/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_Palette;
import org.lwjgl.sdl.SDL_Rect;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLSurface {
    public static final int SDL_SURFACE_PREALLOCATED = 1;
    public static final int SDL_SURFACE_LOCK_NEEDED = 2;
    public static final int SDL_SURFACE_LOCKED = 4;
    public static final int SDL_SURFACE_SIMD_ALIGNED = 8;
    public static final int SDL_SCALEMODE_INVALID = -1;
    public static final int SDL_SCALEMODE_NEAREST = 0;
    public static final int SDL_SCALEMODE_LINEAR = 1;
    public static final int SDL_SCALEMODE_PIXELART = 2;
    public static final int SDL_FLIP_NONE = 0;
    public static final int SDL_FLIP_HORIZONTAL = 1;
    public static final int SDL_FLIP_VERTICAL = 2;
    public static final int SDL_FLIP_HORIZONTAL_AND_VERTICAL = 3;
    public static final String SDL_PROP_SURFACE_SDR_WHITE_POINT_FLOAT = "SDL.surface.SDR_white_point";
    public static final String SDL_PROP_SURFACE_HDR_HEADROOM_FLOAT = "SDL.surface.HDR_headroom";
    public static final String SDL_PROP_SURFACE_TONEMAP_OPERATOR_STRING = "SDL.surface.tonemap";
    public static final String SDL_PROP_SURFACE_HOTSPOT_X_NUMBER = "SDL.surface.hotspot.x";
    public static final String SDL_PROP_SURFACE_HOTSPOT_Y_NUMBER = "SDL.surface.hotspot.y";
    public static final String SDL_PROP_SURFACE_ROTATION_FLOAT = "SDL.surface.rotation";

    protected SDLSurface() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_CreateSurface(int width, int height, int format) {
        long __functionAddress = Functions.CreateSurface;
        return JNI.invokeP(width, height, format, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_CreateSurface(int width, int height, @NativeType(value="SDL_PixelFormat") int format) {
        long __result = SDLSurface.nSDL_CreateSurface(width, height, format);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_CreateSurfaceFrom(int width, int height, int format, long pixels, int pitch) {
        long __functionAddress = Functions.CreateSurfaceFrom;
        return JNI.invokePP(width, height, format, pixels, pitch, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_CreateSurfaceFrom(int width, int height, @NativeType(value="SDL_PixelFormat") int format, @NativeType(value="void *") @Nullable ByteBuffer pixels, int pitch) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pixels, height * pitch);
        }
        long __result = SDLSurface.nSDL_CreateSurfaceFrom(width, height, format, MemoryUtil.memAddressSafe(pixels), pitch);
        return SDL_Surface.createSafe(__result);
    }

    public static void nSDL_DestroySurface(long surface) {
        long __functionAddress = Functions.DestroySurface;
        JNI.invokePV(surface, __functionAddress);
    }

    public static void SDL_DestroySurface(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        SDLSurface.nSDL_DestroySurface(surface.address());
    }

    public static int nSDL_GetSurfaceProperties(long surface) {
        long __functionAddress = Functions.GetSurfaceProperties;
        return JNI.invokePI(surface, __functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetSurfaceProperties(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLSurface.nSDL_GetSurfaceProperties(surface.address());
    }

    public static boolean nSDL_SetSurfaceColorspace(long surface, int colorspace) {
        long __functionAddress = Functions.SetSurfaceColorspace;
        return JNI.invokePZ(surface, colorspace, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceColorspace(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_Colorspace") int colorspace) {
        return SDLSurface.nSDL_SetSurfaceColorspace(surface.address(), colorspace);
    }

    public static int nSDL_GetSurfaceColorspace(long surface) {
        long __functionAddress = Functions.GetSurfaceColorspace;
        return JNI.invokePI(surface, __functionAddress);
    }

    @NativeType(value="SDL_Colorspace")
    public static int SDL_GetSurfaceColorspace(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLSurface.nSDL_GetSurfaceColorspace(surface.address());
    }

    public static long nSDL_CreateSurfacePalette(long surface) {
        long __functionAddress = Functions.CreateSurfacePalette;
        return JNI.invokePP(surface, __functionAddress);
    }

    @NativeType(value="SDL_Palette *")
    public static @Nullable SDL_Palette SDL_CreateSurfacePalette(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        long __result = SDLSurface.nSDL_CreateSurfacePalette(surface.address());
        return SDL_Palette.createSafe(__result);
    }

    public static boolean nSDL_SetSurfacePalette(long surface, long palette) {
        long __functionAddress = Functions.SetSurfacePalette;
        return JNI.invokePPZ(surface, palette, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfacePalette(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_Palette *") @Nullable SDL_Palette palette) {
        return SDLSurface.nSDL_SetSurfacePalette(surface.address(), MemoryUtil.memAddressSafe(palette));
    }

    public static long nSDL_GetSurfacePalette(long surface) {
        long __functionAddress = Functions.GetSurfacePalette;
        return JNI.invokePP(surface, __functionAddress);
    }

    @NativeType(value="SDL_Palette *")
    public static @Nullable SDL_Palette SDL_GetSurfacePalette(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        long __result = SDLSurface.nSDL_GetSurfacePalette(surface.address());
        return SDL_Palette.createSafe(__result);
    }

    public static boolean nSDL_AddSurfaceAlternateImage(long surface, long image) {
        long __functionAddress = Functions.AddSurfaceAlternateImage;
        return JNI.invokePPZ(surface, image, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_AddSurfaceAlternateImage(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_Surface *") SDL_Surface image) {
        return SDLSurface.nSDL_AddSurfaceAlternateImage(surface.address(), image.address());
    }

    public static boolean nSDL_SurfaceHasAlternateImages(long surface) {
        long __functionAddress = Functions.SurfaceHasAlternateImages;
        return JNI.invokePZ(surface, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SurfaceHasAlternateImages(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLSurface.nSDL_SurfaceHasAlternateImages(surface.address());
    }

    public static long nSDL_GetSurfaceImages(long surface, long count) {
        long __functionAddress = Functions.GetSurfaceImages;
        return JNI.invokePPP(surface, count, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Surface **")
    public static @Nullable PointerBuffer SDL_GetSurfaceImages(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLSurface.nSDL_GetSurfaceImages(surface.address(), MemoryUtil.memAddress(count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_RemoveSurfaceAlternateImages(long surface) {
        long __functionAddress = Functions.RemoveSurfaceAlternateImages;
        JNI.invokePV(surface, __functionAddress);
    }

    public static void SDL_RemoveSurfaceAlternateImages(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        SDLSurface.nSDL_RemoveSurfaceAlternateImages(surface.address());
    }

    public static boolean nSDL_LockSurface(long surface) {
        long __functionAddress = Functions.LockSurface;
        return JNI.invokePZ(surface, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LockSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLSurface.nSDL_LockSurface(surface.address());
    }

    public static void nSDL_UnlockSurface(long surface) {
        long __functionAddress = Functions.UnlockSurface;
        JNI.invokePV(surface, __functionAddress);
    }

    public static void SDL_UnlockSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        SDLSurface.nSDL_UnlockSurface(surface.address());
    }

    public static long nSDL_LoadSurface_IO(long src, boolean closeio) {
        long __functionAddress = Functions.LoadSurface_IO;
        if (Checks.CHECKS) {
            Checks.check(src);
        }
        return JNI.invokePP(src, closeio, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadSurface_IO(@NativeType(value="SDL_IOStream *") long src, @NativeType(value="bool") boolean closeio) {
        long __result = SDLSurface.nSDL_LoadSurface_IO(src, closeio);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_LoadSurface(long file) {
        long __functionAddress = Functions.LoadSurface;
        return JNI.invokePP(file, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadSurface(@NativeType(value="char const *") ByteBuffer file) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
        }
        long __result = SDLSurface.nSDL_LoadSurface(MemoryUtil.memAddress(file));
        return SDL_Surface.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadSurface(@NativeType(value="char const *") CharSequence file) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            long __result = SDLSurface.nSDL_LoadSurface(fileEncoded);
            SDL_Surface sDL_Surface = SDL_Surface.createSafe(__result);
            return sDL_Surface;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_LoadBMP_IO(long src, boolean closeio) {
        long __functionAddress = Functions.LoadBMP_IO;
        if (Checks.CHECKS) {
            Checks.check(src);
        }
        return JNI.invokePP(src, closeio, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadBMP_IO(@NativeType(value="SDL_IOStream *") long src, @NativeType(value="bool") boolean closeio) {
        long __result = SDLSurface.nSDL_LoadBMP_IO(src, closeio);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_LoadBMP(long file) {
        long __functionAddress = Functions.LoadBMP;
        return JNI.invokePP(file, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadBMP(@NativeType(value="char const *") ByteBuffer file) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
        }
        long __result = SDLSurface.nSDL_LoadBMP(MemoryUtil.memAddress(file));
        return SDL_Surface.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadBMP(@NativeType(value="char const *") CharSequence file) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            long __result = SDLSurface.nSDL_LoadBMP(fileEncoded);
            SDL_Surface sDL_Surface = SDL_Surface.createSafe(__result);
            return sDL_Surface;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SaveBMP_IO(long surface, long dst, boolean closeio) {
        long __functionAddress = Functions.SaveBMP_IO;
        if (Checks.CHECKS) {
            Checks.check(dst);
        }
        return JNI.invokePPZ(surface, dst, closeio, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SaveBMP_IO(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_IOStream *") long dst, @NativeType(value="bool") boolean closeio) {
        return SDLSurface.nSDL_SaveBMP_IO(surface.address(), dst, closeio);
    }

    public static boolean nSDL_SaveBMP(long surface, long file) {
        long __functionAddress = Functions.SaveBMP;
        return JNI.invokePPZ(surface, file, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SaveBMP(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="char const *") ByteBuffer file) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
        }
        return SDLSurface.nSDL_SaveBMP(surface.address(), MemoryUtil.memAddress(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SaveBMP(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="char const *") CharSequence file) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            boolean bl = SDLSurface.nSDL_SaveBMP(surface.address(), fileEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_LoadPNG_IO(long src, boolean closeio) {
        long __functionAddress = Functions.LoadPNG_IO;
        if (Checks.CHECKS) {
            Checks.check(src);
        }
        return JNI.invokePP(src, closeio, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadPNG_IO(@NativeType(value="SDL_IOStream *") long src, @NativeType(value="bool") boolean closeio) {
        long __result = SDLSurface.nSDL_LoadPNG_IO(src, closeio);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_LoadPNG(long file) {
        long __functionAddress = Functions.LoadPNG;
        return JNI.invokePP(file, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadPNG(@NativeType(value="char const *") ByteBuffer file) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
        }
        long __result = SDLSurface.nSDL_LoadPNG(MemoryUtil.memAddress(file));
        return SDL_Surface.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_LoadPNG(@NativeType(value="char const *") CharSequence file) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            long __result = SDLSurface.nSDL_LoadPNG(fileEncoded);
            SDL_Surface sDL_Surface = SDL_Surface.createSafe(__result);
            return sDL_Surface;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SavePNG_IO(long surface, long dst, boolean closeio) {
        long __functionAddress = Functions.SavePNG_IO;
        if (Checks.CHECKS) {
            Checks.check(dst);
        }
        return JNI.invokePPZ(surface, dst, closeio, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SavePNG_IO(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_IOStream *") long dst, @NativeType(value="bool") boolean closeio) {
        return SDLSurface.nSDL_SavePNG_IO(surface.address(), dst, closeio);
    }

    public static boolean nSDL_SavePNG(long surface, long file) {
        long __functionAddress = Functions.SavePNG;
        return JNI.invokePPZ(surface, file, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SavePNG(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="char const *") ByteBuffer file) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
        }
        return SDLSurface.nSDL_SavePNG(surface.address(), MemoryUtil.memAddress(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SavePNG(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="char const *") CharSequence file) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            boolean bl = SDLSurface.nSDL_SavePNG(surface.address(), fileEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetSurfaceRLE(long surface, boolean enabled) {
        long __functionAddress = Functions.SetSurfaceRLE;
        return JNI.invokePZ(surface, enabled, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceRLE(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="bool") boolean enabled) {
        return SDLSurface.nSDL_SetSurfaceRLE(surface.address(), enabled);
    }

    public static boolean nSDL_SurfaceHasRLE(long surface) {
        long __functionAddress = Functions.SurfaceHasRLE;
        return JNI.invokePZ(surface, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SurfaceHasRLE(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLSurface.nSDL_SurfaceHasRLE(surface.address());
    }

    public static boolean nSDL_SetSurfaceColorKey(long surface, boolean enabled, int key) {
        long __functionAddress = Functions.SetSurfaceColorKey;
        return JNI.invokePZ(surface, enabled, key, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceColorKey(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="bool") boolean enabled, @NativeType(value="Uint32") int key) {
        return SDLSurface.nSDL_SetSurfaceColorKey(surface.address(), enabled, key);
    }

    public static boolean nSDL_SurfaceHasColorKey(long surface) {
        long __functionAddress = Functions.SurfaceHasColorKey;
        return JNI.invokePZ(surface, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SurfaceHasColorKey(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLSurface.nSDL_SurfaceHasColorKey(surface.address());
    }

    public static boolean nSDL_GetSurfaceColorKey(long surface, long key) {
        long __functionAddress = Functions.GetSurfaceColorKey;
        return JNI.invokePPZ(surface, key, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetSurfaceColorKey(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint32 *") @Nullable IntBuffer key) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)key, 1);
        }
        return SDLSurface.nSDL_GetSurfaceColorKey(surface.address(), MemoryUtil.memAddressSafe(key));
    }

    public static boolean nSDL_SetSurfaceColorMod(long surface, byte r, byte g, byte b) {
        long __functionAddress = Functions.SetSurfaceColorMod;
        return JNI.invokePUUUZ(surface, r, g, b, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceColorMod(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b) {
        return SDLSurface.nSDL_SetSurfaceColorMod(surface.address(), r, g, b);
    }

    public static boolean nSDL_GetSurfaceColorMod(long surface, long r, long g, long b) {
        long __functionAddress = Functions.GetSurfaceColorMod;
        return JNI.invokePPPPZ(surface, r, g, b, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetSurfaceColorMod(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint8 *") @Nullable ByteBuffer r, @NativeType(value="Uint8 *") @Nullable ByteBuffer g, @NativeType(value="Uint8 *") @Nullable ByteBuffer b) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, 1);
            Checks.checkSafe((Buffer)g, 1);
            Checks.checkSafe((Buffer)b, 1);
        }
        return SDLSurface.nSDL_GetSurfaceColorMod(surface.address(), MemoryUtil.memAddressSafe(r), MemoryUtil.memAddressSafe(g), MemoryUtil.memAddressSafe(b));
    }

    public static boolean nSDL_SetSurfaceAlphaMod(long surface, byte alpha) {
        long __functionAddress = Functions.SetSurfaceAlphaMod;
        return JNI.invokePUZ(surface, alpha, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceAlphaMod(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint8") byte alpha) {
        return SDLSurface.nSDL_SetSurfaceAlphaMod(surface.address(), alpha);
    }

    public static boolean nSDL_GetSurfaceAlphaMod(long surface, long alpha) {
        long __functionAddress = Functions.GetSurfaceAlphaMod;
        return JNI.invokePPZ(surface, alpha, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetSurfaceAlphaMod(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint8 *") @Nullable ByteBuffer alpha) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)alpha, 1);
        }
        return SDLSurface.nSDL_GetSurfaceAlphaMod(surface.address(), MemoryUtil.memAddressSafe(alpha));
    }

    public static boolean nSDL_SetSurfaceBlendMode(long surface, int blendMode) {
        long __functionAddress = Functions.SetSurfaceBlendMode;
        return JNI.invokePZ(surface, blendMode, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceBlendMode(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_BlendMode") int blendMode) {
        return SDLSurface.nSDL_SetSurfaceBlendMode(surface.address(), blendMode);
    }

    public static boolean nSDL_GetSurfaceBlendMode(long surface, long blendMode) {
        long __functionAddress = Functions.GetSurfaceBlendMode;
        return JNI.invokePPZ(surface, blendMode, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetSurfaceBlendMode(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_BlendMode *") @Nullable IntBuffer blendMode) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)blendMode, 1);
        }
        return SDLSurface.nSDL_GetSurfaceBlendMode(surface.address(), MemoryUtil.memAddressSafe(blendMode));
    }

    public static boolean nSDL_SetSurfaceClipRect(long surface, long rect) {
        long __functionAddress = Functions.SetSurfaceClipRect;
        return JNI.invokePPZ(surface, rect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetSurfaceClipRect(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_Rect const *") SDL_Rect rect) {
        return SDLSurface.nSDL_SetSurfaceClipRect(surface.address(), rect.address());
    }

    public static boolean nSDL_GetSurfaceClipRect(long surface, long rect) {
        long __functionAddress = Functions.GetSurfaceClipRect;
        return JNI.invokePPZ(surface, rect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetSurfaceClipRect(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLSurface.nSDL_GetSurfaceClipRect(surface.address(), rect.address());
    }

    public static boolean nSDL_FlipSurface(long surface, int flip) {
        long __functionAddress = Functions.FlipSurface;
        return JNI.invokePZ(surface, flip, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_FlipSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_FlipMode") int flip) {
        return SDLSurface.nSDL_FlipSurface(surface.address(), flip);
    }

    public static long nSDL_RotateSurface(long surface, float angle) {
        long __functionAddress = Functions.RotateSurface;
        return JNI.invokePP(surface, angle, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_RotateSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface, float angle) {
        long __result = SDLSurface.nSDL_RotateSurface(surface.address(), angle);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_DuplicateSurface(long surface) {
        long __functionAddress = Functions.DuplicateSurface;
        return JNI.invokePP(surface, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_DuplicateSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        long __result = SDLSurface.nSDL_DuplicateSurface(surface.address());
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_ScaleSurface(long surface, int width, int height, int scaleMode) {
        long __functionAddress = Functions.ScaleSurface;
        return JNI.invokePP(surface, width, height, scaleMode, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_ScaleSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface, int width, int height, @NativeType(value="SDL_ScaleMode") int scaleMode) {
        long __result = SDLSurface.nSDL_ScaleSurface(surface.address(), width, height, scaleMode);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_ConvertSurface(long surface, int format) {
        long __functionAddress = Functions.ConvertSurface;
        return JNI.invokePP(surface, format, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_ConvertSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_PixelFormat") int format) {
        long __result = SDLSurface.nSDL_ConvertSurface(surface.address(), format);
        return SDL_Surface.createSafe(__result);
    }

    public static long nSDL_ConvertSurfaceAndColorspace(long surface, int format, long palette, int colorspace, int props) {
        long __functionAddress = Functions.ConvertSurfaceAndColorspace;
        return JNI.invokePPP(surface, format, palette, colorspace, props, __functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_ConvertSurfaceAndColorspace(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="SDL_PixelFormat") int format, @NativeType(value="SDL_Palette *") @Nullable SDL_Palette palette, @NativeType(value="SDL_Colorspace") int colorspace, @NativeType(value="SDL_PropertiesID") int props) {
        long __result = SDLSurface.nSDL_ConvertSurfaceAndColorspace(surface.address(), format, MemoryUtil.memAddressSafe(palette), colorspace, props);
        return SDL_Surface.createSafe(__result);
    }

    public static boolean nSDL_ConvertPixels(int width, int height, int src_format, long src, int src_pitch, int dst_format, long dst, int dst_pitch) {
        long __functionAddress = Functions.ConvertPixels;
        return JNI.invokePPZ(width, height, src_format, src, src_pitch, dst_format, dst, dst_pitch, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ConvertPixels(int width, int height, @NativeType(value="SDL_PixelFormat") int src_format, @NativeType(value="void const *") ByteBuffer src, int src_pitch, @NativeType(value="SDL_PixelFormat") int dst_format, @NativeType(value="void *") ByteBuffer dst, int dst_pitch) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, height * src_pitch);
            Checks.check((Buffer)dst, height * dst_pitch);
        }
        return SDLSurface.nSDL_ConvertPixels(width, height, src_format, MemoryUtil.memAddress(src), src_pitch, dst_format, MemoryUtil.memAddress(dst), dst_pitch);
    }

    public static boolean nSDL_ConvertPixelsAndColorspace(int width, int height, int src_format, int src_colorspace, int src_properties, long src, int src_pitch, int dst_format, int dst_colorspace, int dst_properties, long dst, int dst_pitch) {
        long __functionAddress = Functions.ConvertPixelsAndColorspace;
        return JNI.invokePPZ(width, height, src_format, src_colorspace, src_properties, src, src_pitch, dst_format, dst_colorspace, dst_properties, dst, dst_pitch, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ConvertPixelsAndColorspace(int width, int height, @NativeType(value="SDL_PixelFormat") int src_format, @NativeType(value="SDL_Colorspace") int src_colorspace, @NativeType(value="SDL_PropertiesID") int src_properties, @NativeType(value="void const *") ByteBuffer src, int src_pitch, @NativeType(value="SDL_PixelFormat") int dst_format, @NativeType(value="SDL_Colorspace") int dst_colorspace, @NativeType(value="SDL_PropertiesID") int dst_properties, @NativeType(value="void *") ByteBuffer dst, int dst_pitch) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, height * src_pitch);
            Checks.check((Buffer)dst, height * dst_pitch);
        }
        return SDLSurface.nSDL_ConvertPixelsAndColorspace(width, height, src_format, src_colorspace, src_properties, MemoryUtil.memAddress(src), src_pitch, dst_format, dst_colorspace, dst_properties, MemoryUtil.memAddress(dst), dst_pitch);
    }

    public static boolean nSDL_PremultiplyAlpha(int width, int height, int src_format, long src, int src_pitch, int dst_format, long dst, int dst_pitch, boolean linear) {
        long __functionAddress = Functions.PremultiplyAlpha;
        return JNI.invokePPZ(width, height, src_format, src, src_pitch, dst_format, dst, dst_pitch, linear, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PremultiplyAlpha(int width, int height, @NativeType(value="SDL_PixelFormat") int src_format, @NativeType(value="void const *") ByteBuffer src, int src_pitch, @NativeType(value="SDL_PixelFormat") int dst_format, @NativeType(value="void *") ByteBuffer dst, int dst_pitch, @NativeType(value="bool") boolean linear) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, height * src_pitch);
            Checks.check((Buffer)dst, height * dst_pitch);
        }
        return SDLSurface.nSDL_PremultiplyAlpha(width, height, src_format, MemoryUtil.memAddress(src), src_pitch, dst_format, MemoryUtil.memAddress(dst), dst_pitch, linear);
    }

    public static boolean nSDL_PremultiplySurfaceAlpha(long surface, boolean linear) {
        long __functionAddress = Functions.PremultiplySurfaceAlpha;
        return JNI.invokePZ(surface, linear, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PremultiplySurfaceAlpha(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="bool") boolean linear) {
        return SDLSurface.nSDL_PremultiplySurfaceAlpha(surface.address(), linear);
    }

    public static boolean nSDL_ClearSurface(long surface, float r, float g, float b, float a) {
        long __functionAddress = Functions.ClearSurface;
        return JNI.invokePZ(surface, r, g, b, a, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ClearSurface(@NativeType(value="SDL_Surface *") SDL_Surface surface, float r, float g, float b, float a) {
        return SDLSurface.nSDL_ClearSurface(surface.address(), r, g, b, a);
    }

    public static boolean nSDL_FillSurfaceRect(long dst, long rect, int color) {
        long __functionAddress = Functions.FillSurfaceRect;
        return JNI.invokePPZ(dst, rect, color, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_FillSurfaceRect(@NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect, @NativeType(value="Uint32") int color) {
        return SDLSurface.nSDL_FillSurfaceRect(dst.address(), MemoryUtil.memAddressSafe(rect), color);
    }

    public static boolean nSDL_FillSurfaceRects(long dst, long rects, int count, int color) {
        long __functionAddress = Functions.FillSurfaceRects;
        return JNI.invokePPZ(dst, rects, count, color, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_FillSurfaceRects(@NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") SDL_Rect.Buffer rects, @NativeType(value="Uint32") int color) {
        return SDLSurface.nSDL_FillSurfaceRects(dst.address(), rects.address(), rects.remaining(), color);
    }

    public static boolean nSDL_BlitSurface(long src, long srcrect, long dst, long dstrect) {
        long __functionAddress = Functions.BlitSurface;
        return JNI.invokePPPPZ(src, srcrect, dst, dstrect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurface(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect srcrect, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect dstrect) {
        return SDLSurface.nSDL_BlitSurface(src.address(), MemoryUtil.memAddressSafe(srcrect), dst.address(), MemoryUtil.memAddressSafe(dstrect));
    }

    public static boolean nSDL_BlitSurfaceUnchecked(long src, long srcrect, long dst, long dstrect) {
        long __functionAddress = Functions.BlitSurfaceUnchecked;
        return JNI.invokePPPPZ(src, srcrect, dst, dstrect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurfaceUnchecked(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") SDL_Rect srcrect, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") SDL_Rect dstrect) {
        return SDLSurface.nSDL_BlitSurfaceUnchecked(src.address(), srcrect.address(), dst.address(), dstrect.address());
    }

    public static boolean nSDL_BlitSurfaceScaled(long src, long srcrect, long dst, long dstrect, int scaleMode) {
        long __functionAddress = Functions.BlitSurfaceScaled;
        return JNI.invokePPPPZ(src, srcrect, dst, dstrect, scaleMode, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurfaceScaled(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect srcrect, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect dstrect, @NativeType(value="SDL_ScaleMode") int scaleMode) {
        return SDLSurface.nSDL_BlitSurfaceScaled(src.address(), MemoryUtil.memAddressSafe(srcrect), dst.address(), MemoryUtil.memAddressSafe(dstrect), scaleMode);
    }

    public static boolean nSDL_BlitSurfaceUncheckedScaled(long src, long srcrect, long dst, long dstrect, int scaleMode) {
        long __functionAddress = Functions.BlitSurfaceUncheckedScaled;
        return JNI.invokePPPPZ(src, srcrect, dst, dstrect, scaleMode, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurfaceUncheckedScaled(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") SDL_Rect srcrect, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") SDL_Rect dstrect, @NativeType(value="SDL_ScaleMode") int scaleMode) {
        return SDLSurface.nSDL_BlitSurfaceUncheckedScaled(src.address(), srcrect.address(), dst.address(), dstrect.address(), scaleMode);
    }

    public static boolean nSDL_StretchSurface(long src, long srcrect, long dst, long dstrect, int scaleMode) {
        long __functionAddress = Functions.StretchSurface;
        return JNI.invokePPPPZ(src, srcrect, dst, dstrect, scaleMode, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StretchSurface(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect srcrect, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect dstrect, @NativeType(value="SDL_ScaleMode") int scaleMode) {
        return SDLSurface.nSDL_StretchSurface(src.address(), MemoryUtil.memAddressSafe(srcrect), dst.address(), MemoryUtil.memAddressSafe(dstrect), scaleMode);
    }

    public static boolean nSDL_BlitSurfaceTiled(long src, long srcrect, long dst, long dstrect) {
        long __functionAddress = Functions.BlitSurfaceTiled;
        return JNI.invokePPPPZ(src, srcrect, dst, dstrect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurfaceTiled(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect srcrect, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect dstrect) {
        return SDLSurface.nSDL_BlitSurfaceTiled(src.address(), MemoryUtil.memAddressSafe(srcrect), dst.address(), MemoryUtil.memAddressSafe(dstrect));
    }

    public static boolean nSDL_BlitSurfaceTiledWithScale(long src, long srcrect, float scale, int scaleMode, long dst, long dstrect) {
        long __functionAddress = Functions.BlitSurfaceTiledWithScale;
        return JNI.invokePPPPZ(src, srcrect, scale, scaleMode, dst, dstrect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurfaceTiledWithScale(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect srcrect, float scale, @NativeType(value="SDL_ScaleMode") int scaleMode, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect dstrect) {
        return SDLSurface.nSDL_BlitSurfaceTiledWithScale(src.address(), MemoryUtil.memAddressSafe(srcrect), scale, scaleMode, dst.address(), MemoryUtil.memAddressSafe(dstrect));
    }

    public static boolean nSDL_BlitSurface9Grid(long src, long srcrect, int left_width, int right_width, int top_height, int bottom_height, float scale, int scaleMode, long dst, long dstrect) {
        long __functionAddress = Functions.BlitSurface9Grid;
        return JNI.invokePPPPZ(src, srcrect, left_width, right_width, top_height, bottom_height, scale, scaleMode, dst, dstrect, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BlitSurface9Grid(@NativeType(value="SDL_Surface *") SDL_Surface src, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect srcrect, int left_width, int right_width, int top_height, int bottom_height, float scale, @NativeType(value="SDL_ScaleMode") int scaleMode, @NativeType(value="SDL_Surface *") SDL_Surface dst, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect dstrect) {
        return SDLSurface.nSDL_BlitSurface9Grid(src.address(), MemoryUtil.memAddressSafe(srcrect), left_width, right_width, top_height, bottom_height, scale, scaleMode, dst.address(), MemoryUtil.memAddressSafe(dstrect));
    }

    public static int nSDL_MapSurfaceRGB(long surface, byte r, byte g, byte b) {
        long __functionAddress = Functions.MapSurfaceRGB;
        return JNI.invokePUUUI(surface, r, g, b, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_MapSurfaceRGB(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b) {
        return SDLSurface.nSDL_MapSurfaceRGB(surface.address(), r, g, b);
    }

    public static int nSDL_MapSurfaceRGBA(long surface, byte r, byte g, byte b, byte a) {
        long __functionAddress = Functions.MapSurfaceRGBA;
        return JNI.invokePUUUUI(surface, r, g, b, a, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_MapSurfaceRGBA(@NativeType(value="SDL_Surface *") SDL_Surface surface, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b, @NativeType(value="Uint8") byte a) {
        return SDLSurface.nSDL_MapSurfaceRGBA(surface.address(), r, g, b, a);
    }

    public static boolean nSDL_ReadSurfacePixel(long surface, int x, int y, long r, long g, long b, long a) {
        long __functionAddress = Functions.ReadSurfacePixel;
        return JNI.invokePPPPPZ(surface, x, y, r, g, b, a, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ReadSurfacePixel(@NativeType(value="SDL_Surface *") SDL_Surface surface, int x, int y, @NativeType(value="Uint8 *") @Nullable ByteBuffer r, @NativeType(value="Uint8 *") @Nullable ByteBuffer g, @NativeType(value="Uint8 *") @Nullable ByteBuffer b, @NativeType(value="Uint8 *") @Nullable ByteBuffer a) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, 1);
            Checks.checkSafe((Buffer)g, 1);
            Checks.checkSafe((Buffer)b, 1);
            Checks.checkSafe((Buffer)a, 1);
        }
        return SDLSurface.nSDL_ReadSurfacePixel(surface.address(), x, y, MemoryUtil.memAddressSafe(r), MemoryUtil.memAddressSafe(g), MemoryUtil.memAddressSafe(b), MemoryUtil.memAddressSafe(a));
    }

    public static boolean nSDL_ReadSurfacePixelFloat(long surface, int x, int y, long r, long g, long b, long a) {
        long __functionAddress = Functions.ReadSurfacePixelFloat;
        return JNI.invokePPPPPZ(surface, x, y, r, g, b, a, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ReadSurfacePixelFloat(@NativeType(value="SDL_Surface *") SDL_Surface surface, int x, int y, @NativeType(value="float *") @Nullable FloatBuffer r, @NativeType(value="float *") @Nullable FloatBuffer g, @NativeType(value="float *") @Nullable FloatBuffer b, @NativeType(value="float *") @Nullable FloatBuffer a) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, 1);
            Checks.checkSafe((Buffer)g, 1);
            Checks.checkSafe((Buffer)b, 1);
            Checks.checkSafe((Buffer)a, 1);
        }
        return SDLSurface.nSDL_ReadSurfacePixelFloat(surface.address(), x, y, MemoryUtil.memAddressSafe(r), MemoryUtil.memAddressSafe(g), MemoryUtil.memAddressSafe(b), MemoryUtil.memAddressSafe(a));
    }

    public static boolean nSDL_WriteSurfacePixel(long surface, int x, int y, byte r, byte g, byte b, byte a) {
        long __functionAddress = Functions.WriteSurfacePixel;
        return JNI.invokePUUUUZ(surface, x, y, r, g, b, a, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WriteSurfacePixel(@NativeType(value="SDL_Surface *") SDL_Surface surface, int x, int y, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b, @NativeType(value="Uint8") byte a) {
        return SDLSurface.nSDL_WriteSurfacePixel(surface.address(), x, y, r, g, b, a);
    }

    public static boolean nSDL_WriteSurfacePixelFloat(long surface, int x, int y, float r, float g, float b, float a) {
        long __functionAddress = Functions.WriteSurfacePixelFloat;
        return JNI.invokePZ(surface, x, y, r, g, b, a, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WriteSurfacePixelFloat(@NativeType(value="SDL_Surface *") SDL_Surface surface, int x, int y, float r, float g, float b, float a) {
        return SDLSurface.nSDL_WriteSurfacePixelFloat(surface.address(), x, y, r, g, b, a);
    }

    @NativeType(value="bool")
    public static boolean SDL_MUSTLOCK(SDL_Surface S) {
        return (S.flags() & 2) == 2;
    }

    public static final class Functions {
        public static final long CreateSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateSurface");
        public static final long CreateSurfaceFrom = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateSurfaceFrom");
        public static final long DestroySurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_DestroySurface");
        public static final long GetSurfaceProperties = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceProperties");
        public static final long SetSurfaceColorspace = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceColorspace");
        public static final long GetSurfaceColorspace = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceColorspace");
        public static final long CreateSurfacePalette = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateSurfacePalette");
        public static final long SetSurfacePalette = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfacePalette");
        public static final long GetSurfacePalette = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfacePalette");
        public static final long AddSurfaceAlternateImage = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_AddSurfaceAlternateImage");
        public static final long SurfaceHasAlternateImages = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SurfaceHasAlternateImages");
        public static final long GetSurfaceImages = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceImages");
        public static final long RemoveSurfaceAlternateImages = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_RemoveSurfaceAlternateImages");
        public static final long LockSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LockSurface");
        public static final long UnlockSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_UnlockSurface");
        public static final long LoadSurface_IO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadSurface_IO");
        public static final long LoadSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadSurface");
        public static final long LoadBMP_IO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadBMP_IO");
        public static final long LoadBMP = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadBMP");
        public static final long SaveBMP_IO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SaveBMP_IO");
        public static final long SaveBMP = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SaveBMP");
        public static final long LoadPNG_IO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadPNG_IO");
        public static final long LoadPNG = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadPNG");
        public static final long SavePNG_IO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SavePNG_IO");
        public static final long SavePNG = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SavePNG");
        public static final long SetSurfaceRLE = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceRLE");
        public static final long SurfaceHasRLE = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SurfaceHasRLE");
        public static final long SetSurfaceColorKey = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceColorKey");
        public static final long SurfaceHasColorKey = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SurfaceHasColorKey");
        public static final long GetSurfaceColorKey = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceColorKey");
        public static final long SetSurfaceColorMod = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceColorMod");
        public static final long GetSurfaceColorMod = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceColorMod");
        public static final long SetSurfaceAlphaMod = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceAlphaMod");
        public static final long GetSurfaceAlphaMod = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceAlphaMod");
        public static final long SetSurfaceBlendMode = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceBlendMode");
        public static final long GetSurfaceBlendMode = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceBlendMode");
        public static final long SetSurfaceClipRect = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetSurfaceClipRect");
        public static final long GetSurfaceClipRect = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSurfaceClipRect");
        public static final long FlipSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_FlipSurface");
        public static final long RotateSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_RotateSurface");
        public static final long DuplicateSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_DuplicateSurface");
        public static final long ScaleSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ScaleSurface");
        public static final long ConvertSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ConvertSurface");
        public static final long ConvertSurfaceAndColorspace = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ConvertSurfaceAndColorspace");
        public static final long ConvertPixels = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ConvertPixels");
        public static final long ConvertPixelsAndColorspace = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ConvertPixelsAndColorspace");
        public static final long PremultiplyAlpha = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_PremultiplyAlpha");
        public static final long PremultiplySurfaceAlpha = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_PremultiplySurfaceAlpha");
        public static final long ClearSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ClearSurface");
        public static final long FillSurfaceRect = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_FillSurfaceRect");
        public static final long FillSurfaceRects = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_FillSurfaceRects");
        public static final long BlitSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurface");
        public static final long BlitSurfaceUnchecked = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurfaceUnchecked");
        public static final long BlitSurfaceScaled = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurfaceScaled");
        public static final long BlitSurfaceUncheckedScaled = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurfaceUncheckedScaled");
        public static final long StretchSurface = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_StretchSurface");
        public static final long BlitSurfaceTiled = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurfaceTiled");
        public static final long BlitSurfaceTiledWithScale = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurfaceTiledWithScale");
        public static final long BlitSurface9Grid = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_BlitSurface9Grid");
        public static final long MapSurfaceRGB = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_MapSurfaceRGB");
        public static final long MapSurfaceRGBA = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_MapSurfaceRGBA");
        public static final long ReadSurfacePixel = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ReadSurfacePixel");
        public static final long ReadSurfacePixelFloat = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ReadSurfacePixelFloat");
        public static final long WriteSurfacePixel = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_WriteSurfacePixel");
        public static final long WriteSurfacePixelFloat = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_WriteSurfacePixelFloat");

        private Functions() {
        }
    }
}

