/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_CompareCallbackI;
import org.lwjgl.sdl.SDL_CompareCallback_rI;
import org.lwjgl.sdl.SDL_calloc_funcI;
import org.lwjgl.sdl.SDL_free_funcI;
import org.lwjgl.sdl.SDL_malloc_funcI;
import org.lwjgl.sdl.SDL_realloc_funcI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLStdinc {
    public static final float SDL_FLT_EPSILON = 1.1920929E-7f;
    public static final int SDL_INVALID_UNICODE_CODEPOINT = 65533;

    protected SDLStdinc() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_malloc(long size) {
        long __functionAddress = Functions.malloc;
        return JNI.invokePP(size, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_malloc(@NativeType(value="size_t") long size) {
        long __result = SDLStdinc.nSDL_malloc(size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static long nSDL_calloc(long nmemb, long size) {
        long __functionAddress = Functions.calloc;
        return JNI.invokePPP(nmemb, size, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_calloc(@NativeType(value="size_t") long nmemb, @NativeType(value="size_t") long size) {
        long __result = SDLStdinc.nSDL_calloc(nmemb, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)nmemb * (int)size);
    }

    public static long nSDL_realloc(long mem, long size) {
        long __functionAddress = Functions.realloc;
        return JNI.invokePPP(mem, size, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_realloc(@NativeType(value="void *") @Nullable ByteBuffer mem, @NativeType(value="size_t") long size) {
        long __result = SDLStdinc.nSDL_realloc(MemoryUtil.memAddressSafe(mem), size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static void nSDL_free(long mem) {
        long __functionAddress = Functions.free;
        JNI.invokePV(mem, __functionAddress);
    }

    public static void SDL_free(@NativeType(value="void *") @Nullable ByteBuffer mem) {
        SDLStdinc.nSDL_free(MemoryUtil.memAddressSafe(mem));
    }

    public static void SDL_free(@NativeType(value="void *") @Nullable IntBuffer mem) {
        SDLStdinc.nSDL_free(MemoryUtil.memAddressSafe(mem));
    }

    public static void SDL_free(@NativeType(value="void *") @Nullable LongBuffer mem) {
        SDLStdinc.nSDL_free(MemoryUtil.memAddressSafe(mem));
    }

    public static void SDL_free(@NativeType(value="void *") @Nullable PointerBuffer mem) {
        SDLStdinc.nSDL_free(MemoryUtil.memAddressSafe(mem));
    }

    public static void nSDL_GetOriginalMemoryFunctions(long malloc_func, long calloc_func, long realloc_func, long free_func) {
        long __functionAddress = Functions.GetOriginalMemoryFunctions;
        JNI.invokePPPPV(malloc_func, calloc_func, realloc_func, free_func, __functionAddress);
    }

    public static void SDL_GetOriginalMemoryFunctions(@NativeType(value="SDL_malloc_func *") @Nullable PointerBuffer malloc_func, @NativeType(value="SDL_calloc_func *") @Nullable PointerBuffer calloc_func, @NativeType(value="SDL_realloc_func *") @Nullable PointerBuffer realloc_func, @NativeType(value="SDL_free_func *") @Nullable PointerBuffer free_func) {
        if (Checks.CHECKS) {
            Checks.checkSafe(malloc_func, 1);
            Checks.checkSafe(calloc_func, 1);
            Checks.checkSafe(realloc_func, 1);
            Checks.checkSafe(free_func, 1);
        }
        SDLStdinc.nSDL_GetOriginalMemoryFunctions(MemoryUtil.memAddressSafe(malloc_func), MemoryUtil.memAddressSafe(calloc_func), MemoryUtil.memAddressSafe(realloc_func), MemoryUtil.memAddressSafe(free_func));
    }

    public static void nSDL_GetMemoryFunctions(long malloc_func, long calloc_func, long realloc_func, long free_func) {
        long __functionAddress = Functions.GetMemoryFunctions;
        JNI.invokePPPPV(malloc_func, calloc_func, realloc_func, free_func, __functionAddress);
    }

    public static void SDL_GetMemoryFunctions(@NativeType(value="SDL_malloc_func *") @Nullable PointerBuffer malloc_func, @NativeType(value="SDL_calloc_func *") @Nullable PointerBuffer calloc_func, @NativeType(value="SDL_realloc_func *") @Nullable PointerBuffer realloc_func, @NativeType(value="SDL_free_func *") @Nullable PointerBuffer free_func) {
        if (Checks.CHECKS) {
            Checks.checkSafe(malloc_func, 1);
            Checks.checkSafe(calloc_func, 1);
            Checks.checkSafe(realloc_func, 1);
            Checks.checkSafe(free_func, 1);
        }
        SDLStdinc.nSDL_GetMemoryFunctions(MemoryUtil.memAddressSafe(malloc_func), MemoryUtil.memAddressSafe(calloc_func), MemoryUtil.memAddressSafe(realloc_func), MemoryUtil.memAddressSafe(free_func));
    }

    public static boolean nSDL_SetMemoryFunctions(long malloc_func, long calloc_func, long realloc_func, long free_func) {
        long __functionAddress = Functions.SetMemoryFunctions;
        return JNI.invokePPPPZ(malloc_func, calloc_func, realloc_func, free_func, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetMemoryFunctions(@NativeType(value="SDL_malloc_func") SDL_malloc_funcI malloc_func, @NativeType(value="SDL_calloc_func") SDL_calloc_funcI calloc_func, @NativeType(value="SDL_realloc_func") SDL_realloc_funcI realloc_func, @NativeType(value="SDL_free_func") SDL_free_funcI free_func) {
        return SDLStdinc.nSDL_SetMemoryFunctions(malloc_func.address(), calloc_func.address(), realloc_func.address(), free_func.address());
    }

    public static long nSDL_aligned_alloc(long alignment, long size) {
        long __functionAddress = Functions.aligned_alloc;
        return JNI.invokePPP(alignment, size, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_aligned_alloc(@NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        long __result = SDLStdinc.nSDL_aligned_alloc(alignment, size);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static void nSDL_aligned_free(long mem) {
        long __functionAddress = Functions.aligned_free;
        JNI.invokePV(mem, __functionAddress);
    }

    public static void SDL_aligned_free(@NativeType(value="void *") @Nullable ByteBuffer mem) {
        SDLStdinc.nSDL_aligned_free(MemoryUtil.memAddressSafe(mem));
    }

    public static int SDL_GetNumAllocations() {
        long __functionAddress = Functions.GetNumAllocations;
        return JNI.invokeI(__functionAddress);
    }

    @NativeType(value="SDL_Environment *")
    public static long SDL_GetEnvironment() {
        long __functionAddress = Functions.GetEnvironment;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="SDL_Environment *")
    public static long SDL_CreateEnvironment(@NativeType(value="bool") boolean populated) {
        long __functionAddress = Functions.CreateEnvironment;
        return JNI.invokeP(populated, __functionAddress);
    }

    public static long nSDL_GetEnvironmentVariable(long env, long name) {
        long __functionAddress = Functions.GetEnvironmentVariable;
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return JNI.invokePPP(env, name, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetEnvironmentVariable(@NativeType(value="SDL_Environment *") long env, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        long __result = SDLStdinc.nSDL_GetEnvironmentVariable(env, MemoryUtil.memAddress(name));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable String SDL_GetEnvironmentVariable(@NativeType(value="SDL_Environment *") long env, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            long __result = SDLStdinc.nSDL_GetEnvironmentVariable(env, nameEncoded);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void *")
    public static long SDL_GetEnvironmentVariables(@NativeType(value="SDL_Environment *") long env) {
        long __functionAddress = Functions.GetEnvironmentVariables;
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return JNI.invokePP(env, __functionAddress);
    }

    public static boolean nSDL_SetEnvironmentVariable(long env, long name, long value, boolean overwrite) {
        long __functionAddress = Functions.SetEnvironmentVariable;
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return JNI.invokePPPZ(env, name, value, overwrite, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetEnvironmentVariable(@NativeType(value="SDL_Environment *") long env, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") ByteBuffer value, @NativeType(value="bool") boolean overwrite) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkNT1(value);
        }
        return SDLStdinc.nSDL_SetEnvironmentVariable(env, MemoryUtil.memAddress(name), MemoryUtil.memAddress(value), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetEnvironmentVariable(@NativeType(value="SDL_Environment *") long env, @NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") CharSequence value, @NativeType(value="bool") boolean overwrite) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            stack.nUTF8(value, true);
            long valueEncoded = stack.getPointerAddress();
            boolean bl = SDLStdinc.nSDL_SetEnvironmentVariable(env, nameEncoded, valueEncoded, overwrite);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_UnsetEnvironmentVariable(long env, long name) {
        long __functionAddress = Functions.UnsetEnvironmentVariable;
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return JNI.invokePPZ(env, name, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UnsetEnvironmentVariable(@NativeType(value="SDL_Environment *") long env, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return SDLStdinc.nSDL_UnsetEnvironmentVariable(env, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_UnsetEnvironmentVariable(@NativeType(value="SDL_Environment *") long env, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLStdinc.nSDL_UnsetEnvironmentVariable(env, nameEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_DestroyEnvironment(@NativeType(value="SDL_Environment *") long env) {
        long __functionAddress = Functions.DestroyEnvironment;
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        JNI.invokePV(env, __functionAddress);
    }

    public static long nSDL_getenv(long name) {
        long __functionAddress = Functions.getenv;
        return JNI.invokePP(name, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_getenv(@NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        long __result = SDLStdinc.nSDL_getenv(MemoryUtil.memAddress(name));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable String SDL_getenv(@NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            long __result = SDLStdinc.nSDL_getenv(nameEncoded);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_getenv_unsafe(long name) {
        long __functionAddress = Functions.getenv_unsafe;
        return JNI.invokePP(name, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_getenv_unsafe(@NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        long __result = SDLStdinc.nSDL_getenv_unsafe(MemoryUtil.memAddress(name));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable String SDL_getenv_unsafe(@NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            long __result = SDLStdinc.nSDL_getenv_unsafe(nameEncoded);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nSDL_setenv_unsafe(long name, long value, int overwrite) {
        long __functionAddress = Functions.setenv_unsafe;
        return JNI.invokePPI(name, value, overwrite, __functionAddress);
    }

    public static int SDL_setenv_unsafe(@NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") ByteBuffer value, int overwrite) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkNT1(value);
        }
        return SDLStdinc.nSDL_setenv_unsafe(MemoryUtil.memAddress(name), MemoryUtil.memAddress(value), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SDL_setenv_unsafe(@NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") CharSequence value, int overwrite) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            stack.nUTF8(value, true);
            long valueEncoded = stack.getPointerAddress();
            int n = SDLStdinc.nSDL_setenv_unsafe(nameEncoded, valueEncoded, overwrite);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nSDL_unsetenv_unsafe(long name) {
        long __functionAddress = Functions.unsetenv_unsafe;
        return JNI.invokePI(name, __functionAddress);
    }

    public static int SDL_unsetenv_unsafe(@NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return SDLStdinc.nSDL_unsetenv_unsafe(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SDL_unsetenv_unsafe(@NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = SDLStdinc.nSDL_unsetenv_unsafe(nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_qsort(long base, long nmemb, long size, long compare) {
        long __functionAddress = Functions.qsort;
        JNI.invokePPPPV(base, nmemb, size, compare, __functionAddress);
    }

    public static void SDL_qsort(@NativeType(value="void *") ByteBuffer base, @NativeType(value="size_t") long nmemb, @NativeType(value="size_t") long size, @NativeType(value="SDL_CompareCallback") SDL_CompareCallbackI compare) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)base, nmemb * size);
        }
        SDLStdinc.nSDL_qsort(MemoryUtil.memAddress(base), nmemb, size, compare.address());
    }

    public static long nSDL_bsearch(long key, long base, long nmemb, long size, long compare) {
        long __functionAddress = Functions.bsearch;
        return JNI.invokePPPPPP(key, base, nmemb, size, compare, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_bsearch(@NativeType(value="void const *") ByteBuffer key, @NativeType(value="void const *") ByteBuffer base, @NativeType(value="size_t") long nmemb, @NativeType(value="size_t") long size, @NativeType(value="SDL_CompareCallback") SDL_CompareCallbackI compare) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)key, size);
            Checks.check((Buffer)base, nmemb * size);
        }
        long __result = SDLStdinc.nSDL_bsearch(MemoryUtil.memAddress(key), MemoryUtil.memAddress(base), nmemb, size, compare.address());
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static void nSDL_qsort_r(long base, long nmemb, long size, long compare, long userdata) {
        long __functionAddress = Functions.qsort_r;
        JNI.invokePPPPPV(base, nmemb, size, compare, userdata, __functionAddress);
    }

    public static void SDL_qsort_r(@NativeType(value="void *") ByteBuffer base, @NativeType(value="size_t") long nmemb, @NativeType(value="size_t") long size, @NativeType(value="SDL_CompareCallback_r") SDL_CompareCallback_rI compare, @NativeType(value="void *") long userdata) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)base, nmemb * size);
        }
        SDLStdinc.nSDL_qsort_r(MemoryUtil.memAddress(base), nmemb, size, compare.address(), userdata);
    }

    public static long nSDL_bsearch_r(long key, long base, long nmemb, long size, long compare, long userdata) {
        long __functionAddress = Functions.bsearch_r;
        return JNI.invokePPPPPPP(key, base, nmemb, size, compare, userdata, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_bsearch_r(@NativeType(value="void const *") ByteBuffer key, @NativeType(value="void const *") ByteBuffer base, @NativeType(value="size_t") long nmemb, @NativeType(value="size_t") long size, @NativeType(value="SDL_CompareCallback_r") SDL_CompareCallback_rI compare, @NativeType(value="void *") long userdata) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)key, size);
            Checks.check((Buffer)base, nmemb * size);
        }
        long __result = SDLStdinc.nSDL_bsearch_r(MemoryUtil.memAddress(key), MemoryUtil.memAddress(base), nmemb, size, compare.address(), userdata);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static short nSDL_crc16(short crc, long data, long len) {
        long __functionAddress = Functions.crc16;
        return JNI.invokeCPPC(crc, data, len, __functionAddress);
    }

    @NativeType(value="Uint16")
    public static short SDL_crc16(@NativeType(value="Uint16") short crc, @NativeType(value="void const *") ByteBuffer data) {
        return SDLStdinc.nSDL_crc16(crc, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int nSDL_crc32(int crc, long data, long len) {
        long __functionAddress = Functions.crc32;
        return JNI.invokePPI(crc, data, len, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_crc32(@NativeType(value="Uint32") int crc, @NativeType(value="void const *") ByteBuffer data) {
        return SDLStdinc.nSDL_crc32(crc, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int nSDL_murmur3_32(long data, long len, int seed) {
        long __functionAddress = Functions.murmur3_32;
        return JNI.invokePPI(data, len, seed, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_murmur3_32(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="Uint32") int seed) {
        return SDLStdinc.nSDL_murmur3_32(MemoryUtil.memAddress(data), data.remaining(), seed);
    }

    public static long nSDL_memset4(long dst, int val, long dwords) {
        long __functionAddress = Functions.memset4;
        return JNI.invokePPP(dst, val, dwords, __functionAddress);
    }

    @NativeType(value="void *")
    public static long SDL_memset4(@NativeType(value="void *") ByteBuffer dst, @NativeType(value="Uint32") int val) {
        return SDLStdinc.nSDL_memset4(MemoryUtil.memAddress(dst), val, Integer.toUnsignedLong(dst.remaining()) >> 2);
    }

    @NativeType(value="void *")
    public static long SDL_memset4(@NativeType(value="void *") IntBuffer dst, @NativeType(value="Uint32") int val) {
        return SDLStdinc.nSDL_memset4(MemoryUtil.memAddress(dst), val, Integer.toUnsignedLong(dst.remaining()));
    }

    public static int nSDL_memcmp(long s1, long s2, long len) {
        long __functionAddress = Functions.memcmp;
        return JNI.invokePPPI(s1, s2, len, __functionAddress);
    }

    public static int SDL_memcmp(@NativeType(value="void const *") ByteBuffer s1, @NativeType(value="void const *") ByteBuffer s2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)s2, s1.remaining());
        }
        return SDLStdinc.nSDL_memcmp(MemoryUtil.memAddress(s1), MemoryUtil.memAddress(s2), s1.remaining());
    }

    public static void SDL_srand(@NativeType(value="Uint64") long seed) {
        long __functionAddress = Functions.srand;
        JNI.invokeJV(seed, __functionAddress);
    }

    @NativeType(value="Sint32")
    public static int SDL_rand(@NativeType(value="Sint32") int n) {
        long __functionAddress = Functions.rand;
        return JNI.invokeI(n, __functionAddress);
    }

    public static float SDL_randf() {
        long __functionAddress = Functions.randf;
        return JNI.invokeF(__functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_rand_bits() {
        long __functionAddress = Functions.rand_bits;
        return JNI.invokeI(__functionAddress);
    }

    public static int nSDL_rand_r(long state, int n) {
        long __functionAddress = Functions.rand_r;
        return JNI.invokePI(state, n, __functionAddress);
    }

    @NativeType(value="Sint32")
    public static int SDL_rand_r(@NativeType(value="Uint64 *") LongBuffer state, @NativeType(value="Sint32") int n) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, 1);
        }
        return SDLStdinc.nSDL_rand_r(MemoryUtil.memAddress(state), n);
    }

    public static float nSDL_randf_r(long state) {
        long __functionAddress = Functions.randf_r;
        return JNI.invokePF(state, __functionAddress);
    }

    public static float SDL_randf_r(@NativeType(value="Uint64 *") LongBuffer state) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, 1);
        }
        return SDLStdinc.nSDL_randf_r(MemoryUtil.memAddress(state));
    }

    public static int nSDL_rand_bits_r(long state) {
        long __functionAddress = Functions.rand_bits_r;
        return JNI.invokePI(state, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_rand_bits_r(@NativeType(value="Uint64 *") LongBuffer state) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, 1);
        }
        return SDLStdinc.nSDL_rand_bits_r(MemoryUtil.memAddress(state));
    }

    @NativeType(value="uint32_t")
    public static int SDL_FOURCC(@NativeType(value="uint8_t") byte A, @NativeType(value="uint8_t") byte B, @NativeType(value="uint8_t") byte C, @NativeType(value="uint8_t") byte D) {
        return (A & 0xFF) << 0 | (B & 0xFF) << 8 | (C & 0xFF) << 16 | (D & 0xFF) << 24;
    }

    public static final class Functions {
        public static final long malloc = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_malloc");
        public static final long calloc = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_calloc");
        public static final long realloc = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_realloc");
        public static final long free = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_free");
        public static final long GetOriginalMemoryFunctions = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetOriginalMemoryFunctions");
        public static final long GetMemoryFunctions = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetMemoryFunctions");
        public static final long SetMemoryFunctions = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetMemoryFunctions");
        public static final long aligned_alloc = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_aligned_alloc");
        public static final long aligned_free = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_aligned_free");
        public static final long GetNumAllocations = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetNumAllocations");
        public static final long GetEnvironment = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetEnvironment");
        public static final long CreateEnvironment = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateEnvironment");
        public static final long GetEnvironmentVariable = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetEnvironmentVariable");
        public static final long GetEnvironmentVariables = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetEnvironmentVariables");
        public static final long SetEnvironmentVariable = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetEnvironmentVariable");
        public static final long UnsetEnvironmentVariable = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_UnsetEnvironmentVariable");
        public static final long DestroyEnvironment = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_DestroyEnvironment");
        public static final long getenv = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_getenv");
        public static final long getenv_unsafe = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_getenv_unsafe");
        public static final long setenv_unsafe = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_setenv_unsafe");
        public static final long unsetenv_unsafe = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_unsetenv_unsafe");
        public static final long qsort = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_qsort");
        public static final long bsearch = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_bsearch");
        public static final long qsort_r = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_qsort_r");
        public static final long bsearch_r = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_bsearch_r");
        public static final long crc16 = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_crc16");
        public static final long crc32 = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_crc32");
        public static final long murmur3_32 = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_murmur3_32");
        public static final long memset4 = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_memset4");
        public static final long memcmp = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_memcmp");
        public static final long srand = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_srand");
        public static final long rand = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_rand");
        public static final long randf = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_randf");
        public static final long rand_bits = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_rand_bits");
        public static final long rand_r = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_rand_r");
        public static final long randf_r = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_randf_r");
        public static final long rand_bits_r = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_rand_bits_r");

        private Functions() {
        }
    }
}

