/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLMisc {
    protected SDLMisc() {
        throw new UnsupportedOperationException();
    }

    public static boolean nSDL_OpenURL(long url) {
        long __functionAddress = Functions.OpenURL;
        return JNI.invokePZ(url, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_OpenURL(@NativeType(value="char const *") ByteBuffer url) {
        if (Checks.CHECKS) {
            Checks.checkNT1(url);
        }
        return SDLMisc.nSDL_OpenURL(MemoryUtil.memAddress(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_OpenURL(@NativeType(value="char const *") CharSequence url) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(url, true);
            long urlEncoded = stack.getPointerAddress();
            boolean bl = SDLMisc.nSDL_OpenURL(urlEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long OpenURL = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_OpenURL");

        private Functions() {
        }
    }
}

