/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_MainThreadCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLInit {
    public static final int SDL_INIT_AUDIO = 16;
    public static final int SDL_INIT_VIDEO = 32;
    public static final int SDL_INIT_JOYSTICK = 512;
    public static final int SDL_INIT_HAPTIC = 4096;
    public static final int SDL_INIT_GAMEPAD = 8192;
    public static final int SDL_INIT_EVENTS = 16384;
    public static final int SDL_INIT_SENSOR = 32768;
    public static final int SDL_INIT_CAMERA = 65536;
    public static final int SDL_APP_CONTINUE = 0;
    public static final int SDL_APP_SUCCESS = 1;
    public static final int SDL_APP_FAILURE = 2;
    public static final String SDL_PROP_APP_METADATA_NAME_STRING = "SDL.app.metadata.name";
    public static final String SDL_PROP_APP_METADATA_VERSION_STRING = "SDL.app.metadata.version";
    public static final String SDL_PROP_APP_METADATA_IDENTIFIER_STRING = "SDL.app.metadata.identifier";
    public static final String SDL_PROP_APP_METADATA_CREATOR_STRING = "SDL.app.metadata.creator";
    public static final String SDL_PROP_APP_METADATA_COPYRIGHT_STRING = "SDL.app.metadata.copyright";
    public static final String SDL_PROP_APP_METADATA_URL_STRING = "SDL.app.metadata.url";
    public static final String SDL_PROP_APP_METADATA_TYPE_STRING = "SDL.app.metadata.type";

    protected SDLInit() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="bool")
    public static boolean SDL_Init(@NativeType(value="SDL_InitFlags") int flags) {
        long __functionAddress = Functions.Init;
        return JNI.invokeZ(flags, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_InitSubSystem(@NativeType(value="SDL_InitFlags") int flags) {
        long __functionAddress = Functions.InitSubSystem;
        return JNI.invokeZ(flags, __functionAddress);
    }

    public static void SDL_QuitSubSystem(@NativeType(value="SDL_InitFlags") int flags) {
        long __functionAddress = Functions.QuitSubSystem;
        JNI.invokeV(flags, __functionAddress);
    }

    @NativeType(value="SDL_InitFlags")
    public static int SDL_WasInit(@NativeType(value="SDL_InitFlags") int flags) {
        long __functionAddress = Functions.WasInit;
        return JNI.invokeI(flags, __functionAddress);
    }

    public static void SDL_Quit() {
        long __functionAddress = Functions.Quit;
        JNI.invokeV(__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsMainThread() {
        long __functionAddress = Functions.IsMainThread;
        return JNI.invokeZ(__functionAddress);
    }

    public static boolean nSDL_RunOnMainThread(long callback, long userdata, boolean wait_complete) {
        long __functionAddress = Functions.RunOnMainThread;
        return JNI.invokePPZ(callback, userdata, wait_complete, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RunOnMainThread(@NativeType(value="SDL_MainThreadCallback") SDL_MainThreadCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="bool") boolean wait_complete) {
        return SDLInit.nSDL_RunOnMainThread(callback.address(), userdata, wait_complete);
    }

    public static boolean nSDL_SetAppMetadata(long appname, long appversion, long appidentifier) {
        long __functionAddress = Functions.SetAppMetadata;
        return JNI.invokePPPZ(appname, appversion, appidentifier, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAppMetadata(@NativeType(value="char const *") @Nullable ByteBuffer appname, @NativeType(value="char const *") @Nullable ByteBuffer appversion, @NativeType(value="char const *") @Nullable ByteBuffer appidentifier) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(appname);
            Checks.checkNT1Safe(appversion);
            Checks.checkNT1Safe(appidentifier);
        }
        return SDLInit.nSDL_SetAppMetadata(MemoryUtil.memAddressSafe(appname), MemoryUtil.memAddressSafe(appversion), MemoryUtil.memAddressSafe(appidentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetAppMetadata(@NativeType(value="char const *") @Nullable CharSequence appname, @NativeType(value="char const *") @Nullable CharSequence appversion, @NativeType(value="char const *") @Nullable CharSequence appidentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(appname, true);
            long appnameEncoded = appname == null ? 0L : stack.getPointerAddress();
            stack.nUTF8Safe(appversion, true);
            long appversionEncoded = appversion == null ? 0L : stack.getPointerAddress();
            stack.nUTF8Safe(appidentifier, true);
            long appidentifierEncoded = appidentifier == null ? 0L : stack.getPointerAddress();
            boolean bl = SDLInit.nSDL_SetAppMetadata(appnameEncoded, appversionEncoded, appidentifierEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetAppMetadataProperty(long name, long value) {
        long __functionAddress = Functions.SetAppMetadataProperty;
        return JNI.invokePPZ(name, value, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAppMetadataProperty(@NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkNT1(value);
        }
        return SDLInit.nSDL_SetAppMetadataProperty(MemoryUtil.memAddress(name), MemoryUtil.memAddress(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetAppMetadataProperty(@NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") CharSequence value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            stack.nUTF8(value, true);
            long valueEncoded = stack.getPointerAddress();
            boolean bl = SDLInit.nSDL_SetAppMetadataProperty(nameEncoded, valueEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetAppMetadataProperty(long name) {
        long __functionAddress = Functions.GetAppMetadataProperty;
        return JNI.invokePP(name, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetAppMetadataProperty(@NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        long __result = SDLInit.nSDL_GetAppMetadataProperty(MemoryUtil.memAddress(name));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable String SDL_GetAppMetadataProperty(@NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            long __result = SDLInit.nSDL_GetAppMetadataProperty(nameEncoded);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long Init = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_Init");
        public static final long InitSubSystem = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_InitSubSystem");
        public static final long QuitSubSystem = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_QuitSubSystem");
        public static final long WasInit = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_WasInit");
        public static final long Quit = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_Quit");
        public static final long IsMainThread = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_IsMainThread");
        public static final long RunOnMainThread = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_RunOnMainThread");
        public static final long SetAppMetadata = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetAppMetadata");
        public static final long SetAppMetadataProperty = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetAppMetadataProperty");
        public static final long GetAppMetadataProperty = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetAppMetadataProperty");

        private Functions() {
        }
    }
}

