/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_DialogFileCallbackI;
import org.lwjgl.sdl.SDL_DialogFileFilter;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

public class SDLDialog {
    public static final String SDL_PROP_FILE_DIALOG_FILTERS_POINTER = "SDL.filedialog.filters";
    public static final String SDL_PROP_FILE_DIALOG_NFILTERS_NUMBER = "SDL.filedialog.nfilters";
    public static final String SDL_PROP_FILE_DIALOG_WINDOW_POINTER = "SDL.filedialog.window";
    public static final String SDL_PROP_FILE_DIALOG_LOCATION_STRING = "SDL.filedialog.location";
    public static final String SDL_PROP_FILE_DIALOG_MANY_BOOLEAN = "SDL.filedialog.many";
    public static final String SDL_PROP_FILE_DIALOG_TITLE_STRING = "SDL.filedialog.title";
    public static final String SDL_PROP_FILE_DIALOG_ACCEPT_STRING = "SDL.filedialog.accept";
    public static final String SDL_PROP_FILE_DIALOG_CANCEL_STRING = "SDL.filedialog.cancel";
    public static final int SDL_FILEDIALOG_OPENFILE = 0;
    public static final int SDL_FILEDIALOG_SAVEFILE = 1;
    public static final int SDL_FILEDIALOG_OPENFOLDER = 2;

    protected SDLDialog() {
        throw new UnsupportedOperationException();
    }

    public static void nSDL_ShowOpenFileDialog(long callback, long userdata, long window, long filters, int nfilters, long default_location, boolean allow_many) {
        long __functionAddress = Functions.ShowOpenFileDialog;
        if (Checks.CHECKS && filters != 0L) {
            Struct.validate(filters, nfilters, SDL_DialogFileFilter.SIZEOF, SDL_DialogFileFilter::validate);
        }
        JNI.invokePPPPPV(callback, userdata, window, filters, nfilters, default_location, allow_many, __functionAddress);
    }

    public static void SDL_ShowOpenFileDialog(@NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_DialogFileFilter const *") @Nullable SDL_DialogFileFilter.Buffer filters, @NativeType(value="char const *") @Nullable ByteBuffer default_location, @NativeType(value="bool") boolean allow_many) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(default_location);
        }
        SDLDialog.nSDL_ShowOpenFileDialog(callback.address(), userdata, window, MemoryUtil.memAddressSafe(filters), Checks.remainingSafe(filters), MemoryUtil.memAddressSafe(default_location), allow_many);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SDL_ShowOpenFileDialog(@NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_DialogFileFilter const *") @Nullable SDL_DialogFileFilter.Buffer filters, @NativeType(value="char const *") @Nullable CharSequence default_location, @NativeType(value="bool") boolean allow_many) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(default_location, true);
            long default_locationEncoded = default_location == null ? 0L : stack.getPointerAddress();
            SDLDialog.nSDL_ShowOpenFileDialog(callback.address(), userdata, window, MemoryUtil.memAddressSafe(filters), Checks.remainingSafe(filters), default_locationEncoded, allow_many);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_ShowSaveFileDialog(long callback, long userdata, long window, long filters, int nfilters, long default_location) {
        long __functionAddress = Functions.ShowSaveFileDialog;
        if (Checks.CHECKS && filters != 0L) {
            Struct.validate(filters, nfilters, SDL_DialogFileFilter.SIZEOF, SDL_DialogFileFilter::validate);
        }
        JNI.invokePPPPPV(callback, userdata, window, filters, nfilters, default_location, __functionAddress);
    }

    public static void SDL_ShowSaveFileDialog(@NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_DialogFileFilter const *") @Nullable SDL_DialogFileFilter.Buffer filters, @NativeType(value="char const *") @Nullable ByteBuffer default_location) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(default_location);
        }
        SDLDialog.nSDL_ShowSaveFileDialog(callback.address(), userdata, window, MemoryUtil.memAddressSafe(filters), Checks.remainingSafe(filters), MemoryUtil.memAddressSafe(default_location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SDL_ShowSaveFileDialog(@NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_DialogFileFilter const *") @Nullable SDL_DialogFileFilter.Buffer filters, @NativeType(value="char const *") @Nullable CharSequence default_location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(default_location, true);
            long default_locationEncoded = default_location == null ? 0L : stack.getPointerAddress();
            SDLDialog.nSDL_ShowSaveFileDialog(callback.address(), userdata, window, MemoryUtil.memAddressSafe(filters), Checks.remainingSafe(filters), default_locationEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_ShowOpenFolderDialog(long callback, long userdata, long window, long default_location, boolean allow_many) {
        long __functionAddress = Functions.ShowOpenFolderDialog;
        JNI.invokePPPPV(callback, userdata, window, default_location, allow_many, __functionAddress);
    }

    public static void SDL_ShowOpenFolderDialog(@NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_Window *") long window, @NativeType(value="char const *") @Nullable ByteBuffer default_location, @NativeType(value="bool") boolean allow_many) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(default_location);
        }
        SDLDialog.nSDL_ShowOpenFolderDialog(callback.address(), userdata, window, MemoryUtil.memAddressSafe(default_location), allow_many);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SDL_ShowOpenFolderDialog(@NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_Window *") long window, @NativeType(value="char const *") @Nullable CharSequence default_location, @NativeType(value="bool") boolean allow_many) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(default_location, true);
            long default_locationEncoded = default_location == null ? 0L : stack.getPointerAddress();
            SDLDialog.nSDL_ShowOpenFolderDialog(callback.address(), userdata, window, default_locationEncoded, allow_many);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_ShowFileDialogWithProperties(int type, long callback, long userdata, int props) {
        long __functionAddress = Functions.ShowFileDialogWithProperties;
        JNI.invokePPV(type, callback, userdata, props, __functionAddress);
    }

    public static void SDL_ShowFileDialogWithProperties(@NativeType(value="SDL_FileDialogType") int type, @NativeType(value="SDL_DialogFileCallback") SDL_DialogFileCallbackI callback, @NativeType(value="void *") long userdata, @NativeType(value="SDL_PropertiesID") int props) {
        SDLDialog.nSDL_ShowFileDialogWithProperties(type, callback.address(), userdata, props);
    }

    public static final class Functions {
        public static final long ShowOpenFileDialog = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ShowOpenFileDialog");
        public static final long ShowSaveFileDialog = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ShowSaveFileDialog");
        public static final long ShowOpenFolderDialog = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ShowOpenFolderDialog");
        public static final long ShowFileDialogWithProperties = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ShowFileDialogWithProperties");

        private Functions() {
        }
    }
}

