/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.consumers.ConsumeItemDynamic;

public abstract class BlockProducer
extends PayloadBlock {
    public float buildSpeed = 0.4f;

    public BlockProducer(String name) {
        super(name);
        this.size = 3;
        this.update = true;
        this.outputsPayload = true;
        this.hasItems = true;
        this.solid = true;
        this.hasPower = true;
        this.acceptsUnitPayloads = false;
        this.rotate = true;
        this.regionRotated1 = 1;
        ObjectMap stacks = new ObjectMap();
        this.consume(new ConsumeItemDynamic(e -> {
            Block block = e.recipe();
            if (block != null) {
                ItemStack[] clone = (ItemStack[])stacks.get(block, () -> ItemStack.copy(block.requirements));
                if (clone.length != block.requirements.length) {
                    clone = ItemStack.copy(block.requirements);
                    stacks.put(block, clone);
                }
                for (int i = 0; i < clone.length; ++i) {
                    clone[i].item = block.requirements[i].item;
                    clone[i].amount = Mathf.ceil((float)block.requirements[i].amount * Vars.state.rules.buildCostMultiplier);
                }
                return clone;
            }
            return ItemStack.empty;
        }));
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.outRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("progress", entity -> new Bar("bar.progress", Pal.ammo, () -> entity.recipe() == null ? 0.0f : entity.progress / entity.recipe().buildTime));
    }

    public abstract class BlockProducerBuild
    extends PayloadBlock.PayloadBlockBuild<BuildPayload> {
        public float progress;
        public float time;
        public float heat;

        public BlockProducerBuild() {
            super(BlockProducer.this);
        }

        @Nullable
        public abstract Block recipe();

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            if (this.recipe() == null) {
                return 0;
            }
            for (ItemStack stack : this.recipe().requirements) {
                if (stack.item != item) continue;
                return stack.amount * 2;
            }
            return 0;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        @Override
        public boolean shouldConsume() {
            return super.shouldConsume() && this.recipe() != null;
        }

        @Override
        public void updateTile() {
            boolean produce;
            super.updateTile();
            Block recipe = this.recipe();
            boolean bl = produce = recipe != null && this.efficiency > 0.0f && this.payload == null;
            if (produce) {
                this.progress += BlockProducer.this.buildSpeed * this.edelta();
                if (this.progress >= recipe.buildTime) {
                    this.consume();
                    this.payload = new BuildPayload(recipe, this.team);
                    ((BuildPayload)this.payload).block().placeEffect.at(this.x, this.y, ((BuildPayload)this.payload).size() / 8.0f);
                    this.payVector.setZero();
                    this.progress %= 1.0f;
                }
            }
            this.heat = Mathf.lerpDelta(this.heat, Mathf.num(produce), 0.15f);
            this.time += this.heat * this.delta();
            this.moveOutPayload();
        }

        @Override
        public void draw() {
            Draw.rect(BlockProducer.this.region, this.x, this.y);
            Draw.rect(BlockProducer.this.outRegion, this.x, this.y, this.rotdeg());
            Block recipe = this.recipe();
            if (recipe != null) {
                Drawf.shadow(this.x, this.y, (float)(recipe.size * 8) * 2.0f, this.progress / recipe.buildTime);
                Draw.draw(40.0f, () -> {
                    Draw.color(Pal.accent);
                    TextureRegion[] textureRegionArray = recipe.getGeneratedIcons();
                    int n = textureRegionArray.length;
                    for (int i = 0; i < n; ++i) {
                        TextureRegion region;
                        Shaders.blockbuild.region = region = textureRegionArray[i];
                        Shaders.blockbuild.time = this.time;
                        Shaders.blockbuild.progress = this.progress / recipe.buildTime;
                        Draw.rect(region, this.x, this.y, recipe.rotate ? this.rotdeg() : 0.0f);
                        Draw.flush();
                    }
                    Draw.color();
                });
                Draw.z(41.0f);
                Draw.color(Pal.accent, this.heat);
                Lines.lineAngleCenter(this.x + Mathf.sin(this.time, 10.0f, 4.0f * (float)recipe.size + 1.0f), this.y, 90.0f, (float)(recipe.size * 8) + 1.0f);
                Draw.reset();
            }
            this.drawPayload();
            Draw.z(41.1f);
            Draw.rect(BlockProducer.this.topRegion, this.x, this.y);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
        }
    }
}

