/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;

public class SwitchBlock
extends Block {
    public Sound clickSound = Sounds.click;
    public TextureRegion onRegion;

    public SwitchBlock(String name) {
        super(name);
        this.configurable = true;
        this.update = true;
        this.drawDisabled = false;
        this.autoResetEnabled = false;
        this.configureSound = Sounds.none;
        this.group = BlockGroup.logic;
        this.envEnabled = -1;
        this.config(Boolean.class, (entity, b) -> {
            entity.enabled = b;
        });
    }

    public boolean accessible() {
        return !this.privileged || Vars.state.rules.editor || Vars.state.rules.allowEditWorldProcessors;
    }

    @Override
    public boolean canBreak(Tile tile) {
        return this.accessible();
    }

    public class SwitchBuild
    extends Building {
        @Override
        public void damage(float damage) {
            if (SwitchBlock.this.privileged) {
                return;
            }
            super.damage(damage);
        }

        @Override
        public boolean canPickup() {
            return !SwitchBlock.this.privileged;
        }

        @Override
        public boolean collide(Bullet other) {
            return !SwitchBlock.this.privileged;
        }

        @Override
        public boolean configTapped() {
            this.configure(!this.enabled);
            SwitchBlock.this.clickSound.at(this);
            return false;
        }

        @Override
        public void draw() {
            super.draw();
            if (this.enabled) {
                Draw.rect(SwitchBlock.this.onRegion, this.x, this.y);
            }
        }

        @Override
        public Boolean config() {
            return this.enabled;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 1) {
                this.enabled = read.bool();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.enabled);
        }
    }
}

