/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ItemBridge
extends Block {
    private static BuildPlan otherReq;
    public final int timerCheckMoved;
    public int range;
    public float transportTime;
    public TextureRegion endRegion;
    public TextureRegion bridgeRegion;
    public TextureRegion arrowRegion;
    public boolean fadeIn;
    public boolean moveArrows;
    public boolean pulse;
    public float arrowSpacing;
    public float arrowOffset;
    public float arrowPeriod;
    public float arrowTimeScl;
    public float bridgeWidth;
    @Nullable
    public ItemBridgeBuild lastBuild;

    public ItemBridge(String name) {
        super(name);
        this.timerCheckMoved = this.timers++;
        this.fadeIn = true;
        this.moveArrows = true;
        this.pulse = false;
        this.arrowSpacing = 4.0f;
        this.arrowOffset = 2.0f;
        this.arrowPeriod = 0.4f;
        this.arrowTimeScl = 6.2f;
        this.bridgeWidth = 6.5f;
        this.update = true;
        this.solid = true;
        this.underBullets = true;
        this.hasPower = true;
        this.itemCapacity = 10;
        this.configurable = true;
        this.hasItems = true;
        this.unloadable = false;
        this.group = BlockGroup.transportation;
        this.noUpdateDisabled = true;
        this.allowDiagonal = false;
        this.copyConfig = false;
        this.allowConfigInventory = false;
        this.ignoreResizeConfig = true;
        this.priority = -1.0f;
        this.delayLandingConfig = true;
        this.config(Point2.class, (tile, i) -> {
            tile.link = Point2.pack(i.x + tile.tileX(), i.y + tile.tileY());
        });
        this.config(Integer.class, (tile, i) -> {
            tile.link = i;
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.transportTime != 0.0f) {
            this.stats.add(Stat.itemsMoved, 60.0f / this.transportTime, StatUnit.itemsSecond);
        }
    }

    @Override
    public void drawPlanConfigTop(BuildPlan plan, Eachable<BuildPlan> list) {
        otherReq = null;
        list.each(other -> {
            Point2 p;
            Object patt2492$temp;
            if (other.block == this && plan != other && (patt2492$temp = plan.config) instanceof Point2 && (p = (Point2)patt2492$temp).equals(other.x - plan.x, other.y - plan.y)) {
                otherReq = other;
            }
        });
        if (otherReq != null) {
            this.drawBridge(plan, otherReq.drawx(), otherReq.drawy(), 0.0f);
        }
    }

    public void drawBridge(BuildPlan req, float ox, float oy, float flip) {
        if (Mathf.zero(Renderer.bridgeOpacity)) {
            return;
        }
        Draw.alpha(Renderer.bridgeOpacity);
        Lines.stroke(this.bridgeWidth);
        Tmp.v1.set(ox, oy).sub(req.drawx(), req.drawy()).setLength(4.0f);
        Lines.line(this.bridgeRegion, req.drawx() + Tmp.v1.x, req.drawy() + Tmp.v1.y, ox - Tmp.v1.x, oy - Tmp.v1.y, false);
        Draw.rect(this.arrowRegion, (req.drawx() + ox) / 2.0f, (req.drawy() + oy) / 2.0f, Angles.angle(req.drawx(), req.drawy(), ox, oy) + flip);
        Draw.reset();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Tile link = this.findLink(x, y);
        for (int i = 0; i < 4; ++i) {
            Drawf.dashLine(Pal.placing, (float)(x * 8) + (float)Geometry.d4[i].x * 6.0f, (float)(y * 8) + (float)Geometry.d4[i].y * 6.0f, x * 8 + Geometry.d4[i].x * this.range * 8, y * 8 + Geometry.d4[i].y * this.range * 8);
        }
        Draw.reset();
        Draw.color(Pal.placing);
        Lines.stroke(1.0f);
        if (link != null && Math.abs(link.x - x) + Math.abs(link.y - y) > 1) {
            byte rot = link.absoluteRelativeTo(x, y);
            float w = link.x == x ? 8 : Math.abs(link.x - x) * 8 - 8;
            float h = link.y == y ? 8 : Math.abs(link.y - y) * 8 - 8;
            Lines.rect((float)(x + link.x) / 2.0f * 8.0f - w / 2.0f, (float)(y + link.y) / 2.0f * 8.0f - h / 2.0f, w, h);
            Draw.rect("bridge-arrow", (float)(link.x * 8 + Geometry.d4((int)rot).x * 8), (float)(link.y * 8 + Geometry.d4((int)rot).y * 8), (float)(link.absoluteRelativeTo(x, y) * 90));
        }
        Draw.reset();
    }

    public boolean linkValid(Tile tile, Tile other) {
        return this.linkValid(tile, other, true);
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble) {
        if (other == null || tile == null || !this.positionsValid(tile.x, tile.y, other.x, other.y)) {
            return false;
        }
        return (other.block() == tile.block() && tile.block() == this || !(tile.block() instanceof ItemBridge) && other.block() == this) && (other.team() == tile.team() || tile.block() != this) && (!checkDouble || ((ItemBridgeBuild)other.build).link != tile.pos());
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            return Math.abs(y1 - y2) <= this.range;
        }
        if (y1 == y2) {
            return Math.abs(x1 - x2) <= this.range;
        }
        return false;
    }

    public Tile findLink(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && this.lastBuild != null && this.linkValid(tile, this.lastBuild.tile) && this.lastBuild.tile != tile && this.lastBuild.link == -1) {
            return this.lastBuild.tile;
        }
        return null;
    }

    @Override
    public void init() {
        super.init();
        this.updateClipRadius(((float)this.range + 0.5f) * 8.0f);
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        for (int i = 0; i < plans.size - 1; ++i) {
            BuildPlan cur = plans.get(i);
            BuildPlan next = plans.get(i + 1);
            if (!this.positionsValid(cur.x, cur.y, next.x, next.y)) continue;
            cur.config = new Point2(next.x - cur.x, next.y - cur.y);
        }
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, this, rotation, (point, other) -> Math.max(Math.abs(point.x - other.x), Math.abs(point.y - other.y)) <= this.range);
    }

    public class ItemBridgeBuild
    extends Building {
        public int link = -1;
        public IntSeq incoming = new IntSeq(false, 4);
        public float warmup;
        public float time = -8.0f;
        public float timeSpeed;
        public boolean wasMoved;
        public boolean moved;
        public float transportCounter;

        @Override
        public void pickedUp() {
            this.link = -1;
        }

        @Override
        public void playerPlaced(Object config) {
            super.playerPlaced(config);
            Tile link = ItemBridge.this.findLink(this.tile.x, this.tile.y);
            if (ItemBridge.this.linkValid(this.tile, link) && this.link != link.pos() && !this.proximity.contains(link.build)) {
                link.build.configure(this.tile.pos());
            }
            ItemBridge.this.lastBuild = this;
        }

        @Override
        public void drawSelect() {
            if (ItemBridge.this.linkValid(this.tile, Vars.world.tile(this.link))) {
                this.drawInput(Vars.world.tile(this.link));
            }
            this.incoming.each(pos -> this.drawInput(Vars.world.tile(pos)));
            Draw.reset();
        }

        private void drawInput(Tile other) {
            if (!ItemBridge.this.linkValid(this.tile, other, false)) {
                return;
            }
            boolean linked = other.pos() == this.link;
            Tmp.v2.trns(this.tile.angleTo(other), 2.0f);
            float tx = this.tile.drawx();
            float ty = this.tile.drawy();
            float ox = other.drawx();
            float oy = other.drawy();
            float alpha = Math.abs((float)(linked ? 100 : 0) - Time.time * 2.0f % 100.0f) / 100.0f;
            float x = Mathf.lerp(ox, tx, alpha);
            float y = Mathf.lerp(oy, ty, alpha);
            Tile otherLink = linked ? other : this.tile;
            byte rel = (linked ? this.tile : other).absoluteRelativeTo(otherLink.x, otherLink.y);
            Draw.color(Pal.gray);
            Lines.stroke(2.5f);
            Lines.square(ox, oy, 2.0f, 45.0f);
            Lines.stroke(2.5f);
            Lines.line(tx + Tmp.v2.x, ty + Tmp.v2.y, ox - Tmp.v2.x, oy - Tmp.v2.y);
            float color = (linked ? Pal.place : Pal.accent).toFloatBits();
            Draw.color(color);
            Lines.stroke(1.0f);
            Lines.line(tx + Tmp.v2.x, ty + Tmp.v2.y, ox - Tmp.v2.x, oy - Tmp.v2.y);
            Lines.square(ox, oy, 2.0f, 45.0f);
            Draw.mixcol(color);
            Draw.color();
            Draw.rect(ItemBridge.this.arrowRegion, x, y, (float)(rel * 90));
            Draw.mixcol();
        }

        @Override
        public void drawConfigure() {
            Drawf.select(this.x, this.y, (float)(this.tile.block().size * 8) / 2.0f + 2.0f, Pal.accent);
            for (int i = 1; i <= ItemBridge.this.range; ++i) {
                for (int j = 0; j < 4; ++j) {
                    Tile other = this.tile.nearby(Geometry.d4[j].x * i, Geometry.d4[j].y * i);
                    if (!ItemBridge.this.linkValid(this.tile, other)) continue;
                    boolean linked = other.pos() == this.link;
                    Drawf.select(other.drawx(), other.drawy(), (float)(other.block().size * 8) / 2.0f + 2.0f + (linked ? 0.0f : Mathf.absin(Time.time, 4.0f, 1.0f)), linked ? Pal.place : Pal.breakInvalid);
                }
            }
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (other instanceof ItemBridgeBuild) {
                ItemBridgeBuild b = (ItemBridgeBuild)other;
                if (b.link == this.pos()) {
                    this.configure(other.pos());
                    other.configure(-1);
                    return true;
                }
            }
            if (ItemBridge.this.linkValid(this.tile, other.tile)) {
                if (this.link == other.pos()) {
                    this.configure(-1);
                } else {
                    this.configure(other.pos());
                }
                return false;
            }
            return true;
        }

        public void checkIncoming() {
            for (int idx = 0; idx < this.incoming.size; ++idx) {
                int i = this.incoming.items[idx];
                Tile other = Vars.world.tile(i);
                if (ItemBridge.this.linkValid(this.tile, other, false) && ((ItemBridgeBuild)other.build).link == this.tile.pos()) continue;
                this.incoming.removeIndex(idx);
                --idx;
            }
        }

        @Override
        public void updateTile() {
            if (this.timer(ItemBridge.this.timerCheckMoved, 30.0f)) {
                this.wasMoved = this.moved;
                this.moved = false;
            }
            this.timeSpeed = Mathf.approachDelta(this.timeSpeed, this.wasMoved ? 1.0f : 0.0f, 0.016666668f);
            this.time += this.timeSpeed * this.delta();
            this.checkIncoming();
            Tile other = Vars.world.tile(this.link);
            if (!ItemBridge.this.linkValid(this.tile, other)) {
                this.doDump();
                this.warmup = 0.0f;
            } else {
                IntSeq inc = ((ItemBridgeBuild)other.build).incoming;
                int pos = this.tile.pos();
                if (!inc.contains(pos)) {
                    inc.add(pos);
                }
                this.warmup = Mathf.approachDelta(this.warmup, this.efficiency, 0.033333335f);
                this.updateTransport(other.build);
            }
        }

        public void doDump() {
            this.dumpAccumulate();
        }

        public void updateTransport(Building other) {
            this.transportCounter += this.edelta();
            while (this.transportCounter >= ItemBridge.this.transportTime) {
                Item item = this.items.take();
                if (item != null && other.acceptItem(this, item)) {
                    other.handleItem(this, item);
                    this.moved = true;
                } else if (item != null) {
                    this.items.add(item, 1);
                    this.items.undoFlow(item);
                }
                this.transportCounter -= ItemBridge.this.transportTime;
            }
        }

        @Override
        public void draw() {
            super.draw();
            Draw.z(70.0f);
            Tile other = Vars.world.tile(this.link);
            if (!ItemBridge.this.linkValid(this.tile, other)) {
                return;
            }
            if (Mathf.zero(Renderer.bridgeOpacity)) {
                return;
            }
            byte i = this.relativeTo(other.x, other.y);
            if (ItemBridge.this.pulse) {
                Draw.color(Color.white, Color.black, Mathf.absin(Time.time, 6.0f, 0.07f));
            }
            float warmup = ItemBridge.this.hasPower ? this.warmup : 1.0f;
            Draw.alpha((ItemBridge.this.fadeIn ? Math.max(warmup, 0.25f) : 1.0f) * Renderer.bridgeOpacity);
            Draw.rect(ItemBridge.this.endRegion, this.x, this.y, (float)(i * 90 + 90));
            Draw.rect(ItemBridge.this.endRegion, other.drawx(), other.drawy(), (float)(i * 90 + 270));
            Lines.stroke(ItemBridge.this.bridgeWidth);
            Tmp.v1.set(this.x, this.y).sub(other.worldx(), other.worldy()).setLength(4.0f).scl(-1.0f);
            Lines.line(ItemBridge.this.bridgeRegion, this.x + Tmp.v1.x, this.y + Tmp.v1.y, other.worldx() - Tmp.v1.x, other.worldy() - Tmp.v1.y, false);
            int dist = Math.max(Math.abs(other.x - this.tile.x), Math.abs(other.y - this.tile.y)) - 1;
            Draw.color();
            int arrows = (int)((float)(dist * 8) / ItemBridge.this.arrowSpacing);
            int dx = Geometry.d4x(i);
            int dy = Geometry.d4y(i);
            for (int a = 0; a < arrows; ++a) {
                Draw.alpha(Mathf.absin((float)a - this.time / ItemBridge.this.arrowTimeScl, ItemBridge.this.arrowPeriod, 1.0f) * warmup * Renderer.bridgeOpacity);
                Draw.rect(ItemBridge.this.arrowRegion, this.x + (float)dx * (4.0f + (float)a * ItemBridge.this.arrowSpacing + ItemBridge.this.arrowOffset), this.y + (float)dy * (4.0f + (float)a * ItemBridge.this.arrowSpacing + ItemBridge.this.arrowOffset), (float)i * 90.0f);
            }
            Draw.reset();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return ItemBridge.this.hasItems && this.team == source.team && this.items.total() < ItemBridge.this.itemCapacity && this.checkAccept(source, Vars.world.tile(this.link));
        }

        @Override
        public boolean canDumpLiquid(Building to, Liquid liquid) {
            return this.checkDump(to);
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return ItemBridge.this.hasLiquids && this.team == source.team && (this.liquids.current() == liquid || this.liquids.get(this.liquids.current()) < 0.2f) && this.checkAccept(source, Vars.world.tile(this.link));
        }

        protected boolean checkAccept(Building source, Tile link) {
            if (this.tile == null || this.linked(source)) {
                return true;
            }
            if (ItemBridge.this.linkValid(this.tile, link)) {
                byte rel = this.relativeTo(link);
                Tile facing = Edges.getFacingEdge(source, this);
                byte rel2 = facing == null ? (byte)-1 : (byte)this.relativeTo(facing);
                return rel != rel2;
            }
            return false;
        }

        protected boolean linked(Building source) {
            return source instanceof ItemBridgeBuild && ItemBridge.this.linkValid(source.tile, this.tile) && ((ItemBridgeBuild)source).link == this.pos();
        }

        @Override
        public boolean canDump(Building to, Item item) {
            return this.checkDump(to);
        }

        protected boolean checkDump(Building to) {
            byte rel2;
            Tile other = Vars.world.tile(this.link);
            if (!ItemBridge.this.linkValid(this.tile, other)) {
                Tile edge = Edges.getFacingEdge(to.tile, this.tile);
                byte i = this.relativeTo(edge.x, edge.y);
                for (int j = 0; j < this.incoming.size; ++j) {
                    int v = this.incoming.items[j];
                    if (this.relativeTo(Point2.x(v), Point2.y(v)) != i) continue;
                    return false;
                }
                return true;
            }
            byte rel = this.relativeTo(other.x, other.y);
            return rel != (rel2 = this.relativeTo(to.tileX(), to.tileY()));
        }

        @Override
        public boolean shouldConsume() {
            return ItemBridge.this.linkValid(this.tile, Vars.world.tile(this.link)) && this.enabled;
        }

        @Override
        public Point2 config() {
            return Point2.unpack(this.link).sub(this.tile.x, this.tile.y);
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.warmup);
            write.b(this.incoming.size);
            for (int i = 0; i < this.incoming.size; ++i) {
                write.i(this.incoming.items[i]);
            }
            write.bool(this.wasMoved || this.moved);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.warmup = read.f();
            int links = read.b();
            for (int i = 0; i < links; ++i) {
                this.incoming.add(read.i());
            }
            if (revision >= 1) {
                this.wasMoved = this.moved = read.bool();
            }
        }
    }
}

