/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitUnit;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.UnitType;
import mindustry.world.Build;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.RotBlock;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;

public class BuildTurret
extends BaseTurret {
    public final int timerTarget;
    public final int timerTarget2;
    public int targetInterval;
    public TextureRegion baseRegion;
    public TextureRegion glowRegion;
    public float buildSpeed;
    public float buildBeamOffset;
    @Nullable
    public UnitType unitType;
    public float elevation;
    public Color heatColor;

    public BuildTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.timerTarget2 = this.timers++;
        this.targetInterval = 15;
        this.buildSpeed = 1.0f;
        this.buildBeamOffset = 5.0f;
        this.elevation = -1.0f;
        this.heatColor = Pal.accent.cpy().a(0.9f);
        this.group = BlockGroup.turrets;
        this.sync = false;
        this.rotateSpeed = 10.0f;
        this.suppressable = true;
    }

    @Override
    public void init() {
        super.init();
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
        this.unitType = new UnitType("turret-unit-" + this.name){
            {
                this.hidden = true;
                this.internal = true;
                this.speed = 0.0f;
                this.hitSize = 0.0f;
                this.health = 1.0f;
                this.itemCapacity = 0;
                this.rotateSpeed = BuildTurret.this.rotateSpeed;
                this.buildBeamOffset = BuildTurret.this.buildBeamOffset;
                this.buildRange = BuildTurret.this.range;
                this.buildSpeed = BuildTurret.this.buildSpeed;
                this.constructor = BlockUnitUnit::create;
            }
        };
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.addPercent(Stat.buildSpeed, this.buildSpeed);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public class BuildTurretBuild
    extends BaseTurret.BaseTurretBuild
    implements ControlBlock,
    RotBlock {
        public BlockUnitc unit;
        @Nullable
        public Unit following;
        @Nullable
        public Teams.BlockPlan lastPlan;
        public float warmup;

        public BuildTurretBuild() {
            super(BuildTurret.this);
            this.unit = (BlockUnitc)((Object)BuildTurret.this.unitType.create(this.team));
            this.unit.rotation(90.0f);
        }

        @Override
        public boolean canControl() {
            return true;
        }

        @Override
        public float buildRotation() {
            return this.unit.rotation();
        }

        @Override
        public Unit unit() {
            this.unit.tile(this);
            this.unit.team(this.team);
            return (Unit)((Object)this.unit);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void updateTile() {
            block13: {
                block11: {
                    block15: {
                        block14: {
                            block12: {
                                this.unit.tile(this);
                                this.unit.team(this.team);
                                this.rotation = this.unit.rotation();
                                if (this.unit.activelyBuilding()) {
                                    this.unit.lookAt(this.angleTo(this.unit.buildPlan()));
                                }
                                if (this.checkSuppression()) {
                                    this.potentialEfficiency = 0.0f;
                                    this.efficiency = 0.0f;
                                }
                                this.unit.buildSpeedMultiplier(this.potentialEfficiency * this.timeScale);
                                this.unit.speedMultiplier(this.potentialEfficiency * this.timeScale);
                                this.warmup = Mathf.lerpDelta(this.warmup, this.unit.activelyBuilding() != false ? this.efficiency : 0.0f, 0.1f);
                                if (this.isControlled()) break block11;
                                this.unit.updateBuilding(true);
                                if (this.following == null) break block12;
                                if (!this.following.isValid() || !this.following.activelyBuilding()) {
                                    this.following = null;
                                    this.unit.plans().clear();
                                } else {
                                    this.unit.plans().clear();
                                    this.unit.plans().addFirst(this.following.buildPlan());
                                    this.lastPlan = null;
                                }
                                break block13;
                            }
                            if (this.unit.buildPlan() != null || !this.timer(BuildTurret.this.timerTarget, BuildTurret.this.targetInterval)) break block14;
                            blocks = this.team.data().plans;
                            for (i = 0; i < blocks.size; ++i) {
                                block = blocks.get(i);
                                if (!this.within(block.x * 8, block.y * 8, BuildTurret.this.range) || !Build.validPlace(btype = block.block, this.unit.team(), block.x, block.y, block.rotation) || !Vars.state.rules.infiniteResources && !this.team.rules().infiniteResources && !this.team.items().has(btype.requirements, Vars.state.rules.buildCostMultiplier)) continue;
                                this.unit.addBuild(new BuildPlan(block.x, block.y, block.rotation, block.block, block.config));
                                blocks.addLast(blocks.removeIndex(i));
                                this.lastPlan = block;
                                break;
                            }
                            if (this.unit.buildPlan() == null) {
                                this.following = null;
                                Units.nearby(this.team, this.x, this.y, BuildTurret.this.range, (Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$updateTile$0(mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)((BuildTurretBuild)this));
                            }
                            break block13;
                        }
                        if (this.unit.buildPlan() == null) break block13;
                        req = this.unit.buildPlan();
                        if (!req.breaking && this.timer.get(BuildTurret.this.timerTarget2, 30.0f)) {
                            for (Player player : this.team.data().players) {
                                if (!player.isBuilder() || !player.unit().activelyBuilding() || !player.unit().buildPlan().samePos(req) || !player.unit().buildPlan().breaking) continue;
                                this.unit.plans().removeFirst();
                                this.team.data().plans.remove((Teams.BlockPlan)(Boolf<Teams.BlockPlan>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTile$1(mindustry.entities.units.BuildPlan mindustry.game.Teams$BlockPlan ), (Lmindustry/game/Teams$BlockPlan;)Z)((BuildPlan)req));
                                return;
                            }
                        }
                        if (this.lastPlan != null && this.lastPlan.removed) ** GOTO lbl-1000
                        if (req.tile() == null || !((var4_9 = req.tile().build) instanceof ConstructBlock.ConstructBuild)) break block15;
                        cons = (ConstructBlock.ConstructBuild)var4_9;
                        if (cons.current == req.block) ** GOTO lbl-1000
                    }
                    if (req.breaking != false ? Build.validBreak(this.unit.team(), req.x, req.y) != false : Build.validPlace(req.block, this.unit.team(), req.x, req.y, req.rotation) != false) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = valid = false;
                    }
                    if (!valid) {
                        this.unit.plans().removeFirst();
                        this.lastPlan = null;
                    }
                    break block13;
                }
                this.following = null;
                this.lastPlan = null;
            }
            this.unit.plans().remove((BuildPlan)(Boolf<BuildPlan>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateTile$2(mindustry.entities.units.BuildPlan ), (Lmindustry/entities/units/BuildPlan;)Z)((BuildTurretBuild)this));
            this.unit.updateBuildLogic();
        }

        @Override
        public boolean shouldConsume() {
            return this.unit.plans().size > 0 && !this.isHealSuppressed();
        }

        @Override
        public void draw() {
            Draw.rect(BuildTurret.this.baseRegion, this.x, this.y);
            Draw.color();
            Draw.z(50.0f);
            Drawf.shadow(BuildTurret.this.region, this.x - BuildTurret.this.elevation, this.y - BuildTurret.this.elevation, this.rotation - 90.0f);
            Draw.rect(BuildTurret.this.region, this.x, this.y, this.rotation - 90.0f);
            if (BuildTurret.this.glowRegion.found()) {
                Drawf.additive(BuildTurret.this.glowRegion, BuildTurret.this.heatColor, this.warmup, this.x, this.y, this.rotation - 90.0f, 50.1f);
            }
            if (this.efficiency > 0.0f) {
                this.unit.drawBuilding();
            }
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
            TypeIO.writePlans(write, this.unit.plans().toArray(BuildPlan.class));
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.rotation = read.f();
            this.unit.rotation(this.rotation);
            this.unit.plans().clear();
            BuildPlan[] reqs = TypeIO.readPlans(read);
            if (reqs != null) {
                for (BuildPlan req : reqs) {
                    this.unit.plans().add(req);
                }
            }
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case buildX: 
                case buildY: {
                    d = this.unit.sense(sensor);
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        @Override
        public Object senseObject(LAccess sensor) {
            Object object;
            switch (sensor) {
                case building: 
                case breaking: {
                    object = this.unit.senseObject(sensor);
                    break;
                }
                default: {
                    object = super.senseObject(sensor);
                }
            }
            return object;
        }

        private /* synthetic */ boolean lambda$updateTile$2(BuildPlan b) {
            return b.build() == this;
        }

        private static /* synthetic */ boolean lambda$updateTile$1(BuildPlan req, Teams.BlockPlan p) {
            return p.x == req.x && p.y == req.y;
        }

        private /* synthetic */ void lambda$updateTile$0(Unit u) {
            if (this.following != null) {
                return;
            }
            if (u.canBuild() && u.activelyBuilding()) {
                BuildPlan plan = u.buildPlan();
                Building build = Vars.world.build(plan.x, plan.y);
                if (build instanceof ConstructBlock.ConstructBuild && this.within(build, BuildTurret.this.range)) {
                    this.following = u;
                }
            }
        }
    }
}

