/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.campaign;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.Sector;
import mindustry.ui.Bar;
import mindustry.ui.ReqImage;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.Stats;

public class LandingPad
extends Block {
    static ObjectMap<Item, Seq<LandingPadBuild>> waiting = new ObjectMap();
    static long lastUpdateId = -1L;
    public TextureRegion podRegion;
    public float arrivalDuration = 150.0f;
    public float cooldownTime = 150.0f;
    public float consumeLiquidAmount = 100.0f;
    public Liquid consumeLiquid = Liquids.water;
    public Effect landEffect = Fx.podLandShockwave;
    public Effect coolingEffect = Fx.none;
    public float coolingEffectChance = 0.2f;
    public float liquidPad = 2.0f;
    public Color bottomColor = Pal.darkerMetal;
    public float landSoundVolume = 0.75f;
    public Sound landSound = Sounds.padLand;

    public LandingPad(String name) {
        super(name);
        this.hasItems = true;
        this.hasLiquids = true;
        this.solid = true;
        this.update = true;
        this.configurable = true;
        this.acceptsItems = false;
        this.canOverdrive = false;
        this.emitLight = true;
        this.lightRadius = 90.0f;
        this.config(Item.class, (build, item) -> {
            if (!build.accessible()) {
                return;
            }
            build.config = item;
        });
        this.configClear(build -> {
            if (!build.accessible()) {
                return;
            }
            build.config = null;
        });
    }

    @Override
    public void init() {
        this.consume(new ConsumeLiquid(this.consumeLiquid, this.consumeLiquidAmount){

            @Override
            public void build(Building build, Table table) {
                table.add(new ReqImage(this.liquid.uiIcon, () -> build.liquids.get(this.liquid) >= this.amount)).size(32.0f).top().left();
            }

            @Override
            public float efficiency(Building build) {
                return build.liquids.get(LandingPad.this.consumeLiquid) >= this.amount ? 1.0f : 0.0f;
            }

            @Override
            public void display(Stats stats) {
                stats.add(Stat.input, this.liquid, this.amount, false);
            }
        }).update(false);
        super.init();
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addLiquidBar(this.consumeLiquid);
        this.addBar("cooldown", entity -> new Bar("bar.cooldown", Pal.lightOrange, () -> entity.cooldown));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.cooldownTime, (this.cooldownTime + this.arrivalDuration) / 60.0f, StatUnit.seconds);
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    public static void landingPadLanded(Tile tile) {
        Building building;
        if (tile == null || !((building = tile.build) instanceof LandingPadBuild)) {
            return;
        }
        LandingPadBuild build = (LandingPadBuild)building;
        build.handleLanding();
    }

    static {
        Events.on(EventType.ResetEvent.class, e -> {
            waiting.clear();
            lastUpdateId = -1L;
        });
    }

    public class LandingPadBuild
    extends Building {
        @Nullable
        public Item config;
        public int priority = Mathf.rand.nextInt();
        public float cooldown = 0.0f;
        public float landParticleTimer;
        public float arrivingTimer = 0.0f;
        @Nullable
        public Item arriving;
        public float liquidRemoved;

        public void handleLanding() {
            if (this.config == null) {
                return;
            }
            this.cooldown = 1.0f;
            this.arriving = this.config;
            this.arrivingTimer = 0.0f;
            this.liquidRemoved = 0.0f;
            LandingPad.this.landSound.at(this.x, this.y, 1.0f, LandingPad.this.landSoundVolume);
            if (Vars.state.isCampaign() && !this.isFake()) {
                Vars.state.rules.sector.info.importCooldownTimers.put(this.config, 0.0f);
            }
        }

        public boolean accessible() {
            return Vars.state.rules.editor || Vars.state.rules.allowEditWorldProcessors || Vars.state.isCampaign() || Vars.state.rules.infiniteResources || this.team != Vars.state.rules.defaultTeam && !Vars.state.rules.pvp && this.team != Team.derelict;
        }

        public void updateTimers() {
            if (Vars.state.isCampaign() && lastUpdateId != Vars.state.updateId) {
                lastUpdateId = Vars.state.updateId;
                float[] imports = Vars.state.rules.sector.info.getImportRates(Vars.state.getPlanet());
                for (Item item2 : Vars.content.items()) {
                    float importedPerFrame = imports[item2.id] / 60.0f;
                    if (importedPerFrame > 0.0f) {
                        float framesBetweenArrival = (float)LandingPad.this.itemCapacity / importedPerFrame;
                        Vars.state.rules.sector.info.importCooldownTimers.increment(item2, 0.0f, 1.0f / framesBetweenArrival * Time.delta);
                        continue;
                    }
                    Vars.state.rules.sector.info.importCooldownTimers.put(item2, 0.0f);
                }
                waiting.each((item, pads) -> {
                    if (pads.size > 0) {
                        pads.sort(p -> p.priority);
                        LandingPadBuild first = (LandingPadBuild)pads.first();
                        LandingPadBuild head = (LandingPadBuild)pads.peek();
                        Call.landingPadLanded(first.tile);
                        int tmp = first.priority;
                        first.priority = head.priority;
                        head.priority = tmp;
                        pads.clear();
                    }
                });
            }
        }

        @Override
        public void draw() {
            if (LandingPad.this.consumeLiquid != null) {
                Draw.color(LandingPad.this.bottomColor);
                Fill.square(this.x, this.y, (float)(LandingPad.this.size * 8) / 2.0f - LandingPad.this.liquidPad);
                Draw.color();
                LiquidBlock.drawTiledFrames(this.block.size, this.x, this.y, LandingPad.this.liquidPad, LandingPad.this.liquidPad, LandingPad.this.liquidPad, LandingPad.this.liquidPad, LandingPad.this.consumeLiquid, this.liquids.get(LandingPad.this.consumeLiquid) / LandingPad.this.liquidCapacity);
            }
            super.draw();
            if (this.arriving != null) {
                float fin = Mathf.clamp(this.arrivingTimer);
                float fout = 1.0f - fin;
                float alpha = Interp.pow5Out.apply(fin);
                float scale = (1.0f - alpha) * 1.3f + 1.0f;
                float cx = this.x;
                float cy = this.y + Interp.pow4In.apply(fout) * (100.0f + Mathf.randomSeedRange(this.id() + 2, 30.0f));
                float rotation = fout * (90.0f + Mathf.randomSeedRange(this.id(), 50.0f));
                Draw.z(110.001f);
                Draw.color(Pal.engine);
                float rad = 0.15f + Interp.pow5Out.apply(Mathf.slope(fin));
                Fill.light(cx, cy, 10, 25.0f * (rad + scale - 1.0f), Tmp.c2.set(Pal.engine).a(alpha), Tmp.c1.set(Pal.engine).a(0.0f));
                Draw.alpha(alpha);
                for (int i = 0; i < 4; ++i) {
                    Drawf.tri(cx, cy, 6.0f, 40.0f * (rad + scale - 1.0f), (float)i * 90.0f + rotation);
                }
                Draw.color();
                Draw.z(129.0f);
                float rw = (float)LandingPad.this.podRegion.width * (scale *= LandingPad.this.podRegion.scl());
                float rh = (float)LandingPad.this.podRegion.height * scale;
                Draw.alpha(alpha);
                Drawf.shadow(cx, cy, (float)(LandingPad.this.size * 8), fin);
                Draw.rect(LandingPad.this.podRegion, cx, cy, rw, rh, rotation);
                Tmp.v1.trns(225.0f, Interp.pow3In.apply(fout) * 250.0f);
                Draw.z(116.0f);
                Draw.color(0.0f, 0.0f, 0.0f, 0.22f * alpha);
                Draw.rect(LandingPad.this.podRegion, cx + Tmp.v1.x, cy + Tmp.v1.y, rw, rh, rotation);
            } else if (this.cooldown > 0.0f) {
                Drawf.shadow(this.x, this.y, (float)(LandingPad.this.size * 8), this.cooldown);
                Draw.alpha(this.cooldown);
                Draw.mixcol(Pal.accent, 1.0f - this.cooldown);
                Draw.rect(LandingPad.this.podRegion, this.x, this.y);
            }
            Draw.reset();
        }

        @Override
        public void drawLight() {
            Drawf.light(this.x, this.y, LandingPad.this.lightRadius, Pal.accent, Mathf.clamp(Math.max(this.cooldown, this.arrivingTimer * 1.5f)));
        }

        @Override
        public void updateTile() {
            this.updateTimers();
            if (this.arriving != null) {
                if (!Vars.headless) {
                    float fin = this.arrivingTimer;
                    float tsize = Interp.pow5Out.apply(fin);
                    this.landParticleTimer += tsize * Time.delta / 2.0f;
                    if (this.landParticleTimer >= 1.0f) {
                        this.tile.getLinkedTiles(t -> {
                            if (Mathf.chance(0.1f)) {
                                Fx.podLandDust.at(t.worldx(), t.worldy(), this.angleTo(t.worldx(), t.worldy()) + Mathf.range(30.0f), Tmp.c1.set(t.floor().mapColor).mul(1.5f + Mathf.range(0.15f)));
                            }
                        });
                        this.landParticleTimer = 0.0f;
                    }
                }
                this.arrivingTimer += Time.delta / LandingPad.this.arrivalDuration;
                float toRemove = Math.min(LandingPad.this.consumeLiquidAmount / LandingPad.this.arrivalDuration * Time.delta, LandingPad.this.consumeLiquidAmount - this.liquidRemoved);
                this.liquidRemoved += toRemove;
                this.liquids.remove(LandingPad.this.consumeLiquid, toRemove);
                if (Mathf.chanceDelta(LandingPad.this.coolingEffectChance * Interp.pow5Out.apply(this.arrivingTimer))) {
                    LandingPad.this.coolingEffect.at(this);
                }
                if (this.arrivingTimer >= 1.0f) {
                    this.liquids.remove(LandingPad.this.consumeLiquid, LandingPad.this.consumeLiquidAmount - this.liquidRemoved);
                    LandingPad.this.landEffect.at(this);
                    Effect.shake(3.0f, 3.0f, this);
                    this.items.set(this.arriving, LandingPad.this.itemCapacity);
                    if (!this.isFake()) {
                        this.produced(this.arriving, LandingPad.this.itemCapacity);
                        Vars.state.getSector().info.handleItemImport(this.arriving, LandingPad.this.itemCapacity);
                    }
                    this.arriving = null;
                    this.arrivingTimer = 0.0f;
                }
            }
            if (this.items.total() > 0) {
                this.dumpAccumulate(this.config == null || this.items.get(this.config) != this.items.total() ? null : this.config);
            }
            if (this.arriving == null) {
                this.cooldown -= this.delta() / LandingPad.this.cooldownTime;
                this.cooldown = Mathf.clamp(this.cooldown);
            }
            if (this.config != null && (this.isFake() || Vars.state.isCampaign() && !Vars.state.getPlanet().campaignRules.legacyLaunchPads) && this.cooldown <= 0.0f && this.efficiency > 0.0f && this.items.total() == 0 && (this.isFake() || Vars.state.rules.sector.info.getImportRate(Vars.state.getPlanet(), this.config) > 0.0f && Vars.state.rules.sector.info.importCooldownTimers.get(this.config, 0.0f) >= 1.0f)) {
                if (this.isFake()) {
                    Call.landingPadLanded(this.tile);
                } else {
                    ((Seq)((Object)waiting.get(this.config, (Seq<LandingPadBuild>)((Object)((Prov<Seq>)Seq::new))))).add(this);
                }
            }
        }

        public boolean isFake() {
            return this.team != Vars.state.rules.defaultTeam || !Vars.state.isCampaign();
        }

        @Override
        public void drawSelect() {
            this.drawItemSelection(this.config);
        }

        @Override
        public Graphics.Cursor getCursor() {
            return !this.accessible() ? Graphics.Cursor.SystemCursor.arrow : super.getCursor();
        }

        @Override
        public boolean shouldShowConfigure(Player player) {
            return this.accessible();
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (this == other || !this.accessible()) {
                this.deselect();
                return false;
            }
            return super.onConfigureBuildTapped(other);
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(LandingPad.this, table, Vars.content.items(), () -> this.config, this::configure, LandingPad.this.selectionRows, LandingPad.this.selectionColumns);
            if (!Vars.net.client() && !this.isFake()) {
                table.row();
                table.table(t -> {
                    t.background(Styles.black6);
                    t.button(Icon.downOpen, Styles.clearNonei, 40.0f, () -> {
                        if (this.config == null || !Vars.state.isCampaign()) {
                            return;
                        }
                        for (Sector sector : Vars.state.getPlanet().sectors) {
                            if (!this.canRedirectExports(sector)) continue;
                            sector.info.destination = Vars.state.getSector();
                            sector.saveInfo();
                        }
                        Vars.state.getSector().info.refreshImportRates(Vars.state.getPlanet());
                    }).disabled(button -> this.config == null || !Vars.state.isCampaign() || !Vars.state.getPlanet().sectors.contains((Sector)((Object)((Boolf<Sector>)this::canRedirectExports)))).tooltip("@sectors.redirect").get();
                }).fillX().left();
            }
        }

        private boolean canRedirectExports(Sector sector) {
            return sector.hasBase() && sector != Vars.state.getSector() && sector.info.hasExport(this.config) && sector.info.destination != Vars.state.getSector();
        }

        @Override
        public void display(Table table) {
            super.display(table);
            if (!Vars.state.isCampaign() || Vars.net.client() || this.team != Vars.player.team() || this.isFake()) {
                return;
            }
            table.row();
            table.label(() -> {
                if (!Vars.state.isCampaign() || this.isFake()) {
                    return "";
                }
                if (Vars.state.getPlanet().campaignRules.legacyLaunchPads) {
                    return Core.bundle.get("landingpad.legacy.disabled");
                }
                if (this.config == null) {
                    return "";
                }
                int sources = 0;
                float perSecond = 0.0f;
                for (Sector otherSector : Vars.state.getPlanet().sectors) {
                    float amount;
                    if (otherSector == Vars.state.getSector() || !otherSector.hasBase() || otherSector.info.destination != Vars.state.getSector() || (amount = otherSector.info.getExport(this.config)) <= 0.0f) continue;
                    ++sources;
                    perSecond += amount;
                }
                String str = Core.bundle.format("landing.sources", sources == 0 ? Core.bundle.get("none") : Integer.valueOf(sources));
                if (perSecond > 0.0f) {
                    str = str + "\n" + Core.bundle.format("landing.import", this.config.emoji(), (int)(perSecond * 60.0f));
                }
                return str;
            }).pad(4.0f).wrap().width(200.0f).left();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        @Nullable
        public Object config() {
            return this.config;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.config = TypeIO.readItem(read);
            this.priority = read.i();
            this.cooldown = read.f();
            if (revision >= 1) {
                this.arriving = TypeIO.readItem(read);
                this.arrivingTimer = read.f();
                this.liquidRemoved = read.f();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            TypeIO.writeItem(write, this.config);
            write.i(this.priority);
            write.f(this.cooldown);
            TypeIO.writeItem(write, this.arriving);
            write.f(this.arrivingTimer);
            write.f(this.liquidRemoved);
        }
    }
}

