/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.world.Block;

public class ItemSelection {
    private static TextField search;
    private static int rowCount;

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer) {
        ItemSelection.buildTable(table, items, holder, consumer, true);
    }

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, boolean closeSelect) {
        ItemSelection.buildTable(null, table, items, holder, consumer, closeSelect, 5, 4);
    }

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, int columns) {
        ItemSelection.buildTable(null, table, items, holder, consumer, true, 5, columns);
    }

    public static <T extends UnlockableContent> void buildTable(Block block, Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer) {
        ItemSelection.buildTable(block, table, items, holder, consumer, true, 5, 4);
    }

    public static <T extends UnlockableContent> void buildTable(Block block, Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, boolean closeSelect) {
        ItemSelection.buildTable(block, table, items, holder, consumer, closeSelect, 5, 4);
    }

    public static <T extends UnlockableContent> void buildTable(Block block, Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, int rows, int columns) {
        ItemSelection.buildTable(block, table, items, holder, consumer, true, rows, columns);
    }

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, int rows, int columns) {
        ItemSelection.buildTable(null, table, items, holder, consumer, true, rows, columns);
    }

    public static <T extends UnlockableContent> void buildTable(@Nullable Block block, Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, boolean closeSelect, int rows, int columns) {
        ButtonGroup group = new ButtonGroup();
        group.setMinCheckCount(0);
        Table cont = new Table().top();
        cont.defaults().size(40.0f);
        if (search != null) {
            search.clearText();
        }
        Runnable rebuild = () -> {
            group.clear();
            cont.clearChildren();
            String text = search != null ? search.getText() : "";
            int i = 0;
            rowCount = 0;
            Seq<UnlockableContent> list = items.select(u -> text.isEmpty() || u.localizedName.toLowerCase().contains(text.toLowerCase()));
            for (UnlockableContent item : list) {
                if (!item.unlockedNow() || !item.isOnPlanet(Vars.state.getPlanet()) || item.isHidden()) continue;
                ImageButton button = cont.button(Tex.whiteui, Styles.clearNoneTogglei, Mathf.clamp(item.selectionSize, 0.0f, 40.0f), () -> {
                    if (closeSelect) {
                        Vars.control.input.config.hideConfig();
                    }
                }).tooltip(item.localizedName).group(group).get();
                button.changed(() -> consumer.get(button.isChecked() ? item : null));
                button.getStyle().imageUp = new TextureRegionDrawable(item.uiIcon);
                button.update(() -> button.setChecked(holder.get() == item));
                if (i++ % columns != columns - 1) continue;
                cont.row();
                ++rowCount;
            }
        };
        rebuild.run();
        Table main = new Table().background(Styles.black6);
        if ((float)rowCount > (float)rows * 1.5f) {
            main.table(s -> {
                s.image(Icon.zoom).padLeft(4.0f);
                search = s.field(null, text -> rebuild.run()).padBottom(4.0f).left().growX().get();
                search.setMessageText("@players.search");
            }).fillX().row();
        }
        ScrollPane pane = new ScrollPane((Element)cont, Styles.smallPane);
        pane.setScrollingDisabled(true, false);
        pane.exited(() -> {
            if (pane.hasScroll()) {
                Core.scene.setScrollFocus(null);
            }
        });
        if (block != null) {
            pane.setScrollYForce(block.selectScroll);
            pane.update(() -> {
                block.selectScroll = pane.getScrollY();
            });
        }
        pane.setOverscroll(false, false);
        main.add(pane).maxHeight(40 * rows);
        table.top().add(main);
    }
}

