/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.weapons;

import mindustry.entities.units.WeaponMount;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;

public class PointDefenseBulletWeapon
extends Weapon {
    public float damageTargetWeight = 10.0f;

    public PointDefenseBulletWeapon(String name) {
        super(name);
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.useAmmo = false;
        this.useAttackRange = false;
        this.targetSwitchInterval = 5.0f;
        this.targetInterval = 5.0f;
    }

    public PointDefenseBulletWeapon() {
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.useAmmo = false;
        this.useAttackRange = false;
        this.targetSwitchInterval = 5.0f;
        this.targetInterval = 5.0f;
    }

    @Override
    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        return Groups.bullet.intersect(x - range, y - range, range * 2.0f, range * 2.0f).min(b -> b.team != unit.team && b.type().hittable && (!b.type.collidesAir || b.type.collidesTiles), b -> b.dst2(x, y) - b.damage * this.damageTargetWeight);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        if (!target.within(unit, range)) return true;
        if (target.team() == unit.team) return true;
        if (!(target instanceof Bullet)) return true;
        Bullet b = (Bullet)target;
        if (b.type == null) return true;
        if (!b.type.hittable) return true;
        return false;
    }

    @Override
    protected void handleBullet(Unit unit, WeaponMount mount, Bullet bullet) {
        super.handleBullet(unit, mount, bullet);
        Teamc teamc = mount.target;
        if (teamc instanceof Bullet) {
            Bullet b = (Bullet)teamc;
            bullet.data = b;
        }
    }
}

