/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.struct.ObjectMap;
import arc.struct.StringMap;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import java.util.Locale;

public class MapLocales
extends ObjectMap<String, StringMap>
implements Json.JsonSerializable {
    @Override
    public void write(Json json) {
        for (ObjectMap.Entry entry : this.entries()) {
            json.writeValue((String)entry.key, entry.value, StringMap.class, String.class);
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        for (JsonValue value : jsonData) {
            StringMap map = new StringMap();
            JsonValue child = value.child;
            while (child != null) {
                map.put(child.name, json.readValue(String.class, null, child));
                child = child.next;
            }
            this.put(value.name, map);
        }
    }

    public MapLocales copy() {
        MapLocales out = new MapLocales();
        for (ObjectMap.Entry entry : this.entries()) {
            StringMap map = new StringMap();
            map.putAll((ObjectMap)entry.value);
            out.put((String)entry.key, map);
        }
        return out;
    }

    public String getProperty(String key) {
        if (!this.containsProperty(MapLocales.currentLocale(), key)) {
            if (this.containsProperty("en", key)) {
                return (String)((StringMap)this.get("en")).get(key);
            }
            if (Core.bundle.has(key)) {
                return Core.bundle.get(key);
            }
            return "???" + key + "???";
        }
        return (String)((StringMap)this.get(MapLocales.currentLocale())).get(key);
    }

    private String getProperty(String locale, String key) {
        if (!this.containsProperty(locale, key)) {
            if (this.containsProperty("en", key)) {
                return (String)((StringMap)this.get("en")).get(key);
            }
            return "???" + key + "???";
        }
        return (String)((StringMap)this.get(locale)).get(key);
    }

    public boolean containsProperty(String key) {
        return this.containsProperty(MapLocales.currentLocale(), key) || this.containsProperty("en", key);
    }

    private boolean containsProperty(String locale, String key) {
        if (!this.containsKey(locale)) {
            return false;
        }
        return ((StringMap)this.get(locale)).containsKey(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getFormatted(String key, Object ... args) {
        StringBuilder result = new StringBuilder();
        if (!this.containsProperty(MapLocales.currentLocale(), key)) {
            if (!this.containsProperty("en", key)) return "???" + key + "???";
            result.append(this.getProperty("en", key));
        } else {
            result.append(this.getProperty(MapLocales.currentLocale(), key));
        }
        for (Object arg : args) {
            int placeholderIndex = result.indexOf("@");
            if (placeholderIndex == -1) return result.toString();
            result.replace(placeholderIndex, placeholderIndex + 1, arg.toString());
        }
        return result.toString();
    }

    public static String currentLocale() {
        String locale = Core.settings.getString("locale");
        if (locale.equals("default")) {
            locale = Locale.getDefault().getLanguage();
        }
        return locale;
    }
}

