/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.struct.Seq;
import mindustry.content.Liquids;
import mindustry.type.Liquid;

public class LiquidStack
implements Comparable<LiquidStack> {
    public static final LiquidStack[] empty = new LiquidStack[0];
    public Liquid liquid;
    public float amount;

    public LiquidStack(Liquid liquid, float amount) {
        this.liquid = liquid;
        this.amount = amount;
    }

    protected LiquidStack() {
        this.liquid = Liquids.water;
    }

    public LiquidStack set(Liquid liquid, float amount) {
        this.liquid = liquid;
        this.amount = amount;
        return this;
    }

    public LiquidStack copy() {
        return new LiquidStack(this.liquid, this.amount);
    }

    public boolean equals(LiquidStack other) {
        return other != null && other.liquid == this.liquid && other.amount == this.amount;
    }

    public static LiquidStack[] mult(LiquidStack[] stacks, float amount) {
        LiquidStack[] copy = new LiquidStack[stacks.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new LiquidStack(stacks[i].liquid, stacks[i].amount * amount);
        }
        return copy;
    }

    public static LiquidStack[] with(Object ... items) {
        LiquidStack[] stacks = new LiquidStack[items.length / 2];
        for (int i = 0; i < items.length; i += 2) {
            stacks[i / 2] = new LiquidStack((Liquid)items[i], ((Number)items[i + 1]).floatValue());
        }
        return stacks;
    }

    public static Seq<LiquidStack> list(Object ... items) {
        Seq<LiquidStack> stacks = new Seq<LiquidStack>(items.length / 2);
        for (int i = 0; i < items.length; i += 2) {
            stacks.add(new LiquidStack((Liquid)items[i], ((Number)items[i + 1]).floatValue()));
        }
        return stacks;
    }

    @Override
    public int compareTo(LiquidStack liquidStack) {
        return this.liquid.compareTo(liquidStack.liquid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiquidStack)) {
            return false;
        }
        LiquidStack stack = (LiquidStack)o;
        return this.amount == stack.amount && this.liquid == stack.liquid;
    }

    public String toString() {
        return "LiquidStack{liquid=" + this.liquid + ", amount=" + this.amount + '}';
    }
}

