/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import mindustry.net.Net;
import mindustry.net.Packet;
import mindustry.net.Packets;

public class Streamable
extends Packet {
    public transient ByteArrayInputStream stream;

    @Override
    public int getPriority() {
        return 2;
    }

    public static class StreamBuilder {
        public final int id;
        public final byte type;
        public final int total;
        public final ByteArrayOutputStream stream = new ByteArrayOutputStream();

        public StreamBuilder(Packets.StreamBegin begin) {
            this.id = begin.id;
            this.type = begin.type;
            this.total = begin.total;
        }

        public float progress() {
            return (float)this.stream.size() / (float)this.total;
        }

        public void add(byte[] bytes) {
            try {
                this.stream.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Streamable build() {
            Streamable s = (Streamable)Net.newPacket(this.type);
            s.stream = new ByteArrayInputStream(this.stream.toByteArray());
            return s;
        }

        public boolean isDone() {
            return this.stream.size() >= this.total;
        }
    }
}

