/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Gamemode;
import mindustry.game.Rules;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.io.JsonIO;
import mindustry.io.SaveIO;
import mindustry.logic.GlobalVars;
import mindustry.maps.Map;
import mindustry.net.Administration;
import mindustry.net.Host;
import mindustry.type.MapLocales;

public class NetworkIO {
    public static void writeWorld(Player player, OutputStream os) {
        try (DataOutputStream stream = new DataOutputStream(os);){
            if (Vars.state.isCampaign()) {
                Vars.state.rules.researched.clear();
                for (ContentType type : ContentType.all) {
                    for (Content c : Vars.content.getBy(type)) {
                        UnlockableContent u;
                        if (!(c instanceof UnlockableContent) || !(u = (UnlockableContent)c).unlocked() || u.techNode == null) continue;
                        Vars.state.rules.researched.add(u);
                    }
                }
            }
            stream.writeUTF(JsonIO.write(Vars.state.rules));
            stream.writeUTF(JsonIO.write(Vars.state.mapLocales));
            SaveIO.getSaveWriter().writeStringMap(stream, Vars.state.map.tags);
            stream.writeInt(Vars.state.wave);
            stream.writeFloat(Vars.state.wavetime);
            stream.writeDouble(Vars.state.tick);
            stream.writeLong(GlobalVars.rand.seed0);
            stream.writeLong(GlobalVars.rand.seed1);
            stream.writeInt(player.id);
            player.write(new Writes(stream));
            SaveIO.getSaveWriter().writeContentHeader(stream);
            SaveIO.getSaveWriter().writeContentPatches(stream);
            SaveIO.getSaveWriter().writeMap(stream);
            SaveIO.getSaveWriter().writeTeamBlocks(stream);
            SaveIO.getSaveWriter().writeMarkers(stream);
            SaveIO.getSaveWriter().writeCustomChunks(stream, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadWorld(InputStream is) {
        try (DataInputStream stream = new DataInputStream(is);){
            Time.clear();
            Vars.state.rules = JsonIO.read(Rules.class, stream.readUTF());
            Vars.state.mapLocales = JsonIO.read(MapLocales.class, stream.readUTF());
            Vars.state.map = new Map(SaveIO.getSaveWriter().readStringMap(stream));
            Vars.state.wave = stream.readInt();
            Vars.state.wavetime = stream.readFloat();
            Vars.state.tick = stream.readDouble();
            GlobalVars.rand.seed0 = stream.readLong();
            GlobalVars.rand.seed1 = stream.readLong();
            Reads read = new Reads(stream);
            Groups.clear();
            int id = stream.readInt();
            Vars.player.reset();
            Vars.player.read(read);
            Vars.player.id = id;
            Vars.player.add();
            SaveIO.getSaveWriter().readContentHeader(stream);
            SaveIO.getSaveWriter().readContentPatches(stream);
            SaveIO.getSaveWriter().readMap(stream, Vars.world.context);
            SaveIO.getSaveWriter().readTeamBlocks(stream);
            SaveIO.getSaveWriter().readMarkers(stream);
            SaveIO.getSaveWriter().readCustomChunks(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Vars.content.setTemporaryMapper(null);
        }
    }

    public static ByteBuffer writeServerData() {
        String name = Vars.headless ? Administration.Config.serverName.string() : Vars.player.name;
        String description = Vars.headless && !Administration.Config.desc.string().equals("off") ? Administration.Config.desc.string() : "";
        String map = Vars.state.map.name();
        ByteBuffer buffer = ByteBuffer.allocate(500);
        NetworkIO.writeString(buffer, name, 100);
        NetworkIO.writeString(buffer, map, 64);
        buffer.putInt(Core.settings.getInt("totalPlayers", Groups.player.size()));
        buffer.putInt(Vars.state.wave);
        buffer.putInt(Version.build);
        NetworkIO.writeString(buffer, Version.type);
        buffer.put((byte)Vars.state.rules.mode().ordinal());
        buffer.putInt(Vars.netServer.admins.getPlayerLimit());
        NetworkIO.writeString(buffer, description, 100);
        NetworkIO.writeString(buffer, Vars.state.rules.modeName == null ? "" : Vars.state.rules.modeName, 50);
        buffer.putShort((short)Core.settings.getInt("port", 6567));
        return buffer;
    }

    public static Host readServerData(int ping, String hostAddress, ByteBuffer buffer) {
        String host = NetworkIO.readString(buffer);
        String map = NetworkIO.readString(buffer);
        int players = buffer.getInt();
        int wave = buffer.getInt();
        int version = buffer.getInt();
        String vertype = NetworkIO.readString(buffer);
        byte mode = buffer.get();
        Gamemode gamemode = Gamemode.all[mode < Gamemode.all.length ? mode : (byte)0];
        int limit = buffer.getInt();
        String description = NetworkIO.readString(buffer);
        String modeName = NetworkIO.readString(buffer);
        int port = buffer.getShort();
        int hostPort = port != 0 ? port : 6567;
        return new Host(ping, host, hostAddress, hostPort, map, wave, players, version, vertype, gamemode, limit, description, modeName.isEmpty() ? null : modeName);
    }

    private static void writeString(ByteBuffer buffer, String string, int maxlen) {
        byte[] bytes = string.getBytes(Vars.charset);
        if (bytes.length > maxlen) {
            bytes = Arrays.copyOfRange(bytes, 0, maxlen);
        }
        buffer.put((byte)bytes.length);
        buffer.put(bytes);
    }

    private static void writeString(ByteBuffer buffer, String string) {
        NetworkIO.writeString(buffer, string, 32);
    }

    private static String readString(ByteBuffer buffer) {
        short length = (short)(buffer.get() & 0xFF);
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, Vars.charset);
    }
}

