/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.files.Fi;
import arc.math.geom.Geometry;
import arc.struct.Seq;
import java.util.Objects;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.game.Schematics;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.generators.WorldGenerator;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;
import mindustry.world.WorldParams;
import mindustry.world.blocks.storage.CoreBlock;

public class FileMapGenerator
implements WorldGenerator {
    public final Map map;
    public final SectorPreset preset;

    public FileMapGenerator(String mapName, SectorPreset preset) {
        if (Vars.maps == null) {
            this.map = null;
        } else {
            String fileName;
            Seq<String> candidates = new Seq<String>(4);
            candidates.add(preset.planet.name + "/" + mapName);
            candidates.add(mapName);
            if (preset.minfo.mod != null) {
                String baseName = mapName.substring(1 + preset.minfo.mod.name.length());
                candidates.add(preset.planet.name + "/" + baseName);
                candidates.add(baseName);
            }
            this.map = Vars.maps.loadInternalMap((fileName = candidates.find(name -> Vars.tree.get("maps/" + name + "." + "msav").exists())) == null ? (String)candidates.first() : fileName);
        }
        this.preset = preset;
    }

    public FileMapGenerator(Map map, SectorPreset preset) {
        this.map = map;
        this.preset = preset;
    }

    public FileMapGenerator(SectorPreset preset) {
        this(Vars.emptyMap, preset);
    }

    @Override
    public void generate(Tiles tiles, WorldParams params) {
        if (this.map == null) {
            throw new RuntimeException("Generator has null map, cannot be used.");
        }
        final Sector sector = Vars.state.rules.sector;
        Vars.world.setGenerating(false);
        Fi fi = this.map.file;
        World world = Vars.world;
        Objects.requireNonNull(world);
        SaveIO.load(fi, (WorldContext)new World.FilterContext(world, this.map){
            {
                World world = x0;
                Objects.requireNonNull(world);
                super(map);
            }

            @Override
            public Sector getSector() {
                return sector;
            }

            @Override
            public void end() {
                this.applyFilters();
            }

            @Override
            public boolean isMap() {
                return true;
            }
        });
        Vars.world.setGenerating(true);
        if (sector != null) {
            Vars.state.rules.sector = sector;
        }
        tiles = Vars.world.tiles;
        boolean anyCores = false;
        Block coreTypeToUse = Vars.state.rules.defaultTeam.cores().isEmpty() ? sector.planet.defaultCore : Vars.state.rules.defaultTeam.core().block;
        for (Tile tile : tiles) {
            if (tile.overlay() == Blocks.spawn) {
                int rad = 10;
                Geometry.circle(tile.x, tile.y, tiles.width, tiles.height, rad, (wx, wy) -> {
                    if (tile.overlay().itemDrop != null) {
                        tile.clearOverlay();
                    }
                });
            }
            if (params.corePositionOverride != 0 && sector != null) {
                if (tile.pos() == params.corePositionOverride) {
                    if (sector.allowLaunchLoadout()) {
                        Schematics.placeLaunchLoadout(tile.x, tile.y);
                    } else {
                        tile.setBlock(coreTypeToUse, Vars.state.rules.defaultTeam, 0);
                    }
                    anyCores = true;
                    if (!this.preset.addStartingItems && this.preset.planet.allowLaunchLoadout) continue;
                    tile.build.items.clear();
                    tile.build.items.add(Vars.state.rules.loadout);
                    continue;
                }
                if (!(tile.build instanceof CoreBlock.CoreBuild) || tile.team() != Vars.state.rules.defaultTeam || tile.build.pos() == params.corePositionOverride) continue;
                tile.remove();
                continue;
            }
            if (!tile.isCenter() || !(tile.block() instanceof CoreBlock) || tile.team() != Vars.state.rules.defaultTeam || anyCores) continue;
            if (sector != null && sector.allowLaunchLoadout()) {
                Schematics.placeLaunchLoadout(tile.x, tile.y);
            }
            anyCores = true;
            if (!this.preset.addStartingItems && this.preset.planet.allowLaunchLoadout) continue;
            tile.build.items.clear();
            tile.build.items.add(Vars.state.rules.loadout);
        }
        if (!anyCores) {
            throw new IllegalArgumentException("All maps must have a core.");
        }
        Vars.state.map = this.map;
    }
}

