/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.struct.IntSeq;
import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;
import mindustry.world.Tiles;

public class EnemySpawnFilter
extends GenerateFilter {
    public int amount = 1;

    @Override
    public FilterOption[] options() {
        return new FilterOption.SliderOption[]{new FilterOption.SliderOption("amount", () -> this.amount, f -> {
            this.amount = (int)f;
        }, 1.0f, 10.0f).display()};
    }

    @Override
    public char icon() {
        return '\uf8ff';
    }

    @Override
    public void apply(Tiles tiles, GenerateFilter.GenerateInput in) {
        int used;
        IntSeq spawns = new IntSeq();
        for (Tile tile : tiles) {
            if (tile.overlay() != Blocks.spawn) continue;
            spawns.add(tile.pos());
        }
        spawns.shuffle();
        for (int i = used = Math.min(spawns.size, this.amount); i < spawns.size; ++i) {
            Tile tile = tiles.getp(spawns.get(i));
            tile.clearOverlay();
        }
    }

    @Override
    public boolean isPost() {
        return true;
    }
}

