/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Cubemap;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.util.Disposable;

public class CubemapMesh
implements Disposable {
    private static final float[] vertices = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    private final Mesh mesh;
    private final Shader shader;
    private Cubemap map;

    public CubemapMesh(Cubemap map) {
        this.map = map;
        this.map.setFilter(Texture.TextureFilter.linear);
        this.mesh = new Mesh(true, vertices.length, 0, VertexAttribute.position3);
        this.mesh.getVerticesBuffer().limit(vertices.length);
        this.mesh.getVerticesBuffer().put(vertices, 0, vertices.length);
        this.shader = new Shader(Core.files.internal("shaders/cubemap.vert"), Core.files.internal("shaders/cubemap.frag"));
    }

    public void setCubemap(Cubemap map) {
        this.map = map;
    }

    public void render(Mat3D projection) {
        this.map.bind();
        this.shader.bind();
        this.shader.setUniformi("u_cubemap", 0);
        this.shader.setUniformMatrix4("u_proj", projection.val);
        this.mesh.render(this.shader, 4);
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        this.map.dispose();
    }
}

