/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.func.Intc;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.game.SpawnGroup;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;

public class Waves {
    public static final int waveVersion = 7;
    private Seq<SpawnGroup> spawns;

    public Seq<SpawnGroup> get() {
        if (this.spawns == null && UnitTypes.dagger != null) {
            this.spawns = Seq.with(new SpawnGroup(UnitTypes.dagger){
                {
                    this.end = 10;
                    this.unitScaling = 2.0f;
                    this.max = 30;
                }
            }, new SpawnGroup(UnitTypes.crawler){
                {
                    this.begin = 4;
                    this.end = 13;
                    this.unitAmount = 2;
                    this.unitScaling = 1.5f;
                }
            }, new SpawnGroup(UnitTypes.flare){
                {
                    this.begin = 12;
                    this.end = 16;
                    this.unitScaling = 1.0f;
                }
            }, new SpawnGroup(UnitTypes.dagger){
                {
                    this.begin = 11;
                    this.unitScaling = 1.7f;
                    this.spacing = 2;
                    this.max = 4;
                    this.shieldScaling = 25.0f;
                }
            }, new SpawnGroup(UnitTypes.pulsar){
                {
                    this.begin = 13;
                    this.spacing = 3;
                    this.unitScaling = 0.5f;
                    this.max = 25;
                }
            }, new SpawnGroup(UnitTypes.mace){
                {
                    this.begin = 7;
                    this.spacing = 3;
                    this.unitScaling = 2.0f;
                    this.end = 30;
                }
            }, new SpawnGroup(UnitTypes.dagger){
                {
                    this.begin = 12;
                    this.unitScaling = 1.0f;
                    this.unitAmount = 4;
                    this.spacing = 2;
                    this.shieldScaling = 20.0f;
                    this.max = 14;
                }
            }, new SpawnGroup(UnitTypes.mace){
                {
                    this.begin = 28;
                    this.spacing = 3;
                    this.unitScaling = 1.0f;
                    this.end = 40;
                    this.shieldScaling = 20.0f;
                }
            }, new SpawnGroup(UnitTypes.spiroct){
                {
                    this.begin = 45;
                    this.spacing = 3;
                    this.unitScaling = 1.0f;
                    this.max = 10;
                    this.shieldScaling = 30.0f;
                    this.shields = 100.0f;
                    this.effect = StatusEffects.overdrive;
                }
            }, new SpawnGroup(UnitTypes.pulsar){
                {
                    this.begin = 120;
                    this.spacing = 2;
                    this.unitScaling = 3.0f;
                    this.unitAmount = 5;
                    this.effect = StatusEffects.overdrive;
                }
            }, new SpawnGroup(UnitTypes.flare){
                {
                    this.begin = 16;
                    this.unitScaling = 1.0f;
                    this.spacing = 2;
                    this.shieldScaling = 20.0f;
                    this.max = 20;
                }
            }, new SpawnGroup(UnitTypes.quasar){
                {
                    this.begin = 82;
                    this.spacing = 3;
                    this.unitAmount = 4;
                    this.unitScaling = 3.0f;
                    this.shieldScaling = 30.0f;
                    this.effect = StatusEffects.overdrive;
                }
            }, new SpawnGroup(UnitTypes.pulsar){
                {
                    this.begin = 41;
                    this.spacing = 5;
                    this.unitAmount = 1;
                    this.unitScaling = 3.0f;
                    this.shields = 640.0f;
                    this.max = 25;
                }
            }, new SpawnGroup(UnitTypes.fortress){
                {
                    this.begin = 40;
                    this.spacing = 5;
                    this.unitAmount = 2;
                    this.unitScaling = 2.0f;
                    this.max = 20;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.nova){
                {
                    this.begin = 35;
                    this.spacing = 3;
                    this.unitAmount = 4;
                    this.effect = StatusEffects.overdrive;
                    this.items = new ItemStack(Items.blastCompound, 60);
                    this.end = 60;
                }
            }, new SpawnGroup(UnitTypes.dagger){
                {
                    this.begin = 42;
                    this.spacing = 3;
                    this.unitAmount = 4;
                    this.effect = StatusEffects.overdrive;
                    this.items = new ItemStack(Items.pyratite, 100);
                    this.end = 130;
                    this.max = 30;
                }
            }, new SpawnGroup(UnitTypes.horizon){
                {
                    this.begin = 40;
                    this.unitAmount = 2;
                    this.spacing = 2;
                    this.unitScaling = 2.0f;
                    this.shieldScaling = 20.0f;
                }
            }, new SpawnGroup(UnitTypes.flare){
                {
                    this.begin = 50;
                    this.unitAmount = 4;
                    this.unitScaling = 3.0f;
                    this.spacing = 5;
                    this.shields = 100.0f;
                    this.shieldScaling = 10.0f;
                    this.effect = StatusEffects.overdrive;
                    this.max = 20;
                }
            }, new SpawnGroup(UnitTypes.zenith){
                {
                    this.begin = 50;
                    this.unitAmount = 2;
                    this.unitScaling = 3.0f;
                    this.spacing = 5;
                    this.max = 16;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.nova){
                {
                    this.begin = 53;
                    this.unitAmount = 2;
                    this.unitScaling = 3.0f;
                    this.spacing = 4;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.atrax){
                {
                    this.begin = 31;
                    this.unitAmount = 4;
                    this.unitScaling = 1.0f;
                    this.spacing = 3;
                    this.shieldScaling = 10.0f;
                }
            }, new SpawnGroup(UnitTypes.scepter){
                {
                    this.begin = 41;
                    this.unitAmount = 1;
                    this.unitScaling = 1.0f;
                    this.spacing = 30;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.reign){
                {
                    this.begin = 81;
                    this.unitAmount = 1;
                    this.unitScaling = 1.0f;
                    this.spacing = 40;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.antumbra){
                {
                    this.begin = 120;
                    this.unitAmount = 1;
                    this.unitScaling = 1.0f;
                    this.spacing = 40;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.vela){
                {
                    this.begin = 100;
                    this.unitAmount = 1;
                    this.unitScaling = 1.0f;
                    this.spacing = 30;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.corvus){
                {
                    this.begin = 145;
                    this.unitAmount = 1;
                    this.unitScaling = 1.0f;
                    this.spacing = 35;
                    this.shieldScaling = 30.0f;
                    this.shields = 100.0f;
                }
            }, new SpawnGroup(UnitTypes.horizon){
                {
                    this.begin = 90;
                    this.unitAmount = 2;
                    this.unitScaling = 3.0f;
                    this.spacing = 4;
                    this.shields = 40.0f;
                    this.shieldScaling = 30.0f;
                }
            }, new SpawnGroup(UnitTypes.toxopid){
                {
                    this.begin = 210;
                    this.unitAmount = 1;
                    this.unitScaling = 1.0f;
                    this.spacing = 35;
                    this.shields = 1000.0f;
                    this.shieldScaling = 35.0f;
                }
            });
        }
        return this.spawns == null ? new Seq<SpawnGroup>() : this.spawns;
    }

    public static Seq<SpawnGroup> generate(float difficulty) {
        return Waves.generate(Mathf.pow(difficulty, 1.12f), new Rand(), false);
    }

    public static Seq<SpawnGroup> generate(float difficulty, Rand rand, boolean attack) {
        return Waves.generate(difficulty, rand, attack, false);
    }

    public static Seq<SpawnGroup> generate(float difficulty, Rand rand, boolean attack, boolean airOnly) {
        return Waves.generate(difficulty, rand, attack, airOnly, false);
    }

    public static Seq<SpawnGroup> generate(final float difficulty, final Rand rand, boolean attack, boolean airOnly, boolean naval) {
        UnitType[][] species = new UnitType[][]{{UnitTypes.dagger, UnitTypes.mace, UnitTypes.fortress, UnitTypes.scepter, UnitTypes.reign}, {UnitTypes.nova, UnitTypes.pulsar, UnitTypes.quasar, UnitTypes.vela, UnitTypes.corvus}, {UnitTypes.crawler, UnitTypes.atrax, UnitTypes.spiroct, UnitTypes.arkyid, UnitTypes.toxopid}, {UnitTypes.risso, UnitTypes.minke, UnitTypes.bryde, UnitTypes.sei, UnitTypes.omura}, {UnitTypes.retusa, UnitTypes.oxynoe, UnitTypes.cyerce, UnitTypes.aegires, UnitTypes.navanax}, {UnitTypes.flare, UnitTypes.horizon, UnitTypes.zenith, rand.chance(0.5) ? UnitTypes.quad : UnitTypes.antumbra, rand.chance(0.1) ? UnitTypes.quad : UnitTypes.eclipse}};
        if (airOnly) {
            species = Structs.filter(UnitType[].class, species, v -> v[0].flying);
        }
        species = naval ? (UnitType[][])Structs.filter(UnitType[].class, species, v -> v[0].flying || v[0].naval) : (UnitType[][])Structs.filter(UnitType[].class, species, v -> !v[0].naval);
        UnitType[][] fspec = species;
        Seq<SpawnGroup> out = new Seq<SpawnGroup>();
        final int cap = 150;
        float shieldStart = 30.0f;
        final float shieldsPerWave = 20.0f + difficulty * 30.0f;
        final float[] scaling = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Intc createProgression = start -> {
            UnitType[] curSpecies = (UnitType[])Structs.random(rand, fspec);
            int curTier = 0;
            int i = start;
            while (i < cap) {
                final int f = i;
                final int next = rand.random(8, 16) + (int)Mathf.lerp(5.0f, 0.0f, difficulty) + curTier * 4;
                final float shieldAmount = Math.max(((float)i - shieldStart) * shieldsPerWave, 0.0f);
                final int space = start == 0 ? 1 : rand.random(1, 2);
                final int ctier = curTier;
                out.add(new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(type);
                        this.unitAmount = f == start ? 1 : 6 / (int)scaling[ctier];
                        this.begin = f;
                        this.end = f + next >= cap ? Integer.MAX_VALUE : f + next;
                        this.max = 13;
                        this.unitScaling = (difficulty < 0.4f ? rand.random(2.5f, 5.0f) : rand.random(1.0f, 4.0f)) * scaling[ctier];
                        this.shields = shieldAmount;
                        this.shieldScaling = shieldsPerWave;
                        this.spacing = space;
                    }
                });
                out.add(new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(type);
                        this.unitAmount = 3 / (int)scaling[ctier];
                        this.begin = f + next - 1;
                        this.end = f + next + rand.random(6, 10);
                        this.max = 6;
                        this.unitScaling = rand.random(2.0f, 4.0f);
                        this.spacing = rand.random(2, 4);
                        this.shields = shieldAmount / 2.0f;
                        this.shieldScaling = shieldsPerWave;
                    }
                });
                i += next + 1;
                if (curTier < 3 || rand.chance(0.05) && (double)difficulty > 0.8) {
                    ++curTier;
                }
                curTier = Math.min(curTier, 3);
                if (!rand.chance(0.3)) continue;
                curSpecies = (UnitType[])Structs.random(rand, fspec);
            }
        };
        createProgression.get(0);
        for (int step = 5 + rand.random(5); step <= cap; step += (int)((float)rand.random(15, 30) * Mathf.lerp(1.0f, 0.5f, difficulty))) {
            createProgression.get(step);
        }
        final int bossWave = (int)((float)rand.random(50, 70) * Mathf.lerp(1.0f, 0.5f, difficulty));
        final int bossSpacing = (int)((float)rand.random(25, 40) * Mathf.lerp(1.0f, 0.5f, difficulty));
        int bossTier = (double)difficulty < 0.6 ? 3 : 4;
        out.add(new SpawnGroup(((UnitType[])Structs.random(rand, species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = bossWave;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        out.add(new SpawnGroup(((UnitType[])Structs.random(rand, species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = bossWave + rand.random(3, 5) * bossSpacing;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        final int finalBossStart = 120 + rand.random(30);
        out.add(new SpawnGroup(((UnitType[])Structs.random(rand, species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = finalBossStart;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        out.add(new SpawnGroup(((UnitType[])Structs.random(rand, species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = finalBossStart + 15;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        if (attack && (double)difficulty >= 0.5) {
            int amount = rand.random(1, 3 + (int)(difficulty * 2.0f));
            for (int i = 0; i < amount; ++i) {
                final int wave = rand.random(3, 20);
                out.add(new SpawnGroup(UnitTypes.mega){
                    {
                        super(type);
                        this.unitAmount = 1;
                        this.begin = wave;
                        this.end = wave;
                        this.max = 16;
                    }
                });
            }
        }
        int shift = Math.max((int)(difficulty * 14.0f - 5.0f), 0);
        for (SpawnGroup group : out) {
            group.begin -= shift;
            group.end -= shift;
        }
        return out;
    }
}

