/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.graphics.Color;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Gamemode;
import mindustry.game.MapObjectives;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.io.JsonIO;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.blocks.Attributes;

public class Rules {
    public boolean allowEditRules = false;
    public boolean infiniteResources;
    public TeamRules teams = new TeamRules();
    public boolean waveTimer = true;
    public boolean waveSending = true;
    public boolean waves;
    public boolean airUseSpawns = false;
    public boolean wavesSpawnAtCores = true;
    public boolean pvp;
    public boolean pvpAutoPause = true;
    public boolean waitEnemies = false;
    public boolean attackMode = false;
    public boolean editor = false;
    public boolean derelictRepair = true;
    public boolean canGameOver = true;
    public boolean coreCapture = false;
    public boolean reactorExplosions = true;
    public boolean possessionAllowed = true;
    public boolean schematicsAllowed = true;
    public boolean damageExplosions = true;
    public boolean fire = true;
    public boolean unitAmmo = false;
    public boolean randomWaveAI = false;
    public boolean unitPayloadUpdate = false;
    public boolean unitPayloadsExplode = false;
    public boolean unitCapVariable = true;
    public boolean showSpawns = false;
    public float solarMultiplier = 1.0f;
    public float unitBuildSpeedMultiplier = 1.0f;
    public float unitCostMultiplier = 1.0f;
    public float unitDamageMultiplier = 1.0f;
    public float unitHealthMultiplier = 1.0f;
    public float unitCrashDamageMultiplier = 1.0f;
    public float unitMineSpeedMultiplier = 1.0f;
    public boolean ghostBlocks = true;
    public boolean logicUnitControl = true;
    public boolean logicUnitBuild = true;
    public boolean logicUnitDeconstruct = false;
    public boolean allowEditWorldProcessors = false;
    public boolean disableWorldProcessors = false;
    public float blockHealthMultiplier = 1.0f;
    public float blockDamageMultiplier = 1.0f;
    public float buildCostMultiplier = 1.0f;
    public float buildSpeedMultiplier = 1.0f;
    public float deconstructRefundMultiplier = 0.5f;
    public float objectiveTimerMultiplier = 1.0f;
    public float enemyCoreBuildRadius = 400.0f;
    public boolean polygonCoreProtection = false;
    public boolean placeRangeCheck = false;
    public boolean cleanupDeadTeams = true;
    public boolean onlyDepositCore = false;
    public boolean allowCoreUnloaders = true;
    public float itemDepositCooldown = 0.5f;
    public boolean coreDestroyClear = false;
    public boolean hideBannedBlocks = false;
    public boolean allowEnvironmentDeconstruct = false;
    public boolean instantBuild = false;
    public boolean blockWhitelist = false;
    public boolean unitWhitelist = false;
    public float dropZoneRadius = 300.0f;
    public float waveSpacing = 7200.0f;
    public float initialWaveSpacing = 0.0f;
    public int winWave = 0;
    public int unitCap = 0;
    public boolean disableUnitCap;
    public float dragMultiplier = 1.0f;
    public int env = 233;
    public Attributes attributes = new Attributes();
    @Nullable
    public Sector sector;
    public Seq<SpawnGroup> spawns = new Seq();
    public Seq<ItemStack> loadout = ItemStack.list(Items.copper, 100);
    public Seq<Weather.WeatherEntry> weather = new Seq(1);
    public ObjectSet<Block> bannedBlocks = new ObjectSet();
    public ObjectSet<UnitType> bannedUnits = new ObjectSet();
    public ObjectSet<Block> revealedBlocks = new ObjectSet();
    public ObjectSet<UnlockableContent> researched = new ObjectSet();
    public MapObjectives objectives = new MapObjectives();
    public ObjectSet<String> objectiveFlags = new ObjectSet();
    public boolean fog = false;
    public boolean staticFog = true;
    public Color staticColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public Color dynamicColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    public boolean lighting = false;
    public Color ambientLight = new Color(0.01f, 0.01f, 0.04f, 0.99f);
    public Team defaultTeam = Team.sharded;
    public Team waveTeam = Team.crux;
    public Color cloudColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    @Nullable
    public String modeName;
    @Nullable
    public String mission;
    public boolean coreIncinerates = true;
    public boolean borderDarkness = true;
    public boolean limitMapArea = false;
    public int limitX;
    public int limitY;
    public int limitWidth = 1;
    public int limitHeight = 1;
    public boolean disableOutsideArea = true;
    public StringMap tags = new StringMap();
    @Nullable
    public String customBackgroundCallback;
    @Nullable
    public String backgroundTexture;
    public float backgroundSpeed = 27000.0f;
    public float backgroundScl = 1.0f;
    public float backgroundOffsetX = 0.1f;
    public float backgroundOffsetY = 0.1f;
    @Nullable
    public PlanetParams planetBackground;
    public Planet planet = Planets.serpulo;
    public boolean allowLogicData = false;

    public Rules copy() {
        return JsonIO.copy(this);
    }

    public Gamemode mode() {
        if (this.pvp) {
            return Gamemode.pvp;
        }
        if (this.editor) {
            return Gamemode.editor;
        }
        if (this.attackMode) {
            return Gamemode.attack;
        }
        if (this.infiniteResources) {
            return Gamemode.sandbox;
        }
        return Gamemode.survival;
    }

    public boolean hasEnv(int env) {
        return (this.env & env) != 0;
    }

    public float buildRadius(Team team) {
        return !this.teams.get((Team)team).protectCores ? 0.0f : this.enemyCoreBuildRadius + this.teams.get((Team)team).extraCoreBuildRadius;
    }

    public float unitBuildSpeed(Team team) {
        return this.unitBuildSpeedMultiplier * this.teams.get((Team)team).unitBuildSpeedMultiplier;
    }

    public float unitCost(Team team) {
        return this.unitCostMultiplier * this.teams.get((Team)team).unitCostMultiplier;
    }

    public float unitDamage(Team team) {
        return this.unitDamageMultiplier * this.teams.get((Team)team).unitDamageMultiplier;
    }

    public float unitHealth(Team team) {
        return Math.max(this.unitHealthMultiplier * this.teams.get((Team)team).unitHealthMultiplier, 1.0E-6f);
    }

    public float unitCrashDamage(Team team) {
        return this.unitDamage(team) * this.unitCrashDamageMultiplier * this.teams.get((Team)team).unitCrashDamageMultiplier;
    }

    public float unitMineSpeed(Team team) {
        return this.unitMineSpeedMultiplier * this.teams.get((Team)team).unitMineSpeedMultiplier;
    }

    public float blockHealth(Team team) {
        return this.blockHealthMultiplier * this.teams.get((Team)team).blockHealthMultiplier;
    }

    public float blockDamage(Team team) {
        return this.blockDamageMultiplier * this.teams.get((Team)team).blockDamageMultiplier;
    }

    public float buildSpeed(Team team) {
        return this.buildSpeedMultiplier * this.teams.get((Team)team).buildSpeedMultiplier;
    }

    public boolean isBanned(Block block) {
        return this.blockWhitelist != this.bannedBlocks.contains(block);
    }

    public boolean isBanned(UnitType unit) {
        return this.unitWhitelist != this.bannedUnits.contains(unit);
    }

    public static class TeamRules
    implements Json.JsonSerializable {
        final TeamRule[] values = new TeamRule[Team.all.length];

        public TeamRule get(Team team) {
            TeamRule out = this.values[team.id];
            return out == null ? new TeamRule(team) : out;
        }

        @Override
        public void write(Json json) {
            for (Team team : Team.all) {
                if (this.values[team.id] == null) continue;
                json.writeValue(team.id + "", this.values[team.id], TeamRule.class);
            }
        }

        @Override
        public void read(Json json, JsonValue jsonData) {
            for (JsonValue value : jsonData) {
                this.values[Integer.parseInt((String)value.name)] = json.readValue(TeamRule.class, value);
            }
        }
    }

    public static class TeamRule {
        public boolean aiCoreSpawn = true;
        public boolean protectCores = true;
        public boolean checkPlacement = true;
        public boolean cheat;
        public boolean fillItems;
        public boolean infiniteResources;
        public boolean infiniteAmmo;
        public boolean prebuildAi;
        public boolean buildAi;
        public float buildAiTier = 1.0f;
        public boolean rtsAi;
        public int rtsMinSquad = 4;
        public int rtsMaxSquad = 50;
        public float rtsMinWeight = 1.2f;
        public float unitBuildSpeedMultiplier = 1.0f;
        public float unitDamageMultiplier = 1.0f;
        public float unitCrashDamageMultiplier = 1.0f;
        public float unitMineSpeedMultiplier = 1.0f;
        public float unitCostMultiplier = 1.0f;
        public float unitHealthMultiplier = 1.0f;
        public float blockHealthMultiplier = 1.0f;
        public float blockDamageMultiplier = 1.0f;
        public float buildSpeedMultiplier = 1.0f;
        public float extraCoreBuildRadius = 0.0f;

        public TeamRule() {
        }

        public TeamRule(Team team) {
            if (team == Team.derelict) {
                this.protectCores = false;
                this.checkPlacement = false;
            }
        }
    }
}

