/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.util.Nullable;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Teamc;

public class MultiBulletType
extends BulletType {
    public BulletType[] bullets = new BulletType[0];
    public int repeat = 1;

    public MultiBulletType(BulletType ... bullets) {
        this.bullets = bullets;
    }

    public MultiBulletType(int repeat, BulletType ... bullets) {
        this.repeat = repeat;
        this.bullets = bullets;
    }

    public MultiBulletType() {
    }

    @Override
    public float estimateDPS() {
        float sum = 0.0f;
        for (BulletType b : this.bullets) {
            sum += b.estimateDPS();
        }
        return sum;
    }

    @Override
    protected float calculateRange() {
        float max = 0.0f;
        for (BulletType b : this.bullets) {
            max = Math.max(max, b.calculateRange());
        }
        return max;
    }

    @Override
    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        angle += this.angleOffset;
        Bullet last = null;
        for (int i = 0; i < this.repeat; ++i) {
            for (BulletType bullet : this.bullets) {
                last = bullet.create(owner, shooter, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
            }
        }
        return last;
    }
}

