/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.math.Interp;
import mindustry.content.Fx;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;

public class ArtilleryBulletType
extends BasicBulletType {
    public float trailMult = 1.0f;
    public float trailSize = 4.0f;

    public ArtilleryBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
        this.collidesTiles = false;
        this.collides = false;
        this.collidesAir = false;
        this.scaleLife = true;
        this.hitShake = 1.0f;
        this.hitSound = Sounds.explosionArtillery;
        this.hitEffect = Fx.flakExplosion;
        this.shootEffect = Fx.shootBig;
        this.trailEffect = Fx.artilleryTrail;
        this.shrinkX = 0.15f;
        this.shrinkY = 0.5f;
        this.shrinkInterp = Interp.slope;
    }

    public ArtilleryBulletType(float speed, float damage) {
        this(speed, damage, "shell");
    }

    public ArtilleryBulletType() {
        this(1.0f, 1.0f, "shell");
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (b.timer(0, (3.0f + b.fslope() * 2.0f) * this.trailMult)) {
            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : b.fslope() * this.trailSize, this.backColor);
        }
    }
}

