/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.audio.Sound;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;

public class RepairFieldAbility
extends Ability {
    public float amount = 1.0f;
    public float reload = 100.0f;
    public float range = 60.0f;
    public float healPercent = 0.0f;
    public Effect healEffect = Fx.heal;
    public Effect activeEffect = Fx.healWaveDynamic;
    public Sound sound = Sounds.healWave;
    public float soundVolume = 0.5f;
    public boolean parentizeEffects = false;
    public float sameTypeHealMult = 1.0f;
    protected float timer;
    protected boolean wasHealed = false;

    RepairFieldAbility() {
    }

    public RepairFieldAbility(float amount, float reload, float range) {
        this.amount = amount;
        this.reload = reload;
        this.range = range;
    }

    public RepairFieldAbility(float amount, float reload, float range, float healPercent) {
        this.amount = amount;
        this.reload = reload;
        this.range = range;
        this.healPercent = healPercent;
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add(Core.bundle.format("bullet.range", Strings.autoFixed(this.range / 8.0f, 2)));
        t.row();
        t.add(this.abilityStat("repairspeed", Strings.autoFixed(this.amount * 60.0f / this.reload, 2)));
        t.row();
        if (this.healPercent > 0.0f) {
            t.row();
            t.add(Core.bundle.format("bullet.healpercent", Strings.autoFixed(this.healPercent, 2)));
        }
        if (this.sameTypeHealMult != 1.0f) {
            t.row();
            t.add(this.abilityStat("sametypehealmultiplier", (this.sameTypeHealMult < 1.0f ? "[negstat]" : "") + Strings.autoFixed(this.sameTypeHealMult * 100.0f, 2)));
        }
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.wasHealed = false;
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> {
                if (other.damaged()) {
                    this.healEffect.at((Position)other, this.parentizeEffects);
                    this.wasHealed = true;
                }
                float healMult = unit.type == other.type ? this.sameTypeHealMult : 1.0f;
                other.heal((this.amount + this.healPercent / 100.0f * other.maxHealth()) * healMult);
            });
            if (this.wasHealed) {
                this.activeEffect.at((Position)unit, this.range);
                this.sound.at(unit, 1.0f + Mathf.range(0.1f), this.soundVolume);
            }
            this.timer = 0.0f;
        }
    }
}

