/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Sized;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Buildingc;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.Tile;

public class Units {
    private static final Rect hitrect = new Rect();
    private static Unit result;
    private static float cdist;
    private static float cpriority;
    private static int intResult;
    private static Building buildResult;
    private static boolean anyEntityGround;
    private static float aeX;
    private static float aeY;
    private static float aeW;
    private static float aeH;
    private static final Boolf<Unit> anyEntityLambda;

    public static void notifyUnitSpawn(Unit unit) {
        if (Vars.net.server()) {
            Call.unitSpawn(new UnitSyncContainer(unit));
        }
    }

    public static void unitSpawn(UnitSyncContainer container) {
    }

    public static void unitCapDeath(Unit unit) {
        if (unit != null) {
            unit.dead = true;
            Fx.unitCapKill.at(unit);
            Core.app.post(() -> Call.unitDestroy(unit.id));
        }
    }

    public static void unitEnvDeath(Unit unit) {
        if (unit != null) {
            unit.dead = true;
            Fx.unitEnvKill.at(unit);
            Core.app.post(() -> Call.unitDestroy(unit.id));
        }
    }

    public static void unitDeath(int uid) {
        Unit unit = Groups.unit.getByID(uid);
        if (Vars.netClient != null) {
            Vars.netClient.addRemovedEntity(uid);
        }
        if (unit != null) {
            unit.killed();
        }
    }

    public static void unitDestroy(int uid) {
        Unit unit = Groups.unit.getByID(uid);
        if (Vars.netClient != null) {
            Vars.netClient.addRemovedEntity(uid);
        }
        if (unit != null) {
            unit.destroy();
        }
    }

    public static void unitDespawn(Unit unit) {
        if (unit == null) {
            return;
        }
        Fx.unitDespawn.at(unit.x, unit.y, 0.0f, unit);
        unit.remove();
    }

    public static void unitSafeDeath(Unit unit) {
        if (unit == null) {
            return;
        }
        unit.type.deathExplosionEffect.at(unit.x, unit.y, unit.hitSize / 8.0f);
        float shake = unit.type.deathShake < 0.0f ? unit.hitSize / 3.0f : unit.type.deathShake;
        Effect.shake(shake, shake, unit);
        unit.type.deathSound.at(unit, 1.0f, unit.type.deathSoundVolume);
        unit.remove();
    }

    public static boolean canCreate(Team team, UnitType type) {
        return !type.useUnitCap || team.data().countType(type) < Units.getCap(team) && !type.isBanned();
    }

    public static int getCap(Team team) {
        if (team == Vars.state.rules.waveTeam && !Vars.state.rules.pvp || Vars.state.isCampaign() && team == Vars.state.rules.waveTeam || Vars.state.rules.disableUnitCap || team.ignoreUnitCap) {
            return Integer.MAX_VALUE;
        }
        return Math.max(0, Vars.state.rules.unitCapVariable ? Vars.state.rules.unitCap + team.data().unitCap : Vars.state.rules.unitCap);
    }

    public static String getStringCap(Team team) {
        int cap = Units.getCap(team);
        return cap >= 0x7FFFFFFE ? "\u221e" : cap + "";
    }

    public static boolean canInteract(Player player, Building tile) {
        return player == null || tile == null || tile.interactable(player.team()) || Vars.state.rules.editor;
    }

    public static boolean isHittable(@Nullable Posc target, boolean air, boolean ground) {
        Unit u;
        return target != null && (target instanceof Buildingc ? ground : target instanceof Unit && (u = (Unit)target).checkTarget(air, ground));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean invalidateTarget(Posc target, Team team, float x, float y, float range) {
        if (target == null) return true;
        if (range != Float.MAX_VALUE) {
            float f;
            if (target instanceof Sized) {
                Sized hb = (Sized)((Object)target);
                f = hb.hitSize() / 2.0f;
            } else {
                f = 0.0f;
            }
            if (!target.within(x, y, range + f)) return true;
        }
        if (target instanceof Teamc) {
            Teamc t = (Teamc)target;
            if (t.team() == team) return true;
        }
        if (target instanceof Healthc) {
            Healthc h = (Healthc)target;
            if (!h.isValid()) return true;
        }
        if (!(target instanceof Unit)) return false;
        Unit u = (Unit)target;
        if (u.targetable(team)) return false;
        return true;
    }

    public static boolean invalidateTarget(Posc target, Team team, float x, float y) {
        return Units.invalidateTarget(target, team, x, y, Float.MAX_VALUE);
    }

    public static boolean invalidateTarget(Teamc target, Unit targeter, float range) {
        return Units.invalidateTarget(target, targeter.team(), targeter.x(), targeter.y(), range);
    }

    public static boolean anyEntities(Tile tile, boolean ground) {
        float size = tile.block().size * 8;
        return Units.anyEntities(tile.drawx() - size / 2.0f, tile.drawy() - size / 2.0f, size, size, ground);
    }

    public static boolean anyEntities(Tile tile) {
        return Units.anyEntities(tile, true);
    }

    public static boolean anyEntities(float x, float y, float size) {
        return Units.anyEntities(x - size / 2.0f, y - size / 2.0f, size, size, true);
    }

    public static boolean anyEntities(float x, float y, float width, float height) {
        return Units.anyEntities(x, y, width, height, true);
    }

    public static boolean anyEntities(float x, float y, float width, float height, boolean ground) {
        anyEntityGround = ground;
        aeX = x;
        aeY = y;
        aeW = width;
        aeH = height;
        return Units.nearbyCheck(x, y, width, height, anyEntityLambda);
    }

    public static boolean anyEntities(float x, float y, float width, float height, Boolf<Unit> check) {
        return Units.nearbyCheck(x, y, width, height, unit -> {
            if (check.get((Unit)unit)) {
                unit.hitboxTile(hitrect);
                return hitrect.overlaps(x, y, width, height);
            }
            return false;
        });
    }

    public static Building findDamagedTile(Team team, float x, float y) {
        return Vars.indexer.getDamaged(team).min(b -> b.dst2(x, y));
    }

    public static Building findAllyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        return Vars.indexer.findTile(team, x, y, range, pred);
    }

    public static Building findEnemyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        if (team == Team.derelict) {
            return null;
        }
        return Vars.indexer.findEnemyTile(team, x, y, range, pred);
    }

    @Nullable
    public static Building closestBuilding(Team team, float wx, float wy, float range, Boolf<Building> pred) {
        buildResult = null;
        cdist = 0.0f;
        QuadTree<Building> buildings = team.data().buildingTree;
        if (buildings == null) {
            return null;
        }
        buildings.intersect(wx - range, wy - range, range * 2.0f, range * 2.0f, b -> {
            float dst;
            if (pred.get((Building)b) && (dst = b.dst(wx, wy) - b.hitSize() / 2.0f) <= range && (buildResult == null || dst <= cdist)) {
                cdist = dst;
                buildResult = b;
            }
        });
        Building result = buildResult;
        buildResult = null;
        return result;
    }

    public static void nearbyBuildings(float x, float y, float range, Cons<Building> cons) {
        Vars.indexer.allBuildings(x, y, range, cons);
    }

    public static Teamc closestTarget(Team team, float x, float y, float range) {
        return Units.closestTarget(team, x, y, range, Healthc::isValid);
    }

    public static Teamc closestTarget(Team team, float x, float y, float range, Boolf<Unit> unitPred) {
        return Units.closestTarget(team, x, y, range, unitPred, t -> true);
    }

    public static Teamc closestTarget(Team team, float x, float y, float range, Boolf<Unit> unitPred, Boolf<Building> tilePred) {
        if (team == Team.derelict) {
            return null;
        }
        Unit unit = Units.closestEnemy(team, x, y, range, unitPred);
        if (unit != null) {
            return unit;
        }
        return Units.findEnemyTile(team, x, y, range, tilePred);
    }

    public static Teamc bestTarget(Team team, float x, float y, float range, Boolf<Unit> unitPred, Boolf<Building> tilePred, Sortf sort) {
        if (team == Team.derelict) {
            return null;
        }
        Unit unit = Units.bestEnemy(team, x, y, range, unitPred, sort);
        if (unit != null) {
            return unit;
        }
        return Units.findEnemyTile(team, x, y, range, tilePred);
    }

    public static Unit closestEnemy(Team team, float x, float y, float range, Boolf<Unit> predicate) {
        if (team == Team.derelict) {
            return null;
        }
        result = null;
        cdist = 0.0f;
        cpriority = -99999.0f;
        Units.nearbyEnemies(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (e.dead() || !predicate.get((Unit)e) || e.team == Team.derelict || !e.targetable(team) || e.inFogTo(team)) {
                return;
            }
            float dst2 = e.dst2(x, y) - e.hitSize * e.hitSize;
            if (dst2 < range * range && (result == null || dst2 < cdist || e.type.targetPriority > cpriority) && e.type.targetPriority >= cpriority) {
                result = e;
                cdist = dst2;
                cpriority = e.type.targetPriority;
            }
        });
        return result;
    }

    public static Unit bestEnemy(Team team, float x, float y, float range, Boolf<Unit> predicate, Sortf sort) {
        if (team == Team.derelict) {
            return null;
        }
        result = null;
        cdist = 0.0f;
        cpriority = -99999.0f;
        Units.nearbyEnemies(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (e.dead() || !predicate.get((Unit)e) || e.team == Team.derelict || !e.within(x, y, range + e.hitSize / 2.0f) || !e.targetable(team) || e.inFogTo(team)) {
                return;
            }
            float cost = sort.cost((Unit)e, x, y);
            if ((result == null || cost < cdist || e.type.targetPriority > cpriority) && e.type.targetPriority >= cpriority) {
                result = e;
                cdist = cost;
                cpriority = e.type.targetPriority;
            }
        });
        return result;
    }

    public static Unit closest(Team team, float x, float y, Boolf<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        for (Unit e : Groups.unit) {
            if (!predicate.get(e) || e.team() != team) continue;
            float dist = e.dst2(x, y);
            if (result != null && !(dist < cdist)) continue;
            result = e;
            cdist = dist;
        }
        return result;
    }

    public static Unit closest(Team team, float x, float y, float range, Boolf<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x, y, range, (Unit e) -> {
            if (!e.isValid() || !predicate.get((Unit)e)) {
                return;
            }
            float dist = e.dst2(x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static Unit closest(Team team, float x, float y, float range, Boolf<Unit> predicate, Sortf sort) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x, y, range, (Unit e) -> {
            if (!e.isValid() || !predicate.get((Unit)e)) {
                return;
            }
            float dist = sort.cost((Unit)e, x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static Unit closestOverlap(Team team, float x, float y, float range, Boolf<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (!e.isValid() || !predicate.get((Unit)e)) {
                return;
            }
            float dist = e.dst2(x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static int count(float x, float y, float size, Boolf<Unit> filter) {
        return Units.count(x - size / 2.0f, y - size / 2.0f, size, size, filter);
    }

    public static int count(float x, float y, float width, float height, Boolf<Unit> filter) {
        intResult = 0;
        Groups.unit.intersect(x, y, width, height, v -> {
            if (filter.get((Unit)v)) {
                ++intResult;
            }
        });
        return intResult;
    }

    public static boolean any(float x, float y, float width, float height, Boolf<Unit> filter) {
        return Groups.unit.intersect(x, y, width, height, filter);
    }

    public static void nearby(@Nullable Team team, float x, float y, float width, float height, Cons<Unit> cons) {
        if (team != null) {
            team.data().tree().intersect(x, y, width, height, cons);
        } else {
            for (Teams.TeamData other : Vars.state.teams.present) {
                other.tree().intersect(x, y, width, height, cons);
            }
        }
    }

    public static void nearby(@Nullable Team team, float x, float y, float radius, Cons<Unit> cons) {
        Units.nearby(team, x - radius, y - radius, radius * 2.0f, radius * 2.0f, unit -> {
            if (unit.within(x, y, radius + unit.hitSize / 2.0f)) {
                cons.get((Unit)unit);
            }
        });
    }

    public static void nearby(float x, float y, float width, float height, Cons<Unit> cons) {
        Groups.unit.intersect(x, y, width, height, cons);
    }

    public static boolean nearbyCheck(float x, float y, float width, float height, Boolf<Unit> cons) {
        return Groups.unit.intersect(x, y, width, height, cons);
    }

    public static void nearby(Rect rect, Cons<Unit> cons) {
        Units.nearby(rect.x, rect.y, rect.width, rect.height, cons);
    }

    public static void nearbyEnemies(Team team, float x, float y, float width, float height, Cons<Unit> cons) {
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == team) continue;
            Units.nearby(((Teams.TeamData[])data.items)[i].team, x, y, width, height, cons);
        }
    }

    public static void nearbyEnemies(Team team, float x, float y, float radius, Cons<Unit> cons) {
        Units.nearbyEnemies(team, x - radius, y - radius, radius * 2.0f, radius * 2.0f, u -> {
            if (u.within(x, y, radius + u.hitSize / 2.0f)) {
                cons.get((Unit)u);
            }
        });
    }

    public static void nearbyEnemies(Team team, Rect rect, Cons<Unit> cons) {
        Units.nearbyEnemies(team, rect.x, rect.y, rect.width, rect.height, cons);
    }

    public static boolean nearEnemy(Team team, float x, float y, float width, float height) {
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            Teams.TeamData other = ((Teams.TeamData[])data.items)[i];
            if (other.team == team || other.team == Team.derelict) continue;
            if (other.tree().any(x, y, width, height)) {
                return true;
            }
            if (other.turretTree == null || !other.turretTree.any(x, y, width, height)) continue;
            return true;
        }
        return false;
    }

    static {
        anyEntityLambda = unit -> {
            if ((unit.isGrounded() && !unit.type.allowLegStep) == anyEntityGround) {
                unit.hitboxTile(hitrect);
                return hitrect.overlaps(aeX, aeY, aeW, aeH);
            }
            return false;
        };
    }

    public static class UnitSyncContainer {
        public Unit unit;

        public UnitSyncContainer() {
        }

        public UnitSyncContainer(Unit unit) {
            this.unit = unit;
        }
    }

    public static interface Sortf {
        public float cost(Unit var1, float var2, float var3);
    }

    public static interface BuildingPriorityf {
        public float priority(Building var1);
    }
}

