/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Cons;
import arc.scene.Element;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class MapLoadDialog
extends BaseDialog {
    @Nullable
    private Map selected = null;

    public MapLoadDialog(Cons<Map> loader) {
        super("@editor.loadmap");
        this.shown(this::rebuild);
        this.hidden(() -> {
            this.selected = null;
        });
        this.onResize(this::rebuild);
        this.buttons.defaults().size(210.0f, 64.0f);
        this.buttons.button("@cancel", Icon.cancel, this::hide);
        this.buttons.button("@load", Icon.ok, () -> {
            if (this.selected != null) {
                loader.get(this.selected);
                this.hide();
            }
        }).disabled(b -> this.selected == null);
        this.addCloseListener();
        this.makeButtonOverlay();
    }

    public void rebuild() {
        this.cont.clear();
        ButtonGroup group = new ButtonGroup();
        int i = 0;
        int cols = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(300.0f)), 1);
        Table table = new Table();
        table.defaults().size(250.0f, 90.0f).pad(4.0f);
        table.margin(10.0f);
        ScrollPane pane = new ScrollPane((Element)table);
        pane.setFadeScrollBars(false);
        pane.setScrollingDisabledX(true);
        for (Map map : Vars.maps.all()) {
            table.button((Button b) -> {
                b.add(new BorderImage(map.safeTexture(), 2.0f).setScaling(Scaling.fit)).padLeft(5.0f).size(64.0f);
                b.add(map.name()).wrap().grow().labelAlign(1).padLeft(5.0f);
            }, (Button.ButtonStyle)Styles.squareTogglet, () -> {
                this.selected = map;
            }).group(group).margin(8.0f).checked(b -> this.selected == map);
            if (++i % cols != 0) continue;
            table.row();
        }
        group.uncheckAll();
        if (Vars.maps.all().isEmpty()) {
            table.add("@maps.none").center();
        } else {
            this.cont.add("@editor.selectmap");
        }
        this.cont.row();
        this.cont.add(pane);
    }
}

