/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.scene.style.Drawable;
import arc.scene.ui.TextArea;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import mindustry.Vars;
import mindustry.editor.MapGenerateDialog;
import mindustry.editor.MapLocalesDialog;
import mindustry.editor.MapObjectivesDialog;
import mindustry.editor.MapPatchesDialog;
import mindustry.editor.MapProcessorsDialog;
import mindustry.editor.WaveInfoDialog;
import mindustry.game.Rules;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.io.JsonIO;
import mindustry.maps.filters.GenerateFilter;
import mindustry.type.MapLocales;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.CustomRulesDialog;

public class MapInfoDialog
extends BaseDialog {
    private WaveInfoDialog waveInfo = new WaveInfoDialog();
    private MapGenerateDialog generate = new MapGenerateDialog(false);
    private CustomRulesDialog ruleInfo = new CustomRulesDialog();
    private MapObjectivesDialog objectives = new MapObjectivesDialog();
    private MapLocalesDialog locales = new MapLocalesDialog();
    private MapProcessorsDialog processors = new MapProcessorsDialog();
    private MapPatchesDialog patches = new MapPatchesDialog();

    public MapInfoDialog() {
        super("@editor.mapinfo");
        this.addCloseButton();
        this.shown(this::setup);
    }

    private void setup() {
        this.cont.clear();
        StringMap tags = Vars.editor.tags;
        this.cont.pane((Table t) -> {
            t.add("@editor.mapname").padRight(8.0f).left();
            t.defaults().padTop(15.0f);
            TextField name = t.field(tags.get("name", ""), text -> tags.put("name", text)).size(400.0f, 55.0f).maxTextLength(50).get();
            name.setMessageText("@unknown");
            t.row();
            t.add("@editor.description").padRight(8.0f).left();
            TextArea description = t.area(tags.get("description", ""), Styles.areaField, text -> tags.put("description", text)).size(400.0f, 140.0f).maxTextLength(1000).get();
            t.row();
            t.add("@editor.author").padRight(8.0f).left();
            TextField author = t.field(tags.get("author", ""), text -> tags.put("author", text)).size(400.0f, 55.0f).maxTextLength(50).get();
            author.setMessageText("@unknown");
            t.row();
            t.table(Tex.button, r -> {
                r.defaults().width(230.0f).height(60.0f);
                TextButton.TextButtonStyle style = Styles.flatt;
                r.button("@editor.rules", (Drawable)Icon.list, style, () -> {
                    this.ruleInfo.show(Vars.state.rules, () -> {
                        Vars.state.rules = new Rules();
                        return Vars.state.rules;
                    });
                    this.hide();
                }).marginLeft(10.0f);
                r.button("@editor.waves", (Drawable)Icon.units, style, () -> {
                    this.waveInfo.show();
                    this.hide();
                }).marginLeft(10.0f);
                r.row();
                r.button("@editor.objectives", (Drawable)Icon.info, style, () -> {
                    this.objectives.show(Vars.state.rules.objectives.all, Vars.state.rules.objectives.all::set);
                    this.hide();
                }).marginLeft(10.0f);
                r.button("@editor.generation", (Drawable)Icon.terrain, style, () -> {
                    Seq<GenerateFilter> res = Vars.maps.readFilters(Vars.editor.tags.get("genfilters", ""));
                    res.each(GenerateFilter::randomize);
                    this.generate.show(res, (Seq<GenerateFilter> filters) -> {
                        filters.each(f -> {
                            f.seed = 0;
                        });
                        Vars.editor.tags.put("genfilters", JsonIO.write(filters));
                    });
                    this.hide();
                }).marginLeft(10.0f);
                r.row();
                r.button("@editor.locales", (Drawable)Icon.fileText, style, () -> {
                    try {
                        MapLocales res = JsonIO.read(MapLocales.class, Vars.editor.tags.get("locales", "{}"));
                        this.locales.show(res);
                    }
                    catch (Throwable e) {
                        this.locales.show(new MapLocales());
                        Vars.ui.showException(e);
                    }
                    this.hide();
                }).marginLeft(10.0f);
                r.button("@editor.worldprocessors", (Drawable)Icon.logic, style, () -> {
                    this.hide();
                    this.processors.show();
                }).marginLeft(10.0f);
                r.row();
                r.button("@editor.patches", (Drawable)Icon.file, style, () -> {
                    this.hide();
                    this.patches.show();
                }).marginLeft(10.0f);
                r.add().marginLeft(10.0f);
            }).colspan(2).center();
            name.change();
            description.change();
            author.change();
            t.margin(16.0f);
        });
    }
}

