/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.func.Boolf;
import arc.func.Cons;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Bresenham2;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Bits;
import arc.struct.IntSeq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.gen.TileOp;
import mindustry.gen.TileOpData;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;

public enum EditorTool {
    zoom(KeyCode.v),
    pick(KeyCode.i){

        @Override
        public void touched(int x, int y) {
            if (!Structs.inBounds(x, y, Vars.editor.width(), Vars.editor.height())) {
                return;
            }
            Tile tile = Vars.editor.tile(x, y);
            Vars.editor.drawBlock = tile.block() == Blocks.air || !tile.block().inEditor ? (tile.overlay() == Blocks.air ? tile.floor() : tile.overlay()) : tile.block();
            Vars.editor.drawBlock.editorPicked(tile);
        }
    }
    ,
    line(KeyCode.l, new String[]{"replace", "orthogonal"}){

        @Override
        public void touchedLine(int x1, int y1, int x2, int y2) {
            if (this.mode == 1) {
                if (Math.abs(x2 - x1) > Math.abs(y2 - y1)) {
                    y2 = y1;
                } else {
                    x2 = x1;
                }
            }
            Bresenham2.line(x1, y1, x2, y2, (x, y) -> {
                if (this.mode == 0) {
                    Vars.editor.drawBlocksReplace(x, y);
                } else {
                    Vars.editor.drawBlocks(x, y);
                }
            });
        }
    }
    ,
    pencil(KeyCode.b, new String[]{"replace", "square", "drawteams", "underliquid"}){
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(int x, int y) {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (this.mode != -1) break block2;
                                    Vars.editor.drawBlocks(x, y);
                                    break block3;
                                }
                                if (this.mode != 0) break block4;
                                Vars.editor.drawBlocksReplace(x, y);
                                break block3;
                            }
                            if (this.mode != 1) break block5;
                            Vars.editor.drawBlocks(x, y, true, false, tile -> true);
                            break block3;
                        }
                        if (this.mode != 2) break block6;
                        Vars.editor.drawCircle(x, y, tile -> tile.setTeam(Vars.editor.drawTeam));
                        break block3;
                    }
                    if (this.mode != 3) break block3;
                    Block block = Vars.editor.drawBlock;
                    if (!(block instanceof Floor)) break block7;
                    Floor f = (Floor)block;
                    if (f.isLiquid) break block3;
                }
                Vars.editor.drawBlocks(x, y, false, true, tile -> tile.floor().isLiquid);
            }
        }
    }
    ,
    eraser(KeyCode.e, new String[]{"eraseores"}){
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(int x, int y) {
            Vars.editor.drawCircle(x, y, tile -> {
                if (this.mode == -1) {
                    tile.remove();
                } else if (this.mode == 0) {
                    tile.clearOverlay();
                }
            });
        }
    }
    ,
    fill(KeyCode.g, new String[]{"replaceall", "fillteams", "fillerase", "fillcliffs"}){
        IntSeq stack;
        {
            this.edit = true;
            this.stack = new IntSeq();
        }

        @Override
        public void touched(int x, int y) {
            if (!Structs.inBounds(x, y, Vars.editor.width(), Vars.editor.height())) {
                return;
            }
            Tile tile = Vars.editor.tile(x, y);
            if (tile == null) {
                return;
            }
            if (Vars.editor.drawBlock.isMultiblock() && (this.mode == 0 || this.mode == -1)) {
                pencil.touched(x, y);
                return;
            }
            if (this.mode == 0 || this.mode == -1) {
                Cons<Tile> setter;
                Boolf<Tile> tester;
                Block dest;
                if (tile.block().isMultiblock()) {
                    return;
                }
                if (Vars.editor.drawBlock.isOverlay()) {
                    dest = tile.overlay();
                    if (dest == Vars.editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.overlay() == dest && (t.floor().hasSurface() || !t.floor().needsSurface);
                    setter = t -> t.setOverlay(Vars.editor.drawBlock);
                } else if (Vars.editor.drawBlock.isFloor()) {
                    dest = tile.floor();
                    if (dest == Vars.editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.floor() == dest;
                    setter = t -> {
                        t.setFloor(Vars.editor.drawBlock.asFloor());
                        if (!(t.overlay() instanceof OverlayFloor) && !t.floor().supportsOverlay) {
                            t.setOverlay(Blocks.air);
                        }
                    };
                } else {
                    dest = tile.block();
                    if (dest == Vars.editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.block() == dest;
                    setter = t -> t.setBlock(Vars.editor.drawBlock, Vars.editor.drawTeam);
                }
                Cons<Tile> oldSetter = setter;
                setter = t -> {
                    if (Vars.editor.drawBlock.saveData) {
                        Vars.editor.addTileOp(TileOp.get(t.x, t.y, 5, TileOpData.get(t.data, t.floorData, t.overlayData)));
                        Vars.editor.addTileOp(TileOp.get(t.x, t.y, 6, t.extraData));
                    }
                    oldSetter.get((Tile)t);
                    if (!Vars.editor.drawBlock.synthetic() && Vars.editor.drawBlock.saveConfig) {
                        Vars.editor.drawBlock.placeEnded((Tile)t, null, Vars.editor.rotation, Vars.editor.drawBlock.lastConfig);
                        Vars.editor.renderer.updateStatic(t.x, t.y);
                    }
                };
                this.fill(x, y, this.mode == 0, tester, setter);
            } else if (this.mode == 1) {
                if (tile.synthetic()) {
                    Team dest = tile.team();
                    if (dest == Vars.editor.drawTeam) {
                        return;
                    }
                    this.fill(x, y, true, t -> t.getTeamID() == dest.id && t.synthetic(), t -> t.setTeam(Vars.editor.drawTeam));
                }
            } else if (this.mode == 2) {
                Cons<Tile> setter;
                Boolf<Tile> tester;
                if (tile.block() != Blocks.air) {
                    Block dest = tile.block();
                    tester = t -> t.block() == dest;
                    setter = t -> t.setBlock(Blocks.air);
                } else if (tile.overlay() != Blocks.air) {
                    Floor dest = tile.overlay();
                    tester = t -> t.overlay() == dest;
                    setter = t -> t.setOverlay(Blocks.air);
                } else {
                    tester = null;
                    setter = null;
                }
                if (setter != null) {
                    this.fill(x, y, false, tester, setter);
                }
            } else if (this.mode == 3) {
                if (!tile.block().isStatic() || tile.block() == Blocks.cliff) {
                    return;
                }
                Bits wasStatic = new Bits(Vars.editor.width() * Vars.editor.height());
                this.fill(x, y, false, t -> t.block().isStatic() && t.block() != Blocks.cliff, t -> {
                    int rotation = 0;
                    for (int i = 0; i < 8; ++i) {
                        Tile other = Vars.world.tiles.get(t.x + Geometry.d8[i].x, t.y + Geometry.d8[i].y);
                        if (other == null || other.block().isStatic() || wasStatic.get(other.array())) continue;
                        rotation |= 1 << i;
                    }
                    if (rotation != 0) {
                        t.setBlock(Blocks.cliff);
                    } else {
                        t.setBlock(Blocks.air);
                        wasStatic.set(t.array());
                    }
                    t.data = (byte)rotation;
                });
            }
        }

        void fill(int x, int y, boolean replace, Boolf<Tile> tester, Cons<Tile> filler) {
            int width = Vars.editor.width();
            int height = Vars.editor.height();
            if (replace) {
                for (int cx = 0; cx < width; ++cx) {
                    for (int cy = 0; cy < height; ++cy) {
                        Tile tile = Vars.editor.tile(cx, cy);
                        if (!tester.get(tile)) continue;
                        filler.get(tile);
                    }
                }
            } else {
                this.stack.clear();
                this.stack.add(Point2.pack(x, y));
                try {
                    while (this.stack.size > 0 && this.stack.size < width * height) {
                        int x1;
                        int popped = this.stack.pop();
                        x = Point2.x(popped);
                        y = Point2.y(popped);
                        for (x1 = x; x1 >= 0 && tester.get(Vars.editor.tile(x1, y)); --x1) {
                        }
                        ++x1;
                        boolean spanAbove = false;
                        boolean spanBelow = false;
                        while (x1 < width && tester.get(Vars.editor.tile(x1, y))) {
                            filler.get(Vars.editor.tile(x1, y));
                            if (!spanAbove && y > 0 && tester.get(Vars.editor.tile(x1, y - 1))) {
                                this.stack.add(Point2.pack(x1, y - 1));
                                spanAbove = true;
                            } else if (spanAbove && !tester.get(Vars.editor.tile(x1, y - 1))) {
                                spanAbove = false;
                            }
                            if (!spanBelow && y < height - 1 && tester.get(Vars.editor.tile(x1, y + 1))) {
                                this.stack.add(Point2.pack(x1, y + 1));
                                spanBelow = true;
                            } else if (spanBelow && y < height - 1 && !tester.get(Vars.editor.tile(x1, y + 1))) {
                                spanBelow = false;
                            }
                            ++x1;
                        }
                    }
                    this.stack.clear();
                }
                catch (OutOfMemoryError e) {
                    this.stack = null;
                    System.gc();
                    e.printStackTrace();
                    this.stack = new IntSeq();
                }
            }
        }
    }
    ,
    spray(KeyCode.r, new String[]{"replace"}){
        final double chance = 0.012;
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(int x, int y) {
            if (Vars.editor.drawBlock.isFloor()) {
                Vars.editor.drawCircle(x, y, tile -> {
                    if (Mathf.chance(0.012)) {
                        tile.setFloor(Vars.editor.drawBlock.asFloor());
                    }
                });
            } else if (this.mode == 0) {
                Vars.editor.drawBlocks(x, y, tile -> Mathf.chance(0.012) && tile.block() != Blocks.air);
            } else {
                Vars.editor.drawBlocks(x, y, tile -> Mathf.chance(0.012));
            }
        }
    };

    public static final EditorTool[] all;
    public final String[] altModes;
    public KeyCode key = KeyCode.unset;
    public int mode = -1;
    public boolean edit;
    public boolean draggable;

    private EditorTool() {
        this(new String[0]);
    }

    private EditorTool(KeyCode code) {
        this(new String[0]);
        this.key = code;
    }

    private EditorTool(String ... altModes) {
        this.altModes = altModes;
    }

    private EditorTool(KeyCode code, String ... altModes) {
        this.altModes = altModes;
        this.key = code;
    }

    public void touched(int x, int y) {
    }

    public void touchedLine(int x1, int y1, int x2, int y2) {
    }

    static {
        all = EditorTool.values();
    }
}

