/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.math.WindowedMean;
import arc.util.Time;

public enum PerfCounter {
    frame,
    update,
    entityUpdate,
    ui,
    render;

    public static final PerfCounter[] all;
    static final int meanWindow = 30;
    static final int refreshTimeMillis = 500;
    private long valueRefreshTime;
    private float refreshValue;
    private long beginTime;
    private boolean began = false;
    private WindowedMean mean = new WindowedMean(30);

    public void begin() {
        this.began = true;
        this.beginTime = Time.nanos();
    }

    public void end() {
        if (!this.began) {
            return;
        }
        this.began = false;
        this.mean.add(Time.timeSinceNanos(this.beginTime));
    }

    public float valueMs() {
        if (Time.timeSinceMillis(this.valueRefreshTime) > 500L) {
            this.refreshValue = this.rawValueMs();
            this.valueRefreshTime = Time.millis();
        }
        return this.refreshValue;
    }

    public float rawValueMs() {
        return this.mean.rawMean() / 1000000.0f;
    }

    public long rawValueNs() {
        return (long)this.mean.rawMean();
    }

    static {
        all = PerfCounter.values();
    }
}

