/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.struct.Seq;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.entities.UnitSorts;
import mindustry.entities.abilities.ForceFieldAbility;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousFlameBulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.EmptyBulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.LightningBulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.bullet.PointLaserBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.RadialEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.entities.effect.WrapEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.HaloPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.part.ShapePart;
import mindustry.entities.pattern.ShootAlternate;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.pattern.ShootHelix;
import mindustry.entities.pattern.ShootMulti;
import mindustry.entities.pattern.ShootSpread;
import mindustry.entities.pattern.ShootSummon;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.unit.MissileUnitType;
import mindustry.world.Block;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.campaign.Accelerator;
import mindustry.world.blocks.campaign.LandingPad;
import mindustry.world.blocks.campaign.LaunchPad;
import mindustry.world.blocks.defense.AutoDoor;
import mindustry.world.blocks.defense.BaseShield;
import mindustry.world.blocks.defense.BuildTurret;
import mindustry.world.blocks.defense.Door;
import mindustry.world.blocks.defense.ForceProjector;
import mindustry.world.blocks.defense.MendProjector;
import mindustry.world.blocks.defense.OverdriveProjector;
import mindustry.world.blocks.defense.Radar;
import mindustry.world.blocks.defense.RegenProjector;
import mindustry.world.blocks.defense.ShieldWall;
import mindustry.world.blocks.defense.ShockMine;
import mindustry.world.blocks.defense.ShockwaveTower;
import mindustry.world.blocks.defense.Thruster;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.defense.turrets.ContinuousLiquidTurret;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.LaserTurret;
import mindustry.world.blocks.defense.turrets.LiquidTurret;
import mindustry.world.blocks.defense.turrets.PointDefenseTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.blocks.distribution.ArmoredConveyor;
import mindustry.world.blocks.distribution.BufferedItemBridge;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.distribution.DirectionLiquidBridge;
import mindustry.world.blocks.distribution.DirectionalUnloader;
import mindustry.world.blocks.distribution.Duct;
import mindustry.world.blocks.distribution.DuctBridge;
import mindustry.world.blocks.distribution.DuctRouter;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.blocks.distribution.OverflowDuct;
import mindustry.world.blocks.distribution.OverflowGate;
import mindustry.world.blocks.distribution.Router;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.blocks.distribution.StackRouter;
import mindustry.world.blocks.environment.AirBlock;
import mindustry.world.blocks.environment.CharacterOverlay;
import mindustry.world.blocks.environment.Cliff;
import mindustry.world.blocks.environment.ColoredFloor;
import mindustry.world.blocks.environment.ColoredWall;
import mindustry.world.blocks.environment.EmptyFloor;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.environment.Prop;
import mindustry.world.blocks.environment.RemoveOre;
import mindustry.world.blocks.environment.RemoveWall;
import mindustry.world.blocks.environment.RuneOverlay;
import mindustry.world.blocks.environment.SeaBush;
import mindustry.world.blocks.environment.Seaweed;
import mindustry.world.blocks.environment.ShallowLiquid;
import mindustry.world.blocks.environment.SpawnBlock;
import mindustry.world.blocks.environment.StaticTree;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.environment.SteamVent;
import mindustry.world.blocks.environment.TallBlock;
import mindustry.world.blocks.environment.TreeBlock;
import mindustry.world.blocks.heat.HeatConductor;
import mindustry.world.blocks.heat.HeatProducer;
import mindustry.world.blocks.legacy.LegacyCommandCenter;
import mindustry.world.blocks.legacy.LegacyMechPad;
import mindustry.world.blocks.legacy.LegacyUnitFactory;
import mindustry.world.blocks.liquid.ArmoredConduit;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.blocks.liquid.LiquidBridge;
import mindustry.world.blocks.liquid.LiquidJunction;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.blocks.logic.CanvasBlock;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.blocks.logic.MemoryBlock;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.logic.SwitchBlock;
import mindustry.world.blocks.logic.TileableLogicDisplay;
import mindustry.world.blocks.payloads.Constructor;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.payloads.PayloadDeconstructor;
import mindustry.world.blocks.payloads.PayloadLoader;
import mindustry.world.blocks.payloads.PayloadMassDriver;
import mindustry.world.blocks.payloads.PayloadRouter;
import mindustry.world.blocks.payloads.PayloadSource;
import mindustry.world.blocks.payloads.PayloadUnloader;
import mindustry.world.blocks.payloads.PayloadVoid;
import mindustry.world.blocks.power.Battery;
import mindustry.world.blocks.power.BeamNode;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.blocks.power.HeaterGenerator;
import mindustry.world.blocks.power.ImpactReactor;
import mindustry.world.blocks.power.LightBlock;
import mindustry.world.blocks.power.LongPowerNode;
import mindustry.world.blocks.power.NuclearReactor;
import mindustry.world.blocks.power.PowerDiode;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.power.SolarGenerator;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.blocks.power.VariableReactor;
import mindustry.world.blocks.production.AttributeCrafter;
import mindustry.world.blocks.production.BeamDrill;
import mindustry.world.blocks.production.BurstDrill;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.Fracker;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.HeatCrafter;
import mindustry.world.blocks.production.Incinerator;
import mindustry.world.blocks.production.ItemIncinerator;
import mindustry.world.blocks.production.Pump;
import mindustry.world.blocks.production.Separator;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.blocks.production.WallCrafter;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.ItemVoid;
import mindustry.world.blocks.sandbox.LiquidSource;
import mindustry.world.blocks.sandbox.LiquidVoid;
import mindustry.world.blocks.sandbox.PowerSource;
import mindustry.world.blocks.sandbox.PowerVoid;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.blocks.storage.Unloader;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.RepairTower;
import mindustry.world.blocks.units.RepairTurret;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitAssemblerModule;
import mindustry.world.blocks.units.UnitCargoLoader;
import mindustry.world.blocks.units.UnitCargoUnloadPoint;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.ConsumeItemExplode;
import mindustry.world.consumers.ConsumeItemFlammable;
import mindustry.world.consumers.ConsumeItemRadioactive;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.draw.DrawArcSmelt;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawBlurSpin;
import mindustry.world.draw.DrawBubbles;
import mindustry.world.draw.DrawCells;
import mindustry.world.draw.DrawCircles;
import mindustry.world.draw.DrawCrucibleFlame;
import mindustry.world.draw.DrawCultivator;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawFade;
import mindustry.world.draw.DrawFlame;
import mindustry.world.draw.DrawGlowRegion;
import mindustry.world.draw.DrawHeatInput;
import mindustry.world.draw.DrawHeatOutput;
import mindustry.world.draw.DrawHeatRegion;
import mindustry.world.draw.DrawLiquidOutputs;
import mindustry.world.draw.DrawLiquidRegion;
import mindustry.world.draw.DrawLiquidTile;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawMultiWeave;
import mindustry.world.draw.DrawParticles;
import mindustry.world.draw.DrawPistons;
import mindustry.world.draw.DrawPulseShape;
import mindustry.world.draw.DrawRegion;
import mindustry.world.draw.DrawShape;
import mindustry.world.draw.DrawSoftParticles;
import mindustry.world.draw.DrawSpikes;
import mindustry.world.draw.DrawTurret;
import mindustry.world.draw.DrawWarmupRegion;
import mindustry.world.draw.DrawWeave;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BuildVisibility;

public class Blocks {
    public static Block air;
    public static Block spawn;
    public static Block removeWall;
    public static Block removeOre;
    public static Block cliff;
    public static Block deepwater;
    public static Block water;
    public static Block taintedWater;
    public static Block deepTaintedWater;
    public static Block tar;
    public static Block slag;
    public static Block cryofluid;
    public static Block stone;
    public static Block craters;
    public static Block charr;
    public static Block sand;
    public static Block darksand;
    public static Block dirt;
    public static Block mud;
    public static Block ice;
    public static Block snow;
    public static Block darksandTaintedWater;
    public static Block space;
    public static Block empty;
    public static Block dacite;
    public static Block rhyolite;
    public static Block rhyoliteCrater;
    public static Block roughRhyolite;
    public static Block regolith;
    public static Block yellowStone;
    public static Block redIce;
    public static Block redStone;
    public static Block denseRedStone;
    public static Block arkyciteFloor;
    public static Block arkyicStone;
    public static Block redmat;
    public static Block bluemat;
    public static Block stoneWall;
    public static Block dirtWall;
    public static Block sporeWall;
    public static Block iceWall;
    public static Block daciteWall;
    public static Block sporePine;
    public static Block snowPine;
    public static Block pine;
    public static Block shrubs;
    public static Block whiteTree;
    public static Block whiteTreeDead;
    public static Block sporeCluster;
    public static Block redweed;
    public static Block purbush;
    public static Block yellowCoral;
    public static Block rhyoliteVent;
    public static Block carbonVent;
    public static Block arkyicVent;
    public static Block yellowStoneVent;
    public static Block redStoneVent;
    public static Block crystallineVent;
    public static Block stoneVent;
    public static Block basaltVent;
    public static Block regolithWall;
    public static Block yellowStoneWall;
    public static Block rhyoliteWall;
    public static Block carbonWall;
    public static Block redIceWall;
    public static Block ferricStoneWall;
    public static Block beryllicStoneWall;
    public static Block arkyicWall;
    public static Block crystallineStoneWall;
    public static Block redStoneWall;
    public static Block redDiamondWall;
    public static Block ferricStone;
    public static Block ferricCraters;
    public static Block carbonStone;
    public static Block beryllicStone;
    public static Block crystallineStone;
    public static Block crystalFloor;
    public static Block yellowStonePlates;
    public static Block iceSnow;
    public static Block sandWater;
    public static Block darksandWater;
    public static Block duneWall;
    public static Block sandWall;
    public static Block moss;
    public static Block sporeMoss;
    public static Block shale;
    public static Block shaleWall;
    public static Block grass;
    public static Block salt;
    public static Block coreZone;
    public static Block shaleBoulder;
    public static Block sandBoulder;
    public static Block daciteBoulder;
    public static Block boulder;
    public static Block snowBoulder;
    public static Block basaltBoulder;
    public static Block carbonBoulder;
    public static Block ferricBoulder;
    public static Block beryllicBoulder;
    public static Block yellowStoneBoulder;
    public static Block arkyicBoulder;
    public static Block crystalCluster;
    public static Block vibrantCrystalCluster;
    public static Block crystalBlocks;
    public static Block crystalOrbs;
    public static Block crystallineBoulder;
    public static Block redIceBoulder;
    public static Block rhyoliteBoulder;
    public static Block redStoneBoulder;
    public static Block metalFloor;
    public static Block metalFloorDamaged;
    public static Block metalFloor2;
    public static Block metalFloor3;
    public static Block metalFloor4;
    public static Block metalFloor5;
    public static Block basalt;
    public static Block magmarock;
    public static Block hotrock;
    public static Block snowWall;
    public static Block saltWall;
    public static Block darkPanel1;
    public static Block darkPanel2;
    public static Block darkPanel3;
    public static Block darkPanel4;
    public static Block darkPanel5;
    public static Block darkPanel6;
    public static Block darkMetal;
    public static Block metalTiles1;
    public static Block metalTiles2;
    public static Block metalTiles3;
    public static Block metalTiles4;
    public static Block metalTiles5;
    public static Block metalTiles6;
    public static Block metalTiles7;
    public static Block metalTiles8;
    public static Block metalTiles9;
    public static Block metalTiles10;
    public static Block metalTiles11;
    public static Block metalTiles12;
    public static Block metalTiles13;
    public static Block metalWall1;
    public static Block metalWall2;
    public static Block metalWall3;
    public static Block coloredFloor;
    public static Block coloredWall;
    public static Block characterOverlayGray;
    public static Block characterOverlayWhite;
    public static Block runeOverlay;
    public static Block cruxRuneOverlay;
    public static Block pebbles;
    public static Block tendrils;
    public static Block oreCopper;
    public static Block oreLead;
    public static Block oreScrap;
    public static Block oreCoal;
    public static Block oreTitanium;
    public static Block oreThorium;
    public static Block oreBeryllium;
    public static Block oreTungsten;
    public static Block oreCrystalThorium;
    public static Block wallOreThorium;
    public static Block wallOreBeryllium;
    public static Block graphiticWall;
    public static Block wallOreGraphite;
    public static Block wallOreTungsten;
    public static Block siliconSmelter;
    public static Block siliconCrucible;
    public static Block kiln;
    public static Block graphitePress;
    public static Block plastaniumCompressor;
    public static Block multiPress;
    public static Block phaseWeaver;
    public static Block surgeSmelter;
    public static Block pyratiteMixer;
    public static Block blastMixer;
    public static Block cryofluidMixer;
    public static Block melter;
    public static Block separator;
    public static Block disassembler;
    public static Block sporePress;
    public static Block pulverizer;
    public static Block incinerator;
    public static Block coalCentrifuge;
    public static Block siliconArcFurnace;
    public static Block electrolyzer;
    public static Block oxidationChamber;
    public static Block atmosphericConcentrator;
    public static Block electricHeater;
    public static Block slagHeater;
    public static Block phaseHeater;
    public static Block heatRedirector;
    public static Block smallHeatRedirector;
    public static Block heatRouter;
    public static Block slagIncinerator;
    public static Block carbideCrucible;
    public static Block slagCentrifuge;
    public static Block surgeCrucible;
    public static Block cyanogenSynthesizer;
    public static Block phaseSynthesizer;
    public static Block heatReactor;
    public static Block powerSource;
    public static Block powerVoid;
    public static Block itemSource;
    public static Block itemVoid;
    public static Block liquidSource;
    public static Block liquidVoid;
    public static Block payloadSource;
    public static Block payloadVoid;
    public static Block illuminator;
    public static Block heatSource;
    public static Block copperWall;
    public static Block copperWallLarge;
    public static Block titaniumWall;
    public static Block titaniumWallLarge;
    public static Block plastaniumWall;
    public static Block plastaniumWallLarge;
    public static Block thoriumWall;
    public static Block thoriumWallLarge;
    public static Block door;
    public static Block doorLarge;
    public static Block phaseWall;
    public static Block phaseWallLarge;
    public static Block surgeWall;
    public static Block surgeWallLarge;
    public static Block scrapWall;
    public static Block scrapWallLarge;
    public static Block scrapWallHuge;
    public static Block scrapWallGigantic;
    public static Block thruster;
    public static Block berylliumWall;
    public static Block berylliumWallLarge;
    public static Block tungstenWall;
    public static Block tungstenWallLarge;
    public static Block blastDoor;
    public static Block reinforcedSurgeWall;
    public static Block reinforcedSurgeWallLarge;
    public static Block carbideWall;
    public static Block carbideWallLarge;
    public static Block shieldedWall;
    public static Block mender;
    public static Block mendProjector;
    public static Block overdriveProjector;
    public static Block overdriveDome;
    public static Block forceProjector;
    public static Block shockMine;
    public static Block radar;
    public static Block buildTower;
    public static Block regenProjector;
    public static Block barrierProjector;
    public static Block shockwaveTower;
    public static Block shieldProjector;
    public static Block largeShieldProjector;
    public static Block shieldBreaker;
    public static Block conveyor;
    public static Block titaniumConveyor;
    public static Block plastaniumConveyor;
    public static Block armoredConveyor;
    public static Block distributor;
    public static Block junction;
    public static Block itemBridge;
    public static Block phaseConveyor;
    public static Block sorter;
    public static Block invertedSorter;
    public static Block router;
    public static Block overflowGate;
    public static Block underflowGate;
    public static Block unloader;
    public static Block massDriver;
    public static Block duct;
    public static Block armoredDuct;
    public static Block ductRouter;
    public static Block overflowDuct;
    public static Block underflowDuct;
    public static Block ductBridge;
    public static Block ductUnloader;
    public static Block surgeConveyor;
    public static Block surgeRouter;
    public static Block unitCargoLoader;
    public static Block unitCargoUnloadPoint;
    public static Block mechanicalPump;
    public static Block rotaryPump;
    public static Block impulsePump;
    public static Block conduit;
    public static Block pulseConduit;
    public static Block platedConduit;
    public static Block liquidRouter;
    public static Block liquidContainer;
    public static Block liquidTank;
    public static Block liquidJunction;
    public static Block bridgeConduit;
    public static Block phaseConduit;
    public static Block reinforcedPump;
    public static Block reinforcedConduit;
    public static Block reinforcedLiquidJunction;
    public static Block reinforcedBridgeConduit;
    public static Block reinforcedLiquidRouter;
    public static Block reinforcedLiquidContainer;
    public static Block reinforcedLiquidTank;
    public static Block combustionGenerator;
    public static Block thermalGenerator;
    public static Block steamGenerator;
    public static Block differentialGenerator;
    public static Block rtgGenerator;
    public static Block solarPanel;
    public static Block largeSolarPanel;
    public static Block thoriumReactor;
    public static Block impactReactor;
    public static Block battery;
    public static Block batteryLarge;
    public static Block powerNode;
    public static Block powerNodeLarge;
    public static Block surgeTower;
    public static Block diode;
    public static Block turbineCondenser;
    public static Block ventCondenser;
    public static Block chemicalCombustionChamber;
    public static Block pyrolysisGenerator;
    public static Block fluxReactor;
    public static Block neoplasiaReactor;
    public static Block beamNode;
    public static Block beamTower;
    public static Block beamLink;
    public static Block mechanicalDrill;
    public static Block pneumaticDrill;
    public static Block laserDrill;
    public static Block blastDrill;
    public static Block waterExtractor;
    public static Block oilExtractor;
    public static Block cultivator;
    public static Block cliffCrusher;
    public static Block largeCliffCrusher;
    public static Block plasmaBore;
    public static Block largePlasmaBore;
    public static Block impactDrill;
    public static Block eruptionDrill;
    public static Block coreShard;
    public static Block coreFoundation;
    public static Block coreNucleus;
    public static Block vault;
    public static Block container;
    public static Block coreBastion;
    public static Block coreCitadel;
    public static Block coreAcropolis;
    public static Block reinforcedContainer;
    public static Block reinforcedVault;
    public static Block duo;
    public static Block scatter;
    public static Block scorch;
    public static Block hail;
    public static Block arc;
    public static Block wave;
    public static Block lancer;
    public static Block swarmer;
    public static Block salvo;
    public static Block fuse;
    public static Block ripple;
    public static Block cyclone;
    public static Block foreshadow;
    public static Block spectre;
    public static Block meltdown;
    public static Block segment;
    public static Block parallax;
    public static Block tsunami;
    public static Block breach;
    public static Block diffuse;
    public static Block sublimate;
    public static Block titan;
    public static Block disperse;
    public static Block afflict;
    public static Block lustre;
    public static Block scathe;
    public static Block smite;
    public static Block malign;
    public static Block groundFactory;
    public static Block airFactory;
    public static Block navalFactory;
    public static Block additiveReconstructor;
    public static Block multiplicativeReconstructor;
    public static Block exponentialReconstructor;
    public static Block tetrativeReconstructor;
    public static Block repairPoint;
    public static Block repairTurret;
    public static Block tankFabricator;
    public static Block shipFabricator;
    public static Block mechFabricator;
    public static Block tankRefabricator;
    public static Block shipRefabricator;
    public static Block mechRefabricator;
    public static Block primeRefabricator;
    public static Block tankAssembler;
    public static Block shipAssembler;
    public static Block mechAssembler;
    public static Block basicAssemblerModule;
    public static Block unitRepairTower;
    public static Block payloadConveyor;
    public static Block payloadRouter;
    public static Block reinforcedPayloadConveyor;
    public static Block reinforcedPayloadRouter;
    public static Block payloadMassDriver;
    public static Block largePayloadMassDriver;
    public static Block smallDeconstructor;
    public static Block deconstructor;
    public static Block constructor;
    public static Block largeConstructor;
    public static Block payloadLoader;
    public static Block payloadUnloader;
    public static Block message;
    public static Block switchBlock;
    public static Block microProcessor;
    public static Block logicProcessor;
    public static Block hyperProcessor;
    public static Block largeLogicDisplay;
    public static Block logicDisplay;
    public static Block tileLogicDisplay;
    public static Block memoryCell;
    public static Block memoryBank;
    public static Block canvas;
    public static Block reinforcedMessage;
    public static Block worldProcessor;
    public static Block worldCell;
    public static Block worldMessage;
    public static Block worldSwitch;
    public static Block launchPad;
    public static Block advancedLaunchPad;
    public static Block landingPad;
    public static Block interplanetaryAccelerator;

    public static void load() {
        air = new AirBlock("air");
        spawn = new SpawnBlock("spawn");
        removeWall = new RemoveWall("remove-wall");
        removeOre = new RemoveOre("remove-ore");
        cliff = new Cliff("cliff"){
            {
                this.inEditor = false;
                this.saveData = true;
            }
        };
        for (int i = 1; i <= 16; ++i) {
            new ConstructBlock(i);
        }
        deepwater = new Floor("deep-water"){
            {
                this.speedMultiplier = 0.2f;
                this.variants = 0;
                this.liquidDrop = Liquids.water;
                this.liquidMultiplier = 1.5f;
                this.isLiquid = true;
                this.status = StatusEffects.wet;
                this.statusDuration = 120.0f;
                this.drownTime = 200.0f;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        water = new Floor("shallow-water"){
            {
                this.speedMultiplier = 0.5f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 90.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        taintedWater = new Floor("tainted-water"){
            {
                this.speedMultiplier = 0.5f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 90.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.9f;
                this.attributes.set(Attribute.spores, 0.15f);
                this.supportsOverlay = true;
            }
        };
        deepTaintedWater = new Floor("deep-tainted-water"){
            {
                this.speedMultiplier = 0.18f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 140.0f;
                this.drownTime = 200.0f;
                this.liquidDrop = Liquids.water;
                this.liquidMultiplier = 1.5f;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.9f;
                this.attributes.set(Attribute.spores, 0.15f);
                this.supportsOverlay = true;
            }
        };
        darksandTaintedWater = new ShallowLiquid("darksand-tainted-water"){
            {
                this.speedMultiplier = 0.75f;
                this.statusDuration = 60.0f;
                this.albedo = 0.9f;
                this.attributes.set(Attribute.spores, 0.1f);
                this.supportsOverlay = true;
            }
        };
        sandWater = new ShallowLiquid("sand-water"){
            {
                this.speedMultiplier = 0.8f;
                this.statusDuration = 50.0f;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        darksandWater = new ShallowLiquid("darksand-water"){
            {
                this.speedMultiplier = 0.8f;
                this.statusDuration = 50.0f;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        tar = new Floor("tar"){
            {
                this.drownTime = 230.0f;
                this.status = StatusEffects.tarred;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 0.19f;
                this.variants = 0;
                this.liquidDrop = Liquids.oil;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.tar;
                this.obstructsLight = true;
            }
        };
        cryofluid = new Floor("pooled-cryofluid"){
            {
                this.supportsOverlay = true;
                this.overlayAlpha = 0.35f;
                this.drownTime = 150.0f;
                this.status = StatusEffects.freezing;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 0.5f;
                this.variants = 0;
                this.liquidDrop = Liquids.cryofluid;
                this.liquidMultiplier = 0.5f;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.cryofluid;
                this.emitLight = true;
                this.lightRadius = 25.0f;
                this.lightColor = Color.cyan.cpy().a(0.19f);
                this.obstructsLight = true;
                this.forceDrawLight = true;
            }
        };
        slag = new Floor("molten-slag"){
            {
                this.drownTime = 230.0f;
                this.status = StatusEffects.melting;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 0.19f;
                this.variants = 0;
                this.liquidDrop = Liquids.slag;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.slag;
                this.attributes.set(Attribute.heat, 0.85f);
                this.emitLight = true;
                this.lightRadius = 40.0f;
                this.lightColor = Color.orange.cpy().a(0.38f);
                this.obstructsLight = true;
                this.forceDrawLight = true;
            }
        };
        space = new Floor("space"){
            {
                this.cacheLayer = CacheLayer.space;
                this.placeableOn = false;
                this.solid = true;
                this.variants = 0;
                this.canShadow = false;
                this.drawEdgeOut = false;
            }
        };
        empty = new EmptyFloor("empty");
        stone = new Floor("stone");
        craters = new Floor("crater-stone"){
            {
                this.variants = 3;
                this.blendGroup = stone;
            }
        };
        charr = new Floor("char"){
            {
                this.blendGroup = stone;
                this.attributes.set(Attribute.water, -0.25f);
            }
        };
        basalt = new Floor("basalt"){
            {
                this.attributes.set(Attribute.water, -0.25f);
            }
        };
        hotrock = new Floor("hotrock"){
            {
                this.attributes.set(Attribute.heat, 0.5f);
                this.attributes.set(Attribute.water, -0.5f);
                this.blendGroup = basalt;
                this.emitLight = true;
                this.lightRadius = 30.0f;
                this.lightColor = Color.orange.cpy().a(0.15f);
            }
        };
        magmarock = new Floor("magmarock"){
            {
                this.attributes.set(Attribute.heat, 0.75f);
                this.attributes.set(Attribute.water, -0.75f);
                this.blendGroup = basalt;
                this.emitLight = true;
                this.lightRadius = 50.0f;
                this.lightColor = Color.orange.cpy().a(0.3f);
            }
        };
        sand = new Floor("sand-floor"){
            {
                this.itemDrop = Items.sand;
                this.playerUnmineable = true;
                this.attributes.set(Attribute.oil, 0.7f);
            }
        };
        darksand = new Floor("darksand"){
            {
                this.itemDrop = Items.sand;
                this.playerUnmineable = true;
                this.attributes.set(Attribute.oil, 1.5f);
            }
        };
        dirt = new Floor("dirt");
        mud = new Floor("mud"){
            {
                this.speedMultiplier = 0.6f;
                this.variants = 3;
                this.status = StatusEffects.muddy;
                this.statusDuration = 30.0f;
                this.attributes.set(Attribute.water, 1.0f);
                this.cacheLayer = CacheLayer.mud;
                this.walkSound = Sounds.stepMud;
                this.walkSoundVolume = 0.08f;
                this.walkSoundPitchMin = 0.4f;
                this.walkSoundPitchMax = 0.5f;
            }
        };
        ((ShallowLiquid)darksandTaintedWater).set(taintedWater, darksand);
        ((ShallowLiquid)sandWater).set(water, sand);
        ((ShallowLiquid)darksandWater).set(water, darksand);
        dacite = new Floor("dacite");
        rhyolite = new Floor("rhyolite"){
            {
                this.attributes.set(Attribute.water, -1.0f);
            }
        };
        rhyoliteCrater = new Floor("rhyolite-crater"){
            {
                this.attributes.set(Attribute.water, -1.0f);
                this.blendGroup = rhyolite;
            }
        };
        roughRhyolite = new Floor("rough-rhyolite"){
            {
                this.attributes.set(Attribute.water, -1.0f);
                this.variants = 3;
            }
        };
        regolith = new Floor("regolith"){
            {
                this.attributes.set(Attribute.water, -1.0f);
            }
        };
        yellowStone = new Floor("yellow-stone"){
            {
                this.attributes.set(Attribute.water, -1.0f);
            }
        };
        carbonStone = new Floor("carbon-stone"){
            {
                this.attributes.set(Attribute.water, -1.0f);
                this.variants = 4;
            }
        };
        ferricStone = new Floor("ferric-stone"){
            {
                this.attributes.set(Attribute.water, -1.0f);
            }
        };
        ferricCraters = new Floor("ferric-craters"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.water, -1.0f);
                this.blendGroup = ferricStone;
            }
        };
        beryllicStone = new Floor("beryllic-stone"){
            {
                this.variants = 4;
            }
        };
        crystallineStone = new Floor("crystalline-stone"){
            {
                this.variants = 5;
            }
        };
        crystalFloor = new Floor("crystal-floor"){
            {
                this.variants = 4;
            }
        };
        yellowStonePlates = new Floor("yellow-stone-plates"){
            {
                this.variants = 3;
            }
        };
        redStone = new Floor("red-stone"){
            {
                this.attributes.set(Attribute.water, -1.0f);
                this.variants = 4;
            }
        };
        denseRedStone = new Floor("dense-red-stone"){
            {
                this.attributes.set(Attribute.water, -1.0f);
                this.variants = 4;
            }
        };
        redIce = new Floor("red-ice"){
            {
                this.dragMultiplier = 0.4f;
                this.speedMultiplier = 0.9f;
                this.attributes.set(Attribute.water, 0.4f);
            }
        };
        arkyciteFloor = new Floor("arkycite-floor"){
            {
                this.speedMultiplier = 0.3f;
                this.variants = 0;
                this.liquidDrop = Liquids.arkycite;
                this.isLiquid = true;
                this.drownTime = 200.0f;
                this.cacheLayer = CacheLayer.arkycite;
                this.albedo = 0.9f;
                this.obstructsLight = true;
            }
        };
        arkyicStone = new Floor("arkyic-stone"){
            {
                this.variants = 3;
            }
        };
        rhyoliteVent = new SteamVent("rhyolite-vent"){
            {
                this.parent = this.blendGroup = rhyolite;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        carbonVent = new SteamVent("carbon-vent"){
            {
                this.parent = this.blendGroup = carbonStone;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        arkyicVent = new SteamVent("arkyic-vent"){
            {
                this.parent = this.blendGroup = arkyicStone;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        yellowStoneVent = new SteamVent("yellow-stone-vent"){
            {
                this.parent = this.blendGroup = yellowStone;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        redStoneVent = new SteamVent("red-stone-vent"){
            {
                this.parent = this.blendGroup = denseRedStone;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        crystallineVent = new SteamVent("crystalline-vent"){
            {
                this.parent = this.blendGroup = crystallineStone;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        stoneVent = new SteamVent("stone-vent"){
            {
                this.parent = this.blendGroup = stone;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        basaltVent = new SteamVent("basalt-vent"){
            {
                this.parent = this.blendGroup = basalt;
                this.attributes.set(Attribute.steam, 1.0f);
            }
        };
        redmat = new Floor("redmat");
        bluemat = new Floor("bluemat");
        grass = new Floor("grass"){
            {
                this.attributes.set(Attribute.water, 0.1f);
            }
        };
        salt = new Floor("salt"){
            {
                this.variants = 0;
                this.attributes.set(Attribute.water, -0.3f);
                this.attributes.set(Attribute.oil, 0.3f);
            }
        };
        snow = new Floor("snow"){
            {
                this.attributes.set(Attribute.water, 0.2f);
                this.albedo = 0.7f;
            }
        };
        ice = new Floor("ice"){
            {
                this.dragMultiplier = 0.35f;
                this.speedMultiplier = 0.9f;
                this.attributes.set(Attribute.water, 0.4f);
                this.albedo = 0.65f;
            }
        };
        iceSnow = new Floor("ice-snow"){
            {
                this.dragMultiplier = 0.6f;
                this.variants = 3;
                this.attributes.set(Attribute.water, 0.3f);
                this.albedo = 0.6f;
            }
        };
        shale = new Floor("shale"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.oil, 2.0f);
            }
        };
        moss = new Floor("moss"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.spores, 0.15f);
            }
        };
        coreZone = new Floor("core-zone"){
            {
                this.variants = 0;
                this.allowCorePlacement = true;
            }
        };
        sporeMoss = new Floor("spore-moss"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.spores, 0.3f);
            }
        };
        stoneWall = new StaticWall("stone-wall"){
            {
                this.attributes.set(Attribute.sand, 1.0f);
            }
        };
        sporeWall = new StaticWall("spore-wall"){
            {
                Blocks.deepTaintedWater.asFloor().wall = Blocks.sporeMoss.asFloor().wall = this;
                Blocks.taintedWater.asFloor().wall = Blocks.sporeMoss.asFloor().wall;
            }
        };
        dirtWall = new StaticWall("dirt-wall");
        daciteWall = new StaticWall("dacite-wall");
        iceWall = new StaticWall("ice-wall"){
            {
                Blocks.iceSnow.asFloor().wall = this;
                this.albedo = 0.6f;
            }
        };
        snowWall = new StaticWall("snow-wall");
        duneWall = new StaticWall("dune-wall"){
            {
                Blocks.darksandWater.asFloor().wall = Blocks.darksandTaintedWater.asFloor().wall = this;
                Blocks.basalt.asFloor().wall = Blocks.darksandTaintedWater.asFloor().wall;
                Blocks.magmarock.asFloor().wall = Blocks.darksandTaintedWater.asFloor().wall;
                Blocks.hotrock.asFloor().wall = Blocks.darksandTaintedWater.asFloor().wall;
                this.attributes.set(Attribute.sand, 2.0f);
            }
        };
        regolithWall = new StaticWall("regolith-wall"){
            {
                Blocks.regolith.asFloor().wall = this;
                this.attributes.set(Attribute.sand, 1.0f);
            }
        };
        yellowStoneWall = new StaticWall("yellow-stone-wall"){
            {
                Blocks.slag.asFloor().wall = Blocks.yellowStonePlates.asFloor().wall = this;
                Blocks.yellowStone.asFloor().wall = Blocks.yellowStonePlates.asFloor().wall;
                this.attributes.set(Attribute.sand, 1.5f);
            }
        };
        rhyoliteWall = new StaticWall("rhyolite-wall"){
            {
                Blocks.rhyoliteCrater.asFloor().wall = Blocks.roughRhyolite.asFloor().wall = this;
                Blocks.rhyolite.asFloor().wall = Blocks.roughRhyolite.asFloor().wall;
                this.attributes.set(Attribute.sand, 1.0f);
            }
        };
        carbonWall = new StaticWall("carbon-wall"){
            {
                Blocks.carbonStone.asFloor().wall = this;
                this.attributes.set(Attribute.sand, 0.7f);
            }
        };
        ferricStoneWall = new StaticWall("ferric-stone-wall"){
            {
                Blocks.ferricStone.asFloor().wall = this;
                this.attributes.set(Attribute.sand, 0.5f);
            }
        };
        beryllicStoneWall = new StaticWall("beryllic-stone-wall"){
            {
                Blocks.beryllicStone.asFloor().wall = this;
                this.attributes.set(Attribute.sand, 1.2f);
            }
        };
        arkyicWall = new StaticWall("arkyic-wall"){
            {
                this.variants = 3;
                Blocks.arkyciteFloor.asFloor().wall = Blocks.arkyicStone.asFloor().wall = this;
            }
        };
        crystallineStoneWall = new StaticWall("crystalline-stone-wall"){
            {
                this.variants = 4;
                Blocks.crystallineStone.asFloor().wall = Blocks.crystalFloor.asFloor().wall = this;
            }
        };
        redIceWall = new StaticWall("red-ice-wall"){
            {
                Blocks.redIce.asFloor().wall = this;
            }
        };
        redStoneWall = new StaticWall("red-stone-wall"){
            {
                Blocks.redStone.asFloor().wall = Blocks.denseRedStone.asFloor().wall = this;
                this.attributes.set(Attribute.sand, 1.5f);
            }
        };
        redDiamondWall = new StaticTree("red-diamond-wall"){
            {
                this.variants = 3;
            }
        };
        sandWall = new StaticWall("sand-wall"){
            {
                Blocks.deepwater.asFloor().wall = Blocks.sand.asFloor().wall = this;
                Blocks.water.asFloor().wall = Blocks.sand.asFloor().wall;
                Blocks.sandWater.asFloor().wall = Blocks.sand.asFloor().wall;
                this.attributes.set(Attribute.sand, 2.0f);
            }
        };
        saltWall = new StaticWall("salt-wall");
        shrubs = new StaticWall("shrubs");
        shaleWall = new StaticWall("shale-wall");
        sporePine = new StaticTree("spore-pine"){
            {
                Blocks.moss.asFloor().wall = this;
            }
        };
        snowPine = new StaticTree("snow-pine");
        pine = new StaticTree("pine");
        whiteTreeDead = new TreeBlock("white-tree-dead");
        whiteTree = new TreeBlock("white-tree");
        sporeCluster = new Prop("spore-cluster"){
            {
                this.variants = 3;
                this.breakSound = Sounds.plantBreak;
                this.obstructsLight = false;
            }
        };
        redweed = new Seaweed("redweed"){
            {
                this.variants = 3;
                Blocks.redmat.asFloor().decoration = this;
            }
        };
        purbush = new SeaBush("pur-bush"){
            {
                Blocks.bluemat.asFloor().decoration = this;
            }
        };
        yellowCoral = new SeaBush("yellowcoral"){
            {
                this.lobesMin = 2;
                this.lobesMax = 3;
                this.magMax = 8.0f;
                this.magMin = 2.0f;
                this.origin = 0.3f;
                this.spread = 40.0f;
                this.sclMin = 60.0f;
                this.sclMax = 100.0f;
            }
        };
        boulder = new Prop("boulder"){
            {
                this.variants = 2;
                Blocks.craters.asFloor().decoration = Blocks.charr.asFloor().decoration = this;
                Blocks.stone.asFloor().decoration = Blocks.charr.asFloor().decoration;
            }
        };
        snowBoulder = new Prop("snow-boulder"){
            {
                this.variants = 2;
                Blocks.iceSnow.asFloor().decoration = Blocks.salt.asFloor().decoration = this;
                Blocks.ice.asFloor().decoration = Blocks.salt.asFloor().decoration;
                Blocks.snow.asFloor().decoration = Blocks.salt.asFloor().decoration;
            }
        };
        shaleBoulder = new Prop("shale-boulder"){
            {
                this.variants = 2;
                Blocks.shale.asFloor().decoration = this;
            }
        };
        sandBoulder = new Prop("sand-boulder"){
            {
                this.variants = 2;
                Blocks.sand.asFloor().decoration = this;
            }
        };
        daciteBoulder = new Prop("dacite-boulder"){
            {
                this.variants = 2;
                Blocks.dacite.asFloor().decoration = this;
            }
        };
        basaltBoulder = new Prop("basalt-boulder"){
            {
                this.variants = 2;
                Blocks.darksand.asFloor().decoration = Blocks.magmarock.asFloor().decoration = this;
                Blocks.hotrock.asFloor().decoration = Blocks.magmarock.asFloor().decoration;
                Blocks.basalt.asFloor().decoration = Blocks.magmarock.asFloor().decoration;
            }
        };
        carbonBoulder = new Prop("carbon-boulder"){
            {
                this.variants = 2;
                Blocks.carbonStone.asFloor().decoration = this;
            }
        };
        ferricBoulder = new Prop("ferric-boulder"){
            {
                this.variants = 2;
                Blocks.ferricStone.asFloor().decoration = Blocks.ferricCraters.asFloor().decoration = this;
            }
        };
        beryllicBoulder = new Prop("beryllic-boulder"){
            {
                this.variants = 2;
                Blocks.beryllicStone.asFloor().decoration = this;
            }
        };
        yellowStoneBoulder = new Prop("yellow-stone-boulder"){
            {
                this.variants = 2;
                Blocks.regolith.asFloor().decoration = Blocks.yellowStonePlates.asFloor().decoration = this;
                Blocks.yellowStone.asFloor().decoration = Blocks.yellowStonePlates.asFloor().decoration;
            }
        };
        arkyicBoulder = new Prop("arkyic-boulder"){
            {
                this.variants = 3;
                this.customShadow = true;
                Blocks.arkyicStone.asFloor().decoration = this;
                this.obstructsLight = false;
            }
        };
        crystalCluster = new TallBlock("crystal-cluster"){
            {
                this.variants = 3;
                this.clipSize = 128.0f;
            }
        };
        vibrantCrystalCluster = new TallBlock("vibrant-crystal-cluster"){
            {
                this.variants = 3;
                this.clipSize = 128.0f;
            }
        };
        crystalBlocks = new TallBlock("crystal-blocks"){
            {
                this.variants = 3;
                this.clipSize = 128.0f;
                this.shadowAlpha = 0.5f;
                this.shadowOffset = -2.5f;
            }
        };
        crystalOrbs = new TallBlock("crystal-orbs"){
            {
                this.variants = 3;
                this.clipSize = 128.0f;
                this.shadowAlpha = 0.5f;
                this.shadowOffset = -2.5f;
            }
        };
        crystallineBoulder = new Prop("crystalline-boulder"){
            {
                this.variants = 2;
                Blocks.crystallineStone.asFloor().decoration = this;
            }
        };
        redIceBoulder = new Prop("red-ice-boulder"){
            {
                this.variants = 3;
                Blocks.redIce.asFloor().decoration = this;
            }
        };
        rhyoliteBoulder = new Prop("rhyolite-boulder"){
            {
                this.variants = 3;
                Blocks.rhyolite.asFloor().decoration = Blocks.roughRhyolite.asFloor().decoration = this;
            }
        };
        redStoneBoulder = new Prop("red-stone-boulder"){
            {
                this.variants = 4;
                Blocks.denseRedStone.asFloor().decoration = Blocks.redStone.asFloor().decoration = this;
            }
        };
        metalFloor = new Floor("metal-floor", 0);
        metalFloorDamaged = new Floor("metal-floor-damaged", 3);
        metalFloor2 = new Floor("metal-floor-2", 0);
        metalFloor3 = new Floor("metal-floor-3", 0);
        metalFloor4 = new Floor("metal-floor-4", 0);
        metalFloor5 = new Floor("metal-floor-5", 0);
        darkPanel1 = new Floor("dark-panel-1", 0);
        darkPanel2 = new Floor("dark-panel-2", 0);
        darkPanel3 = new Floor("dark-panel-3", 0);
        darkPanel4 = new Floor("dark-panel-4", 0);
        darkPanel5 = new Floor("dark-panel-5", 0);
        darkPanel6 = new Floor("dark-panel-6", 0);
        darkMetal = new StaticWall("dark-metal");
        metalTiles1 = new Floor("metal-tiles-1"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles2 = new Floor("metal-tiles-2"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles3 = new Floor("metal-tiles-3"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles4 = new Floor("metal-tiles-4"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles5 = new Floor("metal-tiles-5"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles6 = new Floor("metal-tiles-6"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
                this.emitLight = true;
                this.lightRadius = 30.0f;
                this.lightColor = Team.crux.color.cpy().a(0.3f);
            }
        };
        metalTiles7 = new Floor("metal-tiles-7"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
                this.autotileMidVariants = 9;
            }
        };
        metalTiles8 = new Floor("metal-tiles-8"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
                this.autotileMidVariants = 2;
            }
        };
        metalTiles9 = new Floor("metal-tiles-9"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles10 = new Floor("metal-tiles-10"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalTiles11 = new Floor("metal-tiles-11"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
                this.autotileVariants = 3;
            }
        };
        metalTiles12 = new Floor("metal-tiles-12"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
                this.autotileVariants = 4;
                this.emitLight = true;
                this.lightRadius = 30.0f;
                this.lightColor = Team.crux.color.cpy().a(0.3f);
            }
        };
        metalTiles13 = new Floor("metal-tiles-13"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
                this.autotileMidVariants = 6;
            }
        };
        metalWall1 = new StaticWall("metal-wall-1"){
            {
                this.autotile = true;
            }
        };
        metalWall2 = new StaticWall("metal-wall-2"){
            {
                this.autotile = true;
                this.autotileMidVariants = 2;
            }
        };
        metalWall3 = new StaticWall("metal-wall-3"){
            {
                this.autotile = true;
            }
        };
        coloredFloor = new ColoredFloor("colored-floor"){
            {
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        coloredWall = new ColoredWall("colored-wall"){
            {
                this.autotile = true;
            }
        };
        characterOverlayGray = new CharacterOverlay("character-overlay"){
            {
                this.color = Pal.metalGrayDark;
            }
        };
        characterOverlayWhite = new CharacterOverlay("character-overlay-white"){
            {
                this.color = Color.white;
            }
        };
        runeOverlay = new RuneOverlay("rune-overlay"){
            {
                this.color = Color.valueOf("3f4049");
            }
        };
        cruxRuneOverlay = new RuneOverlay("rune-overlay-crux");
        Seq.with(metalFloor, metalFloorDamaged, metalFloor2, metalFloor3, metalFloor4, metalFloor5, darkPanel1, darkPanel2, darkPanel3, darkPanel4, darkPanel5, darkPanel6).each(b -> {
            b.asFloor().wall = darkMetal;
        });
        pebbles = new OverlayFloor("pebbles");
        tendrils = new OverlayFloor("tendrils");
        oreCopper = new OreBlock(Items.copper){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.81f;
                this.oreScale = 23.47619f;
            }
        };
        oreLead = new OreBlock(Items.lead){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.828f;
                this.oreScale = 23.952381f;
            }
        };
        oreScrap = new OreBlock(Items.scrap);
        oreCoal = new OreBlock(Items.coal){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.846f;
                this.oreScale = 24.428572f;
            }
        };
        oreTitanium = new OreBlock(Items.titanium){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.864f;
                this.oreScale = 24.904762f;
            }
        };
        oreThorium = new OreBlock(Items.thorium){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.882f;
                this.oreScale = 25.380953f;
            }
        };
        oreBeryllium = new OreBlock(Items.beryllium);
        oreTungsten = new OreBlock(Items.tungsten);
        oreCrystalThorium = new OreBlock("ore-crystal-thorium", Items.thorium);
        wallOreThorium = new OreBlock("ore-wall-thorium", Items.thorium){
            {
                this.wallOre = true;
            }
        };
        wallOreBeryllium = new OreBlock("ore-wall-beryllium", Items.beryllium){
            {
                this.wallOre = true;
            }
        };
        graphiticWall = new StaticWall("graphitic-wall"){
            {
                this.itemDrop = Items.graphite;
                this.variants = 3;
            }
        };
        wallOreGraphite = new OreBlock("ore-wall-graphite", Items.graphite){
            {
                this.wallOre = true;
            }
        };
        wallOreTungsten = new OreBlock("ore-wall-tungsten", Items.tungsten){
            {
                this.wallOre = true;
            }
        };
        graphitePress = new GenericCrafter("graphite-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 75, Items.lead, 30));
                this.craftEffect = Fx.pulverizeMedium;
                this.outputItem = new ItemStack(Items.graphite, 1);
                this.craftTime = 90.0f;
                this.size = 2;
                this.hasItems = true;
                this.consumeItem(Items.coal, 2);
            }
        };
        multiPress = new GenericCrafter("multi-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 100, Items.silicon, 25, Items.lead, 100, Items.graphite, 50));
                this.craftEffect = Fx.pulverizeMedium;
                this.outputItem = new ItemStack(Items.graphite, 2);
                this.craftTime = 30.0f;
                this.itemCapacity = 20;
                this.size = 3;
                this.hasItems = true;
                this.hasLiquids = true;
                this.hasPower = true;
                this.consumePower(1.8f);
                this.consumeItem(Items.coal, 3);
                this.consumeLiquid(Liquids.water, 0.1f);
            }
        };
        siliconSmelter = new GenericCrafter("silicon-smelter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 25));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.silicon, 1);
                this.craftTime = 40.0f;
                this.size = 2;
                this.hasPower = true;
                this.hasLiquids = false;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawFlame(Color.valueOf("ffef99")));
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.07f;
                this.consumeItems(ItemStack.with(Items.coal, 1, Items.sand, 2));
                this.consumePower(0.5f);
            }
        };
        siliconCrucible = new AttributeCrafter("silicon-crucible"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 120, Items.metaglass, 80, Items.plastanium, 35, Items.silicon, 60));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.silicon, 8);
                this.craftTime = 90.0f;
                this.size = 3;
                this.hasPower = true;
                this.hasLiquids = false;
                this.itemCapacity = 30;
                this.boostScale = 0.15f;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawFlame(Color.valueOf("ffef99")));
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.07f;
                this.consumeItems(ItemStack.with(Items.coal, 4, Items.sand, 6, Items.pyratite, 1));
                this.consumePower(4.0f);
            }
        };
        kiln = new GenericCrafter("kiln"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 60, Items.graphite, 30, Items.lead, 30));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.metaglass, 1);
                this.craftTime = 30.0f;
                this.size = 2;
                this.hasItems = true;
                this.hasPower = true;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawFlame(Color.valueOf("ffc099")));
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.07f;
                this.consumeItems(ItemStack.with(Items.lead, 1, Items.sand, 1));
                this.consumePower(0.6f);
            }
        };
        plastaniumCompressor = new GenericCrafter("plastanium-compressor"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 80, Items.lead, 115, Items.graphite, 60, Items.titanium, 80));
                this.hasItems = true;
                this.liquidCapacity = 60.0f;
                this.craftTime = 60.0f;
                this.outputItem = new ItemStack(Items.plastanium, 1);
                this.size = 2;
                this.health = 320;
                this.hasLiquids = true;
                this.hasPower = true;
                this.craftEffect = Fx.formsmoke;
                this.updateEffect = Fx.plasticburn;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawFade());
                this.consumeLiquid(Liquids.oil, 0.25f);
                this.consumePower(3.0f);
                this.consumeItem(Items.titanium, 2);
            }
        };
        phaseWeaver = new GenericCrafter("phase-weaver"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 130, Items.lead, 120, Items.thorium, 75));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.phaseFabric, 1);
                this.craftTime = 120.0f;
                this.size = 2;
                this.hasPower = true;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawWeave(), new DrawDefault());
                this.envEnabled |= 2;
                this.ambientSound = Sounds.loopTech;
                this.ambientSoundVolume = 0.02f;
                this.consumeItems(ItemStack.with(Items.thorium, 4, Items.sand, 10));
                this.consumePower(5.0f);
                this.itemCapacity = 30;
            }
        };
        surgeSmelter = new GenericCrafter("surge-smelter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 80, Items.lead, 80, Items.thorium, 70));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.surgeAlloy, 1);
                this.craftTime = 75.0f;
                this.size = 3;
                this.hasPower = true;
                this.itemCapacity = 20;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawFlame());
                this.consumePower(4.0f);
                this.consumeItems(ItemStack.with(Items.copper, 3, Items.lead, 4, Items.titanium, 2, Items.silicon, 3));
            }
        };
        cryofluidMixer = new GenericCrafter("cryofluid-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 65, Items.silicon, 40, Items.titanium, 60));
                this.outputLiquid = new LiquidStack(Liquids.cryofluid, 0.2f);
                this.size = 2;
                this.hasPower = true;
                this.hasItems = true;
                this.hasLiquids = true;
                this.rotate = false;
                this.solid = true;
                this.outputsLiquid = true;
                this.envEnabled = -1;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.water), new DrawLiquidTile(Liquids.cryofluid){
                    {
                        super(drawLiquid);
                        drawLiquidLight = true;
                    }
                }, new DrawDefault());
                this.liquidCapacity = 36.0f;
                this.craftTime = 120.0f;
                this.lightLiquid = Liquids.cryofluid;
                this.consumePower(1.0f);
                this.consumeItem(Items.titanium);
                this.consumeLiquid(Liquids.water, 0.2f);
            }
        };
        pyratiteMixer = new GenericCrafter("pyratite-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 50, Items.lead, 25));
                this.hasItems = true;
                this.hasPower = true;
                this.outputItem = new ItemStack(Items.pyratite, 1);
                this.envEnabled |= 2;
                this.size = 2;
                this.ambientSound = Sounds.loopMachineSpin;
                this.ambientSoundVolume = 0.1f;
                this.consumePower(0.2f);
                this.consumeItems(ItemStack.with(Items.coal, 1, Items.lead, 2, Items.sand, 2));
            }
        };
        blastMixer = new GenericCrafter("blast-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 30, Items.titanium, 20));
                this.hasItems = true;
                this.hasPower = true;
                this.outputItem = new ItemStack(Items.blastCompound, 1);
                this.size = 2;
                this.envEnabled |= 2;
                this.ambientSound = Sounds.loopMachineSpin;
                this.ambientSoundVolume = 0.12f;
                this.consumeItems(ItemStack.with(Items.pyratite, 1, Items.sporePod, 1));
                this.consumePower(0.4f);
            }
        };
        melter = new GenericCrafter("melter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 35, Items.graphite, 45));
                this.health = 200;
                this.outputLiquid = new LiquidStack(Liquids.slag, 0.2f);
                this.craftTime = 10.0f;
                this.hasPower = true;
                this.hasLiquids = true;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(), new DrawDefault());
                this.consumePower(1.0f);
                this.consumeItem(Items.scrap, 1);
            }
        };
        separator = new Separator("separator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.titanium, 25));
                this.results = ItemStack.with(Items.copper, 5, Items.lead, 3, Items.graphite, 2, Items.titanium, 2);
                this.hasPower = true;
                this.craftTime = 35.0f;
                this.size = 2;
                this.consumePower(1.1f);
                this.consumeLiquid(Liquids.slag, 0.06666667f);
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(), new DrawRegion("-spinner", 3.0f, true), new DrawDefault());
            }
        };
        disassembler = new Separator("disassembler"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.plastanium, 40, Items.titanium, 100, Items.silicon, 150, Items.thorium, 80));
                this.results = ItemStack.with(Items.sand, 2, Items.graphite, 1, Items.titanium, 1, Items.thorium, 1);
                this.hasPower = true;
                this.craftTime = 15.0f;
                this.size = 3;
                this.itemCapacity = 20;
                this.consumePower(4.0f);
                this.consumeItem(Items.scrap);
                this.consumeLiquid(Liquids.slag, 0.12f);
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(), new DrawRegion("-spinner", 3.0f, true), new DrawDefault());
            }
        };
        sporePress = new GenericCrafter("spore-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 35, Items.silicon, 30));
                this.liquidCapacity = 60.0f;
                this.craftTime = 20.0f;
                this.outputLiquid = new LiquidStack(Liquids.oil, 0.3f);
                this.size = 2;
                this.health = 320;
                this.hasLiquids = true;
                this.hasPower = true;
                this.craftEffect = Fx.none;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawPistons(){
                    {
                        this.sinMag = 1.0f;
                    }
                }, new DrawDefault(), new DrawLiquidRegion(), new DrawRegion("-top"));
                this.consumeItem(Items.sporePod, 1);
                this.consumePower(0.7f);
            }
        };
        pulverizer = new GenericCrafter("pulverizer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 25));
                this.outputItem = new ItemStack(Items.sand, 1);
                this.craftEffect = Fx.pulverize;
                this.craftTime = 40.0f;
                this.updateEffect = Fx.pulverizeSmall;
                this.hasPower = true;
                this.hasItems = true;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawRegion("-rotator"){
                    {
                        super(suffix);
                        this.spinSprite = true;
                        this.rotateSpeed = 2.0f;
                    }
                }, new DrawRegion("-top"));
                this.ambientSound = Sounds.loopGrind;
                this.ambientSoundVolume = 0.025f;
                this.consumeItem(Items.scrap, 1);
                this.consumePower(0.5f);
            }
        };
        coalCentrifuge = new GenericCrafter("coal-centrifuge"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 20, Items.graphite, 40, Items.lead, 30));
                this.craftEffect = Fx.coalSmeltsmoke;
                this.outputItem = new ItemStack(Items.coal, 1);
                this.craftTime = 30.0f;
                this.size = 2;
                this.hasLiquids = true;
                this.hasItems = true;
                this.hasPower = true;
                this.rotateDraw = false;
                this.consumeLiquid(Liquids.oil, 0.1f);
                this.consumePower(0.7f);
            }
        };
        incinerator = new Incinerator("incinerator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.graphite, 5, Items.lead, 15));
                this.health = 90;
                this.envEnabled |= 2;
                this.consumePower(0.5f);
            }
        };
        siliconArcFurnace = new GenericCrafter("silicon-arc-furnace"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.beryllium, 70, Items.graphite, 80));
                this.craftEffect = Fx.none;
                this.outputItem = new ItemStack(Items.silicon, 4);
                this.craftTime = 50.0f;
                this.size = 3;
                this.hasPower = true;
                this.hasLiquids = false;
                this.envEnabled |= 6;
                this.envDisabled = 0;
                this.itemCapacity = 30;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawArcSmelt(), new DrawDefault());
                this.fogRadius = 3;
                this.researchCost = ItemStack.with(Items.beryllium, 150, Items.graphite, 50);
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.12f;
                this.consumeItems(ItemStack.with(Items.graphite, 1, Items.sand, 4));
                this.consumePower(5.0f);
            }
        };
        electrolyzer = new GenericCrafter("electrolyzer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 50, Items.graphite, 40, Items.beryllium, 130, Items.tungsten, 80));
                this.size = 3;
                this.researchCostMultiplier = 1.2f;
                this.craftTime = 10.0f;
                this.rotate = true;
                this.invertFlip = true;
                this.group = BlockGroup.liquids;
                this.itemCapacity = 0;
                this.liquidCapacity = 50.0f;
                this.consumeLiquid(Liquids.water, 0.16666667f);
                this.consumePower(1.0f);
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.water, 2.0f), new DrawBubbles(Color.valueOf("7693e3")){
                    {
                        super(color);
                        this.sides = 10;
                        this.recurrence = 3.0f;
                        this.spread = 6.0f;
                        this.radius = 1.5f;
                        this.amount = 20;
                    }
                }, new DrawRegion(), new DrawLiquidOutputs(), new DrawGlowRegion(){
                    {
                        this.alpha = 0.7f;
                        this.color = Color.valueOf("c4bdf3");
                        this.glowIntensity = 0.3f;
                        this.glowScale = 6.0f;
                    }
                });
                this.ambientSound = Sounds.loopElectricHum;
                this.ambientSoundVolume = 0.08f;
                this.regionRotated1 = 3;
                this.outputLiquids = LiquidStack.with(Liquids.ozone, Float.valueOf(0.06666667f), Liquids.hydrogen, Float.valueOf(0.1f));
                this.liquidOutputDirections = new int[]{1, 3};
            }
        };
        atmosphericConcentrator = new HeatCrafter("atmospheric-concentrator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.oxide, 60, Items.beryllium, 180, Items.silicon, 150));
                this.size = 3;
                this.hasLiquids = true;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.nitrogen, 4.1f), new DrawDefault(), new DrawHeatInput(), new DrawParticles(){
                    {
                        this.color = Color.valueOf("d4f0ff");
                        this.alpha = 0.6f;
                        this.particleSize = 4.0f;
                        this.particles = 10;
                        this.particleRad = 12.0f;
                        this.particleLife = 140.0f;
                    }
                });
                this.researchCostMultiplier = 1.1f;
                this.itemCapacity = 0;
                this.liquidCapacity = 60.0f;
                this.consumePower(2.0f);
                this.ambientSound = Sounds.loopExtract;
                this.ambientSoundVolume = 0.06f;
                this.maxEfficiency = 1.0f;
                this.heatRequirement = 24.0f;
                this.outputLiquid = new LiquidStack(Liquids.nitrogen, 0.26666668f);
                this.researchCost = ItemStack.with(Items.silicon, 2000, Items.oxide, 900, Items.beryllium, 2400);
            }
        };
        oxidationChamber = new HeatProducer("oxidation-chamber"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 120, Items.graphite, 80, Items.silicon, 100, Items.beryllium, 120));
                this.size = 3;
                this.outputItem = new ItemStack(Items.oxide, 1);
                this.researchCostMultiplier = 1.1f;
                this.consumeLiquid(Liquids.ozone, 0.033333335f);
                this.consumeItem(Items.beryllium);
                this.consumePower(0.5f);
                this.rotateDraw = false;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidRegion(), new DrawDefault(), new DrawHeatOutput());
                this.ambientSound = Sounds.loopExtract;
                this.ambientSoundVolume = 0.08f;
                this.regionRotated1 = 2;
                this.craftTime = 120.0f;
                this.liquidCapacity = 30.0f;
                this.heatOutput = 5.0f;
            }
        };
        electricHeater = new HeatProducer("electric-heater"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 30, Items.oxide, 30, Items.beryllium, 30));
                this.researchCostMultiplier = 4.0f;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput());
                this.rotateDraw = false;
                this.size = 2;
                this.heatOutput = 3.0f;
                this.regionRotated1 = 1;
                this.ambientSound = Sounds.loopHum;
                this.itemCapacity = 0;
                this.consumePower(1.6666666f);
            }
        };
        slagHeater = new HeatProducer("slag-heater"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 50, Items.oxide, 20, Items.beryllium, 20));
                this.researchCostMultiplier = 4.0f;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.slag), new DrawDefault(), new DrawHeatOutput());
                this.size = 3;
                this.itemCapacity = 0;
                this.liquidCapacity = 120.0f;
                this.rotateDraw = false;
                this.regionRotated1 = 1;
                this.ambientSound = Sounds.loopHum;
                this.consumeLiquid(Liquids.slag, 0.6666667f);
                this.heatOutput = 8.0f;
                this.researchCost = ItemStack.with(Items.tungsten, 1200, Items.oxide, 900, Items.beryllium, 2400);
            }
        };
        phaseHeater = new HeatProducer("phase-heater"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.oxide, 30, Items.carbide, 30, Items.beryllium, 30));
                this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput());
                this.size = 2;
                this.heatOutput = 15.0f;
                this.craftTime = 480.0f;
                this.ambientSound = Sounds.loopHum;
                this.consumeItem(Items.phaseFabric);
            }
        };
        heatRedirector = new HeatConductor("heat-redirector"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 10, Items.graphite, 10));
                this.researchCostMultiplier = 10.0f;
                this.group = BlockGroup.heat;
                this.size = 3;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput(), new DrawHeatInput("-heat"));
                this.regionRotated1 = 1;
            }
        };
        smallHeatRedirector = new HeatConductor("small-heat-redirector"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.surgeAlloy, 8, Items.graphite, 8));
                this.researchCostMultiplier = 2.0f;
                this.researchCostMultipliers.put(Items.graphite, 7.0f);
                this.group = BlockGroup.heat;
                this.size = 2;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput(), new DrawHeatInput("-heat"));
                this.regionRotated1 = 1;
            }
        };
        heatRouter = new HeatConductor("heat-router"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 15, Items.graphite, 10));
                this.researchCostMultiplier = 10.0f;
                this.group = BlockGroup.heat;
                this.size = 3;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput(-1, false), new DrawHeatOutput(), new DrawHeatOutput(1, false), new DrawHeatInput("-heat"));
                this.regionRotated1 = 1;
                this.splitHeat = true;
            }
        };
        slagIncinerator = new ItemIncinerator("slag-incinerator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 15));
                this.size = 1;
                this.consumeLiquid(Liquids.slag, 0.0f);
            }
        };
        carbideCrucible = new HeatCrafter("carbide-crucible"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.tungsten, 110, Items.thorium, 150, Items.oxide, 60));
                this.craftEffect = Fx.none;
                this.outputItem = new ItemStack(Items.carbide, 1);
                this.craftTime = 33.75f;
                this.size = 3;
                this.itemCapacity = 20;
                this.hasItems = true;
                this.hasPower = true;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawCrucibleFlame(), new DrawDefault(), new DrawHeatInput());
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.09f;
                this.heatRequirement = 40.0f;
                this.maxEfficiency = 1.0f;
                this.consumeItems(ItemStack.with(Items.tungsten, 2, Items.graphite, 3));
                this.consumePower(2.0f);
            }
        };
        slagCentrifuge = new GenericCrafter("slag-centrifuge"){
            {
                this.requirements(Category.crafting, BuildVisibility.debugOnly, ItemStack.with(Items.carbide, 70, Items.graphite, 60, Items.silicon, 40, Items.oxide, 40));
                this.consumePower(0.033333335f);
                this.size = 3;
                this.consumeItem(Items.sand, 1);
                this.consumeLiquid(Liquids.slag, 0.6666667f);
                this.liquidCapacity = 80.0f;
                Seq<DrawBlock> drawers = Seq.with(new DrawRegion("-bottom"), new DrawLiquidRegion(Liquids.slag){
                    {
                        super(drawLiquid);
                        this.alpha = 0.7f;
                    }
                });
                int i = 0;
                while (i < 5) {
                    final int fi = i++;
                    drawers.add(new DrawGlowRegion(-1.0f){
                        {
                            super(layer);
                            this.glowIntensity = 0.3f;
                            this.rotateSpeed = 3.0f / (1.0f + (float)fi / 1.4f);
                            this.alpha = 0.4f;
                            this.color = new Color(1.0f, 0.5f, 0.5f, 1.0f);
                        }
                    });
                }
                this.drawer = new DrawMulti(drawers.add(new DrawDefault()));
                this.craftTime = 120.0f;
                this.outputLiquid = new LiquidStack(Liquids.gallium, 0.016666668f);
            }
        };
        surgeCrucible = new HeatCrafter("surge-crucible"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 100, Items.graphite, 80, Items.tungsten, 80, Items.oxide, 80));
                this.size = 3;
                this.itemCapacity = 20;
                this.heatRequirement = 40.0f;
                this.maxEfficiency = 1.0f;
                this.craftTime = 45.0f;
                this.liquidCapacity = 400.0f;
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.9f;
                this.outputItem = new ItemStack(Items.surgeAlloy, 1);
                this.craftEffect = new RadialEffect(Fx.surgeCruciSmoke, 4, 90.0f, 5.0f);
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawCircles(){
                    {
                        this.color = Color.valueOf("ffc073").a(0.24f);
                        this.strokeMax = 2.5f;
                        this.radius = 10.0f;
                        this.amount = 3;
                    }
                }, new DrawLiquidRegion(Liquids.slag), new DrawDefault(), new DrawHeatInput(), new DrawHeatRegion(){
                    {
                        this.color = Color.valueOf("ff6060ff");
                    }
                }, new DrawHeatRegion("-vents"){
                    {
                        super(suffix);
                        this.color.a = 1.0f;
                    }
                });
                this.consumeItem(Items.silicon, 3);
                this.consumeLiquid(Liquids.slag, 2.6666667f);
                this.consumePower(1.5f);
            }
        };
        cyanogenSynthesizer = new HeatCrafter("cyanogen-synthesizer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.carbide, 80, Items.silicon, 120, Items.beryllium, 140, Items.oxide, 40));
                this.heatRequirement = 20.0f;
                this.maxEfficiency = 1.0f;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.cyanogen), new DrawParticles(){
                    {
                        this.color = Color.valueOf("89e8b6");
                        this.alpha = 0.5f;
                        this.particleSize = 3.0f;
                        this.particles = 10;
                        this.particleRad = 9.0f;
                        this.particleLife = 200.0f;
                        this.reverse = true;
                        this.particleSizeInterp = Interp.one;
                    }
                }, new DrawDefault(), new DrawHeatInput(), new DrawHeatRegion("-heat-top"));
                this.size = 3;
                this.ambientSound = Sounds.loopExtract;
                this.ambientSoundVolume = 0.08f;
                this.liquidCapacity = 80.0f;
                this.outputLiquid = new LiquidStack(Liquids.cyanogen, 0.2f);
                this.consumeLiquid(Liquids.arkycite, 2.6666667f);
                this.consumeItem(Items.graphite);
                this.consumePower(2.0f);
            }
        };
        phaseSynthesizer = new HeatCrafter("phase-synthesizer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.carbide, 90, Items.silicon, 100, Items.thorium, 100, Items.tungsten, 200));
                this.size = 3;
                this.itemCapacity = 40;
                this.heatRequirement = 32.0f;
                this.maxEfficiency = 1.0f;
                this.craftTime = 30.0f;
                this.liquidCapacity = 40.0f;
                this.ambientSound = Sounds.loopTech;
                this.ambientSoundVolume = 0.04f;
                this.outputItem = new ItemStack(Items.phaseFabric, 1);
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawSpikes(){
                    {
                        this.color = Color.valueOf("ffd59e");
                        this.stroke = 1.5f;
                        this.layers = 2;
                        this.amount = 12;
                        this.rotateSpeed = 0.5f;
                        this.layerSpeed = -0.9f;
                    }
                }, new DrawMultiWeave(){
                    {
                        this.glowColor = new Color(1.0f, 0.4f, 0.4f, 0.8f);
                    }
                }, new DrawDefault(), new DrawHeatInput(), new DrawHeatRegion("-vents"){
                    {
                        super(suffix);
                        this.color = new Color(1.0f, 0.4f, 0.3f, 1.0f);
                    }
                });
                this.consumeItems(ItemStack.with(Items.thorium, 2, Items.sand, 6));
                this.consumeLiquid(Liquids.ozone, 0.13333334f);
                this.consumePower(8.0f);
            }
        };
        heatReactor = new HeatProducer("heat-reactor"){
            {
                this.requirements(Category.crafting, BuildVisibility.debugOnly, ItemStack.with(Items.oxide, 70, Items.graphite, 20, Items.carbide, 10, Items.thorium, 80));
                this.size = 3;
                this.craftTime = 600.0f;
                this.craftEffect = new RadialEffect(Fx.heatReactorSmoke, 4, 90.0f, 7.0f);
                this.itemCapacity = 20;
                this.outputItem = new ItemStack(Items.fissileMatter, 1);
                this.consumeItem(Items.thorium, 3);
                this.consumeLiquid(Liquids.nitrogen, 0.016666668f);
            }
        };
        final int wallHealthMultiplier = 4;
        copperWall = new Wall("copper-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.copper, 6));
                this.health = 80 * wallHealthMultiplier;
                this.researchCostMultiplier = 0.1f;
            }
        };
        copperWallLarge = new Wall("copper-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.copperWall.requirements, 4.0f));
                this.health = 320 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        titaniumWall = new Wall("titanium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.titanium, 6));
                this.health = 110 * wallHealthMultiplier;
            }
        };
        titaniumWallLarge = new Wall("titanium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.titaniumWall.requirements, 4.0f));
                this.health = 110 * wallHealthMultiplier * 4;
                this.size = 2;
            }
        };
        plastaniumWall = new Wall("plastanium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.plastanium, 5, Items.metaglass, 2));
                this.health = 125 * wallHealthMultiplier;
                this.insulated = true;
                this.absorbLasers = true;
                this.schematicPriority = 10;
            }
        };
        plastaniumWallLarge = new Wall("plastanium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.plastaniumWall.requirements, 4.0f));
                this.health = 125 * wallHealthMultiplier * 4;
                this.size = 2;
                this.insulated = true;
                this.absorbLasers = true;
                this.schematicPriority = 10;
            }
        };
        thoriumWall = new Wall("thorium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.thorium, 6));
                this.health = 200 * wallHealthMultiplier;
            }
        };
        thoriumWallLarge = new Wall("thorium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.thoriumWall.requirements, 4.0f));
                this.health = 200 * wallHealthMultiplier * 4;
                this.size = 2;
            }
        };
        phaseWall = new Wall("phase-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.phaseFabric, 6));
                this.health = 150 * wallHealthMultiplier;
                this.chanceDeflect = 10.0f;
                this.flashHit = true;
            }
        };
        phaseWallLarge = new Wall("phase-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.phaseWall.requirements, 4.0f));
                this.health = 600 * wallHealthMultiplier;
                this.size = 2;
                this.chanceDeflect = 10.0f;
                this.flashHit = true;
            }
        };
        surgeWall = new Wall("surge-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.surgeAlloy, 6));
                this.health = 230 * wallHealthMultiplier;
                this.lightningChance = 0.05f;
            }
        };
        surgeWallLarge = new Wall("surge-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.surgeWall.requirements, 4.0f));
                this.health = 920 * wallHealthMultiplier;
                this.size = 2;
                this.lightningChance = 0.05f;
            }
        };
        door = new Door("door"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.titanium, 6, Items.silicon, 4));
                this.health = 100 * wallHealthMultiplier;
            }
        };
        doorLarge = new Door("door-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.door.requirements, 4.0f));
                this.openfx = Fx.dooropenlarge;
                this.closefx = Fx.doorcloselarge;
                this.health = 400 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        scrapWall = new Wall("scrap-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.scrap, 6));
                this.health = 60 * wallHealthMultiplier;
                this.variants = 5;
                this.buildCostMultiplier = 4.0f;
            }
        };
        scrapWallLarge = new Wall("scrap-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.scrapWall.requirements, 4.0f));
                this.health = 240 * wallHealthMultiplier;
                this.size = 2;
                this.variants = 4;
                this.buildCostMultiplier = 4.0f;
            }
        };
        scrapWallHuge = new Wall("scrap-wall-huge"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.scrapWall.requirements, 9.0f));
                this.health = 540 * wallHealthMultiplier;
                this.size = 3;
                this.variants = 3;
                this.buildCostMultiplier = 4.0f;
            }
        };
        scrapWallGigantic = new Wall("scrap-wall-gigantic"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.scrapWall.requirements, 16.0f));
                this.health = 960 * wallHealthMultiplier;
                this.size = 4;
                this.buildCostMultiplier = 4.0f;
            }
        };
        thruster = new Thruster("thruster"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.with(Items.scrap, 96));
                this.health = 880 * wallHealthMultiplier;
                this.size = 4;
            }
        };
        berylliumWall = new Wall("beryllium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.beryllium, 6));
                this.health = 130 * wallHealthMultiplier;
                this.armor = 2.0f;
                this.buildCostMultiplier = 8.0f;
            }
        };
        berylliumWallLarge = new Wall("beryllium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.berylliumWall.requirements, 4.0f));
                this.health = 130 * wallHealthMultiplier * 4;
                this.armor = 2.0f;
                this.buildCostMultiplier = 5.0f;
                this.size = 2;
            }
        };
        tungstenWall = new Wall("tungsten-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.tungsten, 6));
                this.health = 180 * wallHealthMultiplier;
                this.armor = 14.0f;
                this.buildCostMultiplier = 8.0f;
            }
        };
        tungstenWallLarge = new Wall("tungsten-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.tungstenWall.requirements, 4.0f));
                this.health = 180 * wallHealthMultiplier * 4;
                this.armor = 14.0f;
                this.buildCostMultiplier = 5.0f;
                this.size = 2;
            }
        };
        blastDoor = new AutoDoor("blast-door"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.tungsten, 24, Items.silicon, 24));
                this.health = 175 * wallHealthMultiplier * 4;
                this.armor = 14.0f;
                this.size = 2;
            }
        };
        reinforcedSurgeWall = new Wall("reinforced-surge-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.surgeAlloy, 6, Items.tungsten, 2));
                this.health = 250 * wallHealthMultiplier;
                this.lightningChance = 0.05f;
                this.lightningDamage = 30.0f;
                this.armor = 20.0f;
                this.researchCost = ItemStack.with(Items.surgeAlloy, 20, Items.tungsten, 100);
            }
        };
        reinforcedSurgeWallLarge = new Wall("reinforced-surge-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.reinforcedSurgeWall.requirements, 4.0f));
                this.health = 250 * wallHealthMultiplier * 4;
                this.lightningChance = 0.05f;
                this.lightningDamage = 30.0f;
                this.armor = 20.0f;
                this.size = 2;
                this.researchCost = ItemStack.with(Items.surgeAlloy, 40, Items.tungsten, 200);
            }
        };
        carbideWall = new Wall("carbide-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.thorium, 6, Items.carbide, 6));
                this.health = 270 * wallHealthMultiplier;
                this.armor = 16.0f;
            }
        };
        carbideWallLarge = new Wall("carbide-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.carbideWall.requirements, 4.0f));
                this.health = 270 * wallHealthMultiplier * 4;
                this.armor = 16.0f;
                this.size = 2;
            }
        };
        shieldedWall = new ShieldWall("shielded-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.phaseFabric, 20, Items.surgeAlloy, 12, Items.beryllium, 12));
                this.consumePower(0.05f);
                this.outputsPower = false;
                this.hasPower = true;
                this.consumesPower = true;
                this.conductivePower = true;
                this.chanceDeflect = 8.0f;
                this.health = 260 * wallHealthMultiplier * 4;
                this.armor = 15.0f;
                this.size = 2;
            }
        };
        mender = new MendProjector("mender"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 30, Items.copper, 25));
                this.consumePower(0.3f);
                this.size = 1;
                this.reload = 200.0f;
                this.range = 40.0f;
                this.healPercent = 4.0f;
                this.phaseBoost = 4.0f;
                this.phaseRangeBoost = 20.0f;
                this.health = 80;
                this.consumeItem(Items.silicon).boost();
            }
        };
        mendProjector = new MendProjector("mend-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 25, Items.silicon, 40, Items.copper, 50));
                this.consumePower(1.5f);
                this.size = 2;
                this.reload = 250.0f;
                this.range = 85.0f;
                this.healPercent = 11.0f;
                this.phaseBoost = 15.0f;
                this.scaledHealth = 80.0f;
                this.consumeItem(Items.phaseFabric).boost();
            }
        };
        overdriveProjector = new OverdriveProjector("overdrive-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 75, Items.silicon, 75, Items.plastanium, 30));
                this.consumePower(3.5f);
                this.size = 2;
                this.consumeItem(Items.phaseFabric).boost();
                this.ambientSoundVolume = 0.08f;
            }
        };
        overdriveDome = new OverdriveProjector("overdrive-dome"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 200, Items.titanium, 130, Items.silicon, 130, Items.plastanium, 80, Items.surgeAlloy, 120));
                this.consumePower(10.0f);
                this.size = 3;
                this.range = 200.0f;
                this.speedBoost = 2.5f;
                this.useTime = 300.0f;
                this.ambientSoundVolume = 0.12f;
                this.hasBoost = false;
                this.consumeItems(ItemStack.with(Items.phaseFabric, 1, Items.silicon, 1));
            }
        };
        forceProjector = new ForceProjector("force-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 75, Items.silicon, 125));
                this.size = 3;
                this.phaseRadiusBoost = 80.0f;
                this.radius = 101.7f;
                this.shieldHealth = 750.0f;
                this.cooldownNormal = 1.5f;
                this.cooldownLiquid = 1.2f;
                this.cooldownBrokenBase = 0.35f;
                this.itemConsumer = this.consumeItem(Items.phaseFabric).boost();
                this.consumePower(4.0f);
            }
        };
        shockMine = new ShockMine("shock-mine"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 25, Items.silicon, 12));
                this.hasShadow = false;
                this.health = 50;
                this.damage = 25.0f;
                this.tileDamage = 7.0f;
                this.length = 10;
                this.tendrils = 4;
            }
        };
        radar = new Radar("radar"){
            {
                this.requirements(Category.effect, BuildVisibility.fogOnly, ItemStack.with(Items.silicon, 60, Items.graphite, 50, Items.beryllium, 10));
                this.outlineColor = Color.valueOf("4a4b53");
                this.fogRadius = 34;
                this.researchCost = ItemStack.with(Items.silicon, 70, Items.graphite, 70);
                this.consumePower(0.6f);
            }
        };
        buildTower = new BuildTurret("build-tower"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.silicon, 150, Items.oxide, 40, Items.thorium, 60));
                this.outlineColor = Pal.darkOutline;
                this.range = 200.0f;
                this.size = 3;
                this.buildSpeed = 1.5f;
                this.consumePower(3.0f);
                this.consumeLiquid(Liquids.nitrogen, 0.05f);
            }
        };
        regenProjector = new RegenProjector("regen-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.silicon, 80, Items.tungsten, 60, Items.oxide, 40, Items.beryllium, 80));
                this.size = 3;
                this.range = 28;
                this.baseColor = Pal.regen;
                this.consumePower(1.0f);
                this.consumeLiquid(Liquids.hydrogen, 0.016666668f);
                this.consumeItem(Items.phaseFabric).boost();
                this.healPercent = 0.06666667f;
                final Color col = Color.valueOf("8ca9e8");
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.hydrogen, 2.25f), new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.color = Color.sky;
                    }
                }, new DrawPulseShape(false){
                    {
                        super(square);
                        this.layer = 110.0f;
                        this.color = col;
                    }
                }, new DrawShape(){
                    {
                        this.layer = 110.0f;
                        this.radius = 3.5f;
                        this.useWarmupRadius = true;
                        this.timeScl = 2.0f;
                        this.color = col;
                    }
                });
            }
        };
        shockwaveTower = new ShockwaveTower("shockwave-tower"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.surgeAlloy, 50, Items.silicon, 150, Items.oxide, 30, Items.tungsten, 100));
                this.size = 3;
                this.consumeLiquids(LiquidStack.with(Liquids.cyanogen, Float.valueOf(0.025f)));
                this.consumePower(1.6666666f);
                this.range = 170.0f;
                this.reload = 80.0f;
            }
        };
        shieldProjector = new BaseShield("shield-projector"){
            {
                this.requirements(Category.effect, BuildVisibility.editorOnly, ItemStack.with(new Object[0]));
                this.size = 3;
                this.consumePower(5.0f);
            }
        };
        largeShieldProjector = new BaseShield("large-shield-projector"){
            {
                this.requirements(Category.effect, BuildVisibility.editorOnly, ItemStack.with(new Object[0]));
                this.size = 4;
                this.radius = 400.0f;
                this.consumePower(5.0f);
            }
        };
        conveyor = new Conveyor("conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1));
                this.health = 45;
                this.speed = 0.03f;
                this.displayedSpeed = 4.2f;
                this.buildCostMultiplier = 2.0f;
                this.researchCost = ItemStack.with(Items.copper, 5);
            }
        };
        titaniumConveyor = new Conveyor("titanium-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1, Items.lead, 1, Items.titanium, 1));
                this.health = 65;
                this.speed = 0.08f;
                this.displayedSpeed = 11.0f;
            }
        };
        plastaniumConveyor = new StackConveyor("plastanium-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.plastanium, 1, Items.silicon, 1, Items.graphite, 1));
                this.health = 90;
                this.speed = 0.06666667f;
                this.itemCapacity = 10;
            }
        };
        armoredConveyor = new ArmoredConveyor("armored-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.plastanium, 1, Items.thorium, 1, Items.metaglass, 1));
                this.health = 280;
                this.speed = 0.08f;
                this.displayedSpeed = 11.0f;
            }
        };
        junction = new Junction("junction"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 3));
                this.speed = 26.0f;
                this.capacity = 6;
                this.health = 30;
                this.buildCostMultiplier = 6.0f;
            }
        };
        itemBridge = new BufferedItemBridge("bridge-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 6, Items.copper, 6));
                this.moveArrows = false;
                this.fadeIn = false;
                this.range = 4;
                this.speed = 74.0f;
                this.arrowSpacing = 6.0f;
                this.bufferCapacity = 14;
                this.crushFragile = true;
            }
        };
        phaseConveyor = new ItemBridge("phase-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.phaseFabric, 5, Items.silicon, 7, Items.lead, 10, Items.graphite, 10));
                this.range = 12;
                this.transportTime = 2.0f;
                this.arrowPeriod = 0.9f;
                this.arrowTimeScl = 2.75f;
                this.hasPower = true;
                this.pulse = true;
                this.envEnabled |= 2;
                this.consumePower(0.3f);
            }
        };
        sorter = new Sorter("sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 2));
                this.buildCostMultiplier = 3.0f;
            }
        };
        invertedSorter = new Sorter("inverted-sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 2));
                this.buildCostMultiplier = 3.0f;
                this.invert = true;
            }
        };
        router = new Router("router"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 3));
                this.buildCostMultiplier = 4.0f;
            }
        };
        distributor = new Router("distributor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 4, Items.copper, 4));
                this.buildCostMultiplier = 3.0f;
                this.size = 2;
            }
        };
        overflowGate = new OverflowGate("overflow-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 4));
                this.buildCostMultiplier = 3.0f;
            }
        };
        underflowGate = new OverflowGate("underflow-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 4));
                this.buildCostMultiplier = 3.0f;
                this.invert = true;
            }
        };
        unloader = new Unloader("unloader"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.titanium, 25, Items.silicon, 30));
                this.speed = 5.4545455f;
                this.group = BlockGroup.transportation;
            }
        };
        massDriver = new MassDriver("mass-driver"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.titanium, 125, Items.silicon, 75, Items.lead, 125, Items.thorium, 50));
                this.size = 3;
                this.itemCapacity = 120;
                this.reload = 200.0f;
                this.range = 440.0f;
                this.consumePower(1.75f);
            }
        };
        duct = new Duct("duct"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.beryllium, 1));
                this.health = 90;
                this.speed = 4.0f;
                this.researchCost = ItemStack.with(Items.beryllium, 5);
            }
        };
        armoredDuct = new Duct("armored-duct"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.beryllium, 2, Items.tungsten, 1));
                this.health = 140;
                this.speed = 4.0f;
                this.armored = true;
                this.researchCost = ItemStack.with(Items.beryllium, 300, Items.tungsten, 100);
            }
        };
        ductRouter = new DuctRouter("duct-router"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.beryllium, 10));
                this.health = 90;
                this.speed = 4.0f;
                this.regionRotated1 = 1;
                this.solid = false;
                this.researchCost = ItemStack.with(Items.beryllium, 30);
            }
        };
        overflowDuct = new OverflowDuct("overflow-duct"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.graphite, 8, Items.beryllium, 8));
                this.health = 90;
                this.speed = 4.0f;
                this.solid = false;
                this.researchCostMultiplier = 1.5f;
            }
        };
        underflowDuct = new OverflowDuct("underflow-duct"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.graphite, 8, Items.beryllium, 8));
                this.health = 90;
                this.speed = 4.0f;
                this.solid = false;
                this.researchCostMultiplier = 1.5f;
                this.invert = true;
            }
        };
        ductBridge = new DuctBridge("duct-bridge"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.beryllium, 15));
                this.health = 90;
                this.speed = 4.0f;
                this.buildCostMultiplier = 2.0f;
                this.researchCostMultiplier = 0.3f;
                this.crushFragile = true;
            }
        };
        ductUnloader = new DirectionalUnloader("duct-unloader"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.graphite, 20, Items.silicon, 20, Items.tungsten, 10));
                this.health = 120;
                this.speed = 4.0f;
                this.solid = false;
                this.underBullets = true;
                this.regionRotated1 = 1;
            }
        };
        surgeConveyor = new StackConveyor("surge-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.surgeAlloy, 1, Items.tungsten, 1));
                this.health = 130;
                this.speed = 0.083333336f;
                this.itemCapacity = 10;
                this.outputRouter = false;
                this.hasPower = true;
                this.consumesPower = true;
                this.conductivePower = true;
                this.underBullets = true;
                this.baseEfficiency = 1.0f;
                this.consumePower(0.016666668f);
                this.researchCost = ItemStack.with(Items.surgeAlloy, 30, Items.tungsten, 80);
            }
        };
        surgeRouter = new StackRouter("surge-router"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.surgeAlloy, 5, Items.tungsten, 1));
                this.health = 130;
                this.speed = 6.0f;
                this.hasPower = true;
                this.consumesPower = true;
                this.conductivePower = true;
                this.baseEfficiency = 1.0f;
                this.underBullets = true;
                this.solid = false;
                this.consumePower(0.05f);
            }
        };
        unitCargoLoader = new UnitCargoLoader("unit-cargo-loader"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.silicon, 80, Items.surgeAlloy, 50, Items.oxide, 20));
                this.size = 3;
                this.unitBuildTime = 480.0f;
                this.consumePower(0.13333334f);
                this.consumeLiquid(Liquids.nitrogen, 0.16666667f);
                this.itemCapacity = 200;
                this.researchCost = ItemStack.with(Items.silicon, 2500, Items.surgeAlloy, 20, Items.oxide, 30);
            }
        };
        unitCargoUnloadPoint = new UnitCargoUnloadPoint("unit-cargo-unload-point"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.silicon, 60, Items.tungsten, 60));
                this.size = 2;
                this.itemCapacity = 100;
                this.researchCost = ItemStack.with(Items.silicon, 3000, Items.oxide, 20);
            }
        };
        mechanicalPump = new Pump("mechanical-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 15, Items.metaglass, 10));
                this.pumpAmount = 0.11666667f;
                this.liquidCapacity = 20.0f;
            }
        };
        rotaryPump = new Pump("rotary-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 70, Items.metaglass, 50, Items.silicon, 20, Items.titanium, 35));
                this.pumpAmount = 0.2f;
                this.consumePower(0.3f);
                this.liquidCapacity = 80.0f;
                this.hasPower = true;
                this.size = 2;
            }
        };
        impulsePump = new Pump("impulse-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 80, Items.metaglass, 90, Items.silicon, 30, Items.titanium, 40, Items.thorium, 35));
                this.pumpAmount = 0.22f;
                this.consumePower(1.3f);
                this.liquidCapacity = 200.0f;
                this.hasPower = true;
                this.size = 3;
            }
        };
        conduit = new Conduit("conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.metaglass, 1));
                this.liquidCapacity = 20.0f;
                this.health = 45;
                this.flammabilityScale = 0.5f;
                this.explosivenessScale = 0.5f;
            }
        };
        pulseConduit = new Conduit("pulse-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 2, Items.metaglass, 1));
                this.liquidCapacity = 40.0f;
                this.liquidPressure = 1.025f;
                this.health = 90;
                this.flammabilityScale = 0.4f;
                this.explosivenessScale = 0.4f;
            }
        };
        platedConduit = new ArmoredConduit("plated-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.thorium, 2, Items.metaglass, 1, Items.plastanium, 1));
                this.liquidCapacity = 50.0f;
                this.liquidPressure = 1.025f;
                this.health = 220;
                this.flammabilityScale = 0.32f;
                this.explosivenessScale = 0.32f;
            }
        };
        liquidRouter = new LiquidRouter("liquid-router"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 2));
                this.liquidCapacity = 120.0f;
                this.underBullets = true;
                this.solid = false;
                this.flammabilityScale = 0.16666667f;
                this.explosivenessScale = 0.16666667f;
            }
        };
        liquidContainer = new LiquidRouter("liquid-container"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 10, Items.metaglass, 15));
                this.liquidCapacity = 700.0f;
                this.size = 2;
                this.solid = true;
            }
        };
        liquidTank = new LiquidRouter("liquid-tank"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 30, Items.metaglass, 40));
                this.size = 3;
                this.solid = true;
                this.liquidCapacity = 1800.0f;
                this.health = 500;
            }
        };
        liquidJunction = new LiquidJunction("liquid-junction"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 8));
                this.solid = false;
            }
        };
        bridgeConduit = new LiquidBridge("bridge-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 8));
                this.floating = true;
                this.moveArrows = false;
                this.fadeIn = false;
                this.arrowSpacing = 6.0f;
                this.range = 4;
                this.hasPower = false;
                this.liquidCapacity = 100.0f;
                this.flammabilityScale = 0.2f;
                this.explosivenessScale = 0.2f;
            }
        };
        phaseConduit = new LiquidBridge("phase-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.phaseFabric, 5, Items.silicon, 7, Items.metaglass, 20, Items.titanium, 10));
                this.floating = true;
                this.range = 12;
                this.arrowPeriod = 0.9f;
                this.arrowTimeScl = 2.75f;
                this.hasPower = true;
                this.canOverdrive = false;
                this.pulse = true;
                this.flammabilityScale = 0.2f;
                this.explosivenessScale = 0.2f;
                this.liquidCapacity = 100.0f;
                this.consumePower(0.3f);
            }
        };
        reinforcedPump = new Pump("reinforced-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.beryllium, 40, Items.tungsten, 30, Items.silicon, 20));
                this.consumeLiquid(Liquids.hydrogen, 0.025f);
                this.pumpAmount = 0.33333334f;
                this.liquidCapacity = 160.0f;
                this.size = 2;
            }
        };
        reinforcedConduit = new ArmoredConduit("reinforced-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.beryllium, 2));
                this.botColor = Pal.darkestMetal;
                this.leaks = true;
                this.liquidCapacity = 50.0f;
                this.liquidPressure = 1.03f;
                this.health = 250;
                this.researchCostMultiplier = 3.0f;
                this.underBullets = true;
                this.flammabilityScale = 0.4f;
                this.explosivenessScale = 0.4f;
            }
        };
        reinforcedLiquidJunction = new LiquidJunction("reinforced-liquid-junction"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.beryllium, 8));
                this.buildCostMultiplier = 3.0f;
                this.health = 250;
                ((Conduit)Blocks.reinforcedConduit).junctionReplacement = this;
                this.researchCostMultiplier = 1.0f;
                this.solid = false;
                this.underBullets = true;
            }
        };
        reinforcedBridgeConduit = new DirectionLiquidBridge("reinforced-bridge-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 8, Items.beryllium, 20));
                this.range = 4;
                this.hasPower = false;
                this.liquidCapacity = 120.0f;
                this.researchCostMultiplier = 1.0f;
                this.underBullets = true;
                this.health = 250;
                this.flammabilityScale = 0.16666667f;
                this.explosivenessScale = 0.16666667f;
                ((Conduit)Blocks.reinforcedConduit).rotBridgeReplacement = this;
            }
        };
        reinforcedLiquidRouter = new LiquidRouter("reinforced-liquid-router"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 8, Items.beryllium, 4));
                this.liquidCapacity = 150.0f;
                this.liquidPadding = 0.75f;
                this.researchCostMultiplier = 3.0f;
                this.underBullets = true;
                this.solid = false;
                this.health = 250;
                this.flammabilityScale = 0.26666668f;
                this.explosivenessScale = 0.26666668f;
            }
        };
        reinforcedLiquidContainer = new LiquidRouter("reinforced-liquid-container"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.tungsten, 10, Items.beryllium, 16));
                this.liquidCapacity = 1000.0f;
                this.size = 2;
                this.liquidPadding = 1.5f;
                this.researchCostMultiplier = 4.0f;
                this.solid = true;
                this.health = 400;
            }
        };
        reinforcedLiquidTank = new LiquidRouter("reinforced-liquid-tank"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.tungsten, 40, Items.beryllium, 50));
                this.size = 3;
                this.solid = true;
                this.liquidCapacity = 2700.0f;
                this.liquidPadding = 2.0f;
                this.health = 900;
            }
        };
        powerNode = new PowerNode("power-node"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 2, Items.lead, 6));
                this.maxNodes = 10;
                this.laserRange = 6.0f;
                this.underBullets = true;
                this.crushFragile = true;
            }
        };
        powerNodeLarge = new PowerNode("power-node-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 5, Items.lead, 10, Items.silicon, 3));
                this.size = 2;
                this.maxNodes = 15;
                this.laserRange = 15.0f;
            }
        };
        surgeTower = new PowerNode("surge-tower"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 7, Items.lead, 10, Items.silicon, 15, Items.surgeAlloy, 15));
                this.size = 2;
                this.maxNodes = 2;
                this.laserRange = 40.0f;
                this.schematicPriority = -15;
            }
        };
        diode = new PowerDiode("diode"){
            {
                this.requirements(Category.power, ItemStack.with(Items.silicon, 10, Items.plastanium, 5, Items.metaglass, 10));
            }
        };
        battery = new Battery("battery"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 5, Items.lead, 20));
                this.consumePowerBuffered(4000.0f);
                this.baseExplosiveness = 1.0f;
            }
        };
        batteryLarge = new Battery("battery-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 20, Items.lead, 50, Items.silicon, 30));
                this.size = 3;
                this.consumePowerBuffered(50000.0f);
                this.baseExplosiveness = 5.0f;
            }
        };
        combustionGenerator = new ConsumeGenerator("combustion-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 25, Items.lead, 15));
                this.powerProduction = 1.0f;
                this.itemDuration = 120.0f;
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.03f;
                this.generateEffect = Fx.generatespark;
                this.consume(new ConsumeItemFlammable());
                this.consume(new ConsumeItemExplode());
                this.itemDurationMultipliers.put(Items.pyratite, 3.0f);
                this.drawer = new DrawMulti(new DrawDefault(), new DrawWarmupRegion());
            }
        };
        thermalGenerator = new ThermalGenerator("thermal-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 40, Items.graphite, 35, Items.lead, 50, Items.silicon, 35, Items.metaglass, 40));
                this.powerProduction = 1.8f;
                this.generateEffect = Fx.redgeneratespark;
                this.effectChance = 0.011f;
                this.size = 2;
                this.floating = true;
                this.ambientSound = Sounds.loopHum;
                this.ambientSoundVolume = 0.06f;
            }
        };
        steamGenerator = new ConsumeGenerator("steam-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 35, Items.graphite, 25, Items.lead, 40, Items.silicon, 30));
                this.powerProduction = 5.5f;
                this.itemDuration = 90.0f;
                this.consumeLiquid(Liquids.water, 0.1f);
                this.hasLiquids = true;
                this.size = 2;
                this.generateEffect = Fx.generatespark;
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.06f;
                this.consume(new ConsumeItemFlammable());
                this.consume(new ConsumeItemExplode());
                this.itemDurationMultipliers.put(Items.pyratite, 3.0f);
                this.drawer = new DrawMulti(new DrawDefault(), new DrawWarmupRegion(), new DrawRegion("-turbine"){
                    {
                        super(suffix);
                        this.rotateSpeed = 2.0f;
                    }
                }, new DrawRegion("-turbine"){
                    {
                        super(suffix);
                        this.rotateSpeed = -2.0f;
                        this.rotation = 45.0f;
                    }
                }, new DrawRegion("-cap"), new DrawLiquidRegion());
            }
        };
        differentialGenerator = new ConsumeGenerator("differential-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 70, Items.titanium, 50, Items.lead, 100, Items.silicon, 65, Items.metaglass, 50));
                this.powerProduction = 18.0f;
                this.itemDuration = 220.0f;
                this.hasLiquids = true;
                this.hasItems = true;
                this.size = 3;
                this.ambientSound = Sounds.loopDifferential;
                this.generateEffect = Fx.generatespark;
                this.ambientSoundVolume = 0.12f;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawWarmupRegion(), new DrawLiquidRegion());
                this.consumeItem(Items.pyratite);
                this.consumeLiquid(Liquids.cryofluid, 0.1f);
            }
        };
        rtgGenerator = new ConsumeGenerator("rtg-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 100, Items.silicon, 75, Items.phaseFabric, 25, Items.plastanium, 75, Items.thorium, 50));
                this.size = 2;
                this.powerProduction = 4.5f;
                this.itemDuration = 840.0f;
                this.envEnabled = -1;
                this.generateEffect = Fx.generatespark;
                this.itemDurationMultipliers.put(Items.phaseFabric, 15.0f);
                this.drawer = new DrawMulti(new DrawDefault(), new DrawWarmupRegion());
                this.consume(new ConsumeItemRadioactive());
            }
        };
        solarPanel = new SolarGenerator("solar-panel"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 10, Items.silicon, 8));
                this.powerProduction = 0.12f;
            }
        };
        largeSolarPanel = new SolarGenerator("solar-panel-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 60, Items.silicon, 70, Items.phaseFabric, 15));
                this.size = 3;
                this.powerProduction = 1.6f;
            }
        };
        thoriumReactor = new NuclearReactor("thorium-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 300, Items.silicon, 200, Items.graphite, 150, Items.thorium, 150, Items.metaglass, 50));
                this.ambientSound = Sounds.loopThoriumReactor;
                this.ambientSoundVolume = 0.11f;
                this.size = 3;
                this.health = 700;
                this.itemDuration = 360.0f;
                this.powerProduction = 15.0f;
                this.heating = 0.02f;
                this.consumeItem(Items.thorium);
                this.consumeLiquid(Liquids.cryofluid, this.heating / this.coolantPower).update(false);
            }
        };
        impactReactor = new ImpactReactor("impact-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 500, Items.silicon, 300, Items.graphite, 400, Items.thorium, 100, Items.surgeAlloy, 250, Items.metaglass, 250));
                this.size = 4;
                this.health = 900;
                this.powerProduction = 130.0f;
                this.itemDuration = 140.0f;
                this.ambientSound = Sounds.loopPulse;
                this.ambientSoundVolume = 0.08f;
                this.liquidCapacity = 80.0f;
                this.consumePower(25.0f);
                this.consumeItem(Items.blastCompound);
                this.consumeLiquid(Liquids.cryofluid, 0.25f);
            }
        };
        beamNode = new BeamNode("beam-node"){
            {
                this.requirements(Category.power, ItemStack.with(Items.beryllium, 8));
                this.outputsPower = true;
                this.consumesPower = true;
                this.health = 90;
                this.range = 10;
                this.fogRadius = 1;
                this.researchCost = ItemStack.with(Items.beryllium, 5);
                this.crushFragile = true;
                this.consumePowerBuffered(1000.0f);
            }
        };
        beamTower = new BeamNode("beam-tower"){
            {
                this.requirements(Category.power, ItemStack.with(Items.beryllium, 30, Items.oxide, 10, Items.silicon, 10));
                this.size = 3;
                this.outputsPower = true;
                this.consumesPower = true;
                this.range = 23;
                this.scaledHealth = 90.0f;
                this.fogRadius = 2;
                this.consumePowerBuffered(40000.0f);
            }
        };
        beamLink = new LongPowerNode("beam-link"){
            {
                this.requirements(Category.power, ItemStack.with(Items.beryllium, 250, Items.silicon, 250, Items.oxide, 150, Items.carbide, 75, Items.surgeAlloy, 75, Items.phaseFabric, 75));
                this.size = 3;
                this.maxNodes = 1;
                this.laserRange = 500.0f;
                this.powerLayer = 77.0f;
                this.autolink = false;
                this.sameBlockConnection = true;
                this.laserColor2 = Color.valueOf("ffd9c2");
                this.laserScale = 0.8f;
                this.scaledHealth = 130.0f;
            }
        };
        turbineCondenser = new ThermalGenerator("turbine-condenser"){
            {
                this.requirements(Category.power, ItemStack.with(Items.beryllium, 60));
                this.attribute = Attribute.steam;
                this.group = BlockGroup.liquids;
                this.displayEfficiencyScale = 0.11111111f;
                this.minEfficiency = 8.9999f;
                this.powerProduction = 0.33333334f;
                this.displayEfficiency = false;
                this.generateEffect = Fx.turbinegenerate;
                this.effectChance = 0.04f;
                this.size = 3;
                this.ambientSound = Sounds.loopHum;
                this.ambientSoundVolume = 0.06f;
                this.drawer = new DrawMulti(new DrawDefault(), new DrawBlurSpin("-rotator", 5.4f){
                    {
                        super(suffix, speed);
                        this.blurThresh = 0.01f;
                    }
                });
                this.hasLiquids = true;
                this.outputLiquid = new LiquidStack(Liquids.water, 0.009259259f);
                this.liquidCapacity = 20.0f;
                this.fogRadius = 3;
                this.researchCost = ItemStack.with(Items.beryllium, 15);
            }
        };
        chemicalCombustionChamber = new ConsumeGenerator("chemical-combustion-chamber"){
            {
                this.requirements(Category.power, ItemStack.with(Items.graphite, 40, Items.tungsten, 20, Items.oxide, Float.valueOf(40.0f), Items.silicon, 30));
                this.powerProduction = 9.166667f;
                this.researchCost = ItemStack.with(Items.graphite, 2000, Items.tungsten, 1000, Items.oxide, 10, Items.silicon, 1500);
                this.consumeLiquids(LiquidStack.with(Liquids.ozone, Float.valueOf(0.033333335f), Liquids.arkycite, Float.valueOf(0.6666667f)));
                this.size = 3;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawPistons(){
                    {
                        this.sinMag = 3.0f;
                        this.sinScl = 5.0f;
                    }
                }, new DrawRegion("-mid"), new DrawLiquidTile(Liquids.arkycite, 9.25f), new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.alpha = 1.0f;
                        this.glowScale = 5.0f;
                        this.color = Color.valueOf("c967b099");
                    }
                });
                this.generateEffect = Fx.none;
                this.liquidCapacity = 100.0f;
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.06f;
            }
        };
        pyrolysisGenerator = new ConsumeGenerator("pyrolysis-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.graphite, 100, Items.carbide, 60, Items.oxide, Float.valueOf(60.0f), Items.silicon, 100));
                this.powerProduction = 23.333334f;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawPistons(){
                    {
                        this.sinMag = 2.75f;
                        this.sinScl = 5.0f;
                        this.sides = 8;
                        this.sideOffset = 1.5707964f;
                    }
                }, new DrawRegion("-mid"), new DrawLiquidTile(Liquids.arkycite, 9.5f), new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.alpha = 1.0f;
                        this.glowScale = 5.0f;
                        this.color = Pal.slagOrange;
                    }
                });
                this.consumeLiquids(LiquidStack.with(Liquids.slag, Float.valueOf(0.33333334f), Liquids.arkycite, Float.valueOf(0.6666667f)));
                this.size = 3;
                this.liquidCapacity = 150.0f;
                this.outputLiquid = new LiquidStack(Liquids.water, 0.33333334f);
                this.generateEffect = Fx.none;
                this.ambientSound = Sounds.loopSmelter;
                this.ambientSoundVolume = 0.06f;
                this.researchCostMultiplier = 0.4f;
            }
        };
        fluxReactor = new VariableReactor("flux-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.graphite, 240, Items.carbide, 60, Items.oxide, 80, Items.silicon, 480, Items.surgeAlloy, 120));
                this.powerProduction = 300.0f;
                this.maxHeat = 150.0f;
                this.consumeLiquid(Liquids.cyanogen, 0.15f);
                this.liquidCapacity = 30.0f;
                this.explosionMinWarmup = 0.5f;
                this.explosionRadius = 17;
                this.explosionDamage = 2500;
                this.ambientSound = Sounds.loopFlux;
                this.ambientSoundVolume = 0.15f;
                this.size = 5;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.cyanogen), new DrawRegion("-mid"), new DrawSoftParticles(){
                    {
                        this.alpha = 0.35f;
                        this.particleRad = 12.0f;
                        this.particleSize = 9.0f;
                        this.particleLife = 120.0f;
                        this.particles = 27;
                    }
                }, new DrawDefault(), new DrawHeatInput(), new DrawGlowRegion("-ventglow"){
                    {
                        super(suffix);
                        this.color = Color.valueOf("32603a");
                    }
                });
            }
        };
        neoplasiaReactor = new HeaterGenerator("neoplasia-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.tungsten, 750, Items.carbide, 300, Items.oxide, 150, Items.silicon, 500, Items.phaseFabric, 150, Items.surgeAlloy, 200));
                this.size = 5;
                this.liquidCapacity = 80.0f;
                this.outputLiquid = new LiquidStack(Liquids.neoplasm, 0.33333334f);
                this.explodeOnFull = true;
                this.heatOutput = 60.0f;
                this.consumeLiquid(Liquids.arkycite, 1.3333334f);
                this.consumeLiquid(Liquids.water, 0.16666667f);
                this.consumeItem(Items.phaseFabric);
                this.itemDuration = 180.0f;
                this.itemCapacity = 10;
                this.explosionRadius = 9;
                this.explosionDamage = 2000;
                this.explodeEffect = new MultiEffect(Fx.bigShockwave, new WrapEffect(Fx.titanSmoke, Liquids.neoplasm.color), Fx.neoplasmSplat);
                this.explodeSound = Sounds.explosionReactorNeoplasm;
                this.powerProduction = 140.0f;
                this.ambientSound = Sounds.loopBio;
                this.ambientSoundVolume = 0.2f;
                this.explosionPuddles = 80;
                this.explosionPuddleRange = 56.0f;
                this.explosionPuddleLiquid = Liquids.neoplasm;
                this.explosionPuddleAmount = 200.0f;
                this.explosionMinWarmup = 0.5f;
                this.consumeEffect = new RadialEffect(Fx.neoplasiaSmoke, 4, 90.0f, 13.5f);
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.arkycite, 3.0f), new DrawCircles(){
                    {
                        this.color = Color.valueOf("feb380").a(0.8f);
                        this.strokeMax = 3.25f;
                        this.radius = 16.25f;
                        this.amount = 5;
                        this.timeScl = 200.0f;
                    }
                }, new DrawRegion("-center"), new DrawCells(){
                    {
                        this.color = Color.valueOf("c33e2b");
                        this.particleColorFrom = Color.valueOf("e8803f");
                        this.particleColorTo = Color.valueOf("8c1225");
                        this.particles = 50;
                        this.range = 4.0f;
                    }
                }, new DrawDefault(), new DrawHeatOutput(), new DrawGlowRegion("-glow"){
                    {
                        super(suffix);
                        this.color = Color.valueOf("70170b");
                        this.alpha = 0.7f;
                    }
                });
            }
        };
        mechanicalDrill = new Drill("mechanical-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 12));
                this.tier = 2;
                this.drillTime = 600.0f;
                this.size = 2;
                this.envEnabled ^= 2;
                this.researchCost = ItemStack.with(Items.copper, 10);
                this.consumeLiquid(Liquids.water, 0.05f).boost();
            }
        };
        pneumaticDrill = new Drill("pneumatic-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 18, Items.graphite, 10));
                this.tier = 3;
                this.drillTime = 400.0f;
                this.size = 2;
                this.consumeLiquid(Liquids.water, 0.058333334f).boost();
            }
        };
        laserDrill = new Drill("laser-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 35, Items.graphite, 30, Items.silicon, 30, Items.titanium, 20));
                this.drillTime = 280.0f;
                this.size = 3;
                this.hasPower = true;
                this.tier = 4;
                this.updateEffect = Fx.pulverizeMedium;
                this.drillEffect = Fx.mineBig;
                this.consumePower(1.1f);
                this.consumeLiquid(Liquids.water, 0.08f).boost();
            }
        };
        blastDrill = new Drill("blast-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 65, Items.silicon, 60, Items.titanium, 50, Items.thorium, 75));
                this.drillTime = 280.0f;
                this.size = 4;
                this.drawRim = true;
                this.hasPower = true;
                this.tier = 5;
                this.updateEffect = Fx.pulverizeRed;
                this.updateEffectChance = 0.03f;
                this.drillEffect = Fx.mineHuge;
                this.rotateSpeed = 6.0f;
                this.warmupSpeed = 0.01f;
                this.itemCapacity = 20;
                this.liquidBoostIntensity = 1.8f;
                this.consumePower(3.0f);
                this.consumeLiquid(Liquids.water, 0.1f).boost();
            }
        };
        waterExtractor = new SolidPump("water-extractor"){
            {
                this.requirements(Category.production, ItemStack.with(Items.metaglass, 30, Items.graphite, 30, Items.lead, 30, Items.copper, 30));
                this.result = Liquids.water;
                this.pumpAmount = 0.11f;
                this.size = 2;
                this.liquidCapacity = 40.0f;
                this.rotateSpeed = 1.4f;
                this.attribute = Attribute.water;
                this.envRequired |= 0x40;
                this.consumePower(1.5f);
            }
        };
        cultivator = new AttributeCrafter("cultivator"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 25, Items.lead, 25, Items.silicon, 10));
                this.outputItem = new ItemStack(Items.sporePod, 1);
                this.craftTime = 100.0f;
                this.size = 2;
                this.hasLiquids = true;
                this.hasPower = true;
                this.hasItems = true;
                this.liquidCapacity = 80.0f;
                this.craftEffect = Fx.none;
                this.envRequired |= 8;
                this.attribute = Attribute.spores;
                this.ambientSound = Sounds.loopCultivator;
                this.ambientSoundVolume = 0.075f;
                this.legacyReadWarmup = true;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.water), new DrawDefault(), new DrawCultivator(), new DrawRegion("-top"));
                this.maxBoost = 2.0f;
                this.consumePower(1.3333334f);
                this.consumeLiquid(Liquids.water, 0.3f);
            }
        };
        oilExtractor = new Fracker("oil-extractor"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 150, Items.graphite, 175, Items.lead, 115, Items.thorium, 115, Items.silicon, 75));
                this.result = Liquids.oil;
                this.updateEffect = Fx.pulverize;
                this.updateEffectChance = 0.05f;
                this.pumpAmount = 0.25f;
                this.size = 3;
                this.liquidCapacity = 40.0f;
                this.attribute = Attribute.oil;
                this.baseEfficiency = 0.0f;
                this.itemUseTime = 60.0f;
                this.consumeItem(Items.sand);
                this.consumePower(3.0f);
                this.consumeLiquid(Liquids.water, 0.15f);
            }
        };
        ventCondenser = new AttributeCrafter("vent-condenser"){
            {
                this.requirements(Category.production, ItemStack.with(Items.graphite, 20, Items.beryllium, 60));
                this.attribute = Attribute.steam;
                this.group = BlockGroup.liquids;
                this.minEfficiency = 8.9999f;
                this.baseEfficiency = 0.0f;
                this.displayEfficiency = false;
                this.craftEffect = Fx.turbinegenerate;
                this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawBlurSpin("-rotator", 6.0f), new DrawRegion("-mid"), new DrawLiquidTile(Liquids.water, 9.5f), new DrawDefault());
                this.craftTime = 120.0f;
                this.size = 3;
                this.ambientSound = Sounds.loopHum;
                this.ambientSoundVolume = 0.06f;
                this.hasLiquids = true;
                this.boostScale = 0.11111111f;
                this.itemCapacity = 0;
                this.outputLiquid = new LiquidStack(Liquids.water, 0.5f);
                this.consumePower(0.5f);
                this.liquidCapacity = 60.0f;
            }
        };
        cliffCrusher = new WallCrafter("cliff-crusher"){
            {
                this.requirements(Category.production, ItemStack.with(Items.graphite, 25, Items.beryllium, 20));
                this.consumePower(0.18333334f);
                this.drillTime = 110.0f;
                this.size = 2;
                this.attribute = Attribute.sand;
                this.output = Items.sand;
                this.fogRadius = 2;
                this.researchCost = ItemStack.with(Items.beryllium, 100, Items.graphite, 40);
                this.ambientSound = Sounds.loopDrill;
                this.ambientSoundVolume = 0.04f;
            }
        };
        largeCliffCrusher = new WallCrafter("large-cliff-crusher"){
            {
                this.requirements(Category.production, ItemStack.with(Items.silicon, 80, Items.surgeAlloy, 15, Items.beryllium, 100, Items.tungsten, 50));
                this.consumePower(1.0f);
                this.drillTime = 48.0f;
                this.size = 3;
                this.attribute = Attribute.sand;
                this.output = Items.sand;
                this.fogRadius = 3;
                this.ambientSound = Sounds.loopDrill;
                this.ambientSoundVolume = 0.08f;
                this.consumeLiquid(Liquids.hydrogen, 0.016666668f);
                this.itemConsumer = this.consumeItem(Items.graphite).boost();
                this.itemCapacity = 20;
                this.boostItemUseTime = 80.0f;
            }
        };
        plasmaBore = new BeamDrill("plasma-bore"){
            {
                this.requirements(Category.production, ItemStack.with(Items.beryllium, 40));
                this.consumePower(0.15f);
                this.drillTime = 160.0f;
                this.tier = 3;
                this.size = 2;
                this.range = 5;
                this.fogRadius = 3;
                this.researchCost = ItemStack.with(Items.beryllium, 10);
                this.consumeLiquid(Liquids.hydrogen, 0.004166667f).boost();
            }
        };
        largePlasmaBore = new BeamDrill("large-plasma-bore"){
            {
                this.requirements(Category.production, ItemStack.with(Items.silicon, 100, Items.oxide, 25, Items.beryllium, 100, Items.tungsten, 70));
                this.consumePower(0.8f);
                this.drillTime = 100.0f;
                this.tier = 5;
                this.size = 3;
                this.range = 6;
                this.fogRadius = 4;
                this.laserWidth = 0.7f;
                this.itemCapacity = 20;
                this.consumeLiquid(Liquids.hydrogen, 0.008333334f);
                this.consumeLiquid(Liquids.nitrogen, 0.05f).boost();
                this.researchCost = ItemStack.with(Items.silicon, 1500, Items.oxide, 200, Items.beryllium, 3000, Items.tungsten, 1200);
            }
        };
        impactDrill = new BurstDrill("impact-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.silicon, 70, Items.beryllium, 90, Items.graphite, 60));
                this.drillTime = 720.0f;
                this.size = 4;
                this.hasPower = true;
                this.tier = 6;
                this.drillEffect = new MultiEffect(Fx.mineImpact, Fx.drillSteam, Fx.mineImpactWave.wrap(Pal.redLight, 40.0f));
                this.shake = 4.0f;
                this.itemCapacity = 40;
                this.blockedItem = Items.thorium;
                this.researchCostMultiplier = 0.5f;
                this.drillMultipliers.put(Items.beryllium, 2.0f);
                this.liquidBoostIntensity = 1.75f;
                this.fogRadius = 4;
                this.consumePower(2.6666667f);
                this.consumeLiquid(Liquids.water, 0.16666667f);
                this.consumeLiquid(Liquids.ozone, 0.05f).boost();
            }
        };
        eruptionDrill = new BurstDrill("eruption-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.silicon, 300, Items.oxide, 20, Items.tungsten, 250, Items.thorium, 150));
                this.drillTime = 281.25f;
                this.size = 5;
                this.hasPower = true;
                this.tier = 7;
                this.drillEffect = new MultiEffect(Fx.mineImpact, Fx.drillSteam, Fx.dynamicSpikes.wrap(Liquids.hydrogen.color, 30.0f), Fx.mineImpactWave.wrap(Liquids.hydrogen.color, 45.0f));
                this.shake = 4.0f;
                this.itemCapacity = 60;
                this.arrowOffset = 2.0f;
                this.arrowSpacing = 5.0f;
                this.arrows = 2;
                this.glowColor.a = 0.6f;
                this.fogRadius = 5;
                this.drillMultipliers.put(Items.beryllium, 2.0f);
                this.liquidBoostIntensity = 2.0f;
                this.consumePower(6.0f);
                this.consumeLiquid(Liquids.hydrogen, 0.06666667f);
                this.consumeLiquid(Liquids.cyanogen, 0.0125f).boost();
            }
        };
        coreShard = new CoreBlock("core-shard"){
            {
                this.requirements(Category.effect, BuildVisibility.coreZoneOnly, ItemStack.with(Items.copper, 1000, Items.lead, 800));
                this.alwaysUnlocked = true;
                this.isFirstTier = true;
                this.unitType = UnitTypes.alpha;
                this.health = 1100;
                this.itemCapacity = 4000;
                this.size = 3;
                this.buildCostMultiplier = 2.0f;
                this.unitCapModifier = 8;
            }
        };
        coreFoundation = new CoreBlock("core-foundation"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.copper, 3000, Items.lead, 3000, Items.silicon, 2000));
                this.unitType = UnitTypes.beta;
                this.health = 3500;
                this.itemCapacity = 9000;
                this.size = 4;
                this.thrusterLength = 8.5f;
                this.unitCapModifier = 16;
                this.researchCostMultiplier = 0.07f;
            }
        };
        coreNucleus = new CoreBlock("core-nucleus"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.copper, 8000, Items.lead, 8000, Items.silicon, 5000, Items.thorium, 4000));
                this.unitType = UnitTypes.gamma;
                this.health = 6000;
                this.itemCapacity = 13000;
                this.size = 5;
                this.thrusterLength = 10.0f;
                this.unitCapModifier = 24;
                this.researchCostMultiplier = 0.11f;
            }
        };
        coreBastion = new CoreBlock("core-bastion"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.graphite, 1000, Items.silicon, 1000, Items.beryllium, 800));
                this.isFirstTier = true;
                this.unitType = UnitTypes.evoke;
                this.health = 4500;
                this.itemCapacity = 2000;
                this.size = 4;
                this.thrusterLength = 8.5f;
                this.armor = 5.0f;
                this.alwaysUnlocked = true;
                this.incinerateNonBuildable = true;
                this.requiresCoreZone = true;
                this.buildCostMultiplier = 0.7f;
                this.unitCapModifier = 15;
                this.researchCostMultiplier = 0.07f;
            }
        };
        coreCitadel = new CoreBlock("core-citadel"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.silicon, 4000, Items.beryllium, 4000, Items.tungsten, 3000, Items.oxide, 1000));
                this.unitType = UnitTypes.incite;
                this.health = 16000;
                this.itemCapacity = 3000;
                this.size = 5;
                this.thrusterLength = 10.0f;
                this.armor = 10.0f;
                this.incinerateNonBuildable = true;
                this.buildCostMultiplier = 0.7f;
                this.requiresCoreZone = true;
                this.unitCapModifier = 15;
                this.researchCostMultipliers.put(Items.silicon, 0.5f);
                this.researchCostMultiplier = 0.17f;
            }
        };
        coreAcropolis = new CoreBlock("core-acropolis"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.beryllium, 6000, Items.silicon, 5000, Items.tungsten, 5000, Items.carbide, 3000, Items.oxide, 3000));
                this.unitType = UnitTypes.emanate;
                this.health = 30000;
                this.itemCapacity = 4000;
                this.size = 6;
                this.thrusterLength = 12.0f;
                this.armor = 15.0f;
                this.incinerateNonBuildable = true;
                this.buildCostMultiplier = 0.7f;
                this.requiresCoreZone = true;
                this.unitCapModifier = 15;
                this.researchCostMultipliers.put(Items.silicon, 0.4f);
                this.researchCostMultiplier = 0.1f;
            }
        };
        container = new StorageBlock("container"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 100));
                this.size = 2;
                this.itemCapacity = 300;
                this.scaledHealth = 55.0f;
            }
        };
        vault = new StorageBlock("vault"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 250, Items.thorium, 125));
                this.size = 3;
                this.itemCapacity = 1000;
                this.scaledHealth = 55.0f;
            }
        };
        reinforcedContainer = new StorageBlock("reinforced-container"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.tungsten, 30, Items.graphite, 40));
                this.size = 2;
                this.itemCapacity = 160;
                this.scaledHealth = 120.0f;
                this.coreMerge = false;
            }
        };
        reinforcedVault = new StorageBlock("reinforced-vault"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.tungsten, 125, Items.thorium, 70, Items.beryllium, 100));
                this.size = 3;
                this.itemCapacity = 900;
                this.scaledHealth = 120.0f;
                this.coreMerge = false;
            }
        };
        duo = new ItemTurret("duo"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 35));
                this.ammo(Items.copper, new BasicBulletType(2.5f, 9.0f){
                    {
                        super(speed, damage);
                        this.width = 7.0f;
                        this.height = 9.0f;
                        this.lifetime = 60.0f;
                        this.ammoMultiplier = 2.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.copperAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.copperAmmoFront;
                    }
                }, Items.graphite, new BasicBulletType(3.5f, 18.0f){
                    {
                        super(speed, damage);
                        this.width = 9.0f;
                        this.height = 12.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lifetime = 60.0f;
                        this.reloadMultiplier = 0.8f;
                        this.rangeChange = 16.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.graphiteAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.graphiteAmmoFront;
                    }
                }, Items.silicon, new BasicBulletType(3.0f, 12.0f){
                    {
                        super(speed, damage);
                        this.width = 7.0f;
                        this.height = 9.0f;
                        this.homingPower = 0.2f;
                        this.reloadMultiplier = 1.5f;
                        this.ammoMultiplier = 5.0f;
                        this.lifetime = 60.0f;
                        this.trailLength = 5;
                        this.trailWidth = 1.5f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.siliconAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.siliconAmmoFront;
                    }
                });
                this.shoot = new ShootAlternate(3.5f);
                this.recoils = 2;
                this.drawer = new DrawTurret(){
                    {
                        for (int i = 0; i < 2; ++i) {
                            final int f = i;
                            this.parts.add(new RegionPart("-barrel-" + (i == 0 ? "l" : "r")){
                                {
                                    super(region);
                                    this.progress = DrawPart.PartProgress.recoil;
                                    this.recoilIndex = f;
                                    this.under = true;
                                    this.moveY = -1.5f;
                                }
                            });
                        }
                    }
                };
                this.shootSound = Sounds.shootDuo;
                this.recoil = 0.5f;
                this.shootY = 3.0f;
                this.reload = 20.0f;
                this.range = 160.0f;
                this.shootCone = 15.0f;
                this.ammoUseEffect = Fx.casing1;
                this.health = 250;
                this.inaccuracy = 2.0f;
                this.rotateSpeed = 10.0f;
                this.coolant = this.consumeCoolant(0.1f);
                this.coolantMultiplier = 10.0f;
                this.researchCostMultiplier = 0.05f;
                this.depositCooldown = 2.0f;
                this.limitRange(5.0f);
            }
        };
        scatter = new ItemTurret("scatter"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 85, Items.lead, 45));
                this.ammo(Items.scrap, new FlakBulletType(4.0f, 3.0f){
                    {
                        super(speed, damage);
                        this.lifetime = 60.0f;
                        this.ammoMultiplier = 5.0f;
                        this.shootEffect = Fx.shootSmall;
                        this.reloadMultiplier = 0.5f;
                        this.width = 6.0f;
                        this.height = 8.0f;
                        this.hitEffect = Fx.flakExplosion;
                        this.splashDamage = 33.0f;
                        this.splashDamageRadius = 24.0f;
                        this.frontColor = Pal.scrapAmmoFront;
                        this.backColor = this.hitColor = Pal.scrapAmmoBack;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.lead, new FlakBulletType(4.2f, 3.0f){
                    {
                        super(speed, damage);
                        this.lifetime = 60.0f;
                        this.ammoMultiplier = 4.0f;
                        this.shootEffect = Fx.shootSmall;
                        this.width = 6.0f;
                        this.height = 8.0f;
                        this.hitEffect = Fx.flakExplosion;
                        this.splashDamage = 40.5f;
                        this.splashDamageRadius = 15.0f;
                    }
                }, Items.metaglass, new FlakBulletType(4.0f, 3.0f){
                    {
                        super(speed, damage);
                        this.backColor = this.trailColor = Pal.glassAmmoBack;
                        this.hitColor = this.frontColor = Pal.glassAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.lifetime = 60.0f;
                        this.ammoMultiplier = 5.0f;
                        this.shootEffect = Fx.shootSmall;
                        this.reloadMultiplier = 0.8f;
                        this.width = 6.0f;
                        this.height = 8.0f;
                        this.hitEffect = Fx.flakExplosion;
                        this.splashDamage = 45.0f;
                        this.splashDamageRadius = 20.0f;
                        this.fragBullets = 6;
                        this.fragBullet = new BasicBulletType(3.0f, 5.0f){
                            {
                                super(speed, damage);
                                this.width = 5.0f;
                                this.height = 12.0f;
                                this.shrinkY = 1.0f;
                                this.lifetime = 20.0f;
                                this.backColor = this.trailColor = Pal.glassAmmoBack;
                                this.hitColor = this.frontColor = Pal.glassAmmoFront;
                                this.despawnEffect = Fx.none;
                                this.collidesGround = false;
                            }
                        };
                    }
                });
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add(new RegionPart("-mid"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.recoil;
                                this.under = false;
                                this.moveY = -1.25f;
                            }
                        });
                    }
                };
                this.reload = 18.0f;
                this.range = 220.0f;
                this.size = 2;
                this.targetGround = false;
                this.shoot.shotDelay = 5.0f;
                this.shoot.shots = 2;
                this.recoil = 1.0f;
                this.rotateSpeed = 15.0f;
                this.inaccuracy = 17.0f;
                this.shootCone = 35.0f;
                this.scaledHealth = 200.0f;
                this.shootSound = Sounds.shootScatter;
                this.coolant = this.consumeCoolant(0.2f);
                this.researchCostMultiplier = 0.05f;
                this.depositCooldown = 0.5f;
                this.limitRange(2.0f);
            }
        };
        scorch = new ItemTurret("scorch"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 25, Items.graphite, 22));
                this.ammo(Items.coal, new BulletType(3.35f, 17.0f){
                    {
                        super(speed, damage);
                        this.ammoMultiplier = 3.0f;
                        this.hitSize = 7.0f;
                        this.lifetime = 18.0f;
                        this.pierce = true;
                        this.collidesAir = false;
                        this.statusDuration = 240.0f;
                        this.shootEffect = Fx.shootSmallFlame;
                        this.hitEffect = Fx.hitFlameSmall;
                        this.despawnEffect = Fx.none;
                        this.status = StatusEffects.burning;
                        this.keepVelocity = false;
                        this.hittable = false;
                    }
                }, Items.pyratite, new BulletType(4.0f, 30.0f){
                    {
                        super(speed, damage);
                        this.ammoMultiplier = 10.0f;
                        this.hitSize = 7.0f;
                        this.lifetime = 18.0f;
                        this.pierce = true;
                        this.collidesAir = false;
                        this.statusDuration = 600.0f;
                        this.shootEffect = Fx.shootPyraFlame;
                        this.hitEffect = Fx.hitFlameSmall;
                        this.despawnEffect = Fx.none;
                        this.status = StatusEffects.burning;
                        this.hittable = false;
                    }
                });
                this.recoil = 0.0f;
                this.reload = 6.0f;
                this.coolantMultiplier = 1.5f;
                this.range = 60.0f;
                this.shootY = 3.0f;
                this.shootCone = 50.0f;
                this.targetAir = false;
                this.ammoUseEffect = Fx.none;
                this.health = 400;
                this.shootSound = Sounds.shootFlame;
                this.coolant = this.consumeCoolant(0.1f);
                this.depositCooldown = 1.0f;
            }
        };
        hail = new ItemTurret("hail"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 40, Items.graphite, 17));
                this.ammo(Items.graphite, new ArtilleryBulletType(3.0f, 20.0f){
                    {
                        super(speed, damage);
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.height = 11.0f;
                        this.width = 11.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 18.75f;
                        this.splashDamage = 33.0f;
                        this.backColor = this.trailColor = Pal.graphiteAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.graphiteAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.silicon, new ArtilleryBulletType(3.0f, 20.0f){
                    {
                        super(speed, damage);
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.height = 11.0f;
                        this.width = 11.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 18.75f;
                        this.splashDamage = 33.0f;
                        this.reloadMultiplier = 1.2f;
                        this.ammoMultiplier = 3.0f;
                        this.homingPower = 0.08f;
                        this.homingRange = 50.0f;
                        this.trailLength = 7;
                        this.trailWidth = 3.0f;
                        this.backColor = this.trailColor = Pal.siliconAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.siliconAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.pyratite, new ArtilleryBulletType(3.0f, 25.0f){
                    {
                        super(speed, damage);
                        this.hitEffect = Fx.blastExplosion;
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.height = 13.0f;
                        this.width = 13.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 18.75f;
                        this.splashDamage = 45.0f;
                        this.status = StatusEffects.burning;
                        this.statusDuration = 720.0f;
                        this.trailColor = this.hitColor = Pal.lightishOrange;
                        this.frontColor = this.hitColor;
                        this.backColor = Pal.lightOrange;
                        this.makeFire = true;
                        this.trailEffect = Fx.incendTrail;
                        this.ammoMultiplier = 4.0f;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                });
                this.targetAir = false;
                this.reload = 60.0f;
                this.recoil = 2.0f;
                this.range = 235.0f;
                this.inaccuracy = 1.0f;
                this.shootCone = 10.0f;
                this.health = 260;
                this.shootSound = Sounds.shootArtillerySmall;
                this.coolant = this.consumeCoolant(0.1f);
                this.coolantMultiplier = 10.0f;
                this.depositCooldown = 2.0f;
                this.limitRange(0.0f);
            }
        };
        wave = new LiquidTurret("wave"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.metaglass, 45, Items.lead, 75, Items.copper, 25));
                this.ammo(Liquids.water, new LiquidBulletType(Liquids.water){
                    {
                        super(liquid);
                        this.knockback = 0.7f;
                        this.drag = 0.01f;
                        this.layer = 98.0f;
                    }
                }, Liquids.slag, new LiquidBulletType(Liquids.slag){
                    {
                        super(liquid);
                        this.damage = 4.0f;
                        this.drag = 0.01f;
                    }
                }, Liquids.cryofluid, new LiquidBulletType(Liquids.cryofluid){
                    {
                        super(liquid);
                        this.drag = 0.01f;
                    }
                }, Liquids.oil, new LiquidBulletType(Liquids.oil){
                    {
                        super(liquid);
                        this.drag = 0.01f;
                        this.layer = 98.0f;
                    }
                });
                this.size = 2;
                this.recoil = 0.0f;
                this.reload = 3.0f;
                this.inaccuracy = 5.0f;
                this.shootCone = 50.0f;
                this.liquidCapacity = 10.0f;
                this.shootEffect = Fx.shootLiquid;
                this.range = 110.0f;
                this.scaledHealth = 250.0f;
                this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret, BlockFlag.extinguisher});
            }
        };
        lancer = new PowerTurret("lancer"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 60, Items.lead, 70, Items.silicon, 60, Items.titanium, 30));
                this.range = 165.0f;
                this.shoot.firstShotDelay = 40.0f;
                this.recoil = 2.0f;
                this.reload = 80.0f;
                this.shake = 2.0f;
                this.shootEffect = Fx.lancerLaserShoot;
                this.smokeEffect = Fx.none;
                this.heatColor = Color.red;
                this.size = 2;
                this.scaledHealth = 280.0f;
                this.targetAir = false;
                this.moveWhileCharging = false;
                this.accurateDelay = false;
                this.shootSound = Sounds.shootLancer;
                this.coolant = this.consumeCoolant(0.2f);
                this.chargeSound = Sounds.chargeLancer;
                this.consumePower(6.0f);
                this.shootType = new LaserBulletType(140.0f){
                    {
                        super(damage);
                        this.colors = new Color[]{Pal.lancerLaser.cpy().a(0.4f), Pal.lancerLaser, Color.white};
                        this.chargeEffect = new MultiEffect(Fx.lancerLaserCharge, Fx.lancerLaserChargeBegin);
                        this.buildingDamageMultiplier = 0.25f;
                        this.armorMultiplier = 4.0f;
                        this.hitEffect = Fx.hitLancer;
                        this.hitSize = 4.0f;
                        this.lifetime = 16.0f;
                        this.drawSize = 400.0f;
                        this.collidesAir = false;
                        this.length = 173.0f;
                        this.ammoMultiplier = 1.0f;
                        this.pierceCap = 4;
                    }
                };
            }
        };
        arc = new PowerTurret("arc"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 50, Items.lead, 50));
                this.shootType = new LightningBulletType(){
                    {
                        this.damage = 20.0f;
                        this.lightningLength = 25;
                        this.collidesAir = false;
                        this.ammoMultiplier = 1.0f;
                        this.buildingDamageMultiplier = 0.25f;
                        this.lightningType = new BulletType(1.0E-4f, 0.0f){
                            {
                                super(speed, damage);
                                this.lifetime = Fx.lightning.lifetime;
                                this.hitEffect = Fx.hitLancer;
                                this.despawnEffect = Fx.none;
                                this.status = StatusEffects.shocked;
                                this.hittable = false;
                                this.lightColor = Color.white;
                                this.collidesAir = false;
                                this.buildingDamageMultiplier = 0.25f;
                                this.shieldDamageMultiplier = 0.2f;
                            }
                        };
                    }
                };
                this.reload = 35.0f;
                this.shootCone = 40.0f;
                this.rotateSpeed = 8.0f;
                this.targetAir = false;
                this.range = 90.0f;
                this.shootEffect = Fx.lightningShoot;
                this.heatColor = Color.red;
                this.recoil = 1.0f;
                this.size = 1;
                this.health = 260;
                this.shootSound = Sounds.shootArc;
                this.consumePower(3.3f);
                this.coolant = this.consumeCoolant(0.1f);
            }
        };
        parallax = new TractorBeamTurret("parallax"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.silicon, 160, Items.titanium, 110, Items.graphite, 50));
                this.hasPower = true;
                this.size = 2;
                this.force = 16.0f;
                this.scaledForce = 9.0f;
                this.range = 300.0f;
                this.damage = 0.5f;
                this.scaledHealth = 160.0f;
                this.rotateSpeed = 12.0f;
                this.consumePower(3.3f);
            }
        };
        swarmer = new ItemTurret("swarmer"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.graphite, 35, Items.titanium, 35, Items.plastanium, 45, Items.silicon, 30));
                this.ammo(Items.blastCompound, new MissileBulletType(3.7f, 10.0f){
                    {
                        super(speed, damage);
                        this.width = 8.0f;
                        this.height = 8.0f;
                        this.shrinkY = 0.0f;
                        this.splashDamageRadius = 30.0f;
                        this.splashDamage = 45.0f;
                        this.ammoMultiplier = 5.0f;
                        this.hitEffect = Fx.blastExplosion;
                        this.despawnEffect = Fx.blastExplosion;
                        this.status = StatusEffects.blasted;
                        this.backColor = this.trailColor = Pal.blastAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.blastAmmoFront;
                    }
                }, Items.pyratite, new MissileBulletType(3.7f, 12.0f){
                    {
                        super(speed, damage);
                        this.frontColor = Pal.lightishOrange;
                        this.backColor = Pal.lightOrange;
                        this.width = 7.0f;
                        this.height = 8.0f;
                        this.shrinkY = 0.0f;
                        this.homingPower = 0.08f;
                        this.splashDamageRadius = 20.0f;
                        this.splashDamage = 45.0f;
                        this.makeFire = true;
                        this.ammoMultiplier = 5.0f;
                        this.hitEffect = Fx.blastExplosion;
                        this.status = StatusEffects.burning;
                    }
                }, Items.surgeAlloy, new MissileBulletType(3.7f, 18.0f){
                    {
                        super(speed, damage);
                        this.width = 8.0f;
                        this.height = 8.0f;
                        this.shrinkY = 0.0f;
                        this.splashDamageRadius = 25.0f;
                        this.splashDamage = 35.0f;
                        this.hitEffect = Fx.blastExplosion;
                        this.despawnEffect = Fx.blastExplosion;
                        this.ammoMultiplier = 4.0f;
                        this.lightningDamage = 10.0f;
                        this.lightning = 2;
                        this.lightningLength = 10;
                        this.backColor = this.trailColor = Pal.surgeAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.surgeAmmoFront;
                    }
                });
                this.shoot = new ShootBarrel(){
                    {
                        this.barrels = new float[]{-4.0f, -1.25f, 0.0f, 0.0f, 0.0f, 0.0f, 4.0f, -1.25f, 0.0f};
                        this.shots = 4;
                        this.shotDelay = 5.0f;
                    }
                };
                this.shootY = 4.5f;
                this.reload = 34.285713f;
                this.inaccuracy = 10.0f;
                this.range = 240.0f;
                this.consumeAmmoOnce = false;
                this.size = 2;
                this.scaledHealth = 300.0f;
                this.shootSound = Sounds.shootMissile;
                this.envEnabled |= 2;
                this.limitRange(5.0f);
                this.coolant = this.consumeCoolant(0.3f);
                this.depositCooldown = 2.0f;
            }
        };
        salvo = new ItemTurret("salvo"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 100, Items.graphite, 80, Items.titanium, 50));
                this.ammo(Items.copper, new BasicBulletType(2.5f, 15.0f){
                    {
                        super(speed, damage);
                        this.width = 7.0f;
                        this.height = 9.0f;
                        this.lifetime = 60.0f;
                        this.ammoMultiplier = 4.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.copperAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.copperAmmoFront;
                    }
                }, Items.graphite, new BasicBulletType(3.5f, 31.0f){
                    {
                        super(speed, damage);
                        this.width = 9.0f;
                        this.height = 12.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lifetime = 60.0f;
                        this.reloadMultiplier = 0.8f;
                        this.rangeChange = 32.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.graphiteAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.graphiteAmmoFront;
                    }
                }, Items.pyratite, new BasicBulletType(3.2f, 25.0f){
                    {
                        super(speed, damage);
                        this.width = 10.0f;
                        this.height = 12.0f;
                        this.frontColor = this.hitColor = Pal.lightishOrange;
                        this.backColor = Pal.lightOrange;
                        this.status = StatusEffects.burning;
                        this.hitEffect = new MultiEffect(Fx.hitBulletColor, Fx.fireHit);
                        this.ammoMultiplier = 5.0f;
                        this.splashDamage = 15.0f;
                        this.splashDamageRadius = 22.0f;
                        this.makeFire = true;
                        this.lifetime = 60.0f;
                    }
                }, Items.silicon, new BasicBulletType(3.0f, 23.0f, "bullet"){
                    {
                        super(speed, damage, bulletSprite);
                        this.width = 8.0f;
                        this.height = 10.0f;
                        this.homingPower = 0.2f;
                        this.reloadMultiplier = 1.5f;
                        this.ammoMultiplier = 5.0f;
                        this.lifetime = 60.0f;
                        this.trailLength = 5;
                        this.trailWidth = 1.5f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.siliconAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.siliconAmmoFront;
                    }
                }, Items.thorium, new BasicBulletType(4.0f, 28.0f, "bullet"){
                    {
                        super(speed, damage, bulletSprite);
                        this.width = 8.0f;
                        this.height = 13.0f;
                        this.shootEffect = Fx.shootBig;
                        this.smokeEffect = Fx.shootBigSmoke;
                        this.ammoMultiplier = 4.0f;
                        this.lifetime = 60.0f;
                        this.armorMultiplier = 0.8f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.hitColor = this.trailColor = Pal.thoriumAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.thoriumAmmoFront;
                    }
                });
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add(new RegionPart("-side"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.moveX = 0.6f;
                                this.moveRot = -15.0f;
                                this.mirror = true;
                                this.layerOffset = 0.001f;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.5f, -0.5f, -8.0f));
                            }
                        }, new RegionPart("-barrel"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.recoil;
                                this.moveY = -2.5f;
                            }
                        });
                    }
                };
                this.size = 2;
                this.range = 190.0f;
                this.reload = 29.0f;
                this.consumeAmmoOnce = false;
                this.ammoEjectBack = 3.0f;
                this.recoil = 0.0f;
                this.shake = 1.0f;
                this.shoot.shots = 4;
                this.shoot.shotDelay = 3.0f;
                this.ammoUseEffect = Fx.casing2;
                this.scaledHealth = 240.0f;
                this.shootSound = Sounds.shootSalvo;
                this.limitRange();
                this.coolant = this.consumeCoolant(0.2f);
                this.depositCooldown = 2.0f;
            }
        };
        segment = new PointDefenseTurret("segment"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.silicon, 130, Items.thorium, 80, Items.phaseFabric, 40, Items.titanium, 40));
                this.scaledHealth = 250.0f;
                this.range = 180.0f;
                this.hasPower = true;
                this.consumePower(8.0f);
                this.size = 2;
                this.shootLength = 5.0f;
                this.bulletDamage = 30.0f;
                this.reload = 8.0f;
                this.envEnabled |= 2;
            }
        };
        tsunami = new LiquidTurret("tsunami"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.metaglass, 100, Items.lead, 400, Items.titanium, 250, Items.thorium, 100));
                this.ammo(Liquids.water, new LiquidBulletType(Liquids.water){
                    {
                        super(liquid);
                        this.lifetime = 49.0f;
                        this.speed = 4.0f;
                        this.knockback = 1.7f;
                        this.puddleSize = 8.0f;
                        this.orbSize = 4.0f;
                        this.drag = 0.001f;
                        this.ammoMultiplier = 0.4f;
                        this.statusDuration = 240.0f;
                        this.damage = 0.2f;
                        this.layer = 98.0f;
                    }
                }, Liquids.slag, new LiquidBulletType(Liquids.slag){
                    {
                        super(liquid);
                        this.lifetime = 49.0f;
                        this.speed = 4.0f;
                        this.knockback = 1.3f;
                        this.puddleSize = 8.0f;
                        this.orbSize = 4.0f;
                        this.damage = 4.75f;
                        this.drag = 0.001f;
                        this.ammoMultiplier = 0.4f;
                        this.statusDuration = 240.0f;
                    }
                }, Liquids.cryofluid, new LiquidBulletType(Liquids.cryofluid){
                    {
                        super(liquid);
                        this.lifetime = 49.0f;
                        this.speed = 4.0f;
                        this.knockback = 1.3f;
                        this.puddleSize = 8.0f;
                        this.orbSize = 4.0f;
                        this.drag = 0.001f;
                        this.ammoMultiplier = 0.4f;
                        this.statusDuration = 240.0f;
                        this.damage = 0.2f;
                    }
                }, Liquids.oil, new LiquidBulletType(Liquids.oil){
                    {
                        super(liquid);
                        this.lifetime = 49.0f;
                        this.speed = 4.0f;
                        this.knockback = 1.3f;
                        this.puddleSize = 8.0f;
                        this.orbSize = 4.0f;
                        this.drag = 0.001f;
                        this.ammoMultiplier = 0.4f;
                        this.statusDuration = 240.0f;
                        this.damage = 0.2f;
                        this.layer = 98.0f;
                    }
                });
                this.size = 3;
                this.reload = 3.0f;
                this.shoot.shots = 2;
                this.velocityRnd = 0.1f;
                this.inaccuracy = 4.0f;
                this.recoil = 1.0f;
                this.shootCone = 45.0f;
                this.liquidCapacity = 40.0f;
                this.shootEffect = Fx.shootLiquid;
                this.range = 190.0f;
                this.scaledHealth = 250.0f;
                this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret, BlockFlag.extinguisher});
            }
        };
        fuse = new ItemTurret("fuse"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 225, Items.graphite, 225, Items.thorium, 100));
                this.reload = 35.0f;
                this.shake = 4.0f;
                this.range = 90.0f;
                this.recoil = 5.0f;
                this.shoot = new ShootSpread(3, 20.0f);
                this.shootCone = 30.0f;
                this.size = 3;
                this.envEnabled |= 2;
                this.scaledHealth = 220.0f;
                this.shootSound = Sounds.shootFuse;
                this.shootSoundVolume = 0.9f;
                this.coolant = this.consumeCoolant(0.3f);
                final float brange = this.range + 10.0f;
                this.ammo(Items.titanium, new ShrapnelBulletType(){
                    {
                        this.length = brange;
                        this.damage = 66.0f;
                        this.ammoMultiplier = 4.0f;
                        this.width = 17.0f;
                        this.reloadMultiplier = 1.3f;
                    }
                }, Items.thorium, new ShrapnelBulletType(){
                    {
                        this.length = brange;
                        this.damage = 105.0f;
                        this.ammoMultiplier = 5.0f;
                        this.toColor = Pal.thoriumPink;
                        this.shootEffect = this.smokeEffect = Fx.thoriumShoot;
                    }
                });
                this.depositCooldown = 1.0f;
            }
        };
        ripple = new ItemTurret("ripple"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 150, Items.graphite, 135, Items.titanium, 60));
                this.ammo(Items.graphite, new ArtilleryBulletType(3.0f, 40.0f){
                    {
                        super(speed, damage);
                        this.hitEffect = new MultiEffect(Fx.flakExplosion, Fx.shockwaveSmaller);
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.width = 12.0f;
                        this.height = 14.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 22.5f;
                        this.splashDamage = 70.0f;
                        this.hitColor = this.trailColor = Pal.graphiteAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.graphiteAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.lifeScaleRandMax = 1.08f;
                        this.lifeScaleRandMin = 0.95f;
                    }
                }, Items.silicon, new ArtilleryBulletType(3.0f, 40.0f){
                    {
                        super(speed, damage);
                        this.hitEffect = new MultiEffect(Fx.flakExplosion, Fx.shockwaveSmaller);
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.width = 12.0f;
                        this.height = 14.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 22.5f;
                        this.splashDamage = 70.0f;
                        this.reloadMultiplier = 1.2f;
                        this.ammoMultiplier = 3.0f;
                        this.homingPower = 0.08f;
                        this.homingRange = 50.0f;
                        this.trailLength = 9;
                        this.trailWidth = 3.1f;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.hitColor = this.trailColor = Pal.siliconAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.siliconAmmoFront;
                        this.lifeScaleRandMax = 1.08f;
                        this.lifeScaleRandMin = 0.95f;
                    }
                }, Items.pyratite, new ArtilleryBulletType(3.0f, 48.0f){
                    {
                        super(speed, damage);
                        this.hitEffect = new MultiEffect(Fx.blastExplosion, Fx.shockwave);
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.width = 13.0f;
                        this.height = 15.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 22.5f;
                        this.splashDamage = 90.0f;
                        this.status = StatusEffects.burning;
                        this.statusDuration = 720.0f;
                        this.frontColor = Pal.lightishOrange;
                        this.backColor = this.hitColor = Pal.lightOrange;
                        this.makeFire = true;
                        this.trailEffect = Fx.incendTrail;
                        this.ammoMultiplier = 4.0f;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.lifeScaleRandMax = 1.08f;
                        this.lifeScaleRandMin = 0.95f;
                    }
                }, Items.blastCompound, new ArtilleryBulletType(2.0f, 40.0f, "shell"){
                    {
                        super(speed, damage, bulletSprite);
                        this.hitEffect = new MultiEffect(Fx.blastExplosion, Fx.shockwave);
                        this.knockback = 0.8f;
                        this.lifetime = 80.0f;
                        this.width = 14.0f;
                        this.height = 16.0f;
                        this.collidesTiles = false;
                        this.ammoMultiplier = 4.0f;
                        this.splashDamageRadius = 37.5f;
                        this.splashDamage = 90.0f;
                        this.status = StatusEffects.blasted;
                        this.lifeScaleRandMax = 1.08f;
                        this.lifeScaleRandMin = 0.95f;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.hitColor = this.trailColor = Pal.blastAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.blastAmmoFront;
                    }
                }, Items.plastanium, new ArtilleryBulletType(3.4f, 40.0f, "shell"){
                    {
                        super(speed, damage, bulletSprite);
                        this.hitEffect = new MultiEffect(Fx.plasticExplosion, Fx.shockwave);
                        this.knockback = 1.0f;
                        this.lifetime = 80.0f;
                        this.width = 13.0f;
                        this.height = 15.0f;
                        this.collidesTiles = false;
                        this.splashDamageRadius = 30.0f;
                        this.splashDamage = 90.0f;
                        this.fragBullet = new BasicBulletType(2.5f, 14.0f, "bullet"){
                            {
                                super(speed, damage, bulletSprite);
                                this.width = 10.0f;
                                this.height = 12.0f;
                                this.shrinkY = 1.0f;
                                this.lifetime = 15.0f;
                                this.backColor = Pal.plastaniumBack;
                                this.frontColor = Pal.plastaniumFront;
                                this.despawnEffect = Fx.none;
                                this.collidesAir = false;
                            }
                        };
                        this.fragBullets = 15;
                        this.backColor = Pal.plastaniumBack;
                        this.frontColor = Pal.plastaniumFront;
                        this.lifeScaleRandMax = 1.08f;
                        this.lifeScaleRandMin = 0.95f;
                    }
                });
                this.targetAir = false;
                this.size = 3;
                this.shoot.shots = 4;
                this.inaccuracy = 11.0f;
                this.reload = 120.0f;
                this.ammoEjectBack = 5.0f;
                this.ammoUseEffect = Fx.casing3Double;
                this.ammoPerShot = 2;
                this.velocityRnd = 0.2f;
                this.scaleLifetimeOffset = 0.11111111f;
                this.recoil = 6.0f;
                this.shake = 2.0f;
                this.range = 290.0f;
                this.minRange = 50.0f;
                this.coolant = this.consumeCoolant(0.3f);
                this.scaledHealth = 130.0f;
                this.depositCooldown = 2.0f;
                this.shootSound = Sounds.shootRipple;
            }
        };
        cyclone = new ItemTurret("cyclone"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 200, Items.titanium, 125, Items.plastanium, 80));
                this.ammo(Items.metaglass, new FlakBulletType(4.0f, 6.0f){
                    {
                        super(speed, damage);
                        this.ammoMultiplier = 2.0f;
                        this.shootEffect = Fx.shootSmall;
                        this.reloadMultiplier = 0.8f;
                        this.width = 6.0f;
                        this.height = 11.0f;
                        this.hitEffect = Fx.flakExplosion;
                        this.splashDamage = 45.0f;
                        this.splashDamageRadius = 25.0f;
                        this.fragBullet = new BasicBulletType(3.0f, 12.0f, "bullet"){
                            {
                                super(speed, damage, bulletSprite);
                                this.width = 5.0f;
                                this.height = 12.0f;
                                this.shrinkY = 1.0f;
                                this.lifetime = 20.0f;
                                this.backColor = Pal.gray;
                                this.frontColor = Color.white;
                                this.despawnEffect = Fx.none;
                            }
                        };
                        this.fragBullets = 4;
                        this.explodeRange = 20.0f;
                        this.collidesGround = true;
                        this.hitColor = this.trailColor = Pal.glassAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.glassAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.blastCompound, new FlakBulletType(4.0f, 8.0f){
                    {
                        super(speed, damage);
                        this.shootEffect = Fx.shootBig;
                        this.ammoMultiplier = 5.0f;
                        this.splashDamage = 45.0f;
                        this.splashDamageRadius = 60.0f;
                        this.collidesGround = true;
                        this.status = StatusEffects.blasted;
                        this.hitColor = this.trailColor = Pal.blastAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.blastAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.plastanium, new FlakBulletType(4.0f, 8.0f){
                    {
                        super(speed, damage);
                        this.ammoMultiplier = 4.0f;
                        this.splashDamageRadius = 40.0f;
                        this.splashDamage = 37.5f;
                        this.fragBullet = new BasicBulletType(2.5f, 12.0f, "bullet"){
                            {
                                super(speed, damage, bulletSprite);
                                this.width = 10.0f;
                                this.height = 12.0f;
                                this.shrinkY = 1.0f;
                                this.lifetime = 15.0f;
                                this.backColor = Pal.plastaniumBack;
                                this.frontColor = Pal.plastaniumFront;
                                this.despawnEffect = Fx.none;
                            }
                        };
                        this.fragBullets = 6;
                        this.hitEffect = Fx.plasticExplosion;
                        this.frontColor = Pal.plastaniumFront;
                        this.backColor = Pal.plastaniumBack;
                        this.shootEffect = Fx.shootBig;
                        this.collidesGround = true;
                        this.explodeRange = 20.0f;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.surgeAlloy, new FlakBulletType(4.5f, 13.0f){
                    {
                        super(speed, damage);
                        this.ammoMultiplier = 5.0f;
                        this.splashDamage = 75.0f;
                        this.splashDamageRadius = 38.0f;
                        this.lightning = 2;
                        this.lightningLength = 7;
                        this.shootEffect = Fx.shootBig;
                        this.collidesGround = true;
                        this.explodeRange = 20.0f;
                        this.hitColor = this.trailColor = Pal.surgeAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.surgeAmmoFront;
                        this.despawnEffect = Fx.hitBulletColor;
                    }
                });
                this.shootY = 10.0f;
                this.shoot = new ShootBarrel(){
                    {
                        this.barrels = new float[]{0.0f, 1.0f, 0.0f, 3.0f, 0.0f, 0.0f, -3.0f, 0.0f, 0.0f};
                    }
                };
                this.recoils = 3;
                this.drawer = new DrawTurret(){
                    {
                        for (int i = 3; i > 0; --i) {
                            final int f = i;
                            this.parts.add(new RegionPart("-barrel-" + i){
                                {
                                    super(region);
                                    this.progress = DrawPart.PartProgress.recoil;
                                    this.recoilIndex = f - 1;
                                    this.under = true;
                                    this.moveY = -2.0f;
                                }
                            });
                        }
                    }
                };
                this.reload = 10.0f;
                this.range = 200.0f;
                this.size = 3;
                this.recoil = 1.5f;
                this.recoilTime = 10.0f;
                this.rotateSpeed = 10.0f;
                this.inaccuracy = 10.0f;
                this.shootCone = 30.0f;
                this.shootSound = Sounds.shootCyclone;
                this.coolant = this.consumeCoolant(0.3f);
                this.scaledHealth = 145.0f;
                this.depositCooldown = 2.0f;
                this.limitRange();
            }
        };
        foreshadow = new ItemTurret("foreshadow"){
            {
                this.range = 500.0f;
                final float brange = 500.0f;
                this.requirements(Category.turret, ItemStack.with(Items.copper, 1000, Items.metaglass, 600, Items.surgeAlloy, 300, Items.plastanium, 200, Items.silicon, 600));
                this.ammo(Items.surgeAlloy, new RailBulletType(){
                    {
                        this.shootEffect = Fx.instShoot;
                        this.hitEffect = Fx.instHit;
                        this.pierceEffect = Fx.railHit;
                        this.smokeEffect = Fx.smokeCloud;
                        this.pointEffect = Fx.instTrail;
                        this.despawnEffect = Fx.instBomb;
                        this.pointEffectSpace = 20.0f;
                        this.damage = 1350.0f;
                        this.buildingDamageMultiplier = 0.2f;
                        this.pierceDamageFactor = 1.0f;
                        this.length = brange;
                        this.hitShake = 6.0f;
                        this.ammoMultiplier = 1.0f;
                    }
                });
                this.maxAmmo = 40;
                this.ammoPerShot = 5;
                this.rotateSpeed = 2.0f;
                this.reload = 200.0f;
                this.ammoUseEffect = Fx.casing3Double;
                this.recoil = 5.0f;
                this.cooldownTime = this.reload;
                this.shake = 4.0f;
                this.size = 4;
                this.shootCone = 2.0f;
                this.shootSound = Sounds.shootForeshadow;
                this.unitSort = UnitSorts.strongest;
                this.envEnabled |= 2;
                this.coolantMultiplier = 0.4f;
                this.liquidCapacity = 60.0f;
                this.scaledHealth = 150.0f;
                this.coolant = this.consumeCoolant(1.0f);
                this.depositCooldown = 2.0f;
                this.consumePower(10.0f);
            }
        };
        spectre = new ItemTurret("spectre"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 900, Items.graphite, 300, Items.surgeAlloy, 250, Items.plastanium, 175, Items.thorium, 250));
                this.ammo(Items.graphite, new BasicBulletType(7.5f, 50.0f){
                    {
                        super(speed, damage);
                        this.hitSize = 4.8f;
                        this.width = 15.0f;
                        this.height = 21.0f;
                        this.shootEffect = Fx.shootBig;
                        this.ammoMultiplier = 4.0f;
                        this.reloadMultiplier = 1.7f;
                        this.knockback = 0.3f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.backColor = this.trailColor = Pal.graphiteAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.graphiteAmmoFront;
                    }
                }, Items.thorium, new BasicBulletType(8.0f, 80.0f){
                    {
                        super(speed, damage);
                        this.hitSize = 5.0f;
                        this.width = 16.0f;
                        this.height = 23.0f;
                        this.shootEffect = Fx.shootBig;
                        this.pierceCap = 2;
                        this.pierceBuilding = true;
                        this.knockback = 0.7f;
                        this.hitColor = this.trailColor = Pal.thoriumAmmoBack;
                        this.backColor = this.trailColor;
                        this.frontColor = Pal.thoriumAmmoFront;
                    }
                }, Items.pyratite, new BasicBulletType(7.0f, 70.0f){
                    {
                        super(speed, damage);
                        this.hitSize = 5.0f;
                        this.width = 16.0f;
                        this.height = 21.0f;
                        this.frontColor = Pal.lightishOrange;
                        this.backColor = Pal.lightOrange;
                        this.status = StatusEffects.burning;
                        this.hitEffect = new MultiEffect(Fx.hitBulletSmall, Fx.fireHit);
                        this.shootEffect = Fx.shootBig;
                        this.makeFire = true;
                        this.pierceCap = 2;
                        this.pierceBuilding = true;
                        this.knockback = 0.6f;
                        this.ammoMultiplier = 3.0f;
                        this.splashDamage = 20.0f;
                        this.splashDamageRadius = 25.0f;
                    }
                });
                this.reload = 7.0f;
                this.recoilTime = this.reload * 2.0f;
                this.coolantMultiplier = 0.5f;
                this.liquidCapacity = 120.0f;
                this.ammoUseEffect = Fx.casing3;
                this.range = 260.0f;
                this.inaccuracy = 3.0f;
                this.recoil = 3.0f;
                this.shoot = new ShootAlternate(8.0f);
                this.shake = 2.0f;
                this.size = 4;
                this.shootCone = 24.0f;
                this.shootSound = Sounds.shootSpectre;
                this.scaledHealth = 160.0f;
                this.coolant = this.consumeCoolant(1.0f);
                this.depositCooldown = 2.0f;
                this.limitRange();
            }
        };
        meltdown = new LaserTurret("meltdown"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 1200, Items.lead, 350, Items.graphite, 300, Items.surgeAlloy, 325, Items.silicon, 325));
                this.shootEffect = Fx.shootBigSmoke2;
                this.shootCone = 40.0f;
                this.recoil = 4.0f;
                this.size = 4;
                this.shake = 2.0f;
                this.range = 195.0f;
                this.reload = 90.0f;
                this.firingMoveFract = 0.5f;
                this.shootDuration = 230.0f;
                this.shootSound = Sounds.shootMeltdown;
                this.loopSound = Sounds.beamMeltdown;
                this.loopSoundVolume = 2.0f;
                this.envEnabled |= 2;
                this.shootType = new ContinuousLaserBulletType(78.0f){
                    {
                        super(damage);
                        this.length = 200.0f;
                        this.hitEffect = Fx.hitMeltdown;
                        this.hitColor = Pal.meltdownHit;
                        this.status = StatusEffects.melting;
                        this.drawSize = 420.0f;
                        this.timescaleDamage = true;
                        this.incendChance = 0.4f;
                        this.incendSpread = 5.0f;
                        this.incendAmount = 1;
                        this.ammoMultiplier = 1.0f;
                    }
                };
                this.scaledHealth = 200.0f;
                this.liquidCapacity = 60.0f;
                this.coolant = this.consumeCoolant(0.5f);
                this.consumePower(17.0f);
            }
        };
        breach = new ItemTurret("breach"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.beryllium, 150, Items.silicon, 150, Items.graphite, 125));
                final MultiEffect sfe = new MultiEffect(Fx.shootBigColor, Fx.colorSparkBig);
                this.ammo(Items.beryllium, new BasicBulletType(7.5f, 85.0f){
                    {
                        super(speed, damage);
                        this.width = 12.0f;
                        this.hitSize = 7.0f;
                        this.height = 20.0f;
                        this.shootEffect = sfe;
                        this.smokeEffect = Fx.shootBigSmoke;
                        this.ammoMultiplier = 1.0f;
                        this.pierceCap = 2;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.backColor = this.trailColor = Pal.berylShot;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 2.1f;
                        this.trailLength = 10;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.buildingDamageMultiplier = 0.3f;
                    }
                }, Items.tungsten, new BasicBulletType(8.0f, 95.0f){
                    {
                        super(speed, damage);
                        this.width = 13.0f;
                        this.height = 19.0f;
                        this.hitSize = 7.0f;
                        this.shootEffect = sfe;
                        this.smokeEffect = Fx.shootBigSmoke;
                        this.ammoMultiplier = 2.0f;
                        this.reloadMultiplier = 1.0f;
                        this.pierceCap = 4;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.backColor = this.trailColor = Pal.tungstenShot;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 2.2f;
                        this.trailLength = 11;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.rangeChange = 40.0f;
                        this.buildingDamageMultiplier = 0.3f;
                    }
                }, Items.carbide, new BasicBulletType(12.0f, 433.33334f){
                    {
                        super(speed, damage);
                        this.width = 15.0f;
                        this.height = 21.0f;
                        this.hitSize = 7.0f;
                        this.shootEffect = sfe;
                        this.smokeEffect = Fx.shootBigSmoke;
                        this.ammoMultiplier = 2.0f;
                        this.reloadMultiplier = 0.2f;
                        this.backColor = this.trailColor = Color.valueOf("ab8ec5");
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 2.2f;
                        this.trailLength = 11;
                        this.trailEffect = Fx.disperseTrail;
                        this.trailInterval = 2.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.rangeChange = 56.0f;
                        this.buildingDamageMultiplier = 0.3f;
                        this.trailRotation = true;
                        this.shootSound = Sounds.shootBreachCarbide;
                        this.fragBullets = 3;
                        this.fragRandomSpread = 0.0f;
                        this.fragSpread = 25.0f;
                        this.fragVelocityMin = 1.0f;
                        this.fragBullet = new BasicBulletType(8.1f, 227.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 8.0f;
                                this.width = 11.0f;
                                this.height = 14.0f;
                                this.hitSize = 7.0f;
                                this.shootEffect = sfe;
                                this.ammoMultiplier = 1.0f;
                                this.reloadMultiplier = 1.0f;
                                this.pierceCap = 2;
                                this.pierce = true;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = Color.valueOf("ab8ec5");
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 1.8f;
                                this.trailLength = 11;
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                                this.buildingDamageMultiplier = 0.2f;
                            }
                        };
                    }
                });
                this.coolantMultiplier = 15.0f;
                this.shootSound = Sounds.shootBreach;
                this.targetUnderBlocks = false;
                this.shake = 1.0f;
                this.ammoPerShot = 2;
                this.drawer = new DrawTurret("reinforced-");
                this.shootY = -2.0f;
                this.outlineColor = Pal.darkOutline;
                this.size = 3;
                this.envEnabled |= 2;
                this.reload = 40.0f;
                this.recoil = 2.0f;
                this.range = 190.0f;
                this.shootCone = 3.0f;
                this.scaledHealth = 180.0f;
                this.rotateSpeed = 1.5f;
                this.researchCostMultiplier = 0.05f;
                this.buildTime = 540.0f;
                this.coolant = this.consume(new ConsumeLiquid(Liquids.water, 0.25f));
                this.limitRange(12.0f);
            }
        };
        diffuse = new ItemTurret("diffuse"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.beryllium, 150, Items.silicon, 200, Items.graphite, 200, Items.tungsten, 50));
                this.ammo(Items.graphite, new BasicBulletType(8.0f, 41.0f){
                    {
                        super(speed, damage);
                        this.knockback = 4.0f;
                        this.width = 25.0f;
                        this.hitSize = 7.0f;
                        this.height = 20.0f;
                        this.shootEffect = Fx.shootBigColor;
                        this.smokeEffect = Fx.shootSmokeSquareSparse;
                        this.ammoMultiplier = 1.0f;
                        this.backColor = this.trailColor = Color.valueOf("ea8878");
                        this.hitColor = this.trailColor;
                        this.frontColor = Pal.redLight;
                        this.trailWidth = 6.0f;
                        this.trailLength = 3;
                        this.hitEffect = this.despawnEffect = Fx.hitSquaresColor;
                        this.buildingDamageMultiplier = 0.2f;
                    }
                }, Items.oxide, new BasicBulletType(8.0f, 90.0f){
                    {
                        super(speed, damage);
                        this.knockback = 3.0f;
                        this.width = 25.0f;
                        this.hitSize = 7.0f;
                        this.height = 20.0f;
                        this.shootEffect = Fx.shootBigColor;
                        this.smokeEffect = Fx.shootSmokeSquareSparse;
                        this.ammoMultiplier = 2.0f;
                        this.backColor = this.trailColor = Color.valueOf("a0b380");
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.valueOf("e4ffd6");
                        this.trailWidth = 6.0f;
                        this.trailLength = 3;
                        this.hitEffect = this.despawnEffect = Fx.hitSquaresColor;
                        this.buildingDamageMultiplier = 0.2f;
                    }
                }, Items.silicon, new BasicBulletType(8.0f, 35.0f){
                    {
                        super(speed, damage);
                        this.knockback = 3.0f;
                        this.width = 25.0f;
                        this.hitSize = 7.0f;
                        this.height = 20.0f;
                        this.homingPower = 0.045f;
                        this.shootEffect = Fx.shootBigColor;
                        this.smokeEffect = Fx.shootSmokeSquareSparse;
                        this.ammoMultiplier = 1.0f;
                        this.backColor = this.trailColor = Pal.siliconAmmoBack;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.valueOf("dae1ee");
                        this.trailWidth = 6.0f;
                        this.trailLength = 6;
                        this.hitEffect = this.despawnEffect = Fx.hitSquaresColor;
                        this.buildingDamageMultiplier = 0.2f;
                    }
                });
                this.shoot = new ShootSpread(15, 4.0f);
                this.coolantMultiplier = 15.0f;
                this.inaccuracy = 0.2f;
                this.velocityRnd = 0.17f;
                this.shake = 1.0f;
                this.ammoPerShot = 3;
                this.maxAmmo = 30;
                this.consumeAmmoOnce = true;
                this.targetUnderBlocks = false;
                this.shootSound = Sounds.shootDiffuse;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.add(new RegionPart("-front"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.moveRot = -10.0f;
                                this.mirror = true;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, -3.0f, -5.0f));
                                this.heatColor = Color.red;
                            }
                        });
                    }
                };
                this.shootY = 5.0f;
                this.outlineColor = Pal.darkOutline;
                this.size = 3;
                this.envEnabled |= 2;
                this.reload = 30.0f;
                this.recoil = 2.0f;
                this.range = 125.0f;
                this.shootCone = 40.0f;
                this.scaledHealth = 210.0f;
                this.rotateSpeed = 3.0f;
                this.coolant = this.consume(new ConsumeLiquid(Liquids.water, 0.25f));
                this.limitRange(25.0f);
            }
        };
        sublimate = new ContinuousLiquidTurret("sublimate"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.tungsten, 150, Items.silicon, 200, Items.oxide, 40, Items.beryllium, 400));
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        Color heatc;
                        super(basePrefix);
                        heatColor = heatc = Color.valueOf("fa2859");
                        this.parts.addAll(new RegionPart("-back"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveRot = 40.0f;
                                this.x = 5.5f;
                                this.y = -0.25f;
                                this.moveY = 1.5f;
                                this.under = true;
                                this.heatColor = heatc;
                            }
                        }, new RegionPart("-front"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveRot = 40.0f;
                                this.x = 5.0f;
                                this.y = 4.25f;
                                this.moveX = 1.0f;
                                this.moveY = 1.0f;
                                this.under = true;
                                this.heatColor = heatc;
                            }
                        }, new RegionPart("-nozzle"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveX = 2.0f;
                                this.heatColor = Color.valueOf("f03b0e");
                            }
                        });
                    }
                };
                this.outlineColor = Pal.darkOutline;
                this.liquidCapacity = 50.0f;
                this.liquidConsumed = 0.3f;
                this.targetInterval = 5.0f;
                this.newTargetInterval = 30.0f;
                this.targetUnderBlocks = false;
                this.shootY = 8.0f;
                this.range = 130.0f;
                final float r = 130.0f;
                this.loopSound = Sounds.shootSublimate;
                this.shootSound = Sounds.none;
                this.loopSoundVolume = 1.0f;
                this.ammo(Liquids.ozone, new ContinuousFlameBulletType(){
                    {
                        this.damage = 60.0f;
                        this.length = r;
                        this.ammoMultiplier = 1.2f;
                        this.knockback = 1.0f;
                        this.pierceCap = 2;
                        this.buildingDamageMultiplier = 0.3f;
                        this.timescaleDamage = true;
                        this.colors = new Color[]{Color.valueOf("eb7abe").a(0.55f), Color.valueOf("e189f5").a(0.7f), Color.valueOf("907ef7").a(0.8f), Color.valueOf("91a4ff"), Color.white};
                    }
                }, Liquids.cyanogen, new ContinuousFlameBulletType(){
                    {
                        this.damage = 130.0f;
                        this.rangeChange = 70.0f;
                        this.length = r + this.rangeChange;
                        this.knockback = 2.0f;
                        this.pierceCap = 3;
                        this.buildingDamageMultiplier = 0.3f;
                        this.timescaleDamage = true;
                        this.colors = new Color[]{Color.valueOf("465ab8").a(0.55f), Color.valueOf("66a6d2").a(0.7f), Color.valueOf("89e8b6").a(0.8f), Color.valueOf("cafcbe"), Color.white};
                        this.lightColor = this.hitColor = (this.flareColor = Color.valueOf("89e8b6"));
                    }
                });
                this.scaledHealth = 210.0f;
                this.size = 3;
                this.researchCost = ItemStack.with(Items.tungsten, 400, Items.silicon, 400, Items.oxide, 80, Items.beryllium, 800);
            }
        };
        titan = new ItemTurret("titan"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.tungsten, 250, Items.silicon, 300, Items.thorium, 400));
                this.ammo(Items.thorium, new ArtilleryBulletType(2.5f, 350.0f, "shell"){
                    {
                        super(speed, damage, bulletSprite);
                        this.hitEffect = new MultiEffect(Fx.titanExplosion, Fx.titanSmoke);
                        this.despawnEffect = Fx.none;
                        this.knockback = 2.0f;
                        this.lifetime = 140.0f;
                        this.height = 19.0f;
                        this.width = 17.0f;
                        this.splashDamageRadius = 65.0f;
                        this.splashDamage = 350.0f;
                        this.scaledSplashDamage = true;
                        this.hitColor = this.trailColor = Color.valueOf("ea8878").lerp(Pal.redLight, 0.5f);
                        this.backColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.ammoMultiplier = 1.0f;
                        this.hitSound = Sounds.explosionTitan;
                        this.status = StatusEffects.blasted;
                        this.trailLength = 32;
                        this.trailWidth = 3.35f;
                        this.trailSinScl = 2.5f;
                        this.trailSinMag = 0.5f;
                        this.trailEffect = Fx.none;
                        this.despawnShake = 7.0f;
                        this.shootEffect = Fx.shootTitan;
                        this.smokeEffect = Fx.shootSmokeTitan;
                        this.trailInterp = v -> Math.max(Mathf.slope(v), 0.8f);
                        this.shrinkX = 0.2f;
                        this.shrinkY = 0.1f;
                        this.buildingDamageMultiplier = 0.3f;
                    }
                }, Items.carbide, new ArtilleryBulletType(3.25f, 700.0f, "shell"){
                    {
                        super(speed, damage, bulletSprite);
                        this.hitEffect = new MultiEffect(Fx.titanExplosionSmall, Fx.titanSmokeSmall);
                        this.despawnEffect = Fx.none;
                        this.knockback = 3.0f;
                        this.lifetime = 140.0f;
                        this.height = 28.0f;
                        this.width = 15.0f;
                        this.splashDamageRadius = 36.0f;
                        this.splashDamage = 750.0f;
                        this.rangeChange = 80.0f;
                        this.reloadMultiplier = 0.8f;
                        this.scaledSplashDamage = true;
                        this.hitColor = this.trailColor = Color.valueOf("ab8ec5");
                        this.backColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.ammoMultiplier = 1.0f;
                        this.hitSound = Sounds.explosionTitan;
                        this.status = StatusEffects.blasted;
                        this.trailLength = 32;
                        this.trailWidth = 3.35f;
                        this.trailSinScl = 2.5f;
                        this.trailSinMag = 0.5f;
                        this.trailEffect = Fx.disperseTrail;
                        this.trailInterval = 2.0f;
                        this.despawnShake = 7.0f;
                        this.shootEffect = Fx.shootTitan;
                        this.smokeEffect = Fx.shootSmokeTitan;
                        this.trailRotation = true;
                        this.trailInterp = v -> Math.max(Mathf.slope(v), 0.8f);
                        this.shrinkX = 0.2f;
                        this.shrinkY = 0.1f;
                        this.buildingDamageMultiplier = 0.2f;
                        this.fragLifeMin = 1.5f;
                        this.fragBullets = 12;
                        this.fragBullet = new ArtilleryBulletType(0.5f, 50.0f, "shell"){
                            {
                                super(speed, damage, bulletSprite);
                                this.hitEffect = new MultiEffect(Fx.titanExplosionFrag, Fx.titanLightSmall, new WaveEffect(){
                                    {
                                        this.lifetime = 8.0f;
                                        this.strokeFrom = 1.0f;
                                        this.sizeTo = 8.0f;
                                    }
                                });
                                this.despawnEffect = Fx.hitBulletColor;
                                this.width = 8.0f;
                                this.height = 12.0f;
                                this.lifetime = 50.0f;
                                this.knockback = 0.5f;
                                this.splashDamageRadius = 22.0f;
                                this.splashDamage = 50.0f;
                                this.scaledSplashDamage = true;
                                this.pierceArmor = true;
                                this.frontColor = this.hitColor = Color.valueOf("ab8ec5");
                                this.backColor = this.hitColor;
                                this.frontColor = Color.white;
                                this.buildingDamageMultiplier = 0.25f;
                                this.shrinkY = 0.3f;
                            }
                        };
                    }
                }, Items.oxide, new ArtilleryBulletType(2.5f, 300.0f, "shell"){
                    {
                        super(speed, damage, bulletSprite);
                        this.hitEffect = new MultiEffect(Fx.titanExplosionLarge, Fx.titanSmokeLarge, Fx.smokeAoeCloud);
                        this.despawnEffect = Fx.none;
                        this.knockback = 2.0f;
                        this.lifetime = 190.0f;
                        this.height = 19.0f;
                        this.width = 17.0f;
                        this.reloadMultiplier = 0.7f;
                        this.splashDamageRadius = 110.0f;
                        this.rangeChange = 8.0f;
                        this.splashDamage = 180.0f;
                        this.scaledSplashDamage = true;
                        this.backColor = this.trailColor = Color.valueOf("a0b380");
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.valueOf("e4ffd6");
                        this.ammoMultiplier = 1.0f;
                        this.hitSound = Sounds.explosionTitan;
                        this.trailLength = 32;
                        this.trailWidth = 3.35f;
                        this.trailSinScl = 2.5f;
                        this.trailSinMag = 0.5f;
                        this.trailEffect = Fx.vapor;
                        this.trailInterval = 3.0f;
                        this.despawnShake = 7.0f;
                        this.shootEffect = Fx.shootTitan;
                        this.smokeEffect = Fx.shootSmokeTitan;
                        this.trailInterp = v -> Math.max(Mathf.slope(v), 0.8f);
                        this.shrinkX = 0.2f;
                        this.shrinkY = 0.1f;
                        this.buildingDamageMultiplier = 0.25f;
                        this.status = StatusEffects.corroded;
                        this.statusDuration = 480.0f;
                        this.fragBullets = 1;
                        this.fragBullet = new EmptyBulletType(){
                            {
                                this.damage = 0.0f;
                                this.lifetime = 150.0f;
                                this.bulletInterval = 20.0f;
                                this.hitEffect = this.despawnEffect = Fx.none;
                                this.intervalBullet = new EmptyBulletType(){
                                    {
                                        this.splashDamage = 15.0f;
                                        this.collidesGround = true;
                                        this.collidesAir = false;
                                        this.collides = false;
                                        this.hitEffect = this.despawnEffect = Fx.none;
                                        this.pierce = true;
                                        this.instantDisappear = true;
                                        this.splashDamageRadius = 90.0f;
                                        this.buildingDamageMultiplier = 0.0f;
                                    }
                                };
                            }
                        };
                    }
                });
                this.shootSound = Sounds.shootTank;
                this.ammoPerShot = 4;
                this.maxAmmo = this.ammoPerShot * 3;
                this.targetAir = false;
                this.shake = 4.0f;
                this.recoil = 1.0f;
                this.reload = 138.0f;
                this.shootY = 7.0f;
                this.rotateSpeed = 1.4f;
                this.minWarmup = 0.85f;
                this.newTargetInterval = 40.0f;
                this.shootWarmupSpeed = 0.07f;
                this.warmupMaintainTime = 120.0f;
                this.coolant = this.consume(new ConsumeLiquid(Liquids.water, 0.5f));
                this.coolantMultiplier = 3.75f;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.addAll(new RegionPart("-barrel"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.recoil.curve(Interp.pow2In);
                                this.moveY = -6.6666665f;
                                this.heatColor = Color.valueOf("f03b0e");
                                this.mirror = false;
                            }
                        }, new RegionPart("-side"){
                            {
                                super(region);
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveX = 2.6666667f;
                                this.moveY = -0.5f;
                                this.moveRot = -40.0f;
                                this.under = true;
                                this.heatColor = Color.red.cpy();
                            }
                        });
                    }
                };
                this.shootWarmupSpeed = 0.08f;
                this.outlineColor = Pal.darkOutline;
                this.consumeLiquid(Liquids.hydrogen, 0.083333336f);
                this.scaledHealth = 250.0f;
                this.range = 390.0f;
                this.size = 4;
            }
        };
        disperse = new ItemTurret("disperse"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.thorium, 50, Items.oxide, 150, Items.silicon, 200, Items.beryllium, 350));
                this.ammo(Items.tungsten, new BasicBulletType(){
                    {
                        this.damage = 65.0f;
                        this.speed = 8.5f;
                        this.height = 16.0f;
                        this.width = 16.0f;
                        this.shrinkY = 0.3f;
                        this.backSprite = "large-bomb-back";
                        this.sprite = "mine-bullet";
                        velocityRnd = 0.11f;
                        this.collidesGround = false;
                        this.collidesTiles = false;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.frontColor = Color.white;
                        this.trailColor = this.hitColor = Color.sky;
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.ammoMultiplier = 3.0f;
                        this.lifetime = 34.0f;
                        this.rotationOffset = 90.0f;
                        this.trailRotation = true;
                        this.trailEffect = Fx.disperseTrail;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.thorium, new BasicBulletType(){
                    {
                        this.damage = 90.0f;
                        this.reloadMultiplier = 0.85f;
                        this.rangeChange = -120.0f;
                        this.speed = 9.5f;
                        this.height = 16.0f;
                        this.width = 16.0f;
                        this.pierceCap = 2;
                        this.shrinkY = 0.3f;
                        this.backSprite = "large-bomb-back";
                        this.sprite = "mine-bullet";
                        velocityRnd = 0.5f;
                        this.collidesGround = false;
                        this.collidesTiles = false;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.frontColor = Color.white;
                        this.trailColor = this.hitColor = Color.valueOf("e89dbd");
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.ammoMultiplier = 1.0f;
                        this.lifetime = 34.0f;
                        this.extraRangeMargin = 32.0f;
                        this.rotationOffset = 90.0f;
                        this.trailRotation = true;
                        this.trailEffect = Fx.disperseTrail;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.silicon, new BasicBulletType(){
                    {
                        this.damage = 37.0f;
                        this.homingPower = 0.045f;
                        this.speed = 9.0f;
                        this.height = 16.0f;
                        this.width = 16.0f;
                        this.shrinkY = 0.3f;
                        this.backSprite = "large-bomb-back";
                        this.sprite = "mine-bullet";
                        velocityRnd = 0.11f;
                        this.collidesGround = false;
                        this.collidesTiles = false;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.frontColor = Color.valueOf("dae1ee");
                        this.trailColor = this.hitColor = Pal.siliconAmmoBack;
                        this.backColor = this.hitColor;
                        this.ammoMultiplier = 4.0f;
                        this.lifetime = 34.0f;
                        this.rotationOffset = 90.0f;
                        this.trailLength = 7;
                        this.extraRangeMargin = 32.0f;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                    }
                }, Items.surgeAlloy, new BasicBulletType(){
                    {
                        this.reloadMultiplier = 0.75f;
                        this.damage = 65.0f;
                        this.rangeChange = 24.0f;
                        this.lightning = 3;
                        this.lightningLength = 4;
                        this.lightningDamage = 18.0f;
                        this.lightningLengthRand = 3;
                        this.speed = 6.0f;
                        this.height = 16.0f;
                        this.width = 16.0f;
                        this.shrinkY = 0.3f;
                        this.backSprite = "large-bomb-back";
                        this.sprite = "mine-bullet";
                        velocityRnd = 0.11f;
                        this.collidesGround = false;
                        this.collidesTiles = false;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.frontColor = Color.white;
                        this.trailColor = this.hitColor = Pal.surge;
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.ammoMultiplier = 3.0f;
                        this.lifetime = 34.0f;
                        this.rotationOffset = 90.0f;
                        this.trailRotation = true;
                        this.trailEffect = Fx.disperseTrail;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.bulletInterval = 4.0f;
                        this.intervalBullet = new BulletType(){
                            {
                                this.collidesGround = false;
                                this.collidesTiles = false;
                                this.lightningLengthRand = 4;
                                this.lightningLength = 2;
                                this.lightningCone = 30.0f;
                                this.lightningDamage = 20.0f;
                                this.lightning = 1;
                                this.collides = false;
                                this.hittable = false;
                                this.instantDisappear = true;
                                this.hitEffect = this.despawnEffect = Fx.none;
                            }
                        };
                    }
                });
                this.reload = 9.0f;
                this.shootY = 15.0f;
                this.rotateSpeed = 5.0f;
                this.shootCone = 30.0f;
                this.consumeAmmoOnce = true;
                this.shootSound = Sounds.shootDisperse;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.add(new RegionPart("-side"){
                            {
                                super(region);
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 1.75f;
                                this.moveY = -0.5f;
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(region);
                                this.under = true;
                                this.moveY = -1.5f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatProgress = DrawPart.PartProgress.recoil.add(0.25f).min(DrawPart.PartProgress.warmup);
                                this.heatColor = Color.sky.cpy().a(0.9f);
                            }
                        }, new RegionPart("-blade"){
                            {
                                super(region);
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatColor = Color.sky.cpy().a(0.9f);
                                this.mirror = true;
                                this.under = true;
                                this.moveY = 1.0f;
                                this.moveX = 1.5f;
                                this.moveRot = 8.0f;
                            }
                        });
                    }
                };
                this.shoot = new ShootAlternate(){
                    {
                        this.spread = 4.7f;
                        this.shots = 4;
                        this.barrels = 4;
                    }
                };
                this.targetGround = false;
                this.inaccuracy = 8.0f;
                this.shootWarmupSpeed = 0.08f;
                this.outlineColor = Pal.darkOutline;
                this.scaledHealth = 280.0f;
                this.range = 310.0f;
                this.size = 4;
                this.coolant = this.consume(new ConsumeLiquid(Liquids.water, 0.33333334f));
                this.coolantMultiplier = 6.25f;
                this.limitRange(16.0f);
            }
        };
        afflict = new PowerTurret("afflict"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.surgeAlloy, 100, Items.silicon, 200, Items.graphite, 250, Items.oxide, 40));
                this.buildCostMultiplier = 1.0f;
                this.shootType = new BasicBulletType(){
                    {
                        this.shootEffect = new MultiEffect(Fx.shootTitan, new WaveEffect(){
                            {
                                this.colorTo = Pal.surge;
                                this.sizeTo = 26.0f;
                                this.lifetime = 14.0f;
                                this.strokeFrom = 4.0f;
                            }
                        });
                        this.smokeEffect = Fx.shootSmokeTitan;
                        this.hitColor = Pal.surge;
                        this.sprite = "large-orb";
                        this.trailEffect = Fx.missileTrail;
                        this.trailInterval = 3.0f;
                        this.trailParam = 4.0f;
                        this.pierceCap = 2;
                        this.buildingDamageMultiplier = 0.5f;
                        this.fragOnHit = false;
                        this.speed = 5.0f;
                        this.damage = 180.0f;
                        this.lifetime = 80.0f;
                        this.height = 16.0f;
                        this.width = 16.0f;
                        this.backColor = Pal.surge;
                        this.frontColor = Color.white;
                        this.shrinkY = 0.0f;
                        this.shrinkX = 0.0f;
                        this.trailColor = Pal.surge;
                        this.trailLength = 12;
                        this.trailWidth = 2.2f;
                        this.despawnEffect = this.hitEffect = new ExplosionEffect(){
                            {
                                this.waveColor = Pal.surge;
                                this.smokeColor = Color.gray;
                                this.sparkColor = Pal.sap;
                                this.waveStroke = 4.0f;
                                this.waveRad = 40.0f;
                            }
                        };
                        this.despawnSound = Sounds.explosionAfflict;
                        this.shootSound = Sounds.shootAfflict;
                        this.fragBullet = this.intervalBullet = new BasicBulletType(3.0f, 35.0f){
                            {
                                super(speed, damage);
                                this.width = 9.0f;
                                this.hitSize = 5.0f;
                                this.height = 15.0f;
                                this.pierceCap = 3;
                                this.lifetime = 28.0f;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = Pal.surge;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 2.1f;
                                this.trailLength = 5;
                                this.hitEffect = this.despawnEffect = new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = Pal.surge;
                                        this.sizeTo = 4.0f;
                                        this.strokeFrom = 4.0f;
                                        this.lifetime = 10.0f;
                                    }
                                };
                                this.buildingDamageMultiplier = 0.3f;
                                this.homingPower = 0.1f;
                            }
                        };
                        this.bulletInterval = 3.0f;
                        this.intervalRandomSpread = 20.0f;
                        this.intervalBullets = 2;
                        this.intervalAngle = 180.0f;
                        this.intervalSpread = 300.0f;
                        this.fragBullets = 20;
                        this.fragVelocityMin = 0.5f;
                        this.fragVelocityMax = 1.2f;
                        this.fragLifeMin = 0.5f;
                    }
                };
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.add(new RegionPart("-blade"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatColor = Color.valueOf("ff6214");
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 2.0f;
                                this.moveY = -1.0f;
                                this.moveRot = -7.0f;
                            }
                        }, new RegionPart("-blade-glow"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatColor = Color.valueOf("ff6214");
                                this.drawRegion = false;
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 2.0f;
                                this.moveY = -1.0f;
                                this.moveRot = -7.0f;
                            }
                        });
                    }
                };
                this.consumePower(5.0f);
                this.heatRequirement = 20.0f;
                this.maxHeatEfficiency = 1.0f;
                this.newTargetInterval = 40.0f;
                this.inaccuracy = 1.0f;
                this.shake = 2.0f;
                this.shootY = 4.0f;
                this.outlineColor = Pal.darkOutline;
                this.size = 4;
                this.envEnabled |= 2;
                this.reload = 50.0f;
                this.cooldownTime = 100.0f;
                this.recoil = 3.0f;
                this.range = 368.0f;
                this.shootCone = 20.0f;
                this.scaledHealth = 220.0f;
                this.rotateSpeed = 1.5f;
                this.researchCostMultiplier = 0.04f;
                this.buildCostMultiplier = 1.5f;
                this.limitRange(-55.0f);
            }
        };
        lustre = new ContinuousTurret("lustre"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.silicon, 250, Items.graphite, 200, Items.oxide, 50, Items.carbide, 90));
                this.shootType = new PointLaserBulletType(){
                    {
                        this.damage = 210.0f;
                        this.buildingDamageMultiplier = 0.3f;
                        this.hitColor = Color.valueOf("fda981");
                    }
                };
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        final DrawPart.PartProgress heatp = DrawPart.PartProgress.warmup.blend(p -> Mathf.absin(2.0f, 1.0f) * p.warmup, 0.2f);
                        this.parts.add(new RegionPart("-blade"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatColor = Color.valueOf("ff6214");
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 2.0f;
                                this.moveRot = -7.0f;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.warmup, 0.0f, -2.0f, 3.0f));
                            }
                        }, new RegionPart("-inner"){
                            {
                                super(region);
                                this.heatProgress = heatp;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatColor = Color.valueOf("ff6214");
                                this.mirror = true;
                                this.under = false;
                                this.moveX = 2.0f;
                                this.moveY = -8.0f;
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(region);
                                this.heatProgress = heatp;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatColor = Color.valueOf("ff6214");
                                this.moveY = -8.0f;
                                this.mirror = false;
                                this.under = true;
                            }
                        });
                    }
                };
                this.scaleDamageEfficiency = true;
                this.shootSound = Sounds.none;
                this.loopSoundVolume = 1.0f;
                this.loopSound = Sounds.beamLustre;
                this.shootWarmupSpeed = 0.08f;
                this.shootCone = 360.0f;
                this.aimChangeSpeed = 0.9f;
                this.rotateSpeed = 0.9f;
                this.shootY = 0.5f;
                this.outlineColor = Pal.darkOutline;
                this.size = 4;
                this.envEnabled |= 2;
                this.range = 250.0f;
                this.scaledHealth = 210.0f;
                this.unitSort = UnitSorts.strongest;
                this.consumeLiquid(Liquids.nitrogen, 0.1f);
                this.consumePower(3.3333333f);
            }
        };
        scathe = new ItemTurret("scathe"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.silicon, 450, Items.graphite, 400, Items.tungsten, 500, Items.oxide, 100, Items.carbide, 200));
                this.predictTarget = false;
                this.ammo(Items.carbide, new BulletType(0.0f, 0.0f){
                    {
                        super(speed, damage);
                        this.shootEffect = Fx.shootBig;
                        this.smokeEffect = Fx.shootSmokeMissileColor;
                        this.hitColor = Pal.redLight;
                        this.ammoMultiplier = 1.0f;
                        this.spawnUnit = new MissileUnitType("scathe-missile"){
                            {
                                super(name);
                                this.speed = 4.6f;
                                this.maxRange = 6.0f;
                                this.lifetime = 330.0f;
                                this.hitSize = 10.0f;
                                this.outlineColor = Pal.darkOutline;
                                this.engineColor = this.trailColor = Pal.redLight;
                                this.engineLayer = 110.0f;
                                this.engineSize = 3.1f;
                                this.engineOffset = 10.0f;
                                this.rotateSpeed = 0.25f;
                                this.trailLength = 18;
                                this.missileAccelTime = 50.0f;
                                this.lowAltitude = true;
                                this.loopSound = Sounds.loopMissileTrail;
                                this.loopSoundVolume = 0.6f;
                                this.deathSound = Sounds.explosionMissile;
                                this.targetAir = false;
                                this.targetUnderBlocks = false;
                                this.fogRadius = 6.0f;
                                this.health = 240.0f;
                                this.weapons.add(new Weapon(){
                                    {
                                        this.shootCone = 360.0f;
                                        this.mirror = false;
                                        this.reload = 1.0f;
                                        deathExplosionEffect = Fx.massiveExplosion;
                                        this.shootOnDeath = true;
                                        this.shake = 10.0f;
                                        this.bullet = new ExplosionBulletType(1000.0f, 65.0f){
                                            {
                                                super(splashDamage, splashDamageRadius);
                                                this.hitColor = Pal.redLight;
                                                this.shootEffect = new MultiEffect(Fx.massiveExplosion, Fx.scatheExplosion, Fx.scatheLight, new WaveEffect(){
                                                    {
                                                        this.lifetime = 10.0f;
                                                        this.strokeFrom = 4.0f;
                                                        this.sizeTo = 130.0f;
                                                    }
                                                });
                                                this.collidesAir = false;
                                                this.buildingDamageMultiplier = 0.1f;
                                                this.ammoMultiplier = 1.0f;
                                                this.fragLifeMin = 0.1f;
                                                this.fragBullets = 7;
                                                this.fragBullet = new ArtilleryBulletType(3.4f, 32.0f){
                                                    {
                                                        super(speed, damage);
                                                        this.buildingDamageMultiplier = 0.1f;
                                                        this.drag = 0.02f;
                                                        this.hitEffect = Fx.massiveExplosion;
                                                        this.despawnEffect = Fx.scatheSlash;
                                                        this.knockback = 0.8f;
                                                        this.lifetime = 23.0f;
                                                        this.height = 18.0f;
                                                        this.width = 18.0f;
                                                        this.collidesTiles = false;
                                                        this.splashDamageRadius = 40.0f;
                                                        this.splashDamage = 100.0f;
                                                        this.trailColor = this.hitColor = Pal.redLight;
                                                        this.backColor = this.hitColor;
                                                        this.frontColor = Color.white;
                                                        this.smokeEffect = Fx.shootBigSmoke2;
                                                        this.despawnShake = 7.0f;
                                                        this.lightRadius = 30.0f;
                                                        this.lightColor = Pal.redLight;
                                                        this.lightOpacity = 0.5f;
                                                        this.trailLength = 20;
                                                        this.trailWidth = 3.5f;
                                                        this.trailEffect = Fx.none;
                                                    }
                                                };
                                            }
                                        };
                                    }
                                });
                                this.abilities.add(new MoveEffectAbility(){
                                    {
                                        this.effect = Fx.missileTrailSmoke;
                                        this.rotation = 180.0f;
                                        this.y = -9.0f;
                                        this.color = Color.grays(0.6f).lerp(Pal.redLight, 0.5f).a(0.4f);
                                        this.interval = 7.0f;
                                    }
                                });
                            }
                        };
                    }
                }, Items.phaseFabric, new BulletType(0.0f, 0.0f){
                    {
                        super(speed, damage);
                        this.shootEffect = Fx.shootBig;
                        this.smokeEffect = Fx.shootSmokeMissileColor;
                        this.hitColor = Color.valueOf("ffd37f");
                        this.ammoMultiplier = 5.0f;
                        this.reloadMultiplier = 0.8f;
                        this.spawnUnit = new MissileUnitType("scathe-missile-phase"){
                            {
                                super(name);
                                this.speed = 2.5f;
                                this.maxRange = 6.0f;
                                this.lifetime = 586.2f;
                                this.hitSize = 10.0f;
                                this.outlineColor = Pal.darkOutline;
                                this.engineColor = this.trailColor = Color.valueOf("ffd37f");
                                this.engineLayer = 110.0f;
                                this.engineSize = 3.1f;
                                this.engineOffset = 10.0f;
                                this.rotateSpeed = 0.2f;
                                this.trailLength = 18;
                                this.missileAccelTime = 50.0f;
                                this.lowAltitude = true;
                                this.loopSound = Sounds.loopMissileTrail;
                                this.loopSoundVolume = 0.6f;
                                this.deathSound = Sounds.explosionMissile;
                                this.targetAir = false;
                                this.targetUnderBlocks = false;
                                this.parts.add(new ShapePart(){
                                    {
                                        this.progress = DrawPart.PartProgress.constant(1.0f);
                                        this.color = Pal.accent;
                                        this.sides = 6;
                                        this.radius = 3.0f;
                                        this.rotateSpeed = 3.0f;
                                        this.hollow = true;
                                        this.layer = 110.0f;
                                        this.y = 1.8f;
                                    }
                                });
                                this.fogRadius = 6.0f;
                                this.health = 500.0f;
                                this.weapons.add(new Weapon(){
                                    {
                                        this.shootCone = 360.0f;
                                        this.mirror = false;
                                        this.reload = 1.0f;
                                        deathExplosionEffect = Fx.massiveExplosion;
                                        this.shootOnDeath = true;
                                        this.shake = 10.0f;
                                        this.bullet = new ExplosionBulletType(320.0f, 120.0f){
                                            {
                                                super(splashDamage, splashDamageRadius);
                                                this.reloadMultiplier = 0.8f;
                                                this.ammoMultiplier = 5.0f;
                                                this.hitColor = engineColor;
                                                this.shootEffect = new MultiEffect(Fx.massiveExplosion, Fx.scatheExplosion, Fx.scatheLight, new WaveEffect(){
                                                    {
                                                        this.lifetime = 10.0f;
                                                        this.strokeFrom = 4.0f;
                                                        this.sizeTo = 130.0f;
                                                    }
                                                });
                                                this.collidesAir = false;
                                                this.buildingDamageMultiplier = 0.1f;
                                                this.fragLifeMin = 0.1f;
                                                this.fragBullets = 7;
                                                this.fragBullet = new ArtilleryBulletType(3.4f, 32.0f){
                                                    {
                                                        super(speed, damage);
                                                        this.buildingDamageMultiplier = 0.2f;
                                                        this.drag = 0.02f;
                                                        this.hitEffect = Fx.massiveExplosion;
                                                        this.despawnEffect = Fx.scatheSlash;
                                                        this.knockback = 0.8f;
                                                        this.lifetime = 23.0f;
                                                        this.height = 18.0f;
                                                        this.width = 18.0f;
                                                        this.collidesTiles = false;
                                                        this.splashDamageRadius = 56.0f;
                                                        this.splashDamage = 120.0f;
                                                        this.trailColor = this.hitColor = engineColor;
                                                        this.backColor = this.hitColor;
                                                        this.frontColor = Color.white;
                                                        this.smokeEffect = Fx.shootBigSmoke2;
                                                        this.despawnShake = 7.0f;
                                                        this.lightRadius = 30.0f;
                                                        this.lightColor = engineColor;
                                                        this.lightOpacity = 0.5f;
                                                        this.trailLength = 20;
                                                        this.trailWidth = 3.5f;
                                                        this.trailEffect = Fx.none;
                                                    }
                                                };
                                            }
                                        };
                                    }
                                });
                                this.abilities.add(new MoveEffectAbility(){
                                    {
                                        this.effect = Fx.missileTrailSmoke;
                                        this.rotation = 180.0f;
                                        this.y = -9.0f;
                                        this.color = Color.grays(0.6f).lerp(Pal.redLight, 0.5f).a(0.4f);
                                        this.interval = 15.0f;
                                    }
                                });
                                this.abilities.add(new ForceFieldAbility(120.0f, 0.0f, 3000.0f, 1.0E9f));
                            }
                        };
                    }
                }, Items.surgeAlloy, new BulletType(0.0f, 0.0f){
                    {
                        super(speed, damage);
                        this.shootEffect = Fx.shootBig;
                        this.smokeEffect = Fx.shootSmokeMissileColor;
                        this.hitColor = Color.valueOf("f7e97e");
                        this.ammoMultiplier = 1.0f;
                        this.reloadMultiplier = 0.9f;
                        this.spawnUnit = new MissileUnitType("scathe-missile-surge"){
                            {
                                super(name);
                                this.speed = 4.4f;
                                this.maxRange = 6.0f;
                                this.lifetime = 84.0f;
                                this.hitSize = 10.0f;
                                this.outlineColor = Pal.darkOutline;
                                this.engineColor = this.trailColor = Color.valueOf("f7e97e");
                                this.engineLayer = 110.0f;
                                this.engineSize = 3.1f;
                                this.engineOffset = 10.0f;
                                this.rotateSpeed = 0.25f;
                                this.trailLength = 18;
                                this.missileAccelTime = 30.0f;
                                this.lowAltitude = true;
                                this.loopSound = Sounds.loopMissileTrail;
                                this.loopSoundVolume = 0.6f;
                                this.deathSound = Sounds.explosionMissile;
                                this.targetAir = false;
                                this.targetUnderBlocks = false;
                                this.fogRadius = 6.0f;
                                this.health = 300.0f;
                                this.weapons.add(new Weapon(){
                                    {
                                        this.shootCone = 360.0f;
                                        this.rotate = true;
                                        this.rotateSpeed = 0.0f;
                                        this.rotationLimit = 0.0f;
                                        this.reload = 1.0f;
                                        deathExplosionEffect = Fx.massiveExplosion;
                                        this.shootOnDeath = true;
                                        this.shake = 10.0f;
                                        this.bullet = new ExplosionBulletType(1800.0f, 40.0f){
                                            {
                                                super(splashDamage, splashDamageRadius);
                                                this.ammoMultiplier = 1.0f;
                                                this.reloadMultiplier = 0.9f;
                                                this.lightning = 10;
                                                this.lightningDamage = 45.0f;
                                                this.lightningLength = 12;
                                                this.hitColor = engineColor;
                                                this.shootEffect = new MultiEffect(Fx.massiveExplosion, Fx.scatheExplosionSmall);
                                                this.collidesAir = false;
                                                this.buildingDamageMultiplier = 0.1f;
                                                this.fragLifeMin = 0.1f;
                                                this.fragBullets = 5;
                                                this.fragRandomSpread = 0.0f;
                                                this.fragSpread = 20.0f;
                                                this.fragBullet = new BulletType(){
                                                    {
                                                        this.shootEffect = Fx.shootBig;
                                                        this.smokeEffect = Fx.shootSmokeMissileColor;
                                                        this.hitColor = engineColor;
                                                        this.ammoMultiplier = 1.0f;
                                                        this.spawnUnit = new MissileUnitType("scathe-missile-surge-split"){
                                                            {
                                                                super(name);
                                                                this.speed = 4.8f;
                                                                this.maxRange = 6.0f;
                                                                this.lifetime = 222.0f;
                                                                this.outlineColor = Pal.darkOutline;
                                                                this.engineColor = this.trailColor = Color.valueOf("f7e97e");
                                                                this.engineLayer = 110.0f;
                                                                this.engineSize = 2.2f;
                                                                this.engineOffset = 8.0f;
                                                                this.rotateSpeed = 1.4f;
                                                                this.trailLength = 12;
                                                                this.lowAltitude = true;
                                                                this.loopSound = Sounds.loopMissileTrail;
                                                                this.loopSoundVolume = 0.6f;
                                                                this.deathSound = Sounds.explosionMissile;
                                                                this.targetAir = false;
                                                                this.targetUnderBlocks = false;
                                                                this.fogRadius = 6.0f;
                                                                this.health = 50.0f;
                                                                this.weapons.add(new Weapon(){
                                                                    {
                                                                        this.shootCone = 360.0f;
                                                                        this.mirror = false;
                                                                        this.reload = 1.0f;
                                                                        deathExplosionEffect = Fx.massiveExplosion;
                                                                        this.shootOnDeath = true;
                                                                        this.shake = 10.0f;
                                                                        this.bullet = new ExplosionBulletType(180.0f, 35.0f){
                                                                            {
                                                                                super(splashDamage, splashDamageRadius);
                                                                                this.lightning = 4;
                                                                                this.lightningDamage = 25.0f;
                                                                                this.lightningLength = 6;
                                                                                this.hitColor = engineColor;
                                                                                this.shootEffect = new MultiEffect(Fx.massiveExplosion, Fx.scatheExplosionSmall, Fx.scatheLightSmall, new WaveEffect(){
                                                                                    {
                                                                                        this.lifetime = 10.0f;
                                                                                        this.strokeFrom = 4.0f;
                                                                                        this.sizeTo = 100.0f;
                                                                                    }
                                                                                });
                                                                                this.collidesAir = false;
                                                                                this.buildingDamageMultiplier = 0.1f;
                                                                            }
                                                                        };
                                                                    }
                                                                });
                                                                this.abilities.add(new MoveEffectAbility(){
                                                                    {
                                                                        this.effect = Fx.missileTrailSmokeSmall;
                                                                        this.rotation = 180.0f;
                                                                        this.y = -9.0f;
                                                                        this.color = Color.grays(0.6f).lerp(Color.valueOf("f7e97e"), 0.5f).a(0.4f);
                                                                        this.interval = 5.0f;
                                                                    }
                                                                });
                                                            }
                                                        };
                                                    }
                                                };
                                            }
                                        };
                                    }
                                });
                                this.abilities.add(new MoveEffectAbility(){
                                    {
                                        this.effect = Fx.missileTrailSmoke;
                                        this.rotation = 180.0f;
                                        this.y = -9.0f;
                                        this.color = Color.grays(0.6f).lerp(Color.valueOf("f7e97e"), 0.5f).a(0.4f);
                                        this.interval = 7.0f;
                                    }
                                });
                            }
                        };
                    }
                });
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.add(new RegionPart("-blade"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatColor = Color.red;
                                this.moveRot = -22.0f;
                                this.moveX = 0.0f;
                                this.moveY = -5.0f;
                                this.mirror = true;
                                this.children.add(new RegionPart("-side"){
                                    {
                                        super(region);
                                        this.progress = DrawPart.PartProgress.warmup.delay(0.6f);
                                        this.heatProgress = DrawPart.PartProgress.recoil;
                                        this.heatColor = Color.red;
                                        this.mirror = true;
                                        this.under = false;
                                        this.moveY = -4.0f;
                                        this.moveX = 1.0f;
                                        this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil, 1.0f, 6.0f, -40.0f));
                                    }
                                });
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatProgress = DrawPart.PartProgress.warmup.add(-0.2f).add(p -> Mathf.sin(9.0f, 0.2f) * p.warmup);
                                this.mirror = false;
                                this.under = true;
                                this.moveY = -5.0f;
                            }
                        }, new RegionPart("-missile"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.reload.curve(Interp.pow2In);
                                this.colorTo = new Color(1.0f, 1.0f, 1.0f, 0.0f);
                                this.color = Color.white;
                                this.mixColorTo = Pal.accent;
                                this.mixColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
                                this.outline = false;
                                this.under = true;
                                this.layerOffset = -0.01f;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.warmup.inv(), 0.0f, -4.0f, 0.0f));
                            }
                        });
                    }
                };
                this.recoil = 0.5f;
                this.fogRadiusMultiplier = 0.4f;
                this.coolantMultiplier = 15.0f;
                this.shootSound = Sounds.shootScathe;
                this.minWarmup = 0.94f;
                this.newTargetInterval = 40.0f;
                this.unitSort = UnitSorts.strongest;
                this.shootWarmupSpeed = 0.03f;
                this.targetAir = false;
                this.targetUnderBlocks = false;
                this.shake = 6.0f;
                this.ammoPerShot = 15;
                this.maxAmmo = 45;
                this.shootY = -1.0f;
                this.outlineColor = Pal.darkOutline;
                this.size = 4;
                this.envEnabled |= 2;
                this.reload = 600.0f;
                this.range = 1350.0f;
                this.shootCone = 1.0f;
                this.scaledHealth = 220.0f;
                this.rotateSpeed = 0.9f;
                this.coolant = this.consume(new ConsumeLiquid(Liquids.water, 0.25f));
                this.limitRange();
            }
        };
        smite = new ItemTurret("smite"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.oxide, 200, Items.surgeAlloy, 400, Items.silicon, 800, Items.carbide, 500, Items.phaseFabric, 300));
                this.ammo(Items.surgeAlloy, new BasicBulletType(7.0f, 250.0f){
                    {
                        super(speed, damage);
                        this.sprite = "large-orb";
                        this.width = 17.0f;
                        this.height = 21.0f;
                        this.hitSize = 8.0f;
                        this.shootEffect = new MultiEffect(Fx.shootTitan, Fx.colorSparkBig, new WaveEffect(){
                            {
                                this.colorFrom = this.colorTo = Pal.accent;
                                this.lifetime = 12.0f;
                                this.sizeTo = 20.0f;
                                this.strokeFrom = 3.0f;
                                this.strokeTo = 0.3f;
                            }
                        });
                        this.smokeEffect = Fx.shootSmokeSmite;
                        this.ammoMultiplier = 1.0f;
                        this.pierceCap = 4;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.backColor = this.trailColor = Pal.accent;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 2.8f;
                        this.trailLength = 9;
                        this.hitEffect = Fx.hitBulletColor;
                        this.buildingDamageMultiplier = 0.3f;
                        this.despawnEffect = new MultiEffect(Fx.hitBulletColor, new WaveEffect(){
                            {
                                this.sizeTo = 30.0f;
                                this.colorFrom = this.colorTo = Pal.accent;
                                this.lifetime = 12.0f;
                            }
                        });
                        this.trailRotation = true;
                        this.trailEffect = Fx.disperseTrail;
                        this.trailInterval = 3.0f;
                        this.intervalBullet = new LightningBulletType(){
                            {
                                this.damage = 30.0f;
                                this.collidesAir = false;
                                this.ammoMultiplier = 1.0f;
                                this.lightningColor = Pal.accent;
                                this.lightningLength = 5;
                                this.lightningLengthRand = 10;
                                this.buildingDamageMultiplier = 0.25f;
                                this.lightningType = new BulletType(1.0E-4f, 0.0f){
                                    {
                                        super(speed, damage);
                                        this.lifetime = Fx.lightning.lifetime;
                                        this.hitEffect = Fx.hitLancer;
                                        this.despawnEffect = Fx.none;
                                        this.status = StatusEffects.shocked;
                                        this.hittable = false;
                                        this.lightColor = Color.white;
                                        this.buildingDamageMultiplier = 0.25f;
                                    }
                                };
                            }
                        };
                        this.bulletInterval = 3.0f;
                    }
                });
                this.shoot = new ShootMulti(new ShootAlternate(){
                    {
                        this.spread = 6.27f;
                        this.barrels = 5;
                        this.shots = 5;
                    }
                }, new ShootHelix(){
                    {
                        this.scl = 4.0f;
                        this.mag = 3.0f;
                    }
                });
                this.shootSound = Sounds.shootSmite;
                this.minWarmup = 0.99f;
                this.coolantMultiplier = 15.0f;
                final DrawPart.PartProgress haloProgress = DrawPart.PartProgress.warmup.delay(0.5f);
                final float haloY = -15.0f;
                final float haloRotSpeed = 1.0f;
                this.shake = 2.0f;
                this.ammoPerShot = 2;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        int fi;
                        super(basePrefix);
                        this.parts.addAll(new RegionPart("-mid"){
                            {
                                super(region);
                                this.heatProgress = DrawPart.PartProgress.heat.blend(DrawPart.PartProgress.warmup, 0.5f);
                                this.mirror = false;
                            }
                        }, new RegionPart("-blade"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveX = 5.5f;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, -3.0f, 0.0f));
                            }
                        }, new RegionPart("-front"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.recoil;
                                this.mirror = true;
                                this.under = true;
                                this.moveY = 4.0f;
                                this.moveX = 6.5f;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, -5.5f, 0.0f));
                            }
                        }, new RegionPart("-back"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 5.5f;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.2f);
                                this.color = Pal.accent;
                                this.circle = true;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 2.0f;
                                this.radius = 10.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.rotateSpeed = haloRotSpeed;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.delay(0.2f);
                                this.color = Pal.accent;
                                this.circle = true;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 1.6f;
                                this.radius = 4.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.rotateSpeed = haloRotSpeed;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotation = 90.0f;
                                this.shapes = 2;
                                this.triLength = 0.0f;
                                this.triLengthTo = 20.0f;
                                this.haloRadius = 16.0f;
                                this.tri = true;
                                this.radius = 4.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotation = 90.0f;
                                this.shapes = 2;
                                this.triLength = 0.0f;
                                this.triLengthTo = 5.0f;
                                this.haloRadius = 16.0f;
                                this.tri = true;
                                this.radius = 4.0f;
                                this.shapeRotation = 180.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotateSpeed = -haloRotSpeed;
                                this.shapes = 4;
                                this.triLength = 0.0f;
                                this.triLengthTo = 5.0f;
                                this.haloRotation = 45.0f;
                                this.haloRadius = 16.0f;
                                this.tri = true;
                                this.radius = 8.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotateSpeed = -haloRotSpeed;
                                this.shapes = 4;
                                this.shapeRotation = 180.0f;
                                this.triLength = 0.0f;
                                this.triLengthTo = 2.0f;
                                this.haloRotation = 45.0f;
                                this.haloRadius = 16.0f;
                                this.tri = true;
                                this.radius = 8.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = Pal.accent;
                                this.layer = 110.0f;
                                this.y = haloY;
                                this.haloRotateSpeed = haloRotSpeed;
                                this.shapes = 4;
                                this.triLength = 0.0f;
                                this.triLengthTo = 3.0f;
                                this.haloRotation = 45.0f;
                                this.haloRadius = 10.0f;
                                this.tri = true;
                                this.radius = 6.0f;
                            }
                        });
                        int i = 0;
                        while (i < 3) {
                            fi = i++;
                            this.parts.add(new RegionPart("-blade-bar"){
                                {
                                    super(region);
                                    this.progress = DrawPart.PartProgress.warmup;
                                    this.heatProgress = DrawPart.PartProgress.warmup;
                                    this.mirror = true;
                                    this.under = true;
                                    this.outline = false;
                                    this.layerOffset = -0.3f;
                                    this.turretHeatLayer = 49.8f;
                                    this.y = 11.0f - (float)fi * 38.0f / 4.0f;
                                    this.moveX = 2.0f;
                                    this.color = Pal.accent;
                                }
                            });
                        }
                        i = 0;
                        while (i < 4) {
                            fi = i++;
                            this.parts.add(new RegionPart("-spine"){
                                {
                                    super(region);
                                    this.progress = DrawPart.PartProgress.warmup.delay((float)fi / 5.0f);
                                    this.heatProgress = DrawPart.PartProgress.warmup;
                                    this.mirror = true;
                                    this.under = true;
                                    this.layerOffset = -0.3f;
                                    this.turretHeatLayer = 49.8f;
                                    this.moveY = -5.5f - (float)fi * 3.0f;
                                    this.moveX = 13.0f - (float)fi * 1.0f + 2.0f;
                                    this.moveRot = (float)(-fi) * 30.0f;
                                    this.color = Pal.accent;
                                    this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil.delay((float)fi / 5.0f), 0.0f, 0.0f, 35.0f));
                                }
                            });
                        }
                    }
                };
                this.shootWarmupSpeed = 0.04f;
                this.shootY = 15.0f;
                this.outlineColor = Pal.darkOutline;
                this.size = 5;
                this.envEnabled |= 2;
                this.warmupMaintainTime = 120.0f;
                this.reload = 100.0f;
                this.recoil = 2.0f;
                this.range = 300.0f;
                this.trackingRange = this.range * 1.4f;
                this.shootCone = 30.0f;
                this.scaledHealth = 350.0f;
                this.rotateSpeed = 1.5f;
                this.coolant = this.consume(new ConsumeLiquid(Liquids.water, 0.25f));
                this.limitRange();
                this.loopSound = Sounds.loopGlow;
                this.loopSoundVolume = 0.8f;
            }
        };
        malign = new PowerTurret("malign"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.carbide, 200, Items.beryllium, 1000, Items.silicon, 500, Items.graphite, 500, Items.phaseFabric, 200));
                final DrawPart.PartProgress haloProgress = DrawPart.PartProgress.warmup;
                final Color haloColor = Color.valueOf("d370d3");
                final Color heatCol = Color.purple;
                final float haloY = -15.0f;
                final float haloRotSpeed = 1.5f;
                final DrawPart.PartProgress circleProgress = DrawPart.PartProgress.warmup.delay(0.9f);
                final Color circleColor = haloColor;
                final float circleY = 25.0f;
                final float circleRad = 11.0f;
                final float circleRotSpeed = 3.5f;
                final float circleStroke = 1.6f;
                this.shootSound = Sounds.shootMalign;
                this.loopSound = Sounds.loopMalign;
                this.loopSoundVolume = 1.3f;
                this.shootType = new FlakBulletType(8.0f, 70.0f){
                    {
                        super(speed, damage);
                        this.sprite = "missile-large";
                        this.lifetime = 40.0f;
                        this.width = 12.0f;
                        this.height = 22.0f;
                        this.hitSize = 7.0f;
                        this.shootEffect = Fx.shootSmokeSquareBig;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.ammoMultiplier = 1.0f;
                        this.trailColor = this.lightningColor = circleColor;
                        this.backColor = this.lightningColor;
                        this.hitColor = this.lightningColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 3.0f;
                        this.trailLength = 12;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.buildingDamageMultiplier = 0.3f;
                        this.trailEffect = Fx.colorSpark;
                        this.trailRotation = true;
                        this.trailInterval = 3.0f;
                        this.homingPower = 0.17f;
                        this.homingDelay = 19.0f;
                        this.homingRange = 160.0f;
                        this.explodeRange = 100.0f;
                        this.explodeDelay = 0.0f;
                        this.flakInterval = 20.0f;
                        this.despawnShake = 3.0f;
                        this.intervalBullet = new LightningBulletType(){
                            {
                                this.lightningColor = circleColor;
                                this.lightningCone = 15.0f;
                                this.lightningLength = 35;
                                this.lightningLengthRand = 5;
                                this.damage = 18.0f;
                            }
                        };
                        this.fragBullet = new LaserBulletType(65.0f){
                            {
                                super(damage);
                                this.colors = new Color[]{haloColor.cpy().a(0.4f), haloColor, Color.white};
                                this.buildingDamageMultiplier = 0.25f;
                                this.width = 19.0f;
                                this.hitEffect = Fx.hitLancer;
                                this.sideAngle = 175.0f;
                                this.sideWidth = 1.0f;
                                this.sideLength = 40.0f;
                                this.lifetime = 22.0f;
                                this.drawSize = 400.0f;
                                this.length = 120.0f;
                                this.pierceCap = 2;
                                this.optimalLifeFract = 1.0f;
                            }
                        };
                        this.intervalBullets = 1;
                        this.intervalRandomSpread = 0.0f;
                        this.fragRandomSpread = 0.0f;
                        this.fragSpread = 0.0f;
                        this.bulletInterval = 20.0f;
                        this.splashDamage = 0.0f;
                        this.hitEffect = Fx.hitSquaresColor;
                        this.collidesGround = true;
                    }
                };
                this.size = 5;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.addAll(new ShapePart(){
                            {
                                this.progress = circleProgress;
                                this.color = circleColor;
                                this.circle = true;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = circleStroke;
                                this.radius = circleRad;
                                this.layer = 110.0f;
                                this.y = circleY;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = circleProgress;
                                this.rotateSpeed = -circleRotSpeed;
                                this.color = circleColor;
                                this.sides = 4;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = circleStroke;
                                this.radius = circleRad - 1.0f;
                                this.layer = 110.0f;
                                this.y = circleY;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = circleProgress;
                                this.rotateSpeed = -circleRotSpeed;
                                this.color = circleColor;
                                this.sides = 4;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = circleStroke;
                                this.radius = circleRad - 1.0f;
                                this.layer = 110.0f;
                                this.y = circleY;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = circleProgress;
                                this.rotateSpeed = -circleRotSpeed / 2.0f;
                                this.color = circleColor;
                                this.sides = 4;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 2.0f;
                                this.radius = 3.0f;
                                this.layer = 110.0f;
                                this.y = circleY;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = circleProgress;
                                this.color = circleColor;
                                this.tri = true;
                                this.shapes = 3;
                                this.triLength = 0.0f;
                                this.triLengthTo = 5.0f;
                                this.radius = 6.0f;
                                this.haloRadius = circleRad;
                                this.haloRotateSpeed = haloRotSpeed / 2.0f;
                                this.shapeRotation = 180.0f;
                                this.haloRotation = 180.0f;
                                this.layer = 110.0f;
                                this.y = circleY;
                            }
                        }, new RegionPart("-mouth"){
                            {
                                super(region);
                                this.heatColor = heatCol;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.moveY = -8.0f;
                            }
                        }, new RegionPart("-end"){
                            {
                                super(region);
                                this.moveY = 0.0f;
                            }
                        }, new RegionPart("-front"){
                            {
                                super(region);
                                this.heatColor = heatCol;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveRot = 33.0f;
                                this.moveY = -4.0f;
                                this.moveX = 10.0f;
                            }
                        }, new RegionPart("-back"){
                            {
                                super(region);
                                this.heatColor = heatCol;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.moveRot = 10.0f;
                                this.moveX = 2.0f;
                                this.moveY = 5.0f;
                            }
                        }, new RegionPart("-mid"){
                            {
                                super(region);
                                this.heatColor = heatCol;
                                this.heatProgress = DrawPart.PartProgress.recoil;
                                this.moveY = -9.5f;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.circle = true;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 2.0f;
                                this.radius = 10.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        }, new ShapePart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.sides = 3;
                                this.rotation = 90.0f;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 2.0f;
                                this.radius = 4.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.sides = 3;
                                this.shapes = 3;
                                this.hollow = true;
                                this.stroke = 0.0f;
                                this.strokeTo = 2.0f;
                                this.radius = 3.0f;
                                this.haloRadius = 10.0f + this.radius / 2.0f;
                                this.haloRotateSpeed = haloRotSpeed;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.tri = true;
                                this.shapes = 3;
                                this.triLength = 0.0f;
                                this.triLengthTo = 10.0f;
                                this.radius = 6.0f;
                                this.haloRadius = 16.0f;
                                this.haloRotation = 180.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.tri = true;
                                this.shapes = 3;
                                this.triLength = 0.0f;
                                this.triLengthTo = 3.0f;
                                this.radius = 6.0f;
                                this.haloRadius = 16.0f;
                                this.shapeRotation = 180.0f;
                                this.haloRotation = 180.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.sides = 3;
                                this.tri = true;
                                this.shapes = 3;
                                this.triLength = 0.0f;
                                this.triLengthTo = 10.0f;
                                this.shapeRotation = 180.0f;
                                this.radius = 6.0f;
                                this.haloRadius = 16.0f;
                                this.haloRotateSpeed = -haloRotSpeed;
                                this.haloRotation = 60.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        }, new HaloPart(){
                            {
                                this.progress = haloProgress;
                                this.color = haloColor;
                                this.sides = 3;
                                this.tri = true;
                                this.shapes = 3;
                                this.triLength = 0.0f;
                                this.triLengthTo = 4.0f;
                                this.radius = 6.0f;
                                this.haloRadius = 16.0f;
                                this.haloRotateSpeed = -haloRotSpeed;
                                this.haloRotation = 60.0f;
                                this.layer = 110.0f;
                                this.y = haloY;
                            }
                        });
                        final Color heatCol2 = heatCol.cpy().add(0.1f, 0.1f, 0.1f).mul(1.2f);
                        int i = 1;
                        while (i < 4) {
                            final int fi = i++;
                            this.parts.add(new RegionPart("-spine"){
                                {
                                    super(region);
                                    this.outline = false;
                                    this.progress = DrawPart.PartProgress.warmup.delay((float)fi / 5.0f);
                                    this.heatProgress = DrawPart.PartProgress.warmup.add(p -> (Mathf.absin(3.0f, 0.2f) - 0.2f) * p.warmup);
                                    this.mirror = true;
                                    this.under = true;
                                    this.layerOffset = -0.3f;
                                    this.turretHeatLayer = 49.8f;
                                    this.moveY = 9.0f;
                                    this.moveX = 1.0f + (float)fi * 4.0f;
                                    this.moveRot = (float)fi * 60.0f - 130.0f;
                                    this.color = Color.valueOf("bb68c3");
                                    this.heatColor = heatCol2;
                                    this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.recoil.delay((float)fi / 5.0f), 1.0f, 0.0f, 3.0f));
                                }
                            });
                        }
                    }
                };
                this.velocityRnd = 0.15f;
                this.heatRequirement = 144.0f;
                this.maxHeatEfficiency = 1.0f;
                this.warmupMaintainTime = 120.0f;
                this.consumePower(40.0f);
                this.unitSort = UnitSorts.strongest;
                this.shoot = new ShootSummon(0.0f, 0.0f, circleRad, 20.0f);
                this.minWarmup = 0.96f;
                this.shootWarmupSpeed = 0.08f;
                this.shootY = circleY - 5.0f;
                this.outlineColor = Pal.darkOutline;
                this.envEnabled |= 2;
                this.reload = 3.5f;
                this.range = 410.0f;
                this.trackingRange = this.range * 1.4f;
                this.shootCone = 100.0f;
                this.scaledHealth = 370.0f;
                this.rotateSpeed = 2.6f;
                this.recoil = 0.5f;
                this.recoilTime = 30.0f;
                this.shake = 3.0f;
            }
        };
        groundFactory = new UnitFactory("ground-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 50, Items.lead, 120, Items.silicon, 80));
                this.plans = Seq.with(new UnitFactory.UnitPlan(UnitTypes.dagger, 900.0f, ItemStack.with(Items.silicon, 10, Items.lead, 10)), new UnitFactory.UnitPlan(UnitTypes.crawler, 600.0f, ItemStack.with(Items.silicon, 8, Items.coal, 10)), new UnitFactory.UnitPlan(UnitTypes.nova, 2400.0f, ItemStack.with(Items.silicon, 30, Items.lead, 20, Items.titanium, 20)));
                this.size = 3;
                this.consumePower(1.2f);
                this.researchCostMultiplier = 0.5f;
            }
        };
        airFactory = new UnitFactory("air-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 60, Items.lead, 70, Items.silicon, 60));
                this.plans = Seq.with(new UnitFactory.UnitPlan(UnitTypes.flare, 900.0f, ItemStack.with(Items.silicon, 15)), new UnitFactory.UnitPlan(UnitTypes.mono, 2100.0f, ItemStack.with(Items.silicon, 30, Items.lead, 15)));
                this.size = 3;
                this.consumePower(1.2f);
                this.researchCostMultiplier = 0.5f;
            }
        };
        navalFactory = new UnitFactory("naval-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 150, Items.lead, 130, Items.metaglass, 120));
                this.plans = Seq.with(new UnitFactory.UnitPlan(UnitTypes.risso, 2700.0f, ItemStack.with(Items.silicon, 20, Items.metaglass, 35)), new UnitFactory.UnitPlan(UnitTypes.retusa, 2100.0f, ItemStack.with(Items.silicon, 15, Items.titanium, 20)));
                this.size = 3;
                this.consumePower(1.2f);
                this.floating = true;
            }
        };
        additiveReconstructor = new Reconstructor("additive-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 200, Items.lead, 120, Items.silicon, 90));
                this.size = 3;
                this.consumePower(3.0f);
                this.consumeItems(ItemStack.with(Items.silicon, 40, Items.graphite, 40));
                this.constructTime = 600.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.nova, UnitTypes.pulsar}, {UnitTypes.dagger, UnitTypes.mace}, {UnitTypes.crawler, UnitTypes.atrax}, {UnitTypes.flare, UnitTypes.horizon}, {UnitTypes.mono, UnitTypes.poly}, {UnitTypes.risso, UnitTypes.minke}, {UnitTypes.retusa, UnitTypes.oxynoe}});
            }
        };
        multiplicativeReconstructor = new Reconstructor("multiplicative-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 650, Items.silicon, 450, Items.titanium, 350, Items.thorium, 650));
                this.size = 5;
                this.consumePower(6.0f);
                this.consumeItems(ItemStack.with(Items.silicon, 130, Items.titanium, 80, Items.metaglass, 40));
                this.constructTime = 1800.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.horizon, UnitTypes.zenith}, {UnitTypes.mace, UnitTypes.fortress}, {UnitTypes.poly, UnitTypes.mega}, {UnitTypes.minke, UnitTypes.bryde}, {UnitTypes.pulsar, UnitTypes.quasar}, {UnitTypes.atrax, UnitTypes.spiroct}, {UnitTypes.oxynoe, UnitTypes.cyerce}});
            }
        };
        exponentialReconstructor = new Reconstructor("exponential-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 2000, Items.silicon, 1000, Items.titanium, 2000, Items.thorium, 750, Items.plastanium, 450, Items.phaseFabric, 600));
                this.size = 7;
                this.consumePower(13.0f);
                this.consumeItems(ItemStack.with(Items.silicon, 850, Items.titanium, 750, Items.plastanium, 650));
                this.consumeLiquid(Liquids.cryofluid, 1.0f);
                this.createSound = Sounds.unitCreateBig;
                this.constructTime = 5400.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.zenith, UnitTypes.antumbra}, {UnitTypes.spiroct, UnitTypes.arkyid}, {UnitTypes.fortress, UnitTypes.scepter}, {UnitTypes.bryde, UnitTypes.sei}, {UnitTypes.mega, UnitTypes.quad}, {UnitTypes.quasar, UnitTypes.vela}, {UnitTypes.cyerce, UnitTypes.aegires}});
            }
        };
        tetrativeReconstructor = new Reconstructor("tetrative-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 4000, Items.silicon, 3000, Items.thorium, 1000, Items.plastanium, 600, Items.phaseFabric, 600, Items.surgeAlloy, 800));
                this.size = 9;
                this.consumePower(25.0f);
                this.consumeItems(ItemStack.with(Items.silicon, 1000, Items.plastanium, 600, Items.surgeAlloy, 500, Items.phaseFabric, 350));
                this.consumeLiquid(Liquids.cryofluid, 3.0f);
                this.constructTime = 14400.0f;
                this.createSound = Sounds.unitCreateBig;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.antumbra, UnitTypes.eclipse}, {UnitTypes.arkyid, UnitTypes.toxopid}, {UnitTypes.scepter, UnitTypes.reign}, {UnitTypes.sei, UnitTypes.omura}, {UnitTypes.quad, UnitTypes.oct}, {UnitTypes.vela, UnitTypes.corvus}, {UnitTypes.aegires, UnitTypes.navanax}});
            }
        };
        repairPoint = new RepairTurret("repair-point"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 30, Items.copper, 30, Items.silicon, 20));
                this.repairSpeed = 0.45f;
                this.repairRadius = 60.0f;
                this.beamWidth = 0.73f;
                this.powerUse = 1.0f;
                this.pulseRadius = 5.0f;
                this.ambientSoundVolume = 0.9f;
            }
        };
        repairTurret = new RepairTurret("repair-turret"){
            {
                this.requirements(Category.units, ItemStack.with(Items.silicon, 90, Items.thorium, 80, Items.plastanium, 60));
                this.size = 2;
                this.length = 6.0f;
                this.repairSpeed = 3.0f;
                this.repairRadius = 145.0f;
                this.powerUse = 5.0f;
                this.beamWidth = 1.1f;
                this.pulseRadius = 6.1f;
                this.coolantUse = 0.16f;
                this.coolantMultiplier = 1.6f;
                this.acceptCoolant = true;
                this.ambientSoundVolume = 1.25f;
            }
        };
        tankFabricator = new UnitFactory("tank-fabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.silicon, 200, Items.beryllium, 150));
                this.size = 3;
                this.configurable = false;
                this.plans.add(new UnitFactory.UnitPlan(UnitTypes.stell, 2100.0f, ItemStack.with(Items.beryllium, 40, Items.silicon, 50)));
                this.researchCost = ItemStack.with(Items.beryllium, 200, Items.graphite, 80, Items.silicon, 80);
                this.regionSuffix = "-dark";
                this.fogRadius = 3;
                this.consumePower(1.5f);
            }
        };
        shipFabricator = new UnitFactory("ship-fabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.silicon, 250, Items.beryllium, 200));
                this.size = 3;
                this.configurable = false;
                this.plans.add(new UnitFactory.UnitPlan(UnitTypes.elude, 2400.0f, ItemStack.with(Items.graphite, 50, Items.silicon, 70)));
                this.regionSuffix = "-dark";
                this.fogRadius = 3;
                this.researchCostMultiplier = 0.5f;
                this.consumePower(1.5f);
            }
        };
        mechFabricator = new UnitFactory("mech-fabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.silicon, 200, Items.beryllium, 250, Items.tungsten, 10));
                this.size = 3;
                this.configurable = false;
                this.plans.add(new UnitFactory.UnitPlan(UnitTypes.merui, 2400.0f, ItemStack.with(Items.beryllium, 50, Items.silicon, 70)));
                this.regionSuffix = "-dark";
                this.fogRadius = 3;
                this.researchCostMultiplier = 0.65f;
                this.consumePower(1.5f);
            }
        };
        tankRefabricator = new Reconstructor("tank-refabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.beryllium, 200, Items.tungsten, 80, Items.silicon, 100));
                this.regionSuffix = "-dark";
                this.size = 3;
                this.consumePower(3.0f);
                this.consumeLiquid(Liquids.hydrogen, 0.05f);
                this.consumeItems(ItemStack.with(Items.silicon, 40, Items.tungsten, 30));
                this.constructTime = 1800.0f;
                this.researchCostMultiplier = 0.75f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.stell, UnitTypes.locus}});
            }
        };
        shipRefabricator = new Reconstructor("ship-refabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.beryllium, 250, Items.tungsten, 120, Items.silicon, 150, Items.oxide, 15));
                this.regionSuffix = "-dark";
                this.size = 3;
                this.consumePower(2.5f);
                this.consumeLiquid(Liquids.hydrogen, 0.05f);
                this.consumeItems(ItemStack.with(Items.silicon, 60, Items.tungsten, 40));
                this.constructTime = 3000.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.elude, UnitTypes.avert}});
                this.researchCost = ItemStack.with(Items.beryllium, 500, Items.tungsten, 200, Items.silicon, 300, Items.oxide, 80);
            }
        };
        mechRefabricator = new Reconstructor("mech-refabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.beryllium, 250, Items.tungsten, 175, Items.silicon, 150));
                this.regionSuffix = "-dark";
                this.size = 3;
                this.consumePower(2.5f);
                this.consumeLiquid(Liquids.hydrogen, 0.05f);
                this.consumeItems(ItemStack.with(Items.silicon, 50, Items.tungsten, 40));
                this.constructTime = 2700.0f;
                this.researchCostMultiplier = 0.75f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.merui, UnitTypes.cleroi}});
            }
        };
        primeRefabricator = new Reconstructor("prime-refabricator"){
            {
                this.requirements(Category.units, ItemStack.with(Items.thorium, 250, Items.oxide, 200, Items.tungsten, 200, Items.silicon, 400));
                this.regionSuffix = "-dark";
                this.researchCostMultipliers.put(Items.thorium, 0.2f);
                this.size = 5;
                this.consumePower(4.5f);
                this.consumeLiquid(Liquids.nitrogen, 0.16666667f);
                this.consumeItems(ItemStack.with(Items.thorium, 80, Items.silicon, 100));
                this.constructTime = 3600.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.locus, UnitTypes.precept}, {UnitTypes.cleroi, UnitTypes.anthicus}, {UnitTypes.avert, UnitTypes.obviate}});
            }
        };
        tankAssembler = new UnitAssembler("tank-assembler"){
            {
                this.requirements(Category.units, ItemStack.with(Items.thorium, 500, Items.oxide, 150, Items.carbide, 80, Items.silicon, 650));
                this.regionSuffix = "-dark";
                this.size = 5;
                this.plans.add(new UnitAssembler.AssemblerUnitPlan(UnitTypes.vanquish, 3000.0f, PayloadStack.list(UnitTypes.stell, 4, tungstenWallLarge, 10)), new UnitAssembler.AssemblerUnitPlan(UnitTypes.conquer, 10800.0f, PayloadStack.list(UnitTypes.locus, 6, carbideWallLarge, 20)));
                this.areaSize = 13;
                this.researchCostMultiplier = 0.4f;
                this.consumePower(2.5f);
                this.consumeLiquid(Liquids.cyanogen, 0.15f);
            }
        };
        shipAssembler = new UnitAssembler("ship-assembler"){
            {
                this.requirements(Category.units, ItemStack.with(Items.carbide, 100, Items.oxide, 200, Items.tungsten, 550, Items.silicon, 900, Items.thorium, 400));
                this.regionSuffix = "-dark";
                this.size = 5;
                this.plans.add(new UnitAssembler.AssemblerUnitPlan(UnitTypes.quell, 3600.0f, PayloadStack.list(UnitTypes.elude, 4, berylliumWallLarge, 12)), new UnitAssembler.AssemblerUnitPlan(UnitTypes.disrupt, 10800.0f, PayloadStack.list(UnitTypes.avert, 6, carbideWallLarge, 20)));
                this.areaSize = 13;
                this.consumePower(2.5f);
                this.consumeLiquid(Liquids.cyanogen, 0.2f);
            }
        };
        mechAssembler = new UnitAssembler("mech-assembler"){
            {
                this.requirements(Category.units, ItemStack.with(Items.carbide, 200, Items.thorium, 600, Items.oxide, 200, Items.tungsten, 550, Items.silicon, 1000));
                this.regionSuffix = "-dark";
                this.size = 5;
                this.plans.add(new UnitAssembler.AssemblerUnitPlan(UnitTypes.tecta, 4200.0f, PayloadStack.list(UnitTypes.merui, 5, tungstenWallLarge, 12)), new UnitAssembler.AssemblerUnitPlan(UnitTypes.collaris, 10800.0f, PayloadStack.list(UnitTypes.cleroi, 6, carbideWallLarge, 20)));
                this.areaSize = 13;
                this.consumePower(3.0f);
                this.consumeLiquid(Liquids.cyanogen, 0.2f);
            }
        };
        basicAssemblerModule = new UnitAssemblerModule("basic-assembler-module"){
            {
                this.requirements(Category.units, ItemStack.with(Items.carbide, 300, Items.thorium, 500, Items.oxide, 250, Items.phaseFabric, 400));
                this.consumePower(3.5f);
                this.regionSuffix = "-dark";
                this.researchCostMultiplier = 0.75f;
                this.size = 5;
            }
        };
        unitRepairTower = new RepairTower("unit-repair-tower"){
            {
                this.requirements(Category.units, ItemStack.with(Items.graphite, 90, Items.silicon, 90, Items.tungsten, 80));
                this.size = 2;
                this.range = 100.0f;
                this.healAmount = 1.5f;
                this.consumePower(1.0f);
                this.consumeLiquid(Liquids.ozone, 0.05f);
            }
        };
        payloadConveyor = new PayloadConveyor("payload-conveyor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.graphite, 10, Items.copper, 10));
                this.canOverdrive = false;
            }
        };
        payloadRouter = new PayloadRouter("payload-router"){
            {
                this.requirements(Category.units, ItemStack.with(Items.graphite, 15, Items.copper, 10));
                this.canOverdrive = false;
            }
        };
        reinforcedPayloadConveyor = new PayloadConveyor("reinforced-payload-conveyor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.tungsten, 10));
                this.moveTime = 35.0f;
                this.canOverdrive = false;
                this.health = 800;
                this.researchCostMultiplier = 4.0f;
                this.underBullets = true;
            }
        };
        reinforcedPayloadRouter = new PayloadRouter("reinforced-payload-router"){
            {
                this.requirements(Category.units, ItemStack.with(Items.tungsten, 15));
                this.moveTime = 35.0f;
                this.health = 800;
                this.canOverdrive = false;
                this.researchCostMultiplier = 4.0f;
                this.underBullets = true;
            }
        };
        payloadMassDriver = new PayloadMassDriver("payload-mass-driver"){
            {
                this.requirements(Category.units, ItemStack.with(Items.tungsten, 40, Items.silicon, 50, Items.graphite, 20));
                this.regionSuffix = "-dark";
                this.size = 3;
                this.reload = 130.0f;
                this.chargeTime = 90.0f;
                this.range = 700.0f;
                this.maxPayloadSize = 2.5f;
                this.fogRadius = 5;
                this.consumePower(0.5f);
            }
        };
        largePayloadMassDriver = new PayloadMassDriver("large-payload-mass-driver"){
            {
                this.requirements(Category.units, ItemStack.with(Items.phaseFabric, 20, Items.tungsten, 200, Items.silicon, 200, Items.graphite, 100, Items.oxide, 30));
                this.regionSuffix = "-dark";
                this.size = 5;
                this.reload = 130.0f;
                this.chargeTime = 100.0f;
                this.range = 2100.0f;
                this.maxPayloadSize = 4.0f;
                this.consumePower(3.0f);
            }
        };
        smallDeconstructor = new PayloadDeconstructor("small-deconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.beryllium, 100, Items.silicon, 100, Items.oxide, 40, Items.graphite, 80));
                this.regionSuffix = "-dark";
                this.itemCapacity = 100;
                this.consumePower(1.0f);
                this.size = 3;
                this.deconstructSpeed = 3.0f;
            }
        };
        deconstructor = new PayloadDeconstructor("deconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.beryllium, 250, Items.oxide, 100, Items.silicon, 250, Items.carbide, 50));
                this.regionSuffix = "-dark";
                this.itemCapacity = 250;
                this.consumePower(3.0f);
                this.size = 5;
                this.deconstructSpeed = 6.0f;
            }
        };
        constructor = new Constructor("constructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.silicon, 50, Items.beryllium, 75, Items.tungsten, 40));
                this.regionSuffix = "-dark";
                this.hasPower = true;
                this.buildSpeed = 0.6f;
                this.consumePower(2.5f);
                this.size = 3;
                this.filter = Seq.with(tungstenWallLarge, berylliumWallLarge, carbideWallLarge, reinforcedSurgeWallLarge, reinforcedLiquidContainer, reinforcedContainer, beamNode);
            }
        };
        largeConstructor = new Constructor("large-constructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.silicon, 150, Items.oxide, 100, Items.tungsten, 200, Items.thorium, 80));
                this.regionSuffix = "-dark";
                this.hasPower = true;
                this.buildSpeed = 0.75f;
                this.maxBlockSize = 4;
                this.minBlockSize = 3;
                this.size = 5;
                this.consumePower(3.0f);
            }
        };
        payloadLoader = new PayloadLoader("payload-loader"){
            {
                this.requirements(Category.units, ItemStack.with(Items.graphite, 80, Items.silicon, 160, Items.tungsten, 90));
                this.regionSuffix = "-dark";
                this.hasPower = true;
                this.consumePower(2.0f);
                this.size = 3;
                this.fogRadius = 5;
            }
        };
        payloadUnloader = new PayloadUnloader("payload-unloader"){
            {
                this.requirements(Category.units, ItemStack.with(Items.graphite, 140, Items.silicon, 220, Items.tungsten, 180));
                this.regionSuffix = "-dark";
                this.hasPower = true;
                this.consumePower(2.0f);
                this.size = 3;
                this.fogRadius = 5;
            }
        };
        powerSource = new PowerSource("power-source"){
            {
                this.requirements(Category.power, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.powerProduction = 16666.666f;
                this.alwaysUnlocked = true;
            }
        };
        powerVoid = new PowerVoid("power-void"){
            {
                this.requirements(Category.power, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        itemSource = new ItemSource("item-source"){
            {
                this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        itemVoid = new ItemVoid("item-void"){
            {
                this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        liquidSource = new LiquidSource("liquid-source"){
            {
                this.requirements(Category.liquid, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
                this.floating = true;
            }
        };
        liquidVoid = new LiquidVoid("liquid-void"){
            {
                this.requirements(Category.liquid, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
                this.floating = true;
            }
        };
        payloadSource = new PayloadSource("payload-source"){
            {
                this.requirements(Category.units, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.size = 5;
                this.alwaysUnlocked = true;
            }
        };
        payloadVoid = new PayloadVoid("payload-void"){
            {
                this.requirements(Category.units, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.size = 5;
                this.alwaysUnlocked = true;
            }
        };
        heatSource = new HeatProducer("heat-source"){
            {
                this.requirements(Category.crafting, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput());
                this.rotateDraw = false;
                this.size = 1;
                this.heatOutput = 1000.0f;
                this.warmupRate = 1000.0f;
                this.regionRotated1 = 1;
                this.itemCapacity = 0;
                this.alwaysUnlocked = true;
                this.ambientSound = Sounds.none;
                this.allDatabaseTabs = true;
            }
        };
        illuminator = new LightBlock("illuminator"){
            {
                this.requirements(Category.effect, BuildVisibility.lightingOnly, ItemStack.with(Items.graphite, 12, Items.silicon, 8, Items.lead, 8));
                this.brightness = 0.75f;
                this.radius = 140.0f;
                this.consumePower(0.05f);
            }
        };
        new LegacyMechPad("legacy-mech-pad");
        new LegacyUnitFactory("legacy-unit-factory");
        new LegacyUnitFactory("legacy-unit-factory-air"){
            {
                this.replacement = airFactory;
            }
        };
        new LegacyUnitFactory("legacy-unit-factory-ground"){
            {
                this.replacement = groundFactory;
            }
        };
        new LegacyCommandCenter("command-center"){
            {
                this.size = 2;
            }
        };
        launchPad = new LaunchPad("launch-pad"){
            {
                this.requirements(Category.effect, BuildVisibility.legacyLaunchPadOnly, ItemStack.with(Items.copper, 350, Items.silicon, 140, Items.lead, 200, Items.titanium, 150));
                this.size = 3;
                this.itemCapacity = 100;
                this.launchTime = 1200.0f;
                this.hasPower = true;
                this.acceptMultipleItems = true;
                this.consumePower(4.0f);
            }
        };
        advancedLaunchPad = new LaunchPad("advanced-launch-pad"){
            {
                this.requirements(Category.effect, BuildVisibility.notLegacyLaunchPadOnly, ItemStack.with(Items.copper, 350, Items.silicon, 250, Items.lead, 300, Items.titanium, 200));
                this.size = 4;
                this.itemCapacity = 100;
                this.launchTime = 1800.0f;
                this.liquidCapacity = 40.0f;
                this.hasPower = true;
                this.drawLiquid = Liquids.oil;
                this.consumeLiquid(Liquids.oil, 0.15f);
                this.consumePower(8.0f);
            }
        };
        landingPad = new LandingPad("landing-pad"){
            {
                this.requirements(Category.effect, BuildVisibility.notLegacyLaunchPadOnly, ItemStack.with(Items.copper, 200, Items.graphite, 100, Items.titanium, 100));
                this.size = 4;
                this.itemCapacity = 100;
                this.coolingEffect = new RadialEffect(Fx.steamCoolSmoke, 4, 90.0f, 9.5f, 180.0f);
                this.liquidCapacity = 3000.0f;
                this.consumeLiquidAmount = 1500.0f;
            }
        };
        interplanetaryAccelerator = new Accelerator("interplanetary-accelerator"){
            {
                this.requirements(Category.effect, BuildVisibility.campaignOnly, ItemStack.with(Items.copper, 16000, Items.silicon, 11000, Items.thorium, 13000, Items.titanium, 12000, Items.surgeAlloy, 6000, Items.phaseFabric, 5000));
                this.researchCostMultiplier = 0.1f;
                this.powerBufferRequirement = 1000000.0f;
                this.size = 7;
                this.hasPower = true;
                this.consumePower(10.0f);
                this.buildCostMultiplier = 0.5f;
                this.scaledHealth = 80.0f;
            }
        };
        message = new MessageBlock("message"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 5, Items.copper, 5));
            }
        };
        switchBlock = new SwitchBlock("switch"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 5, Items.copper, 5));
            }
        };
        microProcessor = new LogicBlock("micro-processor"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.copper, 90, Items.lead, 50, Items.silicon, 50));
                this.instructionsPerTick = 2;
                this.size = 1;
            }
        };
        logicProcessor = new LogicBlock("logic-processor"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 320, Items.silicon, 80, Items.graphite, 60, Items.thorium, 50));
                this.instructionsPerTick = 8;
                this.range = 176.0f;
                this.size = 2;
            }
        };
        hyperProcessor = new LogicBlock("hyper-processor"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 450, Items.silicon, 150, Items.thorium, 75, Items.surgeAlloy, 50));
                this.consumeLiquid(Liquids.cryofluid, 0.08f);
                this.hasLiquids = true;
                this.instructionsPerTick = 25;
                this.range = 336.0f;
                this.size = 3;
            }
        };
        memoryCell = new MemoryBlock("memory-cell"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 30, Items.silicon, 30, Items.copper, 30));
                this.memoryCapacity = 64;
            }
        };
        memoryBank = new MemoryBlock("memory-bank"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 80, Items.silicon, 80, Items.phaseFabric, 30, Items.copper, 30));
                this.memoryCapacity = 512;
                this.size = 2;
            }
        };
        logicDisplay = new LogicDisplay("logic-display"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 100, Items.silicon, 50, Items.metaglass, 50));
                this.displaySize = 80;
                this.size = 3;
            }
        };
        largeLogicDisplay = new LogicDisplay("large-logic-display"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 200, Items.silicon, 150, Items.metaglass, 100, Items.phaseFabric, 75));
                this.displaySize = 176;
                this.size = 6;
            }
        };
        tileLogicDisplay = new TileableLogicDisplay("tile-logic-display"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 8, Items.silicon, 8, Items.metaglass, 8, Items.phaseFabric, 3));
            }
        };
        canvas = new CanvasBlock("canvas"){
            {
                this.requirements(Category.logic, BuildVisibility.shown, ItemStack.with(Items.silicon, 10, Items.beryllium, 10));
                this.canvasSize = 12;
                this.padding = 3.5f;
                this.size = 2;
            }
        };
        reinforcedMessage = new MessageBlock("reinforced-message"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 10, Items.beryllium, 5));
                this.health = 100;
            }
        };
        worldProcessor = new LogicBlock("world-processor"){
            {
                this.requirements(Category.logic, BuildVisibility.worldProcessorOnly, ItemStack.with(new Object[0]));
                this.canOverdrive = false;
                this.targetable = false;
                this.instructionsPerTick = 8;
                this.forceDark = true;
                this.privileged = true;
                this.size = 1;
                this.maxInstructionsPerTick = 1000;
                this.range = Float.MAX_VALUE;
            }
        };
        worldCell = new MemoryBlock("world-cell"){
            {
                this.requirements(Category.logic, BuildVisibility.worldProcessorOnly, ItemStack.with(new Object[0]));
                this.targetable = false;
                this.privileged = true;
                this.memoryCapacity = 512;
                this.forceDark = true;
            }
        };
        worldMessage = new MessageBlock("world-message"){
            {
                this.requirements(Category.logic, BuildVisibility.worldProcessorOnly, ItemStack.with(new Object[0]));
                this.targetable = false;
                this.privileged = true;
            }
        };
        worldSwitch = new SwitchBlock("world-switch"){
            {
                this.requirements(Category.logic, BuildVisibility.worldProcessorOnly, ItemStack.with(new Object[0]));
                this.targetable = false;
                this.privileged = true;
            }
        };
    }
}

