/*
 * Decompiled with CFR 0.152.
 */
package mindustry.audio;

import arc.Core;
import arc.audio.Sound;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.gen.Sounds;

public class SoundPriority {
    static int lastGroup = 1;

    public static void init() {
        Sounds.coreLaunch.setBus(Vars.control.sound.uiBus);
        SoundPriority.max(7, Sounds.beamPlasma, Sounds.shootMeltdown, Sounds.beamMeltdown);
        SoundPriority.set(3.0f, Sounds.acceleratorLaunch, Sounds.acceleratorCharge, Sounds.coreLand, Sounds.coreLaunch);
        SoundPriority.set(2.0f, Sounds.beamMeltdown, Sounds.beamLustre, Sounds.beamPlasma, Sounds.explosionReactor, Sounds.explosionReactor2, Sounds.explosionReactorNeoplasm, Sounds.explosionCore, Sounds.blockExplodeElectricBig, Sounds.blockExplodeExplosive, Sounds.blockExplodeExplosiveAlt);
        SoundPriority.set(1.5f, Sounds.shootMeltdown, Sounds.shootSublimate, Sounds.shootForeshadow, Sounds.shootConquer, Sounds.shootCorvus, Sounds.chargeCorvus, Sounds.chargeVela, Sounds.chargeLancer, Sounds.shootReign, Sounds.shootEclipse, Sounds.shootArtillerySapBig, Sounds.shootToxopidShotgun, Sounds.beamPlasmaSmall, Sounds.shootNavanax, Sounds.explosionNavanax);
        SoundPriority.set(1.0f, Sounds.loopConveyor, Sounds.loopSmelter, Sounds.loopDrill, Sounds.loopExtract, Sounds.loopFlux, Sounds.loopHum, Sounds.loopBio, Sounds.loopTech, Sounds.loopUnitBuilding);
        Sounds.shootLancer.setMaxConcurrent(5);
        SoundPriority.sameGroup(Sounds.shootFlame, Sounds.shootFlamePlasma);
        SoundPriority.sameGroup(Sounds.shootMissile, Sounds.shootMissileShort, Sounds.shootMissilePlasmaShort);
        SoundPriority.sameGroup(Sounds.shootArc, Sounds.shootPulsar);
        for (Sound sound : Core.assets.getAll(Sound.class, new Seq())) {
            sound.setMinConcurrentInterrupt(Math.min(0.25f, sound.getLength() * 0.5f));
        }
        Sounds.mechStepSmall.setMinConcurrentInterrupt(0.5f);
        Sounds.mechStep.setMinConcurrentInterrupt(0.5f);
        Sounds.walkerStep.setMinConcurrentInterrupt(0.6f);
        Sounds.mechStepHeavy.setMinConcurrentInterrupt(0.6f);
        Sounds.shieldHit.setMaxConcurrent(4);
        SoundPriority.max(5, Sounds.mechStep, Sounds.mechStepHeavy, Sounds.walkerStep, Sounds.walkerStepSmall, Sounds.walkerStepTiny);
        SoundPriority.set(-1.0f, Sounds.blockHeal, Sounds.healWave);
        SoundPriority.set(-2.0f, Sounds.mechStep, Sounds.mechStepHeavy, Sounds.walkerStep, Sounds.walkerStepSmall, Sounds.walkerStepTiny, Sounds.mechStepSmall);
        Sounds.explosionCore.setFalloffOffset(100.0f);
        Sounds.blockExplodeElectricBig.setFalloffOffset(70.0f);
    }

    static void max(int max, Sound ... sounds) {
        for (Sound s : sounds) {
            s.setMaxConcurrent(max);
        }
    }

    static void sameGroup(Sound ... sounds) {
        int id = lastGroup++;
        for (Sound s : sounds) {
            s.setConcurrentGroup(id);
        }
    }

    static void set(float value, Sound ... sounds) {
        for (Sound s : sounds) {
            s.setPriority(value);
        }
    }
}

