/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.Sized;
import mindustry.entities.units.AIController;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Teamc;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class HugAI
extends AIController {
    @Override
    public void updateMovement() {
        Tile spawner;
        CoreBlock.CoreBuild core = this.unit.closestEnemyCore();
        if (core != null && this.unit.within(core, this.unit.range() / 1.1f + (float)(core.block.size * 8) / 2.0f)) {
            this.target = core;
            for (WeaponMount mount : this.unit.mounts) {
                if (!mount.weapon.controllable || !mount.weapon.bullet.collidesGround) continue;
                mount.target = core;
            }
        }
        boolean move = true;
        if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam && (spawner = this.getClosestSpawner()) != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
            move = false;
        }
        if (this.target != null && this.unit.within(this.target, this.unit.type.range) && !World.raycast(this.unit.tileX(), this.unit.tileY(), this.target.tileX(), this.target.tileY(), (x, y) -> {
            for (Point2 p : Geometry.d4c) {
                if (this.unit.canPass(x + p.x, y + p.y)) continue;
                return true;
            }
            return false;
        })) {
            float f;
            float f2 = this.unit.hitSize;
            Teamc teamc = this.target;
            if (teamc instanceof Sized) {
                Sized s = (Sized)((Object)teamc);
                f = s.hitSize();
            } else {
                f = 1.0f;
            }
            if (this.unit.within(this.target, (f2 + f) * 0.5f)) {
                this.unit.movePref(vec.set(this.target).sub(this.unit).rotate(90.0f).setLength(this.unit.speed()));
            } else {
                this.unit.movePref(vec.set(this.target).sub(this.unit).limit(this.unit.speed()));
            }
        } else if (move) {
            this.pathfind(0);
        }
        if (this.unit.type.canBoost && this.unit.elevation > 0.001f && !this.unit.onSolid()) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, 0.0f, this.unit.type.descentSpeed);
        }
        this.faceTarget();
    }
}

