/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class GroundAI
extends AIController {
    float stuckTime = 0.0f;
    float stuckX = -999.0f;
    float stuckY = -999.0f;
    static final float stuckRange = 12.0f;

    @Override
    public void updateMovement() {
        float stuckThreshold = Math.max(1.0f, 24.0f / this.unit.type.speed);
        CoreBlock.CoreBuild core = this.unit.closestEnemyCore();
        boolean moved = false;
        if (core != null && this.unit.within(core, this.unit.range() / 1.3f + (float)(core.block.size * 8) / 2.0f)) {
            this.target = core;
            for (WeaponMount mount : this.unit.mounts) {
                if (!mount.weapon.controllable || !mount.weapon.bullet.collidesGround) continue;
                mount.target = core;
            }
        }
        if (core == null || !this.unit.within(core, this.unit.type.range * 0.5f)) {
            boolean move = true;
            if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
                Tile spawner = this.getClosestSpawner();
                if (spawner != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
                    move = false;
                }
                if (spawner == null && core == null) {
                    move = false;
                }
            }
            if (!(core != null || Vars.state.rules.waves && this.getClosestSpawner() != null)) {
                move = false;
            }
            moved = move;
            if (move) {
                this.pathfind(0, true, this.stuckTime >= stuckThreshold);
            }
        }
        if (this.unit.type.canBoost && this.unit.elevation > 0.001f && !this.unit.onSolid()) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, 0.0f, this.unit.type.descentSpeed);
        }
        this.faceTarget();
        if (moved) {
            if (this.unit.within(this.stuckX, this.stuckY, 12.0f)) {
                this.stuckTime += Time.delta;
                if (this.stuckTime - Time.delta < stuckThreshold && this.stuckTime >= stuckThreshold) {
                    float radius = this.unit.hitSize * 0.6f * 2.0f;
                    Units.nearby(this.unit.team, this.unit.x, this.unit.y, radius, other -> {
                        UnitController patt2454$temp;
                        if (other != this.unit && (patt2454$temp = other.controller()) instanceof GroundAI) {
                            GroundAI ai = (GroundAI)patt2454$temp;
                            if (other.within(this.unit.x, this.unit.y, radius + other.hitSize * 0.6f)) {
                                ai.stuckX = other.x;
                                ai.stuckY = other.y;
                                ai.stuckTime = Math.max(1.0f, 24.0f / other.type.speed) + 1.0f;
                            }
                        }
                    });
                }
            } else {
                this.stuckX = this.unit.x;
                this.stuckY = this.unit.y;
                this.stuckTime = 0.0f;
            }
        } else {
            this.stuckTime = 0.0f;
        }
    }
}

