/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.func.Boolf;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Bits;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.ControlPathfinder;
import mindustry.ai.ItemUnitStance;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitGroup;
import mindustry.ai.UnitStance;
import mindustry.core.World;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitController;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.meta.BuildVisibility;

public class CommandAI
extends AIController {
    protected static final int maxCommandQueueSize = 50;
    protected static final int avoidInterval = 10;
    protected static final Vec2 vecOut = new Vec2();
    protected static final Vec2 vecMovePos = new Vec2();
    protected static final boolean[] noFound = new boolean[]{false};
    protected static final UnitPayload tmpPayload = new UnitPayload(null);
    protected static final int transferStateNone = 0;
    protected static final int transferStateLoad = 1;
    protected static final int transferStateUnload = 2;
    public Seq<Position> commandQueue = new Seq(5);
    @Nullable
    public Vec2 targetPos;
    @Nullable
    public Teamc attackTarget;
    @Nullable
    public UnitGroup group;
    public int groupIndex = 0;
    public IntSeq unreachableBuildings = new IntSeq(8);
    public int readAttackTarget = -1;
    protected boolean stopAtTarget;
    protected boolean stopWhenInRange;
    protected Vec2 lastTargetPos;
    protected boolean blockingUnit;
    protected float timeSpentBlocked;
    protected float payloadPickupCooldown;
    protected int transferState = 0;
    public UnitCommand command;
    public Bits stances;
    @Nullable
    protected AIController commandController;
    @Nullable
    protected UnitCommand lastCommand;

    public CommandAI() {
        this.stances = new Bits(Vars.content.unitStances().size);
    }

    public UnitCommand currentCommand() {
        return this.command == null ? UnitCommand.moveCommand : this.command;
    }

    public void command(UnitCommand command) {
        if (this.unit.type.commands.contains(command)) {
            this.unit.mineTile = null;
            this.unit.clearBuilding();
            this.command = command;
        }
    }

    public boolean hasStance(@Nullable UnitStance stance) {
        return stance != null && this.stances.get(stance.id);
    }

    public void setStance(UnitStance stance, boolean enabled) {
        if (enabled) {
            this.setStance(stance);
        } else {
            this.disableStance(stance);
        }
    }

    public void setStance(UnitStance stance) {
        if (stance == UnitStance.stop) {
            return;
        }
        this.stances.andNot(stance.incompatibleBits);
        this.stances.set(stance.id);
        this.stanceChanged();
    }

    public void disableStance(UnitStance stance) {
        this.stances.clear(stance.id);
        this.stanceChanged();
    }

    @Override
    public void stanceChanged() {
        if (this.commandController != null && !(this.commandController instanceof CommandAI)) {
            this.commandController.stanceChanged();
        }
    }

    @Override
    public void init() {
        if (this.command == null) {
            UnitCommand unitCommand = this.command = this.unit.type.defaultCommand == null && this.unit.type.commands.size > 0 ? this.unit.type.commands.first() : this.unit.type.defaultCommand;
            if (this.command == null) {
                this.command = UnitCommand.moveCommand;
            }
        }
    }

    @Override
    public boolean isLogicControllable() {
        return !this.hasCommand();
    }

    public boolean isAttacking() {
        return this.target != null && this.unit.within(this.target, this.unit.range() + 10.0f);
    }

    @Override
    public void updateUnit() {
        UnitCommand curCommand;
        if (this.command == UnitCommand.mineCommand && !this.hasStance(UnitStance.mineAuto) && !ItemUnitStance.all().contains((ItemUnitStance)((Object)((Boolf<ItemUnitStance>)this::hasStance)))) {
            this.setStance(UnitStance.mineAuto);
        }
        if (this.hasStance(UnitStance.pursueTarget) && !this.hasStance(UnitStance.patrol) && this.target != null && this.attackTarget == null && this.targetPos == null) {
            this.commandTarget(this.target, false);
        }
        if (this.hasStance(UnitStance.patrol) && this.hasStance(UnitStance.pursueTarget) && this.target != null && this.attackTarget == null) {
            if (this.targetPos != null) {
                this.commandQueue.add(this.targetPos.cpy());
            }
            this.commandTarget(this.target, false);
        }
        if (this.commandQueue.any()) {
            this.commandQueue.removeAll(e -> {
                Healthc h;
                return e instanceof Healthc && !(h = (Healthc)e).isValid();
            });
        }
        if (this.command == null && this.unit.type.commands.size > 0) {
            UnitCommand unitCommand = this.command = this.unit.type.defaultCommand == null ? this.unit.type.commands.first() : this.unit.type.defaultCommand;
        }
        if (this.lastCommand != (curCommand = this.command)) {
            this.lastCommand = curCommand;
            AIController aIController = this.commandController = curCommand == null ? null : curCommand.controller.get(this.unit);
        }
        if (this.commandController != null) {
            if (this.commandController.unit() != this.unit) {
                this.commandController.unit(this.unit);
            }
            this.commandController.updateUnit();
        } else {
            this.defaultBehavior();
            this.unit.updateBoosting(false);
        }
    }

    public void clearCommands() {
        this.commandQueue.clear();
        this.targetPos = null;
        this.attackTarget = null;
    }

    void tryPickupUnit(Payloadc pay) {
        Unit target = Units.closest(this.unit.team, this.unit.x, this.unit.y, this.unit.type.hitSize * 2.0f, u -> u.isAI() && u != this.unit && u.isGrounded() && pay.canPickup((Unit)u) && u.within(this.unit, u.hitSize + this.unit.hitSize));
        if (target != null) {
            Call.pickedUnitPayload(this.unit, target);
        }
    }

    @Override
    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        if (!this.unit.type.autoFindTarget && this.targetPos != null && !this.nearAttackTarget(this.unit.x, this.unit.y, this.unit.range())) {
            return null;
        }
        return super.findMainTarget(x, y, range, air, ground);
    }

    public void defaultBehavior() {
        boolean withinAttackRange;
        Position current;
        Building build;
        Unit unit;
        if (!Vars.net.client() && (unit = this.unit) instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            this.payloadPickupCooldown -= Time.delta;
            if (this.command == UnitCommand.unloadPayloadCommand && pay.hasPayload()) {
                Call.payloadDropped(this.unit, this.unit.x, this.unit.y);
            }
            if (this.command == UnitCommand.loadUnitsCommand) {
                this.tryPickupUnit(pay);
            }
            if (this.command == UnitCommand.loadBlocksCommand && (this.targetPos == null || this.unit.within(this.targetPos, 1.0f)) && (build = Vars.world.buildWorld(this.unit.x, this.unit.y)) != null && Vars.state.teams.canInteract(this.unit.team, build.team)) {
                current = build.getPayload();
                if (current != null && pay.canPickupPayload((Payload)current)) {
                    Call.pickedBuildPayload(this.unit, build, false);
                } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                    Call.pickedBuildPayload(this.unit, build, true);
                }
            }
        }
        if (!Vars.net.client() && this.command == UnitCommand.enterPayloadCommand && this.unit.buildOn() != null && (this.targetPos == null || Vars.world.buildWorld(this.targetPos.x, this.targetPos.y) != null && Vars.world.buildWorld(this.targetPos.x, this.targetPos.y) == this.unit.buildOn())) {
            Building build2 = this.unit.buildOn();
            CommandAI.tmpPayload.unit = this.unit;
            if (build2.team == this.unit.team && build2.acceptPayload(build2, tmpPayload)) {
                Call.unitEnteredPayload(this.unit, build2);
                return;
            }
        }
        this.updateVisuals();
        this.updateTargeting();
        if (this.attackTarget != null && this.invalid(this.attackTarget)) {
            this.attackTarget = null;
            this.targetPos = null;
        }
        if (this.attackTarget == null && this.targetPos == null) {
            this.finishPath();
        }
        boolean ramming = this.hasStance(UnitStance.ram);
        if (this.attackTarget != null) {
            if (this.targetPos == null) {
                this.lastTargetPos = this.targetPos = new Vec2();
            }
            this.targetPos.set(this.attackTarget);
            if (this.unit.isGrounded() && (current = this.attackTarget) instanceof Building) {
                Tile best;
                build = (Building)current;
                if (build.tile.solid() && this.unit.type.pathCostId != 2 && !ramming && (best = build.findClosestEdge(this.unit, Tile::solid)) != null) {
                    this.targetPos.set(best);
                }
            }
        }
        boolean alwaysArrive = false;
        float engageRange = this.unit.type.range - 10.0f;
        boolean bl = withinAttackRange = this.attackTarget != null && this.unit.within(this.attackTarget, engageRange) && !ramming;
        if (this.targetPos != null) {
            boolean move = true;
            boolean isFinalPoint = this.commandQueue.size == 0;
            vecOut.set(this.targetPos);
            vecMovePos.set(this.targetPos);
            if (this.group != null && this.group.valid && this.groupIndex < this.group.units.size && this.command != UnitCommand.enterPayloadCommand) {
                vecMovePos.add(this.group.positions[this.groupIndex * 2], this.group.positions[this.groupIndex * 2 + 1]);
            }
            Building targetBuild = Vars.world.buildWorld(this.targetPos.x, this.targetPos.y);
            if (this.hasStance(UnitStance.patrol) && !this.hasStance(UnitStance.pursueTarget) && this.target != null && this.unit.within(this.target, this.unit.type.range - 2.0f) && !this.unit.type.circleTarget || this.command == UnitCommand.enterPayloadCommand && this.unit.within(this.targetPos, 4.0f) || targetBuild != null && this.unit.within(targetBuild, (float)(targetBuild.block.size * 8) / 2.0f * 0.9f) || this.command == UnitCommand.loopPayloadCommand && this.unit.within(vecMovePos, 10.0f)) {
                move = false;
            }
            if (this.unit.isGrounded() && !ramming) {
                if (this.timer.get(2, 10.0f)) {
                    Vec2 dstPos = Tmp.v1.trns(this.unit.rotation, this.unit.hitSize / 2.0f);
                    float max = this.unit.hitSize / 2.0f;
                    float radius = Math.max(7.0f, max);
                    float margin = 4.0f;
                    this.blockingUnit = Units.nearbyCheck(this.unit.x + dstPos.x - radius / 2.0f, this.unit.y + dstPos.y - radius / 2.0f, radius, radius, u -> {
                        if (u == this.unit) return false;
                        if (!u.within(this.unit, u.hitSize / 2.0f + this.unit.hitSize / 2.0f + margin)) return false;
                        UnitController patt11550$temp = u.controller();
                        if (!(patt11550$temp instanceof CommandAI)) return false;
                        CommandAI ai = (CommandAI)patt11550$temp;
                        if (ai.targetPos == null) return false;
                        if (!ai.targetPos.equals(this.targetPos)) return false;
                        if (!(u.dst2(this.targetPos) < this.unit.dst2(this.targetPos))) return false;
                        if (Angles.within(this.unit.rotation, u.rotation, 15.0f)) return false;
                        if (!ControlPathfinder.isNearObstacle(this.unit, this.unit.tileX(), this.unit.tileY(), u.tileX(), u.tileY())) return false;
                        return true;
                    });
                }
                float maxBlockTime = 300.0f;
                if (this.blockingUnit) {
                    this.timeSpentBlocked += Time.delta;
                    if (this.timeSpentBlocked >= maxBlockTime * 2.0f) {
                        this.timeSpentBlocked = 0.0f;
                    }
                } else {
                    this.timeSpentBlocked = 0.0f;
                }
                if (withinAttackRange) {
                    move = true;
                    CommandAI.noFound[0] = false;
                    vecOut.set(vecMovePos);
                } else {
                    move &= Vars.controlPath.getPathPosition(this.unit, vecMovePos, this.targetPos, vecOut, noFound) && (!this.blockingUnit || this.timeSpentBlocked > maxBlockTime);
                }
                alwaysArrive = vecOut.epsilonEquals(this.unit.tileX() * 8, (float)(this.unit.tileY() * 8));
                isFinalPoint &= vecMovePos.epsilonEquals(vecOut, 4.1f);
                if (this.unit.team.isAI() && (noFound[0] || this.unit.isPathImpassable(World.toTile(CommandAI.vecMovePos.x), World.toTile(CommandAI.vecMovePos.y)))) {
                    Teamc teamc = this.attackTarget;
                    if (teamc instanceof Building) {
                        Building build3 = (Building)teamc;
                        this.unreachableBuildings.addUnique(build3.pos());
                    }
                    this.attackTarget = null;
                    this.finishPath();
                    return;
                }
            } else {
                vecOut.set(vecMovePos);
            }
            if (this.command == UnitCommand.loopPayloadCommand) {
                alwaysArrive = true;
            }
            if (move) {
                if (this.unit.type.circleTarget && this.attackTarget != null) {
                    this.target = this.attackTarget;
                    this.circleAttack(this.unit.type.circleTargetRadius);
                } else {
                    this.moveTo(vecOut, withinAttackRange ? engageRange : (this.unit.isGrounded() ? 0.0f : (this.attackTarget != null && !ramming ? engageRange : 0.0f)), this.unit.isFlying() ? 40.0f : 100.0f, false, null, isFinalPoint || alwaysArrive);
                }
            }
            if (this.attackTarget != null && this.stopAtTarget && this.unit.within(this.attackTarget, engageRange - 1.0f)) {
                this.attackTarget = null;
            }
            if (!(!this.unit.isFlying() || !move || this.unit.type.circleTarget && !this.unit.type.omniMovement || this.attackTarget != null && this.unit.within(this.attackTarget, this.unit.type.range))) {
                this.unit.lookAt(vecMovePos);
            } else {
                this.faceTarget();
            }
            if (this.attackTarget == null && this.unit.within(vecMovePos, this.command.exactArrival && this.commandQueue.size == 0 ? 1.0f : Math.max(5.0f, this.unit.hitSize / 2.0f))) {
                this.finishPath();
            }
            if (this.stopWhenInRange && this.targetPos != null && this.unit.within(vecMovePos, engageRange * 0.9f)) {
                this.finishPath();
                this.stopWhenInRange = false;
            }
        } else if (this.target != null) {
            if (this.unit.type.circleTarget && this.shouldFire()) {
                this.circleAttack(this.unit.type.circleTargetRadius);
            } else {
                this.faceTarget();
            }
        }
    }

    void finishPath() {
        Unit unit;
        if (this.command == UnitCommand.enterPayloadCommand && this.commandQueue.size == 0 && this.targetPos != null && Vars.world.buildWorld(this.targetPos.x, this.targetPos.y) != null && Vars.world.buildWorld((float)this.targetPos.x, (float)this.targetPos.y).block.acceptsUnitPayloads) {
            return;
        }
        if (!Vars.net.client() && this.command == UnitCommand.loopPayloadCommand && (unit = this.unit) instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            if (this.transferState == 0) {
                int n = this.transferState = pay.hasPayload() ? 2 : 1;
            }
            if (this.payloadPickupCooldown > 0.0f) {
                return;
            }
            if (this.transferState == 2) {
                int prev = -1;
                while (pay.hasPayload() && prev != pay.payloads().size) {
                    prev = pay.payloads().size;
                    Call.payloadDropped(this.unit, this.unit.x, this.unit.y);
                }
                if (pay.hasPayload()) {
                    return;
                }
                this.payloadPickupCooldown = 60.0f;
            } else if (this.transferState == 1) {
                int prev = -1;
                while (prev != pay.payloads().size) {
                    prev = pay.payloads().size;
                    this.tryPickupUnit(pay);
                }
                if (!pay.hasPayload()) {
                    return;
                }
                this.payloadPickupCooldown = 60.0f;
            }
            if (this.commandQueue.size == 0) {
                return;
            }
        }
        this.transferState = 0;
        Vec2 prev = this.targetPos;
        this.targetPos = null;
        if (this.commandQueue.size > 0) {
            Position next = this.commandQueue.remove(0);
            if (next instanceof Teamc) {
                Teamc target = (Teamc)next;
                this.commandTarget(target, this.stopAtTarget);
            } else if (next instanceof Vec2) {
                Vec2 position = (Vec2)next;
                this.commandPosition(position);
            }
            if (prev != null && (this.hasStance(UnitStance.patrol) || this.command == UnitCommand.loopPayloadCommand)) {
                this.commandQueue.add(prev.cpy());
            }
            if (this.group != null) {
                Vec2 position;
                this.group.updateRaycast(this.groupIndex, next instanceof Vec2 ? (position = (Vec2)next) : Tmp.v3.set(next));
            }
        } else if (this.group != null) {
            this.group = null;
        }
    }

    @Override
    public void removed(Unit unit) {
        this.clearCommands();
    }

    public void commandQueue(Position location) {
        if (this.targetPos == null && this.attackTarget == null) {
            if (location instanceof Teamc) {
                Teamc t = (Teamc)location;
                this.commandTarget(t, this.stopAtTarget);
            } else if (location instanceof Vec2) {
                Vec2 position = (Vec2)location;
                this.commandPosition(position);
            }
        } else if (this.commandQueue.size < 50 && !this.commandQueue.contains(location)) {
            this.commandQueue.add(location);
        }
    }

    @Override
    public void afterRead(Unit unit) {
        if (this.readAttackTarget != -1) {
            this.attackTarget = Groups.unit.getByID(this.readAttackTarget);
            this.readAttackTarget = -1;
        }
    }

    @Override
    public boolean shouldFire() {
        return !this.hasStance(UnitStance.holdFire);
    }

    @Override
    public void hit(Bullet bullet) {
        Unit u;
        Teamc teamc;
        Entityc entityc;
        if (this.unit.team.isAI() && (entityc = bullet.owner) instanceof Teamc && (teamc = (Teamc)entityc).team() != this.unit.team && this.attackTarget == null && (!(teamc instanceof Unit) || (u = (Unit)teamc).checkTarget(this.unit.type.targetAir, this.unit.type.targetGround)) && this.timer.get(3, 600.0f)) {
            this.commandTarget(teamc, true);
        }
    }

    @Override
    public boolean keepState() {
        return true;
    }

    @Override
    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        return !this.nearAttackTarget(x, y, range) ? super.findTarget(x, y, range, air, ground) : (Units.isHittable(this.attackTarget, air, ground) ? this.attackTarget : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean nearAttackTarget(float x, float y, float range) {
        float f;
        if (this.attackTarget == null) return false;
        Teamc teamc = this.attackTarget;
        if (teamc instanceof Sized) {
            Sized s = (Sized)((Object)teamc);
            f = s.hitSize() / 2.0f;
        } else {
            f = 0.0f;
        }
        if (!this.attackTarget.within(x, y, range + 3.0f + f)) return false;
        return true;
    }

    @Override
    public boolean retarget() {
        return this.timer.get(0, this.attackTarget != null ? 10.0f : 20.0f);
    }

    public boolean hasCommand() {
        return this.targetPos != null;
    }

    public void setupLastPos() {
        this.lastTargetPos = this.targetPos;
    }

    @Override
    public void commandPosition(Vec2 pos) {
        if (pos == null) {
            return;
        }
        this.commandPosition(pos, false);
        if (this.commandController != null) {
            this.commandController.commandPosition(pos);
        }
    }

    public void commandPosition(Vec2 pos, boolean stopWhenInRange) {
        Building build;
        if (pos == null) {
            return;
        }
        this.targetPos = this.lastTargetPos = pos.cpy();
        if (this.command != null && this.command.snapToBuilding && (build = Vars.world.buildWorld(this.targetPos.x, this.targetPos.y)) != null && build.team == this.unit.team) {
            this.targetPos.set(build);
        }
        this.attackTarget = null;
        this.stopWhenInRange = stopWhenInRange;
    }

    @Override
    public void commandTarget(Teamc moveTo) {
        this.commandTarget(moveTo, false);
        if (this.commandController != null) {
            this.commandController.commandTarget(moveTo);
        }
    }

    public void commandTarget(Teamc moveTo, boolean stopAtTarget) {
        this.attackTarget = moveTo;
        this.stopAtTarget = stopAtTarget;
    }
}

