/*
 * Decompiled with CFR 0.152.
 */
package arc.packer;

import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.packer.TexturePacker;
import arc.struct.Seq;
import arc.util.Structs;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;

public class ImageProcessor {
    private static final Pixmap emptyImage = new Pixmap(1, 1);
    private final TexturePacker.Settings settings;
    private final HashMap<String, TexturePacker.Rect> crcs = new HashMap();
    private final Seq<TexturePacker.Rect> rects = new Seq();
    private float scale = 1.0f;
    private boolean resampling;

    public ImageProcessor(TexturePacker.Settings settings) {
        this.settings = settings;
    }

    public void addImage(File file, String rootPath) {
        int dotIndex;
        Pixmap image = new Pixmap(new Fi(file));
        String name = file.getAbsolutePath().replace('\\', '/');
        if (rootPath != null) {
            if (!name.startsWith(rootPath)) {
                throw new RuntimeException("Path '" + name + "' does not start with root: " + rootPath);
            }
            name = name.substring(rootPath.length());
        }
        if ((dotIndex = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, dotIndex);
        }
        this.addImage(image, name);
    }

    public TexturePacker.Rect addImage(Pixmap image, String name) {
        TexturePacker.Rect rect = this.processImage(image, name);
        if (rect == null) {
            if (!this.settings.silent) {
                System.out.println("Ignoring blank input image: " + name);
            }
            return null;
        }
        if (this.settings.alias) {
            String crc = ImageProcessor.hash(rect.getImage(this));
            TexturePacker.Rect existing = this.crcs.get(crc);
            if (existing != null) {
                if (!this.settings.silent && this.settings.printAliases) {
                    System.out.println(rect.name + " (alias of " + existing.name + ")");
                }
                existing.aliases.add(new TexturePacker.Alias(rect));
                return null;
            }
            this.crcs.put(crc, rect);
        }
        this.rects.add(rect);
        return rect;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setResampling(boolean resampling) {
        this.resampling = resampling;
    }

    public Seq<TexturePacker.Rect> getImages() {
        return this.rects;
    }

    public void clear() {
        this.rects.clear();
        this.crcs.clear();
    }

    TexturePacker.Rect processImage(Pixmap image, String name) {
        TexturePacker.Rect rect;
        Pixmap newImage;
        if (this.scale <= 0.0f) {
            throw new IllegalArgumentException("scale cannot be <= 0: " + this.scale);
        }
        int width = image.width;
        int height = image.height;
        boolean isPatch = name.endsWith(".9");
        int[] splits = null;
        int[] pads = null;
        if (isPatch) {
            name = name.substring(0, name.length() - 2);
            splits = this.getSplits(image, name);
            pads = this.getPads(image, name, splits);
            newImage = new Pixmap(width -= 2, height -= 2);
            newImage.draw(image, 1, 1, width + 1, height + 1, 0, 0, width, height);
            image = newImage;
        }
        if (this.scale != 1.0f) {
            width = Math.max(1, Math.round((float)width * this.scale));
            height = Math.max(1, Math.round((float)height * this.scale));
            newImage = new Pixmap(width, height);
            newImage.draw(image, 0, 0, width, height, this.resampling);
            image = newImage;
        }
        if (isPatch) {
            rect = new TexturePacker.Rect(image, 0, 0, width, height, true);
            rect.splits = splits;
            rect.pads = pads;
            rect.canRotate = false;
        } else {
            rect = this.stripWhitespace(image, name);
            if (rect == null) {
                return null;
            }
        }
        rect.name = name;
        return rect;
    }

    private TexturePacker.Rect stripWhitespace(Pixmap source, String name) {
        int x;
        int thresh = this.settings.alphaThreshold;
        if (Structs.contains(this.settings.ignoredWhitespaceStrings, name::contains)) {
            return new TexturePacker.Rect(source, 0, 0, source.width, source.height, false);
        }
        if (this.settings.stripWhitespaceCenter && source.width > 3 && source.height > 3) {
            int cropY;
            int cropX = 0;
            int maxCrop = Math.min(source.width, source.height) / 2 - 1;
            block0: for (cropY = 0; cropY < maxCrop; ++cropY) {
                for (x = 0; x < source.width; ++x) {
                    if (source.getA(x, cropY) > thresh || source.getA(x, source.height - 1 - cropY) > thresh) break block0;
                }
            }
            block2: while (cropX < maxCrop) {
                for (int y = 0; y < source.height; ++y) {
                    if (source.getA(cropX, y) > thresh || source.getA(source.width - 1 - cropX, y) > thresh) break block2;
                }
                ++cropX;
            }
            int realCropX = Math.max(cropX - 1, 0);
            int realCropY = Math.max(cropY - 1, 0);
            if (realCropX > 0 || realCropY > 0) {
                return new TexturePacker.Rect(source, realCropX, realCropY, source.width - realCropX * 2, source.height - realCropY * 2, false);
            }
        }
        if (!this.settings.stripWhitespaceX && !this.settings.stripWhitespaceY) {
            return new TexturePacker.Rect(source, 0, 0, source.width, source.height, false);
        }
        int top = 0;
        int bottom = source.height;
        if (this.settings.stripWhitespaceY) {
            int alpha;
            int y;
            block4: for (y = 0; y < source.height; ++y) {
                for (x = 0; x < source.width; ++x) {
                    alpha = source.getA(x, y);
                    if (alpha > thresh) break block4;
                }
                ++top;
            }
            y = source.height;
            block6: while (--y >= top) {
                for (x = 0; x < source.width; ++x) {
                    alpha = source.getA(x, y);
                    if (alpha > thresh) break block6;
                }
                --bottom;
            }
            if (this.settings.duplicatePadding) {
                if (top > 0) {
                    --top;
                }
                if (bottom < source.height) {
                    ++bottom;
                }
            }
        }
        int left = 0;
        int right = source.width;
        if (this.settings.stripWhitespaceX) {
            int alpha;
            int y;
            int x2;
            block8: for (x2 = 0; x2 < source.width; ++x2) {
                for (y = top; y < bottom; ++y) {
                    alpha = source.getA(x2, y);
                    if (alpha > thresh) break block8;
                }
                ++left;
            }
            x2 = source.width;
            block10: while (--x2 >= left) {
                for (y = top; y < bottom; ++y) {
                    alpha = source.getA(x2, y);
                    if (alpha > thresh) break block10;
                }
                --right;
            }
            if (this.settings.duplicatePadding) {
                if (left > 0) {
                    --left;
                }
                if (right < source.width) {
                    ++right;
                }
            }
        }
        int newWidth = right - left;
        int newHeight = bottom - top;
        if (newWidth <= 0 || newHeight <= 0) {
            if (this.settings.ignoreBlankImages) {
                return null;
            }
            return new TexturePacker.Rect(emptyImage, 0, 0, 1, 1, false);
        }
        return new TexturePacker.Rect(source, left, top, newWidth, newHeight, false);
    }

    private int[] getSplits(Pixmap image, String name) {
        int startX = ImageProcessor.getSplitPoint(image, name, 1, 0, true, true);
        int endX = ImageProcessor.getSplitPoint(image, name, startX, 0, false, true);
        int startY = ImageProcessor.getSplitPoint(image, name, 0, 1, true, false);
        int endY = ImageProcessor.getSplitPoint(image, name, 0, startY, false, false);
        ImageProcessor.getSplitPoint(image, name, endX + 1, 0, true, true);
        ImageProcessor.getSplitPoint(image, name, 0, endY + 1, true, false);
        if (startX == 0 && endX == 0 && startY == 0 && endY == 0) {
            return null;
        }
        if (startX != 0) {
            --startX;
            endX = image.getWidth() - 2 - (endX - 1);
        } else {
            endX = image.getWidth() - 2;
        }
        if (startY != 0) {
            --startY;
            endY = image.getHeight() - 2 - (endY - 1);
        } else {
            endY = image.getHeight() - 2;
        }
        if (this.scale != 1.0f) {
            startX = Math.round((float)startX * this.scale);
            endX = Math.round((float)endX * this.scale);
            startY = Math.round((float)startY * this.scale);
            endY = Math.round((float)endY * this.scale);
        }
        return new int[]{startX, endX, startY, endY};
    }

    private int[] getPads(Pixmap image, String name, int[] splits) {
        int bottom = image.height - 1;
        int right = image.width - 1;
        int startX = ImageProcessor.getSplitPoint(image, name, 1, bottom, true, true);
        int startY = ImageProcessor.getSplitPoint(image, name, right, 1, true, false);
        int endX = 0;
        int endY = 0;
        if (startX != 0) {
            endX = ImageProcessor.getSplitPoint(image, name, startX + 1, bottom, false, true);
        }
        if (startY != 0) {
            endY = ImageProcessor.getSplitPoint(image, name, right, startY + 1, false, false);
        }
        ImageProcessor.getSplitPoint(image, name, endX + 1, bottom, true, true);
        ImageProcessor.getSplitPoint(image, name, right, endY + 1, true, false);
        if (startX == 0 && endX == 0 && startY == 0 && endY == 0) {
            return null;
        }
        if (startX == 0 && endX == 0) {
            startX = -1;
            endX = -1;
        } else if (startX > 0) {
            --startX;
            endX = image.getWidth() - 2 - (endX - 1);
        } else {
            endX = image.getWidth() - 2;
        }
        if (startY == 0 && endY == 0) {
            startY = -1;
            endY = -1;
        } else if (startY > 0) {
            --startY;
            endY = image.getHeight() - 2 - (endY - 1);
        } else {
            endY = image.getHeight() - 2;
        }
        if (this.scale != 1.0f) {
            startX = Math.round((float)startX * this.scale);
            endX = Math.round((float)endX * this.scale);
            startY = Math.round((float)startY * this.scale);
            endY = Math.round((float)endY * this.scale);
        }
        int[] pads = new int[]{startX, endX, startY, endY};
        if (splits != null && Arrays.equals(pads, splits)) {
            return null;
        }
        return pads;
    }

    private static int getSplitPoint(Pixmap image, String name, int startX, int startY, boolean startPoint, boolean xAxis) {
        int end = xAxis ? image.width : image.height;
        int breakA = startPoint ? 255 : 0;
        int x = startX;
        int y = startY;
        for (int next = xAxis ? startX : startY; next != end; ++next) {
            if (xAxis) {
                x = next;
            } else {
                y = next;
            }
            int rgba = image.get(x, y);
            int r = Color.ri(rgba);
            int g = Color.gi(rgba);
            int b = Color.bi(rgba);
            int a = Color.ai(rgba);
            if (a == breakA) {
                return next;
            }
            if (startPoint || r == 0 && g == 0 && b == 0 && a == 255) continue;
            throw new RuntimeException("Invalid " + name + " ninepatch split pixel at " + x + ", " + y + ", rgba: " + r + ", " + g + ", " + b + ", " + a);
        }
        return 0;
    }

    private static String hash(Pixmap image) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            int width = image.width;
            int height = image.height;
            byte[] bytes = new byte[image.pixels.capacity()];
            image.pixels.position(0);
            image.pixels.get(bytes);
            digest.update(bytes);
            image.pixels.position(0);
            ImageProcessor.hash(digest, width);
            ImageProcessor.hash(digest, height);
            return new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void hash(MessageDigest digest, int value) {
        digest.update((byte)(value >> 24));
        digest.update((byte)(value >> 16));
        digest.update((byte)(value >> 8));
        digest.update((byte)value);
    }
}

