/*
 * Decompiled with CFR 0.152.
 */
package arc.math;

import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;

public final class Mathf {
    public static final int[] signs;
    public static final int[] zeroOne;
    public static final boolean[] booleans;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float pi = (float)Math.PI;
    public static final float halfPi = 1.5707964f;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float E = (float)Math.E;
    public static final float sqrt2;
    public static final float sqrt3;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    public static final double doubleDegRad = Math.PI / 180;
    public static final double doubleRadDeg = 57.29577951308232;
    private static final int sinBits = 14;
    private static final int sinMask = 16383;
    private static final int sinCount = 16384;
    private static final float[] sinTable;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_ROUND = 16384.5;
    private static final Rand seedr;
    private static final Vec2 v1;
    private static final Vec2 v2;
    private static final Vec2 v3;
    public static Rand rand;

    public static float sin(float radians) {
        return sinTable[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return sinTable[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float degrees) {
        return sinTable[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return sinTable[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float absin(float scl, float mag) {
        return Mathf.absin(Time.time, scl, mag);
    }

    public static float absin(float in, float scl, float mag) {
        return (Mathf.sin(in, scl * 2.0f, mag) + mag) / 2.0f;
    }

    public static float tan(float radians, float scl, float mag) {
        return Mathf.sin(radians / scl) / Mathf.cos(radians / scl) * mag;
    }

    public static float sin(float scl, float mag) {
        return Mathf.sin(Time.time / scl) * mag;
    }

    public static float sin(float radians, float scl, float mag) {
        return Mathf.sin(radians / scl) * mag;
    }

    public static float cos(float radians, float scl, float mag) {
        return Mathf.cos(radians / scl) * mag;
    }

    public static float angle(float x, float y) {
        float result = Mathf.atan2(x, y) * 57.295776f;
        if (result < 0.0f) {
            result += 360.0f;
        }
        return result;
    }

    public static float angleExact(float x, float y) {
        float result = (float)Math.atan2(y, x) * 57.295776f;
        if (result < 0.0f) {
            result += 360.0f;
        }
        return result;
    }

    public static float wrapAngleAroundZero(float a) {
        if (a >= 0.0f) {
            float rotation = a % ((float)Math.PI * 2);
            if (rotation > (float)Math.PI) {
                rotation -= (float)Math.PI * 2;
            }
            return rotation;
        }
        float rotation = -a % ((float)Math.PI * 2);
        if (rotation > (float)Math.PI) {
            rotation -= (float)Math.PI * 2;
        }
        return -rotation;
    }

    private static float atn(double i) {
        double n = Math.abs(i);
        double c = (n - 1.0) / (n + 1.0);
        double c2 = c * c;
        double c3 = c * c2;
        double c5 = c3 * c2;
        double c7 = c5 * c2;
        double c9 = c7 * c2;
        double c11 = c9 * c2;
        return (float)Math.copySign(0.7853981633974483 + (0.99997726 * c - 0.33262347 * c3 + 0.19354346 * c5 - 0.11643287 * c7 + 0.05265332 * c9 - 0.0117212 * c11), i);
    }

    public static float atan2(float x, float y) {
        float n = y / x;
        if (n != n) {
            n = y == x ? 1.0f : -1.0f;
        } else if (n - n != n - n) {
            x = 0.0f;
        }
        if (x > 0.0f) {
            return Mathf.atn(n);
        }
        if (x < 0.0f) {
            return y >= 0.0f ? Mathf.atn(n) + (float)Math.PI : Mathf.atn(n) - (float)Math.PI;
        }
        if (y > 0.0f) {
            return x + 1.5707964f;
        }
        if (y < 0.0f) {
            return x - 1.5707964f;
        }
        return x + y;
    }

    public static int digits(int n) {
        return n < 100000 ? (n < 100 ? (n < 10 ? 1 : 2) : (n < 1000 ? 3 : (n < 10000 ? 4 : 5))) : (n < 10000000 ? (n < 1000000 ? 6 : 7) : (n < 100000000 ? 8 : (n < 1000000000 ? 9 : 10)));
    }

    public static int digits(long n) {
        return n == 0L ? 1 : (int)(Math.log10(n) + 1.0);
    }

    public static float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    public static float sqr(float x) {
        return x * x;
    }

    public static float map(float value, float froma, float toa, float fromb, float tob) {
        return fromb + (value - froma) * (tob - fromb) / (toa - froma);
    }

    public static float map(float value, float from, float to) {
        return Mathf.map(value, 0.0f, 1.0f, from, to);
    }

    public static int sign(float f) {
        return f < 0.0f ? -1 : 1;
    }

    public static int sign(boolean b) {
        return b ? 1 : -1;
    }

    public static int num(boolean b) {
        return b ? 1 : 0;
    }

    public static float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static int pow(int a, int b) {
        return (int)Math.ceil(Math.pow(a, b));
    }

    public static float range(float range) {
        return Mathf.random(-range, range);
    }

    public static int range(int range) {
        return Mathf.random(-range, range);
    }

    public static float range(float min, float max) {
        if (Mathf.chance(0.5)) {
            return Mathf.random(min, max);
        }
        return -Mathf.random(min, max);
    }

    public static boolean chanceDelta(double d) {
        return (double)rand.nextFloat() < d * (double)Time.delta;
    }

    public static boolean chance(double d) {
        return d >= 1.0 || (double)rand.nextFloat() < d;
    }

    public static int random(int range) {
        return rand.nextInt(range + 1);
    }

    public static int random(int start, int end) {
        return start + rand.nextInt(end - start + 1);
    }

    public static long random(long range) {
        return (long)(rand.nextDouble() * (double)range);
    }

    public static long random(long start, long end) {
        return start + (long)(rand.nextDouble() * (double)(end - start));
    }

    public static boolean randomBoolean() {
        return rand.nextBoolean();
    }

    public static boolean randomBoolean(float chance) {
        return Mathf.random() < chance;
    }

    public static float random() {
        return rand.nextFloat();
    }

    public static float random(float range) {
        return rand.nextFloat() * range;
    }

    public static float random(float start, float end) {
        return start + rand.nextFloat() * (end - start);
    }

    public static int randomSign() {
        return 1 | rand.nextInt() >> 31;
    }

    public static int randomSeed(long seed, int min, int max) {
        seedr.setSeed(seed);
        if (Mathf.isPowerOfTwo(max)) {
            seedr.nextInt();
        }
        return seedr.nextInt(max - min + 1) + min;
    }

    public static float randomSeed(long seed, float min, float max) {
        seedr.setSeed(seed);
        return min + seedr.nextFloat() * (max - min);
    }

    public static float randomSeed(long seed) {
        seedr.setSeed(seed * 99999L);
        return seedr.nextFloat();
    }

    public static float randomSeed(long seed, float max) {
        seedr.setSeed(seed * 99999L);
        return seedr.nextFloat() * max;
    }

    public static float randomSeedRange(long seed, float range) {
        seedr.setSeed(seed * 99999L);
        return range * (seedr.nextFloat() - 0.5f) * 2.0f;
    }

    public static float randomTriangular() {
        return rand.nextFloat() - rand.nextFloat();
    }

    public static float randomTriangular(float max) {
        return (rand.nextFloat() - rand.nextFloat()) * max;
    }

    public static float randomTriangular(float min, float max) {
        return Mathf.randomTriangular(min, max, (min + max) * 0.5f);
    }

    public static float randomTriangular(float min, float max, float mode) {
        float d;
        float u = rand.nextFloat();
        if (u <= (mode - min) / (d = max - min)) {
            return min + (float)Math.sqrt(u * d * (mode - min));
        }
        return max - (float)Math.sqrt((1.0f - u) * d * (max - mode));
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value) {
        return Math.max(Math.min(value, 1.0f), 0.0f);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float maxZero(float val) {
        return Math.max(val, 0.0f);
    }

    public static float approach(float from, float to, float speed) {
        return from + Mathf.clamp(to - from, -speed, speed);
    }

    public static float approachDelta(float from, float to, float speed) {
        return Mathf.approach(from, to, Time.delta * speed);
    }

    public static float lerp(float fromValue, float toValue, float progress) {
        return fromValue + (toValue - fromValue) * progress;
    }

    public static float lerpDelta(float fromValue, float toValue, float progress) {
        return Mathf.lerp(fromValue, toValue, Mathf.clamp(progress * Time.delta));
    }

    public static float slerpRad(float fromRadians, float toRadians, float progress) {
        float delta = (toRadians - fromRadians + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return (fromRadians + delta * progress + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float slerp(float fromDegrees, float toDegrees, float progress) {
        float delta = (toDegrees - fromDegrees + 360.0f + 180.0f) % 360.0f - 180.0f;
        return (fromDegrees + delta * progress + 360.0f) % 360.0f;
    }

    public static float slerpDelta(float fromDegrees, float toDegrees, float progress) {
        return Mathf.slerp(fromDegrees, toDegrees, Mathf.clamp(progress * Time.delta));
    }

    public static int floor(float value) {
        return (int)((double)value + 16384.0) - 16384;
    }

    public static int floorPositive(float value) {
        return (int)value;
    }

    public static int ceil(float value) {
        return 16384 - (int)(16384.0 - (double)value);
    }

    public static int ceilPositive(float value) {
        return (int)((double)value + 0.9999999);
    }

    public static int round(float value) {
        return (int)((double)value + 16384.5) - 16384;
    }

    public static int round(int value, int step) {
        return value / step * step;
    }

    public static float round(float value, float step) {
        return (float)((int)(value / step)) * step;
    }

    public static int round(float value, int step) {
        return (int)(value / (float)step) * step;
    }

    public static int roundPositive(float value) {
        return (int)(value + 0.5f);
    }

    public static boolean zero(float value) {
        return Math.abs(value) <= 1.0E-6f;
    }

    public static boolean zero(double value) {
        return Math.abs(value) <= (double)1.0E-6f;
    }

    public static boolean zero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean equal(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    public static boolean equal(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static float log(float a, float value) {
        return (float)(Math.log(value) / Math.log(a));
    }

    public static float log2(float value) {
        return Mathf.log(2.0f, value);
    }

    public static int log2(int value) {
        return value == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(value);
    }

    public static float mod(float f, float n) {
        return (f % n + n) % n;
    }

    public static int mod(int x, int n) {
        return (x % n + n) % n;
    }

    public static float sample(float[] values, float time) {
        time = Mathf.clamp(time);
        float pos = time * (float)(values.length - 1);
        int cur = Math.min((int)(time * (float)(values.length - 1)), values.length - 1);
        int next = Math.min(cur + 1, values.length - 1);
        float mod = pos - (float)cur;
        return Mathf.lerp(values[cur], values[next], mod);
    }

    public static float slope(float fin) {
        return 1.0f - Math.abs(fin - 0.5f) * 2.0f;
    }

    public static float curve(float f, float offset) {
        if (f < offset) {
            return 0.0f;
        }
        return (f - offset) / (1.0f - offset);
    }

    public static float curve(float f, float from, float to) {
        if (f < from) {
            return 0.0f;
        }
        if (f > to) {
            return 1.0f;
        }
        return (f - from) / (to - from);
    }

    public static float curveMargin(float f, float margin) {
        return Mathf.curveMargin(f, margin, margin);
    }

    public static float curveMargin(float f, float marginLeft, float marginRight) {
        if (f < marginLeft) {
            return f / marginLeft * 0.5f;
        }
        if (f > 1.0f - marginRight) {
            return (f - 1.0f + marginRight) / marginRight * 0.5f + 0.5f;
        }
        return 0.5f;
    }

    public static float len(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }

    public static float len2(float x, float y) {
        return x * x + y * y;
    }

    public static float dot(float x1, float y1, float x2, float y2) {
        return x1 * x2 + y1 * y2;
    }

    public static float dst(float x1, float y1) {
        return (float)Math.sqrt(x1 * x1 + y1 * y1);
    }

    public static float dst2(float x1, float y1) {
        return x1 * x1 + y1 * y1;
    }

    public static float dst(float x1, float y1, float x2, float y2) {
        float xd = x2 - x1;
        float yd = y2 - y1;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public static float dst2(float x1, float y1, float x2, float y2) {
        float xd = x2 - x1;
        float yd = y2 - y1;
        return xd * xd + yd * yd;
    }

    public static float dstm(float x1, float y1, float x2, float y2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2);
    }

    public static Vec2 arrive(Position pos, Position target, Vec2 curVel, float radius, float tolerance, float speed, float smoothTime) {
        return Mathf.arrive(pos.getX(), pos.getY(), target.getX(), target.getY(), curVel, radius, tolerance, speed, smoothTime);
    }

    public static Vec2 arrive(float x, float y, float destX, float destY, Vec2 curVel, float radius, float tolerance, float speed, float accel) {
        Vec2 toTarget = v1.set(destX, destY).sub(x, y);
        float distance = toTarget.len();
        if (distance <= tolerance) {
            return v3.setZero();
        }
        float targetSpeed = speed;
        if (distance <= radius) {
            targetSpeed *= distance / radius;
        }
        return toTarget.sub(curVel.x / accel, curVel.y / accel).limit(targetSpeed);
    }

    public static boolean within(float x1, float y1, float x2, float y2, float dst) {
        return Mathf.dst2(x1, y1, x2, y2) < dst * dst;
    }

    public static boolean within(float x1, float y1, float dst) {
        return x1 * x1 + y1 * y1 < dst * dst;
    }

    static {
        int i;
        signs = new int[]{-1, 1};
        zeroOne = new int[]{0, 1};
        booleans = new boolean[]{true, false};
        sqrt2 = Mathf.sqrt(2.0f);
        sqrt3 = Mathf.sqrt(3.0f);
        sinTable = new float[16384];
        seedr = new Rand();
        v1 = new Vec2();
        v2 = new Vec2();
        v3 = new Vec2();
        for (i = 0; i < 16384; ++i) {
            Mathf.sinTable[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
        }
        for (i = 0; i < 360; i += 90) {
            Mathf.sinTable[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
        Mathf.sinTable[0] = 0.0f;
        Mathf.sinTable[4096] = 1.0f;
        Mathf.sinTable[8192] = 0.0f;
        Mathf.sinTable[12288] = -1.0f;
        rand = new Rand();
    }
}

