/*
 * Decompiled with CFR 0.152.
 */
package arc.input;

import arc.Core;
import arc.input.KeyCode;
import arc.struct.Seq;
import arc.util.Nullable;

public class KeyBind {
    public static final Seq<KeyBind> all = new Seq();
    public final String name;
    public final KeybindValue defaultValue;
    @Nullable
    public final String category;
    public Axis value;

    public static KeyBind add(String name, KeybindValue defaultValue, String category) {
        return new KeyBind(name, defaultValue, category);
    }

    public static KeyBind add(String name, KeybindValue defaultValue) {
        return new KeyBind(name, defaultValue, null);
    }

    public static void resetAll() {
        for (KeyBind def : all) {
            def.resetToDefault();
        }
    }

    protected KeyBind(String name, KeybindValue defaultValue, String category) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.category = category;
        this.value = defaultValue instanceof Axis ? (Axis)defaultValue : new Axis((KeyCode)defaultValue);
        all.add(this);
        this.load();
    }

    public void save() {
        String name = this.settingsKey();
        Core.settings.put(name + "-single", this.value.key != null);
        if (this.value.key != null) {
            Core.settings.put(name + "-key", this.value.key.ordinal());
        } else {
            Core.settings.put(name + "-min", this.value.min.ordinal());
            Core.settings.put(name + "-max", this.value.max.ordinal());
        }
    }

    public void load() {
        Axis loaded;
        if (Core.settings == null) {
            return;
        }
        String name = this.settingsKey();
        if (Core.settings.getBool(name + "-single", true)) {
            KeyCode key = KeyCode.byOrdinal(Core.settings.getInt(name + "-key", KeyCode.unset.ordinal()));
            loaded = key == KeyCode.unset ? null : new Axis(key);
        } else {
            KeyCode min = KeyCode.byOrdinal(Core.settings.getInt(name + "-min", KeyCode.unset.ordinal()));
            KeyCode max = KeyCode.byOrdinal(Core.settings.getInt(name + "-max", KeyCode.unset.ordinal()));
            Axis axis = loaded = min == KeyCode.unset || max == KeyCode.unset ? null : new Axis(min, max);
        }
        if (loaded != null) {
            this.value = loaded;
        }
    }

    public void resetToDefault() {
        String name = this.settingsKey();
        Core.settings.remove(name + "-single");
        Core.settings.remove(name + "-key");
        Core.settings.remove(name + "-min");
        Core.settings.remove(name + "-max");
        this.value = this.defaultValue instanceof Axis ? (((Axis)this.defaultValue).min == null ? new Axis(((Axis)this.defaultValue).key) : new Axis(((Axis)this.defaultValue).min, ((Axis)this.defaultValue).max)) : new Axis((KeyCode)this.defaultValue);
    }

    public boolean isDefault() {
        if (this.defaultValue instanceof Axis) {
            if (((Axis)this.defaultValue).min == null) {
                return ((Axis)this.defaultValue).key == this.value.key;
            }
            return ((Axis)this.defaultValue).max == this.value.max && ((Axis)this.defaultValue).min == this.value.min;
        }
        return this.defaultValue == this.value.key;
    }

    String settingsKey() {
        return "keybind-default-keyboard-" + this.name;
    }

    public static interface KeybindValue {
    }

    public static class Axis
    implements KeybindValue {
        @Nullable
        public KeyCode min;
        @Nullable
        public KeyCode max;
        @Nullable
        public KeyCode key;

        public Axis(KeyCode key) {
            this.key = key;
            this.max = null;
            this.min = null;
        }

        public Axis(KeyCode min, KeyCode max) {
            this.min = min;
            this.max = max;
            this.key = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Axis axis = (Axis)o;
            return this.min == axis.min && this.max == axis.max && this.key == axis.key;
        }
    }
}

