/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g3d;

import arc.graphics.Color;
import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.struct.Seq;

public class VertexBatch3D {
    private final int maxVertices;
    private final Mesh mesh;
    private final int numTexCoords;
    private final int vertexSize;
    private final int normalOffset;
    private final int colorOffset;
    private final int texCoordOffset;
    private final Mat3D proj = new Mat3D();
    private final float[] vertices;
    private final String[] shaderUniformNames;
    private int vertexIdx;
    private int numSetTexCoords;
    private int numVertices;
    private Shader shader;
    private boolean ownsShader;

    public VertexBatch3D(boolean hasNormals, boolean hasColors, int numTexCoords) {
        this(5000, hasNormals, hasColors, numTexCoords, VertexBatch3D.createDefaultShader(hasNormals, hasColors, numTexCoords));
        this.ownsShader = true;
    }

    public VertexBatch3D(int maxVertices, boolean hasNormals, boolean hasColors, int numTexCoords) {
        this(maxVertices, hasNormals, hasColors, numTexCoords, VertexBatch3D.createDefaultShader(hasNormals, hasColors, numTexCoords));
        this.ownsShader = true;
    }

    public VertexBatch3D(int maxVertices, boolean hasNormals, boolean hasColors, int numTexCoords, Shader shader) {
        this.maxVertices = maxVertices;
        this.numTexCoords = numTexCoords;
        this.shader = shader;
        VertexAttribute[] attribs = this.buildVertexAttributes(hasNormals, hasColors, numTexCoords);
        this.mesh = new Mesh(false, maxVertices, 0, attribs);
        this.vertices = new float[maxVertices * (this.mesh.vertexSize / 4)];
        this.vertexSize = this.mesh.vertexSize / 4;
        int offset = 3;
        if (hasNormals) {
            this.normalOffset = offset;
            offset += 3;
        } else {
            this.normalOffset = 0;
        }
        this.colorOffset = hasColors ? offset++ : 0;
        this.texCoordOffset = offset;
        this.shaderUniformNames = new String[numTexCoords];
        for (int i = 0; i < numTexCoords; ++i) {
            this.shaderUniformNames[i] = "u_sampler" + i;
        }
    }

    private static String createVertexShader(boolean hasNormals, boolean hasColors, int numTexCoords) {
        int i;
        StringBuilder shader = new StringBuilder("attribute vec4 a_position;\n" + (hasNormals ? "attribute vec3 a_normal;\n" : "") + (hasColors ? "attribute vec4 a_color;\n" : ""));
        for (i = 0; i < numTexCoords; ++i) {
            shader.append("attribute vec2 a_texCoord").append(i).append(";\n");
        }
        shader.append("uniform mat4 u_proj;\n");
        shader.append(hasColors ? "varying vec4 v_col;\n" : "");
        for (i = 0; i < numTexCoords; ++i) {
            shader.append("varying vec2 v_tex").append(i).append(";\n");
        }
        shader.append("void main() {\n   gl_Position = u_proj * a_position;\n").append(hasColors ? "   v_col = a_color;\n" : "");
        for (i = 0; i < numTexCoords; ++i) {
            shader.append("   v_tex").append(i).append(" = ").append("a_texCoord").append(i).append(";\n");
        }
        shader.append("   gl_PointSize = 1.0;\n");
        shader.append("}\n");
        return shader.toString();
    }

    private static String createFragmentShader(boolean hasNormals, boolean hasColors, int numTexCoords) {
        int i;
        StringBuilder shader = new StringBuilder();
        if (hasColors) {
            shader.append("varying vec4 v_col;\n");
        }
        for (i = 0; i < numTexCoords; ++i) {
            shader.append("varying vec2 v_tex").append(i).append(";\n");
            shader.append("uniform sampler2D u_sampler").append(i).append(";\n");
        }
        shader.append("void main(){\n   gl_FragColor = ").append(hasColors ? "v_col" : "vec4(1, 1, 1, 1)");
        if (numTexCoords > 0) {
            shader.append(" * ");
        }
        for (i = 0; i < numTexCoords; ++i) {
            if (i == numTexCoords - 1) {
                shader.append(" texture2D(u_sampler").append(i).append(",  v_tex").append(i).append(")");
                continue;
            }
            shader.append(" texture2D(u_sampler").append(i).append(",  v_tex").append(i).append(") *");
        }
        shader.append(";\n}");
        return shader.toString();
    }

    public static Shader createDefaultShader(boolean hasNormals, boolean hasColors, int numTexCoords) {
        String vertexShader = VertexBatch3D.createVertexShader(hasNormals, hasColors, numTexCoords);
        String fragmentShader = VertexBatch3D.createFragmentShader(hasNormals, hasColors, numTexCoords);
        return new Shader(vertexShader, fragmentShader);
    }

    private VertexAttribute[] buildVertexAttributes(boolean hasNormals, boolean hasColor, int numTexCoords) {
        Seq<VertexAttribute> attribs = new Seq<VertexAttribute>();
        attribs.add(VertexAttribute.position3);
        if (hasNormals) {
            attribs.add(VertexAttribute.normal);
        }
        if (hasColor) {
            attribs.add(VertexAttribute.color);
        }
        for (int i = 0; i < numTexCoords; ++i) {
            attribs.add(new VertexAttribute(2, "a_texCoord" + i));
        }
        return (VertexAttribute[])attribs.toArray(VertexAttribute.class);
    }

    public void setShader(Shader shader) {
        if (this.ownsShader) {
            this.shader.dispose();
        }
        this.shader = shader;
        this.ownsShader = false;
    }

    public void color(Color color) {
        this.vertices[this.vertexIdx + this.colorOffset] = color.toFloatBits();
    }

    public void color(float r, float g, float b, float a) {
        this.vertices[this.vertexIdx + this.colorOffset] = Color.toFloatBits(r, g, b, a);
    }

    public void color(float colorBits) {
        this.vertices[this.vertexIdx + this.colorOffset] = colorBits;
    }

    public void texCoord(float u, float v) {
        int idx = this.vertexIdx + this.texCoordOffset;
        this.vertices[idx + this.numSetTexCoords] = u;
        this.vertices[idx + this.numSetTexCoords + 1] = v;
        this.numSetTexCoords += 2;
    }

    public void normal(Vec3 v) {
        this.normal(v.x, v.y, v.z);
    }

    public void normal(float x, float y, float z) {
        int idx = this.vertexIdx + this.normalOffset;
        this.vertices[idx] = x;
        this.vertices[idx + 1] = y;
        this.vertices[idx + 2] = z;
    }

    public void tri2(Vec3 v1, Vec3 v2, Vec3 v3, Color color) {
        this.tri(v1, v2, v3, color);
        this.tri(v1, v3, v2, color);
    }

    public void tri(Vec3 v1, Vec3 v2, Vec3 v3, Color color) {
        this.tri(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, color);
    }

    public void tri(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, Color color) {
        float bits = color.toFloatBits();
        this.vertex(x1, y1, z1, bits);
        this.vertex(x2, y2, z2, bits);
        this.vertex(x3, y3, z3, bits);
    }

    public void quad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Color color) {
        this.tri(v1, v2, v3, color);
        this.tri(v1, v3, v4, color);
    }

    public void vertex(Vec3 v, Color color) {
        this.color(color);
        this.vertex(v.x, v.y, v.z);
    }

    public void vertex(Vec3 v) {
        this.vertex(v.x, v.y, v.z);
    }

    public void vertex(float x, float y, float z, float color) {
        int idx = this.vertexIdx;
        this.vertices[idx] = x;
        this.vertices[idx + 1] = y;
        this.vertices[idx + 2] = z;
        this.vertices[idx + this.colorOffset] = color;
        this.numSetTexCoords = 0;
        this.vertexIdx += this.vertexSize;
        ++this.numVertices;
    }

    public void vertex(float x, float y, float z) {
        int idx = this.vertexIdx;
        this.vertices[idx] = x;
        this.vertices[idx + 1] = y;
        this.vertices[idx + 2] = z;
        this.numSetTexCoords = 0;
        this.vertexIdx += this.vertexSize;
        ++this.numVertices;
    }

    public void vertex(float[] floats) {
        System.arraycopy(floats, 0, this.vertices, this.vertexIdx, this.vertexSize);
        this.vertexIdx += this.vertexSize;
        ++this.numVertices;
    }

    public Mat3D proj() {
        return this.proj;
    }

    public void proj(Mat3D projModelView) {
        this.proj.set(projModelView);
    }

    public void flush(int primitiveType) {
        this.flush(primitiveType, this.shader);
    }

    public void flush(int primitiveType, Shader shader) {
        if (this.numVertices == 0) {
            return;
        }
        shader.bind();
        shader.apply();
        shader.setUniformMatrix4("u_proj", this.proj.val);
        for (int i = 0; i < this.numTexCoords; ++i) {
            shader.setUniformi(this.shaderUniformNames[i], i);
        }
        this.mesh.setVertices(this.vertices, 0, this.vertexIdx);
        this.mesh.render(shader, primitiveType);
        this.numSetTexCoords = 0;
        this.vertexIdx = 0;
        this.numVertices = 0;
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public int getMaxVertices() {
        return this.maxVertices;
    }

    public void dispose() {
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
        this.mesh.dispose();
    }
}

