/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Core;
import arc.Input;
import arc.backend.sdl.SdlScanmap;
import arc.input.InputEventQueue;
import arc.input.KeyCode;
import arc.scene.ui.TextField;
import arc.struct.Seq;
import java.util.Arrays;
import org.lwjgl.sdl.SDLKeyboard;
import org.lwjgl.sdl.SDL_Event;

public class SdlInput
extends Input {
    private final InputEventQueue queue = new InputEventQueue();
    private int[] keycodeToScancode;
    private int mouseX;
    private int mouseY;
    private int deltaX;
    private int deltaY;
    private int mousePressed;
    private Seq<EditEvent> stringEditEvents = new Seq();

    void handleInput(final SDL_Event event) {
        int type = event.type();
        if (type == 768 || type == 769) {
            boolean down = type == 768;
            int keycode = event.key().scancode();
            KeyCode key = SdlScanmap.getCode(keycode);
            if (!event.key().repeat()) {
                if (down) {
                    this.queue.keyDown(key);
                } else {
                    this.queue.keyUp(key);
                }
            }
            if (down) {
                if (key == KeyCode.backspace) {
                    this.queue.keyTyped('\b');
                }
                if (key == KeyCode.tab) {
                    this.queue.keyTyped('\t');
                }
                if (key == KeyCode.enter) {
                    this.queue.keyTyped('\r');
                }
                if (key == KeyCode.forwardDel || key == KeyCode.del) {
                    this.queue.keyTyped('\u007f');
                }
            }
        } else if (type == 1025 || type == 1026) {
            KeyCode key;
            boolean down = type == 1025;
            byte keycode = event.button().button();
            int x = (int)event.button().x();
            int y = Core.graphics.getHeight() - (int)event.button().y();
            KeyCode keyCode = keycode == 1 ? KeyCode.mouseLeft : (keycode == 3 ? KeyCode.mouseRight : (keycode == 2 ? KeyCode.mouseMiddle : (keycode == 4 ? KeyCode.mouseBack : (key = keycode == 5 ? KeyCode.mouseForward : null))));
            if (key != null) {
                if (down) {
                    ++this.mousePressed;
                    this.queue.touchDown(x, y, 0, key);
                } else {
                    this.mousePressed = Math.max(0, this.mousePressed - 1);
                    this.queue.touchUp(x, y, 0, key);
                }
            }
        } else if (type == 1024) {
            int x = (int)event.motion().x();
            int y = Core.graphics.getHeight() - (int)event.motion().y();
            this.deltaX = x - this.mouseX;
            this.deltaY = y - this.mouseY;
            this.mouseX = x;
            this.mouseY = y;
            if (this.mousePressed > 0) {
                this.queue.touchDragged(this.mouseX, this.mouseY, 0);
            } else {
                this.queue.mouseMoved(this.mouseX, this.mouseY);
            }
        } else if (type == 1027) {
            int sx = (int)event.wheel().x();
            int sy = (int)event.wheel().y();
            this.queue.scrolled(-sx, -sy);
        } else if (type == 771) {
            String text = event.text().textString();
            if (text != null) {
                for (int i = 0; i < text.length(); ++i) {
                    this.queue.keyTyped(text.charAt(i));
                }
            }
        } else if (type == 770) {
            final String editString = event.edit().textString();
            this.stringEditEvents.add(new EditEvent(){
                {
                    this.start = event.edit().start();
                    this.length = event.edit().length();
                    this.text = editString;
                }
            });
        }
    }

    void handleFieldCandidate(EditEvent e) {
        String text = e.text;
        if (Core.scene != null && Core.scene.getKeyboardFocus() instanceof TextField) {
            class ImeData {
                String lastSetText;
                String realText;
                int cursor;

                ImeData() {
                }
            }
            ImeData data;
            final TextField field = (TextField)Core.scene.getKeyboardFocus();
            if (field.imeData instanceof ImeData) {
                data = (ImeData)field.imeData;
                if (data.lastSetText != field.getText()) {
                    field.imeData = null;
                } else if (text.length() == 0) {
                    field.imeData = null;
                    field.setText(data.realText);
                    field.clearSelection();
                    field.setCursorPosition(data.cursor);
                }
            }
            if (text.length() == 0) {
                return;
            }
            if (field.imeData == null) {
                field.imeData = new ImeData(){
                    {
                        this.cursor = field.getCursorPosition();
                        this.realText = field.getText();
                    }
                };
            }
            data = (ImeData)field.imeData;
            String targetText = data.realText;
            int insertPos = data.cursor;
            field.setText(targetText.substring(0, Math.min(insertPos, targetText.length())) + text + targetText.substring(Math.min(insertPos, targetText.length())));
            field.setSelection(insertPos, insertPos + text.length());
            data.lastSetText = field.getText();
        }
    }

    void update() {
        this.queue.setProcessor(this.inputMultiplexer);
        this.queue.drain();
        for (EditEvent e : this.stringEditEvents) {
            this.handleFieldCandidate(e);
        }
        this.stringEditEvents.clear();
    }

    void postUpdate() {
        this.keyboard.postUpdate();
        this.deltaY = 0;
        this.deltaX = 0;
    }

    @Override
    public String getKeyName(KeyCode code) {
        int value;
        if (this.keycodeToScancode == null) {
            this.keycodeToScancode = new int[KeyCode.all.length];
            Arrays.fill(this.keycodeToScancode, -1);
            for (int i = 0; i < 256; ++i) {
                KeyCode keycode = SdlScanmap.getCode(i);
                if (this.keycodeToScancode[keycode.ordinal()] != -1) continue;
                this.keycodeToScancode[keycode.ordinal()] = i;
            }
        }
        if ((value = this.keycodeToScancode[code.ordinal()]) != -1) {
            return SDLKeyboard.SDL_GetScancodeName(value);
        }
        return super.getKeyName(code);
    }

    @Override
    public int mouseX() {
        return this.mouseX;
    }

    @Override
    public int mouseX(int pointer) {
        return pointer == 0 ? this.mouseX : 0;
    }

    @Override
    public int deltaX() {
        return this.deltaX;
    }

    @Override
    public int deltaX(int pointer) {
        return pointer == 0 ? this.deltaX : 0;
    }

    @Override
    public int mouseY() {
        return this.mouseY;
    }

    @Override
    public int mouseY(int pointer) {
        return pointer == 0 ? this.mouseY : 0;
    }

    @Override
    public int deltaY() {
        return this.deltaY;
    }

    @Override
    public int deltaY(int pointer) {
        return pointer == 0 ? this.deltaY : 0;
    }

    @Override
    public boolean isTouched() {
        return this.keyDown(KeyCode.mouseLeft) || this.keyDown(KeyCode.mouseRight);
    }

    @Override
    public boolean justTouched() {
        return this.keyTap(KeyCode.mouseLeft) || this.keyTap(KeyCode.mouseRight);
    }

    @Override
    public boolean isTouched(int pointer) {
        return false;
    }

    @Override
    public long getCurrentEventTime() {
        return this.queue.getCurrentEventTime();
    }

    static class EditEvent {
        int start;
        int length;
        String text;

        EditEvent() {
        }
    }
}

