/*
 * Decompiled with CFR 0.152.
 */
package arc.assets.loaders;

import arc.Core;
import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetManager;
import arc.assets.loaders.AsynchronousAssetLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.audio.Sound;
import arc.files.Fi;
import arc.struct.Seq;
import arc.util.Nullable;

public class SoundLoader
extends AsynchronousAssetLoader<Sound, SoundParameter> {
    private Sound sound;

    public SoundLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    protected Sound getLoadedSound() {
        return this.sound;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, Fi file, SoundParameter parameter) {
        if (parameter != null && parameter.sound != null) {
            this.sound = parameter.sound;
            this.sound.load(file);
        } else {
            this.sound = Core.audio.newSound(file);
        }
    }

    @Override
    public Sound loadSync(AssetManager manager, String fileName, Fi file, SoundParameter parameter) {
        Sound sound = this.sound;
        this.sound = null;
        return sound;
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, SoundParameter parameter) {
        return null;
    }

    public static class SoundParameter
    extends AssetLoaderParameters<Sound> {
        @Nullable
        public Sound sound;

        public SoundParameter() {
        }

        public SoundParameter(@Nullable Sound sound) {
            this.sound = sound;
        }

        public SoundParameter(AssetLoaderParameters.LoadedCallback loadedCallback) {
            super(loadedCallback);
        }
    }
}

