# Box Textured with `CESIUM_primitive_outline` and shared vertices

This is a variation on BoxTextured that adds `CESIUM_primitive_outline` to outline the edges of the box.
This version of the model has no normals or textures, and furthermore shares
vertices among triangles that meet at a corner.

This model is for testing that the outline extensions cause vertices to be
duplicated at runtime. `BoxWithPrimitiveOutline` in contrast has duplicated
vertices due to normals and texture coordinates, so no further duplication is
needed at runtime.

## Screenshot

![screenshot](screenshot/screenshot.png)

## License Information

This model is licensed under a [Creative Commons Attribution 4.0 International License](http://creativecommons.org/licenses/by/4.0/).

## Outline Generation Code

The outline edge indices buffer was generated by the following Python 3 script. There are no dependencies.

In the `glTF` subdirectory:

```bash
python3 make_primitive_outlines.py
```

will generate `outlines.bin`.
