/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.138.0
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod2) => function __require() {
  return mod2 || (0, cb[__getOwnPropNames(cb)[0]])((mod2 = { exports: {} }).exports, mod2), mod2.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod2, isNodeMode, target) => (target = mod2 != null ? __create(__getProtoOf(mod2)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod2 || !mod2.__esModule ? __defProp(target, "default", { value: mod2, enumerable: true }) : target,
  mod2
));
var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

// node_modules/mersenne-twister/src/mersenne-twister.js
var require_mersenne_twister = __commonJS({
  "node_modules/mersenne-twister/src/mersenne-twister.js"(exports2, module2) {
    var MersenneTwister4 = function(seed) {
      if (seed == void 0) {
        seed = (/* @__PURE__ */ new Date()).getTime();
      }
      this.N = 624;
      this.M = 397;
      this.MATRIX_A = 2567483615;
      this.UPPER_MASK = 2147483648;
      this.LOWER_MASK = 2147483647;
      this.mt = new Array(this.N);
      this.mti = this.N + 1;
      if (seed.constructor == Array) {
        this.init_by_array(seed, seed.length);
      } else {
        this.init_seed(seed);
      }
    };
    MersenneTwister4.prototype.init_seed = function(s) {
      this.mt[0] = s >>> 0;
      for (this.mti = 1; this.mti < this.N; this.mti++) {
        var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
        this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
        this.mt[this.mti] >>>= 0;
      }
    };
    MersenneTwister4.prototype.init_by_array = function(init_key, key_length) {
      var i, j, k;
      this.init_seed(19650218);
      i = 1;
      j = 0;
      k = this.N > key_length ? this.N : key_length;
      for (; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
        this.mt[i] >>>= 0;
        i++;
        j++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
        if (j >= key_length) j = 0;
      }
      for (k = this.N - 1; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
        this.mt[i] >>>= 0;
        i++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
      }
      this.mt[0] = 2147483648;
    };
    MersenneTwister4.prototype.random_int = function() {
      var y;
      var mag01 = new Array(0, this.MATRIX_A);
      if (this.mti >= this.N) {
        var kk;
        if (this.mti == this.N + 1)
          this.init_seed(5489);
        for (kk = 0; kk < this.N - this.M; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
        }
        for (; kk < this.N - 1; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
        }
        y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
        this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
        this.mti = 0;
      }
      y = this.mt[this.mti++];
      y ^= y >>> 11;
      y ^= y << 7 & 2636928640;
      y ^= y << 15 & 4022730752;
      y ^= y >>> 18;
      return y >>> 0;
    };
    MersenneTwister4.prototype.random_int31 = function() {
      return this.random_int() >>> 1;
    };
    MersenneTwister4.prototype.random_incl = function() {
      return this.random_int() * (1 / 4294967295);
    };
    MersenneTwister4.prototype.random = function() {
      return this.random_int() * (1 / 4294967296);
    };
    MersenneTwister4.prototype.random_excl = function() {
      return (this.random_int() + 0.5) * (1 / 4294967296);
    };
    MersenneTwister4.prototype.random_long = function() {
      var a3 = this.random_int() >>> 5, b = this.random_int() >>> 6;
      return (a3 * 67108864 + b) * (1 / 9007199254740992);
    };
    module2.exports = MersenneTwister4;
  }
});

// node_modules/urijs/src/punycode.js
var require_punycode = __commonJS({
  "node_modules/urijs/src/punycode.js"(exports2, module2) {
    /*! https://mths.be/punycode v1.4.0 by @mathias */
    (function(root) {
      var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
      var freeModule = typeof module2 == "object" && module2 && !module2.nodeType && module2;
      var freeGlobal = typeof global == "object" && global;
      if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
      }
      var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, fn) {
        var length2 = array.length;
        var result = [];
        while (length2--) {
          result[length2] = fn(array[length2]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [], counter = 0, length2 = string.length, value, extra;
        while (counter < length2) {
          value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length2) {
            extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      function ucs2encode(array) {
        return map(array, function(value) {
          var output = "";
          if (value > 65535) {
            value -= 65536;
            output += stringFromCharCode(value >>> 10 & 1023 | 55296);
            value = 56320 | value & 1023;
          }
          output += stringFromCharCode(value);
          return output;
        }).join("");
      }
      function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      }
      function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      }
      function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      }
      function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          for (oldi = i, w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return ucs2encode(output);
      }
      function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          for (m = maxInt, j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue == n) {
              for (q = delta, k = base; ; k += base) {
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                qMinusT = q - t;
                baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      }
      function toUnicode(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      }
      function toASCII(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      }
      punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "1.3.2",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
          return punycode;
        });
      } else if (freeExports && freeModule) {
        if (module2.exports == freeExports) {
          freeModule.exports = punycode;
        } else {
          for (key in punycode) {
            punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
          }
        }
      } else {
        root.punycode = punycode;
      }
    })(exports2);
  }
});

// node_modules/urijs/src/IPv6.js
var require_IPv6 = __commonJS({
  "node_modules/urijs/src/IPv6.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     * IPv6 Support
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.IPv6 = factory(root);
      }
    })(exports2, function(root) {
      "use strict";
      var _IPv6 = root && root.IPv6;
      function bestPresentation(address) {
        var _address = address.toLowerCase();
        var segments = _address.split(":");
        var length2 = segments.length;
        var total = 8;
        if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
          segments.shift();
          segments.shift();
        } else if (segments[0] === "" && segments[1] === "") {
          segments.shift();
        } else if (segments[length2 - 1] === "" && segments[length2 - 2] === "") {
          segments.pop();
        }
        length2 = segments.length;
        if (segments[length2 - 1].indexOf(".") !== -1) {
          total = 7;
        }
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (segments[pos] === "") {
            break;
          }
        }
        if (pos < total) {
          segments.splice(pos, 1, "0000");
          while (segments.length < total) {
            segments.splice(pos, 0, "0000");
          }
        }
        var _segments;
        for (var i = 0; i < total; i++) {
          _segments = segments[i].split("");
          for (var j = 0; j < 3; j++) {
            if (_segments[0] === "0" && _segments.length > 1) {
              _segments.splice(0, 1);
            } else {
              break;
            }
          }
          segments[i] = _segments.join("");
        }
        var best = -1;
        var _best = 0;
        var _current = 0;
        var current = -1;
        var inzeroes = false;
        for (i = 0; i < total; i++) {
          if (inzeroes) {
            if (segments[i] === "0") {
              _current += 1;
            } else {
              inzeroes = false;
              if (_current > _best) {
                best = current;
                _best = _current;
              }
            }
          } else {
            if (segments[i] === "0") {
              inzeroes = true;
              current = i;
              _current = 1;
            }
          }
        }
        if (_current > _best) {
          best = current;
          _best = _current;
        }
        if (_best > 1) {
          segments.splice(best, _best, "");
        }
        length2 = segments.length;
        var result = "";
        if (segments[0] === "") {
          result = ":";
        }
        for (i = 0; i < length2; i++) {
          result += segments[i];
          if (i === length2 - 1) {
            break;
          }
          result += ":";
        }
        if (segments[length2 - 1] === "") {
          result += ":";
        }
        return result;
      }
      function noConflict() {
        if (root.IPv6 === this) {
          root.IPv6 = _IPv6;
        }
        return this;
      }
      return {
        best: bestPresentation,
        noConflict
      };
    });
  }
});

// node_modules/urijs/src/SecondLevelDomains.js
var require_SecondLevelDomains = __commonJS({
  "node_modules/urijs/src/SecondLevelDomains.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     * Second Level Domain (SLD) Support
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.SecondLevelDomains = factory(root);
      }
    })(exports2, function(root) {
      "use strict";
      var _SecondLevelDomains = root && root.SecondLevelDomains;
      var SLD = {
        // list of known Second Level Domains
        // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
        // ----
        // publicsuffix.org is more current and actually used by a couple of browsers internally.
        // downside is it also contains domains like "dyndns.org" - which is fine for the security
        // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
        // ----
        list: {
          "ac": " com gov mil net org ",
          "ae": " ac co gov mil name net org pro sch ",
          "af": " com edu gov net org ",
          "al": " com edu gov mil net org ",
          "ao": " co ed gv it og pb ",
          "ar": " com edu gob gov int mil net org tur ",
          "at": " ac co gv or ",
          "au": " asn com csiro edu gov id net org ",
          "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
          "bb": " biz co com edu gov info net org store tv ",
          "bh": " biz cc com edu gov info net org ",
          "bn": " com edu gov net org ",
          "bo": " com edu gob gov int mil net org tv ",
          "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
          "bs": " com edu gov net org ",
          "bz": " du et om ov rg ",
          "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
          "ck": " biz co edu gen gov info net org ",
          "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
          "co": " com edu gov mil net nom org ",
          "cr": " ac c co ed fi go or sa ",
          "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
          "do": " art com edu gob gov mil net org sld web ",
          "dz": " art asso com edu gov net org pol ",
          "ec": " com edu fin gov info med mil net org pro ",
          "eg": " com edu eun gov mil name net org sci ",
          "er": " com edu gov ind mil net org rochest w ",
          "es": " com edu gob nom org ",
          "et": " biz com edu gov info name net org ",
          "fj": " ac biz com info mil name net org pro ",
          "fk": " ac co gov net nom org ",
          "fr": " asso com f gouv nom prd presse tm ",
          "gg": " co net org ",
          "gh": " com edu gov mil org ",
          "gn": " ac com gov net org ",
          "gr": " com edu gov mil net org ",
          "gt": " com edu gob ind mil net org ",
          "gu": " com edu gov net org ",
          "hk": " com edu gov idv net org ",
          "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
          "id": " ac co go mil net or sch web ",
          "il": " ac co gov idf k12 muni net org ",
          "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
          "iq": " com edu gov i mil net org ",
          "ir": " ac co dnssec gov i id net org sch ",
          "it": " edu gov ",
          "je": " co net org ",
          "jo": " com edu gov mil name net org sch ",
          "jp": " ac ad co ed go gr lg ne or ",
          "ke": " ac co go info me mobi ne or sc ",
          "kh": " com edu gov mil net org per ",
          "ki": " biz com de edu gov info mob net org tel ",
          "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
          "kn": " edu gov net org ",
          "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
          "kw": " com edu gov net org ",
          "ky": " com edu gov net org ",
          "kz": " com edu gov mil net org ",
          "lb": " com edu gov net org ",
          "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
          "lr": " com edu gov net org ",
          "lv": " asn com conf edu gov id mil net org ",
          "ly": " com edu gov id med net org plc sch ",
          "ma": " ac co gov m net org press ",
          "mc": " asso tm ",
          "me": " ac co edu gov its net org priv ",
          "mg": " com edu gov mil nom org prd tm ",
          "mk": " com edu gov inf name net org pro ",
          "ml": " com edu gov net org presse ",
          "mn": " edu gov org ",
          "mo": " com edu gov net org ",
          "mt": " com edu gov net org ",
          "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
          "mw": " ac co com coop edu gov int museum net org ",
          "mx": " com edu gob net org ",
          "my": " com edu gov mil name net org sch ",
          "nf": " arts com firm info net other per rec store web ",
          "ng": " biz com edu gov mil mobi name net org sch ",
          "ni": " ac co com edu gob mil net nom org ",
          "np": " com edu gov mil net org ",
          "nr": " biz com edu gov info net org ",
          "om": " ac biz co com edu gov med mil museum net org pro sch ",
          "pe": " com edu gob mil net nom org sld ",
          "ph": " com edu gov i mil net ngo org ",
          "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
          "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
          "pr": " ac biz com edu est gov info isla name net org pro prof ",
          "ps": " com edu gov net org plo sec ",
          "pw": " belau co ed go ne or ",
          "ro": " arts com firm info nom nt org rec store tm www ",
          "rs": " ac co edu gov in org ",
          "sb": " com edu gov net org ",
          "sc": " com edu gov net org ",
          "sh": " co com edu gov net nom org ",
          "sl": " com edu gov net org ",
          "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
          "sv": " com edu gob org red ",
          "sz": " ac co org ",
          "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
          "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
          "tw": " club com ebiz edu game gov idv mil net org ",
          "mu": " ac co com gov net or org ",
          "mz": " ac co edu gov org ",
          "na": " co com ",
          "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
          "pa": " abo ac com edu gob ing med net nom org sld ",
          "pt": " com edu gov int net nome org publ ",
          "py": " com edu gov mil net org ",
          "qa": " com edu gov mil net org ",
          "re": " asso com nom ",
          "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
          "rw": " ac co com edu gouv gov int mil net ",
          "sa": " com edu gov med net org pub sch ",
          "sd": " com edu gov info med net org tv ",
          "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
          "sg": " com edu gov idn net org per ",
          "sn": " art com edu gouv org perso univ ",
          "sy": " com edu gov mil net news org ",
          "th": " ac co go in mi net or ",
          "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
          "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
          "tz": " ac co go ne or ",
          "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
          "ug": " ac co go ne or org sc ",
          "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
          "us": " dni fed isa kids nsn ",
          "uy": " com edu gub mil net org ",
          "ve": " co com edu gob info mil net org web ",
          "vi": " co com k12 net org ",
          "vn": " ac biz com edu gov health info int name net org pro ",
          "ye": " co com gov ltd me net org plc ",
          "yu": " ac co edu gov org ",
          "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
          "zm": " ac co com edu gov net org sch ",
          // https://en.wikipedia.org/wiki/CentralNic#Second-level_domains
          "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
          "net": "gb jp se uk ",
          "org": "ae",
          "de": "com "
        },
        // gorhill 2013-10-25: Using indexOf() instead Regexp(). Significant boost
        // in both performance and memory footprint. No initialization required.
        // http://jsperf.com/uri-js-sld-regex-vs-binary-search/4
        // Following methods use lastIndexOf() rather than array.split() in order
        // to avoid any memory allocations.
        has: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
        },
        is: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset >= 0) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
        },
        get: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return null;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return null;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return null;
          }
          if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
            return null;
          }
          return domain.slice(sldOffset + 1);
        },
        noConflict: function() {
          if (root.SecondLevelDomains === this) {
            root.SecondLevelDomains = _SecondLevelDomains;
          }
          return this;
        }
      };
      return SLD;
    });
  }
});

// node_modules/urijs/src/URI.js
var require_URI = __commonJS({
  "node_modules/urijs/src/URI.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
      } else if (typeof define === "function" && define.amd) {
        define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
      } else {
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      }
    })(exports2, function(punycode, IPv6, SLD, root) {
      "use strict";
      var _URI = root && root.URI;
      function URI(url2, base) {
        var _urlSupplied = arguments.length >= 1;
        var _baseSupplied = arguments.length >= 2;
        if (!(this instanceof URI)) {
          if (_urlSupplied) {
            if (_baseSupplied) {
              return new URI(url2, base);
            }
            return new URI(url2);
          }
          return new URI();
        }
        if (url2 === void 0) {
          if (_urlSupplied) {
            throw new TypeError("undefined is not a valid argument for URI");
          }
          if (typeof location !== "undefined") {
            url2 = location.href + "";
          } else {
            url2 = "";
          }
        }
        if (url2 === null) {
          if (_urlSupplied) {
            throw new TypeError("null is not a valid argument for URI");
          }
        }
        this.href(url2);
        if (base !== void 0) {
          return this.absoluteTo(base);
        }
        return this;
      }
      function isInteger(value) {
        return /^[0-9]+$/.test(value);
      }
      URI.version = "1.19.11";
      var p = URI.prototype;
      var hasOwn = Object.prototype.hasOwnProperty;
      function escapeRegEx(string) {
        return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
      }
      function getType(value) {
        if (value === void 0) {
          return "Undefined";
        }
        return String(Object.prototype.toString.call(value)).slice(8, -1);
      }
      function isArray(obj) {
        return getType(obj) === "Array";
      }
      function filterArrayValues(data, value) {
        var lookup = {};
        var i, length2;
        if (getType(value) === "RegExp") {
          lookup = null;
        } else if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            lookup[value[i]] = true;
          }
        } else {
          lookup[value] = true;
        }
        for (i = 0, length2 = data.length; i < length2; i++) {
          var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
          if (_match) {
            data.splice(i, 1);
            length2--;
            i--;
          }
        }
        return data;
      }
      function arrayContains(list, value) {
        var i, length2;
        if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            if (!arrayContains(list, value[i])) {
              return false;
            }
          }
          return true;
        }
        var _type = getType(value);
        for (i = 0, length2 = list.length; i < length2; i++) {
          if (_type === "RegExp") {
            if (typeof list[i] === "string" && list[i].match(value)) {
              return true;
            }
          } else if (list[i] === value) {
            return true;
          }
        }
        return false;
      }
      function arraysEqual(one, two) {
        if (!isArray(one) || !isArray(two)) {
          return false;
        }
        if (one.length !== two.length) {
          return false;
        }
        one.sort();
        two.sort();
        for (var i = 0, l = one.length; i < l; i++) {
          if (one[i] !== two[i]) {
            return false;
          }
        }
        return true;
      }
      function trimSlashes(text2) {
        var trim_expression = /^\/+|\/+$/g;
        return text2.replace(trim_expression, "");
      }
      URI._parts = function() {
        return {
          protocol: null,
          username: null,
          password: null,
          hostname: null,
          urn: null,
          port: null,
          path: null,
          query: null,
          fragment: null,
          // state
          preventInvalidHostname: URI.preventInvalidHostname,
          duplicateQueryParameters: URI.duplicateQueryParameters,
          escapeQuerySpace: URI.escapeQuerySpace
        };
      };
      URI.preventInvalidHostname = false;
      URI.duplicateQueryParameters = false;
      URI.escapeQuerySpace = true;
      URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
      URI.idn_expression = /[^a-z0-9\._-]/i;
      URI.punycode_expression = /(xn--)/i;
      URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
      URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
      URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
      URI.findUri = {
        // valid "scheme://" or "www."
        start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
        // everything up to the next whitespace
        end: /[\s\r\n]|$/,
        // trim trailing punctuation captured by end RegExp
        trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
        // balanced parens inclusion (), [], {}, <>
        parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
      };
      URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
      URI.defaultPorts = {
        http: "80",
        https: "443",
        ftp: "21",
        gopher: "70",
        ws: "80",
        wss: "443"
      };
      URI.hostProtocols = [
        "http",
        "https"
      ];
      URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
      URI.domAttributes = {
        "a": "href",
        "blockquote": "cite",
        "link": "href",
        "base": "href",
        "script": "src",
        "form": "action",
        "img": "src",
        "area": "href",
        "iframe": "src",
        "embed": "src",
        "source": "src",
        "track": "src",
        "input": "src",
        // but only if type="image"
        "audio": "src",
        "video": "src"
      };
      URI.getDomAttribute = function(node) {
        if (!node || !node.nodeName) {
          return void 0;
        }
        var nodeName = node.nodeName.toLowerCase();
        if (nodeName === "input" && node.type !== "image") {
          return void 0;
        }
        return URI.domAttributes[nodeName];
      };
      function escapeForDumbFirefox36(value) {
        return escape(value);
      }
      function strictEncodeURIComponent(string) {
        return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
      }
      URI.encode = strictEncodeURIComponent;
      URI.decode = decodeURIComponent;
      URI.iso8859 = function() {
        URI.encode = escape;
        URI.decode = unescape;
      };
      URI.unicode = function() {
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
      };
      URI.characters = {
        pathname: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
              // -._~!'()*
              "%24": "$",
              "%26": "&",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%3A": ":",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23"
            }
          }
        },
        reserved: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
              // gen-delims
              "%3A": ":",
              "%2F": "/",
              "%3F": "?",
              "%23": "#",
              "%5B": "[",
              "%5D": "]",
              "%40": "@",
              // sub-delims
              "%21": "!",
              "%24": "$",
              "%26": "&",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "="
            }
          }
        },
        urnpath: {
          // The characters under `encode` are the characters called out by RFC 2141 as being acceptable
          // for usage in a URN. RFC2141 also calls out "-", ".", and "_" as acceptable characters, but
          // these aren't encoded by encodeURIComponent, so we don't have to call them out here. Also
          // note that the colon character is not featured in the encoding map; this is because URI.js
          // gives the colons in URNs semantic meaning as the delimiters of path segements, and so it
          // should not appear unencoded in a segment itself.
          // See also the note above about RFC3986 and capitalalized hex digits.
          encode: {
            expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
            map: {
              "%21": "!",
              "%24": "$",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%40": "@"
            }
          },
          // These characters are the characters called out by RFC2141 as "reserved" characters that
          // should never appear in a URN, plus the colon character (see note above).
          decode: {
            expression: /[\/\?#:]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23",
              ":": "%3A"
            }
          }
        }
      };
      URI.encodeQuery = function(string, escapeQuerySpace) {
        var escaped = URI.encode(string + "");
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
      };
      URI.decodeQuery = function(string, escapeQuerySpace) {
        string += "";
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        try {
          return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
        } catch (e) {
          return string;
        }
      };
      var _parts = { "encode": "encode", "decode": "decode" };
      var _part;
      var generateAccessor = function(_group, _part2) {
        return function(string) {
          try {
            return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
              return URI.characters[_group][_part2].map[c];
            });
          } catch (e) {
            return string;
          }
        };
      };
      for (_part in _parts) {
        URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
        URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
      }
      var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
        return function(string) {
          var actualCodingFunc;
          if (!_innerCodingFuncName) {
            actualCodingFunc = URI[_codingFuncName];
          } else {
            actualCodingFunc = function(string2) {
              return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
            };
          }
          var segments = (string + "").split(_sep);
          for (var i = 0, length2 = segments.length; i < length2; i++) {
            segments[i] = actualCodingFunc(segments[i]);
          }
          return segments.join(_sep);
        };
      };
      URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
      URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
      URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
      URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
      URI.encodeReserved = generateAccessor("reserved", "encode");
      URI.parse = function(string, parts) {
        var pos;
        if (!parts) {
          parts = {
            preventInvalidHostname: URI.preventInvalidHostname
          };
        }
        string = string.replace(URI.leading_whitespace_expression, "");
        string = string.replace(URI.ascii_tab_whitespace, "");
        pos = string.indexOf("#");
        if (pos > -1) {
          parts.fragment = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        pos = string.indexOf("?");
        if (pos > -1) {
          parts.query = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
        string = string.replace(/^[/\\]{2,}/i, "//");
        if (string.substring(0, 2) === "//") {
          parts.protocol = null;
          string = string.substring(2);
          string = URI.parseAuthority(string, parts);
        } else {
          pos = string.indexOf(":");
          if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
              parts.protocol = void 0;
            } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
              string = string.substring(pos + 3);
              string = URI.parseAuthority(string, parts);
            } else {
              string = string.substring(pos + 1);
              parts.urn = true;
            }
          }
        }
        parts.path = string;
        return parts;
      };
      URI.parseHost = function(string, parts) {
        if (!string) {
          string = "";
        }
        string = string.replace(/\\/g, "/");
        var pos = string.indexOf("/");
        var bracketPos;
        var t;
        if (pos === -1) {
          pos = string.length;
        }
        if (string.charAt(0) === "[") {
          bracketPos = string.indexOf("]");
          parts.hostname = string.substring(1, bracketPos) || null;
          parts.port = string.substring(bracketPos + 2, pos) || null;
          if (parts.port === "/") {
            parts.port = null;
          }
        } else {
          var firstColon = string.indexOf(":");
          var firstSlash = string.indexOf("/");
          var nextColon = string.indexOf(":", firstColon + 1);
          if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
            parts.hostname = string.substring(0, pos) || null;
            parts.port = null;
          } else {
            t = string.substring(0, pos).split(":");
            parts.hostname = t[0] || null;
            parts.port = t[1] || null;
          }
        }
        if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
          pos++;
          string = "/" + string;
        }
        if (parts.preventInvalidHostname) {
          URI.ensureValidHostname(parts.hostname, parts.protocol);
        }
        if (parts.port) {
          URI.ensureValidPort(parts.port);
        }
        return string.substring(pos) || "/";
      };
      URI.parseAuthority = function(string, parts) {
        string = URI.parseUserinfo(string, parts);
        return URI.parseHost(string, parts);
      };
      URI.parseUserinfo = function(string, parts) {
        var _string = string;
        var firstBackSlash = string.indexOf("\\");
        if (firstBackSlash !== -1) {
          string = string.replace(/\\/g, "/");
        }
        var firstSlash = string.indexOf("/");
        var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
        var t;
        if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
          t = string.substring(0, pos).split(":");
          parts.username = t[0] ? URI.decode(t[0]) : null;
          t.shift();
          parts.password = t[0] ? URI.decode(t.join(":")) : null;
          string = _string.substring(pos + 1);
        } else {
          parts.username = null;
          parts.password = null;
        }
        return string;
      };
      URI.parseQuery = function(string, escapeQuerySpace) {
        if (!string) {
          return {};
        }
        string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
        if (!string) {
          return {};
        }
        var items = {};
        var splits = string.split("&");
        var length2 = splits.length;
        var v3, name, value;
        for (var i = 0; i < length2; i++) {
          v3 = splits[i].split("=");
          name = URI.decodeQuery(v3.shift(), escapeQuerySpace);
          value = v3.length ? URI.decodeQuery(v3.join("="), escapeQuerySpace) : null;
          if (name === "__proto__") {
            continue;
          } else if (hasOwn.call(items, name)) {
            if (typeof items[name] === "string" || items[name] === null) {
              items[name] = [items[name]];
            }
            items[name].push(value);
          } else {
            items[name] = value;
          }
        }
        return items;
      };
      URI.build = function(parts) {
        var t = "";
        var requireAbsolutePath = false;
        if (parts.protocol) {
          t += parts.protocol + ":";
        }
        if (!parts.urn && (t || parts.hostname)) {
          t += "//";
          requireAbsolutePath = true;
        }
        t += URI.buildAuthority(parts) || "";
        if (typeof parts.path === "string") {
          if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
            t += "/";
          }
          t += parts.path;
        }
        if (typeof parts.query === "string" && parts.query) {
          t += "?" + parts.query;
        }
        if (typeof parts.fragment === "string" && parts.fragment) {
          t += "#" + parts.fragment;
        }
        return t;
      };
      URI.buildHost = function(parts) {
        var t = "";
        if (!parts.hostname) {
          return "";
        } else if (URI.ip6_expression.test(parts.hostname)) {
          t += "[" + parts.hostname + "]";
        } else {
          t += parts.hostname;
        }
        if (parts.port) {
          t += ":" + parts.port;
        }
        return t;
      };
      URI.buildAuthority = function(parts) {
        return URI.buildUserinfo(parts) + URI.buildHost(parts);
      };
      URI.buildUserinfo = function(parts) {
        var t = "";
        if (parts.username) {
          t += URI.encode(parts.username);
        }
        if (parts.password) {
          t += ":" + URI.encode(parts.password);
        }
        if (t) {
          t += "@";
        }
        return t;
      };
      URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
        var t = "";
        var unique, key, i, length2;
        for (key in data) {
          if (key === "__proto__") {
            continue;
          } else if (hasOwn.call(data, key)) {
            if (isArray(data[key])) {
              unique = {};
              for (i = 0, length2 = data[key].length; i < length2; i++) {
                if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                  t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                  if (duplicateQueryParameters !== true) {
                    unique[data[key][i] + ""] = true;
                  }
                }
              }
            } else if (data[key] !== void 0) {
              t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
          }
        }
        return t.substring(1);
      };
      URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
        return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
      };
      URI.addQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.addQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (data[name] === void 0) {
            data[name] = value;
            return;
          } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
          }
          if (!isArray(value)) {
            value = [value];
          }
          data[name] = (data[name] || []).concat(value);
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
      };
      URI.setQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.setQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          data[name] = value === void 0 ? null : value;
        } else {
          throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
        }
      };
      URI.removeQuery = function(data, name, value) {
        var i, length2, key;
        if (isArray(name)) {
          for (i = 0, length2 = name.length; i < length2; i++) {
            data[name[i]] = void 0;
          }
        } else if (getType(name) === "RegExp") {
          for (key in data) {
            if (name.test(key)) {
              data[key] = void 0;
            }
          }
        } else if (typeof name === "object") {
          for (key in name) {
            if (hasOwn.call(name, key)) {
              URI.removeQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (value !== void 0) {
            if (getType(value) === "RegExp") {
              if (!isArray(data[name]) && value.test(data[name])) {
                data[name] = void 0;
              } else {
                data[name] = filterArrayValues(data[name], value);
              }
            } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
              data[name] = void 0;
            } else if (isArray(data[name])) {
              data[name] = filterArrayValues(data[name], value);
            }
          } else {
            data[name] = void 0;
          }
        } else {
          throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
        }
      };
      URI.hasQuery = function(data, name, value, withinArray) {
        switch (getType(name)) {
          case "String":
            break;
          case "RegExp":
            for (var key in data) {
              if (hasOwn.call(data, key)) {
                if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                  return true;
                }
              }
            }
            return false;
          case "Object":
            for (var _key in name) {
              if (hasOwn.call(name, _key)) {
                if (!URI.hasQuery(data, _key, name[_key])) {
                  return false;
                }
              }
            }
            return true;
          default:
            throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
        }
        switch (getType(value)) {
          case "Undefined":
            return name in data;
          // data[name] !== undefined;
          case "Boolean":
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;
          case "Function":
            return !!value(data[name], name, data);
          case "Array":
            if (!isArray(data[name])) {
              return false;
            }
            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);
          case "RegExp":
            if (!isArray(data[name])) {
              return Boolean(data[name] && data[name].match(value));
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          case "Number":
            value = String(value);
          /* falls through */
          case "String":
            if (!isArray(data[name])) {
              return data[name] === value;
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
        }
      };
      URI.joinPaths = function() {
        var input = [];
        var segments = [];
        var nonEmptySegments = 0;
        for (var i = 0; i < arguments.length; i++) {
          var url2 = new URI(arguments[i]);
          input.push(url2);
          var _segments = url2.segment();
          for (var s = 0; s < _segments.length; s++) {
            if (typeof _segments[s] === "string") {
              segments.push(_segments[s]);
            }
            if (_segments[s]) {
              nonEmptySegments++;
            }
          }
        }
        if (!segments.length || !nonEmptySegments) {
          return new URI("");
        }
        var uri = new URI("").segment(segments);
        if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
          uri.path("/" + uri.path());
        }
        return uri.normalize();
      };
      URI.commonPath = function(one, two) {
        var length2 = Math.min(one.length, two.length);
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
          }
        }
        if (pos < 1) {
          return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
        }
        if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
          pos = one.substring(0, pos).lastIndexOf("/");
        }
        return one.substring(0, pos + 1);
      };
      URI.withinString = function(string, callback, options) {
        options || (options = {});
        var _start = options.start || URI.findUri.start;
        var _end = options.end || URI.findUri.end;
        var _trim = options.trim || URI.findUri.trim;
        var _parens = options.parens || URI.findUri.parens;
        var _attributeOpen = /[a-z0-9-]=["']?$/i;
        _start.lastIndex = 0;
        while (true) {
          var match = _start.exec(string);
          if (!match) {
            break;
          }
          var start = match.index;
          if (options.ignoreHtml) {
            var attributeOpen = string.slice(Math.max(start - 3, 0), start);
            if (attributeOpen && _attributeOpen.test(attributeOpen)) {
              continue;
            }
          }
          var end = start + string.slice(start).search(_end);
          var slice = string.slice(start, end);
          var parensEnd = -1;
          while (true) {
            var parensMatch = _parens.exec(slice);
            if (!parensMatch) {
              break;
            }
            var parensMatchEnd = parensMatch.index + parensMatch[0].length;
            parensEnd = Math.max(parensEnd, parensMatchEnd);
          }
          if (parensEnd > -1) {
            slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
          } else {
            slice = slice.replace(_trim, "");
          }
          if (slice.length <= match[0].length) {
            continue;
          }
          if (options.ignore && options.ignore.test(slice)) {
            continue;
          }
          end = start + slice.length;
          var result = callback(slice, start, end, string);
          if (result === void 0) {
            _start.lastIndex = end;
            continue;
          }
          result = String(result);
          string = string.slice(0, start) + result + string.slice(end);
          _start.lastIndex = start + result.length;
        }
        _start.lastIndex = 0;
        return string;
      };
      URI.ensureValidHostname = function(v3, protocol) {
        var hasHostname = !!v3;
        var hasProtocol = !!protocol;
        var rejectEmptyHostname = false;
        if (hasProtocol) {
          rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
        }
        if (rejectEmptyHostname && !hasHostname) {
          throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
        } else if (v3 && v3.match(URI.invalid_hostname_characters)) {
          if (!punycode) {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
          }
          if (punycode.toASCII(v3).match(URI.invalid_hostname_characters)) {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-:_]');
          }
        }
      };
      URI.ensureValidPort = function(v3) {
        if (!v3) {
          return;
        }
        var port = Number(v3);
        if (isInteger(port) && port > 0 && port < 65536) {
          return;
        }
        throw new TypeError('Port "' + v3 + '" is not a valid port');
      };
      URI.noConflict = function(removeAll2) {
        if (removeAll2) {
          var unconflicted = {
            URI: this.noConflict()
          };
          if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
            unconflicted.URITemplate = root.URITemplate.noConflict();
          }
          if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
            unconflicted.IPv6 = root.IPv6.noConflict();
          }
          if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
            unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
          }
          return unconflicted;
        } else if (root.URI === this) {
          root.URI = _URI;
        }
        return this;
      };
      p.build = function(deferBuild) {
        if (deferBuild === true) {
          this._deferred_build = true;
        } else if (deferBuild === void 0 || this._deferred_build) {
          this._string = URI.build(this._parts);
          this._deferred_build = false;
        }
        return this;
      };
      p.clone = function() {
        return new URI(this);
      };
      p.valueOf = p.toString = function() {
        return this.build(false)._string;
      };
      function generateSimpleAccessor(_part2) {
        return function(v3, build) {
          if (v3 === void 0) {
            return this._parts[_part2] || "";
          } else {
            this._parts[_part2] = v3 || null;
            this.build(!build);
            return this;
          }
        };
      }
      function generatePrefixAccessor(_part2, _key) {
        return function(v3, build) {
          if (v3 === void 0) {
            return this._parts[_part2] || "";
          } else {
            if (v3 !== null) {
              v3 = v3 + "";
              if (v3.charAt(0) === _key) {
                v3 = v3.substring(1);
              }
            }
            this._parts[_part2] = v3;
            this.build(!build);
            return this;
          }
        };
      }
      p.protocol = generateSimpleAccessor("protocol");
      p.username = generateSimpleAccessor("username");
      p.password = generateSimpleAccessor("password");
      p.hostname = generateSimpleAccessor("hostname");
      p.port = generateSimpleAccessor("port");
      p.query = generatePrefixAccessor("query", "?");
      p.fragment = generatePrefixAccessor("fragment", "#");
      p.search = function(v3, build) {
        var t = this.query(v3, build);
        return typeof t === "string" && t.length ? "?" + t : t;
      };
      p.hash = function(v3, build) {
        var t = this.fragment(v3, build);
        return typeof t === "string" && t.length ? "#" + t : t;
      };
      p.pathname = function(v3, build) {
        if (v3 === void 0 || v3 === true) {
          var res = this._parts.path || (this._parts.hostname ? "/" : "");
          return v3 ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
        } else {
          if (this._parts.urn) {
            this._parts.path = v3 ? URI.recodeUrnPath(v3) : "";
          } else {
            this._parts.path = v3 ? URI.recodePath(v3) : "/";
          }
          this.build(!build);
          return this;
        }
      };
      p.path = p.pathname;
      p.href = function(href, build) {
        var key;
        if (href === void 0) {
          return this.toString();
        }
        this._string = "";
        this._parts = URI._parts();
        var _URI2 = href instanceof URI;
        var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
        if (href.nodeName) {
          var attribute = URI.getDomAttribute(href);
          href = href[attribute] || "";
          _object = false;
        }
        if (!_URI2 && _object && href.pathname !== void 0) {
          href = href.toString();
        }
        if (typeof href === "string" || href instanceof String) {
          this._parts = URI.parse(String(href), this._parts);
        } else if (_URI2 || _object) {
          var src = _URI2 ? href._parts : href;
          for (key in src) {
            if (key === "query") {
              continue;
            }
            if (hasOwn.call(this._parts, key)) {
              this._parts[key] = src[key];
            }
          }
          if (src.query) {
            this.query(src.query, false);
          }
        } else {
          throw new TypeError("invalid input");
        }
        this.build(!build);
        return this;
      };
      p.is = function(what) {
        var ip = false;
        var ip4 = false;
        var ip6 = false;
        var name = false;
        var sld = false;
        var idn = false;
        var punycode2 = false;
        var relative = !this._parts.urn;
        if (this._parts.hostname) {
          relative = false;
          ip4 = URI.ip4_expression.test(this._parts.hostname);
          ip6 = URI.ip6_expression.test(this._parts.hostname);
          ip = ip4 || ip6;
          name = !ip;
          sld = name && SLD && SLD.has(this._parts.hostname);
          idn = name && URI.idn_expression.test(this._parts.hostname);
          punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
        }
        switch (what.toLowerCase()) {
          case "relative":
            return relative;
          case "absolute":
            return !relative;
          // hostname identification
          case "domain":
          case "name":
            return name;
          case "sld":
            return sld;
          case "ip":
            return ip;
          case "ip4":
          case "ipv4":
          case "inet4":
            return ip4;
          case "ip6":
          case "ipv6":
          case "inet6":
            return ip6;
          case "idn":
            return idn;
          case "url":
            return !this._parts.urn;
          case "urn":
            return !!this._parts.urn;
          case "punycode":
            return punycode2;
        }
        return null;
      };
      var _protocol = p.protocol;
      var _port = p.port;
      var _hostname = p.hostname;
      p.protocol = function(v3, build) {
        if (v3) {
          v3 = v3.replace(/:(\/\/)?$/, "");
          if (!v3.match(URI.protocol_expression)) {
            throw new TypeError('Protocol "' + v3 + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
          }
        }
        return _protocol.call(this, v3, build);
      };
      p.scheme = p.protocol;
      p.port = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 !== void 0) {
          if (v3 === 0) {
            v3 = null;
          }
          if (v3) {
            v3 += "";
            if (v3.charAt(0) === ":") {
              v3 = v3.substring(1);
            }
            URI.ensureValidPort(v3);
          }
        }
        return _port.call(this, v3, build);
      };
      p.hostname = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 !== void 0) {
          var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
          var res = URI.parseHost(v3, x);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-]');
          }
          v3 = x.hostname;
          if (this._parts.preventInvalidHostname) {
            URI.ensureValidHostname(v3, this._parts.protocol);
          }
        }
        return _hostname.call(this, v3, build);
      };
      p.origin = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          var protocol = this.protocol();
          var authority = this.authority();
          if (!authority) {
            return "";
          }
          return (protocol ? protocol + "://" : "") + this.authority();
        } else {
          var origin = URI(v3);
          this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
          return this;
        }
      };
      p.host = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          return this._parts.hostname ? URI.buildHost(this._parts) : "";
        } else {
          var res = URI.parseHost(v3, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.authority = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
        } else {
          var res = URI.parseAuthority(v3, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.userinfo = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          var t = URI.buildUserinfo(this._parts);
          return t ? t.substring(0, t.length - 1) : t;
        } else {
          if (v3[v3.length - 1] !== "@") {
            v3 += "@";
          }
          URI.parseUserinfo(v3, this._parts);
          this.build(!build);
          return this;
        }
      };
      p.resource = function(v3, build) {
        var parts;
        if (v3 === void 0) {
          return this.path() + this.search() + this.hash();
        }
        parts = URI.parse(v3);
        this._parts.path = parts.path;
        this._parts.query = parts.query;
        this._parts.fragment = parts.fragment;
        this.build(!build);
        return this;
      };
      p.subdomain = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var end = this._parts.hostname.length - this.domain().length - 1;
          return this._parts.hostname.substring(0, end) || "";
        } else {
          var e = this._parts.hostname.length - this.domain().length;
          var sub = this._parts.hostname.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(sub));
          if (v3 && v3.charAt(v3.length - 1) !== ".") {
            v3 += ".";
          }
          if (v3.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          if (v3) {
            URI.ensureValidHostname(v3, this._parts.protocol);
          }
          this._parts.hostname = this._parts.hostname.replace(replace, v3);
          this.build(!build);
          return this;
        }
      };
      p.domain = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (typeof v3 === "boolean") {
          build = v3;
          v3 = void 0;
        }
        if (v3 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var t = this._parts.hostname.match(/\./g);
          if (t && t.length < 2) {
            return this._parts.hostname;
          }
          var end = this._parts.hostname.length - this.tld(build).length - 1;
          end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
          return this._parts.hostname.substring(end) || "";
        } else {
          if (!v3) {
            throw new TypeError("cannot set domain empty");
          }
          if (v3.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          URI.ensureValidHostname(v3, this._parts.protocol);
          if (!this._parts.hostname || this.is("IP")) {
            this._parts.hostname = v3;
          } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v3);
          }
          this.build(!build);
          return this;
        }
      };
      p.tld = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (typeof v3 === "boolean") {
          build = v3;
          v3 = void 0;
        }
        if (v3 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var pos = this._parts.hostname.lastIndexOf(".");
          var tld = this._parts.hostname.substring(pos + 1);
          if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
          }
          return tld;
        } else {
          var replace;
          if (!v3) {
            throw new TypeError("cannot set TLD empty");
          } else if (v3.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v3)) {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v3);
            } else {
              throw new TypeError('TLD "' + v3 + '" contains characters other than [A-Z0-9]');
            }
          } else if (!this._parts.hostname || this.is("IP")) {
            throw new ReferenceError("cannot set TLD on non-domain host");
          } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v3);
          }
          this.build(!build);
          return this;
        }
      };
      p.directory = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0 || v3 === true) {
          if (!this._parts.path && !this._parts.hostname) {
            return "";
          }
          if (this._parts.path === "/") {
            return "/";
          }
          var end = this._parts.path.length - this.filename().length - 1;
          var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
          return v3 ? URI.decodePath(res) : res;
        } else {
          var e = this._parts.path.length - this.filename().length;
          var directory = this._parts.path.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(directory));
          if (!this.is("relative")) {
            if (!v3) {
              v3 = "/";
            }
            if (v3.charAt(0) !== "/") {
              v3 = "/" + v3;
            }
          }
          if (v3 && v3.charAt(v3.length - 1) !== "/") {
            v3 += "/";
          }
          v3 = URI.recodePath(v3);
          this._parts.path = this._parts.path.replace(replace, v3);
          this.build(!build);
          return this;
        }
      };
      p.filename = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (typeof v3 !== "string") {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var pos = this._parts.path.lastIndexOf("/");
          var res = this._parts.path.substring(pos + 1);
          return v3 ? URI.decodePathSegment(res) : res;
        } else {
          var mutatedDirectory = false;
          if (v3.charAt(0) === "/") {
            v3 = v3.substring(1);
          }
          if (v3.match(/\.?\//)) {
            mutatedDirectory = true;
          }
          var replace = new RegExp(escapeRegEx(this.filename()) + "$");
          v3 = URI.recodePath(v3);
          this._parts.path = this._parts.path.replace(replace, v3);
          if (mutatedDirectory) {
            this.normalizePath(build);
          } else {
            this.build(!build);
          }
          return this;
        }
      };
      p.suffix = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0 || v3 === true) {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var filename = this.filename();
          var pos = filename.lastIndexOf(".");
          var s, res;
          if (pos === -1) {
            return "";
          }
          s = filename.substring(pos + 1);
          res = /^[a-z0-9%]+$/i.test(s) ? s : "";
          return v3 ? URI.decodePathSegment(res) : res;
        } else {
          if (v3.charAt(0) === ".") {
            v3 = v3.substring(1);
          }
          var suffix = this.suffix();
          var replace;
          if (!suffix) {
            if (!v3) {
              return this;
            }
            this._parts.path += "." + URI.recodePath(v3);
          } else if (!v3) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
          } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
          }
          if (replace) {
            v3 = URI.recodePath(v3);
            this._parts.path = this._parts.path.replace(replace, v3);
          }
          this.build(!build);
          return this;
        }
      };
      p.segment = function(segment, v3, build) {
        var separator = this._parts.urn ? ":" : "/";
        var path = this.path();
        var absolute = path.substring(0, 1) === "/";
        var segments = path.split(separator);
        if (segment !== void 0 && typeof segment !== "number") {
          build = v3;
          v3 = segment;
          segment = void 0;
        }
        if (segment !== void 0 && typeof segment !== "number") {
          throw new Error('Bad segment "' + segment + '", must be 0-based integer');
        }
        if (absolute) {
          segments.shift();
        }
        if (segment < 0) {
          segment = Math.max(segments.length + segment, 0);
        }
        if (v3 === void 0) {
          return segment === void 0 ? segments : segments[segment];
        } else if (segment === null || segments[segment] === void 0) {
          if (isArray(v3)) {
            segments = [];
            for (var i = 0, l = v3.length; i < l; i++) {
              if (!v3[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                continue;
              }
              if (segments.length && !segments[segments.length - 1].length) {
                segments.pop();
              }
              segments.push(trimSlashes(v3[i]));
            }
          } else if (v3 || typeof v3 === "string") {
            v3 = trimSlashes(v3);
            if (segments[segments.length - 1] === "") {
              segments[segments.length - 1] = v3;
            } else {
              segments.push(v3);
            }
          }
        } else {
          if (v3) {
            segments[segment] = trimSlashes(v3);
          } else {
            segments.splice(segment, 1);
          }
        }
        if (absolute) {
          segments.unshift("");
        }
        return this.path(segments.join(separator), build);
      };
      p.segmentCoded = function(segment, v3, build) {
        var segments, i, l;
        if (typeof segment !== "number") {
          build = v3;
          v3 = segment;
          segment = void 0;
        }
        if (v3 === void 0) {
          segments = this.segment(segment, v3, build);
          if (!isArray(segments)) {
            segments = segments !== void 0 ? URI.decode(segments) : void 0;
          } else {
            for (i = 0, l = segments.length; i < l; i++) {
              segments[i] = URI.decode(segments[i]);
            }
          }
          return segments;
        }
        if (!isArray(v3)) {
          v3 = typeof v3 === "string" || v3 instanceof String ? URI.encode(v3) : v3;
        } else {
          for (i = 0, l = v3.length; i < l; i++) {
            v3[i] = URI.encode(v3[i]);
          }
        }
        return this.segment(segment, v3, build);
      };
      var q = p.query;
      p.query = function(v3, build) {
        if (v3 === true) {
          return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        } else if (typeof v3 === "function") {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          var result = v3.call(this, data);
          this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else if (v3 !== void 0 && typeof v3 !== "string") {
          this._parts.query = URI.buildQuery(v3, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else {
          return q.call(this, v3, build);
        }
      };
      p.setQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        if (typeof name === "string" || name instanceof String) {
          data[name] = value !== void 0 ? value : null;
        } else if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              data[key] = name[key];
            }
          }
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.addQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.addQuery(data, name, value === void 0 ? null : value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.removeQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.removeQuery(data, name, value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.hasQuery = function(name, value, withinArray) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        return URI.hasQuery(data, name, value, withinArray);
      };
      p.setSearch = p.setQuery;
      p.addSearch = p.addQuery;
      p.removeSearch = p.removeQuery;
      p.hasSearch = p.hasQuery;
      p.normalize = function() {
        if (this._parts.urn) {
          return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        }
        return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
      };
      p.normalizeProtocol = function(build) {
        if (typeof this._parts.protocol === "string") {
          this._parts.protocol = this._parts.protocol.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizeHostname = function(build) {
        if (this._parts.hostname) {
          if (this.is("IDN") && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
          } else if (this.is("IPv6") && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
          }
          this._parts.hostname = this._parts.hostname.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizePort = function(build) {
        if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
          this._parts.port = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizePath = function(build) {
        var _path = this._parts.path;
        if (!_path) {
          return this;
        }
        if (this._parts.urn) {
          this._parts.path = URI.recodeUrnPath(this._parts.path);
          this.build(!build);
          return this;
        }
        if (this._parts.path === "/") {
          return this;
        }
        _path = URI.recodePath(_path);
        var _was_relative;
        var _leadingParents = "";
        var _parent, _pos;
        if (_path.charAt(0) !== "/") {
          _was_relative = true;
          _path = "/" + _path;
        }
        if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
          _path += "/";
        }
        _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
        if (_was_relative) {
          _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
          if (_leadingParents) {
            _leadingParents = _leadingParents[0];
          }
        }
        while (true) {
          _parent = _path.search(/\/\.\.(\/|$)/);
          if (_parent === -1) {
            break;
          } else if (_parent === 0) {
            _path = _path.substring(3);
            continue;
          }
          _pos = _path.substring(0, _parent).lastIndexOf("/");
          if (_pos === -1) {
            _pos = _parent;
          }
          _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
        }
        if (_was_relative && this.is("relative")) {
          _path = _leadingParents + _path.substring(1);
        }
        this._parts.path = _path;
        this.build(!build);
        return this;
      };
      p.normalizePathname = p.normalizePath;
      p.normalizeQuery = function(build) {
        if (typeof this._parts.query === "string") {
          if (!this._parts.query.length) {
            this._parts.query = null;
          } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
          }
          this.build(!build);
        }
        return this;
      };
      p.normalizeFragment = function(build) {
        if (!this._parts.fragment) {
          this._parts.fragment = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizeSearch = p.normalizeQuery;
      p.normalizeHash = p.normalizeFragment;
      p.iso8859 = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = escape;
        URI.decode = decodeURIComponent;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.unicode = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = strictEncodeURIComponent;
        URI.decode = unescape;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.readable = function() {
        var uri = this.clone();
        uri.username("").password("").normalize();
        var t = "";
        if (uri._parts.protocol) {
          t += uri._parts.protocol + "://";
        }
        if (uri._parts.hostname) {
          if (uri.is("punycode") && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
              t += ":" + uri._parts.port;
            }
          } else {
            t += uri.host();
          }
        }
        if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
          t += "/";
        }
        t += uri.path(true);
        if (uri._parts.query) {
          var q3 = "";
          for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split("=");
            q3 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            if (kv[1] !== void 0) {
              q3 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            }
          }
          t += "?" + q3.substring(1);
        }
        t += URI.decodeQuery(uri.hash(), true);
        return t;
      };
      p.absoluteTo = function(base) {
        var resolved = this.clone();
        var properties = ["protocol", "username", "password", "hostname", "port"];
        var basedir, i, p2;
        if (this._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        if (!(base instanceof URI)) {
          base = new URI(base);
        }
        if (resolved._parts.protocol) {
          return resolved;
        } else {
          resolved._parts.protocol = base._parts.protocol;
        }
        if (this._parts.hostname) {
          return resolved;
        }
        for (i = 0; p2 = properties[i]; i++) {
          resolved._parts[p2] = base._parts[p2];
        }
        if (!resolved._parts.path) {
          resolved._parts.path = base._parts.path;
          if (!resolved._parts.query) {
            resolved._parts.query = base._parts.query;
          }
        } else {
          if (resolved._parts.path.substring(-2) === "..") {
            resolved._parts.path += "/";
          }
          if (resolved.path().charAt(0) !== "/") {
            basedir = base.directory();
            basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
            resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
            resolved.normalizePath();
          }
        }
        resolved.build();
        return resolved;
      };
      p.relativeTo = function(base) {
        var relative = this.clone().normalize();
        var relativeParts, baseParts, common, relativePath, basePath;
        if (relative._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        base = new URI(base).normalize();
        relativeParts = relative._parts;
        baseParts = base._parts;
        relativePath = relative.path();
        basePath = base.path();
        if (relativePath.charAt(0) !== "/") {
          throw new Error("URI is already relative");
        }
        if (basePath.charAt(0) !== "/") {
          throw new Error("Cannot calculate a URI relative to another relative URI");
        }
        if (relativeParts.protocol === baseParts.protocol) {
          relativeParts.protocol = null;
        }
        if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
          return relative.build();
        }
        if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
          return relative.build();
        }
        if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
          relativeParts.hostname = null;
          relativeParts.port = null;
        } else {
          return relative.build();
        }
        if (relativePath === basePath) {
          relativeParts.path = "";
          return relative.build();
        }
        common = URI.commonPath(relativePath, basePath);
        if (!common) {
          return relative.build();
        }
        var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
        relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
        return relative.build();
      };
      p.equals = function(uri) {
        var one = this.clone();
        var two = new URI(uri);
        var one_map = {};
        var two_map = {};
        var checked = {};
        var one_query, two_query, key;
        one.normalize();
        two.normalize();
        if (one.toString() === two.toString()) {
          return true;
        }
        one_query = one.query();
        two_query = two.query();
        one.query("");
        two.query("");
        if (one.toString() !== two.toString()) {
          return false;
        }
        if (one_query.length !== two_query.length) {
          return false;
        }
        one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
        two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
        for (key in one_map) {
          if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
              if (one_map[key] !== two_map[key]) {
                return false;
              }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
              return false;
            }
            checked[key] = true;
          }
        }
        for (key in two_map) {
          if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
              return false;
            }
          }
        }
        return true;
      };
      p.preventInvalidHostname = function(v3) {
        this._parts.preventInvalidHostname = !!v3;
        return this;
      };
      p.duplicateQueryParameters = function(v3) {
        this._parts.duplicateQueryParameters = !!v3;
        return this;
      };
      p.escapeQuerySpace = function(v3) {
        this._parts.escapeQuerySpace = !!v3;
        return this;
      };
      return URI;
    });
  }
});

// node_modules/bitmap-sdf/index.js
var require_bitmap_sdf = __commonJS({
  "node_modules/bitmap-sdf/index.js"(exports2, module2) {
    "use strict";
    module2.exports = calcSDF;
    var INF = 1e20;
    function calcSDF(src, options) {
      if (!options) options = {};
      var cutoff = options.cutoff == null ? 0.25 : options.cutoff;
      var radius = options.radius == null ? 8 : options.radius;
      var channel = options.channel || 0;
      var w, h, size, data, intData, stride, ctx, canvas, imgData, i, l;
      if (ArrayBuffer.isView(src) || Array.isArray(src)) {
        if (!options.width || !options.height) throw Error("For raw data width and height should be provided by options");
        w = options.width, h = options.height;
        data = src;
        if (!options.stride) stride = Math.floor(src.length / w / h);
        else stride = options.stride;
      } else {
        if (window.HTMLCanvasElement && src instanceof window.HTMLCanvasElement) {
          canvas = src;
          ctx = canvas.getContext("2d");
          w = canvas.width, h = canvas.height;
          imgData = ctx.getImageData(0, 0, w, h);
          data = imgData.data;
          stride = 4;
        } else if (window.CanvasRenderingContext2D && src instanceof window.CanvasRenderingContext2D) {
          canvas = src.canvas;
          ctx = src;
          w = canvas.width, h = canvas.height;
          imgData = ctx.getImageData(0, 0, w, h);
          data = imgData.data;
          stride = 4;
        } else if (window.ImageData && src instanceof window.ImageData) {
          imgData = src;
          w = src.width, h = src.height;
          data = imgData.data;
          stride = 4;
        }
      }
      size = Math.max(w, h);
      if (window.Uint8ClampedArray && data instanceof window.Uint8ClampedArray || window.Uint8Array && data instanceof window.Uint8Array) {
        intData = data;
        data = Array(w * h);
        for (i = 0, l = Math.floor(intData.length / stride); i < l; i++) {
          data[i] = intData[i * stride + channel] / 255;
        }
      } else {
        if (stride !== 1) throw Error("Raw data can have only 1 value per pixel");
      }
      var gridOuter = Array(w * h);
      var gridInner = Array(w * h);
      var f = Array(size);
      var d = Array(size);
      var z = Array(size + 1);
      var v3 = Array(size);
      for (i = 0, l = w * h; i < l; i++) {
        var a3 = data[i];
        gridOuter[i] = a3 === 1 ? 0 : a3 === 0 ? INF : Math.pow(Math.max(0, 0.5 - a3), 2);
        gridInner[i] = a3 === 1 ? INF : a3 === 0 ? 0 : Math.pow(Math.max(0, a3 - 0.5), 2);
      }
      edt(gridOuter, w, h, f, d, v3, z);
      edt(gridInner, w, h, f, d, v3, z);
      var dist = window.Float32Array ? new Float32Array(w * h) : new Array(w * h);
      for (i = 0, l = w * h; i < l; i++) {
        dist[i] = Math.min(Math.max(1 - ((gridOuter[i] - gridInner[i]) / radius + cutoff), 0), 1);
      }
      return dist;
    }
    function edt(data, width, height, f, d, v3, z) {
      for (var x = 0; x < width; x++) {
        for (var y = 0; y < height; y++) {
          f[y] = data[y * width + x];
        }
        edt1d(f, d, v3, z, height);
        for (y = 0; y < height; y++) {
          data[y * width + x] = d[y];
        }
      }
      for (y = 0; y < height; y++) {
        for (x = 0; x < width; x++) {
          f[x] = data[y * width + x];
        }
        edt1d(f, d, v3, z, width);
        for (x = 0; x < width; x++) {
          data[y * width + x] = Math.sqrt(d[x]);
        }
      }
    }
    function edt1d(f, d, v3, z, n) {
      v3[0] = 0;
      z[0] = -INF;
      z[1] = +INF;
      for (var q = 1, k = 0; q < n; q++) {
        var s = (f[q] + q * q - (f[v3[k]] + v3[k] * v3[k])) / (2 * q - 2 * v3[k]);
        while (s <= z[k]) {
          k--;
          s = (f[q] + q * q - (f[v3[k]] + v3[k] * v3[k])) / (2 * q - 2 * v3[k]);
        }
        k++;
        v3[k] = q;
        z[k] = s;
        z[k + 1] = +INF;
      }
      for (q = 0, k = 0; q < n; q++) {
        while (z[k + 1] < q) k++;
        d[q] = (q - v3[k]) * (q - v3[k]) + f[v3[k]];
      }
    }
  }
});

// node_modules/grapheme-splitter/index.js
var require_grapheme_splitter = __commonJS({
  "node_modules/grapheme-splitter/index.js"(exports2, module2) {
    function GraphemeSplitter2() {
      var CR = 0, LF = 1, Control = 2, Extend = 3, Regional_Indicator = 4, SpacingMark = 5, L = 6, V = 7, T2 = 8, LV = 9, LVT = 10, Other = 11, Prepend = 12, E_Base = 13, E_Modifier = 14, ZWJ = 15, Glue_After_Zwj = 16, E_Base_GAZ = 17;
      var NotBreak = 0, BreakStart = 1, Break = 2, BreakLastRegional = 3, BreakPenultimateRegional = 4;
      function isSurrogate(str, pos) {
        return 55296 <= str.charCodeAt(pos) && str.charCodeAt(pos) <= 56319 && 56320 <= str.charCodeAt(pos + 1) && str.charCodeAt(pos + 1) <= 57343;
      }
      function codePointAt(str, idx) {
        if (idx === void 0) {
          idx = 0;
        }
        var code = str.charCodeAt(idx);
        if (55296 <= code && code <= 56319 && idx < str.length - 1) {
          var hi = code;
          var low = str.charCodeAt(idx + 1);
          if (56320 <= low && low <= 57343) {
            return (hi - 55296) * 1024 + (low - 56320) + 65536;
          }
          return hi;
        }
        if (56320 <= code && code <= 57343 && idx >= 1) {
          var hi = str.charCodeAt(idx - 1);
          var low = code;
          if (55296 <= hi && hi <= 56319) {
            return (hi - 55296) * 1024 + (low - 56320) + 65536;
          }
          return low;
        }
        return code;
      }
      function shouldBreak(start, mid, end) {
        var all = [start].concat(mid).concat([end]);
        var previous = all[all.length - 2];
        var next = end;
        var eModifierIndex = all.lastIndexOf(E_Modifier);
        if (eModifierIndex > 1 && all.slice(1, eModifierIndex).every(function(c) {
          return c == Extend;
        }) && [Extend, E_Base, E_Base_GAZ].indexOf(start) == -1) {
          return Break;
        }
        var rIIndex = all.lastIndexOf(Regional_Indicator);
        if (rIIndex > 0 && all.slice(1, rIIndex).every(function(c) {
          return c == Regional_Indicator;
        }) && [Prepend, Regional_Indicator].indexOf(previous) == -1) {
          if (all.filter(function(c) {
            return c == Regional_Indicator;
          }).length % 2 == 1) {
            return BreakLastRegional;
          } else {
            return BreakPenultimateRegional;
          }
        }
        if (previous == CR && next == LF) {
          return NotBreak;
        } else if (previous == Control || previous == CR || previous == LF) {
          if (next == E_Modifier && mid.every(function(c) {
            return c == Extend;
          })) {
            return Break;
          } else {
            return BreakStart;
          }
        } else if (next == Control || next == CR || next == LF) {
          return BreakStart;
        } else if (previous == L && (next == L || next == V || next == LV || next == LVT)) {
          return NotBreak;
        } else if ((previous == LV || previous == V) && (next == V || next == T2)) {
          return NotBreak;
        } else if ((previous == LVT || previous == T2) && next == T2) {
          return NotBreak;
        } else if (next == Extend || next == ZWJ) {
          return NotBreak;
        } else if (next == SpacingMark) {
          return NotBreak;
        } else if (previous == Prepend) {
          return NotBreak;
        }
        var previousNonExtendIndex = all.indexOf(Extend) != -1 ? all.lastIndexOf(Extend) - 1 : all.length - 2;
        if ([E_Base, E_Base_GAZ].indexOf(all[previousNonExtendIndex]) != -1 && all.slice(previousNonExtendIndex + 1, -1).every(function(c) {
          return c == Extend;
        }) && next == E_Modifier) {
          return NotBreak;
        }
        if (previous == ZWJ && [Glue_After_Zwj, E_Base_GAZ].indexOf(next) != -1) {
          return NotBreak;
        }
        if (mid.indexOf(Regional_Indicator) != -1) {
          return Break;
        }
        if (previous == Regional_Indicator && next == Regional_Indicator) {
          return NotBreak;
        }
        return BreakStart;
      }
      this.nextBreak = function(string, index) {
        if (index === void 0) {
          index = 0;
        }
        if (index < 0) {
          return 0;
        }
        if (index >= string.length - 1) {
          return string.length;
        }
        var prev = getGraphemeBreakProperty(codePointAt(string, index));
        var mid = [];
        for (var i = index + 1; i < string.length; i++) {
          if (isSurrogate(string, i - 1)) {
            continue;
          }
          var next = getGraphemeBreakProperty(codePointAt(string, i));
          if (shouldBreak(prev, mid, next)) {
            return i;
          }
          mid.push(next);
        }
        return string.length;
      };
      this.splitGraphemes = function(str) {
        var res = [];
        var index = 0;
        var brk;
        while ((brk = this.nextBreak(str, index)) < str.length) {
          res.push(str.slice(index, brk));
          index = brk;
        }
        if (index < str.length) {
          res.push(str.slice(index));
        }
        return res;
      };
      this.iterateGraphemes = function(str) {
        var index = 0;
        var res = {
          next: (function() {
            var value;
            var brk;
            if ((brk = this.nextBreak(str, index)) < str.length) {
              value = str.slice(index, brk);
              index = brk;
              return { value, done: false };
            }
            if (index < str.length) {
              value = str.slice(index);
              index = str.length;
              return { value, done: false };
            }
            return { value: void 0, done: true };
          }).bind(this)
        };
        if (typeof Symbol !== "undefined" && Symbol.iterator) {
          res[Symbol.iterator] = function() {
            return res;
          };
        }
        return res;
      };
      this.countGraphemes = function(str) {
        var count = 0;
        var index = 0;
        var brk;
        while ((brk = this.nextBreak(str, index)) < str.length) {
          index = brk;
          count++;
        }
        if (index < str.length) {
          count++;
        }
        return count;
      };
      function getGraphemeBreakProperty(code) {
        if (1536 <= code && code <= 1541 || // Cf   [6] ARABIC NUMBER SIGN..ARABIC NUMBER MARK ABOVE
        1757 == code || // Cf       ARABIC END OF AYAH
        1807 == code || // Cf       SYRIAC ABBREVIATION MARK
        2274 == code || // Cf       ARABIC DISPUTED END OF AYAH
        3406 == code || // Lo       MALAYALAM LETTER DOT REPH
        69821 == code || // Cf       KAITHI NUMBER SIGN
        70082 <= code && code <= 70083 || // Lo   [2] SHARADA SIGN JIHVAMULIYA..SHARADA SIGN UPADHMANIYA
        72250 == code || // Lo       ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
        72326 <= code && code <= 72329 || // Lo   [4] SOYOMBO CLUSTER-INITIAL LETTER RA..SOYOMBO CLUSTER-INITIAL LETTER SA
        73030 == code) {
          return Prepend;
        }
        if (13 == code) {
          return CR;
        }
        if (10 == code) {
          return LF;
        }
        if (0 <= code && code <= 9 || // Cc  [10] <control-0000>..<control-0009>
        11 <= code && code <= 12 || // Cc   [2] <control-000B>..<control-000C>
        14 <= code && code <= 31 || // Cc  [18] <control-000E>..<control-001F>
        127 <= code && code <= 159 || // Cc  [33] <control-007F>..<control-009F>
        173 == code || // Cf       SOFT HYPHEN
        1564 == code || // Cf       ARABIC LETTER MARK
        6158 == code || // Cf       MONGOLIAN VOWEL SEPARATOR
        8203 == code || // Cf       ZERO WIDTH SPACE
        8206 <= code && code <= 8207 || // Cf   [2] LEFT-TO-RIGHT MARK..RIGHT-TO-LEFT MARK
        8232 == code || // Zl       LINE SEPARATOR
        8233 == code || // Zp       PARAGRAPH SEPARATOR
        8234 <= code && code <= 8238 || // Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
        8288 <= code && code <= 8292 || // Cf   [5] WORD JOINER..INVISIBLE PLUS
        8293 == code || // Cn       <reserved-2065>
        8294 <= code && code <= 8303 || // Cf  [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIGIT SHAPES
        55296 <= code && code <= 57343 || // Cs [2048] <surrogate-D800>..<surrogate-DFFF>
        65279 == code || // Cf       ZERO WIDTH NO-BREAK SPACE
        65520 <= code && code <= 65528 || // Cn   [9] <reserved-FFF0>..<reserved-FFF8>
        65529 <= code && code <= 65531 || // Cf   [3] INTERLINEAR ANNOTATION ANCHOR..INTERLINEAR ANNOTATION TERMINATOR
        113824 <= code && code <= 113827 || // Cf   [4] SHORTHAND FORMAT LETTER OVERLAP..SHORTHAND FORMAT UP STEP
        119155 <= code && code <= 119162 || // Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
        917504 == code || // Cn       <reserved-E0000>
        917505 == code || // Cf       LANGUAGE TAG
        917506 <= code && code <= 917535 || // Cn  [30] <reserved-E0002>..<reserved-E001F>
        917632 <= code && code <= 917759 || // Cn [128] <reserved-E0080>..<reserved-E00FF>
        918e3 <= code && code <= 921599) {
          return Control;
        }
        if (768 <= code && code <= 879 || // Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
        1155 <= code && code <= 1159 || // Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
        1160 <= code && code <= 1161 || // Me   [2] COMBINING CYRILLIC HUNDRED THOUSANDS SIGN..COMBINING CYRILLIC MILLIONS SIGN
        1425 <= code && code <= 1469 || // Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
        1471 == code || // Mn       HEBREW POINT RAFE
        1473 <= code && code <= 1474 || // Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
        1476 <= code && code <= 1477 || // Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
        1479 == code || // Mn       HEBREW POINT QAMATS QATAN
        1552 <= code && code <= 1562 || // Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
        1611 <= code && code <= 1631 || // Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
        1648 == code || // Mn       ARABIC LETTER SUPERSCRIPT ALEF
        1750 <= code && code <= 1756 || // Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
        1759 <= code && code <= 1764 || // Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
        1767 <= code && code <= 1768 || // Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
        1770 <= code && code <= 1773 || // Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
        1809 == code || // Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
        1840 <= code && code <= 1866 || // Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
        1958 <= code && code <= 1968 || // Mn  [11] THAANA ABAFILI..THAANA SUKUN
        2027 <= code && code <= 2035 || // Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
        2070 <= code && code <= 2073 || // Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
        2075 <= code && code <= 2083 || // Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
        2085 <= code && code <= 2087 || // Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
        2089 <= code && code <= 2093 || // Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
        2137 <= code && code <= 2139 || // Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
        2260 <= code && code <= 2273 || // Mn  [14] ARABIC SMALL HIGH WORD AR-RUB..ARABIC SMALL HIGH SIGN SAFHA
        2275 <= code && code <= 2306 || // Mn  [32] ARABIC TURNED DAMMA BELOW..DEVANAGARI SIGN ANUSVARA
        2362 == code || // Mn       DEVANAGARI VOWEL SIGN OE
        2364 == code || // Mn       DEVANAGARI SIGN NUKTA
        2369 <= code && code <= 2376 || // Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
        2381 == code || // Mn       DEVANAGARI SIGN VIRAMA
        2385 <= code && code <= 2391 || // Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
        2402 <= code && code <= 2403 || // Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
        2433 == code || // Mn       BENGALI SIGN CANDRABINDU
        2492 == code || // Mn       BENGALI SIGN NUKTA
        2494 == code || // Mc       BENGALI VOWEL SIGN AA
        2497 <= code && code <= 2500 || // Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
        2509 == code || // Mn       BENGALI SIGN VIRAMA
        2519 == code || // Mc       BENGALI AU LENGTH MARK
        2530 <= code && code <= 2531 || // Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
        2561 <= code && code <= 2562 || // Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
        2620 == code || // Mn       GURMUKHI SIGN NUKTA
        2625 <= code && code <= 2626 || // Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
        2631 <= code && code <= 2632 || // Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
        2635 <= code && code <= 2637 || // Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
        2641 == code || // Mn       GURMUKHI SIGN UDAAT
        2672 <= code && code <= 2673 || // Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
        2677 == code || // Mn       GURMUKHI SIGN YAKASH
        2689 <= code && code <= 2690 || // Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
        2748 == code || // Mn       GUJARATI SIGN NUKTA
        2753 <= code && code <= 2757 || // Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
        2759 <= code && code <= 2760 || // Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
        2765 == code || // Mn       GUJARATI SIGN VIRAMA
        2786 <= code && code <= 2787 || // Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
        2810 <= code && code <= 2815 || // Mn   [6] GUJARATI SIGN SUKUN..GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE
        2817 == code || // Mn       ORIYA SIGN CANDRABINDU
        2876 == code || // Mn       ORIYA SIGN NUKTA
        2878 == code || // Mc       ORIYA VOWEL SIGN AA
        2879 == code || // Mn       ORIYA VOWEL SIGN I
        2881 <= code && code <= 2884 || // Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
        2893 == code || // Mn       ORIYA SIGN VIRAMA
        2902 == code || // Mn       ORIYA AI LENGTH MARK
        2903 == code || // Mc       ORIYA AU LENGTH MARK
        2914 <= code && code <= 2915 || // Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
        2946 == code || // Mn       TAMIL SIGN ANUSVARA
        3006 == code || // Mc       TAMIL VOWEL SIGN AA
        3008 == code || // Mn       TAMIL VOWEL SIGN II
        3021 == code || // Mn       TAMIL SIGN VIRAMA
        3031 == code || // Mc       TAMIL AU LENGTH MARK
        3072 == code || // Mn       TELUGU SIGN COMBINING CANDRABINDU ABOVE
        3134 <= code && code <= 3136 || // Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
        3142 <= code && code <= 3144 || // Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
        3146 <= code && code <= 3149 || // Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
        3157 <= code && code <= 3158 || // Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
        3170 <= code && code <= 3171 || // Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
        3201 == code || // Mn       KANNADA SIGN CANDRABINDU
        3260 == code || // Mn       KANNADA SIGN NUKTA
        3263 == code || // Mn       KANNADA VOWEL SIGN I
        3266 == code || // Mc       KANNADA VOWEL SIGN UU
        3270 == code || // Mn       KANNADA VOWEL SIGN E
        3276 <= code && code <= 3277 || // Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
        3285 <= code && code <= 3286 || // Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
        3298 <= code && code <= 3299 || // Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
        3328 <= code && code <= 3329 || // Mn   [2] MALAYALAM SIGN COMBINING ANUSVARA ABOVE..MALAYALAM SIGN CANDRABINDU
        3387 <= code && code <= 3388 || // Mn   [2] MALAYALAM SIGN VERTICAL BAR VIRAMA..MALAYALAM SIGN CIRCULAR VIRAMA
        3390 == code || // Mc       MALAYALAM VOWEL SIGN AA
        3393 <= code && code <= 3396 || // Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
        3405 == code || // Mn       MALAYALAM SIGN VIRAMA
        3415 == code || // Mc       MALAYALAM AU LENGTH MARK
        3426 <= code && code <= 3427 || // Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
        3530 == code || // Mn       SINHALA SIGN AL-LAKUNA
        3535 == code || // Mc       SINHALA VOWEL SIGN AELA-PILLA
        3538 <= code && code <= 3540 || // Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
        3542 == code || // Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
        3551 == code || // Mc       SINHALA VOWEL SIGN GAYANUKITTA
        3633 == code || // Mn       THAI CHARACTER MAI HAN-AKAT
        3636 <= code && code <= 3642 || // Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
        3655 <= code && code <= 3662 || // Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
        3761 == code || // Mn       LAO VOWEL SIGN MAI KAN
        3764 <= code && code <= 3769 || // Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
        3771 <= code && code <= 3772 || // Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVOWEL SIGN LO
        3784 <= code && code <= 3789 || // Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
        3864 <= code && code <= 3865 || // Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
        3893 == code || // Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
        3895 == code || // Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
        3897 == code || // Mn       TIBETAN MARK TSA -PHRU
        3953 <= code && code <= 3966 || // Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
        3968 <= code && code <= 3972 || // Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
        3974 <= code && code <= 3975 || // Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
        3981 <= code && code <= 3991 || // Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
        3993 <= code && code <= 4028 || // Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
        4038 == code || // Mn       TIBETAN SYMBOL PADMA GDAN
        4141 <= code && code <= 4144 || // Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
        4146 <= code && code <= 4151 || // Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
        4153 <= code && code <= 4154 || // Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
        4157 <= code && code <= 4158 || // Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
        4184 <= code && code <= 4185 || // Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
        4190 <= code && code <= 4192 || // Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
        4209 <= code && code <= 4212 || // Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
        4226 == code || // Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
        4229 <= code && code <= 4230 || // Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
        4237 == code || // Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
        4253 == code || // Mn       MYANMAR VOWEL SIGN AITON AI
        4957 <= code && code <= 4959 || // Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
        5906 <= code && code <= 5908 || // Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
        5938 <= code && code <= 5940 || // Mn   [3] HANUNOO VOWEL SIGN I..HANUNOO SIGN PAMUDPOD
        5970 <= code && code <= 5971 || // Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
        6002 <= code && code <= 6003 || // Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
        6068 <= code && code <= 6069 || // Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
        6071 <= code && code <= 6077 || // Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
        6086 == code || // Mn       KHMER SIGN NIKAHIT
        6089 <= code && code <= 6099 || // Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
        6109 == code || // Mn       KHMER SIGN ATTHACAN
        6155 <= code && code <= 6157 || // Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
        6277 <= code && code <= 6278 || // Mn   [2] MONGOLIAN LETTER ALI GALI BALUDA..MONGOLIAN LETTER ALI GALI THREE BALUDA
        6313 == code || // Mn       MONGOLIAN LETTER ALI GALI DAGALGA
        6432 <= code && code <= 6434 || // Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
        6439 <= code && code <= 6440 || // Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
        6450 == code || // Mn       LIMBU SMALL LETTER ANUSVARA
        6457 <= code && code <= 6459 || // Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
        6679 <= code && code <= 6680 || // Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
        6683 == code || // Mn       BUGINESE VOWEL SIGN AE
        6742 == code || // Mn       TAI THAM CONSONANT SIGN MEDIAL LA
        6744 <= code && code <= 6750 || // Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
        6752 == code || // Mn       TAI THAM SIGN SAKOT
        6754 == code || // Mn       TAI THAM VOWEL SIGN MAI SAT
        6757 <= code && code <= 6764 || // Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
        6771 <= code && code <= 6780 || // Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
        6783 == code || // Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
        6832 <= code && code <= 6845 || // Mn  [14] COMBINING DOUBLED CIRCUMFLEX ACCENT..COMBINING PARENTHESES BELOW
        6846 == code || // Me       COMBINING PARENTHESES OVERLAY
        6912 <= code && code <= 6915 || // Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
        6964 == code || // Mn       BALINESE SIGN REREKAN
        6966 <= code && code <= 6970 || // Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
        6972 == code || // Mn       BALINESE VOWEL SIGN LA LENGA
        6978 == code || // Mn       BALINESE VOWEL SIGN PEPET
        7019 <= code && code <= 7027 || // Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
        7040 <= code && code <= 7041 || // Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
        7074 <= code && code <= 7077 || // Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
        7080 <= code && code <= 7081 || // Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
        7083 <= code && code <= 7085 || // Mn   [3] SUNDANESE SIGN VIRAMA..SUNDANESE CONSONANT SIGN PASANGAN WA
        7142 == code || // Mn       BATAK SIGN TOMPI
        7144 <= code && code <= 7145 || // Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
        7149 == code || // Mn       BATAK VOWEL SIGN KARO O
        7151 <= code && code <= 7153 || // Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
        7212 <= code && code <= 7219 || // Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
        7222 <= code && code <= 7223 || // Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
        7376 <= code && code <= 7378 || // Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
        7380 <= code && code <= 7392 || // Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
        7394 <= code && code <= 7400 || // Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
        7405 == code || // Mn       VEDIC SIGN TIRYAK
        7412 == code || // Mn       VEDIC TONE CANDRA ABOVE
        7416 <= code && code <= 7417 || // Mn   [2] VEDIC TONE RING ABOVE..VEDIC TONE DOUBLE RING ABOVE
        7616 <= code && code <= 7673 || // Mn  [58] COMBINING DOTTED GRAVE ACCENT..COMBINING WIDE INVERTED BRIDGE BELOW
        7675 <= code && code <= 7679 || // Mn   [5] COMBINING DELETION MARK..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
        8204 == code || // Cf       ZERO WIDTH NON-JOINER
        8400 <= code && code <= 8412 || // Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
        8413 <= code && code <= 8416 || // Me   [4] COMBINING ENCLOSING CIRCLE..COMBINING ENCLOSING CIRCLE BACKSLASH
        8417 == code || // Mn       COMBINING LEFT RIGHT ARROW ABOVE
        8418 <= code && code <= 8420 || // Me   [3] COMBINING ENCLOSING SCREEN..COMBINING ENCLOSING UPWARD POINTING TRIANGLE
        8421 <= code && code <= 8432 || // Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
        11503 <= code && code <= 11505 || // Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
        11647 == code || // Mn       TIFINAGH CONSONANT JOINER
        11744 <= code && code <= 11775 || // Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
        12330 <= code && code <= 12333 || // Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
        12334 <= code && code <= 12335 || // Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
        12441 <= code && code <= 12442 || // Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
        42607 == code || // Mn       COMBINING CYRILLIC VZMET
        42608 <= code && code <= 42610 || // Me   [3] COMBINING CYRILLIC TEN MILLIONS SIGN..COMBINING CYRILLIC THOUSAND MILLIONS SIGN
        42612 <= code && code <= 42621 || // Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
        42654 <= code && code <= 42655 || // Mn   [2] COMBINING CYRILLIC LETTER EF..COMBINING CYRILLIC LETTER IOTIFIED E
        42736 <= code && code <= 42737 || // Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
        43010 == code || // Mn       SYLOTI NAGRI SIGN DVISVARA
        43014 == code || // Mn       SYLOTI NAGRI SIGN HASANTA
        43019 == code || // Mn       SYLOTI NAGRI SIGN ANUSVARA
        43045 <= code && code <= 43046 || // Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
        43204 <= code && code <= 43205 || // Mn   [2] SAURASHTRA SIGN VIRAMA..SAURASHTRA SIGN CANDRABINDU
        43232 <= code && code <= 43249 || // Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
        43302 <= code && code <= 43309 || // Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
        43335 <= code && code <= 43345 || // Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
        43392 <= code && code <= 43394 || // Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
        43443 == code || // Mn       JAVANESE SIGN CECAK TELU
        43446 <= code && code <= 43449 || // Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
        43452 == code || // Mn       JAVANESE VOWEL SIGN PEPET
        43493 == code || // Mn       MYANMAR SIGN SHAN SAW
        43561 <= code && code <= 43566 || // Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
        43569 <= code && code <= 43570 || // Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
        43573 <= code && code <= 43574 || // Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
        43587 == code || // Mn       CHAM CONSONANT SIGN FINAL NG
        43596 == code || // Mn       CHAM CONSONANT SIGN FINAL M
        43644 == code || // Mn       MYANMAR SIGN TAI LAING TONE-2
        43696 == code || // Mn       TAI VIET MAI KANG
        43698 <= code && code <= 43700 || // Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
        43703 <= code && code <= 43704 || // Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
        43710 <= code && code <= 43711 || // Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
        43713 == code || // Mn       TAI VIET TONE MAI THO
        43756 <= code && code <= 43757 || // Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
        43766 == code || // Mn       MEETEI MAYEK VIRAMA
        44005 == code || // Mn       MEETEI MAYEK VOWEL SIGN ANAP
        44008 == code || // Mn       MEETEI MAYEK VOWEL SIGN UNAP
        44013 == code || // Mn       MEETEI MAYEK APUN IYEK
        64286 == code || // Mn       HEBREW POINT JUDEO-SPANISH VARIKA
        65024 <= code && code <= 65039 || // Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
        65056 <= code && code <= 65071 || // Mn  [16] COMBINING LIGATURE LEFT HALF..COMBINING CYRILLIC TITLO RIGHT HALF
        65438 <= code && code <= 65439 || // Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
        66045 == code || // Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
        66272 == code || // Mn       COPTIC EPACT THOUSANDS MARK
        66422 <= code && code <= 66426 || // Mn   [5] COMBINING OLD PERMIC LETTER AN..COMBINING OLD PERMIC LETTER SII
        68097 <= code && code <= 68099 || // Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
        68101 <= code && code <= 68102 || // Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
        68108 <= code && code <= 68111 || // Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
        68152 <= code && code <= 68154 || // Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
        68159 == code || // Mn       KHAROSHTHI VIRAMA
        68325 <= code && code <= 68326 || // Mn   [2] MANICHAEAN ABBREVIATION MARK ABOVE..MANICHAEAN ABBREVIATION MARK BELOW
        69633 == code || // Mn       BRAHMI SIGN ANUSVARA
        69688 <= code && code <= 69702 || // Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
        69759 <= code && code <= 69761 || // Mn   [3] BRAHMI NUMBER JOINER..KAITHI SIGN ANUSVARA
        69811 <= code && code <= 69814 || // Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
        69817 <= code && code <= 69818 || // Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
        69888 <= code && code <= 69890 || // Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
        69927 <= code && code <= 69931 || // Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
        69933 <= code && code <= 69940 || // Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
        70003 == code || // Mn       MAHAJANI SIGN NUKTA
        70016 <= code && code <= 70017 || // Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
        70070 <= code && code <= 70078 || // Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
        70090 <= code && code <= 70092 || // Mn   [3] SHARADA SIGN NUKTA..SHARADA EXTRA SHORT VOWEL MARK
        70191 <= code && code <= 70193 || // Mn   [3] KHOJKI VOWEL SIGN U..KHOJKI VOWEL SIGN AI
        70196 == code || // Mn       KHOJKI SIGN ANUSVARA
        70198 <= code && code <= 70199 || // Mn   [2] KHOJKI SIGN NUKTA..KHOJKI SIGN SHADDA
        70206 == code || // Mn       KHOJKI SIGN SUKUN
        70367 == code || // Mn       KHUDAWADI SIGN ANUSVARA
        70371 <= code && code <= 70378 || // Mn   [8] KHUDAWADI VOWEL SIGN U..KHUDAWADI SIGN VIRAMA
        70400 <= code && code <= 70401 || // Mn   [2] GRANTHA SIGN COMBINING ANUSVARA ABOVE..GRANTHA SIGN CANDRABINDU
        70460 == code || // Mn       GRANTHA SIGN NUKTA
        70462 == code || // Mc       GRANTHA VOWEL SIGN AA
        70464 == code || // Mn       GRANTHA VOWEL SIGN II
        70487 == code || // Mc       GRANTHA AU LENGTH MARK
        70502 <= code && code <= 70508 || // Mn   [7] COMBINING GRANTHA DIGIT ZERO..COMBINING GRANTHA DIGIT SIX
        70512 <= code && code <= 70516 || // Mn   [5] COMBINING GRANTHA LETTER A..COMBINING GRANTHA LETTER PA
        70712 <= code && code <= 70719 || // Mn   [8] NEWA VOWEL SIGN U..NEWA VOWEL SIGN AI
        70722 <= code && code <= 70724 || // Mn   [3] NEWA SIGN VIRAMA..NEWA SIGN ANUSVARA
        70726 == code || // Mn       NEWA SIGN NUKTA
        70832 == code || // Mc       TIRHUTA VOWEL SIGN AA
        70835 <= code && code <= 70840 || // Mn   [6] TIRHUTA VOWEL SIGN U..TIRHUTA VOWEL SIGN VOCALIC LL
        70842 == code || // Mn       TIRHUTA VOWEL SIGN SHORT E
        70845 == code || // Mc       TIRHUTA VOWEL SIGN SHORT O
        70847 <= code && code <= 70848 || // Mn   [2] TIRHUTA SIGN CANDRABINDU..TIRHUTA SIGN ANUSVARA
        70850 <= code && code <= 70851 || // Mn   [2] TIRHUTA SIGN VIRAMA..TIRHUTA SIGN NUKTA
        71087 == code || // Mc       SIDDHAM VOWEL SIGN AA
        71090 <= code && code <= 71093 || // Mn   [4] SIDDHAM VOWEL SIGN U..SIDDHAM VOWEL SIGN VOCALIC RR
        71100 <= code && code <= 71101 || // Mn   [2] SIDDHAM SIGN CANDRABINDU..SIDDHAM SIGN ANUSVARA
        71103 <= code && code <= 71104 || // Mn   [2] SIDDHAM SIGN VIRAMA..SIDDHAM SIGN NUKTA
        71132 <= code && code <= 71133 || // Mn   [2] SIDDHAM VOWEL SIGN ALTERNATE U..SIDDHAM VOWEL SIGN ALTERNATE UU
        71219 <= code && code <= 71226 || // Mn   [8] MODI VOWEL SIGN U..MODI VOWEL SIGN AI
        71229 == code || // Mn       MODI SIGN ANUSVARA
        71231 <= code && code <= 71232 || // Mn   [2] MODI SIGN VIRAMA..MODI SIGN ARDHACANDRA
        71339 == code || // Mn       TAKRI SIGN ANUSVARA
        71341 == code || // Mn       TAKRI VOWEL SIGN AA
        71344 <= code && code <= 71349 || // Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
        71351 == code || // Mn       TAKRI SIGN NUKTA
        71453 <= code && code <= 71455 || // Mn   [3] AHOM CONSONANT SIGN MEDIAL LA..AHOM CONSONANT SIGN MEDIAL LIGATING RA
        71458 <= code && code <= 71461 || // Mn   [4] AHOM VOWEL SIGN I..AHOM VOWEL SIGN UU
        71463 <= code && code <= 71467 || // Mn   [5] AHOM VOWEL SIGN AW..AHOM SIGN KILLER
        72193 <= code && code <= 72198 || // Mn   [6] ZANABAZAR SQUARE VOWEL SIGN I..ZANABAZAR SQUARE VOWEL SIGN O
        72201 <= code && code <= 72202 || // Mn   [2] ZANABAZAR SQUARE VOWEL SIGN REVERSED I..ZANABAZAR SQUARE VOWEL LENGTH MARK
        72243 <= code && code <= 72248 || // Mn   [6] ZANABAZAR SQUARE FINAL CONSONANT MARK..ZANABAZAR SQUARE SIGN ANUSVARA
        72251 <= code && code <= 72254 || // Mn   [4] ZANABAZAR SQUARE CLUSTER-FINAL LETTER YA..ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA
        72263 == code || // Mn       ZANABAZAR SQUARE SUBJOINER
        72273 <= code && code <= 72278 || // Mn   [6] SOYOMBO VOWEL SIGN I..SOYOMBO VOWEL SIGN OE
        72281 <= code && code <= 72283 || // Mn   [3] SOYOMBO VOWEL SIGN VOCALIC R..SOYOMBO VOWEL LENGTH MARK
        72330 <= code && code <= 72342 || // Mn  [13] SOYOMBO FINAL CONSONANT SIGN G..SOYOMBO SIGN ANUSVARA
        72344 <= code && code <= 72345 || // Mn   [2] SOYOMBO GEMINATION MARK..SOYOMBO SUBJOINER
        72752 <= code && code <= 72758 || // Mn   [7] BHAIKSUKI VOWEL SIGN I..BHAIKSUKI VOWEL SIGN VOCALIC L
        72760 <= code && code <= 72765 || // Mn   [6] BHAIKSUKI VOWEL SIGN E..BHAIKSUKI SIGN ANUSVARA
        72767 == code || // Mn       BHAIKSUKI SIGN VIRAMA
        72850 <= code && code <= 72871 || // Mn  [22] MARCHEN SUBJOINED LETTER KA..MARCHEN SUBJOINED LETTER ZA
        72874 <= code && code <= 72880 || // Mn   [7] MARCHEN SUBJOINED LETTER RA..MARCHEN VOWEL SIGN AA
        72882 <= code && code <= 72883 || // Mn   [2] MARCHEN VOWEL SIGN U..MARCHEN VOWEL SIGN E
        72885 <= code && code <= 72886 || // Mn   [2] MARCHEN SIGN ANUSVARA..MARCHEN SIGN CANDRABINDU
        73009 <= code && code <= 73014 || // Mn   [6] MASARAM GONDI VOWEL SIGN AA..MASARAM GONDI VOWEL SIGN VOCALIC R
        73018 == code || // Mn       MASARAM GONDI VOWEL SIGN E
        73020 <= code && code <= 73021 || // Mn   [2] MASARAM GONDI VOWEL SIGN AI..MASARAM GONDI VOWEL SIGN O
        73023 <= code && code <= 73029 || // Mn   [7] MASARAM GONDI VOWEL SIGN AU..MASARAM GONDI VIRAMA
        73031 == code || // Mn       MASARAM GONDI RA-KARA
        92912 <= code && code <= 92916 || // Mn   [5] BASSA VAH COMBINING HIGH TONE..BASSA VAH COMBINING HIGH-LOW TONE
        92976 <= code && code <= 92982 || // Mn   [7] PAHAWH HMONG MARK CIM TUB..PAHAWH HMONG MARK CIM TAUM
        94095 <= code && code <= 94098 || // Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
        113821 <= code && code <= 113822 || // Mn   [2] DUPLOYAN THICK LETTER SELECTOR..DUPLOYAN DOUBLE MARK
        119141 == code || // Mc       MUSICAL SYMBOL COMBINING STEM
        119143 <= code && code <= 119145 || // Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
        119150 <= code && code <= 119154 || // Mc   [5] MUSICAL SYMBOL COMBINING FLAG-1..MUSICAL SYMBOL COMBINING FLAG-5
        119163 <= code && code <= 119170 || // Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
        119173 <= code && code <= 119179 || // Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
        119210 <= code && code <= 119213 || // Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
        119362 <= code && code <= 119364 || // Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
        121344 <= code && code <= 121398 || // Mn  [55] SIGNWRITING HEAD RIM..SIGNWRITING AIR SUCKING IN
        121403 <= code && code <= 121452 || // Mn  [50] SIGNWRITING MOUTH CLOSED NEUTRAL..SIGNWRITING EXCITEMENT
        121461 == code || // Mn       SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS
        121476 == code || // Mn       SIGNWRITING LOCATION HEAD NECK
        121499 <= code && code <= 121503 || // Mn   [5] SIGNWRITING FILL MODIFIER-2..SIGNWRITING FILL MODIFIER-6
        121505 <= code && code <= 121519 || // Mn  [15] SIGNWRITING ROTATION MODIFIER-2..SIGNWRITING ROTATION MODIFIER-16
        122880 <= code && code <= 122886 || // Mn   [7] COMBINING GLAGOLITIC LETTER AZU..COMBINING GLAGOLITIC LETTER ZHIVETE
        122888 <= code && code <= 122904 || // Mn  [17] COMBINING GLAGOLITIC LETTER ZEMLJA..COMBINING GLAGOLITIC LETTER HERU
        122907 <= code && code <= 122913 || // Mn   [7] COMBINING GLAGOLITIC LETTER SHTA..COMBINING GLAGOLITIC LETTER YATI
        122915 <= code && code <= 122916 || // Mn   [2] COMBINING GLAGOLITIC LETTER YU..COMBINING GLAGOLITIC LETTER SMALL YUS
        122918 <= code && code <= 122922 || // Mn   [5] COMBINING GLAGOLITIC LETTER YO..COMBINING GLAGOLITIC LETTER FITA
        125136 <= code && code <= 125142 || // Mn   [7] MENDE KIKAKUI COMBINING NUMBER TEENS..MENDE KIKAKUI COMBINING NUMBER MILLIONS
        125252 <= code && code <= 125258 || // Mn   [7] ADLAM ALIF LENGTHENER..ADLAM NUKTA
        917536 <= code && code <= 917631 || // Cf  [96] TAG SPACE..CANCEL TAG
        917760 <= code && code <= 917999) {
          return Extend;
        }
        if (127462 <= code && code <= 127487) {
          return Regional_Indicator;
        }
        if (2307 == code || // Mc       DEVANAGARI SIGN VISARGA
        2363 == code || // Mc       DEVANAGARI VOWEL SIGN OOE
        2366 <= code && code <= 2368 || // Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
        2377 <= code && code <= 2380 || // Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
        2382 <= code && code <= 2383 || // Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
        2434 <= code && code <= 2435 || // Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
        2495 <= code && code <= 2496 || // Mc   [2] BENGALI VOWEL SIGN I..BENGALI VOWEL SIGN II
        2503 <= code && code <= 2504 || // Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
        2507 <= code && code <= 2508 || // Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
        2563 == code || // Mc       GURMUKHI SIGN VISARGA
        2622 <= code && code <= 2624 || // Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
        2691 == code || // Mc       GUJARATI SIGN VISARGA
        2750 <= code && code <= 2752 || // Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
        2761 == code || // Mc       GUJARATI VOWEL SIGN CANDRA O
        2763 <= code && code <= 2764 || // Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
        2818 <= code && code <= 2819 || // Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
        2880 == code || // Mc       ORIYA VOWEL SIGN II
        2887 <= code && code <= 2888 || // Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
        2891 <= code && code <= 2892 || // Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
        3007 == code || // Mc       TAMIL VOWEL SIGN I
        3009 <= code && code <= 3010 || // Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
        3014 <= code && code <= 3016 || // Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
        3018 <= code && code <= 3020 || // Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
        3073 <= code && code <= 3075 || // Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
        3137 <= code && code <= 3140 || // Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
        3202 <= code && code <= 3203 || // Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
        3262 == code || // Mc       KANNADA VOWEL SIGN AA
        3264 <= code && code <= 3265 || // Mc   [2] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN U
        3267 <= code && code <= 3268 || // Mc   [2] KANNADA VOWEL SIGN VOCALIC R..KANNADA VOWEL SIGN VOCALIC RR
        3271 <= code && code <= 3272 || // Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
        3274 <= code && code <= 3275 || // Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
        3330 <= code && code <= 3331 || // Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
        3391 <= code && code <= 3392 || // Mc   [2] MALAYALAM VOWEL SIGN I..MALAYALAM VOWEL SIGN II
        3398 <= code && code <= 3400 || // Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
        3402 <= code && code <= 3404 || // Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
        3458 <= code && code <= 3459 || // Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
        3536 <= code && code <= 3537 || // Mc   [2] SINHALA VOWEL SIGN KETTI AEDA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
        3544 <= code && code <= 3550 || // Mc   [7] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
        3570 <= code && code <= 3571 || // Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
        3635 == code || // Lo       THAI CHARACTER SARA AM
        3763 == code || // Lo       LAO VOWEL SIGN AM
        3902 <= code && code <= 3903 || // Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
        3967 == code || // Mc       TIBETAN SIGN RNAM BCAD
        4145 == code || // Mc       MYANMAR VOWEL SIGN E
        4155 <= code && code <= 4156 || // Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
        4182 <= code && code <= 4183 || // Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
        4228 == code || // Mc       MYANMAR VOWEL SIGN SHAN E
        6070 == code || // Mc       KHMER VOWEL SIGN AA
        6078 <= code && code <= 6085 || // Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
        6087 <= code && code <= 6088 || // Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
        6435 <= code && code <= 6438 || // Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
        6441 <= code && code <= 6443 || // Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
        6448 <= code && code <= 6449 || // Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
        6451 <= code && code <= 6456 || // Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
        6681 <= code && code <= 6682 || // Mc   [2] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN O
        6741 == code || // Mc       TAI THAM CONSONANT SIGN MEDIAL RA
        6743 == code || // Mc       TAI THAM CONSONANT SIGN LA TANG LAI
        6765 <= code && code <= 6770 || // Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
        6916 == code || // Mc       BALINESE SIGN BISAH
        6965 == code || // Mc       BALINESE VOWEL SIGN TEDUNG
        6971 == code || // Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
        6973 <= code && code <= 6977 || // Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
        6979 <= code && code <= 6980 || // Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
        7042 == code || // Mc       SUNDANESE SIGN PANGWISAD
        7073 == code || // Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
        7078 <= code && code <= 7079 || // Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
        7082 == code || // Mc       SUNDANESE SIGN PAMAAEH
        7143 == code || // Mc       BATAK VOWEL SIGN E
        7146 <= code && code <= 7148 || // Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
        7150 == code || // Mc       BATAK VOWEL SIGN U
        7154 <= code && code <= 7155 || // Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
        7204 <= code && code <= 7211 || // Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
        7220 <= code && code <= 7221 || // Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
        7393 == code || // Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
        7410 <= code && code <= 7411 || // Mc   [2] VEDIC SIGN ARDHAVISARGA..VEDIC SIGN ROTATED ARDHAVISARGA
        7415 == code || // Mc       VEDIC SIGN ATIKRAMA
        43043 <= code && code <= 43044 || // Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
        43047 == code || // Mc       SYLOTI NAGRI VOWEL SIGN OO
        43136 <= code && code <= 43137 || // Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
        43188 <= code && code <= 43203 || // Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
        43346 <= code && code <= 43347 || // Mc   [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
        43395 == code || // Mc       JAVANESE SIGN WIGNYAN
        43444 <= code && code <= 43445 || // Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
        43450 <= code && code <= 43451 || // Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
        43453 <= code && code <= 43456 || // Mc   [4] JAVANESE CONSONANT SIGN KERET..JAVANESE PANGKON
        43567 <= code && code <= 43568 || // Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
        43571 <= code && code <= 43572 || // Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
        43597 == code || // Mc       CHAM CONSONANT SIGN FINAL H
        43755 == code || // Mc       MEETEI MAYEK VOWEL SIGN II
        43758 <= code && code <= 43759 || // Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
        43765 == code || // Mc       MEETEI MAYEK VOWEL SIGN VISARGA
        44003 <= code && code <= 44004 || // Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
        44006 <= code && code <= 44007 || // Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
        44009 <= code && code <= 44010 || // Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
        44012 == code || // Mc       MEETEI MAYEK LUM IYEK
        69632 == code || // Mc       BRAHMI SIGN CANDRABINDU
        69634 == code || // Mc       BRAHMI SIGN VISARGA
        69762 == code || // Mc       KAITHI SIGN VISARGA
        69808 <= code && code <= 69810 || // Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
        69815 <= code && code <= 69816 || // Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
        69932 == code || // Mc       CHAKMA VOWEL SIGN E
        70018 == code || // Mc       SHARADA SIGN VISARGA
        70067 <= code && code <= 70069 || // Mc   [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
        70079 <= code && code <= 70080 || // Mc   [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
        70188 <= code && code <= 70190 || // Mc   [3] KHOJKI VOWEL SIGN AA..KHOJKI VOWEL SIGN II
        70194 <= code && code <= 70195 || // Mc   [2] KHOJKI VOWEL SIGN O..KHOJKI VOWEL SIGN AU
        70197 == code || // Mc       KHOJKI SIGN VIRAMA
        70368 <= code && code <= 70370 || // Mc   [3] KHUDAWADI VOWEL SIGN AA..KHUDAWADI VOWEL SIGN II
        70402 <= code && code <= 70403 || // Mc   [2] GRANTHA SIGN ANUSVARA..GRANTHA SIGN VISARGA
        70463 == code || // Mc       GRANTHA VOWEL SIGN I
        70465 <= code && code <= 70468 || // Mc   [4] GRANTHA VOWEL SIGN U..GRANTHA VOWEL SIGN VOCALIC RR
        70471 <= code && code <= 70472 || // Mc   [2] GRANTHA VOWEL SIGN EE..GRANTHA VOWEL SIGN AI
        70475 <= code && code <= 70477 || // Mc   [3] GRANTHA VOWEL SIGN OO..GRANTHA SIGN VIRAMA
        70498 <= code && code <= 70499 || // Mc   [2] GRANTHA VOWEL SIGN VOCALIC L..GRANTHA VOWEL SIGN VOCALIC LL
        70709 <= code && code <= 70711 || // Mc   [3] NEWA VOWEL SIGN AA..NEWA VOWEL SIGN II
        70720 <= code && code <= 70721 || // Mc   [2] NEWA VOWEL SIGN O..NEWA VOWEL SIGN AU
        70725 == code || // Mc       NEWA SIGN VISARGA
        70833 <= code && code <= 70834 || // Mc   [2] TIRHUTA VOWEL SIGN I..TIRHUTA VOWEL SIGN II
        70841 == code || // Mc       TIRHUTA VOWEL SIGN E
        70843 <= code && code <= 70844 || // Mc   [2] TIRHUTA VOWEL SIGN AI..TIRHUTA VOWEL SIGN O
        70846 == code || // Mc       TIRHUTA VOWEL SIGN AU
        70849 == code || // Mc       TIRHUTA SIGN VISARGA
        71088 <= code && code <= 71089 || // Mc   [2] SIDDHAM VOWEL SIGN I..SIDDHAM VOWEL SIGN II
        71096 <= code && code <= 71099 || // Mc   [4] SIDDHAM VOWEL SIGN E..SIDDHAM VOWEL SIGN AU
        71102 == code || // Mc       SIDDHAM SIGN VISARGA
        71216 <= code && code <= 71218 || // Mc   [3] MODI VOWEL SIGN AA..MODI VOWEL SIGN II
        71227 <= code && code <= 71228 || // Mc   [2] MODI VOWEL SIGN O..MODI VOWEL SIGN AU
        71230 == code || // Mc       MODI SIGN VISARGA
        71340 == code || // Mc       TAKRI SIGN VISARGA
        71342 <= code && code <= 71343 || // Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
        71350 == code || // Mc       TAKRI SIGN VIRAMA
        71456 <= code && code <= 71457 || // Mc   [2] AHOM VOWEL SIGN A..AHOM VOWEL SIGN AA
        71462 == code || // Mc       AHOM VOWEL SIGN E
        72199 <= code && code <= 72200 || // Mc   [2] ZANABAZAR SQUARE VOWEL SIGN AI..ZANABAZAR SQUARE VOWEL SIGN AU
        72249 == code || // Mc       ZANABAZAR SQUARE SIGN VISARGA
        72279 <= code && code <= 72280 || // Mc   [2] SOYOMBO VOWEL SIGN AI..SOYOMBO VOWEL SIGN AU
        72343 == code || // Mc       SOYOMBO SIGN VISARGA
        72751 == code || // Mc       BHAIKSUKI VOWEL SIGN AA
        72766 == code || // Mc       BHAIKSUKI SIGN VISARGA
        72873 == code || // Mc       MARCHEN SUBJOINED LETTER YA
        72881 == code || // Mc       MARCHEN VOWEL SIGN I
        72884 == code || // Mc       MARCHEN VOWEL SIGN O
        94033 <= code && code <= 94078 || // Mc  [46] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN NG
        119142 == code || // Mc       MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
        119149 == code) {
          return SpacingMark;
        }
        if (4352 <= code && code <= 4447 || // Lo  [96] HANGUL CHOSEONG KIYEOK..HANGUL CHOSEONG FILLER
        43360 <= code && code <= 43388) {
          return L;
        }
        if (4448 <= code && code <= 4519 || // Lo  [72] HANGUL JUNGSEONG FILLER..HANGUL JUNGSEONG O-YAE
        55216 <= code && code <= 55238) {
          return V;
        }
        if (4520 <= code && code <= 4607 || // Lo  [88] HANGUL JONGSEONG KIYEOK..HANGUL JONGSEONG SSANGNIEUN
        55243 <= code && code <= 55291) {
          return T2;
        }
        if (44032 == code || // Lo       HANGUL SYLLABLE GA
        44060 == code || // Lo       HANGUL SYLLABLE GAE
        44088 == code || // Lo       HANGUL SYLLABLE GYA
        44116 == code || // Lo       HANGUL SYLLABLE GYAE
        44144 == code || // Lo       HANGUL SYLLABLE GEO
        44172 == code || // Lo       HANGUL SYLLABLE GE
        44200 == code || // Lo       HANGUL SYLLABLE GYEO
        44228 == code || // Lo       HANGUL SYLLABLE GYE
        44256 == code || // Lo       HANGUL SYLLABLE GO
        44284 == code || // Lo       HANGUL SYLLABLE GWA
        44312 == code || // Lo       HANGUL SYLLABLE GWAE
        44340 == code || // Lo       HANGUL SYLLABLE GOE
        44368 == code || // Lo       HANGUL SYLLABLE GYO
        44396 == code || // Lo       HANGUL SYLLABLE GU
        44424 == code || // Lo       HANGUL SYLLABLE GWEO
        44452 == code || // Lo       HANGUL SYLLABLE GWE
        44480 == code || // Lo       HANGUL SYLLABLE GWI
        44508 == code || // Lo       HANGUL SYLLABLE GYU
        44536 == code || // Lo       HANGUL SYLLABLE GEU
        44564 == code || // Lo       HANGUL SYLLABLE GYI
        44592 == code || // Lo       HANGUL SYLLABLE GI
        44620 == code || // Lo       HANGUL SYLLABLE GGA
        44648 == code || // Lo       HANGUL SYLLABLE GGAE
        44676 == code || // Lo       HANGUL SYLLABLE GGYA
        44704 == code || // Lo       HANGUL SYLLABLE GGYAE
        44732 == code || // Lo       HANGUL SYLLABLE GGEO
        44760 == code || // Lo       HANGUL SYLLABLE GGE
        44788 == code || // Lo       HANGUL SYLLABLE GGYEO
        44816 == code || // Lo       HANGUL SYLLABLE GGYE
        44844 == code || // Lo       HANGUL SYLLABLE GGO
        44872 == code || // Lo       HANGUL SYLLABLE GGWA
        44900 == code || // Lo       HANGUL SYLLABLE GGWAE
        44928 == code || // Lo       HANGUL SYLLABLE GGOE
        44956 == code || // Lo       HANGUL SYLLABLE GGYO
        44984 == code || // Lo       HANGUL SYLLABLE GGU
        45012 == code || // Lo       HANGUL SYLLABLE GGWEO
        45040 == code || // Lo       HANGUL SYLLABLE GGWE
        45068 == code || // Lo       HANGUL SYLLABLE GGWI
        45096 == code || // Lo       HANGUL SYLLABLE GGYU
        45124 == code || // Lo       HANGUL SYLLABLE GGEU
        45152 == code || // Lo       HANGUL SYLLABLE GGYI
        45180 == code || // Lo       HANGUL SYLLABLE GGI
        45208 == code || // Lo       HANGUL SYLLABLE NA
        45236 == code || // Lo       HANGUL SYLLABLE NAE
        45264 == code || // Lo       HANGUL SYLLABLE NYA
        45292 == code || // Lo       HANGUL SYLLABLE NYAE
        45320 == code || // Lo       HANGUL SYLLABLE NEO
        45348 == code || // Lo       HANGUL SYLLABLE NE
        45376 == code || // Lo       HANGUL SYLLABLE NYEO
        45404 == code || // Lo       HANGUL SYLLABLE NYE
        45432 == code || // Lo       HANGUL SYLLABLE NO
        45460 == code || // Lo       HANGUL SYLLABLE NWA
        45488 == code || // Lo       HANGUL SYLLABLE NWAE
        45516 == code || // Lo       HANGUL SYLLABLE NOE
        45544 == code || // Lo       HANGUL SYLLABLE NYO
        45572 == code || // Lo       HANGUL SYLLABLE NU
        45600 == code || // Lo       HANGUL SYLLABLE NWEO
        45628 == code || // Lo       HANGUL SYLLABLE NWE
        45656 == code || // Lo       HANGUL SYLLABLE NWI
        45684 == code || // Lo       HANGUL SYLLABLE NYU
        45712 == code || // Lo       HANGUL SYLLABLE NEU
        45740 == code || // Lo       HANGUL SYLLABLE NYI
        45768 == code || // Lo       HANGUL SYLLABLE NI
        45796 == code || // Lo       HANGUL SYLLABLE DA
        45824 == code || // Lo       HANGUL SYLLABLE DAE
        45852 == code || // Lo       HANGUL SYLLABLE DYA
        45880 == code || // Lo       HANGUL SYLLABLE DYAE
        45908 == code || // Lo       HANGUL SYLLABLE DEO
        45936 == code || // Lo       HANGUL SYLLABLE DE
        45964 == code || // Lo       HANGUL SYLLABLE DYEO
        45992 == code || // Lo       HANGUL SYLLABLE DYE
        46020 == code || // Lo       HANGUL SYLLABLE DO
        46048 == code || // Lo       HANGUL SYLLABLE DWA
        46076 == code || // Lo       HANGUL SYLLABLE DWAE
        46104 == code || // Lo       HANGUL SYLLABLE DOE
        46132 == code || // Lo       HANGUL SYLLABLE DYO
        46160 == code || // Lo       HANGUL SYLLABLE DU
        46188 == code || // Lo       HANGUL SYLLABLE DWEO
        46216 == code || // Lo       HANGUL SYLLABLE DWE
        46244 == code || // Lo       HANGUL SYLLABLE DWI
        46272 == code || // Lo       HANGUL SYLLABLE DYU
        46300 == code || // Lo       HANGUL SYLLABLE DEU
        46328 == code || // Lo       HANGUL SYLLABLE DYI
        46356 == code || // Lo       HANGUL SYLLABLE DI
        46384 == code || // Lo       HANGUL SYLLABLE DDA
        46412 == code || // Lo       HANGUL SYLLABLE DDAE
        46440 == code || // Lo       HANGUL SYLLABLE DDYA
        46468 == code || // Lo       HANGUL SYLLABLE DDYAE
        46496 == code || // Lo       HANGUL SYLLABLE DDEO
        46524 == code || // Lo       HANGUL SYLLABLE DDE
        46552 == code || // Lo       HANGUL SYLLABLE DDYEO
        46580 == code || // Lo       HANGUL SYLLABLE DDYE
        46608 == code || // Lo       HANGUL SYLLABLE DDO
        46636 == code || // Lo       HANGUL SYLLABLE DDWA
        46664 == code || // Lo       HANGUL SYLLABLE DDWAE
        46692 == code || // Lo       HANGUL SYLLABLE DDOE
        46720 == code || // Lo       HANGUL SYLLABLE DDYO
        46748 == code || // Lo       HANGUL SYLLABLE DDU
        46776 == code || // Lo       HANGUL SYLLABLE DDWEO
        46804 == code || // Lo       HANGUL SYLLABLE DDWE
        46832 == code || // Lo       HANGUL SYLLABLE DDWI
        46860 == code || // Lo       HANGUL SYLLABLE DDYU
        46888 == code || // Lo       HANGUL SYLLABLE DDEU
        46916 == code || // Lo       HANGUL SYLLABLE DDYI
        46944 == code || // Lo       HANGUL SYLLABLE DDI
        46972 == code || // Lo       HANGUL SYLLABLE RA
        47e3 == code || // Lo       HANGUL SYLLABLE RAE
        47028 == code || // Lo       HANGUL SYLLABLE RYA
        47056 == code || // Lo       HANGUL SYLLABLE RYAE
        47084 == code || // Lo       HANGUL SYLLABLE REO
        47112 == code || // Lo       HANGUL SYLLABLE RE
        47140 == code || // Lo       HANGUL SYLLABLE RYEO
        47168 == code || // Lo       HANGUL SYLLABLE RYE
        47196 == code || // Lo       HANGUL SYLLABLE RO
        47224 == code || // Lo       HANGUL SYLLABLE RWA
        47252 == code || // Lo       HANGUL SYLLABLE RWAE
        47280 == code || // Lo       HANGUL SYLLABLE ROE
        47308 == code || // Lo       HANGUL SYLLABLE RYO
        47336 == code || // Lo       HANGUL SYLLABLE RU
        47364 == code || // Lo       HANGUL SYLLABLE RWEO
        47392 == code || // Lo       HANGUL SYLLABLE RWE
        47420 == code || // Lo       HANGUL SYLLABLE RWI
        47448 == code || // Lo       HANGUL SYLLABLE RYU
        47476 == code || // Lo       HANGUL SYLLABLE REU
        47504 == code || // Lo       HANGUL SYLLABLE RYI
        47532 == code || // Lo       HANGUL SYLLABLE RI
        47560 == code || // Lo       HANGUL SYLLABLE MA
        47588 == code || // Lo       HANGUL SYLLABLE MAE
        47616 == code || // Lo       HANGUL SYLLABLE MYA
        47644 == code || // Lo       HANGUL SYLLABLE MYAE
        47672 == code || // Lo       HANGUL SYLLABLE MEO
        47700 == code || // Lo       HANGUL SYLLABLE ME
        47728 == code || // Lo       HANGUL SYLLABLE MYEO
        47756 == code || // Lo       HANGUL SYLLABLE MYE
        47784 == code || // Lo       HANGUL SYLLABLE MO
        47812 == code || // Lo       HANGUL SYLLABLE MWA
        47840 == code || // Lo       HANGUL SYLLABLE MWAE
        47868 == code || // Lo       HANGUL SYLLABLE MOE
        47896 == code || // Lo       HANGUL SYLLABLE MYO
        47924 == code || // Lo       HANGUL SYLLABLE MU
        47952 == code || // Lo       HANGUL SYLLABLE MWEO
        47980 == code || // Lo       HANGUL SYLLABLE MWE
        48008 == code || // Lo       HANGUL SYLLABLE MWI
        48036 == code || // Lo       HANGUL SYLLABLE MYU
        48064 == code || // Lo       HANGUL SYLLABLE MEU
        48092 == code || // Lo       HANGUL SYLLABLE MYI
        48120 == code || // Lo       HANGUL SYLLABLE MI
        48148 == code || // Lo       HANGUL SYLLABLE BA
        48176 == code || // Lo       HANGUL SYLLABLE BAE
        48204 == code || // Lo       HANGUL SYLLABLE BYA
        48232 == code || // Lo       HANGUL SYLLABLE BYAE
        48260 == code || // Lo       HANGUL SYLLABLE BEO
        48288 == code || // Lo       HANGUL SYLLABLE BE
        48316 == code || // Lo       HANGUL SYLLABLE BYEO
        48344 == code || // Lo       HANGUL SYLLABLE BYE
        48372 == code || // Lo       HANGUL SYLLABLE BO
        48400 == code || // Lo       HANGUL SYLLABLE BWA
        48428 == code || // Lo       HANGUL SYLLABLE BWAE
        48456 == code || // Lo       HANGUL SYLLABLE BOE
        48484 == code || // Lo       HANGUL SYLLABLE BYO
        48512 == code || // Lo       HANGUL SYLLABLE BU
        48540 == code || // Lo       HANGUL SYLLABLE BWEO
        48568 == code || // Lo       HANGUL SYLLABLE BWE
        48596 == code || // Lo       HANGUL SYLLABLE BWI
        48624 == code || // Lo       HANGUL SYLLABLE BYU
        48652 == code || // Lo       HANGUL SYLLABLE BEU
        48680 == code || // Lo       HANGUL SYLLABLE BYI
        48708 == code || // Lo       HANGUL SYLLABLE BI
        48736 == code || // Lo       HANGUL SYLLABLE BBA
        48764 == code || // Lo       HANGUL SYLLABLE BBAE
        48792 == code || // Lo       HANGUL SYLLABLE BBYA
        48820 == code || // Lo       HANGUL SYLLABLE BBYAE
        48848 == code || // Lo       HANGUL SYLLABLE BBEO
        48876 == code || // Lo       HANGUL SYLLABLE BBE
        48904 == code || // Lo       HANGUL SYLLABLE BBYEO
        48932 == code || // Lo       HANGUL SYLLABLE BBYE
        48960 == code || // Lo       HANGUL SYLLABLE BBO
        48988 == code || // Lo       HANGUL SYLLABLE BBWA
        49016 == code || // Lo       HANGUL SYLLABLE BBWAE
        49044 == code || // Lo       HANGUL SYLLABLE BBOE
        49072 == code || // Lo       HANGUL SYLLABLE BBYO
        49100 == code || // Lo       HANGUL SYLLABLE BBU
        49128 == code || // Lo       HANGUL SYLLABLE BBWEO
        49156 == code || // Lo       HANGUL SYLLABLE BBWE
        49184 == code || // Lo       HANGUL SYLLABLE BBWI
        49212 == code || // Lo       HANGUL SYLLABLE BBYU
        49240 == code || // Lo       HANGUL SYLLABLE BBEU
        49268 == code || // Lo       HANGUL SYLLABLE BBYI
        49296 == code || // Lo       HANGUL SYLLABLE BBI
        49324 == code || // Lo       HANGUL SYLLABLE SA
        49352 == code || // Lo       HANGUL SYLLABLE SAE
        49380 == code || // Lo       HANGUL SYLLABLE SYA
        49408 == code || // Lo       HANGUL SYLLABLE SYAE
        49436 == code || // Lo       HANGUL SYLLABLE SEO
        49464 == code || // Lo       HANGUL SYLLABLE SE
        49492 == code || // Lo       HANGUL SYLLABLE SYEO
        49520 == code || // Lo       HANGUL SYLLABLE SYE
        49548 == code || // Lo       HANGUL SYLLABLE SO
        49576 == code || // Lo       HANGUL SYLLABLE SWA
        49604 == code || // Lo       HANGUL SYLLABLE SWAE
        49632 == code || // Lo       HANGUL SYLLABLE SOE
        49660 == code || // Lo       HANGUL SYLLABLE SYO
        49688 == code || // Lo       HANGUL SYLLABLE SU
        49716 == code || // Lo       HANGUL SYLLABLE SWEO
        49744 == code || // Lo       HANGUL SYLLABLE SWE
        49772 == code || // Lo       HANGUL SYLLABLE SWI
        49800 == code || // Lo       HANGUL SYLLABLE SYU
        49828 == code || // Lo       HANGUL SYLLABLE SEU
        49856 == code || // Lo       HANGUL SYLLABLE SYI
        49884 == code || // Lo       HANGUL SYLLABLE SI
        49912 == code || // Lo       HANGUL SYLLABLE SSA
        49940 == code || // Lo       HANGUL SYLLABLE SSAE
        49968 == code || // Lo       HANGUL SYLLABLE SSYA
        49996 == code || // Lo       HANGUL SYLLABLE SSYAE
        50024 == code || // Lo       HANGUL SYLLABLE SSEO
        50052 == code || // Lo       HANGUL SYLLABLE SSE
        50080 == code || // Lo       HANGUL SYLLABLE SSYEO
        50108 == code || // Lo       HANGUL SYLLABLE SSYE
        50136 == code || // Lo       HANGUL SYLLABLE SSO
        50164 == code || // Lo       HANGUL SYLLABLE SSWA
        50192 == code || // Lo       HANGUL SYLLABLE SSWAE
        50220 == code || // Lo       HANGUL SYLLABLE SSOE
        50248 == code || // Lo       HANGUL SYLLABLE SSYO
        50276 == code || // Lo       HANGUL SYLLABLE SSU
        50304 == code || // Lo       HANGUL SYLLABLE SSWEO
        50332 == code || // Lo       HANGUL SYLLABLE SSWE
        50360 == code || // Lo       HANGUL SYLLABLE SSWI
        50388 == code || // Lo       HANGUL SYLLABLE SSYU
        50416 == code || // Lo       HANGUL SYLLABLE SSEU
        50444 == code || // Lo       HANGUL SYLLABLE SSYI
        50472 == code || // Lo       HANGUL SYLLABLE SSI
        50500 == code || // Lo       HANGUL SYLLABLE A
        50528 == code || // Lo       HANGUL SYLLABLE AE
        50556 == code || // Lo       HANGUL SYLLABLE YA
        50584 == code || // Lo       HANGUL SYLLABLE YAE
        50612 == code || // Lo       HANGUL SYLLABLE EO
        50640 == code || // Lo       HANGUL SYLLABLE E
        50668 == code || // Lo       HANGUL SYLLABLE YEO
        50696 == code || // Lo       HANGUL SYLLABLE YE
        50724 == code || // Lo       HANGUL SYLLABLE O
        50752 == code || // Lo       HANGUL SYLLABLE WA
        50780 == code || // Lo       HANGUL SYLLABLE WAE
        50808 == code || // Lo       HANGUL SYLLABLE OE
        50836 == code || // Lo       HANGUL SYLLABLE YO
        50864 == code || // Lo       HANGUL SYLLABLE U
        50892 == code || // Lo       HANGUL SYLLABLE WEO
        50920 == code || // Lo       HANGUL SYLLABLE WE
        50948 == code || // Lo       HANGUL SYLLABLE WI
        50976 == code || // Lo       HANGUL SYLLABLE YU
        51004 == code || // Lo       HANGUL SYLLABLE EU
        51032 == code || // Lo       HANGUL SYLLABLE YI
        51060 == code || // Lo       HANGUL SYLLABLE I
        51088 == code || // Lo       HANGUL SYLLABLE JA
        51116 == code || // Lo       HANGUL SYLLABLE JAE
        51144 == code || // Lo       HANGUL SYLLABLE JYA
        51172 == code || // Lo       HANGUL SYLLABLE JYAE
        51200 == code || // Lo       HANGUL SYLLABLE JEO
        51228 == code || // Lo       HANGUL SYLLABLE JE
        51256 == code || // Lo       HANGUL SYLLABLE JYEO
        51284 == code || // Lo       HANGUL SYLLABLE JYE
        51312 == code || // Lo       HANGUL SYLLABLE JO
        51340 == code || // Lo       HANGUL SYLLABLE JWA
        51368 == code || // Lo       HANGUL SYLLABLE JWAE
        51396 == code || // Lo       HANGUL SYLLABLE JOE
        51424 == code || // Lo       HANGUL SYLLABLE JYO
        51452 == code || // Lo       HANGUL SYLLABLE JU
        51480 == code || // Lo       HANGUL SYLLABLE JWEO
        51508 == code || // Lo       HANGUL SYLLABLE JWE
        51536 == code || // Lo       HANGUL SYLLABLE JWI
        51564 == code || // Lo       HANGUL SYLLABLE JYU
        51592 == code || // Lo       HANGUL SYLLABLE JEU
        51620 == code || // Lo       HANGUL SYLLABLE JYI
        51648 == code || // Lo       HANGUL SYLLABLE JI
        51676 == code || // Lo       HANGUL SYLLABLE JJA
        51704 == code || // Lo       HANGUL SYLLABLE JJAE
        51732 == code || // Lo       HANGUL SYLLABLE JJYA
        51760 == code || // Lo       HANGUL SYLLABLE JJYAE
        51788 == code || // Lo       HANGUL SYLLABLE JJEO
        51816 == code || // Lo       HANGUL SYLLABLE JJE
        51844 == code || // Lo       HANGUL SYLLABLE JJYEO
        51872 == code || // Lo       HANGUL SYLLABLE JJYE
        51900 == code || // Lo       HANGUL SYLLABLE JJO
        51928 == code || // Lo       HANGUL SYLLABLE JJWA
        51956 == code || // Lo       HANGUL SYLLABLE JJWAE
        51984 == code || // Lo       HANGUL SYLLABLE JJOE
        52012 == code || // Lo       HANGUL SYLLABLE JJYO
        52040 == code || // Lo       HANGUL SYLLABLE JJU
        52068 == code || // Lo       HANGUL SYLLABLE JJWEO
        52096 == code || // Lo       HANGUL SYLLABLE JJWE
        52124 == code || // Lo       HANGUL SYLLABLE JJWI
        52152 == code || // Lo       HANGUL SYLLABLE JJYU
        52180 == code || // Lo       HANGUL SYLLABLE JJEU
        52208 == code || // Lo       HANGUL SYLLABLE JJYI
        52236 == code || // Lo       HANGUL SYLLABLE JJI
        52264 == code || // Lo       HANGUL SYLLABLE CA
        52292 == code || // Lo       HANGUL SYLLABLE CAE
        52320 == code || // Lo       HANGUL SYLLABLE CYA
        52348 == code || // Lo       HANGUL SYLLABLE CYAE
        52376 == code || // Lo       HANGUL SYLLABLE CEO
        52404 == code || // Lo       HANGUL SYLLABLE CE
        52432 == code || // Lo       HANGUL SYLLABLE CYEO
        52460 == code || // Lo       HANGUL SYLLABLE CYE
        52488 == code || // Lo       HANGUL SYLLABLE CO
        52516 == code || // Lo       HANGUL SYLLABLE CWA
        52544 == code || // Lo       HANGUL SYLLABLE CWAE
        52572 == code || // Lo       HANGUL SYLLABLE COE
        52600 == code || // Lo       HANGUL SYLLABLE CYO
        52628 == code || // Lo       HANGUL SYLLABLE CU
        52656 == code || // Lo       HANGUL SYLLABLE CWEO
        52684 == code || // Lo       HANGUL SYLLABLE CWE
        52712 == code || // Lo       HANGUL SYLLABLE CWI
        52740 == code || // Lo       HANGUL SYLLABLE CYU
        52768 == code || // Lo       HANGUL SYLLABLE CEU
        52796 == code || // Lo       HANGUL SYLLABLE CYI
        52824 == code || // Lo       HANGUL SYLLABLE CI
        52852 == code || // Lo       HANGUL SYLLABLE KA
        52880 == code || // Lo       HANGUL SYLLABLE KAE
        52908 == code || // Lo       HANGUL SYLLABLE KYA
        52936 == code || // Lo       HANGUL SYLLABLE KYAE
        52964 == code || // Lo       HANGUL SYLLABLE KEO
        52992 == code || // Lo       HANGUL SYLLABLE KE
        53020 == code || // Lo       HANGUL SYLLABLE KYEO
        53048 == code || // Lo       HANGUL SYLLABLE KYE
        53076 == code || // Lo       HANGUL SYLLABLE KO
        53104 == code || // Lo       HANGUL SYLLABLE KWA
        53132 == code || // Lo       HANGUL SYLLABLE KWAE
        53160 == code || // Lo       HANGUL SYLLABLE KOE
        53188 == code || // Lo       HANGUL SYLLABLE KYO
        53216 == code || // Lo       HANGUL SYLLABLE KU
        53244 == code || // Lo       HANGUL SYLLABLE KWEO
        53272 == code || // Lo       HANGUL SYLLABLE KWE
        53300 == code || // Lo       HANGUL SYLLABLE KWI
        53328 == code || // Lo       HANGUL SYLLABLE KYU
        53356 == code || // Lo       HANGUL SYLLABLE KEU
        53384 == code || // Lo       HANGUL SYLLABLE KYI
        53412 == code || // Lo       HANGUL SYLLABLE KI
        53440 == code || // Lo       HANGUL SYLLABLE TA
        53468 == code || // Lo       HANGUL SYLLABLE TAE
        53496 == code || // Lo       HANGUL SYLLABLE TYA
        53524 == code || // Lo       HANGUL SYLLABLE TYAE
        53552 == code || // Lo       HANGUL SYLLABLE TEO
        53580 == code || // Lo       HANGUL SYLLABLE TE
        53608 == code || // Lo       HANGUL SYLLABLE TYEO
        53636 == code || // Lo       HANGUL SYLLABLE TYE
        53664 == code || // Lo       HANGUL SYLLABLE TO
        53692 == code || // Lo       HANGUL SYLLABLE TWA
        53720 == code || // Lo       HANGUL SYLLABLE TWAE
        53748 == code || // Lo       HANGUL SYLLABLE TOE
        53776 == code || // Lo       HANGUL SYLLABLE TYO
        53804 == code || // Lo       HANGUL SYLLABLE TU
        53832 == code || // Lo       HANGUL SYLLABLE TWEO
        53860 == code || // Lo       HANGUL SYLLABLE TWE
        53888 == code || // Lo       HANGUL SYLLABLE TWI
        53916 == code || // Lo       HANGUL SYLLABLE TYU
        53944 == code || // Lo       HANGUL SYLLABLE TEU
        53972 == code || // Lo       HANGUL SYLLABLE TYI
        54e3 == code || // Lo       HANGUL SYLLABLE TI
        54028 == code || // Lo       HANGUL SYLLABLE PA
        54056 == code || // Lo       HANGUL SYLLABLE PAE
        54084 == code || // Lo       HANGUL SYLLABLE PYA
        54112 == code || // Lo       HANGUL SYLLABLE PYAE
        54140 == code || // Lo       HANGUL SYLLABLE PEO
        54168 == code || // Lo       HANGUL SYLLABLE PE
        54196 == code || // Lo       HANGUL SYLLABLE PYEO
        54224 == code || // Lo       HANGUL SYLLABLE PYE
        54252 == code || // Lo       HANGUL SYLLABLE PO
        54280 == code || // Lo       HANGUL SYLLABLE PWA
        54308 == code || // Lo       HANGUL SYLLABLE PWAE
        54336 == code || // Lo       HANGUL SYLLABLE POE
        54364 == code || // Lo       HANGUL SYLLABLE PYO
        54392 == code || // Lo       HANGUL SYLLABLE PU
        54420 == code || // Lo       HANGUL SYLLABLE PWEO
        54448 == code || // Lo       HANGUL SYLLABLE PWE
        54476 == code || // Lo       HANGUL SYLLABLE PWI
        54504 == code || // Lo       HANGUL SYLLABLE PYU
        54532 == code || // Lo       HANGUL SYLLABLE PEU
        54560 == code || // Lo       HANGUL SYLLABLE PYI
        54588 == code || // Lo       HANGUL SYLLABLE PI
        54616 == code || // Lo       HANGUL SYLLABLE HA
        54644 == code || // Lo       HANGUL SYLLABLE HAE
        54672 == code || // Lo       HANGUL SYLLABLE HYA
        54700 == code || // Lo       HANGUL SYLLABLE HYAE
        54728 == code || // Lo       HANGUL SYLLABLE HEO
        54756 == code || // Lo       HANGUL SYLLABLE HE
        54784 == code || // Lo       HANGUL SYLLABLE HYEO
        54812 == code || // Lo       HANGUL SYLLABLE HYE
        54840 == code || // Lo       HANGUL SYLLABLE HO
        54868 == code || // Lo       HANGUL SYLLABLE HWA
        54896 == code || // Lo       HANGUL SYLLABLE HWAE
        54924 == code || // Lo       HANGUL SYLLABLE HOE
        54952 == code || // Lo       HANGUL SYLLABLE HYO
        54980 == code || // Lo       HANGUL SYLLABLE HU
        55008 == code || // Lo       HANGUL SYLLABLE HWEO
        55036 == code || // Lo       HANGUL SYLLABLE HWE
        55064 == code || // Lo       HANGUL SYLLABLE HWI
        55092 == code || // Lo       HANGUL SYLLABLE HYU
        55120 == code || // Lo       HANGUL SYLLABLE HEU
        55148 == code || // Lo       HANGUL SYLLABLE HYI
        55176 == code) {
          return LV;
        }
        if (44033 <= code && code <= 44059 || // Lo  [27] HANGUL SYLLABLE GAG..HANGUL SYLLABLE GAH
        44061 <= code && code <= 44087 || // Lo  [27] HANGUL SYLLABLE GAEG..HANGUL SYLLABLE GAEH
        44089 <= code && code <= 44115 || // Lo  [27] HANGUL SYLLABLE GYAG..HANGUL SYLLABLE GYAH
        44117 <= code && code <= 44143 || // Lo  [27] HANGUL SYLLABLE GYAEG..HANGUL SYLLABLE GYAEH
        44145 <= code && code <= 44171 || // Lo  [27] HANGUL SYLLABLE GEOG..HANGUL SYLLABLE GEOH
        44173 <= code && code <= 44199 || // Lo  [27] HANGUL SYLLABLE GEG..HANGUL SYLLABLE GEH
        44201 <= code && code <= 44227 || // Lo  [27] HANGUL SYLLABLE GYEOG..HANGUL SYLLABLE GYEOH
        44229 <= code && code <= 44255 || // Lo  [27] HANGUL SYLLABLE GYEG..HANGUL SYLLABLE GYEH
        44257 <= code && code <= 44283 || // Lo  [27] HANGUL SYLLABLE GOG..HANGUL SYLLABLE GOH
        44285 <= code && code <= 44311 || // Lo  [27] HANGUL SYLLABLE GWAG..HANGUL SYLLABLE GWAH
        44313 <= code && code <= 44339 || // Lo  [27] HANGUL SYLLABLE GWAEG..HANGUL SYLLABLE GWAEH
        44341 <= code && code <= 44367 || // Lo  [27] HANGUL SYLLABLE GOEG..HANGUL SYLLABLE GOEH
        44369 <= code && code <= 44395 || // Lo  [27] HANGUL SYLLABLE GYOG..HANGUL SYLLABLE GYOH
        44397 <= code && code <= 44423 || // Lo  [27] HANGUL SYLLABLE GUG..HANGUL SYLLABLE GUH
        44425 <= code && code <= 44451 || // Lo  [27] HANGUL SYLLABLE GWEOG..HANGUL SYLLABLE GWEOH
        44453 <= code && code <= 44479 || // Lo  [27] HANGUL SYLLABLE GWEG..HANGUL SYLLABLE GWEH
        44481 <= code && code <= 44507 || // Lo  [27] HANGUL SYLLABLE GWIG..HANGUL SYLLABLE GWIH
        44509 <= code && code <= 44535 || // Lo  [27] HANGUL SYLLABLE GYUG..HANGUL SYLLABLE GYUH
        44537 <= code && code <= 44563 || // Lo  [27] HANGUL SYLLABLE GEUG..HANGUL SYLLABLE GEUH
        44565 <= code && code <= 44591 || // Lo  [27] HANGUL SYLLABLE GYIG..HANGUL SYLLABLE GYIH
        44593 <= code && code <= 44619 || // Lo  [27] HANGUL SYLLABLE GIG..HANGUL SYLLABLE GIH
        44621 <= code && code <= 44647 || // Lo  [27] HANGUL SYLLABLE GGAG..HANGUL SYLLABLE GGAH
        44649 <= code && code <= 44675 || // Lo  [27] HANGUL SYLLABLE GGAEG..HANGUL SYLLABLE GGAEH
        44677 <= code && code <= 44703 || // Lo  [27] HANGUL SYLLABLE GGYAG..HANGUL SYLLABLE GGYAH
        44705 <= code && code <= 44731 || // Lo  [27] HANGUL SYLLABLE GGYAEG..HANGUL SYLLABLE GGYAEH
        44733 <= code && code <= 44759 || // Lo  [27] HANGUL SYLLABLE GGEOG..HANGUL SYLLABLE GGEOH
        44761 <= code && code <= 44787 || // Lo  [27] HANGUL SYLLABLE GGEG..HANGUL SYLLABLE GGEH
        44789 <= code && code <= 44815 || // Lo  [27] HANGUL SYLLABLE GGYEOG..HANGUL SYLLABLE GGYEOH
        44817 <= code && code <= 44843 || // Lo  [27] HANGUL SYLLABLE GGYEG..HANGUL SYLLABLE GGYEH
        44845 <= code && code <= 44871 || // Lo  [27] HANGUL SYLLABLE GGOG..HANGUL SYLLABLE GGOH
        44873 <= code && code <= 44899 || // Lo  [27] HANGUL SYLLABLE GGWAG..HANGUL SYLLABLE GGWAH
        44901 <= code && code <= 44927 || // Lo  [27] HANGUL SYLLABLE GGWAEG..HANGUL SYLLABLE GGWAEH
        44929 <= code && code <= 44955 || // Lo  [27] HANGUL SYLLABLE GGOEG..HANGUL SYLLABLE GGOEH
        44957 <= code && code <= 44983 || // Lo  [27] HANGUL SYLLABLE GGYOG..HANGUL SYLLABLE GGYOH
        44985 <= code && code <= 45011 || // Lo  [27] HANGUL SYLLABLE GGUG..HANGUL SYLLABLE GGUH
        45013 <= code && code <= 45039 || // Lo  [27] HANGUL SYLLABLE GGWEOG..HANGUL SYLLABLE GGWEOH
        45041 <= code && code <= 45067 || // Lo  [27] HANGUL SYLLABLE GGWEG..HANGUL SYLLABLE GGWEH
        45069 <= code && code <= 45095 || // Lo  [27] HANGUL SYLLABLE GGWIG..HANGUL SYLLABLE GGWIH
        45097 <= code && code <= 45123 || // Lo  [27] HANGUL SYLLABLE GGYUG..HANGUL SYLLABLE GGYUH
        45125 <= code && code <= 45151 || // Lo  [27] HANGUL SYLLABLE GGEUG..HANGUL SYLLABLE GGEUH
        45153 <= code && code <= 45179 || // Lo  [27] HANGUL SYLLABLE GGYIG..HANGUL SYLLABLE GGYIH
        45181 <= code && code <= 45207 || // Lo  [27] HANGUL SYLLABLE GGIG..HANGUL SYLLABLE GGIH
        45209 <= code && code <= 45235 || // Lo  [27] HANGUL SYLLABLE NAG..HANGUL SYLLABLE NAH
        45237 <= code && code <= 45263 || // Lo  [27] HANGUL SYLLABLE NAEG..HANGUL SYLLABLE NAEH
        45265 <= code && code <= 45291 || // Lo  [27] HANGUL SYLLABLE NYAG..HANGUL SYLLABLE NYAH
        45293 <= code && code <= 45319 || // Lo  [27] HANGUL SYLLABLE NYAEG..HANGUL SYLLABLE NYAEH
        45321 <= code && code <= 45347 || // Lo  [27] HANGUL SYLLABLE NEOG..HANGUL SYLLABLE NEOH
        45349 <= code && code <= 45375 || // Lo  [27] HANGUL SYLLABLE NEG..HANGUL SYLLABLE NEH
        45377 <= code && code <= 45403 || // Lo  [27] HANGUL SYLLABLE NYEOG..HANGUL SYLLABLE NYEOH
        45405 <= code && code <= 45431 || // Lo  [27] HANGUL SYLLABLE NYEG..HANGUL SYLLABLE NYEH
        45433 <= code && code <= 45459 || // Lo  [27] HANGUL SYLLABLE NOG..HANGUL SYLLABLE NOH
        45461 <= code && code <= 45487 || // Lo  [27] HANGUL SYLLABLE NWAG..HANGUL SYLLABLE NWAH
        45489 <= code && code <= 45515 || // Lo  [27] HANGUL SYLLABLE NWAEG..HANGUL SYLLABLE NWAEH
        45517 <= code && code <= 45543 || // Lo  [27] HANGUL SYLLABLE NOEG..HANGUL SYLLABLE NOEH
        45545 <= code && code <= 45571 || // Lo  [27] HANGUL SYLLABLE NYOG..HANGUL SYLLABLE NYOH
        45573 <= code && code <= 45599 || // Lo  [27] HANGUL SYLLABLE NUG..HANGUL SYLLABLE NUH
        45601 <= code && code <= 45627 || // Lo  [27] HANGUL SYLLABLE NWEOG..HANGUL SYLLABLE NWEOH
        45629 <= code && code <= 45655 || // Lo  [27] HANGUL SYLLABLE NWEG..HANGUL SYLLABLE NWEH
        45657 <= code && code <= 45683 || // Lo  [27] HANGUL SYLLABLE NWIG..HANGUL SYLLABLE NWIH
        45685 <= code && code <= 45711 || // Lo  [27] HANGUL SYLLABLE NYUG..HANGUL SYLLABLE NYUH
        45713 <= code && code <= 45739 || // Lo  [27] HANGUL SYLLABLE NEUG..HANGUL SYLLABLE NEUH
        45741 <= code && code <= 45767 || // Lo  [27] HANGUL SYLLABLE NYIG..HANGUL SYLLABLE NYIH
        45769 <= code && code <= 45795 || // Lo  [27] HANGUL SYLLABLE NIG..HANGUL SYLLABLE NIH
        45797 <= code && code <= 45823 || // Lo  [27] HANGUL SYLLABLE DAG..HANGUL SYLLABLE DAH
        45825 <= code && code <= 45851 || // Lo  [27] HANGUL SYLLABLE DAEG..HANGUL SYLLABLE DAEH
        45853 <= code && code <= 45879 || // Lo  [27] HANGUL SYLLABLE DYAG..HANGUL SYLLABLE DYAH
        45881 <= code && code <= 45907 || // Lo  [27] HANGUL SYLLABLE DYAEG..HANGUL SYLLABLE DYAEH
        45909 <= code && code <= 45935 || // Lo  [27] HANGUL SYLLABLE DEOG..HANGUL SYLLABLE DEOH
        45937 <= code && code <= 45963 || // Lo  [27] HANGUL SYLLABLE DEG..HANGUL SYLLABLE DEH
        45965 <= code && code <= 45991 || // Lo  [27] HANGUL SYLLABLE DYEOG..HANGUL SYLLABLE DYEOH
        45993 <= code && code <= 46019 || // Lo  [27] HANGUL SYLLABLE DYEG..HANGUL SYLLABLE DYEH
        46021 <= code && code <= 46047 || // Lo  [27] HANGUL SYLLABLE DOG..HANGUL SYLLABLE DOH
        46049 <= code && code <= 46075 || // Lo  [27] HANGUL SYLLABLE DWAG..HANGUL SYLLABLE DWAH
        46077 <= code && code <= 46103 || // Lo  [27] HANGUL SYLLABLE DWAEG..HANGUL SYLLABLE DWAEH
        46105 <= code && code <= 46131 || // Lo  [27] HANGUL SYLLABLE DOEG..HANGUL SYLLABLE DOEH
        46133 <= code && code <= 46159 || // Lo  [27] HANGUL SYLLABLE DYOG..HANGUL SYLLABLE DYOH
        46161 <= code && code <= 46187 || // Lo  [27] HANGUL SYLLABLE DUG..HANGUL SYLLABLE DUH
        46189 <= code && code <= 46215 || // Lo  [27] HANGUL SYLLABLE DWEOG..HANGUL SYLLABLE DWEOH
        46217 <= code && code <= 46243 || // Lo  [27] HANGUL SYLLABLE DWEG..HANGUL SYLLABLE DWEH
        46245 <= code && code <= 46271 || // Lo  [27] HANGUL SYLLABLE DWIG..HANGUL SYLLABLE DWIH
        46273 <= code && code <= 46299 || // Lo  [27] HANGUL SYLLABLE DYUG..HANGUL SYLLABLE DYUH
        46301 <= code && code <= 46327 || // Lo  [27] HANGUL SYLLABLE DEUG..HANGUL SYLLABLE DEUH
        46329 <= code && code <= 46355 || // Lo  [27] HANGUL SYLLABLE DYIG..HANGUL SYLLABLE DYIH
        46357 <= code && code <= 46383 || // Lo  [27] HANGUL SYLLABLE DIG..HANGUL SYLLABLE DIH
        46385 <= code && code <= 46411 || // Lo  [27] HANGUL SYLLABLE DDAG..HANGUL SYLLABLE DDAH
        46413 <= code && code <= 46439 || // Lo  [27] HANGUL SYLLABLE DDAEG..HANGUL SYLLABLE DDAEH
        46441 <= code && code <= 46467 || // Lo  [27] HANGUL SYLLABLE DDYAG..HANGUL SYLLABLE DDYAH
        46469 <= code && code <= 46495 || // Lo  [27] HANGUL SYLLABLE DDYAEG..HANGUL SYLLABLE DDYAEH
        46497 <= code && code <= 46523 || // Lo  [27] HANGUL SYLLABLE DDEOG..HANGUL SYLLABLE DDEOH
        46525 <= code && code <= 46551 || // Lo  [27] HANGUL SYLLABLE DDEG..HANGUL SYLLABLE DDEH
        46553 <= code && code <= 46579 || // Lo  [27] HANGUL SYLLABLE DDYEOG..HANGUL SYLLABLE DDYEOH
        46581 <= code && code <= 46607 || // Lo  [27] HANGUL SYLLABLE DDYEG..HANGUL SYLLABLE DDYEH
        46609 <= code && code <= 46635 || // Lo  [27] HANGUL SYLLABLE DDOG..HANGUL SYLLABLE DDOH
        46637 <= code && code <= 46663 || // Lo  [27] HANGUL SYLLABLE DDWAG..HANGUL SYLLABLE DDWAH
        46665 <= code && code <= 46691 || // Lo  [27] HANGUL SYLLABLE DDWAEG..HANGUL SYLLABLE DDWAEH
        46693 <= code && code <= 46719 || // Lo  [27] HANGUL SYLLABLE DDOEG..HANGUL SYLLABLE DDOEH
        46721 <= code && code <= 46747 || // Lo  [27] HANGUL SYLLABLE DDYOG..HANGUL SYLLABLE DDYOH
        46749 <= code && code <= 46775 || // Lo  [27] HANGUL SYLLABLE DDUG..HANGUL SYLLABLE DDUH
        46777 <= code && code <= 46803 || // Lo  [27] HANGUL SYLLABLE DDWEOG..HANGUL SYLLABLE DDWEOH
        46805 <= code && code <= 46831 || // Lo  [27] HANGUL SYLLABLE DDWEG..HANGUL SYLLABLE DDWEH
        46833 <= code && code <= 46859 || // Lo  [27] HANGUL SYLLABLE DDWIG..HANGUL SYLLABLE DDWIH
        46861 <= code && code <= 46887 || // Lo  [27] HANGUL SYLLABLE DDYUG..HANGUL SYLLABLE DDYUH
        46889 <= code && code <= 46915 || // Lo  [27] HANGUL SYLLABLE DDEUG..HANGUL SYLLABLE DDEUH
        46917 <= code && code <= 46943 || // Lo  [27] HANGUL SYLLABLE DDYIG..HANGUL SYLLABLE DDYIH
        46945 <= code && code <= 46971 || // Lo  [27] HANGUL SYLLABLE DDIG..HANGUL SYLLABLE DDIH
        46973 <= code && code <= 46999 || // Lo  [27] HANGUL SYLLABLE RAG..HANGUL SYLLABLE RAH
        47001 <= code && code <= 47027 || // Lo  [27] HANGUL SYLLABLE RAEG..HANGUL SYLLABLE RAEH
        47029 <= code && code <= 47055 || // Lo  [27] HANGUL SYLLABLE RYAG..HANGUL SYLLABLE RYAH
        47057 <= code && code <= 47083 || // Lo  [27] HANGUL SYLLABLE RYAEG..HANGUL SYLLABLE RYAEH
        47085 <= code && code <= 47111 || // Lo  [27] HANGUL SYLLABLE REOG..HANGUL SYLLABLE REOH
        47113 <= code && code <= 47139 || // Lo  [27] HANGUL SYLLABLE REG..HANGUL SYLLABLE REH
        47141 <= code && code <= 47167 || // Lo  [27] HANGUL SYLLABLE RYEOG..HANGUL SYLLABLE RYEOH
        47169 <= code && code <= 47195 || // Lo  [27] HANGUL SYLLABLE RYEG..HANGUL SYLLABLE RYEH
        47197 <= code && code <= 47223 || // Lo  [27] HANGUL SYLLABLE ROG..HANGUL SYLLABLE ROH
        47225 <= code && code <= 47251 || // Lo  [27] HANGUL SYLLABLE RWAG..HANGUL SYLLABLE RWAH
        47253 <= code && code <= 47279 || // Lo  [27] HANGUL SYLLABLE RWAEG..HANGUL SYLLABLE RWAEH
        47281 <= code && code <= 47307 || // Lo  [27] HANGUL SYLLABLE ROEG..HANGUL SYLLABLE ROEH
        47309 <= code && code <= 47335 || // Lo  [27] HANGUL SYLLABLE RYOG..HANGUL SYLLABLE RYOH
        47337 <= code && code <= 47363 || // Lo  [27] HANGUL SYLLABLE RUG..HANGUL SYLLABLE RUH
        47365 <= code && code <= 47391 || // Lo  [27] HANGUL SYLLABLE RWEOG..HANGUL SYLLABLE RWEOH
        47393 <= code && code <= 47419 || // Lo  [27] HANGUL SYLLABLE RWEG..HANGUL SYLLABLE RWEH
        47421 <= code && code <= 47447 || // Lo  [27] HANGUL SYLLABLE RWIG..HANGUL SYLLABLE RWIH
        47449 <= code && code <= 47475 || // Lo  [27] HANGUL SYLLABLE RYUG..HANGUL SYLLABLE RYUH
        47477 <= code && code <= 47503 || // Lo  [27] HANGUL SYLLABLE REUG..HANGUL SYLLABLE REUH
        47505 <= code && code <= 47531 || // Lo  [27] HANGUL SYLLABLE RYIG..HANGUL SYLLABLE RYIH
        47533 <= code && code <= 47559 || // Lo  [27] HANGUL SYLLABLE RIG..HANGUL SYLLABLE RIH
        47561 <= code && code <= 47587 || // Lo  [27] HANGUL SYLLABLE MAG..HANGUL SYLLABLE MAH
        47589 <= code && code <= 47615 || // Lo  [27] HANGUL SYLLABLE MAEG..HANGUL SYLLABLE MAEH
        47617 <= code && code <= 47643 || // Lo  [27] HANGUL SYLLABLE MYAG..HANGUL SYLLABLE MYAH
        47645 <= code && code <= 47671 || // Lo  [27] HANGUL SYLLABLE MYAEG..HANGUL SYLLABLE MYAEH
        47673 <= code && code <= 47699 || // Lo  [27] HANGUL SYLLABLE MEOG..HANGUL SYLLABLE MEOH
        47701 <= code && code <= 47727 || // Lo  [27] HANGUL SYLLABLE MEG..HANGUL SYLLABLE MEH
        47729 <= code && code <= 47755 || // Lo  [27] HANGUL SYLLABLE MYEOG..HANGUL SYLLABLE MYEOH
        47757 <= code && code <= 47783 || // Lo  [27] HANGUL SYLLABLE MYEG..HANGUL SYLLABLE MYEH
        47785 <= code && code <= 47811 || // Lo  [27] HANGUL SYLLABLE MOG..HANGUL SYLLABLE MOH
        47813 <= code && code <= 47839 || // Lo  [27] HANGUL SYLLABLE MWAG..HANGUL SYLLABLE MWAH
        47841 <= code && code <= 47867 || // Lo  [27] HANGUL SYLLABLE MWAEG..HANGUL SYLLABLE MWAEH
        47869 <= code && code <= 47895 || // Lo  [27] HANGUL SYLLABLE MOEG..HANGUL SYLLABLE MOEH
        47897 <= code && code <= 47923 || // Lo  [27] HANGUL SYLLABLE MYOG..HANGUL SYLLABLE MYOH
        47925 <= code && code <= 47951 || // Lo  [27] HANGUL SYLLABLE MUG..HANGUL SYLLABLE MUH
        47953 <= code && code <= 47979 || // Lo  [27] HANGUL SYLLABLE MWEOG..HANGUL SYLLABLE MWEOH
        47981 <= code && code <= 48007 || // Lo  [27] HANGUL SYLLABLE MWEG..HANGUL SYLLABLE MWEH
        48009 <= code && code <= 48035 || // Lo  [27] HANGUL SYLLABLE MWIG..HANGUL SYLLABLE MWIH
        48037 <= code && code <= 48063 || // Lo  [27] HANGUL SYLLABLE MYUG..HANGUL SYLLABLE MYUH
        48065 <= code && code <= 48091 || // Lo  [27] HANGUL SYLLABLE MEUG..HANGUL SYLLABLE MEUH
        48093 <= code && code <= 48119 || // Lo  [27] HANGUL SYLLABLE MYIG..HANGUL SYLLABLE MYIH
        48121 <= code && code <= 48147 || // Lo  [27] HANGUL SYLLABLE MIG..HANGUL SYLLABLE MIH
        48149 <= code && code <= 48175 || // Lo  [27] HANGUL SYLLABLE BAG..HANGUL SYLLABLE BAH
        48177 <= code && code <= 48203 || // Lo  [27] HANGUL SYLLABLE BAEG..HANGUL SYLLABLE BAEH
        48205 <= code && code <= 48231 || // Lo  [27] HANGUL SYLLABLE BYAG..HANGUL SYLLABLE BYAH
        48233 <= code && code <= 48259 || // Lo  [27] HANGUL SYLLABLE BYAEG..HANGUL SYLLABLE BYAEH
        48261 <= code && code <= 48287 || // Lo  [27] HANGUL SYLLABLE BEOG..HANGUL SYLLABLE BEOH
        48289 <= code && code <= 48315 || // Lo  [27] HANGUL SYLLABLE BEG..HANGUL SYLLABLE BEH
        48317 <= code && code <= 48343 || // Lo  [27] HANGUL SYLLABLE BYEOG..HANGUL SYLLABLE BYEOH
        48345 <= code && code <= 48371 || // Lo  [27] HANGUL SYLLABLE BYEG..HANGUL SYLLABLE BYEH
        48373 <= code && code <= 48399 || // Lo  [27] HANGUL SYLLABLE BOG..HANGUL SYLLABLE BOH
        48401 <= code && code <= 48427 || // Lo  [27] HANGUL SYLLABLE BWAG..HANGUL SYLLABLE BWAH
        48429 <= code && code <= 48455 || // Lo  [27] HANGUL SYLLABLE BWAEG..HANGUL SYLLABLE BWAEH
        48457 <= code && code <= 48483 || // Lo  [27] HANGUL SYLLABLE BOEG..HANGUL SYLLABLE BOEH
        48485 <= code && code <= 48511 || // Lo  [27] HANGUL SYLLABLE BYOG..HANGUL SYLLABLE BYOH
        48513 <= code && code <= 48539 || // Lo  [27] HANGUL SYLLABLE BUG..HANGUL SYLLABLE BUH
        48541 <= code && code <= 48567 || // Lo  [27] HANGUL SYLLABLE BWEOG..HANGUL SYLLABLE BWEOH
        48569 <= code && code <= 48595 || // Lo  [27] HANGUL SYLLABLE BWEG..HANGUL SYLLABLE BWEH
        48597 <= code && code <= 48623 || // Lo  [27] HANGUL SYLLABLE BWIG..HANGUL SYLLABLE BWIH
        48625 <= code && code <= 48651 || // Lo  [27] HANGUL SYLLABLE BYUG..HANGUL SYLLABLE BYUH
        48653 <= code && code <= 48679 || // Lo  [27] HANGUL SYLLABLE BEUG..HANGUL SYLLABLE BEUH
        48681 <= code && code <= 48707 || // Lo  [27] HANGUL SYLLABLE BYIG..HANGUL SYLLABLE BYIH
        48709 <= code && code <= 48735 || // Lo  [27] HANGUL SYLLABLE BIG..HANGUL SYLLABLE BIH
        48737 <= code && code <= 48763 || // Lo  [27] HANGUL SYLLABLE BBAG..HANGUL SYLLABLE BBAH
        48765 <= code && code <= 48791 || // Lo  [27] HANGUL SYLLABLE BBAEG..HANGUL SYLLABLE BBAEH
        48793 <= code && code <= 48819 || // Lo  [27] HANGUL SYLLABLE BBYAG..HANGUL SYLLABLE BBYAH
        48821 <= code && code <= 48847 || // Lo  [27] HANGUL SYLLABLE BBYAEG..HANGUL SYLLABLE BBYAEH
        48849 <= code && code <= 48875 || // Lo  [27] HANGUL SYLLABLE BBEOG..HANGUL SYLLABLE BBEOH
        48877 <= code && code <= 48903 || // Lo  [27] HANGUL SYLLABLE BBEG..HANGUL SYLLABLE BBEH
        48905 <= code && code <= 48931 || // Lo  [27] HANGUL SYLLABLE BBYEOG..HANGUL SYLLABLE BBYEOH
        48933 <= code && code <= 48959 || // Lo  [27] HANGUL SYLLABLE BBYEG..HANGUL SYLLABLE BBYEH
        48961 <= code && code <= 48987 || // Lo  [27] HANGUL SYLLABLE BBOG..HANGUL SYLLABLE BBOH
        48989 <= code && code <= 49015 || // Lo  [27] HANGUL SYLLABLE BBWAG..HANGUL SYLLABLE BBWAH
        49017 <= code && code <= 49043 || // Lo  [27] HANGUL SYLLABLE BBWAEG..HANGUL SYLLABLE BBWAEH
        49045 <= code && code <= 49071 || // Lo  [27] HANGUL SYLLABLE BBOEG..HANGUL SYLLABLE BBOEH
        49073 <= code && code <= 49099 || // Lo  [27] HANGUL SYLLABLE BBYOG..HANGUL SYLLABLE BBYOH
        49101 <= code && code <= 49127 || // Lo  [27] HANGUL SYLLABLE BBUG..HANGUL SYLLABLE BBUH
        49129 <= code && code <= 49155 || // Lo  [27] HANGUL SYLLABLE BBWEOG..HANGUL SYLLABLE BBWEOH
        49157 <= code && code <= 49183 || // Lo  [27] HANGUL SYLLABLE BBWEG..HANGUL SYLLABLE BBWEH
        49185 <= code && code <= 49211 || // Lo  [27] HANGUL SYLLABLE BBWIG..HANGUL SYLLABLE BBWIH
        49213 <= code && code <= 49239 || // Lo  [27] HANGUL SYLLABLE BBYUG..HANGUL SYLLABLE BBYUH
        49241 <= code && code <= 49267 || // Lo  [27] HANGUL SYLLABLE BBEUG..HANGUL SYLLABLE BBEUH
        49269 <= code && code <= 49295 || // Lo  [27] HANGUL SYLLABLE BBYIG..HANGUL SYLLABLE BBYIH
        49297 <= code && code <= 49323 || // Lo  [27] HANGUL SYLLABLE BBIG..HANGUL SYLLABLE BBIH
        49325 <= code && code <= 49351 || // Lo  [27] HANGUL SYLLABLE SAG..HANGUL SYLLABLE SAH
        49353 <= code && code <= 49379 || // Lo  [27] HANGUL SYLLABLE SAEG..HANGUL SYLLABLE SAEH
        49381 <= code && code <= 49407 || // Lo  [27] HANGUL SYLLABLE SYAG..HANGUL SYLLABLE SYAH
        49409 <= code && code <= 49435 || // Lo  [27] HANGUL SYLLABLE SYAEG..HANGUL SYLLABLE SYAEH
        49437 <= code && code <= 49463 || // Lo  [27] HANGUL SYLLABLE SEOG..HANGUL SYLLABLE SEOH
        49465 <= code && code <= 49491 || // Lo  [27] HANGUL SYLLABLE SEG..HANGUL SYLLABLE SEH
        49493 <= code && code <= 49519 || // Lo  [27] HANGUL SYLLABLE SYEOG..HANGUL SYLLABLE SYEOH
        49521 <= code && code <= 49547 || // Lo  [27] HANGUL SYLLABLE SYEG..HANGUL SYLLABLE SYEH
        49549 <= code && code <= 49575 || // Lo  [27] HANGUL SYLLABLE SOG..HANGUL SYLLABLE SOH
        49577 <= code && code <= 49603 || // Lo  [27] HANGUL SYLLABLE SWAG..HANGUL SYLLABLE SWAH
        49605 <= code && code <= 49631 || // Lo  [27] HANGUL SYLLABLE SWAEG..HANGUL SYLLABLE SWAEH
        49633 <= code && code <= 49659 || // Lo  [27] HANGUL SYLLABLE SOEG..HANGUL SYLLABLE SOEH
        49661 <= code && code <= 49687 || // Lo  [27] HANGUL SYLLABLE SYOG..HANGUL SYLLABLE SYOH
        49689 <= code && code <= 49715 || // Lo  [27] HANGUL SYLLABLE SUG..HANGUL SYLLABLE SUH
        49717 <= code && code <= 49743 || // Lo  [27] HANGUL SYLLABLE SWEOG..HANGUL SYLLABLE SWEOH
        49745 <= code && code <= 49771 || // Lo  [27] HANGUL SYLLABLE SWEG..HANGUL SYLLABLE SWEH
        49773 <= code && code <= 49799 || // Lo  [27] HANGUL SYLLABLE SWIG..HANGUL SYLLABLE SWIH
        49801 <= code && code <= 49827 || // Lo  [27] HANGUL SYLLABLE SYUG..HANGUL SYLLABLE SYUH
        49829 <= code && code <= 49855 || // Lo  [27] HANGUL SYLLABLE SEUG..HANGUL SYLLABLE SEUH
        49857 <= code && code <= 49883 || // Lo  [27] HANGUL SYLLABLE SYIG..HANGUL SYLLABLE SYIH
        49885 <= code && code <= 49911 || // Lo  [27] HANGUL SYLLABLE SIG..HANGUL SYLLABLE SIH
        49913 <= code && code <= 49939 || // Lo  [27] HANGUL SYLLABLE SSAG..HANGUL SYLLABLE SSAH
        49941 <= code && code <= 49967 || // Lo  [27] HANGUL SYLLABLE SSAEG..HANGUL SYLLABLE SSAEH
        49969 <= code && code <= 49995 || // Lo  [27] HANGUL SYLLABLE SSYAG..HANGUL SYLLABLE SSYAH
        49997 <= code && code <= 50023 || // Lo  [27] HANGUL SYLLABLE SSYAEG..HANGUL SYLLABLE SSYAEH
        50025 <= code && code <= 50051 || // Lo  [27] HANGUL SYLLABLE SSEOG..HANGUL SYLLABLE SSEOH
        50053 <= code && code <= 50079 || // Lo  [27] HANGUL SYLLABLE SSEG..HANGUL SYLLABLE SSEH
        50081 <= code && code <= 50107 || // Lo  [27] HANGUL SYLLABLE SSYEOG..HANGUL SYLLABLE SSYEOH
        50109 <= code && code <= 50135 || // Lo  [27] HANGUL SYLLABLE SSYEG..HANGUL SYLLABLE SSYEH
        50137 <= code && code <= 50163 || // Lo  [27] HANGUL SYLLABLE SSOG..HANGUL SYLLABLE SSOH
        50165 <= code && code <= 50191 || // Lo  [27] HANGUL SYLLABLE SSWAG..HANGUL SYLLABLE SSWAH
        50193 <= code && code <= 50219 || // Lo  [27] HANGUL SYLLABLE SSWAEG..HANGUL SYLLABLE SSWAEH
        50221 <= code && code <= 50247 || // Lo  [27] HANGUL SYLLABLE SSOEG..HANGUL SYLLABLE SSOEH
        50249 <= code && code <= 50275 || // Lo  [27] HANGUL SYLLABLE SSYOG..HANGUL SYLLABLE SSYOH
        50277 <= code && code <= 50303 || // Lo  [27] HANGUL SYLLABLE SSUG..HANGUL SYLLABLE SSUH
        50305 <= code && code <= 50331 || // Lo  [27] HANGUL SYLLABLE SSWEOG..HANGUL SYLLABLE SSWEOH
        50333 <= code && code <= 50359 || // Lo  [27] HANGUL SYLLABLE SSWEG..HANGUL SYLLABLE SSWEH
        50361 <= code && code <= 50387 || // Lo  [27] HANGUL SYLLABLE SSWIG..HANGUL SYLLABLE SSWIH
        50389 <= code && code <= 50415 || // Lo  [27] HANGUL SYLLABLE SSYUG..HANGUL SYLLABLE SSYUH
        50417 <= code && code <= 50443 || // Lo  [27] HANGUL SYLLABLE SSEUG..HANGUL SYLLABLE SSEUH
        50445 <= code && code <= 50471 || // Lo  [27] HANGUL SYLLABLE SSYIG..HANGUL SYLLABLE SSYIH
        50473 <= code && code <= 50499 || // Lo  [27] HANGUL SYLLABLE SSIG..HANGUL SYLLABLE SSIH
        50501 <= code && code <= 50527 || // Lo  [27] HANGUL SYLLABLE AG..HANGUL SYLLABLE AH
        50529 <= code && code <= 50555 || // Lo  [27] HANGUL SYLLABLE AEG..HANGUL SYLLABLE AEH
        50557 <= code && code <= 50583 || // Lo  [27] HANGUL SYLLABLE YAG..HANGUL SYLLABLE YAH
        50585 <= code && code <= 50611 || // Lo  [27] HANGUL SYLLABLE YAEG..HANGUL SYLLABLE YAEH
        50613 <= code && code <= 50639 || // Lo  [27] HANGUL SYLLABLE EOG..HANGUL SYLLABLE EOH
        50641 <= code && code <= 50667 || // Lo  [27] HANGUL SYLLABLE EG..HANGUL SYLLABLE EH
        50669 <= code && code <= 50695 || // Lo  [27] HANGUL SYLLABLE YEOG..HANGUL SYLLABLE YEOH
        50697 <= code && code <= 50723 || // Lo  [27] HANGUL SYLLABLE YEG..HANGUL SYLLABLE YEH
        50725 <= code && code <= 50751 || // Lo  [27] HANGUL SYLLABLE OG..HANGUL SYLLABLE OH
        50753 <= code && code <= 50779 || // Lo  [27] HANGUL SYLLABLE WAG..HANGUL SYLLABLE WAH
        50781 <= code && code <= 50807 || // Lo  [27] HANGUL SYLLABLE WAEG..HANGUL SYLLABLE WAEH
        50809 <= code && code <= 50835 || // Lo  [27] HANGUL SYLLABLE OEG..HANGUL SYLLABLE OEH
        50837 <= code && code <= 50863 || // Lo  [27] HANGUL SYLLABLE YOG..HANGUL SYLLABLE YOH
        50865 <= code && code <= 50891 || // Lo  [27] HANGUL SYLLABLE UG..HANGUL SYLLABLE UH
        50893 <= code && code <= 50919 || // Lo  [27] HANGUL SYLLABLE WEOG..HANGUL SYLLABLE WEOH
        50921 <= code && code <= 50947 || // Lo  [27] HANGUL SYLLABLE WEG..HANGUL SYLLABLE WEH
        50949 <= code && code <= 50975 || // Lo  [27] HANGUL SYLLABLE WIG..HANGUL SYLLABLE WIH
        50977 <= code && code <= 51003 || // Lo  [27] HANGUL SYLLABLE YUG..HANGUL SYLLABLE YUH
        51005 <= code && code <= 51031 || // Lo  [27] HANGUL SYLLABLE EUG..HANGUL SYLLABLE EUH
        51033 <= code && code <= 51059 || // Lo  [27] HANGUL SYLLABLE YIG..HANGUL SYLLABLE YIH
        51061 <= code && code <= 51087 || // Lo  [27] HANGUL SYLLABLE IG..HANGUL SYLLABLE IH
        51089 <= code && code <= 51115 || // Lo  [27] HANGUL SYLLABLE JAG..HANGUL SYLLABLE JAH
        51117 <= code && code <= 51143 || // Lo  [27] HANGUL SYLLABLE JAEG..HANGUL SYLLABLE JAEH
        51145 <= code && code <= 51171 || // Lo  [27] HANGUL SYLLABLE JYAG..HANGUL SYLLABLE JYAH
        51173 <= code && code <= 51199 || // Lo  [27] HANGUL SYLLABLE JYAEG..HANGUL SYLLABLE JYAEH
        51201 <= code && code <= 51227 || // Lo  [27] HANGUL SYLLABLE JEOG..HANGUL SYLLABLE JEOH
        51229 <= code && code <= 51255 || // Lo  [27] HANGUL SYLLABLE JEG..HANGUL SYLLABLE JEH
        51257 <= code && code <= 51283 || // Lo  [27] HANGUL SYLLABLE JYEOG..HANGUL SYLLABLE JYEOH
        51285 <= code && code <= 51311 || // Lo  [27] HANGUL SYLLABLE JYEG..HANGUL SYLLABLE JYEH
        51313 <= code && code <= 51339 || // Lo  [27] HANGUL SYLLABLE JOG..HANGUL SYLLABLE JOH
        51341 <= code && code <= 51367 || // Lo  [27] HANGUL SYLLABLE JWAG..HANGUL SYLLABLE JWAH
        51369 <= code && code <= 51395 || // Lo  [27] HANGUL SYLLABLE JWAEG..HANGUL SYLLABLE JWAEH
        51397 <= code && code <= 51423 || // Lo  [27] HANGUL SYLLABLE JOEG..HANGUL SYLLABLE JOEH
        51425 <= code && code <= 51451 || // Lo  [27] HANGUL SYLLABLE JYOG..HANGUL SYLLABLE JYOH
        51453 <= code && code <= 51479 || // Lo  [27] HANGUL SYLLABLE JUG..HANGUL SYLLABLE JUH
        51481 <= code && code <= 51507 || // Lo  [27] HANGUL SYLLABLE JWEOG..HANGUL SYLLABLE JWEOH
        51509 <= code && code <= 51535 || // Lo  [27] HANGUL SYLLABLE JWEG..HANGUL SYLLABLE JWEH
        51537 <= code && code <= 51563 || // Lo  [27] HANGUL SYLLABLE JWIG..HANGUL SYLLABLE JWIH
        51565 <= code && code <= 51591 || // Lo  [27] HANGUL SYLLABLE JYUG..HANGUL SYLLABLE JYUH
        51593 <= code && code <= 51619 || // Lo  [27] HANGUL SYLLABLE JEUG..HANGUL SYLLABLE JEUH
        51621 <= code && code <= 51647 || // Lo  [27] HANGUL SYLLABLE JYIG..HANGUL SYLLABLE JYIH
        51649 <= code && code <= 51675 || // Lo  [27] HANGUL SYLLABLE JIG..HANGUL SYLLABLE JIH
        51677 <= code && code <= 51703 || // Lo  [27] HANGUL SYLLABLE JJAG..HANGUL SYLLABLE JJAH
        51705 <= code && code <= 51731 || // Lo  [27] HANGUL SYLLABLE JJAEG..HANGUL SYLLABLE JJAEH
        51733 <= code && code <= 51759 || // Lo  [27] HANGUL SYLLABLE JJYAG..HANGUL SYLLABLE JJYAH
        51761 <= code && code <= 51787 || // Lo  [27] HANGUL SYLLABLE JJYAEG..HANGUL SYLLABLE JJYAEH
        51789 <= code && code <= 51815 || // Lo  [27] HANGUL SYLLABLE JJEOG..HANGUL SYLLABLE JJEOH
        51817 <= code && code <= 51843 || // Lo  [27] HANGUL SYLLABLE JJEG..HANGUL SYLLABLE JJEH
        51845 <= code && code <= 51871 || // Lo  [27] HANGUL SYLLABLE JJYEOG..HANGUL SYLLABLE JJYEOH
        51873 <= code && code <= 51899 || // Lo  [27] HANGUL SYLLABLE JJYEG..HANGUL SYLLABLE JJYEH
        51901 <= code && code <= 51927 || // Lo  [27] HANGUL SYLLABLE JJOG..HANGUL SYLLABLE JJOH
        51929 <= code && code <= 51955 || // Lo  [27] HANGUL SYLLABLE JJWAG..HANGUL SYLLABLE JJWAH
        51957 <= code && code <= 51983 || // Lo  [27] HANGUL SYLLABLE JJWAEG..HANGUL SYLLABLE JJWAEH
        51985 <= code && code <= 52011 || // Lo  [27] HANGUL SYLLABLE JJOEG..HANGUL SYLLABLE JJOEH
        52013 <= code && code <= 52039 || // Lo  [27] HANGUL SYLLABLE JJYOG..HANGUL SYLLABLE JJYOH
        52041 <= code && code <= 52067 || // Lo  [27] HANGUL SYLLABLE JJUG..HANGUL SYLLABLE JJUH
        52069 <= code && code <= 52095 || // Lo  [27] HANGUL SYLLABLE JJWEOG..HANGUL SYLLABLE JJWEOH
        52097 <= code && code <= 52123 || // Lo  [27] HANGUL SYLLABLE JJWEG..HANGUL SYLLABLE JJWEH
        52125 <= code && code <= 52151 || // Lo  [27] HANGUL SYLLABLE JJWIG..HANGUL SYLLABLE JJWIH
        52153 <= code && code <= 52179 || // Lo  [27] HANGUL SYLLABLE JJYUG..HANGUL SYLLABLE JJYUH
        52181 <= code && code <= 52207 || // Lo  [27] HANGUL SYLLABLE JJEUG..HANGUL SYLLABLE JJEUH
        52209 <= code && code <= 52235 || // Lo  [27] HANGUL SYLLABLE JJYIG..HANGUL SYLLABLE JJYIH
        52237 <= code && code <= 52263 || // Lo  [27] HANGUL SYLLABLE JJIG..HANGUL SYLLABLE JJIH
        52265 <= code && code <= 52291 || // Lo  [27] HANGUL SYLLABLE CAG..HANGUL SYLLABLE CAH
        52293 <= code && code <= 52319 || // Lo  [27] HANGUL SYLLABLE CAEG..HANGUL SYLLABLE CAEH
        52321 <= code && code <= 52347 || // Lo  [27] HANGUL SYLLABLE CYAG..HANGUL SYLLABLE CYAH
        52349 <= code && code <= 52375 || // Lo  [27] HANGUL SYLLABLE CYAEG..HANGUL SYLLABLE CYAEH
        52377 <= code && code <= 52403 || // Lo  [27] HANGUL SYLLABLE CEOG..HANGUL SYLLABLE CEOH
        52405 <= code && code <= 52431 || // Lo  [27] HANGUL SYLLABLE CEG..HANGUL SYLLABLE CEH
        52433 <= code && code <= 52459 || // Lo  [27] HANGUL SYLLABLE CYEOG..HANGUL SYLLABLE CYEOH
        52461 <= code && code <= 52487 || // Lo  [27] HANGUL SYLLABLE CYEG..HANGUL SYLLABLE CYEH
        52489 <= code && code <= 52515 || // Lo  [27] HANGUL SYLLABLE COG..HANGUL SYLLABLE COH
        52517 <= code && code <= 52543 || // Lo  [27] HANGUL SYLLABLE CWAG..HANGUL SYLLABLE CWAH
        52545 <= code && code <= 52571 || // Lo  [27] HANGUL SYLLABLE CWAEG..HANGUL SYLLABLE CWAEH
        52573 <= code && code <= 52599 || // Lo  [27] HANGUL SYLLABLE COEG..HANGUL SYLLABLE COEH
        52601 <= code && code <= 52627 || // Lo  [27] HANGUL SYLLABLE CYOG..HANGUL SYLLABLE CYOH
        52629 <= code && code <= 52655 || // Lo  [27] HANGUL SYLLABLE CUG..HANGUL SYLLABLE CUH
        52657 <= code && code <= 52683 || // Lo  [27] HANGUL SYLLABLE CWEOG..HANGUL SYLLABLE CWEOH
        52685 <= code && code <= 52711 || // Lo  [27] HANGUL SYLLABLE CWEG..HANGUL SYLLABLE CWEH
        52713 <= code && code <= 52739 || // Lo  [27] HANGUL SYLLABLE CWIG..HANGUL SYLLABLE CWIH
        52741 <= code && code <= 52767 || // Lo  [27] HANGUL SYLLABLE CYUG..HANGUL SYLLABLE CYUH
        52769 <= code && code <= 52795 || // Lo  [27] HANGUL SYLLABLE CEUG..HANGUL SYLLABLE CEUH
        52797 <= code && code <= 52823 || // Lo  [27] HANGUL SYLLABLE CYIG..HANGUL SYLLABLE CYIH
        52825 <= code && code <= 52851 || // Lo  [27] HANGUL SYLLABLE CIG..HANGUL SYLLABLE CIH
        52853 <= code && code <= 52879 || // Lo  [27] HANGUL SYLLABLE KAG..HANGUL SYLLABLE KAH
        52881 <= code && code <= 52907 || // Lo  [27] HANGUL SYLLABLE KAEG..HANGUL SYLLABLE KAEH
        52909 <= code && code <= 52935 || // Lo  [27] HANGUL SYLLABLE KYAG..HANGUL SYLLABLE KYAH
        52937 <= code && code <= 52963 || // Lo  [27] HANGUL SYLLABLE KYAEG..HANGUL SYLLABLE KYAEH
        52965 <= code && code <= 52991 || // Lo  [27] HANGUL SYLLABLE KEOG..HANGUL SYLLABLE KEOH
        52993 <= code && code <= 53019 || // Lo  [27] HANGUL SYLLABLE KEG..HANGUL SYLLABLE KEH
        53021 <= code && code <= 53047 || // Lo  [27] HANGUL SYLLABLE KYEOG..HANGUL SYLLABLE KYEOH
        53049 <= code && code <= 53075 || // Lo  [27] HANGUL SYLLABLE KYEG..HANGUL SYLLABLE KYEH
        53077 <= code && code <= 53103 || // Lo  [27] HANGUL SYLLABLE KOG..HANGUL SYLLABLE KOH
        53105 <= code && code <= 53131 || // Lo  [27] HANGUL SYLLABLE KWAG..HANGUL SYLLABLE KWAH
        53133 <= code && code <= 53159 || // Lo  [27] HANGUL SYLLABLE KWAEG..HANGUL SYLLABLE KWAEH
        53161 <= code && code <= 53187 || // Lo  [27] HANGUL SYLLABLE KOEG..HANGUL SYLLABLE KOEH
        53189 <= code && code <= 53215 || // Lo  [27] HANGUL SYLLABLE KYOG..HANGUL SYLLABLE KYOH
        53217 <= code && code <= 53243 || // Lo  [27] HANGUL SYLLABLE KUG..HANGUL SYLLABLE KUH
        53245 <= code && code <= 53271 || // Lo  [27] HANGUL SYLLABLE KWEOG..HANGUL SYLLABLE KWEOH
        53273 <= code && code <= 53299 || // Lo  [27] HANGUL SYLLABLE KWEG..HANGUL SYLLABLE KWEH
        53301 <= code && code <= 53327 || // Lo  [27] HANGUL SYLLABLE KWIG..HANGUL SYLLABLE KWIH
        53329 <= code && code <= 53355 || // Lo  [27] HANGUL SYLLABLE KYUG..HANGUL SYLLABLE KYUH
        53357 <= code && code <= 53383 || // Lo  [27] HANGUL SYLLABLE KEUG..HANGUL SYLLABLE KEUH
        53385 <= code && code <= 53411 || // Lo  [27] HANGUL SYLLABLE KYIG..HANGUL SYLLABLE KYIH
        53413 <= code && code <= 53439 || // Lo  [27] HANGUL SYLLABLE KIG..HANGUL SYLLABLE KIH
        53441 <= code && code <= 53467 || // Lo  [27] HANGUL SYLLABLE TAG..HANGUL SYLLABLE TAH
        53469 <= code && code <= 53495 || // Lo  [27] HANGUL SYLLABLE TAEG..HANGUL SYLLABLE TAEH
        53497 <= code && code <= 53523 || // Lo  [27] HANGUL SYLLABLE TYAG..HANGUL SYLLABLE TYAH
        53525 <= code && code <= 53551 || // Lo  [27] HANGUL SYLLABLE TYAEG..HANGUL SYLLABLE TYAEH
        53553 <= code && code <= 53579 || // Lo  [27] HANGUL SYLLABLE TEOG..HANGUL SYLLABLE TEOH
        53581 <= code && code <= 53607 || // Lo  [27] HANGUL SYLLABLE TEG..HANGUL SYLLABLE TEH
        53609 <= code && code <= 53635 || // Lo  [27] HANGUL SYLLABLE TYEOG..HANGUL SYLLABLE TYEOH
        53637 <= code && code <= 53663 || // Lo  [27] HANGUL SYLLABLE TYEG..HANGUL SYLLABLE TYEH
        53665 <= code && code <= 53691 || // Lo  [27] HANGUL SYLLABLE TOG..HANGUL SYLLABLE TOH
        53693 <= code && code <= 53719 || // Lo  [27] HANGUL SYLLABLE TWAG..HANGUL SYLLABLE TWAH
        53721 <= code && code <= 53747 || // Lo  [27] HANGUL SYLLABLE TWAEG..HANGUL SYLLABLE TWAEH
        53749 <= code && code <= 53775 || // Lo  [27] HANGUL SYLLABLE TOEG..HANGUL SYLLABLE TOEH
        53777 <= code && code <= 53803 || // Lo  [27] HANGUL SYLLABLE TYOG..HANGUL SYLLABLE TYOH
        53805 <= code && code <= 53831 || // Lo  [27] HANGUL SYLLABLE TUG..HANGUL SYLLABLE TUH
        53833 <= code && code <= 53859 || // Lo  [27] HANGUL SYLLABLE TWEOG..HANGUL SYLLABLE TWEOH
        53861 <= code && code <= 53887 || // Lo  [27] HANGUL SYLLABLE TWEG..HANGUL SYLLABLE TWEH
        53889 <= code && code <= 53915 || // Lo  [27] HANGUL SYLLABLE TWIG..HANGUL SYLLABLE TWIH
        53917 <= code && code <= 53943 || // Lo  [27] HANGUL SYLLABLE TYUG..HANGUL SYLLABLE TYUH
        53945 <= code && code <= 53971 || // Lo  [27] HANGUL SYLLABLE TEUG..HANGUL SYLLABLE TEUH
        53973 <= code && code <= 53999 || // Lo  [27] HANGUL SYLLABLE TYIG..HANGUL SYLLABLE TYIH
        54001 <= code && code <= 54027 || // Lo  [27] HANGUL SYLLABLE TIG..HANGUL SYLLABLE TIH
        54029 <= code && code <= 54055 || // Lo  [27] HANGUL SYLLABLE PAG..HANGUL SYLLABLE PAH
        54057 <= code && code <= 54083 || // Lo  [27] HANGUL SYLLABLE PAEG..HANGUL SYLLABLE PAEH
        54085 <= code && code <= 54111 || // Lo  [27] HANGUL SYLLABLE PYAG..HANGUL SYLLABLE PYAH
        54113 <= code && code <= 54139 || // Lo  [27] HANGUL SYLLABLE PYAEG..HANGUL SYLLABLE PYAEH
        54141 <= code && code <= 54167 || // Lo  [27] HANGUL SYLLABLE PEOG..HANGUL SYLLABLE PEOH
        54169 <= code && code <= 54195 || // Lo  [27] HANGUL SYLLABLE PEG..HANGUL SYLLABLE PEH
        54197 <= code && code <= 54223 || // Lo  [27] HANGUL SYLLABLE PYEOG..HANGUL SYLLABLE PYEOH
        54225 <= code && code <= 54251 || // Lo  [27] HANGUL SYLLABLE PYEG..HANGUL SYLLABLE PYEH
        54253 <= code && code <= 54279 || // Lo  [27] HANGUL SYLLABLE POG..HANGUL SYLLABLE POH
        54281 <= code && code <= 54307 || // Lo  [27] HANGUL SYLLABLE PWAG..HANGUL SYLLABLE PWAH
        54309 <= code && code <= 54335 || // Lo  [27] HANGUL SYLLABLE PWAEG..HANGUL SYLLABLE PWAEH
        54337 <= code && code <= 54363 || // Lo  [27] HANGUL SYLLABLE POEG..HANGUL SYLLABLE POEH
        54365 <= code && code <= 54391 || // Lo  [27] HANGUL SYLLABLE PYOG..HANGUL SYLLABLE PYOH
        54393 <= code && code <= 54419 || // Lo  [27] HANGUL SYLLABLE PUG..HANGUL SYLLABLE PUH
        54421 <= code && code <= 54447 || // Lo  [27] HANGUL SYLLABLE PWEOG..HANGUL SYLLABLE PWEOH
        54449 <= code && code <= 54475 || // Lo  [27] HANGUL SYLLABLE PWEG..HANGUL SYLLABLE PWEH
        54477 <= code && code <= 54503 || // Lo  [27] HANGUL SYLLABLE PWIG..HANGUL SYLLABLE PWIH
        54505 <= code && code <= 54531 || // Lo  [27] HANGUL SYLLABLE PYUG..HANGUL SYLLABLE PYUH
        54533 <= code && code <= 54559 || // Lo  [27] HANGUL SYLLABLE PEUG..HANGUL SYLLABLE PEUH
        54561 <= code && code <= 54587 || // Lo  [27] HANGUL SYLLABLE PYIG..HANGUL SYLLABLE PYIH
        54589 <= code && code <= 54615 || // Lo  [27] HANGUL SYLLABLE PIG..HANGUL SYLLABLE PIH
        54617 <= code && code <= 54643 || // Lo  [27] HANGUL SYLLABLE HAG..HANGUL SYLLABLE HAH
        54645 <= code && code <= 54671 || // Lo  [27] HANGUL SYLLABLE HAEG..HANGUL SYLLABLE HAEH
        54673 <= code && code <= 54699 || // Lo  [27] HANGUL SYLLABLE HYAG..HANGUL SYLLABLE HYAH
        54701 <= code && code <= 54727 || // Lo  [27] HANGUL SYLLABLE HYAEG..HANGUL SYLLABLE HYAEH
        54729 <= code && code <= 54755 || // Lo  [27] HANGUL SYLLABLE HEOG..HANGUL SYLLABLE HEOH
        54757 <= code && code <= 54783 || // Lo  [27] HANGUL SYLLABLE HEG..HANGUL SYLLABLE HEH
        54785 <= code && code <= 54811 || // Lo  [27] HANGUL SYLLABLE HYEOG..HANGUL SYLLABLE HYEOH
        54813 <= code && code <= 54839 || // Lo  [27] HANGUL SYLLABLE HYEG..HANGUL SYLLABLE HYEH
        54841 <= code && code <= 54867 || // Lo  [27] HANGUL SYLLABLE HOG..HANGUL SYLLABLE HOH
        54869 <= code && code <= 54895 || // Lo  [27] HANGUL SYLLABLE HWAG..HANGUL SYLLABLE HWAH
        54897 <= code && code <= 54923 || // Lo  [27] HANGUL SYLLABLE HWAEG..HANGUL SYLLABLE HWAEH
        54925 <= code && code <= 54951 || // Lo  [27] HANGUL SYLLABLE HOEG..HANGUL SYLLABLE HOEH
        54953 <= code && code <= 54979 || // Lo  [27] HANGUL SYLLABLE HYOG..HANGUL SYLLABLE HYOH
        54981 <= code && code <= 55007 || // Lo  [27] HANGUL SYLLABLE HUG..HANGUL SYLLABLE HUH
        55009 <= code && code <= 55035 || // Lo  [27] HANGUL SYLLABLE HWEOG..HANGUL SYLLABLE HWEOH
        55037 <= code && code <= 55063 || // Lo  [27] HANGUL SYLLABLE HWEG..HANGUL SYLLABLE HWEH
        55065 <= code && code <= 55091 || // Lo  [27] HANGUL SYLLABLE HWIG..HANGUL SYLLABLE HWIH
        55093 <= code && code <= 55119 || // Lo  [27] HANGUL SYLLABLE HYUG..HANGUL SYLLABLE HYUH
        55121 <= code && code <= 55147 || // Lo  [27] HANGUL SYLLABLE HEUG..HANGUL SYLLABLE HEUH
        55149 <= code && code <= 55175 || // Lo  [27] HANGUL SYLLABLE HYIG..HANGUL SYLLABLE HYIH
        55177 <= code && code <= 55203) {
          return LVT;
        }
        if (9757 == code || // So       WHITE UP POINTING INDEX
        9977 == code || // So       PERSON WITH BALL
        9994 <= code && code <= 9997 || // So   [4] RAISED FIST..WRITING HAND
        127877 == code || // So       FATHER CHRISTMAS
        127938 <= code && code <= 127940 || // So   [3] SNOWBOARDER..SURFER
        127943 == code || // So       HORSE RACING
        127946 <= code && code <= 127948 || // So   [3] SWIMMER..GOLFER
        128066 <= code && code <= 128067 || // So   [2] EAR..NOSE
        128070 <= code && code <= 128080 || // So  [11] WHITE UP POINTING BACKHAND INDEX..OPEN HANDS SIGN
        128110 == code || // So       POLICE OFFICER
        128112 <= code && code <= 128120 || // So   [9] BRIDE WITH VEIL..PRINCESS
        128124 == code || // So       BABY ANGEL
        128129 <= code && code <= 128131 || // So   [3] INFORMATION DESK PERSON..DANCER
        128133 <= code && code <= 128135 || // So   [3] NAIL POLISH..HAIRCUT
        128170 == code || // So       FLEXED BICEPS
        128372 <= code && code <= 128373 || // So   [2] MAN IN BUSINESS SUIT LEVITATING..SLEUTH OR SPY
        128378 == code || // So       MAN DANCING
        128400 == code || // So       RAISED HAND WITH FINGERS SPLAYED
        128405 <= code && code <= 128406 || // So   [2] REVERSED HAND WITH MIDDLE FINGER EXTENDED..RAISED HAND WITH PART BETWEEN MIDDLE AND RING FINGERS
        128581 <= code && code <= 128583 || // So   [3] FACE WITH NO GOOD GESTURE..PERSON BOWING DEEPLY
        128587 <= code && code <= 128591 || // So   [5] HAPPY PERSON RAISING ONE HAND..PERSON WITH FOLDED HANDS
        128675 == code || // So       ROWBOAT
        128692 <= code && code <= 128694 || // So   [3] BICYCLIST..PEDESTRIAN
        128704 == code || // So       BATH
        128716 == code || // So       SLEEPING ACCOMMODATION
        129304 <= code && code <= 129308 || // So   [5] SIGN OF THE HORNS..RIGHT-FACING FIST
        129310 <= code && code <= 129311 || // So   [2] HAND WITH INDEX AND MIDDLE FINGERS CROSSED..I LOVE YOU HAND SIGN
        129318 == code || // So       FACE PALM
        129328 <= code && code <= 129337 || // So  [10] PREGNANT WOMAN..JUGGLING
        129341 <= code && code <= 129342 || // So   [2] WATER POLO..HANDBALL
        129489 <= code && code <= 129501) {
          return E_Base;
        }
        if (127995 <= code && code <= 127999) {
          return E_Modifier;
        }
        if (8205 == code) {
          return ZWJ;
        }
        if (9792 == code || // So       FEMALE SIGN
        9794 == code || // So       MALE SIGN
        9877 <= code && code <= 9878 || // So   [2] STAFF OF AESCULAPIUS..SCALES
        9992 == code || // So       AIRPLANE
        10084 == code || // So       HEAVY BLACK HEART
        127752 == code || // So       RAINBOW
        127806 == code || // So       EAR OF RICE
        127859 == code || // So       COOKING
        127891 == code || // So       GRADUATION CAP
        127908 == code || // So       MICROPHONE
        127912 == code || // So       ARTIST PALETTE
        127979 == code || // So       SCHOOL
        127981 == code || // So       FACTORY
        128139 == code || // So       KISS MARK
        128187 <= code && code <= 128188 || // So   [2] PERSONAL COMPUTER..BRIEFCASE
        128295 == code || // So       WRENCH
        128300 == code || // So       MICROSCOPE
        128488 == code || // So       LEFT SPEECH BUBBLE
        128640 == code || // So       ROCKET
        128658 == code) {
          return Glue_After_Zwj;
        }
        if (128102 <= code && code <= 128105) {
          return E_Base_GAZ;
        }
        return Other;
      }
      return this;
    }
    if (typeof module2 != "undefined" && module2.exports) {
      module2.exports = GraphemeSplitter2;
    }
  }
});

// node_modules/topojson-client/dist/topojson-client.js
var require_topojson_client = __commonJS({
  "node_modules/topojson-client/dist/topojson-client.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.topojson = global2.topojson || {}));
    })(exports2, function(exports3) {
      "use strict";
      function identity(x) {
        return x;
      }
      function transform3(transform4) {
        if (transform4 == null) return identity;
        var x0, y0, kx = transform4.scale[0], ky = transform4.scale[1], dx = transform4.translate[0], dy = transform4.translate[1];
        return function(input, i) {
          if (!i) x0 = y0 = 0;
          var j = 2, n = input.length, output = new Array(n);
          output[0] = (x0 += input[0]) * kx + dx;
          output[1] = (y0 += input[1]) * ky + dy;
          while (j < n) output[j] = input[j], ++j;
          return output;
        };
      }
      function bbox(topology) {
        var t = transform3(topology.transform), key, x0 = Infinity, y0 = x0, x1 = -x0, y1 = -x0;
        function bboxPoint(p) {
          p = t(p);
          if (p[0] < x0) x0 = p[0];
          if (p[0] > x1) x1 = p[0];
          if (p[1] < y0) y0 = p[1];
          if (p[1] > y1) y1 = p[1];
        }
        function bboxGeometry(o) {
          switch (o.type) {
            case "GeometryCollection":
              o.geometries.forEach(bboxGeometry);
              break;
            case "Point":
              bboxPoint(o.coordinates);
              break;
            case "MultiPoint":
              o.coordinates.forEach(bboxPoint);
              break;
          }
        }
        topology.arcs.forEach(function(arc) {
          var i = -1, n = arc.length, p;
          while (++i < n) {
            p = t(arc[i], i);
            if (p[0] < x0) x0 = p[0];
            if (p[0] > x1) x1 = p[0];
            if (p[1] < y0) y0 = p[1];
            if (p[1] > y1) y1 = p[1];
          }
        });
        for (key in topology.objects) {
          bboxGeometry(topology.objects[key]);
        }
        return [x0, y0, x1, y1];
      }
      function reverse(array, n) {
        var t, j = array.length, i = j - n;
        while (i < --j) t = array[i], array[i++] = array[j], array[j] = t;
      }
      function feature2(topology, o) {
        if (typeof o === "string") o = topology.objects[o];
        return o.type === "GeometryCollection" ? { type: "FeatureCollection", features: o.geometries.map(function(o2) {
          return feature$1(topology, o2);
        }) } : feature$1(topology, o);
      }
      function feature$1(topology, o) {
        var id = o.id, bbox2 = o.bbox, properties = o.properties == null ? {} : o.properties, geometry = object(topology, o);
        return id == null && bbox2 == null ? { type: "Feature", properties, geometry } : bbox2 == null ? { type: "Feature", id, properties, geometry } : { type: "Feature", id, bbox: bbox2, properties, geometry };
      }
      function object(topology, o) {
        var transformPoint2 = transform3(topology.transform), arcs = topology.arcs;
        function arc(i, points) {
          if (points.length) points.pop();
          for (var a3 = arcs[i < 0 ? ~i : i], k = 0, n = a3.length; k < n; ++k) {
            points.push(transformPoint2(a3[k], k));
          }
          if (i < 0) reverse(points, n);
        }
        function point(p) {
          return transformPoint2(p);
        }
        function line(arcs2) {
          var points = [];
          for (var i = 0, n = arcs2.length; i < n; ++i) arc(arcs2[i], points);
          if (points.length < 2) points.push(points[0]);
          return points;
        }
        function ring(arcs2) {
          var points = line(arcs2);
          while (points.length < 4) points.push(points[0]);
          return points;
        }
        function polygon2(arcs2) {
          return arcs2.map(ring);
        }
        function geometry(o2) {
          var type = o2.type, coordinates;
          switch (type) {
            case "GeometryCollection":
              return { type, geometries: o2.geometries.map(geometry) };
            case "Point":
              coordinates = point(o2.coordinates);
              break;
            case "MultiPoint":
              coordinates = o2.coordinates.map(point);
              break;
            case "LineString":
              coordinates = line(o2.arcs);
              break;
            case "MultiLineString":
              coordinates = o2.arcs.map(line);
              break;
            case "Polygon":
              coordinates = polygon2(o2.arcs);
              break;
            case "MultiPolygon":
              coordinates = o2.arcs.map(polygon2);
              break;
            default:
              return null;
          }
          return { type, coordinates };
        }
        return geometry(o);
      }
      function stitch(topology, arcs) {
        var stitchedArcs = {}, fragmentByStart = {}, fragmentByEnd = {}, fragments = [], emptyIndex = -1;
        arcs.forEach(function(i, j) {
          var arc = topology.arcs[i < 0 ? ~i : i], t;
          if (arc.length < 3 && !arc[1][0] && !arc[1][1]) {
            t = arcs[++emptyIndex], arcs[emptyIndex] = i, arcs[j] = t;
          }
        });
        arcs.forEach(function(i) {
          var e = ends(i), start = e[0], end = e[1], f, g2;
          if (f = fragmentByEnd[start]) {
            delete fragmentByEnd[f.end];
            f.push(i);
            f.end = end;
            if (g2 = fragmentByStart[end]) {
              delete fragmentByStart[g2.start];
              var fg = g2 === f ? f : f.concat(g2);
              fragmentByStart[fg.start = f.start] = fragmentByEnd[fg.end = g2.end] = fg;
            } else {
              fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
            }
          } else if (f = fragmentByStart[end]) {
            delete fragmentByStart[f.start];
            f.unshift(i);
            f.start = start;
            if (g2 = fragmentByEnd[start]) {
              delete fragmentByEnd[g2.end];
              var gf = g2 === f ? f : g2.concat(f);
              fragmentByStart[gf.start = g2.start] = fragmentByEnd[gf.end = f.end] = gf;
            } else {
              fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
            }
          } else {
            f = [i];
            fragmentByStart[f.start = start] = fragmentByEnd[f.end = end] = f;
          }
        });
        function ends(i) {
          var arc = topology.arcs[i < 0 ? ~i : i], p0 = arc[0], p1;
          if (topology.transform) p1 = [0, 0], arc.forEach(function(dp) {
            p1[0] += dp[0], p1[1] += dp[1];
          });
          else p1 = arc[arc.length - 1];
          return i < 0 ? [p1, p0] : [p0, p1];
        }
        function flush(fragmentByEnd2, fragmentByStart2) {
          for (var k in fragmentByEnd2) {
            var f = fragmentByEnd2[k];
            delete fragmentByStart2[f.start];
            delete f.start;
            delete f.end;
            f.forEach(function(i) {
              stitchedArcs[i < 0 ? ~i : i] = 1;
            });
            fragments.push(f);
          }
        }
        flush(fragmentByEnd, fragmentByStart);
        flush(fragmentByStart, fragmentByEnd);
        arcs.forEach(function(i) {
          if (!stitchedArcs[i < 0 ? ~i : i]) fragments.push([i]);
        });
        return fragments;
      }
      function mesh(topology) {
        return object(topology, meshArcs.apply(this, arguments));
      }
      function meshArcs(topology, object2, filter) {
        var arcs, i, n;
        if (arguments.length > 1) arcs = extractArcs(topology, object2, filter);
        else for (i = 0, arcs = new Array(n = topology.arcs.length); i < n; ++i) arcs[i] = i;
        return { type: "MultiLineString", arcs: stitch(topology, arcs) };
      }
      function extractArcs(topology, object2, filter) {
        var arcs = [], geomsByArc = [], geom;
        function extract0(i) {
          var j = i < 0 ? ~i : i;
          (geomsByArc[j] || (geomsByArc[j] = [])).push({ i, g: geom });
        }
        function extract1(arcs2) {
          arcs2.forEach(extract0);
        }
        function extract2(arcs2) {
          arcs2.forEach(extract1);
        }
        function extract3(arcs2) {
          arcs2.forEach(extract2);
        }
        function geometry(o) {
          switch (geom = o, o.type) {
            case "GeometryCollection":
              o.geometries.forEach(geometry);
              break;
            case "LineString":
              extract1(o.arcs);
              break;
            case "MultiLineString":
            case "Polygon":
              extract2(o.arcs);
              break;
            case "MultiPolygon":
              extract3(o.arcs);
              break;
          }
        }
        geometry(object2);
        geomsByArc.forEach(filter == null ? function(geoms) {
          arcs.push(geoms[0].i);
        } : function(geoms) {
          if (filter(geoms[0].g, geoms[geoms.length - 1].g)) arcs.push(geoms[0].i);
        });
        return arcs;
      }
      function planarRingArea(ring) {
        var i = -1, n = ring.length, a3, b = ring[n - 1], area2 = 0;
        while (++i < n) a3 = b, b = ring[i], area2 += a3[0] * b[1] - a3[1] * b[0];
        return Math.abs(area2);
      }
      function merge2(topology) {
        return object(topology, mergeArcs.apply(this, arguments));
      }
      function mergeArcs(topology, objects) {
        var polygonsByArc = {}, polygons = [], groups = [];
        objects.forEach(geometry);
        function geometry(o) {
          switch (o.type) {
            case "GeometryCollection":
              o.geometries.forEach(geometry);
              break;
            case "Polygon":
              extract(o.arcs);
              break;
            case "MultiPolygon":
              o.arcs.forEach(extract);
              break;
          }
        }
        function extract(polygon2) {
          polygon2.forEach(function(ring) {
            ring.forEach(function(arc) {
              (polygonsByArc[arc = arc < 0 ? ~arc : arc] || (polygonsByArc[arc] = [])).push(polygon2);
            });
          });
          polygons.push(polygon2);
        }
        function area2(ring) {
          return planarRingArea(object(topology, { type: "Polygon", arcs: [ring] }).coordinates[0]);
        }
        polygons.forEach(function(polygon2) {
          if (!polygon2._) {
            var group = [], neighbors2 = [polygon2];
            polygon2._ = 1;
            groups.push(group);
            while (polygon2 = neighbors2.pop()) {
              group.push(polygon2);
              polygon2.forEach(function(ring) {
                ring.forEach(function(arc) {
                  polygonsByArc[arc < 0 ? ~arc : arc].forEach(function(polygon3) {
                    if (!polygon3._) {
                      polygon3._ = 1;
                      neighbors2.push(polygon3);
                    }
                  });
                });
              });
            }
          }
        });
        polygons.forEach(function(polygon2) {
          delete polygon2._;
        });
        return {
          type: "MultiPolygon",
          arcs: groups.map(function(polygons2) {
            var arcs = [], n;
            polygons2.forEach(function(polygon2) {
              polygon2.forEach(function(ring) {
                ring.forEach(function(arc) {
                  if (polygonsByArc[arc < 0 ? ~arc : arc].length < 2) {
                    arcs.push(arc);
                  }
                });
              });
            });
            arcs = stitch(topology, arcs);
            if ((n = arcs.length) > 1) {
              for (var i = 1, k = area2(arcs[0]), ki, t; i < n; ++i) {
                if ((ki = area2(arcs[i])) > k) {
                  t = arcs[0], arcs[0] = arcs[i], arcs[i] = t, k = ki;
                }
              }
            }
            return arcs;
          }).filter(function(arcs) {
            return arcs.length > 0;
          })
        };
      }
      function bisect2(a3, x) {
        var lo = 0, hi = a3.length;
        while (lo < hi) {
          var mid = lo + hi >>> 1;
          if (a3[mid] < x) lo = mid + 1;
          else hi = mid;
        }
        return lo;
      }
      function neighbors(objects) {
        var indexesByArc = {}, neighbors2 = objects.map(function() {
          return [];
        });
        function line(arcs, i2) {
          arcs.forEach(function(a3) {
            if (a3 < 0) a3 = ~a3;
            var o = indexesByArc[a3];
            if (o) o.push(i2);
            else indexesByArc[a3] = [i2];
          });
        }
        function polygon2(arcs, i2) {
          arcs.forEach(function(arc) {
            line(arc, i2);
          });
        }
        function geometry(o, i2) {
          if (o.type === "GeometryCollection") o.geometries.forEach(function(o2) {
            geometry(o2, i2);
          });
          else if (o.type in geometryType) geometryType[o.type](o.arcs, i2);
        }
        var geometryType = {
          LineString: line,
          MultiLineString: polygon2,
          Polygon: polygon2,
          MultiPolygon: function(arcs, i2) {
            arcs.forEach(function(arc) {
              polygon2(arc, i2);
            });
          }
        };
        objects.forEach(geometry);
        for (var i in indexesByArc) {
          for (var indexes = indexesByArc[i], m = indexes.length, j = 0; j < m; ++j) {
            for (var k = j + 1; k < m; ++k) {
              var ij = indexes[j], ik = indexes[k], n;
              if ((n = neighbors2[ij])[i = bisect2(n, ik)] !== ik) n.splice(i, 0, ik);
              if ((n = neighbors2[ik])[i = bisect2(n, ij)] !== ij) n.splice(i, 0, ij);
            }
          }
        }
        return neighbors2;
      }
      function untransform(transform4) {
        if (transform4 == null) return identity;
        var x0, y0, kx = transform4.scale[0], ky = transform4.scale[1], dx = transform4.translate[0], dy = transform4.translate[1];
        return function(input, i) {
          if (!i) x0 = y0 = 0;
          var j = 2, n = input.length, output = new Array(n), x1 = Math.round((input[0] - dx) / kx), y1 = Math.round((input[1] - dy) / ky);
          output[0] = x1 - x0, x0 = x1;
          output[1] = y1 - y0, y0 = y1;
          while (j < n) output[j] = input[j], ++j;
          return output;
        };
      }
      function quantize(topology, transform4) {
        if (topology.transform) throw new Error("already quantized");
        if (!transform4 || !transform4.scale) {
          if (!((n = Math.floor(transform4)) >= 2)) throw new Error("n must be \u22652");
          box = topology.bbox || bbox(topology);
          var x0 = box[0], y0 = box[1], x1 = box[2], y1 = box[3], n;
          transform4 = { scale: [x1 - x0 ? (x1 - x0) / (n - 1) : 1, y1 - y0 ? (y1 - y0) / (n - 1) : 1], translate: [x0, y0] };
        } else {
          box = topology.bbox;
        }
        var t = untransform(transform4), box, key, inputs = topology.objects, outputs = {};
        function quantizePoint(point) {
          return t(point);
        }
        function quantizeGeometry(input) {
          var output;
          switch (input.type) {
            case "GeometryCollection":
              output = { type: "GeometryCollection", geometries: input.geometries.map(quantizeGeometry) };
              break;
            case "Point":
              output = { type: "Point", coordinates: quantizePoint(input.coordinates) };
              break;
            case "MultiPoint":
              output = { type: "MultiPoint", coordinates: input.coordinates.map(quantizePoint) };
              break;
            default:
              return input;
          }
          if (input.id != null) output.id = input.id;
          if (input.bbox != null) output.bbox = input.bbox;
          if (input.properties != null) output.properties = input.properties;
          return output;
        }
        function quantizeArc(input) {
          var i = 0, j = 1, n2 = input.length, p, output = new Array(n2);
          output[0] = t(input[0], 0);
          while (++i < n2) if ((p = t(input[i], i))[0] || p[1]) output[j++] = p;
          if (j === 1) output[j++] = [0, 0];
          output.length = j;
          return output;
        }
        for (key in inputs) outputs[key] = quantizeGeometry(inputs[key]);
        return {
          type: "Topology",
          bbox: box,
          transform: transform4,
          objects: outputs,
          arcs: topology.arcs.map(quantizeArc)
        };
      }
      exports3.bbox = bbox;
      exports3.feature = feature2;
      exports3.merge = merge2;
      exports3.mergeArcs = mergeArcs;
      exports3.mesh = mesh;
      exports3.meshArcs = meshArcs;
      exports3.neighbors = neighbors;
      exports3.quantize = quantize;
      exports3.transform = transform3;
      exports3.untransform = untransform;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// node_modules/tslib/tslib.es6.mjs
var tslib_es6_exports = {};
__export(tslib_es6_exports, {
  __addDisposableResource: () => __addDisposableResource,
  __assign: () => __assign,
  __asyncDelegator: () => __asyncDelegator,
  __asyncGenerator: () => __asyncGenerator,
  __asyncValues: () => __asyncValues,
  __await: () => __await,
  __awaiter: () => __awaiter,
  __classPrivateFieldGet: () => __classPrivateFieldGet,
  __classPrivateFieldIn: () => __classPrivateFieldIn,
  __classPrivateFieldSet: () => __classPrivateFieldSet,
  __createBinding: () => __createBinding,
  __decorate: () => __decorate,
  __disposeResources: () => __disposeResources,
  __esDecorate: () => __esDecorate,
  __exportStar: () => __exportStar,
  __extends: () => __extends,
  __generator: () => __generator,
  __importDefault: () => __importDefault,
  __importStar: () => __importStar,
  __makeTemplateObject: () => __makeTemplateObject,
  __metadata: () => __metadata,
  __param: () => __param,
  __propKey: () => __propKey,
  __read: () => __read,
  __rest: () => __rest,
  __rewriteRelativeImportExtension: () => __rewriteRelativeImportExtension,
  __runInitializers: () => __runInitializers,
  __setFunctionName: () => __setFunctionName,
  __spread: () => __spread,
  __spreadArray: () => __spreadArray,
  __spreadArrays: () => __spreadArrays,
  __values: () => __values,
  default: () => tslib_es6_default
});
function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
    throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
    t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
}
function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}
function __param(paramIndex, decorator) {
  return function(target, key) {
    decorator(target, key, paramIndex);
  };
}
function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
}
function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
}
function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
}
function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
}
function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}
function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve2) {
      resolve2(value);
    });
  }
  return new (P || (P = Promise))(function(resolve2, reject) {
    function fulfilled(value) {
      try {
        step2(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step2(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step2(result) {
      result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step2((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}
function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() {
    if (t[0] & 1) throw t[1];
    return t[1];
  }, trys: [], ops: [] }, f, y, t, g2 = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g2.next = verb(0), g2["throw"] = verb(1), g2["return"] = verb(2), typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
    return this;
  }), g2;
  function verb(n) {
    return function(v3) {
      return step2([n, v3]);
    };
  }
  function step2(op) {
    if (f) throw new TypeError("Generator is already executing.");
    while (g2 && (g2 = 0, op[0] && (_ = 0)), _) try {
      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
      if (y = 0, t) op = [op[0] & 2, t.value];
      switch (op[0]) {
        case 0:
        case 1:
          t = op;
          break;
        case 4:
          _.label++;
          return { value: op[1], done: false };
        case 5:
          _.label++;
          y = op[1];
          op = [0];
          continue;
        case 7:
          op = _.ops.pop();
          _.trys.pop();
          continue;
        default:
          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
            _ = 0;
            continue;
          }
          if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
            _.label = op[1];
            break;
          }
          if (op[0] === 6 && _.label < t[1]) {
            _.label = t[1];
            t = op;
            break;
          }
          if (t && _.label < t[2]) {
            _.label = t[2];
            _.ops.push(op);
            break;
          }
          if (t[2]) _.ops.pop();
          _.trys.pop();
          continue;
      }
      op = body.call(thisArg, _);
    } catch (e) {
      op = [6, e];
      y = 0;
    } finally {
      f = t = 0;
    }
    if (op[0] & 5) throw op[1];
    return { value: op[0] ? op[1] : void 0, done: true };
  }
}
function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}
function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
    next: function() {
      if (o && i >= o.length) o = void 0;
      return { value: o && o[i++], done: !o };
    }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  } catch (error) {
    e = { error };
  } finally {
    try {
      if (r && !r.done && (m = i["return"])) m.call(i);
    } finally {
      if (e) throw e.error;
    }
  }
  return ar;
}
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
    ar = ar.concat(__read(arguments[i]));
  return ar;
}
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
    for (var a3 = arguments[i], j = 0, jl = a3.length; j < jl; j++, k++)
      r[k] = a3[j];
  return r;
}
function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
    if (ar || !(i in from)) {
      if (!ar) ar = Array.prototype.slice.call(from, 0, i);
      ar[i] = from[i];
    }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}
function __await(v3) {
  return this instanceof __await ? (this.v = v3, this) : new __await(v3);
}
function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g2 = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function() {
    return this;
  }, i;
  function awaitReturn(f) {
    return function(v3) {
      return Promise.resolve(v3).then(f, reject);
    };
  }
  function verb(n, f) {
    if (g2[n]) {
      i[n] = function(v3) {
        return new Promise(function(a3, b) {
          q.push([n, v3, a3, b]) > 1 || resume(n, v3);
        });
      };
      if (f) i[n] = f(i[n]);
    }
  }
  function resume(n, v3) {
    try {
      step2(g2[n](v3));
    } catch (e) {
      settle(q[0][3], e);
    }
  }
  function step2(r) {
    r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }
  function fulfill(value) {
    resume("next", value);
  }
  function reject(value) {
    resume("throw", value);
  }
  function settle(f, v3) {
    if (f(v3), q.shift(), q.length) resume(q[0][0], q[0][1]);
  }
}
function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function(e) {
    throw e;
  }), verb("return"), i[Symbol.iterator] = function() {
    return this;
  }, i;
  function verb(n, f) {
    i[n] = o[n] ? function(v3) {
      return (p = !p) ? { value: __await(o[n](v3)), done: false } : f ? f(v3) : v3;
    } : f;
  }
}
function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
    return this;
  }, i);
  function verb(n) {
    i[n] = o[n] && function(v3) {
      return new Promise(function(resolve2, reject) {
        v3 = o[n](v3), settle(resolve2, reject, v3.done, v3.value);
      });
    };
  }
  function settle(resolve2, reject, d, v3) {
    Promise.resolve(v3).then(function(v4) {
      resolve2({ value: v4, done: d });
    }, reject);
  }
}
function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) {
    Object.defineProperty(cooked, "raw", { value: raw });
  } else {
    cooked.raw = raw;
  }
  return cooked;
}
function __importStar(mod2) {
  if (mod2 && mod2.__esModule) return mod2;
  var result = {};
  if (mod2 != null) {
    for (var k = ownKeys(mod2), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod2, k[i]);
  }
  __setModuleDefault(result, mod2);
  return result;
}
function __importDefault(mod2) {
  return mod2 && mod2.__esModule ? mod2 : { default: mod2 };
}
function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}
function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
}
function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function") throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}
function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() {
      try {
        inner.call(this);
      } catch (e) {
        return Promise.reject(e);
      }
    };
    env.stack.push({ value, dispose, async });
  } else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}
function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) {
            fail(e);
            return next();
          });
        } else s |= 1;
      } catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}
function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
    return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function(m, tsx, d, ext, cm) {
      return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : d + ext + "." + cm.toLowerCase() + "js";
    });
  }
  return path;
}
var extendStatics, __assign, __createBinding, __setModuleDefault, ownKeys, _SuppressedError, tslib_es6_default;
var init_tslib_es6 = __esm({
  "node_modules/tslib/tslib.es6.mjs"() {
    extendStatics = function(d, b) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
        d2.__proto__ = b2;
      } || function(d2, b2) {
        for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
      };
      return extendStatics(d, b);
    };
    __assign = function() {
      __assign = Object.assign || function __assign2(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
      };
      return __assign.apply(this, arguments);
    };
    __createBinding = Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    __setModuleDefault = Object.create ? (function(o, v3) {
      Object.defineProperty(o, "default", { enumerable: true, value: v3 });
    }) : function(o, v3) {
      o["default"] = v3;
    };
    ownKeys = function(o) {
      ownKeys = Object.getOwnPropertyNames || function(o2) {
        var ar = [];
        for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
        return ar;
      };
      return ownKeys(o);
    };
    _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
      var e = new Error(message);
      return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };
    tslib_es6_default = {
      __extends,
      __assign,
      __rest,
      __decorate,
      __param,
      __esDecorate,
      __runInitializers,
      __propKey,
      __setFunctionName,
      __metadata,
      __awaiter,
      __generator,
      __createBinding,
      __exportStar,
      __values,
      __read,
      __spread,
      __spreadArrays,
      __spreadArray,
      __await,
      __asyncGenerator,
      __asyncDelegator,
      __asyncValues,
      __makeTemplateObject,
      __importStar,
      __importDefault,
      __classPrivateFieldGet,
      __classPrivateFieldSet,
      __classPrivateFieldIn,
      __addDisposableResource,
      __disposeResources,
      __rewriteRelativeImportExtension
    };
  }
});

// node_modules/autolinker/dist/commonjs/version.js
var require_version = __commonJS({
  "node_modules/autolinker/dist/commonjs/version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "4.1.5";
  }
});

// node_modules/autolinker/dist/commonjs/utils.js
var require_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.hasOwnProperty = void 0;
    exports2.isBoolean = isBoolean;
    exports2.ellipsis = ellipsis;
    exports2.removeWithPredicate = removeWithPredicate;
    exports2.assertNever = assertNever;
    exports2.hasOwnProperty = Object.prototype.hasOwnProperty;
    function isBoolean(value) {
      return typeof value === "boolean";
    }
    function ellipsis(str, truncateLen, ellipsisChars) {
      var ellipsisLength;
      if (str.length > truncateLen) {
        if (ellipsisChars == null) {
          ellipsisChars = "&hellip;";
          ellipsisLength = 3;
        } else {
          ellipsisLength = ellipsisChars.length;
        }
        str = str.substring(0, truncateLen - ellipsisLength) + ellipsisChars;
      }
      return str;
    }
    function removeWithPredicate(arr, fn) {
      for (var i = arr.length - 1; i >= 0; i--) {
        if (fn(arr[i]) === true) {
          arr.splice(i, 1);
        }
      }
    }
    function assertNever(theValue) {
      throw new Error("Unhandled case for value: '".concat(theValue, "'"));
    }
  }
});

// node_modules/autolinker/dist/commonjs/html-tag.js
var require_html_tag = __commonJS({
  "node_modules/autolinker/dist/commonjs/html-tag.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HtmlTag = exports2.whitespaceRe = void 0;
    var utils_1 = require_utils();
    exports2.whitespaceRe = /\s+/;
    var HtmlTag = (
      /** @class */
      (function() {
        function HtmlTag2(cfg) {
          if (cfg === void 0) {
            cfg = {};
          }
          this.tagName = "";
          this.attrs = {};
          this.innerHTML = "";
          this.tagName = cfg.tagName || "";
          this.attrs = cfg.attrs || {};
          this.innerHTML = cfg.innerHtml || cfg.innerHTML || "";
        }
        HtmlTag2.prototype.setTagName = function(tagName) {
          this.tagName = tagName;
          return this;
        };
        HtmlTag2.prototype.getTagName = function() {
          return this.tagName;
        };
        HtmlTag2.prototype.setAttr = function(attrName, attrValue) {
          var tagAttrs = this.getAttrs();
          tagAttrs[attrName] = attrValue;
          return this;
        };
        HtmlTag2.prototype.getAttr = function(attrName) {
          return this.getAttrs()[attrName];
        };
        HtmlTag2.prototype.setAttrs = function(attrs) {
          Object.assign(this.getAttrs(), attrs);
          return this;
        };
        HtmlTag2.prototype.getAttrs = function() {
          return this.attrs;
        };
        HtmlTag2.prototype.setClass = function(cssClass) {
          return this.setAttr("class", cssClass);
        };
        HtmlTag2.prototype.addClass = function(cssClass) {
          var classAttr = this.getClass();
          var classes = !classAttr ? [] : classAttr.split(exports2.whitespaceRe);
          var newClasses = cssClass.split(exports2.whitespaceRe);
          var newClass;
          while (newClass = newClasses.shift()) {
            if (classes.indexOf(newClass) === -1) {
              classes.push(newClass);
            }
          }
          this.getAttrs()["class"] = classes.join(" ");
          return this;
        };
        HtmlTag2.prototype.removeClass = function(cssClass) {
          var classAttr = this.getClass();
          var classes = !classAttr ? [] : classAttr.split(exports2.whitespaceRe);
          var removeClasses = cssClass.split(exports2.whitespaceRe);
          var removeClass;
          while (classes.length && (removeClass = removeClasses.shift())) {
            var idx = classes.indexOf(removeClass);
            if (idx !== -1) {
              classes.splice(idx, 1);
            }
          }
          this.getAttrs()["class"] = classes.join(" ");
          return this;
        };
        HtmlTag2.prototype.getClass = function() {
          return this.getAttrs()["class"] || "";
        };
        HtmlTag2.prototype.hasClass = function(cssClass) {
          return (" " + this.getClass() + " ").indexOf(" " + cssClass + " ") !== -1;
        };
        HtmlTag2.prototype.setInnerHTML = function(html2) {
          this.innerHTML = html2;
          return this;
        };
        HtmlTag2.prototype.setInnerHtml = function(html2) {
          return this.setInnerHTML(html2);
        };
        HtmlTag2.prototype.getInnerHTML = function() {
          return this.innerHTML || "";
        };
        HtmlTag2.prototype.getInnerHtml = function() {
          return this.getInnerHTML();
        };
        HtmlTag2.prototype.toAnchorString = function() {
          var tagName = this.getTagName();
          var attrsStr = this.buildAttrsStr();
          attrsStr = attrsStr ? " " + attrsStr : "";
          return ["<", tagName, attrsStr, ">", this.getInnerHtml(), "</", tagName, ">"].join("");
        };
        HtmlTag2.prototype.buildAttrsStr = function() {
          var attrs = this.getAttrs(), attrsArr = [];
          for (var prop in attrs) {
            if (utils_1.hasOwnProperty.call(attrs, prop)) {
              attrsArr.push(prop + '="' + attrs[prop] + '"');
            }
          }
          return attrsArr.join(" ");
        };
        return HtmlTag2;
      })()
    );
    exports2.HtmlTag = HtmlTag;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-smart.js
var require_truncate_smart = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-smart.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateSmart = truncateSmart;
    function truncateSmart(url2, truncateLen, ellipsisChars) {
      var ellipsisLengthBeforeParsing;
      var ellipsisLength;
      if (ellipsisChars == null) {
        ellipsisChars = "&hellip;";
        ellipsisLength = 3;
        ellipsisLengthBeforeParsing = 8;
      } else {
        ellipsisLength = ellipsisChars.length;
        ellipsisLengthBeforeParsing = ellipsisChars.length;
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      var availableLength = truncateLen - ellipsisLength;
      var urlObj = parseUrl(url2);
      if (urlObj.query) {
        var matchQuery = urlObj.query.match(/^(.*?)(?=(\?|#))(.*?)$/i);
        if (matchQuery) {
          urlObj.query = urlObj.query.substr(0, matchQuery[1].length);
          url2 = buildUrl(urlObj);
        }
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      if (urlObj.host) {
        urlObj.host = urlObj.host.replace(/^www\./, "");
        url2 = buildUrl(urlObj);
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      var truncatedUrl = "";
      if (urlObj.host) {
        truncatedUrl += urlObj.host;
      }
      if (truncatedUrl.length >= availableLength) {
        if (urlObj.host.length === truncateLen) {
          return (urlObj.host.substr(0, truncateLen - ellipsisLength) + ellipsisChars).substr(0, availableLength + ellipsisLengthBeforeParsing);
        }
        return buildSegment(truncatedUrl, availableLength, ellipsisChars).substr(0, availableLength + ellipsisLengthBeforeParsing);
      }
      var pathAndQuery = "";
      if (urlObj.path) {
        pathAndQuery += "/" + urlObj.path;
      }
      if (urlObj.query) {
        pathAndQuery += "?" + urlObj.query;
      }
      if (pathAndQuery) {
        if ((truncatedUrl + pathAndQuery).length >= availableLength) {
          if ((truncatedUrl + pathAndQuery).length == truncateLen) {
            return (truncatedUrl + pathAndQuery).substr(0, truncateLen);
          }
          var remainingAvailableLength = availableLength - truncatedUrl.length;
          return (truncatedUrl + buildSegment(pathAndQuery, remainingAvailableLength, ellipsisChars)).substr(0, availableLength + ellipsisLengthBeforeParsing);
        } else {
          truncatedUrl += pathAndQuery;
        }
      }
      if (urlObj.fragment) {
        var fragment = "#" + urlObj.fragment;
        if ((truncatedUrl + fragment).length >= availableLength) {
          if ((truncatedUrl + fragment).length == truncateLen) {
            return (truncatedUrl + fragment).substr(0, truncateLen);
          }
          var remainingAvailableLength2 = availableLength - truncatedUrl.length;
          return (truncatedUrl + buildSegment(fragment, remainingAvailableLength2, ellipsisChars)).substr(0, availableLength + ellipsisLengthBeforeParsing);
        } else {
          truncatedUrl += fragment;
        }
      }
      if (urlObj.scheme && urlObj.host) {
        var scheme = urlObj.scheme + "://";
        if ((truncatedUrl + scheme).length < availableLength) {
          return (scheme + truncatedUrl).substr(0, truncateLen);
        }
      }
      if (truncatedUrl.length <= truncateLen) {
        return truncatedUrl;
      }
      var end = "";
      if (availableLength > 0) {
        end = truncatedUrl.substr(-1 * Math.floor(availableLength / 2));
      }
      return (truncatedUrl.substr(0, Math.ceil(availableLength / 2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);
    }
    function parseUrl(url2) {
      var urlObj = {};
      var urlSub = url2;
      var match = urlSub.match(/^([a-z]+):\/\//i);
      if (match) {
        urlObj.scheme = match[1];
        urlSub = urlSub.slice(match[0].length);
      }
      match = urlSub.match(/^(.*?)(?=(\?|#|\/|$))/i);
      if (match) {
        urlObj.host = match[1];
        urlSub = urlSub.slice(match[0].length);
      }
      match = urlSub.match(/^\/(.*?)(?=(\?|#|$))/i);
      if (match) {
        urlObj.path = match[1];
        urlSub = urlSub.slice(match[0].length);
      }
      match = urlSub.match(/^\?(.*?)(?=(#|$))/i);
      if (match) {
        urlObj.query = match[1];
        urlSub = urlSub.slice(match[0].length);
      }
      match = urlSub.match(/^#(.*?)$/i);
      if (match) {
        urlObj.fragment = match[1];
      }
      return urlObj;
    }
    function buildUrl(urlObj) {
      var url2 = "";
      if (urlObj.scheme && urlObj.host) {
        url2 += urlObj.scheme + "://";
      }
      if (urlObj.host) {
        url2 += urlObj.host;
      }
      if (urlObj.path) {
        url2 += "/" + urlObj.path;
      }
      if (urlObj.query) {
        url2 += "?" + urlObj.query;
      }
      if (urlObj.fragment) {
        url2 += "#" + urlObj.fragment;
      }
      return url2;
    }
    function buildSegment(segment, remainingAvailableLength, ellipsisChars) {
      var remainingAvailableLengthHalf = remainingAvailableLength / 2;
      var startOffset = Math.ceil(remainingAvailableLengthHalf);
      var endOffset = -1 * Math.floor(remainingAvailableLengthHalf);
      var end = "";
      if (endOffset < 0) {
        end = segment.substr(endOffset);
      }
      return segment.substr(0, startOffset) + ellipsisChars + end;
    }
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-middle.js
var require_truncate_middle = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-middle.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateMiddle = truncateMiddle;
    function truncateMiddle(url2, truncateLen, ellipsisChars) {
      if (url2.length <= truncateLen) {
        return url2;
      }
      var ellipsisLengthBeforeParsing;
      var ellipsisLength;
      if (ellipsisChars == null) {
        ellipsisChars = "&hellip;";
        ellipsisLengthBeforeParsing = 8;
        ellipsisLength = 3;
      } else {
        ellipsisLengthBeforeParsing = ellipsisChars.length;
        ellipsisLength = ellipsisChars.length;
      }
      var availableLength = truncateLen - ellipsisLength;
      var end = "";
      if (availableLength > 0) {
        end = url2.substr(-1 * Math.floor(availableLength / 2));
      }
      return (url2.substr(0, Math.ceil(availableLength / 2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);
    }
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-end.js
var require_truncate_end = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-end.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateEnd = truncateEnd;
    var utils_1 = require_utils();
    function truncateEnd(anchorText, truncateLen, ellipsisChars) {
      return (0, utils_1.ellipsis)(anchorText, truncateLen, ellipsisChars);
    }
  }
});

// node_modules/autolinker/dist/commonjs/anchor-tag-builder.js
var require_anchor_tag_builder = __commonJS({
  "node_modules/autolinker/dist/commonjs/anchor-tag-builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AnchorTagBuilder = void 0;
    var html_tag_1 = require_html_tag();
    var truncate_smart_1 = require_truncate_smart();
    var truncate_middle_1 = require_truncate_middle();
    var truncate_end_1 = require_truncate_end();
    var AnchorTagBuilder = (
      /** @class */
      (function() {
        function AnchorTagBuilder2(cfg) {
          if (cfg === void 0) {
            cfg = {};
          }
          this.newWindow = false;
          this.truncate = {};
          this.className = "";
          this.newWindow = cfg.newWindow || false;
          this.truncate = cfg.truncate || {};
          this.className = cfg.className || "";
        }
        AnchorTagBuilder2.prototype.build = function(match) {
          return new html_tag_1.HtmlTag({
            tagName: "a",
            attrs: this.createAttrs(match),
            innerHtml: this.processAnchorText(match.getAnchorText())
          });
        };
        AnchorTagBuilder2.prototype.createAttrs = function(match) {
          var attrs = {
            href: match.getAnchorHref()
            // we'll always have the `href` attribute
          };
          var cssClass = this.createCssClass(match);
          if (cssClass) {
            attrs["class"] = cssClass;
          }
          if (this.newWindow) {
            attrs["target"] = "_blank";
            attrs["rel"] = "noopener noreferrer";
          }
          if (this.truncate.length && this.truncate.length < match.getAnchorText().length) {
            attrs["title"] = match.getAnchorHref();
          }
          return attrs;
        };
        AnchorTagBuilder2.prototype.createCssClass = function(match) {
          var className = this.className;
          if (!className) {
            return "";
          } else {
            var returnClasses = [className], cssClassSuffixes = match.getCssClassSuffixes();
            for (var i = 0, len = cssClassSuffixes.length; i < len; i++) {
              returnClasses.push(className + "-" + cssClassSuffixes[i]);
            }
            return returnClasses.join(" ");
          }
        };
        AnchorTagBuilder2.prototype.processAnchorText = function(anchorText) {
          anchorText = this.doTruncate(anchorText);
          return anchorText;
        };
        AnchorTagBuilder2.prototype.doTruncate = function(anchorText) {
          var truncate = this.truncate;
          if (!truncate.length)
            return anchorText;
          var truncateLength = truncate.length, truncateLocation = truncate.location;
          if (truncateLocation === "smart") {
            return (0, truncate_smart_1.truncateSmart)(anchorText, truncateLength);
          } else if (truncateLocation === "middle") {
            return (0, truncate_middle_1.truncateMiddle)(anchorText, truncateLength);
          } else {
            return (0, truncate_end_1.truncateEnd)(anchorText, truncateLength);
          }
        };
        return AnchorTagBuilder2;
      })()
    );
    exports2.AnchorTagBuilder = AnchorTagBuilder;
  }
});

// node_modules/autolinker/dist/commonjs/match/abstract-match.js
var require_abstract_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/abstract-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AbstractMatch = void 0;
    var AbstractMatch = (
      /** @class */
      (function() {
        function AbstractMatch2(cfg) {
          this._ = null;
          this.matchedText = "";
          this.offset = 0;
          this.tagBuilder = cfg.tagBuilder;
          this.matchedText = cfg.matchedText;
          this.offset = cfg.offset;
        }
        AbstractMatch2.prototype.getMatchedText = function() {
          return this.matchedText;
        };
        AbstractMatch2.prototype.setOffset = function(offset) {
          this.offset = offset;
        };
        AbstractMatch2.prototype.getOffset = function() {
          return this.offset;
        };
        AbstractMatch2.prototype.getCssClassSuffixes = function() {
          return [this.type];
        };
        AbstractMatch2.prototype.buildTag = function() {
          return this.tagBuilder.build(this);
        };
        return AbstractMatch2;
      })()
    );
    exports2.AbstractMatch = AbstractMatch;
  }
});

// node_modules/autolinker/dist/commonjs/char-utils.js
var require_char_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/char-utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isControlChar = isControlChar;
    exports2.isAsciiLetterChar = isAsciiLetterChar;
    exports2.isDigitChar = isDigitChar;
    exports2.isQuoteChar = isQuoteChar;
    exports2.isWhitespaceChar = isWhitespaceChar;
    exports2.isAlphaNumericOrMarkChar = isAlphaNumericOrMarkChar;
    exports2.isValidEmailLocalPartSpecialChar = isValidEmailLocalPartSpecialChar;
    exports2.isUrlSuffixAllowedSpecialChar = isUrlSuffixAllowedSpecialChar;
    exports2.isUrlSuffixNotAllowedAsFinalChar = isUrlSuffixNotAllowedAsFinalChar;
    exports2.isOpenBraceChar = isOpenBraceChar;
    exports2.isCloseBraceChar = isCloseBraceChar;
    function isControlChar(c) {
      return c >= 0 && c <= 31 || c == 127;
    }
    function isAsciiLetterChar(c) {
      return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }
    function isDigitChar(c) {
      return c >= 48 && c <= 57;
    }
    function isQuoteChar(c) {
      return c == 34 || c == 39;
    }
    function isWhitespaceChar(c) {
      return c < 8232 ? c < 160 ? c >= 9 && c <= 13 || c == 32 : c < 5760 ? c == 160 : c == 5760 || c >= 8192 && c <= 8202 : c < 8287 ? c >= 8232 && c <= 8233 || c == 8239 : c < 12288 ? c == 8287 : c == 12288 || c == 65279;
    }
    function isAlphaNumericOrMarkChar(c) {
      return c < 4800 ? c < 2949 ? c < 2451 ? c < 1425 ? c < 768 ? c < 192 ? c < 169 ? c < 65 ? c >= 48 && c <= 57 : c >= 65 && c <= 90 || c >= 97 && c <= 122 : c < 181 ? c >= 169 && c <= 170 || c == 174 : c == 181 || c == 186 : c < 710 ? c < 216 ? c >= 192 && c <= 214 : c >= 216 && c <= 246 || c >= 248 && c <= 705 : c < 748 ? c >= 710 && c <= 721 || c >= 736 && c <= 740 : c == 748 || c == 750 : c < 910 ? c < 895 ? c < 886 ? c >= 768 && c <= 884 : c >= 886 && c <= 887 || c >= 890 && c <= 893 : c < 904 ? c == 895 || c == 902 : c >= 904 && c <= 906 || c == 908 : c < 1155 ? c < 931 ? c >= 910 && c <= 929 : c >= 931 && c <= 1013 || c >= 1015 && c <= 1153 : c < 1369 ? c >= 1155 && c <= 1327 || c >= 1329 && c <= 1366 : c == 1369 || c >= 1377 && c <= 1415 : c < 1808 ? c < 1552 ? c < 1476 ? c < 1471 ? c >= 1425 && c <= 1469 : c == 1471 || c >= 1473 && c <= 1474 : c < 1488 ? c >= 1476 && c <= 1477 || c == 1479 : c >= 1488 && c <= 1514 || c >= 1520 && c <= 1522 : c < 1749 ? c < 1568 ? c >= 1552 && c <= 1562 : c >= 1568 && c <= 1641 || c >= 1646 && c <= 1747 : c < 1770 ? c >= 1749 && c <= 1756 || c >= 1759 && c <= 1768 : c >= 1770 && c <= 1788 || c == 1791 : c < 2230 ? c < 2042 ? c < 1869 ? c >= 1808 && c <= 1866 : c >= 1869 && c <= 1969 || c >= 1984 && c <= 2037 : c < 2112 ? c == 2042 || c >= 2048 && c <= 2093 : c >= 2112 && c <= 2139 || c >= 2208 && c <= 2228 : c < 2406 ? c < 2260 ? c >= 2230 && c <= 2237 : c >= 2260 && c <= 2273 || c >= 2275 && c <= 2403 : c < 2437 ? c >= 2406 && c <= 2415 || c >= 2417 && c <= 2435 : c >= 2437 && c <= 2444 || c >= 2447 && c <= 2448 : c < 2693 ? c < 2579 ? c < 2519 ? c < 2486 ? c < 2474 ? c >= 2451 && c <= 2472 : c >= 2474 && c <= 2480 || c == 2482 : c < 2503 ? c >= 2486 && c <= 2489 || c >= 2492 && c <= 2500 : c >= 2503 && c <= 2504 || c >= 2507 && c <= 2510 : c < 2534 ? c < 2524 ? c == 2519 : c >= 2524 && c <= 2525 || c >= 2527 && c <= 2531 : c < 2565 ? c >= 2534 && c <= 2545 || c >= 2561 && c <= 2563 : c >= 2565 && c <= 2570 || c >= 2575 && c <= 2576 : c < 2631 ? c < 2613 ? c < 2602 ? c >= 2579 && c <= 2600 : c >= 2602 && c <= 2608 || c >= 2610 && c <= 2611 : c < 2620 ? c >= 2613 && c <= 2614 || c >= 2616 && c <= 2617 : c == 2620 || c >= 2622 && c <= 2626 : c < 2649 ? c < 2635 ? c >= 2631 && c <= 2632 : c >= 2635 && c <= 2637 || c == 2641 : c < 2662 ? c >= 2649 && c <= 2652 || c == 2654 : c >= 2662 && c <= 2677 || c >= 2689 && c <= 2691 : c < 2821 ? c < 2759 ? c < 2730 ? c < 2703 ? c >= 2693 && c <= 2701 : c >= 2703 && c <= 2705 || c >= 2707 && c <= 2728 : c < 2741 ? c >= 2730 && c <= 2736 || c >= 2738 && c <= 2739 : c >= 2741 && c <= 2745 || c >= 2748 && c <= 2757 : c < 2784 ? c < 2763 ? c >= 2759 && c <= 2761 : c >= 2763 && c <= 2765 || c == 2768 : c < 2809 ? c >= 2784 && c <= 2787 || c >= 2790 && c <= 2799 : c == 2809 || c >= 2817 && c <= 2819 : c < 2887 ? c < 2858 ? c < 2831 ? c >= 2821 && c <= 2828 : c >= 2831 && c <= 2832 || c >= 2835 && c <= 2856 : c < 2869 ? c >= 2858 && c <= 2864 || c >= 2866 && c <= 2867 : c >= 2869 && c <= 2873 || c >= 2876 && c <= 2884 : c < 2911 ? c < 2902 ? c >= 2887 && c <= 2888 || c >= 2891 && c <= 2893 : c >= 2902 && c <= 2903 || c >= 2908 && c <= 2909 : c < 2929 ? c >= 2911 && c <= 2915 || c >= 2918 && c <= 2927 : c == 2929 || c >= 2946 && c <= 2947 : c < 3517 ? c < 3205 ? c < 3046 ? c < 2984 ? c < 2969 ? c < 2958 ? c >= 2949 && c <= 2954 : c >= 2958 && c <= 2960 || c >= 2962 && c <= 2965 : c < 2974 ? c >= 2969 && c <= 2970 || c == 2972 : c >= 2974 && c <= 2975 || c >= 2979 && c <= 2980 : c < 3014 ? c < 2990 ? c >= 2984 && c <= 2986 : c >= 2990 && c <= 3001 || c >= 3006 && c <= 3010 : c < 3024 ? c >= 3014 && c <= 3016 || c >= 3018 && c <= 3021 : c == 3024 || c == 3031 : c < 3142 ? c < 3086 ? c < 3072 ? c >= 3046 && c <= 3055 : c >= 3072 && c <= 3075 || c >= 3077 && c <= 3084 : c < 3114 ? c >= 3086 && c <= 3088 || c >= 3090 && c <= 3112 : c >= 3114 && c <= 3129 || c >= 3133 && c <= 3140 : c < 3160 ? c < 3146 ? c >= 3142 && c <= 3144 : c >= 3146 && c <= 3149 || c >= 3157 && c <= 3158 : c < 3174 ? c >= 3160 && c <= 3162 || c >= 3168 && c <= 3171 : c >= 3174 && c <= 3183 || c >= 3200 && c <= 3203 : c < 3333 ? c < 3274 ? c < 3242 ? c < 3214 ? c >= 3205 && c <= 3212 : c >= 3214 && c <= 3216 || c >= 3218 && c <= 3240 : c < 3260 ? c >= 3242 && c <= 3251 || c >= 3253 && c <= 3257 : c >= 3260 && c <= 3268 || c >= 3270 && c <= 3272 : c < 3296 ? c < 3285 ? c >= 3274 && c <= 3277 : c >= 3285 && c <= 3286 || c == 3294 : c < 3313 ? c >= 3296 && c <= 3299 || c >= 3302 && c <= 3311 : c >= 3313 && c <= 3314 || c >= 3329 && c <= 3331 : c < 3423 ? c < 3389 ? c < 3342 ? c >= 3333 && c <= 3340 : c >= 3342 && c <= 3344 || c >= 3346 && c <= 3386 : c < 3402 ? c >= 3389 && c <= 3396 || c >= 3398 && c <= 3400 : c >= 3402 && c <= 3406 || c >= 3412 && c <= 3415 : c < 3458 ? c < 3430 ? c >= 3423 && c <= 3427 : c >= 3430 && c <= 3439 || c >= 3450 && c <= 3455 : c < 3482 ? c >= 3458 && c <= 3459 || c >= 3461 && c <= 3478 : c >= 3482 && c <= 3505 || c >= 3507 && c <= 3515 : c < 3804 ? c < 3722 ? c < 3570 ? c < 3535 ? c < 3520 ? c == 3517 : c >= 3520 && c <= 3526 || c == 3530 : c < 3544 ? c >= 3535 && c <= 3540 || c == 3542 : c >= 3544 && c <= 3551 || c >= 3558 && c <= 3567 : c < 3664 ? c < 3585 ? c >= 3570 && c <= 3571 : c >= 3585 && c <= 3642 || c >= 3648 && c <= 3662 : c < 3716 ? c >= 3664 && c <= 3673 || c >= 3713 && c <= 3714 : c == 3716 || c >= 3719 && c <= 3720 : c < 3754 ? c < 3737 ? c < 3725 ? c == 3722 : c == 3725 || c >= 3732 && c <= 3735 : c < 3749 ? c >= 3737 && c <= 3743 || c >= 3745 && c <= 3747 : c == 3749 || c == 3751 : c < 3776 ? c < 3757 ? c >= 3754 && c <= 3755 : c >= 3757 && c <= 3769 || c >= 3771 && c <= 3773 : c < 3784 ? c >= 3776 && c <= 3780 || c == 3782 : c >= 3784 && c <= 3789 || c >= 3792 && c <= 3801 : c < 4176 ? c < 3902 ? c < 3872 ? c < 3840 ? c >= 3804 && c <= 3807 : c == 3840 || c >= 3864 && c <= 3865 : c < 3895 ? c >= 3872 && c <= 3881 || c == 3893 : c == 3895 || c == 3897 : c < 3974 ? c < 3913 ? c >= 3902 && c <= 3911 : c >= 3913 && c <= 3948 || c >= 3953 && c <= 3972 : c < 4038 ? c >= 3974 && c <= 3991 || c >= 3993 && c <= 4028 : c == 4038 || c >= 4096 && c <= 4169 : c < 4688 ? c < 4301 ? c < 4256 ? c >= 4176 && c <= 4253 : c >= 4256 && c <= 4293 || c == 4295 : c < 4348 ? c == 4301 || c >= 4304 && c <= 4346 : c >= 4348 && c <= 4680 || c >= 4682 && c <= 4685 : c < 4746 ? c < 4698 ? c >= 4688 && c <= 4694 || c == 4696 : c >= 4698 && c <= 4701 || c >= 4704 && c <= 4744 : c < 4786 ? c >= 4746 && c <= 4749 || c >= 4752 && c <= 4784 : c >= 4786 && c <= 4789 || c >= 4792 && c <= 4798 : c < 11035 ? c < 7416 ? c < 6176 ? c < 5873 ? c < 4992 ? c < 4824 ? c < 4802 ? c == 4800 : c >= 4802 && c <= 4805 || c >= 4808 && c <= 4822 : c < 4888 ? c >= 4824 && c <= 4880 || c >= 4882 && c <= 4885 : c >= 4888 && c <= 4954 || c >= 4957 && c <= 4959 : c < 5121 ? c < 5024 ? c >= 4992 && c <= 5007 : c >= 5024 && c <= 5109 || c >= 5112 && c <= 5117 : c < 5761 ? c >= 5121 && c <= 5740 || c >= 5743 && c <= 5759 : c >= 5761 && c <= 5786 || c >= 5792 && c <= 5866 : c < 6002 ? c < 5920 ? c < 5888 ? c >= 5873 && c <= 5880 : c >= 5888 && c <= 5900 || c >= 5902 && c <= 5908 : c < 5984 ? c >= 5920 && c <= 5940 || c >= 5952 && c <= 5971 : c >= 5984 && c <= 5996 || c >= 5998 && c <= 6e3 : c < 6108 ? c < 6016 ? c >= 6002 && c <= 6003 : c >= 6016 && c <= 6099 || c == 6103 : c < 6155 ? c >= 6108 && c <= 6109 || c >= 6112 && c <= 6121 : c >= 6155 && c <= 6157 || c >= 6160 && c <= 6169 : c < 6783 ? c < 6512 ? c < 6400 ? c < 6272 ? c >= 6176 && c <= 6263 : c >= 6272 && c <= 6314 || c >= 6320 && c <= 6389 : c < 6448 ? c >= 6400 && c <= 6430 || c >= 6432 && c <= 6443 : c >= 6448 && c <= 6459 || c >= 6470 && c <= 6509 : c < 6608 ? c < 6528 ? c >= 6512 && c <= 6516 : c >= 6528 && c <= 6571 || c >= 6576 && c <= 6601 : c < 6688 ? c >= 6608 && c <= 6617 || c >= 6656 && c <= 6683 : c >= 6688 && c <= 6750 || c >= 6752 && c <= 6780 : c < 7040 ? c < 6832 ? c < 6800 ? c >= 6783 && c <= 6793 : c >= 6800 && c <= 6809 || c == 6823 : c < 6992 ? c >= 6832 && c <= 6846 || c >= 6912 && c <= 6987 : c >= 6992 && c <= 7001 || c >= 7019 && c <= 7027 : c < 7245 ? c < 7168 ? c >= 7040 && c <= 7155 : c >= 7168 && c <= 7223 || c >= 7232 && c <= 7241 : c < 7376 ? c >= 7245 && c <= 7293 || c >= 7296 && c <= 7304 : c >= 7376 && c <= 7378 || c >= 7380 && c <= 7414 : c < 8450 ? c < 8130 ? c < 8025 ? c < 7960 ? c < 7424 ? c >= 7416 && c <= 7417 : c >= 7424 && c <= 7669 || c >= 7675 && c <= 7957 : c < 8008 ? c >= 7960 && c <= 7965 || c >= 7968 && c <= 8005 : c >= 8008 && c <= 8013 || c >= 8016 && c <= 8023 : c < 8031 ? c < 8027 ? c == 8025 : c == 8027 || c == 8029 : c < 8118 ? c >= 8031 && c <= 8061 || c >= 8064 && c <= 8116 : c >= 8118 && c <= 8124 || c == 8126 : c < 8205 ? c < 8150 ? c < 8134 ? c >= 8130 && c <= 8132 : c >= 8134 && c <= 8140 || c >= 8144 && c <= 8147 : c < 8178 ? c >= 8150 && c <= 8155 || c >= 8160 && c <= 8172 : c >= 8178 && c <= 8180 || c >= 8182 && c <= 8188 : c < 8305 ? c < 8252 ? c == 8205 : c == 8252 || c == 8265 : c < 8336 ? c == 8305 || c == 8319 : c >= 8336 && c <= 8348 || c >= 8400 && c <= 8432 : c < 8579 ? c < 8486 ? c < 8469 ? c < 8455 ? c == 8450 : c == 8455 || c >= 8458 && c <= 8467 : c < 8482 ? c == 8469 || c >= 8473 && c <= 8477 : c == 8482 || c == 8484 : c < 8495 ? c < 8488 ? c == 8486 : c == 8488 || c >= 8490 && c <= 8493 : c < 8517 ? c >= 8495 && c <= 8505 || c >= 8508 && c <= 8511 : c >= 8517 && c <= 8521 || c == 8526 : c < 9410 ? c < 9e3 ? c < 8592 ? c >= 8579 && c <= 8580 : c >= 8592 && c <= 8703 || c >= 8986 && c <= 8987 : c < 9193 ? c == 9e3 || c == 9167 : c >= 9193 && c <= 9203 || c >= 9208 && c <= 9210 : c < 9723 ? c < 9654 ? c == 9410 || c >= 9642 && c <= 9643 : c == 9654 || c == 9664 : c < 10548 ? c >= 9723 && c <= 9726 || c >= 9728 && c <= 10175 : c >= 10548 && c <= 10549 || c >= 11013 && c <= 11015 : c < 43259 ? c < 12445 ? c < 11688 ? c < 11520 ? c < 11264 ? c < 11088 ? c >= 11035 && c <= 11036 : c == 11088 || c == 11093 : c < 11360 ? c >= 11264 && c <= 11310 || c >= 11312 && c <= 11358 : c >= 11360 && c <= 11492 || c >= 11499 && c <= 11507 : c < 11568 ? c < 11559 ? c >= 11520 && c <= 11557 : c == 11559 || c == 11565 : c < 11647 ? c >= 11568 && c <= 11623 || c == 11631 : c >= 11647 && c <= 11670 || c >= 11680 && c <= 11686 : c < 11744 ? c < 11712 ? c < 11696 ? c >= 11688 && c <= 11694 : c >= 11696 && c <= 11702 || c >= 11704 && c <= 11710 : c < 11728 ? c >= 11712 && c <= 11718 || c >= 11720 && c <= 11726 : c >= 11728 && c <= 11734 || c >= 11736 && c <= 11742 : c < 12330 ? c < 11823 ? c >= 11744 && c <= 11775 : c == 11823 || c >= 12293 && c <= 12294 : c < 12353 ? c >= 12330 && c <= 12341 || c >= 12347 && c <= 12349 : c >= 12353 && c <= 12438 || c >= 12441 && c <= 12442 : c < 42512 ? c < 12951 ? c < 12549 ? c < 12449 ? c >= 12445 && c <= 12447 : c >= 12449 && c <= 12538 || c >= 12540 && c <= 12543 : c < 12704 ? c >= 12549 && c <= 12589 || c >= 12593 && c <= 12686 : c >= 12704 && c <= 12730 || c >= 12784 && c <= 12799 : c < 19968 ? c < 12953 ? c == 12951 : c == 12953 || c >= 13312 && c <= 19893 : c < 42192 ? c >= 19968 && c <= 40917 || c >= 40960 && c <= 42124 : c >= 42192 && c <= 42237 || c >= 42240 && c <= 42508 : c < 42891 ? c < 42623 ? c < 42560 ? c >= 42512 && c <= 42539 : c >= 42560 && c <= 42610 || c >= 42612 && c <= 42621 : c < 42775 ? c >= 42623 && c <= 42725 || c >= 42736 && c <= 42737 : c >= 42775 && c <= 42783 || c >= 42786 && c <= 42888 : c < 43072 ? c < 42928 ? c >= 42891 && c <= 42926 : c >= 42928 && c <= 42935 || c >= 42999 && c <= 43047 : c < 43216 ? c >= 43072 && c <= 43123 || c >= 43136 && c <= 43205 : c >= 43216 && c <= 43225 || c >= 43232 && c <= 43255 : c < 55243 ? c < 43744 ? c < 43488 ? c < 43312 ? c < 43261 ? c == 43259 : c == 43261 || c >= 43264 && c <= 43309 : c < 43392 ? c >= 43312 && c <= 43347 || c >= 43360 && c <= 43388 : c >= 43392 && c <= 43456 || c >= 43471 && c <= 43481 : c < 43600 ? c < 43520 ? c >= 43488 && c <= 43518 : c >= 43520 && c <= 43574 || c >= 43584 && c <= 43597 : c < 43642 ? c >= 43600 && c <= 43609 || c >= 43616 && c <= 43638 : c >= 43642 && c <= 43714 || c >= 43739 && c <= 43741 : c < 43824 ? c < 43785 ? c < 43762 ? c >= 43744 && c <= 43759 : c >= 43762 && c <= 43766 || c >= 43777 && c <= 43782 : c < 43808 ? c >= 43785 && c <= 43790 || c >= 43793 && c <= 43798 : c >= 43808 && c <= 43814 || c >= 43816 && c <= 43822 : c < 44012 ? c < 43868 ? c >= 43824 && c <= 43866 : c >= 43868 && c <= 43877 || c >= 43888 && c <= 44010 : c < 44032 ? c >= 44012 && c <= 44013 || c >= 44016 && c <= 44025 : c >= 44032 && c <= 55203 || c >= 55216 && c <= 55238 : c < 64848 ? c < 64298 ? c < 64112 ? c < 55296 ? c >= 55243 && c <= 55291 : c >= 55296 && c <= 57343 || c >= 63744 && c <= 64109 : c < 64275 ? c >= 64112 && c <= 64217 || c >= 64256 && c <= 64262 : c >= 64275 && c <= 64279 || c >= 64285 && c <= 64296 : c < 64320 ? c < 64312 ? c >= 64298 && c <= 64310 : c >= 64312 && c <= 64316 || c == 64318 : c < 64326 ? c >= 64320 && c <= 64321 || c >= 64323 && c <= 64324 : c >= 64326 && c <= 64433 || c >= 64467 && c <= 64829 : c < 65296 ? c < 65024 ? c < 64914 ? c >= 64848 && c <= 64911 : c >= 64914 && c <= 64967 || c >= 65008 && c <= 65019 : c < 65136 ? c >= 65024 && c <= 65039 || c >= 65056 && c <= 65071 : c >= 65136 && c <= 65140 || c >= 65142 && c <= 65276 : c < 65474 ? c < 65345 ? c >= 65296 && c <= 65305 || c >= 65313 && c <= 65338 : c >= 65345 && c <= 65370 || c >= 65382 && c <= 65470 : c < 65490 ? c >= 65474 && c <= 65479 || c >= 65482 && c <= 65487 : c >= 65490 && c <= 65495 || c >= 65498 && c <= 65500;
    }
    function isValidEmailLocalPartSpecialChar(c) {
      return c < 47 ? c < 42 ? c == 33 || c >= 35 && c <= 39 : c >= 42 && c <= 43 || c == 45 : c < 63 ? c == 47 || c == 61 : c < 94 ? c == 63 : c >= 94 && c <= 96 || c >= 123 && c <= 126;
    }
    function isUrlSuffixAllowedSpecialChar(c) {
      return c < 91 ? c < 47 ? c >= 35 && c <= 43 || c == 45 : c < 61 ? c == 47 : c == 61 || c == 64 : c < 95 ? c == 91 || c == 93 : c < 123 ? c == 95 : c >= 123 && c <= 126 || c == 10003;
    }
    function isUrlSuffixNotAllowedAsFinalChar(c) {
      return c < 58 ? c < 44 ? c == 33 : c == 44 || c == 46 : c < 63 ? c >= 58 && c <= 59 : c == 63 || c == 94;
    }
    function isOpenBraceChar(c) {
      return c < 91 ? c == 40 : c == 91 || c == 123;
    }
    function isCloseBraceChar(c) {
      return c < 93 ? c == 41 : c == 93 || c == 125;
    }
  }
});

// node_modules/autolinker/dist/commonjs/parser/known-tlds.js
var require_known_tlds = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/known-tlds.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tldRegex = void 0;
    exports2.tldRegex = /^(?:xn--vermgensberatung-pwb|xn--vermgensberater-ctb|xn--clchc0ea0b2g2a9gcd|xn--w4r85el8fhu5dnra|travelersinsurance|vermögensberatung|xn--5su34j936bgsg|xn--bck1b9a5dre4c|xn--mgbah1a3hjkrd|xn--mgbai9azgqp6j|xn--mgberp4a5d4ar|xn--xkc2dl3a5ee0h|vermögensberater|xn--fzys8d69uvgm|xn--mgba7c0bbn0a|xn--mgbcpq6gpa1a|xn--xkc2al3hye2a|americanexpress|kerryproperties|sandvikcoromant|xn--i1b6b1a6a2e|xn--kcrx77d1x4a|xn--lgbbat1ad8j|xn--mgba3a4f16a|xn--mgbc0a9azcg|xn--nqv7fs00ema|americanfamily|weatherchannel|xn--54b7fta0cc|xn--6qq986b3xl|xn--80aqecdr1a|xn--b4w605ferd|xn--fiq228c5hs|xn--h2breg3eve|xn--jlq480n2rg|xn--mgba3a3ejt|xn--mgbaam7a8h|xn--mgbayh7gpa|xn--mgbbh1a71e|xn--mgbca7dzdo|xn--mgbi4ecexp|xn--mgbx4cd0ab|xn--rvc1e0am3e|international|lifeinsurance|wolterskluwer|xn--cckwcxetd|xn--eckvdtc9d|xn--fpcrj9c3d|xn--fzc2c9e2c|xn--h2brj9c8c|xn--tiq49xqyj|xn--yfro4i67o|xn--ygbi2ammx|construction|lplfinancial|scholarships|versicherung|xn--3e0b707e|xn--45br5cyl|xn--4dbrk0ce|xn--80adxhks|xn--80asehdb|xn--8y0a063a|xn--gckr3f0f|xn--mgb9awbf|xn--mgbab2bd|xn--mgbgu82a|xn--mgbpl2fh|xn--mgbt3dhd|xn--mk1bu44c|xn--ngbc5azd|xn--ngbe9e0a|xn--ogbpf8fl|xn--qcka1pmc|accountants|barclaycard|blackfriday|blockbuster|bridgestone|calvinklein|contractors|creditunion|engineering|enterprises|investments|kerryhotels|lamborghini|motorcycles|olayangroup|photography|playstation|productions|progressive|redumbrella|williamhill|xn--11b4c3d|xn--1ck2e1b|xn--1qqw23a|xn--2scrj9c|xn--3bst00m|xn--3ds443g|xn--3hcrj9c|xn--42c2d9a|xn--45brj9c|xn--55qw42g|xn--6frz82g|xn--80ao21a|xn--9krt00a|xn--cck2b3b|xn--czr694b|xn--d1acj3b|xn--efvy88h|xn--fct429k|xn--fjq720a|xn--flw351e|xn--g2xx48c|xn--gecrj9c|xn--gk3at1e|xn--h2brj9c|xn--hxt814e|xn--imr513n|xn--j6w193g|xn--jvr189m|xn--kprw13d|xn--kpry57d|xn--mgbbh1a|xn--mgbtx2b|xn--mix891f|xn--nyqy26a|xn--otu796d|xn--pgbs0dh|xn--q9jyb4c|xn--rhqv96g|xn--rovu88b|xn--s9brj9c|xn--ses554g|xn--t60b56a|xn--vuq861b|xn--w4rs40l|xn--xhq521b|xn--zfr164b|சிங்கப்பூர்|accountant|apartments|associates|basketball|bnpparibas|boehringer|capitalone|consulting|creditcard|cuisinella|eurovision|extraspace|foundation|healthcare|immobilien|industries|management|mitsubishi|nextdirect|properties|protection|prudential|realestate|republican|restaurant|schaeffler|tatamotors|technology|university|vlaanderen|xn--30rr7y|xn--3pxu8k|xn--45q11c|xn--4gbrim|xn--55qx5d|xn--5tzm5g|xn--80aswg|xn--90a3ac|xn--9dbq2a|xn--9et52u|xn--c2br7g|xn--cg4bki|xn--czrs0t|xn--czru2d|xn--fiq64b|xn--fiqs8s|xn--fiqz9s|xn--io0a7i|xn--kput3i|xn--mxtq1m|xn--o3cw4h|xn--pssy2u|xn--q7ce6a|xn--unup4y|xn--wgbh1c|xn--wgbl6a|xn--y9a3aq|accenture|allfinanz|amsterdam|analytics|aquarelle|barcelona|bloomberg|christmas|community|directory|education|equipment|fairwinds|financial|firestone|fresenius|furniture|goldpoint|hisamitsu|homedepot|homegoods|homesense|institute|insurance|kuokgroup|landrover|lifestyle|marketing|marshalls|melbourne|microsoft|panasonic|pramerica|richardli|shangrila|solutions|statebank|statefarm|stockholm|travelers|vacations|xn--90ais|xn--c1avg|xn--d1alf|xn--e1a4c|xn--fhbei|xn--j1aef|xn--j1amh|xn--l1acc|xn--ngbrx|xn--nqv7f|xn--p1acf|xn--qxa6a|xn--tckwe|xn--vhquv|yodobashi|موريتانيا|abudhabi|airforce|allstate|attorney|barclays|barefoot|bargains|baseball|boutique|bradesco|broadway|brussels|builders|business|capetown|catering|catholic|cipriani|cleaning|clinique|clothing|commbank|computer|delivery|deloitte|democrat|diamonds|discount|discover|download|engineer|ericsson|exchange|feedback|fidelity|firmdale|football|frontier|goodyear|grainger|graphics|hdfcbank|helsinki|holdings|hospital|infiniti|ipiranga|istanbul|jpmorgan|lighting|lundbeck|marriott|mckinsey|memorial|merckmsd|mortgage|observer|partners|pharmacy|pictures|plumbing|property|redstone|reliance|saarland|samsclub|security|services|shopping|softbank|software|stcgroup|supplies|training|vanguard|ventures|verisign|woodside|xn--90ae|xn--node|xn--p1ai|xn--qxam|yokohama|السعودية|abogado|academy|agakhan|alibaba|android|athleta|auction|audible|auspost|banamex|bauhaus|bestbuy|booking|brother|capital|caravan|careers|channel|charity|chintai|citadel|clubmed|college|cologne|company|compare|contact|cooking|corsica|country|coupons|courses|cricket|cruises|dentist|digital|domains|exposed|express|farmers|fashion|ferrari|ferrero|finance|fishing|fitness|flights|florist|flowers|forsale|frogans|fujitsu|gallery|genting|godaddy|grocery|guitars|hamburg|hangout|hitachi|holiday|hosting|hotmail|hyundai|ismaili|jewelry|juniper|kitchen|komatsu|lacaixa|lanxess|lasalle|latrobe|leclerc|limited|lincoln|markets|monster|netbank|netflix|network|neustar|okinawa|organic|origins|philips|pioneer|politie|realtor|recipes|rentals|reviews|rexroth|samsung|sandvik|schmidt|schwarz|science|shiksha|singles|staples|storage|support|surgery|systems|temasek|theater|theatre|tickets|toshiba|trading|walmart|wanggou|watches|weather|website|wedding|whoswho|windows|winners|yamaxun|youtube|zuerich|католик|البحرين|الجزائر|العليان|پاکستان|كاثوليك|இந்தியா|abbott|abbvie|africa|agency|airbus|airtel|alipay|alsace|alstom|amazon|anquan|aramco|author|bayern|beauty|berlin|bharti|bostik|boston|broker|camera|career|casino|center|chanel|chrome|church|circle|claims|clinic|coffee|comsec|condos|coupon|credit|cruise|dating|datsun|dealer|degree|dental|design|direct|doctor|dunlop|dupont|durban|emerck|energy|estate|events|expert|family|flickr|futbol|gallup|garden|george|giving|global|google|gratis|health|hermes|hiphop|hockey|hotels|hughes|imamat|insure|intuit|jaguar|joburg|juegos|kaufen|kindle|kosher|latino|lawyer|lefrak|living|locker|london|luxury|madrid|maison|makeup|market|mattel|mobile|monash|mormon|moscow|museum|nagoya|nissan|nissay|norton|nowruz|office|olayan|online|oracle|orange|otsuka|pfizer|photos|physio|pictet|quebec|racing|realty|reisen|repair|report|review|rogers|ryukyu|safety|sakura|sanofi|school|schule|search|secure|select|shouji|soccer|social|stream|studio|supply|suzuki|swatch|sydney|taipei|taobao|target|tattoo|tennis|tienda|tjmaxx|tkmaxx|toyota|travel|unicom|viajes|viking|villas|virgin|vision|voting|voyage|walter|webcam|xihuan|yachts|yandex|zappos|москва|онлайн|ابوظبي|ارامكو|الاردن|المغرب|امارات|فلسطين|مليسيا|भारतम्|இலங்கை|ファッション|actor|adult|aetna|amfam|amica|apple|archi|audio|autos|azure|baidu|beats|bible|bingo|black|boats|bosch|build|canon|cards|chase|cheap|cisco|citic|click|cloud|coach|codes|crown|cymru|dance|deals|delta|drive|dubai|earth|edeka|email|epson|faith|fedex|final|forex|forum|gallo|games|gifts|gives|glass|globo|gmail|green|gripe|group|gucci|guide|homes|honda|horse|house|hyatt|ikano|irish|jetzt|koeln|kyoto|lamer|lease|legal|lexus|lilly|loans|locus|lotte|lotto|mango|media|miami|money|movie|music|nexus|nikon|ninja|nokia|nowtv|omega|osaka|paris|parts|party|phone|photo|pizza|place|poker|praxi|press|prime|promo|quest|radio|rehab|reise|ricoh|rocks|rodeo|rugby|salon|sener|seven|sharp|shell|shoes|skype|sling|smart|smile|solar|space|sport|stada|store|study|style|sucks|swiss|tatar|tires|tirol|tmall|today|tokyo|tools|toray|total|tours|trade|trust|tunes|tushu|ubank|vegas|video|vodka|volvo|wales|watch|weber|weibo|works|world|xerox|yahoo|ישראל|ایران|بازار|بھارت|سودان|سورية|همراه|भारोत|संगठन|বাংলা|భారత్|ഭാരതം|嘉里大酒店|aarp|able|aero|akdn|ally|amex|arab|army|arpa|arte|asda|asia|audi|auto|baby|band|bank|bbva|beer|best|bike|bing|blog|blue|bofa|bond|book|buzz|cafe|call|camp|care|cars|casa|case|cash|cbre|cern|chat|citi|city|club|cool|coop|cyou|data|date|dclk|deal|dell|desi|diet|dish|docs|dvag|erni|fage|fail|fans|farm|fast|fido|film|fire|fish|flir|food|ford|free|fund|game|gbiz|gent|ggee|gift|gmbh|gold|golf|goog|guge|guru|hair|haus|hdfc|help|here|host|hsbc|icbc|ieee|imdb|immo|info|itau|java|jeep|jobs|jprs|kddi|kids|kiwi|kpmg|kred|land|lego|lgbt|lidl|life|like|limo|link|live|loan|love|ltda|luxe|maif|meet|meme|menu|mini|mint|mobi|moda|moto|name|navy|news|next|nico|nike|ollo|open|page|pars|pccw|pics|ping|pink|play|plus|pohl|porn|post|prod|prof|qpon|read|reit|rent|rest|rich|room|rsvp|ruhr|safe|sale|sarl|save|saxo|scot|seat|seek|sexy|shia|shop|show|silk|sina|site|skin|sncf|sohu|song|sony|spot|star|surf|talk|taxi|team|tech|teva|tiaa|tips|town|toys|tube|vana|visa|viva|vivo|vote|voto|wang|weir|wien|wiki|wine|work|xbox|yoga|zara|zero|zone|дети|сайт|بارت|بيتك|ڀارت|تونس|شبكة|عراق|عمان|موقع|भारत|ভারত|ভাৰত|ਭਾਰਤ|ભારત|ଭାରତ|ಭಾರತ|ලංකා|アマゾン|グーグル|クラウド|ポイント|组织机构|電訊盈科|香格里拉|aaa|abb|abc|aco|ads|aeg|afl|aig|anz|aol|app|art|aws|axa|bar|bbc|bbt|bcg|bcn|bet|bid|bio|biz|bms|bmw|bom|boo|bot|box|buy|bzh|cab|cal|cam|car|cat|cba|cbn|ceo|cfa|cfd|com|cpa|crs|dad|day|dds|dev|dhl|diy|dnp|dog|dot|dtv|dvr|eat|eco|edu|esq|eus|fan|fit|fly|foo|fox|frl|ftr|fun|fyi|gal|gap|gay|gdn|gea|gle|gmo|gmx|goo|gop|got|gov|hbo|hiv|hkt|hot|how|ibm|ice|icu|ifm|inc|ing|ink|int|ist|itv|jcb|jio|jll|jmp|jnj|jot|joy|kfh|kia|kim|kpn|krd|lat|law|lds|llc|llp|lol|lpl|ltd|man|map|mba|med|men|mil|mit|mlb|mls|mma|moe|moi|mom|mov|msd|mtn|mtr|nab|nba|nec|net|new|nfl|ngo|nhk|now|nra|nrw|ntt|nyc|obi|one|ong|onl|ooo|org|ott|ovh|pay|pet|phd|pid|pin|pnc|pro|pru|pub|pwc|red|ren|ril|rio|rip|run|rwe|sap|sas|sbi|sbs|scb|sew|sex|sfr|ski|sky|soy|spa|srl|stc|tab|tax|tci|tdk|tel|thd|tjx|top|trv|tui|tvs|ubs|uno|uol|ups|vet|vig|vin|vip|wed|win|wme|wow|wtc|wtf|xin|xxx|xyz|you|yun|zip|бел|ком|қаз|мкд|мон|орг|рус|срб|укр|հայ|קום|عرب|قطر|كوم|مصر|कॉम|नेट|คอม|ไทย|ລາວ|ストア|セール|みんな|中文网|亚马逊|天主教|我爱你|新加坡|淡马锡|飞利浦|ac|ad|ae|af|ag|ai|al|am|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw|ελ|ευ|бг|ею|рф|გე|닷넷|닷컴|삼성|한국|コム|世界|中信|中国|中國|企业|佛山|信息|健康|八卦|公司|公益|台湾|台灣|商城|商店|商标|嘉里|在线|大拿|娱乐|家電|广东|微博|慈善|手机|招聘|政务|政府|新闻|时尚|書籍|机构|游戏|澳門|点看|移动|网址|网店|网站|网络|联通|谷歌|购物|通販|集团|食品|餐厅|香港)$/;
  }
});

// node_modules/autolinker/dist/commonjs/parser/uri-utils.js
var require_uri_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/uri-utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isDomainLabelStartChar = exports2.isSchemeStartChar = exports2.tldUrlHostRe = exports2.schemeUrlRe = exports2.invalidSchemeRe = exports2.httpSchemePrefixRe = exports2.httpSchemeRe = void 0;
    exports2.isSchemeChar = isSchemeChar;
    exports2.isDomainLabelChar = isDomainLabelChar;
    exports2.isPathChar = isPathChar;
    exports2.isUrlSuffixStartChar = isUrlSuffixStartChar;
    exports2.isKnownTld = isKnownTld;
    exports2.isValidSchemeUrl = isValidSchemeUrl;
    exports2.isValidTldMatch = isValidTldMatch;
    exports2.isValidIpV4Address = isValidIpV4Address;
    var char_utils_1 = require_char_utils();
    var known_tlds_1 = require_known_tlds();
    exports2.httpSchemeRe = /https?:\/\//i;
    exports2.httpSchemePrefixRe = new RegExp("^" + exports2.httpSchemeRe.source, "i");
    exports2.invalidSchemeRe = /^(javascript|vbscript):/i;
    exports2.schemeUrlRe = /^[A-Za-z][-.+A-Za-z0-9]*:(\/\/)?([^:/]*)/;
    exports2.tldUrlHostRe = /^(?:\/\/)?([^/#?:]+)/;
    exports2.isSchemeStartChar = char_utils_1.isAsciiLetterChar;
    function isSchemeChar(charCode) {
      return (0, char_utils_1.isAsciiLetterChar)(charCode) || (0, char_utils_1.isDigitChar)(charCode) || charCode === 43 || // '+'
      charCode === 45 || // '-'
      charCode === 46;
    }
    exports2.isDomainLabelStartChar = char_utils_1.isAlphaNumericOrMarkChar;
    function isDomainLabelChar(charCode) {
      return charCode === 95 || (0, exports2.isDomainLabelStartChar)(charCode);
    }
    function isPathChar(charCode) {
      return (0, char_utils_1.isAlphaNumericOrMarkChar)(charCode) || (0, char_utils_1.isUrlSuffixAllowedSpecialChar)(charCode) || (0, char_utils_1.isUrlSuffixNotAllowedAsFinalChar)(charCode);
    }
    function isUrlSuffixStartChar(charCode) {
      return charCode === 47 || // '/'
      charCode === 63 || // '?'
      charCode === 35;
    }
    function isKnownTld(tld) {
      return known_tlds_1.tldRegex.test(tld.toLowerCase());
    }
    function isValidSchemeUrl(url2) {
      if (exports2.invalidSchemeRe.test(url2)) {
        return false;
      }
      var schemeMatch = url2.match(exports2.schemeUrlRe);
      if (!schemeMatch) {
        return false;
      }
      var isAuthorityMatch = !!schemeMatch[1];
      var host = schemeMatch[2];
      if (isAuthorityMatch) {
        return true;
      }
      if (host.indexOf(".") === -1 || !/[A-Za-z]/.test(host)) {
        return false;
      }
      return true;
    }
    function isValidTldMatch(url2) {
      var tldUrlHostMatch = url2.match(exports2.tldUrlHostRe);
      if (!tldUrlHostMatch) {
        return false;
      }
      var host = tldUrlHostMatch[0];
      var hostLabels = host.split(".");
      if (hostLabels.length < 2) {
        return false;
      }
      var tld = hostLabels[hostLabels.length - 1];
      if (!isKnownTld(tld)) {
        return false;
      }
      return true;
    }
    var ipV4Re = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
    var ipV4PartRe = /[:/?#]/;
    function isValidIpV4Address(url2) {
      var ipV4Part = url2.split(ipV4PartRe, 1)[0];
      return ipV4Re.test(ipV4Part);
    }
  }
});

// node_modules/autolinker/dist/commonjs/match/url-match.js
var require_url_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/url-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatch = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var abstract_match_1 = require_abstract_match();
    var uri_utils_1 = require_uri_utils();
    var wwwPrefixRegex = /^(https?:\/\/)?(?:www\.)?/i;
    var protocolRelativeRegex = /^\/\//;
    var UrlMatch = (
      /** @class */
      (function(_super) {
        tslib_1.__extends(UrlMatch2, _super);
        function UrlMatch2(cfg) {
          var _this = _super.call(this, cfg) || this;
          _this.type = "url";
          _this.url = "";
          _this.urlMatchType = "scheme";
          _this.protocolRelativeMatch = false;
          _this.stripPrefix = {
            scheme: true,
            www: true
          };
          _this.stripTrailingSlash = true;
          _this.decodePercentEncoding = true;
          _this.protocolPrepended = false;
          _this.urlMatchType = cfg.urlMatchType;
          _this.url = cfg.url;
          _this.protocolRelativeMatch = cfg.protocolRelativeMatch;
          _this.stripPrefix = cfg.stripPrefix;
          _this.stripTrailingSlash = cfg.stripTrailingSlash;
          _this.decodePercentEncoding = cfg.decodePercentEncoding;
          return _this;
        }
        UrlMatch2.prototype.getType = function() {
          return "url";
        };
        UrlMatch2.prototype.getUrlMatchType = function() {
          return this.urlMatchType;
        };
        UrlMatch2.prototype.getUrl = function() {
          var url2 = this.url;
          if (!this.protocolRelativeMatch && this.urlMatchType !== "scheme" && !this.protocolPrepended) {
            url2 = this.url = "http://" + url2;
            this.protocolPrepended = true;
          }
          return url2;
        };
        UrlMatch2.prototype.getAnchorHref = function() {
          var url2 = this.getUrl();
          return url2.replace(/&amp;/g, "&");
        };
        UrlMatch2.prototype.getAnchorText = function() {
          var anchorText = this.getMatchedText();
          if (this.protocolRelativeMatch) {
            anchorText = stripProtocolRelativePrefix(anchorText);
          }
          if (this.stripPrefix.scheme) {
            anchorText = stripSchemePrefix(anchorText);
          }
          if (this.stripPrefix.www) {
            anchorText = stripWwwPrefix(anchorText);
          }
          if (this.stripTrailingSlash) {
            anchorText = removeTrailingSlash(anchorText);
          }
          if (this.decodePercentEncoding) {
            anchorText = removePercentEncoding(anchorText);
          }
          return anchorText;
        };
        return UrlMatch2;
      })(abstract_match_1.AbstractMatch)
    );
    exports2.UrlMatch = UrlMatch;
    function stripSchemePrefix(url2) {
      return url2.replace(uri_utils_1.httpSchemePrefixRe, "");
    }
    function stripWwwPrefix(url2) {
      if (!url2.includes("www.")) {
        return url2;
      } else {
        return url2.replace(wwwPrefixRegex, "$1");
      }
    }
    function stripProtocolRelativePrefix(text2) {
      return text2.replace(protocolRelativeRegex, "");
    }
    function removeTrailingSlash(anchorText) {
      if (anchorText.charAt(anchorText.length - 1) === "/") {
        anchorText = anchorText.slice(0, -1);
      }
      return anchorText;
    }
    function removePercentEncoding(anchorText) {
      var preProcessedEntityAnchorText = anchorText.replace(/%(?:22|26|27|3C|3E)/gi, function(match) {
        if (match === "%22")
          return "&quot;";
        if (match === "%26")
          return "&amp;";
        if (match === "%27")
          return "&#39;";
        if (match === "%3C" || match === "%3c")
          return "&lt;";
        return "&gt;";
      });
      if (preProcessedEntityAnchorText.includes("%")) {
        try {
          return decodeURIComponent(preProcessedEntityAnchorText);
        } catch (error) {
        }
      }
      return preProcessedEntityAnchorText;
    }
  }
});

// node_modules/autolinker/dist/commonjs/parser/email-utils.js
var require_email_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/email-utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isEmailLocalPartStartChar = exports2.mailtoSchemePrefixRe = void 0;
    exports2.isEmailLocalPartChar = isEmailLocalPartChar;
    exports2.isValidEmail = isValidEmail;
    var char_utils_1 = require_char_utils();
    var uri_utils_1 = require_uri_utils();
    exports2.mailtoSchemePrefixRe = /^mailto:/i;
    exports2.isEmailLocalPartStartChar = char_utils_1.isAlphaNumericOrMarkChar;
    function isEmailLocalPartChar(charCode) {
      return (0, exports2.isEmailLocalPartStartChar)(charCode) || (0, char_utils_1.isValidEmailLocalPartSpecialChar)(charCode);
    }
    function isValidEmail(emailAddress) {
      var emailAddressTld = emailAddress.split(".").pop();
      return (0, uri_utils_1.isKnownTld)(emailAddressTld);
    }
  }
});

// node_modules/autolinker/dist/commonjs/match/email-match.js
var require_email_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/email-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EmailMatch = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var abstract_match_1 = require_abstract_match();
    var EmailMatch = (
      /** @class */
      (function(_super) {
        tslib_1.__extends(EmailMatch2, _super);
        function EmailMatch2(cfg) {
          var _this = _super.call(this, cfg) || this;
          _this.type = "email";
          _this.email = "";
          _this.email = cfg.email;
          return _this;
        }
        EmailMatch2.prototype.getType = function() {
          return "email";
        };
        EmailMatch2.prototype.getEmail = function() {
          return this.email;
        };
        EmailMatch2.prototype.getAnchorHref = function() {
          return "mailto:" + this.email;
        };
        EmailMatch2.prototype.getAnchorText = function() {
          return this.email;
        };
        return EmailMatch2;
      })(abstract_match_1.AbstractMatch)
    );
    exports2.EmailMatch = EmailMatch;
  }
});

// node_modules/autolinker/dist/commonjs/parser/hashtag-utils.js
var require_hashtag_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/hashtag-utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.hashtagServices = void 0;
    exports2.isHashtagTextChar = isHashtagTextChar;
    exports2.isValidHashtag = isValidHashtag;
    var char_utils_1 = require_char_utils();
    function isHashtagTextChar(charCode) {
      return charCode === 95 || (0, char_utils_1.isAlphaNumericOrMarkChar)(charCode);
    }
    function isValidHashtag(hashtag) {
      return hashtag.length <= 140;
    }
    exports2.hashtagServices = [
      "twitter",
      "facebook",
      "instagram",
      "tiktok",
      "youtube"
    ];
  }
});

// node_modules/autolinker/dist/commonjs/match/hashtag-match.js
var require_hashtag_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/hashtag-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HashtagMatch = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var utils_1 = require_utils();
    var abstract_match_1 = require_abstract_match();
    var HashtagMatch = (
      /** @class */
      (function(_super) {
        tslib_1.__extends(HashtagMatch2, _super);
        function HashtagMatch2(cfg) {
          var _this = _super.call(this, cfg) || this;
          _this.type = "hashtag";
          _this.serviceName = "twitter";
          _this.hashtag = "";
          _this.serviceName = cfg.serviceName;
          _this.hashtag = cfg.hashtag;
          return _this;
        }
        HashtagMatch2.prototype.getType = function() {
          return "hashtag";
        };
        HashtagMatch2.prototype.getServiceName = function() {
          return this.serviceName;
        };
        HashtagMatch2.prototype.getHashtag = function() {
          return this.hashtag;
        };
        HashtagMatch2.prototype.getAnchorHref = function() {
          var serviceName = this.serviceName, hashtag = this.hashtag;
          switch (serviceName) {
            case "twitter":
              return "https://twitter.com/hashtag/" + hashtag;
            case "facebook":
              return "https://www.facebook.com/hashtag/" + hashtag;
            case "instagram":
              return "https://instagram.com/explore/tags/" + hashtag;
            case "tiktok":
              return "https://www.tiktok.com/tag/" + hashtag;
            case "youtube":
              return "https://youtube.com/hashtag/" + hashtag;
            /* istanbul ignore next */
            default:
              (0, utils_1.assertNever)(serviceName);
          }
        };
        HashtagMatch2.prototype.getAnchorText = function() {
          return "#" + this.hashtag;
        };
        HashtagMatch2.prototype.getCssClassSuffixes = function() {
          var cssClassSuffixes = _super.prototype.getCssClassSuffixes.call(this), serviceName = this.getServiceName();
          if (serviceName) {
            cssClassSuffixes.push(serviceName);
          }
          return cssClassSuffixes;
        };
        return HashtagMatch2;
      })(abstract_match_1.AbstractMatch)
    );
    exports2.HashtagMatch = HashtagMatch;
  }
});

// node_modules/autolinker/dist/commonjs/parser/mention-utils.js
var require_mention_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/mention-utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.mentionServices = void 0;
    exports2.isMentionTextChar = isMentionTextChar;
    exports2.isValidMention = isValidMention;
    var char_utils_1 = require_char_utils();
    var mentionRegexes = {
      twitter: /^@\w{1,15}$/,
      instagram: /^@[_\w]{1,30}$/,
      soundcloud: /^@[-a-z0-9_]{3,25}$/,
      // TikTok usernames are 1-24 characters containing letters, numbers, underscores
      // and periods, but cannot end in a period: https://support.tiktok.com/en/getting-started/setting-up-your-profile/changing-your-username
      tiktok: /^@[.\w]{1,23}[\w]$/,
      // Youtube usernames are 3-30 characters containing letters, numbers, underscores,
      // dashes, or latin middle dots ('·').
      // https://support.google.com/youtube/answer/11585688?hl=en&co=GENIE.Platform%3DAndroid#tns
      youtube: /^@[-.·\w]{3,30}$/
    };
    function isMentionTextChar(charCode) {
      return charCode === 45 || // '-'
      charCode === 46 || // '.'
      charCode === 95 || // '_'
      (0, char_utils_1.isAsciiLetterChar)(charCode) || (0, char_utils_1.isDigitChar)(charCode);
    }
    function isValidMention(mention, serviceName) {
      var re = mentionRegexes[serviceName];
      return re.test(mention);
    }
    exports2.mentionServices = [
      "twitter",
      "instagram",
      "soundcloud",
      "tiktok",
      "youtube"
    ];
  }
});

// node_modules/autolinker/dist/commonjs/match/mention-match.js
var require_mention_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/mention-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MentionMatch = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var utils_1 = require_utils();
    var abstract_match_1 = require_abstract_match();
    var MentionMatch = (
      /** @class */
      (function(_super) {
        tslib_1.__extends(MentionMatch2, _super);
        function MentionMatch2(cfg) {
          var _this = _super.call(this, cfg) || this;
          _this.type = "mention";
          _this.serviceName = "twitter";
          _this.mention = "";
          _this.mention = cfg.mention;
          _this.serviceName = cfg.serviceName;
          return _this;
        }
        MentionMatch2.prototype.getType = function() {
          return "mention";
        };
        MentionMatch2.prototype.getMention = function() {
          return this.mention;
        };
        MentionMatch2.prototype.getServiceName = function() {
          return this.serviceName;
        };
        MentionMatch2.prototype.getAnchorHref = function() {
          switch (this.serviceName) {
            case "twitter":
              return "https://twitter.com/" + this.mention;
            case "instagram":
              return "https://instagram.com/" + this.mention;
            case "soundcloud":
              return "https://soundcloud.com/" + this.mention;
            case "tiktok":
              return "https://www.tiktok.com/@" + this.mention;
            case "youtube":
              return "https://youtube.com/@" + this.mention;
            /* istanbul ignore next */
            default:
              (0, utils_1.assertNever)(this.serviceName);
          }
        };
        MentionMatch2.prototype.getAnchorText = function() {
          return "@" + this.mention;
        };
        MentionMatch2.prototype.getCssClassSuffixes = function() {
          var cssClassSuffixes = _super.prototype.getCssClassSuffixes.call(this), serviceName = this.getServiceName();
          if (serviceName) {
            cssClassSuffixes.push(serviceName);
          }
          return cssClassSuffixes;
        };
        return MentionMatch2;
      })(abstract_match_1.AbstractMatch)
    );
    exports2.MentionMatch = MentionMatch;
  }
});

// node_modules/autolinker/dist/commonjs/parser/phone-number-utils.js
var require_phone_number_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/phone-number-utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isPhoneNumberSeparatorChar = isPhoneNumberSeparatorChar;
    exports2.isPhoneNumberControlChar = isPhoneNumberControlChar;
    exports2.isValidPhoneNumber = isValidPhoneNumber;
    var hasDelimCharsRe = /[-. ()]/;
    var mostPhoneNumbers = /(?:(?:(?:(\+)?\d{1,3}[-. ]?)?\(?\d{3}\)?[-. ]?\d{3}[-. ]?\d{4})|(?:(\+)(?:9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)[-. ]?(?:\d[-. ]?){6,12}\d+))([,;]+[0-9]+#?)*/;
    var japanesePhoneRe = /(0([1-9]-?[1-9]\d{3}|[1-9]{2}-?\d{3}|[1-9]{2}\d{1}-?\d{2}|[1-9]{2}\d{2}-?\d{1})-?\d{4}|0[789]0-?\d{4}-?\d{4}|050-?\d{4}-?\d{4})/;
    var validPhoneNumberRe = new RegExp("^".concat(mostPhoneNumbers.source, "|").concat(japanesePhoneRe.source, "$"));
    function isPhoneNumberSeparatorChar(charCode) {
      return charCode === 45 || // '-'
      charCode === 46 || // '.'
      charCode === 32;
    }
    function isPhoneNumberControlChar(charCode) {
      return charCode === 44 || // ','
      charCode === 59;
    }
    function isValidPhoneNumber(phoneNumberText) {
      var hasDelimiters = phoneNumberText.charAt(0) === "+" || hasDelimCharsRe.test(phoneNumberText);
      return hasDelimiters && validPhoneNumberRe.test(phoneNumberText);
    }
  }
});

// node_modules/autolinker/dist/commonjs/match/phone-match.js
var require_phone_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/phone-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PhoneMatch = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var abstract_match_1 = require_abstract_match();
    var PhoneMatch = (
      /** @class */
      (function(_super) {
        tslib_1.__extends(PhoneMatch2, _super);
        function PhoneMatch2(cfg) {
          var _this = _super.call(this, cfg) || this;
          _this.type = "phone";
          _this.number = "";
          _this.plusSign = false;
          _this.number = cfg.number;
          _this.plusSign = cfg.plusSign;
          return _this;
        }
        PhoneMatch2.prototype.getType = function() {
          return "phone";
        };
        PhoneMatch2.prototype.getPhoneNumber = function() {
          return this.number;
        };
        PhoneMatch2.prototype.getNumber = function() {
          return this.getPhoneNumber();
        };
        PhoneMatch2.prototype.getAnchorHref = function() {
          return "tel:" + (this.plusSign ? "+" : "") + this.number;
        };
        PhoneMatch2.prototype.getAnchorText = function() {
          return this.matchedText;
        };
        return PhoneMatch2;
      })(abstract_match_1.AbstractMatch)
    );
    exports2.PhoneMatch = PhoneMatch;
  }
});

// node_modules/autolinker/dist/commonjs/parser/parse-matches.js
var require_parse_matches = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/parse-matches.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseMatches = parseMatches;
    exports2.excludeUnbalancedTrailingBracesAndPunctuation = excludeUnbalancedTrailingBracesAndPunctuation;
    var url_match_1 = require_url_match();
    var utils_1 = require_utils();
    var uri_utils_1 = require_uri_utils();
    var email_utils_1 = require_email_utils();
    var email_match_1 = require_email_match();
    var hashtag_utils_1 = require_hashtag_utils();
    var hashtag_match_1 = require_hashtag_match();
    var mention_utils_1 = require_mention_utils();
    var mention_match_1 = require_mention_match();
    var phone_number_utils_1 = require_phone_number_utils();
    var phone_match_1 = require_phone_match();
    var char_utils_1 = require_char_utils();
    var ParseMatchesContext = (
      /** @class */
      (function() {
        function ParseMatchesContext2(text2, args) {
          this.charIdx = 0;
          this.matches = [];
          this._stateMachines = [];
          this.schemeUrlMachinesCount = 0;
          this.text = text2;
          this.tagBuilder = args.tagBuilder;
          this.stripPrefix = args.stripPrefix;
          this.stripTrailingSlash = args.stripTrailingSlash;
          this.decodePercentEncoding = args.decodePercentEncoding;
          this.hashtagServiceName = args.hashtagServiceName;
          this.mentionServiceName = args.mentionServiceName;
        }
        Object.defineProperty(ParseMatchesContext2.prototype, "stateMachines", {
          get: function() {
            return this._stateMachines;
          },
          enumerable: false,
          configurable: true
        });
        ParseMatchesContext2.prototype.addMachine = function(stateMachine) {
          this._stateMachines.push(stateMachine);
          if (isSchemeUrlStateMachine(stateMachine)) {
            this.schemeUrlMachinesCount++;
          }
        };
        ParseMatchesContext2.prototype.removeMachine = function(stateMachine) {
          this._stateMachines = this._stateMachines.filter(function(m) {
            return m !== stateMachine;
          });
          if (isSchemeUrlStateMachine(stateMachine)) {
            this.schemeUrlMachinesCount--;
          }
        };
        ParseMatchesContext2.prototype.hasSchemeUrlMachine = function() {
          return this.schemeUrlMachinesCount > 0;
        };
        return ParseMatchesContext2;
      })()
    );
    function parseMatches(text2, args) {
      var context = new ParseMatchesContext(text2, args);
      for (; context.charIdx < context.text.length; context.charIdx++) {
        var char = text2.charAt(context.charIdx);
        var charCode = text2.charCodeAt(context.charIdx);
        if (context.stateMachines.length === 0) {
          stateNoMatch(context, char, charCode);
        } else {
          for (var stateIdx = context.stateMachines.length - 1; stateIdx >= 0; stateIdx--) {
            var stateMachine = context.stateMachines[stateIdx];
            switch (stateMachine.state) {
              // Protocol-relative URL states
              case 11:
                stateProtocolRelativeSlash1(context, stateMachine, charCode);
                break;
              case 12:
                stateProtocolRelativeSlash2(context, stateMachine, charCode);
                break;
              case 0:
                stateSchemeChar(context, stateMachine, charCode);
                break;
              case 1:
                stateSchemeHyphen(context, stateMachine, charCode);
                break;
              case 2:
                stateSchemeColon(context, stateMachine, charCode);
                break;
              case 3:
                stateSchemeSlash1(context, stateMachine, charCode);
                break;
              case 4:
                stateSchemeSlash2(context, stateMachine, char, charCode);
                break;
              case 5:
                stateDomainLabelChar(context, stateMachine, charCode);
                break;
              case 6:
                stateDomainHyphen(context, stateMachine, char, charCode);
                break;
              case 7:
                stateDomainDot(context, stateMachine, char, charCode);
                break;
              case 13:
                stateIpV4Digit(context, stateMachine, charCode);
                break;
              case 14:
                stateIpV4Dot(context, stateMachine, charCode);
                break;
              case 8:
                statePortColon(context, stateMachine, charCode);
                break;
              case 9:
                statePortNumber(context, stateMachine, charCode);
                break;
              case 10:
                statePath(context, stateMachine, charCode);
                break;
              // Email States
              case 15:
                stateEmailMailto_M(context, stateMachine, char, charCode);
                break;
              case 16:
                stateEmailMailto_A(context, stateMachine, char, charCode);
                break;
              case 17:
                stateEmailMailto_I(context, stateMachine, char, charCode);
                break;
              case 18:
                stateEmailMailto_L(context, stateMachine, char, charCode);
                break;
              case 19:
                stateEmailMailto_T(context, stateMachine, char, charCode);
                break;
              case 20:
                stateEmailMailto_O(context, stateMachine, charCode);
                break;
              case 21:
                stateEmailMailtoColon(context, stateMachine, charCode);
                break;
              case 22:
                stateEmailLocalPart(context, stateMachine, charCode);
                break;
              case 23:
                stateEmailLocalPartDot(context, stateMachine, charCode);
                break;
              case 24:
                stateEmailAtSign(context, stateMachine, charCode);
                break;
              case 25:
                stateEmailDomainChar(context, stateMachine, charCode);
                break;
              case 26:
                stateEmailDomainHyphen(context, stateMachine, charCode);
                break;
              case 27:
                stateEmailDomainDot(context, stateMachine, charCode);
                break;
              // Hashtag states
              case 28:
                stateHashtagHashChar(context, stateMachine, charCode);
                break;
              case 29:
                stateHashtagTextChar(context, stateMachine, charCode);
                break;
              // Mention states
              case 30:
                stateMentionAtChar(context, stateMachine, charCode);
                break;
              case 31:
                stateMentionTextChar(context, stateMachine, charCode);
                break;
              // Phone number states
              case 32:
                statePhoneNumberOpenParen(context, stateMachine, char, charCode);
                break;
              case 33:
                statePhoneNumberAreaCodeDigit1(context, stateMachine, charCode);
                break;
              case 34:
                statePhoneNumberAreaCodeDigit2(context, stateMachine, charCode);
                break;
              case 35:
                statePhoneNumberAreaCodeDigit3(context, stateMachine, charCode);
                break;
              case 36:
                statePhoneNumberCloseParen(context, stateMachine, char, charCode);
                break;
              case 37:
                statePhoneNumberPlus(context, stateMachine, char, charCode);
                break;
              case 38:
                statePhoneNumberDigit(context, stateMachine, char, charCode);
                break;
              case 39:
                statePhoneNumberSeparator(context, stateMachine, char, charCode);
                break;
              case 40:
                statePhoneNumberControlChar(context, stateMachine, charCode);
                break;
              case 41:
                statePhoneNumberPoundChar(context, stateMachine, charCode);
                break;
              /* istanbul ignore next */
              default:
                (0, utils_1.assertNever)(stateMachine.state);
            }
          }
          if (!context.hasSchemeUrlMachine() && context.charIdx > 0 && (0, uri_utils_1.isSchemeStartChar)(charCode)) {
            var prevCharCode = context.text.charCodeAt(context.charIdx - 1);
            if (!(0, uri_utils_1.isSchemeStartChar)(prevCharCode)) {
              context.addMachine(createSchemeUrlStateMachine(
                context.charIdx,
                0
                /* State.SchemeChar */
              ));
            }
          }
        }
      }
      for (var i = context.stateMachines.length - 1; i >= 0; i--) {
        context.stateMachines.forEach(function(stateMachine2) {
          return captureMatchIfValidAndRemove(context, stateMachine2);
        });
      }
      return context.matches;
    }
    function stateNoMatch(context, char, charCode) {
      var charIdx = context.charIdx;
      if (charCode === 35) {
        context.addMachine(createHashtagStateMachine(
          charIdx,
          28
          /* State.HashtagHashChar */
        ));
      } else if (charCode === 64) {
        context.addMachine(createMentionStateMachine(
          charIdx,
          30
          /* State.MentionAtChar */
        ));
      } else if (charCode === 47) {
        context.addMachine(createTldUrlStateMachine(
          charIdx,
          11
          /* State.ProtocolRelativeSlash1 */
        ));
      } else if (charCode === 43) {
        context.addMachine(createPhoneNumberStateMachine(
          charIdx,
          37
          /* State.PhoneNumberPlus */
        ));
      } else if (charCode === 40) {
        context.addMachine(createPhoneNumberStateMachine(
          charIdx,
          32
          /* State.PhoneNumberOpenParen */
        ));
      } else {
        if ((0, char_utils_1.isDigitChar)(charCode)) {
          context.addMachine(createPhoneNumberStateMachine(
            charIdx,
            38
            /* State.PhoneNumberDigit */
          ));
          context.addMachine(createIpV4UrlStateMachine(
            charIdx,
            13
            /* State.IpV4Digit */
          ));
        }
        if ((0, email_utils_1.isEmailLocalPartStartChar)(charCode)) {
          var startState = char.toLowerCase() === "m" ? 15 : 22;
          context.addMachine(createEmailStateMachine(charIdx, startState));
        }
        if ((0, uri_utils_1.isSchemeStartChar)(charCode)) {
          context.addMachine(createSchemeUrlStateMachine(
            charIdx,
            0
            /* State.SchemeChar */
          ));
        }
        if ((0, char_utils_1.isAlphaNumericOrMarkChar)(charCode)) {
          context.addMachine(createTldUrlStateMachine(
            charIdx,
            5
            /* State.DomainLabelChar */
          ));
        }
      }
    }
    function stateSchemeChar(context, stateMachine, charCode) {
      if (charCode === 58) {
        stateMachine.state = 2;
      } else if (charCode === 45) {
        stateMachine.state = 1;
      } else if ((0, uri_utils_1.isSchemeChar)(charCode)) {
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateSchemeHyphen(context, stateMachine, charCode) {
      var charIdx = context.charIdx;
      if (charCode === 45) {
      } else if (charCode === 47) {
        context.removeMachine(stateMachine);
        context.addMachine(createTldUrlStateMachine(
          charIdx,
          11
          /* State.ProtocolRelativeSlash1 */
        ));
      } else if ((0, uri_utils_1.isSchemeChar)(charCode)) {
        stateMachine.state = 0;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateSchemeColon(context, stateMachine, charCode) {
      var charIdx = context.charIdx;
      if (charCode === 47) {
        stateMachine.state = 3;
      } else if (charCode === 46) {
        context.removeMachine(stateMachine);
      } else if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 5;
        if ((0, uri_utils_1.isSchemeStartChar)(charCode)) {
          context.addMachine(createSchemeUrlStateMachine(
            charIdx,
            0
            /* State.SchemeChar */
          ));
        }
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateSchemeSlash1(context, stateMachine, charCode) {
      if (charCode === 47) {
        stateMachine.state = 4;
      } else if ((0, uri_utils_1.isPathChar)(charCode)) {
        stateMachine.state = 10;
        stateMachine.acceptStateReached = true;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateSchemeSlash2(context, stateMachine, char, charCode) {
      if (charCode === 47) {
        stateMachine.state = 10;
        stateMachine.acceptStateReached = true;
      } else if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 5;
        stateMachine.acceptStateReached = true;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateProtocolRelativeSlash1(context, stateMachine, charCode) {
      if (charCode === 47) {
        stateMachine.state = 12;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateProtocolRelativeSlash2(context, stateMachine, charCode) {
      if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 5;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateDomainLabelChar(context, stateMachine, charCode) {
      if (charCode === 46) {
        stateMachine.state = 7;
      } else if (charCode === 45) {
        stateMachine.state = 6;
      } else if (charCode === 58) {
        stateMachine.state = 8;
      } else if ((0, uri_utils_1.isUrlSuffixStartChar)(charCode)) {
        stateMachine.state = 10;
      } else if ((0, uri_utils_1.isDomainLabelChar)(charCode)) {
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateDomainHyphen(context, stateMachine, char, charCode) {
      if (charCode === 45) {
      } else if (charCode === 46) {
        captureMatchIfValidAndRemove(context, stateMachine);
      } else if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 5;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateDomainDot(context, stateMachine, char, charCode) {
      if (charCode === 46) {
        captureMatchIfValidAndRemove(context, stateMachine);
      } else if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 5;
        stateMachine.acceptStateReached = true;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateIpV4Digit(context, stateMachine, charCode) {
      if (charCode === 46) {
        stateMachine.state = 14;
      } else if (charCode === 58) {
        stateMachine.state = 8;
      } else if ((0, char_utils_1.isDigitChar)(charCode)) {
      } else if ((0, uri_utils_1.isUrlSuffixStartChar)(charCode)) {
        stateMachine.state = 10;
      } else if ((0, char_utils_1.isAlphaNumericOrMarkChar)(charCode)) {
        context.removeMachine(stateMachine);
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateIpV4Dot(context, stateMachine, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.octetsEncountered++;
        if (stateMachine.octetsEncountered === 4) {
          stateMachine.acceptStateReached = true;
        }
        stateMachine.state = 13;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function statePortColon(context, stateMachine, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 9;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function statePortNumber(context, stateMachine, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
      } else if ((0, uri_utils_1.isUrlSuffixStartChar)(charCode)) {
        stateMachine.state = 10;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function statePath(context, stateMachine, charCode) {
      if ((0, uri_utils_1.isPathChar)(charCode)) {
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateEmailMailto_M(context, stateMachine, char, charCode) {
      if (char.toLowerCase() === "a") {
        stateMachine.state = 16;
      } else {
        stateEmailLocalPart(context, stateMachine, charCode);
      }
    }
    function stateEmailMailto_A(context, stateMachine, char, charCode) {
      if (char.toLowerCase() === "i") {
        stateMachine.state = 17;
      } else {
        stateEmailLocalPart(context, stateMachine, charCode);
      }
    }
    function stateEmailMailto_I(context, stateMachine, char, charCode) {
      if (char.toLowerCase() === "l") {
        stateMachine.state = 18;
      } else {
        stateEmailLocalPart(context, stateMachine, charCode);
      }
    }
    function stateEmailMailto_L(context, stateMachine, char, charCode) {
      if (char.toLowerCase() === "t") {
        stateMachine.state = 19;
      } else {
        stateEmailLocalPart(context, stateMachine, charCode);
      }
    }
    function stateEmailMailto_T(context, stateMachine, char, charCode) {
      if (char.toLowerCase() === "o") {
        stateMachine.state = 20;
      } else {
        stateEmailLocalPart(context, stateMachine, charCode);
      }
    }
    function stateEmailMailto_O(context, stateMachine, charCode) {
      if (charCode === 58) {
        stateMachine.state = 21;
      } else {
        stateEmailLocalPart(context, stateMachine, charCode);
      }
    }
    function stateEmailMailtoColon(context, stateMachine, charCode) {
      if ((0, email_utils_1.isEmailLocalPartChar)(charCode)) {
        stateMachine.state = 22;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateEmailLocalPart(context, stateMachine, charCode) {
      if (charCode === 46) {
        stateMachine.state = 23;
      } else if (charCode === 64) {
        stateMachine.state = 24;
      } else if ((0, email_utils_1.isEmailLocalPartChar)(charCode)) {
        stateMachine.state = 22;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateEmailLocalPartDot(context, stateMachine, charCode) {
      if (charCode === 46) {
        context.removeMachine(stateMachine);
      } else if (charCode === 64) {
        context.removeMachine(stateMachine);
      } else if ((0, email_utils_1.isEmailLocalPartChar)(charCode)) {
        stateMachine.state = 22;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateEmailAtSign(context, stateMachine, charCode) {
      if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 25;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateEmailDomainChar(context, stateMachine, charCode) {
      if (charCode === 46) {
        stateMachine.state = 27;
      } else if (charCode === 45) {
        stateMachine.state = 26;
      } else if ((0, uri_utils_1.isDomainLabelChar)(charCode)) {
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateEmailDomainHyphen(context, stateMachine, charCode) {
      if (charCode === 45 || charCode === 46) {
        captureMatchIfValidAndRemove(context, stateMachine);
      } else if ((0, uri_utils_1.isDomainLabelChar)(charCode)) {
        stateMachine.state = 25;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateEmailDomainDot(context, stateMachine, charCode) {
      if (charCode === 46 || charCode === 45) {
        captureMatchIfValidAndRemove(context, stateMachine);
      } else if ((0, uri_utils_1.isDomainLabelStartChar)(charCode)) {
        stateMachine.state = 25;
        stateMachine.acceptStateReached = true;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateHashtagHashChar(context, stateMachine, charCode) {
      if ((0, hashtag_utils_1.isHashtagTextChar)(charCode)) {
        stateMachine.state = 29;
        stateMachine.acceptStateReached = true;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateHashtagTextChar(context, stateMachine, charCode) {
      if ((0, hashtag_utils_1.isHashtagTextChar)(charCode)) {
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function stateMentionAtChar(context, stateMachine, charCode) {
      if ((0, mention_utils_1.isMentionTextChar)(charCode)) {
        stateMachine.state = 31;
        stateMachine.acceptStateReached = true;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function stateMentionTextChar(context, stateMachine, charCode) {
      if ((0, mention_utils_1.isMentionTextChar)(charCode)) {
      } else if ((0, char_utils_1.isAlphaNumericOrMarkChar)(charCode)) {
        context.removeMachine(stateMachine);
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function statePhoneNumberPlus(context, stateMachine, char, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 38;
      } else {
        context.removeMachine(stateMachine);
        stateNoMatch(context, char, charCode);
      }
    }
    function statePhoneNumberOpenParen(context, stateMachine, char, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 33;
      } else {
        context.removeMachine(stateMachine);
      }
      stateNoMatch(context, char, charCode);
    }
    function statePhoneNumberAreaCodeDigit1(context, stateMachine, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 34;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function statePhoneNumberAreaCodeDigit2(context, stateMachine, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 35;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function statePhoneNumberAreaCodeDigit3(context, stateMachine, charCode) {
      if (charCode === 41) {
        stateMachine.state = 36;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function statePhoneNumberCloseParen(context, stateMachine, char, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 38;
      } else if ((0, phone_number_utils_1.isPhoneNumberSeparatorChar)(charCode)) {
        stateMachine.state = 39;
      } else {
        context.removeMachine(stateMachine);
      }
    }
    function statePhoneNumberDigit(context, stateMachine, char, charCode) {
      var charIdx = context.charIdx;
      stateMachine.acceptStateReached = true;
      if ((0, phone_number_utils_1.isPhoneNumberControlChar)(charCode)) {
        stateMachine.state = 40;
      } else if (charCode === 35) {
        stateMachine.state = 41;
      } else if ((0, char_utils_1.isDigitChar)(charCode)) {
      } else if (charCode === 40) {
        stateMachine.state = 32;
      } else if ((0, phone_number_utils_1.isPhoneNumberSeparatorChar)(charCode)) {
        stateMachine.state = 39;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
        if ((0, uri_utils_1.isSchemeStartChar)(charCode)) {
          context.addMachine(createSchemeUrlStateMachine(
            charIdx,
            0
            /* State.SchemeChar */
          ));
        }
      }
    }
    function statePhoneNumberSeparator(context, stateMachine, char, charCode) {
      if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 38;
      } else if (charCode === 40) {
        stateMachine.state = 32;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
        stateNoMatch(context, char, charCode);
      }
    }
    function statePhoneNumberControlChar(context, stateMachine, charCode) {
      if ((0, phone_number_utils_1.isPhoneNumberControlChar)(charCode)) {
      } else if (charCode === 35) {
        stateMachine.state = 41;
      } else if ((0, char_utils_1.isDigitChar)(charCode)) {
        stateMachine.state = 38;
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function statePhoneNumberPoundChar(context, stateMachine, charCode) {
      if ((0, phone_number_utils_1.isPhoneNumberControlChar)(charCode)) {
        stateMachine.state = 40;
      } else if ((0, char_utils_1.isDigitChar)(charCode)) {
        context.removeMachine(stateMachine);
      } else {
        captureMatchIfValidAndRemove(context, stateMachine);
      }
    }
    function captureMatchIfValidAndRemove(context, stateMachine) {
      var matches = context.matches, text2 = context.text, charIdx = context.charIdx, tagBuilder = context.tagBuilder, stripPrefix = context.stripPrefix, stripTrailingSlash = context.stripTrailingSlash, decodePercentEncoding = context.decodePercentEncoding, hashtagServiceName = context.hashtagServiceName, mentionServiceName = context.mentionServiceName;
      context.removeMachine(stateMachine);
      if (!stateMachine.acceptStateReached) {
        return;
      }
      var startIdx = stateMachine.startIdx;
      var matchedText = text2.slice(stateMachine.startIdx, charIdx);
      matchedText = excludeUnbalancedTrailingBracesAndPunctuation(matchedText);
      switch (stateMachine.type) {
        case 0: {
          var charBeforeUrlMatch = text2.charCodeAt(stateMachine.startIdx - 1);
          if (charBeforeUrlMatch === 64) {
            return;
          }
          switch (stateMachine.matchType) {
            case 0: {
              var httpSchemeMatch = uri_utils_1.httpSchemeRe.exec(matchedText);
              if (httpSchemeMatch) {
                startIdx = startIdx + httpSchemeMatch.index;
                matchedText = matchedText.slice(httpSchemeMatch.index);
              }
              if (!(0, uri_utils_1.isValidSchemeUrl)(matchedText)) {
                return;
              }
              break;
            }
            case 1: {
              if (!(0, uri_utils_1.isValidTldMatch)(matchedText)) {
                return;
              }
              break;
            }
            case 2: {
              if (!(0, uri_utils_1.isValidIpV4Address)(matchedText)) {
                return;
              }
              break;
            }
            /* istanbul ignore next */
            default:
              (0, utils_1.assertNever)(stateMachine);
          }
          matches.push(new url_match_1.UrlMatch({
            tagBuilder,
            matchedText,
            offset: startIdx,
            urlMatchType: toUrlMatchType(stateMachine.matchType),
            url: matchedText,
            protocolRelativeMatch: matchedText.slice(0, 2) === "//",
            // TODO: Do these settings need to be passed to the match,
            // or should we handle them here in UrlMatcher?
            stripPrefix,
            stripTrailingSlash,
            decodePercentEncoding
          }));
          break;
        }
        case 1: {
          if ((0, email_utils_1.isValidEmail)(matchedText)) {
            matches.push(new email_match_1.EmailMatch({
              tagBuilder,
              matchedText,
              offset: startIdx,
              email: matchedText.replace(email_utils_1.mailtoSchemePrefixRe, "")
            }));
          }
          break;
        }
        case 2: {
          if ((0, hashtag_utils_1.isValidHashtag)(matchedText)) {
            matches.push(new hashtag_match_1.HashtagMatch({
              tagBuilder,
              matchedText,
              offset: startIdx,
              serviceName: hashtagServiceName,
              hashtag: matchedText.slice(1)
            }));
          }
          break;
        }
        case 3: {
          if ((0, mention_utils_1.isValidMention)(matchedText, mentionServiceName)) {
            matches.push(new mention_match_1.MentionMatch({
              tagBuilder,
              matchedText,
              offset: startIdx,
              serviceName: mentionServiceName,
              mention: matchedText.slice(1)
              // strip off the '@' character at the beginning
            }));
          }
          break;
        }
        case 4: {
          matchedText = matchedText.replace(/ +$/g, "");
          if ((0, phone_number_utils_1.isValidPhoneNumber)(matchedText)) {
            var cleanNumber = matchedText.replace(/[^0-9,;#]/g, "");
            matches.push(new phone_match_1.PhoneMatch({
              tagBuilder,
              matchedText,
              offset: startIdx,
              number: cleanNumber,
              plusSign: matchedText.charAt(0) === "+"
            }));
          }
          break;
        }
        /* istanbul ignore next */
        default:
          (0, utils_1.assertNever)(stateMachine);
      }
    }
    function toUrlMatchType(stateMachineMatchType) {
      switch (stateMachineMatchType) {
        case 0:
          return "scheme";
        case 1:
          return "tld";
        case 2:
          return "ipV4";
        /* istanbul ignore next */
        default:
          (0, utils_1.assertNever)(stateMachineMatchType);
      }
    }
    var oppositeBrace = {
      ")": "(",
      "}": "{",
      "]": "["
    };
    function excludeUnbalancedTrailingBracesAndPunctuation(matchedText) {
      var braceCounts = {
        "(": 0,
        "{": 0,
        "[": 0
      };
      for (var i = 0; i < matchedText.length; i++) {
        var char = matchedText.charAt(i);
        var charCode = matchedText.charCodeAt(i);
        if ((0, char_utils_1.isOpenBraceChar)(charCode)) {
          braceCounts[char]++;
        } else if ((0, char_utils_1.isCloseBraceChar)(charCode)) {
          braceCounts[oppositeBrace[char]]--;
        }
      }
      var endIdx = matchedText.length - 1;
      while (endIdx >= 0) {
        var char = matchedText.charAt(endIdx);
        var charCode = matchedText.charCodeAt(endIdx);
        if ((0, char_utils_1.isCloseBraceChar)(charCode)) {
          var oppositeBraceChar = oppositeBrace[char];
          if (braceCounts[oppositeBraceChar] < 0) {
            braceCounts[oppositeBraceChar]++;
            endIdx--;
          } else {
            break;
          }
        } else if ((0, char_utils_1.isUrlSuffixNotAllowedAsFinalChar)(charCode)) {
          endIdx--;
        } else {
          break;
        }
      }
      return matchedText.slice(0, endIdx + 1);
    }
    function createSchemeUrlStateMachine(startIdx, state) {
      return {
        type: 0,
        startIdx,
        state,
        acceptStateReached: false,
        matchType: 0
      };
    }
    function createTldUrlStateMachine(startIdx, state) {
      return {
        type: 0,
        startIdx,
        state,
        acceptStateReached: false,
        matchType: 1
      };
    }
    function createIpV4UrlStateMachine(startIdx, state) {
      return {
        type: 0,
        startIdx,
        state,
        acceptStateReached: false,
        matchType: 2,
        octetsEncountered: 1
        // starts at 1 because we create this machine when encountering the first octet
      };
    }
    function createEmailStateMachine(startIdx, state) {
      return {
        type: 1,
        startIdx,
        state,
        acceptStateReached: false
      };
    }
    function createHashtagStateMachine(startIdx, state) {
      return {
        type: 2,
        startIdx,
        state,
        acceptStateReached: false
      };
    }
    function createMentionStateMachine(startIdx, state) {
      return {
        type: 3,
        startIdx,
        state,
        acceptStateReached: false
      };
    }
    function createPhoneNumberStateMachine(startIdx, state) {
      return {
        type: 4,
        startIdx,
        state,
        acceptStateReached: false
      };
    }
    function isSchemeUrlStateMachine(machine) {
      return machine.type === 0 && machine.matchType === 0;
    }
  }
});

// node_modules/autolinker/dist/commonjs/htmlParser/parse-html.js
var require_parse_html = __commonJS({
  "node_modules/autolinker/dist/commonjs/htmlParser/parse-html.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseHtml = parseHtml;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var char_utils_1 = require_char_utils();
    var utils_1 = require_utils();
    var CurrentTag = (
      /** @class */
      /* @__PURE__ */ (function() {
        function CurrentTag2(cfg) {
          if (cfg === void 0) {
            cfg = {};
          }
          this.idx = cfg.idx !== void 0 ? cfg.idx : -1;
          this.type = cfg.type || "tag";
          this.name = cfg.name || "";
          this.isOpening = !!cfg.isOpening;
          this.isClosing = !!cfg.isClosing;
        }
        return CurrentTag2;
      })()
    );
    var noCurrentTag = new CurrentTag();
    var ParseHtmlContext = (
      /** @class */
      /* @__PURE__ */ (function() {
        function ParseHtmlContext2(html2, callbacks) {
          this.charIdx = 0;
          this.state = 0;
          this.currentDataIdx = 0;
          this.currentTag = noCurrentTag;
          this.html = html2;
          this.callbacks = callbacks;
        }
        return ParseHtmlContext2;
      })()
    );
    function parseHtml(html2, callbacks) {
      var context = new ParseHtmlContext(html2, callbacks);
      var len = html2.length;
      while (context.charIdx < len) {
        var char = html2.charAt(context.charIdx);
        var charCode = html2.charCodeAt(context.charIdx);
        switch (context.state) {
          case 0:
            stateData(context, char);
            break;
          case 1:
            stateTagOpen(context, char, charCode);
            break;
          case 2:
            stateEndTagOpen(context, char, charCode);
            break;
          case 3:
            stateTagName(context, char, charCode);
            break;
          case 4:
            stateBeforeAttributeName(context, char, charCode);
            break;
          case 5:
            stateAttributeName(context, char, charCode);
            break;
          case 6:
            stateAfterAttributeName(context, char, charCode);
            break;
          case 7:
            stateBeforeAttributeValue(context, char, charCode);
            break;
          case 8:
            stateAttributeValueDoubleQuoted(context, char);
            break;
          case 9:
            stateAttributeValueSingleQuoted(context, char);
            break;
          case 10:
            stateAttributeValueUnquoted(context, char, charCode);
            break;
          case 11:
            stateAfterAttributeValueQuoted(context, char, charCode);
            break;
          case 12:
            stateSelfClosingStartTag(context, char);
            break;
          case 13:
            stateMarkupDeclarationOpen(context);
            break;
          case 14:
            stateCommentStart(context, char);
            break;
          case 15:
            stateCommentStartDash(context, char);
            break;
          case 16:
            stateComment(context, char);
            break;
          case 17:
            stateCommentEndDash(context, char);
            break;
          case 18:
            stateCommentEnd(context, char);
            break;
          case 19:
            stateCommentEndBang(context, char);
            break;
          case 20:
            stateDoctype(context, char);
            break;
          /* istanbul ignore next */
          default:
            (0, utils_1.assertNever)(context.state);
        }
        context.charIdx++;
      }
      if (context.currentDataIdx < context.charIdx) {
        emitText(context);
      }
    }
    function stateData(context, char) {
      if (char === "<") {
        startNewTag(context);
      }
    }
    function stateTagOpen(context, char, charCode) {
      if (char === "!") {
        context.state = 13;
      } else if (char === "/") {
        context.state = 2;
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { isClosing: true }));
      } else if (char === "<") {
        startNewTag(context);
      } else if ((0, char_utils_1.isAsciiLetterChar)(charCode)) {
        context.state = 3;
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { isOpening: true }));
      } else {
        context.state = 0;
        context.currentTag = noCurrentTag;
      }
    }
    function stateTagName(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { name: captureTagName(context) }));
        context.state = 4;
      } else if (char === "<") {
        startNewTag(context);
      } else if (char === "/") {
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { name: captureTagName(context) }));
        context.state = 12;
      } else if (char === ">") {
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { name: captureTagName(context) }));
        emitTagAndPreviousTextNode(context);
      } else if (!(0, char_utils_1.isAsciiLetterChar)(charCode) && !(0, char_utils_1.isDigitChar)(charCode) && char !== ":") {
        resetToDataState(context);
      } else {
      }
    }
    function stateEndTagOpen(context, char, charCode) {
      if (char === ">") {
        resetToDataState(context);
      } else if ((0, char_utils_1.isAsciiLetterChar)(charCode)) {
        context.state = 3;
      } else {
        resetToDataState(context);
      }
    }
    function stateBeforeAttributeName(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
      } else if (char === "/") {
        context.state = 12;
      } else if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "<") {
        startNewTag(context);
      } else if (char === "=" || (0, char_utils_1.isQuoteChar)(charCode) || (0, char_utils_1.isControlChar)(charCode)) {
        resetToDataState(context);
      } else {
        context.state = 5;
      }
    }
    function stateAttributeName(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
        context.state = 6;
      } else if (char === "/") {
        context.state = 12;
      } else if (char === "=") {
        context.state = 7;
      } else if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "<") {
        startNewTag(context);
      } else if ((0, char_utils_1.isQuoteChar)(charCode)) {
        resetToDataState(context);
      } else {
      }
    }
    function stateAfterAttributeName(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
      } else if (char === "/") {
        context.state = 12;
      } else if (char === "=") {
        context.state = 7;
      } else if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "<") {
        startNewTag(context);
      } else if ((0, char_utils_1.isQuoteChar)(charCode)) {
        resetToDataState(context);
      } else {
        context.state = 5;
      }
    }
    function stateBeforeAttributeValue(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
      } else if (char === '"') {
        context.state = 8;
      } else if (char === "'") {
        context.state = 9;
      } else if (/[>=`]/.test(char)) {
        resetToDataState(context);
      } else if (char === "<") {
        startNewTag(context);
      } else {
        context.state = 10;
      }
    }
    function stateAttributeValueDoubleQuoted(context, char) {
      if (char === '"') {
        context.state = 11;
      } else {
      }
    }
    function stateAttributeValueSingleQuoted(context, char) {
      if (char === "'") {
        context.state = 11;
      } else {
      }
    }
    function stateAttributeValueUnquoted(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
        context.state = 4;
      } else if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "<") {
        startNewTag(context);
      } else {
      }
    }
    function stateAfterAttributeValueQuoted(context, char, charCode) {
      if ((0, char_utils_1.isWhitespaceChar)(charCode)) {
        context.state = 4;
      } else if (char === "/") {
        context.state = 12;
      } else if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "<") {
        startNewTag(context);
      } else {
        context.state = 4;
        reconsumeCurrentChar(context);
      }
    }
    function stateSelfClosingStartTag(context, char) {
      if (char === ">") {
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { isClosing: true }));
        emitTagAndPreviousTextNode(context);
      } else {
        resetToDataState(context);
      }
    }
    function stateMarkupDeclarationOpen(context) {
      var html2 = context.html, charIdx = context.charIdx;
      if (html2.slice(charIdx, charIdx + 2) === "--") {
        context.charIdx++;
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { type: "comment" }));
        context.state = 14;
      } else if (html2.slice(charIdx, charIdx + 7).toUpperCase() === "DOCTYPE") {
        context.charIdx += 6;
        context.currentTag = new CurrentTag(tslib_1.__assign(tslib_1.__assign({}, context.currentTag), { type: "doctype" }));
        context.state = 20;
      } else {
        resetToDataState(context);
      }
    }
    function stateCommentStart(context, char) {
      if (char === "-") {
        context.state = 15;
      } else if (char === ">") {
        resetToDataState(context);
      } else {
        context.state = 16;
      }
    }
    function stateCommentStartDash(context, char) {
      if (char === "-") {
        context.state = 18;
      } else if (char === ">") {
        resetToDataState(context);
      } else {
        context.state = 16;
      }
    }
    function stateComment(context, char) {
      if (char === "-") {
        context.state = 17;
      } else {
      }
    }
    function stateCommentEndDash(context, char) {
      if (char === "-") {
        context.state = 18;
      } else {
        context.state = 16;
      }
    }
    function stateCommentEnd(context, char) {
      if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "!") {
        context.state = 19;
      } else if (char === "-") {
      } else {
        context.state = 16;
      }
    }
    function stateCommentEndBang(context, char) {
      if (char === "-") {
        context.state = 17;
      } else if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else {
        context.state = 16;
      }
    }
    function stateDoctype(context, char) {
      if (char === ">") {
        emitTagAndPreviousTextNode(context);
      } else if (char === "<") {
        startNewTag(context);
      } else {
      }
    }
    function resetToDataState(context) {
      context.state = 0;
      context.currentTag = noCurrentTag;
    }
    function startNewTag(context) {
      context.state = 1;
      context.currentTag = new CurrentTag({ idx: context.charIdx });
    }
    function emitTagAndPreviousTextNode(context) {
      var textBeforeTag = context.html.slice(context.currentDataIdx, context.currentTag.idx);
      if (textBeforeTag) {
        context.callbacks.onText(textBeforeTag, context.currentDataIdx);
      }
      var currentTag = context.currentTag;
      if (currentTag.type === "comment") {
        context.callbacks.onComment(currentTag.idx);
      } else if (currentTag.type === "doctype") {
        context.callbacks.onDoctype(currentTag.idx);
      } else {
        if (currentTag.isOpening) {
          context.callbacks.onOpenTag(currentTag.name, currentTag.idx);
        }
        if (currentTag.isClosing) {
          context.callbacks.onCloseTag(currentTag.name, currentTag.idx);
        }
      }
      resetToDataState(context);
      context.currentDataIdx = context.charIdx + 1;
    }
    function emitText(context) {
      var text2 = context.html.slice(context.currentDataIdx, context.charIdx);
      context.callbacks.onText(text2, context.currentDataIdx);
      context.currentDataIdx = context.charIdx + 1;
    }
    function captureTagName(context) {
      var startIdx = context.currentTag.idx + (context.currentTag.isClosing ? 2 : 1);
      return context.html.slice(startIdx, context.charIdx).toLowerCase();
    }
    function reconsumeCurrentChar(context) {
      context.charIdx--;
    }
  }
});

// node_modules/autolinker/dist/commonjs/autolinker.js
var require_autolinker = __commonJS({
  "node_modules/autolinker/dist/commonjs/autolinker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var version_1 = require_version();
    var utils_1 = require_utils();
    var anchor_tag_builder_1 = require_anchor_tag_builder();
    var html_tag_1 = require_html_tag();
    var parse_matches_1 = require_parse_matches();
    var parse_html_1 = require_parse_html();
    var mention_utils_1 = require_mention_utils();
    var hashtag_utils_1 = require_hashtag_utils();
    var Autolinker3 = (
      /** @class */
      (function() {
        function Autolinker4(cfg) {
          if (cfg === void 0) {
            cfg = {};
          }
          this.version = Autolinker4.version;
          this.urls = {};
          this.email = true;
          this.phone = true;
          this.hashtag = false;
          this.mention = false;
          this.newWindow = true;
          this.stripPrefix = {
            scheme: true,
            www: true
          };
          this.stripTrailingSlash = true;
          this.decodePercentEncoding = true;
          this.truncate = {
            length: 0,
            location: "end"
          };
          this.className = "";
          this.replaceFn = null;
          this.context = void 0;
          this.sanitizeHtml = false;
          this.tagBuilder = null;
          this.urls = normalizeUrlsCfg(cfg.urls);
          this.email = (0, utils_1.isBoolean)(cfg.email) ? cfg.email : this.email;
          this.phone = (0, utils_1.isBoolean)(cfg.phone) ? cfg.phone : this.phone;
          this.hashtag = cfg.hashtag || this.hashtag;
          this.mention = cfg.mention || this.mention;
          this.newWindow = (0, utils_1.isBoolean)(cfg.newWindow) ? cfg.newWindow : this.newWindow;
          this.stripPrefix = normalizeStripPrefixCfg(cfg.stripPrefix);
          this.stripTrailingSlash = (0, utils_1.isBoolean)(cfg.stripTrailingSlash) ? cfg.stripTrailingSlash : this.stripTrailingSlash;
          this.decodePercentEncoding = (0, utils_1.isBoolean)(cfg.decodePercentEncoding) ? cfg.decodePercentEncoding : this.decodePercentEncoding;
          this.sanitizeHtml = cfg.sanitizeHtml || false;
          var mention = this.mention;
          if (mention !== false && mention_utils_1.mentionServices.indexOf(mention) === -1) {
            throw new Error("invalid `mention` cfg '".concat(mention, "' - see docs"));
          }
          var hashtag = this.hashtag;
          if (hashtag !== false && hashtag_utils_1.hashtagServices.indexOf(hashtag) === -1) {
            throw new Error("invalid `hashtag` cfg '".concat(hashtag, "' - see docs"));
          }
          this.truncate = normalizeTruncateCfg(cfg.truncate);
          this.className = cfg.className || this.className;
          this.replaceFn = cfg.replaceFn || this.replaceFn;
          this.context = cfg.context || this;
        }
        Autolinker4.link = function(textOrHtml, options) {
          var autolinker3 = new Autolinker4(options);
          return autolinker3.link(textOrHtml);
        };
        Autolinker4.parse = function(textOrHtml, options) {
          var autolinker3 = new Autolinker4(options);
          return autolinker3.parse(textOrHtml);
        };
        Autolinker4.prototype.parse = function(textOrHtml) {
          var _this = this;
          var skipTagNames = ["a", "style", "script"];
          var skipTagsStackCount = 0;
          var matches = [];
          (0, parse_html_1.parseHtml)(textOrHtml, {
            onOpenTag: function(tagName) {
              if (skipTagNames.indexOf(tagName) >= 0) {
                skipTagsStackCount++;
              }
            },
            onText: function(text2, offset) {
              if (skipTagsStackCount === 0) {
                var htmlCharacterEntitiesRegex = /(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi;
                var textSplit = text2.split(htmlCharacterEntitiesRegex);
                var currentOffset_1 = offset;
                textSplit.forEach(function(splitText, i) {
                  if (i % 2 === 0) {
                    var textNodeMatches = _this.parseText(splitText, currentOffset_1);
                    matches.push.apply(matches, tslib_1.__spreadArray([], tslib_1.__read(textNodeMatches), false));
                  }
                  currentOffset_1 += splitText.length;
                });
              }
            },
            onCloseTag: function(tagName) {
              if (skipTagNames.indexOf(tagName) >= 0) {
                skipTagsStackCount = Math.max(skipTagsStackCount - 1, 0);
              }
            },
            onComment: function() {
            },
            // no need to process comment nodes
            onDoctype: function() {
            }
            // no need to process doctype nodes
          });
          matches = this.compactMatches(matches);
          matches = this.removeUnwantedMatches(matches);
          return matches;
        };
        Autolinker4.prototype.compactMatches = function(matches) {
          matches.sort(byMatchOffset);
          var i = 0;
          while (i < matches.length - 1) {
            var match = matches[i];
            var offset = match.getOffset();
            var matchedTextLength = match.getMatchedText().length;
            if (i + 1 < matches.length) {
              if (matches[i + 1].getOffset() === offset) {
                var removeIdx = matches[i + 1].getMatchedText().length > matchedTextLength ? i : i + 1;
                matches.splice(removeIdx, 1);
                continue;
              }
            }
            i++;
          }
          return matches;
        };
        Autolinker4.prototype.removeUnwantedMatches = function(matches) {
          if (!this.hashtag)
            (0, utils_1.removeWithPredicate)(matches, function(match) {
              return match.getType() === "hashtag";
            });
          if (!this.email)
            (0, utils_1.removeWithPredicate)(matches, function(match) {
              return match.getType() === "email";
            });
          if (!this.phone)
            (0, utils_1.removeWithPredicate)(matches, function(match) {
              return match.getType() === "phone";
            });
          if (!this.mention)
            (0, utils_1.removeWithPredicate)(matches, function(match) {
              return match.getType() === "mention";
            });
          if (!this.urls.schemeMatches) {
            (0, utils_1.removeWithPredicate)(matches, function(m) {
              return m.getType() === "url" && m.getUrlMatchType() === "scheme";
            });
          }
          if (!this.urls.tldMatches) {
            (0, utils_1.removeWithPredicate)(matches, function(m) {
              return m.getType() === "url" && m.getUrlMatchType() === "tld";
            });
          }
          if (!this.urls.ipV4Matches) {
            (0, utils_1.removeWithPredicate)(matches, function(m) {
              return m.getType() === "url" && m.getUrlMatchType() === "ipV4";
            });
          }
          return matches;
        };
        Autolinker4.prototype.parseText = function(text2, offset) {
          offset = offset || 0;
          var matches = (0, parse_matches_1.parseMatches)(text2, {
            tagBuilder: this.getTagBuilder(),
            stripPrefix: this.stripPrefix,
            stripTrailingSlash: this.stripTrailingSlash,
            decodePercentEncoding: this.decodePercentEncoding,
            hashtagServiceName: this.hashtag,
            mentionServiceName: this.mention || "twitter"
          });
          for (var i = 0, numTextMatches = matches.length; i < numTextMatches; i++) {
            matches[i].setOffset(offset + matches[i].getOffset());
          }
          return matches;
        };
        Autolinker4.prototype.link = function(textOrHtml) {
          if (!textOrHtml) {
            return "";
          }
          if (this.sanitizeHtml) {
            textOrHtml = textOrHtml.replace(/</g, "&lt;").replace(/>/g, "&gt;");
          }
          var matches = this.parse(textOrHtml);
          var newHtml = new Array(matches.length * 2 + 1);
          var lastIndex = 0;
          for (var i = 0, len = matches.length; i < len; i++) {
            var match = matches[i];
            newHtml.push(textOrHtml.substring(lastIndex, match.getOffset()));
            newHtml.push(this.createMatchReturnVal(match));
            lastIndex = match.getOffset() + match.getMatchedText().length;
          }
          newHtml.push(textOrHtml.substring(lastIndex));
          return newHtml.join("");
        };
        Autolinker4.prototype.createMatchReturnVal = function(match) {
          var replaceFnResult;
          if (this.replaceFn) {
            replaceFnResult = this.replaceFn.call(this.context, match);
          }
          if (typeof replaceFnResult === "string") {
            return replaceFnResult;
          } else if (replaceFnResult === false) {
            return match.getMatchedText();
          } else if (replaceFnResult instanceof html_tag_1.HtmlTag) {
            return replaceFnResult.toAnchorString();
          } else {
            var anchorTag = match.buildTag();
            return anchorTag.toAnchorString();
          }
        };
        Autolinker4.prototype.getTagBuilder = function() {
          var tagBuilder = this.tagBuilder;
          if (!tagBuilder) {
            tagBuilder = this.tagBuilder = new anchor_tag_builder_1.AnchorTagBuilder({
              newWindow: this.newWindow,
              truncate: this.truncate,
              className: this.className
            });
          }
          return tagBuilder;
        };
        Autolinker4.version = version_1.version;
        return Autolinker4;
      })()
    );
    exports2.default = Autolinker3;
    function normalizeUrlsCfg(urls) {
      if (urls == null)
        urls = true;
      if ((0, utils_1.isBoolean)(urls)) {
        return { schemeMatches: urls, tldMatches: urls, ipV4Matches: urls };
      } else {
        return {
          schemeMatches: (0, utils_1.isBoolean)(urls.schemeMatches) ? urls.schemeMatches : true,
          tldMatches: (0, utils_1.isBoolean)(urls.tldMatches) ? urls.tldMatches : true,
          ipV4Matches: (0, utils_1.isBoolean)(urls.ipV4Matches) ? urls.ipV4Matches : true
        };
      }
    }
    function normalizeStripPrefixCfg(stripPrefix) {
      if (stripPrefix == null)
        stripPrefix = true;
      if ((0, utils_1.isBoolean)(stripPrefix)) {
        return { scheme: stripPrefix, www: stripPrefix };
      } else {
        return {
          scheme: (0, utils_1.isBoolean)(stripPrefix.scheme) ? stripPrefix.scheme : true,
          www: (0, utils_1.isBoolean)(stripPrefix.www) ? stripPrefix.www : true
        };
      }
    }
    function normalizeTruncateCfg(truncate) {
      if (typeof truncate === "number") {
        return { length: truncate, location: "end" };
      } else {
        return tslib_1.__assign({ length: Number.POSITIVE_INFINITY, location: "end" }, truncate);
      }
    }
    function byMatchOffset(a3, b) {
      return a3.getOffset() - b.getOffset();
    }
  }
});

// node_modules/autolinker/dist/commonjs/match/match.js
var require_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/autolinker/dist/commonjs/match/index.js
var require_match2 = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_match(), exports2);
    tslib_1.__exportStar(require_email_match(), exports2);
    tslib_1.__exportStar(require_hashtag_match(), exports2);
    tslib_1.__exportStar(require_abstract_match(), exports2);
    tslib_1.__exportStar(require_mention_match(), exports2);
    tslib_1.__exportStar(require_phone_match(), exports2);
    tslib_1.__exportStar(require_url_match(), exports2);
  }
});

// node_modules/autolinker/dist/commonjs/parser/index.js
var require_parser = __commonJS({
  "node_modules/autolinker/dist/commonjs/parser/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_parse_matches(), exports2);
  }
});

// node_modules/autolinker/dist/commonjs/index.js
var require_commonjs = __commonJS({
  "node_modules/autolinker/dist/commonjs/index.js"(exports2, module2) {
    "use strict";
    exports2 = module2.exports = require_autolinker().default;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Autolinker = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var autolinker_1 = tslib_1.__importDefault(require_autolinker());
    exports2.Autolinker = autolinker_1.default;
    exports2.default = autolinker_1.default;
    tslib_1.__exportStar(require_autolinker(), exports2);
    tslib_1.__exportStar(require_anchor_tag_builder(), exports2);
    tslib_1.__exportStar(require_html_tag(), exports2);
    tslib_1.__exportStar(require_match2(), exports2);
    tslib_1.__exportStar(require_parser(), exports2);
  }
});

// node_modules/protobufjs/dist/minimal/protobuf.js
var require_protobuf = __commonJS({
  "node_modules/protobufjs/dist/minimal/protobuf.js"(exports, module) {
    /*!
     * protobuf.js v8.0.0 (c) 2016, daniel wirtz
     * compiled tue, 16 dec 2025 22:00:06 utc
     * licensed under the bsd-3-clause license
     * see: https://github.com/dcodeio/protobuf.js for details
     */
    (function(undefined) {
      "use strict";
      (function prelude(modules, cache, entries2) {
        function $require(name) {
          var $module = cache[name];
          if (!$module)
            modules[name][0].call($module = cache[name] = { exports: {} }, $require, $module, $module.exports);
          return $module.exports;
        }
        var protobuf3 = $require(entries2[0]);
        protobuf3.util.global.protobuf = protobuf3;
        if (typeof define === "function" && define.amd)
          define(["long"], function(Long) {
            if (Long && Long.isLong) {
              protobuf3.util.Long = Long;
              protobuf3.configure();
            }
            return protobuf3;
          });
        if (typeof module === "object" && module && module.exports)
          module.exports = protobuf3;
      })({ 1: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = asPromise;
        function asPromise(fn, ctx) {
          var params = new Array(arguments.length - 1), offset = 0, index = 2, pending = true;
          while (index < arguments.length)
            params[offset++] = arguments[index++];
          return new Promise(function executor(resolve2, reject) {
            params[offset] = function callback(err) {
              if (pending) {
                pending = false;
                if (err)
                  reject(err);
                else {
                  var params2 = new Array(arguments.length - 1), offset2 = 0;
                  while (offset2 < params2.length)
                    params2[offset2++] = arguments[offset2];
                  resolve2.apply(null, params2);
                }
              }
            };
            try {
              fn.apply(ctx || null, params);
            } catch (err) {
              if (pending) {
                pending = false;
                reject(err);
              }
            }
          });
        }
      }, {}], 2: [function(require2, module2, exports2) {
        "use strict";
        var base64 = exports2;
        base64.length = function length2(string) {
          var p = string.length;
          if (!p)
            return 0;
          var n = 0;
          while (--p % 4 > 1 && string.charAt(p) === "=")
            ++n;
          return Math.ceil(string.length * 3) / 4 - n;
        };
        var b64 = new Array(64);
        var s64 = new Array(123);
        for (var i = 0; i < 64; )
          s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;
        base64.encode = function encode(buffer2, start, end) {
          var parts = null, chunk = [];
          var i2 = 0, j = 0, t;
          while (start < end) {
            var b = buffer2[start++];
            switch (j) {
              case 0:
                chunk[i2++] = b64[b >> 2];
                t = (b & 3) << 4;
                j = 1;
                break;
              case 1:
                chunk[i2++] = b64[t | b >> 4];
                t = (b & 15) << 2;
                j = 2;
                break;
              case 2:
                chunk[i2++] = b64[t | b >> 6];
                chunk[i2++] = b64[b & 63];
                j = 0;
                break;
            }
            if (i2 > 8191) {
              (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
              i2 = 0;
            }
          }
          if (j) {
            chunk[i2++] = b64[t];
            chunk[i2++] = 61;
            if (j === 1)
              chunk[i2++] = 61;
          }
          if (parts) {
            if (i2)
              parts.push(String.fromCharCode.apply(String, chunk.slice(0, i2)));
            return parts.join("");
          }
          return String.fromCharCode.apply(String, chunk.slice(0, i2));
        };
        var invalidEncoding = "invalid encoding";
        base64.decode = function decode(string, buffer2, offset) {
          var start = offset;
          var j = 0, t;
          for (var i2 = 0; i2 < string.length; ) {
            var c = string.charCodeAt(i2++);
            if (c === 61 && j > 1)
              break;
            if ((c = s64[c]) === undefined)
              throw Error(invalidEncoding);
            switch (j) {
              case 0:
                t = c;
                j = 1;
                break;
              case 1:
                buffer2[offset++] = t << 2 | (c & 48) >> 4;
                t = c;
                j = 2;
                break;
              case 2:
                buffer2[offset++] = (t & 15) << 4 | (c & 60) >> 2;
                t = c;
                j = 3;
                break;
              case 3:
                buffer2[offset++] = (t & 3) << 6 | c;
                j = 0;
                break;
            }
          }
          if (j === 1)
            throw Error(invalidEncoding);
          return offset - start;
        };
        base64.test = function test(string) {
          return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
        };
      }, {}], 3: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = EventEmitter;
        function EventEmitter() {
          this._listeners = {};
        }
        EventEmitter.prototype.on = function on(evt, fn, ctx) {
          (this._listeners[evt] || (this._listeners[evt] = [])).push({
            fn,
            ctx: ctx || this
          });
          return this;
        };
        EventEmitter.prototype.off = function off(evt, fn) {
          if (evt === undefined)
            this._listeners = {};
          else {
            if (fn === undefined)
              this._listeners[evt] = [];
            else {
              var listeners = this._listeners[evt];
              for (var i = 0; i < listeners.length; )
                if (listeners[i].fn === fn)
                  listeners.splice(i, 1);
                else
                  ++i;
            }
          }
          return this;
        };
        EventEmitter.prototype.emit = function emit(evt) {
          var listeners = this._listeners[evt];
          if (listeners) {
            var args = [], i = 1;
            for (; i < arguments.length; )
              args.push(arguments[i++]);
            for (i = 0; i < listeners.length; )
              listeners[i].fn.apply(listeners[i++].ctx, args);
          }
          return this;
        };
      }, {}], 4: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = factory(factory);
        function factory(exports3) {
          if (typeof Float32Array !== "undefined") (function() {
            var f32 = new Float32Array([-0]), f8b = new Uint8Array(f32.buffer), le = f8b[3] === 128;
            function writeFloat_f32_cpy(val, buf, pos) {
              f32[0] = val;
              buf[pos] = f8b[0];
              buf[pos + 1] = f8b[1];
              buf[pos + 2] = f8b[2];
              buf[pos + 3] = f8b[3];
            }
            function writeFloat_f32_rev(val, buf, pos) {
              f32[0] = val;
              buf[pos] = f8b[3];
              buf[pos + 1] = f8b[2];
              buf[pos + 2] = f8b[1];
              buf[pos + 3] = f8b[0];
            }
            exports3.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
            exports3.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;
            function readFloat_f32_cpy(buf, pos) {
              f8b[0] = buf[pos];
              f8b[1] = buf[pos + 1];
              f8b[2] = buf[pos + 2];
              f8b[3] = buf[pos + 3];
              return f32[0];
            }
            function readFloat_f32_rev(buf, pos) {
              f8b[3] = buf[pos];
              f8b[2] = buf[pos + 1];
              f8b[1] = buf[pos + 2];
              f8b[0] = buf[pos + 3];
              return f32[0];
            }
            exports3.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
            exports3.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;
          })();
          else (function() {
            function writeFloat_ieee754(writeUint, val, buf, pos) {
              var sign3 = val < 0 ? 1 : 0;
              if (sign3)
                val = -val;
              if (val === 0)
                writeUint(1 / val > 0 ? (
                  /* positive */
                  0
                ) : (
                  /* negative 0 */
                  2147483648
                ), buf, pos);
              else if (isNaN(val))
                writeUint(2143289344, buf, pos);
              else if (val > 34028234663852886e22)
                writeUint((sign3 << 31 | 2139095040) >>> 0, buf, pos);
              else if (val < 11754943508222875e-54)
                writeUint((sign3 << 31 | Math.round(val / 1401298464324817e-60)) >>> 0, buf, pos);
              else {
                var exponent = Math.floor(Math.log(val) / Math.LN2), mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
                writeUint((sign3 << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
              }
            }
            exports3.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
            exports3.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);
            function readFloat_ieee754(readUint, buf, pos) {
              var uint = readUint(buf, pos), sign3 = (uint >> 31) * 2 + 1, exponent = uint >>> 23 & 255, mantissa = uint & 8388607;
              return exponent === 255 ? mantissa ? NaN : sign3 * Infinity : exponent === 0 ? sign3 * 1401298464324817e-60 * mantissa : sign3 * Math.pow(2, exponent - 150) * (mantissa + 8388608);
            }
            exports3.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
            exports3.readFloatBE = readFloat_ieee754.bind(null, readUintBE);
          })();
          if (typeof Float64Array !== "undefined") (function() {
            var f64 = new Float64Array([-0]), f8b = new Uint8Array(f64.buffer), le = f8b[7] === 128;
            function writeDouble_f64_cpy(val, buf, pos) {
              f64[0] = val;
              buf[pos] = f8b[0];
              buf[pos + 1] = f8b[1];
              buf[pos + 2] = f8b[2];
              buf[pos + 3] = f8b[3];
              buf[pos + 4] = f8b[4];
              buf[pos + 5] = f8b[5];
              buf[pos + 6] = f8b[6];
              buf[pos + 7] = f8b[7];
            }
            function writeDouble_f64_rev(val, buf, pos) {
              f64[0] = val;
              buf[pos] = f8b[7];
              buf[pos + 1] = f8b[6];
              buf[pos + 2] = f8b[5];
              buf[pos + 3] = f8b[4];
              buf[pos + 4] = f8b[3];
              buf[pos + 5] = f8b[2];
              buf[pos + 6] = f8b[1];
              buf[pos + 7] = f8b[0];
            }
            exports3.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
            exports3.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;
            function readDouble_f64_cpy(buf, pos) {
              f8b[0] = buf[pos];
              f8b[1] = buf[pos + 1];
              f8b[2] = buf[pos + 2];
              f8b[3] = buf[pos + 3];
              f8b[4] = buf[pos + 4];
              f8b[5] = buf[pos + 5];
              f8b[6] = buf[pos + 6];
              f8b[7] = buf[pos + 7];
              return f64[0];
            }
            function readDouble_f64_rev(buf, pos) {
              f8b[7] = buf[pos];
              f8b[6] = buf[pos + 1];
              f8b[5] = buf[pos + 2];
              f8b[4] = buf[pos + 3];
              f8b[3] = buf[pos + 4];
              f8b[2] = buf[pos + 5];
              f8b[1] = buf[pos + 6];
              f8b[0] = buf[pos + 7];
              return f64[0];
            }
            exports3.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
            exports3.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;
          })();
          else (function() {
            function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
              var sign3 = val < 0 ? 1 : 0;
              if (sign3)
                val = -val;
              if (val === 0) {
                writeUint(0, buf, pos + off0);
                writeUint(1 / val > 0 ? (
                  /* positive */
                  0
                ) : (
                  /* negative 0 */
                  2147483648
                ), buf, pos + off1);
              } else if (isNaN(val)) {
                writeUint(0, buf, pos + off0);
                writeUint(2146959360, buf, pos + off1);
              } else if (val > 17976931348623157e292) {
                writeUint(0, buf, pos + off0);
                writeUint((sign3 << 31 | 2146435072) >>> 0, buf, pos + off1);
              } else {
                var mantissa;
                if (val < 22250738585072014e-324) {
                  mantissa = val / 5e-324;
                  writeUint(mantissa >>> 0, buf, pos + off0);
                  writeUint((sign3 << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
                } else {
                  var exponent = Math.floor(Math.log(val) / Math.LN2);
                  if (exponent === 1024)
                    exponent = 1023;
                  mantissa = val * Math.pow(2, -exponent);
                  writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
                  writeUint((sign3 << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
                }
              }
            }
            exports3.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
            exports3.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);
            function readDouble_ieee754(readUint, off0, off1, buf, pos) {
              var lo = readUint(buf, pos + off0), hi = readUint(buf, pos + off1);
              var sign3 = (hi >> 31) * 2 + 1, exponent = hi >>> 20 & 2047, mantissa = 4294967296 * (hi & 1048575) + lo;
              return exponent === 2047 ? mantissa ? NaN : sign3 * Infinity : exponent === 0 ? sign3 * 5e-324 * mantissa : sign3 * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
            }
            exports3.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
            exports3.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);
          })();
          return exports3;
        }
        function writeUintLE(val, buf, pos) {
          buf[pos] = val & 255;
          buf[pos + 1] = val >>> 8 & 255;
          buf[pos + 2] = val >>> 16 & 255;
          buf[pos + 3] = val >>> 24;
        }
        function writeUintBE(val, buf, pos) {
          buf[pos] = val >>> 24;
          buf[pos + 1] = val >>> 16 & 255;
          buf[pos + 2] = val >>> 8 & 255;
          buf[pos + 3] = val & 255;
        }
        function readUintLE(buf, pos) {
          return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16 | buf[pos + 3] << 24) >>> 0;
        }
        function readUintBE(buf, pos) {
          return (buf[pos] << 24 | buf[pos + 1] << 16 | buf[pos + 2] << 8 | buf[pos + 3]) >>> 0;
        }
      }, {}], 5: [function(require, module, exports) {
        "use strict";
        module.exports = inquire;
        function inquire(moduleName) {
          try {
            var mod = eval("quire".replace(/^/, "re"))(moduleName);
            if (mod && (mod.length || Object.keys(mod).length))
              return mod;
          } catch (e) {
          }
          return null;
        }
      }, {}], 6: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = pool2;
        function pool2(alloc, slice, size) {
          var SIZE = size || 8192;
          var MAX = SIZE >>> 1;
          var slab = null;
          var offset = SIZE;
          return function pool_alloc(size2) {
            if (size2 < 1 || size2 > MAX)
              return alloc(size2);
            if (offset + size2 > SIZE) {
              slab = alloc(SIZE);
              offset = 0;
            }
            var buf = slice.call(slab, offset, offset += size2);
            if (offset & 7)
              offset = (offset | 7) + 1;
            return buf;
          };
        }
      }, {}], 7: [function(require2, module2, exports2) {
        "use strict";
        var utf8 = exports2;
        utf8.length = function utf8_length(string) {
          var len = 0, c = 0;
          for (var i = 0; i < string.length; ++i) {
            c = string.charCodeAt(i);
            if (c < 128)
              len += 1;
            else if (c < 2048)
              len += 2;
            else if ((c & 64512) === 55296 && (string.charCodeAt(i + 1) & 64512) === 56320) {
              ++i;
              len += 4;
            } else
              len += 3;
          }
          return len;
        };
        utf8.read = function utf8_read(buffer2, start, end) {
          var len = end - start;
          if (len < 1)
            return "";
          var parts = null, chunk = [], i = 0, t;
          while (start < end) {
            t = buffer2[start++];
            if (t < 128)
              chunk[i++] = t;
            else if (t > 191 && t < 224)
              chunk[i++] = (t & 31) << 6 | buffer2[start++] & 63;
            else if (t > 239 && t < 365) {
              t = ((t & 7) << 18 | (buffer2[start++] & 63) << 12 | (buffer2[start++] & 63) << 6 | buffer2[start++] & 63) - 65536;
              chunk[i++] = 55296 + (t >> 10);
              chunk[i++] = 56320 + (t & 1023);
            } else
              chunk[i++] = (t & 15) << 12 | (buffer2[start++] & 63) << 6 | buffer2[start++] & 63;
            if (i > 8191) {
              (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
              i = 0;
            }
          }
          if (parts) {
            if (i)
              parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
            return parts.join("");
          }
          return String.fromCharCode.apply(String, chunk.slice(0, i));
        };
        utf8.write = function utf8_write(string, buffer2, offset) {
          var start = offset, c14, c22;
          for (var i = 0; i < string.length; ++i) {
            c14 = string.charCodeAt(i);
            if (c14 < 128) {
              buffer2[offset++] = c14;
            } else if (c14 < 2048) {
              buffer2[offset++] = c14 >> 6 | 192;
              buffer2[offset++] = c14 & 63 | 128;
            } else if ((c14 & 64512) === 55296 && ((c22 = string.charCodeAt(i + 1)) & 64512) === 56320) {
              c14 = 65536 + ((c14 & 1023) << 10) + (c22 & 1023);
              ++i;
              buffer2[offset++] = c14 >> 18 | 240;
              buffer2[offset++] = c14 >> 12 & 63 | 128;
              buffer2[offset++] = c14 >> 6 & 63 | 128;
              buffer2[offset++] = c14 & 63 | 128;
            } else {
              buffer2[offset++] = c14 >> 12 | 224;
              buffer2[offset++] = c14 >> 6 & 63 | 128;
              buffer2[offset++] = c14 & 63 | 128;
            }
          }
          return offset - start;
        };
      }, {}], 8: [function(require2, module2, exports2) {
        "use strict";
        var protobuf3 = exports2;
        protobuf3.build = "minimal";
        protobuf3.Writer = require2(16);
        protobuf3.BufferWriter = require2(17);
        protobuf3.Reader = require2(9);
        protobuf3.BufferReader = require2(10);
        protobuf3.util = require2(15);
        protobuf3.rpc = require2(12);
        protobuf3.roots = require2(11);
        protobuf3.configure = configure2;
        function configure2() {
          protobuf3.util._configure();
          protobuf3.Writer._configure(protobuf3.BufferWriter);
          protobuf3.Reader._configure(protobuf3.BufferReader);
        }
        configure2();
      }, { "10": 10, "11": 11, "12": 12, "15": 15, "16": 16, "17": 17, "9": 9 }], 9: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Reader3;
        var util = require2(15);
        var BufferReader;
        var LongBits = util.LongBits, utf8 = util.utf8;
        function indexOutOfRange(reader, writeLength) {
          return RangeError("index out of range: " + reader.pos + " + " + (writeLength || 1) + " > " + reader.len);
        }
        function Reader3(buffer2) {
          this.buf = buffer2;
          this.pos = 0;
          this.len = buffer2.length;
        }
        var create_array = typeof Uint8Array !== "undefined" ? function create_typed_array(buffer2) {
          if (buffer2 instanceof Uint8Array || Array.isArray(buffer2))
            return new Reader3(buffer2);
          throw Error("illegal buffer");
        } : function create_array2(buffer2) {
          if (Array.isArray(buffer2))
            return new Reader3(buffer2);
          throw Error("illegal buffer");
        };
        var create2 = function create3() {
          return util.Buffer ? function create_buffer_setup(buffer2) {
            return (Reader3.create = function create_buffer(buffer3) {
              return util.Buffer.isBuffer(buffer3) ? new BufferReader(buffer3) : create_array(buffer3);
            })(buffer2);
          } : create_array;
        };
        Reader3.create = create2();
        Reader3.prototype._slice = util.Array.prototype.subarray || /* istanbul ignore next */
        util.Array.prototype.slice;
        Reader3.prototype.uint32 = /* @__PURE__ */ (function read_uint32_setup() {
          var value = 4294967295;
          return function read_uint32() {
            value = (this.buf[this.pos] & 127) >>> 0;
            if (this.buf[this.pos++] < 128) return value;
            value = (value | (this.buf[this.pos] & 127) << 7) >>> 0;
            if (this.buf[this.pos++] < 128) return value;
            value = (value | (this.buf[this.pos] & 127) << 14) >>> 0;
            if (this.buf[this.pos++] < 128) return value;
            value = (value | (this.buf[this.pos] & 127) << 21) >>> 0;
            if (this.buf[this.pos++] < 128) return value;
            value = (value | (this.buf[this.pos] & 15) << 28) >>> 0;
            if (this.buf[this.pos++] < 128) return value;
            if ((this.pos += 5) > this.len) {
              this.pos = this.len;
              throw indexOutOfRange(this, 10);
            }
            return value;
          };
        })();
        Reader3.prototype.int32 = function read_int32() {
          return this.uint32() | 0;
        };
        Reader3.prototype.sint32 = function read_sint32() {
          var value = this.uint32();
          return value >>> 1 ^ -(value & 1) | 0;
        };
        function readLongVarint() {
          var bits = new LongBits(0, 0);
          var i = 0;
          if (this.len - this.pos > 4) {
            for (; i < 4; ++i) {
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << 28) >>> 0;
            bits.hi = (bits.hi | (this.buf[this.pos] & 127) >> 4) >>> 0;
            if (this.buf[this.pos++] < 128)
              return bits;
            i = 0;
          } else {
            for (; i < 3; ++i) {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
            bits.lo = (bits.lo | (this.buf[this.pos++] & 127) << i * 7) >>> 0;
            return bits;
          }
          if (this.len - this.pos > 4) {
            for (; i < 5; ++i) {
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
          } else {
            for (; i < 5; ++i) {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
          }
          throw Error("invalid varint encoding");
        }
        Reader3.prototype.bool = function read_bool() {
          return this.uint32() !== 0;
        };
        function readFixed32_end(buf, end) {
          return (buf[end - 4] | buf[end - 3] << 8 | buf[end - 2] << 16 | buf[end - 1] << 24) >>> 0;
        }
        Reader3.prototype.fixed32 = function read_fixed32() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          return readFixed32_end(this.buf, this.pos += 4);
        };
        Reader3.prototype.sfixed32 = function read_sfixed32() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          return readFixed32_end(this.buf, this.pos += 4) | 0;
        };
        function readFixed64() {
          if (this.pos + 8 > this.len)
            throw indexOutOfRange(this, 8);
          return new LongBits(readFixed32_end(this.buf, this.pos += 4), readFixed32_end(this.buf, this.pos += 4));
        }
        Reader3.prototype.float = function read_float() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          var value = util.float.readFloatLE(this.buf, this.pos);
          this.pos += 4;
          return value;
        };
        Reader3.prototype.double = function read_double() {
          if (this.pos + 8 > this.len)
            throw indexOutOfRange(this, 4);
          var value = util.float.readDoubleLE(this.buf, this.pos);
          this.pos += 8;
          return value;
        };
        Reader3.prototype.bytes = function read_bytes() {
          var length2 = this.uint32(), start = this.pos, end = this.pos + length2;
          if (end > this.len)
            throw indexOutOfRange(this, length2);
          this.pos += length2;
          if (Array.isArray(this.buf))
            return this.buf.slice(start, end);
          if (start === end) {
            var nativeBuffer = util.Buffer;
            return nativeBuffer ? nativeBuffer.alloc(0) : new this.buf.constructor(0);
          }
          return this._slice.call(this.buf, start, end);
        };
        Reader3.prototype.string = function read_string() {
          var bytes = this.bytes();
          return utf8.read(bytes, 0, bytes.length);
        };
        Reader3.prototype.skip = function skip(length2) {
          if (typeof length2 === "number") {
            if (this.pos + length2 > this.len)
              throw indexOutOfRange(this, length2);
            this.pos += length2;
          } else {
            do {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
            } while (this.buf[this.pos++] & 128);
          }
          return this;
        };
        Reader3.prototype.skipType = function(wireType) {
          switch (wireType) {
            case 0:
              this.skip();
              break;
            case 1:
              this.skip(8);
              break;
            case 2:
              this.skip(this.uint32());
              break;
            case 3:
              while ((wireType = this.uint32() & 7) !== 4) {
                this.skipType(wireType);
              }
              break;
            case 5:
              this.skip(4);
              break;
            /* istanbul ignore next */
            default:
              throw Error("invalid wire type " + wireType + " at offset " + this.pos);
          }
          return this;
        };
        Reader3._configure = function(BufferReader_) {
          BufferReader = BufferReader_;
          Reader3.create = create2();
          BufferReader._configure();
          var fn = util.Long ? "toLong" : (
            /* istanbul ignore next */
            "toNumber"
          );
          util.merge(Reader3.prototype, {
            int64: function read_int64() {
              return readLongVarint.call(this)[fn](false);
            },
            uint64: function read_uint64() {
              return readLongVarint.call(this)[fn](true);
            },
            sint64: function read_sint64() {
              return readLongVarint.call(this).zzDecode()[fn](false);
            },
            fixed64: function read_fixed64() {
              return readFixed64.call(this)[fn](true);
            },
            sfixed64: function read_sfixed64() {
              return readFixed64.call(this)[fn](false);
            }
          });
        };
      }, { "15": 15 }], 10: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = BufferReader;
        var Reader3 = require2(9);
        (BufferReader.prototype = Object.create(Reader3.prototype)).constructor = BufferReader;
        var util = require2(15);
        function BufferReader(buffer2) {
          Reader3.call(this, buffer2);
        }
        BufferReader._configure = function() {
          if (util.Buffer)
            BufferReader.prototype._slice = util.Buffer.prototype.slice;
        };
        BufferReader.prototype.string = function read_string_buffer() {
          var len = this.uint32();
          return this.buf.utf8Slice ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + len, this.len)) : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + len, this.len));
        };
        BufferReader._configure();
      }, { "15": 15, "9": 9 }], 11: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = {};
      }, {}], 12: [function(require2, module2, exports2) {
        "use strict";
        var rpc = exports2;
        rpc.Service = require2(13);
      }, { "13": 13 }], 13: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Service;
        var util = require2(15);
        (Service.prototype = Object.create(util.EventEmitter.prototype)).constructor = Service;
        function Service(rpcImpl, requestDelimited, responseDelimited) {
          if (typeof rpcImpl !== "function")
            throw TypeError("rpcImpl must be a function");
          util.EventEmitter.call(this);
          this.rpcImpl = rpcImpl;
          this.requestDelimited = Boolean(requestDelimited);
          this.responseDelimited = Boolean(responseDelimited);
        }
        Service.prototype.rpcCall = function rpcCall(method, requestCtor, responseCtor, request, callback) {
          if (!request)
            throw TypeError("request must be specified");
          var self2 = this;
          if (!callback)
            return util.asPromise(rpcCall, self2, method, requestCtor, responseCtor, request);
          if (!self2.rpcImpl) {
            setTimeout(function() {
              callback(Error("already ended"));
            }, 0);
            return undefined;
          }
          try {
            return self2.rpcImpl(
              method,
              requestCtor[self2.requestDelimited ? "encodeDelimited" : "encode"](request).finish(),
              function rpcCallback(err, response) {
                if (err) {
                  self2.emit("error", err, method);
                  return callback(err);
                }
                if (response === null) {
                  self2.end(
                    /* endedByRPC */
                    true
                  );
                  return undefined;
                }
                if (!(response instanceof responseCtor)) {
                  try {
                    response = responseCtor[self2.responseDelimited ? "decodeDelimited" : "decode"](response);
                  } catch (err2) {
                    self2.emit("error", err2, method);
                    return callback(err2);
                  }
                }
                self2.emit("data", response, method);
                return callback(null, response);
              }
            );
          } catch (err) {
            self2.emit("error", err, method);
            setTimeout(function() {
              callback(err);
            }, 0);
            return undefined;
          }
        };
        Service.prototype.end = function end(endedByRPC) {
          if (this.rpcImpl) {
            if (!endedByRPC)
              this.rpcImpl(null, null, null);
            this.rpcImpl = null;
            this.emit("end").off();
          }
          return this;
        };
      }, { "15": 15 }], 14: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = LongBits;
        var util = require2(15);
        function LongBits(lo, hi) {
          this.lo = lo >>> 0;
          this.hi = hi >>> 0;
        }
        var zero = LongBits.zero = new LongBits(0, 0);
        zero.toNumber = function() {
          return 0;
        };
        zero.zzEncode = zero.zzDecode = function() {
          return this;
        };
        zero.length = function() {
          return 1;
        };
        var zeroHash = LongBits.zeroHash = "\0\0\0\0\0\0\0\0";
        LongBits.fromNumber = function fromNumber(value) {
          if (value === 0)
            return zero;
          var sign3 = value < 0;
          if (sign3)
            value = -value;
          var lo = value >>> 0, hi = (value - lo) / 4294967296 >>> 0;
          if (sign3) {
            hi = ~hi >>> 0;
            lo = ~lo >>> 0;
            if (++lo > 4294967295) {
              lo = 0;
              if (++hi > 4294967295)
                hi = 0;
            }
          }
          return new LongBits(lo, hi);
        };
        LongBits.from = function from(value) {
          if (typeof value === "number")
            return LongBits.fromNumber(value);
          if (util.isString(value)) {
            if (util.Long)
              value = util.Long.fromString(value);
            else
              return LongBits.fromNumber(parseInt(value, 10));
          }
          return value.low || value.high ? new LongBits(value.low >>> 0, value.high >>> 0) : zero;
        };
        LongBits.prototype.toNumber = function toNumber(unsigned) {
          if (!unsigned && this.hi >>> 31) {
            var lo = ~this.lo + 1 >>> 0, hi = ~this.hi >>> 0;
            if (!lo)
              hi = hi + 1 >>> 0;
            return -(lo + hi * 4294967296);
          }
          return this.lo + this.hi * 4294967296;
        };
        LongBits.prototype.toLong = function toLong(unsigned) {
          return util.Long ? new util.Long(this.lo | 0, this.hi | 0, Boolean(unsigned)) : { low: this.lo | 0, high: this.hi | 0, unsigned: Boolean(unsigned) };
        };
        var charCodeAt = String.prototype.charCodeAt;
        LongBits.fromHash = function fromHash(hash2) {
          if (hash2 === zeroHash)
            return zero;
          return new LongBits(
            (charCodeAt.call(hash2, 0) | charCodeAt.call(hash2, 1) << 8 | charCodeAt.call(hash2, 2) << 16 | charCodeAt.call(hash2, 3) << 24) >>> 0,
            (charCodeAt.call(hash2, 4) | charCodeAt.call(hash2, 5) << 8 | charCodeAt.call(hash2, 6) << 16 | charCodeAt.call(hash2, 7) << 24) >>> 0
          );
        };
        LongBits.prototype.toHash = function toHash() {
          return String.fromCharCode(
            this.lo & 255,
            this.lo >>> 8 & 255,
            this.lo >>> 16 & 255,
            this.lo >>> 24,
            this.hi & 255,
            this.hi >>> 8 & 255,
            this.hi >>> 16 & 255,
            this.hi >>> 24
          );
        };
        LongBits.prototype.zzEncode = function zzEncode() {
          var mask = this.hi >> 31;
          this.hi = ((this.hi << 1 | this.lo >>> 31) ^ mask) >>> 0;
          this.lo = (this.lo << 1 ^ mask) >>> 0;
          return this;
        };
        LongBits.prototype.zzDecode = function zzDecode() {
          var mask = -(this.lo & 1);
          this.lo = ((this.lo >>> 1 | this.hi << 31) ^ mask) >>> 0;
          this.hi = (this.hi >>> 1 ^ mask) >>> 0;
          return this;
        };
        LongBits.prototype.length = function length2() {
          var part0 = this.lo, part1 = (this.lo >>> 28 | this.hi << 4) >>> 0, part2 = this.hi >>> 24;
          return part2 === 0 ? part1 === 0 ? part0 < 16384 ? part0 < 128 ? 1 : 2 : part0 < 2097152 ? 3 : 4 : part1 < 16384 ? part1 < 128 ? 5 : 6 : part1 < 2097152 ? 7 : 8 : part2 < 128 ? 9 : 10;
        };
      }, { "15": 15 }], 15: [function(require2, module2, exports2) {
        "use strict";
        var util = exports2;
        util.asPromise = require2(1);
        util.base64 = require2(2);
        util.EventEmitter = require2(3);
        util.float = require2(4);
        util.inquire = require2(5);
        util.utf8 = require2(7);
        util.pool = require2(6);
        util.LongBits = require2(14);
        util.isNode = Boolean(typeof global !== "undefined" && global && global.process && global.process.versions && global.process.versions.node);
        util.global = util.isNode && global || typeof window !== "undefined" && window || typeof self !== "undefined" && self || this;
        util.emptyArray = Object.freeze ? Object.freeze([]) : (
          /* istanbul ignore next */
          []
        );
        util.emptyObject = Object.freeze ? Object.freeze({}) : (
          /* istanbul ignore next */
          {}
        );
        util.isInteger = Number.isInteger || /* istanbul ignore next */
        function isInteger(value) {
          return typeof value === "number" && isFinite(value) && Math.floor(value) === value;
        };
        util.isString = function isString(value) {
          return typeof value === "string" || value instanceof String;
        };
        util.isObject = function isObject(value) {
          return value && typeof value === "object";
        };
        util.isset = /**
         * Checks if a property on a message is considered to be present.
         * @param {Object} obj Plain object or message instance
         * @param {string} prop Property name
         * @returns {boolean} `true` if considered to be present, otherwise `false`
         */
        util.isSet = function isSet(obj, prop) {
          var value = obj[prop];
          if (value != null && obj.hasOwnProperty(prop))
            return typeof value !== "object" || (Array.isArray(value) ? value.length : Object.keys(value).length) > 0;
          return false;
        };
        util.Buffer = (function() {
          try {
            var Buffer3 = util.inquire("buffer").Buffer;
            return Buffer3.prototype.utf8Write ? Buffer3 : (
              /* istanbul ignore next */
              null
            );
          } catch (e) {
            return null;
          }
        })();
        util._Buffer_from = null;
        util._Buffer_allocUnsafe = null;
        util.newBuffer = function newBuffer(sizeOrArray) {
          return typeof sizeOrArray === "number" ? util.Buffer ? util._Buffer_allocUnsafe(sizeOrArray) : new util.Array(sizeOrArray) : util.Buffer ? util._Buffer_from(sizeOrArray) : typeof Uint8Array === "undefined" ? sizeOrArray : new Uint8Array(sizeOrArray);
        };
        util.Array = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
        util.Long = /* istanbul ignore next */
        util.global.dcodeIO && /* istanbul ignore next */
        util.global.dcodeIO.Long || /* istanbul ignore next */
        util.global.Long || util.inquire("long");
        util.key2Re = /^true|false|0|1$/;
        util.key32Re = /^-?(?:0|[1-9][0-9]*)$/;
        util.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;
        util.longToHash = function longToHash(value) {
          return value ? util.LongBits.from(value).toHash() : util.LongBits.zeroHash;
        };
        util.longFromHash = function longFromHash(hash2, unsigned) {
          var bits = util.LongBits.fromHash(hash2);
          if (util.Long)
            return util.Long.fromBits(bits.lo, bits.hi, unsigned);
          return bits.toNumber(Boolean(unsigned));
        };
        function merge2(dst, src, ifNotSet) {
          for (var keys = Object.keys(src), i = 0; i < keys.length; ++i)
            if (dst[keys[i]] === undefined || !ifNotSet)
              dst[keys[i]] = src[keys[i]];
          return dst;
        }
        util.merge = merge2;
        util.lcFirst = function lcFirst(str) {
          return str.charAt(0).toLowerCase() + str.substring(1);
        };
        function newError(name) {
          function CustomError(message, properties) {
            if (!(this instanceof CustomError))
              return new CustomError(message, properties);
            Object.defineProperty(this, "message", { get: function() {
              return message;
            } });
            if (Error.captureStackTrace)
              Error.captureStackTrace(this, CustomError);
            else
              Object.defineProperty(this, "stack", { value: new Error().stack || "" });
            if (properties)
              merge2(this, properties);
          }
          CustomError.prototype = Object.create(Error.prototype, {
            constructor: {
              value: CustomError,
              writable: true,
              enumerable: false,
              configurable: true
            },
            name: {
              get: function get2() {
                return name;
              },
              set: undefined,
              enumerable: false,
              // configurable: false would accurately preserve the behavior of
              // the original, but I'm guessing that was not intentional.
              // For an actual error subclass, this property would
              // be configurable.
              configurable: true
            },
            toString: {
              value: function value() {
                return this.name + ": " + this.message;
              },
              writable: true,
              enumerable: false,
              configurable: true
            }
          });
          return CustomError;
        }
        util.newError = newError;
        util.ProtocolError = newError("ProtocolError");
        util.oneOfGetter = function getOneOf(fieldNames) {
          var fieldMap = {};
          for (var i = 0; i < fieldNames.length; ++i)
            fieldMap[fieldNames[i]] = 1;
          return function() {
            for (var keys = Object.keys(this), i2 = keys.length - 1; i2 > -1; --i2)
              if (fieldMap[keys[i2]] === 1 && this[keys[i2]] !== undefined && this[keys[i2]] !== null)
                return keys[i2];
          };
        };
        util.oneOfSetter = function setOneOf(fieldNames) {
          return function(name) {
            for (var i = 0; i < fieldNames.length; ++i)
              if (fieldNames[i] !== name)
                delete this[fieldNames[i]];
          };
        };
        util.toJSONOptions = {
          longs: String,
          enums: String,
          bytes: String,
          json: true
        };
        util._configure = function() {
          var Buffer3 = util.Buffer;
          if (!Buffer3) {
            util._Buffer_from = util._Buffer_allocUnsafe = null;
            return;
          }
          util._Buffer_from = Buffer3.from !== Uint8Array.from && Buffer3.from || /* istanbul ignore next */
          function Buffer_from(value, encoding) {
            return new Buffer3(value, encoding);
          };
          util._Buffer_allocUnsafe = Buffer3.allocUnsafe || /* istanbul ignore next */
          function Buffer_allocUnsafe(size) {
            return new Buffer3(size);
          };
        };
      }, { "1": 1, "14": 14, "2": 2, "3": 3, "4": 4, "5": 5, "6": 6, "7": 7 }], 16: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Writer2;
        var util = require2(15);
        var BufferWriter;
        var LongBits = util.LongBits, base64 = util.base64, utf8 = util.utf8;
        function Op(fn, len, val) {
          this.fn = fn;
          this.len = len;
          this.next = undefined;
          this.val = val;
        }
        function noop() {
        }
        function State(writer) {
          this.head = writer.head;
          this.tail = writer.tail;
          this.len = writer.len;
          this.next = writer.states;
        }
        function Writer2() {
          this.len = 0;
          this.head = new Op(noop, 0, 0);
          this.tail = this.head;
          this.states = null;
        }
        var create2 = function create3() {
          return util.Buffer ? function create_buffer_setup() {
            return (Writer2.create = function create_buffer() {
              return new BufferWriter();
            })();
          } : function create_array() {
            return new Writer2();
          };
        };
        Writer2.create = create2();
        Writer2.alloc = function alloc(size) {
          return new util.Array(size);
        };
        if (util.Array !== Array)
          Writer2.alloc = util.pool(Writer2.alloc, util.Array.prototype.subarray);
        Writer2.prototype._push = function push(fn, len, val) {
          this.tail = this.tail.next = new Op(fn, len, val);
          this.len += len;
          return this;
        };
        function writeByte(val, buf, pos) {
          buf[pos] = val & 255;
        }
        function writeVarint32(val, buf, pos) {
          while (val > 127) {
            buf[pos++] = val & 127 | 128;
            val >>>= 7;
          }
          buf[pos] = val;
        }
        function VarintOp(len, val) {
          this.len = len;
          this.next = undefined;
          this.val = val;
        }
        VarintOp.prototype = Object.create(Op.prototype);
        VarintOp.prototype.fn = writeVarint32;
        Writer2.prototype.uint32 = function write_uint32(value) {
          this.len += (this.tail = this.tail.next = new VarintOp(
            (value = value >>> 0) < 128 ? 1 : value < 16384 ? 2 : value < 2097152 ? 3 : value < 268435456 ? 4 : 5,
            value
          )).len;
          return this;
        };
        Writer2.prototype.int32 = function write_int32(value) {
          return value < 0 ? this._push(writeVarint64, 10, LongBits.fromNumber(value)) : this.uint32(value);
        };
        Writer2.prototype.sint32 = function write_sint32(value) {
          return this.uint32((value << 1 ^ value >> 31) >>> 0);
        };
        function writeVarint64(val, buf, pos) {
          while (val.hi) {
            buf[pos++] = val.lo & 127 | 128;
            val.lo = (val.lo >>> 7 | val.hi << 25) >>> 0;
            val.hi >>>= 7;
          }
          while (val.lo > 127) {
            buf[pos++] = val.lo & 127 | 128;
            val.lo = val.lo >>> 7;
          }
          buf[pos++] = val.lo;
        }
        Writer2.prototype.uint64 = function write_uint64(value) {
          var bits = LongBits.from(value);
          return this._push(writeVarint64, bits.length(), bits);
        };
        Writer2.prototype.int64 = Writer2.prototype.uint64;
        Writer2.prototype.sint64 = function write_sint64(value) {
          var bits = LongBits.from(value).zzEncode();
          return this._push(writeVarint64, bits.length(), bits);
        };
        Writer2.prototype.bool = function write_bool(value) {
          return this._push(writeByte, 1, value ? 1 : 0);
        };
        function writeFixed32(val, buf, pos) {
          buf[pos] = val & 255;
          buf[pos + 1] = val >>> 8 & 255;
          buf[pos + 2] = val >>> 16 & 255;
          buf[pos + 3] = val >>> 24;
        }
        Writer2.prototype.fixed32 = function write_fixed32(value) {
          return this._push(writeFixed32, 4, value >>> 0);
        };
        Writer2.prototype.sfixed32 = Writer2.prototype.fixed32;
        Writer2.prototype.fixed64 = function write_fixed64(value) {
          var bits = LongBits.from(value);
          return this._push(writeFixed32, 4, bits.lo)._push(writeFixed32, 4, bits.hi);
        };
        Writer2.prototype.sfixed64 = Writer2.prototype.fixed64;
        Writer2.prototype.float = function write_float(value) {
          return this._push(util.float.writeFloatLE, 4, value);
        };
        Writer2.prototype.double = function write_double(value) {
          return this._push(util.float.writeDoubleLE, 8, value);
        };
        var writeBytes = util.Array.prototype.set ? function writeBytes_set(val, buf, pos) {
          buf.set(val, pos);
        } : function writeBytes_for(val, buf, pos) {
          for (var i = 0; i < val.length; ++i)
            buf[pos + i] = val[i];
        };
        Writer2.prototype.bytes = function write_bytes(value) {
          var len = value.length >>> 0;
          if (!len)
            return this._push(writeByte, 1, 0);
          if (util.isString(value)) {
            var buf = Writer2.alloc(len = base64.length(value));
            base64.decode(value, buf, 0);
            value = buf;
          }
          return this.uint32(len)._push(writeBytes, len, value);
        };
        Writer2.prototype.string = function write_string(value) {
          var len = utf8.length(value);
          return len ? this.uint32(len)._push(utf8.write, len, value) : this._push(writeByte, 1, 0);
        };
        Writer2.prototype.fork = function fork() {
          this.states = new State(this);
          this.head = this.tail = new Op(noop, 0, 0);
          this.len = 0;
          return this;
        };
        Writer2.prototype.reset = function reset2() {
          if (this.states) {
            this.head = this.states.head;
            this.tail = this.states.tail;
            this.len = this.states.len;
            this.states = this.states.next;
          } else {
            this.head = this.tail = new Op(noop, 0, 0);
            this.len = 0;
          }
          return this;
        };
        Writer2.prototype.ldelim = function ldelim() {
          var head = this.head, tail = this.tail, len = this.len;
          this.reset().uint32(len);
          if (len) {
            this.tail.next = head.next;
            this.tail = tail;
            this.len += len;
          }
          return this;
        };
        Writer2.prototype.finish = function finish() {
          var head = this.head.next, buf = this.constructor.alloc(this.len), pos = 0;
          while (head) {
            head.fn(head.val, buf, pos);
            pos += head.len;
            head = head.next;
          }
          return buf;
        };
        Writer2._configure = function(BufferWriter_) {
          BufferWriter = BufferWriter_;
          Writer2.create = create2();
          BufferWriter._configure();
        };
      }, { "15": 15 }], 17: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = BufferWriter;
        var Writer2 = require2(16);
        (BufferWriter.prototype = Object.create(Writer2.prototype)).constructor = BufferWriter;
        var util = require2(15);
        function BufferWriter() {
          Writer2.call(this);
        }
        BufferWriter._configure = function() {
          BufferWriter.alloc = util._Buffer_allocUnsafe;
          BufferWriter.writeBytesBuffer = util.Buffer && util.Buffer.prototype instanceof Uint8Array && util.Buffer.prototype.set.name === "set" ? function writeBytesBuffer_set(val, buf, pos) {
            buf.set(val, pos);
          } : function writeBytesBuffer_copy(val, buf, pos) {
            if (val.copy)
              val.copy(buf, pos, 0, val.length);
            else for (var i = 0; i < val.length; )
              buf[pos++] = val[i++];
          };
        };
        BufferWriter.prototype.bytes = function write_bytes_buffer(value) {
          if (util.isString(value))
            value = util._Buffer_from(value, "base64");
          var len = value.length >>> 0;
          this.uint32(len);
          if (len)
            this._push(BufferWriter.writeBytesBuffer, len, value);
          return this;
        };
        function writeStringBuffer(val, buf, pos) {
          if (val.length < 40)
            util.utf8.write(val, buf, pos);
          else if (buf.utf8Write)
            buf.utf8Write(val, pos);
          else
            buf.write(val, pos);
        }
        BufferWriter.prototype.string = function write_string_buffer(value) {
          var len = util.Buffer.byteLength(value);
          this.uint32(len);
          if (len)
            this._push(writeStringBuffer, len, value);
          return this;
        };
        BufferWriter._configure();
      }, { "15": 15, "16": 16 }] }, {}, [8]);
    })();
  }
});

// node_modules/lerc/LercDecode.js
var require_LercDecode = __commonJS({
  "node_modules/lerc/LercDecode.js"(exports2, module2) {
    /* Copyright 2015-2018 Esri. Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 @preserve */
    (function() {
      var LercDecode = (function() {
        var CntZImage = {};
        CntZImage.defaultNoDataValue = -34027999387901484e22;
        CntZImage.decode = function(input, options) {
          options = options || {};
          var skipMask = options.encodedMaskData || options.encodedMaskData === null;
          var parsedData = parse3(input, options.inputOffset || 0, skipMask);
          var noDataValue = options.noDataValue !== null ? options.noDataValue : CntZImage.defaultNoDataValue;
          var uncompressedData = uncompressPixelValues(
            parsedData,
            options.pixelType || Float32Array,
            options.encodedMaskData,
            noDataValue,
            options.returnMask
          );
          var result = {
            width: parsedData.width,
            height: parsedData.height,
            pixelData: uncompressedData.resultPixels,
            minValue: uncompressedData.minValue,
            maxValue: parsedData.pixels.maxValue,
            noDataValue
          };
          if (uncompressedData.resultMask) {
            result.maskData = uncompressedData.resultMask;
          }
          if (options.returnEncodedMask && parsedData.mask) {
            result.encodedMaskData = parsedData.mask.bitset ? parsedData.mask.bitset : null;
          }
          if (options.returnFileInfo) {
            result.fileInfo = formatFileInfo(parsedData);
            if (options.computeUsedBitDepths) {
              result.fileInfo.bitDepths = computeUsedBitDepths(parsedData);
            }
          }
          return result;
        };
        var uncompressPixelValues = function(data, TypedArrayClass, maskBitset, noDataValue, storeDecodedMask) {
          var blockIdx = 0;
          var numX = data.pixels.numBlocksX;
          var numY = data.pixels.numBlocksY;
          var blockWidth = Math.floor(data.width / numX);
          var blockHeight = Math.floor(data.height / numY);
          var scale = 2 * data.maxZError;
          var minValue = Number.MAX_VALUE, currentValue;
          maskBitset = maskBitset || (data.mask ? data.mask.bitset : null);
          var resultPixels, resultMask;
          resultPixels = new TypedArrayClass(data.width * data.height);
          if (storeDecodedMask && maskBitset) {
            resultMask = new Uint8Array(data.width * data.height);
          }
          var blockDataBuffer = new Float32Array(blockWidth * blockHeight);
          var xx, yy;
          for (var y = 0; y <= numY; y++) {
            var thisBlockHeight = y !== numY ? blockHeight : data.height % numY;
            if (thisBlockHeight === 0) {
              continue;
            }
            for (var x = 0; x <= numX; x++) {
              var thisBlockWidth = x !== numX ? blockWidth : data.width % numX;
              if (thisBlockWidth === 0) {
                continue;
              }
              var outPtr = y * data.width * blockHeight + x * blockWidth;
              var outStride = data.width - thisBlockWidth;
              var block = data.pixels.blocks[blockIdx];
              var blockData, blockPtr, constValue;
              if (block.encoding < 2) {
                if (block.encoding === 0) {
                  blockData = block.rawData;
                } else {
                  unstuff(block.stuffedData, block.bitsPerPixel, block.numValidPixels, block.offset, scale, blockDataBuffer, data.pixels.maxValue);
                  blockData = blockDataBuffer;
                }
                blockPtr = 0;
              } else if (block.encoding === 2) {
                constValue = 0;
              } else {
                constValue = block.offset;
              }
              var maskByte;
              if (maskBitset) {
                for (yy = 0; yy < thisBlockHeight; yy++) {
                  if (outPtr & 7) {
                    maskByte = maskBitset[outPtr >> 3];
                    maskByte <<= outPtr & 7;
                  }
                  for (xx = 0; xx < thisBlockWidth; xx++) {
                    if (!(outPtr & 7)) {
                      maskByte = maskBitset[outPtr >> 3];
                    }
                    if (maskByte & 128) {
                      if (resultMask) {
                        resultMask[outPtr] = 1;
                      }
                      currentValue = block.encoding < 2 ? blockData[blockPtr++] : constValue;
                      minValue = minValue > currentValue ? currentValue : minValue;
                      resultPixels[outPtr++] = currentValue;
                    } else {
                      if (resultMask) {
                        resultMask[outPtr] = 0;
                      }
                      resultPixels[outPtr++] = noDataValue;
                    }
                    maskByte <<= 1;
                  }
                  outPtr += outStride;
                }
              } else {
                if (block.encoding < 2) {
                  for (yy = 0; yy < thisBlockHeight; yy++) {
                    for (xx = 0; xx < thisBlockWidth; xx++) {
                      currentValue = blockData[blockPtr++];
                      minValue = minValue > currentValue ? currentValue : minValue;
                      resultPixels[outPtr++] = currentValue;
                    }
                    outPtr += outStride;
                  }
                } else {
                  minValue = minValue > constValue ? constValue : minValue;
                  for (yy = 0; yy < thisBlockHeight; yy++) {
                    for (xx = 0; xx < thisBlockWidth; xx++) {
                      resultPixels[outPtr++] = constValue;
                    }
                    outPtr += outStride;
                  }
                }
              }
              if (block.encoding === 1 && blockPtr !== block.numValidPixels) {
                throw "Block and Mask do not match";
              }
              blockIdx++;
            }
          }
          return {
            resultPixels,
            resultMask,
            minValue
          };
        };
        var formatFileInfo = function(data) {
          return {
            "fileIdentifierString": data.fileIdentifierString,
            "fileVersion": data.fileVersion,
            "imageType": data.imageType,
            "height": data.height,
            "width": data.width,
            "maxZError": data.maxZError,
            "eofOffset": data.eofOffset,
            "mask": data.mask ? {
              "numBlocksX": data.mask.numBlocksX,
              "numBlocksY": data.mask.numBlocksY,
              "numBytes": data.mask.numBytes,
              "maxValue": data.mask.maxValue
            } : null,
            "pixels": {
              "numBlocksX": data.pixels.numBlocksX,
              "numBlocksY": data.pixels.numBlocksY,
              "numBytes": data.pixels.numBytes,
              "maxValue": data.pixels.maxValue,
              "noDataValue": data.noDataValue
            }
          };
        };
        var computeUsedBitDepths = function(data) {
          var numBlocks = data.pixels.numBlocksX * data.pixels.numBlocksY;
          var bitDepths = {};
          for (var i = 0; i < numBlocks; i++) {
            var block = data.pixels.blocks[i];
            if (block.encoding === 0) {
              bitDepths.float32 = true;
            } else if (block.encoding === 1) {
              bitDepths[block.bitsPerPixel] = true;
            } else {
              bitDepths[0] = true;
            }
          }
          return Object.keys(bitDepths);
        };
        var parse3 = function(input, fp, skipMask) {
          var data = {};
          var fileIdView = new Uint8Array(input, fp, 10);
          data.fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
          if (data.fileIdentifierString.trim() !== "CntZImage") {
            throw "Unexpected file identifier string: " + data.fileIdentifierString;
          }
          fp += 10;
          var view = new DataView(input, fp, 24);
          data.fileVersion = view.getInt32(0, true);
          data.imageType = view.getInt32(4, true);
          data.height = view.getUint32(8, true);
          data.width = view.getUint32(12, true);
          data.maxZError = view.getFloat64(16, true);
          fp += 24;
          if (!skipMask) {
            view = new DataView(input, fp, 16);
            data.mask = {};
            data.mask.numBlocksY = view.getUint32(0, true);
            data.mask.numBlocksX = view.getUint32(4, true);
            data.mask.numBytes = view.getUint32(8, true);
            data.mask.maxValue = view.getFloat32(12, true);
            fp += 16;
            if (data.mask.numBytes > 0) {
              var bitset = new Uint8Array(Math.ceil(data.width * data.height / 8));
              view = new DataView(input, fp, data.mask.numBytes);
              var cnt = view.getInt16(0, true);
              var ip = 2, op = 0;
              do {
                if (cnt > 0) {
                  while (cnt--) {
                    bitset[op++] = view.getUint8(ip++);
                  }
                } else {
                  var val = view.getUint8(ip++);
                  cnt = -cnt;
                  while (cnt--) {
                    bitset[op++] = val;
                  }
                }
                cnt = view.getInt16(ip, true);
                ip += 2;
              } while (ip < data.mask.numBytes);
              if (cnt !== -32768 || op < bitset.length) {
                throw "Unexpected end of mask RLE encoding";
              }
              data.mask.bitset = bitset;
              fp += data.mask.numBytes;
            } else if ((data.mask.numBytes | data.mask.numBlocksY | data.mask.maxValue) === 0) {
              data.mask.bitset = new Uint8Array(Math.ceil(data.width * data.height / 8));
            }
          }
          view = new DataView(input, fp, 16);
          data.pixels = {};
          data.pixels.numBlocksY = view.getUint32(0, true);
          data.pixels.numBlocksX = view.getUint32(4, true);
          data.pixels.numBytes = view.getUint32(8, true);
          data.pixels.maxValue = view.getFloat32(12, true);
          fp += 16;
          var numBlocksX = data.pixels.numBlocksX;
          var numBlocksY = data.pixels.numBlocksY;
          var actualNumBlocksX = numBlocksX + (data.width % numBlocksX > 0 ? 1 : 0);
          var actualNumBlocksY = numBlocksY + (data.height % numBlocksY > 0 ? 1 : 0);
          data.pixels.blocks = new Array(actualNumBlocksX * actualNumBlocksY);
          var blockI = 0;
          for (var blockY = 0; blockY < actualNumBlocksY; blockY++) {
            for (var blockX = 0; blockX < actualNumBlocksX; blockX++) {
              var size = 0;
              var bytesLeft = input.byteLength - fp;
              view = new DataView(input, fp, Math.min(10, bytesLeft));
              var block = {};
              data.pixels.blocks[blockI++] = block;
              var headerByte = view.getUint8(0);
              size++;
              block.encoding = headerByte & 63;
              if (block.encoding > 3) {
                throw "Invalid block encoding (" + block.encoding + ")";
              }
              if (block.encoding === 2) {
                fp++;
                continue;
              }
              if (headerByte !== 0 && headerByte !== 2) {
                headerByte >>= 6;
                block.offsetType = headerByte;
                if (headerByte === 2) {
                  block.offset = view.getInt8(1);
                  size++;
                } else if (headerByte === 1) {
                  block.offset = view.getInt16(1, true);
                  size += 2;
                } else if (headerByte === 0) {
                  block.offset = view.getFloat32(1, true);
                  size += 4;
                } else {
                  throw "Invalid block offset type";
                }
                if (block.encoding === 1) {
                  headerByte = view.getUint8(size);
                  size++;
                  block.bitsPerPixel = headerByte & 63;
                  headerByte >>= 6;
                  block.numValidPixelsType = headerByte;
                  if (headerByte === 2) {
                    block.numValidPixels = view.getUint8(size);
                    size++;
                  } else if (headerByte === 1) {
                    block.numValidPixels = view.getUint16(size, true);
                    size += 2;
                  } else if (headerByte === 0) {
                    block.numValidPixels = view.getUint32(size, true);
                    size += 4;
                  } else {
                    throw "Invalid valid pixel count type";
                  }
                }
              }
              fp += size;
              if (block.encoding === 3) {
                continue;
              }
              var arrayBuf, store8;
              if (block.encoding === 0) {
                var numPixels = (data.pixels.numBytes - 1) / 4;
                if (numPixels !== Math.floor(numPixels)) {
                  throw "uncompressed block has invalid length";
                }
                arrayBuf = new ArrayBuffer(numPixels * 4);
                store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, fp, numPixels * 4));
                var rawData = new Float32Array(arrayBuf);
                block.rawData = rawData;
                fp += numPixels * 4;
              } else if (block.encoding === 1) {
                var dataBytes = Math.ceil(block.numValidPixels * block.bitsPerPixel / 8);
                var dataWords = Math.ceil(dataBytes / 4);
                arrayBuf = new ArrayBuffer(dataWords * 4);
                store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, fp, dataBytes));
                block.stuffedData = new Uint32Array(arrayBuf);
                fp += dataBytes;
              }
            }
          }
          data.eofOffset = fp;
          return data;
        };
        var unstuff = function(src, bitsPerPixel, numPixels, offset, scale, dest, maxValue) {
          var bitMask = (1 << bitsPerPixel) - 1;
          var i = 0, o;
          var bitsLeft = 0;
          var n, buffer2;
          var nmax = Math.ceil((maxValue - offset) / scale);
          var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
          src[src.length - 1] <<= 8 * numInvalidTailBytes;
          for (o = 0; o < numPixels; o++) {
            if (bitsLeft === 0) {
              buffer2 = src[i++];
              bitsLeft = 32;
            }
            if (bitsLeft >= bitsPerPixel) {
              n = buffer2 >>> bitsLeft - bitsPerPixel & bitMask;
              bitsLeft -= bitsPerPixel;
            } else {
              var missingBits = bitsPerPixel - bitsLeft;
              n = (buffer2 & bitMask) << missingBits & bitMask;
              buffer2 = src[i++];
              bitsLeft = 32 - missingBits;
              n += buffer2 >>> bitsLeft;
            }
            dest[o] = n < nmax ? offset + n * scale : maxValue;
          }
          return dest;
        };
        return CntZImage;
      })();
      var Lerc2Decode = (function() {
        "use strict";
        var BitStuffer = {
          //methods ending with 2 are for the new byte order used by Lerc2.3 and above.
          //originalUnstuff is used to unpack Huffman code table. code is duplicated to unstuffx for performance reasons.
          unstuff: function(src, dest, bitsPerPixel, numPixels, lutArr, offset, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0;
            var n, buffer2, missingBits, nmax;
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            if (lutArr) {
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer2 = src[i++];
                  bitsLeft = 32;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer2 >>> bitsLeft - bitsPerPixel & bitMask;
                  bitsLeft -= bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = (buffer2 & bitMask) << missingBits & bitMask;
                  buffer2 = src[i++];
                  bitsLeft = 32 - missingBits;
                  n += buffer2 >>> bitsLeft;
                }
                dest[o] = lutArr[n];
              }
            } else {
              nmax = Math.ceil((maxValue - offset) / scale);
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer2 = src[i++];
                  bitsLeft = 32;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer2 >>> bitsLeft - bitsPerPixel & bitMask;
                  bitsLeft -= bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = (buffer2 & bitMask) << missingBits & bitMask;
                  buffer2 = src[i++];
                  bitsLeft = 32 - missingBits;
                  n += buffer2 >>> bitsLeft;
                }
                dest[o] = n < nmax ? offset + n * scale : maxValue;
              }
            }
          },
          unstuffLUT: function(src, bitsPerPixel, numPixels, offset, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o = 0, missingBits = 0, bitsLeft = 0, n = 0;
            var buffer2;
            var dest = [];
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            var nmax = Math.ceil((maxValue - offset) / scale);
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer2 = src[i++];
                bitsLeft = 32;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer2 >>> bitsLeft - bitsPerPixel & bitMask;
                bitsLeft -= bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = (buffer2 & bitMask) << missingBits & bitMask;
                buffer2 = src[i++];
                bitsLeft = 32 - missingBits;
                n += buffer2 >>> bitsLeft;
              }
              dest[o] = n < nmax ? offset + n * scale : maxValue;
            }
            dest.unshift(offset);
            return dest;
          },
          unstuff2: function(src, dest, bitsPerPixel, numPixels, lutArr, offset, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0, bitPos = 0;
            var n, buffer2, missingBits;
            if (lutArr) {
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer2 = src[i++];
                  bitsLeft = 32;
                  bitPos = 0;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer2 >>> bitPos & bitMask;
                  bitsLeft -= bitsPerPixel;
                  bitPos += bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = buffer2 >>> bitPos & bitMask;
                  buffer2 = src[i++];
                  bitsLeft = 32 - missingBits;
                  n |= (buffer2 & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                  bitPos = missingBits;
                }
                dest[o] = lutArr[n];
              }
            } else {
              var nmax = Math.ceil((maxValue - offset) / scale);
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer2 = src[i++];
                  bitsLeft = 32;
                  bitPos = 0;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer2 >>> bitPos & bitMask;
                  bitsLeft -= bitsPerPixel;
                  bitPos += bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = buffer2 >>> bitPos & bitMask;
                  buffer2 = src[i++];
                  bitsLeft = 32 - missingBits;
                  n |= (buffer2 & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                  bitPos = missingBits;
                }
                dest[o] = n < nmax ? offset + n * scale : maxValue;
              }
            }
            return dest;
          },
          unstuffLUT2: function(src, bitsPerPixel, numPixels, offset, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o = 0, missingBits = 0, bitsLeft = 0, n = 0, bitPos = 0;
            var buffer2;
            var dest = [];
            var nmax = Math.ceil((maxValue - offset) / scale);
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer2 = src[i++];
                bitsLeft = 32;
                bitPos = 0;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer2 >>> bitPos & bitMask;
                bitsLeft -= bitsPerPixel;
                bitPos += bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = buffer2 >>> bitPos & bitMask;
                buffer2 = src[i++];
                bitsLeft = 32 - missingBits;
                n |= (buffer2 & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                bitPos = missingBits;
              }
              dest[o] = n < nmax ? offset + n * scale : maxValue;
            }
            dest.unshift(offset);
            return dest;
          },
          originalUnstuff: function(src, dest, bitsPerPixel, numPixels) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0;
            var n, buffer2, missingBits;
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer2 = src[i++];
                bitsLeft = 32;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer2 >>> bitsLeft - bitsPerPixel & bitMask;
                bitsLeft -= bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = (buffer2 & bitMask) << missingBits & bitMask;
                buffer2 = src[i++];
                bitsLeft = 32 - missingBits;
                n += buffer2 >>> bitsLeft;
              }
              dest[o] = n;
            }
            return dest;
          },
          originalUnstuff2: function(src, dest, bitsPerPixel, numPixels) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0, bitPos = 0;
            var n, buffer2, missingBits;
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer2 = src[i++];
                bitsLeft = 32;
                bitPos = 0;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer2 >>> bitPos & bitMask;
                bitsLeft -= bitsPerPixel;
                bitPos += bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = buffer2 >>> bitPos & bitMask;
                buffer2 = src[i++];
                bitsLeft = 32 - missingBits;
                n |= (buffer2 & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                bitPos = missingBits;
              }
              dest[o] = n;
            }
            return dest;
          }
        };
        var Lerc2Helpers = {
          HUFFMAN_LUT_BITS_MAX: 12,
          //use 2^12 lut, treat it like constant
          computeChecksumFletcher32: function(input) {
            var sum1 = 65535, sum2 = 65535;
            var len = input.length;
            var words = Math.floor(len / 2);
            var i = 0;
            while (words) {
              var tlen = words >= 359 ? 359 : words;
              words -= tlen;
              do {
                sum1 += input[i++] << 8;
                sum2 += sum1 += input[i++];
              } while (--tlen);
              sum1 = (sum1 & 65535) + (sum1 >>> 16);
              sum2 = (sum2 & 65535) + (sum2 >>> 16);
            }
            if (len & 1) {
              sum2 += sum1 += input[i] << 8;
            }
            sum1 = (sum1 & 65535) + (sum1 >>> 16);
            sum2 = (sum2 & 65535) + (sum2 >>> 16);
            return (sum2 << 16 | sum1) >>> 0;
          },
          readHeaderInfo: function(input, data) {
            var ptr = data.ptr;
            var fileIdView = new Uint8Array(input, ptr, 6);
            var headerInfo = {};
            headerInfo.fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
            if (headerInfo.fileIdentifierString.lastIndexOf("Lerc2", 0) !== 0) {
              throw "Unexpected file identifier string (expect Lerc2 ): " + headerInfo.fileIdentifierString;
            }
            ptr += 6;
            var view = new DataView(input, ptr, 8);
            var fileVersion = view.getInt32(0, true);
            headerInfo.fileVersion = fileVersion;
            ptr += 4;
            if (fileVersion >= 3) {
              headerInfo.checksum = view.getUint32(4, true);
              ptr += 4;
            }
            view = new DataView(input, ptr, 12);
            headerInfo.height = view.getUint32(0, true);
            headerInfo.width = view.getUint32(4, true);
            ptr += 8;
            if (fileVersion >= 4) {
              headerInfo.numDims = view.getUint32(8, true);
              ptr += 4;
            } else {
              headerInfo.numDims = 1;
            }
            view = new DataView(input, ptr, 40);
            headerInfo.numValidPixel = view.getUint32(0, true);
            headerInfo.microBlockSize = view.getInt32(4, true);
            headerInfo.blobSize = view.getInt32(8, true);
            headerInfo.imageType = view.getInt32(12, true);
            headerInfo.maxZError = view.getFloat64(16, true);
            headerInfo.zMin = view.getFloat64(24, true);
            headerInfo.zMax = view.getFloat64(32, true);
            ptr += 40;
            data.headerInfo = headerInfo;
            data.ptr = ptr;
            var checksum, keyLength;
            if (fileVersion >= 3) {
              keyLength = fileVersion >= 4 ? 52 : 48;
              checksum = this.computeChecksumFletcher32(new Uint8Array(input, ptr - keyLength, headerInfo.blobSize - 14));
              if (checksum !== headerInfo.checksum) {
                throw "Checksum failed.";
              }
            }
            return true;
          },
          checkMinMaxRanges: function(input, data) {
            var headerInfo = data.headerInfo;
            var OutPixelTypeArray = this.getDataTypeArray(headerInfo.imageType);
            var rangeBytes = headerInfo.numDims * this.getDataTypeSize(headerInfo.imageType);
            var minValues = this.readSubArray(input, data.ptr, OutPixelTypeArray, rangeBytes);
            var maxValues = this.readSubArray(input, data.ptr + rangeBytes, OutPixelTypeArray, rangeBytes);
            data.ptr += 2 * rangeBytes;
            var i, equal = true;
            for (i = 0; i < headerInfo.numDims; i++) {
              if (minValues[i] !== maxValues[i]) {
                equal = false;
                break;
              }
            }
            headerInfo.minValues = minValues;
            headerInfo.maxValues = maxValues;
            return equal;
          },
          readSubArray: function(input, ptr, OutPixelTypeArray, numBytes) {
            var rawData;
            if (OutPixelTypeArray === Uint8Array) {
              rawData = new Uint8Array(input, ptr, numBytes);
            } else {
              var arrayBuf = new ArrayBuffer(numBytes);
              var store8 = new Uint8Array(arrayBuf);
              store8.set(new Uint8Array(input, ptr, numBytes));
              rawData = new OutPixelTypeArray(arrayBuf);
            }
            return rawData;
          },
          readMask: function(input, data) {
            var ptr = data.ptr;
            var headerInfo = data.headerInfo;
            var numPixels = headerInfo.width * headerInfo.height;
            var numValidPixel = headerInfo.numValidPixel;
            var view = new DataView(input, ptr, 4);
            var mask = {};
            mask.numBytes = view.getUint32(0, true);
            ptr += 4;
            if ((0 === numValidPixel || numPixels === numValidPixel) && 0 !== mask.numBytes) {
              throw "invalid mask";
            }
            var bitset, resultMask;
            if (numValidPixel === 0) {
              bitset = new Uint8Array(Math.ceil(numPixels / 8));
              mask.bitset = bitset;
              resultMask = new Uint8Array(numPixels);
              data.pixels.resultMask = resultMask;
              ptr += mask.numBytes;
            } else if (mask.numBytes > 0) {
              bitset = new Uint8Array(Math.ceil(numPixels / 8));
              view = new DataView(input, ptr, mask.numBytes);
              var cnt = view.getInt16(0, true);
              var ip = 2, op = 0, val = 0;
              do {
                if (cnt > 0) {
                  while (cnt--) {
                    bitset[op++] = view.getUint8(ip++);
                  }
                } else {
                  val = view.getUint8(ip++);
                  cnt = -cnt;
                  while (cnt--) {
                    bitset[op++] = val;
                  }
                }
                cnt = view.getInt16(ip, true);
                ip += 2;
              } while (ip < mask.numBytes);
              if (cnt !== -32768 || op < bitset.length) {
                throw "Unexpected end of mask RLE encoding";
              }
              resultMask = new Uint8Array(numPixels);
              var mb = 0, k = 0;
              for (k = 0; k < numPixels; k++) {
                if (k & 7) {
                  mb = bitset[k >> 3];
                  mb <<= k & 7;
                } else {
                  mb = bitset[k >> 3];
                }
                if (mb & 128) {
                  resultMask[k] = 1;
                }
              }
              data.pixels.resultMask = resultMask;
              mask.bitset = bitset;
              ptr += mask.numBytes;
            }
            data.ptr = ptr;
            data.mask = mask;
            return true;
          },
          readDataOneSweep: function(input, data, OutPixelTypeArray) {
            var ptr = data.ptr;
            var headerInfo = data.headerInfo;
            var numDims = headerInfo.numDims;
            var numPixels = headerInfo.width * headerInfo.height;
            var imageType = headerInfo.imageType;
            var numBytes = headerInfo.numValidPixel * Lerc2Helpers.getDataTypeSize(imageType) * numDims;
            var rawData;
            var mask = data.pixels.resultMask;
            if (OutPixelTypeArray === Uint8Array) {
              rawData = new Uint8Array(input, ptr, numBytes);
            } else {
              var arrayBuf = new ArrayBuffer(numBytes);
              var store8 = new Uint8Array(arrayBuf);
              store8.set(new Uint8Array(input, ptr, numBytes));
              rawData = new OutPixelTypeArray(arrayBuf);
            }
            if (rawData.length === numPixels * numDims) {
              data.pixels.resultPixels = rawData;
            } else {
              data.pixels.resultPixels = new OutPixelTypeArray(numPixels * numDims);
              var z = 0, k = 0, i = 0, nStart = 0;
              if (numDims > 1) {
                for (i = 0; i < numDims; i++) {
                  nStart = i * numPixels;
                  for (k = 0; k < numPixels; k++) {
                    if (mask[k]) {
                      data.pixels.resultPixels[nStart + k] = rawData[z++];
                    }
                  }
                }
              } else {
                for (k = 0; k < numPixels; k++) {
                  if (mask[k]) {
                    data.pixels.resultPixels[k] = rawData[z++];
                  }
                }
              }
            }
            ptr += numBytes;
            data.ptr = ptr;
            return true;
          },
          readHuffmanTree: function(input, data) {
            var BITS_MAX = this.HUFFMAN_LUT_BITS_MAX;
            var view = new DataView(input, data.ptr, 16);
            data.ptr += 16;
            var version = view.getInt32(0, true);
            if (version < 2) {
              throw "unsupported Huffman version";
            }
            var size = view.getInt32(4, true);
            var i0 = view.getInt32(8, true);
            var i1 = view.getInt32(12, true);
            if (i0 >= i1) {
              return false;
            }
            var blockDataBuffer = new Uint32Array(i1 - i0);
            Lerc2Helpers.decodeBits(input, data, blockDataBuffer);
            var codeTable = [];
            var i, j, k, len;
            for (i = i0; i < i1; i++) {
              j = i - (i < size ? 0 : size);
              codeTable[j] = { first: blockDataBuffer[i - i0], second: null };
            }
            var dataBytes = input.byteLength - data.ptr;
            var dataWords = Math.ceil(dataBytes / 4);
            var arrayBuf = new ArrayBuffer(dataWords * 4);
            var store8 = new Uint8Array(arrayBuf);
            store8.set(new Uint8Array(input, data.ptr, dataBytes));
            var stuffedData = new Uint32Array(arrayBuf);
            var bitPos = 0, word, srcPtr = 0;
            word = stuffedData[0];
            for (i = i0; i < i1; i++) {
              j = i - (i < size ? 0 : size);
              len = codeTable[j].first;
              if (len > 0) {
                codeTable[j].second = word << bitPos >>> 32 - len;
                if (32 - bitPos >= len) {
                  bitPos += len;
                  if (bitPos === 32) {
                    bitPos = 0;
                    srcPtr++;
                    word = stuffedData[srcPtr];
                  }
                } else {
                  bitPos += len - 32;
                  srcPtr++;
                  word = stuffedData[srcPtr];
                  codeTable[j].second |= word >>> 32 - bitPos;
                }
              }
            }
            var numBitsLUT = 0, numBitsLUTQick = 0;
            var tree = new TreeNode();
            for (i = 0; i < codeTable.length; i++) {
              if (codeTable[i] !== void 0) {
                numBitsLUT = Math.max(numBitsLUT, codeTable[i].first);
              }
            }
            if (numBitsLUT >= BITS_MAX) {
              numBitsLUTQick = BITS_MAX;
            } else {
              numBitsLUTQick = numBitsLUT;
            }
            if (numBitsLUT >= 30) {
              console.log("WARning, large NUM LUT BITS IS " + numBitsLUT);
            }
            var decodeLut = [], entry, code, numEntries, jj, currentBit, node;
            for (i = i0; i < i1; i++) {
              j = i - (i < size ? 0 : size);
              len = codeTable[j].first;
              if (len > 0) {
                entry = [len, j];
                if (len <= numBitsLUTQick) {
                  code = codeTable[j].second << numBitsLUTQick - len;
                  numEntries = 1 << numBitsLUTQick - len;
                  for (k = 0; k < numEntries; k++) {
                    decodeLut[code | k] = entry;
                  }
                } else {
                  code = codeTable[j].second;
                  node = tree;
                  for (jj = len - 1; jj >= 0; jj--) {
                    currentBit = code >>> jj & 1;
                    if (currentBit) {
                      if (!node.right) {
                        node.right = new TreeNode();
                      }
                      node = node.right;
                    } else {
                      if (!node.left) {
                        node.left = new TreeNode();
                      }
                      node = node.left;
                    }
                    if (jj === 0 && !node.val) {
                      node.val = entry[1];
                    }
                  }
                }
              }
            }
            return {
              decodeLut,
              numBitsLUTQick,
              numBitsLUT,
              tree,
              stuffedData,
              srcPtr,
              bitPos
            };
          },
          readHuffman: function(input, data, OutPixelTypeArray) {
            var headerInfo = data.headerInfo;
            var numDims = headerInfo.numDims;
            var height = data.headerInfo.height;
            var width = data.headerInfo.width;
            var numPixels = width * height;
            var huffmanInfo = this.readHuffmanTree(input, data);
            var decodeLut = huffmanInfo.decodeLut;
            var tree = huffmanInfo.tree;
            var stuffedData = huffmanInfo.stuffedData;
            var srcPtr = huffmanInfo.srcPtr;
            var bitPos = huffmanInfo.bitPos;
            var numBitsLUTQick = huffmanInfo.numBitsLUTQick;
            var numBitsLUT = huffmanInfo.numBitsLUT;
            var offset = data.headerInfo.imageType === 0 ? 128 : 0;
            var node, val, delta, mask = data.pixels.resultMask, valTmp, valTmpQuick, currentBit;
            var i, j, k, ii;
            var prevVal = 0;
            if (bitPos > 0) {
              srcPtr++;
              bitPos = 0;
            }
            var word = stuffedData[srcPtr];
            var deltaEncode = data.encodeMode === 1;
            var resultPixelsAllDim = new OutPixelTypeArray(numPixels * numDims);
            var resultPixels = resultPixelsAllDim;
            var iDim;
            for (iDim = 0; iDim < headerInfo.numDims; iDim++) {
              if (numDims > 1) {
                resultPixels = new OutPixelTypeArray(resultPixelsAllDim.buffer, numPixels * iDim, numPixels);
                prevVal = 0;
              }
              if (data.headerInfo.numValidPixel === width * height) {
                for (k = 0, i = 0; i < height; i++) {
                  for (j = 0; j < width; j++, k++) {
                    val = 0;
                    valTmp = word << bitPos >>> 32 - numBitsLUTQick;
                    valTmpQuick = valTmp;
                    if (32 - bitPos < numBitsLUTQick) {
                      valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUTQick;
                      valTmpQuick = valTmp;
                    }
                    if (decodeLut[valTmpQuick]) {
                      val = decodeLut[valTmpQuick][1];
                      bitPos += decodeLut[valTmpQuick][0];
                    } else {
                      valTmp = word << bitPos >>> 32 - numBitsLUT;
                      valTmpQuick = valTmp;
                      if (32 - bitPos < numBitsLUT) {
                        valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUT;
                        valTmpQuick = valTmp;
                      }
                      node = tree;
                      for (ii = 0; ii < numBitsLUT; ii++) {
                        currentBit = valTmp >>> numBitsLUT - ii - 1 & 1;
                        node = currentBit ? node.right : node.left;
                        if (!(node.left || node.right)) {
                          val = node.val;
                          bitPos = bitPos + ii + 1;
                          break;
                        }
                      }
                    }
                    if (bitPos >= 32) {
                      bitPos -= 32;
                      srcPtr++;
                      word = stuffedData[srcPtr];
                    }
                    delta = val - offset;
                    if (deltaEncode) {
                      if (j > 0) {
                        delta += prevVal;
                      } else if (i > 0) {
                        delta += resultPixels[k - width];
                      } else {
                        delta += prevVal;
                      }
                      delta &= 255;
                      resultPixels[k] = delta;
                      prevVal = delta;
                    } else {
                      resultPixels[k] = delta;
                    }
                  }
                }
              } else {
                for (k = 0, i = 0; i < height; i++) {
                  for (j = 0; j < width; j++, k++) {
                    if (mask[k]) {
                      val = 0;
                      valTmp = word << bitPos >>> 32 - numBitsLUTQick;
                      valTmpQuick = valTmp;
                      if (32 - bitPos < numBitsLUTQick) {
                        valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUTQick;
                        valTmpQuick = valTmp;
                      }
                      if (decodeLut[valTmpQuick]) {
                        val = decodeLut[valTmpQuick][1];
                        bitPos += decodeLut[valTmpQuick][0];
                      } else {
                        valTmp = word << bitPos >>> 32 - numBitsLUT;
                        valTmpQuick = valTmp;
                        if (32 - bitPos < numBitsLUT) {
                          valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUT;
                          valTmpQuick = valTmp;
                        }
                        node = tree;
                        for (ii = 0; ii < numBitsLUT; ii++) {
                          currentBit = valTmp >>> numBitsLUT - ii - 1 & 1;
                          node = currentBit ? node.right : node.left;
                          if (!(node.left || node.right)) {
                            val = node.val;
                            bitPos = bitPos + ii + 1;
                            break;
                          }
                        }
                      }
                      if (bitPos >= 32) {
                        bitPos -= 32;
                        srcPtr++;
                        word = stuffedData[srcPtr];
                      }
                      delta = val - offset;
                      if (deltaEncode) {
                        if (j > 0 && mask[k - 1]) {
                          delta += prevVal;
                        } else if (i > 0 && mask[k - width]) {
                          delta += resultPixels[k - width];
                        } else {
                          delta += prevVal;
                        }
                        delta &= 255;
                        resultPixels[k] = delta;
                        prevVal = delta;
                      } else {
                        resultPixels[k] = delta;
                      }
                    }
                  }
                }
              }
              data.ptr = data.ptr + (srcPtr + 1) * 4 + (bitPos > 0 ? 4 : 0);
            }
            data.pixels.resultPixels = resultPixelsAllDim;
          },
          decodeBits: function(input, data, blockDataBuffer, offset, iDim) {
            {
              var headerInfo = data.headerInfo;
              var fileVersion = headerInfo.fileVersion;
              var blockPtr = 0;
              var view = new DataView(input, data.ptr, 5);
              var headerByte = view.getUint8(0);
              blockPtr++;
              var bits67 = headerByte >> 6;
              var n = bits67 === 0 ? 4 : 3 - bits67;
              var doLut = (headerByte & 32) > 0 ? true : false;
              var numBits = headerByte & 31;
              var numElements = 0;
              if (n === 1) {
                numElements = view.getUint8(blockPtr);
                blockPtr++;
              } else if (n === 2) {
                numElements = view.getUint16(blockPtr, true);
                blockPtr += 2;
              } else if (n === 4) {
                numElements = view.getUint32(blockPtr, true);
                blockPtr += 4;
              } else {
                throw "Invalid valid pixel count type";
              }
              var scale = 2 * headerInfo.maxZError;
              var stuffedData, arrayBuf, store8, dataBytes, dataWords;
              var lutArr, lutData, lutBytes, lutBitsPerElement, bitsPerPixel;
              var zMax = headerInfo.numDims > 1 ? headerInfo.maxValues[iDim] : headerInfo.zMax;
              if (doLut) {
                data.counter.lut++;
                lutBytes = view.getUint8(blockPtr);
                lutBitsPerElement = numBits;
                blockPtr++;
                dataBytes = Math.ceil((lutBytes - 1) * numBits / 8);
                dataWords = Math.ceil(dataBytes / 4);
                arrayBuf = new ArrayBuffer(dataWords * 4);
                store8 = new Uint8Array(arrayBuf);
                data.ptr += blockPtr;
                store8.set(new Uint8Array(input, data.ptr, dataBytes));
                lutData = new Uint32Array(arrayBuf);
                data.ptr += dataBytes;
                bitsPerPixel = 0;
                while (lutBytes - 1 >>> bitsPerPixel) {
                  bitsPerPixel++;
                }
                dataBytes = Math.ceil(numElements * bitsPerPixel / 8);
                dataWords = Math.ceil(dataBytes / 4);
                arrayBuf = new ArrayBuffer(dataWords * 4);
                store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, data.ptr, dataBytes));
                stuffedData = new Uint32Array(arrayBuf);
                data.ptr += dataBytes;
                if (fileVersion >= 3) {
                  lutArr = BitStuffer.unstuffLUT2(lutData, numBits, lutBytes - 1, offset, scale, zMax);
                } else {
                  lutArr = BitStuffer.unstuffLUT(lutData, numBits, lutBytes - 1, offset, scale, zMax);
                }
                if (fileVersion >= 3) {
                  BitStuffer.unstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements, lutArr);
                } else {
                  BitStuffer.unstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements, lutArr);
                }
              } else {
                data.counter.bitstuffer++;
                bitsPerPixel = numBits;
                data.ptr += blockPtr;
                if (bitsPerPixel > 0) {
                  dataBytes = Math.ceil(numElements * bitsPerPixel / 8);
                  dataWords = Math.ceil(dataBytes / 4);
                  arrayBuf = new ArrayBuffer(dataWords * 4);
                  store8 = new Uint8Array(arrayBuf);
                  store8.set(new Uint8Array(input, data.ptr, dataBytes));
                  stuffedData = new Uint32Array(arrayBuf);
                  data.ptr += dataBytes;
                  if (fileVersion >= 3) {
                    if (offset == null) {
                      BitStuffer.originalUnstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements);
                    } else {
                      BitStuffer.unstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements, false, offset, scale, zMax);
                    }
                  } else {
                    if (offset == null) {
                      BitStuffer.originalUnstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements);
                    } else {
                      BitStuffer.unstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements, false, offset, scale, zMax);
                    }
                  }
                }
              }
            }
          },
          readTiles: function(input, data, OutPixelTypeArray) {
            var headerInfo = data.headerInfo;
            var width = headerInfo.width;
            var height = headerInfo.height;
            var microBlockSize = headerInfo.microBlockSize;
            var imageType = headerInfo.imageType;
            var dataTypeSize = Lerc2Helpers.getDataTypeSize(imageType);
            var numBlocksX = Math.ceil(width / microBlockSize);
            var numBlocksY = Math.ceil(height / microBlockSize);
            data.pixels.numBlocksY = numBlocksY;
            data.pixels.numBlocksX = numBlocksX;
            data.pixels.ptr = 0;
            var row = 0, col = 0, blockY = 0, blockX = 0, thisBlockHeight = 0, thisBlockWidth = 0, bytesLeft = 0, headerByte = 0, bits67 = 0, testCode = 0, outPtr = 0, outStride = 0, numBytes = 0, bytesleft = 0, z = 0, blockPtr = 0;
            var view, block, arrayBuf, store8, rawData;
            var blockEncoding;
            var blockDataBuffer = new OutPixelTypeArray(microBlockSize * microBlockSize);
            var lastBlockHeight = height % microBlockSize || microBlockSize;
            var lastBlockWidth = width % microBlockSize || microBlockSize;
            var offsetType, offset;
            var numDims = headerInfo.numDims, iDim;
            var mask = data.pixels.resultMask;
            var resultPixels = data.pixels.resultPixels;
            for (blockY = 0; blockY < numBlocksY; blockY++) {
              thisBlockHeight = blockY !== numBlocksY - 1 ? microBlockSize : lastBlockHeight;
              for (blockX = 0; blockX < numBlocksX; blockX++) {
                thisBlockWidth = blockX !== numBlocksX - 1 ? microBlockSize : lastBlockWidth;
                outPtr = blockY * width * microBlockSize + blockX * microBlockSize;
                outStride = width - thisBlockWidth;
                for (iDim = 0; iDim < numDims; iDim++) {
                  if (numDims > 1) {
                    resultPixels = new OutPixelTypeArray(data.pixels.resultPixels.buffer, width * height * iDim * dataTypeSize, width * height);
                  }
                  bytesLeft = input.byteLength - data.ptr;
                  view = new DataView(input, data.ptr, Math.min(10, bytesLeft));
                  block = {};
                  blockPtr = 0;
                  headerByte = view.getUint8(0);
                  blockPtr++;
                  bits67 = headerByte >> 6 & 255;
                  testCode = headerByte >> 2 & 15;
                  if (testCode !== (blockX * microBlockSize >> 3 & 15)) {
                    throw "integrity issue";
                  }
                  blockEncoding = headerByte & 3;
                  if (blockEncoding > 3) {
                    data.ptr += blockPtr;
                    throw "Invalid block encoding (" + blockEncoding + ")";
                  } else if (blockEncoding === 2) {
                    data.counter.constant++;
                    data.ptr += blockPtr;
                    continue;
                  } else if (blockEncoding === 0) {
                    data.counter.uncompressed++;
                    data.ptr += blockPtr;
                    numBytes = thisBlockHeight * thisBlockWidth * dataTypeSize;
                    bytesleft = input.byteLength - data.ptr;
                    numBytes = numBytes < bytesleft ? numBytes : bytesleft;
                    arrayBuf = new ArrayBuffer(numBytes % dataTypeSize === 0 ? numBytes : numBytes + dataTypeSize - numBytes % dataTypeSize);
                    store8 = new Uint8Array(arrayBuf);
                    store8.set(new Uint8Array(input, data.ptr, numBytes));
                    rawData = new OutPixelTypeArray(arrayBuf);
                    z = 0;
                    if (mask) {
                      for (row = 0; row < thisBlockHeight; row++) {
                        for (col = 0; col < thisBlockWidth; col++) {
                          if (mask[outPtr]) {
                            resultPixels[outPtr] = rawData[z++];
                          }
                          outPtr++;
                        }
                        outPtr += outStride;
                      }
                    } else {
                      for (row = 0; row < thisBlockHeight; row++) {
                        for (col = 0; col < thisBlockWidth; col++) {
                          resultPixels[outPtr++] = rawData[z++];
                        }
                        outPtr += outStride;
                      }
                    }
                    data.ptr += z * dataTypeSize;
                  } else {
                    offsetType = Lerc2Helpers.getDataTypeUsed(imageType, bits67);
                    offset = Lerc2Helpers.getOnePixel(block, blockPtr, offsetType, view);
                    blockPtr += Lerc2Helpers.getDataTypeSize(offsetType);
                    if (blockEncoding === 3) {
                      data.ptr += blockPtr;
                      data.counter.constantoffset++;
                      if (mask) {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            if (mask[outPtr]) {
                              resultPixels[outPtr] = offset;
                            }
                            outPtr++;
                          }
                          outPtr += outStride;
                        }
                      } else {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            resultPixels[outPtr++] = offset;
                          }
                          outPtr += outStride;
                        }
                      }
                    } else {
                      data.ptr += blockPtr;
                      Lerc2Helpers.decodeBits(input, data, blockDataBuffer, offset, iDim);
                      blockPtr = 0;
                      if (mask) {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            if (mask[outPtr]) {
                              resultPixels[outPtr] = blockDataBuffer[blockPtr++];
                            }
                            outPtr++;
                          }
                          outPtr += outStride;
                        }
                      } else {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            resultPixels[outPtr++] = blockDataBuffer[blockPtr++];
                          }
                          outPtr += outStride;
                        }
                      }
                    }
                  }
                }
              }
            }
          },
          /*****************
          *  private methods (helper methods)
          *****************/
          formatFileInfo: function(data) {
            return {
              "fileIdentifierString": data.headerInfo.fileIdentifierString,
              "fileVersion": data.headerInfo.fileVersion,
              "imageType": data.headerInfo.imageType,
              "height": data.headerInfo.height,
              "width": data.headerInfo.width,
              "numValidPixel": data.headerInfo.numValidPixel,
              "microBlockSize": data.headerInfo.microBlockSize,
              "blobSize": data.headerInfo.blobSize,
              "maxZError": data.headerInfo.maxZError,
              "pixelType": Lerc2Helpers.getPixelType(data.headerInfo.imageType),
              "eofOffset": data.eofOffset,
              "mask": data.mask ? {
                "numBytes": data.mask.numBytes
              } : null,
              "pixels": {
                "numBlocksX": data.pixels.numBlocksX,
                "numBlocksY": data.pixels.numBlocksY,
                //"numBytes": data.pixels.numBytes,
                "maxValue": data.headerInfo.zMax,
                "minValue": data.headerInfo.zMin,
                "noDataValue": data.noDataValue
              }
            };
          },
          constructConstantSurface: function(data) {
            var val = data.headerInfo.zMax;
            var numDims = data.headerInfo.numDims;
            var numPixels = data.headerInfo.height * data.headerInfo.width;
            var numPixelAllDims = numPixels * numDims;
            var i = 0, k = 0, nStart = 0;
            var mask = data.pixels.resultMask;
            if (mask) {
              if (numDims > 1) {
                for (i = 0; i < numDims; i++) {
                  nStart = i * numPixels;
                  for (k = 0; k < numPixels; k++) {
                    if (mask[k]) {
                      data.pixels.resultPixels[nStart + k] = val;
                    }
                  }
                }
              } else {
                for (k = 0; k < numPixels; k++) {
                  if (mask[k]) {
                    data.pixels.resultPixels[k] = val;
                  }
                }
              }
            } else {
              if (data.pixels.resultPixels.fill) {
                data.pixels.resultPixels.fill(val);
              } else {
                for (k = 0; k < numPixelAllDims; k++) {
                  data.pixels.resultPixels[k] = val;
                }
              }
            }
            return;
          },
          getDataTypeArray: function(t) {
            var tp;
            switch (t) {
              case 0:
                tp = Int8Array;
                break;
              case 1:
                tp = Uint8Array;
                break;
              case 2:
                tp = Int16Array;
                break;
              case 3:
                tp = Uint16Array;
                break;
              case 4:
                tp = Int32Array;
                break;
              case 5:
                tp = Uint32Array;
                break;
              case 6:
                tp = Float32Array;
                break;
              case 7:
                tp = Float64Array;
                break;
              default:
                tp = Float32Array;
            }
            return tp;
          },
          getPixelType: function(t) {
            var tp;
            switch (t) {
              case 0:
                tp = "S8";
                break;
              case 1:
                tp = "U8";
                break;
              case 2:
                tp = "S16";
                break;
              case 3:
                tp = "U16";
                break;
              case 4:
                tp = "S32";
                break;
              case 5:
                tp = "U32";
                break;
              case 6:
                tp = "F32";
                break;
              case 7:
                tp = "F64";
                break;
              default:
                tp = "F32";
            }
            return tp;
          },
          isValidPixelValue: function(t, val) {
            if (val == null) {
              return false;
            }
            var isValid;
            switch (t) {
              case 0:
                isValid = val >= -128 && val <= 127;
                break;
              case 1:
                isValid = val >= 0 && val <= 255;
                break;
              case 2:
                isValid = val >= -32768 && val <= 32767;
                break;
              case 3:
                isValid = val >= 0 && val <= 65536;
                break;
              case 4:
                isValid = val >= -2147483648 && val <= 2147483647;
                break;
              case 5:
                isValid = val >= 0 && val <= 4294967296;
                break;
              case 6:
                isValid = val >= -34027999387901484e22 && val <= 34027999387901484e22;
                break;
              case 7:
                isValid = val >= 5e-324 && val <= 17976931348623157e292;
                break;
              default:
                isValid = false;
            }
            return isValid;
          },
          getDataTypeSize: function(t) {
            var s = 0;
            switch (t) {
              case 0:
              //ubyte
              case 1:
                s = 1;
                break;
              case 2:
              //short
              case 3:
                s = 2;
                break;
              case 4:
              case 5:
              case 6:
                s = 4;
                break;
              case 7:
                s = 8;
                break;
              default:
                s = t;
            }
            return s;
          },
          getDataTypeUsed: function(dt, tc) {
            var t = dt;
            switch (dt) {
              case 2:
              //short
              case 4:
                t = dt - tc;
                break;
              case 3:
              //ushort
              case 5:
                t = dt - 2 * tc;
                break;
              case 6:
                if (0 === tc) {
                  t = dt;
                } else if (1 === tc) {
                  t = 2;
                } else {
                  t = 1;
                }
                break;
              case 7:
                if (0 === tc) {
                  t = dt;
                } else {
                  t = dt - 2 * tc + 1;
                }
                break;
              default:
                t = dt;
                break;
            }
            return t;
          },
          getOnePixel: function(block, blockPtr, offsetType, view) {
            var temp = 0;
            switch (offsetType) {
              case 0:
                temp = view.getInt8(blockPtr);
                break;
              case 1:
                temp = view.getUint8(blockPtr);
                break;
              case 2:
                temp = view.getInt16(blockPtr, true);
                break;
              case 3:
                temp = view.getUint16(blockPtr, true);
                break;
              case 4:
                temp = view.getInt32(blockPtr, true);
                break;
              case 5:
                temp = view.getUInt32(blockPtr, true);
                break;
              case 6:
                temp = view.getFloat32(blockPtr, true);
                break;
              case 7:
                temp = view.getFloat64(blockPtr, true);
                break;
              default:
                throw "the decoder does not understand this pixel type";
            }
            return temp;
          }
        };
        var TreeNode = function(val, left, right) {
          this.val = val;
          this.left = left;
          this.right = right;
        };
        var Lerc2Decode2 = {
          /*
          * ********removed options compared to LERC1. We can bring some of them back if needed.
           * removed pixel type. LERC2 is typed and doesn't require user to give pixel type
           * changed encodedMaskData to maskData. LERC2 's js version make it faster to use maskData directly.
           * removed returnMask. mask is used by LERC2 internally and is cost free. In case of user input mask, it's returned as well and has neglible cost.
           * removed nodatavalue. Because LERC2 pixels are typed, nodatavalue will sacrify a useful value for many types (8bit, 16bit) etc,
           *       user has to be knowledgable enough about raster and their data to avoid usability issues. so nodata value is simply removed now.
           *       We can add it back later if their's a clear requirement.
           * removed encodedMask. This option was not implemented in LercDecode. It can be done after decoding (less efficient)
           * removed computeUsedBitDepths.
           *
           *
           * response changes compared to LERC1
           * 1. encodedMaskData is not available
           * 2. noDataValue is optional (returns only if user's noDataValue is with in the valid data type range)
           * 3. maskData is always available
          */
          /*****************
          *  public properties
          ******************/
          //HUFFMAN_LUT_BITS_MAX: 12, //use 2^12 lut, not configurable
          /*****************
          *  public methods
          *****************/
          /**
           * Decode a LERC2 byte stream and return an object containing the pixel data and optional metadata.
           *
           * @param {ArrayBuffer} input The LERC input byte stream
           * @param {object} [options] options Decoding options
           * @param {number} [options.inputOffset] The number of bytes to skip in the input byte stream. A valid LERC file is expected at that position
           * @param {boolean} [options.returnFileInfo] If true, the return value will have a fileInfo property that contains metadata obtained from the LERC headers and the decoding process
           */
          decode: function(input, options) {
            options = options || {};
            var noDataValue = options.noDataValue;
            var i = 0, data = {};
            data.ptr = options.inputOffset || 0;
            data.pixels = {};
            if (!Lerc2Helpers.readHeaderInfo(input, data)) {
              return;
            }
            var headerInfo = data.headerInfo;
            var fileVersion = headerInfo.fileVersion;
            var OutPixelTypeArray = Lerc2Helpers.getDataTypeArray(headerInfo.imageType);
            Lerc2Helpers.readMask(input, data);
            if (headerInfo.numValidPixel !== headerInfo.width * headerInfo.height && !data.pixels.resultMask) {
              data.pixels.resultMask = options.maskData;
            }
            var numPixels = headerInfo.width * headerInfo.height;
            data.pixels.resultPixels = new OutPixelTypeArray(numPixels * headerInfo.numDims);
            data.counter = {
              onesweep: 0,
              uncompressed: 0,
              lut: 0,
              bitstuffer: 0,
              constant: 0,
              constantoffset: 0
            };
            if (headerInfo.numValidPixel !== 0) {
              if (headerInfo.zMax === headerInfo.zMin) {
                Lerc2Helpers.constructConstantSurface(data);
              } else if (fileVersion >= 4 && Lerc2Helpers.checkMinMaxRanges(input, data)) {
                Lerc2Helpers.constructConstantSurface(data);
              } else {
                var view = new DataView(input, data.ptr, 2);
                var bReadDataOneSweep = view.getUint8(0);
                data.ptr++;
                if (bReadDataOneSweep) {
                  Lerc2Helpers.readDataOneSweep(input, data, OutPixelTypeArray);
                } else {
                  if (fileVersion > 1 && headerInfo.imageType <= 1 && Math.abs(headerInfo.maxZError - 0.5) < 1e-5) {
                    var flagHuffman = view.getUint8(1);
                    data.ptr++;
                    data.encodeMode = flagHuffman;
                    if (flagHuffman > 2 || fileVersion < 4 && flagHuffman > 1) {
                      throw "Invalid Huffman flag " + flagHuffman;
                    }
                    if (flagHuffman) {
                      Lerc2Helpers.readHuffman(input, data, OutPixelTypeArray);
                    } else {
                      Lerc2Helpers.readTiles(input, data, OutPixelTypeArray);
                    }
                  } else {
                    Lerc2Helpers.readTiles(input, data, OutPixelTypeArray);
                  }
                }
              }
            }
            data.eofOffset = data.ptr;
            var diff;
            if (options.inputOffset) {
              diff = data.headerInfo.blobSize + options.inputOffset - data.ptr;
              if (Math.abs(diff) >= 1) {
                data.eofOffset = options.inputOffset + data.headerInfo.blobSize;
              }
            } else {
              diff = data.headerInfo.blobSize - data.ptr;
              if (Math.abs(diff) >= 1) {
                data.eofOffset = data.headerInfo.blobSize;
              }
            }
            var result = {
              width: headerInfo.width,
              height: headerInfo.height,
              pixelData: data.pixels.resultPixels,
              minValue: headerInfo.zMin,
              maxValue: headerInfo.zMax,
              validPixelCount: headerInfo.numValidPixel,
              dimCount: headerInfo.numDims,
              dimStats: {
                minValues: headerInfo.minValues,
                maxValues: headerInfo.maxValues
              },
              maskData: data.pixels.resultMask
              //noDataValue: noDataValue
            };
            if (data.pixels.resultMask && Lerc2Helpers.isValidPixelValue(headerInfo.imageType, noDataValue)) {
              var mask = data.pixels.resultMask;
              for (i = 0; i < numPixels; i++) {
                if (!mask[i]) {
                  result.pixelData[i] = noDataValue;
                }
              }
              result.noDataValue = noDataValue;
            }
            data.noDataValue = noDataValue;
            if (options.returnFileInfo) {
              result.fileInfo = Lerc2Helpers.formatFileInfo(data);
            }
            return result;
          },
          getBandCount: function(input) {
            var count = 0;
            var i = 0;
            var temp = {};
            temp.ptr = 0;
            temp.pixels = {};
            while (i < input.byteLength - 58) {
              Lerc2Helpers.readHeaderInfo(input, temp);
              i += temp.headerInfo.blobSize;
              count++;
              temp.ptr = i;
            }
            return count;
          }
        };
        return Lerc2Decode2;
      })();
      var isPlatformLittleEndian = (function() {
        var a3 = new ArrayBuffer(4);
        var b = new Uint8Array(a3);
        var c = new Uint32Array(a3);
        c[0] = 1;
        return b[0] === 1;
      })();
      var Lerc2 = {
        /************wrapper**********************************************/
        /**
         * A wrapper for decoding both LERC1 and LERC2 byte streams capable of handling multiband pixel blocks for various pixel types.
         *
         * @alias module:Lerc
         * @param {ArrayBuffer} input The LERC input byte stream
         * @param {object} [options] The decoding options below are optional.
         * @param {number} [options.inputOffset] The number of bytes to skip in the input byte stream. A valid Lerc file is expected at that position.
         * @param {string} [options.pixelType] (LERC1 only) Default value is F32. Valid pixel types for input are U8/S8/S16/U16/S32/U32/F32.
         * @param {number} [options.noDataValue] (LERC1 only). It is recommended to use the returned mask instead of setting this value.
         * @returns {{width, height, pixels, pixelType, mask, statistics}}
           * @property {number} width Width of decoded image.
           * @property {number} height Height of decoded image.
           * @property {array} pixels [band1, band2, …] Each band is a typed array of width*height.
           * @property {string} pixelType The type of pixels represented in the output.
           * @property {mask} mask Typed array with a size of width*height, or null if all pixels are valid.
           * @property {array} statistics [statistics_band1, statistics_band2, …] Each element is a statistics object representing min and max values
        **/
        decode: function(encodedData, options) {
          if (!isPlatformLittleEndian) {
            throw "Big endian system is not supported.";
          }
          options = options || {};
          var inputOffset = options.inputOffset || 0;
          var fileIdView = new Uint8Array(encodedData, inputOffset, 10);
          var fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
          var lerc, majorVersion;
          if (fileIdentifierString.trim() === "CntZImage") {
            lerc = LercDecode;
            majorVersion = 1;
          } else if (fileIdentifierString.substring(0, 5) === "Lerc2") {
            lerc = Lerc2Decode;
            majorVersion = 2;
          } else {
            throw "Unexpected file identifier string: " + fileIdentifierString;
          }
          var iPlane = 0, eof = encodedData.byteLength - 10, encodedMaskData, bandMasks = [], bandMask, maskData;
          var decodedPixelBlock = {
            width: 0,
            height: 0,
            pixels: [],
            pixelType: options.pixelType,
            mask: null,
            statistics: []
          };
          while (inputOffset < eof) {
            var result = lerc.decode(encodedData, {
              inputOffset,
              //for both lerc1 and lerc2
              encodedMaskData,
              //lerc1 only
              maskData,
              //lerc2 only
              returnMask: iPlane === 0 ? true : false,
              //lerc1 only
              returnEncodedMask: iPlane === 0 ? true : false,
              //lerc1 only
              returnFileInfo: true,
              //for both lerc1 and lerc2
              pixelType: options.pixelType || null,
              //lerc1 only
              noDataValue: options.noDataValue || null
              //lerc1 only
            });
            inputOffset = result.fileInfo.eofOffset;
            if (iPlane === 0) {
              encodedMaskData = result.encodedMaskData;
              maskData = result.maskData;
              decodedPixelBlock.width = result.width;
              decodedPixelBlock.height = result.height;
              decodedPixelBlock.dimCount = result.dimCount || 1;
              decodedPixelBlock.pixelType = result.pixelType || result.fileInfo.pixelType;
              decodedPixelBlock.mask = result.maskData;
            }
            if (majorVersion > 1 && result.fileInfo.mask && result.fileInfo.mask.numBytes > 0) {
              bandMasks.push(result.maskData);
            }
            iPlane++;
            decodedPixelBlock.pixels.push(result.pixelData);
            decodedPixelBlock.statistics.push({
              minValue: result.minValue,
              maxValue: result.maxValue,
              noDataValue: result.noDataValue,
              dimStats: result.dimStats
            });
          }
          var i, j, numPixels;
          if (majorVersion > 1 && bandMasks.length > 1) {
            numPixels = decodedPixelBlock.width * decodedPixelBlock.height;
            decodedPixelBlock.bandMasks = bandMasks;
            maskData = new Uint8Array(numPixels);
            maskData.set(bandMasks[0]);
            for (i = 1; i < bandMasks.length; i++) {
              bandMask = bandMasks[i];
              for (j = 0; j < numPixels; j++) {
                maskData[j] = maskData[j] & bandMask[j];
              }
            }
            decodedPixelBlock.maskData = maskData;
          }
          return decodedPixelBlock;
        }
      };
      if (typeof define === "function" && define.amd) {
        define([], function() {
          return Lerc2;
        });
      } else if (typeof module2 !== "undefined" && module2.exports) {
        module2.exports = Lerc2;
      } else {
        this.Lerc = Lerc2;
      }
    })();
  }
});

// node_modules/nosleep.js/dist/NoSleep.min.js
var require_NoSleep_min = __commonJS({
  "node_modules/nosleep.js/dist/NoSleep.min.js"(exports2, module2) {
    /*! NoSleep.min.js v0.12.0 - git.io/vfn01 - Rich Tibbett - MIT license */
    !(function(A2, e) {
      "object" == typeof exports2 && "object" == typeof module2 ? module2.exports = e() : "function" == typeof define && define.amd ? define([], e) : "object" == typeof exports2 ? exports2.NoSleep = e() : A2.NoSleep = e();
    })(exports2, (function() {
      return (function(A2) {
        var e = {};
        function B(g2) {
          if (e[g2]) return e[g2].exports;
          var o = e[g2] = { i: g2, l: false, exports: {} };
          return A2[g2].call(o.exports, o, o.exports, B), o.l = true, o.exports;
        }
        return B.m = A2, B.c = e, B.d = function(A3, e2, g2) {
          B.o(A3, e2) || Object.defineProperty(A3, e2, { enumerable: true, get: g2 });
        }, B.r = function(A3) {
          "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(A3, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(A3, "__esModule", { value: true });
        }, B.t = function(A3, e2) {
          if (1 & e2 && (A3 = B(A3)), 8 & e2) return A3;
          if (4 & e2 && "object" == typeof A3 && A3 && A3.__esModule) return A3;
          var g2 = /* @__PURE__ */ Object.create(null);
          if (B.r(g2), Object.defineProperty(g2, "default", { enumerable: true, value: A3 }), 2 & e2 && "string" != typeof A3) for (var o in A3) B.d(g2, o, function(e3) {
            return A3[e3];
          }.bind(null, o));
          return g2;
        }, B.n = function(A3) {
          var e2 = A3 && A3.__esModule ? function() {
            return A3.default;
          } : function() {
            return A3;
          };
          return B.d(e2, "a", e2), e2;
        }, B.o = function(A3, e2) {
          return Object.prototype.hasOwnProperty.call(A3, e2);
        }, B.p = "", B(B.s = 0);
      })([function(A2, e, B) {
        "use strict";
        var g2 = /* @__PURE__ */ (function() {
          function A3(A4, e2) {
            for (var B2 = 0; B2 < e2.length; B2++) {
              var g3 = e2[B2];
              g3.enumerable = g3.enumerable || false, g3.configurable = true, "value" in g3 && (g3.writable = true), Object.defineProperty(A4, g3.key, g3);
            }
          }
          return function(e2, B2, g3) {
            return B2 && A3(e2.prototype, B2), g3 && A3(e2, g3), e2;
          };
        })();
        var o = B(1), E = o.webm, n = o.mp4, C = function() {
          return "undefined" != typeof navigator && parseFloat(("" + (/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0, ""])[1]).replace("undefined", "3_2").replace("_", ".").replace("_", "")) < 10 && !window.MSStream;
        }, Q = function() {
          return "wakeLock" in navigator;
        }, i = (function() {
          function A3() {
            var e2 = this;
            if ((function(A4, e3) {
              if (!(A4 instanceof e3)) throw new TypeError("Cannot call a class as a function");
            })(this, A3), this.enabled = false, Q()) {
              this._wakeLock = null;
              var B2 = function() {
                null !== e2._wakeLock && "visible" === document.visibilityState && e2.enable();
              };
              document.addEventListener("visibilitychange", B2), document.addEventListener("fullscreenchange", B2);
            } else C() ? this.noSleepTimer = null : (this.noSleepVideo = document.createElement("video"), this.noSleepVideo.setAttribute("title", "No Sleep"), this.noSleepVideo.setAttribute("playsinline", ""), this._addSourceToVideo(this.noSleepVideo, "webm", E), this._addSourceToVideo(this.noSleepVideo, "mp4", n), this.noSleepVideo.addEventListener("loadedmetadata", (function() {
              e2.noSleepVideo.duration <= 1 ? e2.noSleepVideo.setAttribute("loop", "") : e2.noSleepVideo.addEventListener("timeupdate", (function() {
                e2.noSleepVideo.currentTime > 0.5 && (e2.noSleepVideo.currentTime = Math.random());
              }));
            })));
          }
          return g2(A3, [{ key: "_addSourceToVideo", value: function(A4, e2, B2) {
            var g3 = document.createElement("source");
            g3.src = B2, g3.type = "video/" + e2, A4.appendChild(g3);
          } }, { key: "enable", value: function() {
            var A4 = this;
            return Q() ? navigator.wakeLock.request("screen").then((function(e2) {
              A4._wakeLock = e2, A4.enabled = true, console.log("Wake Lock active."), A4._wakeLock.addEventListener("release", (function() {
                console.log("Wake Lock released.");
              }));
            })).catch((function(e2) {
              throw A4.enabled = false, console.error(e2.name + ", " + e2.message), e2;
            })) : C() ? (this.disable(), console.warn("\n        NoSleep enabled for older iOS devices. This can interrupt\n        active or long-running network requests from completing successfully.\n        See https://github.com/richtr/NoSleep.js/issues/15 for more details.\n      "), this.noSleepTimer = window.setInterval((function() {
              document.hidden || (window.location.href = window.location.href.split("#")[0], window.setTimeout(window.stop, 0));
            }), 15e3), this.enabled = true, Promise.resolve()) : this.noSleepVideo.play().then((function(e2) {
              return A4.enabled = true, e2;
            })).catch((function(e2) {
              throw A4.enabled = false, e2;
            }));
          } }, { key: "disable", value: function() {
            Q() ? (this._wakeLock && this._wakeLock.release(), this._wakeLock = null) : C() ? this.noSleepTimer && (console.warn("\n          NoSleep now disabled for older iOS devices.\n        "), window.clearInterval(this.noSleepTimer), this.noSleepTimer = null) : this.noSleepVideo.pause(), this.enabled = false;
          } }, { key: "isEnabled", get: function() {
            return this.enabled;
          } }]), A3;
        })();
        A2.exports = i;
      }, function(A2, e, B) {
        "use strict";
        A2.exports = { webm: "data:video/webm;base64,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", mp4: "data:video/mp4;base64,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" };
      }]);
    }));
  }
});

// Source/Cesium.js
var Cesium_exports = {};
__export(Cesium_exports, {
  AlphaMode: () => AlphaMode_default,
  AlphaPipelineStage: () => AlphaPipelineStage_default,
  AnchorPointDirect: () => AnchorPointDirect_default,
  AnchorPointIndirect: () => AnchorPointIndirect_default,
  Animation: () => Animation_default,
  AnimationViewModel: () => AnimationViewModel_default,
  Appearance: () => Appearance_default,
  ApproximateTerrainHeights: () => ApproximateTerrainHeights_default,
  ArcGISTiledElevationTerrainProvider: () => ArcGISTiledElevationTerrainProvider_default,
  ArcGisBaseMapType: () => ArcGisBaseMapType_default,
  ArcGisMapServerImageryProvider: () => ArcGisMapServerImageryProvider_default,
  ArcGisMapService: () => ArcGisMapService_default,
  ArcType: () => ArcType_default,
  ArticulationStageType: () => ArticulationStageType_default,
  AssociativeArray: () => AssociativeArray_default,
  Atmosphere: () => Atmosphere_default,
  AtmospherePipelineStage: () => AtmospherePipelineStage_default,
  AttributeCompression: () => AttributeCompression_default,
  AttributeType: () => AttributeType_default,
  AutoExposure: () => AutoExposure_default,
  AutomaticUniforms: () => AutomaticUniforms_default,
  Axis: () => Axis_default,
  AxisAlignedBoundingBox: () => AxisAlignedBoundingBox_default,
  Azure2DImageryProvider: () => Azure2DImageryProvider_default,
  B3dmLoader: () => B3dmLoader_default,
  B3dmParser: () => B3dmParser_default,
  BaseLayerPicker: () => BaseLayerPicker_default,
  BaseLayerPickerViewModel: () => BaseLayerPickerViewModel_default,
  BatchTable: () => BatchTable_default,
  BatchTableHierarchy: () => BatchTableHierarchy_default,
  BatchTexture: () => BatchTexture_default,
  BatchTexturePipelineStage: () => BatchTexturePipelineStage_default,
  Billboard: () => Billboard_default,
  BillboardCollection: () => BillboardCollection_default,
  BillboardGraphics: () => BillboardGraphics_default,
  BillboardLoadState: () => BillboardLoadState_default,
  BillboardTexture: () => BillboardTexture_default,
  BillboardVisualizer: () => BillboardVisualizer_default,
  BingMapsGeocoderService: () => BingMapsGeocoderService_default,
  BingMapsImageryProvider: () => BingMapsImageryProvider_default,
  BingMapsStyle: () => BingMapsStyle_default,
  BlendEquation: () => BlendEquation_default,
  BlendFunction: () => BlendFunction_default,
  BlendOption: () => BlendOption_default,
  BlendingState: () => BlendingState_default,
  BoundingRectangle: () => BoundingRectangle_default,
  BoundingSphere: () => BoundingSphere_default,
  BoundingSphereState: () => BoundingSphereState_default,
  BoundingVolumeSemantics: () => BoundingVolumeSemantics_default,
  BoxEmitter: () => BoxEmitter_default,
  BoxGeometry: () => BoxGeometry_default,
  BoxGeometryUpdater: () => BoxGeometryUpdater_default,
  BoxGraphics: () => BoxGraphics_default,
  BoxOutlineGeometry: () => BoxOutlineGeometry_default,
  BrdfLutGenerator: () => BrdfLutGenerator_default,
  Buffer: () => Buffer_default,
  BufferLoader: () => BufferLoader_default,
  BufferUsage: () => BufferUsage_default,
  CPUStylingPipelineStage: () => CPUStylingPipelineStage_default,
  CallbackPositionProperty: () => CallbackPositionProperty_default,
  CallbackProperty: () => CallbackProperty_default,
  Camera: () => Camera_default,
  CameraEventAggregator: () => CameraEventAggregator_default,
  CameraEventType: () => CameraEventType_default,
  CameraFlightPath: () => CameraFlightPath_default,
  Cartesian2: () => Cartesian2_default,
  Cartesian3: () => Cartesian3_default,
  Cartesian4: () => Cartesian4_default,
  CartesianRectangle: () => CartesianRectangle_default,
  Cartographic: () => Cartographic_default,
  CartographicGeocoderService: () => CartographicGeocoderService_default,
  CatmullRomSpline: () => CatmullRomSpline_default,
  Cesium3DContentGroup: () => Cesium3DContentGroup_default,
  Cesium3DTile: () => Cesium3DTile_default,
  Cesium3DTileBatchTable: () => Cesium3DTileBatchTable_default,
  Cesium3DTileColorBlendMode: () => Cesium3DTileColorBlendMode_default,
  Cesium3DTileContent: () => Cesium3DTileContent_default,
  Cesium3DTileContentFactory: () => Cesium3DTileContentFactory_default,
  Cesium3DTileContentState: () => Cesium3DTileContentState_default,
  Cesium3DTileContentType: () => Cesium3DTileContentType_default,
  Cesium3DTileFeature: () => Cesium3DTileFeature_default,
  Cesium3DTileFeatureTable: () => Cesium3DTileFeatureTable_default,
  Cesium3DTileOptimizationHint: () => Cesium3DTileOptimizationHint_default,
  Cesium3DTileOptimizations: () => Cesium3DTileOptimizations_default,
  Cesium3DTilePass: () => Cesium3DTilePass_default,
  Cesium3DTilePassState: () => Cesium3DTilePassState_default,
  Cesium3DTilePointFeature: () => Cesium3DTilePointFeature_default,
  Cesium3DTileRefine: () => Cesium3DTileRefine_default,
  Cesium3DTileStyle: () => Cesium3DTileStyle_default,
  Cesium3DTileStyleEngine: () => Cesium3DTileStyleEngine_default,
  Cesium3DTilesInspector: () => Cesium3DTilesInspector_default,
  Cesium3DTilesInspectorViewModel: () => Cesium3DTilesInspectorViewModel_default,
  Cesium3DTilesTerrainData: () => Cesium3DTilesTerrainData_default,
  Cesium3DTilesTerrainGeometryProcessor: () => Cesium3DTilesTerrainGeometryProcessor_default,
  Cesium3DTilesTerrainProvider: () => Cesium3DTilesTerrainProvider_default,
  Cesium3DTilesVoxelProvider: () => Cesium3DTilesVoxelProvider_default,
  Cesium3DTileset: () => Cesium3DTileset_default,
  Cesium3DTilesetBaseTraversal: () => Cesium3DTilesetBaseTraversal_default,
  Cesium3DTilesetCache: () => Cesium3DTilesetCache_default,
  Cesium3DTilesetGraphics: () => Cesium3DTilesetGraphics_default,
  Cesium3DTilesetHeatmap: () => Cesium3DTilesetHeatmap_default,
  Cesium3DTilesetMetadata: () => Cesium3DTilesetMetadata_default,
  Cesium3DTilesetMostDetailedTraversal: () => Cesium3DTilesetMostDetailedTraversal_default,
  Cesium3DTilesetSkipTraversal: () => Cesium3DTilesetSkipTraversal_default,
  Cesium3DTilesetStatistics: () => Cesium3DTilesetStatistics_default,
  Cesium3DTilesetTraversal: () => Cesium3DTilesetTraversal_default,
  Cesium3DTilesetVisualizer: () => Cesium3DTilesetVisualizer_default,
  CesiumInspector: () => CesiumInspector_default,
  CesiumInspectorViewModel: () => CesiumInspectorViewModel_default,
  CesiumTerrainProvider: () => CesiumTerrainProvider_default,
  CesiumWidget: () => CesiumWidget_default,
  Check: () => Check_default,
  CheckerboardMaterialProperty: () => CheckerboardMaterialProperty_default,
  CircleEmitter: () => CircleEmitter_default,
  CircleGeometry: () => CircleGeometry_default,
  CircleOutlineGeometry: () => CircleOutlineGeometry_default,
  ClassificationModelDrawCommand: () => ClassificationModelDrawCommand_default,
  ClassificationPipelineStage: () => ClassificationPipelineStage_default,
  ClassificationPrimitive: () => ClassificationPrimitive_default,
  ClassificationType: () => ClassificationType_default,
  ClearCommand: () => ClearCommand_default,
  ClippingPlane: () => ClippingPlane_default,
  ClippingPlaneCollection: () => ClippingPlaneCollection_default,
  ClippingPolygon: () => ClippingPolygon_default,
  ClippingPolygonCollection: () => ClippingPolygonCollection_default,
  Clock: () => Clock_default,
  ClockRange: () => ClockRange_default,
  ClockStep: () => ClockStep_default,
  ClockViewModel: () => ClockViewModel_default,
  CloudCollection: () => CloudCollection_default,
  CloudType: () => CloudType_default,
  Color: () => Color_default,
  ColorBlendMode: () => ColorBlendMode_default,
  ColorGeometryInstanceAttribute: () => ColorGeometryInstanceAttribute_default,
  ColorMaterialProperty: () => ColorMaterialProperty_default,
  Command: () => Command_default,
  ComponentDatatype: () => ComponentDatatype_default,
  Composite3DTileContent: () => Composite3DTileContent_default,
  CompositeEntityCollection: () => CompositeEntityCollection_default,
  CompositeMaterialProperty: () => CompositeMaterialProperty_default,
  CompositePositionProperty: () => CompositePositionProperty_default,
  CompositeProperty: () => CompositeProperty_default,
  CompressedTextureBuffer: () => CompressedTextureBuffer_default,
  ComputeCommand: () => ComputeCommand_default,
  ComputeEngine: () => ComputeEngine_default,
  ConditionsExpression: () => ConditionsExpression_default,
  ConeEmitter: () => ConeEmitter_default,
  ConstantPositionProperty: () => ConstantPositionProperty_default,
  ConstantProperty: () => ConstantProperty_default,
  ConstantSpline: () => ConstantSpline_default,
  ContentMetadata: () => ContentMetadata_default,
  Context: () => Context_default,
  ContextLimits: () => ContextLimits_default,
  CoplanarPolygonGeometry: () => CoplanarPolygonGeometry_default,
  CoplanarPolygonGeometryLibrary: () => CoplanarPolygonGeometryLibrary_default,
  CoplanarPolygonOutlineGeometry: () => CoplanarPolygonOutlineGeometry_default,
  CornerType: () => CornerType_default,
  CorrelationGroup: () => CorrelationGroup_default,
  CorridorGeometry: () => CorridorGeometry_default,
  CorridorGeometryLibrary: () => CorridorGeometryLibrary_default,
  CorridorGeometryUpdater: () => CorridorGeometryUpdater_default,
  CorridorGraphics: () => CorridorGraphics_default,
  CorridorOutlineGeometry: () => CorridorOutlineGeometry_default,
  Credit: () => Credit_default,
  CreditDisplay: () => CreditDisplay_default,
  CubeMap: () => CubeMap_default,
  CubeMapFace: () => CubeMapFace_default,
  CubicRealPolynomial: () => CubicRealPolynomial_default,
  CullFace: () => CullFace_default,
  CullingVolume: () => CullingVolume_default,
  CumulusCloud: () => CumulusCloud_default,
  CustomDataSource: () => CustomDataSource_default,
  CustomHeightmapTerrainProvider: () => CustomHeightmapTerrainProvider_default,
  CustomShader: () => CustomShader_default,
  CustomShaderMode: () => CustomShaderMode_default,
  CustomShaderPipelineStage: () => CustomShaderPipelineStage_default,
  CustomShaderTranslucencyMode: () => CustomShaderTranslucencyMode_default,
  CylinderGeometry: () => CylinderGeometry_default,
  CylinderGeometryLibrary: () => CylinderGeometryLibrary_default,
  CylinderGeometryUpdater: () => CylinderGeometryUpdater_default,
  CylinderGraphics: () => CylinderGraphics_default,
  CylinderOutlineGeometry: () => CylinderOutlineGeometry_default,
  CzmlDataSource: () => CzmlDataSource_default,
  DataSource: () => DataSource_default,
  DataSourceClock: () => DataSourceClock_default,
  DataSourceCollection: () => DataSourceCollection_default,
  DataSourceDisplay: () => DataSourceDisplay_default,
  DebugAppearance: () => DebugAppearance_default,
  DebugCameraPrimitive: () => DebugCameraPrimitive_default,
  DebugInspector: () => DebugInspector_default,
  DebugModelMatrixPrimitive: () => DebugModelMatrixPrimitive_default,
  DefaultProxy: () => DefaultProxy_default,
  DepthFunction: () => DepthFunction_default,
  DepthPlane: () => DepthPlane_default,
  DequantizationPipelineStage: () => DequantizationPipelineStage_default,
  DerivedCommand: () => DerivedCommand_default,
  DeveloperError: () => DeveloperError_default,
  DeviceOrientationCameraController: () => DeviceOrientationCameraController_default,
  DirectionalLight: () => DirectionalLight_default,
  DiscardEmptyTileImagePolicy: () => DiscardEmptyTileImagePolicy_default,
  DiscardMissingTileImagePolicy: () => DiscardMissingTileImagePolicy_default,
  DistanceDisplayCondition: () => DistanceDisplayCondition_default,
  DistanceDisplayConditionGeometryInstanceAttribute: () => DistanceDisplayConditionGeometryInstanceAttribute_default,
  DoubleEndedPriorityQueue: () => DoubleEndedPriorityQueue_default,
  DoublyLinkedList: () => DoublyLinkedList_default,
  DracoLoader: () => DracoLoader_default,
  DrawCommand: () => DrawCommand_default,
  DynamicAtmosphereLightingType: () => DynamicAtmosphereLightingType_default,
  DynamicEnvironmentMapManager: () => DynamicEnvironmentMapManager_default,
  DynamicGeometryBatch: () => DynamicGeometryBatch_default,
  DynamicGeometryUpdater: () => DynamicGeometryUpdater_default,
  EarthOrientationParameters: () => EarthOrientationParameters_default,
  EarthOrientationParametersSample: () => EarthOrientationParametersSample_default,
  EasingFunction: () => EasingFunction_default,
  EdgeDetectionPipelineStage: () => EdgeDetectionPipelineStage_default,
  EdgeFramebuffer: () => EdgeFramebuffer_default,
  EdgeVisibilityPipelineStage: () => EdgeVisibilityPipelineStage_default,
  EllipseGeometry: () => EllipseGeometry_default,
  EllipseGeometryLibrary: () => EllipseGeometryLibrary_default,
  EllipseGeometryUpdater: () => EllipseGeometryUpdater_default,
  EllipseGraphics: () => EllipseGraphics_default,
  EllipseOutlineGeometry: () => EllipseOutlineGeometry_default,
  Ellipsoid: () => Ellipsoid_default,
  EllipsoidGeodesic: () => EllipsoidGeodesic_default,
  EllipsoidGeometry: () => EllipsoidGeometry_default,
  EllipsoidGeometryUpdater: () => EllipsoidGeometryUpdater_default,
  EllipsoidGraphics: () => EllipsoidGraphics_default,
  EllipsoidOutlineGeometry: () => EllipsoidOutlineGeometry_default,
  EllipsoidPrimitive: () => EllipsoidPrimitive_default,
  EllipsoidRhumbLine: () => EllipsoidRhumbLine_default,
  EllipsoidSurfaceAppearance: () => EllipsoidSurfaceAppearance_default,
  EllipsoidTangentPlane: () => EllipsoidTangentPlane_default,
  EllipsoidTerrainProvider: () => EllipsoidTerrainProvider_default,
  EllipsoidalOccluder: () => EllipsoidalOccluder_default,
  Empty3DTileContent: () => Empty3DTileContent_default,
  EncodedCartesian3: () => EncodedCartesian3_default,
  Entity: () => Entity_default,
  EntityCluster: () => EntityCluster_default,
  EntityCollection: () => EntityCollection_default,
  EntityView: () => EntityView_default,
  Event: () => Event_default,
  EventHelper: () => EventHelper_default,
  Expression: () => Expression_default,
  ExpressionNodeType: () => ExpressionNodeType_default,
  ExtrapolationType: () => ExtrapolationType_default,
  FeatureDetection: () => FeatureDetection_default,
  FeatureIdPipelineStage: () => FeatureIdPipelineStage_default,
  Fog: () => Fog_default,
  ForEach: () => ForEach_default,
  FrameRateMonitor: () => FrameRateMonitor_default,
  FrameState: () => FrameState_default,
  Framebuffer: () => Framebuffer_default,
  FramebufferManager: () => FramebufferManager_default,
  Frozen: () => Frozen_default,
  FrustumCommands: () => FrustumCommands_default,
  FrustumGeometry: () => FrustumGeometry_default,
  FrustumOutlineGeometry: () => FrustumOutlineGeometry_default,
  Fullscreen: () => Fullscreen_default,
  FullscreenButton: () => FullscreenButton_default,
  FullscreenButtonViewModel: () => FullscreenButtonViewModel_default,
  GaussianSplat3DTileContent: () => GaussianSplat3DTileContent_default,
  GaussianSplatPrimitive: () => GaussianSplatPrimitive_default,
  GaussianSplatRenderResources: () => GaussianSplatRenderResources_default,
  GaussianSplatSorter: () => GaussianSplatSorter_default,
  GaussianSplatTextureGenerator: () => GaussianSplatTextureGenerator_default,
  GeoJsonDataSource: () => GeoJsonDataSource_default,
  GeoJsonLoader: () => GeoJsonLoader_default,
  GeocodeType: () => GeocodeType_default,
  Geocoder: () => Geocoder_default,
  GeocoderService: () => GeocoderService_default,
  GeocoderViewModel: () => GeocoderViewModel_default,
  GeographicProjection: () => GeographicProjection_default,
  GeographicTilingScheme: () => GeographicTilingScheme_default,
  Geometry: () => Geometry_default,
  Geometry3DTileContent: () => Geometry3DTileContent_default,
  GeometryAttribute: () => GeometryAttribute_default,
  GeometryAttributes: () => GeometryAttributes_default,
  GeometryFactory: () => GeometryFactory_default,
  GeometryInstance: () => GeometryInstance_default,
  GeometryInstanceAttribute: () => GeometryInstanceAttribute_default,
  GeometryOffsetAttribute: () => GeometryOffsetAttribute_default,
  GeometryPipeline: () => GeometryPipeline_default,
  GeometryPipelineStage: () => GeometryPipelineStage_default,
  GeometryType: () => GeometryType_default,
  GeometryUpdater: () => GeometryUpdater_default,
  GeometryUpdaterSet: () => GeometryUpdaterSet_default,
  GeometryVisualizer: () => GeometryVisualizer_default,
  GetFeatureInfoFormat: () => GetFeatureInfoFormat_default,
  Globe: () => Globe_default,
  GlobeDepth: () => GlobeDepth_default,
  GlobeSurfaceShaderSet: () => GlobeSurfaceShaderSet_default,
  GlobeSurfaceTile: () => GlobeSurfaceTile_default,
  GlobeSurfaceTileProvider: () => GlobeSurfaceTileProvider_default,
  GlobeTranslucency: () => GlobeTranslucency_default,
  GlobeTranslucencyFramebuffer: () => GlobeTranslucencyFramebuffer_default,
  GlobeTranslucencyState: () => GlobeTranslucencyState_default,
  GltfBufferViewLoader: () => GltfBufferViewLoader_default,
  GltfDracoLoader: () => GltfDracoLoader_default,
  GltfGpmLoader: () => GltfGpmLoader_default,
  GltfGpmLocal: () => GltfGpmLocal_default,
  GltfImageLoader: () => GltfImageLoader_default,
  GltfIndexBufferLoader: () => GltfIndexBufferLoader_default,
  GltfJsonLoader: () => GltfJsonLoader_default,
  GltfLoader: () => GltfLoader_default,
  GltfLoaderUtil: () => GltfLoaderUtil_default,
  GltfMeshPrimitiveGpmLoader: () => GltfMeshPrimitiveGpmLoader_default,
  GltfSpzLoader: () => GltfSpzLoader_default,
  GltfStructuralMetadataLoader: () => GltfStructuralMetadataLoader_default,
  GltfTextureLoader: () => GltfTextureLoader_default,
  GltfVertexBufferLoader: () => GltfVertexBufferLoader_default,
  Google2DImageryProvider: () => Google2DImageryProvider_default,
  GoogleEarthEnterpriseImageryProvider: () => GoogleEarthEnterpriseImageryProvider_default,
  GoogleEarthEnterpriseMapsProvider: () => GoogleEarthEnterpriseMapsProvider_default,
  GoogleEarthEnterpriseMetadata: () => GoogleEarthEnterpriseMetadata_default,
  GoogleEarthEnterpriseTerrainData: () => GoogleEarthEnterpriseTerrainData_default,
  GoogleEarthEnterpriseTerrainProvider: () => GoogleEarthEnterpriseTerrainProvider_default,
  GoogleEarthEnterpriseTileInformation: () => GoogleEarthEnterpriseTileInformation_default,
  GoogleGeocoderService: () => GoogleGeocoderService_default,
  GoogleMaps: () => GoogleMaps_default,
  GpxDataSource: () => GpxDataSource_default,
  GregorianDate: () => GregorianDate_default,
  GridImageryProvider: () => GridImageryProvider_default,
  GridMaterialProperty: () => GridMaterialProperty_default,
  GroundGeometryUpdater: () => GroundGeometryUpdater_default,
  GroundPolylineGeometry: () => GroundPolylineGeometry_default,
  GroundPolylinePrimitive: () => GroundPolylinePrimitive_default,
  GroundPrimitive: () => GroundPrimitive_default,
  GroupMetadata: () => GroupMetadata_default,
  HeadingPitchRange: () => HeadingPitchRange_default,
  HeadingPitchRoll: () => HeadingPitchRoll_default,
  Heap: () => Heap_default,
  HeightReference: () => HeightReference_default,
  HeightmapEncoding: () => HeightmapEncoding_default,
  HeightmapTerrainData: () => HeightmapTerrainData_default,
  HeightmapTessellator: () => HeightmapTessellator_default,
  HermitePolynomialApproximation: () => HermitePolynomialApproximation_default,
  HermiteSpline: () => HermiteSpline_default,
  HilbertOrder: () => HilbertOrder_default,
  HomeButton: () => HomeButton_default,
  HomeButtonViewModel: () => HomeButtonViewModel_default,
  HorizontalOrigin: () => HorizontalOrigin_default,
  I3SBuildingSceneLayerExplorer: () => I3SBuildingSceneLayerExplorer_default,
  I3SBuildingSceneLayerExplorerViewModel: () => I3SBuildingSceneLayerExplorerViewModel_default,
  I3SDataProvider: () => I3SDataProvider_default,
  I3SDecoder: () => I3SDecoder_default,
  I3SFeature: () => I3SFeature_default,
  I3SField: () => I3SField_default,
  I3SGeometry: () => I3SGeometry_default,
  I3SLayer: () => I3SLayer_default,
  I3SNode: () => I3SNode_default,
  I3SStatistics: () => I3SStatistics_default,
  I3SSublayer: () => I3SSublayer_default,
  I3SSymbology: () => I3SSymbology_default,
  I3dmLoader: () => I3dmLoader_default,
  I3dmParser: () => I3dmParser_default,
  ITwinData: () => ITwinData_default,
  ITwinPlatform: () => ITwinPlatform_default,
  Iau2000Orientation: () => Iau2000Orientation_default,
  Iau2006XysData: () => Iau2006XysData_default,
  Iau2006XysSample: () => Iau2006XysSample_default,
  IauOrientationAxes: () => IauOrientationAxes_default,
  IauOrientationParameters: () => IauOrientationParameters_default,
  ImageBasedLighting: () => ImageBasedLighting_default,
  ImageBasedLightingPipelineStage: () => ImageBasedLightingPipelineStage_default,
  ImageMaterialProperty: () => ImageMaterialProperty_default,
  Imagery: () => Imagery_default,
  ImageryConfiguration: () => ImageryConfiguration_default,
  ImageryCoverage: () => ImageryCoverage_default,
  ImageryFlags: () => ImageryFlags_default,
  ImageryInput: () => ImageryInput_default,
  ImageryLayer: () => ImageryLayer_default,
  ImageryLayerCollection: () => ImageryLayerCollection_default,
  ImageryLayerFeatureInfo: () => ImageryLayerFeatureInfo_default,
  ImageryPipelineStage: () => ImageryPipelineStage_default,
  ImageryProvider: () => ImageryProvider_default,
  ImageryState: () => ImageryState_default,
  Implicit3DTileContent: () => Implicit3DTileContent_default,
  ImplicitAvailabilityBitstream: () => ImplicitAvailabilityBitstream_default,
  ImplicitMetadataView: () => ImplicitMetadataView_default,
  ImplicitSubdivisionScheme: () => ImplicitSubdivisionScheme_default,
  ImplicitSubtree: () => ImplicitSubtree_default,
  ImplicitSubtreeCache: () => ImplicitSubtreeCache_default,
  ImplicitSubtreeMetadata: () => ImplicitSubtreeMetadata_default,
  ImplicitTileCoordinates: () => ImplicitTileCoordinates_default,
  ImplicitTileset: () => ImplicitTileset_default,
  IndexDatatype: () => IndexDatatype_default,
  InfoBox: () => InfoBox_default,
  InfoBoxViewModel: () => InfoBoxViewModel_default,
  InspectorShared: () => InspectorShared_default,
  InstanceAttributeSemantic: () => InstanceAttributeSemantic_default,
  InstancingPipelineStage: () => InstancingPipelineStage_default,
  InterpolationAlgorithm: () => InterpolationAlgorithm_default,
  InterpolationType: () => InterpolationType_default,
  Intersect: () => Intersect_default,
  IntersectionTests: () => IntersectionTests_default,
  Intersections2D: () => Intersections2D_default,
  Interval: () => Interval_default,
  InvertClassification: () => InvertClassification_default,
  Ion: () => Ion_default,
  IonGeocodeProviderType: () => IonGeocodeProviderType_default,
  IonGeocoderService: () => IonGeocoderService_default,
  IonImageryProvider: () => IonImageryProvider_default,
  IonImageryProviderFactory: () => IonImageryProviderFactory_default,
  IonResource: () => IonResource_default,
  IonWorldImageryStyle: () => IonWorldImageryStyle_default,
  Iso8601: () => Iso8601_default,
  JobScheduler: () => JobScheduler_default,
  JobType: () => JobType_default,
  JsonMetadataTable: () => JsonMetadataTable_default,
  JulianDate: () => JulianDate_default,
  KTX2Transcoder: () => KTX2Transcoder_default,
  KeyboardEventModifier: () => KeyboardEventModifier_default,
  KeyframeNode: () => KeyframeNode_default,
  KmlCamera: () => KmlCamera_default,
  KmlDataSource: () => KmlDataSource_default,
  KmlLookAt: () => KmlLookAt_default,
  KmlTour: () => KmlTour_default,
  KmlTourFlyTo: () => KmlTourFlyTo_default,
  KmlTourWait: () => KmlTourWait_default,
  Label: () => Label_default,
  LabelCollection: () => LabelCollection_default,
  LabelGraphics: () => LabelGraphics_default,
  LabelStyle: () => LabelStyle_default,
  LabelVisualizer: () => LabelVisualizer_default,
  LagrangePolynomialApproximation: () => LagrangePolynomialApproximation_default,
  LeapSecond: () => LeapSecond_default,
  Light: () => Light_default,
  LightingModel: () => LightingModel_default,
  LightingPipelineStage: () => LightingPipelineStage_default,
  LinearApproximation: () => LinearApproximation_default,
  LinearSpline: () => LinearSpline_default,
  ManagedArray: () => ManagedArray_default,
  MapMode2D: () => MapMode2D_default,
  MapProjection: () => MapProjection_default,
  MapboxImageryProvider: () => MapboxImageryProvider_default,
  MapboxStyleImageryProvider: () => MapboxStyleImageryProvider_default,
  MappedPositions: () => MappedPositions_default,
  Material: () => Material_default,
  MaterialAppearance: () => MaterialAppearance_default,
  MaterialPipelineStage: () => MaterialPipelineStage_default,
  MaterialProperty: () => MaterialProperty_default,
  Math: () => Math_default,
  Matrix2: () => Matrix2_default,
  Matrix3: () => Matrix3_default,
  Matrix4: () => Matrix4_default,
  Megatexture: () => Megatexture_default2,
  MeshPrimitiveGpmLocal: () => MeshPrimitiveGpmLocal_default,
  MetadataClass: () => MetadataClass_default,
  MetadataClassProperty: () => MetadataClassProperty_default,
  MetadataComponentType: () => MetadataComponentType_default,
  MetadataEntity: () => MetadataEntity_default,
  MetadataEnum: () => MetadataEnum_default,
  MetadataEnumValue: () => MetadataEnumValue_default,
  MetadataPicking: () => MetadataPicking_default,
  MetadataPickingPipelineStage: () => MetadataPickingPipelineStage_default,
  MetadataPipelineStage: () => MetadataPipelineStage_default,
  MetadataSchema: () => MetadataSchema_default,
  MetadataSchemaLoader: () => MetadataSchemaLoader_default,
  MetadataSemantic: () => MetadataSemantic_default,
  MetadataTable: () => MetadataTable_default,
  MetadataTableProperty: () => MetadataTableProperty_default,
  MetadataType: () => MetadataType_default,
  MipmapHint: () => MipmapHint_default,
  Model: () => Model_default,
  Model3DTileContent: () => Model3DTileContent_default,
  ModelAlphaOptions: () => ModelAlphaOptions_default,
  ModelAnimation: () => ModelAnimation_default,
  ModelAnimationChannel: () => ModelAnimationChannel_default,
  ModelAnimationCollection: () => ModelAnimationCollection_default,
  ModelAnimationLoop: () => ModelAnimationLoop_default,
  ModelAnimationState: () => ModelAnimationState_default,
  ModelArticulation: () => ModelArticulation_default,
  ModelArticulationStage: () => ModelArticulationStage_default,
  ModelClippingPlanesPipelineStage: () => ModelClippingPlanesPipelineStage_default,
  ModelClippingPolygonsPipelineStage: () => ModelClippingPolygonsPipelineStage_default,
  ModelColorPipelineStage: () => ModelColorPipelineStage_default,
  ModelComponents: () => ModelComponents_default,
  ModelDrawCommand: () => ModelDrawCommand_default,
  ModelDrawCommands: () => ModelDrawCommands_default,
  ModelFeature: () => ModelFeature_default,
  ModelFeatureTable: () => ModelFeatureTable_default,
  ModelGraphics: () => ModelGraphics_default,
  ModelImagery: () => ModelImagery_default,
  ModelImageryMapping: () => ModelImageryMapping_default,
  ModelLightingOptions: () => ModelLightingOptions_default,
  ModelMatrixUpdateStage: () => ModelMatrixUpdateStage_default,
  ModelNode: () => ModelNode_default,
  ModelPrimitiveImagery: () => ModelPrimitiveImagery_default,
  ModelReader: () => ModelReader_default,
  ModelRenderResources: () => ModelRenderResources_default,
  ModelRuntimeNode: () => ModelRuntimeNode_default,
  ModelRuntimePrimitive: () => ModelRuntimePrimitive_default,
  ModelSceneGraph: () => ModelSceneGraph_default,
  ModelSilhouettePipelineStage: () => ModelSilhouettePipelineStage_default,
  ModelSkin: () => ModelSkin_default,
  ModelSplitterPipelineStage: () => ModelSplitterPipelineStage_default,
  ModelStatistics: () => ModelStatistics_default,
  ModelType: () => ModelType_default,
  ModelUtility: () => ModelUtility_default,
  ModelVisualizer: () => ModelVisualizer_default,
  Moon: () => Moon_default,
  MorphTargetsPipelineStage: () => MorphTargetsPipelineStage_default,
  MorphWeightSpline: () => MorphWeightSpline_default,
  MortonOrder: () => MortonOrder_default,
  Multiple3DTileContent: () => Multiple3DTileContent_default,
  MultisampleFramebuffer: () => MultisampleFramebuffer_default,
  NavigationHelpButton: () => NavigationHelpButton_default,
  NavigationHelpButtonViewModel: () => NavigationHelpButtonViewModel_default,
  NearFarScalar: () => NearFarScalar_default,
  NeverTileDiscardPolicy: () => NeverTileDiscardPolicy_default,
  NodeRenderResources: () => NodeRenderResources_default,
  NodeStatisticsPipelineStage: () => NodeStatisticsPipelineStage_default,
  NodeTransformationProperty: () => NodeTransformationProperty_default,
  OIT: () => OIT_default,
  Occluder: () => Occluder_default,
  OffsetGeometryInstanceAttribute: () => OffsetGeometryInstanceAttribute_default,
  OpenCageGeocoderService: () => OpenCageGeocoderService_default,
  OpenStreetMapImageryProvider: () => OpenStreetMapImageryProvider_default,
  OrderedGroundPrimitiveCollection: () => OrderedGroundPrimitiveCollection_default,
  OrientedBoundingBox: () => OrientedBoundingBox_default,
  OrthographicFrustum: () => OrthographicFrustum_default,
  OrthographicOffCenterFrustum: () => OrthographicOffCenterFrustum_default,
  Packable: () => Packable_default,
  PackableForInterpolation: () => PackableForInterpolation_default,
  Particle: () => Particle_default,
  ParticleBurst: () => ParticleBurst_default,
  ParticleEmitter: () => ParticleEmitter_default,
  ParticleSystem: () => ParticleSystem_default,
  Pass: () => Pass_default,
  PassState: () => PassState_default,
  PathGraphics: () => PathGraphics_default,
  PathVisualizer: () => PathVisualizer_default,
  PeliasGeocoderService: () => PeliasGeocoderService_default,
  PerInstanceColorAppearance: () => PerInstanceColorAppearance_default,
  PerformanceDisplay: () => PerformanceDisplay_default,
  PerformanceWatchdog: () => PerformanceWatchdog_default,
  PerformanceWatchdogViewModel: () => PerformanceWatchdogViewModel_default,
  PerspectiveFrustum: () => PerspectiveFrustum_default,
  PerspectiveOffCenterFrustum: () => PerspectiveOffCenterFrustum_default,
  PickDepth: () => PickDepth_default,
  PickDepthFramebuffer: () => PickDepthFramebuffer_default,
  PickFramebuffer: () => PickFramebuffer_default,
  PickedMetadataInfo: () => PickedMetadataInfo_default,
  Picking: () => Picking_default,
  PickingPipelineStage: () => PickingPipelineStage_default,
  PinBuilder: () => PinBuilder_default,
  PixelDatatype: () => PixelDatatype_default,
  PixelFormat: () => PixelFormat_default,
  Plane: () => Plane_default,
  PlaneGeometry: () => PlaneGeometry_default,
  PlaneGeometryUpdater: () => PlaneGeometryUpdater_default,
  PlaneGraphics: () => PlaneGraphics_default,
  PlaneOutlineGeometry: () => PlaneOutlineGeometry_default,
  PntsLoader: () => PntsLoader_default,
  PntsParser: () => PntsParser_default,
  PointCloud: () => PointCloud_default,
  PointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default2,
  PointCloudShading: () => PointCloudShading_default,
  PointCloudStylingPipelineStage: () => PointCloudStylingPipelineStage_default,
  PointGraphics: () => PointGraphics_default,
  PointPrimitive: () => PointPrimitive_default,
  PointPrimitiveCollection: () => PointPrimitiveCollection_default,
  PointVisualizer: () => PointVisualizer_default,
  PolygonGeometry: () => PolygonGeometry_default,
  PolygonGeometryLibrary: () => PolygonGeometryLibrary_default,
  PolygonGeometryUpdater: () => PolygonGeometryUpdater_default,
  PolygonGraphics: () => PolygonGraphics_default,
  PolygonHierarchy: () => PolygonHierarchy_default,
  PolygonOutlineGeometry: () => PolygonOutlineGeometry_default,
  PolygonPipeline: () => PolygonPipeline_default,
  Polyline: () => Polyline_default,
  PolylineArrowMaterialProperty: () => PolylineArrowMaterialProperty_default,
  PolylineCollection: () => PolylineCollection_default,
  PolylineColorAppearance: () => PolylineColorAppearance_default,
  PolylineDashMaterialProperty: () => PolylineDashMaterialProperty_default,
  PolylineGeometry: () => PolylineGeometry_default,
  PolylineGeometryUpdater: () => PolylineGeometryUpdater_default,
  PolylineGlowMaterialProperty: () => PolylineGlowMaterialProperty_default,
  PolylineGraphics: () => PolylineGraphics_default,
  PolylineMaterialAppearance: () => PolylineMaterialAppearance_default,
  PolylineOutlineMaterialProperty: () => PolylineOutlineMaterialProperty_default,
  PolylinePipeline: () => PolylinePipeline_default,
  PolylineVisualizer: () => PolylineVisualizer_default,
  PolylineVolumeGeometry: () => PolylineVolumeGeometry_default,
  PolylineVolumeGeometryLibrary: () => PolylineVolumeGeometryLibrary_default,
  PolylineVolumeGeometryUpdater: () => PolylineVolumeGeometryUpdater_default,
  PolylineVolumeGraphics: () => PolylineVolumeGraphics_default,
  PolylineVolumeOutlineGeometry: () => PolylineVolumeOutlineGeometry_default,
  PositionProperty: () => PositionProperty_default,
  PositionPropertyArray: () => PositionPropertyArray_default,
  PostProcessStage: () => PostProcessStage_default,
  PostProcessStageCollection: () => PostProcessStageCollection_default,
  PostProcessStageComposite: () => PostProcessStageComposite_default,
  PostProcessStageLibrary: () => PostProcessStageLibrary_default,
  PostProcessStageSampleMode: () => PostProcessStageSampleMode_default,
  PostProcessStageTextureCache: () => PostProcessStageTextureCache_default,
  PpeMetadata: () => PpeMetadata_default,
  PpeSource: () => PpeSource_default,
  PpeTexture: () => PpeTexture_default,
  Primitive: () => Primitive_default,
  PrimitiveCollection: () => PrimitiveCollection_default,
  PrimitiveLoadPlan: () => PrimitiveLoadPlan_default,
  PrimitiveOutlineGenerator: () => PrimitiveOutlineGenerator_default,
  PrimitiveOutlinePipelineStage: () => PrimitiveOutlinePipelineStage_default,
  PrimitivePipeline: () => PrimitivePipeline_default,
  PrimitiveRenderResources: () => PrimitiveRenderResources_default,
  PrimitiveState: () => PrimitiveState_default,
  PrimitiveStatisticsPipelineStage: () => PrimitiveStatisticsPipelineStage_default,
  PrimitiveType: () => PrimitiveType_default,
  ProjectionPicker: () => ProjectionPicker_default,
  ProjectionPickerViewModel: () => ProjectionPickerViewModel_default,
  Property: () => Property_default,
  PropertyArray: () => PropertyArray_default,
  PropertyAttribute: () => PropertyAttribute_default,
  PropertyAttributeProperty: () => PropertyAttributeProperty_default,
  PropertyBag: () => PropertyBag_default,
  PropertyTable: () => PropertyTable_default,
  PropertyTexture: () => PropertyTexture_default,
  PropertyTextureProperty: () => PropertyTextureProperty_default,
  ProviderViewModel: () => ProviderViewModel_default,
  Proxy: () => Proxy_default,
  QuadraticRealPolynomial: () => QuadraticRealPolynomial_default,
  QuadtreeOccluders: () => QuadtreeOccluders_default,
  QuadtreePrimitive: () => QuadtreePrimitive_default,
  QuadtreeTile: () => QuadtreeTile_default,
  QuadtreeTileLoadState: () => QuadtreeTileLoadState_default,
  QuadtreeTileProvider: () => QuadtreeTileProvider_default,
  QuantizedMeshTerrainData: () => QuantizedMeshTerrainData_default,
  QuarticRealPolynomial: () => QuarticRealPolynomial_default,
  Quaternion: () => Quaternion_default,
  QuaternionSpline: () => QuaternionSpline_default,
  Queue: () => Queue_default,
  Ray: () => Ray_default,
  Rectangle: () => Rectangle_default,
  RectangleCollisionChecker: () => RectangleCollisionChecker_default,
  RectangleGeometry: () => RectangleGeometry_default,
  RectangleGeometryLibrary: () => RectangleGeometryLibrary_default,
  RectangleGeometryUpdater: () => RectangleGeometryUpdater_default,
  RectangleGraphics: () => RectangleGraphics_default,
  RectangleOutlineGeometry: () => RectangleOutlineGeometry_default,
  ReferenceFrame: () => ReferenceFrame_default,
  ReferenceProperty: () => ReferenceProperty_default,
  RenderState: () => RenderState_default,
  Renderbuffer: () => Renderbuffer_default,
  RenderbufferFormat: () => RenderbufferFormat_default,
  Request: () => Request_default,
  RequestErrorEvent: () => RequestErrorEvent_default,
  RequestScheduler: () => RequestScheduler_default,
  RequestState: () => RequestState_default,
  RequestType: () => RequestType_default,
  Resource: () => Resource_default,
  ResourceCache: () => ResourceCache_default,
  ResourceCacheKey: () => ResourceCacheKey_default,
  ResourceCacheStatistics: () => ResourceCacheStatistics_default,
  ResourceLoader: () => ResourceLoader_default,
  ResourceLoaderState: () => ResourceLoaderState_default,
  Rotation: () => Rotation_default,
  RuntimeError: () => RuntimeError_default,
  S2Cell: () => S2Cell_default,
  SDFSettings: () => SDFSettings_default,
  SampledPositionProperty: () => SampledPositionProperty_default,
  SampledProperty: () => SampledProperty_default,
  Sampler: () => Sampler_default,
  ScaledPositionProperty: () => ScaledPositionProperty_default,
  Scene: () => Scene_default,
  SceneFramebuffer: () => SceneFramebuffer_default,
  SceneMode: () => SceneMode_default,
  SceneMode2DPipelineStage: () => SceneMode2DPipelineStage_default,
  SceneModePicker: () => SceneModePicker_default,
  SceneModePickerViewModel: () => SceneModePickerViewModel_default,
  SceneTransforms: () => SceneTransforms_default,
  SceneTransitioner: () => SceneTransitioner_default,
  ScreenSpaceCameraController: () => ScreenSpaceCameraController_default,
  ScreenSpaceEventHandler: () => ScreenSpaceEventHandler_default,
  ScreenSpaceEventType: () => ScreenSpaceEventType_default,
  SelectedFeatureIdPipelineStage: () => SelectedFeatureIdPipelineStage_default,
  SelectionIndicator: () => SelectionIndicator_default,
  SelectionIndicatorViewModel: () => SelectionIndicatorViewModel_default,
  SensorVolumePortionToDisplay: () => SensorVolumePortionToDisplay_default,
  ShaderBuilder: () => ShaderBuilder_default,
  ShaderCache: () => ShaderCache_default,
  ShaderDestination: () => ShaderDestination_default,
  ShaderFunction: () => ShaderFunction_default,
  ShaderProgram: () => ShaderProgram_default,
  ShaderSource: () => ShaderSource_default,
  ShaderStruct: () => ShaderStruct_default,
  ShadowMap: () => ShadowMap_default,
  ShadowMapShader: () => ShadowMapShader_default,
  ShadowMode: () => ShadowMode_default,
  ShadowVolumeAppearance: () => ShadowVolumeAppearance_default,
  SharedContext: () => SharedContext_default,
  ShowGeometryInstanceAttribute: () => ShowGeometryInstanceAttribute_default,
  Simon1994PlanetaryPositions: () => Simon1994PlanetaryPositions_default,
  SimplePolylineGeometry: () => SimplePolylineGeometry_default,
  SingleTileImageryProvider: () => SingleTileImageryProvider_default,
  SkinningPipelineStage: () => SkinningPipelineStage_default,
  SkyAtmosphere: () => SkyAtmosphere_default,
  SkyBox: () => SkyBox_default,
  SpatialNode: () => SpatialNode_default,
  Spdcf: () => Spdcf_default,
  SpecularEnvironmentCubeMap: () => SpecularEnvironmentCubeMap_default,
  SphereEmitter: () => SphereEmitter_default,
  SphereGeometry: () => SphereGeometry_default,
  SphereOutlineGeometry: () => SphereOutlineGeometry_default,
  Spherical: () => Spherical_default,
  Spline: () => Spline_default,
  SplitDirection: () => SplitDirection_default,
  Splitter: () => Splitter_default,
  StaticGeometryColorBatch: () => StaticGeometryColorBatch_default,
  StaticGeometryPerMaterialBatch: () => StaticGeometryPerMaterialBatch_default,
  StaticGroundGeometryColorBatch: () => StaticGroundGeometryColorBatch_default,
  StaticGroundGeometryPerMaterialBatch: () => StaticGroundGeometryPerMaterialBatch_default,
  StaticGroundPolylinePerMaterialBatch: () => StaticGroundPolylinePerMaterialBatch_default,
  StaticOutlineGeometryBatch: () => StaticOutlineGeometryBatch_default,
  StencilConstants: () => StencilConstants_default,
  StencilFunction: () => StencilFunction_default,
  StencilOperation: () => StencilOperation_default,
  SteppedSpline: () => SteppedSpline_default,
  Stereographic: () => Stereographic_default,
  StorageType: () => StorageType_default,
  StripeMaterialProperty: () => StripeMaterialProperty_default,
  StripeOrientation: () => StripeOrientation_default,
  StructuralMetadata: () => StructuralMetadata_default,
  StyleCommandsNeeded: () => StyleCommandsNeeded_default,
  StyleExpression: () => StyleExpression_default,
  Sun: () => Sun_default,
  SunLight: () => SunLight_default,
  SunPostProcess: () => SunPostProcess_default,
  SupportedImageFormats: () => SupportedImageFormats_default,
  SvgPathBindingHandler: () => SvgPathBindingHandler_default,
  Sync: () => Sync_default,
  TaskProcessor: () => TaskProcessor_default,
  Terrain: () => Terrain_default,
  TerrainData: () => TerrainData_default,
  TerrainEncoding: () => TerrainEncoding_default,
  TerrainFillMesh: () => TerrainFillMesh_default,
  TerrainMesh: () => TerrainMesh_default,
  TerrainOffsetProperty: () => TerrainOffsetProperty_default,
  TerrainPicker: () => TerrainPicker_default,
  TerrainProvider: () => TerrainProvider_default,
  TerrainQuantization: () => TerrainQuantization_default,
  TerrainState: () => TerrainState_default,
  Texture: () => Texture_default,
  Texture3D: () => Texture3D_default,
  TextureAtlas: () => TextureAtlas_default,
  TextureCache: () => TextureCache_default,
  TextureMagnificationFilter: () => TextureMagnificationFilter_default,
  TextureManager: () => TextureManager_default,
  TextureMinificationFilter: () => TextureMinificationFilter_default,
  TexturePacker: () => TexturePacker_default,
  TextureUniform: () => TextureUniform_default,
  TextureWrap: () => TextureWrap_default,
  TileAvailability: () => TileAvailability_default,
  TileBoundingRegion: () => TileBoundingRegion_default,
  TileBoundingS2Cell: () => TileBoundingS2Cell_default,
  TileBoundingSphere: () => TileBoundingSphere_default,
  TileBoundingVolume: () => TileBoundingVolume_default,
  TileCoordinatesImageryProvider: () => TileCoordinatesImageryProvider_default,
  TileDiscardPolicy: () => TileDiscardPolicy_default,
  TileEdge: () => TileEdge_default,
  TileImagery: () => TileImagery_default,
  TileMapServiceImageryProvider: () => TileMapServiceImageryProvider_default,
  TileMetadata: () => TileMetadata_default,
  TileOrientedBoundingBox: () => TileOrientedBoundingBox_default,
  TileProviderError: () => TileProviderError_default,
  TileReplacementQueue: () => TileReplacementQueue_default,
  TileSelectionResult: () => TileSelectionResult_default,
  TileState: () => TileState_default,
  Tileset3DTileContent: () => Tileset3DTileContent_default,
  TilesetMetadata: () => TilesetMetadata_default,
  TilesetPipelineStage: () => TilesetPipelineStage_default,
  TilingScheme: () => TilingScheme_default,
  TimeConstants: () => TimeConstants_default,
  TimeDynamicImagery: () => TimeDynamicImagery_default,
  TimeDynamicPointCloud: () => TimeDynamicPointCloud_default,
  TimeInterval: () => TimeInterval_default,
  TimeIntervalCollection: () => TimeIntervalCollection_default,
  TimeIntervalCollectionPositionProperty: () => TimeIntervalCollectionPositionProperty_default,
  TimeIntervalCollectionProperty: () => TimeIntervalCollectionProperty_default,
  TimeStandard: () => TimeStandard_default,
  Timeline: () => Timeline_default,
  TimelineHighlightRange: () => TimelineHighlightRange_default,
  TimelineTrack: () => TimelineTrack_default,
  Tipsify: () => Tipsify_default,
  ToggleButtonViewModel: () => ToggleButtonViewModel_default,
  Tonemapper: () => Tonemapper_default,
  TrackingReferenceFrame: () => TrackingReferenceFrame_default,
  Transforms: () => Transforms_default,
  TranslationRotationScale: () => TranslationRotationScale_default,
  TranslucentTileClassification: () => TranslucentTileClassification_default,
  TridiagonalSystemSolver: () => TridiagonalSystemSolver_default,
  TrustedServers: () => TrustedServers_default,
  TweenCollection: () => TweenCollection_default,
  UniformState: () => UniformState_default,
  UniformType: () => UniformType_default,
  UrlTemplateImageryProvider: () => UrlTemplateImageryProvider_default,
  VERSION: () => VERSION2,
  VRButton: () => VRButton_default,
  VRButtonViewModel: () => VRButtonViewModel_default,
  VRTheWorldTerrainProvider: () => VRTheWorldTerrainProvider_default,
  VaryingType: () => VaryingType_default,
  Vector3DTileBatch: () => Vector3DTileBatch_default,
  Vector3DTileClampedPolylines: () => Vector3DTileClampedPolylines_default,
  Vector3DTileContent: () => Vector3DTileContent_default,
  Vector3DTileGeometry: () => Vector3DTileGeometry_default,
  Vector3DTilePoints: () => Vector3DTilePoints_default,
  Vector3DTilePolygons: () => Vector3DTilePolygons_default,
  Vector3DTilePolylines: () => Vector3DTilePolylines_default,
  Vector3DTilePrimitive: () => Vector3DTilePrimitive_default,
  VelocityOrientationProperty: () => VelocityOrientationProperty_default,
  VelocityVectorProperty: () => VelocityVectorProperty_default,
  VertexArray: () => VertexArray_default,
  VertexArrayFacade: () => VertexArrayFacade_default,
  VertexAttributeSemantic: () => VertexAttributeSemantic_default,
  VertexFormat: () => VertexFormat_default,
  VerticalExaggeration: () => VerticalExaggeration_default,
  VerticalExaggerationPipelineStage: () => VerticalExaggerationPipelineStage_default,
  VerticalOrigin: () => VerticalOrigin_default,
  VideoSynchronizer: () => VideoSynchronizer_default,
  View: () => View_default,
  Viewer: () => Viewer_default,
  ViewportQuad: () => ViewportQuad_default,
  Visibility: () => Visibility_default,
  Visualizer: () => Visualizer_default,
  VoxelBoundsCollection: () => VoxelBoundsCollection_default,
  VoxelBoxShape: () => VoxelBoxShape_default,
  VoxelCell: () => VoxelCell_default,
  VoxelContent: () => VoxelContent_default,
  VoxelCylinderShape: () => VoxelCylinderShape_default,
  VoxelEllipsoidShape: () => VoxelEllipsoidShape_default,
  VoxelInspector: () => VoxelInspector_default,
  VoxelInspectorViewModel: () => VoxelInspectorViewModel_default,
  VoxelMetadataOrder: () => VoxelMetadataOrder_default,
  VoxelPrimitive: () => VoxelPrimitive_default,
  VoxelProvider: () => VoxelProvider_default,
  VoxelRenderResources: () => VoxelRenderResources_default,
  VoxelShape: () => VoxelShape_default,
  VoxelShapeType: () => VoxelShapeType_default,
  VoxelTraversal: () => VoxelTraversal_default,
  VulkanConstants: () => VulkanConstants_default,
  WallGeometry: () => WallGeometry_default,
  WallGeometryLibrary: () => WallGeometryLibrary_default,
  WallGeometryUpdater: () => WallGeometryUpdater_default,
  WallGraphics: () => WallGraphics_default,
  WallOutlineGeometry: () => WallOutlineGeometry_default,
  WebGLConstants: () => WebGLConstants_default,
  WebMapServiceImageryProvider: () => WebMapServiceImageryProvider_default,
  WebMapTileServiceImageryProvider: () => WebMapTileServiceImageryProvider_default,
  WebMercatorProjection: () => WebMercatorProjection_default,
  WebMercatorTilingScheme: () => WebMercatorTilingScheme_default,
  WindingOrder: () => WindingOrder_default,
  WireframeIndexGenerator: () => WireframeIndexGenerator_default,
  WireframePipelineStage: () => WireframePipelineStage_default,
  _shadersAcesTonemappingStage: () => AcesTonemappingStage_default,
  _shadersAdditiveBlend: () => AdditiveBlend_default,
  _shadersAdjustTranslucentFS: () => AdjustTranslucentFS_default,
  _shadersAllMaterialAppearanceFS: () => AllMaterialAppearanceFS_default,
  _shadersAllMaterialAppearanceVS: () => AllMaterialAppearanceVS_default,
  _shadersAmbientOcclusionGenerate: () => AmbientOcclusionGenerate_default,
  _shadersAmbientOcclusionModulate: () => AmbientOcclusionModulate_default,
  _shadersAspectRampMaterial: () => AspectRampMaterial_default,
  _shadersAtmosphereCommon: () => AtmosphereCommon_default,
  _shadersAtmosphereStageFS: () => AtmosphereStageFS_default,
  _shadersAtmosphereStageVS: () => AtmosphereStageVS_default,
  _shadersBasicMaterialAppearanceFS: () => BasicMaterialAppearanceFS_default,
  _shadersBasicMaterialAppearanceVS: () => BasicMaterialAppearanceVS_default,
  _shadersBillboardCollectionFS: () => BillboardCollectionFS_default,
  _shadersBillboardCollectionVS: () => BillboardCollectionVS_default,
  _shadersBlackAndWhite: () => BlackAndWhite_default,
  _shadersBloomComposite: () => BloomComposite_default,
  _shadersBrdfLutGeneratorFS: () => BrdfLutGeneratorFS_default,
  _shadersBrightPass: () => BrightPass_default,
  _shadersBrightness: () => Brightness_default,
  _shadersBumpMapMaterial: () => BumpMapMaterial_default,
  _shadersCPUStylingStageFS: () => CPUStylingStageFS_default,
  _shadersCPUStylingStageVS: () => CPUStylingStageVS_default,
  _shadersCheckerboardMaterial: () => CheckerboardMaterial_default,
  _shadersCloudCollectionFS: () => CloudCollectionFS_default,
  _shadersCloudCollectionVS: () => CloudCollectionVS_default,
  _shadersCloudNoiseFS: () => CloudNoiseFS_default,
  _shadersCloudNoiseVS: () => CloudNoiseVS_default,
  _shadersCompareAndPackTranslucentDepth: () => CompareAndPackTranslucentDepth_default,
  _shadersCompositeOITFS: () => CompositeOITFS_default,
  _shadersCompositeTranslucentClassification: () => CompositeTranslucentClassification_default,
  _shadersComputeIrradianceFS: () => ComputeIrradianceFS_default,
  _shadersComputeRadianceMapFS: () => ComputeRadianceMapFS_default,
  _shadersContrastBias: () => ContrastBias_default,
  _shadersConvolveSpecularMapFS: () => ConvolveSpecularMapFS_default,
  _shadersConvolveSpecularMapVS: () => ConvolveSpecularMapVS_default,
  _shadersCustomShaderStageFS: () => CustomShaderStageFS_default,
  _shadersCustomShaderStageVS: () => CustomShaderStageVS_default,
  _shadersCzmBuiltins: () => CzmBuiltins_default,
  _shadersDepthOfField: () => DepthOfField_default,
  _shadersDepthPlaneFS: () => DepthPlaneFS_default,
  _shadersDepthPlaneVS: () => DepthPlaneVS_default,
  _shadersDepthView: () => DepthView_default,
  _shadersDepthViewPacked: () => DepthViewPacked_default,
  _shadersDotMaterial: () => DotMaterial_default,
  _shadersEdgeDetection: () => EdgeDetection_default,
  _shadersEdgeDetectionStageFS: () => EdgeDetectionStageFS_default,
  _shadersEdgeVisibilityStageFS: () => EdgeVisibilityStageFS_default,
  _shadersElevationBandMaterial: () => ElevationBandMaterial_default,
  _shadersElevationContourMaterial: () => ElevationContourMaterial_default,
  _shadersElevationRampMaterial: () => ElevationRampMaterial_default,
  _shadersEllipsoidFS: () => EllipsoidFS_default,
  _shadersEllipsoidSurfaceAppearanceFS: () => EllipsoidSurfaceAppearanceFS_default,
  _shadersEllipsoidSurfaceAppearanceVS: () => EllipsoidSurfaceAppearanceVS_default,
  _shadersEllipsoidVS: () => EllipsoidVS_default,
  _shadersFXAA: () => FXAA_default,
  _shadersFXAA3_11: () => FXAA3_11_default,
  _shadersFadeMaterial: () => FadeMaterial_default,
  _shadersFeatureIdStageFS: () => FeatureIdStageFS_default,
  _shadersFeatureIdStageVS: () => FeatureIdStageVS_default,
  _shadersFilmicTonemapping: () => FilmicTonemapping_default,
  _shadersGaussianBlur1D: () => GaussianBlur1D_default,
  _shadersGeometryStageFS: () => GeometryStageFS_default,
  _shadersGeometryStageVS: () => GeometryStageVS_default,
  _shadersGlobeFS: () => GlobeFS_default,
  _shadersGlobeVS: () => GlobeVS_default,
  _shadersGridMaterial: () => GridMaterial_default,
  _shadersGroundAtmosphere: () => GroundAtmosphere_default,
  _shadersHSBToRGB: () => HSBToRGB_default,
  _shadersHSLToRGB: () => HSLToRGB_default,
  _shadersImageBasedLightingStageFS: () => ImageBasedLightingStageFS_default,
  _shadersInstancingStageCommon: () => InstancingStageCommon_default,
  _shadersInstancingStageVS: () => InstancingStageVS_default,
  _shadersIntersectBox: () => IntersectBox_default,
  _shadersIntersectCylinder: () => IntersectCylinder_default,
  _shadersIntersectDepth: () => IntersectDepth_default,
  _shadersIntersectEllipsoid: () => IntersectEllipsoid_default,
  _shadersIntersectLongitude: () => IntersectLongitude_default,
  _shadersIntersectPlane: () => IntersectPlane_default,
  _shadersIntersection: () => Intersection_default,
  _shadersIntersectionUtils: () => IntersectionUtils_default,
  _shadersLegacyInstancingStageVS: () => LegacyInstancingStageVS_default,
  _shadersLensFlare: () => LensFlare_default,
  _shadersLightingStageFS: () => LightingStageFS_default,
  _shadersMaterialStageFS: () => MaterialStageFS_default,
  _shadersMegatexture: () => Megatexture_default,
  _shadersMetadataStageFS: () => MetadataStageFS_default,
  _shadersMetadataStageVS: () => MetadataStageVS_default,
  _shadersModelClippingPlanesStageFS: () => ModelClippingPlanesStageFS_default,
  _shadersModelClippingPolygonsStageFS: () => ModelClippingPolygonsStageFS_default,
  _shadersModelClippingPolygonsStageVS: () => ModelClippingPolygonsStageVS_default,
  _shadersModelColorStageFS: () => ModelColorStageFS_default,
  _shadersModelFS: () => ModelFS_default,
  _shadersModelSilhouetteStageFS: () => ModelSilhouetteStageFS_default,
  _shadersModelSilhouetteStageVS: () => ModelSilhouetteStageVS_default,
  _shadersModelSplitterStageFS: () => ModelSplitterStageFS_default,
  _shadersModelVS: () => ModelVS_default,
  _shadersModifiedReinhardTonemapping: () => ModifiedReinhardTonemapping_default,
  _shadersMorphTargetsStageVS: () => MorphTargetsStageVS_default,
  _shadersNightVision: () => NightVision_default,
  _shadersNormalMapMaterial: () => NormalMapMaterial_default,
  _shadersOctree: () => Octree_default,
  _shadersPassThrough: () => PassThrough_default,
  _shadersPassThroughDepth: () => PassThroughDepth_default,
  _shadersPbrNeutralTonemapping: () => PbrNeutralTonemapping_default,
  _shadersPerInstanceColorAppearanceFS: () => PerInstanceColorAppearanceFS_default,
  _shadersPerInstanceColorAppearanceVS: () => PerInstanceColorAppearanceVS_default,
  _shadersPerInstanceFlatColorAppearanceFS: () => PerInstanceFlatColorAppearanceFS_default,
  _shadersPerInstanceFlatColorAppearanceVS: () => PerInstanceFlatColorAppearanceVS_default,
  _shadersPointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default,
  _shadersPointCloudStylingStageVS: () => PointCloudStylingStageVS_default,
  _shadersPointPrimitiveCollectionFS: () => PointPrimitiveCollectionFS_default,
  _shadersPointPrimitiveCollectionVS: () => PointPrimitiveCollectionVS_default,
  _shadersPolygonSignedDistanceFS: () => PolygonSignedDistanceFS_default,
  _shadersPolylineArrowMaterial: () => PolylineArrowMaterial_default,
  _shadersPolylineColorAppearanceVS: () => PolylineColorAppearanceVS_default,
  _shadersPolylineCommon: () => PolylineCommon_default,
  _shadersPolylineDashMaterial: () => PolylineDashMaterial_default,
  _shadersPolylineFS: () => PolylineFS_default,
  _shadersPolylineGlowMaterial: () => PolylineGlowMaterial_default,
  _shadersPolylineMaterialAppearanceVS: () => PolylineMaterialAppearanceVS_default,
  _shadersPolylineOutlineMaterial: () => PolylineOutlineMaterial_default,
  _shadersPolylineShadowVolumeFS: () => PolylineShadowVolumeFS_default,
  _shadersPolylineShadowVolumeMorphFS: () => PolylineShadowVolumeMorphFS_default,
  _shadersPolylineShadowVolumeMorphVS: () => PolylineShadowVolumeMorphVS_default,
  _shadersPolylineShadowVolumeVS: () => PolylineShadowVolumeVS_default,
  _shadersPolylineVS: () => PolylineVS_default,
  _shadersPrimitiveGaussianSplatFS: () => PrimitiveGaussianSplatFS_default,
  _shadersPrimitiveGaussianSplatVS: () => PrimitiveGaussianSplatVS_default,
  _shadersPrimitiveOutlineStageFS: () => PrimitiveOutlineStageFS_default,
  _shadersPrimitiveOutlineStageVS: () => PrimitiveOutlineStageVS_default,
  _shadersRGBToHSB: () => RGBToHSB_default,
  _shadersRGBToHSL: () => RGBToHSL_default,
  _shadersRGBToXYZ: () => RGBToXYZ_default,
  _shadersReinhardTonemapping: () => ReinhardTonemapping_default,
  _shadersReprojectWebMercatorFS: () => ReprojectWebMercatorFS_default,
  _shadersReprojectWebMercatorVS: () => ReprojectWebMercatorVS_default,
  _shadersRimLightingMaterial: () => RimLightingMaterial_default,
  _shadersSelectedFeatureIdStageCommon: () => SelectedFeatureIdStageCommon_default,
  _shadersShadowVolumeAppearanceFS: () => ShadowVolumeAppearanceFS_default,
  _shadersShadowVolumeAppearanceVS: () => ShadowVolumeAppearanceVS_default,
  _shadersShadowVolumeFS: () => ShadowVolumeFS_default,
  _shadersSilhouette: () => Silhouette_default,
  _shadersSkinningStageVS: () => SkinningStageVS_default,
  _shadersSkyAtmosphereCommon: () => SkyAtmosphereCommon_default,
  _shadersSkyAtmosphereFS: () => SkyAtmosphereFS_default,
  _shadersSkyAtmosphereVS: () => SkyAtmosphereVS_default,
  _shadersSkyBoxFS: () => SkyBoxFS_default,
  _shadersSkyBoxVS: () => SkyBoxVS_default,
  _shadersSlopeRampMaterial: () => SlopeRampMaterial_default,
  _shadersStripeMaterial: () => StripeMaterial_default,
  _shadersSunFS: () => SunFS_default,
  _shadersSunTextureFS: () => SunTextureFS_default,
  _shadersSunVS: () => SunVS_default,
  _shadersTexturedMaterialAppearanceFS: () => TexturedMaterialAppearanceFS_default,
  _shadersTexturedMaterialAppearanceVS: () => TexturedMaterialAppearanceVS_default,
  _shadersVector3DTileClampedPolylinesFS: () => Vector3DTileClampedPolylinesFS_default,
  _shadersVector3DTileClampedPolylinesVS: () => Vector3DTileClampedPolylinesVS_default,
  _shadersVector3DTilePolylinesVS: () => Vector3DTilePolylinesVS_default,
  _shadersVectorTileVS: () => VectorTileVS_default,
  _shadersVerticalExaggerationStageVS: () => VerticalExaggerationStageVS_default,
  _shadersViewportQuadFS: () => ViewportQuadFS_default,
  _shadersViewportQuadVS: () => ViewportQuadVS_default,
  _shadersVoxelFS: () => VoxelFS_default,
  _shadersVoxelUtils: () => VoxelUtils_default,
  _shadersVoxelVS: () => VoxelVS_default,
  _shadersWater: () => Water_default,
  _shadersWaterMaskMaterial: () => WaterMaskMaterial_default,
  _shadersXYZToRGB: () => XYZToRGB_default,
  _shadersacesTonemapping: () => acesTonemapping_default,
  _shadersalphaWeight: () => alphaWeight_default,
  _shadersantialias: () => antialias_default,
  _shadersapplyHSBShift: () => applyHSBShift_default,
  _shadersapproximateSphericalCoordinates: () => approximateSphericalCoordinates_default,
  _shadersapproximateTanh: () => approximateTanh_default,
  _shadersbackFacing: () => backFacing_default,
  _shadersbranchFreeTernary: () => branchFreeTernary_default,
  _shaderscascadeColor: () => cascadeColor_default,
  _shaderscascadeDistance: () => cascadeDistance_default,
  _shaderscascadeMatrix: () => cascadeMatrix_default,
  _shaderscascadeWeights: () => cascadeWeights_default,
  _shadersclipPolygons: () => clipPolygons_default,
  _shaderscolumbusViewMorph: () => columbusViewMorph_default,
  _shaderscomputeAtmosphereColor: () => computeAtmosphereColor_default,
  _shaderscomputeGroundAtmosphereScattering: () => computeGroundAtmosphereScattering_default,
  _shaderscomputePosition: () => computePosition_default,
  _shaderscomputeScattering: () => computeScattering_default,
  _shadersconvertLocalToBoxUv: () => convertLocalToBoxUv_default,
  _shadersconvertLocalToCylinderUv: () => convertLocalToCylinderUv_default,
  _shadersconvertLocalToEllipsoidUv: () => convertLocalToEllipsoidUv_default,
  _shaderscosineAndSine: () => cosineAndSine_default,
  _shadersdecompressTextureCoordinates: () => decompressTextureCoordinates_default,
  _shadersdegreesPerRadian: () => degreesPerRadian_default,
  _shadersdepthClamp: () => depthClamp_default,
  _shadersdepthRange: () => depthRange_default,
  _shadersdepthRangeStruct: () => depthRangeStruct_default,
  _shaderseastNorthUpToEyeCoordinates: () => eastNorthUpToEyeCoordinates_default,
  _shadersellipsoidContainsPoint: () => ellipsoidContainsPoint_default,
  _shadersellipsoidTextureCoordinates: () => ellipsoidTextureCoordinates_default,
  _shadersepsilon1: () => epsilon1_default,
  _shadersepsilon2: () => epsilon2_default,
  _shadersepsilon3: () => epsilon3_default,
  _shadersepsilon4: () => epsilon4_default,
  _shadersepsilon5: () => epsilon5_default,
  _shadersepsilon6: () => epsilon6_default,
  _shadersepsilon7: () => epsilon7_default,
  _shadersequalsEpsilon: () => equalsEpsilon_default,
  _shaderseyeOffset: () => eyeOffset_default,
  _shaderseyeToWindowCoordinates: () => eyeToWindowCoordinates_default,
  _shadersfastApproximateAtan: () => fastApproximateAtan_default,
  _shadersfog: () => fog_default,
  _shadersgammaCorrect: () => gammaCorrect_default,
  _shadersgeodeticSurfaceNormal: () => geodeticSurfaceNormal_default,
  _shadersgetDefaultMaterial: () => getDefaultMaterial_default,
  _shadersgetDynamicAtmosphereLightDirection: () => getDynamicAtmosphereLightDirection_default,
  _shadersgetLambertDiffuse: () => getLambertDiffuse_default,
  _shadersgetSpecular: () => getSpecular_default,
  _shadersgetWaterNoise: () => getWaterNoise_default,
  _shadershue: () => hue_default,
  _shadersinfinity: () => infinity_default,
  _shadersinverseGamma: () => inverseGamma_default,
  _shadersisEmpty: () => isEmpty_default,
  _shadersisFull: () => isFull_default,
  _shaderslatitudeToWebMercatorFraction: () => latitudeToWebMercatorFraction_default,
  _shaderslineDistance: () => lineDistance_default,
  _shaderslinearToSrgb: () => linearToSrgb_default,
  _shadersluminance: () => luminance_default,
  _shadersmaterial: () => material_default,
  _shadersmaterialInput: () => materialInput_default,
  _shadersmaximumComponent: () => maximumComponent_default,
  _shadersmetersPerPixel: () => metersPerPixel_default,
  _shadersmodelMaterial: () => modelMaterial_default,
  _shadersmodelToWindowCoordinates: () => modelToWindowCoordinates_default,
  _shadersmodelVertexOutput: () => modelVertexOutput_default,
  _shadersmultiplyWithColorBalance: () => multiplyWithColorBalance_default,
  _shadersnearFarScalar: () => nearFarScalar_default,
  _shadersoctDecode: () => octDecode_default,
  _shadersoneOverPi: () => oneOverPi_default,
  _shadersoneOverTwoPi: () => oneOverTwoPi_default,
  _shaderspackDepth: () => packDepth_default,
  _shaderspassCesium3DTile: () => passCesium3DTile_default,
  _shaderspassCesium3DTileClassification: () => passCesium3DTileClassification_default,
  _shaderspassCesium3DTileClassificationIgnoreShow: () => passCesium3DTileClassificationIgnoreShow_default,
  _shaderspassCesium3DTileEdges: () => passCesium3DTileEdges_default,
  _shaderspassClassification: () => passClassification_default,
  _shaderspassCompute: () => passCompute_default,
  _shaderspassEnvironment: () => passEnvironment_default,
  _shaderspassGaussianSplats: () => passGaussianSplats_default,
  _shaderspassGlobe: () => passGlobe_default,
  _shaderspassOpaque: () => passOpaque_default,
  _shaderspassOverlay: () => passOverlay_default,
  _shaderspassTerrainClassification: () => passTerrainClassification_default,
  _shaderspassTranslucent: () => passTranslucent_default,
  _shaderspassVoxels: () => passVoxels_default,
  _shaderspbrLighting: () => pbrLighting_default,
  _shaderspbrNeutralTonemapping: () => pbrNeutralTonemapping_default,
  _shadersphong: () => phong_default,
  _shaderspi: () => pi_default,
  _shaderspiOverFour: () => piOverFour_default,
  _shaderspiOverSix: () => piOverSix_default,
  _shaderspiOverThree: () => piOverThree_default,
  _shaderspiOverTwo: () => piOverTwo_default,
  _shadersplaneDistance: () => planeDistance_default,
  _shaderspointAlongRay: () => pointAlongRay_default,
  _shadersradiansPerDegree: () => radiansPerDegree_default,
  _shadersray: () => ray_default,
  _shadersrayEllipsoidIntersectionInterval: () => rayEllipsoidIntersectionInterval_default,
  _shadersraySegment: () => raySegment_default,
  _shadersraySphereIntersectionInterval: () => raySphereIntersectionInterval_default,
  _shadersreadDepth: () => readDepth_default,
  _shadersreadNonPerspective: () => readNonPerspective_default,
  _shadersreverseLogDepth: () => reverseLogDepth_default,
  _shadersround: () => round_default,
  _shaderssaturation: () => saturation_default,
  _shaderssceneMode2D: () => sceneMode2D_default,
  _shaderssceneMode3D: () => sceneMode3D_default,
  _shaderssceneModeColumbusView: () => sceneModeColumbusView_default,
  _shaderssceneModeMorphing: () => sceneModeMorphing_default,
  _shadersshadowDepthCompare: () => shadowDepthCompare_default,
  _shadersshadowParameters: () => shadowParameters_default,
  _shadersshadowVisibility: () => shadowVisibility_default,
  _shaderssignNotZero: () => signNotZero_default,
  _shaderssolarRadius: () => solarRadius_default,
  _shaderssphericalHarmonics: () => sphericalHarmonics_default,
  _shaderssrgbToLinear: () => srgbToLinear_default,
  _shaderstangentToEyeSpaceMatrix: () => tangentToEyeSpaceMatrix_default,
  _shaderstextureCube: () => textureCube_default,
  _shadersthreePiOver2: () => threePiOver2_default,
  _shaderstransformPlane: () => transformPlane_default,
  _shaderstranslateRelativeToEye: () => translateRelativeToEye_default,
  _shaderstranslucentPhong: () => translucentPhong_default,
  _shaderstranspose: () => transpose_default,
  _shaderstwoPi: () => twoPi_default,
  _shadersunpackClippingExtents: () => unpackClippingExtents_default,
  _shadersunpackDepth: () => unpackDepth_default,
  _shadersunpackFloat: () => unpackFloat_default,
  _shadersunpackUint: () => unpackUint_default,
  _shadersvalueTransform: () => valueTransform_default,
  _shadersvertexLogDepth: () => vertexLogDepth_default,
  _shaderswebMercatorMaxLatitude: () => webMercatorMaxLatitude_default,
  _shaderswindowToEyeCoordinates: () => windowToEyeCoordinates_default,
  _shaderswriteDepthClamp: () => writeDepthClamp_default,
  _shaderswriteLogDepth: () => writeLogDepth_default,
  _shaderswriteNonPerspective: () => writeNonPerspective_default,
  addAllToArray: () => addAllToArray_default,
  addBuffer: () => addBuffer_default,
  addDefaults: () => addDefaults_default,
  addExtensionsRequired: () => addExtensionsRequired_default,
  addExtensionsUsed: () => addExtensionsUsed_default,
  addPipelineExtras: () => addPipelineExtras_default,
  addToArray: () => addToArray_default,
  appendForwardSlash: () => appendForwardSlash_default,
  arrayRemoveDuplicates: () => arrayRemoveDuplicates_default,
  barycentricCoordinates: () => barycentricCoordinates_default,
  binarySearch: () => binarySearch_default,
  buildModuleUrl: () => buildModuleUrl_default,
  buildVoxelDrawCommands: () => buildVoxelDrawCommands_default,
  clone: () => clone_default,
  combine: () => combine_default,
  computeFlyToLocationForRectangle: () => computeFlyToLocationForRectangle_default,
  createBillboardPointCallback: () => createBillboardPointCallback_default,
  createCommand: () => createCommand_default,
  createDefaultImageryProviderViewModels: () => createDefaultImageryProviderViewModels_default,
  createDefaultTerrainProviderViewModels: () => createDefaultTerrainProviderViewModels_default,
  createElevationBandMaterial: () => createElevationBandMaterial_default,
  createGooglePhotorealistic3DTileset: () => createGooglePhotorealistic3DTileset_default,
  createGuid: () => createGuid_default,
  createMaterialPropertyDescriptor: () => createMaterialPropertyDescriptor_default,
  createOsmBuildingsAsync: () => createOsmBuildingsAsync_default,
  createPropertyDescriptor: () => createPropertyDescriptor_default,
  createRawPropertyDescriptor: () => createRawPropertyDescriptor_default,
  createTangentSpaceDebugPrimitive: () => createTangentSpaceDebugPrimitive_default,
  createTaskProcessorWorker: () => createTaskProcessorWorker_default,
  createUniform: () => createUniform_default,
  createUniformArray: () => createUniformArray_default,
  createWorldBathymetryAsync: () => createWorldBathymetryAsync_default,
  createWorldImageryAsync: () => createWorldImageryAsync_default,
  createWorldTerrainAsync: () => createWorldTerrainAsync_default,
  decodeGoogleEarthEnterpriseData: () => decodeGoogleEarthEnterpriseData_default,
  decodeVectorPolylinePositions: () => decodeVectorPolylinePositions_default,
  defer: () => defer_default,
  defined: () => defined_default,
  demodernizeShader: () => demodernizeShader_default,
  deprecationWarning: () => deprecationWarning_default,
  destroyObject: () => destroyObject_default,
  exportKml: () => exportKml_default,
  findAccessorMinMax: () => findAccessorMinMax_default,
  findContentMetadata: () => findContentMetadata_default,
  findGroupMetadata: () => findGroupMetadata_default,
  findTileMetadata: () => findTileMetadata_default,
  forEachTextureInMaterial: () => forEachTextureInMaterial_default,
  formatError: () => formatError_default,
  freezeRenderState: () => freezeRenderState_default,
  getAbsoluteUri: () => getAbsoluteUri_default,
  getAccessorByteStride: () => getAccessorByteStride_default,
  getBaseUri: () => getBaseUri_default,
  getBinaryAccessor: () => getBinaryAccessor_default,
  getClipAndStyleCode: () => getClipAndStyleCode_default,
  getClippingFunction: () => getClippingFunction_default,
  getComponentReader: () => getComponentReader_default,
  getElement: () => getElement_default,
  getExtensionFromUri: () => getExtensionFromUri_default,
  getFilenameFromUri: () => getFilenameFromUri_default,
  getImageFromTypedArray: () => getImageFromTypedArray_default,
  getImagePixels: () => getImagePixels_default,
  getJsonFromTypedArray: () => getJsonFromTypedArray_default,
  getMagic: () => getMagic_default,
  getMeshPrimitives: () => getMeshPrimitives_default,
  getMetadataClassProperty: () => getMetadataClassProperty_default,
  getMetadataProperty: () => getMetadataProperty_default,
  getStringFromTypedArray: () => getStringFromTypedArray_default,
  getTimestamp: () => getTimestamp_default,
  hasExtension: () => hasExtension_default,
  heightReferenceOnEntityPropertyChanged: () => heightReferenceOnEntityPropertyChanged_default,
  isBitSet: () => isBitSet_default,
  isBlobUri: () => isBlobUri_default,
  isCrossOriginUrl: () => isCrossOriginUrl_default,
  isDataUri: () => isDataUri_default,
  isLeapYear: () => isLeapYear_default,
  knockout: () => knockout_default,
  knockout_3_5_1: () => knockout_3_5_1_default,
  knockout_es5: () => knockout_es5_default,
  loadAndExecuteScript: () => loadAndExecuteScript_default,
  loadCubeMap: () => loadCubeMap_default,
  loadImageFromTypedArray: () => loadImageFromTypedArray_default,
  loadKTX2: () => loadKTX2_default,
  mergeSort: () => mergeSort_default,
  moveTechniqueRenderStates: () => moveTechniqueRenderStates_default,
  moveTechniquesToExtension: () => moveTechniquesToExtension_default,
  numberOfComponentsForType: () => numberOfComponentsForType_default,
  objectToQuery: () => objectToQuery_default,
  oneTimeWarning: () => oneTimeWarning_default,
  parseBatchTable: () => parseBatchTable_default,
  parseFeatureMetadataLegacy: () => parseFeatureMetadataLegacy_default,
  parseGlb: () => parseGlb_default,
  parseResponseHeaders: () => parseResponseHeaders_default,
  parseStructuralMetadata: () => parseStructuralMetadata_default,
  pickModel: () => pickModel,
  pointInsideTriangle: () => pointInsideTriangle_default,
  preprocess3DTileContent: () => preprocess3DTileContent_default,
  processVoxelProperties: () => processVoxelProperties_default,
  queryToObject: () => queryToObject_default,
  readAccessorPacked: () => readAccessorPacked_default,
  removeExtension: () => removeExtension_default,
  removeExtensionsRequired: () => removeExtensionsRequired_default,
  removeExtensionsUsed: () => removeExtensionsUsed_default,
  removePipelineExtras: () => removePipelineExtras_default,
  removeUnusedElements: () => removeUnusedElements_default,
  resizeImageToNextPowerOfTwo: () => resizeImageToNextPowerOfTwo_default,
  sampleTerrain: () => sampleTerrain_default,
  sampleTerrainMostDetailed: () => sampleTerrainMostDetailed_default,
  scaleToGeodeticSurface: () => scaleToGeodeticSurface_default,
  srgbToLinear: () => srgbToLinear_default2,
  subdivideArray: () => subdivideArray_default,
  subscribeAndEvaluate: () => subscribeAndEvaluate_default,
  updateAccessorComponentTypes: () => updateAccessorComponentTypes_default,
  updateVersion: () => updateVersion_default,
  usesExtension: () => usesExtension_default,
  viewerCesium3DTilesInspectorMixin: () => viewerCesium3DTilesInspectorMixin_default,
  viewerCesiumInspectorMixin: () => viewerCesiumInspectorMixin_default,
  viewerDragDropMixin: () => viewerDragDropMixin_default,
  viewerPerformanceWatchdogMixin: () => viewerPerformanceWatchdogMixin_default,
  viewerVoxelInspectorMixin: () => viewerVoxelInspectorMixin_default,
  webGLConstantToGlslType: () => webGLConstantToGlslType_default,
  wrapFunction: () => wrapFunction_default,
  writeTextToCanvas: () => writeTextToCanvas_default
});
module.exports = __toCommonJS(Cesium_exports);

// packages/engine/Source/Core/defined.js
function defined(value) {
  return value !== void 0 && value !== null;
}
var defined_default = defined;

// packages/engine/Source/Core/DeveloperError.js
function DeveloperError(message) {
  this.name = "DeveloperError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  DeveloperError.prototype = Object.create(Error.prototype);
  DeveloperError.prototype.constructor = DeveloperError;
}
DeveloperError.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
DeveloperError.throwInstantiationError = function() {
  throw new DeveloperError(
    "This function defines an interface and should not be called directly."
  );
};
var DeveloperError_default = DeveloperError;

// packages/engine/Source/Core/Check.js
var Check = {};
Check.typeOf = {};
function getUndefinedErrorMessage(name) {
  return `${name} is required, actual value was undefined`;
}
function getFailedTypeErrorMessage(actual, expected, name) {
  return `Expected ${name} to be typeof ${expected}, actual typeof was ${actual}`;
}
Check.defined = function(name, test) {
  if (!defined_default(test)) {
    throw new DeveloperError_default(getUndefinedErrorMessage(name));
  }
};
Check.typeOf.func = function(name, test) {
  if (typeof test !== "function") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "function", name)
    );
  }
};
Check.typeOf.string = function(name, test) {
  if (typeof test !== "string") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "string", name)
    );
  }
};
Check.typeOf.number = function(name, test) {
  if (typeof test !== "number") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "number", name)
    );
  }
};
Check.typeOf.number.lessThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test >= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.lessThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test > limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test <= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test < limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.object = function(name, test) {
  if (typeof test !== "object") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "object", name)
    );
  }
};
Check.typeOf.bool = function(name, test) {
  if (typeof test !== "boolean") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "boolean", name)
    );
  }
};
Check.typeOf.bigint = function(name, test) {
  if (typeof test !== "bigint") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "bigint", name)
    );
  }
};
Check.typeOf.number.equals = function(name1, name2, test1, test2) {
  Check.typeOf.number(name1, test1);
  Check.typeOf.number(name2, test2);
  if (test1 !== test2) {
    throw new DeveloperError_default(
      `${name1} must be equal to ${name2}, the actual values are ${test1} and ${test2}`
    );
  }
};
var Check_default = Check;

// packages/engine/Source/Core/Math.js
var import_mersenne_twister = __toESM(require_mersenne_twister(), 1);
var CesiumMath = {};
CesiumMath.EPSILON1 = 0.1;
CesiumMath.EPSILON2 = 0.01;
CesiumMath.EPSILON3 = 1e-3;
CesiumMath.EPSILON4 = 1e-4;
CesiumMath.EPSILON5 = 1e-5;
CesiumMath.EPSILON6 = 1e-6;
CesiumMath.EPSILON7 = 1e-7;
CesiumMath.EPSILON8 = 1e-8;
CesiumMath.EPSILON9 = 1e-9;
CesiumMath.EPSILON10 = 1e-10;
CesiumMath.EPSILON11 = 1e-11;
CesiumMath.EPSILON12 = 1e-12;
CesiumMath.EPSILON13 = 1e-13;
CesiumMath.EPSILON14 = 1e-14;
CesiumMath.EPSILON15 = 1e-15;
CesiumMath.EPSILON16 = 1e-16;
CesiumMath.EPSILON17 = 1e-17;
CesiumMath.EPSILON18 = 1e-18;
CesiumMath.EPSILON19 = 1e-19;
CesiumMath.EPSILON20 = 1e-20;
CesiumMath.EPSILON21 = 1e-21;
CesiumMath.GRAVITATIONALPARAMETER = 3986004418e5;
CesiumMath.SOLAR_RADIUS = 6955e5;
CesiumMath.LUNAR_RADIUS = 1737400;
CesiumMath.SIXTY_FOUR_KILOBYTES = 64 * 1024;
CesiumMath.FOUR_GIGABYTES = 4 * 1024 * 1024 * 1024;
CesiumMath.sign = Math.sign ?? function sign(value) {
  value = +value;
  if (value === 0 || value !== value) {
    return value;
  }
  return value > 0 ? 1 : -1;
};
CesiumMath.signNotZero = function(value) {
  return value < 0 ? -1 : 1;
};
CesiumMath.toSNorm = function(value, rangeMaximum) {
  rangeMaximum = rangeMaximum ?? 255;
  return Math.round(
    (CesiumMath.clamp(value, -1, 1) * 0.5 + 0.5) * rangeMaximum
  );
};
CesiumMath.fromSNorm = function(value, rangeMaximum) {
  rangeMaximum = rangeMaximum ?? 255;
  return CesiumMath.clamp(value, 0, rangeMaximum) / rangeMaximum * 2 - 1;
};
CesiumMath.normalize = function(value, rangeMinimum, rangeMaximum) {
  rangeMaximum = Math.max(rangeMaximum - rangeMinimum, 0);
  return rangeMaximum === 0 ? 0 : CesiumMath.clamp((value - rangeMinimum) / rangeMaximum, 0, 1);
};
CesiumMath.sinh = Math.sinh ?? function sinh(value) {
  return (Math.exp(value) - Math.exp(-value)) / 2;
};
CesiumMath.cosh = Math.cosh ?? function cosh(value) {
  return (Math.exp(value) + Math.exp(-value)) / 2;
};
CesiumMath.lerp = function(p, q, time) {
  return (1 - time) * p + time * q;
};
CesiumMath.PI = Math.PI;
CesiumMath.ONE_OVER_PI = 1 / Math.PI;
CesiumMath.PI_OVER_TWO = Math.PI / 2;
CesiumMath.PI_OVER_THREE = Math.PI / 3;
CesiumMath.PI_OVER_FOUR = Math.PI / 4;
CesiumMath.PI_OVER_SIX = Math.PI / 6;
CesiumMath.THREE_PI_OVER_TWO = 3 * Math.PI / 2;
CesiumMath.TWO_PI = 2 * Math.PI;
CesiumMath.ONE_OVER_TWO_PI = 1 / (2 * Math.PI);
CesiumMath.RADIANS_PER_DEGREE = Math.PI / 180;
CesiumMath.DEGREES_PER_RADIAN = 180 / Math.PI;
CesiumMath.RADIANS_PER_ARCSECOND = CesiumMath.RADIANS_PER_DEGREE / 3600;
CesiumMath.toRadians = function(degrees) {
  if (!defined_default(degrees)) {
    throw new DeveloperError_default("degrees is required.");
  }
  return degrees * CesiumMath.RADIANS_PER_DEGREE;
};
CesiumMath.toDegrees = function(radians) {
  if (!defined_default(radians)) {
    throw new DeveloperError_default("radians is required.");
  }
  return radians * CesiumMath.DEGREES_PER_RADIAN;
};
CesiumMath.convertLongitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  const twoPi = CesiumMath.TWO_PI;
  const simplified = angle - Math.floor(angle / twoPi) * twoPi;
  if (simplified < -Math.PI) {
    return simplified + twoPi;
  }
  if (simplified >= Math.PI) {
    return simplified - twoPi;
  }
  return simplified;
};
CesiumMath.clampToLatitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  return CesiumMath.clamp(
    angle,
    -1 * CesiumMath.PI_OVER_TWO,
    CesiumMath.PI_OVER_TWO
  );
};
CesiumMath.negativePiToPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= -CesiumMath.PI && angle <= CesiumMath.PI) {
    return angle;
  }
  return CesiumMath.zeroToTwoPi(angle + CesiumMath.PI) - CesiumMath.PI;
};
CesiumMath.zeroToTwoPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= 0 && angle <= CesiumMath.TWO_PI) {
    return angle;
  }
  const mod2 = CesiumMath.mod(angle, CesiumMath.TWO_PI);
  if (Math.abs(mod2) < CesiumMath.EPSILON14 && Math.abs(angle) > CesiumMath.EPSILON14) {
    return CesiumMath.TWO_PI;
  }
  return mod2;
};
CesiumMath.mod = function(m, n) {
  if (!defined_default(m)) {
    throw new DeveloperError_default("m is required.");
  }
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (n === 0) {
    throw new DeveloperError_default("divisor cannot be 0.");
  }
  if (CesiumMath.sign(m) === CesiumMath.sign(n) && Math.abs(m) < Math.abs(n)) {
    return m;
  }
  return (m % n + n) % n;
};
CesiumMath.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  relativeEpsilon = relativeEpsilon ?? 0;
  absoluteEpsilon = absoluteEpsilon ?? relativeEpsilon;
  const absDiff = Math.abs(left - right);
  return absDiff <= absoluteEpsilon || absDiff <= relativeEpsilon * Math.max(Math.abs(left), Math.abs(right));
};
CesiumMath.lessThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < -absoluteEpsilon;
};
CesiumMath.lessThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < absoluteEpsilon;
};
CesiumMath.greaterThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > absoluteEpsilon;
};
CesiumMath.greaterThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > -absoluteEpsilon;
};
var factorials = [1];
CesiumMath.factorial = function(n) {
  if (typeof n !== "number" || n < 0) {
    throw new DeveloperError_default(
      "A number greater than or equal to 0 is required."
    );
  }
  const length2 = factorials.length;
  if (n >= length2) {
    let sum = factorials[length2 - 1];
    for (let i = length2; i <= n; i++) {
      const next = sum * i;
      factorials.push(next);
      sum = next;
    }
  }
  return factorials[n];
};
CesiumMath.incrementWrap = function(n, maximumValue, minimumValue) {
  minimumValue = minimumValue ?? 0;
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (maximumValue <= minimumValue) {
    throw new DeveloperError_default("maximumValue must be greater than minimumValue.");
  }
  ++n;
  if (n > maximumValue) {
    n = minimumValue;
  }
  return n;
};
CesiumMath.isPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  return n !== 0 && (n & n - 1) === 0;
};
CesiumMath.nextPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 2147483648) {
    throw new DeveloperError_default("A number between 0 and 2^31 is required.");
  }
  --n;
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  ++n;
  return n;
};
CesiumMath.previousPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  n |= n >> 32;
  n = (n >>> 0) - (n >>> 1);
  return n;
};
CesiumMath.clamp = function(value, min3, max3) {
  Check_default.typeOf.number("value", value);
  Check_default.typeOf.number("min", min3);
  Check_default.typeOf.number("max", max3);
  return value < min3 ? min3 : value > max3 ? max3 : value;
};
var randomNumberGenerator = new import_mersenne_twister.default();
CesiumMath.setRandomNumberSeed = function(seed) {
  if (!defined_default(seed)) {
    throw new DeveloperError_default("seed is required.");
  }
  randomNumberGenerator = new import_mersenne_twister.default(seed);
};
CesiumMath.nextRandomNumber = function() {
  return randomNumberGenerator.random();
};
CesiumMath.randomBetween = function(min3, max3) {
  return CesiumMath.nextRandomNumber() * (max3 - min3) + min3;
};
CesiumMath.acosClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.acos(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.asinClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.asin(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.chordLength = function(angle, radius) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (!defined_default(radius)) {
    throw new DeveloperError_default("radius is required.");
  }
  return 2 * radius * Math.sin(angle * 0.5);
};
CesiumMath.logBase = function(number, base) {
  if (!defined_default(number)) {
    throw new DeveloperError_default("number is required.");
  }
  if (!defined_default(base)) {
    throw new DeveloperError_default("base is required.");
  }
  return Math.log(number) / Math.log(base);
};
CesiumMath.cbrt = Math.cbrt ?? function cbrt(number) {
  const result = Math.pow(Math.abs(number), 1 / 3);
  return number < 0 ? -result : result;
};
CesiumMath.log2 = Math.log2 ?? function log2(number) {
  return Math.log(number) * Math.LOG2E;
};
CesiumMath.fog = function(distanceToCamera, density) {
  const scalar = distanceToCamera * density;
  return 1 - Math.exp(-(scalar * scalar));
};
CesiumMath.fastApproximateAtan = function(x) {
  Check_default.typeOf.number("x", x);
  return x * (-0.1784 * Math.abs(x) - 0.0663 * x * x + 1.0301);
};
CesiumMath.fastApproximateAtan2 = function(x, y) {
  Check_default.typeOf.number("x", x);
  Check_default.typeOf.number("y", y);
  let opposite;
  let t = Math.abs(x);
  opposite = Math.abs(y);
  const adjacent = Math.max(t, opposite);
  opposite = Math.min(t, opposite);
  const oppositeOverAdjacent = opposite / adjacent;
  if (isNaN(oppositeOverAdjacent)) {
    throw new DeveloperError_default("either x or y must be nonzero");
  }
  t = CesiumMath.fastApproximateAtan(oppositeOverAdjacent);
  t = Math.abs(y) > Math.abs(x) ? CesiumMath.PI_OVER_TWO - t : t;
  t = x < 0 ? CesiumMath.PI - t : t;
  t = y < 0 ? -t : t;
  return t;
};
var Math_default = CesiumMath;

// packages/engine/Source/Core/Cartesian3.js
function Cartesian3(x, y, z) {
  this.x = x ?? 0;
  this.y = y ?? 0;
  this.z = z ?? 0;
}
Cartesian3.fromSpherical = function(spherical, result) {
  Check_default.typeOf.object("spherical", spherical);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  const clock = spherical.clock;
  const cone = spherical.cone;
  const magnitude = spherical.magnitude ?? 1;
  const radial = magnitude * Math.sin(cone);
  result.x = radial * Math.cos(clock);
  result.y = radial * Math.sin(clock);
  result.z = magnitude * Math.cos(cone);
  return result;
};
Cartesian3.fromElements = function(x, y, z, result) {
  if (!defined_default(result)) {
    return new Cartesian3(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian3(cartesian11.x, cartesian11.y, cartesian11.z);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  result.z = cartesian11.z;
  return result;
};
Cartesian3.fromCartesian4 = Cartesian3.clone;
Cartesian3.packedLength = 3;
Cartesian3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex] = value.z;
  return array;
};
Cartesian3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex];
  return result;
};
Cartesian3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 3;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 3 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Cartesian3.pack(array[i], result, i * 3);
  }
  return result;
};
Cartesian3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 3);
  if (array.length % 3 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 3.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 3);
  } else {
    result.length = length2 / 3;
  }
  for (let i = 0; i < length2; i += 3) {
    const index = i / 3;
    result[index] = Cartesian3.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian3.fromArray = Cartesian3.unpack;
Cartesian3.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y, cartesian11.z);
};
Cartesian3.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y, cartesian11.z);
};
Cartesian3.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  return result;
};
Cartesian3.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  return result;
};
Cartesian3.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  const z = Math_default.clamp(value.z, min3.z, max3.z);
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z;
};
Cartesian3.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian3.magnitudeSquared(cartesian11));
};
var distanceScratch = new Cartesian3();
Cartesian3.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.subtract(left, right, distanceScratch);
  return Cartesian3.magnitude(distanceScratch);
};
Cartesian3.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.subtract(left, right, distanceScratch);
  return Cartesian3.magnitudeSquared(distanceScratch);
};
Cartesian3.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian3.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  result.z = cartesian11.z / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian3.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z;
};
Cartesian3.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  return result;
};
Cartesian3.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  return result;
};
Cartesian3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  return result;
};
Cartesian3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  return result;
};
Cartesian3.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  result.z = cartesian11.z * scalar;
  return result;
};
Cartesian3.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  result.z = cartesian11.z / scalar;
  return result;
};
Cartesian3.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  result.z = -cartesian11.z;
  return result;
};
Cartesian3.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  result.z = Math.abs(cartesian11.z);
  return result;
};
var lerpScratch = new Cartesian3();
Cartesian3.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian3.multiplyByScalar(end, t, lerpScratch);
  result = Cartesian3.multiplyByScalar(start, 1 - t, result);
  return Cartesian3.add(lerpScratch, result, result);
};
var angleBetweenScratch = new Cartesian3();
var angleBetweenScratch2 = new Cartesian3();
Cartesian3.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.normalize(left, angleBetweenScratch);
  Cartesian3.normalize(right, angleBetweenScratch2);
  const cosine = Cartesian3.dot(angleBetweenScratch, angleBetweenScratch2);
  const sine = Cartesian3.magnitude(
    Cartesian3.cross(
      angleBetweenScratch,
      angleBetweenScratch2,
      angleBetweenScratch
    )
  );
  return Math.atan2(sine, cosine);
};
var mostOrthogonalAxisScratch = new Cartesian3();
Cartesian3.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian3.normalize(cartesian11, mostOrthogonalAxisScratch);
  Cartesian3.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      result = Cartesian3.clone(Cartesian3.UNIT_X, result);
    } else {
      result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
    }
  } else if (f.y <= f.z) {
    result = Cartesian3.clone(Cartesian3.UNIT_Y, result);
  } else {
    result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
  }
  return result;
};
Cartesian3.projectVector = function(a3, b, result) {
  Check_default.defined("a", a3);
  Check_default.defined("b", b);
  Check_default.defined("result", result);
  const scalar = Cartesian3.dot(a3, b) / Cartesian3.dot(b, b);
  return Cartesian3.multiplyByScalar(b, scalar, result);
};
Cartesian3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z;
};
Cartesian3.equalsArray = function(cartesian11, array, offset) {
  return cartesian11.x === array[offset] && cartesian11.y === array[offset + 1] && cartesian11.z === array[offset + 2];
};
Cartesian3.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian3.cross = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const leftX = left.x;
  const leftY = left.y;
  const leftZ = left.z;
  const rightX = right.x;
  const rightY = right.y;
  const rightZ = right.z;
  const x = leftY * rightZ - leftZ * rightY;
  const y = leftZ * rightX - leftX * rightZ;
  const z = leftX * rightY - leftY * rightX;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.midpoint = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = (left.x + right.x) * 0.5;
  result.y = (left.y + right.y) * 0.5;
  result.z = (left.z + right.z) * 0.5;
  return result;
};
Cartesian3.fromDegrees = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartesian3.fromRadians(longitude, latitude, height, ellipsoid, result);
};
var scratchN = new Cartesian3();
var scratchK = new Cartesian3();
Cartesian3._ellipsoidRadiiSquared = new Cartesian3(
  6378137 * 6378137,
  6378137 * 6378137,
  6356752314245179e-9 * 6356752314245179e-9
);
Cartesian3.fromRadians = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = height ?? 0;
  const radiiSquared = !defined_default(ellipsoid) ? Cartesian3._ellipsoidRadiiSquared : ellipsoid.radiiSquared;
  const cosLatitude = Math.cos(latitude);
  scratchN.x = cosLatitude * Math.cos(longitude);
  scratchN.y = cosLatitude * Math.sin(longitude);
  scratchN.z = Math.sin(latitude);
  scratchN = Cartesian3.normalize(scratchN, scratchN);
  Cartesian3.multiplyComponents(radiiSquared, scratchN, scratchK);
  const gamma = Math.sqrt(Cartesian3.dot(scratchN, scratchK));
  scratchK = Cartesian3.divideByScalar(scratchK, gamma, scratchK);
  scratchN = Cartesian3.multiplyByScalar(scratchN, height, scratchN);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  return Cartesian3.add(scratchK, scratchN, result);
};
Cartesian3.fromDegreesArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 2);
  } else {
    result.length = length2 / 2;
  }
  for (let i = 0; i < length2; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian3.fromDegrees(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromRadiansArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 2);
  } else {
    result.length = length2 / 2;
  }
  for (let i = 0; i < length2; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian3.fromRadians(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromDegreesArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 3);
  } else {
    result.length = length2 / 3;
  }
  for (let i = 0; i < length2; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian3.fromDegrees(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromRadiansArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 3);
  } else {
    result.length = length2 / 3;
  }
  for (let i = 0; i < length2; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian3.fromRadians(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.ZERO = Object.freeze(new Cartesian3(0, 0, 0));
Cartesian3.ONE = Object.freeze(new Cartesian3(1, 1, 1));
Cartesian3.UNIT_X = Object.freeze(new Cartesian3(1, 0, 0));
Cartesian3.UNIT_Y = Object.freeze(new Cartesian3(0, 1, 0));
Cartesian3.UNIT_Z = Object.freeze(new Cartesian3(0, 0, 1));
Cartesian3.prototype.clone = function(result) {
  return Cartesian3.clone(this, result);
};
Cartesian3.prototype.equals = function(right) {
  return Cartesian3.equals(this, right);
};
Cartesian3.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian3.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian3.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z})`;
};
var Cartesian3_default = Cartesian3;

// packages/engine/Source/Core/Cartesian4.js
function Cartesian4(x, y, z, w) {
  this.x = x ?? 0;
  this.y = y ?? 0;
  this.z = z ?? 0;
  this.w = w ?? 0;
}
Cartesian4.fromElements = function(x, y, z, w, result) {
  if (!defined_default(result)) {
    return new Cartesian4(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian4.fromColor = function(color, result) {
  Check_default.typeOf.object("color", color);
  if (!defined_default(result)) {
    return new Cartesian4(color.red, color.green, color.blue, color.alpha);
  }
  result.x = color.red;
  result.y = color.green;
  result.z = color.blue;
  result.w = color.alpha;
  return result;
};
Cartesian4.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian4(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  result.z = cartesian11.z;
  result.w = cartesian11.w;
  return result;
};
Cartesian4.packedLength = 4;
Cartesian4.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.z;
  array[startingIndex] = value.w;
  return array;
};
Cartesian4.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Cartesian4();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex++];
  result.w = array[startingIndex];
  return result;
};
Cartesian4.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 4;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 4 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Cartesian4.pack(array[i], result, i * 4);
  }
  return result;
};
Cartesian4.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
  if (array.length % 4 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 4.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 4);
  } else {
    result.length = length2 / 4;
  }
  for (let i = 0; i < length2; i += 4) {
    const index = i / 4;
    result[index] = Cartesian4.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian4.fromArray = Cartesian4.unpack;
Cartesian4.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
};
Cartesian4.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
};
Cartesian4.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  result.w = Math.min(first.w, second.w);
  return result;
};
Cartesian4.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  result.w = Math.max(first.w, second.w);
  return result;
};
Cartesian4.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  const z = Math_default.clamp(value.z, min3.z, max3.z);
  const w = Math_default.clamp(value.w, min3.w, max3.w);
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian4.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z + cartesian11.w * cartesian11.w;
};
Cartesian4.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian4.magnitudeSquared(cartesian11));
};
var distanceScratch2 = new Cartesian4();
Cartesian4.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian4.subtract(left, right, distanceScratch2);
  return Cartesian4.magnitude(distanceScratch2);
};
Cartesian4.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian4.subtract(left, right, distanceScratch2);
  return Cartesian4.magnitudeSquared(distanceScratch2);
};
Cartesian4.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian4.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  result.z = cartesian11.z / magnitude;
  result.w = cartesian11.w / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z) || isNaN(result.w)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian4.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
};
Cartesian4.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  result.w = left.w * right.w;
  return result;
};
Cartesian4.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  result.w = left.w / right.w;
  return result;
};
Cartesian4.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  result.w = left.w + right.w;
  return result;
};
Cartesian4.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  result.w = left.w - right.w;
  return result;
};
Cartesian4.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  result.z = cartesian11.z * scalar;
  result.w = cartesian11.w * scalar;
  return result;
};
Cartesian4.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  result.z = cartesian11.z / scalar;
  result.w = cartesian11.w / scalar;
  return result;
};
Cartesian4.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  result.z = -cartesian11.z;
  result.w = -cartesian11.w;
  return result;
};
Cartesian4.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  result.z = Math.abs(cartesian11.z);
  result.w = Math.abs(cartesian11.w);
  return result;
};
var lerpScratch2 = new Cartesian4();
Cartesian4.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian4.multiplyByScalar(end, t, lerpScratch2);
  result = Cartesian4.multiplyByScalar(start, 1 - t, result);
  return Cartesian4.add(lerpScratch2, result, result);
};
var mostOrthogonalAxisScratch2 = new Cartesian4();
Cartesian4.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian4.normalize(cartesian11, mostOrthogonalAxisScratch2);
  Cartesian4.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      if (f.x <= f.w) {
        result = Cartesian4.clone(Cartesian4.UNIT_X, result);
      } else {
        result = Cartesian4.clone(Cartesian4.UNIT_W, result);
      }
    } else if (f.z <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
  } else if (f.y <= f.z) {
    if (f.y <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Y, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
  } else if (f.z <= f.w) {
    result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
  } else {
    result = Cartesian4.clone(Cartesian4.UNIT_W, result);
  }
  return result;
};
Cartesian4.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
};
Cartesian4.equalsArray = function(cartesian11, array, offset) {
  return cartesian11.x === array[offset] && cartesian11.y === array[offset + 1] && cartesian11.z === array[offset + 2] && cartesian11.w === array[offset + 3];
};
Cartesian4.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.w,
    right.w,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian4.ZERO = Object.freeze(new Cartesian4(0, 0, 0, 0));
Cartesian4.ONE = Object.freeze(new Cartesian4(1, 1, 1, 1));
Cartesian4.UNIT_X = Object.freeze(new Cartesian4(1, 0, 0, 0));
Cartesian4.UNIT_Y = Object.freeze(new Cartesian4(0, 1, 0, 0));
Cartesian4.UNIT_Z = Object.freeze(new Cartesian4(0, 0, 1, 0));
Cartesian4.UNIT_W = Object.freeze(new Cartesian4(0, 0, 0, 1));
Cartesian4.prototype.clone = function(result) {
  return Cartesian4.clone(this, result);
};
Cartesian4.prototype.equals = function(right) {
  return Cartesian4.equals(this, right);
};
Cartesian4.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian4.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian4.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
};
var scratchF32Array = new Float32Array(1);
var scratchU8Array = new Uint8Array(scratchF32Array.buffer);
var testU32 = new Uint32Array([287454020]);
var testU8 = new Uint8Array(testU32.buffer);
var littleEndian = testU8[0] === 68;
Cartesian4.packFloat = function(value, result) {
  Check_default.typeOf.number("value", value);
  if (!defined_default(result)) {
    result = new Cartesian4();
  }
  scratchF32Array[0] = value;
  if (littleEndian) {
    result.x = scratchU8Array[0];
    result.y = scratchU8Array[1];
    result.z = scratchU8Array[2];
    result.w = scratchU8Array[3];
  } else {
    result.x = scratchU8Array[3];
    result.y = scratchU8Array[2];
    result.z = scratchU8Array[1];
    result.w = scratchU8Array[0];
  }
  return result;
};
Cartesian4.unpackFloat = function(packedFloat) {
  Check_default.typeOf.object("packedFloat", packedFloat);
  if (littleEndian) {
    scratchU8Array[0] = packedFloat.x;
    scratchU8Array[1] = packedFloat.y;
    scratchU8Array[2] = packedFloat.z;
    scratchU8Array[3] = packedFloat.w;
  } else {
    scratchU8Array[0] = packedFloat.w;
    scratchU8Array[1] = packedFloat.z;
    scratchU8Array[2] = packedFloat.y;
    scratchU8Array[3] = packedFloat.x;
  }
  return scratchF32Array[0];
};
var Cartesian4_default = Cartesian4;

// packages/engine/Source/Core/Frozen.js
var Frozen = {};
Frozen.EMPTY_OBJECT = Object.freeze({});
Frozen.EMPTY_ARRAY = Object.freeze([]);
var Frozen_default = Frozen;

// packages/engine/Source/Core/Matrix3.js
function Matrix3(column0Row0, column1Row0, column2Row0, column0Row1, column1Row1, column2Row1, column0Row2, column1Row2, column2Row2) {
  this[0] = column0Row0 ?? 0;
  this[1] = column0Row1 ?? 0;
  this[2] = column0Row2 ?? 0;
  this[3] = column1Row0 ?? 0;
  this[4] = column1Row1 ?? 0;
  this[5] = column1Row2 ?? 0;
  this[6] = column2Row0 ?? 0;
  this[7] = column2Row1 ?? 0;
  this[8] = column2Row2 ?? 0;
}
Matrix3.packedLength = 9;
Matrix3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  return array;
};
Matrix3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Matrix3();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  return result;
};
Matrix3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 9;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 9 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Matrix3.pack(array[i], result, i * 9);
  }
  return result;
};
Matrix3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 9);
  if (array.length % 9 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 9.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 9);
  } else {
    result.length = length2 / 9;
  }
  for (let i = 0; i < length2; i += 9) {
    const index = i / 9;
    result[index] = Matrix3.unpack(array, i, result[index]);
  }
  return result;
};
Matrix3.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix3(
      matrix[0],
      matrix[3],
      matrix[6],
      matrix[1],
      matrix[4],
      matrix[7],
      matrix[2],
      matrix[5],
      matrix[8]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.fromArray = Matrix3.unpack;
Matrix3.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix3.clone(values, result);
};
Matrix3.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix3(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8]
    );
  }
  result[0] = values[0];
  result[1] = values[3];
  result[2] = values[6];
  result[3] = values[1];
  result[4] = values[4];
  result[5] = values[7];
  result[6] = values[2];
  result[7] = values[5];
  result[8] = values[8];
  return result;
};
Matrix3.fromQuaternion = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  const x2 = quaternion.x * quaternion.x;
  const xy = quaternion.x * quaternion.y;
  const xz = quaternion.x * quaternion.z;
  const xw = quaternion.x * quaternion.w;
  const y2 = quaternion.y * quaternion.y;
  const yz = quaternion.y * quaternion.z;
  const yw = quaternion.y * quaternion.w;
  const z2 = quaternion.z * quaternion.z;
  const zw = quaternion.z * quaternion.w;
  const w2 = quaternion.w * quaternion.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromHeadingPitchRoll = function(headingPitchRoll, result) {
  Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
  const cosTheta = Math.cos(-headingPitchRoll.pitch);
  const cosPsi = Math.cos(-headingPitchRoll.heading);
  const cosPhi = Math.cos(headingPitchRoll.roll);
  const sinTheta = Math.sin(-headingPitchRoll.pitch);
  const sinPsi = Math.sin(-headingPitchRoll.heading);
  const sinPhi = Math.sin(headingPitchRoll.roll);
  const m00 = cosTheta * cosPsi;
  const m01 = -cosPhi * sinPsi + sinPhi * sinTheta * cosPsi;
  const m02 = sinPhi * sinPsi + cosPhi * sinTheta * cosPsi;
  const m10 = cosTheta * sinPsi;
  const m11 = cosPhi * cosPsi + sinPhi * sinTheta * sinPsi;
  const m12 = -sinPhi * cosPsi + cosPhi * sinTheta * sinPsi;
  const m20 = -sinTheta;
  const m21 = sinPhi * cosTheta;
  const m22 = cosPhi * cosTheta;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale.x, 0, 0, 0, scale.y, 0, 0, 0, scale.z);
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale.y;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale.z;
  return result;
};
Matrix3.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale, 0, 0, 0, scale, 0, 0, 0, scale);
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale;
  return result;
};
Matrix3.fromCrossProduct = function(vector, result) {
  Check_default.typeOf.object("vector", vector);
  if (!defined_default(result)) {
    return new Matrix3(
      0,
      -vector.z,
      vector.y,
      vector.z,
      0,
      -vector.x,
      -vector.y,
      vector.x,
      0
    );
  }
  result[0] = 0;
  result[1] = vector.z;
  result[2] = -vector.y;
  result[3] = -vector.z;
  result[4] = 0;
  result[5] = vector.x;
  result[6] = vector.y;
  result[7] = -vector.x;
  result[8] = 0;
  return result;
};
Matrix3.fromRotationX = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      1,
      0,
      0,
      0,
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle
    );
  }
  result[0] = 1;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = cosAngle;
  result[5] = sinAngle;
  result[6] = 0;
  result[7] = -sinAngle;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationY = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      0,
      sinAngle,
      0,
      1,
      0,
      -sinAngle,
      0,
      cosAngle
    );
  }
  result[0] = cosAngle;
  result[1] = 0;
  result[2] = -sinAngle;
  result[3] = 0;
  result[4] = 1;
  result[5] = 0;
  result[6] = sinAngle;
  result[7] = 0;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationZ = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle,
      0,
      0,
      0,
      1
    );
  }
  result[0] = cosAngle;
  result[1] = sinAngle;
  result[2] = 0;
  result[3] = -sinAngle;
  result[4] = cosAngle;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = 1;
  return result;
};
Matrix3.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 2);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 2);
  return column * 3 + row;
};
Matrix3.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 3;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setColumn = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  const startIndex = index * 3;
  result[startIndex] = cartesian11.x;
  result[startIndex + 1] = cartesian11.y;
  result[startIndex + 2] = cartesian11.z;
  return result;
};
Matrix3.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 3];
  const z = matrix[index + 6];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setRow = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  result[index] = cartesian11.x;
  result[index + 3] = cartesian11.y;
  result[index + 6] = cartesian11.z;
  return result;
};
var scaleScratch1 = new Cartesian3_default();
Matrix3.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch1);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scaleScratch2 = new Cartesian3_default();
Matrix3.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch2);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scratchColumn = new Cartesian3_default();
Matrix3.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[3], matrix[4], matrix[5], scratchColumn)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[6], matrix[7], matrix[8], scratchColumn)
  );
  return result;
};
var scaleScratch3 = new Cartesian3_default();
Matrix3.getMaximumScale = function(matrix) {
  Matrix3.getScale(matrix, scaleScratch3);
  return Cartesian3_default.maximumComponent(scaleScratch3);
};
var scaleScratch4 = new Cartesian3_default();
Matrix3.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch4);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = rotation[3] * scale.y;
  result[4] = rotation[4] * scale.y;
  result[5] = rotation[5] * scale.y;
  result[6] = rotation[6] * scale.z;
  result[7] = rotation[7] * scale.z;
  result[8] = rotation[8] * scale.z;
  return result;
};
var scaleScratch5 = new Cartesian3_default();
Matrix3.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch5);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[3] / scale.y;
  result[4] = matrix[4] / scale.y;
  result[5] = matrix[5] / scale.y;
  result[6] = matrix[6] / scale.z;
  result[7] = matrix[7] / scale.z;
  result[8] = matrix[8] / scale.z;
  return result;
};
Matrix3.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const column0Row0 = left[0] * right[0] + left[3] * right[1] + left[6] * right[2];
  const column0Row1 = left[1] * right[0] + left[4] * right[1] + left[7] * right[2];
  const column0Row2 = left[2] * right[0] + left[5] * right[1] + left[8] * right[2];
  const column1Row0 = left[0] * right[3] + left[3] * right[4] + left[6] * right[5];
  const column1Row1 = left[1] * right[3] + left[4] * right[4] + left[7] * right[5];
  const column1Row2 = left[2] * right[3] + left[5] * right[4] + left[8] * right[5];
  const column2Row0 = left[0] * right[6] + left[3] * right[7] + left[6] * right[8];
  const column2Row1 = left[1] * right[6] + left[4] * right[7] + left[7] * right[8];
  const column2Row2 = left[2] * right[6] + left[5] * right[7] + left[8] * right[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
Matrix3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  return result;
};
Matrix3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  return result;
};
Matrix3.multiplyByVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[3] * vY + matrix[6] * vZ;
  const y = matrix[1] * vX + matrix[4] * vY + matrix[7] * vZ;
  const z = matrix[2] * vX + matrix[5] * vY + matrix[8] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  return result;
};
Matrix3.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale.x;
  result[1] = matrix[1] * scale.x;
  result[2] = matrix[2] * scale.x;
  result[3] = matrix[3] * scale.y;
  result[4] = matrix[4] * scale.y;
  result[5] = matrix[5] * scale.y;
  result[6] = matrix[6] * scale.z;
  result[7] = matrix[7] * scale.z;
  result[8] = matrix[8] * scale.z;
  return result;
};
Matrix3.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3] * scale;
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7] * scale;
  result[8] = matrix[8] * scale;
  return result;
};
Matrix3.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  return result;
};
Matrix3.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const column0Row0 = matrix[0];
  const column0Row1 = matrix[3];
  const column0Row2 = matrix[6];
  const column1Row0 = matrix[1];
  const column1Row1 = matrix[4];
  const column1Row2 = matrix[7];
  const column2Row0 = matrix[2];
  const column2Row1 = matrix[5];
  const column2Row2 = matrix[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
function computeFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 9; ++i) {
    const temp = matrix[i];
    norm += temp * temp;
  }
  return Math.sqrt(norm);
}
var rowVal = [1, 0, 0];
var colVal = [2, 2, 1];
function offDiagonalFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 3; ++i) {
    const temp = matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])];
    norm += 2 * temp * temp;
  }
  return Math.sqrt(norm);
}
function shurDecomposition(matrix, result) {
  const tolerance = Math_default.EPSILON15;
  let maxDiagonal = 0;
  let rotAxis2 = 1;
  for (let i = 0; i < 3; ++i) {
    const temp = Math.abs(
      matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])]
    );
    if (temp > maxDiagonal) {
      rotAxis2 = i;
      maxDiagonal = temp;
    }
  }
  let c = 1;
  let s = 0;
  const p = rowVal[rotAxis2];
  const q = colVal[rotAxis2];
  if (Math.abs(matrix[Matrix3.getElementIndex(q, p)]) > tolerance) {
    const qq = matrix[Matrix3.getElementIndex(q, q)];
    const pp = matrix[Matrix3.getElementIndex(p, p)];
    const qp = matrix[Matrix3.getElementIndex(q, p)];
    const tau = (qq - pp) / 2 / qp;
    let t;
    if (tau < 0) {
      t = -1 / (-tau + Math.sqrt(1 + tau * tau));
    } else {
      t = 1 / (tau + Math.sqrt(1 + tau * tau));
    }
    c = 1 / Math.sqrt(1 + t * t);
    s = t * c;
  }
  result = Matrix3.clone(Matrix3.IDENTITY, result);
  result[Matrix3.getElementIndex(p, p)] = result[Matrix3.getElementIndex(q, q)] = c;
  result[Matrix3.getElementIndex(q, p)] = s;
  result[Matrix3.getElementIndex(p, q)] = -s;
  return result;
}
var jMatrix = new Matrix3();
var jMatrixTranspose = new Matrix3();
Matrix3.computeEigenDecomposition = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  const tolerance = Math_default.EPSILON20;
  const maxSweeps = 10;
  let count = 0;
  let sweep = 0;
  if (!defined_default(result)) {
    result = {};
  }
  const unitaryMatrix = result.unitary = Matrix3.clone(
    Matrix3.IDENTITY,
    result.unitary
  );
  const diagMatrix = result.diagonal = Matrix3.clone(matrix, result.diagonal);
  const epsilon = tolerance * computeFrobeniusNorm(diagMatrix);
  while (sweep < maxSweeps && offDiagonalFrobeniusNorm(diagMatrix) > epsilon) {
    shurDecomposition(diagMatrix, jMatrix);
    Matrix3.transpose(jMatrix, jMatrixTranspose);
    Matrix3.multiply(diagMatrix, jMatrix, diagMatrix);
    Matrix3.multiply(jMatrixTranspose, diagMatrix, diagMatrix);
    Matrix3.multiply(unitaryMatrix, jMatrix, unitaryMatrix);
    if (++count > 2) {
      ++sweep;
      count = 0;
    }
  }
  return result;
};
Matrix3.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  return result;
};
Matrix3.determinant = function(matrix) {
  Check_default.typeOf.object("matrix", matrix);
  const m11 = matrix[0];
  const m21 = matrix[3];
  const m31 = matrix[6];
  const m12 = matrix[1];
  const m22 = matrix[4];
  const m32 = matrix[7];
  const m13 = matrix[2];
  const m23 = matrix[5];
  const m33 = matrix[8];
  return m11 * (m22 * m33 - m23 * m32) + m12 * (m23 * m31 - m21 * m33) + m13 * (m21 * m32 - m22 * m31);
};
Matrix3.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const m11 = matrix[0];
  const m21 = matrix[1];
  const m31 = matrix[2];
  const m12 = matrix[3];
  const m22 = matrix[4];
  const m32 = matrix[5];
  const m13 = matrix[6];
  const m23 = matrix[7];
  const m33 = matrix[8];
  const determinant = Matrix3.determinant(matrix);
  if (Math.abs(determinant) <= Math_default.EPSILON15) {
    throw new DeveloperError_default("matrix is not invertible");
  }
  result[0] = m22 * m33 - m23 * m32;
  result[1] = m23 * m31 - m21 * m33;
  result[2] = m21 * m32 - m22 * m31;
  result[3] = m13 * m32 - m12 * m33;
  result[4] = m11 * m33 - m13 * m31;
  result[5] = m12 * m31 - m11 * m32;
  result[6] = m12 * m23 - m13 * m22;
  result[7] = m13 * m21 - m11 * m23;
  result[8] = m11 * m22 - m12 * m21;
  const scale = 1 / determinant;
  return Matrix3.multiplyByScalar(result, scale, result);
};
var scratchTransposeMatrix = new Matrix3();
Matrix3.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix3.inverse(
    Matrix3.transpose(matrix, scratchTransposeMatrix),
    result
  );
};
Matrix3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[7] === right[7] && left[8] === right[8];
};
Matrix3.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon;
};
Matrix3.IDENTITY = Object.freeze(
  new Matrix3(1, 0, 0, 0, 1, 0, 0, 0, 1)
);
Matrix3.ZERO = Object.freeze(
  new Matrix3(0, 0, 0, 0, 0, 0, 0, 0, 0)
);
Matrix3.COLUMN0ROW0 = 0;
Matrix3.COLUMN0ROW1 = 1;
Matrix3.COLUMN0ROW2 = 2;
Matrix3.COLUMN1ROW0 = 3;
Matrix3.COLUMN1ROW1 = 4;
Matrix3.COLUMN1ROW2 = 5;
Matrix3.COLUMN2ROW0 = 6;
Matrix3.COLUMN2ROW1 = 7;
Matrix3.COLUMN2ROW2 = 8;
Object.defineProperties(Matrix3.prototype, {
  /**
   * Gets the number of items in the collection.
   * @memberof Matrix3.prototype
   *
   * @type {number}
   */
  length: {
    get: function() {
      return Matrix3.packedLength;
    }
  }
});
Matrix3.prototype.clone = function(result) {
  return Matrix3.clone(this, result);
};
Matrix3.prototype.equals = function(right) {
  return Matrix3.equals(this, right);
};
Matrix3.equalsArray = function(matrix, array, offset) {
  return matrix[0] === array[offset] && matrix[1] === array[offset + 1] && matrix[2] === array[offset + 2] && matrix[3] === array[offset + 3] && matrix[4] === array[offset + 4] && matrix[5] === array[offset + 5] && matrix[6] === array[offset + 6] && matrix[7] === array[offset + 7] && matrix[8] === array[offset + 8];
};
Matrix3.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix3.equalsEpsilon(this, right, epsilon);
};
Matrix3.prototype.toString = function() {
  return `(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`;
};
var Matrix3_default = Matrix3;

// packages/engine/Source/Core/RuntimeError.js
function RuntimeError(message) {
  this.name = "RuntimeError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  RuntimeError.prototype = Object.create(Error.prototype);
  RuntimeError.prototype.constructor = RuntimeError;
}
RuntimeError.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
var RuntimeError_default = RuntimeError;

// packages/engine/Source/Core/Matrix4.js
function Matrix4(column0Row0, column1Row0, column2Row0, column3Row0, column0Row1, column1Row1, column2Row1, column3Row1, column0Row2, column1Row2, column2Row2, column3Row2, column0Row3, column1Row3, column2Row3, column3Row3) {
  this[0] = column0Row0 ?? 0;
  this[1] = column0Row1 ?? 0;
  this[2] = column0Row2 ?? 0;
  this[3] = column0Row3 ?? 0;
  this[4] = column1Row0 ?? 0;
  this[5] = column1Row1 ?? 0;
  this[6] = column1Row2 ?? 0;
  this[7] = column1Row3 ?? 0;
  this[8] = column2Row0 ?? 0;
  this[9] = column2Row1 ?? 0;
  this[10] = column2Row2 ?? 0;
  this[11] = column2Row3 ?? 0;
  this[12] = column3Row0 ?? 0;
  this[13] = column3Row1 ?? 0;
  this[14] = column3Row2 ?? 0;
  this[15] = column3Row3 ?? 0;
}
Matrix4.packedLength = 16;
Matrix4.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  array[startingIndex++] = value[9];
  array[startingIndex++] = value[10];
  array[startingIndex++] = value[11];
  array[startingIndex++] = value[12];
  array[startingIndex++] = value[13];
  array[startingIndex++] = value[14];
  array[startingIndex] = value[15];
  return array;
};
Matrix4.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  result[9] = array[startingIndex++];
  result[10] = array[startingIndex++];
  result[11] = array[startingIndex++];
  result[12] = array[startingIndex++];
  result[13] = array[startingIndex++];
  result[14] = array[startingIndex++];
  result[15] = array[startingIndex];
  return result;
};
Matrix4.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 16;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 16 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Matrix4.pack(array[i], result, i * 16);
  }
  return result;
};
Matrix4.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 16);
  if (array.length % 16 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 16.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 16);
  } else {
    result.length = length2 / 16;
  }
  for (let i = 0; i < length2; i += 16) {
    const index = i / 16;
    result[index] = Matrix4.unpack(array, i, result[index]);
  }
  return result;
};
Matrix4.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix4(
      matrix[0],
      matrix[4],
      matrix[8],
      matrix[12],
      matrix[1],
      matrix[5],
      matrix[9],
      matrix[13],
      matrix[2],
      matrix[6],
      matrix[10],
      matrix[14],
      matrix[3],
      matrix[7],
      matrix[11],
      matrix[15]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.fromArray = Matrix4.unpack;
Matrix4.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix4.clone(values, result);
};
Matrix4.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix4(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8],
      values[9],
      values[10],
      values[11],
      values[12],
      values[13],
      values[14],
      values[15]
    );
  }
  result[0] = values[0];
  result[1] = values[4];
  result[2] = values[8];
  result[3] = values[12];
  result[4] = values[1];
  result[5] = values[5];
  result[6] = values[9];
  result[7] = values[13];
  result[8] = values[2];
  result[9] = values[6];
  result[10] = values[10];
  result[11] = values[14];
  result[12] = values[3];
  result[13] = values[7];
  result[14] = values[11];
  result[15] = values[15];
  return result;
};
Matrix4.fromRotationTranslation = function(rotation, translation3, result) {
  Check_default.typeOf.object("rotation", rotation);
  translation3 = translation3 ?? Cartesian3_default.ZERO;
  if (!defined_default(result)) {
    return new Matrix4(
      rotation[0],
      rotation[3],
      rotation[6],
      translation3.x,
      rotation[1],
      rotation[4],
      rotation[7],
      translation3.y,
      rotation[2],
      rotation[5],
      rotation[8],
      translation3.z,
      0,
      0,
      0,
      1
    );
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = 1;
  return result;
};
Matrix4.fromTranslationQuaternionRotationScale = function(translation3, rotation, scale, result) {
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  const x2 = rotation.x * rotation.x;
  const xy = rotation.x * rotation.y;
  const xz = rotation.x * rotation.z;
  const xw = rotation.x * rotation.w;
  const y2 = rotation.y * rotation.y;
  const yz = rotation.y * rotation.z;
  const yw = rotation.y * rotation.w;
  const z2 = rotation.z * rotation.z;
  const zw = rotation.z * rotation.w;
  const w2 = rotation.w * rotation.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  result[0] = m00 * scaleX;
  result[1] = m10 * scaleX;
  result[2] = m20 * scaleX;
  result[3] = 0;
  result[4] = m01 * scaleY;
  result[5] = m11 * scaleY;
  result[6] = m21 * scaleY;
  result[7] = 0;
  result[8] = m02 * scaleZ;
  result[9] = m12 * scaleZ;
  result[10] = m22 * scaleZ;
  result[11] = 0;
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = 1;
  return result;
};
Matrix4.fromTranslationRotationScale = function(translationRotationScale, result) {
  Check_default.typeOf.object("translationRotationScale", translationRotationScale);
  return Matrix4.fromTranslationQuaternionRotationScale(
    translationRotationScale.translation,
    translationRotationScale.rotation,
    translationRotationScale.scale,
    result
  );
};
Matrix4.fromTranslation = function(translation3, result) {
  Check_default.typeOf.object("translation", translation3);
  return Matrix4.fromRotationTranslation(Matrix3_default.IDENTITY, translation3, result);
};
Matrix4.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix4(
      scale.x,
      0,
      0,
      0,
      0,
      scale.y,
      0,
      0,
      0,
      0,
      scale.z,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale.y;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale.z;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix4.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix4(
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix4.fromRotation = function(rotation, result) {
  Check_default.typeOf.object("rotation", rotation);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
var fromCameraF = new Cartesian3_default();
var fromCameraR = new Cartesian3_default();
var fromCameraU = new Cartesian3_default();
Matrix4.fromCamera = function(camera, result) {
  Check_default.typeOf.object("camera", camera);
  const position = camera.position;
  const direction2 = camera.direction;
  const up = camera.up;
  Check_default.typeOf.object("camera.position", position);
  Check_default.typeOf.object("camera.direction", direction2);
  Check_default.typeOf.object("camera.up", up);
  Cartesian3_default.normalize(direction2, fromCameraF);
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraF, up, fromCameraR),
    fromCameraR
  );
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraR, fromCameraF, fromCameraU),
    fromCameraU
  );
  const sX = fromCameraR.x;
  const sY = fromCameraR.y;
  const sZ = fromCameraR.z;
  const fX = fromCameraF.x;
  const fY = fromCameraF.y;
  const fZ = fromCameraF.z;
  const uX = fromCameraU.x;
  const uY = fromCameraU.y;
  const uZ = fromCameraU.z;
  const positionX = position.x;
  const positionY = position.y;
  const positionZ = position.z;
  const t0 = sX * -positionX + sY * -positionY + sZ * -positionZ;
  const t1 = uX * -positionX + uY * -positionY + uZ * -positionZ;
  const t2 = fX * positionX + fY * positionY + fZ * positionZ;
  if (!defined_default(result)) {
    return new Matrix4(
      sX,
      sY,
      sZ,
      t0,
      uX,
      uY,
      uZ,
      t1,
      -fX,
      -fY,
      -fZ,
      t2,
      0,
      0,
      0,
      1
    );
  }
  result[0] = sX;
  result[1] = uX;
  result[2] = -fX;
  result[3] = 0;
  result[4] = sY;
  result[5] = uY;
  result[6] = -fY;
  result[7] = 0;
  result[8] = sZ;
  result[9] = uZ;
  result[10] = -fZ;
  result[11] = 0;
  result[12] = t0;
  result[13] = t1;
  result[14] = t2;
  result[15] = 1;
  return result;
};
Matrix4.computePerspectiveFieldOfView = function(fovY, aspectRatio, near, far, result) {
  Check_default.typeOf.number.greaterThan("fovY", fovY, 0);
  Check_default.typeOf.number.lessThan("fovY", fovY, Math.PI);
  Check_default.typeOf.number.greaterThan("near", near, 0);
  Check_default.typeOf.number.greaterThan("far", far, 0);
  Check_default.typeOf.object("result", result);
  const bottom = Math.tan(fovY * 0.5);
  const column1Row1 = 1 / bottom;
  const column0Row0 = column1Row1 / aspectRatio;
  const column2Row2 = (far + near) / (near - far);
  const column3Row2 = 2 * far * near / (near - far);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = -1;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeOrthographicOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  let a3 = 1 / (right - left);
  let b = 1 / (top - bottom);
  let c = 1 / (far - near);
  const tx = -(right + left) * a3;
  const ty = -(top + bottom) * b;
  const tz = -(far + near) * c;
  a3 *= 2;
  b *= 2;
  c *= -2;
  result[0] = a3;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = b;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = c;
  result[11] = 0;
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = 1;
  return result;
};
Matrix4.computePerspectiveOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -(far + near) / (far - near);
  const column2Row3 = -1;
  const column3Row2 = -2 * far * near / (far - near);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeInfinitePerspectiveOffCenter = function(left, right, bottom, top, near, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -1;
  const column2Row3 = -1;
  const column3Row2 = -2 * near;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeViewportTransformation = function(viewport, nearDepthRange, farDepthRange, result) {
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  viewport = viewport ?? Frozen_default.EMPTY_OBJECT;
  const x = viewport.x ?? 0;
  const y = viewport.y ?? 0;
  const width = viewport.width ?? 0;
  const height = viewport.height ?? 0;
  nearDepthRange = nearDepthRange ?? 0;
  farDepthRange = farDepthRange ?? 1;
  const halfWidth = width * 0.5;
  const halfHeight = height * 0.5;
  const halfDepth = (farDepthRange - nearDepthRange) * 0.5;
  const column0Row0 = halfWidth;
  const column1Row1 = halfHeight;
  const column2Row2 = halfDepth;
  const column3Row0 = x + halfWidth;
  const column3Row1 = y + halfHeight;
  const column3Row2 = nearDepthRange + halfDepth;
  const column3Row3 = 1;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix4.computeView = function(position, direction2, up, right, result) {
  Check_default.typeOf.object("position", position);
  Check_default.typeOf.object("direction", direction2);
  Check_default.typeOf.object("up", up);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = right.x;
  result[1] = up.x;
  result[2] = -direction2.x;
  result[3] = 0;
  result[4] = right.y;
  result[5] = up.y;
  result[6] = -direction2.y;
  result[7] = 0;
  result[8] = right.z;
  result[9] = up.z;
  result[10] = -direction2.z;
  result[11] = 0;
  result[12] = -Cartesian3_default.dot(right, position);
  result[13] = -Cartesian3_default.dot(up, position);
  result[14] = Cartesian3_default.dot(direction2, position);
  result[15] = 1;
  return result;
};
Matrix4.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8],
      matrix[9],
      matrix[10],
      matrix[11],
      matrix[12],
      matrix[13],
      matrix[14],
      matrix[15]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 3);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 3);
  return column * 4 + row;
};
Matrix4.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 4;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  const w = matrix[startIndex + 3];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.setColumn = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix4.clone(matrix, result);
  const startIndex = index * 4;
  result[startIndex] = cartesian11.x;
  result[startIndex + 1] = cartesian11.y;
  result[startIndex + 2] = cartesian11.z;
  result[startIndex + 3] = cartesian11.w;
  return result;
};
Matrix4.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 4];
  const z = matrix[index + 8];
  const w = matrix[index + 12];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.setRow = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix4.clone(matrix, result);
  result[index] = cartesian11.x;
  result[index + 4] = cartesian11.y;
  result[index + 8] = cartesian11.z;
  result[index + 12] = cartesian11.w;
  return result;
};
Matrix4.setTranslation = function(matrix, translation3, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = matrix[15];
  return result;
};
var scaleScratch12 = new Cartesian3_default();
Matrix4.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix4.getScale(matrix, scaleScratch12);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch22 = new Cartesian3_default();
Matrix4.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix4.getScale(matrix, scaleScratch22);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scratchColumn2 = new Cartesian3_default();
Matrix4.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn2)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[4], matrix[5], matrix[6], scratchColumn2)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[8], matrix[9], matrix[10], scratchColumn2)
  );
  return result;
};
var scaleScratch32 = new Cartesian3_default();
Matrix4.getMaximumScale = function(matrix) {
  Matrix4.getScale(matrix, scaleScratch32);
  return Cartesian3_default.maximumComponent(scaleScratch32);
};
var scaleScratch42 = new Cartesian3_default();
Matrix4.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix4.getScale(matrix, scaleScratch42);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = matrix[3];
  result[4] = rotation[3] * scale.y;
  result[5] = rotation[4] * scale.y;
  result[6] = rotation[5] * scale.y;
  result[7] = matrix[7];
  result[8] = rotation[6] * scale.z;
  result[9] = rotation[7] * scale.z;
  result[10] = rotation[8] * scale.z;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch52 = new Cartesian3_default();
Matrix4.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix4.getScale(matrix, scaleScratch52);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[4] / scale.y;
  result[4] = matrix[5] / scale.y;
  result[5] = matrix[6] / scale.y;
  result[6] = matrix[8] / scale.z;
  result[7] = matrix[9] / scale.z;
  result[8] = matrix[10] / scale.z;
  return result;
};
Matrix4.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left3 = left[3];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left7 = left[7];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left11 = left[11];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const left15 = left[15];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right3 = right[3];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right7 = right[7];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right11 = right[11];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const right15 = right[15];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2 + left12 * right3;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2 + left13 * right3;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2 + left14 * right3;
  const column0Row3 = left3 * right0 + left7 * right1 + left11 * right2 + left15 * right3;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6 + left12 * right7;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6 + left13 * right7;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6 + left14 * right7;
  const column1Row3 = left3 * right4 + left7 * right5 + left11 * right6 + left15 * right7;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10 + left12 * right11;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10 + left13 * right11;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10 + left14 * right11;
  const column2Row3 = left3 * right8 + left7 * right9 + left11 * right10 + left15 * right11;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12 * right15;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13 * right15;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14 * right15;
  const column3Row3 = left3 * right12 + left7 * right13 + left11 * right14 + left15 * right15;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column0Row3;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = column1Row3;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix4.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  result[9] = left[9] + right[9];
  result[10] = left[10] + right[10];
  result[11] = left[11] + right[11];
  result[12] = left[12] + right[12];
  result[13] = left[13] + right[13];
  result[14] = left[14] + right[14];
  result[15] = left[15] + right[15];
  return result;
};
Matrix4.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  result[9] = left[9] - right[9];
  result[10] = left[10] - right[10];
  result[11] = left[11] - right[11];
  result[12] = left[12] - right[12];
  result[13] = left[13] - right[13];
  result[14] = left[14] - right[14];
  result[15] = left[15] - right[15];
  return result;
};
Matrix4.multiplyTransformation = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = 1;
  return result;
};
Matrix4.multiplyByMatrix3 = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("result", result);
  const left0 = matrix[0];
  const left1 = matrix[1];
  const left2 = matrix[2];
  const left4 = matrix[4];
  const left5 = matrix[5];
  const left6 = matrix[6];
  const left8 = matrix[8];
  const left9 = matrix[9];
  const left10 = matrix[10];
  const right0 = rotation[0];
  const right1 = rotation[1];
  const right2 = rotation[2];
  const right4 = rotation[3];
  const right5 = rotation[4];
  const right6 = rotation[5];
  const right8 = rotation[6];
  const right9 = rotation[7];
  const right10 = rotation[8];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByTranslation = function(matrix, translation3, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("result", result);
  const x = translation3.x;
  const y = translation3.y;
  const z = translation3.z;
  const tx = x * matrix[0] + y * matrix[4] + z * matrix[8] + matrix[12];
  const ty = x * matrix[1] + y * matrix[5] + z * matrix[9] + matrix[13];
  const tz = x * matrix[2] + y * matrix[6] + z * matrix[10] + matrix[14];
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  if (scaleX === 1 && scaleY === 1 && scaleZ === 1) {
    return Matrix4.clone(matrix, result);
  }
  result[0] = scaleX * matrix[0];
  result[1] = scaleX * matrix[1];
  result[2] = scaleX * matrix[2];
  result[3] = matrix[3];
  result[4] = scaleY * matrix[4];
  result[5] = scaleY * matrix[5];
  result[6] = scaleY * matrix[6];
  result[7] = matrix[7];
  result[8] = scaleZ * matrix[8];
  result[9] = scaleZ * matrix[9];
  result[10] = scaleZ * matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3];
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7];
  result[8] = matrix[8] * scale;
  result[9] = matrix[9] * scale;
  result[10] = matrix[10] * scale;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const vW = cartesian11.w;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12] * vW;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13] * vW;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14] * vW;
  const w = matrix[3] * vX + matrix[7] * vY + matrix[11] * vZ + matrix[15] * vW;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.multiplyByPointAsVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix4.multiplyByPoint = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12];
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13];
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix4.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  result[9] = matrix[9] * scalar;
  result[10] = matrix[10] * scalar;
  result[11] = matrix[11] * scalar;
  result[12] = matrix[12] * scalar;
  result[13] = matrix[13] * scalar;
  result[14] = matrix[14] * scalar;
  result[15] = matrix[15] * scalar;
  return result;
};
Matrix4.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  result[9] = -matrix[9];
  result[10] = -matrix[10];
  result[11] = -matrix[11];
  result[12] = -matrix[12];
  result[13] = -matrix[13];
  result[14] = -matrix[14];
  result[15] = -matrix[15];
  return result;
};
Matrix4.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix3 = matrix[3];
  const matrix6 = matrix[6];
  const matrix7 = matrix[7];
  const matrix11 = matrix[11];
  result[0] = matrix[0];
  result[1] = matrix[4];
  result[2] = matrix[8];
  result[3] = matrix[12];
  result[4] = matrix1;
  result[5] = matrix[5];
  result[6] = matrix[9];
  result[7] = matrix[13];
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix[10];
  result[11] = matrix[14];
  result[12] = matrix3;
  result[13] = matrix7;
  result[14] = matrix11;
  result[15] = matrix[15];
  return result;
};
Matrix4.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  result[9] = Math.abs(matrix[9]);
  result[10] = Math.abs(matrix[10]);
  result[11] = Math.abs(matrix[11]);
  result[12] = Math.abs(matrix[12]);
  result[13] = Math.abs(matrix[13]);
  result[14] = Math.abs(matrix[14]);
  result[15] = Math.abs(matrix[15]);
  return result;
};
Matrix4.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && // Translation
  left[12] === right[12] && left[13] === right[13] && left[14] === right[14] && // Rotation/scale
  left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[8] === right[8] && left[9] === right[9] && left[10] === right[10] && // Bottom row
  left[3] === right[3] && left[7] === right[7] && left[11] === right[11] && left[15] === right[15];
};
Matrix4.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon && Math.abs(left[9] - right[9]) <= epsilon && Math.abs(left[10] - right[10]) <= epsilon && Math.abs(left[11] - right[11]) <= epsilon && Math.abs(left[12] - right[12]) <= epsilon && Math.abs(left[13] - right[13]) <= epsilon && Math.abs(left[14] - right[14]) <= epsilon && Math.abs(left[15] - right[15]) <= epsilon;
};
Matrix4.getTranslation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = matrix[12];
  result.y = matrix[13];
  result.z = matrix[14];
  return result;
};
Matrix4.getMatrix3 = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[4];
  result[4] = matrix[5];
  result[5] = matrix[6];
  result[6] = matrix[8];
  result[7] = matrix[9];
  result[8] = matrix[10];
  return result;
};
var scratchInverseRotation = new Matrix3_default();
var scratchMatrix3Zero = new Matrix3_default();
var scratchBottomRow = new Cartesian4_default();
var scratchExpectedBottomRow = new Cartesian4_default(0, 0, 0, 1);
Matrix4.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const src0 = matrix[0];
  const src1 = matrix[4];
  const src2 = matrix[8];
  const src3 = matrix[12];
  const src4 = matrix[1];
  const src5 = matrix[5];
  const src6 = matrix[9];
  const src7 = matrix[13];
  const src8 = matrix[2];
  const src9 = matrix[6];
  const src10 = matrix[10];
  const src11 = matrix[14];
  const src12 = matrix[3];
  const src13 = matrix[7];
  const src14 = matrix[11];
  const src15 = matrix[15];
  let tmp0 = src10 * src15;
  let tmp1 = src11 * src14;
  let tmp2 = src9 * src15;
  let tmp3 = src11 * src13;
  let tmp4 = src9 * src14;
  let tmp5 = src10 * src13;
  let tmp6 = src8 * src15;
  let tmp7 = src11 * src12;
  let tmp8 = src8 * src14;
  let tmp9 = src10 * src12;
  let tmp10 = src8 * src13;
  let tmp11 = src9 * src12;
  const dst0 = tmp0 * src5 + tmp3 * src6 + tmp4 * src7 - (tmp1 * src5 + tmp2 * src6 + tmp5 * src7);
  const dst1 = tmp1 * src4 + tmp6 * src6 + tmp9 * src7 - (tmp0 * src4 + tmp7 * src6 + tmp8 * src7);
  const dst2 = tmp2 * src4 + tmp7 * src5 + tmp10 * src7 - (tmp3 * src4 + tmp6 * src5 + tmp11 * src7);
  const dst3 = tmp5 * src4 + tmp8 * src5 + tmp11 * src6 - (tmp4 * src4 + tmp9 * src5 + tmp10 * src6);
  const dst4 = tmp1 * src1 + tmp2 * src2 + tmp5 * src3 - (tmp0 * src1 + tmp3 * src2 + tmp4 * src3);
  const dst5 = tmp0 * src0 + tmp7 * src2 + tmp8 * src3 - (tmp1 * src0 + tmp6 * src2 + tmp9 * src3);
  const dst6 = tmp3 * src0 + tmp6 * src1 + tmp11 * src3 - (tmp2 * src0 + tmp7 * src1 + tmp10 * src3);
  const dst7 = tmp4 * src0 + tmp9 * src1 + tmp10 * src2 - (tmp5 * src0 + tmp8 * src1 + tmp11 * src2);
  tmp0 = src2 * src7;
  tmp1 = src3 * src6;
  tmp2 = src1 * src7;
  tmp3 = src3 * src5;
  tmp4 = src1 * src6;
  tmp5 = src2 * src5;
  tmp6 = src0 * src7;
  tmp7 = src3 * src4;
  tmp8 = src0 * src6;
  tmp9 = src2 * src4;
  tmp10 = src0 * src5;
  tmp11 = src1 * src4;
  const dst8 = tmp0 * src13 + tmp3 * src14 + tmp4 * src15 - (tmp1 * src13 + tmp2 * src14 + tmp5 * src15);
  const dst9 = tmp1 * src12 + tmp6 * src14 + tmp9 * src15 - (tmp0 * src12 + tmp7 * src14 + tmp8 * src15);
  const dst10 = tmp2 * src12 + tmp7 * src13 + tmp10 * src15 - (tmp3 * src12 + tmp6 * src13 + tmp11 * src15);
  const dst11 = tmp5 * src12 + tmp8 * src13 + tmp11 * src14 - (tmp4 * src12 + tmp9 * src13 + tmp10 * src14);
  const dst12 = tmp2 * src10 + tmp5 * src11 + tmp1 * src9 - (tmp4 * src11 + tmp0 * src9 + tmp3 * src10);
  const dst13 = tmp8 * src11 + tmp0 * src8 + tmp7 * src10 - (tmp6 * src10 + tmp9 * src11 + tmp1 * src8);
  const dst14 = tmp6 * src9 + tmp11 * src11 + tmp3 * src8 - (tmp10 * src11 + tmp2 * src8 + tmp7 * src9);
  const dst15 = tmp10 * src10 + tmp4 * src8 + tmp9 * src9 - (tmp8 * src9 + tmp11 * src10 + tmp5 * src8);
  let det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
  if (Math.abs(det) < Math_default.EPSILON21) {
    if (Matrix3_default.equalsEpsilon(
      Matrix4.getMatrix3(matrix, scratchInverseRotation),
      scratchMatrix3Zero,
      Math_default.EPSILON7
    ) && Cartesian4_default.equals(
      Matrix4.getRow(matrix, 3, scratchBottomRow),
      scratchExpectedBottomRow
    )) {
      result[0] = 0;
      result[1] = 0;
      result[2] = 0;
      result[3] = 0;
      result[4] = 0;
      result[5] = 0;
      result[6] = 0;
      result[7] = 0;
      result[8] = 0;
      result[9] = 0;
      result[10] = 0;
      result[11] = 0;
      result[12] = -matrix[12];
      result[13] = -matrix[13];
      result[14] = -matrix[14];
      result[15] = 1;
      return result;
    }
    throw new RuntimeError_default(
      "matrix is not invertible because its determinate is zero."
    );
  }
  det = 1 / det;
  result[0] = dst0 * det;
  result[1] = dst1 * det;
  result[2] = dst2 * det;
  result[3] = dst3 * det;
  result[4] = dst4 * det;
  result[5] = dst5 * det;
  result[6] = dst6 * det;
  result[7] = dst7 * det;
  result[8] = dst8 * det;
  result[9] = dst9 * det;
  result[10] = dst10 * det;
  result[11] = dst11 * det;
  result[12] = dst12 * det;
  result[13] = dst13 * det;
  result[14] = dst14 * det;
  result[15] = dst15 * det;
  return result;
};
Matrix4.inverseTransformation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix0 = matrix[0];
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix4 = matrix[4];
  const matrix5 = matrix[5];
  const matrix6 = matrix[6];
  const matrix8 = matrix[8];
  const matrix9 = matrix[9];
  const matrix10 = matrix[10];
  const vX = matrix[12];
  const vY = matrix[13];
  const vZ = matrix[14];
  const x = -matrix0 * vX - matrix1 * vY - matrix2 * vZ;
  const y = -matrix4 * vX - matrix5 * vY - matrix6 * vZ;
  const z = -matrix8 * vX - matrix9 * vY - matrix10 * vZ;
  result[0] = matrix0;
  result[1] = matrix4;
  result[2] = matrix8;
  result[3] = 0;
  result[4] = matrix1;
  result[5] = matrix5;
  result[6] = matrix9;
  result[7] = 0;
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix10;
  result[11] = 0;
  result[12] = x;
  result[13] = y;
  result[14] = z;
  result[15] = 1;
  return result;
};
var scratchTransposeMatrix2 = new Matrix4();
Matrix4.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix4.inverse(
    Matrix4.transpose(matrix, scratchTransposeMatrix2),
    result
  );
};
Matrix4.IDENTITY = Object.freeze(
  new Matrix4(
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1
  )
);
Matrix4.ZERO = Object.freeze(
  new Matrix4(
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0
  )
);
Matrix4.COLUMN0ROW0 = 0;
Matrix4.COLUMN0ROW1 = 1;
Matrix4.COLUMN0ROW2 = 2;
Matrix4.COLUMN0ROW3 = 3;
Matrix4.COLUMN1ROW0 = 4;
Matrix4.COLUMN1ROW1 = 5;
Matrix4.COLUMN1ROW2 = 6;
Matrix4.COLUMN1ROW3 = 7;
Matrix4.COLUMN2ROW0 = 8;
Matrix4.COLUMN2ROW1 = 9;
Matrix4.COLUMN2ROW2 = 10;
Matrix4.COLUMN2ROW3 = 11;
Matrix4.COLUMN3ROW0 = 12;
Matrix4.COLUMN3ROW1 = 13;
Matrix4.COLUMN3ROW2 = 14;
Matrix4.COLUMN3ROW3 = 15;
Object.defineProperties(Matrix4.prototype, {
  /**
   * Gets the number of items in the collection.
   * @memberof Matrix4.prototype
   *
   * @type {number}
   */
  length: {
    get: function() {
      return Matrix4.packedLength;
    }
  }
});
Matrix4.prototype.clone = function(result) {
  return Matrix4.clone(this, result);
};
Matrix4.prototype.equals = function(right) {
  return Matrix4.equals(this, right);
};
Matrix4.equalsArray = function(matrix, array, offset) {
  return matrix[0] === array[offset] && matrix[1] === array[offset + 1] && matrix[2] === array[offset + 2] && matrix[3] === array[offset + 3] && matrix[4] === array[offset + 4] && matrix[5] === array[offset + 5] && matrix[6] === array[offset + 6] && matrix[7] === array[offset + 7] && matrix[8] === array[offset + 8] && matrix[9] === array[offset + 9] && matrix[10] === array[offset + 10] && matrix[11] === array[offset + 11] && matrix[12] === array[offset + 12] && matrix[13] === array[offset + 13] && matrix[14] === array[offset + 14] && matrix[15] === array[offset + 15];
};
Matrix4.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix4.equalsEpsilon(this, right, epsilon);
};
Matrix4.prototype.toString = function() {
  return `(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`;
};
var Matrix4_default = Matrix4;

// packages/engine/Source/Core/WebGLConstants.js
var WebGLConstants = {
  DEPTH_BUFFER_BIT: 256,
  STENCIL_BUFFER_BIT: 1024,
  COLOR_BUFFER_BIT: 16384,
  POINTS: 0,
  LINES: 1,
  LINE_LOOP: 2,
  LINE_STRIP: 3,
  TRIANGLES: 4,
  TRIANGLE_STRIP: 5,
  TRIANGLE_FAN: 6,
  ZERO: 0,
  ONE: 1,
  SRC_COLOR: 768,
  ONE_MINUS_SRC_COLOR: 769,
  SRC_ALPHA: 770,
  ONE_MINUS_SRC_ALPHA: 771,
  DST_ALPHA: 772,
  ONE_MINUS_DST_ALPHA: 773,
  DST_COLOR: 774,
  ONE_MINUS_DST_COLOR: 775,
  SRC_ALPHA_SATURATE: 776,
  FUNC_ADD: 32774,
  BLEND_EQUATION: 32777,
  BLEND_EQUATION_RGB: 32777,
  // same as BLEND_EQUATION
  BLEND_EQUATION_ALPHA: 34877,
  FUNC_SUBTRACT: 32778,
  FUNC_REVERSE_SUBTRACT: 32779,
  BLEND_DST_RGB: 32968,
  BLEND_SRC_RGB: 32969,
  BLEND_DST_ALPHA: 32970,
  BLEND_SRC_ALPHA: 32971,
  CONSTANT_COLOR: 32769,
  ONE_MINUS_CONSTANT_COLOR: 32770,
  CONSTANT_ALPHA: 32771,
  ONE_MINUS_CONSTANT_ALPHA: 32772,
  BLEND_COLOR: 32773,
  ARRAY_BUFFER: 34962,
  ELEMENT_ARRAY_BUFFER: 34963,
  ARRAY_BUFFER_BINDING: 34964,
  ELEMENT_ARRAY_BUFFER_BINDING: 34965,
  STREAM_DRAW: 35040,
  STATIC_DRAW: 35044,
  DYNAMIC_DRAW: 35048,
  BUFFER_SIZE: 34660,
  BUFFER_USAGE: 34661,
  CURRENT_VERTEX_ATTRIB: 34342,
  FRONT: 1028,
  BACK: 1029,
  FRONT_AND_BACK: 1032,
  CULL_FACE: 2884,
  BLEND: 3042,
  DITHER: 3024,
  STENCIL_TEST: 2960,
  DEPTH_TEST: 2929,
  SCISSOR_TEST: 3089,
  POLYGON_OFFSET_FILL: 32823,
  SAMPLE_ALPHA_TO_COVERAGE: 32926,
  SAMPLE_COVERAGE: 32928,
  NO_ERROR: 0,
  INVALID_ENUM: 1280,
  INVALID_VALUE: 1281,
  INVALID_OPERATION: 1282,
  OUT_OF_MEMORY: 1285,
  CW: 2304,
  CCW: 2305,
  LINE_WIDTH: 2849,
  ALIASED_POINT_SIZE_RANGE: 33901,
  ALIASED_LINE_WIDTH_RANGE: 33902,
  CULL_FACE_MODE: 2885,
  FRONT_FACE: 2886,
  DEPTH_RANGE: 2928,
  DEPTH_WRITEMASK: 2930,
  DEPTH_CLEAR_VALUE: 2931,
  DEPTH_FUNC: 2932,
  STENCIL_CLEAR_VALUE: 2961,
  STENCIL_FUNC: 2962,
  STENCIL_FAIL: 2964,
  STENCIL_PASS_DEPTH_FAIL: 2965,
  STENCIL_PASS_DEPTH_PASS: 2966,
  STENCIL_REF: 2967,
  STENCIL_VALUE_MASK: 2963,
  STENCIL_WRITEMASK: 2968,
  STENCIL_BACK_FUNC: 34816,
  STENCIL_BACK_FAIL: 34817,
  STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
  STENCIL_BACK_PASS_DEPTH_PASS: 34819,
  STENCIL_BACK_REF: 36003,
  STENCIL_BACK_VALUE_MASK: 36004,
  STENCIL_BACK_WRITEMASK: 36005,
  VIEWPORT: 2978,
  SCISSOR_BOX: 3088,
  COLOR_CLEAR_VALUE: 3106,
  COLOR_WRITEMASK: 3107,
  UNPACK_ALIGNMENT: 3317,
  PACK_ALIGNMENT: 3333,
  MAX_TEXTURE_SIZE: 3379,
  MAX_VIEWPORT_DIMS: 3386,
  SUBPIXEL_BITS: 3408,
  RED_BITS: 3410,
  GREEN_BITS: 3411,
  BLUE_BITS: 3412,
  ALPHA_BITS: 3413,
  DEPTH_BITS: 3414,
  STENCIL_BITS: 3415,
  POLYGON_OFFSET_UNITS: 10752,
  POLYGON_OFFSET_FACTOR: 32824,
  TEXTURE_BINDING_2D: 32873,
  SAMPLE_BUFFERS: 32936,
  SAMPLES: 32937,
  SAMPLE_COVERAGE_VALUE: 32938,
  SAMPLE_COVERAGE_INVERT: 32939,
  COMPRESSED_TEXTURE_FORMATS: 34467,
  DONT_CARE: 4352,
  FASTEST: 4353,
  NICEST: 4354,
  GENERATE_MIPMAP_HINT: 33170,
  BYTE: 5120,
  UNSIGNED_BYTE: 5121,
  SHORT: 5122,
  UNSIGNED_SHORT: 5123,
  INT: 5124,
  UNSIGNED_INT: 5125,
  FLOAT: 5126,
  DEPTH_COMPONENT: 6402,
  ALPHA: 6406,
  RGB: 6407,
  RGBA: 6408,
  LUMINANCE: 6409,
  LUMINANCE_ALPHA: 6410,
  UNSIGNED_SHORT_4_4_4_4: 32819,
  UNSIGNED_SHORT_5_5_5_1: 32820,
  UNSIGNED_SHORT_5_6_5: 33635,
  FRAGMENT_SHADER: 35632,
  VERTEX_SHADER: 35633,
  MAX_VERTEX_ATTRIBS: 34921,
  MAX_VERTEX_UNIFORM_VECTORS: 36347,
  MAX_VARYING_VECTORS: 36348,
  MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
  MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
  MAX_TEXTURE_IMAGE_UNITS: 34930,
  MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
  SHADER_TYPE: 35663,
  DELETE_STATUS: 35712,
  LINK_STATUS: 35714,
  VALIDATE_STATUS: 35715,
  ATTACHED_SHADERS: 35717,
  ACTIVE_UNIFORMS: 35718,
  ACTIVE_ATTRIBUTES: 35721,
  SHADING_LANGUAGE_VERSION: 35724,
  CURRENT_PROGRAM: 35725,
  NEVER: 512,
  LESS: 513,
  EQUAL: 514,
  LEQUAL: 515,
  GREATER: 516,
  NOTEQUAL: 517,
  GEQUAL: 518,
  ALWAYS: 519,
  KEEP: 7680,
  REPLACE: 7681,
  INCR: 7682,
  DECR: 7683,
  INVERT: 5386,
  INCR_WRAP: 34055,
  DECR_WRAP: 34056,
  VENDOR: 7936,
  RENDERER: 7937,
  VERSION: 7938,
  NEAREST: 9728,
  LINEAR: 9729,
  NEAREST_MIPMAP_NEAREST: 9984,
  LINEAR_MIPMAP_NEAREST: 9985,
  NEAREST_MIPMAP_LINEAR: 9986,
  LINEAR_MIPMAP_LINEAR: 9987,
  TEXTURE_MAG_FILTER: 10240,
  TEXTURE_MIN_FILTER: 10241,
  TEXTURE_WRAP_S: 10242,
  TEXTURE_WRAP_T: 10243,
  TEXTURE_2D: 3553,
  TEXTURE: 5890,
  TEXTURE_CUBE_MAP: 34067,
  TEXTURE_BINDING_CUBE_MAP: 34068,
  TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
  TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
  TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
  TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
  TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
  TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
  MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
  TEXTURE0: 33984,
  TEXTURE1: 33985,
  TEXTURE2: 33986,
  TEXTURE3: 33987,
  TEXTURE4: 33988,
  TEXTURE5: 33989,
  TEXTURE6: 33990,
  TEXTURE7: 33991,
  TEXTURE8: 33992,
  TEXTURE9: 33993,
  TEXTURE10: 33994,
  TEXTURE11: 33995,
  TEXTURE12: 33996,
  TEXTURE13: 33997,
  TEXTURE14: 33998,
  TEXTURE15: 33999,
  TEXTURE16: 34e3,
  TEXTURE17: 34001,
  TEXTURE18: 34002,
  TEXTURE19: 34003,
  TEXTURE20: 34004,
  TEXTURE21: 34005,
  TEXTURE22: 34006,
  TEXTURE23: 34007,
  TEXTURE24: 34008,
  TEXTURE25: 34009,
  TEXTURE26: 34010,
  TEXTURE27: 34011,
  TEXTURE28: 34012,
  TEXTURE29: 34013,
  TEXTURE30: 34014,
  TEXTURE31: 34015,
  ACTIVE_TEXTURE: 34016,
  REPEAT: 10497,
  CLAMP_TO_EDGE: 33071,
  MIRRORED_REPEAT: 33648,
  FLOAT_VEC2: 35664,
  FLOAT_VEC3: 35665,
  FLOAT_VEC4: 35666,
  INT_VEC2: 35667,
  INT_VEC3: 35668,
  INT_VEC4: 35669,
  BOOL: 35670,
  BOOL_VEC2: 35671,
  BOOL_VEC3: 35672,
  BOOL_VEC4: 35673,
  FLOAT_MAT2: 35674,
  FLOAT_MAT3: 35675,
  FLOAT_MAT4: 35676,
  SAMPLER_2D: 35678,
  SAMPLER_CUBE: 35680,
  VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
  VERTEX_ATTRIB_ARRAY_SIZE: 34339,
  VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
  VERTEX_ATTRIB_ARRAY_TYPE: 34341,
  VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
  VERTEX_ATTRIB_ARRAY_POINTER: 34373,
  VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
  IMPLEMENTATION_COLOR_READ_TYPE: 35738,
  IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
  COMPILE_STATUS: 35713,
  LOW_FLOAT: 36336,
  MEDIUM_FLOAT: 36337,
  HIGH_FLOAT: 36338,
  LOW_INT: 36339,
  MEDIUM_INT: 36340,
  HIGH_INT: 36341,
  FRAMEBUFFER: 36160,
  RENDERBUFFER: 36161,
  RGBA4: 32854,
  RGB5_A1: 32855,
  RGB565: 36194,
  DEPTH_COMPONENT16: 33189,
  STENCIL_INDEX: 6401,
  STENCIL_INDEX8: 36168,
  DEPTH_STENCIL: 34041,
  RENDERBUFFER_WIDTH: 36162,
  RENDERBUFFER_HEIGHT: 36163,
  RENDERBUFFER_INTERNAL_FORMAT: 36164,
  RENDERBUFFER_RED_SIZE: 36176,
  RENDERBUFFER_GREEN_SIZE: 36177,
  RENDERBUFFER_BLUE_SIZE: 36178,
  RENDERBUFFER_ALPHA_SIZE: 36179,
  RENDERBUFFER_DEPTH_SIZE: 36180,
  RENDERBUFFER_STENCIL_SIZE: 36181,
  FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
  FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
  COLOR_ATTACHMENT0: 36064,
  DEPTH_ATTACHMENT: 36096,
  STENCIL_ATTACHMENT: 36128,
  DEPTH_STENCIL_ATTACHMENT: 33306,
  NONE: 0,
  FRAMEBUFFER_COMPLETE: 36053,
  FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
  FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
  FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
  FRAMEBUFFER_UNSUPPORTED: 36061,
  FRAMEBUFFER_BINDING: 36006,
  RENDERBUFFER_BINDING: 36007,
  MAX_RENDERBUFFER_SIZE: 34024,
  INVALID_FRAMEBUFFER_OPERATION: 1286,
  UNPACK_FLIP_Y_WEBGL: 37440,
  UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
  CONTEXT_LOST_WEBGL: 37442,
  UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
  BROWSER_DEFAULT_WEBGL: 37444,
  // WEBGL_compressed_texture_s3tc
  COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
  COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
  COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
  COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
  // WEBGL_compressed_texture_pvrtc
  COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
  COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
  COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
  COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
  // WEBGL_compressed_texture_astc
  COMPRESSED_RGBA_ASTC_4x4_WEBGL: 37808,
  // WEBGL_compressed_texture_etc1
  COMPRESSED_RGB_ETC1_WEBGL: 36196,
  // EXT_texture_compression_bptc
  COMPRESSED_RGBA_BPTC_UNORM: 36492,
  // EXT_color_buffer_half_float
  HALF_FLOAT_OES: 36193,
  // Desktop OpenGL
  DOUBLE: 5130,
  // WebGL 2
  READ_BUFFER: 3074,
  UNPACK_ROW_LENGTH: 3314,
  UNPACK_SKIP_ROWS: 3315,
  UNPACK_SKIP_PIXELS: 3316,
  PACK_ROW_LENGTH: 3330,
  PACK_SKIP_ROWS: 3331,
  PACK_SKIP_PIXELS: 3332,
  COLOR: 6144,
  DEPTH: 6145,
  STENCIL: 6146,
  RED: 6403,
  RGB8: 32849,
  RGBA8: 32856,
  RGB10_A2: 32857,
  TEXTURE_BINDING_3D: 32874,
  UNPACK_SKIP_IMAGES: 32877,
  UNPACK_IMAGE_HEIGHT: 32878,
  TEXTURE_3D: 32879,
  TEXTURE_WRAP_R: 32882,
  MAX_3D_TEXTURE_SIZE: 32883,
  UNSIGNED_INT_2_10_10_10_REV: 33640,
  MAX_ELEMENTS_VERTICES: 33e3,
  MAX_ELEMENTS_INDICES: 33001,
  TEXTURE_MIN_LOD: 33082,
  TEXTURE_MAX_LOD: 33083,
  TEXTURE_BASE_LEVEL: 33084,
  TEXTURE_MAX_LEVEL: 33085,
  MIN: 32775,
  MAX: 32776,
  DEPTH_COMPONENT24: 33190,
  MAX_TEXTURE_LOD_BIAS: 34045,
  TEXTURE_COMPARE_MODE: 34892,
  TEXTURE_COMPARE_FUNC: 34893,
  CURRENT_QUERY: 34917,
  QUERY_RESULT: 34918,
  QUERY_RESULT_AVAILABLE: 34919,
  STREAM_READ: 35041,
  STREAM_COPY: 35042,
  STATIC_READ: 35045,
  STATIC_COPY: 35046,
  DYNAMIC_READ: 35049,
  DYNAMIC_COPY: 35050,
  MAX_DRAW_BUFFERS: 34852,
  DRAW_BUFFER0: 34853,
  DRAW_BUFFER1: 34854,
  DRAW_BUFFER2: 34855,
  DRAW_BUFFER3: 34856,
  DRAW_BUFFER4: 34857,
  DRAW_BUFFER5: 34858,
  DRAW_BUFFER6: 34859,
  DRAW_BUFFER7: 34860,
  DRAW_BUFFER8: 34861,
  DRAW_BUFFER9: 34862,
  DRAW_BUFFER10: 34863,
  DRAW_BUFFER11: 34864,
  DRAW_BUFFER12: 34865,
  DRAW_BUFFER13: 34866,
  DRAW_BUFFER14: 34867,
  DRAW_BUFFER15: 34868,
  MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
  MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
  SAMPLER_3D: 35679,
  SAMPLER_2D_SHADOW: 35682,
  FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
  PIXEL_PACK_BUFFER: 35051,
  PIXEL_UNPACK_BUFFER: 35052,
  PIXEL_PACK_BUFFER_BINDING: 35053,
  PIXEL_UNPACK_BUFFER_BINDING: 35055,
  FLOAT_MAT2x3: 35685,
  FLOAT_MAT2x4: 35686,
  FLOAT_MAT3x2: 35687,
  FLOAT_MAT3x4: 35688,
  FLOAT_MAT4x2: 35689,
  FLOAT_MAT4x3: 35690,
  SRGB: 35904,
  SRGB8: 35905,
  SRGB8_ALPHA8: 35907,
  COMPARE_REF_TO_TEXTURE: 34894,
  RGBA32F: 34836,
  RGB32F: 34837,
  RGBA16F: 34842,
  RGB16F: 34843,
  VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
  MAX_ARRAY_TEXTURE_LAYERS: 35071,
  MIN_PROGRAM_TEXEL_OFFSET: 35076,
  MAX_PROGRAM_TEXEL_OFFSET: 35077,
  MAX_VARYING_COMPONENTS: 35659,
  TEXTURE_2D_ARRAY: 35866,
  TEXTURE_BINDING_2D_ARRAY: 35869,
  R11F_G11F_B10F: 35898,
  UNSIGNED_INT_10F_11F_11F_REV: 35899,
  RGB9_E5: 35901,
  UNSIGNED_INT_5_9_9_9_REV: 35902,
  TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
  MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
  TRANSFORM_FEEDBACK_VARYINGS: 35971,
  TRANSFORM_FEEDBACK_BUFFER_START: 35972,
  TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
  TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
  RASTERIZER_DISCARD: 35977,
  MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
  MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
  INTERLEAVED_ATTRIBS: 35980,
  SEPARATE_ATTRIBS: 35981,
  TRANSFORM_FEEDBACK_BUFFER: 35982,
  TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
  RGBA32UI: 36208,
  RGB32UI: 36209,
  RGBA16UI: 36214,
  RGB16UI: 36215,
  RGBA8UI: 36220,
  RGB8UI: 36221,
  RGBA32I: 36226,
  RGB32I: 36227,
  RGBA16I: 36232,
  RGB16I: 36233,
  RGBA8I: 36238,
  RGB8I: 36239,
  RED_INTEGER: 36244,
  RGB_INTEGER: 36248,
  RGBA_INTEGER: 36249,
  SAMPLER_2D_ARRAY: 36289,
  SAMPLER_2D_ARRAY_SHADOW: 36292,
  SAMPLER_CUBE_SHADOW: 36293,
  UNSIGNED_INT_VEC2: 36294,
  UNSIGNED_INT_VEC3: 36295,
  UNSIGNED_INT_VEC4: 36296,
  INT_SAMPLER_2D: 36298,
  INT_SAMPLER_3D: 36299,
  INT_SAMPLER_CUBE: 36300,
  INT_SAMPLER_2D_ARRAY: 36303,
  UNSIGNED_INT_SAMPLER_2D: 36306,
  UNSIGNED_INT_SAMPLER_3D: 36307,
  UNSIGNED_INT_SAMPLER_CUBE: 36308,
  UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
  DEPTH_COMPONENT32F: 36012,
  DEPTH32F_STENCIL8: 36013,
  FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
  FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
  FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
  FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
  FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
  FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
  FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
  FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
  FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
  FRAMEBUFFER_DEFAULT: 33304,
  UNSIGNED_INT_24_8: 34042,
  DEPTH24_STENCIL8: 35056,
  UNSIGNED_NORMALIZED: 35863,
  DRAW_FRAMEBUFFER_BINDING: 36006,
  // Same as FRAMEBUFFER_BINDING
  READ_FRAMEBUFFER: 36008,
  DRAW_FRAMEBUFFER: 36009,
  READ_FRAMEBUFFER_BINDING: 36010,
  RENDERBUFFER_SAMPLES: 36011,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
  MAX_COLOR_ATTACHMENTS: 36063,
  COLOR_ATTACHMENT1: 36065,
  COLOR_ATTACHMENT2: 36066,
  COLOR_ATTACHMENT3: 36067,
  COLOR_ATTACHMENT4: 36068,
  COLOR_ATTACHMENT5: 36069,
  COLOR_ATTACHMENT6: 36070,
  COLOR_ATTACHMENT7: 36071,
  COLOR_ATTACHMENT8: 36072,
  COLOR_ATTACHMENT9: 36073,
  COLOR_ATTACHMENT10: 36074,
  COLOR_ATTACHMENT11: 36075,
  COLOR_ATTACHMENT12: 36076,
  COLOR_ATTACHMENT13: 36077,
  COLOR_ATTACHMENT14: 36078,
  COLOR_ATTACHMENT15: 36079,
  FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
  MAX_SAMPLES: 36183,
  HALF_FLOAT: 5131,
  RG: 33319,
  RG_INTEGER: 33320,
  R8: 33321,
  RG8: 33323,
  R16F: 33325,
  R32F: 33326,
  RG16F: 33327,
  RG32F: 33328,
  R8I: 33329,
  R8UI: 33330,
  R16I: 33331,
  R16UI: 33332,
  R32I: 33333,
  R32UI: 33334,
  RG8I: 33335,
  RG8UI: 33336,
  RG16I: 33337,
  RG16UI: 33338,
  RG32I: 33339,
  RG32UI: 33340,
  VERTEX_ARRAY_BINDING: 34229,
  R8_SNORM: 36756,
  RG8_SNORM: 36757,
  RGB8_SNORM: 36758,
  RGBA8_SNORM: 36759,
  SIGNED_NORMALIZED: 36764,
  COPY_READ_BUFFER: 36662,
  COPY_WRITE_BUFFER: 36663,
  COPY_READ_BUFFER_BINDING: 36662,
  // Same as COPY_READ_BUFFER
  COPY_WRITE_BUFFER_BINDING: 36663,
  // Same as COPY_WRITE_BUFFER
  UNIFORM_BUFFER: 35345,
  UNIFORM_BUFFER_BINDING: 35368,
  UNIFORM_BUFFER_START: 35369,
  UNIFORM_BUFFER_SIZE: 35370,
  MAX_VERTEX_UNIFORM_BLOCKS: 35371,
  MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
  MAX_COMBINED_UNIFORM_BLOCKS: 35374,
  MAX_UNIFORM_BUFFER_BINDINGS: 35375,
  MAX_UNIFORM_BLOCK_SIZE: 35376,
  MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
  MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
  UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
  ACTIVE_UNIFORM_BLOCKS: 35382,
  UNIFORM_TYPE: 35383,
  UNIFORM_SIZE: 35384,
  UNIFORM_BLOCK_INDEX: 35386,
  UNIFORM_OFFSET: 35387,
  UNIFORM_ARRAY_STRIDE: 35388,
  UNIFORM_MATRIX_STRIDE: 35389,
  UNIFORM_IS_ROW_MAJOR: 35390,
  UNIFORM_BLOCK_BINDING: 35391,
  UNIFORM_BLOCK_DATA_SIZE: 35392,
  UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
  UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
  UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
  UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
  INVALID_INDEX: 4294967295,
  MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
  MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
  MAX_SERVER_WAIT_TIMEOUT: 37137,
  OBJECT_TYPE: 37138,
  SYNC_CONDITION: 37139,
  SYNC_STATUS: 37140,
  SYNC_FLAGS: 37141,
  SYNC_FENCE: 37142,
  SYNC_GPU_COMMANDS_COMPLETE: 37143,
  UNSIGNALED: 37144,
  SIGNALED: 37145,
  ALREADY_SIGNALED: 37146,
  TIMEOUT_EXPIRED: 37147,
  CONDITION_SATISFIED: 37148,
  WAIT_FAILED: 37149,
  SYNC_FLUSH_COMMANDS_BIT: 1,
  VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
  ANY_SAMPLES_PASSED: 35887,
  ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
  SAMPLER_BINDING: 35097,
  RGB10_A2UI: 36975,
  INT_2_10_10_10_REV: 36255,
  TRANSFORM_FEEDBACK: 36386,
  TRANSFORM_FEEDBACK_PAUSED: 36387,
  TRANSFORM_FEEDBACK_ACTIVE: 36388,
  TRANSFORM_FEEDBACK_BINDING: 36389,
  COMPRESSED_R11_EAC: 37488,
  COMPRESSED_SIGNED_R11_EAC: 37489,
  COMPRESSED_RG11_EAC: 37490,
  COMPRESSED_SIGNED_RG11_EAC: 37491,
  COMPRESSED_RGB8_ETC2: 37492,
  COMPRESSED_SRGB8_ETC2: 37493,
  COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37494,
  COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37495,
  COMPRESSED_RGBA8_ETC2_EAC: 37496,
  COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37497,
  TEXTURE_IMMUTABLE_FORMAT: 37167,
  MAX_ELEMENT_INDEX: 36203,
  TEXTURE_IMMUTABLE_LEVELS: 33503,
  // Extensions
  MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047
};
var WebGLConstants_default = Object.freeze(WebGLConstants);

// packages/engine/Source/Renderer/AutomaticUniforms.js
var viewerPositionWCScratch = new Cartesian3_default();
function AutomaticUniform(options) {
  this._size = options.size;
  this._datatype = options.datatype;
  this.getValue = options.getValue;
}
var datatypeToGlsl = {};
datatypeToGlsl[WebGLConstants_default.FLOAT] = "float";
datatypeToGlsl[WebGLConstants_default.FLOAT_VEC2] = "vec2";
datatypeToGlsl[WebGLConstants_default.FLOAT_VEC3] = "vec3";
datatypeToGlsl[WebGLConstants_default.FLOAT_VEC4] = "vec4";
datatypeToGlsl[WebGLConstants_default.INT] = "int";
datatypeToGlsl[WebGLConstants_default.INT_VEC2] = "ivec2";
datatypeToGlsl[WebGLConstants_default.INT_VEC3] = "ivec3";
datatypeToGlsl[WebGLConstants_default.INT_VEC4] = "ivec4";
datatypeToGlsl[WebGLConstants_default.BOOL] = "bool";
datatypeToGlsl[WebGLConstants_default.BOOL_VEC2] = "bvec2";
datatypeToGlsl[WebGLConstants_default.BOOL_VEC3] = "bvec3";
datatypeToGlsl[WebGLConstants_default.BOOL_VEC4] = "bvec4";
datatypeToGlsl[WebGLConstants_default.FLOAT_MAT2] = "mat2";
datatypeToGlsl[WebGLConstants_default.FLOAT_MAT3] = "mat3";
datatypeToGlsl[WebGLConstants_default.FLOAT_MAT4] = "mat4";
datatypeToGlsl[WebGLConstants_default.SAMPLER_2D] = "sampler2D";
datatypeToGlsl[WebGLConstants_default.SAMPLER_CUBE] = "samplerCube";
AutomaticUniform.prototype.getDeclaration = function(name) {
  let declaration = `uniform ${datatypeToGlsl[this._datatype]} ${name}`;
  const size = this._size;
  if (size === 1) {
    declaration += ";";
  } else {
    declaration += `[${size.toString()}];`;
  }
  return declaration;
};
var AutomaticUniforms = {
  /**
   * An automatic GLSL uniform containing the viewport's <code>x</code>, <code>y</code>, <code>width</code>,
   * and <code>height</code> properties in an <code>vec4</code>'s <code>x</code>, <code>y</code>, <code>z</code>,
   * and <code>w</code> components, respectively.
   *
   * @example
   * // GLSL declaration
   * uniform vec4 czm_viewport;
   *
   * // Scale the window coordinate components to [0, 1] by dividing
   * // by the viewport's width and height.
   * vec2 v = gl_FragCoord.xy / czm_viewport.zw;
   *
   * @see Context#getViewport
   */
  czm_viewport: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.viewportCartesian4;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 orthographic projection matrix that
   * transforms window coordinates to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   * <br /><br />
   * This transform is useful when a vertex shader inputs or manipulates window coordinates
   * as done by {@link BillboardCollection}.
   * <br /><br />
   * Do not confuse {@link czm_viewportTransformation} with <code>czm_viewportOrthographic</code>.
   * The former transforms from normalized device coordinates to window coordinates; the later transforms
   * from window coordinates to clip coordinates, and is often used to assign to <code>gl_Position</code>.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_viewportOrthographic;
   *
   * // Example
   * gl_Position = czm_viewportOrthographic * vec4(windowPosition, 0.0, 1.0);
   *
   * @see UniformState#viewportOrthographic
   * @see czm_viewport
   * @see czm_viewportTransformation
   * @see BillboardCollection
   */
  czm_viewportOrthographic: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.viewportOrthographic;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 transformation matrix that
   * transforms normalized device coordinates to window coordinates.  The context's
   * full viewport is used, and the depth range is assumed to be <code>near = 0</code>
   * and <code>far = 1</code>.
   * <br /><br />
   * This transform is useful when there is a need to manipulate window coordinates
   * in a vertex shader as done by {@link BillboardCollection}.  In many cases,
   * this matrix will not be used directly; instead, {@link czm_modelToWindowCoordinates}
   * will be used to transform directly from model to window coordinates.
   * <br /><br />
   * Do not confuse <code>czm_viewportTransformation</code> with {@link czm_viewportOrthographic}.
   * The former transforms from normalized device coordinates to window coordinates; the later transforms
   * from window coordinates to clip coordinates, and is often used to assign to <code>gl_Position</code>.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_viewportTransformation;
   *
   * // Use czm_viewportTransformation as part of the
   * // transform from model to window coordinates.
   * vec4 q = czm_modelViewProjection * positionMC;               // model to clip coordinates
   * q.xyz /= q.w;                                                // clip to normalized device coordinates (ndc)
   * q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // ndc to window coordinates
   *
   * @see UniformState#viewportTransformation
   * @see czm_viewport
   * @see czm_viewportOrthographic
   * @see czm_modelToWindowCoordinates
   * @see BillboardCollection
   */
  czm_viewportTransformation: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.viewportTransformation;
    }
  }),
  /**
   * An automatic GLSL uniform representing the depth of the scene
   * after the globe pass and then updated after the 3D Tiles pass.
   * The depth is packed into an RGBA texture.
   *
   * @example
   * // GLSL declaration
   * uniform sampler2D czm_globeDepthTexture;
   *
   * // Get the depth at the current fragment
   * vec2 coords = gl_FragCoord.xy / czm_viewport.zw;
   * float depth = czm_unpackDepth(texture(czm_globeDepthTexture, coords));
   */
  czm_globeDepthTexture: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.globeDepthTexture;
    }
  }),
  /**
   * An automatic GLSL uniform representing a texture containing edge IDs
   * from the 3D Tiles edge rendering pass. Used for edge detection and
   * avoiding z-fighting between edges and surfaces.
   *
   * @example
   * // GLSL declaration
   * uniform sampler2D czm_edgeIdTexture;
   *
   * // Get the edge ID at the current fragment
   * vec2 coords = gl_FragCoord.xy / czm_viewport.zw;
   * vec4 edgeId = texture(czm_edgeIdTexture, coords);
   */
  czm_edgeIdTexture: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.edgeIdTexture;
    }
  }),
  /**
   * An automatic GLSL uniform containing the edge color texture.
   * This texture contains the edge content rendered during the CESIUM_3D_TILE_EDGES pass.
   *
   * @example
   * // GLSL declaration
   * uniform sampler2D czm_edgeColorTexture;
   *
   * // Sample the edge color at the current fragment
   * vec2 coords = gl_FragCoord.xy / czm_viewport.zw;
   * vec4 edgeColor = texture(czm_edgeColorTexture, coords);
   */
  czm_edgeColorTexture: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.edgeColorTexture;
    }
  }),
  /**
   * An automatic GLSL uniform containing the packed depth texture produced by the
   * edge visibility pass. The depth is packed via czm_packDepth and should be
   * unpacked with czm_unpackDepth.
   *
   * @example
   * // GLSL declaration
   * uniform sampler2D czm_edgeDepthTexture;
   *
   * vec2 coords = gl_FragCoord.xy / czm_viewport.zw;
   * float d = czm_unpackDepth(texture(czm_edgeDepthTexture, coords));
   */
  czm_edgeDepthTexture: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.edgeDepthTexture;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model transformation matrix that
   * transforms model coordinates to world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_model;
   *
   * // Example
   * vec4 worldPosition = czm_model * modelPosition;
   *
   * @see UniformState#model
   * @see czm_inverseModel
   * @see czm_modelView
   * @see czm_modelViewProjection
   */
  czm_model: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.model;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model transformation matrix that
   * transforms world coordinates to model coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseModel;
   *
   * // Example
   * vec4 modelPosition = czm_inverseModel * worldPosition;
   *
   * @see UniformState#inverseModel
   * @see czm_model
   * @see czm_inverseModelView
   */
  czm_inverseModel: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModel;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 view transformation matrix that
   * transforms world coordinates to eye coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_view;
   *
   * // Example
   * vec4 eyePosition = czm_view * worldPosition;
   *
   * @see UniformState#view
   * @see czm_viewRotation
   * @see czm_modelView
   * @see czm_viewProjection
   * @see czm_modelViewProjection
   * @see czm_inverseView
   */
  czm_view: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.view;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 view transformation matrix that
   * transforms 3D world coordinates to eye coordinates.  In 3D mode, this is identical to
   * {@link czm_view}, but in 2D and Columbus View it represents the view matrix
   * as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_view3D;
   *
   * // Example
   * vec4 eyePosition3D = czm_view3D * worldPosition3D;
   *
   * @see UniformState#view3D
   * @see czm_view
   */
  czm_view3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.view3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 view rotation matrix that
   * transforms vectors in world coordinates to eye coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_viewRotation;
   *
   * // Example
   * vec3 eyeVector = czm_viewRotation * worldVector;
   *
   * @see UniformState#viewRotation
   * @see czm_view
   * @see czm_inverseView
   * @see czm_inverseViewRotation
   */
  czm_viewRotation: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.viewRotation;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 view rotation matrix that
   * transforms vectors in 3D world coordinates to eye coordinates.  In 3D mode, this is identical to
   * {@link czm_viewRotation}, but in 2D and Columbus View it represents the view matrix
   * as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_viewRotation3D;
   *
   * // Example
   * vec3 eyeVector = czm_viewRotation3D * worldVector;
   *
   * @see UniformState#viewRotation3D
   * @see czm_viewRotation
   */
  czm_viewRotation3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.viewRotation3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 transformation matrix that
   * transforms from eye coordinates to world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseView;
   *
   * // Example
   * vec4 worldPosition = czm_inverseView * eyePosition;
   *
   * @see UniformState#inverseView
   * @see czm_view
   * @see czm_inverseNormal
   */
  czm_inverseView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseView;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 transformation matrix that
   * transforms from 3D eye coordinates to world coordinates.  In 3D mode, this is identical to
   * {@link czm_inverseView}, but in 2D and Columbus View it represents the inverse view matrix
   * as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseView3D;
   *
   * // Example
   * vec4 worldPosition = czm_inverseView3D * eyePosition;
   *
   * @see UniformState#inverseView3D
   * @see czm_inverseView
   */
  czm_inverseView3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseView3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 rotation matrix that
   * transforms vectors from eye coordinates to world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_inverseViewRotation;
   *
   * // Example
   * vec4 worldVector = czm_inverseViewRotation * eyeVector;
   *
   * @see UniformState#inverseView
   * @see czm_view
   * @see czm_viewRotation
   * @see czm_inverseViewRotation
   */
  czm_inverseViewRotation: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseViewRotation;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 rotation matrix that
   * transforms vectors from 3D eye coordinates to world coordinates.  In 3D mode, this is identical to
   * {@link czm_inverseViewRotation}, but in 2D and Columbus View it represents the inverse view matrix
   * as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_inverseViewRotation3D;
   *
   * // Example
   * vec4 worldVector = czm_inverseViewRotation3D * eyeVector;
   *
   * @see UniformState#inverseView3D
   * @see czm_inverseViewRotation
   */
  czm_inverseViewRotation3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseViewRotation3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 projection transformation matrix that
   * transforms eye coordinates to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_projection;
   *
   * // Example
   * gl_Position = czm_projection * eyePosition;
   *
   * @see UniformState#projection
   * @see czm_viewProjection
   * @see czm_modelViewProjection
   * @see czm_infiniteProjection
   */
  czm_projection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.projection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 inverse projection transformation matrix that
   * transforms from clip coordinates to eye coordinates. Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseProjection;
   *
   * // Example
   * vec4 eyePosition = czm_inverseProjection * clipPosition;
   *
   * @see UniformState#inverseProjection
   * @see czm_projection
   */
  czm_inverseProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseProjection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 projection transformation matrix with the far plane at infinity,
   * that transforms eye coordinates to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.  An infinite far plane is used
   * in algorithms like shadow volumes and GPU ray casting with proxy geometry to ensure that triangles
   * are not clipped by the far plane.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_infiniteProjection;
   *
   * // Example
   * gl_Position = czm_infiniteProjection * eyePosition;
   *
   * @see UniformState#infiniteProjection
   * @see czm_projection
   * @see czm_modelViewInfiniteProjection
   */
  czm_infiniteProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.infiniteProjection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model-view transformation matrix that
   * transforms model coordinates to eye coordinates.
   * <br /><br />
   * Positions should be transformed to eye coordinates using <code>czm_modelView</code> and
   * normals should be transformed using {@link czm_normal}.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_modelView;
   *
   * // Example
   * vec4 eyePosition = czm_modelView * modelPosition;
   *
   * // The above is equivalent to, but more efficient than:
   * vec4 eyePosition = czm_view * czm_model * modelPosition;
   *
   * @see UniformState#modelView
   * @see czm_model
   * @see czm_view
   * @see czm_modelViewProjection
   * @see czm_normal
   */
  czm_modelView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelView;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model-view transformation matrix that
   * transforms 3D model coordinates to eye coordinates.  In 3D mode, this is identical to
   * {@link czm_modelView}, but in 2D and Columbus View it represents the model-view matrix
   * as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   * <br /><br />
   * Positions should be transformed to eye coordinates using <code>czm_modelView3D</code> and
   * normals should be transformed using {@link czm_normal3D}.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_modelView3D;
   *
   * // Example
   * vec4 eyePosition = czm_modelView3D * modelPosition;
   *
   * // The above is equivalent to, but more efficient than:
   * vec4 eyePosition = czm_view3D * czm_model * modelPosition;
   *
   * @see UniformState#modelView3D
   * @see czm_modelView
   */
  czm_modelView3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelView3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model-view transformation matrix that
   * transforms model coordinates, relative to the eye, to eye coordinates.  This is used
   * in conjunction with {@link czm_translateRelativeToEye}.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_modelViewRelativeToEye;
   *
   * // Example
   * attribute vec3 positionHigh;
   * attribute vec3 positionLow;
   *
   * void main()
   * {
   *   vec4 p = czm_translateRelativeToEye(positionHigh, positionLow);
   *   gl_Position = czm_projection * (czm_modelViewRelativeToEye * p);
   * }
   *
   * @see czm_modelViewProjectionRelativeToEye
   * @see czm_translateRelativeToEye
   * @see EncodedCartesian3
   */
  czm_modelViewRelativeToEye: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewRelativeToEye;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 transformation matrix that
   * transforms from eye coordinates to model coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseModelView;
   *
   * // Example
   * vec4 modelPosition = czm_inverseModelView * eyePosition;
   *
   * @see UniformState#inverseModelView
   * @see czm_modelView
   */
  czm_inverseModelView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModelView;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 transformation matrix that
   * transforms from eye coordinates to 3D model coordinates.  In 3D mode, this is identical to
   * {@link czm_inverseModelView}, but in 2D and Columbus View it represents the inverse model-view matrix
   * as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseModelView3D;
   *
   * // Example
   * vec4 modelPosition = czm_inverseModelView3D * eyePosition;
   *
   * @see UniformState#inverseModelView
   * @see czm_inverseModelView
   * @see czm_modelView3D
   */
  czm_inverseModelView3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModelView3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 view-projection transformation matrix that
   * transforms world coordinates to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_viewProjection;
   *
   * // Example
   * vec4 gl_Position = czm_viewProjection * czm_model * modelPosition;
   *
   * // The above is equivalent to, but more efficient than:
   * gl_Position = czm_projection * czm_view * czm_model * modelPosition;
   *
   * @see UniformState#viewProjection
   * @see czm_view
   * @see czm_projection
   * @see czm_modelViewProjection
   * @see czm_inverseViewProjection
   */
  czm_viewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.viewProjection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 view-projection transformation matrix that
   * transforms clip coordinates to world coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseViewProjection;
   *
   * // Example
   * vec4 worldPosition = czm_inverseViewProjection * clipPosition;
   *
   * @see UniformState#inverseViewProjection
   * @see czm_viewProjection
   */
  czm_inverseViewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseViewProjection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model-view-projection transformation matrix that
   * transforms model coordinates to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_modelViewProjection;
   *
   * // Example
   * vec4 gl_Position = czm_modelViewProjection * modelPosition;
   *
   * // The above is equivalent to, but more efficient than:
   * gl_Position = czm_projection * czm_view * czm_model * modelPosition;
   *
   * @see UniformState#modelViewProjection
   * @see czm_model
   * @see czm_view
   * @see czm_projection
   * @see czm_modelView
   * @see czm_viewProjection
   * @see czm_modelViewInfiniteProjection
   * @see czm_inverseModelViewProjection
   */
  czm_modelViewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewProjection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 inverse model-view-projection transformation matrix that
   * transforms clip coordinates to model coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_inverseModelViewProjection;
   *
   * // Example
   * vec4 modelPosition = czm_inverseModelViewProjection * clipPosition;
   *
   * @see UniformState#modelViewProjection
   * @see czm_modelViewProjection
   */
  czm_inverseModelViewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModelViewProjection;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model-view-projection transformation matrix that
   * transforms model coordinates, relative to the eye, to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.  This is used in
   * conjunction with {@link czm_translateRelativeToEye}.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_modelViewProjectionRelativeToEye;
   *
   * // Example
   * attribute vec3 positionHigh;
   * attribute vec3 positionLow;
   *
   * void main()
   * {
   *   vec4 p = czm_translateRelativeToEye(positionHigh, positionLow);
   *   gl_Position = czm_modelViewProjectionRelativeToEye * p;
   * }
   *
   * @see czm_modelViewRelativeToEye
   * @see czm_translateRelativeToEye
   * @see EncodedCartesian3
   */
  czm_modelViewProjectionRelativeToEye: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewProjectionRelativeToEye;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 4x4 model-view-projection transformation matrix that
   * transforms model coordinates to clip coordinates.  Clip coordinates is the
   * coordinate system for a vertex shader's <code>gl_Position</code> output.  The projection matrix places
   * the far plane at infinity.  This is useful in algorithms like shadow volumes and GPU ray casting with
   * proxy geometry to ensure that triangles are not clipped by the far plane.
   *
   * @example
   * // GLSL declaration
   * uniform mat4 czm_modelViewInfiniteProjection;
   *
   * // Example
   * vec4 gl_Position = czm_modelViewInfiniteProjection * modelPosition;
   *
   * // The above is equivalent to, but more efficient than:
   * gl_Position = czm_infiniteProjection * czm_view * czm_model * modelPosition;
   *
   * @see UniformState#modelViewInfiniteProjection
   * @see czm_model
   * @see czm_view
   * @see czm_infiniteProjection
   * @see czm_modelViewProjection
   */
  czm_modelViewInfiniteProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewInfiniteProjection;
    }
  }),
  /**
   * An automatic GLSL uniform that indicates if the current camera is orthographic in 3D.
   *
   * @see UniformState#orthographicIn3D
   */
  czm_orthographicIn3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.orthographicIn3D ? 1 : 0;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 normal transformation matrix that
   * transforms normal vectors in model coordinates to eye coordinates.
   * <br /><br />
   * Positions should be transformed to eye coordinates using {@link czm_modelView} and
   * normals should be transformed using <code>czm_normal</code>.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_normal;
   *
   * // Example
   * vec3 eyeNormal = czm_normal * normal;
   *
   * @see UniformState#normal
   * @see czm_inverseNormal
   * @see czm_modelView
   */
  czm_normal: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.normal;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 normal transformation matrix that
   * transforms normal vectors in 3D model coordinates to eye coordinates.
   * In 3D mode, this is identical to
   * {@link czm_normal}, but in 2D and Columbus View it represents the normal transformation
   * matrix as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   * <br /><br />
   * Positions should be transformed to eye coordinates using {@link czm_modelView3D} and
   * normals should be transformed using <code>czm_normal3D</code>.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_normal3D;
   *
   * // Example
   * vec3 eyeNormal = czm_normal3D * normal;
   *
   * @see UniformState#normal3D
   * @see czm_normal
   */
  czm_normal3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.normal3D;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 normal transformation matrix that
   * transforms normal vectors in eye coordinates to model coordinates.  This is
   * the opposite of the transform provided by {@link czm_normal}.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_inverseNormal;
   *
   * // Example
   * vec3 normalMC = czm_inverseNormal * normalEC;
   *
   * @see UniformState#inverseNormal
   * @see czm_normal
   * @see czm_modelView
   * @see czm_inverseView
   */
  czm_inverseNormal: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseNormal;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 normal transformation matrix that
   * transforms normal vectors in eye coordinates to 3D model coordinates.  This is
   * the opposite of the transform provided by {@link czm_normal}.
   * In 3D mode, this is identical to
   * {@link czm_inverseNormal}, but in 2D and Columbus View it represents the inverse normal transformation
   * matrix as if the camera were at an equivalent location in 3D mode.  This is useful for lighting
   * 2D and Columbus View in the same way that 3D is lit.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_inverseNormal3D;
   *
   * // Example
   * vec3 normalMC = czm_inverseNormal3D * normalEC;
   *
   * @see UniformState#inverseNormal3D
   * @see czm_inverseNormal
   */
  czm_inverseNormal3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseNormal3D;
    }
  }),
  /**
   * An automatic GLSL uniform containing the height in meters of the
   * eye (camera) above or below the ellipsoid.
   *
   * @see UniformState#eyeHeight
   */
  czm_eyeHeight: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.eyeHeight;
    }
  }),
  /**
   * An automatic GLSL uniform containing height (<code>x</code>) and height squared (<code>y</code>)
   * in meters of the eye (camera) above the 2D world plane. This uniform is only valid
   * when the {@link SceneMode} is <code>SCENE2D</code>.
   *
   * @see UniformState#eyeHeight2D
   */
  czm_eyeHeight2D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.eyeHeight2D;
    }
  }),
  /**
   * An automatic GLSL uniform containing the ellipsoid surface normal
   * at the position below the eye (camera), in eye coordinates.
   * This uniform is only valid when the {@link SceneMode} is <code>SCENE3D</code>.
   */
  czm_eyeEllipsoidNormalEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.eyeEllipsoidNormalEC;
    }
  }),
  /**
   * An automatic GLSL uniform containing the ellipsoid radii of curvature at the camera position.
   * The .x component is the prime vertical radius of curvature (east-west direction)
   * .y is the meridional radius of curvature (north-south direction)
   * This uniform is only valid when the {@link SceneMode} is <code>SCENE3D</code>.
   */
  czm_eyeEllipsoidCurvature: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.eyeEllipsoidCurvature;
    }
  }),
  /**
   * An automatic GLSL uniform containing the transform from model coordinates
   * to an east-north-up coordinate system centered at the position on the
   * ellipsoid below the camera.
   * This uniform is only valid when the {@link SceneMode} is <code>SCENE3D</code>.
   */
  czm_modelToEnu: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelToEnu;
    }
  }),
  /**
   * An automatic GLSL uniform containing the the inverse of
   * {@link AutomaticUniforms.czm_modelToEnu}.
   * This uniform is only valid when the {@link SceneMode} is <code>SCENE3D</code>.
   */
  czm_enuToModel: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.enuToModel;
    }
  }),
  /**
   * An automatic GLSL uniform containing the near distance (<code>x</code>) and the far distance (<code>y</code>)
   * of the frustum defined by the camera.  This is the largest possible frustum, not an individual
   * frustum used for multi-frustum rendering.
   *
   * @example
   * // GLSL declaration
   * uniform vec2 czm_entireFrustum;
   *
   * // Example
   * float frustumLength = czm_entireFrustum.y - czm_entireFrustum.x;
   *
   * @see UniformState#entireFrustum
   * @see czm_currentFrustum
   */
  czm_entireFrustum: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.entireFrustum;
    }
  }),
  /**
   * An automatic GLSL uniform containing the near distance (<code>x</code>) and the far distance (<code>y</code>)
   * of the frustum defined by the camera.  This is the individual
   * frustum used for multi-frustum rendering.
   *
   * @example
   * // GLSL declaration
   * uniform vec2 czm_currentFrustum;
   *
   * // Example
   * float frustumLength = czm_currentFrustum.y - czm_currentFrustum.x;
   *
   * @see UniformState#currentFrustum
   * @see czm_entireFrustum
   */
  czm_currentFrustum: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.currentFrustum;
    }
  }),
  /**
   * The distances to the frustum planes. The top, bottom, left and right distances are
   * the x, y, z, and w components, respectively.
   */
  czm_frustumPlanes: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.frustumPlanes;
    }
  }),
  /**
   * Gets the far plane's distance from the near plane, plus 1.0.
   */
  czm_farDepthFromNearPlusOne: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.farDepthFromNearPlusOne;
    }
  }),
  /**
   * Gets the log2 of {@link AutomaticUniforms#czm_farDepthFromNearPlusOne}.
   */
  czm_log2FarDepthFromNearPlusOne: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.log2FarDepthFromNearPlusOne;
    }
  }),
  /**
   * Gets 1.0 divided by {@link AutomaticUniforms#czm_log2FarDepthFromNearPlusOne}.
   */
  czm_oneOverLog2FarDepthFromNearPlusOne: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.oneOverLog2FarDepthFromNearPlusOne;
    }
  }),
  /**
   * An automatic GLSL uniform representing the sun position in world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_sunPositionWC;
   *
   * @see UniformState#sunPositionWC
   * @see czm_sunPositionColumbusView
   * @see czm_sunDirectionWC
   */
  czm_sunPositionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunPositionWC;
    }
  }),
  /**
   * An automatic GLSL uniform representing the sun position in Columbus view world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_sunPositionColumbusView;
   *
   * @see UniformState#sunPositionColumbusView
   * @see czm_sunPositionWC
   */
  czm_sunPositionColumbusView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunPositionColumbusView;
    }
  }),
  /**
   * An automatic GLSL uniform representing the normalized direction to the sun in eye coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_sunDirectionEC;
   *
   * // Example
   * float diffuse = max(dot(czm_sunDirectionEC, normalEC), 0.0);
   *
   * @see UniformState#sunDirectionEC
   * @see czm_moonDirectionEC
   * @see czm_sunDirectionWC
   */
  czm_sunDirectionEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunDirectionEC;
    }
  }),
  /**
   * An automatic GLSL uniform representing the normalized direction to the sun in world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_sunDirectionWC;
   *
   * // Example
   * float diffuse = max(dot(czm_sunDirectionWC, normalWC), 0.0);
   *
   * @see UniformState#sunDirectionWC
   * @see czm_sunPositionWC
   * @see czm_sunDirectionEC
   */
  czm_sunDirectionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunDirectionWC;
    }
  }),
  /**
   * An automatic GLSL uniform representing the normalized direction to the moon in eye coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_moonDirectionEC;
   *
   * // Example
   * float diffuse = max(dot(czm_moonDirectionEC, normalEC), 0.0);
   *
   * @see UniformState#moonDirectionEC
   * @see czm_sunDirectionEC
   */
  czm_moonDirectionEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.moonDirectionEC;
    }
  }),
  /**
   * An automatic GLSL uniform representing the normalized direction to the scene's light source in eye coordinates.
   * This is commonly used for directional lighting computations.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_lightDirectionEC;
   *
   * // Example
   * float diffuse = max(dot(czm_lightDirectionEC, normalEC), 0.0);
   *
   * @see UniformState#lightDirectionEC
   * @see czm_lightDirectionWC
   */
  czm_lightDirectionEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightDirectionEC;
    }
  }),
  /**
   * An automatic GLSL uniform representing the normalized direction to the scene's light source in world coordinates.
   * This is commonly used for directional lighting computations.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_lightDirectionWC;
   *
   * // Example
   * float diffuse = max(dot(czm_lightDirectionWC, normalWC), 0.0);
   *
   * @see UniformState#lightDirectionWC
   * @see czm_lightDirectionEC
   */
  czm_lightDirectionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightDirectionWC;
    }
  }),
  /**
   * An automatic GLSL uniform that represents the color of light emitted by the scene's light source. This
   * is equivalent to the light color multiplied by the light intensity limited to a maximum luminance of 1.0
   * suitable for non-HDR lighting.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_lightColor;
   *
   * // Example
   * vec3 diffuseColor = czm_lightColor * max(dot(czm_lightDirectionWC, normalWC), 0.0);
   *
   * @see UniformState#lightColor
   * @see czm_lightColorHdr
   */
  czm_lightColor: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightColor;
    }
  }),
  /**
   * An automatic GLSL uniform that represents the high dynamic range color of light emitted by the scene's light
   * source. This is equivalent to the light color multiplied by the light intensity suitable for HDR lighting.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_lightColorHdr;
   *
   * // Example
   * vec3 diffuseColor = czm_lightColorHdr * max(dot(czm_lightDirectionWC, normalWC), 0.0);
   *
   * @see UniformState#lightColorHdr
   * @see czm_lightColor
   */
  czm_lightColorHdr: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightColorHdr;
    }
  }),
  /**
   * An automatic GLSL uniform representing the high bits of the camera position in model
   * coordinates.  This is used for GPU RTE to eliminate jittering artifacts when rendering
   * as described in {@link http://help.agi.com/AGIComponents/html/BlogPrecisionsPrecisions.htm|Precisions, Precisions}.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_encodedCameraPositionMCHigh;
   *
   * @see czm_encodedCameraPositionMCLow
   * @see czm_modelViewRelativeToEye
   * @see czm_modelViewProjectionRelativeToEye
   */
  czm_encodedCameraPositionMCHigh: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.encodedCameraPositionMCHigh;
    }
  }),
  /**
   * An automatic GLSL uniform representing the low bits of the camera position in model
   * coordinates.  This is used for GPU RTE to eliminate jittering artifacts when rendering
   * as described in {@linkhttp://help.agi.com/AGIComponents/html/BlogPrecisionsPrecisions.htm|Precisions, Precisions}.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_encodedCameraPositionMCLow;
   *
   * @see czm_encodedCameraPositionMCHigh
   * @see czm_modelViewRelativeToEye
   * @see czm_modelViewProjectionRelativeToEye
   */
  czm_encodedCameraPositionMCLow: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.encodedCameraPositionMCLow;
    }
  }),
  /**
   * An automatic GLSL uniform representing the position of the viewer (camera) in world coordinates.
   *
   * @example
   * // GLSL declaration
   * uniform vec3 czm_viewerPositionWC;
   */
  czm_viewerPositionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return Matrix4_default.getTranslation(
        uniformState.inverseView,
        viewerPositionWCScratch
      );
    }
  }),
  /**
   * An automatic GLSL uniform representing the frame number. This uniform is automatically incremented
   * every frame.
   *
   * @example
   * // GLSL declaration
   * uniform float czm_frameNumber;
   */
  czm_frameNumber: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.frameState.frameNumber;
    }
  }),
  /**
   * An automatic GLSL uniform representing the current morph transition time between
   * 2D/Columbus View and 3D, with 0.0 being 2D or Columbus View and 1.0 being 3D.
   *
   * @example
   * // GLSL declaration
   * uniform float czm_morphTime;
   *
   * // Example
   * vec4 p = czm_columbusViewMorph(position2D, position3D, czm_morphTime);
   */
  czm_morphTime: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.frameState.morphTime;
    }
  }),
  /**
   * An automatic GLSL uniform representing the current {@link SceneMode}, expressed
   * as a float.
   *
   * @example
   * // GLSL declaration
   * uniform float czm_sceneMode;
   *
   * // Example
   * if (czm_sceneMode == czm_sceneMode2D)
   * {
   *     eyeHeightSq = czm_eyeHeight2D.y;
   * }
   *
   * @see czm_sceneMode2D
   * @see czm_sceneModeColumbusView
   * @see czm_sceneMode3D
   * @see czm_sceneModeMorphing
   */
  czm_sceneMode: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.frameState.mode;
    }
  }),
  /**
   * An automatic GLSL uniform representing the current rendering pass.
   *
   * @example
   * // GLSL declaration
   * uniform float czm_pass;
   *
   * // Example
   * if ((czm_pass == czm_passTranslucent) && isOpaque())
   * {
   *     gl_Position *= 0.0; // Cull opaque geometry in the translucent pass
   * }
   */
  czm_pass: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.pass;
    }
  }),
  /**
   * An automatic GLSL uniform representing the current scene background color.
   *
   * @example
   * // GLSL declaration
   * uniform vec4 czm_backgroundColor;
   *
   * // Example: If the given color's RGB matches the background color, invert it.
   * vec4 adjustColorForContrast(vec4 color)
   * {
   *     if (czm_backgroundColor.rgb == color.rgb)
   *     {
   *         color.rgb = vec3(1.0) - color.rgb;
   *     }
   *
   *     return color;
   * }
   */
  czm_backgroundColor: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.backgroundColor;
    }
  }),
  /**
   * An automatic GLSL uniform containing the BRDF look up texture used for image-based lighting computations.
   *
   * @example
   * // GLSL declaration
   * uniform sampler2D czm_brdfLut;
   *
   * // Example: For a given roughness and NdotV value, find the material's BRDF information in the red and green channels
   * float roughness = 0.5;
   * float NdotV = dot(normal, view);
   * vec2 brdfLut = texture(czm_brdfLut, vec2(NdotV, roughness)).rg;
   */
  czm_brdfLut: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.brdfLut;
    }
  }),
  /**
   * An automatic GLSL uniform containing the environment map used within the scene.
   *
   * @example
   * // GLSL declaration
   * uniform samplerCube czm_environmentMap;
   *
   * // Example: Create a perfect reflection of the environment map on a  model
   * float reflected = reflect(view, normal);
   * vec4 reflectedColor = texture(czm_environmentMap, reflected);
   */
  czm_environmentMap: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_CUBE,
    getValue: function(uniformState) {
      return uniformState.environmentMap;
    }
  }),
  /**
   * An automatic GLSL uniform containing the specular environment cube map used within the scene.
   *
   * @example
   * // GLSL declaration
   * uniform samplerCube czm_specularEnvironmentMaps;
   */
  czm_specularEnvironmentMaps: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_CUBE,
    getValue: function(uniformState) {
      return uniformState.specularEnvironmentMaps;
    }
  }),
  /**
   * An automatic GLSL uniform containing the maximum valid level-of-detail of the specular environment cube map used within the scene.
   *
   * @example
   * // GLSL declaration
   * uniform float czm_specularEnvironmentMapsMaximumLOD;
   */
  czm_specularEnvironmentMapsMaximumLOD: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.specularEnvironmentMapsMaximumLOD;
    }
  }),
  /**
   * An automatic GLSL uniform containing the spherical harmonic coefficients used within the scene.
   *
   * @example
   * // GLSL declaration
   * uniform vec3[9] czm_sphericalHarmonicCoefficients;
   */
  czm_sphericalHarmonicCoefficients: new AutomaticUniform({
    size: 9,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sphericalHarmonicCoefficients;
    }
  }),
  /**
   * An automatic GLSL uniform representing a 3x3 rotation matrix that transforms
   * from True Equator Mean Equinox (TEME) axes to the pseudo-fixed axes at the current scene time.
   *
   * @example
   * // GLSL declaration
   * uniform mat3 czm_temeToPseudoFixed;
   *
   * // Example
   * vec3 pseudoFixed = czm_temeToPseudoFixed * teme;
   *
   * @see UniformState#temeToPseudoFixedMatrix
   * @see Transforms.computeTemeToPseudoFixedMatrix
   */
  czm_temeToPseudoFixed: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.temeToPseudoFixedMatrix;
    }
  }),
  /**
   * An automatic GLSL uniform representing the ratio of canvas coordinate space to canvas pixel space.
   *
   * @example
   * uniform float czm_pixelRatio;
   */
  czm_pixelRatio: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.pixelRatio;
    }
  }),
  /**
   * An automatic GLSL uniform scalar used to mix a color with the fog color based on the distance to the camera.
   *
   * @see czm_fog
   */
  czm_fogDensity: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.fogDensity;
    }
  }),
  /**
   * An automatic GLSL uniform scalar used to mix a color with the fog color based on the distance to the camera.
   *
   * @see czm_fog
   */
  czm_fogVisualDensityScalar: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.fogVisualDensityScalar;
    }
  }),
  /**
   * An automatic GLSL uniform scalar used to set a minimum brightness when dynamic lighting is applied to fog.
   *
   * @see czm_fog
   */
  czm_fogMinimumBrightness: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.fogMinimumBrightness;
    }
  }),
  /**
   * An automatic uniform representing the color shift for the atmosphere in HSB color space
   *
   * @example
   * uniform vec3 czm_atmosphereHsbShift;
   */
  czm_atmosphereHsbShift: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.atmosphereHsbShift;
    }
  }),
  /**
   * An automatic uniform representing the intensity of the light that is used for computing the atmosphere color
   *
   * @example
   * uniform float czm_atmosphereLightIntensity;
   */
  czm_atmosphereLightIntensity: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.atmosphereLightIntensity;
    }
  }),
  /**
   * An automatic uniform representing the Rayleigh scattering coefficient used when computing the atmosphere scattering
   *
   * @example
   * uniform vec3 czm_atmosphereRayleighCoefficient;
   */
  czm_atmosphereRayleighCoefficient: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.atmosphereRayleighCoefficient;
    }
  }),
  /**
   * An automatic uniform representing the Rayleigh scale height in meters used for computing atmosphere scattering.
   *
   * @example
   * uniform vec3 czm_atmosphereRayleighScaleHeight;
   */
  czm_atmosphereRayleighScaleHeight: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.atmosphereRayleighScaleHeight;
    }
  }),
  /**
   * An automatic uniform representing the Mie scattering coefficient used when computing atmosphere scattering.
   *
   * @example
   * uniform vec3 czm_atmosphereMieCoefficient;
   */
  czm_atmosphereMieCoefficient: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.atmosphereMieCoefficient;
    }
  }),
  /**
   * An automatic uniform storign the Mie scale height used when computing atmosphere scattering.
   *
   * @example
   * uniform float czm_atmosphereMieScaleHeight;
   */
  czm_atmosphereMieScaleHeight: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.atmosphereMieScaleHeight;
    }
  }),
  /**
   * An automatic uniform representing the anisotropy of the medium to consider for Mie scattering.
   *
   * @example
   * uniform float czm_atmosphereAnisotropy;
   */
  czm_atmosphereMieAnisotropy: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.atmosphereMieAnisotropy;
    }
  }),
  /**
   * An automatic uniform representing which light source to use for dynamic lighting
   *
   * @example
   * uniform float czm_atmosphereDynamicLighting
   */
  czm_atmosphereDynamicLighting: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.atmosphereDynamicLighting;
    }
  }),
  /**
   * An automatic GLSL uniform representing the splitter position to use when rendering with a splitter.
   * This will be in pixel coordinates relative to the canvas.
   *
   * @example
   * // GLSL declaration
   * uniform float czm_splitPosition;
   */
  czm_splitPosition: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.splitPosition;
    }
  }),
  /**
   * An automatic GLSL uniform scalar representing the geometric tolerance per meter
   */
  czm_geometricToleranceOverMeter: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.geometricToleranceOverMeter;
    }
  }),
  /**
   * An automatic GLSL uniform representing the distance from the camera at which to disable the depth test of billboards, labels and points
   * to, for example, prevent clipping against terrain. When set to zero, the depth test should always be applied. When less than zero,
   * the depth test should never be applied.
   */
  czm_minimumDisableDepthTestDistance: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.minimumDisableDepthTestDistance;
    }
  }),
  /**
   * An automatic GLSL uniform that will be the highlight color of unclassified 3D Tiles.
   */
  czm_invertClassificationColor: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.invertClassificationColor;
    }
  }),
  /**
   * An automatic GLSL uniform that is used for gamma correction.
   */
  czm_gamma: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.gamma;
    }
  }),
  /**
   * An automatic GLSL uniform that stores the ellipsoid radii.
   */
  czm_ellipsoidRadii: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.ellipsoid.radii;
    }
  }),
  /**
   * An automatic GLSL uniform that stores the ellipsoid inverse radii.
   */
  czm_ellipsoidInverseRadii: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.ellipsoid.oneOverRadii;
    }
  })
};
var AutomaticUniforms_default = AutomaticUniforms;

// packages/engine/Source/Core/createGuid.js
function createGuid() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
    const r = Math.random() * 16 | 0;
    const v3 = c === "x" ? r : r & 3 | 8;
    return v3.toString(16);
  });
}
var createGuid_default = createGuid;

// packages/engine/Source/Core/destroyObject.js
function returnTrue() {
  return true;
}
function destroyObject(object, message) {
  message = message ?? "This object was destroyed, i.e., destroy() was called.";
  function throwOnDestroyed() {
    throw new DeveloperError_default(message);
  }
  for (const key in object) {
    if (typeof object[key] === "function") {
      object[key] = throwOnDestroyed;
    }
  }
  object.isDestroyed = returnTrue;
  return void 0;
}
var destroyObject_default = destroyObject;

// packages/engine/Source/Core/IndexDatatype.js
var IndexDatatype = {
  /**
   * 8-bit unsigned byte corresponding to <code>UNSIGNED_BYTE</code> and the type
   * of an element in <code>Uint8Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
  /**
   * 16-bit unsigned short corresponding to <code>UNSIGNED_SHORT</code> and the type
   * of an element in <code>Uint16Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
  /**
   * 32-bit unsigned int corresponding to <code>UNSIGNED_INT</code> and the type
   * of an element in <code>Uint32Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT
};
IndexDatatype.getSizeInBytes = function(indexDatatype) {
  switch (indexDatatype) {
    case IndexDatatype.UNSIGNED_BYTE:
      return Uint8Array.BYTES_PER_ELEMENT;
    case IndexDatatype.UNSIGNED_SHORT:
      return Uint16Array.BYTES_PER_ELEMENT;
    case IndexDatatype.UNSIGNED_INT:
      return Uint32Array.BYTES_PER_ELEMENT;
  }
  throw new DeveloperError_default(
    "indexDatatype is required and must be a valid IndexDatatype constant."
  );
};
IndexDatatype.fromSizeInBytes = function(sizeInBytes) {
  switch (sizeInBytes) {
    case 2:
      return IndexDatatype.UNSIGNED_SHORT;
    case 4:
      return IndexDatatype.UNSIGNED_INT;
    case 1:
      return IndexDatatype.UNSIGNED_BYTE;
    //>>includeStart('debug', pragmas.debug);
    default:
      throw new DeveloperError_default(
        "Size in bytes cannot be mapped to an IndexDatatype"
      );
  }
};
IndexDatatype.validate = function(indexDatatype) {
  return defined_default(indexDatatype) && (indexDatatype === IndexDatatype.UNSIGNED_BYTE || indexDatatype === IndexDatatype.UNSIGNED_SHORT || indexDatatype === IndexDatatype.UNSIGNED_INT);
};
IndexDatatype.createTypedArray = function(numberOfVertices, indicesLengthOrArray) {
  if (!defined_default(numberOfVertices)) {
    throw new DeveloperError_default("numberOfVertices is required.");
  }
  if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
    return new Uint32Array(indicesLengthOrArray);
  }
  return new Uint16Array(indicesLengthOrArray);
};
IndexDatatype.createTypedArrayFromArrayBuffer = function(numberOfVertices, sourceArray, byteOffset, length2) {
  if (!defined_default(numberOfVertices)) {
    throw new DeveloperError_default("numberOfVertices is required.");
  }
  if (!defined_default(sourceArray)) {
    throw new DeveloperError_default("sourceArray is required.");
  }
  if (!defined_default(byteOffset)) {
    throw new DeveloperError_default("byteOffset is required.");
  }
  if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
    return new Uint32Array(sourceArray, byteOffset, length2);
  }
  return new Uint16Array(sourceArray, byteOffset, length2);
};
IndexDatatype.fromTypedArray = function(array) {
  if (array instanceof Uint8Array) {
    return IndexDatatype.UNSIGNED_BYTE;
  }
  if (array instanceof Uint16Array) {
    return IndexDatatype.UNSIGNED_SHORT;
  }
  if (array instanceof Uint32Array) {
    return IndexDatatype.UNSIGNED_INT;
  }
  throw new DeveloperError_default(
    "array must be a Uint8Array, Uint16Array, or Uint32Array."
  );
};
var IndexDatatype_default = Object.freeze(IndexDatatype);

// packages/engine/Source/Renderer/BufferUsage.js
var BufferUsage = {
  STREAM_DRAW: WebGLConstants_default.STREAM_DRAW,
  STATIC_DRAW: WebGLConstants_default.STATIC_DRAW,
  DYNAMIC_DRAW: WebGLConstants_default.DYNAMIC_DRAW,
  DYNAMIC_READ: WebGLConstants_default.DYNAMIC_READ,
  validate: function(bufferUsage) {
    return bufferUsage === BufferUsage.STREAM_DRAW || bufferUsage === BufferUsage.STATIC_DRAW || bufferUsage === BufferUsage.DYNAMIC_DRAW || bufferUsage === BufferUsage.DYNAMIC_READ;
  }
};
var BufferUsage_default = Object.freeze(BufferUsage);

// packages/engine/Source/Renderer/Buffer.js
function Buffer2(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  Check_default.defined("options.context", options.context);
  if (!defined_default(options.typedArray) && !defined_default(options.sizeInBytes)) {
    throw new DeveloperError_default(
      "Either options.sizeInBytes or options.typedArray is required."
    );
  }
  if (defined_default(options.typedArray) && defined_default(options.sizeInBytes)) {
    throw new DeveloperError_default(
      "Cannot pass in both options.sizeInBytes and options.typedArray."
    );
  }
  if (defined_default(options.typedArray)) {
    Check_default.typeOf.object("options.typedArray", options.typedArray);
    Check_default.typeOf.number(
      "options.typedArray.byteLength",
      options.typedArray.byteLength
    );
  }
  if (!BufferUsage_default.validate(options.usage)) {
    throw new DeveloperError_default("usage is invalid.");
  }
  const gl = options.context._gl;
  const bufferTarget = options.bufferTarget;
  const typedArray = options.typedArray;
  let sizeInBytes = options.sizeInBytes;
  const usage = options.usage;
  const hasArray = defined_default(typedArray);
  if (hasArray) {
    sizeInBytes = typedArray.byteLength;
  }
  Check_default.typeOf.number.greaterThan("sizeInBytes", sizeInBytes, 0);
  const buffer2 = gl.createBuffer();
  gl.bindBuffer(bufferTarget, buffer2);
  gl.bufferData(bufferTarget, hasArray ? typedArray : sizeInBytes, usage);
  gl.bindBuffer(bufferTarget, null);
  this._id = createGuid_default();
  this._gl = gl;
  this._webgl2 = options.context._webgl2;
  this._bufferTarget = bufferTarget;
  this._sizeInBytes = sizeInBytes;
  this._usage = usage;
  this._buffer = buffer2;
  this.vertexArrayDestroyable = true;
}
Buffer2.createPixelBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  if (!options.context._webgl2) {
    throw new DeveloperError_default(
      "A WebGL 2 context is required to create PixelBuffers."
    );
  }
  return new Buffer2({
    context: options.context,
    bufferTarget: WebGLConstants_default.PIXEL_PACK_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
};
Buffer2.createVertexBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  return new Buffer2({
    context: options.context,
    bufferTarget: WebGLConstants_default.ARRAY_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
};
Buffer2.createIndexBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  if (!IndexDatatype_default.validate(options.indexDatatype)) {
    throw new DeveloperError_default("Invalid indexDatatype.");
  }
  if (options.indexDatatype === IndexDatatype_default.UNSIGNED_INT && !options.context.elementIndexUint) {
    throw new DeveloperError_default(
      "IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.  Check context.elementIndexUint."
    );
  }
  const context = options.context;
  const indexDatatype = options.indexDatatype;
  const bytesPerIndex = IndexDatatype_default.getSizeInBytes(indexDatatype);
  const buffer2 = new Buffer2({
    context,
    bufferTarget: WebGLConstants_default.ELEMENT_ARRAY_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
  const numberOfIndices = buffer2.sizeInBytes / bytesPerIndex;
  Object.defineProperties(buffer2, {
    indexDatatype: {
      get: function() {
        return indexDatatype;
      }
    },
    bytesPerIndex: {
      get: function() {
        return bytesPerIndex;
      }
    },
    numberOfIndices: {
      get: function() {
        return numberOfIndices;
      }
    }
  });
  return buffer2;
};
Object.defineProperties(Buffer2.prototype, {
  sizeInBytes: {
    get: function() {
      return this._sizeInBytes;
    }
  },
  usage: {
    get: function() {
      return this._usage;
    }
  }
});
Buffer2.prototype._getBuffer = function() {
  return this._buffer;
};
Buffer2.prototype._bind = function() {
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, this._buffer);
};
Buffer2.prototype._unBind = function() {
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, null);
};
Buffer2.prototype.copyFromArrayView = function(arrayView, offsetInBytes) {
  offsetInBytes = offsetInBytes ?? 0;
  Check_default.defined("arrayView", arrayView);
  Check_default.typeOf.number.lessThanOrEquals(
    "offsetInBytes + arrayView.byteLength",
    offsetInBytes + arrayView.byteLength,
    this._sizeInBytes
  );
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, this._buffer);
  gl.bufferSubData(target, offsetInBytes, arrayView);
  gl.bindBuffer(target, null);
};
Buffer2.prototype.copyFromBuffer = function(readBuffer, readOffset, writeOffset, sizeInBytes) {
  if (!this._webgl2) {
    throw new DeveloperError_default("A WebGL 2 context is required.");
  }
  if (!defined_default(readBuffer)) {
    throw new DeveloperError_default("readBuffer must be defined.");
  }
  if (!defined_default(sizeInBytes) || sizeInBytes <= 0) {
    throw new DeveloperError_default(
      "sizeInBytes must be defined and be greater than zero."
    );
  }
  if (!defined_default(readOffset) || readOffset < 0 || readOffset + sizeInBytes > readBuffer._sizeInBytes) {
    throw new DeveloperError_default(
      "readOffset must be greater than or equal to zero and readOffset + sizeInBytes must be less than of equal to readBuffer.sizeInBytes."
    );
  }
  if (!defined_default(writeOffset) || writeOffset < 0 || writeOffset + sizeInBytes > this._sizeInBytes) {
    throw new DeveloperError_default(
      "writeOffset must be greater than or equal to zero and writeOffset + sizeInBytes must be less than of equal to this.sizeInBytes."
    );
  }
  if (this._buffer === readBuffer._buffer && (writeOffset >= readOffset && writeOffset < readOffset + sizeInBytes || readOffset > writeOffset && readOffset < writeOffset + sizeInBytes)) {
    throw new DeveloperError_default(
      "When readBuffer is equal to this, the ranges [readOffset + sizeInBytes) and [writeOffset, writeOffset + sizeInBytes) must not overlap."
    );
  }
  if (this._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER || this._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER) {
    throw new DeveloperError_default(
      "Can not copy an index buffer into another buffer type."
    );
  }
  const readTarget = WebGLConstants_default.COPY_READ_BUFFER;
  const writeTarget = WebGLConstants_default.COPY_WRITE_BUFFER;
  const gl = this._gl;
  gl.bindBuffer(writeTarget, this._buffer);
  gl.bindBuffer(readTarget, readBuffer._buffer);
  gl.copyBufferSubData(
    readTarget,
    writeTarget,
    readOffset,
    writeOffset,
    sizeInBytes
  );
  gl.bindBuffer(writeTarget, null);
  gl.bindBuffer(readTarget, null);
};
Buffer2.prototype.getBufferData = function(arrayView, sourceOffset, destinationOffset, length2) {
  sourceOffset = sourceOffset ?? 0;
  destinationOffset = destinationOffset ?? 0;
  if (!this._webgl2) {
    throw new DeveloperError_default("A WebGL 2 context is required.");
  }
  if (!defined_default(arrayView)) {
    throw new DeveloperError_default("arrayView is required.");
  }
  let copyLength;
  let elementSize;
  let arrayLength = arrayView.byteLength;
  if (!defined_default(length2)) {
    if (defined_default(arrayLength)) {
      copyLength = arrayLength - destinationOffset;
      elementSize = 1;
    } else {
      arrayLength = arrayView.length;
      copyLength = arrayLength - destinationOffset;
      elementSize = arrayView.BYTES_PER_ELEMENT;
    }
  } else {
    copyLength = length2;
    if (defined_default(arrayLength)) {
      elementSize = 1;
    } else {
      arrayLength = arrayView.length;
      elementSize = arrayView.BYTES_PER_ELEMENT;
    }
  }
  if (destinationOffset < 0 || destinationOffset > arrayLength) {
    throw new DeveloperError_default(
      "destinationOffset must be greater than zero and less than the arrayView length."
    );
  }
  if (destinationOffset + copyLength > arrayLength) {
    throw new DeveloperError_default(
      "destinationOffset + length must be less than or equal to the arrayViewLength."
    );
  }
  if (sourceOffset < 0 || sourceOffset > this._sizeInBytes) {
    throw new DeveloperError_default(
      "sourceOffset must be greater than zero and less than the buffers size."
    );
  }
  if (sourceOffset + copyLength * elementSize > this._sizeInBytes) {
    throw new DeveloperError_default(
      "sourceOffset + length must be less than the buffers size."
    );
  }
  const gl = this._gl;
  const target = WebGLConstants_default.COPY_READ_BUFFER;
  gl.bindBuffer(target, this._buffer);
  gl.getBufferSubData(
    target,
    sourceOffset,
    arrayView,
    destinationOffset,
    length2
  );
  gl.bindBuffer(target, null);
};
Buffer2.prototype.isDestroyed = function() {
  return false;
};
Buffer2.prototype.destroy = function() {
  this._gl.deleteBuffer(this._buffer);
  return destroyObject_default(this);
};
var Buffer_default = Buffer2;

// packages/engine/Source/Core/Fullscreen.js
var _supportsFullscreen;
var _names = {
  requestFullscreen: void 0,
  exitFullscreen: void 0,
  fullscreenEnabled: void 0,
  fullscreenElement: void 0,
  fullscreenchange: void 0,
  fullscreenerror: void 0
};
var Fullscreen = {};
Object.defineProperties(Fullscreen, {
  /**
   * The element that is currently fullscreen, if any.  To simply check if the
   * browser is in fullscreen mode or not, use {@link Fullscreen#fullscreen}.
   * @memberof Fullscreen
   * @type {object}
   * @readonly
   */
  element: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenElement];
    }
  },
  /**
   * The name of the event on the document that is fired when fullscreen is
   * entered or exited.  This event name is intended for use with addEventListener.
   * In your event handler, to determine if the browser is in fullscreen mode or not,
   * use {@link Fullscreen#fullscreen}.
   * @memberof Fullscreen
   * @type {string}
   * @readonly
   */
  changeEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenchange;
    }
  },
  /**
   * The name of the event that is fired when a fullscreen error
   * occurs.  This event name is intended for use with addEventListener.
   * @memberof Fullscreen
   * @type {string}
   * @readonly
   */
  errorEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenerror;
    }
  },
  /**
   * Determine whether the browser will allow an element to be made fullscreen, or not.
   * For example, by default, iframes cannot go fullscreen unless the containing page
   * adds an "allowfullscreen" attribute (or prefixed equivalent).
   * @memberof Fullscreen
   * @type {boolean}
   * @readonly
   */
  enabled: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenEnabled];
    }
  },
  /**
   * Determines if the browser is currently in fullscreen mode.
   * @memberof Fullscreen
   * @type {boolean}
   * @readonly
   */
  fullscreen: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return Fullscreen.element !== null;
    }
  }
});
Fullscreen.supportsFullscreen = function() {
  if (defined_default(_supportsFullscreen)) {
    return _supportsFullscreen;
  }
  _supportsFullscreen = false;
  const body = document.body;
  if (typeof body.requestFullscreen === "function") {
    _names.requestFullscreen = "requestFullscreen";
    _names.exitFullscreen = "exitFullscreen";
    _names.fullscreenEnabled = "fullscreenEnabled";
    _names.fullscreenElement = "fullscreenElement";
    _names.fullscreenchange = "fullscreenchange";
    _names.fullscreenerror = "fullscreenerror";
    _supportsFullscreen = true;
    return _supportsFullscreen;
  }
  const prefixes = ["webkit", "moz", "o", "ms", "khtml"];
  let name;
  for (let i = 0, len = prefixes.length; i < len; ++i) {
    const prefix = prefixes[i];
    name = `${prefix}RequestFullscreen`;
    if (typeof body[name] === "function") {
      _names.requestFullscreen = name;
      _supportsFullscreen = true;
    } else {
      name = `${prefix}RequestFullScreen`;
      if (typeof body[name] === "function") {
        _names.requestFullscreen = name;
        _supportsFullscreen = true;
      }
    }
    name = `${prefix}ExitFullscreen`;
    if (typeof document[name] === "function") {
      _names.exitFullscreen = name;
    } else {
      name = `${prefix}CancelFullScreen`;
      if (typeof document[name] === "function") {
        _names.exitFullscreen = name;
      }
    }
    name = `${prefix}FullscreenEnabled`;
    if (document[name] !== void 0) {
      _names.fullscreenEnabled = name;
    } else {
      name = `${prefix}FullScreenEnabled`;
      if (document[name] !== void 0) {
        _names.fullscreenEnabled = name;
      }
    }
    name = `${prefix}FullscreenElement`;
    if (document[name] !== void 0) {
      _names.fullscreenElement = name;
    } else {
      name = `${prefix}FullScreenElement`;
      if (document[name] !== void 0) {
        _names.fullscreenElement = name;
      }
    }
    name = `${prefix}fullscreenchange`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenChange";
      }
      _names.fullscreenchange = name;
    }
    name = `${prefix}fullscreenerror`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenError";
      }
      _names.fullscreenerror = name;
    }
  }
  return _supportsFullscreen;
};
Fullscreen.requestFullscreen = function(element, vrDevice) {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  element[_names.requestFullscreen]({ vrDisplay: vrDevice });
};
Fullscreen.exitFullscreen = function() {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  document[_names.exitFullscreen]();
};
Fullscreen._names = _names;
var Fullscreen_default = Fullscreen;

// packages/engine/Source/Core/FeatureDetection.js
var theNavigator;
if (typeof navigator !== "undefined") {
  theNavigator = navigator;
} else {
  theNavigator = {};
}
function extractVersion(versionString) {
  const parts = versionString.split(".");
  for (let i = 0, len = parts.length; i < len; ++i) {
    parts[i] = parseInt(parts[i], 10);
  }
  return parts;
}
var isChromeResult;
var chromeVersionResult;
function isChrome() {
  if (!defined_default(isChromeResult)) {
    isChromeResult = false;
    if (!isEdge()) {
      const fields = / Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isChromeResult = true;
        chromeVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isChromeResult;
}
function chromeVersion() {
  return isChrome() && chromeVersionResult;
}
var isSafariResult;
var safariVersionResult;
function isSafari() {
  if (!defined_default(isSafariResult)) {
    isSafariResult = false;
    if (!isChrome() && !isEdge() && / Safari\/[\.0-9]+/.test(theNavigator.userAgent)) {
      const fields = / Version\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isSafariResult = true;
        safariVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isSafariResult;
}
function safariVersion() {
  return isSafari() && safariVersionResult;
}
var isWebkitResult;
var webkitVersionResult;
function isWebkit() {
  if (!defined_default(isWebkitResult)) {
    isWebkitResult = false;
    const fields = / AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isWebkitResult = true;
      webkitVersionResult = extractVersion(fields[1]);
      webkitVersionResult.isNightly = !!fields[2];
    }
  }
  return isWebkitResult;
}
function webkitVersion() {
  return isWebkit() && webkitVersionResult;
}
var isEdgeResult;
var edgeVersionResult;
function isEdge() {
  if (!defined_default(isEdgeResult)) {
    isEdgeResult = false;
    const fields = / Edg\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isEdgeResult = true;
      edgeVersionResult = extractVersion(fields[1]);
    }
  }
  return isEdgeResult;
}
function edgeVersion() {
  return isEdge() && edgeVersionResult;
}
var isFirefoxResult;
var firefoxVersionResult;
function isFirefox() {
  if (!defined_default(isFirefoxResult)) {
    isFirefoxResult = false;
    const fields = /Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isFirefoxResult = true;
      firefoxVersionResult = extractVersion(fields[1]);
    }
  }
  return isFirefoxResult;
}
var isWindowsResult;
function isWindows() {
  if (!defined_default(isWindowsResult)) {
    isWindowsResult = /Windows/i.test(theNavigator.appVersion);
  }
  return isWindowsResult;
}
var isIPadOrIOSResult;
function isIPadOrIOS() {
  if (!defined_default(isIPadOrIOSResult)) {
    isIPadOrIOSResult = navigator.platform === "iPhone" || navigator.platform === "iPod" || navigator.platform === "iPad";
  }
  return isIPadOrIOSResult;
}
function firefoxVersion() {
  return isFirefox() && firefoxVersionResult;
}
var hasPointerEvents;
function supportsPointerEvents() {
  if (!defined_default(hasPointerEvents)) {
    hasPointerEvents = !isFirefox() && typeof PointerEvent !== "undefined" && (!defined_default(theNavigator.pointerEnabled) || theNavigator.pointerEnabled);
  }
  return hasPointerEvents;
}
var imageRenderingValueResult;
var supportsImageRenderingPixelatedResult;
function supportsImageRenderingPixelated() {
  if (!defined_default(supportsImageRenderingPixelatedResult)) {
    const canvas = document.createElement("canvas");
    canvas.setAttribute(
      "style",
      "image-rendering: -moz-crisp-edges;image-rendering: pixelated;"
    );
    const tmp2 = canvas.style.imageRendering;
    supportsImageRenderingPixelatedResult = defined_default(tmp2) && tmp2 !== "";
    if (supportsImageRenderingPixelatedResult) {
      imageRenderingValueResult = tmp2;
    }
  }
  return supportsImageRenderingPixelatedResult;
}
function imageRenderingValue() {
  return supportsImageRenderingPixelated() ? imageRenderingValueResult : void 0;
}
function supportsWebP() {
  if (!supportsWebP.initialized) {
    throw new DeveloperError_default(
      "You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP"
    );
  }
  return supportsWebP._result;
}
supportsWebP._promise = void 0;
supportsWebP._result = void 0;
supportsWebP.initialize = function() {
  if (defined_default(supportsWebP._promise)) {
    return supportsWebP._promise;
  }
  supportsWebP._promise = new Promise((resolve2) => {
    const image = new Image();
    image.onload = function() {
      supportsWebP._result = image.width > 0 && image.height > 0;
      resolve2(supportsWebP._result);
    };
    image.onerror = function() {
      supportsWebP._result = false;
      resolve2(supportsWebP._result);
    };
    image.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
  });
  return supportsWebP._promise;
};
Object.defineProperties(supportsWebP, {
  initialized: {
    get: function() {
      return defined_default(supportsWebP._result);
    }
  }
});
var typedArrayTypes = [];
if (typeof ArrayBuffer !== "undefined") {
  typedArrayTypes.push(
    Int8Array,
    Uint8Array,
    Int16Array,
    Uint16Array,
    Int32Array,
    Uint32Array,
    Float32Array,
    Float64Array
  );
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof BigInt64Array !== "undefined") {
    typedArrayTypes.push(BigInt64Array);
  }
  if (typeof BigUint64Array !== "undefined") {
    typedArrayTypes.push(BigUint64Array);
  }
}
var FeatureDetection = {
  isChrome,
  chromeVersion,
  isSafari,
  safariVersion,
  isWebkit,
  webkitVersion,
  isEdge,
  edgeVersion,
  isFirefox,
  firefoxVersion,
  isWindows,
  isIPadOrIOS,
  hardwareConcurrency: theNavigator.hardwareConcurrency ?? 3,
  supportsPointerEvents,
  supportsImageRenderingPixelated,
  supportsWebP,
  imageRenderingValue,
  typedArrayTypes
};
FeatureDetection.supportsBasis = function(scene) {
  return FeatureDetection.supportsWebAssembly() && scene.context.supportsBasis;
};
FeatureDetection.supportsFullscreen = function() {
  return Fullscreen_default.supportsFullscreen();
};
FeatureDetection.supportsTypedArrays = function() {
  return typeof ArrayBuffer !== "undefined";
};
FeatureDetection.supportsBigInt64Array = function() {
  return typeof BigInt64Array !== "undefined";
};
FeatureDetection.supportsBigUint64Array = function() {
  return typeof BigUint64Array !== "undefined";
};
FeatureDetection.supportsBigInt = function() {
  return typeof BigInt !== "undefined";
};
FeatureDetection.supportsWebWorkers = function() {
  return typeof Worker !== "undefined";
};
FeatureDetection.supportsWebAssembly = function() {
  return typeof WebAssembly !== "undefined";
};
FeatureDetection.supportsWebgl2 = function(scene) {
  Check_default.defined("scene", scene);
  return scene.context.webgl2;
};
FeatureDetection.supportsEsmWebWorkers = function() {
  return !isFirefox() || parseInt(firefoxVersionResult) >= 114;
};
var FeatureDetection_default = FeatureDetection;

// packages/engine/Source/Core/Color.js
function hue2rgb(m1, m2, h) {
  if (h < 0) {
    h += 1;
  }
  if (h > 1) {
    h -= 1;
  }
  if (h * 6 < 1) {
    return m1 + (m2 - m1) * 6 * h;
  }
  if (h * 2 < 1) {
    return m2;
  }
  if (h * 3 < 2) {
    return m1 + (m2 - m1) * (2 / 3 - h) * 6;
  }
  return m1;
}
function Color(red, green, blue, alpha) {
  this.red = red ?? 1;
  this.green = green ?? 1;
  this.blue = blue ?? 1;
  this.alpha = alpha ?? 1;
}
Color.fromCartesian4 = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  if (!defined_default(result)) {
    return new Color(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  }
  result.red = cartesian11.x;
  result.green = cartesian11.y;
  result.blue = cartesian11.z;
  result.alpha = cartesian11.w;
  return result;
};
Color.fromBytes = function(red, green, blue, alpha, result) {
  red = Color.byteToFloat(red ?? 255);
  green = Color.byteToFloat(green ?? 255);
  blue = Color.byteToFloat(blue ?? 255);
  alpha = Color.byteToFloat(alpha ?? 255);
  if (!defined_default(result)) {
    return new Color(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
Color.fromAlpha = function(color, alpha, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("alpha", alpha);
  if (!defined_default(result)) {
    return new Color(color.red, color.green, color.blue, alpha);
  }
  result.red = color.red;
  result.green = color.green;
  result.blue = color.blue;
  result.alpha = alpha;
  return result;
};
var scratchArrayBuffer;
var scratchUint32Array;
var scratchUint8Array;
if (FeatureDetection_default.supportsTypedArrays()) {
  scratchArrayBuffer = new ArrayBuffer(4);
  scratchUint32Array = new Uint32Array(scratchArrayBuffer);
  scratchUint8Array = new Uint8Array(scratchArrayBuffer);
}
Color.fromRgba = function(rgba, result) {
  scratchUint32Array[0] = rgba;
  return Color.fromBytes(
    scratchUint8Array[0],
    scratchUint8Array[1],
    scratchUint8Array[2],
    scratchUint8Array[3],
    result
  );
};
Color.fromHsl = function(hue, saturation, lightness, alpha, result) {
  hue = (hue ?? 0) % 1;
  saturation = saturation ?? 0;
  lightness = lightness ?? 0;
  alpha = alpha ?? 1;
  let red = lightness;
  let green = lightness;
  let blue = lightness;
  if (saturation !== 0) {
    let m2;
    if (lightness < 0.5) {
      m2 = lightness * (1 + saturation);
    } else {
      m2 = lightness + saturation - lightness * saturation;
    }
    const m1 = 2 * lightness - m2;
    red = hue2rgb(m1, m2, hue + 1 / 3);
    green = hue2rgb(m1, m2, hue);
    blue = hue2rgb(m1, m2, hue - 1 / 3);
  }
  if (!defined_default(result)) {
    return new Color(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
Color.fromRandom = function(options, result) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  let red = options.red;
  if (!defined_default(red)) {
    const minimumRed = options.minimumRed ?? 0;
    const maximumRed = options.maximumRed ?? 1;
    Check_default.typeOf.number.lessThanOrEquals("minimumRed", minimumRed, maximumRed);
    red = minimumRed + Math_default.nextRandomNumber() * (maximumRed - minimumRed);
  }
  let green = options.green;
  if (!defined_default(green)) {
    const minimumGreen = options.minimumGreen ?? 0;
    const maximumGreen = options.maximumGreen ?? 1;
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumGreen",
      minimumGreen,
      maximumGreen
    );
    green = minimumGreen + Math_default.nextRandomNumber() * (maximumGreen - minimumGreen);
  }
  let blue = options.blue;
  if (!defined_default(blue)) {
    const minimumBlue = options.minimumBlue ?? 0;
    const maximumBlue = options.maximumBlue ?? 1;
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumBlue",
      minimumBlue,
      maximumBlue
    );
    blue = minimumBlue + Math_default.nextRandomNumber() * (maximumBlue - minimumBlue);
  }
  let alpha = options.alpha;
  if (!defined_default(alpha)) {
    const minimumAlpha = options.minimumAlpha ?? 0;
    const maximumAlpha = options.maximumAlpha ?? 1;
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumAlpha",
      minimumAlpha,
      maximumAlpha
    );
    alpha = minimumAlpha + Math_default.nextRandomNumber() * (maximumAlpha - minimumAlpha);
  }
  if (!defined_default(result)) {
    return new Color(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
var rgbaMatcher = /^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i;
var rrggbbaaMatcher = /^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i;
var rgbParenthesesMatcher = /^rgba?\s*\(\s*([0-9.]+%?)\s*[,\s]+\s*([0-9.]+%?)\s*[,\s]+\s*([0-9.]+%?)(?:\s*[,\s/]+\s*([0-9.]+))?\s*\)$/i;
var hslParenthesesMatcher = /^hsla?\s*\(\s*([0-9.]+)\s*[,\s]+\s*([0-9.]+%)\s*[,\s]+\s*([0-9.]+%)(?:\s*[,\s/]+\s*([0-9.]+))?\s*\)$/i;
Color.fromCssColorString = function(color, result) {
  Check_default.typeOf.string("color", color);
  if (!defined_default(result)) {
    result = new Color();
  }
  color = color.trim();
  const namedColor = Color[color.toUpperCase()];
  if (defined_default(namedColor)) {
    Color.clone(namedColor, result);
    return result;
  }
  let matches = rgbaMatcher.exec(color);
  if (matches !== null) {
    result.red = parseInt(matches[1], 16) / 15;
    result.green = parseInt(matches[2], 16) / 15;
    result.blue = parseInt(matches[3], 16) / 15;
    result.alpha = parseInt(matches[4] ?? "f", 16) / 15;
    return result;
  }
  matches = rrggbbaaMatcher.exec(color);
  if (matches !== null) {
    result.red = parseInt(matches[1], 16) / 255;
    result.green = parseInt(matches[2], 16) / 255;
    result.blue = parseInt(matches[3], 16) / 255;
    result.alpha = parseInt(matches[4] ?? "ff", 16) / 255;
    return result;
  }
  matches = rgbParenthesesMatcher.exec(color);
  if (matches !== null) {
    result.red = parseFloat(matches[1]) / ("%" === matches[1].substr(-1) ? 100 : 255);
    result.green = parseFloat(matches[2]) / ("%" === matches[2].substr(-1) ? 100 : 255);
    result.blue = parseFloat(matches[3]) / ("%" === matches[3].substr(-1) ? 100 : 255);
    result.alpha = parseFloat(matches[4] ?? "1.0");
    return result;
  }
  matches = hslParenthesesMatcher.exec(color);
  if (matches !== null) {
    return Color.fromHsl(
      parseFloat(matches[1]) / 360,
      parseFloat(matches[2]) / 100,
      parseFloat(matches[3]) / 100,
      parseFloat(matches[4] ?? "1.0"),
      result
    );
  }
  result = void 0;
  return result;
};
Color.packedLength = 4;
Color.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.red;
  array[startingIndex++] = value.green;
  array[startingIndex++] = value.blue;
  array[startingIndex] = value.alpha;
  return array;
};
Color.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Color();
  }
  result.red = array[startingIndex++];
  result.green = array[startingIndex++];
  result.blue = array[startingIndex++];
  result.alpha = array[startingIndex];
  return result;
};
Color.byteToFloat = function(number) {
  return number / 255;
};
Color.floatToByte = function(number) {
  return number === 1 ? 255 : number * 256 | 0;
};
Color.clone = function(color, result) {
  if (!defined_default(color)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Color(color.red, color.green, color.blue, color.alpha);
  }
  result.red = color.red;
  result.green = color.green;
  result.blue = color.blue;
  result.alpha = color.alpha;
  return result;
};
Color.equals = function(left, right) {
  return left === right || //
  defined_default(left) && //
  defined_default(right) && //
  left.red === right.red && //
  left.green === right.green && //
  left.blue === right.blue && //
  left.alpha === right.alpha;
};
Color.equalsArray = function(color, array, offset) {
  return color.red === array[offset] && color.green === array[offset + 1] && color.blue === array[offset + 2] && color.alpha === array[offset + 3];
};
Color.prototype.clone = function(result) {
  return Color.clone(this, result);
};
Color.prototype.equals = function(other) {
  return Color.equals(this, other);
};
Color.prototype.equalsEpsilon = function(other, epsilon) {
  return this === other || //
  defined_default(other) && //
  Math.abs(this.red - other.red) <= epsilon && //
  Math.abs(this.green - other.green) <= epsilon && //
  Math.abs(this.blue - other.blue) <= epsilon && //
  Math.abs(this.alpha - other.alpha) <= epsilon;
};
Color.prototype.toString = function() {
  return `(${this.red}, ${this.green}, ${this.blue}, ${this.alpha})`;
};
Color.prototype.toCssColorString = function() {
  const red = Color.floatToByte(this.red);
  const green = Color.floatToByte(this.green);
  const blue = Color.floatToByte(this.blue);
  if (this.alpha === 1) {
    return `rgb(${red},${green},${blue})`;
  }
  return `rgba(${red},${green},${blue},${this.alpha})`;
};
Color.prototype.toCssHexString = function() {
  let r = Color.floatToByte(this.red).toString(16);
  if (r.length < 2) {
    r = `0${r}`;
  }
  let g2 = Color.floatToByte(this.green).toString(16);
  if (g2.length < 2) {
    g2 = `0${g2}`;
  }
  let b = Color.floatToByte(this.blue).toString(16);
  if (b.length < 2) {
    b = `0${b}`;
  }
  if (this.alpha < 1) {
    let hexAlpha = Color.floatToByte(this.alpha).toString(16);
    if (hexAlpha.length < 2) {
      hexAlpha = `0${hexAlpha}`;
    }
    return `#${r}${g2}${b}${hexAlpha}`;
  }
  return `#${r}${g2}${b}`;
};
Color.prototype.toBytes = function(result) {
  const red = Color.floatToByte(this.red);
  const green = Color.floatToByte(this.green);
  const blue = Color.floatToByte(this.blue);
  const alpha = Color.floatToByte(this.alpha);
  if (!defined_default(result)) {
    return [red, green, blue, alpha];
  }
  result[0] = red;
  result[1] = green;
  result[2] = blue;
  result[3] = alpha;
  return result;
};
Color.bytesToRgba = function(red, green, blue, alpha) {
  scratchUint8Array[0] = red;
  scratchUint8Array[1] = green;
  scratchUint8Array[2] = blue;
  scratchUint8Array[3] = alpha;
  return scratchUint32Array[0];
};
Color.prototype.toRgba = function() {
  return Color.bytesToRgba(
    Color.floatToByte(this.red),
    Color.floatToByte(this.green),
    Color.floatToByte(this.blue),
    Color.floatToByte(this.alpha)
  );
};
Color.prototype.brighten = function(magnitude, result) {
  Check_default.typeOf.number("magnitude", magnitude);
  Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
  Check_default.typeOf.object("result", result);
  magnitude = 1 - magnitude;
  result.red = 1 - (1 - this.red) * magnitude;
  result.green = 1 - (1 - this.green) * magnitude;
  result.blue = 1 - (1 - this.blue) * magnitude;
  result.alpha = this.alpha;
  return result;
};
Color.prototype.darken = function(magnitude, result) {
  Check_default.typeOf.number("magnitude", magnitude);
  Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
  Check_default.typeOf.object("result", result);
  magnitude = 1 - magnitude;
  result.red = this.red * magnitude;
  result.green = this.green * magnitude;
  result.blue = this.blue * magnitude;
  result.alpha = this.alpha;
  return result;
};
Color.prototype.withAlpha = function(alpha, result) {
  return Color.fromAlpha(this, alpha, result);
};
Color.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red + right.red;
  result.green = left.green + right.green;
  result.blue = left.blue + right.blue;
  result.alpha = left.alpha + right.alpha;
  return result;
};
Color.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red - right.red;
  result.green = left.green - right.green;
  result.blue = left.blue - right.blue;
  result.alpha = left.alpha - right.alpha;
  return result;
};
Color.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red * right.red;
  result.green = left.green * right.green;
  result.blue = left.blue * right.blue;
  result.alpha = left.alpha * right.alpha;
  return result;
};
Color.divide = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red / right.red;
  result.green = left.green / right.green;
  result.blue = left.blue / right.blue;
  result.alpha = left.alpha / right.alpha;
  return result;
};
Color.mod = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red % right.red;
  result.green = left.green % right.green;
  result.blue = left.blue % right.blue;
  result.alpha = left.alpha % right.alpha;
  return result;
};
Color.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  result.red = Math_default.lerp(start.red, end.red, t);
  result.green = Math_default.lerp(start.green, end.green, t);
  result.blue = Math_default.lerp(start.blue, end.blue, t);
  result.alpha = Math_default.lerp(start.alpha, end.alpha, t);
  return result;
};
Color.multiplyByScalar = function(color, scalar, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.red = color.red * scalar;
  result.green = color.green * scalar;
  result.blue = color.blue * scalar;
  result.alpha = color.alpha * scalar;
  return result;
};
Color.divideByScalar = function(color, scalar, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.red = color.red / scalar;
  result.green = color.green / scalar;
  result.blue = color.blue / scalar;
  result.alpha = color.alpha / scalar;
  return result;
};
Color.ALICEBLUE = Object.freeze(Color.fromCssColorString("#F0F8FF"));
Color.ANTIQUEWHITE = Object.freeze(Color.fromCssColorString("#FAEBD7"));
Color.AQUA = Object.freeze(Color.fromCssColorString("#00FFFF"));
Color.AQUAMARINE = Object.freeze(Color.fromCssColorString("#7FFFD4"));
Color.AZURE = Object.freeze(Color.fromCssColorString("#F0FFFF"));
Color.BEIGE = Object.freeze(Color.fromCssColorString("#F5F5DC"));
Color.BISQUE = Object.freeze(Color.fromCssColorString("#FFE4C4"));
Color.BLACK = Object.freeze(Color.fromCssColorString("#000000"));
Color.BLANCHEDALMOND = Object.freeze(Color.fromCssColorString("#FFEBCD"));
Color.BLUE = Object.freeze(Color.fromCssColorString("#0000FF"));
Color.BLUEVIOLET = Object.freeze(Color.fromCssColorString("#8A2BE2"));
Color.BROWN = Object.freeze(Color.fromCssColorString("#A52A2A"));
Color.BURLYWOOD = Object.freeze(Color.fromCssColorString("#DEB887"));
Color.CADETBLUE = Object.freeze(Color.fromCssColorString("#5F9EA0"));
Color.CHARTREUSE = Object.freeze(Color.fromCssColorString("#7FFF00"));
Color.CHOCOLATE = Object.freeze(Color.fromCssColorString("#D2691E"));
Color.CORAL = Object.freeze(Color.fromCssColorString("#FF7F50"));
Color.CORNFLOWERBLUE = Object.freeze(Color.fromCssColorString("#6495ED"));
Color.CORNSILK = Object.freeze(Color.fromCssColorString("#FFF8DC"));
Color.CRIMSON = Object.freeze(Color.fromCssColorString("#DC143C"));
Color.CYAN = Object.freeze(Color.fromCssColorString("#00FFFF"));
Color.DARKBLUE = Object.freeze(Color.fromCssColorString("#00008B"));
Color.DARKCYAN = Object.freeze(Color.fromCssColorString("#008B8B"));
Color.DARKGOLDENROD = Object.freeze(Color.fromCssColorString("#B8860B"));
Color.DARKGRAY = Object.freeze(Color.fromCssColorString("#A9A9A9"));
Color.DARKGREEN = Object.freeze(Color.fromCssColorString("#006400"));
Color.DARKGREY = Color.DARKGRAY;
Color.DARKKHAKI = Object.freeze(Color.fromCssColorString("#BDB76B"));
Color.DARKMAGENTA = Object.freeze(Color.fromCssColorString("#8B008B"));
Color.DARKOLIVEGREEN = Object.freeze(Color.fromCssColorString("#556B2F"));
Color.DARKORANGE = Object.freeze(Color.fromCssColorString("#FF8C00"));
Color.DARKORCHID = Object.freeze(Color.fromCssColorString("#9932CC"));
Color.DARKRED = Object.freeze(Color.fromCssColorString("#8B0000"));
Color.DARKSALMON = Object.freeze(Color.fromCssColorString("#E9967A"));
Color.DARKSEAGREEN = Object.freeze(Color.fromCssColorString("#8FBC8F"));
Color.DARKSLATEBLUE = Object.freeze(Color.fromCssColorString("#483D8B"));
Color.DARKSLATEGRAY = Object.freeze(Color.fromCssColorString("#2F4F4F"));
Color.DARKSLATEGREY = Color.DARKSLATEGRAY;
Color.DARKTURQUOISE = Object.freeze(Color.fromCssColorString("#00CED1"));
Color.DARKVIOLET = Object.freeze(Color.fromCssColorString("#9400D3"));
Color.DEEPPINK = Object.freeze(Color.fromCssColorString("#FF1493"));
Color.DEEPSKYBLUE = Object.freeze(Color.fromCssColorString("#00BFFF"));
Color.DIMGRAY = Object.freeze(Color.fromCssColorString("#696969"));
Color.DIMGREY = Color.DIMGRAY;
Color.DODGERBLUE = Object.freeze(Color.fromCssColorString("#1E90FF"));
Color.FIREBRICK = Object.freeze(Color.fromCssColorString("#B22222"));
Color.FLORALWHITE = Object.freeze(Color.fromCssColorString("#FFFAF0"));
Color.FORESTGREEN = Object.freeze(Color.fromCssColorString("#228B22"));
Color.FUCHSIA = Object.freeze(Color.fromCssColorString("#FF00FF"));
Color.GAINSBORO = Object.freeze(Color.fromCssColorString("#DCDCDC"));
Color.GHOSTWHITE = Object.freeze(Color.fromCssColorString("#F8F8FF"));
Color.GOLD = Object.freeze(Color.fromCssColorString("#FFD700"));
Color.GOLDENROD = Object.freeze(Color.fromCssColorString("#DAA520"));
Color.GRAY = Object.freeze(Color.fromCssColorString("#808080"));
Color.GREEN = Object.freeze(Color.fromCssColorString("#008000"));
Color.GREENYELLOW = Object.freeze(Color.fromCssColorString("#ADFF2F"));
Color.GREY = Color.GRAY;
Color.HONEYDEW = Object.freeze(Color.fromCssColorString("#F0FFF0"));
Color.HOTPINK = Object.freeze(Color.fromCssColorString("#FF69B4"));
Color.INDIANRED = Object.freeze(Color.fromCssColorString("#CD5C5C"));
Color.INDIGO = Object.freeze(Color.fromCssColorString("#4B0082"));
Color.IVORY = Object.freeze(Color.fromCssColorString("#FFFFF0"));
Color.KHAKI = Object.freeze(Color.fromCssColorString("#F0E68C"));
Color.LAVENDER = Object.freeze(Color.fromCssColorString("#E6E6FA"));
Color.LAVENDAR_BLUSH = Object.freeze(Color.fromCssColorString("#FFF0F5"));
Color.LAWNGREEN = Object.freeze(Color.fromCssColorString("#7CFC00"));
Color.LEMONCHIFFON = Object.freeze(Color.fromCssColorString("#FFFACD"));
Color.LIGHTBLUE = Object.freeze(Color.fromCssColorString("#ADD8E6"));
Color.LIGHTCORAL = Object.freeze(Color.fromCssColorString("#F08080"));
Color.LIGHTCYAN = Object.freeze(Color.fromCssColorString("#E0FFFF"));
Color.LIGHTGOLDENRODYELLOW = Object.freeze(Color.fromCssColorString("#FAFAD2"));
Color.LIGHTGRAY = Object.freeze(Color.fromCssColorString("#D3D3D3"));
Color.LIGHTGREEN = Object.freeze(Color.fromCssColorString("#90EE90"));
Color.LIGHTGREY = Color.LIGHTGRAY;
Color.LIGHTPINK = Object.freeze(Color.fromCssColorString("#FFB6C1"));
Color.LIGHTSEAGREEN = Object.freeze(Color.fromCssColorString("#20B2AA"));
Color.LIGHTSKYBLUE = Object.freeze(Color.fromCssColorString("#87CEFA"));
Color.LIGHTSLATEGRAY = Object.freeze(Color.fromCssColorString("#778899"));
Color.LIGHTSLATEGREY = Color.LIGHTSLATEGRAY;
Color.LIGHTSTEELBLUE = Object.freeze(Color.fromCssColorString("#B0C4DE"));
Color.LIGHTYELLOW = Object.freeze(Color.fromCssColorString("#FFFFE0"));
Color.LIME = Object.freeze(Color.fromCssColorString("#00FF00"));
Color.LIMEGREEN = Object.freeze(Color.fromCssColorString("#32CD32"));
Color.LINEN = Object.freeze(Color.fromCssColorString("#FAF0E6"));
Color.MAGENTA = Object.freeze(Color.fromCssColorString("#FF00FF"));
Color.MAROON = Object.freeze(Color.fromCssColorString("#800000"));
Color.MEDIUMAQUAMARINE = Object.freeze(Color.fromCssColorString("#66CDAA"));
Color.MEDIUMBLUE = Object.freeze(Color.fromCssColorString("#0000CD"));
Color.MEDIUMORCHID = Object.freeze(Color.fromCssColorString("#BA55D3"));
Color.MEDIUMPURPLE = Object.freeze(Color.fromCssColorString("#9370DB"));
Color.MEDIUMSEAGREEN = Object.freeze(Color.fromCssColorString("#3CB371"));
Color.MEDIUMSLATEBLUE = Object.freeze(Color.fromCssColorString("#7B68EE"));
Color.MEDIUMSPRINGGREEN = Object.freeze(Color.fromCssColorString("#00FA9A"));
Color.MEDIUMTURQUOISE = Object.freeze(Color.fromCssColorString("#48D1CC"));
Color.MEDIUMVIOLETRED = Object.freeze(Color.fromCssColorString("#C71585"));
Color.MIDNIGHTBLUE = Object.freeze(Color.fromCssColorString("#191970"));
Color.MINTCREAM = Object.freeze(Color.fromCssColorString("#F5FFFA"));
Color.MISTYROSE = Object.freeze(Color.fromCssColorString("#FFE4E1"));
Color.MOCCASIN = Object.freeze(Color.fromCssColorString("#FFE4B5"));
Color.NAVAJOWHITE = Object.freeze(Color.fromCssColorString("#FFDEAD"));
Color.NAVY = Object.freeze(Color.fromCssColorString("#000080"));
Color.OLDLACE = Object.freeze(Color.fromCssColorString("#FDF5E6"));
Color.OLIVE = Object.freeze(Color.fromCssColorString("#808000"));
Color.OLIVEDRAB = Object.freeze(Color.fromCssColorString("#6B8E23"));
Color.ORANGE = Object.freeze(Color.fromCssColorString("#FFA500"));
Color.ORANGERED = Object.freeze(Color.fromCssColorString("#FF4500"));
Color.ORCHID = Object.freeze(Color.fromCssColorString("#DA70D6"));
Color.PALEGOLDENROD = Object.freeze(Color.fromCssColorString("#EEE8AA"));
Color.PALEGREEN = Object.freeze(Color.fromCssColorString("#98FB98"));
Color.PALETURQUOISE = Object.freeze(Color.fromCssColorString("#AFEEEE"));
Color.PALEVIOLETRED = Object.freeze(Color.fromCssColorString("#DB7093"));
Color.PAPAYAWHIP = Object.freeze(Color.fromCssColorString("#FFEFD5"));
Color.PEACHPUFF = Object.freeze(Color.fromCssColorString("#FFDAB9"));
Color.PERU = Object.freeze(Color.fromCssColorString("#CD853F"));
Color.PINK = Object.freeze(Color.fromCssColorString("#FFC0CB"));
Color.PLUM = Object.freeze(Color.fromCssColorString("#DDA0DD"));
Color.POWDERBLUE = Object.freeze(Color.fromCssColorString("#B0E0E6"));
Color.PURPLE = Object.freeze(Color.fromCssColorString("#800080"));
Color.RED = Object.freeze(Color.fromCssColorString("#FF0000"));
Color.ROSYBROWN = Object.freeze(Color.fromCssColorString("#BC8F8F"));
Color.ROYALBLUE = Object.freeze(Color.fromCssColorString("#4169E1"));
Color.SADDLEBROWN = Object.freeze(Color.fromCssColorString("#8B4513"));
Color.SALMON = Object.freeze(Color.fromCssColorString("#FA8072"));
Color.SANDYBROWN = Object.freeze(Color.fromCssColorString("#F4A460"));
Color.SEAGREEN = Object.freeze(Color.fromCssColorString("#2E8B57"));
Color.SEASHELL = Object.freeze(Color.fromCssColorString("#FFF5EE"));
Color.SIENNA = Object.freeze(Color.fromCssColorString("#A0522D"));
Color.SILVER = Object.freeze(Color.fromCssColorString("#C0C0C0"));
Color.SKYBLUE = Object.freeze(Color.fromCssColorString("#87CEEB"));
Color.SLATEBLUE = Object.freeze(Color.fromCssColorString("#6A5ACD"));
Color.SLATEGRAY = Object.freeze(Color.fromCssColorString("#708090"));
Color.SLATEGREY = Color.SLATEGRAY;
Color.SNOW = Object.freeze(Color.fromCssColorString("#FFFAFA"));
Color.SPRINGGREEN = Object.freeze(Color.fromCssColorString("#00FF7F"));
Color.STEELBLUE = Object.freeze(Color.fromCssColorString("#4682B4"));
Color.TAN = Object.freeze(Color.fromCssColorString("#D2B48C"));
Color.TEAL = Object.freeze(Color.fromCssColorString("#008080"));
Color.THISTLE = Object.freeze(Color.fromCssColorString("#D8BFD8"));
Color.TOMATO = Object.freeze(Color.fromCssColorString("#FF6347"));
Color.TURQUOISE = Object.freeze(Color.fromCssColorString("#40E0D0"));
Color.VIOLET = Object.freeze(Color.fromCssColorString("#EE82EE"));
Color.WHEAT = Object.freeze(Color.fromCssColorString("#F5DEB3"));
Color.WHITE = Object.freeze(Color.fromCssColorString("#FFFFFF"));
Color.WHITESMOKE = Object.freeze(Color.fromCssColorString("#F5F5F5"));
Color.YELLOW = Object.freeze(Color.fromCssColorString("#FFFF00"));
Color.YELLOWGREEN = Object.freeze(Color.fromCssColorString("#9ACD32"));
Color.TRANSPARENT = Object.freeze(new Color(0, 0, 0, 0));
var Color_default = Color;

// packages/engine/Source/Renderer/ClearCommand.js
function ClearCommand(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  this.color = options.color;
  this.depth = options.depth;
  this.stencil = options.stencil;
  this.renderState = options.renderState;
  this.framebuffer = options.framebuffer;
  this.owner = options.owner;
  this.pass = options.pass;
}
ClearCommand.ALL = Object.freeze(
  new ClearCommand({
    color: new Color_default(0, 0, 0, 0),
    depth: 1,
    stencil: 0
  })
);
ClearCommand.prototype.execute = function(context, passState) {
  context.clear(this, passState);
};
var ClearCommand_default = ClearCommand;

// packages/engine/Source/Renderer/Pass.js
var Pass = {
  // If you add/modify/remove Pass constants, also change the automatic GLSL constants
  // that start with 'czm_pass'
  //
  // Commands are executed in order by pass up to the translucent pass.
  // Translucent geometry needs special handling (sorting/OIT). The compute pass
  // is executed first and the overlay pass is executed last. Both are not sorted
  // by frustum.
  ENVIRONMENT: 0,
  COMPUTE: 1,
  GLOBE: 2,
  TERRAIN_CLASSIFICATION: 3,
  CESIUM_3D_TILE_EDGES: 4,
  CESIUM_3D_TILE: 5,
  CESIUM_3D_TILE_CLASSIFICATION: 6,
  CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW: 7,
  OPAQUE: 8,
  TRANSLUCENT: 9,
  VOXELS: 10,
  GAUSSIAN_SPLATS: 11,
  OVERLAY: 12,
  NUMBER_OF_PASSES: 13
};
var Pass_default = Object.freeze(Pass);

// packages/engine/Source/Renderer/ComputeCommand.js
function ComputeCommand(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  this.vertexArray = options.vertexArray;
  this.fragmentShaderSource = options.fragmentShaderSource;
  this.shaderProgram = options.shaderProgram;
  this.uniformMap = options.uniformMap;
  this.outputTexture = options.outputTexture;
  this.preExecute = options.preExecute;
  this.postExecute = options.postExecute;
  this.canceled = options.canceled;
  this.persists = options.persists ?? false;
  this.pass = Pass_default.COMPUTE;
  this.owner = options.owner;
}
ComputeCommand.prototype.execute = function(computeEngine) {
  computeEngine.execute(this);
};
var ComputeCommand_default = ComputeCommand;

// packages/engine/Source/Core/Cartesian2.js
function Cartesian2(x, y) {
  this.x = x ?? 0;
  this.y = y ?? 0;
}
Cartesian2.fromElements = function(x, y, result) {
  if (!defined_default(result)) {
    return new Cartesian2(x, y);
  }
  result.x = x;
  result.y = y;
  return result;
};
Cartesian2.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian2(cartesian11.x, cartesian11.y);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  return result;
};
Cartesian2.fromCartesian3 = Cartesian2.clone;
Cartesian2.fromCartesian4 = Cartesian2.clone;
Cartesian2.packedLength = 2;
Cartesian2.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex] = value.y;
  return array;
};
Cartesian2.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Cartesian2();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex];
  return result;
};
Cartesian2.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 2;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 2 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Cartesian2.pack(array[i], result, i * 2);
  }
  return result;
};
Cartesian2.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 2);
  if (array.length % 2 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 2.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 2);
  } else {
    result.length = length2 / 2;
  }
  for (let i = 0; i < length2; i += 2) {
    const index = i / 2;
    result[index] = Cartesian2.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian2.fromArray = Cartesian2.unpack;
Cartesian2.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y);
};
Cartesian2.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y);
};
Cartesian2.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  return result;
};
Cartesian2.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  return result;
};
Cartesian2.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  result.x = x;
  result.y = y;
  return result;
};
Cartesian2.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y;
};
Cartesian2.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian2.magnitudeSquared(cartesian11));
};
var distanceScratch3 = new Cartesian2();
Cartesian2.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.subtract(left, right, distanceScratch3);
  return Cartesian2.magnitude(distanceScratch3);
};
Cartesian2.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.subtract(left, right, distanceScratch3);
  return Cartesian2.magnitudeSquared(distanceScratch3);
};
Cartesian2.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian2.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  if (isNaN(result.x) || isNaN(result.y)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian2.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y;
};
Cartesian2.cross = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.y - left.y * right.x;
};
Cartesian2.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  return result;
};
Cartesian2.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  return result;
};
Cartesian2.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  return result;
};
Cartesian2.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  return result;
};
Cartesian2.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  return result;
};
Cartesian2.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  return result;
};
Cartesian2.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  return result;
};
Cartesian2.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  return result;
};
var lerpScratch3 = new Cartesian2();
Cartesian2.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian2.multiplyByScalar(end, t, lerpScratch3);
  result = Cartesian2.multiplyByScalar(start, 1 - t, result);
  return Cartesian2.add(lerpScratch3, result, result);
};
var angleBetweenScratch3 = new Cartesian2();
var angleBetweenScratch22 = new Cartesian2();
Cartesian2.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.normalize(left, angleBetweenScratch3);
  Cartesian2.normalize(right, angleBetweenScratch22);
  return Math_default.acosClamped(
    Cartesian2.dot(angleBetweenScratch3, angleBetweenScratch22)
  );
};
var mostOrthogonalAxisScratch3 = new Cartesian2();
Cartesian2.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian2.normalize(cartesian11, mostOrthogonalAxisScratch3);
  Cartesian2.abs(f, f);
  if (f.x <= f.y) {
    result = Cartesian2.clone(Cartesian2.UNIT_X, result);
  } else {
    result = Cartesian2.clone(Cartesian2.UNIT_Y, result);
  }
  return result;
};
Cartesian2.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y;
};
Cartesian2.equalsArray = function(cartesian11, array, offset) {
  return cartesian11.x === array[offset] && cartesian11.y === array[offset + 1];
};
Cartesian2.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian2.ZERO = Object.freeze(new Cartesian2(0, 0));
Cartesian2.ONE = Object.freeze(new Cartesian2(1, 1));
Cartesian2.UNIT_X = Object.freeze(new Cartesian2(1, 0));
Cartesian2.UNIT_Y = Object.freeze(new Cartesian2(0, 1));
Cartesian2.prototype.clone = function(result) {
  return Cartesian2.clone(this, result);
};
Cartesian2.prototype.equals = function(right) {
  return Cartesian2.equals(this, right);
};
Cartesian2.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian2.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian2.prototype.toString = function() {
  return `(${this.x}, ${this.y})`;
};
var Cartesian2_default = Cartesian2;

// packages/engine/Source/Core/scaleToGeodeticSurface.js
var scaleToGeodeticSurfaceIntersection = new Cartesian3_default();
var scaleToGeodeticSurfaceGradient = new Cartesian3_default();
function scaleToGeodeticSurface(cartesian11, oneOverRadii, oneOverRadiiSquared, centerToleranceSquared, result) {
  if (!defined_default(cartesian11)) {
    throw new DeveloperError_default("cartesian is required.");
  }
  if (!defined_default(oneOverRadii)) {
    throw new DeveloperError_default("oneOverRadii is required.");
  }
  if (!defined_default(oneOverRadiiSquared)) {
    throw new DeveloperError_default("oneOverRadiiSquared is required.");
  }
  if (!defined_default(centerToleranceSquared)) {
    throw new DeveloperError_default("centerToleranceSquared is required.");
  }
  const positionX = cartesian11.x;
  const positionY = cartesian11.y;
  const positionZ = cartesian11.z;
  const oneOverRadiiX = oneOverRadii.x;
  const oneOverRadiiY = oneOverRadii.y;
  const oneOverRadiiZ = oneOverRadii.z;
  const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
  const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
  const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
  const squaredNorm = x2 + y2 + z2;
  const ratio = Math.sqrt(1 / squaredNorm);
  const intersection = Cartesian3_default.multiplyByScalar(
    cartesian11,
    ratio,
    scaleToGeodeticSurfaceIntersection
  );
  if (squaredNorm < centerToleranceSquared) {
    return !isFinite(ratio) ? void 0 : Cartesian3_default.clone(intersection, result);
  }
  const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
  const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
  const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
  const gradient = scaleToGeodeticSurfaceGradient;
  gradient.x = intersection.x * oneOverRadiiSquaredX * 2;
  gradient.y = intersection.y * oneOverRadiiSquaredY * 2;
  gradient.z = intersection.z * oneOverRadiiSquaredZ * 2;
  let lambda = (1 - ratio) * Cartesian3_default.magnitude(cartesian11) / (0.5 * Cartesian3_default.magnitude(gradient));
  let correction = 0;
  let func;
  let denominator;
  let xMultiplier;
  let yMultiplier;
  let zMultiplier;
  let xMultiplier2;
  let yMultiplier2;
  let zMultiplier2;
  let xMultiplier3;
  let yMultiplier3;
  let zMultiplier3;
  do {
    lambda -= correction;
    xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
    yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
    zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
    xMultiplier2 = xMultiplier * xMultiplier;
    yMultiplier2 = yMultiplier * yMultiplier;
    zMultiplier2 = zMultiplier * zMultiplier;
    xMultiplier3 = xMultiplier2 * xMultiplier;
    yMultiplier3 = yMultiplier2 * yMultiplier;
    zMultiplier3 = zMultiplier2 * zMultiplier;
    func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
    denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
    const derivative = -2 * denominator;
    correction = func / derivative;
  } while (Math.abs(func) > Math_default.EPSILON12);
  if (!defined_default(result)) {
    return new Cartesian3_default(
      positionX * xMultiplier,
      positionY * yMultiplier,
      positionZ * zMultiplier
    );
  }
  result.x = positionX * xMultiplier;
  result.y = positionY * yMultiplier;
  result.z = positionZ * zMultiplier;
  return result;
}
var scaleToGeodeticSurface_default = scaleToGeodeticSurface;

// packages/engine/Source/Core/Cartographic.js
function Cartographic(longitude, latitude, height) {
  this.longitude = longitude ?? 0;
  this.latitude = latitude ?? 0;
  this.height = height ?? 0;
}
Cartographic.fromRadians = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = height ?? 0;
  if (!defined_default(result)) {
    return new Cartographic(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic.fromDegrees = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartographic.fromRadians(longitude, latitude, height, result);
};
var cartesianToCartographicN = new Cartesian3_default();
var cartesianToCartographicP = new Cartesian3_default();
var cartesianToCartographicH = new Cartesian3_default();
Cartographic._ellipsoidOneOverRadii = new Cartesian3_default(
  1 / 6378137,
  1 / 6378137,
  1 / 6356752314245179e-9
);
Cartographic._ellipsoidOneOverRadiiSquared = new Cartesian3_default(
  1 / (6378137 * 6378137),
  1 / (6378137 * 6378137),
  1 / (6356752314245179e-9 * 6356752314245179e-9)
);
Cartographic._ellipsoidCenterToleranceSquared = Math_default.EPSILON1;
Cartographic.fromCartesian = function(cartesian11, ellipsoid, result) {
  const oneOverRadii = defined_default(ellipsoid) ? ellipsoid.oneOverRadii : Cartographic._ellipsoidOneOverRadii;
  const oneOverRadiiSquared = defined_default(ellipsoid) ? ellipsoid.oneOverRadiiSquared : Cartographic._ellipsoidOneOverRadiiSquared;
  const centerToleranceSquared = defined_default(ellipsoid) ? ellipsoid._centerToleranceSquared : Cartographic._ellipsoidCenterToleranceSquared;
  const p = scaleToGeodeticSurface_default(
    cartesian11,
    oneOverRadii,
    oneOverRadiiSquared,
    centerToleranceSquared,
    cartesianToCartographicP
  );
  if (!defined_default(p)) {
    return void 0;
  }
  let n = Cartesian3_default.multiplyComponents(
    p,
    oneOverRadiiSquared,
    cartesianToCartographicN
  );
  n = Cartesian3_default.normalize(n, n);
  const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic.toCartesian = function(cartographic2, ellipsoid, result) {
  Check_default.defined("cartographic", cartographic2);
  return Cartesian3_default.fromRadians(
    cartographic2.longitude,
    cartographic2.latitude,
    cartographic2.height,
    ellipsoid,
    result
  );
};
Cartographic.clone = function(cartographic2, result) {
  if (!defined_default(cartographic2)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartographic(
      cartographic2.longitude,
      cartographic2.latitude,
      cartographic2.height
    );
  }
  result.longitude = cartographic2.longitude;
  result.latitude = cartographic2.latitude;
  result.height = cartographic2.height;
  return result;
};
Cartographic.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.longitude === right.longitude && left.latitude === right.latitude && left.height === right.height;
};
Cartographic.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.longitude - right.longitude) <= epsilon && Math.abs(left.latitude - right.latitude) <= epsilon && Math.abs(left.height - right.height) <= epsilon;
};
Cartographic.ZERO = Object.freeze(new Cartographic(0, 0, 0));
Cartographic.prototype.clone = function(result) {
  return Cartographic.clone(this, result);
};
Cartographic.prototype.equals = function(right) {
  return Cartographic.equals(this, right);
};
Cartographic.prototype.equalsEpsilon = function(right, epsilon) {
  return Cartographic.equalsEpsilon(this, right, epsilon);
};
Cartographic.prototype.toString = function() {
  return `(${this.longitude}, ${this.latitude}, ${this.height})`;
};
var Cartographic_default = Cartographic;

// packages/engine/Source/Core/Ellipsoid.js
function initialize(ellipsoid, x, y, z) {
  x = x ?? 0;
  y = y ?? 0;
  z = z ?? 0;
  Check_default.typeOf.number.greaterThanOrEquals("x", x, 0);
  Check_default.typeOf.number.greaterThanOrEquals("y", y, 0);
  Check_default.typeOf.number.greaterThanOrEquals("z", z, 0);
  ellipsoid._radii = new Cartesian3_default(x, y, z);
  ellipsoid._radiiSquared = new Cartesian3_default(x * x, y * y, z * z);
  ellipsoid._radiiToTheFourth = new Cartesian3_default(
    x * x * x * x,
    y * y * y * y,
    z * z * z * z
  );
  ellipsoid._oneOverRadii = new Cartesian3_default(
    x === 0 ? 0 : 1 / x,
    y === 0 ? 0 : 1 / y,
    z === 0 ? 0 : 1 / z
  );
  ellipsoid._oneOverRadiiSquared = new Cartesian3_default(
    x === 0 ? 0 : 1 / (x * x),
    y === 0 ? 0 : 1 / (y * y),
    z === 0 ? 0 : 1 / (z * z)
  );
  ellipsoid._minimumRadius = Math.min(x, y, z);
  ellipsoid._maximumRadius = Math.max(x, y, z);
  ellipsoid._centerToleranceSquared = Math_default.EPSILON1;
  if (ellipsoid._radiiSquared.z !== 0) {
    ellipsoid._squaredXOverSquaredZ = ellipsoid._radiiSquared.x / ellipsoid._radiiSquared.z;
  }
}
function Ellipsoid(x, y, z) {
  this._radii = void 0;
  this._radiiSquared = void 0;
  this._radiiToTheFourth = void 0;
  this._oneOverRadii = void 0;
  this._oneOverRadiiSquared = void 0;
  this._minimumRadius = void 0;
  this._maximumRadius = void 0;
  this._centerToleranceSquared = void 0;
  this._squaredXOverSquaredZ = void 0;
  initialize(this, x, y, z);
}
Object.defineProperties(Ellipsoid.prototype, {
  /**
   * Gets the radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  radii: {
    get: function() {
      return this._radii;
    }
  },
  /**
   * Gets the squared radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  radiiSquared: {
    get: function() {
      return this._radiiSquared;
    }
  },
  /**
   * Gets the radii of the ellipsoid raise to the fourth power.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  radiiToTheFourth: {
    get: function() {
      return this._radiiToTheFourth;
    }
  },
  /**
   * Gets one over the radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  oneOverRadii: {
    get: function() {
      return this._oneOverRadii;
    }
  },
  /**
   * Gets one over the squared radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  oneOverRadiiSquared: {
    get: function() {
      return this._oneOverRadiiSquared;
    }
  },
  /**
   * Gets the minimum radius of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {number}
   * @readonly
   */
  minimumRadius: {
    get: function() {
      return this._minimumRadius;
    }
  },
  /**
   * Gets the maximum radius of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {number}
   * @readonly
   */
  maximumRadius: {
    get: function() {
      return this._maximumRadius;
    }
  }
});
Ellipsoid.clone = function(ellipsoid, result) {
  if (!defined_default(ellipsoid)) {
    return void 0;
  }
  const radii = ellipsoid._radii;
  if (!defined_default(result)) {
    return new Ellipsoid(radii.x, radii.y, radii.z);
  }
  Cartesian3_default.clone(radii, result._radii);
  Cartesian3_default.clone(ellipsoid._radiiSquared, result._radiiSquared);
  Cartesian3_default.clone(ellipsoid._radiiToTheFourth, result._radiiToTheFourth);
  Cartesian3_default.clone(ellipsoid._oneOverRadii, result._oneOverRadii);
  Cartesian3_default.clone(ellipsoid._oneOverRadiiSquared, result._oneOverRadiiSquared);
  result._minimumRadius = ellipsoid._minimumRadius;
  result._maximumRadius = ellipsoid._maximumRadius;
  result._centerToleranceSquared = ellipsoid._centerToleranceSquared;
  return result;
};
Ellipsoid.fromCartesian3 = function(cartesian11, result) {
  if (!defined_default(result)) {
    result = new Ellipsoid();
  }
  if (!defined_default(cartesian11)) {
    return result;
  }
  initialize(result, cartesian11.x, cartesian11.y, cartesian11.z);
  return result;
};
Ellipsoid.WGS84 = Object.freeze(
  new Ellipsoid(6378137, 6378137, 6356752314245179e-9)
);
Ellipsoid.UNIT_SPHERE = Object.freeze(new Ellipsoid(1, 1, 1));
Ellipsoid.MOON = Object.freeze(
  new Ellipsoid(
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS
  )
);
Ellipsoid.MARS = Object.freeze(new Ellipsoid(3396190, 3396190, 3376200));
Ellipsoid._default = Ellipsoid.WGS84;
Object.defineProperties(Ellipsoid, {
  /**
   * The default ellipsoid used when not otherwise specified.
   * @memberof Ellipsoid
   * @type {Ellipsoid}
   * @example
   * Cesium.Ellipsoid.default = Cesium.Ellipsoid.MOON;
   *
   * // Apollo 11 landing site
   * const position = Cesium.Cartesian3.fromRadians(
   *   0.67416,
   *   23.47315,
   * );
   */
  default: {
    get: function() {
      return Ellipsoid._default;
    },
    set: function(value) {
      Check_default.typeOf.object("value", value);
      Ellipsoid._default = value;
      Cartesian3_default._ellipsoidRadiiSquared = value.radiiSquared;
      Cartographic_default._ellipsoidOneOverRadii = value.oneOverRadii;
      Cartographic_default._ellipsoidOneOverRadiiSquared = value.oneOverRadiiSquared;
      Cartographic_default._ellipsoidCenterToleranceSquared = value._centerToleranceSquared;
    }
  }
});
Ellipsoid.prototype.clone = function(result) {
  return Ellipsoid.clone(this, result);
};
Ellipsoid.packedLength = Cartesian3_default.packedLength;
Ellipsoid.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  Cartesian3_default.pack(value._radii, array, startingIndex);
  return array;
};
Ellipsoid.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  const radii = Cartesian3_default.unpack(array, startingIndex);
  return Ellipsoid.fromCartesian3(radii, result);
};
Ellipsoid.prototype.geocentricSurfaceNormal = Cartesian3_default.normalize;
Ellipsoid.prototype.geodeticSurfaceNormalCartographic = function(cartographic2, result) {
  Check_default.typeOf.object("cartographic", cartographic2);
  const longitude = cartographic2.longitude;
  const latitude = cartographic2.latitude;
  const cosLatitude = Math.cos(latitude);
  const x = cosLatitude * Math.cos(longitude);
  const y = cosLatitude * Math.sin(longitude);
  const z = Math.sin(latitude);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return Cartesian3_default.normalize(result, result);
};
Ellipsoid.prototype.geodeticSurfaceNormal = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  if (isNaN(cartesian11.x) || isNaN(cartesian11.y) || isNaN(cartesian11.z)) {
    throw new DeveloperError_default("cartesian has a NaN component");
  }
  if (Cartesian3_default.equalsEpsilon(cartesian11, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result = Cartesian3_default.multiplyComponents(
    cartesian11,
    this._oneOverRadiiSquared,
    result
  );
  return Cartesian3_default.normalize(result, result);
};
var cartographicToCartesianNormal = new Cartesian3_default();
var cartographicToCartesianK = new Cartesian3_default();
Ellipsoid.prototype.cartographicToCartesian = function(cartographic2, result) {
  const n = cartographicToCartesianNormal;
  const k = cartographicToCartesianK;
  this.geodeticSurfaceNormalCartographic(cartographic2, n);
  Cartesian3_default.multiplyComponents(this._radiiSquared, n, k);
  const gamma = Math.sqrt(Cartesian3_default.dot(n, k));
  Cartesian3_default.divideByScalar(k, gamma, k);
  Cartesian3_default.multiplyByScalar(n, cartographic2.height, n);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.add(k, n, result);
};
Ellipsoid.prototype.cartographicArrayToCartesianArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  const length2 = cartographics.length;
  if (!defined_default(result)) {
    result = new Array(length2);
  } else {
    result.length = length2;
  }
  for (let i = 0; i < length2; i++) {
    result[i] = this.cartographicToCartesian(cartographics[i], result[i]);
  }
  return result;
};
var cartesianToCartographicN2 = new Cartesian3_default();
var cartesianToCartographicP2 = new Cartesian3_default();
var cartesianToCartographicH2 = new Cartesian3_default();
Ellipsoid.prototype.cartesianToCartographic = function(cartesian11, result) {
  const p = this.scaleToGeodeticSurface(cartesian11, cartesianToCartographicP2);
  if (!defined_default(p)) {
    return void 0;
  }
  const n = this.geodeticSurfaceNormal(p, cartesianToCartographicN2);
  const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH2);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Ellipsoid.prototype.cartesianArrayToCartographicArray = function(cartesians, result) {
  Check_default.defined("cartesians", cartesians);
  const length2 = cartesians.length;
  if (!defined_default(result)) {
    result = new Array(length2);
  } else {
    result.length = length2;
  }
  for (let i = 0; i < length2; ++i) {
    result[i] = this.cartesianToCartographic(cartesians[i], result[i]);
  }
  return result;
};
Ellipsoid.prototype.scaleToGeodeticSurface = function(cartesian11, result) {
  return scaleToGeodeticSurface_default(
    cartesian11,
    this._oneOverRadii,
    this._oneOverRadiiSquared,
    this._centerToleranceSquared,
    result
  );
};
Ellipsoid.prototype.scaleToGeocentricSurface = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const positionX = cartesian11.x;
  const positionY = cartesian11.y;
  const positionZ = cartesian11.z;
  const oneOverRadiiSquared = this._oneOverRadiiSquared;
  const beta = 1 / Math.sqrt(
    positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z
  );
  return Cartesian3_default.multiplyByScalar(cartesian11, beta, result);
};
Ellipsoid.prototype.transformPositionToScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._oneOverRadii, result);
};
Ellipsoid.prototype.transformPositionFromScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._radii, result);
};
Ellipsoid.prototype.equals = function(right) {
  return this === right || defined_default(right) && Cartesian3_default.equals(this._radii, right._radii);
};
Ellipsoid.prototype.toString = function() {
  return this._radii.toString();
};
Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis = function(position, buffer2, result) {
  Check_default.typeOf.object("position", position);
  if (!Math_default.equalsEpsilon(
    this._radii.x,
    this._radii.y,
    Math_default.EPSILON15
  )) {
    throw new DeveloperError_default(
      "Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)"
    );
  }
  Check_default.typeOf.number.greaterThan("Ellipsoid.radii.z", this._radii.z, 0);
  buffer2 = buffer2 ?? 0;
  const squaredXOverSquaredZ = this._squaredXOverSquaredZ;
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = 0;
  result.y = 0;
  result.z = position.z * (1 - squaredXOverSquaredZ);
  if (Math.abs(result.z) >= this._radii.z - buffer2) {
    return void 0;
  }
  return result;
};
var scratchEndpoint = new Cartesian3_default();
Ellipsoid.prototype.getLocalCurvature = function(surfacePosition, result) {
  Check_default.typeOf.object("surfacePosition", surfacePosition);
  if (!defined_default(result)) {
    result = new Cartesian2_default();
  }
  const primeVerticalEndpoint = this.getSurfaceNormalIntersectionWithZAxis(
    surfacePosition,
    0,
    scratchEndpoint
  );
  const primeVerticalRadius = Cartesian3_default.distance(
    surfacePosition,
    primeVerticalEndpoint
  );
  const radiusRatio = this.minimumRadius * primeVerticalRadius / this.maximumRadius ** 2;
  const meridionalRadius = primeVerticalRadius * radiusRatio ** 2;
  return Cartesian2_default.fromElements(
    1 / primeVerticalRadius,
    1 / meridionalRadius,
    result
  );
};
var abscissas = [
  0.14887433898163,
  0.43339539412925,
  0.67940956829902,
  0.86506336668898,
  0.97390652851717,
  0
];
var weights = [
  0.29552422471475,
  0.26926671930999,
  0.21908636251598,
  0.14945134915058,
  0.066671344308684,
  0
];
function gaussLegendreQuadrature(a3, b, func) {
  Check_default.typeOf.number("a", a3);
  Check_default.typeOf.number("b", b);
  Check_default.typeOf.func("func", func);
  const xMean = 0.5 * (b + a3);
  const xRange = 0.5 * (b - a3);
  let sum = 0;
  for (let i = 0; i < 5; i++) {
    const dx = xRange * abscissas[i];
    sum += weights[i] * (func(xMean + dx) + func(xMean - dx));
  }
  sum *= xRange;
  return sum;
}
Ellipsoid.prototype.surfaceArea = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const minLongitude = rectangle.west;
  let maxLongitude = rectangle.east;
  const minLatitude = rectangle.south;
  const maxLatitude = rectangle.north;
  while (maxLongitude < minLongitude) {
    maxLongitude += Math_default.TWO_PI;
  }
  const radiiSquared = this._radiiSquared;
  const a22 = radiiSquared.x;
  const b2 = radiiSquared.y;
  const c22 = radiiSquared.z;
  const a2b2 = a22 * b2;
  return gaussLegendreQuadrature(minLatitude, maxLatitude, function(lat) {
    const sinPhi = Math.cos(lat);
    const cosPhi = Math.sin(lat);
    return Math.cos(lat) * gaussLegendreQuadrature(minLongitude, maxLongitude, function(lon) {
      const cosTheta = Math.cos(lon);
      const sinTheta = Math.sin(lon);
      return Math.sqrt(
        a2b2 * cosPhi * cosPhi + c22 * (b2 * cosTheta * cosTheta + a22 * sinTheta * sinTheta) * sinPhi * sinPhi
      );
    });
  });
};
var Ellipsoid_default = Ellipsoid;

// packages/engine/Source/Core/GeographicProjection.js
function GeographicProjection(ellipsoid) {
  this._ellipsoid = ellipsoid ?? Ellipsoid_default.default;
  this._semimajorAxis = this._ellipsoid.maximumRadius;
  this._oneOverSemimajorAxis = 1 / this._semimajorAxis;
}
Object.defineProperties(GeographicProjection.prototype, {
  /**
   * Gets the {@link Ellipsoid}.
   *
   * @memberof GeographicProjection.prototype
   *
   * @type {Ellipsoid}
   * @readonly
   */
  ellipsoid: {
    get: function() {
      return this._ellipsoid;
    }
  }
});
GeographicProjection.prototype.project = function(cartographic2, result) {
  const semimajorAxis = this._semimajorAxis;
  const x = cartographic2.longitude * semimajorAxis;
  const y = cartographic2.latitude * semimajorAxis;
  const z = cartographic2.height;
  if (!defined_default(result)) {
    return new Cartesian3_default(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
GeographicProjection.prototype.unproject = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    throw new DeveloperError_default("cartesian is required");
  }
  const oneOverEarthSemimajorAxis = this._oneOverSemimajorAxis;
  const longitude = cartesian11.x * oneOverEarthSemimajorAxis;
  const latitude = cartesian11.y * oneOverEarthSemimajorAxis;
  const height = cartesian11.z;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
var GeographicProjection_default = GeographicProjection;

// packages/engine/Source/Core/Intersect.js
var Intersect = {
  /**
   * Represents that an object is not contained within the frustum.
   *
   * @type {number}
   * @constant
   */
  OUTSIDE: -1,
  /**
   * Represents that an object intersects one of the frustum's planes.
   *
   * @type {number}
   * @constant
   */
  INTERSECTING: 0,
  /**
   * Represents that an object is fully within the frustum.
   *
   * @type {number}
   * @constant
   */
  INSIDE: 1
};
var Intersect_default = Object.freeze(Intersect);

// packages/engine/Source/Core/binarySearch.js
function binarySearch(array, itemToFind, comparator) {
  Check_default.defined("array", array);
  Check_default.defined("itemToFind", itemToFind);
  Check_default.defined("comparator", comparator);
  let low = 0;
  let high = array.length - 1;
  let i;
  let comparison;
  while (low <= high) {
    i = ~~((low + high) / 2);
    comparison = comparator(array[i], itemToFind);
    if (comparison < 0) {
      low = i + 1;
      continue;
    }
    if (comparison > 0) {
      high = i - 1;
      continue;
    }
    return i;
  }
  return ~(high + 1);
}
var binarySearch_default = binarySearch;

// packages/engine/Source/Core/EarthOrientationParametersSample.js
function EarthOrientationParametersSample(xPoleWander, yPoleWander, xPoleOffset, yPoleOffset, ut1MinusUtc) {
  this.xPoleWander = xPoleWander;
  this.yPoleWander = yPoleWander;
  this.xPoleOffset = xPoleOffset;
  this.yPoleOffset = yPoleOffset;
  this.ut1MinusUtc = ut1MinusUtc;
}
var EarthOrientationParametersSample_default = EarthOrientationParametersSample;

// packages/engine/Source/Core/isLeapYear.js
function isLeapYear(year) {
  if (year === null || isNaN(year)) {
    throw new DeveloperError_default("year is required and must be a number.");
  }
  return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
}
var isLeapYear_default = isLeapYear;

// packages/engine/Source/Core/GregorianDate.js
var daysInYear = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function GregorianDate(year, month, day, hour, minute, second, millisecond, isLeapSecond) {
  const minimumYear = 1;
  const minimumMonth = 1;
  const minimumDay = 1;
  const minimumHour = 0;
  const minimumMinute = 0;
  const minimumSecond = 0;
  const minimumMillisecond = 0;
  year = year ?? minimumYear;
  month = month ?? minimumMonth;
  day = day ?? minimumDay;
  hour = hour ?? minimumHour;
  minute = minute ?? minimumMinute;
  second = second ?? minimumSecond;
  millisecond = millisecond ?? minimumMillisecond;
  isLeapSecond = isLeapSecond ?? false;
  validateRange();
  validateDate();
  this.year = year;
  this.month = month;
  this.day = day;
  this.hour = hour;
  this.minute = minute;
  this.second = second;
  this.millisecond = millisecond;
  this.isLeapSecond = isLeapSecond;
  function validateRange() {
    const maximumYear = 9999;
    const maximumMonth = 12;
    const maximumDay = 31;
    const maximumHour = 23;
    const maximumMinute = 59;
    const maximumSecond = 59;
    const excludedMaximumMilisecond = 1e3;
    Check_default.typeOf.number.greaterThanOrEquals("Year", year, minimumYear);
    Check_default.typeOf.number.lessThanOrEquals("Year", year, maximumYear);
    Check_default.typeOf.number.greaterThanOrEquals("Month", month, minimumMonth);
    Check_default.typeOf.number.lessThanOrEquals("Month", month, maximumMonth);
    Check_default.typeOf.number.greaterThanOrEquals("Day", day, minimumDay);
    Check_default.typeOf.number.lessThanOrEquals("Day", day, maximumDay);
    Check_default.typeOf.number.greaterThanOrEquals("Hour", hour, minimumHour);
    Check_default.typeOf.number.lessThanOrEquals("Hour", hour, maximumHour);
    Check_default.typeOf.number.greaterThanOrEquals("Minute", minute, minimumMinute);
    Check_default.typeOf.number.lessThanOrEquals("Minute", minute, maximumMinute);
    Check_default.typeOf.bool("IsLeapSecond", isLeapSecond);
    Check_default.typeOf.number.greaterThanOrEquals("Second", second, minimumSecond);
    Check_default.typeOf.number.lessThanOrEquals(
      "Second",
      second,
      isLeapSecond ? maximumSecond + 1 : maximumSecond
    );
    Check_default.typeOf.number.greaterThanOrEquals(
      "Millisecond",
      millisecond,
      minimumMillisecond
    );
    Check_default.typeOf.number.lessThan(
      "Millisecond",
      millisecond,
      excludedMaximumMilisecond
    );
  }
  function validateDate() {
    const daysInMonth2 = month === 2 && isLeapYear_default(year) ? daysInYear[month - 1] + 1 : daysInYear[month - 1];
    if (day > daysInMonth2) {
      throw new DeveloperError_default("Month and Day represents invalid date");
    }
  }
}
var GregorianDate_default = GregorianDate;

// packages/engine/Source/Core/LeapSecond.js
function LeapSecond(date, offset) {
  this.julianDate = date;
  this.offset = offset;
}
var LeapSecond_default = LeapSecond;

// packages/engine/Source/Core/TimeConstants.js
var TimeConstants = {
  /**
   * The number of seconds in one millisecond: <code>0.001</code>
   * @type {number}
   * @constant
   */
  SECONDS_PER_MILLISECOND: 1e-3,
  /**
   * The number of seconds in one minute: <code>60</code>.
   * @type {number}
   * @constant
   */
  SECONDS_PER_MINUTE: 60,
  /**
   * The number of minutes in one hour: <code>60</code>.
   * @type {number}
   * @constant
   */
  MINUTES_PER_HOUR: 60,
  /**
   * The number of hours in one day: <code>24</code>.
   * @type {number}
   * @constant
   */
  HOURS_PER_DAY: 24,
  /**
   * The number of seconds in one hour: <code>3600</code>.
   * @type {number}
   * @constant
   */
  SECONDS_PER_HOUR: 3600,
  /**
   * The number of minutes in one day: <code>1440</code>.
   * @type {number}
   * @constant
   */
  MINUTES_PER_DAY: 1440,
  /**
   * The number of seconds in one day, ignoring leap seconds: <code>86400</code>.
   * @type {number}
   * @constant
   */
  SECONDS_PER_DAY: 86400,
  /**
   * The number of days in one Julian century: <code>36525</code>.
   * @type {number}
   * @constant
   */
  DAYS_PER_JULIAN_CENTURY: 36525,
  /**
   * One trillionth of a second.
   * @type {number}
   * @constant
   */
  PICOSECOND: 1e-9,
  /**
   * The number of days to subtract from a Julian date to determine the
   * modified Julian date, which gives the number of days since midnight
   * on November 17, 1858.
   * @type {number}
   * @constant
   */
  MODIFIED_JULIAN_DATE_DIFFERENCE: 24000005e-1
};
var TimeConstants_default = Object.freeze(TimeConstants);

// packages/engine/Source/Core/TimeStandard.js
var TimeStandard = {
  /**
   * Represents the coordinated Universal Time (UTC) time standard.
   *
   * UTC is related to TAI according to the relationship
   * <code>UTC = TAI - deltaT</code> where <code>deltaT</code> is the number of leap
   * seconds which have been introduced as of the time in TAI.
   *
   * @type {number}
   * @constant
   */
  UTC: 0,
  /**
   * Represents the International Atomic Time (TAI) time standard.
   * TAI is the principal time standard to which the other time standards are related.
   *
   * @type {number}
   * @constant
   */
  TAI: 1
};
var TimeStandard_default = Object.freeze(TimeStandard);

// packages/engine/Source/Core/JulianDate.js
var gregorianDateScratch = new GregorianDate_default();
var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var daysInLeapFebruary = 29;
function compareLeapSecondDates(leapSecond, dateToFind) {
  return JulianDate.compare(leapSecond.julianDate, dateToFind.julianDate);
}
var binarySearchScratchLeapSecond = new LeapSecond_default();
function convertUtcToTai(julianDate) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
  }
  if (index >= leapSeconds.length) {
    index = leapSeconds.length - 1;
  }
  let offset = leapSeconds[index].offset;
  if (index > 0) {
    const difference = JulianDate.secondsDifference(
      leapSeconds[index].julianDate,
      julianDate
    );
    if (difference > offset) {
      index--;
      offset = leapSeconds[index].offset;
    }
  }
  JulianDate.addSeconds(julianDate, offset, julianDate);
}
function convertTaiToUtc(julianDate, result) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
  }
  if (index === 0) {
    return JulianDate.addSeconds(julianDate, -leapSeconds[0].offset, result);
  }
  if (index >= leapSeconds.length) {
    return JulianDate.addSeconds(
      julianDate,
      -leapSeconds[index - 1].offset,
      result
    );
  }
  const difference = JulianDate.secondsDifference(
    leapSeconds[index].julianDate,
    julianDate
  );
  if (difference === 0) {
    return JulianDate.addSeconds(
      julianDate,
      -leapSeconds[index].offset,
      result
    );
  }
  if (difference <= 1) {
    return void 0;
  }
  return JulianDate.addSeconds(
    julianDate,
    -leapSeconds[--index].offset,
    result
  );
}
function setComponents(wholeDays, secondsOfDay, julianDate) {
  const extraDays = secondsOfDay / TimeConstants_default.SECONDS_PER_DAY | 0;
  wholeDays += extraDays;
  secondsOfDay -= TimeConstants_default.SECONDS_PER_DAY * extraDays;
  if (secondsOfDay < 0) {
    wholeDays--;
    secondsOfDay += TimeConstants_default.SECONDS_PER_DAY;
  }
  julianDate.dayNumber = wholeDays;
  julianDate.secondsOfDay = secondsOfDay;
  return julianDate;
}
function computeJulianDateComponents(year, month, day, hour, minute, second, millisecond) {
  const a3 = (month - 14) / 12 | 0;
  const b = year + 4800 + a3;
  let dayNumber = (1461 * b / 4 | 0) + (367 * (month - 2 - 12 * a3) / 12 | 0) - (3 * ((b + 100) / 100 | 0) / 4 | 0) + day - 32075;
  hour = hour - 12;
  if (hour < 0) {
    hour += 24;
  }
  const secondsOfDay = second + (hour * TimeConstants_default.SECONDS_PER_HOUR + minute * TimeConstants_default.SECONDS_PER_MINUTE + millisecond * TimeConstants_default.SECONDS_PER_MILLISECOND);
  if (secondsOfDay >= 43200) {
    dayNumber -= 1;
  }
  return [dayNumber, secondsOfDay];
}
var matchCalendarYear = /^(\d{4})$/;
var matchCalendarMonth = /^(\d{4})-(\d{2})$/;
var matchOrdinalDate = /^(\d{4})-?(\d{3})$/;
var matchWeekDate = /^(\d{4})-?W(\d{2})-?(\d{1})?$/;
var matchCalendarDate = /^(\d{4})-?(\d{2})-?(\d{2})$/;
var utcOffset = /([Z+\-])?(\d{2})?:?(\d{2})?$/;
var matchHours = /^(\d{2})(\.\d+)?/.source + utcOffset.source;
var matchHoursMinutes = /^(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
var matchHoursMinutesSeconds = /^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
var iso8601ErrorMessage = "Invalid ISO 8601 date.";
function JulianDate(julianDayNumber, secondsOfDay, timeStandard) {
  this.dayNumber = void 0;
  this.secondsOfDay = void 0;
  julianDayNumber = julianDayNumber ?? 0;
  secondsOfDay = secondsOfDay ?? 0;
  timeStandard = timeStandard ?? TimeStandard_default.UTC;
  const wholeDays = julianDayNumber | 0;
  secondsOfDay = secondsOfDay + (julianDayNumber - wholeDays) * TimeConstants_default.SECONDS_PER_DAY;
  setComponents(wholeDays, secondsOfDay, this);
  if (timeStandard === TimeStandard_default.UTC) {
    convertUtcToTai(this);
  }
}
JulianDate.fromGregorianDate = function(date, result) {
  if (!(date instanceof GregorianDate_default)) {
    throw new DeveloperError_default("date must be a valid GregorianDate.");
  }
  const components = computeJulianDateComponents(
    date.year,
    date.month,
    date.day,
    date.hour,
    date.minute,
    date.second,
    date.millisecond
  );
  if (!defined_default(result)) {
    return new JulianDate(components[0], components[1], TimeStandard_default.UTC);
  }
  setComponents(components[0], components[1], result);
  convertUtcToTai(result);
  return result;
};
JulianDate.fromDate = function(date, result) {
  if (!(date instanceof Date) || isNaN(date.getTime())) {
    throw new DeveloperError_default("date must be a valid JavaScript Date.");
  }
  const components = computeJulianDateComponents(
    date.getUTCFullYear(),
    date.getUTCMonth() + 1,
    date.getUTCDate(),
    date.getUTCHours(),
    date.getUTCMinutes(),
    date.getUTCSeconds(),
    date.getUTCMilliseconds()
  );
  if (!defined_default(result)) {
    return new JulianDate(components[0], components[1], TimeStandard_default.UTC);
  }
  setComponents(components[0], components[1], result);
  convertUtcToTai(result);
  return result;
};
JulianDate.fromIso8601 = function(iso8601String, result) {
  if (typeof iso8601String !== "string") {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  iso8601String = iso8601String.replace(",", ".");
  let tokens = iso8601String.split("T");
  let year;
  let month = 1;
  let day = 1;
  let hour = 0;
  let minute = 0;
  let second = 0;
  let millisecond = 0;
  const date = tokens[0];
  const time = tokens[1];
  let tmp2;
  let inLeapYear;
  if (!defined_default(date)) {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  let dashCount;
  tokens = date.match(matchCalendarDate);
  if (tokens !== null) {
    dashCount = date.split("-").length - 1;
    if (dashCount > 0 && dashCount !== 2) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    year = +tokens[1];
    month = +tokens[2];
    day = +tokens[3];
  } else {
    tokens = date.match(matchCalendarMonth);
    if (tokens !== null) {
      year = +tokens[1];
      month = +tokens[2];
    } else {
      tokens = date.match(matchCalendarYear);
      if (tokens !== null) {
        year = +tokens[1];
      } else {
        let dayOfYear;
        tokens = date.match(matchOrdinalDate);
        if (tokens !== null) {
          year = +tokens[1];
          dayOfYear = +tokens[2];
          inLeapYear = isLeapYear_default(year);
          if (dayOfYear < 1 || inLeapYear && dayOfYear > 366 || !inLeapYear && dayOfYear > 365) {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        } else {
          tokens = date.match(matchWeekDate);
          if (tokens !== null) {
            year = +tokens[1];
            const weekNumber = +tokens[2];
            const dayOfWeek = +tokens[3] || 0;
            dashCount = date.split("-").length - 1;
            if (dashCount > 0 && (!defined_default(tokens[3]) && dashCount !== 1 || defined_default(tokens[3]) && dashCount !== 2)) {
              throw new DeveloperError_default(iso8601ErrorMessage);
            }
            const january4 = new Date(Date.UTC(year, 0, 4));
            dayOfYear = weekNumber * 7 + dayOfWeek - january4.getUTCDay() - 3;
          } else {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        }
        tmp2 = new Date(Date.UTC(year, 0, 1));
        tmp2.setUTCDate(dayOfYear);
        month = tmp2.getUTCMonth() + 1;
        day = tmp2.getUTCDate();
      }
    }
  }
  inLeapYear = isLeapYear_default(year);
  if (month < 1 || month > 12 || day < 1 || (month !== 2 || !inLeapYear) && day > daysInMonth[month - 1] || inLeapYear && month === 2 && day > daysInLeapFebruary) {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  let offsetIndex;
  if (defined_default(time)) {
    tokens = time.match(matchHoursMinutesSeconds);
    if (tokens !== null) {
      dashCount = time.split(":").length - 1;
      if (dashCount > 0 && dashCount !== 2 && dashCount !== 3) {
        throw new DeveloperError_default(iso8601ErrorMessage);
      }
      hour = +tokens[1];
      minute = +tokens[2];
      second = +tokens[3];
      millisecond = +(tokens[4] || 0) * 1e3;
      offsetIndex = 5;
    } else {
      tokens = time.match(matchHoursMinutes);
      if (tokens !== null) {
        dashCount = time.split(":").length - 1;
        if (dashCount > 2) {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
        hour = +tokens[1];
        minute = +tokens[2];
        second = +(tokens[3] || 0) * 60;
        offsetIndex = 4;
      } else {
        tokens = time.match(matchHours);
        if (tokens !== null) {
          hour = +tokens[1];
          minute = +(tokens[2] || 0) * 60;
          offsetIndex = 3;
        } else {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
      }
    }
    if (minute >= 60 || second >= 61 || hour > 24 || hour === 24 && (minute > 0 || second > 0 || millisecond > 0)) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    const offset = tokens[offsetIndex];
    const offsetHours = +tokens[offsetIndex + 1];
    const offsetMinutes = +(tokens[offsetIndex + 2] || 0);
    switch (offset) {
      case "+":
        hour = hour - offsetHours;
        minute = minute - offsetMinutes;
        break;
      case "-":
        hour = hour + offsetHours;
        minute = minute + offsetMinutes;
        break;
      case "Z":
        break;
      default:
        minute = minute + new Date(
          Date.UTC(year, month - 1, day, hour, minute)
        ).getTimezoneOffset();
        break;
    }
  }
  const isLeapSecond = second === 60;
  if (isLeapSecond) {
    second--;
  }
  while (minute >= 60) {
    minute -= 60;
    hour++;
  }
  while (hour >= 24) {
    hour -= 24;
    day++;
  }
  tmp2 = inLeapYear && month === 2 ? daysInLeapFebruary : daysInMonth[month - 1];
  while (day > tmp2) {
    day -= tmp2;
    month++;
    if (month > 12) {
      month -= 12;
      year++;
    }
    tmp2 = inLeapYear && month === 2 ? daysInLeapFebruary : daysInMonth[month - 1];
  }
  while (minute < 0) {
    minute += 60;
    hour--;
  }
  while (hour < 0) {
    hour += 24;
    day--;
  }
  while (day < 1) {
    month--;
    if (month < 1) {
      month += 12;
      year--;
    }
    tmp2 = inLeapYear && month === 2 ? daysInLeapFebruary : daysInMonth[month - 1];
    day += tmp2;
  }
  const components = computeJulianDateComponents(
    year,
    month,
    day,
    hour,
    minute,
    second,
    millisecond
  );
  if (!defined_default(result)) {
    result = new JulianDate(components[0], components[1], TimeStandard_default.UTC);
  } else {
    setComponents(components[0], components[1], result);
    convertUtcToTai(result);
  }
  if (isLeapSecond) {
    JulianDate.addSeconds(result, 1, result);
  }
  return result;
};
JulianDate.now = function(result) {
  return JulianDate.fromDate(/* @__PURE__ */ new Date(), result);
};
var toGregorianDateScratch = new JulianDate(0, 0, TimeStandard_default.TAI);
JulianDate.toGregorianDate = function(julianDate, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  let isLeapSecond = false;
  let thisUtc = convertTaiToUtc(julianDate, toGregorianDateScratch);
  if (!defined_default(thisUtc)) {
    JulianDate.addSeconds(julianDate, -1, toGregorianDateScratch);
    thisUtc = convertTaiToUtc(toGregorianDateScratch, toGregorianDateScratch);
    isLeapSecond = true;
  }
  let julianDayNumber = thisUtc.dayNumber;
  const secondsOfDay = thisUtc.secondsOfDay;
  if (secondsOfDay >= 43200) {
    julianDayNumber += 1;
  }
  let L = julianDayNumber + 68569 | 0;
  const N = 4 * L / 146097 | 0;
  L = L - ((146097 * N + 3) / 4 | 0) | 0;
  const I = 4e3 * (L + 1) / 1461001 | 0;
  L = L - (1461 * I / 4 | 0) + 31 | 0;
  const J = 80 * L / 2447 | 0;
  const day = L - (2447 * J / 80 | 0) | 0;
  L = J / 11 | 0;
  const month = J + 2 - 12 * L | 0;
  const year = 100 * (N - 49) + I + L | 0;
  let hour = secondsOfDay / TimeConstants_default.SECONDS_PER_HOUR | 0;
  let remainingSeconds = secondsOfDay - hour * TimeConstants_default.SECONDS_PER_HOUR;
  const minute = remainingSeconds / TimeConstants_default.SECONDS_PER_MINUTE | 0;
  remainingSeconds = remainingSeconds - minute * TimeConstants_default.SECONDS_PER_MINUTE;
  let second = remainingSeconds | 0;
  const millisecond = (remainingSeconds - second) / TimeConstants_default.SECONDS_PER_MILLISECOND;
  hour += 12;
  if (hour > 23) {
    hour -= 24;
  }
  if (isLeapSecond) {
    second += 1;
  }
  if (!defined_default(result)) {
    return new GregorianDate_default(
      year,
      month,
      day,
      hour,
      minute,
      second,
      millisecond,
      isLeapSecond
    );
  }
  result.year = year;
  result.month = month;
  result.day = day;
  result.hour = hour;
  result.minute = minute;
  result.second = second;
  result.millisecond = millisecond;
  result.isLeapSecond = isLeapSecond;
  return result;
};
JulianDate.toDate = function(julianDate) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  const gDate = JulianDate.toGregorianDate(julianDate, gregorianDateScratch);
  let second = gDate.second;
  if (gDate.isLeapSecond) {
    second -= 1;
  }
  return new Date(
    Date.UTC(
      gDate.year,
      gDate.month - 1,
      gDate.day,
      gDate.hour,
      gDate.minute,
      second,
      gDate.millisecond
    )
  );
};
JulianDate.toIso8601 = function(julianDate, precision) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  const gDate = JulianDate.toGregorianDate(julianDate, gregorianDateScratch);
  let year = gDate.year;
  let month = gDate.month;
  let day = gDate.day;
  let hour = gDate.hour;
  const minute = gDate.minute;
  const second = gDate.second;
  const millisecond = gDate.millisecond;
  if (year === 1e4 && month === 1 && day === 1 && hour === 0 && minute === 0 && second === 0 && millisecond === 0) {
    year = 9999;
    month = 12;
    day = 31;
    hour = 24;
  }
  let millisecondStr;
  if (!defined_default(precision) && millisecond !== 0) {
    const millisecondHundreds = millisecond * 0.01;
    millisecondStr = millisecondHundreds < 1e-6 ? millisecondHundreds.toFixed(20).replace(".", "").replace(/0+$/, "") : millisecondHundreds.toString().replace(".", "");
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
  }
  if (!defined_default(precision) || precision === 0) {
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}Z`;
  }
  millisecondStr = (millisecond * 0.01).toFixed(precision).replace(".", "").slice(0, precision);
  return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
};
JulianDate.clone = function(julianDate, result) {
  if (!defined_default(julianDate)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new JulianDate(
      julianDate.dayNumber,
      julianDate.secondsOfDay,
      TimeStandard_default.TAI
    );
  }
  result.dayNumber = julianDate.dayNumber;
  result.secondsOfDay = julianDate.secondsOfDay;
  return result;
};
JulianDate.compare = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const julianDayNumberDifference = left.dayNumber - right.dayNumber;
  if (julianDayNumberDifference !== 0) {
    return julianDayNumberDifference;
  }
  return left.secondsOfDay - right.secondsOfDay;
};
JulianDate.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.dayNumber === right.dayNumber && left.secondsOfDay === right.secondsOfDay;
};
JulianDate.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(JulianDate.secondsDifference(left, right)) <= epsilon;
};
JulianDate.totalDays = function(julianDate) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  return julianDate.dayNumber + julianDate.secondsOfDay / TimeConstants_default.SECONDS_PER_DAY;
};
JulianDate.secondsDifference = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const dayDifference = (left.dayNumber - right.dayNumber) * TimeConstants_default.SECONDS_PER_DAY;
  return dayDifference + (left.secondsOfDay - right.secondsOfDay);
};
JulianDate.daysDifference = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const dayDifference = left.dayNumber - right.dayNumber;
  const secondDifference = (left.secondsOfDay - right.secondsOfDay) / TimeConstants_default.SECONDS_PER_DAY;
  return dayDifference + secondDifference;
};
JulianDate.computeTaiMinusUtc = function(julianDate) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
    --index;
    if (index < 0) {
      index = 0;
    }
  }
  return leapSeconds[index].offset;
};
JulianDate.addSeconds = function(julianDate, seconds, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(seconds)) {
    throw new DeveloperError_default("seconds is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  return setComponents(
    julianDate.dayNumber,
    julianDate.secondsOfDay + seconds,
    result
  );
};
JulianDate.addMinutes = function(julianDate, minutes, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(minutes)) {
    throw new DeveloperError_default("minutes is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newSecondsOfDay = julianDate.secondsOfDay + minutes * TimeConstants_default.SECONDS_PER_MINUTE;
  return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
};
JulianDate.addHours = function(julianDate, hours, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(hours)) {
    throw new DeveloperError_default("hours is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newSecondsOfDay = julianDate.secondsOfDay + hours * TimeConstants_default.SECONDS_PER_HOUR;
  return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
};
JulianDate.addDays = function(julianDate, days, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(days)) {
    throw new DeveloperError_default("days is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newJulianDayNumber = julianDate.dayNumber + days;
  return setComponents(newJulianDayNumber, julianDate.secondsOfDay, result);
};
JulianDate.lessThan = function(left, right) {
  return JulianDate.compare(left, right) < 0;
};
JulianDate.lessThanOrEquals = function(left, right) {
  return JulianDate.compare(left, right) <= 0;
};
JulianDate.greaterThan = function(left, right) {
  return JulianDate.compare(left, right) > 0;
};
JulianDate.greaterThanOrEquals = function(left, right) {
  return JulianDate.compare(left, right) >= 0;
};
JulianDate.prototype.clone = function(result) {
  return JulianDate.clone(this, result);
};
JulianDate.prototype.equals = function(right) {
  return JulianDate.equals(this, right);
};
JulianDate.prototype.equalsEpsilon = function(right, epsilon) {
  return JulianDate.equalsEpsilon(this, right, epsilon);
};
JulianDate.prototype.toString = function() {
  return JulianDate.toIso8601(this);
};
JulianDate.leapSeconds = [
  new LeapSecond_default(new JulianDate(2441317, 43210, TimeStandard_default.TAI), 10),
  // January 1, 1972 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2441499, 43211, TimeStandard_default.TAI), 11),
  // July 1, 1972 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2441683, 43212, TimeStandard_default.TAI), 12),
  // January 1, 1973 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2442048, 43213, TimeStandard_default.TAI), 13),
  // January 1, 1974 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2442413, 43214, TimeStandard_default.TAI), 14),
  // January 1, 1975 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2442778, 43215, TimeStandard_default.TAI), 15),
  // January 1, 1976 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2443144, 43216, TimeStandard_default.TAI), 16),
  // January 1, 1977 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2443509, 43217, TimeStandard_default.TAI), 17),
  // January 1, 1978 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2443874, 43218, TimeStandard_default.TAI), 18),
  // January 1, 1979 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2444239, 43219, TimeStandard_default.TAI), 19),
  // January 1, 1980 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2444786, 43220, TimeStandard_default.TAI), 20),
  // July 1, 1981 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2445151, 43221, TimeStandard_default.TAI), 21),
  // July 1, 1982 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2445516, 43222, TimeStandard_default.TAI), 22),
  // July 1, 1983 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2446247, 43223, TimeStandard_default.TAI), 23),
  // July 1, 1985 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2447161, 43224, TimeStandard_default.TAI), 24),
  // January 1, 1988 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2447892, 43225, TimeStandard_default.TAI), 25),
  // January 1, 1990 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2448257, 43226, TimeStandard_default.TAI), 26),
  // January 1, 1991 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2448804, 43227, TimeStandard_default.TAI), 27),
  // July 1, 1992 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2449169, 43228, TimeStandard_default.TAI), 28),
  // July 1, 1993 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2449534, 43229, TimeStandard_default.TAI), 29),
  // July 1, 1994 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2450083, 43230, TimeStandard_default.TAI), 30),
  // January 1, 1996 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2450630, 43231, TimeStandard_default.TAI), 31),
  // July 1, 1997 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2451179, 43232, TimeStandard_default.TAI), 32),
  // January 1, 1999 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2453736, 43233, TimeStandard_default.TAI), 33),
  // January 1, 2006 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2454832, 43234, TimeStandard_default.TAI), 34),
  // January 1, 2009 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2456109, 43235, TimeStandard_default.TAI), 35),
  // July 1, 2012 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2457204, 43236, TimeStandard_default.TAI), 36),
  // July 1, 2015 00:00:00 UTC
  new LeapSecond_default(new JulianDate(2457754, 43237, TimeStandard_default.TAI), 37)
  // January 1, 2017 00:00:00 UTC
];
var JulianDate_default = JulianDate;

// packages/engine/Source/Core/Resource.js
var import_urijs6 = __toESM(require_URI(), 1);

// packages/engine/Source/Core/appendForwardSlash.js
function appendForwardSlash(url2) {
  if (url2.length === 0 || url2[url2.length - 1] !== "/") {
    url2 = `${url2}/`;
  }
  return url2;
}
var appendForwardSlash_default = appendForwardSlash;

// packages/engine/Source/Core/clone.js
function clone(object, deep) {
  if (object === null || typeof object !== "object") {
    return object;
  }
  deep = deep ?? false;
  const result = new object.constructor();
  for (const propertyName in object) {
    if (object.hasOwnProperty(propertyName)) {
      let value = object[propertyName];
      if (deep) {
        value = clone(value, deep);
      }
      result[propertyName] = value;
    }
  }
  return result;
}
var clone_default = clone;

// packages/engine/Source/Core/combine.js
function combine(object1, object2, deep) {
  deep = deep ?? false;
  const result = {};
  const object1Defined = defined_default(object1);
  const object2Defined = defined_default(object2);
  let property;
  let object1Value;
  let object2Value;
  if (object1Defined) {
    for (property in object1) {
      if (object1.hasOwnProperty(property)) {
        object1Value = object1[property];
        if (object2Defined && deep && typeof object1Value === "object" && object2.hasOwnProperty(property)) {
          object2Value = object2[property];
          if (typeof object2Value === "object") {
            result[property] = combine(object1Value, object2Value, deep);
          } else {
            result[property] = object1Value;
          }
        } else {
          result[property] = object1Value;
        }
      }
    }
  }
  if (object2Defined) {
    for (property in object2) {
      if (object2.hasOwnProperty(property) && !result.hasOwnProperty(property)) {
        object2Value = object2[property];
        result[property] = object2Value;
      }
    }
  }
  return result;
}
var combine_default = combine;

// packages/engine/Source/Core/defer.js
function defer() {
  let resolve2;
  let reject;
  const promise = new Promise(function(res, rej) {
    resolve2 = res;
    reject = rej;
  });
  return {
    resolve: resolve2,
    reject,
    promise
  };
}
var defer_default = defer;

// packages/engine/Source/Core/getAbsoluteUri.js
var import_urijs = __toESM(require_URI(), 1);
function getAbsoluteUri(relative, base) {
  let documentObject;
  if (typeof document !== "undefined") {
    documentObject = document;
  }
  return getAbsoluteUri._implementation(relative, base, documentObject);
}
getAbsoluteUri._implementation = function(relative, base, documentObject) {
  if (!defined_default(relative)) {
    throw new DeveloperError_default("relative uri is required.");
  }
  if (!defined_default(base)) {
    if (typeof documentObject === "undefined") {
      return relative;
    }
    base = documentObject.baseURI ?? documentObject.location.href;
  }
  const relativeUri = new import_urijs.default(relative);
  if (relativeUri.scheme() !== "") {
    return relativeUri.toString();
  }
  return relativeUri.absoluteTo(base).toString();
};
var getAbsoluteUri_default = getAbsoluteUri;

// packages/engine/Source/Core/getBaseUri.js
var import_urijs2 = __toESM(require_URI(), 1);
function getBaseUri(uri, includeQuery) {
  if (!defined_default(uri)) {
    throw new DeveloperError_default("uri is required.");
  }
  let basePath = "";
  const i = uri.lastIndexOf("/");
  if (i !== -1) {
    basePath = uri.substring(0, i + 1);
  }
  if (!includeQuery) {
    return basePath;
  }
  uri = new import_urijs2.default(uri);
  if (uri.query().length !== 0) {
    basePath += `?${uri.query()}`;
  }
  if (uri.fragment().length !== 0) {
    basePath += `#${uri.fragment()}`;
  }
  return basePath;
}
var getBaseUri_default = getBaseUri;

// packages/engine/Source/Core/getExtensionFromUri.js
var import_urijs3 = __toESM(require_URI(), 1);
function getExtensionFromUri(uri) {
  if (!defined_default(uri)) {
    throw new DeveloperError_default("uri is required.");
  }
  const uriObject = new import_urijs3.default(uri);
  uriObject.normalize();
  let path = uriObject.path();
  let index = path.lastIndexOf("/");
  if (index !== -1) {
    path = path.substr(index + 1);
  }
  index = path.lastIndexOf(".");
  if (index === -1) {
    path = "";
  } else {
    path = path.substr(index + 1);
  }
  return path;
}
var getExtensionFromUri_default = getExtensionFromUri;

// packages/engine/Source/Core/getImagePixels.js
var context2DsByWidthAndHeight = {};
function getImagePixels(image, width, height) {
  if (!defined_default(width)) {
    width = image.width;
  }
  if (!defined_default(height)) {
    height = image.height;
  }
  let context2DsByHeight = context2DsByWidthAndHeight[width];
  if (!defined_default(context2DsByHeight)) {
    context2DsByHeight = {};
    context2DsByWidthAndHeight[width] = context2DsByHeight;
  }
  let context2d = context2DsByHeight[height];
  if (!defined_default(context2d)) {
    const canvas = document.createElement("canvas");
    canvas.width = width;
    canvas.height = height;
    context2d = canvas.getContext("2d", { willReadFrequently: true });
    context2d.globalCompositeOperation = "copy";
    context2DsByHeight[height] = context2d;
  }
  context2d.drawImage(image, 0, 0, width, height);
  return context2d.getImageData(0, 0, width, height).data;
}
var getImagePixels_default = getImagePixels;

// packages/engine/Source/Core/isBlobUri.js
var blobUriRegex = /^blob:/i;
function isBlobUri(uri) {
  Check_default.typeOf.string("uri", uri);
  return blobUriRegex.test(uri);
}
var isBlobUri_default = isBlobUri;

// packages/engine/Source/Core/isCrossOriginUrl.js
var a;
function isCrossOriginUrl(url2) {
  if (!defined_default(a)) {
    a = document.createElement("a");
  }
  a.href = window.location.href;
  const host = a.host;
  const protocol = a.protocol;
  a.href = url2;
  a.href = a.href;
  return protocol !== a.protocol || host !== a.host;
}
var isCrossOriginUrl_default = isCrossOriginUrl;

// packages/engine/Source/Core/isDataUri.js
var dataUriRegex = /^data:/i;
function isDataUri(uri) {
  Check_default.typeOf.string("uri", uri);
  return dataUriRegex.test(uri);
}
var isDataUri_default = isDataUri;

// packages/engine/Source/Core/loadAndExecuteScript.js
function loadAndExecuteScript(url2) {
  const script = document.createElement("script");
  script.async = true;
  script.src = url2;
  return new Promise((resolve2, reject) => {
    if (window.crossOriginIsolated) {
      script.setAttribute("crossorigin", "anonymous");
    }
    const head = document.getElementsByTagName("head")[0];
    script.onload = function() {
      script.onload = void 0;
      head.removeChild(script);
      resolve2();
    };
    script.onerror = function(e) {
      reject(e);
    };
    head.appendChild(script);
  });
}
var loadAndExecuteScript_default = loadAndExecuteScript;

// packages/engine/Source/Core/objectToQuery.js
function objectToQuery(obj) {
  if (!defined_default(obj)) {
    throw new DeveloperError_default("obj is required.");
  }
  let result = "";
  for (const propName in obj) {
    if (obj.hasOwnProperty(propName)) {
      const value = obj[propName];
      const part = `${encodeURIComponent(propName)}=`;
      if (Array.isArray(value)) {
        for (let i = 0, len = value.length; i < len; ++i) {
          result += `${part + encodeURIComponent(value[i])}&`;
        }
      } else {
        result += `${part + encodeURIComponent(value)}&`;
      }
    }
  }
  result = result.slice(0, -1);
  return result;
}
var objectToQuery_default = objectToQuery;

// packages/engine/Source/Core/queryToObject.js
function queryToObject(queryString) {
  if (!defined_default(queryString)) {
    throw new DeveloperError_default("queryString is required.");
  }
  const result = {};
  if (queryString === "") {
    return result;
  }
  const parts = queryString.replace(/\+/g, "%20").split(/[&;]/);
  for (let i = 0, len = parts.length; i < len; ++i) {
    const subparts = parts[i].split("=");
    const name = decodeURIComponent(subparts[0]);
    let value = subparts[1];
    if (defined_default(value)) {
      value = decodeURIComponent(value);
    } else {
      value = "";
    }
    const resultValue = result[name];
    if (typeof resultValue === "string") {
      result[name] = [resultValue, value];
    } else if (Array.isArray(resultValue)) {
      resultValue.push(value);
    } else {
      result[name] = value;
    }
  }
  return result;
}
var queryToObject_default = queryToObject;

// packages/engine/Source/Core/RequestState.js
var RequestState = {
  /**
   * Initial unissued state.
   *
   * @type {number}
   * @constant
   */
  UNISSUED: 0,
  /**
   * Issued but not yet active. Will become active when open slots are available.
   *
   * @type {number}
   * @constant
   */
  ISSUED: 1,
  /**
   * Actual http request has been sent.
   *
   * @type {number}
   * @constant
   */
  ACTIVE: 2,
  /**
   * Request completed successfully.
   *
   * @type {number}
   * @constant
   */
  RECEIVED: 3,
  /**
   * Request was cancelled, either explicitly or automatically because of low priority.
   *
   * @type {number}
   * @constant
   */
  CANCELLED: 4,
  /**
   * Request failed.
   *
   * @type {number}
   * @constant
   */
  FAILED: 5
};
var RequestState_default = Object.freeze(RequestState);

// packages/engine/Source/Core/RequestType.js
var RequestType = {
  /**
   * Terrain request.
   *
   * @type {number}
   * @constant
   */
  TERRAIN: 0,
  /**
   * Imagery request.
   *
   * @type {number}
   * @constant
   */
  IMAGERY: 1,
  /**
   * 3D Tiles request.
   *
   * @type {number}
   * @constant
   */
  TILES3D: 2,
  /**
   * Other request.
   *
   * @type {number}
   * @constant
   */
  OTHER: 3
};
var RequestType_default = Object.freeze(RequestType);

// packages/engine/Source/Core/Request.js
function Request(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  const throttleByServer = options.throttleByServer ?? false;
  const throttle = options.throttle ?? false;
  this.url = options.url;
  this.requestFunction = options.requestFunction;
  this.cancelFunction = options.cancelFunction;
  this.priorityFunction = options.priorityFunction;
  this.priority = options.priority ?? 0;
  this.throttle = throttle;
  this.throttleByServer = throttleByServer;
  this.type = options.type ?? RequestType_default.OTHER;
  this.serverKey = options.serverKey;
  this.state = RequestState_default.UNISSUED;
  this.deferred = void 0;
  this.cancelled = false;
}
Request.prototype.cancel = function() {
  this.cancelled = true;
};
Request.prototype.clone = function(result) {
  if (!defined_default(result)) {
    return new Request(this);
  }
  result.url = this.url;
  result.requestFunction = this.requestFunction;
  result.cancelFunction = this.cancelFunction;
  result.priorityFunction = this.priorityFunction;
  result.priority = this.priority;
  result.throttle = this.throttle;
  result.throttleByServer = this.throttleByServer;
  result.type = this.type;
  result.serverKey = this.serverKey;
  result.state = RequestState_default.UNISSUED;
  result.deferred = void 0;
  result.cancelled = false;
  return result;
};
var Request_default = Request;

// packages/engine/Source/Core/parseResponseHeaders.js
function parseResponseHeaders(headerString) {
  const headers = {};
  if (!headerString) {
    return headers;
  }
  const headerPairs = headerString.split("\r\n");
  for (let i = 0; i < headerPairs.length; ++i) {
    const headerPair = headerPairs[i];
    const index = headerPair.indexOf(": ");
    if (index > 0) {
      const key = headerPair.substring(0, index);
      const val = headerPair.substring(index + 2);
      headers[key] = val;
    }
  }
  return headers;
}
var parseResponseHeaders_default = parseResponseHeaders;

// packages/engine/Source/Core/RequestErrorEvent.js
function RequestErrorEvent(statusCode, response, responseHeaders) {
  this.statusCode = statusCode;
  this.response = response;
  this.responseHeaders = responseHeaders;
  if (typeof this.responseHeaders === "string") {
    this.responseHeaders = parseResponseHeaders_default(this.responseHeaders);
  }
}
RequestErrorEvent.prototype.toString = function() {
  let str = "Request has failed.";
  if (defined_default(this.statusCode)) {
    str += ` Status Code: ${this.statusCode}`;
  }
  return str;
};
var RequestErrorEvent_default = RequestErrorEvent;

// packages/engine/Source/Core/RequestScheduler.js
var import_urijs4 = __toESM(require_URI(), 1);

// packages/engine/Source/Core/Event.js
function Event() {
  this._listeners = /* @__PURE__ */ new Map();
  this._toRemove = /* @__PURE__ */ new Map();
  this._toAdd = /* @__PURE__ */ new Map();
  this._invokingListeners = false;
  this._listenerCount = 0;
}
Object.defineProperties(Event.prototype, {
  /**
   * The number of listeners currently subscribed to the event.
   * @memberof Event.prototype
   * @type {number}
   * @readonly
   */
  numberOfListeners: {
    get: function() {
      return this._listenerCount;
    }
  }
});
Event.prototype.addEventListener = function(listener, scope) {
  Check_default.typeOf.func("listener", listener);
  const event = this;
  const listenerMap = event._invokingListeners ? event._toAdd : event._listeners;
  const added = addEventListener(this, listenerMap, listener, scope);
  if (added) {
    event._listenerCount++;
  }
  return function() {
    event.removeEventListener(listener, scope);
  };
};
function addEventListener(event, listenerMap, listener, scope) {
  if (!listenerMap.has(listener)) {
    listenerMap.set(listener, /* @__PURE__ */ new Set());
  }
  const scopes = listenerMap.get(listener);
  if (!scopes.has(scope)) {
    scopes.add(scope);
    return true;
  }
  return false;
}
Event.prototype.removeEventListener = function(listener, scope) {
  Check_default.typeOf.func("listener", listener);
  const removedFromListeners = removeEventListener(
    this,
    this._listeners,
    listener,
    scope
  );
  const removedFromToAdd = removeEventListener(
    this,
    this._toAdd,
    listener,
    scope
  );
  const removed = removedFromListeners || removedFromToAdd;
  if (removed) {
    this._listenerCount--;
  }
  return removed;
};
function removeEventListener(event, listenerMap, listener, scope) {
  const scopes = listenerMap.get(listener);
  if (!scopes || !scopes.has(scope)) {
    return false;
  }
  if (event._invokingListeners) {
    if (!addEventListener(event, event._toRemove, listener, scope)) {
      return false;
    }
  } else {
    scopes.delete(scope);
    if (scopes.size === 0) {
      listenerMap.delete(listener);
    }
  }
  return true;
}
Event.prototype.raiseEvent = function() {
  this._invokingListeners = true;
  for (const [listener, scopes] of this._listeners.entries()) {
    if (!defined_default(listener)) {
      continue;
    }
    for (const scope of scopes) {
      listener.apply(scope, arguments);
    }
  }
  this._invokingListeners = false;
  for (const [listener, scopes] of this._toAdd.entries()) {
    for (const scope of scopes) {
      addEventListener(this, this._listeners, listener, scope);
    }
  }
  this._toAdd.clear();
  for (const [listener, scopes] of this._toRemove.entries()) {
    for (const scope of scopes) {
      removeEventListener(this, this._listeners, listener, scope);
    }
  }
  this._toRemove.clear();
};
var Event_default = Event;

// packages/engine/Source/Core/Heap.js
function Heap(options) {
  Check_default.typeOf.object("options", options);
  Check_default.defined("options.comparator", options.comparator);
  this._comparator = options.comparator;
  this._array = [];
  this._length = 0;
  this._maximumLength = void 0;
}
Object.defineProperties(Heap.prototype, {
  /**
   * Gets the length of the heap.
   *
   * @memberof Heap.prototype
   *
   * @type {number}
   * @readonly
   */
  length: {
    get: function() {
      return this._length;
    }
  },
  /**
   * Gets the internal array.
   *
   * @memberof Heap.prototype
   *
   * @type {Array}
   * @readonly
   */
  internalArray: {
    get: function() {
      return this._array;
    }
  },
  /**
   * Gets and sets the maximum length of the heap.
   *
   * @memberof Heap.prototype
   *
   * @type {number}
   */
  maximumLength: {
    get: function() {
      return this._maximumLength;
    },
    set: function(value) {
      Check_default.typeOf.number.greaterThanOrEquals("maximumLength", value, 0);
      const originalLength = this._length;
      if (value < originalLength) {
        const array = this._array;
        for (let i = value; i < originalLength; ++i) {
          array[i] = void 0;
        }
        this._length = value;
        array.length = value;
      }
      this._maximumLength = value;
    }
  },
  /**
   * The comparator to use for the heap. If comparator(a, b) is less than 0, sort a to a lower index than b, otherwise sort to a higher index.
   *
   * @memberof Heap.prototype
   *
   * @type {Heap.ComparatorCallback}
   */
  comparator: {
    get: function() {
      return this._comparator;
    }
  }
});
function swap(array, a3, b) {
  const temp = array[a3];
  array[a3] = array[b];
  array[b] = temp;
}
Heap.prototype.reserve = function(length2) {
  length2 = length2 ?? this._length;
  this._array.length = length2;
};
Heap.prototype.heapify = function(index) {
  index = index ?? 0;
  const length2 = this._length;
  const comparator = this._comparator;
  const array = this._array;
  let candidate = -1;
  let inserting = true;
  while (inserting) {
    const right = 2 * (index + 1);
    const left = right - 1;
    if (left < length2 && comparator(array[left], array[index]) < 0) {
      candidate = left;
    } else {
      candidate = index;
    }
    if (right < length2 && comparator(array[right], array[candidate]) < 0) {
      candidate = right;
    }
    if (candidate !== index) {
      swap(array, candidate, index);
      index = candidate;
    } else {
      inserting = false;
    }
  }
};
Heap.prototype.resort = function() {
  const length2 = this._length;
  for (let i = Math.ceil(length2 / 2); i >= 0; --i) {
    this.heapify(i);
  }
};
Heap.prototype.insert = function(element) {
  Check_default.defined("element", element);
  const array = this._array;
  const comparator = this._comparator;
  const maximumLength = this._maximumLength;
  let index = this._length++;
  if (index < array.length) {
    array[index] = element;
  } else {
    array.push(element);
  }
  while (index !== 0) {
    const parent = Math.floor((index - 1) / 2);
    if (comparator(array[index], array[parent]) < 0) {
      swap(array, index, parent);
      index = parent;
    } else {
      break;
    }
  }
  let removedElement;
  if (defined_default(maximumLength) && this._length > maximumLength) {
    removedElement = array[maximumLength];
    this._length = maximumLength;
  }
  return removedElement;
};
Heap.prototype.pop = function(index) {
  index = index ?? 0;
  if (this._length === 0) {
    return void 0;
  }
  Check_default.typeOf.number.lessThan("index", index, this._length);
  const array = this._array;
  const root = array[index];
  swap(array, index, --this._length);
  this.heapify(index);
  array[this._length] = void 0;
  return root;
};
var Heap_default = Heap;

// packages/engine/Source/Core/RequestScheduler.js
function sortRequests(a3, b) {
  return a3.priority - b.priority;
}
var statistics = {
  numberOfAttemptedRequests: 0,
  numberOfActiveRequests: 0,
  numberOfCancelledRequests: 0,
  numberOfCancelledActiveRequests: 0,
  numberOfFailedRequests: 0,
  numberOfActiveRequestsEver: 0,
  lastNumberOfActiveRequests: 0
};
var priorityHeapLength = 20;
var requestHeap = new Heap_default({
  comparator: sortRequests
});
requestHeap.maximumLength = priorityHeapLength;
requestHeap.reserve(priorityHeapLength);
var activeRequests = [];
var numberOfActiveRequestsByServer = {};
var pageUri = typeof document !== "undefined" ? new import_urijs4.default(document.location.href) : new import_urijs4.default();
var requestCompletedEvent = new Event_default();
function RequestScheduler() {
}
RequestScheduler.maximumRequests = 50;
RequestScheduler.maximumRequestsPerServer = 18;
RequestScheduler.requestsByServer = {};
RequestScheduler.throttleRequests = true;
RequestScheduler.debugShowStatistics = false;
RequestScheduler.requestCompletedEvent = requestCompletedEvent;
Object.defineProperties(RequestScheduler, {
  /**
   * Returns the statistics used by the request scheduler.
   *
   * @memberof RequestScheduler
   *
   * @type {object}
   * @readonly
   * @private
   */
  statistics: {
    get: function() {
      return statistics;
    }
  },
  /**
   * The maximum size of the priority heap. This limits the number of requests that are sorted by priority. Only applies to requests that are not yet active.
   *
   * @memberof RequestScheduler
   *
   * @type {number}
   * @default 20
   * @private
   */
  priorityHeapLength: {
    get: function() {
      return priorityHeapLength;
    },
    set: function(value) {
      if (value < priorityHeapLength) {
        while (requestHeap.length > value) {
          const request = requestHeap.pop();
          cancelRequest(request);
        }
      }
      priorityHeapLength = value;
      requestHeap.maximumLength = value;
      requestHeap.reserve(value);
    }
  }
});
function updatePriority(request) {
  if (defined_default(request.priorityFunction)) {
    request.priority = request.priorityFunction();
  }
}
RequestScheduler.serverHasOpenSlots = function(serverKey, desiredRequests) {
  desiredRequests = desiredRequests ?? 1;
  const maxRequests = RequestScheduler.requestsByServer[serverKey] ?? RequestScheduler.maximumRequestsPerServer;
  const hasOpenSlotsServer = numberOfActiveRequestsByServer[serverKey] + desiredRequests <= maxRequests;
  return hasOpenSlotsServer;
};
RequestScheduler.heapHasOpenSlots = function(desiredRequests) {
  const hasOpenSlotsHeap = requestHeap.length + desiredRequests <= priorityHeapLength;
  return hasOpenSlotsHeap;
};
function issueRequest(request) {
  if (request.state === RequestState_default.UNISSUED) {
    request.state = RequestState_default.ISSUED;
    request.deferred = defer_default();
  }
  return request.deferred.promise;
}
function getRequestReceivedFunction(request) {
  return function(results) {
    if (request.state === RequestState_default.CANCELLED) {
      return;
    }
    const deferred = request.deferred;
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    requestCompletedEvent.raiseEvent();
    request.state = RequestState_default.RECEIVED;
    request.deferred = void 0;
    deferred.resolve(results);
  };
}
function getRequestFailedFunction(request) {
  return function(error) {
    if (request.state === RequestState_default.CANCELLED) {
      return;
    }
    ++statistics.numberOfFailedRequests;
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    requestCompletedEvent.raiseEvent(error);
    request.state = RequestState_default.FAILED;
    request.deferred.reject(error);
  };
}
function startRequest(request) {
  const promise = issueRequest(request);
  request.state = RequestState_default.ACTIVE;
  activeRequests.push(request);
  ++statistics.numberOfActiveRequests;
  ++statistics.numberOfActiveRequestsEver;
  ++numberOfActiveRequestsByServer[request.serverKey];
  request.requestFunction().then(getRequestReceivedFunction(request)).catch(getRequestFailedFunction(request));
  return promise;
}
function cancelRequest(request) {
  const active = request.state === RequestState_default.ACTIVE;
  request.state = RequestState_default.CANCELLED;
  ++statistics.numberOfCancelledRequests;
  if (defined_default(request.deferred)) {
    const deferred = request.deferred;
    request.deferred = void 0;
    deferred.reject();
  }
  if (active) {
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    ++statistics.numberOfCancelledActiveRequests;
  }
  if (defined_default(request.cancelFunction)) {
    request.cancelFunction();
  }
}
RequestScheduler.update = function() {
  let i;
  let request;
  let removeCount = 0;
  const activeLength = activeRequests.length;
  for (i = 0; i < activeLength; ++i) {
    request = activeRequests[i];
    if (request.cancelled) {
      cancelRequest(request);
    }
    if (request.state !== RequestState_default.ACTIVE) {
      ++removeCount;
      continue;
    }
    if (removeCount > 0) {
      activeRequests[i - removeCount] = request;
    }
  }
  activeRequests.length -= removeCount;
  const issuedRequests = requestHeap.internalArray;
  const issuedLength = requestHeap.length;
  for (i = 0; i < issuedLength; ++i) {
    updatePriority(issuedRequests[i]);
  }
  requestHeap.resort();
  const openSlots = Math.max(
    RequestScheduler.maximumRequests - activeRequests.length,
    0
  );
  let filledSlots = 0;
  while (filledSlots < openSlots && requestHeap.length > 0) {
    request = requestHeap.pop();
    if (request.cancelled) {
      cancelRequest(request);
      continue;
    }
    if (request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
      cancelRequest(request);
      continue;
    }
    startRequest(request);
    ++filledSlots;
  }
  updateStatistics();
};
RequestScheduler.getServerKey = function(url2) {
  Check_default.typeOf.string("url", url2);
  let uri = new import_urijs4.default(url2);
  if (uri.scheme() === "") {
    uri = uri.absoluteTo(pageUri);
    uri.normalize();
  }
  let serverKey = uri.authority();
  if (!/:/.test(serverKey)) {
    serverKey = `${serverKey}:${uri.scheme() === "https" ? "443" : "80"}`;
  }
  const length2 = numberOfActiveRequestsByServer[serverKey];
  if (!defined_default(length2)) {
    numberOfActiveRequestsByServer[serverKey] = 0;
  }
  return serverKey;
};
RequestScheduler.request = function(request) {
  Check_default.typeOf.object("request", request);
  Check_default.typeOf.string("request.url", request.url);
  Check_default.typeOf.func("request.requestFunction", request.requestFunction);
  if (isDataUri_default(request.url) || isBlobUri_default(request.url)) {
    requestCompletedEvent.raiseEvent();
    request.state = RequestState_default.RECEIVED;
    return request.requestFunction();
  }
  ++statistics.numberOfAttemptedRequests;
  if (!defined_default(request.serverKey)) {
    request.serverKey = RequestScheduler.getServerKey(request.url);
  }
  if (RequestScheduler.throttleRequests && request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
    return void 0;
  }
  if (!RequestScheduler.throttleRequests || !request.throttle) {
    return startRequest(request);
  }
  if (activeRequests.length >= RequestScheduler.maximumRequests) {
    return void 0;
  }
  updatePriority(request);
  const removedRequest = requestHeap.insert(request);
  if (defined_default(removedRequest)) {
    if (removedRequest === request) {
      return void 0;
    }
    cancelRequest(removedRequest);
  }
  return issueRequest(request);
};
function updateStatistics() {
  if (!RequestScheduler.debugShowStatistics) {
    return;
  }
  if (statistics.numberOfActiveRequests === 0 && statistics.lastNumberOfActiveRequests > 0) {
    if (statistics.numberOfAttemptedRequests > 0) {
      console.log(
        `Number of attempted requests: ${statistics.numberOfAttemptedRequests}`
      );
      statistics.numberOfAttemptedRequests = 0;
    }
    if (statistics.numberOfCancelledRequests > 0) {
      console.log(
        `Number of cancelled requests: ${statistics.numberOfCancelledRequests}`
      );
      statistics.numberOfCancelledRequests = 0;
    }
    if (statistics.numberOfCancelledActiveRequests > 0) {
      console.log(
        `Number of cancelled active requests: ${statistics.numberOfCancelledActiveRequests}`
      );
      statistics.numberOfCancelledActiveRequests = 0;
    }
    if (statistics.numberOfFailedRequests > 0) {
      console.log(
        `Number of failed requests: ${statistics.numberOfFailedRequests}`
      );
      statistics.numberOfFailedRequests = 0;
    }
  }
  statistics.lastNumberOfActiveRequests = statistics.numberOfActiveRequests;
}
RequestScheduler.clearForSpecs = function() {
  while (requestHeap.length > 0) {
    const request = requestHeap.pop();
    cancelRequest(request);
  }
  const length2 = activeRequests.length;
  for (let i = 0; i < length2; ++i) {
    cancelRequest(activeRequests[i]);
  }
  activeRequests.length = 0;
  numberOfActiveRequestsByServer = {};
  statistics.numberOfAttemptedRequests = 0;
  statistics.numberOfActiveRequests = 0;
  statistics.numberOfCancelledRequests = 0;
  statistics.numberOfCancelledActiveRequests = 0;
  statistics.numberOfFailedRequests = 0;
  statistics.numberOfActiveRequestsEver = 0;
  statistics.lastNumberOfActiveRequests = 0;
};
RequestScheduler.numberOfActiveRequestsByServer = function(serverKey) {
  return numberOfActiveRequestsByServer[serverKey];
};
RequestScheduler.requestHeap = requestHeap;
var RequestScheduler_default = RequestScheduler;

// packages/engine/Source/Core/TrustedServers.js
var import_urijs5 = __toESM(require_URI(), 1);
var TrustedServers = {};
var _servers = {};
TrustedServers.add = function(host, port) {
  if (!defined_default(host)) {
    throw new DeveloperError_default("host is required.");
  }
  if (!defined_default(port) || port <= 0) {
    throw new DeveloperError_default("port is required to be greater than 0.");
  }
  const authority = `${host.toLowerCase()}:${port}`;
  if (!defined_default(_servers[authority])) {
    _servers[authority] = true;
  }
};
TrustedServers.remove = function(host, port) {
  if (!defined_default(host)) {
    throw new DeveloperError_default("host is required.");
  }
  if (!defined_default(port) || port <= 0) {
    throw new DeveloperError_default("port is required to be greater than 0.");
  }
  const authority = `${host.toLowerCase()}:${port}`;
  if (defined_default(_servers[authority])) {
    delete _servers[authority];
  }
};
function getAuthority(url2) {
  const uri = new import_urijs5.default(url2);
  uri.normalize();
  let authority = uri.authority();
  if (authority.length === 0) {
    return void 0;
  }
  uri.authority(authority);
  if (authority.indexOf("@") !== -1) {
    const parts = authority.split("@");
    authority = parts[1];
  }
  if (authority.indexOf(":") === -1) {
    let scheme = uri.scheme();
    if (scheme.length === 0) {
      scheme = window.location.protocol;
      scheme = scheme.substring(0, scheme.length - 1);
    }
    if (scheme === "http") {
      authority += ":80";
    } else if (scheme === "https") {
      authority += ":443";
    } else {
      return void 0;
    }
  }
  return authority;
}
TrustedServers.contains = function(url2) {
  if (!defined_default(url2)) {
    throw new DeveloperError_default("url is required.");
  }
  const authority = getAuthority(url2);
  if (defined_default(authority) && defined_default(_servers[authority])) {
    return true;
  }
  return false;
};
TrustedServers.clear = function() {
  _servers = {};
};
var TrustedServers_default = TrustedServers;

// packages/engine/Source/Core/Resource.js
var xhrBlobSupported = (function() {
  try {
    const xhr = new XMLHttpRequest();
    xhr.open("GET", "#", true);
    xhr.responseType = "blob";
    return xhr.responseType === "blob";
  } catch (e) {
    return false;
  }
})();
function Resource(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  if (typeof options === "string") {
    options = {
      url: options
    };
  }
  Check_default.typeOf.string("options.url", options.url);
  this._url = void 0;
  this._templateValues = defaultClone(options.templateValues, {});
  this._queryParameters = defaultClone(options.queryParameters, {});
  this.headers = defaultClone(options.headers, {});
  this.request = options.request ?? new Request_default();
  this.proxy = options.proxy;
  this.retryCallback = options.retryCallback;
  this.retryAttempts = options.retryAttempts ?? 0;
  this._retryCount = 0;
  const parseUrl = options.parseUrl ?? true;
  if (parseUrl) {
    this.parseUrl(options.url, true, true);
  } else {
    this._url = options.url;
  }
  this._credits = options.credits;
}
function defaultClone(value, defaultValue) {
  return defined_default(value) ? clone_default(value) : defaultValue;
}
Resource.createIfNeeded = function(resource) {
  if (resource instanceof Resource) {
    return resource.getDerivedResource({
      request: resource.request
    });
  }
  if (typeof resource !== "string") {
    return resource;
  }
  return new Resource({
    url: resource
  });
};
var supportsImageBitmapOptionsPromise;
Resource.supportsImageBitmapOptions = function() {
  if (defined_default(supportsImageBitmapOptionsPromise)) {
    return supportsImageBitmapOptionsPromise;
  }
  if (typeof createImageBitmap !== "function") {
    supportsImageBitmapOptionsPromise = Promise.resolve(false);
    return supportsImageBitmapOptionsPromise;
  }
  const imageDataUri = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAABGdBTUEAAE4g3rEiDgAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAADElEQVQI12Ng6GAAAAEUAIngE3ZiAAAAAElFTkSuQmCC";
  supportsImageBitmapOptionsPromise = Resource.fetchBlob({
    url: imageDataUri
  }).then(function(blob) {
    const imageBitmapOptions = {
      // 'from-image' is deprecated, new option is 'none'. However, we still need to support older browsers,
      // and there's no good way to detect support for these options. For now, continue to use 'from-image'. See: https://github.com/CesiumGS/cesium/issues/12846
      imageOrientation: "flipY",
      // default is "from-image"
      premultiplyAlpha: "none",
      // default is "default"
      colorSpaceConversion: "none"
      // default is "default"
    };
    return Promise.all([
      createImageBitmap(blob, imageBitmapOptions),
      createImageBitmap(blob)
    ]);
  }).then(function(imageBitmaps) {
    const colorWithOptions = getImagePixels_default(imageBitmaps[0]);
    const colorWithDefaults = getImagePixels_default(imageBitmaps[1]);
    return colorWithOptions[1] !== colorWithDefaults[1];
  }).catch(function() {
    return false;
  });
  return supportsImageBitmapOptionsPromise;
};
Object.defineProperties(Resource, {
  /**
   * Returns true if blobs are supported.
   *
   * @memberof Resource
   * @type {boolean}
   *
   * @readonly
   */
  isBlobSupported: {
    get: function() {
      return xhrBlobSupported;
    }
  }
});
Object.defineProperties(Resource.prototype, {
  /**
   * Query parameters appended to the url.
   *
   * @memberof Resource.prototype
   * @type {object}
   *
   * @readonly
   */
  queryParameters: {
    get: function() {
      return this._queryParameters;
    }
  },
  /**
   * The key/value pairs used to replace template parameters in the url.
   *
   * @memberof Resource.prototype
   * @type {object}
   *
   * @readonly
   */
  templateValues: {
    get: function() {
      return this._templateValues;
    }
  },
  /**
   * The url to the resource with template values replaced, query string appended and encoded by proxy if one was set.
   *
   * @memberof Resource.prototype
   * @type {string}
   */
  url: {
    get: function() {
      return this.getUrlComponent(true, true);
    },
    set: function(value) {
      this.parseUrl(value, false, false);
    }
  },
  /**
   * The file extension of the resource.
   *
   * @memberof Resource.prototype
   * @type {string}
   *
   * @readonly
   */
  extension: {
    get: function() {
      return getExtensionFromUri_default(this._url);
    }
  },
  /**
   * True if the Resource refers to a data URI.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  isDataUri: {
    get: function() {
      return isDataUri_default(this._url);
    }
  },
  /**
   * True if the Resource refers to a blob URI.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  isBlobUri: {
    get: function() {
      return isBlobUri_default(this._url);
    }
  },
  /**
   * True if the Resource refers to a cross origin URL.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  isCrossOriginUrl: {
    get: function() {
      return isCrossOriginUrl_default(this._url);
    }
  },
  /**
   * True if the Resource has request headers. This is equivalent to checking if the headers property has any keys.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  hasHeaders: {
    get: function() {
      return Object.keys(this.headers).length > 0;
    }
  },
  /**
   * Gets the credits required for attribution of an asset.
   * @private
   */
  credits: {
    get: function() {
      return this._credits;
    }
  }
});
Resource.prototype.toString = function() {
  return this.getUrlComponent(true, true);
};
Resource.prototype.parseUrl = function(url2, merge2, preserveQuery, baseUrl) {
  let uri = new import_urijs6.default(url2);
  const query = parseQueryString(uri.query());
  this._queryParameters = merge2 ? combineQueryParameters(query, this.queryParameters, preserveQuery) : query;
  uri.search("");
  uri.fragment("");
  if (defined_default(baseUrl) && uri.scheme() === "") {
    uri = uri.absoluteTo(getAbsoluteUri_default(baseUrl));
  }
  this._url = uri.toString();
};
function parseQueryString(queryString) {
  if (queryString.length === 0) {
    return {};
  }
  if (queryString.indexOf("=") === -1) {
    return { [queryString]: void 0 };
  }
  return queryToObject_default(queryString);
}
function combineQueryParameters(q12, q22, preserveQueryParameters) {
  if (!preserveQueryParameters) {
    return combine_default(q12, q22);
  }
  const result = clone_default(q12, true);
  for (const param in q22) {
    if (q22.hasOwnProperty(param)) {
      let value = result[param];
      const q2Value = q22[param];
      if (defined_default(value)) {
        if (!Array.isArray(value)) {
          value = result[param] = [value];
        }
        result[param] = value.concat(q2Value);
      } else {
        result[param] = Array.isArray(q2Value) ? q2Value.slice() : q2Value;
      }
    }
  }
  return result;
}
Resource.prototype.getUrlComponent = function(query, proxy) {
  if (this.isDataUri) {
    return this._url;
  }
  let url2 = this._url;
  if (query) {
    url2 = `${url2}${stringifyQuery(this.queryParameters)}`;
  }
  url2 = url2.replace(/%7B/g, "{").replace(/%7D/g, "}");
  const templateValues = this._templateValues;
  if (Object.keys(templateValues).length > 0) {
    url2 = url2.replace(/{(.*?)}/g, function(match, key) {
      const replacement = templateValues[key];
      if (defined_default(replacement)) {
        return encodeURIComponent(replacement);
      }
      return match;
    });
  }
  if (proxy && defined_default(this.proxy)) {
    url2 = this.proxy.getURL(url2);
  }
  return url2;
};
function stringifyQuery(queryObject) {
  const keys = Object.keys(queryObject);
  if (keys.length === 0) {
    return "";
  }
  if (keys.length === 1 && !defined_default(queryObject[keys[0]])) {
    return `?${keys[0]}`;
  }
  return `?${objectToQuery_default(queryObject)}`;
}
Resource.prototype.setQueryParameters = function(params, useAsDefault) {
  if (useAsDefault) {
    this._queryParameters = combineQueryParameters(
      this._queryParameters,
      params,
      false
    );
  } else {
    this._queryParameters = combineQueryParameters(
      params,
      this._queryParameters,
      false
    );
  }
};
Resource.prototype.appendQueryParameters = function(params) {
  this._queryParameters = combineQueryParameters(
    params,
    this._queryParameters,
    true
  );
};
Resource.prototype.setTemplateValues = function(template, useAsDefault) {
  if (useAsDefault) {
    this._templateValues = combine_default(this._templateValues, template);
  } else {
    this._templateValues = combine_default(template, this._templateValues);
  }
};
Resource.prototype.getDerivedResource = function(options) {
  const resource = this.clone();
  resource._retryCount = 0;
  if (defined_default(options.url)) {
    const preserveQuery = options.preserveQueryParameters ?? false;
    resource.parseUrl(options.url, true, preserveQuery, this._url);
  }
  if (defined_default(options.queryParameters)) {
    resource._queryParameters = combine_default(
      options.queryParameters,
      resource.queryParameters
    );
  }
  if (defined_default(options.templateValues)) {
    resource._templateValues = combine_default(
      options.templateValues,
      resource.templateValues
    );
  }
  if (defined_default(options.headers)) {
    resource.headers = combine_default(options.headers, resource.headers);
  }
  if (defined_default(options.proxy)) {
    resource.proxy = options.proxy;
  }
  if (defined_default(options.request)) {
    resource.request = options.request;
  }
  if (defined_default(options.retryCallback)) {
    resource.retryCallback = options.retryCallback;
  }
  if (defined_default(options.retryAttempts)) {
    resource.retryAttempts = options.retryAttempts;
  }
  return resource;
};
Resource.prototype.retryOnError = function(error) {
  const retryCallback2 = this.retryCallback;
  if (typeof retryCallback2 !== "function" || this._retryCount >= this.retryAttempts) {
    return Promise.resolve(false);
  }
  const that = this;
  return Promise.resolve(retryCallback2(this, error)).then(function(result) {
    ++that._retryCount;
    return result;
  });
};
Resource.prototype.clone = function(result) {
  if (!defined_default(result)) {
    return new Resource({
      url: this._url,
      queryParameters: this.queryParameters,
      templateValues: this.templateValues,
      headers: this.headers,
      proxy: this.proxy,
      retryCallback: this.retryCallback,
      retryAttempts: this.retryAttempts,
      request: this.request.clone(),
      parseUrl: false,
      credits: defined_default(this.credits) ? this.credits.slice() : void 0
    });
  }
  result._url = this._url;
  result._queryParameters = clone_default(this._queryParameters);
  result._templateValues = clone_default(this._templateValues);
  result.headers = clone_default(this.headers);
  result.proxy = this.proxy;
  result.retryCallback = this.retryCallback;
  result.retryAttempts = this.retryAttempts;
  result._retryCount = 0;
  result.request = this.request.clone();
  return result;
};
Resource.prototype.getBaseUri = function(includeQuery) {
  return getBaseUri_default(this.getUrlComponent(includeQuery), includeQuery);
};
Resource.prototype.appendForwardSlash = function() {
  this._url = appendForwardSlash_default(this._url);
};
Resource.prototype.fetchArrayBuffer = function() {
  return this.fetch({
    responseType: "arraybuffer"
  });
};
Resource.fetchArrayBuffer = function(options) {
  const resource = new Resource(options);
  return resource.fetchArrayBuffer();
};
Resource.prototype.fetchBlob = function() {
  return this.fetch({
    responseType: "blob"
  });
};
Resource.fetchBlob = function(options) {
  const resource = new Resource(options);
  return resource.fetchBlob();
};
Resource.prototype.fetchImage = function(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  const preferImageBitmap = options.preferImageBitmap ?? false;
  const preferBlob = options.preferBlob ?? false;
  const flipY = options.flipY ?? false;
  const skipColorSpaceConversion = options.skipColorSpaceConversion ?? false;
  checkAndResetRequest(this.request);
  if (!xhrBlobSupported || this.isDataUri || this.isBlobUri || !this.hasHeaders && !preferBlob) {
    return this._fetchImage({
      resource: this,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap
    });
  }
  const blobPromise = this.fetchBlob();
  if (!defined_default(blobPromise)) {
    return;
  }
  let supportsImageBitmap;
  let useImageBitmap;
  let generatedBlobResource;
  let generatedBlob;
  return Resource.supportsImageBitmapOptions().then(function(result) {
    supportsImageBitmap = result;
    useImageBitmap = supportsImageBitmap && preferImageBitmap;
    return blobPromise;
  }).then(function(blob) {
    if (!defined_default(blob)) {
      return;
    }
    generatedBlob = blob;
    if (useImageBitmap) {
      return Resource.createImageBitmapFromBlob(blob, {
        flipY,
        premultiplyAlpha: false,
        skipColorSpaceConversion
      });
    }
    const blobUrl = window.URL.createObjectURL(blob);
    generatedBlobResource = new Resource({
      url: blobUrl
    });
    return generatedBlobResource._fetchImage({
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap: false
    });
  }).then(function(image) {
    if (!defined_default(image)) {
      return;
    }
    image.blob = generatedBlob;
    if (useImageBitmap) {
      return image;
    }
    window.URL.revokeObjectURL(generatedBlobResource.url);
    return image;
  }).catch(function(error) {
    if (defined_default(generatedBlobResource)) {
      window.URL.revokeObjectURL(generatedBlobResource.url);
    }
    error.blob = generatedBlob;
    return Promise.reject(error);
  });
};
Resource.prototype._fetchImage = function(options) {
  const resource = this;
  const flipY = options.flipY;
  const skipColorSpaceConversion = options.skipColorSpaceConversion;
  const preferImageBitmap = options.preferImageBitmap;
  const request = resource.request;
  request.url = resource.url;
  request.requestFunction = function() {
    let crossOrigin = false;
    if (!resource.isDataUri && !resource.isBlobUri) {
      crossOrigin = resource.isCrossOriginUrl;
    }
    const deferred = defer_default();
    Resource._Implementations.createImage(
      request,
      crossOrigin,
      deferred,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap
    );
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.catch(function(e) {
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return resource._fetchImage({
          flipY,
          skipColorSpaceConversion,
          preferImageBitmap
        });
      }
      return Promise.reject(e);
    });
  });
};
Resource.fetchImage = function(options) {
  const resource = new Resource(options);
  return resource.fetchImage({
    flipY: options.flipY,
    skipColorSpaceConversion: options.skipColorSpaceConversion,
    preferBlob: options.preferBlob,
    preferImageBitmap: options.preferImageBitmap
  });
};
Resource.prototype.fetchText = function() {
  return this.fetch({
    responseType: "text"
  });
};
Resource.fetchText = function(options) {
  const resource = new Resource(options);
  return resource.fetchText();
};
Resource.prototype.fetchJson = function() {
  const promise = this.fetch({
    responseType: "text",
    headers: {
      Accept: "application/json,*/*;q=0.01"
    }
  });
  if (!defined_default(promise)) {
    return void 0;
  }
  return promise.then(function(value) {
    if (!defined_default(value)) {
      return;
    }
    return JSON.parse(value);
  });
};
Resource.fetchJson = function(options) {
  const resource = new Resource(options);
  return resource.fetchJson();
};
Resource.prototype.fetchXML = function() {
  return this.fetch({
    responseType: "document",
    overrideMimeType: "text/xml"
  });
};
Resource.fetchXML = function(options) {
  const resource = new Resource(options);
  return resource.fetchXML();
};
Resource.prototype.fetchJsonp = function(callbackParameterName) {
  callbackParameterName = callbackParameterName ?? "callback";
  checkAndResetRequest(this.request);
  let functionName;
  do {
    functionName = `loadJsonp${Math_default.nextRandomNumber().toString().substring(2, 8)}`;
  } while (defined_default(window[functionName]));
  return fetchJsonp(this, callbackParameterName, functionName);
};
function fetchJsonp(resource, callbackParameterName, functionName) {
  const callbackQuery = {};
  callbackQuery[callbackParameterName] = functionName;
  resource.setQueryParameters(callbackQuery);
  const request = resource.request;
  const url2 = resource.url;
  request.url = url2;
  request.requestFunction = function() {
    const deferred = defer_default();
    window[functionName] = function(data) {
      deferred.resolve(data);
      try {
        delete window[functionName];
      } catch (e) {
        window[functionName] = void 0;
      }
    };
    Resource._Implementations.loadAndExecuteScript(url2, functionName, deferred);
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.catch(function(e) {
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return fetchJsonp(resource, callbackParameterName, functionName);
      }
      return Promise.reject(e);
    });
  });
}
Resource.fetchJsonp = function(options) {
  const resource = new Resource(options);
  return resource.fetchJsonp(options.callbackParameterName);
};
Resource.prototype._makeRequest = function(options) {
  const resource = this;
  checkAndResetRequest(resource.request);
  const request = resource.request;
  const url2 = resource.url;
  request.url = url2;
  request.requestFunction = function() {
    const responseType = options.responseType;
    const headers = combine_default(options.headers, resource.headers);
    const overrideMimeType = options.overrideMimeType;
    const method = options.method;
    const data = options.data;
    const deferred = defer_default();
    const xhr = Resource._Implementations.loadWithXhr(
      url2,
      responseType,
      method,
      data,
      headers,
      deferred,
      overrideMimeType
    );
    if (defined_default(xhr) && defined_default(xhr.abort)) {
      request.cancelFunction = function() {
        xhr.abort();
      };
    }
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.then(function(data) {
    request.cancelFunction = void 0;
    return data;
  }).catch(function(e) {
    request.cancelFunction = void 0;
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return resource.fetch(options);
      }
      return Promise.reject(e);
    });
  });
};
function checkAndResetRequest(request) {
  if (request.state === RequestState_default.ISSUED || request.state === RequestState_default.ACTIVE) {
    throw new RuntimeError_default("The Resource is already being fetched.");
  }
  request.state = RequestState_default.UNISSUED;
  request.deferred = void 0;
}
var dataUriRegex2 = /^data:(.*?)(;base64)?,(.*)$/;
function decodeDataUriText(isBase64, data) {
  const result = decodeURIComponent(data);
  if (isBase64) {
    return atob(result);
  }
  return result;
}
function decodeDataUriArrayBuffer(isBase64, data) {
  const byteString = decodeDataUriText(isBase64, data);
  const buffer2 = new ArrayBuffer(byteString.length);
  const view = new Uint8Array(buffer2);
  for (let i = 0; i < byteString.length; i++) {
    view[i] = byteString.charCodeAt(i);
  }
  return buffer2;
}
function decodeDataUri(dataUriRegexResult, responseType) {
  responseType = responseType ?? "";
  const mimeType = dataUriRegexResult[1];
  const isBase64 = !!dataUriRegexResult[2];
  const data = dataUriRegexResult[3];
  let buffer2;
  let parser3;
  switch (responseType) {
    case "":
    case "text":
      return decodeDataUriText(isBase64, data);
    case "arraybuffer":
      return decodeDataUriArrayBuffer(isBase64, data);
    case "blob":
      buffer2 = decodeDataUriArrayBuffer(isBase64, data);
      return new Blob([buffer2], {
        type: mimeType
      });
    case "document":
      parser3 = new DOMParser();
      return parser3.parseFromString(
        decodeDataUriText(isBase64, data),
        mimeType
      );
    case "json":
      return JSON.parse(decodeDataUriText(isBase64, data));
    default:
      throw new DeveloperError_default(`Unhandled responseType: ${responseType}`);
  }
}
Resource.prototype.fetch = function(options) {
  options = defaultClone(options, {});
  options.method = "GET";
  return this._makeRequest(options);
};
Resource.fetch = function(options) {
  const resource = new Resource(options);
  return resource.fetch({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.delete = function(options) {
  options = defaultClone(options, {});
  options.method = "DELETE";
  return this._makeRequest(options);
};
Resource.delete = function(options) {
  const resource = new Resource(options);
  return resource.delete({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType,
    data: options.data
  });
};
Resource.prototype.head = function(options) {
  options = defaultClone(options, {});
  options.method = "HEAD";
  return this._makeRequest(options);
};
Resource.head = function(options) {
  const resource = new Resource(options);
  return resource.head({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.options = function(options) {
  options = defaultClone(options, {});
  options.method = "OPTIONS";
  return this._makeRequest(options);
};
Resource.options = function(options) {
  const resource = new Resource(options);
  return resource.options({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.post = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "POST";
  options.data = data;
  return this._makeRequest(options);
};
Resource.post = function(options) {
  const resource = new Resource(options);
  return resource.post(options.data, {
    // Make copy of just the needed fields because headers can be passed to both the constructor and to post
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.put = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "PUT";
  options.data = data;
  return this._makeRequest(options);
};
Resource.put = function(options) {
  const resource = new Resource(options);
  return resource.put(options.data, {
    // Make copy of just the needed fields because headers can be passed to both the constructor and to post
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.patch = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "PATCH";
  options.data = data;
  return this._makeRequest(options);
};
Resource.patch = function(options) {
  const resource = new Resource(options);
  return resource.patch(options.data, {
    // Make copy of just the needed fields because headers can be passed to both the constructor and to post
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource._Implementations = {};
Resource._Implementations.loadImageElement = function(url2, crossOrigin, deferred) {
  const image = new Image();
  image.onload = function() {
    if (image.naturalWidth === 0 && image.naturalHeight === 0 && image.width === 0 && image.height === 0) {
      image.width = 300;
      image.height = 150;
    }
    deferred.resolve(image);
  };
  image.onerror = function(e) {
    deferred.reject(e);
  };
  if (crossOrigin) {
    if (TrustedServers_default.contains(url2)) {
      image.crossOrigin = "use-credentials";
    } else {
      image.crossOrigin = "";
    }
  }
  image.src = url2;
};
Resource._Implementations.createImage = function(request, crossOrigin, deferred, flipY, skipColorSpaceConversion, preferImageBitmap, headers) {
  const url2 = request.url;
  Resource.supportsImageBitmapOptions().then(function(supportsImageBitmap) {
    if (!(supportsImageBitmap && preferImageBitmap)) {
      Resource._Implementations.loadImageElement(url2, crossOrigin, deferred);
      return;
    }
    const responseType = "blob";
    const method = "GET";
    const xhrDeferred = defer_default();
    const xhr = Resource._Implementations.loadWithXhr(
      url2,
      responseType,
      method,
      void 0,
      headers,
      xhrDeferred,
      void 0,
      void 0,
      void 0
    );
    if (defined_default(xhr) && defined_default(xhr.abort)) {
      request.cancelFunction = function() {
        xhr.abort();
      };
    }
    return xhrDeferred.promise.then(function(blob) {
      if (!defined_default(blob)) {
        deferred.reject(
          new RuntimeError_default(
            `Successfully retrieved ${url2} but it contained no content.`
          )
        );
        return;
      }
      return Resource.createImageBitmapFromBlob(blob, {
        flipY,
        premultiplyAlpha: false,
        skipColorSpaceConversion
      });
    }).then(function(image) {
      deferred.resolve(image);
    });
  }).catch(function(e) {
    deferred.reject(e);
  });
};
Resource.createImageBitmapFromBlob = function(blob, options) {
  Check_default.defined("options", options);
  Check_default.typeOf.bool("options.flipY", options.flipY);
  Check_default.typeOf.bool("options.premultiplyAlpha", options.premultiplyAlpha);
  Check_default.typeOf.bool(
    "options.skipColorSpaceConversion",
    options.skipColorSpaceConversion
  );
  return createImageBitmap(blob, {
    // 'from-image' is deprecated, new option is 'none'. However, we still need to support older browsers,
    // and there's no good way to detect support for these options. For now, continue to use 'from-image'. See: https://github.com/CesiumGS/cesium/issues/12846
    imageOrientation: options.flipY ? "flipY" : "none",
    premultiplyAlpha: options.premultiplyAlpha ? "premultiply" : "none",
    colorSpaceConversion: options.skipColorSpaceConversion ? "none" : "default"
  });
};
function loadWithHttpRequest(url2, responseType, method, data, headers, deferred, overrideMimeType) {
  fetch(url2, {
    method,
    headers
  }).then(async (response) => {
    if (!response.ok) {
      const responseHeaders = {};
      response.headers.forEach((value, key) => {
        responseHeaders[key] = value;
      });
      deferred.reject(
        new RequestErrorEvent_default(response.status, response, responseHeaders)
      );
      return;
    }
    switch (responseType) {
      case "text":
        deferred.resolve(response.text());
        break;
      case "json":
        deferred.resolve(response.json());
        break;
      default:
        deferred.resolve(new Uint8Array(await response.arrayBuffer()).buffer);
        break;
    }
  }).catch(() => {
    deferred.reject(new RequestErrorEvent_default());
  });
}
var noXMLHttpRequest = typeof XMLHttpRequest === "undefined";
Resource._Implementations.loadWithXhr = function(url2, responseType, method, data, headers, deferred, overrideMimeType) {
  const dataUriRegexResult = dataUriRegex2.exec(url2);
  if (dataUriRegexResult !== null) {
    deferred.resolve(decodeDataUri(dataUriRegexResult, responseType));
    return;
  }
  if (noXMLHttpRequest) {
    loadWithHttpRequest(
      url2,
      responseType,
      method,
      data,
      headers,
      deferred,
      overrideMimeType
    );
    return;
  }
  const xhr = new XMLHttpRequest();
  if (TrustedServers_default.contains(url2)) {
    xhr.withCredentials = true;
  }
  xhr.open(method, url2, true);
  if (defined_default(overrideMimeType) && defined_default(xhr.overrideMimeType)) {
    xhr.overrideMimeType(overrideMimeType);
  }
  if (defined_default(headers)) {
    for (const key in headers) {
      if (headers.hasOwnProperty(key)) {
        xhr.setRequestHeader(key, headers[key]);
      }
    }
  }
  if (defined_default(responseType)) {
    xhr.responseType = responseType;
  }
  let localFile = false;
  if (typeof url2 === "string") {
    localFile = url2.indexOf("file://") === 0 || typeof window !== "undefined" && window.location.origin === "file://";
  }
  xhr.onload = function() {
    if ((xhr.status < 200 || xhr.status >= 300) && !(localFile && xhr.status === 0)) {
      deferred.reject(
        new RequestErrorEvent_default(
          xhr.status,
          xhr.response,
          xhr.getAllResponseHeaders()
        )
      );
      return;
    }
    const response = xhr.response;
    const browserResponseType = xhr.responseType;
    if (method === "HEAD" || method === "OPTIONS") {
      const responseHeaderString = xhr.getAllResponseHeaders();
      const splitHeaders = responseHeaderString.trim().split(/[\r\n]+/);
      const responseHeaders = {};
      splitHeaders.forEach(function(line) {
        const parts = line.split(": ");
        const header = parts.shift();
        responseHeaders[header] = parts.join(": ");
      });
      deferred.resolve(responseHeaders);
      return;
    }
    if (xhr.status === 204) {
      deferred.resolve(void 0);
    } else if (defined_default(response) && (!defined_default(responseType) || browserResponseType === responseType)) {
      deferred.resolve(response);
    } else if (responseType === "json" && typeof response === "string") {
      try {
        deferred.resolve(JSON.parse(response));
      } catch (e) {
        deferred.reject(e);
      }
    } else if ((browserResponseType === "" || browserResponseType === "document") && defined_default(xhr.responseXML) && xhr.responseXML.hasChildNodes()) {
      deferred.resolve(xhr.responseXML);
    } else if ((browserResponseType === "" || browserResponseType === "text") && defined_default(xhr.responseText)) {
      deferred.resolve(xhr.responseText);
    } else {
      deferred.reject(
        new RuntimeError_default("Invalid XMLHttpRequest response type.")
      );
    }
  };
  xhr.onerror = function(e) {
    deferred.reject(new RequestErrorEvent_default());
  };
  xhr.send(data);
  return xhr;
};
Resource._Implementations.loadAndExecuteScript = function(url2, functionName, deferred) {
  return loadAndExecuteScript_default(url2, functionName).catch(function(e) {
    deferred.reject(e);
  });
};
Resource._DefaultImplementations = {};
Resource._DefaultImplementations.createImage = Resource._Implementations.createImage;
Resource._DefaultImplementations.loadWithXhr = Resource._Implementations.loadWithXhr;
Resource._DefaultImplementations.loadAndExecuteScript = Resource._Implementations.loadAndExecuteScript;
Resource.DEFAULT = Object.freeze(
  new Resource({
    url: typeof document === "undefined" ? "" : document.location.href.split("?")[0]
  })
);
var Resource_default = Resource;

// packages/engine/Source/Core/EarthOrientationParameters.js
function EarthOrientationParameters(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  this._dates = void 0;
  this._samples = void 0;
  this._dateColumn = -1;
  this._xPoleWanderRadiansColumn = -1;
  this._yPoleWanderRadiansColumn = -1;
  this._ut1MinusUtcSecondsColumn = -1;
  this._xCelestialPoleOffsetRadiansColumn = -1;
  this._yCelestialPoleOffsetRadiansColumn = -1;
  this._taiMinusUtcSecondsColumn = -1;
  this._columnCount = 0;
  this._lastIndex = -1;
  this._addNewLeapSeconds = options.addNewLeapSeconds ?? true;
  if (defined_default(options.data)) {
    onDataReady(this, options.data);
  } else {
    onDataReady(this, {
      columnNames: [
        "dateIso8601",
        "modifiedJulianDateUtc",
        "xPoleWanderRadians",
        "yPoleWanderRadians",
        "ut1MinusUtcSeconds",
        "lengthOfDayCorrectionSeconds",
        "xCelestialPoleOffsetRadians",
        "yCelestialPoleOffsetRadians",
        "taiMinusUtcSeconds"
      ],
      samples: []
    });
  }
}
EarthOrientationParameters.fromUrl = async function(url2, options) {
  Check_default.defined("url", url2);
  options = options ?? Frozen_default.EMPTY_OBJECT;
  const resource = Resource_default.createIfNeeded(url2);
  let eopData;
  try {
    eopData = await resource.fetchJson();
  } catch (e) {
    throw new RuntimeError_default(
      `An error occurred while retrieving the EOP data from the URL ${resource.url}.`
    );
  }
  return new EarthOrientationParameters({
    addNewLeapSeconds: options.addNewLeapSeconds,
    data: eopData
  });
};
EarthOrientationParameters.NONE = Object.freeze({
  compute: function(date, result) {
    if (!defined_default(result)) {
      result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
    } else {
      result.xPoleWander = 0;
      result.yPoleWander = 0;
      result.xPoleOffset = 0;
      result.yPoleOffset = 0;
      result.ut1MinusUtc = 0;
    }
    return result;
  }
});
EarthOrientationParameters.prototype.compute = function(date, result) {
  if (!defined_default(this._samples)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
  }
  if (this._samples.length === 0) {
    result.xPoleWander = 0;
    result.yPoleWander = 0;
    result.xPoleOffset = 0;
    result.yPoleOffset = 0;
    result.ut1MinusUtc = 0;
    return result;
  }
  const dates = this._dates;
  const lastIndex = this._lastIndex;
  let before = 0;
  let after = 0;
  if (defined_default(lastIndex)) {
    const previousIndexDate = dates[lastIndex];
    const nextIndexDate = dates[lastIndex + 1];
    const isAfterPrevious = JulianDate_default.lessThanOrEquals(
      previousIndexDate,
      date
    );
    const isAfterLastSample = !defined_default(nextIndexDate);
    const isBeforeNext = isAfterLastSample || JulianDate_default.greaterThanOrEquals(nextIndexDate, date);
    if (isAfterPrevious && isBeforeNext) {
      before = lastIndex;
      if (!isAfterLastSample && nextIndexDate.equals(date)) {
        ++before;
      }
      after = before + 1;
      interpolate(this, dates, this._samples, date, before, after, result);
      return result;
    }
  }
  let index = binarySearch_default(dates, date, JulianDate_default.compare, this._dateColumn);
  if (index >= 0) {
    if (index < dates.length - 1 && dates[index + 1].equals(date)) {
      ++index;
    }
    before = index;
    after = index;
  } else {
    after = ~index;
    before = after - 1;
    if (before < 0) {
      before = 0;
    }
  }
  this._lastIndex = before;
  interpolate(this, dates, this._samples, date, before, after, result);
  return result;
};
function compareLeapSecondDates2(leapSecond, dateToFind) {
  return JulianDate_default.compare(leapSecond.julianDate, dateToFind);
}
function onDataReady(eop, eopData) {
  if (!defined_default(eopData.columnNames)) {
    throw new RuntimeError_default(
      "Error in loaded EOP data: The columnNames property is required."
    );
  }
  if (!defined_default(eopData.samples)) {
    throw new RuntimeError_default(
      "Error in loaded EOP data: The samples property is required."
    );
  }
  const dateColumn = eopData.columnNames.indexOf("modifiedJulianDateUtc");
  const xPoleWanderRadiansColumn = eopData.columnNames.indexOf("xPoleWanderRadians");
  const yPoleWanderRadiansColumn = eopData.columnNames.indexOf("yPoleWanderRadians");
  const ut1MinusUtcSecondsColumn = eopData.columnNames.indexOf("ut1MinusUtcSeconds");
  const xCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
    "xCelestialPoleOffsetRadians"
  );
  const yCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
    "yCelestialPoleOffsetRadians"
  );
  const taiMinusUtcSecondsColumn = eopData.columnNames.indexOf("taiMinusUtcSeconds");
  if (dateColumn < 0 || xPoleWanderRadiansColumn < 0 || yPoleWanderRadiansColumn < 0 || ut1MinusUtcSecondsColumn < 0 || xCelestialPoleOffsetRadiansColumn < 0 || yCelestialPoleOffsetRadiansColumn < 0 || taiMinusUtcSecondsColumn < 0) {
    throw new RuntimeError_default(
      "Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns"
    );
  }
  const samples = eop._samples = eopData.samples;
  const dates = eop._dates = [];
  eop._dateColumn = dateColumn;
  eop._xPoleWanderRadiansColumn = xPoleWanderRadiansColumn;
  eop._yPoleWanderRadiansColumn = yPoleWanderRadiansColumn;
  eop._ut1MinusUtcSecondsColumn = ut1MinusUtcSecondsColumn;
  eop._xCelestialPoleOffsetRadiansColumn = xCelestialPoleOffsetRadiansColumn;
  eop._yCelestialPoleOffsetRadiansColumn = yCelestialPoleOffsetRadiansColumn;
  eop._taiMinusUtcSecondsColumn = taiMinusUtcSecondsColumn;
  eop._columnCount = eopData.columnNames.length;
  eop._lastIndex = void 0;
  let lastTaiMinusUtc;
  const addNewLeapSeconds = eop._addNewLeapSeconds;
  for (let i = 0, len = samples.length; i < len; i += eop._columnCount) {
    const mjd = samples[i + dateColumn];
    const taiMinusUtc = samples[i + taiMinusUtcSecondsColumn];
    const day = mjd + TimeConstants_default.MODIFIED_JULIAN_DATE_DIFFERENCE;
    const date = new JulianDate_default(day, taiMinusUtc, TimeStandard_default.TAI);
    dates.push(date);
    if (addNewLeapSeconds) {
      if (taiMinusUtc !== lastTaiMinusUtc && defined_default(lastTaiMinusUtc)) {
        const leapSeconds = JulianDate_default.leapSeconds;
        const leapSecondIndex = binarySearch_default(
          leapSeconds,
          date,
          compareLeapSecondDates2
        );
        if (leapSecondIndex < 0) {
          const leapSecond = new LeapSecond_default(date, taiMinusUtc);
          leapSeconds.splice(~leapSecondIndex, 0, leapSecond);
        }
      }
      lastTaiMinusUtc = taiMinusUtc;
    }
  }
}
function fillResultFromIndex(eop, samples, index, columnCount, result) {
  const start = index * columnCount;
  result.xPoleWander = samples[start + eop._xPoleWanderRadiansColumn];
  result.yPoleWander = samples[start + eop._yPoleWanderRadiansColumn];
  result.xPoleOffset = samples[start + eop._xCelestialPoleOffsetRadiansColumn];
  result.yPoleOffset = samples[start + eop._yCelestialPoleOffsetRadiansColumn];
  result.ut1MinusUtc = samples[start + eop._ut1MinusUtcSecondsColumn];
}
function linearInterp(dx, y1, y2) {
  return y1 + dx * (y2 - y1);
}
function interpolate(eop, dates, samples, date, before, after, result) {
  const columnCount = eop._columnCount;
  if (after > dates.length - 1) {
    result.xPoleWander = 0;
    result.yPoleWander = 0;
    result.xPoleOffset = 0;
    result.yPoleOffset = 0;
    result.ut1MinusUtc = 0;
    return result;
  }
  const beforeDate = dates[before];
  const afterDate = dates[after];
  if (beforeDate.equals(afterDate) || date.equals(beforeDate)) {
    fillResultFromIndex(eop, samples, before, columnCount, result);
    return result;
  } else if (date.equals(afterDate)) {
    fillResultFromIndex(eop, samples, after, columnCount, result);
    return result;
  }
  const factor2 = JulianDate_default.secondsDifference(date, beforeDate) / JulianDate_default.secondsDifference(afterDate, beforeDate);
  const startBefore = before * columnCount;
  const startAfter = after * columnCount;
  let beforeUt1MinusUtc = samples[startBefore + eop._ut1MinusUtcSecondsColumn];
  let afterUt1MinusUtc = samples[startAfter + eop._ut1MinusUtcSecondsColumn];
  const offsetDifference = afterUt1MinusUtc - beforeUt1MinusUtc;
  if (offsetDifference > 0.5 || offsetDifference < -0.5) {
    const beforeTaiMinusUtc = samples[startBefore + eop._taiMinusUtcSecondsColumn];
    const afterTaiMinusUtc = samples[startAfter + eop._taiMinusUtcSecondsColumn];
    if (beforeTaiMinusUtc !== afterTaiMinusUtc) {
      if (afterDate.equals(date)) {
        beforeUt1MinusUtc = afterUt1MinusUtc;
      } else {
        afterUt1MinusUtc -= afterTaiMinusUtc - beforeTaiMinusUtc;
      }
    }
  }
  result.xPoleWander = linearInterp(
    factor2,
    samples[startBefore + eop._xPoleWanderRadiansColumn],
    samples[startAfter + eop._xPoleWanderRadiansColumn]
  );
  result.yPoleWander = linearInterp(
    factor2,
    samples[startBefore + eop._yPoleWanderRadiansColumn],
    samples[startAfter + eop._yPoleWanderRadiansColumn]
  );
  result.xPoleOffset = linearInterp(
    factor2,
    samples[startBefore + eop._xCelestialPoleOffsetRadiansColumn],
    samples[startAfter + eop._xCelestialPoleOffsetRadiansColumn]
  );
  result.yPoleOffset = linearInterp(
    factor2,
    samples[startBefore + eop._yCelestialPoleOffsetRadiansColumn],
    samples[startAfter + eop._yCelestialPoleOffsetRadiansColumn]
  );
  result.ut1MinusUtc = linearInterp(
    factor2,
    beforeUt1MinusUtc,
    afterUt1MinusUtc
  );
  return result;
}
var EarthOrientationParameters_default = EarthOrientationParameters;

// packages/engine/Source/Core/HeadingPitchRoll.js
function HeadingPitchRoll(heading, pitch, roll) {
  this.heading = heading ?? 0;
  this.pitch = pitch ?? 0;
  this.roll = roll ?? 0;
}
HeadingPitchRoll.fromQuaternion = function(quaternion, result) {
  if (!defined_default(quaternion)) {
    throw new DeveloperError_default("quaternion is required");
  }
  if (!defined_default(result)) {
    result = new HeadingPitchRoll();
  }
  const test = 2 * (quaternion.w * quaternion.y - quaternion.z * quaternion.x);
  const denominatorRoll = 1 - 2 * (quaternion.x * quaternion.x + quaternion.y * quaternion.y);
  const numeratorRoll = 2 * (quaternion.w * quaternion.x + quaternion.y * quaternion.z);
  const denominatorHeading = 1 - 2 * (quaternion.y * quaternion.y + quaternion.z * quaternion.z);
  const numeratorHeading = 2 * (quaternion.w * quaternion.z + quaternion.x * quaternion.y);
  result.heading = -Math.atan2(numeratorHeading, denominatorHeading);
  result.roll = Math.atan2(numeratorRoll, denominatorRoll);
  result.pitch = -Math_default.asinClamped(test);
  return result;
};
HeadingPitchRoll.fromDegrees = function(heading, pitch, roll, result) {
  if (!defined_default(heading)) {
    throw new DeveloperError_default("heading is required");
  }
  if (!defined_default(pitch)) {
    throw new DeveloperError_default("pitch is required");
  }
  if (!defined_default(roll)) {
    throw new DeveloperError_default("roll is required");
  }
  if (!defined_default(result)) {
    result = new HeadingPitchRoll();
  }
  result.heading = heading * Math_default.RADIANS_PER_DEGREE;
  result.pitch = pitch * Math_default.RADIANS_PER_DEGREE;
  result.roll = roll * Math_default.RADIANS_PER_DEGREE;
  return result;
};
HeadingPitchRoll.clone = function(headingPitchRoll, result) {
  if (!defined_default(headingPitchRoll)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new HeadingPitchRoll(
      headingPitchRoll.heading,
      headingPitchRoll.pitch,
      headingPitchRoll.roll
    );
  }
  result.heading = headingPitchRoll.heading;
  result.pitch = headingPitchRoll.pitch;
  result.roll = headingPitchRoll.roll;
  return result;
};
HeadingPitchRoll.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.heading === right.heading && left.pitch === right.pitch && left.roll === right.roll;
};
HeadingPitchRoll.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.heading,
    right.heading,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.pitch,
    right.pitch,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.roll,
    right.roll,
    relativeEpsilon,
    absoluteEpsilon
  );
};
HeadingPitchRoll.prototype.clone = fu