/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.138.0
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

import{b as U}from"./chunk-OXROQHTA.js";import{a as ft}from"./chunk-WV2SHQ7E.js";import{a as i,b}from"./chunk-TODZU3UG.js";import{a as y}from"./chunk-3XRQCEHV.js";import{a as w,b as tt}from"./chunk-VIWNLE3Z.js";import{e as g}from"./chunk-4TAASUQ2.js";var nt={};nt.computeDiscriminant=function(t,n,r){if(typeof t!="number")throw new w("a is a required number.");if(typeof n!="number")throw new w("b is a required number.");if(typeof r!="number")throw new w("c is a required number.");return n*n-4*t*r};function mt(t,n,r){let e=t+n;return y.sign(t)!==y.sign(n)&&Math.abs(e/Math.max(Math.abs(t),Math.abs(n)))<r?0:e}nt.computeRealRoots=function(t,n,r){if(typeof t!="number")throw new w("a is a required number.");if(typeof n!="number")throw new w("b is a required number.");if(typeof r!="number")throw new w("c is a required number.");let e;if(t===0)return n===0?[]:[-r/n];if(n===0){if(r===0)return[0,0];let u=Math.abs(r),f=Math.abs(t);if(u<f&&u/f<y.EPSILON14)return[0,0];if(u>f&&f/u<y.EPSILON14)return[];if(e=-r/t,e<0)return[];let h=Math.sqrt(e);return[-h,h]}else if(r===0)return e=-n/t,e<0?[e,0]:[0,e];let o=n*n,s=4*t*r,c=mt(o,-s,y.EPSILON14);if(c<0)return[];let a=-.5*mt(n,y.sign(n)*Math.sqrt(c),y.EPSILON14);return n>0?[a/t,r/a]:[r/a,a/t]};var z=nt;var rt={};rt.computeDiscriminant=function(t,n,r,e){if(typeof t!="number")throw new w("a is a required number.");if(typeof n!="number")throw new w("b is a required number.");if(typeof r!="number")throw new w("c is a required number.");if(typeof e!="number")throw new w("d is a required number.");let o=t*t,s=n*n,c=r*r,a=e*e;return 18*t*n*r*e+s*c-27*o*a-4*(t*c*r+s*n*e)};function et(t,n,r,e){let o=t,s=n/3,c=r/3,a=e,u=o*c,f=s*a,h=s*s,d=c*c,p=o*c-h,q=o*a-s*c,m=s*a-d,l=4*p*m-q*q,E,x;if(l<0){let J,k,G;h*f>=u*d?(J=o,k=p,G=-2*s*p+o*q):(J=a,k=m,G=-a*q+2*c*m);let ut=-(G<0?-1:1)*Math.abs(J)*Math.sqrt(-l);x=-G+ut;let K=x/2,Y=K<0?-Math.pow(-K,1/3):Math.pow(K,1/3),$=x===ut?-Y:-k/Y;return E=k<=0?Y+$:-G/(Y*Y+$*$+k),h*f>=u*d?[(E-s)/o]:[-a/(E+c)]}let v=p,W=-2*s*p+o*q,L=m,B=-a*q+2*c*m,I=Math.sqrt(l),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*I,-W)/3);E=2*Math.sqrt(-v);let R=Math.cos(P);x=E*R;let S=E*(-R/2-C*Math.sin(P)),M=x+S>2*s?x-s:S-s,N=o,D=M/N;P=Math.abs(Math.atan2(a*I,-B)/3),E=2*Math.sqrt(-L),R=Math.cos(P),x=E*R,S=E*(-R/2-C*Math.sin(P));let _=-a,Z=x+S<2*c?x+c:S+c,A=_/Z,Rt=N*Z,at=-M*Z-N*_,bt=M*_,V=(c*at-s*bt)/(-s*at+c*Rt);return D<=V?D<=A?V<=A?[D,V,A]:[D,A,V]:[A,D,V]:D<=A?[V,D,A]:V<=A?[V,A,D]:[A,V,D]}rt.computeRealRoots=function(t,n,r,e){if(typeof t!="number")throw new w("a is a required number.");if(typeof n!="number")throw new w("b is a required number.");if(typeof r!="number")throw new w("c is a required number.");if(typeof e!="number")throw new w("d is a required number.");let o,s;if(t===0)return z.computeRealRoots(n,r,e);if(n===0){if(r===0){if(e===0)return[0,0,0];s=-e/t;let c=s<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}else if(e===0)return o=z.computeRealRoots(t,0,r),o.Length===0?[0]:[o[0],0,o[1]];return et(t,0,r,e)}else{if(r===0)return e===0?(s=-n/t,s<0?[s,0,0]:[0,0,s]):et(t,n,0,e);if(e===0)return o=z.computeRealRoots(t,n,r),o.length===0?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]}return et(t,n,r,e)};var H=rt;var ot={};ot.computeDiscriminant=function(t,n,r,e,o){if(typeof t!="number")throw new w("a is a required number.");if(typeof n!="number")throw new w("b is a required number.");if(typeof r!="number")throw new w("c is a required number.");if(typeof e!="number")throw new w("d is a required number.");if(typeof o!="number")throw new w("e is a required number.");let s=t*t,c=s*t,a=n*n,u=a*n,f=r*r,h=f*r,d=e*e,p=d*e,q=o*o,m=q*o;return a*f*d-4*u*p-4*t*h*d+18*t*n*r*p-27*s*d*d+256*c*m+o*(18*u*r*e-4*a*h+16*t*f*f-80*t*n*f*e-6*t*a*d+144*s*r*d)+q*(144*t*a*r-27*a*a-128*s*f-192*s*n*e)};function T(t,n,r,e){let o=t*t,s=n-3*o/8,c=r-n*t/2+o*t/8,a=e-r*t/4+n*o/16-3*o*o/256,u=H.computeRealRoots(1,2*s,s*s-4*a,-c*c);if(u.length>0){let f=-t/4,h=u[u.length-1];if(Math.abs(h)<y.EPSILON14){let d=z.computeRealRoots(1,s,a);if(d.length===2){let p=d[0],q=d[1],m;if(p>=0&&q>=0){let l=Math.sqrt(p),E=Math.sqrt(q);return[f-E,f-l,f+l,f+E]}else{if(p>=0&&q<0)return m=Math.sqrt(p),[f-m,f+m];if(p<0&&q>=0)return m=Math.sqrt(q),[f-m,f+m]}}return[]}else if(h>0){let d=Math.sqrt(h),p=(s+h-c/d)/2,q=(s+h+c/d)/2,m=z.computeRealRoots(1,d,p),l=z.computeRealRoots(1,-d,q);return m.length!==0?(m[0]+=f,m[1]+=f,l.length!==0?(l[0]+=f,l[1]+=f,m[1]<=l[0]?[m[0],m[1],l[0],l[1]]:l[1]<=m[0]?[l[0],l[1],m[0],m[1]]:m[0]>=l[0]&&m[1]<=l[1]?[l[0],m[0],m[1],l[1]]:l[0]>=m[0]&&l[1]<=m[1]?[m[0],l[0],l[1],m[1]]:m[0]>l[0]&&m[0]<l[1]?[l[0],m[0],l[1],m[1]]:[m[0],l[0],m[1],l[1]]):m):l.length!==0?(l[0]+=f,l[1]+=f,l):[]}}return[]}function j(t,n,r,e){let o=r*r,s=n*n,c=t*t,a=-2*n,u=r*t+s-4*e,f=c*e-r*n*t+o,h=H.computeRealRoots(1,a,u,f);if(h.length>0){let d=h[0],p=n-d,q=p*p,m=t/2,l=p/2,E=q-4*e,x=q+4*Math.abs(e),v=c-4*d,W=c+4*Math.abs(d),L,B;if(d<0||E*W<v*x){let N=Math.sqrt(v);L=N/2,B=N===0?0:(t*l-r)/N}else{let N=Math.sqrt(E);L=N===0?0:(t*l-r)/N,B=N/2}let I,C;m===0&&L===0?(I=0,C=0):y.sign(m)===y.sign(L)?(I=m+L,C=d/I):(C=m-L,I=d/C);let P,R;l===0&&B===0?(P=0,R=0):y.sign(l)===y.sign(B)?(P=l+B,R=e/P):(R=l-B,P=e/R);let S=z.computeRealRoots(1,I,P),M=z.computeRealRoots(1,C,R);if(S.length!==0)return M.length!==0?S[1]<=M[0]?[S[0],S[1],M[0],M[1]]:M[1]<=S[0]?[M[0],M[1],S[0],S[1]]:S[0]>=M[0]&&S[1]<=M[1]?[M[0],S[0],S[1],M[1]]:M[0]>=S[0]&&M[1]<=S[1]?[S[0],M[0],M[1],S[1]]:S[0]>M[0]&&S[0]<M[1]?[M[0],S[0],M[1],S[1]]:[S[0],M[0],S[1],M[1]]:S;if(M.length!==0)return M}return[]}ot.computeRealRoots=function(t,n,r,e,o){if(typeof t!="number")throw new w("a is a required number.");if(typeof n!="number")throw new w("b is a required number.");if(typeof r!="number")throw new w("c is a required number.");if(typeof e!="number")throw new w("d is a required number.");if(typeof o!="number")throw new w("e is a required number.");if(Math.abs(t)<y.EPSILON15)return H.computeRealRoots(n,r,e,o);let s=n/t,c=r/t,a=e/t,u=o/t,f=s<0?1:0;switch(f+=c<0?f+1:f,f+=a<0?f+1:f,f+=u<0?f+1:f,f){case 0:return T(s,c,a,u);case 1:return j(s,c,a,u);case 2:return j(s,c,a,u);case 3:return T(s,c,a,u);case 4:return T(s,c,a,u);case 5:return j(s,c,a,u);case 6:return T(s,c,a,u);case 7:return T(s,c,a,u);case 8:return j(s,c,a,u);case 9:return T(s,c,a,u);case 10:return T(s,c,a,u);case 11:return j(s,c,a,u);case 12:return T(s,c,a,u);case 13:return T(s,c,a,u);case 14:return T(s,c,a,u);case 15:return T(s,c,a,u);default:return}};var dt=ot;function X(t,n){n=i.clone(n??i.ZERO),i.equals(n,i.ZERO)||i.normalize(n,n),this.origin=i.clone(t??i.ZERO),this.direction=n}X.clone=function(t,n){if(g(t))return g(n)?(n.origin=i.clone(t.origin),n.direction=i.clone(t.direction),n):new X(t.origin,t.direction)};X.getPoint=function(t,n,r){return tt.typeOf.object("ray",t),tt.typeOf.number("t",n),g(r)||(r=new i),r=i.multiplyByScalar(t.direction,n,r),i.add(t.origin,r,r)};var it=X;var O={};O.rayPlane=function(t,n,r){if(!g(t))throw new w("ray is required.");if(!g(n))throw new w("plane is required.");g(r)||(r=new i);let e=t.origin,o=t.direction,s=n.normal,c=i.dot(s,o);if(Math.abs(c)<y.EPSILON15)return;let a=(-n.distance-i.dot(s,e))/c;if(!(a<0))return r=i.multiplyByScalar(o,a,r),i.add(e,r,r)};var Ot=new i,Pt=new i,Mt=new i,ht=new i,lt=new i;O.rayTriangleParametric=function(t,n,r,e,o){if(!g(t))throw new w("ray is required.");if(!g(n))throw new w("p0 is required.");if(!g(r))throw new w("p1 is required.");if(!g(e))throw new w("p2 is required.");o=o??!1;let s=t.origin,c=t.direction,a=i.subtract(r,n,Ot),u=i.subtract(e,n,Pt),f=i.cross(c,u,Mt),h=i.dot(a,f),d,p,q,m,l;if(o){if(h<y.EPSILON6||(d=i.subtract(s,n,ht),q=i.dot(d,f),q<0||q>h)||(p=i.cross(d,a,lt),m=i.dot(c,p),m<0||q+m>h))return;l=i.dot(u,p)/h}else{if(Math.abs(h)<y.EPSILON6)return;let E=1/h;if(d=i.subtract(s,n,ht),q=i.dot(d,f)*E,q<0||q>1||(p=i.cross(d,a,lt),m=i.dot(c,p)*E,m<0||q+m>1))return;l=i.dot(u,p)*E}return l};O.rayTriangle=function(t,n,r,e,o,s){let c=O.rayTriangleParametric(t,n,r,e,o);if(!(!g(c)||c<0))return g(s)||(s=new i),i.multiplyByScalar(t.direction,c,s),i.add(t.origin,s,s)};var Et=new it;O.lineSegmentTriangle=function(t,n,r,e,o,s,c){if(!g(t))throw new w("v0 is required.");if(!g(n))throw new w("v1 is required.");if(!g(r))throw new w("p0 is required.");if(!g(e))throw new w("p1 is required.");if(!g(o))throw new w("p2 is required.");let a=Et;i.clone(t,a.origin),i.subtract(n,t,a.direction),i.normalize(a.direction,a.direction);let u=O.rayTriangleParametric(a,r,e,o,s);if(!(!g(u)||u<0||u>i.distance(t,n)))return g(c)||(c=new i),i.multiplyByScalar(a.direction,u,c),i.add(a.origin,c,c)};function Ct(t,n,r,e){let o=n*n-4*t*r;if(o<0)return;if(o>0){let c=1/(2*t),a=Math.sqrt(o),u=(-n+a)*c,f=(-n-a)*c;return u<f?(e.root0=u,e.root1=f):(e.root0=f,e.root1=u),e}let s=-n/(2*t);if(s!==0)return e.root0=e.root1=s,e}var Nt={root0:0,root1:0};function yt(t,n,r){g(r)||(r=new U);let e=t.origin,o=t.direction,s=n.center,c=n.radius*n.radius,a=i.subtract(e,s,Mt),u=i.dot(o,o),f=2*i.dot(o,a),h=i.magnitudeSquared(a)-c,d=Ct(u,f,h,Nt);if(g(d))return r.start=d.root0,r.stop=d.root1,r}O.raySphere=function(t,n,r){if(!g(t))throw new w("ray is required.");if(!g(n))throw new w("sphere is required.");if(r=yt(t,n,r),!(!g(r)||r.stop<0))return r.start=Math.max(r.start,0),r};var Lt=new it;O.lineSegmentSphere=function(t,n,r,e){if(!g(t))throw new w("p0 is required.");if(!g(n))throw new w("p1 is required.");if(!g(r))throw new w("sphere is required.");let o=Lt;i.clone(t,o.origin);let s=i.subtract(n,t,o.direction),c=i.magnitude(s);if(i.normalize(s,s),e=yt(o,r,e),!(!g(e)||e.stop<0||e.start>c))return e.start=Math.max(e.start,0),e.stop=Math.min(e.stop,c),e};var It=new i,xt=new i;O.rayEllipsoid=function(t,n){if(!g(t))throw new w("ray is required.");if(!g(n))throw new w("ellipsoid is required.");let r=n.oneOverRadii,e=i.multiplyComponents(r,t.origin,It),o=i.multiplyComponents(r,t.direction,xt),s=i.magnitudeSquared(e),c=i.dot(e,o),a,u,f,h,d;if(s>1){if(c>=0)return;let p=c*c;if(a=s-1,u=i.magnitudeSquared(o),f=u*a,p<f)return;if(p>f){h=c*c-f,d=-c+Math.sqrt(h);let m=d/u,l=a/d;return m<l?new U(m,l):{start:l,stop:m}}let q=Math.sqrt(a/u);return new U(q,q)}else if(s<1)return a=s-1,u=i.magnitudeSquared(o),f=u*a,h=c*c-f,d=-c+Math.sqrt(h),new U(0,d/u);if(c<0)return u=i.magnitudeSquared(o),new U(0,-c/u)};var Bt=new U,Dt=new U,zt=new U;O.rayAxisAlignedBoundingBox=function(t,n,r){if(!g(t))throw new w("ray is required.");if(!g(n))throw new w("box is required.");g(r)||(r=new U);let e=st(t.origin.x,t.direction.x,n.minimum.x,n.maximum.x,Bt),o=st(t.origin.y,t.direction.y,n.minimum.y,n.maximum.y,Dt),s=st(t.origin.z,t.direction.z,n.minimum.z,n.maximum.z,zt);if(r.start=e.start>o.start?e.start:o.start,r.stop=e.stop<o.stop?e.stop:o.stop,!(e.start>o.stop||o.start>e.stop)&&!(r.start>s.stop||s.start>r.stop))return s.start>r.start&&(r.start=s.start),s.stop<r.stop&&(r.stop=s.stop),r};function st(t,n,r,e,o){if(o.start=(r-t)/n,o.stop=(e-t)/n,o.stop<o.start){let s=o.stop;o.stop=o.start,o.start=s}return o}function Q(t,n,r){let e=t+n;return y.sign(t)!==y.sign(n)&&Math.abs(e/Math.max(Math.abs(t),Math.abs(n)))<r?0:e}O.quadraticVectorExpression=function(t,n,r,e,o){let s=e*e,c=o*o,a=(t[b.COLUMN1ROW1]-t[b.COLUMN2ROW2])*c,u=o*(e*Q(t[b.COLUMN1ROW0],t[b.COLUMN0ROW1],y.EPSILON15)+n.y),f=t[b.COLUMN0ROW0]*s+t[b.COLUMN2ROW2]*c+e*n.x+r,h=c*Q(t[b.COLUMN2ROW1],t[b.COLUMN1ROW2],y.EPSILON15),d=o*(e*Q(t[b.COLUMN2ROW0],t[b.COLUMN0ROW2])+n.z),p,q=[];if(d===0&&h===0){if(p=z.computeRealRoots(a,u,f),p.length===0)return q;let P=p[0],R=Math.sqrt(Math.max(1-P*P,0));if(q.push(new i(e,o*P,o*-R)),q.push(new i(e,o*P,o*R)),p.length===2){let S=p[1],M=Math.sqrt(Math.max(1-S*S,0));q.push(new i(e,o*S,o*-M)),q.push(new i(e,o*S,o*M))}return q}let m=d*d,l=h*h,E=a*a,x=d*h,v=E+l,W=2*(u*a+x),L=2*f*a+u*u-l+m,B=2*(f*u-x),I=f*f-m;if(v===0&&W===0&&L===0&&B===0)return q;p=dt.computeRealRoots(v,W,L,B,I);let C=p.length;if(C===0)return q;for(let P=0;P<C;++P){let R=p[P],S=R*R,M=Math.max(1-S,0),N=Math.sqrt(M),D;y.sign(a)===y.sign(f)?D=Q(a*S+f,u*R,y.EPSILON12):y.sign(f)===y.sign(u*R)?D=Q(a*S,u*R+f,y.EPSILON12):D=Q(a*S+u*R,f,y.EPSILON12);let _=Q(h*R,d,y.EPSILON15),Z=D*_;Z<0?q.push(new i(e,o*R,o*N)):Z>0?q.push(new i(e,o*R,o*-N)):N!==0?(q.push(new i(e,o*R,o*-N)),q.push(new i(e,o*R,o*N)),++P):q.push(new i(e,o*R,o*N))}return q};var ct=new i,wt=new i,qt=new i,F=new i,Tt=new i,vt=new b,Wt=new b,At=new b,Ut=new b,Vt=new b,gt=new b,pt=new b,St=new i,Qt=new i,Zt=new ft;O.grazingAltitudeLocation=function(t,n){if(!g(t))throw new w("ray is required.");if(!g(n))throw new w("ellipsoid is required.");let r=t.origin,e=t.direction;if(!i.equals(r,i.ZERO)){let I=n.geodeticSurfaceNormal(r,ct);if(i.dot(e,I)>=0)return r}let o=g(this.rayEllipsoid(t,n)),s=n.transformPositionToScaledSpace(e,ct),c=i.normalize(s,s),a=i.mostOrthogonalAxis(s,F),u=i.normalize(i.cross(a,c,wt),wt),f=i.normalize(i.cross(c,u,qt),qt),h=vt;h[0]=c.x,h[1]=c.y,h[2]=c.z,h[3]=u.x,h[4]=u.y,h[5]=u.z,h[6]=f.x,h[7]=f.y,h[8]=f.z;let d=b.transpose(h,Wt),p=b.fromScale(n.radii,At),q=b.fromScale(n.oneOverRadii,Ut),m=Vt;m[0]=0,m[1]=-e.z,m[2]=e.y,m[3]=e.z,m[4]=0,m[5]=-e.x,m[6]=-e.y,m[7]=e.x,m[8]=0;let l=b.multiply(b.multiply(d,q,gt),m,gt),E=b.multiply(b.multiply(l,p,pt),h,pt),x=b.multiplyByVector(l,r,Tt),v=O.quadraticVectorExpression(E,i.negate(x,ct),0,0,1),W,L,B=v.length;if(B>0){let I=i.clone(i.ZERO,Qt),C=Number.NEGATIVE_INFINITY;for(let R=0;R<B;++R){W=b.multiplyByVector(p,b.multiplyByVector(h,v[R],St),St);let S=i.normalize(i.subtract(W,r,F),F),M=i.dot(S,e);M>C&&(C=M,I=i.clone(W,I))}let P=n.cartesianToCartographic(I,Zt);return C=y.clamp(C,0,1),L=i.magnitude(i.subtract(I,r,F))*Math.sqrt(1-C*C),L=o?-L:L,P.height=L,n.cartographicToCartesian(P,new i)}};var _t=new i;O.lineSegmentPlane=function(t,n,r,e){if(!g(t))throw new w("endPoint0 is required.");if(!g(n))throw new w("endPoint1 is required.");if(!g(r))throw new w("plane is required.");g(e)||(e=new i);let o=i.subtract(n,t,_t),s=r.normal,c=i.dot(s,o);if(Math.abs(c)<y.EPSILON6)return;let a=i.dot(s,t),u=-(r.distance+a)/c;if(!(u<0||u>1))return i.multiplyByScalar(o,u,e),i.add(t,e,e),e};O.trianglePlaneIntersection=function(t,n,r,e){if(!g(t)||!g(n)||!g(r)||!g(e))throw new w("p0, p1, p2, and plane are required.");let o=e.normal,s=e.distance,c=i.dot(o,t)+s<0,a=i.dot(o,n)+s<0,u=i.dot(o,r)+s<0,f=0;f+=c?1:0,f+=a?1:0,f+=u?1:0;let h,d;if((f===1||f===2)&&(h=new i,d=new i),f===1){if(c)return O.lineSegmentPlane(t,n,e,h),O.lineSegmentPlane(t,r,e,d),{positions:[t,n,r,h,d],indices:[0,3,4,1,2,4,1,4,3]};if(a)return O.lineSegmentPlane(n,r,e,h),O.lineSegmentPlane(n,t,e,d),{positions:[t,n,r,h,d],indices:[1,3,4,2,0,4,2,4,3]};if(u)return O.lineSegmentPlane(r,t,e,h),O.lineSegmentPlane(r,n,e,d),{positions:[t,n,r,h,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(f===2)if(c)if(a){if(!u)return O.lineSegmentPlane(t,r,e,h),O.lineSegmentPlane(n,r,e,d),{positions:[t,n,r,h,d],indices:[0,1,4,0,4,3,2,3,4]}}else return O.lineSegmentPlane(r,n,e,h),O.lineSegmentPlane(t,n,e,d),{positions:[t,n,r,h,d],indices:[2,0,4,2,4,3,1,3,4]};else return O.lineSegmentPlane(n,t,e,h),O.lineSegmentPlane(r,t,e,d),{positions:[t,n,r,h,d],indices:[1,2,4,1,4,3,0,3,4]}};var gn=O;export{it as a,gn as b};
