//
//  Copyright (c) 2021 International Business Machines
//  All rights reserved.
//
//  SPDX-License-Identifier: MIT
//
//  Authors: anita.shekar@ibm.com, sandy.kaur@ibm.com
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v3.21.12
// source: gateway.proto

package nvmeof

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AddressFamily int32

const (
	AddressFamily_ipv4 AddressFamily = 0
	AddressFamily_ipv6 AddressFamily = 1
)

// Enum value maps for AddressFamily.
var (
	AddressFamily_name = map[int32]string{
		0: "ipv4",
		1: "ipv6",
	}
	AddressFamily_value = map[string]int32{
		"ipv4": 0,
		"ipv6": 1,
	}
)

func (x AddressFamily) Enum() *AddressFamily {
	p := new(AddressFamily)
	*p = x
	return p
}

func (x AddressFamily) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddressFamily) Descriptor() protoreflect.EnumDescriptor {
	return file_gateway_proto_enumTypes[0].Descriptor()
}

func (AddressFamily) Type() protoreflect.EnumType {
	return &file_gateway_proto_enumTypes[0]
}

func (x AddressFamily) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AddressFamily.Descriptor instead.
func (AddressFamily) EnumDescriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{0}
}

type LogLevel int32

const (
	LogLevel_ERROR   LogLevel = 0
	LogLevel_WARNING LogLevel = 1
	LogLevel_NOTICE  LogLevel = 2
	LogLevel_INFO    LogLevel = 3
	LogLevel_DEBUG   LogLevel = 4
)

// Enum value maps for LogLevel.
var (
	LogLevel_name = map[int32]string{
		0: "ERROR",
		1: "WARNING",
		2: "NOTICE",
		3: "INFO",
		4: "DEBUG",
	}
	LogLevel_value = map[string]int32{
		"ERROR":   0,
		"WARNING": 1,
		"NOTICE":  2,
		"INFO":    3,
		"DEBUG":   4,
	}
)

func (x LogLevel) Enum() *LogLevel {
	p := new(LogLevel)
	*p = x
	return p
}

func (x LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_gateway_proto_enumTypes[1].Descriptor()
}

func (LogLevel) Type() protoreflect.EnumType {
	return &file_gateway_proto_enumTypes[1]
}

func (x LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel.Descriptor instead.
func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{1}
}

type GwLogLevel int32

const (
	GwLogLevel_notset   GwLogLevel = 0
	GwLogLevel_debug    GwLogLevel = 10
	GwLogLevel_info     GwLogLevel = 20
	GwLogLevel_warning  GwLogLevel = 30
	GwLogLevel_error    GwLogLevel = 40
	GwLogLevel_critical GwLogLevel = 50
)

// Enum value maps for GwLogLevel.
var (
	GwLogLevel_name = map[int32]string{
		0:  "notset",
		10: "debug",
		20: "info",
		30: "warning",
		40: "error",
		50: "critical",
	}
	GwLogLevel_value = map[string]int32{
		"notset":   0,
		"debug":    10,
		"info":     20,
		"warning":  30,
		"error":    40,
		"critical": 50,
	}
)

func (x GwLogLevel) Enum() *GwLogLevel {
	p := new(GwLogLevel)
	*p = x
	return p
}

func (x GwLogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GwLogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_gateway_proto_enumTypes[2].Descriptor()
}

func (GwLogLevel) Type() protoreflect.EnumType {
	return &file_gateway_proto_enumTypes[2]
}

func (x GwLogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GwLogLevel.Descriptor instead.
func (GwLogLevel) EnumDescriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{2}
}

// From https://nvmexpress.org/wp-content/uploads/NVM-Express-1_4-2019.06.10-Ratified.pdf page 138
// Asymmetric Namespace Access state for all namespaces in this ANA
// Group when accessed through this controller.
// Value Description Reference
// 01h ANA Optimized state 8.20.3.1
// 02h ANA Non-Optimized state 8.20.3.2
// 03h ANA Inaccessible state 8.20.3.3
// 04h ANA Persistent Loss state 8.20.3.4
// 0Fh ANA Change state 8.20.3.5
// All others Reserved
type AnaState int32

const (
	AnaState_UNSET         AnaState = 0
	AnaState_OPTIMIZED     AnaState = 1
	AnaState_NON_OPTIMIZED AnaState = 2
	AnaState_INACCESSIBLE  AnaState = 3
)

// Enum value maps for AnaState.
var (
	AnaState_name = map[int32]string{
		0: "UNSET",
		1: "OPTIMIZED",
		2: "NON_OPTIMIZED",
		3: "INACCESSIBLE",
	}
	AnaState_value = map[string]int32{
		"UNSET":         0,
		"OPTIMIZED":     1,
		"NON_OPTIMIZED": 2,
		"INACCESSIBLE":  3,
	}
)

func (x AnaState) Enum() *AnaState {
	p := new(AnaState)
	*p = x
	return p
}

func (x AnaState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnaState) Descriptor() protoreflect.EnumDescriptor {
	return file_gateway_proto_enumTypes[3].Descriptor()
}

func (AnaState) Type() protoreflect.EnumType {
	return &file_gateway_proto_enumTypes[3]
}

func (x AnaState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnaState.Descriptor instead.
func (AnaState) EnumDescriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{3}
}

type NamespaceAddReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RbdPoolName        string  `protobuf:"bytes,1,opt,name=rbd_pool_name,json=rbdPoolName,proto3" json:"rbd_pool_name,omitempty"`
	RbdImageName       string  `protobuf:"bytes,2,opt,name=rbd_image_name,json=rbdImageName,proto3" json:"rbd_image_name,omitempty"`
	SubsystemNqn       string  `protobuf:"bytes,3,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid               *uint32 `protobuf:"varint,4,opt,name=nsid,proto3,oneof" json:"nsid,omitempty"`
	BlockSize          uint32  `protobuf:"varint,5,opt,name=block_size,json=blockSize,proto3" json:"block_size,omitempty"`
	Uuid               *string `protobuf:"bytes,6,opt,name=uuid,proto3,oneof" json:"uuid,omitempty"`
	Anagrpid           *int32  `protobuf:"varint,7,opt,name=anagrpid,proto3,oneof" json:"anagrpid,omitempty"`
	CreateImage        *bool   `protobuf:"varint,8,opt,name=create_image,json=createImage,proto3,oneof" json:"create_image,omitempty"`
	Size               *uint64 `protobuf:"varint,9,opt,name=size,proto3,oneof" json:"size,omitempty"`
	Force              *bool   `protobuf:"varint,10,opt,name=force,proto3,oneof" json:"force,omitempty"`
	NoAutoVisible      *bool   `protobuf:"varint,11,opt,name=no_auto_visible,json=noAutoVisible,proto3,oneof" json:"no_auto_visible,omitempty"`
	TrashImage         *bool   `protobuf:"varint,12,opt,name=trash_image,json=trashImage,proto3,oneof" json:"trash_image,omitempty"`
	DisableAutoResize  *bool   `protobuf:"varint,13,opt,name=disable_auto_resize,json=disableAutoResize,proto3,oneof" json:"disable_auto_resize,omitempty"`
	ReadOnly           *bool   `protobuf:"varint,14,opt,name=read_only,json=readOnly,proto3,oneof" json:"read_only,omitempty"`
	RbdDataPoolName    *string `protobuf:"bytes,15,opt,name=rbd_data_pool_name,json=rbdDataPoolName,proto3,oneof" json:"rbd_data_pool_name,omitempty"`
	Location           *string `protobuf:"bytes,16,opt,name=location,proto3,oneof" json:"location,omitempty"`
	RadosNamespaceName *string `protobuf:"bytes,17,opt,name=rados_namespace_name,json=radosNamespaceName,proto3,oneof" json:"rados_namespace_name,omitempty"`
}

func (x *NamespaceAddReq) Reset() {
	*x = NamespaceAddReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceAddReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceAddReq) ProtoMessage() {}

func (x *NamespaceAddReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceAddReq.ProtoReflect.Descriptor instead.
func (*NamespaceAddReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{0}
}

func (x *NamespaceAddReq) GetRbdPoolName() string {
	if x != nil {
		return x.RbdPoolName
	}
	return ""
}

func (x *NamespaceAddReq) GetRbdImageName() string {
	if x != nil {
		return x.RbdImageName
	}
	return ""
}

func (x *NamespaceAddReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceAddReq) GetNsid() uint32 {
	if x != nil && x.Nsid != nil {
		return *x.Nsid
	}
	return 0
}

func (x *NamespaceAddReq) GetBlockSize() uint32 {
	if x != nil {
		return x.BlockSize
	}
	return 0
}

func (x *NamespaceAddReq) GetUuid() string {
	if x != nil && x.Uuid != nil {
		return *x.Uuid
	}
	return ""
}

func (x *NamespaceAddReq) GetAnagrpid() int32 {
	if x != nil && x.Anagrpid != nil {
		return *x.Anagrpid
	}
	return 0
}

func (x *NamespaceAddReq) GetCreateImage() bool {
	if x != nil && x.CreateImage != nil {
		return *x.CreateImage
	}
	return false
}

func (x *NamespaceAddReq) GetSize() uint64 {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return 0
}

func (x *NamespaceAddReq) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

func (x *NamespaceAddReq) GetNoAutoVisible() bool {
	if x != nil && x.NoAutoVisible != nil {
		return *x.NoAutoVisible
	}
	return false
}

func (x *NamespaceAddReq) GetTrashImage() bool {
	if x != nil && x.TrashImage != nil {
		return *x.TrashImage
	}
	return false
}

func (x *NamespaceAddReq) GetDisableAutoResize() bool {
	if x != nil && x.DisableAutoResize != nil {
		return *x.DisableAutoResize
	}
	return false
}

func (x *NamespaceAddReq) GetReadOnly() bool {
	if x != nil && x.ReadOnly != nil {
		return *x.ReadOnly
	}
	return false
}

func (x *NamespaceAddReq) GetRbdDataPoolName() string {
	if x != nil && x.RbdDataPoolName != nil {
		return *x.RbdDataPoolName
	}
	return ""
}

func (x *NamespaceAddReq) GetLocation() string {
	if x != nil && x.Location != nil {
		return *x.Location
	}
	return ""
}

func (x *NamespaceAddReq) GetRadosNamespaceName() string {
	if x != nil && x.RadosNamespaceName != nil {
		return *x.RadosNamespaceName
	}
	return ""
}

type NamespaceResizeReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32  `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	OBSOLETEUuid *string `protobuf:"bytes,3,opt,name=OBSOLETE_uuid,json=OBSOLETEUuid,proto3,oneof" json:"OBSOLETE_uuid,omitempty"`
	NewSize      uint64  `protobuf:"varint,4,opt,name=new_size,json=newSize,proto3" json:"new_size,omitempty"`
}

func (x *NamespaceResizeReq) Reset() {
	*x = NamespaceResizeReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceResizeReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceResizeReq) ProtoMessage() {}

func (x *NamespaceResizeReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceResizeReq.ProtoReflect.Descriptor instead.
func (*NamespaceResizeReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{1}
}

func (x *NamespaceResizeReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceResizeReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceResizeReq) GetOBSOLETEUuid() string {
	if x != nil && x.OBSOLETEUuid != nil {
		return *x.OBSOLETEUuid
	}
	return ""
}

func (x *NamespaceResizeReq) GetNewSize() uint64 {
	if x != nil {
		return x.NewSize
	}
	return 0
}

type NamespaceGetIoStatsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32  `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	OBSOLETEUuid *string `protobuf:"bytes,3,opt,name=OBSOLETE_uuid,json=OBSOLETEUuid,proto3,oneof" json:"OBSOLETE_uuid,omitempty"`
}

func (x *NamespaceGetIoStatsReq) Reset() {
	*x = NamespaceGetIoStatsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceGetIoStatsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceGetIoStatsReq) ProtoMessage() {}

func (x *NamespaceGetIoStatsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceGetIoStatsReq.ProtoReflect.Descriptor instead.
func (*NamespaceGetIoStatsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{2}
}

func (x *NamespaceGetIoStatsReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceGetIoStatsReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceGetIoStatsReq) GetOBSOLETEUuid() string {
	if x != nil && x.OBSOLETEUuid != nil {
		return *x.OBSOLETEUuid
	}
	return ""
}

type NamespaceSetQosReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn      string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid              uint32  `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	OBSOLETEUuid      *string `protobuf:"bytes,3,opt,name=OBSOLETE_uuid,json=OBSOLETEUuid,proto3,oneof" json:"OBSOLETE_uuid,omitempty"`
	RwIosPerSecond    *uint64 `protobuf:"varint,4,opt,name=rw_ios_per_second,json=rwIosPerSecond,proto3,oneof" json:"rw_ios_per_second,omitempty"`
	RwMbytesPerSecond *uint64 `protobuf:"varint,5,opt,name=rw_mbytes_per_second,json=rwMbytesPerSecond,proto3,oneof" json:"rw_mbytes_per_second,omitempty"`
	RMbytesPerSecond  *uint64 `protobuf:"varint,6,opt,name=r_mbytes_per_second,json=rMbytesPerSecond,proto3,oneof" json:"r_mbytes_per_second,omitempty"`
	WMbytesPerSecond  *uint64 `protobuf:"varint,7,opt,name=w_mbytes_per_second,json=wMbytesPerSecond,proto3,oneof" json:"w_mbytes_per_second,omitempty"`
	Force             *bool   `protobuf:"varint,8,opt,name=force,proto3,oneof" json:"force,omitempty"`
}

func (x *NamespaceSetQosReq) Reset() {
	*x = NamespaceSetQosReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceSetQosReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceSetQosReq) ProtoMessage() {}

func (x *NamespaceSetQosReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceSetQosReq.ProtoReflect.Descriptor instead.
func (*NamespaceSetQosReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{3}
}

func (x *NamespaceSetQosReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceSetQosReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceSetQosReq) GetOBSOLETEUuid() string {
	if x != nil && x.OBSOLETEUuid != nil {
		return *x.OBSOLETEUuid
	}
	return ""
}

func (x *NamespaceSetQosReq) GetRwIosPerSecond() uint64 {
	if x != nil && x.RwIosPerSecond != nil {
		return *x.RwIosPerSecond
	}
	return 0
}

func (x *NamespaceSetQosReq) GetRwMbytesPerSecond() uint64 {
	if x != nil && x.RwMbytesPerSecond != nil {
		return *x.RwMbytesPerSecond
	}
	return 0
}

func (x *NamespaceSetQosReq) GetRMbytesPerSecond() uint64 {
	if x != nil && x.RMbytesPerSecond != nil {
		return *x.RMbytesPerSecond
	}
	return 0
}

func (x *NamespaceSetQosReq) GetWMbytesPerSecond() uint64 {
	if x != nil && x.WMbytesPerSecond != nil {
		return *x.WMbytesPerSecond
	}
	return 0
}

func (x *NamespaceSetQosReq) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

type NamespaceChangeLoadBalancingGroupReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32  `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	OBSOLETEUuid *string `protobuf:"bytes,3,opt,name=OBSOLETE_uuid,json=OBSOLETEUuid,proto3,oneof" json:"OBSOLETE_uuid,omitempty"`
	Anagrpid     int32   `protobuf:"varint,4,opt,name=anagrpid,proto3" json:"anagrpid,omitempty"`
	AutoLbLogic  *bool   `protobuf:"varint,5,opt,name=auto_lb_logic,json=autoLbLogic,proto3,oneof" json:"auto_lb_logic,omitempty"`
}

func (x *NamespaceChangeLoadBalancingGroupReq) Reset() {
	*x = NamespaceChangeLoadBalancingGroupReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceChangeLoadBalancingGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceChangeLoadBalancingGroupReq) ProtoMessage() {}

func (x *NamespaceChangeLoadBalancingGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceChangeLoadBalancingGroupReq.ProtoReflect.Descriptor instead.
func (*NamespaceChangeLoadBalancingGroupReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{4}
}

func (x *NamespaceChangeLoadBalancingGroupReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceChangeLoadBalancingGroupReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceChangeLoadBalancingGroupReq) GetOBSOLETEUuid() string {
	if x != nil && x.OBSOLETEUuid != nil {
		return *x.OBSOLETEUuid
	}
	return ""
}

func (x *NamespaceChangeLoadBalancingGroupReq) GetAnagrpid() int32 {
	if x != nil {
		return x.Anagrpid
	}
	return 0
}

func (x *NamespaceChangeLoadBalancingGroupReq) GetAutoLbLogic() bool {
	if x != nil && x.AutoLbLogic != nil {
		return *x.AutoLbLogic
	}
	return false
}

type NamespaceChangeVisibilityReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32 `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	AutoVisible  bool   `protobuf:"varint,3,opt,name=auto_visible,json=autoVisible,proto3" json:"auto_visible,omitempty"`
	Force        *bool  `protobuf:"varint,4,opt,name=force,proto3,oneof" json:"force,omitempty"`
}

func (x *NamespaceChangeVisibilityReq) Reset() {
	*x = NamespaceChangeVisibilityReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceChangeVisibilityReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceChangeVisibilityReq) ProtoMessage() {}

func (x *NamespaceChangeVisibilityReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceChangeVisibilityReq.ProtoReflect.Descriptor instead.
func (*NamespaceChangeVisibilityReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{5}
}

func (x *NamespaceChangeVisibilityReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceChangeVisibilityReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceChangeVisibilityReq) GetAutoVisible() bool {
	if x != nil {
		return x.AutoVisible
	}
	return false
}

func (x *NamespaceChangeVisibilityReq) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

type NamespaceChangeLocationReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32  `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	Location     *string `protobuf:"bytes,3,opt,name=location,proto3,oneof" json:"location,omitempty"`
}

func (x *NamespaceChangeLocationReq) Reset() {
	*x = NamespaceChangeLocationReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceChangeLocationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceChangeLocationReq) ProtoMessage() {}

func (x *NamespaceChangeLocationReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceChangeLocationReq.ProtoReflect.Descriptor instead.
func (*NamespaceChangeLocationReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{6}
}

func (x *NamespaceChangeLocationReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceChangeLocationReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceChangeLocationReq) GetLocation() string {
	if x != nil && x.Location != nil {
		return *x.Location
	}
	return ""
}

type NamespaceSetRbdTrashImageReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32 `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	TrashImage   bool   `protobuf:"varint,3,opt,name=trash_image,json=trashImage,proto3" json:"trash_image,omitempty"`
}

func (x *NamespaceSetRbdTrashImageReq) Reset() {
	*x = NamespaceSetRbdTrashImageReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceSetRbdTrashImageReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceSetRbdTrashImageReq) ProtoMessage() {}

func (x *NamespaceSetRbdTrashImageReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceSetRbdTrashImageReq.ProtoReflect.Descriptor instead.
func (*NamespaceSetRbdTrashImageReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{7}
}

func (x *NamespaceSetRbdTrashImageReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceSetRbdTrashImageReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceSetRbdTrashImageReq) GetTrashImage() bool {
	if x != nil {
		return x.TrashImage
	}
	return false
}

type NamespaceSetAutoResizeReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32 `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	AutoResize   bool   `protobuf:"varint,3,opt,name=auto_resize,json=autoResize,proto3" json:"auto_resize,omitempty"`
}

func (x *NamespaceSetAutoResizeReq) Reset() {
	*x = NamespaceSetAutoResizeReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceSetAutoResizeReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceSetAutoResizeReq) ProtoMessage() {}

func (x *NamespaceSetAutoResizeReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceSetAutoResizeReq.ProtoReflect.Descriptor instead.
func (*NamespaceSetAutoResizeReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{8}
}

func (x *NamespaceSetAutoResizeReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceSetAutoResizeReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceSetAutoResizeReq) GetAutoResize() bool {
	if x != nil {
		return x.AutoResize
	}
	return false
}

type NamespaceDeleteReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32  `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	OBSOLETEUuid *string `protobuf:"bytes,3,opt,name=OBSOLETE_uuid,json=OBSOLETEUuid,proto3,oneof" json:"OBSOLETE_uuid,omitempty"`
	IAmSure      *bool   `protobuf:"varint,4,opt,name=i_am_sure,json=iAmSure,proto3,oneof" json:"i_am_sure,omitempty"`
}

func (x *NamespaceDeleteReq) Reset() {
	*x = NamespaceDeleteReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceDeleteReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceDeleteReq) ProtoMessage() {}

func (x *NamespaceDeleteReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceDeleteReq.ProtoReflect.Descriptor instead.
func (*NamespaceDeleteReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{9}
}

func (x *NamespaceDeleteReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceDeleteReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceDeleteReq) GetOBSOLETEUuid() string {
	if x != nil && x.OBSOLETEUuid != nil {
		return *x.OBSOLETEUuid
	}
	return ""
}

func (x *NamespaceDeleteReq) GetIAmSure() bool {
	if x != nil && x.IAmSure != nil {
		return *x.IAmSure
	}
	return false
}

type NamespaceAddHostReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32 `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	HostNqn      string `protobuf:"bytes,3,opt,name=host_nqn,json=hostNqn,proto3" json:"host_nqn,omitempty"`
	Force        *bool  `protobuf:"varint,4,opt,name=force,proto3,oneof" json:"force,omitempty"`
}

func (x *NamespaceAddHostReq) Reset() {
	*x = NamespaceAddHostReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceAddHostReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceAddHostReq) ProtoMessage() {}

func (x *NamespaceAddHostReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceAddHostReq.ProtoReflect.Descriptor instead.
func (*NamespaceAddHostReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{10}
}

func (x *NamespaceAddHostReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceAddHostReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceAddHostReq) GetHostNqn() string {
	if x != nil {
		return x.HostNqn
	}
	return ""
}

func (x *NamespaceAddHostReq) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

type NamespaceDeleteHostReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid         uint32 `protobuf:"varint,2,opt,name=nsid,proto3" json:"nsid,omitempty"`
	HostNqn      string `protobuf:"bytes,3,opt,name=host_nqn,json=hostNqn,proto3" json:"host_nqn,omitempty"`
}

func (x *NamespaceDeleteHostReq) Reset() {
	*x = NamespaceDeleteHostReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceDeleteHostReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceDeleteHostReq) ProtoMessage() {}

func (x *NamespaceDeleteHostReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceDeleteHostReq.ProtoReflect.Descriptor instead.
func (*NamespaceDeleteHostReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{11}
}

func (x *NamespaceDeleteHostReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceDeleteHostReq) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceDeleteHostReq) GetHostNqn() string {
	if x != nil {
		return x.HostNqn
	}
	return ""
}

type CreateSubsystemReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn    string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	SerialNumber    string  `protobuf:"bytes,2,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	MaxNamespaces   *uint32 `protobuf:"varint,3,opt,name=max_namespaces,json=maxNamespaces,proto3,oneof" json:"max_namespaces,omitempty"`
	EnableHa        bool    `protobuf:"varint,4,opt,name=enable_ha,json=enableHa,proto3" json:"enable_ha,omitempty"`
	NoGroupAppend   *bool   `protobuf:"varint,5,opt,name=no_group_append,json=noGroupAppend,proto3,oneof" json:"no_group_append,omitempty"`
	DhchapKey       *string `protobuf:"bytes,6,opt,name=dhchap_key,json=dhchapKey,proto3,oneof" json:"dhchap_key,omitempty"`
	KeyEncrypted    *bool   `protobuf:"varint,7,opt,name=key_encrypted,json=keyEncrypted,proto3,oneof" json:"key_encrypted,omitempty"`
	NetworkMask     *string `protobuf:"bytes,8,opt,name=network_mask,json=networkMask,proto3,oneof" json:"network_mask,omitempty"`
	SecureListeners *bool   `protobuf:"varint,9,opt,name=secure_listeners,json=secureListeners,proto3,oneof" json:"secure_listeners,omitempty"`
}

func (x *CreateSubsystemReq) Reset() {
	*x = CreateSubsystemReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSubsystemReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSubsystemReq) ProtoMessage() {}

func (x *CreateSubsystemReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSubsystemReq.ProtoReflect.Descriptor instead.
func (*CreateSubsystemReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{12}
}

func (x *CreateSubsystemReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *CreateSubsystemReq) GetSerialNumber() string {
	if x != nil {
		return x.SerialNumber
	}
	return ""
}

func (x *CreateSubsystemReq) GetMaxNamespaces() uint32 {
	if x != nil && x.MaxNamespaces != nil {
		return *x.MaxNamespaces
	}
	return 0
}

func (x *CreateSubsystemReq) GetEnableHa() bool {
	if x != nil {
		return x.EnableHa
	}
	return false
}

func (x *CreateSubsystemReq) GetNoGroupAppend() bool {
	if x != nil && x.NoGroupAppend != nil {
		return *x.NoGroupAppend
	}
	return false
}

func (x *CreateSubsystemReq) GetDhchapKey() string {
	if x != nil && x.DhchapKey != nil {
		return *x.DhchapKey
	}
	return ""
}

func (x *CreateSubsystemReq) GetKeyEncrypted() bool {
	if x != nil && x.KeyEncrypted != nil {
		return *x.KeyEncrypted
	}
	return false
}

func (x *CreateSubsystemReq) GetNetworkMask() string {
	if x != nil && x.NetworkMask != nil {
		return *x.NetworkMask
	}
	return ""
}

func (x *CreateSubsystemReq) GetSecureListeners() bool {
	if x != nil && x.SecureListeners != nil {
		return *x.SecureListeners
	}
	return false
}

type DeleteSubsystemReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Force        *bool  `protobuf:"varint,2,opt,name=force,proto3,oneof" json:"force,omitempty"`
	IAmSure      *bool  `protobuf:"varint,3,opt,name=i_am_sure,json=iAmSure,proto3,oneof" json:"i_am_sure,omitempty"`
}

func (x *DeleteSubsystemReq) Reset() {
	*x = DeleteSubsystemReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSubsystemReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSubsystemReq) ProtoMessage() {}

func (x *DeleteSubsystemReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSubsystemReq.ProtoReflect.Descriptor instead.
func (*DeleteSubsystemReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteSubsystemReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *DeleteSubsystemReq) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

func (x *DeleteSubsystemReq) GetIAmSure() bool {
	if x != nil && x.IAmSure != nil {
		return *x.IAmSure
	}
	return false
}

type ChangeSubsystemKeyReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	DhchapKey    *string `protobuf:"bytes,2,opt,name=dhchap_key,json=dhchapKey,proto3,oneof" json:"dhchap_key,omitempty"`
}

func (x *ChangeSubsystemKeyReq) Reset() {
	*x = ChangeSubsystemKeyReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeSubsystemKeyReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeSubsystemKeyReq) ProtoMessage() {}

func (x *ChangeSubsystemKeyReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeSubsystemKeyReq.ProtoReflect.Descriptor instead.
func (*ChangeSubsystemKeyReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{14}
}

func (x *ChangeSubsystemKeyReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *ChangeSubsystemKeyReq) GetDhchapKey() string {
	if x != nil && x.DhchapKey != nil {
		return *x.DhchapKey
	}
	return ""
}

type ListNamespacesReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subsystem string  `protobuf:"bytes,1,opt,name=subsystem,proto3" json:"subsystem,omitempty"`
	Nsid      *uint32 `protobuf:"varint,2,opt,name=nsid,proto3,oneof" json:"nsid,omitempty"`
	Uuid      *string `protobuf:"bytes,3,opt,name=uuid,proto3,oneof" json:"uuid,omitempty"`
}

func (x *ListNamespacesReq) Reset() {
	*x = ListNamespacesReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNamespacesReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNamespacesReq) ProtoMessage() {}

func (x *ListNamespacesReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNamespacesReq.ProtoReflect.Descriptor instead.
func (*ListNamespacesReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{15}
}

func (x *ListNamespacesReq) GetSubsystem() string {
	if x != nil {
		return x.Subsystem
	}
	return ""
}

func (x *ListNamespacesReq) GetNsid() uint32 {
	if x != nil && x.Nsid != nil {
		return *x.Nsid
	}
	return 0
}

func (x *ListNamespacesReq) GetUuid() string {
	if x != nil && x.Uuid != nil {
		return *x.Uuid
	}
	return ""
}

type AddHostReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	HostNqn      string  `protobuf:"bytes,2,opt,name=host_nqn,json=hostNqn,proto3" json:"host_nqn,omitempty"`
	Psk          *string `protobuf:"bytes,3,opt,name=psk,proto3,oneof" json:"psk,omitempty"`
	DhchapKey    *string `protobuf:"bytes,4,opt,name=dhchap_key,json=dhchapKey,proto3,oneof" json:"dhchap_key,omitempty"`
	PskEncrypted *bool   `protobuf:"varint,5,opt,name=psk_encrypted,json=pskEncrypted,proto3,oneof" json:"psk_encrypted,omitempty"`
	KeyEncrypted *bool   `protobuf:"varint,6,opt,name=key_encrypted,json=keyEncrypted,proto3,oneof" json:"key_encrypted,omitempty"`
}

func (x *AddHostReq) Reset() {
	*x = AddHostReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddHostReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddHostReq) ProtoMessage() {}

func (x *AddHostReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddHostReq.ProtoReflect.Descriptor instead.
func (*AddHostReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{16}
}

func (x *AddHostReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *AddHostReq) GetHostNqn() string {
	if x != nil {
		return x.HostNqn
	}
	return ""
}

func (x *AddHostReq) GetPsk() string {
	if x != nil && x.Psk != nil {
		return *x.Psk
	}
	return ""
}

func (x *AddHostReq) GetDhchapKey() string {
	if x != nil && x.DhchapKey != nil {
		return *x.DhchapKey
	}
	return ""
}

func (x *AddHostReq) GetPskEncrypted() bool {
	if x != nil && x.PskEncrypted != nil {
		return *x.PskEncrypted
	}
	return false
}

func (x *AddHostReq) GetKeyEncrypted() bool {
	if x != nil && x.KeyEncrypted != nil {
		return *x.KeyEncrypted
	}
	return false
}

type ChangeHostKeyReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string  `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	HostNqn      string  `protobuf:"bytes,2,opt,name=host_nqn,json=hostNqn,proto3" json:"host_nqn,omitempty"`
	DhchapKey    *string `protobuf:"bytes,3,opt,name=dhchap_key,json=dhchapKey,proto3,oneof" json:"dhchap_key,omitempty"`
}

func (x *ChangeHostKeyReq) Reset() {
	*x = ChangeHostKeyReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeHostKeyReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeHostKeyReq) ProtoMessage() {}

func (x *ChangeHostKeyReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeHostKeyReq.ProtoReflect.Descriptor instead.
func (*ChangeHostKeyReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{17}
}

func (x *ChangeHostKeyReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *ChangeHostKeyReq) GetHostNqn() string {
	if x != nil {
		return x.HostNqn
	}
	return ""
}

func (x *ChangeHostKeyReq) GetDhchapKey() string {
	if x != nil && x.DhchapKey != nil {
		return *x.DhchapKey
	}
	return ""
}

type RemoveHostReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	HostNqn      string `protobuf:"bytes,2,opt,name=host_nqn,json=hostNqn,proto3" json:"host_nqn,omitempty"`
}

func (x *RemoveHostReq) Reset() {
	*x = RemoveHostReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveHostReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveHostReq) ProtoMessage() {}

func (x *RemoveHostReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveHostReq.ProtoReflect.Descriptor instead.
func (*RemoveHostReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{18}
}

func (x *RemoveHostReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *RemoveHostReq) GetHostNqn() string {
	if x != nil {
		return x.HostNqn
	}
	return ""
}

type ListHostsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subsystem   string `protobuf:"bytes,1,opt,name=subsystem,proto3" json:"subsystem,omitempty"`
	ClearAlerts *bool  `protobuf:"varint,2,opt,name=clear_alerts,json=clearAlerts,proto3,oneof" json:"clear_alerts,omitempty"`
}

func (x *ListHostsReq) Reset() {
	*x = ListHostsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHostsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHostsReq) ProtoMessage() {}

func (x *ListHostsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHostsReq.ProtoReflect.Descriptor instead.
func (*ListHostsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{19}
}

func (x *ListHostsReq) GetSubsystem() string {
	if x != nil {
		return x.Subsystem
	}
	return ""
}

func (x *ListHostsReq) GetClearAlerts() bool {
	if x != nil && x.ClearAlerts != nil {
		return *x.ClearAlerts
	}
	return false
}

type ListConnectionsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subsystem   string `protobuf:"bytes,1,opt,name=subsystem,proto3" json:"subsystem,omitempty"`
	ClearAlerts *bool  `protobuf:"varint,2,opt,name=clear_alerts,json=clearAlerts,proto3,oneof" json:"clear_alerts,omitempty"`
}

func (x *ListConnectionsReq) Reset() {
	*x = ListConnectionsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsReq) ProtoMessage() {}

func (x *ListConnectionsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsReq.ProtoReflect.Descriptor instead.
func (*ListConnectionsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{20}
}

func (x *ListConnectionsReq) GetSubsystem() string {
	if x != nil {
		return x.Subsystem
	}
	return ""
}

func (x *ListConnectionsReq) GetClearAlerts() bool {
	if x != nil && x.ClearAlerts != nil {
		return *x.ClearAlerts
	}
	return false
}

type CreateListenerReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn            string         `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`
	HostName       string         `protobuf:"bytes,2,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	Traddr         string         `protobuf:"bytes,3,opt,name=traddr,proto3" json:"traddr,omitempty"`
	Adrfam         *AddressFamily `protobuf:"varint,5,opt,name=adrfam,proto3,enum=AddressFamily,oneof" json:"adrfam,omitempty"`
	Trsvcid        *uint32        `protobuf:"varint,6,opt,name=trsvcid,proto3,oneof" json:"trsvcid,omitempty"`
	Secure         *bool          `protobuf:"varint,7,opt,name=secure,proto3,oneof" json:"secure,omitempty"`
	VerifyHostName *bool          `protobuf:"varint,8,opt,name=verify_host_name,json=verifyHostName,proto3,oneof" json:"verify_host_name,omitempty"`
}

func (x *CreateListenerReq) Reset() {
	*x = CreateListenerReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateListenerReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateListenerReq) ProtoMessage() {}

func (x *CreateListenerReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateListenerReq.ProtoReflect.Descriptor instead.
func (*CreateListenerReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{21}
}

func (x *CreateListenerReq) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *CreateListenerReq) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *CreateListenerReq) GetTraddr() string {
	if x != nil {
		return x.Traddr
	}
	return ""
}

func (x *CreateListenerReq) GetAdrfam() AddressFamily {
	if x != nil && x.Adrfam != nil {
		return *x.Adrfam
	}
	return AddressFamily_ipv4
}

func (x *CreateListenerReq) GetTrsvcid() uint32 {
	if x != nil && x.Trsvcid != nil {
		return *x.Trsvcid
	}
	return 0
}

func (x *CreateListenerReq) GetSecure() bool {
	if x != nil && x.Secure != nil {
		return *x.Secure
	}
	return false
}

func (x *CreateListenerReq) GetVerifyHostName() bool {
	if x != nil && x.VerifyHostName != nil {
		return *x.VerifyHostName
	}
	return false
}

type DeleteListenerReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn      string         `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`
	HostName string         `protobuf:"bytes,2,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	Traddr   string         `protobuf:"bytes,3,opt,name=traddr,proto3" json:"traddr,omitempty"`
	Adrfam   *AddressFamily `protobuf:"varint,5,opt,name=adrfam,proto3,enum=AddressFamily,oneof" json:"adrfam,omitempty"`
	Trsvcid  *uint32        `protobuf:"varint,6,opt,name=trsvcid,proto3,oneof" json:"trsvcid,omitempty"`
	Force    *bool          `protobuf:"varint,7,opt,name=force,proto3,oneof" json:"force,omitempty"`
}

func (x *DeleteListenerReq) Reset() {
	*x = DeleteListenerReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteListenerReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteListenerReq) ProtoMessage() {}

func (x *DeleteListenerReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteListenerReq.ProtoReflect.Descriptor instead.
func (*DeleteListenerReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{22}
}

func (x *DeleteListenerReq) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *DeleteListenerReq) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *DeleteListenerReq) GetTraddr() string {
	if x != nil {
		return x.Traddr
	}
	return ""
}

func (x *DeleteListenerReq) GetAdrfam() AddressFamily {
	if x != nil && x.Adrfam != nil {
		return *x.Adrfam
	}
	return AddressFamily_ipv4
}

func (x *DeleteListenerReq) GetTrsvcid() uint32 {
	if x != nil && x.Trsvcid != nil {
		return *x.Trsvcid
	}
	return 0
}

func (x *DeleteListenerReq) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

type ListListenersReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subsystem string `protobuf:"bytes,1,opt,name=subsystem,proto3" json:"subsystem,omitempty"`
}

func (x *ListListenersReq) Reset() {
	*x = ListListenersReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListListenersReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListListenersReq) ProtoMessage() {}

func (x *ListListenersReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListListenersReq.ProtoReflect.Descriptor instead.
func (*ListListenersReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{23}
}

func (x *ListListenersReq) GetSubsystem() string {
	if x != nil {
		return x.Subsystem
	}
	return ""
}

type ListSubsystemsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn *string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3,oneof" json:"subsystem_nqn,omitempty"`
	SerialNumber *string `protobuf:"bytes,2,opt,name=serial_number,json=serialNumber,proto3,oneof" json:"serial_number,omitempty"`
}

func (x *ListSubsystemsReq) Reset() {
	*x = ListSubsystemsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubsystemsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubsystemsReq) ProtoMessage() {}

func (x *ListSubsystemsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubsystemsReq.ProtoReflect.Descriptor instead.
func (*ListSubsystemsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{24}
}

func (x *ListSubsystemsReq) GetSubsystemNqn() string {
	if x != nil && x.SubsystemNqn != nil {
		return *x.SubsystemNqn
	}
	return ""
}

func (x *ListSubsystemsReq) GetSerialNumber() string {
	if x != nil && x.SerialNumber != nil {
		return *x.SerialNumber
	}
	return ""
}

type GetSubsystemsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetSubsystemsReq) Reset() {
	*x = GetSubsystemsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSubsystemsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSubsystemsReq) ProtoMessage() {}

func (x *GetSubsystemsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSubsystemsReq.ProtoReflect.Descriptor instead.
func (*GetSubsystemsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{25}
}

type GetSpdkNvmfLogFlagsAndLevelReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AllLogFlags *bool `protobuf:"varint,1,opt,name=all_log_flags,json=allLogFlags,proto3,oneof" json:"all_log_flags,omitempty"`
}

func (x *GetSpdkNvmfLogFlagsAndLevelReq) Reset() {
	*x = GetSpdkNvmfLogFlagsAndLevelReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSpdkNvmfLogFlagsAndLevelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpdkNvmfLogFlagsAndLevelReq) ProtoMessage() {}

func (x *GetSpdkNvmfLogFlagsAndLevelReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpdkNvmfLogFlagsAndLevelReq.ProtoReflect.Descriptor instead.
func (*GetSpdkNvmfLogFlagsAndLevelReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{26}
}

func (x *GetSpdkNvmfLogFlagsAndLevelReq) GetAllLogFlags() bool {
	if x != nil && x.AllLogFlags != nil {
		return *x.AllLogFlags
	}
	return false
}

type DisableSpdkNvmfLogsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ExtraLogFlags []string `protobuf:"bytes,1,rep,name=extra_log_flags,json=extraLogFlags,proto3" json:"extra_log_flags,omitempty"`
}

func (x *DisableSpdkNvmfLogsReq) Reset() {
	*x = DisableSpdkNvmfLogsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableSpdkNvmfLogsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableSpdkNvmfLogsReq) ProtoMessage() {}

func (x *DisableSpdkNvmfLogsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableSpdkNvmfLogsReq.ProtoReflect.Descriptor instead.
func (*DisableSpdkNvmfLogsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{27}
}

func (x *DisableSpdkNvmfLogsReq) GetExtraLogFlags() []string {
	if x != nil {
		return x.ExtraLogFlags
	}
	return nil
}

type SetSpdkNvmfLogsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogLevel      *LogLevel `protobuf:"varint,1,opt,name=log_level,json=logLevel,proto3,enum=LogLevel,oneof" json:"log_level,omitempty"`
	PrintLevel    *LogLevel `protobuf:"varint,2,opt,name=print_level,json=printLevel,proto3,enum=LogLevel,oneof" json:"print_level,omitempty"`
	ExtraLogFlags []string  `protobuf:"bytes,3,rep,name=extra_log_flags,json=extraLogFlags,proto3" json:"extra_log_flags,omitempty"`
}

func (x *SetSpdkNvmfLogsReq) Reset() {
	*x = SetSpdkNvmfLogsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSpdkNvmfLogsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSpdkNvmfLogsReq) ProtoMessage() {}

func (x *SetSpdkNvmfLogsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSpdkNvmfLogsReq.ProtoReflect.Descriptor instead.
func (*SetSpdkNvmfLogsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{28}
}

func (x *SetSpdkNvmfLogsReq) GetLogLevel() LogLevel {
	if x != nil && x.LogLevel != nil {
		return *x.LogLevel
	}
	return LogLevel_ERROR
}

func (x *SetSpdkNvmfLogsReq) GetPrintLevel() LogLevel {
	if x != nil && x.PrintLevel != nil {
		return *x.PrintLevel
	}
	return LogLevel_ERROR
}

func (x *SetSpdkNvmfLogsReq) GetExtraLogFlags() []string {
	if x != nil {
		return x.ExtraLogFlags
	}
	return nil
}

type GetGatewayInfoReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CliVersion *string `protobuf:"bytes,1,opt,name=cli_version,json=cliVersion,proto3,oneof" json:"cli_version,omitempty"`
}

func (x *GetGatewayInfoReq) Reset() {
	*x = GetGatewayInfoReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayInfoReq) ProtoMessage() {}

func (x *GetGatewayInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayInfoReq.ProtoReflect.Descriptor instead.
func (*GetGatewayInfoReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{29}
}

func (x *GetGatewayInfoReq) GetCliVersion() string {
	if x != nil && x.CliVersion != nil {
		return *x.CliVersion
	}
	return ""
}

type GetGatewayLogLevelReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetGatewayLogLevelReq) Reset() {
	*x = GetGatewayLogLevelReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayLogLevelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayLogLevelReq) ProtoMessage() {}

func (x *GetGatewayLogLevelReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayLogLevelReq.ProtoReflect.Descriptor instead.
func (*GetGatewayLogLevelReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{30}
}

type SetGatewayLogLevelReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogLevel GwLogLevel `protobuf:"varint,1,opt,name=log_level,json=logLevel,proto3,enum=GwLogLevel" json:"log_level,omitempty"`
}

func (x *SetGatewayLogLevelReq) Reset() {
	*x = SetGatewayLogLevelReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetGatewayLogLevelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGatewayLogLevelReq) ProtoMessage() {}

func (x *SetGatewayLogLevelReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGatewayLogLevelReq.ProtoReflect.Descriptor instead.
func (*SetGatewayLogLevelReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{31}
}

func (x *SetGatewayLogLevelReq) GetLogLevel() GwLogLevel {
	if x != nil {
		return x.LogLevel
	}
	return GwLogLevel_notset
}

type ShowGatewayListenersInfoReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubsystemNqn string `protobuf:"bytes,1,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
}

func (x *ShowGatewayListenersInfoReq) Reset() {
	*x = ShowGatewayListenersInfoReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowGatewayListenersInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowGatewayListenersInfoReq) ProtoMessage() {}

func (x *ShowGatewayListenersInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowGatewayListenersInfoReq.ProtoReflect.Descriptor instead.
func (*ShowGatewayListenersInfoReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{32}
}

func (x *ShowGatewayListenersInfoReq) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

type GetGatewayStatsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetGatewayStatsReq) Reset() {
	*x = GetGatewayStatsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayStatsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayStatsReq) ProtoMessage() {}

func (x *GetGatewayStatsReq) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayStatsReq.ProtoReflect.Descriptor instead.
func (*GetGatewayStatsReq) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{33}
}

type AnaGroupState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GrpId uint32   `protobuf:"varint,1,opt,name=grp_id,json=grpId,proto3" json:"grp_id,omitempty"`  // groupd id
	State AnaState `protobuf:"varint,2,opt,name=state,proto3,enum=AnaState" json:"state,omitempty"` // ANA state
}

func (x *AnaGroupState) Reset() {
	*x = AnaGroupState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnaGroupState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnaGroupState) ProtoMessage() {}

func (x *AnaGroupState) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnaGroupState.ProtoReflect.Descriptor instead.
func (*AnaGroupState) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{34}
}

func (x *AnaGroupState) GetGrpId() uint32 {
	if x != nil {
		return x.GrpId
	}
	return 0
}

func (x *AnaGroupState) GetState() AnaState {
	if x != nil {
		return x.State
	}
	return AnaState_UNSET
}

type NqnAnaStates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn    string           `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`       // subsystem nqn
	States []*AnaGroupState `protobuf:"bytes,2,rep,name=states,proto3" json:"states,omitempty"` // list of group states
}

func (x *NqnAnaStates) Reset() {
	*x = NqnAnaStates{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NqnAnaStates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NqnAnaStates) ProtoMessage() {}

func (x *NqnAnaStates) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NqnAnaStates.ProtoReflect.Descriptor instead.
func (*NqnAnaStates) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{35}
}

func (x *NqnAnaStates) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *NqnAnaStates) GetStates() []*AnaGroupState {
	if x != nil {
		return x.States
	}
	return nil
}

type AnaInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	States []*NqnAnaStates `protobuf:"bytes,1,rep,name=states,proto3" json:"states,omitempty"` // list of nqn states
}

func (x *AnaInfo) Reset() {
	*x = AnaInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnaInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnaInfo) ProtoMessage() {}

func (x *AnaInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnaInfo.ProtoReflect.Descriptor instead.
func (*AnaInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{36}
}

func (x *AnaInfo) GetStates() []*NqnAnaStates {
	if x != nil {
		return x.States
	}
	return nil
}

type ReqStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32  `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *ReqStatus) Reset() {
	*x = ReqStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReqStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReqStatus) ProtoMessage() {}

func (x *ReqStatus) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReqStatus.ProtoReflect.Descriptor instead.
func (*ReqStatus) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{37}
}

func (x *ReqStatus) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *ReqStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

type SubsysStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32  `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Nqn          string `protobuf:"bytes,3,opt,name=nqn,proto3" json:"nqn,omitempty"`
}

func (x *SubsysStatus) Reset() {
	*x = SubsysStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubsysStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubsysStatus) ProtoMessage() {}

func (x *SubsysStatus) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubsysStatus.ProtoReflect.Descriptor instead.
func (*SubsysStatus) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{38}
}

func (x *SubsysStatus) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *SubsysStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *SubsysStatus) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

type NsidStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32  `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Nsid         uint32 `protobuf:"varint,3,opt,name=nsid,proto3" json:"nsid,omitempty"`
}

func (x *NsidStatus) Reset() {
	*x = NsidStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NsidStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NsidStatus) ProtoMessage() {}

func (x *NsidStatus) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NsidStatus.ProtoReflect.Descriptor instead.
func (*NsidStatus) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{39}
}

func (x *NsidStatus) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *NsidStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *NsidStatus) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

type SubsystemsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subsystems []*Subsystem `protobuf:"bytes,1,rep,name=subsystems,proto3" json:"subsystems,omitempty"`
}

func (x *SubsystemsInfo) Reset() {
	*x = SubsystemsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubsystemsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubsystemsInfo) ProtoMessage() {}

func (x *SubsystemsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubsystemsInfo.ProtoReflect.Descriptor instead.
func (*SubsystemsInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{40}
}

func (x *SubsystemsInfo) GetSubsystems() []*Subsystem {
	if x != nil {
		return x.Subsystems
	}
	return nil
}

type Subsystem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn             string           `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`
	Subtype         string           `protobuf:"bytes,2,opt,name=subtype,proto3" json:"subtype,omitempty"`
	ListenAddresses []*ListenAddress `protobuf:"bytes,3,rep,name=listen_addresses,json=listenAddresses,proto3" json:"listen_addresses,omitempty"`
	Hosts           []*Host          `protobuf:"bytes,4,rep,name=hosts,proto3" json:"hosts,omitempty"`
	AllowAnyHost    bool             `protobuf:"varint,5,opt,name=allow_any_host,json=allowAnyHost,proto3" json:"allow_any_host,omitempty"`
	SerialNumber    *string          `protobuf:"bytes,6,opt,name=serial_number,json=serialNumber,proto3,oneof" json:"serial_number,omitempty"`
	ModelNumber     *string          `protobuf:"bytes,7,opt,name=model_number,json=modelNumber,proto3,oneof" json:"model_number,omitempty"`
	MaxNamespaces   *uint32          `protobuf:"varint,8,opt,name=max_namespaces,json=maxNamespaces,proto3,oneof" json:"max_namespaces,omitempty"`
	MinCntlid       *uint32          `protobuf:"varint,9,opt,name=min_cntlid,json=minCntlid,proto3,oneof" json:"min_cntlid,omitempty"`
	MaxCntlid       *uint32          `protobuf:"varint,10,opt,name=max_cntlid,json=maxCntlid,proto3,oneof" json:"max_cntlid,omitempty"`
	Namespaces      []*Namespace     `protobuf:"bytes,11,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	HasDhchapKey    *bool            `protobuf:"varint,12,opt,name=has_dhchap_key,json=hasDhchapKey,proto3,oneof" json:"has_dhchap_key,omitempty"`
}

func (x *Subsystem) Reset() {
	*x = Subsystem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subsystem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subsystem) ProtoMessage() {}

func (x *Subsystem) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subsystem.ProtoReflect.Descriptor instead.
func (*Subsystem) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{41}
}

func (x *Subsystem) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *Subsystem) GetSubtype() string {
	if x != nil {
		return x.Subtype
	}
	return ""
}

func (x *Subsystem) GetListenAddresses() []*ListenAddress {
	if x != nil {
		return x.ListenAddresses
	}
	return nil
}

func (x *Subsystem) GetHosts() []*Host {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *Subsystem) GetAllowAnyHost() bool {
	if x != nil {
		return x.AllowAnyHost
	}
	return false
}

func (x *Subsystem) GetSerialNumber() string {
	if x != nil && x.SerialNumber != nil {
		return *x.SerialNumber
	}
	return ""
}

func (x *Subsystem) GetModelNumber() string {
	if x != nil && x.ModelNumber != nil {
		return *x.ModelNumber
	}
	return ""
}

func (x *Subsystem) GetMaxNamespaces() uint32 {
	if x != nil && x.MaxNamespaces != nil {
		return *x.MaxNamespaces
	}
	return 0
}

func (x *Subsystem) GetMinCntlid() uint32 {
	if x != nil && x.MinCntlid != nil {
		return *x.MinCntlid
	}
	return 0
}

func (x *Subsystem) GetMaxCntlid() uint32 {
	if x != nil && x.MaxCntlid != nil {
		return *x.MaxCntlid
	}
	return 0
}

func (x *Subsystem) GetNamespaces() []*Namespace {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

func (x *Subsystem) GetHasDhchapKey() bool {
	if x != nil && x.HasDhchapKey != nil {
		return *x.HasDhchapKey
	}
	return false
}

type ListenAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Trtype    string  `protobuf:"bytes,1,opt,name=trtype,proto3" json:"trtype,omitempty"`
	Adrfam    string  `protobuf:"bytes,2,opt,name=adrfam,proto3" json:"adrfam,omitempty"`
	Traddr    string  `protobuf:"bytes,3,opt,name=traddr,proto3" json:"traddr,omitempty"`
	Trsvcid   string  `protobuf:"bytes,4,opt,name=trsvcid,proto3" json:"trsvcid,omitempty"`
	Transport *string `protobuf:"bytes,5,opt,name=transport,proto3,oneof" json:"transport,omitempty"`
	Secure    *bool   `protobuf:"varint,6,opt,name=secure,proto3,oneof" json:"secure,omitempty"`
}

func (x *ListenAddress) Reset() {
	*x = ListenAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenAddress) ProtoMessage() {}

func (x *ListenAddress) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenAddress.ProtoReflect.Descriptor instead.
func (*ListenAddress) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{42}
}

func (x *ListenAddress) GetTrtype() string {
	if x != nil {
		return x.Trtype
	}
	return ""
}

func (x *ListenAddress) GetAdrfam() string {
	if x != nil {
		return x.Adrfam
	}
	return ""
}

func (x *ListenAddress) GetTraddr() string {
	if x != nil {
		return x.Traddr
	}
	return ""
}

func (x *ListenAddress) GetTrsvcid() string {
	if x != nil {
		return x.Trsvcid
	}
	return ""
}

func (x *ListenAddress) GetTransport() string {
	if x != nil && x.Transport != nil {
		return *x.Transport
	}
	return ""
}

func (x *ListenAddress) GetSecure() bool {
	if x != nil && x.Secure != nil {
		return *x.Secure
	}
	return false
}

type Namespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nsid        uint32   `protobuf:"varint,1,opt,name=nsid,proto3" json:"nsid,omitempty"`
	Name        string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	BdevName    *string  `protobuf:"bytes,3,opt,name=bdev_name,json=bdevName,proto3,oneof" json:"bdev_name,omitempty"`
	Nguid       *string  `protobuf:"bytes,4,opt,name=nguid,proto3,oneof" json:"nguid,omitempty"`
	Uuid        *string  `protobuf:"bytes,5,opt,name=uuid,proto3,oneof" json:"uuid,omitempty"`
	Anagrpid    *uint32  `protobuf:"varint,6,opt,name=anagrpid,proto3,oneof" json:"anagrpid,omitempty"`
	Nonce       *string  `protobuf:"bytes,7,opt,name=nonce,proto3,oneof" json:"nonce,omitempty"`
	AutoVisible *bool    `protobuf:"varint,8,opt,name=auto_visible,json=autoVisible,proto3,oneof" json:"auto_visible,omitempty"`
	Hosts       []string `protobuf:"bytes,9,rep,name=hosts,proto3" json:"hosts,omitempty"`
}

func (x *Namespace) Reset() {
	*x = Namespace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Namespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespace) ProtoMessage() {}

func (x *Namespace) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespace.ProtoReflect.Descriptor instead.
func (*Namespace) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{43}
}

func (x *Namespace) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *Namespace) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Namespace) GetBdevName() string {
	if x != nil && x.BdevName != nil {
		return *x.BdevName
	}
	return ""
}

func (x *Namespace) GetNguid() string {
	if x != nil && x.Nguid != nil {
		return *x.Nguid
	}
	return ""
}

func (x *Namespace) GetUuid() string {
	if x != nil && x.Uuid != nil {
		return *x.Uuid
	}
	return ""
}

func (x *Namespace) GetAnagrpid() uint32 {
	if x != nil && x.Anagrpid != nil {
		return *x.Anagrpid
	}
	return 0
}

func (x *Namespace) GetNonce() string {
	if x != nil && x.Nonce != nil {
		return *x.Nonce
	}
	return ""
}

func (x *Namespace) GetAutoVisible() bool {
	if x != nil && x.AutoVisible != nil {
		return *x.AutoVisible
	}
	return false
}

func (x *Namespace) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

type SubsystemsInfoCli struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32           `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string          `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Subsystems   []*SubsystemCli `protobuf:"bytes,3,rep,name=subsystems,proto3" json:"subsystems,omitempty"`
}

func (x *SubsystemsInfoCli) Reset() {
	*x = SubsystemsInfoCli{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubsystemsInfoCli) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubsystemsInfoCli) ProtoMessage() {}

func (x *SubsystemsInfoCli) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubsystemsInfoCli.ProtoReflect.Descriptor instead.
func (*SubsystemsInfoCli) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{44}
}

func (x *SubsystemsInfoCli) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *SubsystemsInfoCli) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *SubsystemsInfoCli) GetSubsystems() []*SubsystemCli {
	if x != nil {
		return x.Subsystems
	}
	return nil
}

type SubsystemCli struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn               string `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`
	EnableHa          bool   `protobuf:"varint,2,opt,name=enable_ha,json=enableHa,proto3" json:"enable_ha,omitempty"`
	SerialNumber      string `protobuf:"bytes,3,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	ModelNumber       string `protobuf:"bytes,4,opt,name=model_number,json=modelNumber,proto3" json:"model_number,omitempty"`
	MinCntlid         uint32 `protobuf:"varint,5,opt,name=min_cntlid,json=minCntlid,proto3" json:"min_cntlid,omitempty"`
	MaxCntlid         uint32 `protobuf:"varint,6,opt,name=max_cntlid,json=maxCntlid,proto3" json:"max_cntlid,omitempty"`
	NamespaceCount    uint32 `protobuf:"varint,7,opt,name=namespace_count,json=namespaceCount,proto3" json:"namespace_count,omitempty"`
	Subtype           string `protobuf:"bytes,8,opt,name=subtype,proto3" json:"subtype,omitempty"`
	MaxNamespaces     uint32 `protobuf:"varint,9,opt,name=max_namespaces,json=maxNamespaces,proto3" json:"max_namespaces,omitempty"`
	HasDhchapKey      *bool  `protobuf:"varint,10,opt,name=has_dhchap_key,json=hasDhchapKey,proto3,oneof" json:"has_dhchap_key,omitempty"`
	AllowAnyHost      *bool  `protobuf:"varint,11,opt,name=allow_any_host,json=allowAnyHost,proto3,oneof" json:"allow_any_host,omitempty"`
	CreatedWithoutKey *bool  `protobuf:"varint,12,opt,name=created_without_key,json=createdWithoutKey,proto3,oneof" json:"created_without_key,omitempty"`
}

func (x *SubsystemCli) Reset() {
	*x = SubsystemCli{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubsystemCli) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubsystemCli) ProtoMessage() {}

func (x *SubsystemCli) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubsystemCli.ProtoReflect.Descriptor instead.
func (*SubsystemCli) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{45}
}

func (x *SubsystemCli) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *SubsystemCli) GetEnableHa() bool {
	if x != nil {
		return x.EnableHa
	}
	return false
}

func (x *SubsystemCli) GetSerialNumber() string {
	if x != nil {
		return x.SerialNumber
	}
	return ""
}

func (x *SubsystemCli) GetModelNumber() string {
	if x != nil {
		return x.ModelNumber
	}
	return ""
}

func (x *SubsystemCli) GetMinCntlid() uint32 {
	if x != nil {
		return x.MinCntlid
	}
	return 0
}

func (x *SubsystemCli) GetMaxCntlid() uint32 {
	if x != nil {
		return x.MaxCntlid
	}
	return 0
}

func (x *SubsystemCli) GetNamespaceCount() uint32 {
	if x != nil {
		return x.NamespaceCount
	}
	return 0
}

func (x *SubsystemCli) GetSubtype() string {
	if x != nil {
		return x.Subtype
	}
	return ""
}

func (x *SubsystemCli) GetMaxNamespaces() uint32 {
	if x != nil {
		return x.MaxNamespaces
	}
	return 0
}

func (x *SubsystemCli) GetHasDhchapKey() bool {
	if x != nil && x.HasDhchapKey != nil {
		return *x.HasDhchapKey
	}
	return false
}

func (x *SubsystemCli) GetAllowAnyHost() bool {
	if x != nil && x.AllowAnyHost != nil {
		return *x.AllowAnyHost
	}
	return false
}

func (x *SubsystemCli) GetCreatedWithoutKey() bool {
	if x != nil && x.CreatedWithoutKey != nil {
		return *x.CreatedWithoutKey
	}
	return false
}

type GatewayInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CliVersion                string  `protobuf:"bytes,1,opt,name=cli_version,json=cliVersion,proto3" json:"cli_version,omitempty"`
	Version                   string  `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Name                      string  `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Group                     string  `protobuf:"bytes,4,opt,name=group,proto3" json:"group,omitempty"`
	Addr                      string  `protobuf:"bytes,5,opt,name=addr,proto3" json:"addr,omitempty"`
	Port                      string  `protobuf:"bytes,6,opt,name=port,proto3" json:"port,omitempty"`
	BoolStatus                bool    `protobuf:"varint,7,opt,name=bool_status,json=boolStatus,proto3" json:"bool_status,omitempty"`
	Status                    int32   `protobuf:"varint,8,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage              string  `protobuf:"bytes,9,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	SpdkVersion               *string `protobuf:"bytes,10,opt,name=spdk_version,json=spdkVersion,proto3,oneof" json:"spdk_version,omitempty"`
	LoadBalancingGroup        uint32  `protobuf:"varint,11,opt,name=load_balancing_group,json=loadBalancingGroup,proto3" json:"load_balancing_group,omitempty"`
	Hostname                  string  `protobuf:"bytes,12,opt,name=hostname,proto3" json:"hostname,omitempty"`
	MaxSubsystems             *uint32 `protobuf:"varint,13,opt,name=max_subsystems,json=maxSubsystems,proto3,oneof" json:"max_subsystems,omitempty"`
	MaxNamespaces             *uint32 `protobuf:"varint,14,opt,name=max_namespaces,json=maxNamespaces,proto3,oneof" json:"max_namespaces,omitempty"`
	MaxHostsPerSubsystem      *uint32 `protobuf:"varint,15,opt,name=max_hosts_per_subsystem,json=maxHostsPerSubsystem,proto3,oneof" json:"max_hosts_per_subsystem,omitempty"`
	MaxNamespacesPerSubsystem *uint32 `protobuf:"varint,16,opt,name=max_namespaces_per_subsystem,json=maxNamespacesPerSubsystem,proto3,oneof" json:"max_namespaces_per_subsystem,omitempty"`
	MaxHosts                  *uint32 `protobuf:"varint,17,opt,name=max_hosts,json=maxHosts,proto3,oneof" json:"max_hosts,omitempty"`
	GatewayInitializationOver *bool   `protobuf:"varint,18,opt,name=gateway_initialization_over,json=gatewayInitializationOver,proto3,oneof" json:"gateway_initialization_over,omitempty"`
}

func (x *GatewayInfo) Reset() {
	*x = GatewayInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayInfo) ProtoMessage() {}

func (x *GatewayInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayInfo.ProtoReflect.Descriptor instead.
func (*GatewayInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{46}
}

func (x *GatewayInfo) GetCliVersion() string {
	if x != nil {
		return x.CliVersion
	}
	return ""
}

func (x *GatewayInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GatewayInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GatewayInfo) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *GatewayInfo) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

func (x *GatewayInfo) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *GatewayInfo) GetBoolStatus() bool {
	if x != nil {
		return x.BoolStatus
	}
	return false
}

func (x *GatewayInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *GatewayInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *GatewayInfo) GetSpdkVersion() string {
	if x != nil && x.SpdkVersion != nil {
		return *x.SpdkVersion
	}
	return ""
}

func (x *GatewayInfo) GetLoadBalancingGroup() uint32 {
	if x != nil {
		return x.LoadBalancingGroup
	}
	return 0
}

func (x *GatewayInfo) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *GatewayInfo) GetMaxSubsystems() uint32 {
	if x != nil && x.MaxSubsystems != nil {
		return *x.MaxSubsystems
	}
	return 0
}

func (x *GatewayInfo) GetMaxNamespaces() uint32 {
	if x != nil && x.MaxNamespaces != nil {
		return *x.MaxNamespaces
	}
	return 0
}

func (x *GatewayInfo) GetMaxHostsPerSubsystem() uint32 {
	if x != nil && x.MaxHostsPerSubsystem != nil {
		return *x.MaxHostsPerSubsystem
	}
	return 0
}

func (x *GatewayInfo) GetMaxNamespacesPerSubsystem() uint32 {
	if x != nil && x.MaxNamespacesPerSubsystem != nil {
		return *x.MaxNamespacesPerSubsystem
	}
	return 0
}

func (x *GatewayInfo) GetMaxHosts() uint32 {
	if x != nil && x.MaxHosts != nil {
		return *x.MaxHosts
	}
	return 0
}

func (x *GatewayInfo) GetGatewayInitializationOver() bool {
	if x != nil && x.GatewayInitializationOver != nil {
		return *x.GatewayInitializationOver
	}
	return false
}

type CliVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32  `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Version      string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *CliVersion) Reset() {
	*x = CliVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CliVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CliVersion) ProtoMessage() {}

func (x *CliVersion) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CliVersion.ProtoReflect.Descriptor instead.
func (*CliVersion) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{47}
}

func (x *CliVersion) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *CliVersion) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *CliVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GwVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32  `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Version      string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GwVersion) Reset() {
	*x = GwVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GwVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GwVersion) ProtoMessage() {}

func (x *GwVersion) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GwVersion.ProtoReflect.Descriptor instead.
func (*GwVersion) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{48}
}

func (x *GwVersion) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *GwVersion) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *GwVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type PollGroupTransportInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Trtype string `protobuf:"bytes,1,opt,name=trtype,proto3" json:"trtype,omitempty"`
}

func (x *PollGroupTransportInfo) Reset() {
	*x = PollGroupTransportInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollGroupTransportInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollGroupTransportInfo) ProtoMessage() {}

func (x *PollGroupTransportInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollGroupTransportInfo.ProtoReflect.Descriptor instead.
func (*PollGroupTransportInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{49}
}

func (x *PollGroupTransportInfo) GetTrtype() string {
	if x != nil {
		return x.Trtype
	}
	return ""
}

type PollGroupInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name               string                    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	AdminQpairs        uint32                    `protobuf:"varint,2,opt,name=admin_qpairs,json=adminQpairs,proto3" json:"admin_qpairs,omitempty"`
	IoQpairs           uint32                    `protobuf:"varint,3,opt,name=io_qpairs,json=ioQpairs,proto3" json:"io_qpairs,omitempty"`
	CurrentAdminQpairs uint32                    `protobuf:"varint,4,opt,name=current_admin_qpairs,json=currentAdminQpairs,proto3" json:"current_admin_qpairs,omitempty"`
	CurrentIoQpairs    uint32                    `protobuf:"varint,5,opt,name=current_io_qpairs,json=currentIoQpairs,proto3" json:"current_io_qpairs,omitempty"`
	PendingBdevIo      uint64                    `protobuf:"varint,6,opt,name=pending_bdev_io,json=pendingBdevIo,proto3" json:"pending_bdev_io,omitempty"`
	CompletedNvmeIo    uint64                    `protobuf:"varint,7,opt,name=completed_nvme_io,json=completedNvmeIo,proto3" json:"completed_nvme_io,omitempty"`
	Transports         []*PollGroupTransportInfo `protobuf:"bytes,8,rep,name=transports,proto3" json:"transports,omitempty"`
}

func (x *PollGroupInfo) Reset() {
	*x = PollGroupInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollGroupInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollGroupInfo) ProtoMessage() {}

func (x *PollGroupInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollGroupInfo.ProtoReflect.Descriptor instead.
func (*PollGroupInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{50}
}

func (x *PollGroupInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PollGroupInfo) GetAdminQpairs() uint32 {
	if x != nil {
		return x.AdminQpairs
	}
	return 0
}

func (x *PollGroupInfo) GetIoQpairs() uint32 {
	if x != nil {
		return x.IoQpairs
	}
	return 0
}

func (x *PollGroupInfo) GetCurrentAdminQpairs() uint32 {
	if x != nil {
		return x.CurrentAdminQpairs
	}
	return 0
}

func (x *PollGroupInfo) GetCurrentIoQpairs() uint32 {
	if x != nil {
		return x.CurrentIoQpairs
	}
	return 0
}

func (x *PollGroupInfo) GetPendingBdevIo() uint64 {
	if x != nil {
		return x.PendingBdevIo
	}
	return 0
}

func (x *PollGroupInfo) GetCompletedNvmeIo() uint64 {
	if x != nil {
		return x.CompletedNvmeIo
	}
	return 0
}

func (x *PollGroupInfo) GetTransports() []*PollGroupTransportInfo {
	if x != nil {
		return x.Transports
	}
	return nil
}

type GatewayStatsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32            `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string           `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	TickRate     uint64           `protobuf:"varint,3,opt,name=tick_rate,json=tickRate,proto3" json:"tick_rate,omitempty"`
	PollGroups   []*PollGroupInfo `protobuf:"bytes,4,rep,name=poll_groups,json=pollGroups,proto3" json:"poll_groups,omitempty"`
}

func (x *GatewayStatsInfo) Reset() {
	*x = GatewayStatsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayStatsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayStatsInfo) ProtoMessage() {}

func (x *GatewayStatsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayStatsInfo.ProtoReflect.Descriptor instead.
func (*GatewayStatsInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{51}
}

func (x *GatewayStatsInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *GatewayStatsInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *GatewayStatsInfo) GetTickRate() uint64 {
	if x != nil {
		return x.TickRate
	}
	return 0
}

func (x *GatewayStatsInfo) GetPollGroups() []*PollGroupInfo {
	if x != nil {
		return x.PollGroups
	}
	return nil
}

type ListenerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HostName string        `protobuf:"bytes,1,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	Trtype   string        `protobuf:"bytes,2,opt,name=trtype,proto3" json:"trtype,omitempty"`
	Adrfam   AddressFamily `protobuf:"varint,3,opt,name=adrfam,proto3,enum=AddressFamily" json:"adrfam,omitempty"`
	Traddr   string        `protobuf:"bytes,4,opt,name=traddr,proto3" json:"traddr,omitempty"`
	Trsvcid  uint32        `protobuf:"varint,5,opt,name=trsvcid,proto3" json:"trsvcid,omitempty"`
	Secure   *bool         `protobuf:"varint,6,opt,name=secure,proto3,oneof" json:"secure,omitempty"`
	Active   *bool         `protobuf:"varint,7,opt,name=active,proto3,oneof" json:"active,omitempty"`
	Manual   *bool         `protobuf:"varint,8,opt,name=manual,proto3,oneof" json:"manual,omitempty"`
}

func (x *ListenerInfo) Reset() {
	*x = ListenerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerInfo) ProtoMessage() {}

func (x *ListenerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerInfo.ProtoReflect.Descriptor instead.
func (*ListenerInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{52}
}

func (x *ListenerInfo) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *ListenerInfo) GetTrtype() string {
	if x != nil {
		return x.Trtype
	}
	return ""
}

func (x *ListenerInfo) GetAdrfam() AddressFamily {
	if x != nil {
		return x.Adrfam
	}
	return AddressFamily_ipv4
}

func (x *ListenerInfo) GetTraddr() string {
	if x != nil {
		return x.Traddr
	}
	return ""
}

func (x *ListenerInfo) GetTrsvcid() uint32 {
	if x != nil {
		return x.Trsvcid
	}
	return 0
}

func (x *ListenerInfo) GetSecure() bool {
	if x != nil && x.Secure != nil {
		return *x.Secure
	}
	return false
}

func (x *ListenerInfo) GetActive() bool {
	if x != nil && x.Active != nil {
		return *x.Active
	}
	return false
}

func (x *ListenerInfo) GetManual() bool {
	if x != nil && x.Manual != nil {
		return *x.Manual
	}
	return false
}

type ListenersInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32           `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string          `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Listeners    []*ListenerInfo `protobuf:"bytes,3,rep,name=listeners,proto3" json:"listeners,omitempty"`
}

func (x *ListenersInfo) Reset() {
	*x = ListenersInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenersInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenersInfo) ProtoMessage() {}

func (x *ListenersInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenersInfo.ProtoReflect.Descriptor instead.
func (*ListenersInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{53}
}

func (x *ListenersInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *ListenersInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *ListenersInfo) GetListeners() []*ListenerInfo {
	if x != nil {
		return x.Listeners
	}
	return nil
}

type GatewayListenerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Listener *ListenerInfo    `protobuf:"bytes,1,opt,name=listener,proto3" json:"listener,omitempty"`
	LbStates []*AnaGroupState `protobuf:"bytes,2,rep,name=lb_states,json=lbStates,proto3" json:"lb_states,omitempty"`
}

func (x *GatewayListenerInfo) Reset() {
	*x = GatewayListenerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayListenerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayListenerInfo) ProtoMessage() {}

func (x *GatewayListenerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayListenerInfo.ProtoReflect.Descriptor instead.
func (*GatewayListenerInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{54}
}

func (x *GatewayListenerInfo) GetListener() *ListenerInfo {
	if x != nil {
		return x.Listener
	}
	return nil
}

func (x *GatewayListenerInfo) GetLbStates() []*AnaGroupState {
	if x != nil {
		return x.LbStates
	}
	return nil
}

type GatewayListenersInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32                  `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string                 `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	GwListeners  []*GatewayListenerInfo `protobuf:"bytes,3,rep,name=gw_listeners,json=gwListeners,proto3" json:"gw_listeners,omitempty"`
}

func (x *GatewayListenersInfo) Reset() {
	*x = GatewayListenersInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayListenersInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayListenersInfo) ProtoMessage() {}

func (x *GatewayListenersInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayListenersInfo.ProtoReflect.Descriptor instead.
func (*GatewayListenersInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{55}
}

func (x *GatewayListenersInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *GatewayListenersInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *GatewayListenersInfo) GetGwListeners() []*GatewayListenerInfo {
	if x != nil {
		return x.GwListeners
	}
	return nil
}

type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn                               string `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`
	UsePsk                            *bool  `protobuf:"varint,2,opt,name=use_psk,json=usePsk,proto3,oneof" json:"use_psk,omitempty"`
	UseDhchap                         *bool  `protobuf:"varint,3,opt,name=use_dhchap,json=useDhchap,proto3,oneof" json:"use_dhchap,omitempty"`
	DisconnectedDueToKeepaliveTimeout *bool  `protobuf:"varint,4,opt,name=disconnected_due_to_keepalive_timeout,json=disconnectedDueToKeepaliveTimeout,proto3,oneof" json:"disconnected_due_to_keepalive_timeout,omitempty"`
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{56}
}

func (x *Host) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *Host) GetUsePsk() bool {
	if x != nil && x.UsePsk != nil {
		return *x.UsePsk
	}
	return false
}

func (x *Host) GetUseDhchap() bool {
	if x != nil && x.UseDhchap != nil {
		return *x.UseDhchap
	}
	return false
}

func (x *Host) GetDisconnectedDueToKeepaliveTimeout() bool {
	if x != nil && x.DisconnectedDueToKeepaliveTimeout != nil {
		return *x.DisconnectedDueToKeepaliveTimeout
	}
	return false
}

type HostsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32   `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string  `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	AllowAnyHost bool    `protobuf:"varint,3,opt,name=allow_any_host,json=allowAnyHost,proto3" json:"allow_any_host,omitempty"`
	SubsystemNqn string  `protobuf:"bytes,4,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Hosts        []*Host `protobuf:"bytes,5,rep,name=hosts,proto3" json:"hosts,omitempty"`
}

func (x *HostsInfo) Reset() {
	*x = HostsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HostsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostsInfo) ProtoMessage() {}

func (x *HostsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostsInfo.ProtoReflect.Descriptor instead.
func (*HostsInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{57}
}

func (x *HostsInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *HostsInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *HostsInfo) GetAllowAnyHost() bool {
	if x != nil {
		return x.AllowAnyHost
	}
	return false
}

func (x *HostsInfo) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *HostsInfo) GetHosts() []*Host {
	if x != nil {
		return x.Hosts
	}
	return nil
}

type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nqn                               string        `protobuf:"bytes,1,opt,name=nqn,proto3" json:"nqn,omitempty"`
	Traddr                            string        `protobuf:"bytes,2,opt,name=traddr,proto3" json:"traddr,omitempty"`
	Trsvcid                           uint32        `protobuf:"varint,3,opt,name=trsvcid,proto3" json:"trsvcid,omitempty"`
	Trtype                            string        `protobuf:"bytes,4,opt,name=trtype,proto3" json:"trtype,omitempty"`
	Adrfam                            AddressFamily `protobuf:"varint,5,opt,name=adrfam,proto3,enum=AddressFamily" json:"adrfam,omitempty"`
	Connected                         bool          `protobuf:"varint,6,opt,name=connected,proto3" json:"connected,omitempty"`
	QpairsCount                       int32         `protobuf:"varint,7,opt,name=qpairs_count,json=qpairsCount,proto3" json:"qpairs_count,omitempty"`
	ControllerId                      int32         `protobuf:"varint,8,opt,name=controller_id,json=controllerId,proto3" json:"controller_id,omitempty"`
	Secure                            *bool         `protobuf:"varint,9,opt,name=secure,proto3,oneof" json:"secure,omitempty"`
	UsePsk                            *bool         `protobuf:"varint,10,opt,name=use_psk,json=usePsk,proto3,oneof" json:"use_psk,omitempty"`
	UseDhchap                         *bool         `protobuf:"varint,11,opt,name=use_dhchap,json=useDhchap,proto3,oneof" json:"use_dhchap,omitempty"`
	Subsystem                         *string       `protobuf:"bytes,12,opt,name=subsystem,proto3,oneof" json:"subsystem,omitempty"`
	DisconnectedDueToKeepaliveTimeout *bool         `protobuf:"varint,13,opt,name=disconnected_due_to_keepalive_timeout,json=disconnectedDueToKeepaliveTimeout,proto3,oneof" json:"disconnected_due_to_keepalive_timeout,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{58}
}

func (x *Connection) GetNqn() string {
	if x != nil {
		return x.Nqn
	}
	return ""
}

func (x *Connection) GetTraddr() string {
	if x != nil {
		return x.Traddr
	}
	return ""
}

func (x *Connection) GetTrsvcid() uint32 {
	if x != nil {
		return x.Trsvcid
	}
	return 0
}

func (x *Connection) GetTrtype() string {
	if x != nil {
		return x.Trtype
	}
	return ""
}

func (x *Connection) GetAdrfam() AddressFamily {
	if x != nil {
		return x.Adrfam
	}
	return AddressFamily_ipv4
}

func (x *Connection) GetConnected() bool {
	if x != nil {
		return x.Connected
	}
	return false
}

func (x *Connection) GetQpairsCount() int32 {
	if x != nil {
		return x.QpairsCount
	}
	return 0
}

func (x *Connection) GetControllerId() int32 {
	if x != nil {
		return x.ControllerId
	}
	return 0
}

func (x *Connection) GetSecure() bool {
	if x != nil && x.Secure != nil {
		return *x.Secure
	}
	return false
}

func (x *Connection) GetUsePsk() bool {
	if x != nil && x.UsePsk != nil {
		return *x.UsePsk
	}
	return false
}

func (x *Connection) GetUseDhchap() bool {
	if x != nil && x.UseDhchap != nil {
		return *x.UseDhchap
	}
	return false
}

func (x *Connection) GetSubsystem() string {
	if x != nil && x.Subsystem != nil {
		return *x.Subsystem
	}
	return ""
}

func (x *Connection) GetDisconnectedDueToKeepaliveTimeout() bool {
	if x != nil && x.DisconnectedDueToKeepaliveTimeout != nil {
		return *x.DisconnectedDueToKeepaliveTimeout
	}
	return false
}

type ConnectionsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32         `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string        `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	SubsystemNqn string        `protobuf:"bytes,3,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Connections  []*Connection `protobuf:"bytes,4,rep,name=connections,proto3" json:"connections,omitempty"`
}

func (x *ConnectionsInfo) Reset() {
	*x = ConnectionsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionsInfo) ProtoMessage() {}

func (x *ConnectionsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionsInfo.ProtoReflect.Descriptor instead.
func (*ConnectionsInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{59}
}

func (x *ConnectionsInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *ConnectionsInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *ConnectionsInfo) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *ConnectionsInfo) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

type NamespaceCli struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nsid                         uint32   `protobuf:"varint,1,opt,name=nsid,proto3" json:"nsid,omitempty"`
	BdevName                     string   `protobuf:"bytes,2,opt,name=bdev_name,json=bdevName,proto3" json:"bdev_name,omitempty"`
	RbdImageName                 string   `protobuf:"bytes,3,opt,name=rbd_image_name,json=rbdImageName,proto3" json:"rbd_image_name,omitempty"`
	RbdPoolName                  string   `protobuf:"bytes,4,opt,name=rbd_pool_name,json=rbdPoolName,proto3" json:"rbd_pool_name,omitempty"`
	LoadBalancingGroup           uint32   `protobuf:"varint,5,opt,name=load_balancing_group,json=loadBalancingGroup,proto3" json:"load_balancing_group,omitempty"`
	BlockSize                    uint32   `protobuf:"varint,6,opt,name=block_size,json=blockSize,proto3" json:"block_size,omitempty"`
	RbdImageSize                 uint64   `protobuf:"varint,7,opt,name=rbd_image_size,json=rbdImageSize,proto3" json:"rbd_image_size,omitempty"`
	Uuid                         string   `protobuf:"bytes,8,opt,name=uuid,proto3" json:"uuid,omitempty"`
	RwIosPerSecond               uint64   `protobuf:"varint,9,opt,name=rw_ios_per_second,json=rwIosPerSecond,proto3" json:"rw_ios_per_second,omitempty"`
	RwMbytesPerSecond            uint64   `protobuf:"varint,10,opt,name=rw_mbytes_per_second,json=rwMbytesPerSecond,proto3" json:"rw_mbytes_per_second,omitempty"`
	RMbytesPerSecond             uint64   `protobuf:"varint,11,opt,name=r_mbytes_per_second,json=rMbytesPerSecond,proto3" json:"r_mbytes_per_second,omitempty"`
	WMbytesPerSecond             uint64   `protobuf:"varint,12,opt,name=w_mbytes_per_second,json=wMbytesPerSecond,proto3" json:"w_mbytes_per_second,omitempty"`
	AutoVisible                  bool     `protobuf:"varint,13,opt,name=auto_visible,json=autoVisible,proto3" json:"auto_visible,omitempty"`
	Hosts                        []string `protobuf:"bytes,14,rep,name=hosts,proto3" json:"hosts,omitempty"`
	NsSubsystemNqn               *string  `protobuf:"bytes,15,opt,name=ns_subsystem_nqn,json=nsSubsystemNqn,proto3,oneof" json:"ns_subsystem_nqn,omitempty"`
	TrashImage                   *bool    `protobuf:"varint,16,opt,name=trash_image,json=trashImage,proto3,oneof" json:"trash_image,omitempty"`
	DisableAutoResize            *bool    `protobuf:"varint,17,opt,name=disable_auto_resize,json=disableAutoResize,proto3,oneof" json:"disable_auto_resize,omitempty"`
	ReadOnly                     *bool    `protobuf:"varint,18,opt,name=read_only,json=readOnly,proto3,oneof" json:"read_only,omitempty"`
	ClusterName                  *string  `protobuf:"bytes,19,opt,name=cluster_name,json=clusterName,proto3,oneof" json:"cluster_name,omitempty"`
	ConfiguredLoadBalancingGroup *uint32  `protobuf:"varint,20,opt,name=configured_load_balancing_group,json=configuredLoadBalancingGroup,proto3,oneof" json:"configured_load_balancing_group,omitempty"`
	ImageWasShrunk               *bool    `protobuf:"varint,21,opt,name=image_was_shrunk,json=imageWasShrunk,proto3,oneof" json:"image_was_shrunk,omitempty"`
	RbdDataPoolName              *string  `protobuf:"bytes,22,opt,name=rbd_data_pool_name,json=rbdDataPoolName,proto3,oneof" json:"rbd_data_pool_name,omitempty"`
	Location                     *string  `protobuf:"bytes,23,opt,name=location,proto3,oneof" json:"location,omitempty"`
	RadosNamespaceName           *string  `protobuf:"bytes,24,opt,name=rados_namespace_name,json=radosNamespaceName,proto3,oneof" json:"rados_namespace_name,omitempty"`
}

func (x *NamespaceCli) Reset() {
	*x = NamespaceCli{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceCli) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceCli) ProtoMessage() {}

func (x *NamespaceCli) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceCli.ProtoReflect.Descriptor instead.
func (*NamespaceCli) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{60}
}

func (x *NamespaceCli) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceCli) GetBdevName() string {
	if x != nil {
		return x.BdevName
	}
	return ""
}

func (x *NamespaceCli) GetRbdImageName() string {
	if x != nil {
		return x.RbdImageName
	}
	return ""
}

func (x *NamespaceCli) GetRbdPoolName() string {
	if x != nil {
		return x.RbdPoolName
	}
	return ""
}

func (x *NamespaceCli) GetLoadBalancingGroup() uint32 {
	if x != nil {
		return x.LoadBalancingGroup
	}
	return 0
}

func (x *NamespaceCli) GetBlockSize() uint32 {
	if x != nil {
		return x.BlockSize
	}
	return 0
}

func (x *NamespaceCli) GetRbdImageSize() uint64 {
	if x != nil {
		return x.RbdImageSize
	}
	return 0
}

func (x *NamespaceCli) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *NamespaceCli) GetRwIosPerSecond() uint64 {
	if x != nil {
		return x.RwIosPerSecond
	}
	return 0
}

func (x *NamespaceCli) GetRwMbytesPerSecond() uint64 {
	if x != nil {
		return x.RwMbytesPerSecond
	}
	return 0
}

func (x *NamespaceCli) GetRMbytesPerSecond() uint64 {
	if x != nil {
		return x.RMbytesPerSecond
	}
	return 0
}

func (x *NamespaceCli) GetWMbytesPerSecond() uint64 {
	if x != nil {
		return x.WMbytesPerSecond
	}
	return 0
}

func (x *NamespaceCli) GetAutoVisible() bool {
	if x != nil {
		return x.AutoVisible
	}
	return false
}

func (x *NamespaceCli) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *NamespaceCli) GetNsSubsystemNqn() string {
	if x != nil && x.NsSubsystemNqn != nil {
		return *x.NsSubsystemNqn
	}
	return ""
}

func (x *NamespaceCli) GetTrashImage() bool {
	if x != nil && x.TrashImage != nil {
		return *x.TrashImage
	}
	return false
}

func (x *NamespaceCli) GetDisableAutoResize() bool {
	if x != nil && x.DisableAutoResize != nil {
		return *x.DisableAutoResize
	}
	return false
}

func (x *NamespaceCli) GetReadOnly() bool {
	if x != nil && x.ReadOnly != nil {
		return *x.ReadOnly
	}
	return false
}

func (x *NamespaceCli) GetClusterName() string {
	if x != nil && x.ClusterName != nil {
		return *x.ClusterName
	}
	return ""
}

func (x *NamespaceCli) GetConfiguredLoadBalancingGroup() uint32 {
	if x != nil && x.ConfiguredLoadBalancingGroup != nil {
		return *x.ConfiguredLoadBalancingGroup
	}
	return 0
}

func (x *NamespaceCli) GetImageWasShrunk() bool {
	if x != nil && x.ImageWasShrunk != nil {
		return *x.ImageWasShrunk
	}
	return false
}

func (x *NamespaceCli) GetRbdDataPoolName() string {
	if x != nil && x.RbdDataPoolName != nil {
		return *x.RbdDataPoolName
	}
	return ""
}

func (x *NamespaceCli) GetLocation() string {
	if x != nil && x.Location != nil {
		return *x.Location
	}
	return ""
}

func (x *NamespaceCli) GetRadosNamespaceName() string {
	if x != nil && x.RadosNamespaceName != nil {
		return *x.RadosNamespaceName
	}
	return ""
}

type NamespacesInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32           `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string          `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	SubsystemNqn string          `protobuf:"bytes,3,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Namespaces   []*NamespaceCli `protobuf:"bytes,4,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
}

func (x *NamespacesInfo) Reset() {
	*x = NamespacesInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespacesInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespacesInfo) ProtoMessage() {}

func (x *NamespacesInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespacesInfo.ProtoReflect.Descriptor instead.
func (*NamespacesInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{61}
}

func (x *NamespacesInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *NamespacesInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *NamespacesInfo) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespacesInfo) GetNamespaces() []*NamespaceCli {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

type NamespaceIoError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value uint32 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *NamespaceIoError) Reset() {
	*x = NamespaceIoError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceIoError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceIoError) ProtoMessage() {}

func (x *NamespaceIoError) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceIoError.ProtoReflect.Descriptor instead.
func (*NamespaceIoError) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{62}
}

func (x *NamespaceIoError) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NamespaceIoError) GetValue() uint32 {
	if x != nil {
		return x.Value
	}
	return 0
}

type NamespaceIoStatsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status               int32               `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage         string              `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	SubsystemNqn         string              `protobuf:"bytes,3,opt,name=subsystem_nqn,json=subsystemNqn,proto3" json:"subsystem_nqn,omitempty"`
	Nsid                 uint32              `protobuf:"varint,4,opt,name=nsid,proto3" json:"nsid,omitempty"`
	Uuid                 *string             `protobuf:"bytes,5,opt,name=uuid,proto3,oneof" json:"uuid,omitempty"`
	BdevName             string              `protobuf:"bytes,6,opt,name=bdev_name,json=bdevName,proto3" json:"bdev_name,omitempty"`
	TickRate             uint64              `protobuf:"varint,7,opt,name=tick_rate,json=tickRate,proto3" json:"tick_rate,omitempty"`
	Ticks                uint64              `protobuf:"varint,8,opt,name=ticks,proto3" json:"ticks,omitempty"`
	BytesRead            uint64              `protobuf:"varint,9,opt,name=bytes_read,json=bytesRead,proto3" json:"bytes_read,omitempty"`
	NumReadOps           uint64              `protobuf:"varint,10,opt,name=num_read_ops,json=numReadOps,proto3" json:"num_read_ops,omitempty"`
	BytesWritten         uint64              `protobuf:"varint,11,opt,name=bytes_written,json=bytesWritten,proto3" json:"bytes_written,omitempty"`
	NumWriteOps          uint64              `protobuf:"varint,12,opt,name=num_write_ops,json=numWriteOps,proto3" json:"num_write_ops,omitempty"`
	BytesUnmapped        uint64              `protobuf:"varint,13,opt,name=bytes_unmapped,json=bytesUnmapped,proto3" json:"bytes_unmapped,omitempty"`
	NumUnmapOps          uint64              `protobuf:"varint,14,opt,name=num_unmap_ops,json=numUnmapOps,proto3" json:"num_unmap_ops,omitempty"`
	ReadLatencyTicks     uint64              `protobuf:"varint,15,opt,name=read_latency_ticks,json=readLatencyTicks,proto3" json:"read_latency_ticks,omitempty"`
	MaxReadLatencyTicks  uint64              `protobuf:"varint,16,opt,name=max_read_latency_ticks,json=maxReadLatencyTicks,proto3" json:"max_read_latency_ticks,omitempty"`
	MinReadLatencyTicks  uint64              `protobuf:"varint,17,opt,name=min_read_latency_ticks,json=minReadLatencyTicks,proto3" json:"min_read_latency_ticks,omitempty"`
	WriteLatencyTicks    uint64              `protobuf:"varint,18,opt,name=write_latency_ticks,json=writeLatencyTicks,proto3" json:"write_latency_ticks,omitempty"`
	MaxWriteLatencyTicks uint64              `protobuf:"varint,19,opt,name=max_write_latency_ticks,json=maxWriteLatencyTicks,proto3" json:"max_write_latency_ticks,omitempty"`
	MinWriteLatencyTicks uint64              `protobuf:"varint,20,opt,name=min_write_latency_ticks,json=minWriteLatencyTicks,proto3" json:"min_write_latency_ticks,omitempty"`
	UnmapLatencyTicks    uint64              `protobuf:"varint,21,opt,name=unmap_latency_ticks,json=unmapLatencyTicks,proto3" json:"unmap_latency_ticks,omitempty"`
	MaxUnmapLatencyTicks uint64              `protobuf:"varint,22,opt,name=max_unmap_latency_ticks,json=maxUnmapLatencyTicks,proto3" json:"max_unmap_latency_ticks,omitempty"`
	MinUnmapLatencyTicks uint64              `protobuf:"varint,23,opt,name=min_unmap_latency_ticks,json=minUnmapLatencyTicks,proto3" json:"min_unmap_latency_ticks,omitempty"`
	CopyLatencyTicks     uint64              `protobuf:"varint,24,opt,name=copy_latency_ticks,json=copyLatencyTicks,proto3" json:"copy_latency_ticks,omitempty"`
	MaxCopyLatencyTicks  uint64              `protobuf:"varint,25,opt,name=max_copy_latency_ticks,json=maxCopyLatencyTicks,proto3" json:"max_copy_latency_ticks,omitempty"`
	MinCopyLatencyTicks  uint64              `protobuf:"varint,26,opt,name=min_copy_latency_ticks,json=minCopyLatencyTicks,proto3" json:"min_copy_latency_ticks,omitempty"`
	IoError              []*NamespaceIoError `protobuf:"bytes,27,rep,name=io_error,json=ioError,proto3" json:"io_error,omitempty"`
}

func (x *NamespaceIoStatsInfo) Reset() {
	*x = NamespaceIoStatsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceIoStatsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceIoStatsInfo) ProtoMessage() {}

func (x *NamespaceIoStatsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceIoStatsInfo.ProtoReflect.Descriptor instead.
func (*NamespaceIoStatsInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{63}
}

func (x *NamespaceIoStatsInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *NamespaceIoStatsInfo) GetSubsystemNqn() string {
	if x != nil {
		return x.SubsystemNqn
	}
	return ""
}

func (x *NamespaceIoStatsInfo) GetNsid() uint32 {
	if x != nil {
		return x.Nsid
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetUuid() string {
	if x != nil && x.Uuid != nil {
		return *x.Uuid
	}
	return ""
}

func (x *NamespaceIoStatsInfo) GetBdevName() string {
	if x != nil {
		return x.BdevName
	}
	return ""
}

func (x *NamespaceIoStatsInfo) GetTickRate() uint64 {
	if x != nil {
		return x.TickRate
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetTicks() uint64 {
	if x != nil {
		return x.Ticks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetBytesRead() uint64 {
	if x != nil {
		return x.BytesRead
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetNumReadOps() uint64 {
	if x != nil {
		return x.NumReadOps
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetBytesWritten() uint64 {
	if x != nil {
		return x.BytesWritten
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetNumWriteOps() uint64 {
	if x != nil {
		return x.NumWriteOps
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetBytesUnmapped() uint64 {
	if x != nil {
		return x.BytesUnmapped
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetNumUnmapOps() uint64 {
	if x != nil {
		return x.NumUnmapOps
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetReadLatencyTicks() uint64 {
	if x != nil {
		return x.ReadLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMaxReadLatencyTicks() uint64 {
	if x != nil {
		return x.MaxReadLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMinReadLatencyTicks() uint64 {
	if x != nil {
		return x.MinReadLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetWriteLatencyTicks() uint64 {
	if x != nil {
		return x.WriteLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMaxWriteLatencyTicks() uint64 {
	if x != nil {
		return x.MaxWriteLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMinWriteLatencyTicks() uint64 {
	if x != nil {
		return x.MinWriteLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetUnmapLatencyTicks() uint64 {
	if x != nil {
		return x.UnmapLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMaxUnmapLatencyTicks() uint64 {
	if x != nil {
		return x.MaxUnmapLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMinUnmapLatencyTicks() uint64 {
	if x != nil {
		return x.MinUnmapLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetCopyLatencyTicks() uint64 {
	if x != nil {
		return x.CopyLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMaxCopyLatencyTicks() uint64 {
	if x != nil {
		return x.MaxCopyLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetMinCopyLatencyTicks() uint64 {
	if x != nil {
		return x.MinCopyLatencyTicks
	}
	return 0
}

func (x *NamespaceIoStatsInfo) GetIoError() []*NamespaceIoError {
	if x != nil {
		return x.IoError
	}
	return nil
}

type SpdkLogFlagInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Enabled bool   `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *SpdkLogFlagInfo) Reset() {
	*x = SpdkLogFlagInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpdkLogFlagInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpdkLogFlagInfo) ProtoMessage() {}

func (x *SpdkLogFlagInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpdkLogFlagInfo.ProtoReflect.Descriptor instead.
func (*SpdkLogFlagInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{64}
}

func (x *SpdkLogFlagInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SpdkLogFlagInfo) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type SpdkNvmfLogFlagsAndLevelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status        int32              `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage  string             `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	NvmfLogFlags  []*SpdkLogFlagInfo `protobuf:"bytes,3,rep,name=nvmf_log_flags,json=nvmfLogFlags,proto3" json:"nvmf_log_flags,omitempty"`
	LogLevel      LogLevel           `protobuf:"varint,4,opt,name=log_level,json=logLevel,proto3,enum=LogLevel" json:"log_level,omitempty"`
	LogPrintLevel LogLevel           `protobuf:"varint,5,opt,name=log_print_level,json=logPrintLevel,proto3,enum=LogLevel" json:"log_print_level,omitempty"`
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) Reset() {
	*x = SpdkNvmfLogFlagsAndLevelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpdkNvmfLogFlagsAndLevelInfo) ProtoMessage() {}

func (x *SpdkNvmfLogFlagsAndLevelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpdkNvmfLogFlagsAndLevelInfo.ProtoReflect.Descriptor instead.
func (*SpdkNvmfLogFlagsAndLevelInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{65}
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) GetNvmfLogFlags() []*SpdkLogFlagInfo {
	if x != nil {
		return x.NvmfLogFlags
	}
	return nil
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) GetLogLevel() LogLevel {
	if x != nil {
		return x.LogLevel
	}
	return LogLevel_ERROR
}

func (x *SpdkNvmfLogFlagsAndLevelInfo) GetLogPrintLevel() LogLevel {
	if x != nil {
		return x.LogPrintLevel
	}
	return LogLevel_ERROR
}

type GatewayLogLevelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status       int32      `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	ErrorMessage string     `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	LogLevel     GwLogLevel `protobuf:"varint,3,opt,name=log_level,json=logLevel,proto3,enum=GwLogLevel" json:"log_level,omitempty"`
}

func (x *GatewayLogLevelInfo) Reset() {
	*x = GatewayLogLevelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gateway_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayLogLevelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayLogLevelInfo) ProtoMessage() {}

func (x *GatewayLogLevelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gateway_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayLogLevelInfo.ProtoReflect.Descriptor instead.
func (*GatewayLogLevelInfo) Descriptor() ([]byte, []int) {
	return file_gateway_proto_rawDescGZIP(), []int{66}
}

func (x *GatewayLogLevelInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *GatewayLogLevelInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *GatewayLogLevelInfo) GetLogLevel() GwLogLevel {
	if x != nil {
		return x.LogLevel
	}
	return GwLogLevel_notset
}

var File_gateway_proto protoreflect.FileDescriptor

var file_gateway_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xce, 0x06, 0x0a, 0x11, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64,
	0x64, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x22, 0x0a, 0x0d, 0x72, 0x62, 0x64, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x62,
	0x64, 0x50, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x62, 0x64,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x62, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a,
	0x0a, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x75, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x04, 0x75, 0x75,
	0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x67, 0x72, 0x70, 0x69,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x67, 0x72,
	0x70, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x17,
	0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x48, 0x04, 0x52, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x6f, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x06, 0x52, 0x0d, 0x6e,
	0x6f, 0x41, 0x75, 0x74, 0x6f, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x07, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x73, 0x68, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x08, 0x52, 0x11, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x48, 0x09, 0x52,
	0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x12,
	0x72, 0x62, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0a, 0x52, 0x0f, 0x72, 0x62, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1f,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x0b, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x35, 0x0a, 0x14, 0x72, 0x61, 0x64, 0x6f, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c, 0x52,
	0x12, 0x72, 0x61, 0x64, 0x6f, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x73, 0x69, 0x64, 0x42,
	0x07, 0x0a, 0x05, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x61, 0x6e, 0x61,
	0x67, 0x72, 0x70, 0x69, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6e, 0x6f,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x16, 0x0a,
	0x14, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72,
	0x65, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x62, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x72, 0x61, 0x64, 0x6f,
	0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa6, 0x01, 0x0a, 0x14, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73,
	0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75,
	0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x4f, 0x42, 0x53,
	0x4f, 0x4c, 0x45, 0x54, 0x45, 0x55, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x08,
	0x6e, 0x65, 0x77, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x6e, 0x65, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x4f, 0x42, 0x53, 0x4f,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x22, 0x91, 0x01, 0x0a, 0x1a, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x6f, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69,
	0x64, 0x12, 0x28, 0x0a, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75, 0x75,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x4f, 0x42, 0x53, 0x4f,
	0x4c, 0x45, 0x54, 0x45, 0x55, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f,
	0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x22, 0xde, 0x03,
	0x0a, 0x15, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x71, 0x6f, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64,
	0x12, 0x28, 0x0a, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75, 0x75, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x4f, 0x42, 0x53, 0x4f, 0x4c,
	0x45, 0x54, 0x45, 0x55, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x11, 0x72, 0x77,
	0x5f, 0x69, 0x6f, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x04, 0x48, 0x01, 0x52, 0x0e, 0x72, 0x77, 0x49, 0x6f, 0x73, 0x50, 0x65,
	0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x14, 0x72, 0x77,
	0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x48, 0x02, 0x52, 0x11, 0x72, 0x77, 0x4d, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x32, 0x0a, 0x13, 0x72, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x48, 0x03, 0x52,
	0x10, 0x72, 0x4d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x13, 0x77, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x04, 0x48, 0x04, 0x52, 0x10, 0x77, 0x4d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45,
	0x5f, 0x75, 0x75, 0x69, 0x64, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x77, 0x5f, 0x69, 0x6f, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x42, 0x17, 0x0a, 0x15, 0x5f,
	0x72, 0x77, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x72, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x42, 0x16, 0x0a, 0x14,
	0x5f, 0x77, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xf7,
	0x01, 0x0a, 0x29, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x6e, 0x73, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54,
	0x45, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c,
	0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x55, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x1a, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x67, 0x72, 0x70, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x67, 0x72, 0x70, 0x69, 0x64, 0x12, 0x27, 0x0a, 0x0d, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x6c, 0x62, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x01, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x4c, 0x62, 0x4c, 0x6f, 0x67, 0x69,
	0x63, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54,
	0x45, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x6c, 0x62, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x22, 0xa2, 0x01, 0x0a, 0x1f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x6e, 0x73, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x61, 0x75, 0x74,
	0x6f, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x86, 0x01,
	0x0a, 0x1d, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0x0a, 0x21, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x72, 0x62, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x73,
	0x68, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04,
	0x6e, 0x73, 0x69, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x73, 0x68,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x79, 0x0a, 0x1d, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65,
	0x22, 0xba, 0x01, 0x0a, 0x14, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73,
	0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75,
	0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x4f, 0x42, 0x53,
	0x4f, 0x4c, 0x45, 0x54, 0x45, 0x55, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x09,
	0x69, 0x5f, 0x61, 0x6d, 0x5f, 0x73, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x01, 0x52, 0x07, 0x69, 0x41, 0x6d, 0x53, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x69, 0x5f, 0x61, 0x6d, 0x5f, 0x73, 0x75, 0x72, 0x65, 0x22, 0x91, 0x01,
	0x0a, 0x16, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69,
	0x64, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x71, 0x6e, 0x12, 0x19, 0x0a, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x22, 0x6f, 0x0a, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x6e, 0x71, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x4e,
	0x71, 0x6e, 0x22, 0xea, 0x03, 0x0a, 0x14, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x75,
	0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52,
	0x0d, 0x6d, 0x61, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x61, 0x12, 0x2b,
	0x0a, 0x0f, 0x6e, 0x6f, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x0d, 0x6e, 0x6f, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x64,
	0x68, 0x63, 0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x02, 0x52, 0x09, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12,
	0x28, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0c, 0x6b, 0x65, 0x79, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x04, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x73, 0x6b, 0x88, 0x01,
	0x01, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x0f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x88, 0x01,
	0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6e, 0x6f, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x64, 0x68, 0x63,
	0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x22,
	0x8f, 0x01, 0x0a, 0x14, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x19, 0x0a,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x09, 0x69, 0x5f, 0x61, 0x6d,
	0x5f, 0x73, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x07, 0x69,
	0x41, 0x6d, 0x53, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x69, 0x5f, 0x61, 0x6d, 0x5f, 0x73, 0x75, 0x72,
	0x65, 0x22, 0x72, 0x0a, 0x18, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a,
	0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e,
	0x71, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70,
	0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61,
	0x70, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x77, 0x0a, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x1c, 0x0a, 0x09,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x73,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64,
	0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x01, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x6e, 0x73, 0x69, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x22, 0x98,
	0x02, 0x0a, 0x0c, 0x61, 0x64, 0x64, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x71, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x71, 0x6e, 0x12,
	0x15, 0x0a, 0x03, 0x70, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03,
	0x70, 0x73, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x09, 0x64, 0x68,
	0x63, 0x68, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x73,
	0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x02, 0x52, 0x0c, 0x70, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0c, 0x6b,
	0x65, 0x79, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x70, 0x73, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61,
	0x70, 0x5f, 0x6b, 0x65, 0x79, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x73, 0x6b, 0x5f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x22, 0x88, 0x01, 0x0a, 0x13, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65,
	0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e,
	0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e,
	0x71, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x71,
	0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x4b,
	0x65, 0x79, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70,
	0x5f, 0x6b, 0x65, 0x79, 0x22, 0x51, 0x0a, 0x0f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x68,
	0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x68, 0x6f, 0x73, 0x74, 0x4e, 0x71, 0x6e, 0x22, 0x67, 0x0a, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75,
	0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x65, 0x61, 0x72,
	0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x0b, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x88, 0x01, 0x01, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73,
	0x22, 0x6d, 0x0a, 0x14, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b,
	0x63, 0x6c, 0x65, 0x61, 0x72, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0f,
	0x0a, 0x0d, 0x5f, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x22,
	0xab, 0x02, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6e, 0x71, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72, 0x12, 0x2b,
	0x0a, 0x06, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e,
	0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x48, 0x00,
	0x52, 0x06, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x74,
	0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x01, 0x52, 0x07,
	0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x06, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x03, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x48, 0x6f, 0x73, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x61, 0x64, 0x72, 0x66, 0x61,
	0x6d, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x42, 0x09, 0x0a,
	0x07, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe4, 0x01,
	0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6e, 0x71, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72, 0x12, 0x2b, 0x0a, 0x06,
	0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x48, 0x00, 0x52, 0x06,
	0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x74, 0x72, 0x73,
	0x76, 0x63, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x01, 0x52, 0x07, 0x74, 0x72,
	0x73, 0x76, 0x63, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x42, 0x0a,
	0x0a, 0x08, 0x5f, 0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x22, 0x32, 0x0a, 0x12, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75,
	0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x22, 0x8d, 0x01, 0x0a, 0x13, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x71,
	0x12, 0x28, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x14, 0x0a, 0x12, 0x67, 0x65, 0x74, 0x5f,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x22, 0x62,
	0x0a, 0x25, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f,
	0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x5f, 0x6c,
	0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x4c, 0x6f, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x88, 0x01, 0x01,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x22, 0x44, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70,
	0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x72, 0x65, 0x71,
	0x12, 0x26, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x4c, 0x6f, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x16, 0x73, 0x65, 0x74,
	0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f,
	0x72, 0x65, 0x71, 0x12, 0x2b, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x48, 0x00, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01,
	0x12, 0x2f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x48, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01,
	0x01, 0x12, 0x26, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x72,
	0x61, 0x4c, 0x6f, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x4c, 0x0a, 0x14, 0x67, 0x65, 0x74, 0x5f, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x72, 0x65, 0x71, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6c, 0x69, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x1b, 0x0a, 0x19, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x72,
	0x65, 0x71, 0x22, 0x45, 0x0a, 0x19, 0x73, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x12,
	0x28, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x0b, 0x2e, 0x47, 0x77, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x46, 0x0a, 0x1f, 0x73, 0x68, 0x6f,
	0x77, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x72, 0x65, 0x71, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71,
	0x6e, 0x22, 0x17, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x22, 0x4a, 0x0a, 0x0f, 0x61, 0x6e,
	0x61, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x06, 0x67, 0x72, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x67,
	0x72, 0x70, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x0a, 0x2e, 0x61, 0x6e, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x4c, 0x0a, 0x0e, 0x6e, 0x71, 0x6e, 0x5f, 0x61, 0x6e,
	0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6e, 0x71, 0x6e, 0x12, 0x28, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x6e, 0x61,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x73, 0x22, 0x33, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x12, 0x27, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x6e, 0x71, 0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x22, 0x49, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0x5e, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6e, 0x71, 0x6e, 0x22, 0x5e, 0x0a, 0x0b, 0x6e, 0x73, 0x69, 0x64, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04,
	0x6e, 0x73, 0x69, 0x64, 0x22, 0x3d, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x2a, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x73, 0x22, 0xba, 0x04, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6e, 0x71, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a,
	0x10, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x05, 0x68, 0x6f, 0x73,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x05, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x52,
	0x05, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x61, 0x6e, 0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6e, 0x79, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x2a,
	0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x69,
	0x6e, 0x5f, 0x63, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x03,
	0x52, 0x09, 0x6d, 0x69, 0x6e, 0x43, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x22,
	0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0d, 0x48, 0x04, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x43, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x88,
	0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x29,
	0x0a, 0x0e, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x0c, 0x68, 0x61, 0x73, 0x44, 0x68, 0x63,
	0x68, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x0f, 0x0a, 0x0d, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x11, 0x0a, 0x0f,
	0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x42,
	0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x42, 0x11, 0x0a,
	0x0f, 0x5f, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79,
	0x22, 0xcb, 0x01, 0x0a, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61,
	0x64, 0x72, 0x66, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x64, 0x72,
	0x66, 0x61, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x74,
	0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72,
	0x73, 0x76, 0x63, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x70, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x06, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
	0x6f, 0x72, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x22, 0xcc,
	0x02, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x62, 0x64, 0x65, 0x76, 0x4e,
	0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x6e, 0x67, 0x75, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x6e, 0x67, 0x75, 0x69, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x02, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x6e,
	0x61, 0x67, 0x72, 0x70, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x03, 0x52, 0x08,
	0x61, 0x6e, 0x61, 0x67, 0x72, 0x70, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x6e,
	0x6f, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x05, 0x6e, 0x6f,
	0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x76,
	0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x0b,
	0x61, 0x75, 0x74, 0x6f, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x14,
	0x0a, 0x05, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x68,
	0x6f, 0x73, 0x74, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x62, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6e, 0x67, 0x75, 0x69, 0x64, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x75, 0x75, 0x69, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x61, 0x6e, 0x61, 0x67, 0x72, 0x70,
	0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x42, 0x0f, 0x0a, 0x0d,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x22, 0x82, 0x01,
	0x0a, 0x13, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x63, 0x6c, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x2e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x63, 0x6c, 0x69, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x73, 0x22, 0xf7, 0x03, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x63, 0x6c, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6e, 0x71, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x68, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x48, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x69, 0x6e, 0x5f, 0x63, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x09, 0x6d, 0x69, 0x6e, 0x43, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x61,
	0x78, 0x5f, 0x63, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09,
	0x6d, 0x61, 0x78, 0x43, 0x6e, 0x74, 0x6c, 0x69, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x62, 0x74, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x0e, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61,
	0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x68,
	0x61, 0x73, 0x44, 0x68, 0x63, 0x68, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x29,
	0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41,
	0x6e, 0x79, 0x48, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x57, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x42, 0x11,
	0x0a, 0x0f, 0x5f, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x5f, 0x6b, 0x65,
	0x79, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6e, 0x79, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0xd2, 0x06, 0x0a,
	0x0c, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x6c, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x6f,
	0x6f, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x70, 0x64, 0x6b,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x73, 0x70, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x30, 0x0a, 0x14, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12,
	0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x01, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x53, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x6d, 0x61,
	0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0d, 0x48, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x17, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x03, 0x52, 0x14, 0x6d, 0x61, 0x78, 0x48, 0x6f,
	0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x88,
	0x01, 0x01, 0x12, 0x44, 0x0a, 0x1c, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x04, 0x52, 0x19, 0x6d, 0x61, 0x78, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x05, 0x52, 0x08, 0x6d,
	0x61, 0x78, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x43, 0x0a, 0x1b, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x06, 0x52, 0x19, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x88, 0x01, 0x01, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x68,
	0x6f, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x73, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x76, 0x65,
	0x72, 0x22, 0x64, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x0a, 0x0a, 0x67, 0x77, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x33, 0x0a, 0x19,
	0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xd3, 0x02, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x71, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x70, 0x61, 0x69, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09,
	0x69, 0x6f, 0x5f, 0x71, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x69, 0x6f, 0x51, 0x70, 0x61, 0x69, 0x72, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x71, 0x70, 0x61, 0x69, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x70, 0x61, 0x69, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6f, 0x5f, 0x71, 0x70, 0x61, 0x69, 0x72, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x49,
	0x6f, 0x51, 0x70, 0x61, 0x69, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x64, 0x65, 0x76, 0x5f, 0x69, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0d, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x64, 0x65, 0x76, 0x49, 0x6f, 0x12,
	0x2a, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x76, 0x6d,
	0x65, 0x5f, 0x69, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x4e, 0x76, 0x6d, 0x65, 0x49, 0x6f, 0x12, 0x3a, 0x0a, 0x0a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x12, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74,
	0x69, 0x63, 0x6b, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x74, 0x69, 0x63, 0x6b, 0x52, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x6c,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x70, 0x6f, 0x6c, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x96, 0x02, 0x0a, 0x0d,
	0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a,
	0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x26, 0x0a, 0x06, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x46, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x52, 0x06, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x61, 0x64,
	0x64, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x07, 0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x06,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x06, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x09,
	0x0a, 0x07, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x22, 0x7b, 0x0a, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x09, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x73, 0x22, 0x72, 0x0a, 0x15, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x2a, 0x0a, 0x08, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x09, 0x6c, 0x62, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x6e, 0x61, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x08, 0x6c, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x73, 0x22, 0x90, 0x01, 0x0a, 0x16, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x39, 0x0a,
	0x0c, 0x67, 0x77, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x67, 0x77, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x22, 0xf6, 0x01, 0x0a, 0x04, 0x68, 0x6f, 0x73,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6e, 0x71, 0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x75, 0x73, 0x65, 0x50, 0x73, 0x6b, 0x88, 0x01,
	0x01, 0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x09, 0x75, 0x73, 0x65, 0x44, 0x68, 0x63, 0x68,
	0x61, 0x70, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65,
	0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x21, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x44, 0x75, 0x65, 0x54, 0x6f, 0x4b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69,
	0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x73, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x75, 0x73, 0x65,
	0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x65, 0x5f, 0x74, 0x6f, 0x5f,
	0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x22, 0xb1, 0x01, 0x0a, 0x0a, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x24, 0x0a,
	0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6e, 0x79, 0x48,
	0x6f, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x1b, 0x0a, 0x05, 0x68, 0x6f, 0x73, 0x74,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x05, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x52, 0x05,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x22, 0xad, 0x04, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x71, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6e, 0x71, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x61, 0x64, 0x64, 0x72, 0x12, 0x18,
	0x0a, 0x07, 0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x74, 0x72, 0x73, 0x76, 0x63, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x72, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x72, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x26, 0x0a, 0x06, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x0e, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x52, 0x06, 0x61, 0x64, 0x72, 0x66, 0x61, 0x6d, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x71, 0x70, 0x61, 0x69, 0x72, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x71, 0x70,
	0x61, 0x69, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x06, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x06, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x07, 0x75,
	0x73, 0x65, 0x5f, 0x70, 0x73, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x50, 0x73, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73, 0x65,
	0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52,
	0x09, 0x75, 0x73, 0x65, 0x44, 0x68, 0x63, 0x68, 0x61, 0x70, 0x88, 0x01, 0x01, 0x12, 0x21, 0x0a,
	0x09, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x03, 0x52, 0x09, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x88, 0x01, 0x01,
	0x12, 0x55, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x64, 0x75, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x04, 0x52, 0x21, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44,
	0x75, 0x65, 0x54, 0x6f, 0x4b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x73, 0x6b, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x64, 0x68, 0x63, 0x68, 0x61, 0x70, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x28, 0x0a, 0x26, 0x5f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x65,
	0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0xa3, 0x01, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x2d, 0x0a, 0x0b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0b, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb3, 0x09, 0x0a, 0x0d,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69,
	0x64, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x64, 0x65, 0x76, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24,
	0x0a, 0x0e, 0x72, 0x62, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x62, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x72, 0x62, 0x64, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x62, 0x64,
	0x50, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x62, 0x64,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x72, 0x62, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75,
	0x75, 0x69, 0x64, 0x12, 0x29, 0x0a, 0x11, 0x72, 0x77, 0x5f, 0x69, 0x6f, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e,
	0x72, 0x77, 0x49, 0x6f, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12, 0x2f,
	0x0a, 0x14, 0x72, 0x77, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x72, 0x77,
	0x4d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12,
	0x2d, 0x0a, 0x13, 0x72, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x72, 0x4d,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12, 0x2d,
	0x0a, 0x13, 0x77, 0x5f, 0x6d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x77, 0x4d, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12, 0x21, 0x0a,
	0x0c, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x6e, 0x73, 0x5f, 0x73, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x6e, 0x73, 0x53, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e,
	0x71, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x0a, 0x74, 0x72,
	0x61, 0x73, 0x68, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x11, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x20, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x88,
	0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0d, 0x48, 0x05, 0x52, 0x1c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x64, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x10, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f,
	0x77, 0x61, 0x73, 0x5f, 0x73, 0x68, 0x72, 0x75, 0x6e, 0x6b, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x06, 0x52, 0x0e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x57, 0x61, 0x73, 0x53, 0x68, 0x72, 0x75,
	0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x12, 0x72, 0x62, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x07, 0x52, 0x0f, 0x72, 0x62, 0x64, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6f, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x48, 0x08, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x61, 0x64, 0x6f,
	0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09, 0x52, 0x12, 0x72, 0x61, 0x64, 0x6f, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x6e, 0x73, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x6e, 0x71, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x22, 0x0a, 0x20, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x77, 0x61, 0x73, 0x5f, 0x73, 0x68,
	0x72, 0x75, 0x6e, 0x6b, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x62, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x72, 0x61, 0x64,
	0x6f, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa3, 0x01, 0x0a, 0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f,
	0x6e, 0x71, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x2e, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x52, 0x0a, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x22, 0x3e, 0x0a, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x6f, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xf2, 0x08, 0x0a, 0x17, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x71,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x4e, 0x71, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x04, 0x6e, 0x73, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x75, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x88,
	0x01, 0x01, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x64, 0x65, 0x76, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x69, 0x63, 0x6b, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x08, 0x74, 0x69, 0x63, 0x6b, 0x52, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x74, 0x69, 0x63,
	0x6b, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x52, 0x65, 0x61,
	0x64, 0x12, 0x20, 0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x70,
	0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x61, 0x64,
	0x4f, 0x70, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x77, 0x72, 0x69,
	0x74, 0x74, 0x65, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x57, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x5f,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0b, 0x6e, 0x75, 0x6d, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x70, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x75, 0x6e, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x55, 0x6e, 0x6d, 0x61, 0x70,
	0x70, 0x65, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x5f, 0x75, 0x6e, 0x6d, 0x61, 0x70,
	0x5f, 0x6f, 0x70, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x55,
	0x6e, 0x6d, 0x61, 0x70, 0x4f, 0x70, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x10, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x61, 0x64, 0x4c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x69,
	0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74,
	0x69, 0x63, 0x6b, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x6d, 0x69, 0x6e, 0x52,
	0x65, 0x61, 0x64, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12,
	0x2e, 0x0a, 0x13, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12,
	0x35, 0x0a, 0x17, 0x6d, 0x61, 0x78, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x14, 0x6d, 0x61, 0x78, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63,
	0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x69, 0x6e, 0x5f, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b,
	0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x04, 0x52, 0x14, 0x6d, 0x69, 0x6e, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x2e, 0x0a,
	0x13, 0x75, 0x6e, 0x6d, 0x61, 0x70, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74,
	0x69, 0x63, 0x6b, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x75, 0x6e, 0x6d, 0x61,
	0x70, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x35, 0x0a,
	0x17, 0x6d, 0x61, 0x78, 0x5f, 0x75, 0x6e, 0x6d, 0x61, 0x70, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x04, 0x52, 0x14,
	0x6d, 0x61, 0x78, 0x55, 0x6e, 0x6d, 0x61, 0x70, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54,
	0x69, 0x63, 0x6b, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x69, 0x6e, 0x5f, 0x75, 0x6e, 0x6d, 0x61,
	0x70, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x04, 0x52, 0x14, 0x6d, 0x69, 0x6e, 0x55, 0x6e, 0x6d, 0x61, 0x70, 0x4c,
	0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x63,
	0x6f, 0x70, 0x79, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b,
	0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x63, 0x6f, 0x70, 0x79, 0x4c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x78,
	0x5f, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69,
	0x63, 0x6b, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x43, 0x6f,
	0x70, 0x79, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x33,
	0x0a, 0x16, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13,
	0x6d, 0x69, 0x6e, 0x43, 0x6f, 0x70, 0x79, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69,
	0x63, 0x6b, 0x73, 0x12, 0x2e, 0x0a, 0x08, 0x69, 0x6f, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x5f, 0x69, 0x6f, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x07, 0x69, 0x6f, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x22, 0x42, 0x0a, 0x12,
	0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x22, 0xf7, 0x01, 0x0a, 0x22, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c,
	0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0e, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67,
	0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73,
	0x70, 0x64, 0x6b, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x52, 0x0c, 0x6e, 0x76, 0x6d, 0x66, 0x4c, 0x6f, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12,
	0x26, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x08, 0x6c,
	0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x5f, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x09, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0d, 0x6c, 0x6f, 0x67,
	0x50, 0x72, 0x69, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x7f, 0x0a, 0x16, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x28, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x0b, 0x2e, 0x47, 0x77, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x2a, 0x23, 0x0a, 0x0d, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x08, 0x0a, 0x04,
	0x69, 0x70, 0x76, 0x34, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x69, 0x70, 0x76, 0x36, 0x10, 0x01,
	0x2a, 0x43, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x54, 0x49, 0x43, 0x45, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45,
	0x42, 0x55, 0x47, 0x10, 0x04, 0x2a, 0x53, 0x0a, 0x0a, 0x47, 0x77, 0x4c, 0x6f, 0x67, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x0a, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x73, 0x65, 0x74, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x64, 0x65, 0x62, 0x75, 0x67, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x69, 0x6e,
	0x66, 0x6f, 0x10, 0x14, 0x12, 0x0b, 0x0a, 0x07, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x10,
	0x1e, 0x12, 0x09, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x28, 0x12, 0x0c, 0x0a, 0x08,
	0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x10, 0x32, 0x2a, 0x4a, 0x0a, 0x09, 0x61, 0x6e,
	0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x4e, 0x53, 0x45, 0x54,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x4e, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x32, 0x99, 0x12, 0x0a, 0x07, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x12, 0x33, 0x0a, 0x0d, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x12, 0x12, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0c, 0x2e, 0x6e, 0x73, 0x69, 0x64, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x3b, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x15, 0x2e, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x72,
	0x65, 0x71, 0x1a, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x00, 0x12, 0x38, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x15, 0x2e, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x1a,
	0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x40,
	0x0a, 0x14, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x6b, 0x65, 0x79, 0x12, 0x19, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65,
	0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00,
	0x12, 0x3b, 0x0a, 0x0f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x12, 0x14, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x10, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x38, 0x0a,
	0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x12, 0x15, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x51, 0x0a, 0x16, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x1b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x67, 0x65,
	0x74, 0x5f, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x18,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x6f, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x18, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x71, 0x6f, 0x73, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x16, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x71, 0x6f, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b,
	0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x62, 0x0a,
	0x25, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2a, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x72,
	0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x00, 0x12, 0x4e, 0x0a, 0x1b, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x20, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72,
	0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x00, 0x12, 0x4a, 0x0a, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b,
	0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x52, 0x0a,
	0x1d, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x72,
	0x62, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x22,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x72,
	0x62, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72,
	0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x00, 0x12, 0x4a, 0x0a, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x1e,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b,
	0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x38, 0x0a,
	0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x15, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x3c, 0x0a, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x17, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x42, 0x0a, 0x15, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x1a,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x28, 0x0a, 0x08, 0x61, 0x64, 0x64,
	0x5f, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x0d, 0x2e, 0x61, 0x64, 0x64, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x22, 0x00, 0x12, 0x2e, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x12, 0x10, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x22, 0x00, 0x12, 0x36, 0x0a, 0x0f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72,
	0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x2c, 0x0a, 0x0a, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x0f, 0x2e, 0x6c, 0x69, 0x73, 0x74,
	0x5f, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x68, 0x6f, 0x73,
	0x74, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x3e, 0x0a, 0x10, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x15, 0x2e,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x72, 0x65, 0x71, 0x1a, 0x11, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x36, 0x0a, 0x0f, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x14, 0x2e, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x72,
	0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x00, 0x12, 0x36, 0x0a, 0x0f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x65, 0x72, 0x12, 0x14, 0x2e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x38, 0x0a, 0x0e, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x13, 0x2e, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x65, 0x71,
	0x1a, 0x0f, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x22, 0x00, 0x12, 0x3f, 0x0a, 0x0f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x14, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x73, 0x75,
	0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x14, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x63,
	0x6c, 0x69, 0x22, 0x00, 0x12, 0x39, 0x0a, 0x0e, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x13, 0x2e, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x75, 0x62,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x10, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12,
	0x29, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x09, 0x2e, 0x61, 0x6e, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x0b, 0x2e, 0x72, 0x65,
	0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12, 0x72, 0x0a, 0x21, 0x67, 0x65,
	0x74, 0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x5f,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x26, 0x2e, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f,
	0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x23, 0x2e, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e,
	0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x61, 0x6e,
	0x64, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x44,
	0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e,
	0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0x1b, 0x2e, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67,
	0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x00, 0x12, 0x3c, 0x0a, 0x12, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x64, 0x6b,
	0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0x17, 0x2e, 0x73, 0x65, 0x74,
	0x5f, 0x73, 0x70, 0x64, 0x6b, 0x5f, 0x6e, 0x76, 0x6d, 0x66, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f,
	0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x22, 0x00, 0x12, 0x3a, 0x0a, 0x10, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x15, 0x2e, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x0d, 0x2e,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x4e,
	0x0a, 0x15, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1a, 0x2e, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f,
	0x72, 0x65, 0x71, 0x1a, 0x17, 0x2e, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x42,
	0x0a, 0x15, 0x73, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1a, 0x2e, 0x73, 0x65, 0x74, 0x5f, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f,
	0x72, 0x65, 0x71, 0x1a, 0x0b, 0x2e, 0x72, 0x65, 0x71, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x22, 0x00, 0x12, 0x5a, 0x0a, 0x1b, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x12, 0x20, 0x2e, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x72, 0x65, 0x71, 0x1a, 0x17, 0x2e, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x42,
	0x0a, 0x11, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x1a, 0x13, 0x2e, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x22, 0x00, 0x42, 0x2b, 0x5a, 0x29, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x63, 0x65, 0x70, 0x68, 0x2f, 0x63, 0x65, 0x70, 0x68, 0x2d, 0x6e, 0x76, 0x6d, 0x65, 0x6f,
	0x66, 0x2f, 0x6c, 0x69, 0x62, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x76, 0x6d, 0x65, 0x6f, 0x66, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_gateway_proto_rawDescOnce sync.Once
	file_gateway_proto_rawDescData = file_gateway_proto_rawDesc
)

func file_gateway_proto_rawDescGZIP() []byte {
	file_gateway_proto_rawDescOnce.Do(func() {
		file_gateway_proto_rawDescData = protoimpl.X.CompressGZIP(file_gateway_proto_rawDescData)
	})
	return file_gateway_proto_rawDescData
}

var file_gateway_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_gateway_proto_msgTypes = make([]protoimpl.MessageInfo, 67)
var file_gateway_proto_goTypes = []interface{}{
	(AddressFamily)(0),                           // 0: AddressFamily
	(LogLevel)(0),                                // 1: LogLevel
	(GwLogLevel)(0),                              // 2: GwLogLevel
	(AnaState)(0),                                // 3: ana_state
	(*NamespaceAddReq)(nil),                      // 4: namespace_add_req
	(*NamespaceResizeReq)(nil),                   // 5: namespace_resize_req
	(*NamespaceGetIoStatsReq)(nil),               // 6: namespace_get_io_stats_req
	(*NamespaceSetQosReq)(nil),                   // 7: namespace_set_qos_req
	(*NamespaceChangeLoadBalancingGroupReq)(nil), // 8: namespace_change_load_balancing_group_req
	(*NamespaceChangeVisibilityReq)(nil),         // 9: namespace_change_visibility_req
	(*NamespaceChangeLocationReq)(nil),           // 10: namespace_change_location_req
	(*NamespaceSetRbdTrashImageReq)(nil),         // 11: namespace_set_rbd_trash_image_req
	(*NamespaceSetAutoResizeReq)(nil),            // 12: namespace_set_auto_resize_req
	(*NamespaceDeleteReq)(nil),                   // 13: namespace_delete_req
	(*NamespaceAddHostReq)(nil),                  // 14: namespace_add_host_req
	(*NamespaceDeleteHostReq)(nil),               // 15: namespace_delete_host_req
	(*CreateSubsystemReq)(nil),                   // 16: create_subsystem_req
	(*DeleteSubsystemReq)(nil),                   // 17: delete_subsystem_req
	(*ChangeSubsystemKeyReq)(nil),                // 18: change_subsystem_key_req
	(*ListNamespacesReq)(nil),                    // 19: list_namespaces_req
	(*AddHostReq)(nil),                           // 20: add_host_req
	(*ChangeHostKeyReq)(nil),                     // 21: change_host_key_req
	(*RemoveHostReq)(nil),                        // 22: remove_host_req
	(*ListHostsReq)(nil),                         // 23: list_hosts_req
	(*ListConnectionsReq)(nil),                   // 24: list_connections_req
	(*CreateListenerReq)(nil),                    // 25: create_listener_req
	(*DeleteListenerReq)(nil),                    // 26: delete_listener_req
	(*ListListenersReq)(nil),                     // 27: list_listeners_req
	(*ListSubsystemsReq)(nil),                    // 28: list_subsystems_req
	(*GetSubsystemsReq)(nil),                     // 29: get_subsystems_req
	(*GetSpdkNvmfLogFlagsAndLevelReq)(nil),       // 30: get_spdk_nvmf_log_flags_and_level_req
	(*DisableSpdkNvmfLogsReq)(nil),               // 31: disable_spdk_nvmf_logs_req
	(*SetSpdkNvmfLogsReq)(nil),                   // 32: set_spdk_nvmf_logs_req
	(*GetGatewayInfoReq)(nil),                    // 33: get_gateway_info_req
	(*GetGatewayLogLevelReq)(nil),                // 34: get_gateway_log_level_req
	(*SetGatewayLogLevelReq)(nil),                // 35: set_gateway_log_level_req
	(*ShowGatewayListenersInfoReq)(nil),          // 36: show_gateway_listeners_info_req
	(*GetGatewayStatsReq)(nil),                   // 37: get_gateway_stats_req
	(*AnaGroupState)(nil),                        // 38: ana_group_state
	(*NqnAnaStates)(nil),                         // 39: nqn_ana_states
	(*AnaInfo)(nil),                              // 40: ana_info
	(*ReqStatus)(nil),                            // 41: req_status
	(*SubsysStatus)(nil),                         // 42: subsys_status
	(*NsidStatus)(nil),                           // 43: nsid_status
	(*SubsystemsInfo)(nil),                       // 44: subsystems_info
	(*Subsystem)(nil),                            // 45: subsystem
	(*ListenAddress)(nil),                        // 46: listen_address
	(*Namespace)(nil),                            // 47: namespace
	(*SubsystemsInfoCli)(nil),                    // 48: subsystems_info_cli
	(*SubsystemCli)(nil),                         // 49: subsystem_cli
	(*GatewayInfo)(nil),                          // 50: gateway_info
	(*CliVersion)(nil),                           // 51: cli_version
	(*GwVersion)(nil),                            // 52: gw_version
	(*PollGroupTransportInfo)(nil),               // 53: poll_group_transport_info
	(*PollGroupInfo)(nil),                        // 54: poll_group_info
	(*GatewayStatsInfo)(nil),                     // 55: gateway_stats_info
	(*ListenerInfo)(nil),                         // 56: listener_info
	(*ListenersInfo)(nil),                        // 57: listeners_info
	(*GatewayListenerInfo)(nil),                  // 58: gateway_listener_info
	(*GatewayListenersInfo)(nil),                 // 59: gateway_listeners_info
	(*Host)(nil),                                 // 60: host
	(*HostsInfo)(nil),                            // 61: hosts_info
	(*Connection)(nil),                           // 62: connection
	(*ConnectionsInfo)(nil),                      // 63: connections_info
	(*NamespaceCli)(nil),                         // 64: namespace_cli
	(*NamespacesInfo)(nil),                       // 65: namespaces_info
	(*NamespaceIoError)(nil),                     // 66: namespace_io_error
	(*NamespaceIoStatsInfo)(nil),                 // 67: namespace_io_stats_info
	(*SpdkLogFlagInfo)(nil),                      // 68: spdk_log_flag_info
	(*SpdkNvmfLogFlagsAndLevelInfo)(nil),         // 69: spdk_nvmf_log_flags_and_level_info
	(*GatewayLogLevelInfo)(nil),                  // 70: gateway_log_level_info
}
var file_gateway_proto_depIdxs = []int32{
	0,  // 0: create_listener_req.adrfam:type_name -> AddressFamily
	0,  // 1: delete_listener_req.adrfam:type_name -> AddressFamily
	1,  // 2: set_spdk_nvmf_logs_req.log_level:type_name -> LogLevel
	1,  // 3: set_spdk_nvmf_logs_req.print_level:type_name -> LogLevel
	2,  // 4: set_gateway_log_level_req.log_level:type_name -> GwLogLevel
	3,  // 5: ana_group_state.state:type_name -> ana_state
	38, // 6: nqn_ana_states.states:type_name -> ana_group_state
	39, // 7: ana_info.states:type_name -> nqn_ana_states
	45, // 8: subsystems_info.subsystems:type_name -> subsystem
	46, // 9: subsystem.listen_addresses:type_name -> listen_address
	60, // 10: subsystem.hosts:type_name -> host
	47, // 11: subsystem.namespaces:type_name -> namespace
	49, // 12: subsystems_info_cli.subsystems:type_name -> subsystem_cli
	53, // 13: poll_group_info.transports:type_name -> poll_group_transport_info
	54, // 14: gateway_stats_info.poll_groups:type_name -> poll_group_info
	0,  // 15: listener_info.adrfam:type_name -> AddressFamily
	56, // 16: listeners_info.listeners:type_name -> listener_info
	56, // 17: gateway_listener_info.listener:type_name -> listener_info
	38, // 18: gateway_listener_info.lb_states:type_name -> ana_group_state
	58, // 19: gateway_listeners_info.gw_listeners:type_name -> gateway_listener_info
	60, // 20: hosts_info.hosts:type_name -> host
	0,  // 21: connection.adrfam:type_name -> AddressFamily
	62, // 22: connections_info.connections:type_name -> connection
	64, // 23: namespaces_info.namespaces:type_name -> namespace_cli
	66, // 24: namespace_io_stats_info.io_error:type_name -> namespace_io_error
	68, // 25: spdk_nvmf_log_flags_and_level_info.nvmf_log_flags:type_name -> spdk_log_flag_info
	1,  // 26: spdk_nvmf_log_flags_and_level_info.log_level:type_name -> LogLevel
	1,  // 27: spdk_nvmf_log_flags_and_level_info.log_print_level:type_name -> LogLevel
	2,  // 28: gateway_log_level_info.log_level:type_name -> GwLogLevel
	4,  // 29: Gateway.namespace_add:input_type -> namespace_add_req
	16, // 30: Gateway.create_subsystem:input_type -> create_subsystem_req
	17, // 31: Gateway.delete_subsystem:input_type -> delete_subsystem_req
	18, // 32: Gateway.change_subsystem_key:input_type -> change_subsystem_key_req
	19, // 33: Gateway.list_namespaces:input_type -> list_namespaces_req
	5,  // 34: Gateway.namespace_resize:input_type -> namespace_resize_req
	6,  // 35: Gateway.namespace_get_io_stats:input_type -> namespace_get_io_stats_req
	7,  // 36: Gateway.namespace_set_qos_limits:input_type -> namespace_set_qos_req
	8,  // 37: Gateway.namespace_change_load_balancing_group:input_type -> namespace_change_load_balancing_group_req
	9,  // 38: Gateway.namespace_change_visibility:input_type -> namespace_change_visibility_req
	10, // 39: Gateway.namespace_change_location:input_type -> namespace_change_location_req
	11, // 40: Gateway.namespace_set_rbd_trash_image:input_type -> namespace_set_rbd_trash_image_req
	12, // 41: Gateway.namespace_set_auto_resize:input_type -> namespace_set_auto_resize_req
	13, // 42: Gateway.namespace_delete:input_type -> namespace_delete_req
	14, // 43: Gateway.namespace_add_host:input_type -> namespace_add_host_req
	15, // 44: Gateway.namespace_delete_host:input_type -> namespace_delete_host_req
	20, // 45: Gateway.add_host:input_type -> add_host_req
	22, // 46: Gateway.remove_host:input_type -> remove_host_req
	21, // 47: Gateway.change_host_key:input_type -> change_host_key_req
	23, // 48: Gateway.list_hosts:input_type -> list_hosts_req
	24, // 49: Gateway.list_connections:input_type -> list_connections_req
	25, // 50: Gateway.create_listener:input_type -> create_listener_req
	26, // 51: Gateway.delete_listener:input_type -> delete_listener_req
	27, // 52: Gateway.list_listeners:input_type -> list_listeners_req
	28, // 53: Gateway.list_subsystems:input_type -> list_subsystems_req
	29, // 54: Gateway.get_subsystems:input_type -> get_subsystems_req
	40, // 55: Gateway.set_ana_state:input_type -> ana_info
	30, // 56: Gateway.get_spdk_nvmf_log_flags_and_level:input_type -> get_spdk_nvmf_log_flags_and_level_req
	31, // 57: Gateway.disable_spdk_nvmf_logs:input_type -> disable_spdk_nvmf_logs_req
	32, // 58: Gateway.set_spdk_nvmf_logs:input_type -> set_spdk_nvmf_logs_req
	33, // 59: Gateway.get_gateway_info:input_type -> get_gateway_info_req
	34, // 60: Gateway.get_gateway_log_level:input_type -> get_gateway_log_level_req
	35, // 61: Gateway.set_gateway_log_level:input_type -> set_gateway_log_level_req
	36, // 62: Gateway.show_gateway_listeners_info:input_type -> show_gateway_listeners_info_req
	37, // 63: Gateway.get_gateway_stats:input_type -> get_gateway_stats_req
	43, // 64: Gateway.namespace_add:output_type -> nsid_status
	42, // 65: Gateway.create_subsystem:output_type -> subsys_status
	41, // 66: Gateway.delete_subsystem:output_type -> req_status
	41, // 67: Gateway.change_subsystem_key:output_type -> req_status
	65, // 68: Gateway.list_namespaces:output_type -> namespaces_info
	41, // 69: Gateway.namespace_resize:output_type -> req_status
	67, // 70: Gateway.namespace_get_io_stats:output_type -> namespace_io_stats_info
	41, // 71: Gateway.namespace_set_qos_limits:output_type -> req_status
	41, // 72: Gateway.namespace_change_load_balancing_group:output_type -> req_status
	41, // 73: Gateway.namespace_change_visibility:output_type -> req_status
	41, // 74: Gateway.namespace_change_location:output_type -> req_status
	41, // 75: Gateway.namespace_set_rbd_trash_image:output_type -> req_status
	41, // 76: Gateway.namespace_set_auto_resize:output_type -> req_status
	41, // 77: Gateway.namespace_delete:output_type -> req_status
	41, // 78: Gateway.namespace_add_host:output_type -> req_status
	41, // 79: Gateway.namespace_delete_host:output_type -> req_status
	41, // 80: Gateway.add_host:output_type -> req_status
	41, // 81: Gateway.remove_host:output_type -> req_status
	41, // 82: Gateway.change_host_key:output_type -> req_status
	61, // 83: Gateway.list_hosts:output_type -> hosts_info
	63, // 84: Gateway.list_connections:output_type -> connections_info
	41, // 85: Gateway.create_listener:output_type -> req_status
	41, // 86: Gateway.delete_listener:output_type -> req_status
	57, // 87: Gateway.list_listeners:output_type -> listeners_info
	48, // 88: Gateway.list_subsystems:output_type -> subsystems_info_cli
	44, // 89: Gateway.get_subsystems:output_type -> subsystems_info
	41, // 90: Gateway.set_ana_state:output_type -> req_status
	69, // 91: Gateway.get_spdk_nvmf_log_flags_and_level:output_type -> spdk_nvmf_log_flags_and_level_info
	41, // 92: Gateway.disable_spdk_nvmf_logs:output_type -> req_status
	41, // 93: Gateway.set_spdk_nvmf_logs:output_type -> req_status
	50, // 94: Gateway.get_gateway_info:output_type -> gateway_info
	70, // 95: Gateway.get_gateway_log_level:output_type -> gateway_log_level_info
	41, // 96: Gateway.set_gateway_log_level:output_type -> req_status
	59, // 97: Gateway.show_gateway_listeners_info:output_type -> gateway_listeners_info
	55, // 98: Gateway.get_gateway_stats:output_type -> gateway_stats_info
	64, // [64:99] is the sub-list for method output_type
	29, // [29:64] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_gateway_proto_init() }
func file_gateway_proto_init() {
	if File_gateway_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_gateway_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceAddReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceResizeReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceGetIoStatsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceSetQosReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceChangeLoadBalancingGroupReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceChangeVisibilityReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceChangeLocationReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceSetRbdTrashImageReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceSetAutoResizeReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceDeleteReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceAddHostReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceDeleteHostReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSubsystemReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSubsystemReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeSubsystemKeyReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNamespacesReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddHostReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeHostKeyReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveHostReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHostsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateListenerReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteListenerReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListListenersReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubsystemsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSubsystemsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSpdkNvmfLogFlagsAndLevelReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableSpdkNvmfLogsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetSpdkNvmfLogsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayInfoReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayLogLevelReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetGatewayLogLevelReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowGatewayListenersInfoReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayStatsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnaGroupState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NqnAnaStates); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnaInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReqStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubsysStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NsidStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubsystemsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subsystem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Namespace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubsystemsInfoCli); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubsystemCli); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CliVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GwVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollGroupTransportInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollGroupInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayStatsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenersInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayListenerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayListenersInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HostsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceCli); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespacesInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceIoError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceIoStatsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpdkLogFlagInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpdkNvmfLogFlagsAndLevelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gateway_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayLogLevelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_gateway_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[16].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[17].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[19].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[20].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[21].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[22].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[24].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[26].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[28].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[29].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[41].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[42].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[43].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[45].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[46].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[52].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[56].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[58].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[60].OneofWrappers = []interface{}{}
	file_gateway_proto_msgTypes[63].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_gateway_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   67,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_gateway_proto_goTypes,
		DependencyIndexes: file_gateway_proto_depIdxs,
		EnumInfos:         file_gateway_proto_enumTypes,
		MessageInfos:      file_gateway_proto_msgTypes,
	}.Build()
	File_gateway_proto = out.File
	file_gateway_proto_rawDesc = nil
	file_gateway_proto_goTypes = nil
	file_gateway_proto_depIdxs = nil
}
