// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ''AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2025 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

#ifndef PX_EXTENSION_METADATAOBJECTS_H
#define PX_EXTENSION_METADATAOBJECTS_H
#include "PxPhysicsAPI.h"
#include "extensions/PxExtensionsAPI.h"
#include "PxMetaDataObjects.h"


namespace physx
{

class PxD6Joint;
class PxJointLimitCone;

struct PxExtensionsPropertyInfoName
{
	enum Enum
	{
		Unnamed = PxPropertyInfoName::LastPxPropertyInfoName,
#include "PxExtensionAutoGeneratedMetaDataObjectNames.h"
		LastPxPropertyInfoName
	};
};

#define DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( type, prop, valueStruct )																			\
	template<> struct PxPropertyToValueStructMemberMap< PxExtensionsPropertyInfoName::type##_##prop >											\
	{																																			\
		PxU32 Offset;																															\
		PxPropertyToValueStructMemberMap< PxExtensionsPropertyInfoName::type##_##prop >() : Offset( PX_OFFSET_OF_RT( valueStruct, prop ) ) {}	\
		template<typename TOperator> void visitProp( TOperator inOperator, valueStruct& inStruct ) { inOperator( inStruct.prop );	}			\
	};

#if PX_LINUX && PX_CLANG
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-identifier"
#endif
#include "PxExtensionAutoGeneratedMetaDataObjects.h"
#if PX_LINUX && PX_CLANG
#pragma clang diagnostic pop
#endif

#undef DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP

PX_FORCE_INLINE bool isD6JointDriveAccessAllowed(PxD6Drive::Enum driveType, PxD6AngularDriveConfig::Enum angDriveConfig)
{
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eX < PxD6Drive::eY);
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eY < PxD6Drive::eZ);
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eZ < PxD6Drive::eSWING);
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eZ < PxD6Drive::eTWIST);
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eZ < PxD6Drive::eSLERP);
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eZ < PxD6Drive::eSWING1);
	PX_COMPILE_TIME_ASSERT(PxD6Drive::eZ < PxD6Drive::eSWING2);

	if (driveType > PxD6Drive::eZ)
	{
		if (angDriveConfig == PxD6AngularDriveConfig::eSWING_TWIST)
		{
			if ((driveType != PxD6Drive::eTWIST) && (driveType != PxD6Drive::eSWING1) && (driveType != PxD6Drive::eSWING2))
				return false;
		}
		else if (angDriveConfig == PxD6AngularDriveConfig::eSLERP)
		{
			if (driveType != PxD6Drive::eSLERP)
				return false;
		}
		else
		{
			PX_ASSERT(angDriveConfig == PxD6AngularDriveConfig::eLEGACY);

			if ((driveType != PxD6Drive::eSWING) && (driveType != PxD6Drive::eTWIST) && (driveType != PxD6Drive::eSLERP))
				return false;
		}
	}

	return true;
}

}

#endif
