// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ''AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2025 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#include "foundation/PxPreprocessor.h"
#if PX_LINUX && PX_CLANG
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-identifier"
#endif
#include "PxMetaDataObjects.h"
#if PX_LINUX && PX_CLANG
#pragma clang diagnostic pop
#endif

#include "PxMetaDataCppPrefix.h"
using namespace physx;
const PxTolerancesScale getPxPhysics_TolerancesScale( const PxPhysics* inObj ) { return inObj->getTolerancesScale(); }
PxU32 getPxPhysics_TriangleMeshes( const PxPhysics* inObj, PxTriangleMesh ** outBuffer, PxU32 inBufSize ) { return inObj->getTriangleMeshes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_TriangleMeshes( const PxPhysics* inObj ) { return inObj->getNbTriangleMeshes(  ); }
PxTriangleMesh * createPxPhysics_TriangleMeshes( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createTriangleMesh( inCreateParam ); }
PxU32 getPxPhysics_TetrahedronMeshes( const PxPhysics* inObj, PxTetrahedronMesh ** outBuffer, PxU32 inBufSize ) { return inObj->getTetrahedronMeshes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_TetrahedronMeshes( const PxPhysics* inObj ) { return inObj->getNbTetrahedronMeshes(  ); }
PxTetrahedronMesh * createPxPhysics_TetrahedronMeshes( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createTetrahedronMesh( inCreateParam ); }
PxU32 getPxPhysics_HeightFields( const PxPhysics* inObj, PxHeightField ** outBuffer, PxU32 inBufSize ) { return inObj->getHeightFields( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_HeightFields( const PxPhysics* inObj ) { return inObj->getNbHeightFields(  ); }
PxHeightField * createPxPhysics_HeightFields( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createHeightField( inCreateParam ); }
PxU32 getPxPhysics_ConvexMeshes( const PxPhysics* inObj, PxConvexMesh ** outBuffer, PxU32 inBufSize ) { return inObj->getConvexMeshes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_ConvexMeshes( const PxPhysics* inObj ) { return inObj->getNbConvexMeshes(  ); }
PxConvexMesh * createPxPhysics_ConvexMeshes( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createConvexMesh( inCreateParam ); }
PxU32 getPxPhysics_BVHs( const PxPhysics* inObj, PxBVH ** outBuffer, PxU32 inBufSize ) { return inObj->getBVHs( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_BVHs( const PxPhysics* inObj ) { return inObj->getNbBVHs(  ); }
PxBVH * createPxPhysics_BVHs( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createBVH( inCreateParam ); }
PxU32 getPxPhysics_Scenes( const PxPhysics* inObj, PxScene ** outBuffer, PxU32 inBufSize ) { return inObj->getScenes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_Scenes( const PxPhysics* inObj ) { return inObj->getNbScenes(  ); }
PxScene * createPxPhysics_Scenes( PxPhysics* inObj, const PxSceneDesc & inCreateParam ){ return inObj->createScene( inCreateParam ); }
PxU32 getPxPhysics_Shapes( const PxPhysics* inObj, PxShape ** outBuffer, PxU32 inBufSize ) { return inObj->getShapes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_Shapes( const PxPhysics* inObj ) { return inObj->getNbShapes(  ); }
PxU32 getPxPhysics_Materials( const PxPhysics* inObj, PxMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_Materials( const PxPhysics* inObj ) { return inObj->getNbMaterials(  ); }
PxU32 getPxPhysics_DeformableSurfaceMaterials( const PxPhysics* inObj, PxDeformableSurfaceMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getDeformableSurfaceMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_DeformableSurfaceMaterials( const PxPhysics* inObj ) { return inObj->getNbDeformableSurfaceMaterials(  ); }
PxU32 getPxPhysics_DeformableVolumeMaterials( const PxPhysics* inObj, PxDeformableVolumeMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getDeformableVolumeMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_DeformableVolumeMaterials( const PxPhysics* inObj ) { return inObj->getNbDeformableVolumeMaterials(  ); }
PxU32 getPxPhysics_FEMSoftBodyMaterials( const PxPhysics* inObj, PxDeformableVolumeMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getFEMSoftBodyMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_FEMSoftBodyMaterials( const PxPhysics* inObj ) { return inObj->getNbFEMSoftBodyMaterials(  ); }
PxU32 getPxPhysics_PBDMaterials( const PxPhysics* inObj, PxPBDMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getPBDMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_PBDMaterials( const PxPhysics* inObj ) { return inObj->getNbPBDMaterials(  ); }
PX_PHYSX_CORE_API PxPhysicsGeneratedInfo::PxPhysicsGeneratedInfo()
	: TolerancesScale( "TolerancesScale", getPxPhysics_TolerancesScale)
	, TriangleMeshes( "TriangleMeshes", getPxPhysics_TriangleMeshes, getNbPxPhysics_TriangleMeshes, createPxPhysics_TriangleMeshes )
	, TetrahedronMeshes( "TetrahedronMeshes", getPxPhysics_TetrahedronMeshes, getNbPxPhysics_TetrahedronMeshes, createPxPhysics_TetrahedronMeshes )
	, HeightFields( "HeightFields", getPxPhysics_HeightFields, getNbPxPhysics_HeightFields, createPxPhysics_HeightFields )
	, ConvexMeshes( "ConvexMeshes", getPxPhysics_ConvexMeshes, getNbPxPhysics_ConvexMeshes, createPxPhysics_ConvexMeshes )
	, BVHs( "BVHs", getPxPhysics_BVHs, getNbPxPhysics_BVHs, createPxPhysics_BVHs )
	, Scenes( "Scenes", getPxPhysics_Scenes, getNbPxPhysics_Scenes, createPxPhysics_Scenes )
	, Shapes( "Shapes", getPxPhysics_Shapes, getNbPxPhysics_Shapes )
	, Materials( "Materials", getPxPhysics_Materials, getNbPxPhysics_Materials )
	, DeformableSurfaceMaterials( "DeformableSurfaceMaterials", getPxPhysics_DeformableSurfaceMaterials, getNbPxPhysics_DeformableSurfaceMaterials )
	, DeformableVolumeMaterials( "DeformableVolumeMaterials", getPxPhysics_DeformableVolumeMaterials, getNbPxPhysics_DeformableVolumeMaterials )
	, FEMSoftBodyMaterials( "FEMSoftBodyMaterials", getPxPhysics_FEMSoftBodyMaterials, getNbPxPhysics_FEMSoftBodyMaterials )
	, PBDMaterials( "PBDMaterials", getPxPhysics_PBDMaterials, getNbPxPhysics_PBDMaterials )
{}
PX_PHYSX_CORE_API PxPhysicsGeneratedValues::PxPhysicsGeneratedValues( const PxPhysics* inSource )
		:TolerancesScale( getPxPhysics_TolerancesScale( inSource ) )
{
	PX_UNUSED(inSource);
}
PxU32 getPxRefCounted_ReferenceCount( const PxRefCounted* inObj ) { return inObj->getReferenceCount(); }
PX_PHYSX_CORE_API PxRefCountedGeneratedInfo::PxRefCountedGeneratedInfo()
	: ReferenceCount( "ReferenceCount", getPxRefCounted_ReferenceCount)
{}
PX_PHYSX_CORE_API PxRefCountedGeneratedValues::PxRefCountedGeneratedValues( const PxRefCounted* inSource )
		:ReferenceCount( getPxRefCounted_ReferenceCount( inSource ) )
{
	PX_UNUSED(inSource);
}
inline void * getPxBaseMaterialUserData( const PxBaseMaterial* inOwner ) { return inOwner->userData; }
inline void setPxBaseMaterialUserData( PxBaseMaterial* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxBaseMaterialGeneratedInfo::PxBaseMaterialGeneratedInfo()
	: UserData( "UserData", setPxBaseMaterialUserData, getPxBaseMaterialUserData )
{}
PX_PHYSX_CORE_API PxBaseMaterialGeneratedValues::PxBaseMaterialGeneratedValues( const PxBaseMaterial* inSource )
		:PxRefCountedGeneratedValues( inSource )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
}
void setPxMaterial_DynamicFriction( PxMaterial* inObj, PxReal inArg){ inObj->setDynamicFriction( inArg ); }
PxReal getPxMaterial_DynamicFriction( const PxMaterial* inObj ) { return inObj->getDynamicFriction(); }
void setPxMaterial_StaticFriction( PxMaterial* inObj, PxReal inArg){ inObj->setStaticFriction( inArg ); }
PxReal getPxMaterial_StaticFriction( const PxMaterial* inObj ) { return inObj->getStaticFriction(); }
void setPxMaterial_Restitution( PxMaterial* inObj, PxReal inArg){ inObj->setRestitution( inArg ); }
PxReal getPxMaterial_Restitution( const PxMaterial* inObj ) { return inObj->getRestitution(); }
void setPxMaterial_Damping( PxMaterial* inObj, PxReal inArg){ inObj->setDamping( inArg ); }
PxReal getPxMaterial_Damping( const PxMaterial* inObj ) { return inObj->getDamping(); }
void setPxMaterial_Flags( PxMaterial* inObj, PxMaterialFlags inArg){ inObj->setFlags( inArg ); }
PxMaterialFlags getPxMaterial_Flags( const PxMaterial* inObj ) { return inObj->getFlags(); }
void setPxMaterial_FrictionCombineMode( PxMaterial* inObj, PxCombineMode::Enum inArg){ inObj->setFrictionCombineMode( inArg ); }
PxCombineMode::Enum getPxMaterial_FrictionCombineMode( const PxMaterial* inObj ) { return inObj->getFrictionCombineMode(); }
void setPxMaterial_RestitutionCombineMode( PxMaterial* inObj, PxCombineMode::Enum inArg){ inObj->setRestitutionCombineMode( inArg ); }
PxCombineMode::Enum getPxMaterial_RestitutionCombineMode( const PxMaterial* inObj ) { return inObj->getRestitutionCombineMode(); }
void setPxMaterial_DampingCombineMode( PxMaterial* inObj, PxCombineMode::Enum inArg){ inObj->setDampingCombineMode( inArg ); }
PxCombineMode::Enum getPxMaterial_DampingCombineMode( const PxMaterial* inObj ) { return inObj->getDampingCombineMode(); }
const char * getPxMaterial_ConcreteTypeName( const PxMaterial* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxMaterialGeneratedInfo::PxMaterialGeneratedInfo()
	: DynamicFriction( "DynamicFriction", setPxMaterial_DynamicFriction, getPxMaterial_DynamicFriction)
	, StaticFriction( "StaticFriction", setPxMaterial_StaticFriction, getPxMaterial_StaticFriction)
	, Restitution( "Restitution", setPxMaterial_Restitution, getPxMaterial_Restitution)
	, Damping( "Damping", setPxMaterial_Damping, getPxMaterial_Damping)
	, Flags( "Flags", setPxMaterial_Flags, getPxMaterial_Flags)
	, FrictionCombineMode( "FrictionCombineMode", setPxMaterial_FrictionCombineMode, getPxMaterial_FrictionCombineMode)
	, RestitutionCombineMode( "RestitutionCombineMode", setPxMaterial_RestitutionCombineMode, getPxMaterial_RestitutionCombineMode)
	, DampingCombineMode( "DampingCombineMode", setPxMaterial_DampingCombineMode, getPxMaterial_DampingCombineMode)
	, ConcreteTypeName( "ConcreteTypeName", getPxMaterial_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxMaterialGeneratedValues::PxMaterialGeneratedValues( const PxMaterial* inSource )
		:PxBaseMaterialGeneratedValues( inSource )
		,DynamicFriction( getPxMaterial_DynamicFriction( inSource ) )
		,StaticFriction( getPxMaterial_StaticFriction( inSource ) )
		,Restitution( getPxMaterial_Restitution( inSource ) )
		,Damping( getPxMaterial_Damping( inSource ) )
		,Flags( getPxMaterial_Flags( inSource ) )
		,FrictionCombineMode( getPxMaterial_FrictionCombineMode( inSource ) )
		,RestitutionCombineMode( getPxMaterial_RestitutionCombineMode( inSource ) )
		,DampingCombineMode( getPxMaterial_DampingCombineMode( inSource ) )
		,ConcreteTypeName( getPxMaterial_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxDeformableMaterial_YoungsModulus( PxDeformableMaterial* inObj, PxReal inArg){ inObj->setYoungsModulus( inArg ); }
PxReal getPxDeformableMaterial_YoungsModulus( const PxDeformableMaterial* inObj ) { return inObj->getYoungsModulus(); }
void setPxDeformableMaterial_Poissons( PxDeformableMaterial* inObj, PxReal inArg){ inObj->setPoissons( inArg ); }
PxReal getPxDeformableMaterial_Poissons( const PxDeformableMaterial* inObj ) { return inObj->getPoissons(); }
void setPxDeformableMaterial_DynamicFriction( PxDeformableMaterial* inObj, PxReal inArg){ inObj->setDynamicFriction( inArg ); }
PxReal getPxDeformableMaterial_DynamicFriction( const PxDeformableMaterial* inObj ) { return inObj->getDynamicFriction(); }
void setPxDeformableMaterial_ElasticityDamping( PxDeformableMaterial* inObj, PxReal inArg){ inObj->setElasticityDamping( inArg ); }
PxReal getPxDeformableMaterial_ElasticityDamping( const PxDeformableMaterial* inObj ) { return inObj->getElasticityDamping(); }
PX_PHYSX_CORE_API PxDeformableMaterialGeneratedInfo::PxDeformableMaterialGeneratedInfo()
	: YoungsModulus( "YoungsModulus", setPxDeformableMaterial_YoungsModulus, getPxDeformableMaterial_YoungsModulus)
	, Poissons( "Poissons", setPxDeformableMaterial_Poissons, getPxDeformableMaterial_Poissons)
	, DynamicFriction( "DynamicFriction", setPxDeformableMaterial_DynamicFriction, getPxDeformableMaterial_DynamicFriction)
	, ElasticityDamping( "ElasticityDamping", setPxDeformableMaterial_ElasticityDamping, getPxDeformableMaterial_ElasticityDamping)
{}
PX_PHYSX_CORE_API PxDeformableMaterialGeneratedValues::PxDeformableMaterialGeneratedValues( const PxDeformableMaterial* inSource )
		:PxBaseMaterialGeneratedValues( inSource )
		,YoungsModulus( getPxDeformableMaterial_YoungsModulus( inSource ) )
		,Poissons( getPxDeformableMaterial_Poissons( inSource ) )
		,DynamicFriction( getPxDeformableMaterial_DynamicFriction( inSource ) )
		,ElasticityDamping( getPxDeformableMaterial_ElasticityDamping( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxDeformableSurfaceMaterial_Thickness( PxDeformableSurfaceMaterial* inObj, PxReal inArg){ inObj->setThickness( inArg ); }
PxReal getPxDeformableSurfaceMaterial_Thickness( const PxDeformableSurfaceMaterial* inObj ) { return inObj->getThickness(); }
void setPxDeformableSurfaceMaterial_BendingStiffness( PxDeformableSurfaceMaterial* inObj, PxReal inArg){ inObj->setBendingStiffness( inArg ); }
PxReal getPxDeformableSurfaceMaterial_BendingStiffness( const PxDeformableSurfaceMaterial* inObj ) { return inObj->getBendingStiffness(); }
void setPxDeformableSurfaceMaterial_BendingDamping( PxDeformableSurfaceMaterial* inObj, PxReal inArg){ inObj->setBendingDamping( inArg ); }
PxReal getPxDeformableSurfaceMaterial_BendingDamping( const PxDeformableSurfaceMaterial* inObj ) { return inObj->getBendingDamping(); }
const char * getPxDeformableSurfaceMaterial_ConcreteTypeName( const PxDeformableSurfaceMaterial* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxDeformableSurfaceMaterialGeneratedInfo::PxDeformableSurfaceMaterialGeneratedInfo()
	: Thickness( "Thickness", setPxDeformableSurfaceMaterial_Thickness, getPxDeformableSurfaceMaterial_Thickness)
	, BendingStiffness( "BendingStiffness", setPxDeformableSurfaceMaterial_BendingStiffness, getPxDeformableSurfaceMaterial_BendingStiffness)
	, BendingDamping( "BendingDamping", setPxDeformableSurfaceMaterial_BendingDamping, getPxDeformableSurfaceMaterial_BendingDamping)
	, ConcreteTypeName( "ConcreteTypeName", getPxDeformableSurfaceMaterial_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxDeformableSurfaceMaterialGeneratedValues::PxDeformableSurfaceMaterialGeneratedValues( const PxDeformableSurfaceMaterial* inSource )
		:PxDeformableMaterialGeneratedValues( inSource )
		,Thickness( getPxDeformableSurfaceMaterial_Thickness( inSource ) )
		,BendingStiffness( getPxDeformableSurfaceMaterial_BendingStiffness( inSource ) )
		,BendingDamping( getPxDeformableSurfaceMaterial_BendingDamping( inSource ) )
		,ConcreteTypeName( getPxDeformableSurfaceMaterial_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxDeformableVolumeMaterial_Damping( PxDeformableVolumeMaterial* inObj, PxReal inArg){ inObj->setDamping( inArg ); }
PxReal getPxDeformableVolumeMaterial_Damping( const PxDeformableVolumeMaterial* inObj ) { return inObj->getDamping(); }
void setPxDeformableVolumeMaterial_DampingScale( PxDeformableVolumeMaterial* inObj, PxReal inArg){ inObj->setDampingScale( inArg ); }
PxReal getPxDeformableVolumeMaterial_DampingScale( const PxDeformableVolumeMaterial* inObj ) { return inObj->getDampingScale(); }
void setPxDeformableVolumeMaterial_MaterialModel( PxDeformableVolumeMaterial* inObj, PxDeformableVolumeMaterialModel::Enum inArg){ inObj->setMaterialModel( inArg ); }
PxDeformableVolumeMaterialModel::Enum getPxDeformableVolumeMaterial_MaterialModel( const PxDeformableVolumeMaterial* inObj ) { return inObj->getMaterialModel(); }
const char * getPxDeformableVolumeMaterial_ConcreteTypeName( const PxDeformableVolumeMaterial* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxDeformableVolumeMaterialGeneratedInfo::PxDeformableVolumeMaterialGeneratedInfo()
	: Damping( "Damping", setPxDeformableVolumeMaterial_Damping, getPxDeformableVolumeMaterial_Damping)
	, DampingScale( "DampingScale", setPxDeformableVolumeMaterial_DampingScale, getPxDeformableVolumeMaterial_DampingScale)
	, MaterialModel( "MaterialModel", setPxDeformableVolumeMaterial_MaterialModel, getPxDeformableVolumeMaterial_MaterialModel)
	, ConcreteTypeName( "ConcreteTypeName", getPxDeformableVolumeMaterial_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxDeformableVolumeMaterialGeneratedValues::PxDeformableVolumeMaterialGeneratedValues( const PxDeformableVolumeMaterial* inSource )
		:PxDeformableMaterialGeneratedValues( inSource )
		,Damping( getPxDeformableVolumeMaterial_Damping( inSource ) )
		,DampingScale( getPxDeformableVolumeMaterial_DampingScale( inSource ) )
		,MaterialModel( getPxDeformableVolumeMaterial_MaterialModel( inSource ) )
		,ConcreteTypeName( getPxDeformableVolumeMaterial_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxPBDMaterial_Friction( PxPBDMaterial* inObj, PxReal inArg){ inObj->setFriction( inArg ); }
PxReal getPxPBDMaterial_Friction( const PxPBDMaterial* inObj ) { return inObj->getFriction(); }
void setPxPBDMaterial_Damping( PxPBDMaterial* inObj, PxReal inArg){ inObj->setDamping( inArg ); }
PxReal getPxPBDMaterial_Damping( const PxPBDMaterial* inObj ) { return inObj->getDamping(); }
void setPxPBDMaterial_Adhesion( PxPBDMaterial* inObj, PxReal inArg){ inObj->setAdhesion( inArg ); }
PxReal getPxPBDMaterial_Adhesion( const PxPBDMaterial* inObj ) { return inObj->getAdhesion(); }
void setPxPBDMaterial_GravityScale( PxPBDMaterial* inObj, PxReal inArg){ inObj->setGravityScale( inArg ); }
PxReal getPxPBDMaterial_GravityScale( const PxPBDMaterial* inObj ) { return inObj->getGravityScale(); }
void setPxPBDMaterial_AdhesionRadiusScale( PxPBDMaterial* inObj, PxReal inArg){ inObj->setAdhesionRadiusScale( inArg ); }
PxReal getPxPBDMaterial_AdhesionRadiusScale( const PxPBDMaterial* inObj ) { return inObj->getAdhesionRadiusScale(); }
void setPxPBDMaterial_Viscosity( PxPBDMaterial* inObj, PxReal inArg){ inObj->setViscosity( inArg ); }
PxReal getPxPBDMaterial_Viscosity( const PxPBDMaterial* inObj ) { return inObj->getViscosity(); }
void setPxPBDMaterial_VorticityConfinement( PxPBDMaterial* inObj, PxReal inArg){ inObj->setVorticityConfinement( inArg ); }
PxReal getPxPBDMaterial_VorticityConfinement( const PxPBDMaterial* inObj ) { return inObj->getVorticityConfinement(); }
void setPxPBDMaterial_SurfaceTension( PxPBDMaterial* inObj, PxReal inArg){ inObj->setSurfaceTension( inArg ); }
PxReal getPxPBDMaterial_SurfaceTension( const PxPBDMaterial* inObj ) { return inObj->getSurfaceTension(); }
void setPxPBDMaterial_Cohesion( PxPBDMaterial* inObj, PxReal inArg){ inObj->setCohesion( inArg ); }
PxReal getPxPBDMaterial_Cohesion( const PxPBDMaterial* inObj ) { return inObj->getCohesion(); }
void setPxPBDMaterial_Lift( PxPBDMaterial* inObj, PxReal inArg){ inObj->setLift( inArg ); }
PxReal getPxPBDMaterial_Lift( const PxPBDMaterial* inObj ) { return inObj->getLift(); }
void setPxPBDMaterial_Drag( PxPBDMaterial* inObj, PxReal inArg){ inObj->setDrag( inArg ); }
PxReal getPxPBDMaterial_Drag( const PxPBDMaterial* inObj ) { return inObj->getDrag(); }
void setPxPBDMaterial_CFLCoefficient( PxPBDMaterial* inObj, PxReal inArg){ inObj->setCFLCoefficient( inArg ); }
PxReal getPxPBDMaterial_CFLCoefficient( const PxPBDMaterial* inObj ) { return inObj->getCFLCoefficient(); }
void setPxPBDMaterial_ParticleFrictionScale( PxPBDMaterial* inObj, PxReal inArg){ inObj->setParticleFrictionScale( inArg ); }
PxReal getPxPBDMaterial_ParticleFrictionScale( const PxPBDMaterial* inObj ) { return inObj->getParticleFrictionScale(); }
void setPxPBDMaterial_ParticleAdhesionScale( PxPBDMaterial* inObj, PxReal inArg){ inObj->setParticleAdhesionScale( inArg ); }
PxReal getPxPBDMaterial_ParticleAdhesionScale( const PxPBDMaterial* inObj ) { return inObj->getParticleAdhesionScale(); }
const char * getPxPBDMaterial_ConcreteTypeName( const PxPBDMaterial* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxPBDMaterialGeneratedInfo::PxPBDMaterialGeneratedInfo()
	: Friction( "Friction", setPxPBDMaterial_Friction, getPxPBDMaterial_Friction)
	, Damping( "Damping", setPxPBDMaterial_Damping, getPxPBDMaterial_Damping)
	, Adhesion( "Adhesion", setPxPBDMaterial_Adhesion, getPxPBDMaterial_Adhesion)
	, GravityScale( "GravityScale", setPxPBDMaterial_GravityScale, getPxPBDMaterial_GravityScale)
	, AdhesionRadiusScale( "AdhesionRadiusScale", setPxPBDMaterial_AdhesionRadiusScale, getPxPBDMaterial_AdhesionRadiusScale)
	, Viscosity( "Viscosity", setPxPBDMaterial_Viscosity, getPxPBDMaterial_Viscosity)
	, VorticityConfinement( "VorticityConfinement", setPxPBDMaterial_VorticityConfinement, getPxPBDMaterial_VorticityConfinement)
	, SurfaceTension( "SurfaceTension", setPxPBDMaterial_SurfaceTension, getPxPBDMaterial_SurfaceTension)
	, Cohesion( "Cohesion", setPxPBDMaterial_Cohesion, getPxPBDMaterial_Cohesion)
	, Lift( "Lift", setPxPBDMaterial_Lift, getPxPBDMaterial_Lift)
	, Drag( "Drag", setPxPBDMaterial_Drag, getPxPBDMaterial_Drag)
	, CFLCoefficient( "CFLCoefficient", setPxPBDMaterial_CFLCoefficient, getPxPBDMaterial_CFLCoefficient)
	, ParticleFrictionScale( "ParticleFrictionScale", setPxPBDMaterial_ParticleFrictionScale, getPxPBDMaterial_ParticleFrictionScale)
	, ParticleAdhesionScale( "ParticleAdhesionScale", setPxPBDMaterial_ParticleAdhesionScale, getPxPBDMaterial_ParticleAdhesionScale)
	, ConcreteTypeName( "ConcreteTypeName", getPxPBDMaterial_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxPBDMaterialGeneratedValues::PxPBDMaterialGeneratedValues( const PxPBDMaterial* inSource )
		:PxBaseMaterialGeneratedValues( inSource )
		,Friction( getPxPBDMaterial_Friction( inSource ) )
		,Damping( getPxPBDMaterial_Damping( inSource ) )
		,Adhesion( getPxPBDMaterial_Adhesion( inSource ) )
		,GravityScale( getPxPBDMaterial_GravityScale( inSource ) )
		,AdhesionRadiusScale( getPxPBDMaterial_AdhesionRadiusScale( inSource ) )
		,Viscosity( getPxPBDMaterial_Viscosity( inSource ) )
		,VorticityConfinement( getPxPBDMaterial_VorticityConfinement( inSource ) )
		,SurfaceTension( getPxPBDMaterial_SurfaceTension( inSource ) )
		,Cohesion( getPxPBDMaterial_Cohesion( inSource ) )
		,Lift( getPxPBDMaterial_Lift( inSource ) )
		,Drag( getPxPBDMaterial_Drag( inSource ) )
		,CFLCoefficient( getPxPBDMaterial_CFLCoefficient( inSource ) )
		,ParticleFrictionScale( getPxPBDMaterial_ParticleFrictionScale( inSource ) )
		,ParticleAdhesionScale( getPxPBDMaterial_ParticleAdhesionScale( inSource ) )
		,ConcreteTypeName( getPxPBDMaterial_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
PxScene * getPxActor_Scene( const PxActor* inObj ) { return inObj->getScene(); }
void setPxActor_Name( PxActor* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxActor_Name( const PxActor* inObj ) { return inObj->getName(); }
void setPxActor_ActorFlags( PxActor* inObj, PxActorFlags inArg){ inObj->setActorFlags( inArg ); }
PxActorFlags getPxActor_ActorFlags( const PxActor* inObj ) { return inObj->getActorFlags(); }
void setPxActor_DominanceGroup( PxActor* inObj, PxDominanceGroup inArg){ inObj->setDominanceGroup( inArg ); }
PxDominanceGroup getPxActor_DominanceGroup( const PxActor* inObj ) { return inObj->getDominanceGroup(); }
void setPxActor_OwnerClient( PxActor* inObj, PxClientID inArg){ inObj->setOwnerClient( inArg ); }
PxClientID getPxActor_OwnerClient( const PxActor* inObj ) { return inObj->getOwnerClient(); }
PxAggregate * getPxActor_Aggregate( const PxActor* inObj ) { return inObj->getAggregate(); }
inline void * getPxActorUserData( const PxActor* inOwner ) { return inOwner->userData; }
inline void setPxActorUserData( PxActor* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxActorGeneratedInfo::PxActorGeneratedInfo()
	: Scene( "Scene", getPxActor_Scene)
	, Name( "Name", setPxActor_Name, getPxActor_Name)
	, ActorFlags( "ActorFlags", setPxActor_ActorFlags, getPxActor_ActorFlags)
	, DominanceGroup( "DominanceGroup", setPxActor_DominanceGroup, getPxActor_DominanceGroup)
	, OwnerClient( "OwnerClient", setPxActor_OwnerClient, getPxActor_OwnerClient)
	, Aggregate( "Aggregate", getPxActor_Aggregate)
	, UserData( "UserData", setPxActorUserData, getPxActorUserData )
{}
PX_PHYSX_CORE_API PxActorGeneratedValues::PxActorGeneratedValues( const PxActor* inSource )
		:Scene( getPxActor_Scene( inSource ) )
		,Name( getPxActor_Name( inSource ) )
		,ActorFlags( getPxActor_ActorFlags( inSource ) )
		,DominanceGroup( getPxActor_DominanceGroup( inSource ) )
		,OwnerClient( getPxActor_OwnerClient( inSource ) )
		,Aggregate( getPxActor_Aggregate( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
}
void setPxRigidActor_GlobalPose( PxRigidActor* inObj, const PxTransform & inArg){ inObj->setGlobalPose( inArg ); }
PxTransform getPxRigidActor_GlobalPose( const PxRigidActor* inObj ) { return inObj->getGlobalPose(); }
PxU32 getPxRigidActor_Shapes( const PxRigidActor* inObj, PxShape ** outBuffer, PxU32 inBufSize ) { return inObj->getShapes( outBuffer, inBufSize ); }
PxU32 getNbPxRigidActor_Shapes( const PxRigidActor* inObj ) { return inObj->getNbShapes(  ); }
PxU32 getPxRigidActor_Constraints( const PxRigidActor* inObj, PxConstraint ** outBuffer, PxU32 inBufSize ) { return inObj->getConstraints( outBuffer, inBufSize ); }
PxU32 getNbPxRigidActor_Constraints( const PxRigidActor* inObj ) { return inObj->getNbConstraints(  ); }
PX_PHYSX_CORE_API PxRigidActorGeneratedInfo::PxRigidActorGeneratedInfo()
	: GlobalPose( "GlobalPose", setPxRigidActor_GlobalPose, getPxRigidActor_GlobalPose)
	, Shapes( "Shapes", getPxRigidActor_Shapes, getNbPxRigidActor_Shapes )
	, Constraints( "Constraints", getPxRigidActor_Constraints, getNbPxRigidActor_Constraints )
{}
PX_PHYSX_CORE_API PxRigidActorGeneratedValues::PxRigidActorGeneratedValues( const PxRigidActor* inSource )
		:PxActorGeneratedValues( inSource )
		,GlobalPose( getPxRigidActor_GlobalPose( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxRigidBody_CMassLocalPose( PxRigidBody* inObj, const PxTransform & inArg){ inObj->setCMassLocalPose( inArg ); }
PxTransform getPxRigidBody_CMassLocalPose( const PxRigidBody* inObj ) { return inObj->getCMassLocalPose(); }
void setPxRigidBody_Mass( PxRigidBody* inObj, PxReal inArg){ inObj->setMass( inArg ); }
PxReal getPxRigidBody_Mass( const PxRigidBody* inObj ) { return inObj->getMass(); }
PxReal getPxRigidBody_InvMass( const PxRigidBody* inObj ) { return inObj->getInvMass(); }
void setPxRigidBody_MassSpaceInertiaTensor( PxRigidBody* inObj, const PxVec3 & inArg){ inObj->setMassSpaceInertiaTensor( inArg ); }
PxVec3 getPxRigidBody_MassSpaceInertiaTensor( const PxRigidBody* inObj ) { return inObj->getMassSpaceInertiaTensor(); }
PxVec3 getPxRigidBody_MassSpaceInvInertiaTensor( const PxRigidBody* inObj ) { return inObj->getMassSpaceInvInertiaTensor(); }
void setPxRigidBody_LinearDamping( PxRigidBody* inObj, PxReal inArg){ inObj->setLinearDamping( inArg ); }
PxReal getPxRigidBody_LinearDamping( const PxRigidBody* inObj ) { return inObj->getLinearDamping(); }
void setPxRigidBody_AngularDamping( PxRigidBody* inObj, PxReal inArg){ inObj->setAngularDamping( inArg ); }
PxReal getPxRigidBody_AngularDamping( const PxRigidBody* inObj ) { return inObj->getAngularDamping(); }
void setPxRigidBody_MaxLinearVelocity( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxLinearVelocity( inArg ); }
PxReal getPxRigidBody_MaxLinearVelocity( const PxRigidBody* inObj ) { return inObj->getMaxLinearVelocity(); }
void setPxRigidBody_MaxAngularVelocity( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxAngularVelocity( inArg ); }
PxReal getPxRigidBody_MaxAngularVelocity( const PxRigidBody* inObj ) { return inObj->getMaxAngularVelocity(); }
PxVec3 getPxRigidBody_LinearAcceleration( const PxRigidBody* inObj ) { return inObj->getLinearAcceleration(); }
PxVec3 getPxRigidBody_AngularAcceleration( const PxRigidBody* inObj ) { return inObj->getAngularAcceleration(); }
void setPxRigidBody_RigidBodyFlags( PxRigidBody* inObj, PxRigidBodyFlags inArg){ inObj->setRigidBodyFlags( inArg ); }
PxRigidBodyFlags getPxRigidBody_RigidBodyFlags( const PxRigidBody* inObj ) { return inObj->getRigidBodyFlags(); }
void setPxRigidBody_MinCCDAdvanceCoefficient( PxRigidBody* inObj, PxReal inArg){ inObj->setMinCCDAdvanceCoefficient( inArg ); }
PxReal getPxRigidBody_MinCCDAdvanceCoefficient( const PxRigidBody* inObj ) { return inObj->getMinCCDAdvanceCoefficient(); }
void setPxRigidBody_MaxDepenetrationVelocity( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxDepenetrationVelocity( inArg ); }
PxReal getPxRigidBody_MaxDepenetrationVelocity( const PxRigidBody* inObj ) { return inObj->getMaxDepenetrationVelocity(); }
void setPxRigidBody_MaxContactImpulse( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxContactImpulse( inArg ); }
PxReal getPxRigidBody_MaxContactImpulse( const PxRigidBody* inObj ) { return inObj->getMaxContactImpulse(); }
void setPxRigidBody_ContactSlopCoefficient( PxRigidBody* inObj, PxReal inArg){ inObj->setContactSlopCoefficient( inArg ); }
PxReal getPxRigidBody_ContactSlopCoefficient( const PxRigidBody* inObj ) { return inObj->getContactSlopCoefficient(); }
PX_PHYSX_CORE_API PxRigidBodyGeneratedInfo::PxRigidBodyGeneratedInfo()
	: CMassLocalPose( "CMassLocalPose", setPxRigidBody_CMassLocalPose, getPxRigidBody_CMassLocalPose)
	, Mass( "Mass", setPxRigidBody_Mass, getPxRigidBody_Mass)
	, InvMass( "InvMass", getPxRigidBody_InvMass)
	, MassSpaceInertiaTensor( "MassSpaceInertiaTensor", setPxRigidBody_MassSpaceInertiaTensor, getPxRigidBody_MassSpaceInertiaTensor)
	, MassSpaceInvInertiaTensor( "MassSpaceInvInertiaTensor", getPxRigidBody_MassSpaceInvInertiaTensor)
	, LinearDamping( "LinearDamping", setPxRigidBody_LinearDamping, getPxRigidBody_LinearDamping)
	, AngularDamping( "AngularDamping", setPxRigidBody_AngularDamping, getPxRigidBody_AngularDamping)
	, MaxLinearVelocity( "MaxLinearVelocity", setPxRigidBody_MaxLinearVelocity, getPxRigidBody_MaxLinearVelocity)
	, MaxAngularVelocity( "MaxAngularVelocity", setPxRigidBody_MaxAngularVelocity, getPxRigidBody_MaxAngularVelocity)
	, LinearAcceleration( "LinearAcceleration", getPxRigidBody_LinearAcceleration)
	, AngularAcceleration( "AngularAcceleration", getPxRigidBody_AngularAcceleration)
	, RigidBodyFlags( "RigidBodyFlags", setPxRigidBody_RigidBodyFlags, getPxRigidBody_RigidBodyFlags)
	, MinCCDAdvanceCoefficient( "MinCCDAdvanceCoefficient", setPxRigidBody_MinCCDAdvanceCoefficient, getPxRigidBody_MinCCDAdvanceCoefficient)
	, MaxDepenetrationVelocity( "MaxDepenetrationVelocity", setPxRigidBody_MaxDepenetrationVelocity, getPxRigidBody_MaxDepenetrationVelocity)
	, MaxContactImpulse( "MaxContactImpulse", setPxRigidBody_MaxContactImpulse, getPxRigidBody_MaxContactImpulse)
	, ContactSlopCoefficient( "ContactSlopCoefficient", setPxRigidBody_ContactSlopCoefficient, getPxRigidBody_ContactSlopCoefficient)
{}
PX_PHYSX_CORE_API PxRigidBodyGeneratedValues::PxRigidBodyGeneratedValues( const PxRigidBody* inSource )
		:PxRigidActorGeneratedValues( inSource )
		,CMassLocalPose( getPxRigidBody_CMassLocalPose( inSource ) )
		,Mass( getPxRigidBody_Mass( inSource ) )
		,InvMass( getPxRigidBody_InvMass( inSource ) )
		,MassSpaceInertiaTensor( getPxRigidBody_MassSpaceInertiaTensor( inSource ) )
		,MassSpaceInvInertiaTensor( getPxRigidBody_MassSpaceInvInertiaTensor( inSource ) )
		,LinearDamping( getPxRigidBody_LinearDamping( inSource ) )
		,AngularDamping( getPxRigidBody_AngularDamping( inSource ) )
		,MaxLinearVelocity( getPxRigidBody_MaxLinearVelocity( inSource ) )
		,MaxAngularVelocity( getPxRigidBody_MaxAngularVelocity( inSource ) )
		,LinearAcceleration( getPxRigidBody_LinearAcceleration( inSource ) )
		,AngularAcceleration( getPxRigidBody_AngularAcceleration( inSource ) )
		,RigidBodyFlags( getPxRigidBody_RigidBodyFlags( inSource ) )
		,MinCCDAdvanceCoefficient( getPxRigidBody_MinCCDAdvanceCoefficient( inSource ) )
		,MaxDepenetrationVelocity( getPxRigidBody_MaxDepenetrationVelocity( inSource ) )
		,MaxContactImpulse( getPxRigidBody_MaxContactImpulse( inSource ) )
		,ContactSlopCoefficient( getPxRigidBody_ContactSlopCoefficient( inSource ) )
{
	PX_UNUSED(inSource);
}
_Bool getPxRigidDynamic_IsSleeping( const PxRigidDynamic* inObj ) { return inObj->isSleeping(); }
void setPxRigidDynamic_SleepThreshold( PxRigidDynamic* inObj, PxReal inArg){ inObj->setSleepThreshold( inArg ); }
PxReal getPxRigidDynamic_SleepThreshold( const PxRigidDynamic* inObj ) { return inObj->getSleepThreshold(); }
void setPxRigidDynamic_StabilizationThreshold( PxRigidDynamic* inObj, PxReal inArg){ inObj->setStabilizationThreshold( inArg ); }
PxReal getPxRigidDynamic_StabilizationThreshold( const PxRigidDynamic* inObj ) { return inObj->getStabilizationThreshold(); }
void setPxRigidDynamic_WakeCounter( PxRigidDynamic* inObj, PxReal inArg){ inObj->setWakeCounter( inArg ); }
PxReal getPxRigidDynamic_WakeCounter( const PxRigidDynamic* inObj ) { return inObj->getWakeCounter(); }
void setPxRigidDynamic_RigidDynamicLockFlags( PxRigidDynamic* inObj, PxRigidDynamicLockFlags inArg){ inObj->setRigidDynamicLockFlags( inArg ); }
PxRigidDynamicLockFlags getPxRigidDynamic_RigidDynamicLockFlags( const PxRigidDynamic* inObj ) { return inObj->getRigidDynamicLockFlags(); }
void setPxRigidDynamic_LinearVelocity( PxRigidDynamic* inObj, const PxVec3 & inArg){ inObj->setLinearVelocity( inArg ); }
PxVec3 getPxRigidDynamic_LinearVelocity( const PxRigidDynamic* inObj ) { return inObj->getLinearVelocity(); }
void setPxRigidDynamic_AngularVelocity( PxRigidDynamic* inObj, const PxVec3 & inArg){ inObj->setAngularVelocity( inArg ); }
PxVec3 getPxRigidDynamic_AngularVelocity( const PxRigidDynamic* inObj ) { return inObj->getAngularVelocity(); }
void setPxRigidDynamic_SolverIterationCounts( PxRigidDynamic* inObj, PxU32 inArg0, PxU32 inArg1 ) { inObj->setSolverIterationCounts( inArg0, inArg1 ); }
void getPxRigidDynamic_SolverIterationCounts( const PxRigidDynamic* inObj, PxU32& inArg0, PxU32& inArg1 ) { inObj->getSolverIterationCounts( inArg0, inArg1 ); }
void setPxRigidDynamic_ContactReportThreshold( PxRigidDynamic* inObj, PxReal inArg){ inObj->setContactReportThreshold( inArg ); }
PxReal getPxRigidDynamic_ContactReportThreshold( const PxRigidDynamic* inObj ) { return inObj->getContactReportThreshold(); }
const char * getPxRigidDynamic_ConcreteTypeName( const PxRigidDynamic* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxRigidDynamicGeneratedInfo::PxRigidDynamicGeneratedInfo()
	: IsSleeping( "IsSleeping", getPxRigidDynamic_IsSleeping)
	, SleepThreshold( "SleepThreshold", setPxRigidDynamic_SleepThreshold, getPxRigidDynamic_SleepThreshold)
	, StabilizationThreshold( "StabilizationThreshold", setPxRigidDynamic_StabilizationThreshold, getPxRigidDynamic_StabilizationThreshold)
	, WakeCounter( "WakeCounter", setPxRigidDynamic_WakeCounter, getPxRigidDynamic_WakeCounter)
	, RigidDynamicLockFlags( "RigidDynamicLockFlags", setPxRigidDynamic_RigidDynamicLockFlags, getPxRigidDynamic_RigidDynamicLockFlags)
	, LinearVelocity( "LinearVelocity", setPxRigidDynamic_LinearVelocity, getPxRigidDynamic_LinearVelocity)
	, AngularVelocity( "AngularVelocity", setPxRigidDynamic_AngularVelocity, getPxRigidDynamic_AngularVelocity)
	, SolverIterationCounts( "SolverIterationCounts", "minPositionIters", "minVelocityIters", setPxRigidDynamic_SolverIterationCounts, getPxRigidDynamic_SolverIterationCounts)
	, ContactReportThreshold( "ContactReportThreshold", setPxRigidDynamic_ContactReportThreshold, getPxRigidDynamic_ContactReportThreshold)
	, ConcreteTypeName( "ConcreteTypeName", getPxRigidDynamic_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxRigidDynamicGeneratedValues::PxRigidDynamicGeneratedValues( const PxRigidDynamic* inSource )
		:PxRigidBodyGeneratedValues( inSource )
		,IsSleeping( getPxRigidDynamic_IsSleeping( inSource ) )
		,SleepThreshold( getPxRigidDynamic_SleepThreshold( inSource ) )
		,StabilizationThreshold( getPxRigidDynamic_StabilizationThreshold( inSource ) )
		,WakeCounter( getPxRigidDynamic_WakeCounter( inSource ) )
		,RigidDynamicLockFlags( getPxRigidDynamic_RigidDynamicLockFlags( inSource ) )
		,LinearVelocity( getPxRigidDynamic_LinearVelocity( inSource ) )
		,AngularVelocity( getPxRigidDynamic_AngularVelocity( inSource ) )
		,ContactReportThreshold( getPxRigidDynamic_ContactReportThreshold( inSource ) )
		,ConcreteTypeName( getPxRigidDynamic_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
	getPxRigidDynamic_SolverIterationCounts( inSource, SolverIterationCounts[0], SolverIterationCounts[1] );
}
const char * getPxRigidStatic_ConcreteTypeName( const PxRigidStatic* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxRigidStaticGeneratedInfo::PxRigidStaticGeneratedInfo()
	: ConcreteTypeName( "ConcreteTypeName", getPxRigidStatic_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxRigidStaticGeneratedValues::PxRigidStaticGeneratedValues( const PxRigidStatic* inSource )
		:PxRigidActorGeneratedValues( inSource )
		,ConcreteTypeName( getPxRigidStatic_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
PxArticulationJointReducedCoordinate * getPxArticulationLink_InboundJoint( const PxArticulationLink* inObj ) { return inObj->getInboundJoint(); }
PxU32 getPxArticulationLink_InboundJointDof( const PxArticulationLink* inObj ) { return inObj->getInboundJointDof(); }
PxU32 getPxArticulationLink_LinkIndex( const PxArticulationLink* inObj ) { return inObj->getLinkIndex(); }
PxU32 getPxArticulationLink_Children( const PxArticulationLink* inObj, PxArticulationLink ** outBuffer, PxU32 inBufSize ) { return inObj->getChildren( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationLink_Children( const PxArticulationLink* inObj ) { return inObj->getNbChildren(  ); }
void setPxArticulationLink_CfmScale( PxArticulationLink* inObj, const PxReal inArg){ inObj->setCfmScale( inArg ); }
PxReal getPxArticulationLink_CfmScale( const PxArticulationLink* inObj ) { return inObj->getCfmScale(); }
PxVec3 getPxArticulationLink_LinearVelocity( const PxArticulationLink* inObj ) { return inObj->getLinearVelocity(); }
PxVec3 getPxArticulationLink_AngularVelocity( const PxArticulationLink* inObj ) { return inObj->getAngularVelocity(); }
const char * getPxArticulationLink_ConcreteTypeName( const PxArticulationLink* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxArticulationLinkGeneratedInfo::PxArticulationLinkGeneratedInfo()
	: InboundJoint( "InboundJoint", getPxArticulationLink_InboundJoint)
	, InboundJointDof( "InboundJointDof", getPxArticulationLink_InboundJointDof)
	, LinkIndex( "LinkIndex", getPxArticulationLink_LinkIndex)
	, Children( "Children", getPxArticulationLink_Children, getNbPxArticulationLink_Children )
	, CfmScale( "CfmScale", setPxArticulationLink_CfmScale, getPxArticulationLink_CfmScale)
	, LinearVelocity( "LinearVelocity", getPxArticulationLink_LinearVelocity)
	, AngularVelocity( "AngularVelocity", getPxArticulationLink_AngularVelocity)
	, ConcreteTypeName( "ConcreteTypeName", getPxArticulationLink_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxArticulationLinkGeneratedValues::PxArticulationLinkGeneratedValues( const PxArticulationLink* inSource )
		:PxRigidBodyGeneratedValues( inSource )
		,InboundJoint( getPxArticulationLink_InboundJoint( inSource ) )
		,InboundJointDof( getPxArticulationLink_InboundJointDof( inSource ) )
		,LinkIndex( getPxArticulationLink_LinkIndex( inSource ) )
		,CfmScale( getPxArticulationLink_CfmScale( inSource ) )
		,LinearVelocity( getPxArticulationLink_LinearVelocity( inSource ) )
		,AngularVelocity( getPxArticulationLink_AngularVelocity( inSource ) )
		,ConcreteTypeName( getPxArticulationLink_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxArticulationJointReducedCoordinate_ParentPose( PxArticulationJointReducedCoordinate* inObj, const PxTransform & inArg){ inObj->setParentPose( inArg ); }
PxTransform getPxArticulationJointReducedCoordinate_ParentPose( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getParentPose(); }
void setPxArticulationJointReducedCoordinate_ChildPose( PxArticulationJointReducedCoordinate* inObj, const PxTransform & inArg){ inObj->setChildPose( inArg ); }
PxTransform getPxArticulationJointReducedCoordinate_ChildPose( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getChildPose(); }
void setPxArticulationJointReducedCoordinate_JointType( PxArticulationJointReducedCoordinate* inObj, PxArticulationJointType::Enum inArg){ inObj->setJointType( inArg ); }
PxArticulationJointType::Enum getPxArticulationJointReducedCoordinate_JointType( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getJointType(); }
void setPxArticulationJointReducedCoordinate_Motion( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxArticulationMotion::Enum inArg ){ inObj->setMotion( inIndex, inArg ); }
PxArticulationMotion::Enum getPxArticulationJointReducedCoordinate_Motion( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getMotion( inIndex ); }
void setPxArticulationJointReducedCoordinate_LimitParams( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxArticulationLimit inArg ){ inObj->setLimitParams( inIndex, inArg ); }
PxArticulationLimit getPxArticulationJointReducedCoordinate_LimitParams( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getLimitParams( inIndex ); }
void setPxArticulationJointReducedCoordinate_DriveParams( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxArticulationDrive inArg ){ inObj->setDriveParams( inIndex, inArg ); }
PxArticulationDrive getPxArticulationJointReducedCoordinate_DriveParams( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getDriveParams( inIndex ); }
void setPxArticulationJointReducedCoordinate_Armature( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxReal inArg ){ inObj->setArmature( inIndex, inArg ); }
PxReal getPxArticulationJointReducedCoordinate_Armature( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getArmature( inIndex ); }
void setPxArticulationJointReducedCoordinate_FrictionCoefficient( PxArticulationJointReducedCoordinate* inObj, const PxReal inArg){ inObj->setFrictionCoefficient( inArg ); }
PxReal getPxArticulationJointReducedCoordinate_FrictionCoefficient( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getFrictionCoefficient(); }
void setPxArticulationJointReducedCoordinate_FrictionParams( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxJointFrictionParams inArg ){ inObj->setFrictionParams( inIndex, inArg ); }
PxJointFrictionParams getPxArticulationJointReducedCoordinate_FrictionParams( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getFrictionParams( inIndex ); }
void setPxArticulationJointReducedCoordinate_MaxJointVelocity( PxArticulationJointReducedCoordinate* inObj, const PxReal inArg){ inObj->setMaxJointVelocity( inArg ); }
PxReal getPxArticulationJointReducedCoordinate_MaxJointVelocity( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getMaxJointVelocity(); }
void setPxArticulationJointReducedCoordinate_JointPosition( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxReal inArg ){ inObj->setJointPosition( inIndex, inArg ); }
PxReal getPxArticulationJointReducedCoordinate_JointPosition( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getJointPosition( inIndex ); }
void setPxArticulationJointReducedCoordinate_JointVelocity( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxReal inArg ){ inObj->setJointVelocity( inIndex, inArg ); }
PxReal getPxArticulationJointReducedCoordinate_JointVelocity( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getJointVelocity( inIndex ); }
const char * getPxArticulationJointReducedCoordinate_ConcreteTypeName( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getConcreteTypeName(); }
void setPxArticulationJointReducedCoordinate_Name( PxArticulationJointReducedCoordinate* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxArticulationJointReducedCoordinate_Name( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getName(); }
inline void * getPxArticulationJointReducedCoordinateUserData( const PxArticulationJointReducedCoordinate* inOwner ) { return inOwner->userData; }
inline void setPxArticulationJointReducedCoordinateUserData( PxArticulationJointReducedCoordinate* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedInfo::PxArticulationJointReducedCoordinateGeneratedInfo()
	: ParentPose( "ParentPose", setPxArticulationJointReducedCoordinate_ParentPose, getPxArticulationJointReducedCoordinate_ParentPose)
	, ChildPose( "ChildPose", setPxArticulationJointReducedCoordinate_ChildPose, getPxArticulationJointReducedCoordinate_ChildPose)
	, JointType( "JointType", setPxArticulationJointReducedCoordinate_JointType, getPxArticulationJointReducedCoordinate_JointType)
	, Motion( "Motion", setPxArticulationJointReducedCoordinate_Motion, getPxArticulationJointReducedCoordinate_Motion)
	, LimitParams( "LimitParams", setPxArticulationJointReducedCoordinate_LimitParams, getPxArticulationJointReducedCoordinate_LimitParams)
	, DriveParams( "DriveParams", setPxArticulationJointReducedCoordinate_DriveParams, getPxArticulationJointReducedCoordinate_DriveParams)
	, Armature( "Armature", setPxArticulationJointReducedCoordinate_Armature, getPxArticulationJointReducedCoordinate_Armature)
	, FrictionCoefficient( "FrictionCoefficient", setPxArticulationJointReducedCoordinate_FrictionCoefficient, getPxArticulationJointReducedCoordinate_FrictionCoefficient)
	, FrictionParams( "FrictionParams", setPxArticulationJointReducedCoordinate_FrictionParams, getPxArticulationJointReducedCoordinate_FrictionParams)
	, MaxJointVelocity( "MaxJointVelocity", setPxArticulationJointReducedCoordinate_MaxJointVelocity, getPxArticulationJointReducedCoordinate_MaxJointVelocity)
	, JointPosition( "JointPosition", setPxArticulationJointReducedCoordinate_JointPosition, getPxArticulationJointReducedCoordinate_JointPosition)
	, JointVelocity( "JointVelocity", setPxArticulationJointReducedCoordinate_JointVelocity, getPxArticulationJointReducedCoordinate_JointVelocity)
	, ConcreteTypeName( "ConcreteTypeName", getPxArticulationJointReducedCoordinate_ConcreteTypeName)
	, Name( "Name", setPxArticulationJointReducedCoordinate_Name, getPxArticulationJointReducedCoordinate_Name)
	, UserData( "UserData", setPxArticulationJointReducedCoordinateUserData, getPxArticulationJointReducedCoordinateUserData )
{}
PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedValues::PxArticulationJointReducedCoordinateGeneratedValues( const PxArticulationJointReducedCoordinate* inSource )
		:ParentPose( getPxArticulationJointReducedCoordinate_ParentPose( inSource ) )
		,ChildPose( getPxArticulationJointReducedCoordinate_ChildPose( inSource ) )
		,JointType( getPxArticulationJointReducedCoordinate_JointType( inSource ) )
		,FrictionCoefficient( getPxArticulationJointReducedCoordinate_FrictionCoefficient( inSource ) )
		,MaxJointVelocity( getPxArticulationJointReducedCoordinate_MaxJointVelocity( inSource ) )
		,ConcreteTypeName( getPxArticulationJointReducedCoordinate_ConcreteTypeName( inSource ) )
		,Name( getPxArticulationJointReducedCoordinate_Name( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		Motion[idx] = getPxArticulationJointReducedCoordinate_Motion( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		LimitParams[idx] = getPxArticulationJointReducedCoordinate_LimitParams( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		DriveParams[idx] = getPxArticulationJointReducedCoordinate_DriveParams( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		Armature[idx] = getPxArticulationJointReducedCoordinate_Armature( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		FrictionParams[idx] = getPxArticulationJointReducedCoordinate_FrictionParams( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		JointPosition[idx] = getPxArticulationJointReducedCoordinate_JointPosition( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		JointVelocity[idx] = getPxArticulationJointReducedCoordinate_JointVelocity( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
}
PxScene * getPxArticulationReducedCoordinate_Scene( const PxArticulationReducedCoordinate* inObj ) { return inObj->getScene(); }
void setPxArticulationReducedCoordinate_SolverIterationCounts( PxArticulationReducedCoordinate* inObj, PxU32 inArg0, PxU32 inArg1 ) { inObj->setSolverIterationCounts( inArg0, inArg1 ); }
void getPxArticulationReducedCoordinate_SolverIterationCounts( const PxArticulationReducedCoordinate* inObj, PxU32& inArg0, PxU32& inArg1 ) { inObj->getSolverIterationCounts( inArg0, inArg1 ); }
_Bool getPxArticulationReducedCoordinate_IsSleeping( const PxArticulationReducedCoordinate* inObj ) { return inObj->isSleeping(); }
void setPxArticulationReducedCoordinate_SleepThreshold( PxArticulationReducedCoordinate* inObj, PxReal inArg){ inObj->setSleepThreshold( inArg ); }
PxReal getPxArticulationReducedCoordinate_SleepThreshold( const PxArticulationReducedCoordinate* inObj ) { return inObj->getSleepThreshold(); }
void setPxArticulationReducedCoordinate_StabilizationThreshold( PxArticulationReducedCoordinate* inObj, PxReal inArg){ inObj->setStabilizationThreshold( inArg ); }
PxReal getPxArticulationReducedCoordinate_StabilizationThreshold( const PxArticulationReducedCoordinate* inObj ) { return inObj->getStabilizationThreshold(); }
void setPxArticulationReducedCoordinate_WakeCounter( PxArticulationReducedCoordinate* inObj, PxReal inArg){ inObj->setWakeCounter( inArg ); }
PxReal getPxArticulationReducedCoordinate_WakeCounter( const PxArticulationReducedCoordinate* inObj ) { return inObj->getWakeCounter(); }
PxU32 getPxArticulationReducedCoordinate_Links( const PxArticulationReducedCoordinate* inObj, PxArticulationLink ** outBuffer, PxU32 inBufSize ) { return inObj->getLinks( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationReducedCoordinate_Links( const PxArticulationReducedCoordinate* inObj ) { return inObj->getNbLinks(  ); }
void setPxArticulationReducedCoordinate_Name( PxArticulationReducedCoordinate* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxArticulationReducedCoordinate_Name( const PxArticulationReducedCoordinate* inObj ) { return inObj->getName(); }
PxAggregate * getPxArticulationReducedCoordinate_Aggregate( const PxArticulationReducedCoordinate* inObj ) { return inObj->getAggregate(); }
void setPxArticulationReducedCoordinate_ArticulationFlags( PxArticulationReducedCoordinate* inObj, PxArticulationFlags inArg){ inObj->setArticulationFlags( inArg ); }
PxArticulationFlags getPxArticulationReducedCoordinate_ArticulationFlags( const PxArticulationReducedCoordinate* inObj ) { return inObj->getArticulationFlags(); }
void setPxArticulationReducedCoordinate_RootGlobalPose( PxArticulationReducedCoordinate* inObj, const PxTransform & inArg){ inObj->setRootGlobalPose( inArg ); }
PxTransform getPxArticulationReducedCoordinate_RootGlobalPose( const PxArticulationReducedCoordinate* inObj ) { return inObj->getRootGlobalPose(); }
void setPxArticulationReducedCoordinate_RootLinearVelocity( PxArticulationReducedCoordinate* inObj, const PxVec3 & inArg){ inObj->setRootLinearVelocity( inArg ); }
PxVec3 getPxArticulationReducedCoordinate_RootLinearVelocity( const PxArticulationReducedCoordinate* inObj ) { return inObj->getRootLinearVelocity(); }
void setPxArticulationReducedCoordinate_RootAngularVelocity( PxArticulationReducedCoordinate* inObj, const PxVec3 & inArg){ inObj->setRootAngularVelocity( inArg ); }
PxVec3 getPxArticulationReducedCoordinate_RootAngularVelocity( const PxArticulationReducedCoordinate* inObj ) { return inObj->getRootAngularVelocity(); }
PxU32 getPxArticulationReducedCoordinate_SpatialTendons( const PxArticulationReducedCoordinate* inObj, PxArticulationSpatialTendon ** outBuffer, PxU32 inBufSize ) { return inObj->getSpatialTendons( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationReducedCoordinate_SpatialTendons( const PxArticulationReducedCoordinate* inObj ) { return inObj->getNbSpatialTendons(  ); }
PxU32 getPxArticulationReducedCoordinate_FixedTendons( const PxArticulationReducedCoordinate* inObj, PxArticulationFixedTendon ** outBuffer, PxU32 inBufSize ) { return inObj->getFixedTendons( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationReducedCoordinate_FixedTendons( const PxArticulationReducedCoordinate* inObj ) { return inObj->getNbFixedTendons(  ); }
PxU32 getPxArticulationReducedCoordinate_MimicJoints( const PxArticulationReducedCoordinate* inObj, PxArticulationMimicJoint ** outBuffer, PxU32 inBufSize ) { return inObj->getMimicJoints( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationReducedCoordinate_MimicJoints( const PxArticulationReducedCoordinate* inObj ) { return inObj->getNbMimicJoints(  ); }
const char * getPxArticulationReducedCoordinate_ConcreteTypeName( const PxArticulationReducedCoordinate* inObj ) { return inObj->getConcreteTypeName(); }
inline void * getPxArticulationReducedCoordinateUserData( const PxArticulationReducedCoordinate* inOwner ) { return inOwner->userData; }
inline void setPxArticulationReducedCoordinateUserData( PxArticulationReducedCoordinate* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxArticulationReducedCoordinateGeneratedInfo::PxArticulationReducedCoordinateGeneratedInfo()
	: Scene( "Scene", getPxArticulationReducedCoordinate_Scene)
	, SolverIterationCounts( "SolverIterationCounts", "minPositionIters", "minVelocityIters", setPxArticulationReducedCoordinate_SolverIterationCounts, getPxArticulationReducedCoordinate_SolverIterationCounts)
	, IsSleeping( "IsSleeping", getPxArticulationReducedCoordinate_IsSleeping)
	, SleepThreshold( "SleepThreshold", setPxArticulationReducedCoordinate_SleepThreshold, getPxArticulationReducedCoordinate_SleepThreshold)
	, StabilizationThreshold( "StabilizationThreshold", setPxArticulationReducedCoordinate_StabilizationThreshold, getPxArticulationReducedCoordinate_StabilizationThreshold)
	, WakeCounter( "WakeCounter", setPxArticulationReducedCoordinate_WakeCounter, getPxArticulationReducedCoordinate_WakeCounter)
	, Links( "Links", getPxArticulationReducedCoordinate_Links, getNbPxArticulationReducedCoordinate_Links )
	, Name( "Name", setPxArticulationReducedCoordinate_Name, getPxArticulationReducedCoordinate_Name)
	, Aggregate( "Aggregate", getPxArticulationReducedCoordinate_Aggregate)
	, ArticulationFlags( "ArticulationFlags", setPxArticulationReducedCoordinate_ArticulationFlags, getPxArticulationReducedCoordinate_ArticulationFlags)
	, RootGlobalPose( "RootGlobalPose", setPxArticulationReducedCoordinate_RootGlobalPose, getPxArticulationReducedCoordinate_RootGlobalPose)
	, RootLinearVelocity( "RootLinearVelocity", setPxArticulationReducedCoordinate_RootLinearVelocity, getPxArticulationReducedCoordinate_RootLinearVelocity)
	, RootAngularVelocity( "RootAngularVelocity", setPxArticulationReducedCoordinate_RootAngularVelocity, getPxArticulationReducedCoordinate_RootAngularVelocity)
	, SpatialTendons( "SpatialTendons", getPxArticulationReducedCoordinate_SpatialTendons, getNbPxArticulationReducedCoordinate_SpatialTendons )
	, FixedTendons( "FixedTendons", getPxArticulationReducedCoordinate_FixedTendons, getNbPxArticulationReducedCoordinate_FixedTendons )
	, MimicJoints( "MimicJoints", getPxArticulationReducedCoordinate_MimicJoints, getNbPxArticulationReducedCoordinate_MimicJoints )
	, ConcreteTypeName( "ConcreteTypeName", getPxArticulationReducedCoordinate_ConcreteTypeName)
	, UserData( "UserData", setPxArticulationReducedCoordinateUserData, getPxArticulationReducedCoordinateUserData )
{}
PX_PHYSX_CORE_API PxArticulationReducedCoordinateGeneratedValues::PxArticulationReducedCoordinateGeneratedValues( const PxArticulationReducedCoordinate* inSource )
		:Scene( getPxArticulationReducedCoordinate_Scene( inSource ) )
		,IsSleeping( getPxArticulationReducedCoordinate_IsSleeping( inSource ) )
		,SleepThreshold( getPxArticulationReducedCoordinate_SleepThreshold( inSource ) )
		,StabilizationThreshold( getPxArticulationReducedCoordinate_StabilizationThreshold( inSource ) )
		,WakeCounter( getPxArticulationReducedCoordinate_WakeCounter( inSource ) )
		,Name( getPxArticulationReducedCoordinate_Name( inSource ) )
		,Aggregate( getPxArticulationReducedCoordinate_Aggregate( inSource ) )
		,ArticulationFlags( getPxArticulationReducedCoordinate_ArticulationFlags( inSource ) )
		,RootGlobalPose( getPxArticulationReducedCoordinate_RootGlobalPose( inSource ) )
		,RootLinearVelocity( getPxArticulationReducedCoordinate_RootLinearVelocity( inSource ) )
		,RootAngularVelocity( getPxArticulationReducedCoordinate_RootAngularVelocity( inSource ) )
		,ConcreteTypeName( getPxArticulationReducedCoordinate_ConcreteTypeName( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
	getPxArticulationReducedCoordinate_SolverIterationCounts( inSource, SolverIterationCounts[0], SolverIterationCounts[1] );
}
PxU32 getPxAggregate_MaxNbActors( const PxAggregate* inObj ) { return inObj->getMaxNbActors(); }
PxU32 getPxAggregate_MaxNbShapes( const PxAggregate* inObj ) { return inObj->getMaxNbShapes(); }
PxU32 getPxAggregate_Actors( const PxAggregate* inObj, PxActor ** outBuffer, PxU32 inBufSize ) { return inObj->getActors( outBuffer, inBufSize ); }
PxU32 getNbPxAggregate_Actors( const PxAggregate* inObj ) { return inObj->getNbActors(  ); }
_Bool getPxAggregate_SelfCollision( const PxAggregate* inObj ) { return inObj->getSelfCollision(); }
const char * getPxAggregate_ConcreteTypeName( const PxAggregate* inObj ) { return inObj->getConcreteTypeName(); }
inline void * getPxAggregateUserData( const PxAggregate* inOwner ) { return inOwner->userData; }
inline void setPxAggregateUserData( PxAggregate* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxAggregateGeneratedInfo::PxAggregateGeneratedInfo()
	: MaxNbActors( "MaxNbActors", getPxAggregate_MaxNbActors)
	, MaxNbShapes( "MaxNbShapes", getPxAggregate_MaxNbShapes)
	, Actors( "Actors", getPxAggregate_Actors, getNbPxAggregate_Actors )
	, SelfCollision( "SelfCollision", getPxAggregate_SelfCollision)
	, ConcreteTypeName( "ConcreteTypeName", getPxAggregate_ConcreteTypeName)
	, UserData( "UserData", setPxAggregateUserData, getPxAggregateUserData )
{}
PX_PHYSX_CORE_API PxAggregateGeneratedValues::PxAggregateGeneratedValues( const PxAggregate* inSource )
		:MaxNbActors( getPxAggregate_MaxNbActors( inSource ) )
		,MaxNbShapes( getPxAggregate_MaxNbShapes( inSource ) )
		,SelfCollision( getPxAggregate_SelfCollision( inSource ) )
		,ConcreteTypeName( getPxAggregate_ConcreteTypeName( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
}
PxScene * getPxConstraint_Scene( const PxConstraint* inObj ) { return inObj->getScene(); }
void setPxConstraint_Actors( PxConstraint* inObj, PxRigidActor * inArg0, PxRigidActor * inArg1 ) { inObj->setActors( inArg0, inArg1 ); }
void getPxConstraint_Actors( const PxConstraint* inObj, PxRigidActor *& inArg0, PxRigidActor *& inArg1 ) { inObj->getActors( inArg0, inArg1 ); }
void setPxConstraint_Flags( PxConstraint* inObj, PxConstraintFlags inArg){ inObj->setFlags( inArg ); }
PxConstraintFlags getPxConstraint_Flags( const PxConstraint* inObj ) { return inObj->getFlags(); }
_Bool getPxConstraint_IsValid( const PxConstraint* inObj ) { return inObj->isValid(); }
void setPxConstraint_BreakForce( PxConstraint* inObj, PxReal inArg0, PxReal inArg1 ) { inObj->setBreakForce( inArg0, inArg1 ); }
void getPxConstraint_BreakForce( const PxConstraint* inObj, PxReal& inArg0, PxReal& inArg1 ) { inObj->getBreakForce( inArg0, inArg1 ); }
void setPxConstraint_MinResponseThreshold( PxConstraint* inObj, PxReal inArg){ inObj->setMinResponseThreshold( inArg ); }
PxReal getPxConstraint_MinResponseThreshold( const PxConstraint* inObj ) { return inObj->getMinResponseThreshold(); }
const char * getPxConstraint_ConcreteTypeName( const PxConstraint* inObj ) { return inObj->getConcreteTypeName(); }
inline void * getPxConstraintUserData( const PxConstraint* inOwner ) { return inOwner->userData; }
inline void setPxConstraintUserData( PxConstraint* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxConstraintGeneratedInfo::PxConstraintGeneratedInfo()
	: Scene( "Scene", getPxConstraint_Scene)
	, Actors( "Actors", "actor0", "actor1", setPxConstraint_Actors, getPxConstraint_Actors)
	, Flags( "Flags", setPxConstraint_Flags, getPxConstraint_Flags)
	, IsValid( "IsValid", getPxConstraint_IsValid)
	, BreakForce( "BreakForce", "linear", "angular", setPxConstraint_BreakForce, getPxConstraint_BreakForce)
	, MinResponseThreshold( "MinResponseThreshold", setPxConstraint_MinResponseThreshold, getPxConstraint_MinResponseThreshold)
	, ConcreteTypeName( "ConcreteTypeName", getPxConstraint_ConcreteTypeName)
	, UserData( "UserData", setPxConstraintUserData, getPxConstraintUserData )
{}
PX_PHYSX_CORE_API PxConstraintGeneratedValues::PxConstraintGeneratedValues( const PxConstraint* inSource )
		:Scene( getPxConstraint_Scene( inSource ) )
		,Flags( getPxConstraint_Flags( inSource ) )
		,IsValid( getPxConstraint_IsValid( inSource ) )
		,MinResponseThreshold( getPxConstraint_MinResponseThreshold( inSource ) )
		,ConcreteTypeName( getPxConstraint_ConcreteTypeName( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
	getPxConstraint_Actors( inSource, Actors[0], Actors[1] );
	getPxConstraint_BreakForce( inSource, BreakForce[0], BreakForce[1] );
}
void setPxShape_LocalPose( PxShape* inObj, const PxTransform & inArg){ inObj->setLocalPose( inArg ); }
PxTransform getPxShape_LocalPose( const PxShape* inObj ) { return inObj->getLocalPose(); }
void setPxShape_SimulationFilterData( PxShape* inObj, const PxFilterData & inArg){ inObj->setSimulationFilterData( inArg ); }
PxFilterData getPxShape_SimulationFilterData( const PxShape* inObj ) { return inObj->getSimulationFilterData(); }
void setPxShape_QueryFilterData( PxShape* inObj, const PxFilterData & inArg){ inObj->setQueryFilterData( inArg ); }
PxFilterData getPxShape_QueryFilterData( const PxShape* inObj ) { return inObj->getQueryFilterData(); }
PxU32 getPxShape_Materials( const PxShape* inObj, PxMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxShape_Materials( const PxShape* inObj ) { return inObj->getNbMaterials(  ); }
void setPxShape_ContactOffset( PxShape* inObj, PxReal inArg){ inObj->setContactOffset( inArg ); }
PxReal getPxShape_ContactOffset( const PxShape* inObj ) { return inObj->getContactOffset(); }
void setPxShape_RestOffset( PxShape* inObj, PxReal inArg){ inObj->setRestOffset( inArg ); }
PxReal getPxShape_RestOffset( const PxShape* inObj ) { return inObj->getRestOffset(); }
void setPxShape_DensityForFluid( PxShape* inObj, PxReal inArg){ inObj->setDensityForFluid( inArg ); }
PxReal getPxShape_DensityForFluid( const PxShape* inObj ) { return inObj->getDensityForFluid(); }
void setPxShape_TorsionalPatchRadius( PxShape* inObj, PxReal inArg){ inObj->setTorsionalPatchRadius( inArg ); }
PxReal getPxShape_TorsionalPatchRadius( const PxShape* inObj ) { return inObj->getTorsionalPatchRadius(); }
void setPxShape_MinTorsionalPatchRadius( PxShape* inObj, PxReal inArg){ inObj->setMinTorsionalPatchRadius( inArg ); }
PxReal getPxShape_MinTorsionalPatchRadius( const PxShape* inObj ) { return inObj->getMinTorsionalPatchRadius(); }
void setPxShape_Flags( PxShape* inObj, PxShapeFlags inArg){ inObj->setFlags( inArg ); }
PxShapeFlags getPxShape_Flags( const PxShape* inObj ) { return inObj->getFlags(); }
_Bool getPxShape_IsExclusive( const PxShape* inObj ) { return inObj->isExclusive(); }
void setPxShape_Name( PxShape* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxShape_Name( const PxShape* inObj ) { return inObj->getName(); }
const char * getPxShape_ConcreteTypeName( const PxShape* inObj ) { return inObj->getConcreteTypeName(); }
inline void * getPxShapeUserData( const PxShape* inOwner ) { return inOwner->userData; }
inline void setPxShapeUserData( PxShape* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxShapeGeneratedInfo::PxShapeGeneratedInfo()
	: LocalPose( "LocalPose", setPxShape_LocalPose, getPxShape_LocalPose)
	, SimulationFilterData( "SimulationFilterData", setPxShape_SimulationFilterData, getPxShape_SimulationFilterData)
	, QueryFilterData( "QueryFilterData", setPxShape_QueryFilterData, getPxShape_QueryFilterData)
	, Materials( "Materials", getPxShape_Materials, getNbPxShape_Materials )
	, ContactOffset( "ContactOffset", setPxShape_ContactOffset, getPxShape_ContactOffset)
	, RestOffset( "RestOffset", setPxShape_RestOffset, getPxShape_RestOffset)
	, DensityForFluid( "DensityForFluid", setPxShape_DensityForFluid, getPxShape_DensityForFluid)
	, TorsionalPatchRadius( "TorsionalPatchRadius", setPxShape_TorsionalPatchRadius, getPxShape_TorsionalPatchRadius)
	, MinTorsionalPatchRadius( "MinTorsionalPatchRadius", setPxShape_MinTorsionalPatchRadius, getPxShape_MinTorsionalPatchRadius)
	, Flags( "Flags", setPxShape_Flags, getPxShape_Flags)
	, IsExclusive( "IsExclusive", getPxShape_IsExclusive)
	, Name( "Name", setPxShape_Name, getPxShape_Name)
	, ConcreteTypeName( "ConcreteTypeName", getPxShape_ConcreteTypeName)
	, UserData( "UserData", setPxShapeUserData, getPxShapeUserData )
{}
PX_PHYSX_CORE_API PxShapeGeneratedValues::PxShapeGeneratedValues( const PxShape* inSource )
		:PxRefCountedGeneratedValues( inSource )
		,LocalPose( getPxShape_LocalPose( inSource ) )
		,SimulationFilterData( getPxShape_SimulationFilterData( inSource ) )
		,QueryFilterData( getPxShape_QueryFilterData( inSource ) )
		,ContactOffset( getPxShape_ContactOffset( inSource ) )
		,RestOffset( getPxShape_RestOffset( inSource ) )
		,DensityForFluid( getPxShape_DensityForFluid( inSource ) )
		,TorsionalPatchRadius( getPxShape_TorsionalPatchRadius( inSource ) )
		,MinTorsionalPatchRadius( getPxShape_MinTorsionalPatchRadius( inSource ) )
		,Flags( getPxShape_Flags( inSource ) )
		,IsExclusive( getPxShape_IsExclusive( inSource ) )
		,Name( getPxShape_Name( inSource ) )
		,ConcreteTypeName( getPxShape_ConcreteTypeName( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
	Geom = PxGeometryHolder(inSource->getGeometry());
}
PxU32 getPxPruningStructure_RigidActors( const PxPruningStructure* inObj, PxRigidActor ** outBuffer, PxU32 inBufSize ) { return inObj->getRigidActors( outBuffer, inBufSize ); }
PxU32 getNbPxPruningStructure_RigidActors( const PxPruningStructure* inObj ) { return inObj->getNbRigidActors(  ); }
const void * getPxPruningStructure_StaticMergeData( const PxPruningStructure* inObj ) { return inObj->getStaticMergeData(); }
const void * getPxPruningStructure_DynamicMergeData( const PxPruningStructure* inObj ) { return inObj->getDynamicMergeData(); }
const char * getPxPruningStructure_ConcreteTypeName( const PxPruningStructure* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxPruningStructureGeneratedInfo::PxPruningStructureGeneratedInfo()
	: RigidActors( "RigidActors", getPxPruningStructure_RigidActors, getNbPxPruningStructure_RigidActors )
	, StaticMergeData( "StaticMergeData", getPxPruningStructure_StaticMergeData)
	, DynamicMergeData( "DynamicMergeData", getPxPruningStructure_DynamicMergeData)
	, ConcreteTypeName( "ConcreteTypeName", getPxPruningStructure_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxPruningStructureGeneratedValues::PxPruningStructureGeneratedValues( const PxPruningStructure* inSource )
		:StaticMergeData( getPxPruningStructure_StaticMergeData( inSource ) )
		,DynamicMergeData( getPxPruningStructure_DynamicMergeData( inSource ) )
		,ConcreteTypeName( getPxPruningStructure_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
_Bool getPxTolerancesScale_IsValid( const PxTolerancesScale* inObj ) { return inObj->isValid(); }
inline PxReal getPxTolerancesScaleLength( const PxTolerancesScale* inOwner ) { return inOwner->length; }
inline void setPxTolerancesScaleLength( PxTolerancesScale* inOwner, PxReal inData) { inOwner->length = inData; }
inline PxReal getPxTolerancesScaleSpeed( const PxTolerancesScale* inOwner ) { return inOwner->speed; }
inline void setPxTolerancesScaleSpeed( PxTolerancesScale* inOwner, PxReal inData) { inOwner->speed = inData; }
PX_PHYSX_CORE_API PxTolerancesScaleGeneratedInfo::PxTolerancesScaleGeneratedInfo()
	: IsValid( "IsValid", getPxTolerancesScale_IsValid)
	, Length( "Length", setPxTolerancesScaleLength, getPxTolerancesScaleLength )
	, Speed( "Speed", setPxTolerancesScaleSpeed, getPxTolerancesScaleSpeed )
{}
PX_PHYSX_CORE_API PxTolerancesScaleGeneratedValues::PxTolerancesScaleGeneratedValues( const PxTolerancesScale* inSource )
		:IsValid( getPxTolerancesScale_IsValid( inSource ) )
		,Length( inSource->length )
		,Speed( inSource->speed )
{
	PX_UNUSED(inSource);
}
PX_PHYSX_CORE_API PxGeometryGeneratedInfo::PxGeometryGeneratedInfo()
{}
PX_PHYSX_CORE_API PxGeometryGeneratedValues::PxGeometryGeneratedValues( const PxGeometry* inSource )
{
	PX_UNUSED(inSource);
}
inline PxVec3 getPxBoxGeometryHalfExtents( const PxBoxGeometry* inOwner ) { return inOwner->halfExtents; }
inline void setPxBoxGeometryHalfExtents( PxBoxGeometry* inOwner, PxVec3 inData) { inOwner->halfExtents = inData; }
PX_PHYSX_CORE_API PxBoxGeometryGeneratedInfo::PxBoxGeometryGeneratedInfo()
	: HalfExtents( "HalfExtents", setPxBoxGeometryHalfExtents, getPxBoxGeometryHalfExtents )
{}
PX_PHYSX_CORE_API PxBoxGeometryGeneratedValues::PxBoxGeometryGeneratedValues( const PxBoxGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,HalfExtents( inSource->halfExtents )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxCapsuleGeometryRadius( const PxCapsuleGeometry* inOwner ) { return inOwner->radius; }
inline void setPxCapsuleGeometryRadius( PxCapsuleGeometry* inOwner, PxReal inData) { inOwner->radius = inData; }
inline PxReal getPxCapsuleGeometryHalfHeight( const PxCapsuleGeometry* inOwner ) { return inOwner->halfHeight; }
inline void setPxCapsuleGeometryHalfHeight( PxCapsuleGeometry* inOwner, PxReal inData) { inOwner->halfHeight = inData; }
PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedInfo::PxCapsuleGeometryGeneratedInfo()
	: Radius( "Radius", setPxCapsuleGeometryRadius, getPxCapsuleGeometryRadius )
	, HalfHeight( "HalfHeight", setPxCapsuleGeometryHalfHeight, getPxCapsuleGeometryHalfHeight )
{}
PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedValues::PxCapsuleGeometryGeneratedValues( const PxCapsuleGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Radius( inSource->radius )
		,HalfHeight( inSource->halfHeight )
{
	PX_UNUSED(inSource);
}
inline PxVec3 getPxMeshScaleScale( const PxMeshScale* inOwner ) { return inOwner->scale; }
inline void setPxMeshScaleScale( PxMeshScale* inOwner, PxVec3 inData) { inOwner->scale = inData; }
inline PxQuat getPxMeshScaleRotation( const PxMeshScale* inOwner ) { return inOwner->rotation; }
inline void setPxMeshScaleRotation( PxMeshScale* inOwner, PxQuat inData) { inOwner->rotation = inData; }
PX_PHYSX_CORE_API PxMeshScaleGeneratedInfo::PxMeshScaleGeneratedInfo()
	: Scale( "Scale", setPxMeshScaleScale, getPxMeshScaleScale )
	, Rotation( "Rotation", setPxMeshScaleRotation, getPxMeshScaleRotation )
{}
PX_PHYSX_CORE_API PxMeshScaleGeneratedValues::PxMeshScaleGeneratedValues( const PxMeshScale* inSource )
		:Scale( inSource->scale )
		,Rotation( inSource->rotation )
{
	PX_UNUSED(inSource);
}
inline PxMeshScale getPxConvexMeshGeometryScale( const PxConvexMeshGeometry* inOwner ) { return inOwner->scale; }
inline void setPxConvexMeshGeometryScale( PxConvexMeshGeometry* inOwner, PxMeshScale inData) { inOwner->scale = inData; }
inline PxConvexMesh * getPxConvexMeshGeometryConvexMesh( const PxConvexMeshGeometry* inOwner ) { return inOwner->convexMesh; }
inline void setPxConvexMeshGeometryConvexMesh( PxConvexMeshGeometry* inOwner, PxConvexMesh * inData) { inOwner->convexMesh = inData; }
inline PxConvexMeshGeometryFlags getPxConvexMeshGeometryMeshFlags( const PxConvexMeshGeometry* inOwner ) { return inOwner->meshFlags; }
inline void setPxConvexMeshGeometryMeshFlags( PxConvexMeshGeometry* inOwner, PxConvexMeshGeometryFlags inData) { inOwner->meshFlags = inData; }
PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedInfo::PxConvexMeshGeometryGeneratedInfo()
	: Scale( "Scale", setPxConvexMeshGeometryScale, getPxConvexMeshGeometryScale )
	, ConvexMesh( "ConvexMesh", setPxConvexMeshGeometryConvexMesh, getPxConvexMeshGeometryConvexMesh )
	, MeshFlags( "MeshFlags", setPxConvexMeshGeometryMeshFlags, getPxConvexMeshGeometryMeshFlags )
{}
PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedValues::PxConvexMeshGeometryGeneratedValues( const PxConvexMeshGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Scale( inSource->scale )
		,ConvexMesh( inSource->convexMesh )
		,MeshFlags( inSource->meshFlags )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxSphereGeometryRadius( const PxSphereGeometry* inOwner ) { return inOwner->radius; }
inline void setPxSphereGeometryRadius( PxSphereGeometry* inOwner, PxReal inData) { inOwner->radius = inData; }
PX_PHYSX_CORE_API PxSphereGeometryGeneratedInfo::PxSphereGeometryGeneratedInfo()
	: Radius( "Radius", setPxSphereGeometryRadius, getPxSphereGeometryRadius )
{}
PX_PHYSX_CORE_API PxSphereGeometryGeneratedValues::PxSphereGeometryGeneratedValues( const PxSphereGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Radius( inSource->radius )
{
	PX_UNUSED(inSource);
}
PX_PHYSX_CORE_API PxPlaneGeometryGeneratedInfo::PxPlaneGeometryGeneratedInfo()
{}
PX_PHYSX_CORE_API PxPlaneGeometryGeneratedValues::PxPlaneGeometryGeneratedValues( const PxPlaneGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
{
	PX_UNUSED(inSource);
}
inline PxMeshScale getPxTriangleMeshGeometryScale( const PxTriangleMeshGeometry* inOwner ) { return inOwner->scale; }
inline void setPxTriangleMeshGeometryScale( PxTriangleMeshGeometry* inOwner, PxMeshScale inData) { inOwner->scale = inData; }
inline PxMeshGeometryFlags getPxTriangleMeshGeometryMeshFlags( const PxTriangleMeshGeometry* inOwner ) { return inOwner->meshFlags; }
inline void setPxTriangleMeshGeometryMeshFlags( PxTriangleMeshGeometry* inOwner, PxMeshGeometryFlags inData) { inOwner->meshFlags = inData; }
inline PxTriangleMesh * getPxTriangleMeshGeometryTriangleMesh( const PxTriangleMeshGeometry* inOwner ) { return inOwner->triangleMesh; }
inline void setPxTriangleMeshGeometryTriangleMesh( PxTriangleMeshGeometry* inOwner, PxTriangleMesh * inData) { inOwner->triangleMesh = inData; }
PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedInfo::PxTriangleMeshGeometryGeneratedInfo()
	: Scale( "Scale", setPxTriangleMeshGeometryScale, getPxTriangleMeshGeometryScale )
	, MeshFlags( "MeshFlags", setPxTriangleMeshGeometryMeshFlags, getPxTriangleMeshGeometryMeshFlags )
	, TriangleMesh( "TriangleMesh", setPxTriangleMeshGeometryTriangleMesh, getPxTriangleMeshGeometryTriangleMesh )
{}
PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedValues::PxTriangleMeshGeometryGeneratedValues( const PxTriangleMeshGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Scale( inSource->scale )
		,MeshFlags( inSource->meshFlags )
		,TriangleMesh( inSource->triangleMesh )
{
	PX_UNUSED(inSource);
}
inline PxHeightField * getPxHeightFieldGeometryHeightField( const PxHeightFieldGeometry* inOwner ) { return inOwner->heightField; }
inline void setPxHeightFieldGeometryHeightField( PxHeightFieldGeometry* inOwner, PxHeightField * inData) { inOwner->heightField = inData; }
inline PxReal getPxHeightFieldGeometryHeightScale( const PxHeightFieldGeometry* inOwner ) { return inOwner->heightScale; }
inline void setPxHeightFieldGeometryHeightScale( PxHeightFieldGeometry* inOwner, PxReal inData) { inOwner->heightScale = inData; }
inline PxReal getPxHeightFieldGeometryRowScale( const PxHeightFieldGeometry* inOwner ) { return inOwner->rowScale; }
inline void setPxHeightFieldGeometryRowScale( PxHeightFieldGeometry* inOwner, PxReal inData) { inOwner->rowScale = inData; }
inline PxReal getPxHeightFieldGeometryColumnScale( const PxHeightFieldGeometry* inOwner ) { return inOwner->columnScale; }
inline void setPxHeightFieldGeometryColumnScale( PxHeightFieldGeometry* inOwner, PxReal inData) { inOwner->columnScale = inData; }
inline PxMeshGeometryFlags getPxHeightFieldGeometryHeightFieldFlags( const PxHeightFieldGeometry* inOwner ) { return inOwner->heightFieldFlags; }
inline void setPxHeightFieldGeometryHeightFieldFlags( PxHeightFieldGeometry* inOwner, PxMeshGeometryFlags inData) { inOwner->heightFieldFlags = inData; }
PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedInfo::PxHeightFieldGeometryGeneratedInfo()
	: HeightField( "HeightField", setPxHeightFieldGeometryHeightField, getPxHeightFieldGeometryHeightField )
	, HeightScale( "HeightScale", setPxHeightFieldGeometryHeightScale, getPxHeightFieldGeometryHeightScale )
	, RowScale( "RowScale", setPxHeightFieldGeometryRowScale, getPxHeightFieldGeometryRowScale )
	, ColumnScale( "ColumnScale", setPxHeightFieldGeometryColumnScale, getPxHeightFieldGeometryColumnScale )
	, HeightFieldFlags( "HeightFieldFlags", setPxHeightFieldGeometryHeightFieldFlags, getPxHeightFieldGeometryHeightFieldFlags )
{}
PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedValues::PxHeightFieldGeometryGeneratedValues( const PxHeightFieldGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,HeightField( inSource->heightField )
		,HeightScale( inSource->heightScale )
		,RowScale( inSource->rowScale )
		,ColumnScale( inSource->columnScale )
		,HeightFieldFlags( inSource->heightFieldFlags )
{
	PX_UNUSED(inSource);
}
void setPxSceneQuerySystemBase_DynamicTreeRebuildRateHint( PxSceneQuerySystemBase* inObj, PxU32 inArg){ inObj->setDynamicTreeRebuildRateHint( inArg ); }
PxU32 getPxSceneQuerySystemBase_DynamicTreeRebuildRateHint( const PxSceneQuerySystemBase* inObj ) { return inObj->getDynamicTreeRebuildRateHint(); }
void setPxSceneQuerySystemBase_UpdateMode( PxSceneQuerySystemBase* inObj, PxSceneQueryUpdateMode::Enum inArg){ inObj->setUpdateMode( inArg ); }
PxSceneQueryUpdateMode::Enum getPxSceneQuerySystemBase_UpdateMode( const PxSceneQuerySystemBase* inObj ) { return inObj->getUpdateMode(); }
PxU32 getPxSceneQuerySystemBase_StaticTimestamp( const PxSceneQuerySystemBase* inObj ) { return inObj->getStaticTimestamp(); }
PX_PHYSX_CORE_API PxSceneQuerySystemBaseGeneratedInfo::PxSceneQuerySystemBaseGeneratedInfo()
	: DynamicTreeRebuildRateHint( "DynamicTreeRebuildRateHint", setPxSceneQuerySystemBase_DynamicTreeRebuildRateHint, getPxSceneQuerySystemBase_DynamicTreeRebuildRateHint)
	, UpdateMode( "UpdateMode", setPxSceneQuerySystemBase_UpdateMode, getPxSceneQuerySystemBase_UpdateMode)
	, StaticTimestamp( "StaticTimestamp", getPxSceneQuerySystemBase_StaticTimestamp)
{}
PX_PHYSX_CORE_API PxSceneQuerySystemBaseGeneratedValues::PxSceneQuerySystemBaseGeneratedValues( const PxSceneQuerySystemBase* inSource )
		:DynamicTreeRebuildRateHint( getPxSceneQuerySystemBase_DynamicTreeRebuildRateHint( inSource ) )
		,UpdateMode( getPxSceneQuerySystemBase_UpdateMode( inSource ) )
		,StaticTimestamp( getPxSceneQuerySystemBase_StaticTimestamp( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxSceneSQSystem_SceneQueryUpdateMode( PxSceneSQSystem* inObj, PxSceneQueryUpdateMode::Enum inArg){ inObj->setSceneQueryUpdateMode( inArg ); }
PxSceneQueryUpdateMode::Enum getPxSceneSQSystem_SceneQueryUpdateMode( const PxSceneSQSystem* inObj ) { return inObj->getSceneQueryUpdateMode(); }
PxU32 getPxSceneSQSystem_SceneQueryStaticTimestamp( const PxSceneSQSystem* inObj ) { return inObj->getSceneQueryStaticTimestamp(); }
PxPruningStructureType::Enum getPxSceneSQSystem_StaticStructure( const PxSceneSQSystem* inObj ) { return inObj->getStaticStructure(); }
PxPruningStructureType::Enum getPxSceneSQSystem_DynamicStructure( const PxSceneSQSystem* inObj ) { return inObj->getDynamicStructure(); }
PX_PHYSX_CORE_API PxSceneSQSystemGeneratedInfo::PxSceneSQSystemGeneratedInfo()
	: SceneQueryUpdateMode( "SceneQueryUpdateMode", setPxSceneSQSystem_SceneQueryUpdateMode, getPxSceneSQSystem_SceneQueryUpdateMode)
	, SceneQueryStaticTimestamp( "SceneQueryStaticTimestamp", getPxSceneSQSystem_SceneQueryStaticTimestamp)
	, StaticStructure( "StaticStructure", getPxSceneSQSystem_StaticStructure)
	, DynamicStructure( "DynamicStructure", getPxSceneSQSystem_DynamicStructure)
{}
PX_PHYSX_CORE_API PxSceneSQSystemGeneratedValues::PxSceneSQSystemGeneratedValues( const PxSceneSQSystem* inSource )
		:PxSceneQuerySystemBaseGeneratedValues( inSource )
		,SceneQueryUpdateMode( getPxSceneSQSystem_SceneQueryUpdateMode( inSource ) )
		,SceneQueryStaticTimestamp( getPxSceneSQSystem_SceneQueryStaticTimestamp( inSource ) )
		,StaticStructure( getPxSceneSQSystem_StaticStructure( inSource ) )
		,DynamicStructure( getPxSceneSQSystem_DynamicStructure( inSource ) )
{
	PX_UNUSED(inSource);
}
PxSceneFlags getPxScene_Flags( const PxScene* inObj ) { return inObj->getFlags(); }
void setPxScene_Limits( PxScene* inObj, const PxSceneLimits & inArg){ inObj->setLimits( inArg ); }
PxSceneLimits getPxScene_Limits( const PxScene* inObj ) { return inObj->getLimits(); }
PxU32 getPxScene_Timestamp( const PxScene* inObj ) { return inObj->getTimestamp(); }
void setPxScene_Name( PxScene* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxScene_Name( const PxScene* inObj ) { return inObj->getName(); }
PxU32 getPxScene_Actors( const PxScene* inObj, PxActorTypeFlags inFilter, PxActor ** outBuffer, PxU32 inBufSize ) { return inObj->getActors( inFilter, outBuffer, inBufSize ); }
PxU32 getNbPxScene_Actors( const PxScene* inObj, PxActorTypeFlags inFilter ) { return inObj->getNbActors( inFilter ); }
PxU32 getPxScene_DeformableVolumes( const PxScene* inObj, PxDeformableVolume ** outBuffer, PxU32 inBufSize ) { return inObj->getDeformableVolumes( outBuffer, inBufSize ); }
PxU32 getNbPxScene_DeformableVolumes( const PxScene* inObj ) { return inObj->getNbDeformableVolumes(  ); }
PxU32 getPxScene_SoftBodies( const PxScene* inObj, PxDeformableVolume ** outBuffer, PxU32 inBufSize ) { return inObj->getSoftBodies( outBuffer, inBufSize ); }
PxU32 getNbPxScene_SoftBodies( const PxScene* inObj ) { return inObj->getNbSoftBodies(  ); }
PxU32 getPxScene_PBDParticleSystems( const PxScene* inObj, class PxPBDParticleSystem ** outBuffer, PxU32 inBufSize ) { return inObj->getPBDParticleSystems( outBuffer, inBufSize ); }
PxU32 getNbPxScene_PBDParticleSystems( const PxScene* inObj ) { return inObj->getNbPBDParticleSystems(  ); }
PxU32 getPxScene_Articulations( const PxScene* inObj, PxArticulationReducedCoordinate ** outBuffer, PxU32 inBufSize ) { return inObj->getArticulations( outBuffer, inBufSize ); }
PxU32 getNbPxScene_Articulations( const PxScene* inObj ) { return inObj->getNbArticulations(  ); }
PxU32 getPxScene_Constraints( const PxScene* inObj, PxConstraint ** outBuffer, PxU32 inBufSize ) { return inObj->getConstraints( outBuffer, inBufSize ); }
PxU32 getNbPxScene_Constraints( const PxScene* inObj ) { return inObj->getNbConstraints(  ); }
PxU32 getPxScene_Aggregates( const PxScene* inObj, PxAggregate ** outBuffer, PxU32 inBufSize ) { return inObj->getAggregates( outBuffer, inBufSize ); }
PxU32 getNbPxScene_Aggregates( const PxScene* inObj ) { return inObj->getNbAggregates(  ); }
PxCpuDispatcher * getPxScene_CpuDispatcher( const PxScene* inObj ) { return inObj->getCpuDispatcher(); }
PxCudaContextManager * getPxScene_CudaContextManager( const PxScene* inObj ) { return inObj->getCudaContextManager(); }
void setPxScene_SimulationEventCallback( PxScene* inObj, PxSimulationEventCallback * inArg){ inObj->setSimulationEventCallback( inArg ); }
PxSimulationEventCallback * getPxScene_SimulationEventCallback( const PxScene* inObj ) { return inObj->getSimulationEventCallback(); }
void setPxScene_ContactModifyCallback( PxScene* inObj, PxContactModifyCallback * inArg){ inObj->setContactModifyCallback( inArg ); }
PxContactModifyCallback * getPxScene_ContactModifyCallback( const PxScene* inObj ) { return inObj->getContactModifyCallback(); }
void setPxScene_CCDContactModifyCallback( PxScene* inObj, PxCCDContactModifyCallback * inArg){ inObj->setCCDContactModifyCallback( inArg ); }
PxCCDContactModifyCallback * getPxScene_CCDContactModifyCallback( const PxScene* inObj ) { return inObj->getCCDContactModifyCallback(); }
void setPxScene_BroadPhaseCallback( PxScene* inObj, PxBroadPhaseCallback * inArg){ inObj->setBroadPhaseCallback( inArg ); }
PxBroadPhaseCallback * getPxScene_BroadPhaseCallback( const PxScene* inObj ) { return inObj->getBroadPhaseCallback(); }
PxU32 getPxScene_FilterShaderDataSize( const PxScene* inObj ) { return inObj->getFilterShaderDataSize(); }
PxSimulationFilterShader getPxScene_FilterShader( const PxScene* inObj ) { return inObj->getFilterShader(); }
PxSimulationFilterCallback * getPxScene_FilterCallback( const PxScene* inObj ) { return inObj->getFilterCallback(); }
PxPairFilteringMode::Enum getPxScene_KinematicKinematicFilteringMode( const PxScene* inObj ) { return inObj->getKinematicKinematicFilteringMode(); }
PxPairFilteringMode::Enum getPxScene_StaticKinematicFilteringMode( const PxScene* inObj ) { return inObj->getStaticKinematicFilteringMode(); }
void setPxScene_Gravity( PxScene* inObj, const PxVec3 & inArg){ inObj->setGravity( inArg ); }
PxVec3 getPxScene_Gravity( const PxScene* inObj ) { return inObj->getGravity(); }
void setPxScene_BounceThresholdVelocity( PxScene* inObj, const PxReal inArg){ inObj->setBounceThresholdVelocity( inArg ); }
PxReal getPxScene_BounceThresholdVelocity( const PxScene* inObj ) { return inObj->getBounceThresholdVelocity(); }
void setPxScene_CCDMaxPasses( PxScene* inObj, PxU32 inArg){ inObj->setCCDMaxPasses( inArg ); }
PxU32 getPxScene_CCDMaxPasses( const PxScene* inObj ) { return inObj->getCCDMaxPasses(); }
void setPxScene_CCDMaxSeparation( PxScene* inObj, const PxReal inArg){ inObj->setCCDMaxSeparation( inArg ); }
PxReal getPxScene_CCDMaxSeparation( const PxScene* inObj ) { return inObj->getCCDMaxSeparation(); }
void setPxScene_CCDThreshold( PxScene* inObj, const PxReal inArg){ inObj->setCCDThreshold( inArg ); }
PxReal getPxScene_CCDThreshold( const PxScene* inObj ) { return inObj->getCCDThreshold(); }
void setPxScene_MaxBiasCoefficient( PxScene* inObj, const PxReal inArg){ inObj->setMaxBiasCoefficient( inArg ); }
PxReal getPxScene_MaxBiasCoefficient( const PxScene* inObj ) { return inObj->getMaxBiasCoefficient(); }
void setPxScene_FrictionOffsetThreshold( PxScene* inObj, const PxReal inArg){ inObj->setFrictionOffsetThreshold( inArg ); }
PxReal getPxScene_FrictionOffsetThreshold( const PxScene* inObj ) { return inObj->getFrictionOffsetThreshold(); }
void setPxScene_FrictionCorrelationDistance( PxScene* inObj, const PxReal inArg){ inObj->setFrictionCorrelationDistance( inArg ); }
PxReal getPxScene_FrictionCorrelationDistance( const PxScene* inObj ) { return inObj->getFrictionCorrelationDistance(); }
PxFrictionType::Enum getPxScene_FrictionType( const PxScene* inObj ) { return inObj->getFrictionType(); }
PxSolverType::Enum getPxScene_SolverType( const PxScene* inObj ) { return inObj->getSolverType(); }
void setPxScene_VisualizationCullingBox( PxScene* inObj, const PxBounds3 & inArg){ inObj->setVisualizationCullingBox( inArg ); }
PxBounds3 getPxScene_VisualizationCullingBox( const PxScene* inObj ) { return inObj->getVisualizationCullingBox(); }
PxBroadPhaseType::Enum getPxScene_BroadPhaseType( const PxScene* inObj ) { return inObj->getBroadPhaseType(); }
PxU32 getPxScene_BroadPhaseRegions( const PxScene* inObj, PxBroadPhaseRegionInfo* outBuffer, PxU32 inBufSize ) { return inObj->getBroadPhaseRegions( outBuffer, inBufSize ); }
PxU32 getNbPxScene_BroadPhaseRegions( const PxScene* inObj ) { return inObj->getNbBroadPhaseRegions(  ); }
PxTaskManager * getPxScene_TaskManager( const PxScene* inObj ) { return inObj->getTaskManager(); }
void setPxScene_NbContactDataBlocks( PxScene* inObj, PxU32 inArg){ inObj->setNbContactDataBlocks( inArg ); }
PxU32 getPxScene_MaxNbContactDataBlocksUsed( const PxScene* inObj ) { return inObj->getMaxNbContactDataBlocksUsed(); }
PxU32 getPxScene_ContactReportStreamBufferSize( const PxScene* inObj ) { return inObj->getContactReportStreamBufferSize(); }
void setPxScene_SolverBatchSize( PxScene* inObj, PxU32 inArg){ inObj->setSolverBatchSize( inArg ); }
PxU32 getPxScene_SolverBatchSize( const PxScene* inObj ) { return inObj->getSolverBatchSize(); }
void setPxScene_SolverArticulationBatchSize( PxScene* inObj, PxU32 inArg){ inObj->setSolverArticulationBatchSize( inArg ); }
PxU32 getPxScene_SolverArticulationBatchSize( const PxScene* inObj ) { return inObj->getSolverArticulationBatchSize(); }
PxReal getPxScene_WakeCounterResetValue( const PxScene* inObj ) { return inObj->getWakeCounterResetValue(); }
PxGpuDynamicsMemoryConfig getPxScene_GpuDynamicsConfig( const PxScene* inObj ) { return inObj->getGpuDynamicsConfig(); }
PxSceneResidual getPxScene_SolverResidual( const PxScene* inObj ) { return inObj->getSolverResidual(); }
void setPxScene_DeformableSurfaceGpuPostSolveCallback( PxScene* inObj, PxPostSolveCallback * inArg){ inObj->setDeformableSurfaceGpuPostSolveCallback( inArg ); }
void setPxScene_DeformableVolumeGpuPostSolveCallback( PxScene* inObj, PxPostSolveCallback * inArg){ inObj->setDeformableVolumeGpuPostSolveCallback( inArg ); }
inline void * getPxSceneUserData( const PxScene* inOwner ) { return inOwner->userData; }
inline void setPxSceneUserData( PxScene* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxSceneGeneratedInfo::PxSceneGeneratedInfo()
	: Flags( "Flags", getPxScene_Flags)
	, Limits( "Limits", setPxScene_Limits, getPxScene_Limits)
	, Timestamp( "Timestamp", getPxScene_Timestamp)
	, Name( "Name", setPxScene_Name, getPxScene_Name)
	, Actors( "Actors", getPxScene_Actors, getNbPxScene_Actors )
	, DeformableVolumes( "DeformableVolumes", getPxScene_DeformableVolumes, getNbPxScene_DeformableVolumes )
	, SoftBodies( "SoftBodies", getPxScene_SoftBodies, getNbPxScene_SoftBodies )
	, PBDParticleSystems( "PBDParticleSystems", getPxScene_PBDParticleSystems, getNbPxScene_PBDParticleSystems )
	, Articulations( "Articulations", getPxScene_Articulations, getNbPxScene_Articulations )
	, Constraints( "Constraints", getPxScene_Constraints, getNbPxScene_Constraints )
	, Aggregates( "Aggregates", getPxScene_Aggregates, getNbPxScene_Aggregates )
	, CpuDispatcher( "CpuDispatcher", getPxScene_CpuDispatcher)
	, CudaContextManager( "CudaContextManager", getPxScene_CudaContextManager)
	, SimulationEventCallback( "SimulationEventCallback", setPxScene_SimulationEventCallback, getPxScene_SimulationEventCallback)
	, ContactModifyCallback( "ContactModifyCallback", setPxScene_ContactModifyCallback, getPxScene_ContactModifyCallback)
	, CCDContactModifyCallback( "CCDContactModifyCallback", setPxScene_CCDContactModifyCallback, getPxScene_CCDContactModifyCallback)
	, BroadPhaseCallback( "BroadPhaseCallback", setPxScene_BroadPhaseCallback, getPxScene_BroadPhaseCallback)
	, FilterShaderDataSize( "FilterShaderDataSize", getPxScene_FilterShaderDataSize)
	, FilterShader( "FilterShader", getPxScene_FilterShader)
	, FilterCallback( "FilterCallback", getPxScene_FilterCallback)
	, KinematicKinematicFilteringMode( "KinematicKinematicFilteringMode", getPxScene_KinematicKinematicFilteringMode)
	, StaticKinematicFilteringMode( "StaticKinematicFilteringMode", getPxScene_StaticKinematicFilteringMode)
	, Gravity( "Gravity", setPxScene_Gravity, getPxScene_Gravity)
	, BounceThresholdVelocity( "BounceThresholdVelocity", setPxScene_BounceThresholdVelocity, getPxScene_BounceThresholdVelocity)
	, CCDMaxPasses( "CCDMaxPasses", setPxScene_CCDMaxPasses, getPxScene_CCDMaxPasses)
	, CCDMaxSeparation( "CCDMaxSeparation", setPxScene_CCDMaxSeparation, getPxScene_CCDMaxSeparation)
	, CCDThreshold( "CCDThreshold", setPxScene_CCDThreshold, getPxScene_CCDThreshold)
	, MaxBiasCoefficient( "MaxBiasCoefficient", setPxScene_MaxBiasCoefficient, getPxScene_MaxBiasCoefficient)
	, FrictionOffsetThreshold( "FrictionOffsetThreshold", setPxScene_FrictionOffsetThreshold, getPxScene_FrictionOffsetThreshold)
	, FrictionCorrelationDistance( "FrictionCorrelationDistance", setPxScene_FrictionCorrelationDistance, getPxScene_FrictionCorrelationDistance)
	, FrictionType( "FrictionType", getPxScene_FrictionType)
	, SolverType( "SolverType", getPxScene_SolverType)
	, VisualizationCullingBox( "VisualizationCullingBox", setPxScene_VisualizationCullingBox, getPxScene_VisualizationCullingBox)
	, BroadPhaseType( "BroadPhaseType", getPxScene_BroadPhaseType)
	, BroadPhaseRegions( "BroadPhaseRegions", getPxScene_BroadPhaseRegions, getNbPxScene_BroadPhaseRegions )
	, TaskManager( "TaskManager", getPxScene_TaskManager)
	, NbContactDataBlocks( "NbContactDataBlocks", setPxScene_NbContactDataBlocks)
	, MaxNbContactDataBlocksUsed( "MaxNbContactDataBlocksUsed", getPxScene_MaxNbContactDataBlocksUsed)
	, ContactReportStreamBufferSize( "ContactReportStreamBufferSize", getPxScene_ContactReportStreamBufferSize)
	, SolverBatchSize( "SolverBatchSize", setPxScene_SolverBatchSize, getPxScene_SolverBatchSize)
	, SolverArticulationBatchSize( "SolverArticulationBatchSize", setPxScene_SolverArticulationBatchSize, getPxScene_SolverArticulationBatchSize)
	, WakeCounterResetValue( "WakeCounterResetValue", getPxScene_WakeCounterResetValue)
	, GpuDynamicsConfig( "GpuDynamicsConfig", getPxScene_GpuDynamicsConfig)
	, SolverResidual( "SolverResidual", getPxScene_SolverResidual)
	, DeformableSurfaceGpuPostSolveCallback( "DeformableSurfaceGpuPostSolveCallback", setPxScene_DeformableSurfaceGpuPostSolveCallback)
	, DeformableVolumeGpuPostSolveCallback( "DeformableVolumeGpuPostSolveCallback", setPxScene_DeformableVolumeGpuPostSolveCallback)
	, UserData( "UserData", setPxSceneUserData, getPxSceneUserData )
{}
PX_PHYSX_CORE_API PxSceneGeneratedValues::PxSceneGeneratedValues( const PxScene* inSource )
		:PxSceneSQSystemGeneratedValues( inSource )
		,Flags( getPxScene_Flags( inSource ) )
		,Limits( getPxScene_Limits( inSource ) )
		,Timestamp( getPxScene_Timestamp( inSource ) )
		,Name( getPxScene_Name( inSource ) )
		,CpuDispatcher( getPxScene_CpuDispatcher( inSource ) )
		,CudaContextManager( getPxScene_CudaContextManager( inSource ) )
		,SimulationEventCallback( getPxScene_SimulationEventCallback( inSource ) )
		,ContactModifyCallback( getPxScene_ContactModifyCallback( inSource ) )
		,CCDContactModifyCallback( getPxScene_CCDContactModifyCallback( inSource ) )
		,BroadPhaseCallback( getPxScene_BroadPhaseCallback( inSource ) )
		,FilterShaderDataSize( getPxScene_FilterShaderDataSize( inSource ) )
		,FilterShader( getPxScene_FilterShader( inSource ) )
		,FilterCallback( getPxScene_FilterCallback( inSource ) )
		,KinematicKinematicFilteringMode( getPxScene_KinematicKinematicFilteringMode( inSource ) )
		,StaticKinematicFilteringMode( getPxScene_StaticKinematicFilteringMode( inSource ) )
		,Gravity( getPxScene_Gravity( inSource ) )
		,BounceThresholdVelocity( getPxScene_BounceThresholdVelocity( inSource ) )
		,CCDMaxPasses( getPxScene_CCDMaxPasses( inSource ) )
		,CCDMaxSeparation( getPxScene_CCDMaxSeparation( inSource ) )
		,CCDThreshold( getPxScene_CCDThreshold( inSource ) )
		,MaxBiasCoefficient( getPxScene_MaxBiasCoefficient( inSource ) )
		,FrictionOffsetThreshold( getPxScene_FrictionOffsetThreshold( inSource ) )
		,FrictionCorrelationDistance( getPxScene_FrictionCorrelationDistance( inSource ) )
		,FrictionType( getPxScene_FrictionType( inSource ) )
		,SolverType( getPxScene_SolverType( inSource ) )
		,VisualizationCullingBox( getPxScene_VisualizationCullingBox( inSource ) )
		,BroadPhaseType( getPxScene_BroadPhaseType( inSource ) )
		,TaskManager( getPxScene_TaskManager( inSource ) )
		,MaxNbContactDataBlocksUsed( getPxScene_MaxNbContactDataBlocksUsed( inSource ) )
		,ContactReportStreamBufferSize( getPxScene_ContactReportStreamBufferSize( inSource ) )
		,SolverBatchSize( getPxScene_SolverBatchSize( inSource ) )
		,SolverArticulationBatchSize( getPxScene_SolverArticulationBatchSize( inSource ) )
		,WakeCounterResetValue( getPxScene_WakeCounterResetValue( inSource ) )
		,GpuDynamicsConfig( getPxScene_GpuDynamicsConfig( inSource ) )
		,SolverResidual( getPxScene_SolverResidual( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
	inSource->getSimulationStatistics(SimulationStatistics);
}
inline PxTetrahedronMesh * getPxTetrahedronMeshGeometryTetrahedronMesh( const PxTetrahedronMeshGeometry* inOwner ) { return inOwner->tetrahedronMesh; }
inline void setPxTetrahedronMeshGeometryTetrahedronMesh( PxTetrahedronMeshGeometry* inOwner, PxTetrahedronMesh * inData) { inOwner->tetrahedronMesh = inData; }
PX_PHYSX_CORE_API PxTetrahedronMeshGeometryGeneratedInfo::PxTetrahedronMeshGeometryGeneratedInfo()
	: TetrahedronMesh( "TetrahedronMesh", setPxTetrahedronMeshGeometryTetrahedronMesh, getPxTetrahedronMeshGeometryTetrahedronMesh )
{}
PX_PHYSX_CORE_API PxTetrahedronMeshGeometryGeneratedValues::PxTetrahedronMeshGeometryGeneratedValues( const PxTetrahedronMeshGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,TetrahedronMesh( inSource->tetrahedronMesh )
{
	PX_UNUSED(inSource);
}
PX_PHYSX_CORE_API PxCustomGeometryGeneratedInfo::PxCustomGeometryGeneratedInfo()
{}
PX_PHYSX_CORE_API PxCustomGeometryGeneratedValues::PxCustomGeometryGeneratedValues( const PxCustomGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
{
	PX_UNUSED(inSource);
	PxCustomGeometry::Type t = inSource->callbacks->getCustomType(); CustomType = *reinterpret_cast<const PxU32*>(&t);
}
inline PxU32 getPxHeightFieldDescNbRows( const PxHeightFieldDesc* inOwner ) { return inOwner->nbRows; }
inline void setPxHeightFieldDescNbRows( PxHeightFieldDesc* inOwner, PxU32 inData) { inOwner->nbRows = inData; }
inline PxU32 getPxHeightFieldDescNbColumns( const PxHeightFieldDesc* inOwner ) { return inOwner->nbColumns; }
inline void setPxHeightFieldDescNbColumns( PxHeightFieldDesc* inOwner, PxU32 inData) { inOwner->nbColumns = inData; }
inline PxHeightFieldFormat::Enum getPxHeightFieldDescFormat( const PxHeightFieldDesc* inOwner ) { return inOwner->format; }
inline void setPxHeightFieldDescFormat( PxHeightFieldDesc* inOwner, PxHeightFieldFormat::Enum inData) { inOwner->format = inData; }
inline PxStridedData getPxHeightFieldDescSamples( const PxHeightFieldDesc* inOwner ) { return inOwner->samples; }
inline void setPxHeightFieldDescSamples( PxHeightFieldDesc* inOwner, PxStridedData inData) { inOwner->samples = inData; }
inline PxReal getPxHeightFieldDescConvexEdgeThreshold( const PxHeightFieldDesc* inOwner ) { return inOwner->convexEdgeThreshold; }
inline void setPxHeightFieldDescConvexEdgeThreshold( PxHeightFieldDesc* inOwner, PxReal inData) { inOwner->convexEdgeThreshold = inData; }
inline PxHeightFieldFlags getPxHeightFieldDescFlags( const PxHeightFieldDesc* inOwner ) { return inOwner->flags; }
inline void setPxHeightFieldDescFlags( PxHeightFieldDesc* inOwner, PxHeightFieldFlags inData) { inOwner->flags = inData; }
PX_PHYSX_CORE_API PxHeightFieldDescGeneratedInfo::PxHeightFieldDescGeneratedInfo()
	: NbRows( "NbRows", setPxHeightFieldDescNbRows, getPxHeightFieldDescNbRows )
	, NbColumns( "NbColumns", setPxHeightFieldDescNbColumns, getPxHeightFieldDescNbColumns )
	, Format( "Format", setPxHeightFieldDescFormat, getPxHeightFieldDescFormat )
	, Samples( "Samples", setPxHeightFieldDescSamples, getPxHeightFieldDescSamples )
	, ConvexEdgeThreshold( "ConvexEdgeThreshold", setPxHeightFieldDescConvexEdgeThreshold, getPxHeightFieldDescConvexEdgeThreshold )
	, Flags( "Flags", setPxHeightFieldDescFlags, getPxHeightFieldDescFlags )
{}
PX_PHYSX_CORE_API PxHeightFieldDescGeneratedValues::PxHeightFieldDescGeneratedValues( const PxHeightFieldDesc* inSource )
		:NbRows( inSource->nbRows )
		,NbColumns( inSource->nbColumns )
		,Format( inSource->format )
		,Samples( inSource->samples )
		,ConvexEdgeThreshold( inSource->convexEdgeThreshold )
		,Flags( inSource->flags )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxArticulationLimitLow( const PxArticulationLimit* inOwner ) { return inOwner->low; }
inline void setPxArticulationLimitLow( PxArticulationLimit* inOwner, PxReal inData) { inOwner->low = inData; }
inline PxReal getPxArticulationLimitHigh( const PxArticulationLimit* inOwner ) { return inOwner->high; }
inline void setPxArticulationLimitHigh( PxArticulationLimit* inOwner, PxReal inData) { inOwner->high = inData; }
PX_PHYSX_CORE_API PxArticulationLimitGeneratedInfo::PxArticulationLimitGeneratedInfo()
	: Low( "Low", setPxArticulationLimitLow, getPxArticulationLimitLow )
	, High( "High", setPxArticulationLimitHigh, getPxArticulationLimitHigh )
{}
PX_PHYSX_CORE_API PxArticulationLimitGeneratedValues::PxArticulationLimitGeneratedValues( const PxArticulationLimit* inSource )
		:Low( inSource->low )
		,High( inSource->high )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxPerformanceEnvelopeMaxEffort( const PxPerformanceEnvelope* inOwner ) { return inOwner->maxEffort; }
inline void setPxPerformanceEnvelopeMaxEffort( PxPerformanceEnvelope* inOwner, PxReal inData) { inOwner->maxEffort = inData; }
inline PxReal getPxPerformanceEnvelopeMaxActuatorVelocity( const PxPerformanceEnvelope* inOwner ) { return inOwner->maxActuatorVelocity; }
inline void setPxPerformanceEnvelopeMaxActuatorVelocity( PxPerformanceEnvelope* inOwner, PxReal inData) { inOwner->maxActuatorVelocity = inData; }
inline PxReal getPxPerformanceEnvelopeVelocityDependentResistance( const PxPerformanceEnvelope* inOwner ) { return inOwner->velocityDependentResistance; }
inline void setPxPerformanceEnvelopeVelocityDependentResistance( PxPerformanceEnvelope* inOwner, PxReal inData) { inOwner->velocityDependentResistance = inData; }
inline PxReal getPxPerformanceEnvelopeSpeedEffortGradient( const PxPerformanceEnvelope* inOwner ) { return inOwner->speedEffortGradient; }
inline void setPxPerformanceEnvelopeSpeedEffortGradient( PxPerformanceEnvelope* inOwner, PxReal inData) { inOwner->speedEffortGradient = inData; }
PX_PHYSX_CORE_API PxPerformanceEnvelopeGeneratedInfo::PxPerformanceEnvelopeGeneratedInfo()
	: MaxEffort( "MaxEffort", setPxPerformanceEnvelopeMaxEffort, getPxPerformanceEnvelopeMaxEffort )
	, MaxActuatorVelocity( "MaxActuatorVelocity", setPxPerformanceEnvelopeMaxActuatorVelocity, getPxPerformanceEnvelopeMaxActuatorVelocity )
	, VelocityDependentResistance( "VelocityDependentResistance", setPxPerformanceEnvelopeVelocityDependentResistance, getPxPerformanceEnvelopeVelocityDependentResistance )
	, SpeedEffortGradient( "SpeedEffortGradient", setPxPerformanceEnvelopeSpeedEffortGradient, getPxPerformanceEnvelopeSpeedEffortGradient )
{}
PX_PHYSX_CORE_API PxPerformanceEnvelopeGeneratedValues::PxPerformanceEnvelopeGeneratedValues( const PxPerformanceEnvelope* inSource )
		:MaxEffort( inSource->maxEffort )
		,MaxActuatorVelocity( inSource->maxActuatorVelocity )
		,VelocityDependentResistance( inSource->velocityDependentResistance )
		,SpeedEffortGradient( inSource->speedEffortGradient )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxJointFrictionParamsStaticFrictionEffort( const PxJointFrictionParams* inOwner ) { return inOwner->staticFrictionEffort; }
inline void setPxJointFrictionParamsStaticFrictionEffort( PxJointFrictionParams* inOwner, PxReal inData) { inOwner->staticFrictionEffort = inData; }
inline PxReal getPxJointFrictionParamsDynamicFrictionEffort( const PxJointFrictionParams* inOwner ) { return inOwner->dynamicFrictionEffort; }
inline void setPxJointFrictionParamsDynamicFrictionEffort( PxJointFrictionParams* inOwner, PxReal inData) { inOwner->dynamicFrictionEffort = inData; }
inline PxReal getPxJointFrictionParamsViscousFrictionCoefficient( const PxJointFrictionParams* inOwner ) { return inOwner->viscousFrictionCoefficient; }
inline void setPxJointFrictionParamsViscousFrictionCoefficient( PxJointFrictionParams* inOwner, PxReal inData) { inOwner->viscousFrictionCoefficient = inData; }
PX_PHYSX_CORE_API PxJointFrictionParamsGeneratedInfo::PxJointFrictionParamsGeneratedInfo()
	: StaticFrictionEffort( "StaticFrictionEffort", setPxJointFrictionParamsStaticFrictionEffort, getPxJointFrictionParamsStaticFrictionEffort )
	, DynamicFrictionEffort( "DynamicFrictionEffort", setPxJointFrictionParamsDynamicFrictionEffort, getPxJointFrictionParamsDynamicFrictionEffort )
	, ViscousFrictionCoefficient( "ViscousFrictionCoefficient", setPxJointFrictionParamsViscousFrictionCoefficient, getPxJointFrictionParamsViscousFrictionCoefficient )
{}
PX_PHYSX_CORE_API PxJointFrictionParamsGeneratedValues::PxJointFrictionParamsGeneratedValues( const PxJointFrictionParams* inSource )
		:StaticFrictionEffort( inSource->staticFrictionEffort )
		,DynamicFrictionEffort( inSource->dynamicFrictionEffort )
		,ViscousFrictionCoefficient( inSource->viscousFrictionCoefficient )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxArticulationDriveStiffness( const PxArticulationDrive* inOwner ) { return inOwner->stiffness; }
inline void setPxArticulationDriveStiffness( PxArticulationDrive* inOwner, PxReal inData) { inOwner->stiffness = inData; }
inline PxReal getPxArticulationDriveDamping( const PxArticulationDrive* inOwner ) { return inOwner->damping; }
inline void setPxArticulationDriveDamping( PxArticulationDrive* inOwner, PxReal inData) { inOwner->damping = inData; }
inline PxReal getPxArticulationDriveMaxForce( const PxArticulationDrive* inOwner ) { return inOwner->maxForce; }
inline void setPxArticulationDriveMaxForce( PxArticulationDrive* inOwner, PxReal inData) { inOwner->maxForce = inData; }
inline PxPerformanceEnvelope getPxArticulationDriveEnvelope( const PxArticulationDrive* inOwner ) { return inOwner->envelope; }
inline void setPxArticulationDriveEnvelope( PxArticulationDrive* inOwner, PxPerformanceEnvelope inData) { inOwner->envelope = inData; }
inline PxArticulationDriveType::Enum getPxArticulationDriveDriveType( const PxArticulationDrive* inOwner ) { return inOwner->driveType; }
inline void setPxArticulationDriveDriveType( PxArticulationDrive* inOwner, PxArticulationDriveType::Enum inData) { inOwner->driveType = inData; }
PX_PHYSX_CORE_API PxArticulationDriveGeneratedInfo::PxArticulationDriveGeneratedInfo()
	: Stiffness( "Stiffness", setPxArticulationDriveStiffness, getPxArticulationDriveStiffness )
	, Damping( "Damping", setPxArticulationDriveDamping, getPxArticulationDriveDamping )
	, MaxForce( "MaxForce", setPxArticulationDriveMaxForce, getPxArticulationDriveMaxForce )
	, Envelope( "Envelope", setPxArticulationDriveEnvelope, getPxArticulationDriveEnvelope )
	, DriveType( "DriveType", setPxArticulationDriveDriveType, getPxArticulationDriveDriveType )
{}
PX_PHYSX_CORE_API PxArticulationDriveGeneratedValues::PxArticulationDriveGeneratedValues( const PxArticulationDrive* inSource )
		:Stiffness( inSource->stiffness )
		,Damping( inSource->damping )
		,MaxForce( inSource->maxForce )
		,Envelope( inSource->envelope )
		,DriveType( inSource->driveType )
{
	PX_UNUSED(inSource);
}
_Bool getPxSceneQueryDesc_IsValid( const PxSceneQueryDesc* inObj ) { return inObj->isValid(); }
inline PxPruningStructureType::Enum getPxSceneQueryDescStaticStructure( const PxSceneQueryDesc* inOwner ) { return inOwner->staticStructure; }
inline void setPxSceneQueryDescStaticStructure( PxSceneQueryDesc* inOwner, PxPruningStructureType::Enum inData) { inOwner->staticStructure = inData; }
inline PxPruningStructureType::Enum getPxSceneQueryDescDynamicStructure( const PxSceneQueryDesc* inOwner ) { return inOwner->dynamicStructure; }
inline void setPxSceneQueryDescDynamicStructure( PxSceneQueryDesc* inOwner, PxPruningStructureType::Enum inData) { inOwner->dynamicStructure = inData; }
inline PxU32 getPxSceneQueryDescDynamicTreeRebuildRateHint( const PxSceneQueryDesc* inOwner ) { return inOwner->dynamicTreeRebuildRateHint; }
inline void setPxSceneQueryDescDynamicTreeRebuildRateHint( PxSceneQueryDesc* inOwner, PxU32 inData) { inOwner->dynamicTreeRebuildRateHint = inData; }
inline PxDynamicTreeSecondaryPruner::Enum getPxSceneQueryDescDynamicTreeSecondaryPruner( const PxSceneQueryDesc* inOwner ) { return inOwner->dynamicTreeSecondaryPruner; }
inline void setPxSceneQueryDescDynamicTreeSecondaryPruner( PxSceneQueryDesc* inOwner, PxDynamicTreeSecondaryPruner::Enum inData) { inOwner->dynamicTreeSecondaryPruner = inData; }
inline PxBVHBuildStrategy::Enum getPxSceneQueryDescStaticBVHBuildStrategy( const PxSceneQueryDesc* inOwner ) { return inOwner->staticBVHBuildStrategy; }
inline void setPxSceneQueryDescStaticBVHBuildStrategy( PxSceneQueryDesc* inOwner, PxBVHBuildStrategy::Enum inData) { inOwner->staticBVHBuildStrategy = inData; }
inline PxBVHBuildStrategy::Enum getPxSceneQueryDescDynamicBVHBuildStrategy( const PxSceneQueryDesc* inOwner ) { return inOwner->dynamicBVHBuildStrategy; }
inline void setPxSceneQueryDescDynamicBVHBuildStrategy( PxSceneQueryDesc* inOwner, PxBVHBuildStrategy::Enum inData) { inOwner->dynamicBVHBuildStrategy = inData; }
inline PxU32 getPxSceneQueryDescStaticNbObjectsPerNode( const PxSceneQueryDesc* inOwner ) { return inOwner->staticNbObjectsPerNode; }
inline void setPxSceneQueryDescStaticNbObjectsPerNode( PxSceneQueryDesc* inOwner, PxU32 inData) { inOwner->staticNbObjectsPerNode = inData; }
inline PxU32 getPxSceneQueryDescDynamicNbObjectsPerNode( const PxSceneQueryDesc* inOwner ) { return inOwner->dynamicNbObjectsPerNode; }
inline void setPxSceneQueryDescDynamicNbObjectsPerNode( PxSceneQueryDesc* inOwner, PxU32 inData) { inOwner->dynamicNbObjectsPerNode = inData; }
inline PxSceneQueryUpdateMode::Enum getPxSceneQueryDescSceneQueryUpdateMode( const PxSceneQueryDesc* inOwner ) { return inOwner->sceneQueryUpdateMode; }
inline void setPxSceneQueryDescSceneQueryUpdateMode( PxSceneQueryDesc* inOwner, PxSceneQueryUpdateMode::Enum inData) { inOwner->sceneQueryUpdateMode = inData; }
PX_PHYSX_CORE_API PxSceneQueryDescGeneratedInfo::PxSceneQueryDescGeneratedInfo()
	: IsValid( "IsValid", getPxSceneQueryDesc_IsValid)
	, StaticStructure( "StaticStructure", setPxSceneQueryDescStaticStructure, getPxSceneQueryDescStaticStructure )
	, DynamicStructure( "DynamicStructure", setPxSceneQueryDescDynamicStructure, getPxSceneQueryDescDynamicStructure )
	, DynamicTreeRebuildRateHint( "DynamicTreeRebuildRateHint", setPxSceneQueryDescDynamicTreeRebuildRateHint, getPxSceneQueryDescDynamicTreeRebuildRateHint )
	, DynamicTreeSecondaryPruner( "DynamicTreeSecondaryPruner", setPxSceneQueryDescDynamicTreeSecondaryPruner, getPxSceneQueryDescDynamicTreeSecondaryPruner )
	, StaticBVHBuildStrategy( "StaticBVHBuildStrategy", setPxSceneQueryDescStaticBVHBuildStrategy, getPxSceneQueryDescStaticBVHBuildStrategy )
	, DynamicBVHBuildStrategy( "DynamicBVHBuildStrategy", setPxSceneQueryDescDynamicBVHBuildStrategy, getPxSceneQueryDescDynamicBVHBuildStrategy )
	, StaticNbObjectsPerNode( "StaticNbObjectsPerNode", setPxSceneQueryDescStaticNbObjectsPerNode, getPxSceneQueryDescStaticNbObjectsPerNode )
	, DynamicNbObjectsPerNode( "DynamicNbObjectsPerNode", setPxSceneQueryDescDynamicNbObjectsPerNode, getPxSceneQueryDescDynamicNbObjectsPerNode )
	, SceneQueryUpdateMode( "SceneQueryUpdateMode", setPxSceneQueryDescSceneQueryUpdateMode, getPxSceneQueryDescSceneQueryUpdateMode )
{}
PX_PHYSX_CORE_API PxSceneQueryDescGeneratedValues::PxSceneQueryDescGeneratedValues( const PxSceneQueryDesc* inSource )
		:IsValid( getPxSceneQueryDesc_IsValid( inSource ) )
		,StaticStructure( inSource->staticStructure )
		,DynamicStructure( inSource->dynamicStructure )
		,DynamicTreeRebuildRateHint( inSource->dynamicTreeRebuildRateHint )
		,DynamicTreeSecondaryPruner( inSource->dynamicTreeSecondaryPruner )
		,StaticBVHBuildStrategy( inSource->staticBVHBuildStrategy )
		,DynamicBVHBuildStrategy( inSource->dynamicBVHBuildStrategy )
		,StaticNbObjectsPerNode( inSource->staticNbObjectsPerNode )
		,DynamicNbObjectsPerNode( inSource->dynamicNbObjectsPerNode )
		,SceneQueryUpdateMode( inSource->sceneQueryUpdateMode )
{
	PX_UNUSED(inSource);
}
void setPxSceneDesc_ToDefault( PxSceneDesc* inObj, const PxTolerancesScale & inArg){ inObj->setToDefault( inArg ); }
inline PxVec3 getPxSceneDescGravity( const PxSceneDesc* inOwner ) { return inOwner->gravity; }
inline void setPxSceneDescGravity( PxSceneDesc* inOwner, PxVec3 inData) { inOwner->gravity = inData; }
inline PxSimulationEventCallback * getPxSceneDescSimulationEventCallback( const PxSceneDesc* inOwner ) { return inOwner->simulationEventCallback; }
inline void setPxSceneDescSimulationEventCallback( PxSceneDesc* inOwner, PxSimulationEventCallback * inData) { inOwner->simulationEventCallback = inData; }
inline PxContactModifyCallback * getPxSceneDescContactModifyCallback( const PxSceneDesc* inOwner ) { return inOwner->contactModifyCallback; }
inline void setPxSceneDescContactModifyCallback( PxSceneDesc* inOwner, PxContactModifyCallback * inData) { inOwner->contactModifyCallback = inData; }
inline PxCCDContactModifyCallback * getPxSceneDescCcdContactModifyCallback( const PxSceneDesc* inOwner ) { return inOwner->ccdContactModifyCallback; }
inline void setPxSceneDescCcdContactModifyCallback( PxSceneDesc* inOwner, PxCCDContactModifyCallback * inData) { inOwner->ccdContactModifyCallback = inData; }
inline const void * getPxSceneDescFilterShaderData( const PxSceneDesc* inOwner ) { return inOwner->filterShaderData; }
inline void setPxSceneDescFilterShaderData( PxSceneDesc* inOwner, const void * inData) { inOwner->filterShaderData = inData; }
inline PxU32 getPxSceneDescFilterShaderDataSize( const PxSceneDesc* inOwner ) { return inOwner->filterShaderDataSize; }
inline void setPxSceneDescFilterShaderDataSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->filterShaderDataSize = inData; }
inline PxSimulationFilterShader getPxSceneDescFilterShader( const PxSceneDesc* inOwner ) { return inOwner->filterShader; }
inline void setPxSceneDescFilterShader( PxSceneDesc* inOwner, PxSimulationFilterShader inData) { inOwner->filterShader = inData; }
inline PxSimulationFilterCallback * getPxSceneDescFilterCallback( const PxSceneDesc* inOwner ) { return inOwner->filterCallback; }
inline void setPxSceneDescFilterCallback( PxSceneDesc* inOwner, PxSimulationFilterCallback * inData) { inOwner->filterCallback = inData; }
inline PxPairFilteringMode::Enum getPxSceneDescKineKineFilteringMode( const PxSceneDesc* inOwner ) { return inOwner->kineKineFilteringMode; }
inline void setPxSceneDescKineKineFilteringMode( PxSceneDesc* inOwner, PxPairFilteringMode::Enum inData) { inOwner->kineKineFilteringMode = inData; }
inline PxPairFilteringMode::Enum getPxSceneDescStaticKineFilteringMode( const PxSceneDesc* inOwner ) { return inOwner->staticKineFilteringMode; }
inline void setPxSceneDescStaticKineFilteringMode( PxSceneDesc* inOwner, PxPairFilteringMode::Enum inData) { inOwner->staticKineFilteringMode = inData; }
inline PxBroadPhaseType::Enum getPxSceneDescBroadPhaseType( const PxSceneDesc* inOwner ) { return inOwner->broadPhaseType; }
inline void setPxSceneDescBroadPhaseType( PxSceneDesc* inOwner, PxBroadPhaseType::Enum inData) { inOwner->broadPhaseType = inData; }
inline PxBroadPhaseCallback * getPxSceneDescBroadPhaseCallback( const PxSceneDesc* inOwner ) { return inOwner->broadPhaseCallback; }
inline void setPxSceneDescBroadPhaseCallback( PxSceneDesc* inOwner, PxBroadPhaseCallback * inData) { inOwner->broadPhaseCallback = inData; }
inline PxSceneLimits getPxSceneDescLimits( const PxSceneDesc* inOwner ) { return inOwner->limits; }
inline void setPxSceneDescLimits( PxSceneDesc* inOwner, PxSceneLimits inData) { inOwner->limits = inData; }
inline PxFrictionType::Enum getPxSceneDescFrictionType( const PxSceneDesc* inOwner ) { return inOwner->frictionType; }
inline void setPxSceneDescFrictionType( PxSceneDesc* inOwner, PxFrictionType::Enum inData) { inOwner->frictionType = inData; }
inline PxSolverType::Enum getPxSceneDescSolverType( const PxSceneDesc* inOwner ) { return inOwner->solverType; }
inline void setPxSceneDescSolverType( PxSceneDesc* inOwner, PxSolverType::Enum inData) { inOwner->solverType = inData; }
inline PxReal getPxSceneDescBounceThresholdVelocity( const PxSceneDesc* inOwner ) { return inOwner->bounceThresholdVelocity; }
inline void setPxSceneDescBounceThresholdVelocity( PxSceneDesc* inOwner, PxReal inData) { inOwner->bounceThresholdVelocity = inData; }
inline PxReal getPxSceneDescFrictionOffsetThreshold( const PxSceneDesc* inOwner ) { return inOwner->frictionOffsetThreshold; }
inline void setPxSceneDescFrictionOffsetThreshold( PxSceneDesc* inOwner, PxReal inData) { inOwner->frictionOffsetThreshold = inData; }
inline PxReal getPxSceneDescFrictionCorrelationDistance( const PxSceneDesc* inOwner ) { return inOwner->frictionCorrelationDistance; }
inline void setPxSceneDescFrictionCorrelationDistance( PxSceneDesc* inOwner, PxReal inData) { inOwner->frictionCorrelationDistance = inData; }
inline PxSceneFlags getPxSceneDescFlags( const PxSceneDesc* inOwner ) { return inOwner->flags; }
inline void setPxSceneDescFlags( PxSceneDesc* inOwner, PxSceneFlags inData) { inOwner->flags = inData; }
inline PxCpuDispatcher * getPxSceneDescCpuDispatcher( const PxSceneDesc* inOwner ) { return inOwner->cpuDispatcher; }
inline void setPxSceneDescCpuDispatcher( PxSceneDesc* inOwner, PxCpuDispatcher * inData) { inOwner->cpuDispatcher = inData; }
inline PxCudaContextManager * getPxSceneDescCudaContextManager( const PxSceneDesc* inOwner ) { return inOwner->cudaContextManager; }
inline void setPxSceneDescCudaContextManager( PxSceneDesc* inOwner, PxCudaContextManager * inData) { inOwner->cudaContextManager = inData; }
inline void * getPxSceneDescUserData( const PxSceneDesc* inOwner ) { return inOwner->userData; }
inline void setPxSceneDescUserData( PxSceneDesc* inOwner, void * inData) { inOwner->userData = inData; }
inline PxU32 getPxSceneDescSolverBatchSize( const PxSceneDesc* inOwner ) { return inOwner->solverBatchSize; }
inline void setPxSceneDescSolverBatchSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->solverBatchSize = inData; }
inline PxU32 getPxSceneDescSolverArticulationBatchSize( const PxSceneDesc* inOwner ) { return inOwner->solverArticulationBatchSize; }
inline void setPxSceneDescSolverArticulationBatchSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->solverArticulationBatchSize = inData; }
inline PxU32 getPxSceneDescNbContactDataBlocks( const PxSceneDesc* inOwner ) { return inOwner->nbContactDataBlocks; }
inline void setPxSceneDescNbContactDataBlocks( PxSceneDesc* inOwner, PxU32 inData) { inOwner->nbContactDataBlocks = inData; }
inline PxU32 getPxSceneDescMaxNbContactDataBlocks( const PxSceneDesc* inOwner ) { return inOwner->maxNbContactDataBlocks; }
inline void setPxSceneDescMaxNbContactDataBlocks( PxSceneDesc* inOwner, PxU32 inData) { inOwner->maxNbContactDataBlocks = inData; }
inline PxReal getPxSceneDescMaxBiasCoefficient( const PxSceneDesc* inOwner ) { return inOwner->maxBiasCoefficient; }
inline void setPxSceneDescMaxBiasCoefficient( PxSceneDesc* inOwner, PxReal inData) { inOwner->maxBiasCoefficient = inData; }
inline PxU32 getPxSceneDescContactReportStreamBufferSize( const PxSceneDesc* inOwner ) { return inOwner->contactReportStreamBufferSize; }
inline void setPxSceneDescContactReportStreamBufferSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->contactReportStreamBufferSize = inData; }
inline PxU32 getPxSceneDescCcdMaxPasses( const PxSceneDesc* inOwner ) { return inOwner->ccdMaxPasses; }
inline void setPxSceneDescCcdMaxPasses( PxSceneDesc* inOwner, PxU32 inData) { inOwner->ccdMaxPasses = inData; }
inline PxReal getPxSceneDescCcdThreshold( const PxSceneDesc* inOwner ) { return inOwner->ccdThreshold; }
inline void setPxSceneDescCcdThreshold( PxSceneDesc* inOwner, PxReal inData) { inOwner->ccdThreshold = inData; }
inline PxReal getPxSceneDescCcdMaxSeparation( const PxSceneDesc* inOwner ) { return inOwner->ccdMaxSeparation; }
inline void setPxSceneDescCcdMaxSeparation( PxSceneDesc* inOwner, PxReal inData) { inOwner->ccdMaxSeparation = inData; }
inline PxReal getPxSceneDescWakeCounterResetValue( const PxSceneDesc* inOwner ) { return inOwner->wakeCounterResetValue; }
inline void setPxSceneDescWakeCounterResetValue( PxSceneDesc* inOwner, PxReal inData) { inOwner->wakeCounterResetValue = inData; }
inline PxBounds3 getPxSceneDescSanityBounds( const PxSceneDesc* inOwner ) { return inOwner->sanityBounds; }
inline void setPxSceneDescSanityBounds( PxSceneDesc* inOwner, PxBounds3 inData) { inOwner->sanityBounds = inData; }
inline PxGpuDynamicsMemoryConfig getPxSceneDescGpuDynamicsConfig( const PxSceneDesc* inOwner ) { return inOwner->gpuDynamicsConfig; }
inline void setPxSceneDescGpuDynamicsConfig( PxSceneDesc* inOwner, PxGpuDynamicsMemoryConfig inData) { inOwner->gpuDynamicsConfig = inData; }
inline PxU32 getPxSceneDescGpuMaxNumPartitions( const PxSceneDesc* inOwner ) { return inOwner->gpuMaxNumPartitions; }
inline void setPxSceneDescGpuMaxNumPartitions( PxSceneDesc* inOwner, PxU32 inData) { inOwner->gpuMaxNumPartitions = inData; }
inline PxU32 getPxSceneDescGpuMaxNumStaticPartitions( const PxSceneDesc* inOwner ) { return inOwner->gpuMaxNumStaticPartitions; }
inline void setPxSceneDescGpuMaxNumStaticPartitions( PxSceneDesc* inOwner, PxU32 inData) { inOwner->gpuMaxNumStaticPartitions = inData; }
inline PxU32 getPxSceneDescGpuComputeVersion( const PxSceneDesc* inOwner ) { return inOwner->gpuComputeVersion; }
inline void setPxSceneDescGpuComputeVersion( PxSceneDesc* inOwner, PxU32 inData) { inOwner->gpuComputeVersion = inData; }
inline PxU32 getPxSceneDescContactPairSlabSize( const PxSceneDesc* inOwner ) { return inOwner->contactPairSlabSize; }
inline void setPxSceneDescContactPairSlabSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->contactPairSlabSize = inData; }
PX_PHYSX_CORE_API PxSceneDescGeneratedInfo::PxSceneDescGeneratedInfo()
	: ToDefault( "ToDefault", setPxSceneDesc_ToDefault)
	, Gravity( "Gravity", setPxSceneDescGravity, getPxSceneDescGravity )
	, SimulationEventCallback( "SimulationEventCallback", setPxSceneDescSimulationEventCallback, getPxSceneDescSimulationEventCallback )
	, ContactModifyCallback( "ContactModifyCallback", setPxSceneDescContactModifyCallback, getPxSceneDescContactModifyCallback )
	, CcdContactModifyCallback( "CcdContactModifyCallback", setPxSceneDescCcdContactModifyCallback, getPxSceneDescCcdContactModifyCallback )
	, FilterShaderData( "FilterShaderData", setPxSceneDescFilterShaderData, getPxSceneDescFilterShaderData )
	, FilterShaderDataSize( "FilterShaderDataSize", setPxSceneDescFilterShaderDataSize, getPxSceneDescFilterShaderDataSize )
	, FilterShader( "FilterShader", setPxSceneDescFilterShader, getPxSceneDescFilterShader )
	, FilterCallback( "FilterCallback", setPxSceneDescFilterCallback, getPxSceneDescFilterCallback )
	, KineKineFilteringMode( "KineKineFilteringMode", setPxSceneDescKineKineFilteringMode, getPxSceneDescKineKineFilteringMode )
	, StaticKineFilteringMode( "StaticKineFilteringMode", setPxSceneDescStaticKineFilteringMode, getPxSceneDescStaticKineFilteringMode )
	, BroadPhaseType( "BroadPhaseType", setPxSceneDescBroadPhaseType, getPxSceneDescBroadPhaseType )
	, BroadPhaseCallback( "BroadPhaseCallback", setPxSceneDescBroadPhaseCallback, getPxSceneDescBroadPhaseCallback )
	, Limits( "Limits", setPxSceneDescLimits, getPxSceneDescLimits )
	, FrictionType( "FrictionType", setPxSceneDescFrictionType, getPxSceneDescFrictionType )
	, SolverType( "SolverType", setPxSceneDescSolverType, getPxSceneDescSolverType )
	, BounceThresholdVelocity( "BounceThresholdVelocity", setPxSceneDescBounceThresholdVelocity, getPxSceneDescBounceThresholdVelocity )
	, FrictionOffsetThreshold( "FrictionOffsetThreshold", setPxSceneDescFrictionOffsetThreshold, getPxSceneDescFrictionOffsetThreshold )
	, FrictionCorrelationDistance( "FrictionCorrelationDistance", setPxSceneDescFrictionCorrelationDistance, getPxSceneDescFrictionCorrelationDistance )
	, Flags( "Flags", setPxSceneDescFlags, getPxSceneDescFlags )
	, CpuDispatcher( "CpuDispatcher", setPxSceneDescCpuDispatcher, getPxSceneDescCpuDispatcher )
	, CudaContextManager( "CudaContextManager", setPxSceneDescCudaContextManager, getPxSceneDescCudaContextManager )
	, UserData( "UserData", setPxSceneDescUserData, getPxSceneDescUserData )
	, SolverBatchSize( "SolverBatchSize", setPxSceneDescSolverBatchSize, getPxSceneDescSolverBatchSize )
	, SolverArticulationBatchSize( "SolverArticulationBatchSize", setPxSceneDescSolverArticulationBatchSize, getPxSceneDescSolverArticulationBatchSize )
	, NbContactDataBlocks( "NbContactDataBlocks", setPxSceneDescNbContactDataBlocks, getPxSceneDescNbContactDataBlocks )
	, MaxNbContactDataBlocks( "MaxNbContactDataBlocks", setPxSceneDescMaxNbContactDataBlocks, getPxSceneDescMaxNbContactDataBlocks )
	, MaxBiasCoefficient( "MaxBiasCoefficient", setPxSceneDescMaxBiasCoefficient, getPxSceneDescMaxBiasCoefficient )
	, ContactReportStreamBufferSize( "ContactReportStreamBufferSize", setPxSceneDescContactReportStreamBufferSize, getPxSceneDescContactReportStreamBufferSize )
	, CcdMaxPasses( "CcdMaxPasses", setPxSceneDescCcdMaxPasses, getPxSceneDescCcdMaxPasses )
	, CcdThreshold( "CcdThreshold", setPxSceneDescCcdThreshold, getPxSceneDescCcdThreshold )
	, CcdMaxSeparation( "CcdMaxSeparation", setPxSceneDescCcdMaxSeparation, getPxSceneDescCcdMaxSeparation )
	, WakeCounterResetValue( "WakeCounterResetValue", setPxSceneDescWakeCounterResetValue, getPxSceneDescWakeCounterResetValue )
	, SanityBounds( "SanityBounds", setPxSceneDescSanityBounds, getPxSceneDescSanityBounds )
	, GpuDynamicsConfig( "GpuDynamicsConfig", setPxSceneDescGpuDynamicsConfig, getPxSceneDescGpuDynamicsConfig )
	, GpuMaxNumPartitions( "GpuMaxNumPartitions", setPxSceneDescGpuMaxNumPartitions, getPxSceneDescGpuMaxNumPartitions )
	, GpuMaxNumStaticPartitions( "GpuMaxNumStaticPartitions", setPxSceneDescGpuMaxNumStaticPartitions, getPxSceneDescGpuMaxNumStaticPartitions )
	, GpuComputeVersion( "GpuComputeVersion", setPxSceneDescGpuComputeVersion, getPxSceneDescGpuComputeVersion )
	, ContactPairSlabSize( "ContactPairSlabSize", setPxSceneDescContactPairSlabSize, getPxSceneDescContactPairSlabSize )
{}
PX_PHYSX_CORE_API PxSceneDescGeneratedValues::PxSceneDescGeneratedValues( const PxSceneDesc* inSource )
		:PxSceneQueryDescGeneratedValues( inSource )
		,Gravity( inSource->gravity )
		,SimulationEventCallback( inSource->simulationEventCallback )
		,ContactModifyCallback( inSource->contactModifyCallback )
		,CcdContactModifyCallback( inSource->ccdContactModifyCallback )
		,FilterShaderData( inSource->filterShaderData )
		,FilterShaderDataSize( inSource->filterShaderDataSize )
		,FilterShader( inSource->filterShader )
		,FilterCallback( inSource->filterCallback )
		,KineKineFilteringMode( inSource->kineKineFilteringMode )
		,StaticKineFilteringMode( inSource->staticKineFilteringMode )
		,BroadPhaseType( inSource->broadPhaseType )
		,BroadPhaseCallback( inSource->broadPhaseCallback )
		,Limits( inSource->limits )
		,FrictionType( inSource->frictionType )
		,SolverType( inSource->solverType )
		,BounceThresholdVelocity( inSource->bounceThresholdVelocity )
		,FrictionOffsetThreshold( inSource->frictionOffsetThreshold )
		,FrictionCorrelationDistance( inSource->frictionCorrelationDistance )
		,Flags( inSource->flags )
		,CpuDispatcher( inSource->cpuDispatcher )
		,CudaContextManager( inSource->cudaContextManager )
		,UserData( inSource->userData )
		,SolverBatchSize( inSource->solverBatchSize )
		,SolverArticulationBatchSize( inSource->solverArticulationBatchSize )
		,NbContactDataBlocks( inSource->nbContactDataBlocks )
		,MaxNbContactDataBlocks( inSource->maxNbContactDataBlocks )
		,MaxBiasCoefficient( inSource->maxBiasCoefficient )
		,ContactReportStreamBufferSize( inSource->contactReportStreamBufferSize )
		,CcdMaxPasses( inSource->ccdMaxPasses )
		,CcdThreshold( inSource->ccdThreshold )
		,CcdMaxSeparation( inSource->ccdMaxSeparation )
		,WakeCounterResetValue( inSource->wakeCounterResetValue )
		,SanityBounds( inSource->sanityBounds )
		,GpuDynamicsConfig( inSource->gpuDynamicsConfig )
		,GpuMaxNumPartitions( inSource->gpuMaxNumPartitions )
		,GpuMaxNumStaticPartitions( inSource->gpuMaxNumStaticPartitions )
		,GpuComputeVersion( inSource->gpuComputeVersion )
		,ContactPairSlabSize( inSource->contactPairSlabSize )
{
	PX_UNUSED(inSource);
}
_Bool getPxBroadPhaseDesc_IsValid( const PxBroadPhaseDesc* inObj ) { return inObj->isValid(); }
inline PxBroadPhaseType::Enum getPxBroadPhaseDescMType( const PxBroadPhaseDesc* inOwner ) { return inOwner->mType; }
inline void setPxBroadPhaseDescMType( PxBroadPhaseDesc* inOwner, PxBroadPhaseType::Enum inData) { inOwner->mType = inData; }
inline PxU64 getPxBroadPhaseDescMContextID( const PxBroadPhaseDesc* inOwner ) { return inOwner->mContextID; }
inline void setPxBroadPhaseDescMContextID( PxBroadPhaseDesc* inOwner, PxU64 inData) { inOwner->mContextID = inData; }
inline PxCudaContextManager * getPxBroadPhaseDescMContextManager( const PxBroadPhaseDesc* inOwner ) { return inOwner->mContextManager; }
inline void setPxBroadPhaseDescMContextManager( PxBroadPhaseDesc* inOwner, PxCudaContextManager * inData) { inOwner->mContextManager = inData; }
inline PxU32 getPxBroadPhaseDescMFoundLostPairsCapacity( const PxBroadPhaseDesc* inOwner ) { return inOwner->mFoundLostPairsCapacity; }
inline void setPxBroadPhaseDescMFoundLostPairsCapacity( PxBroadPhaseDesc* inOwner, PxU32 inData) { inOwner->mFoundLostPairsCapacity = inData; }
inline _Bool getPxBroadPhaseDescMDiscardStaticVsKinematic( const PxBroadPhaseDesc* inOwner ) { return inOwner->mDiscardStaticVsKinematic; }
inline void setPxBroadPhaseDescMDiscardStaticVsKinematic( PxBroadPhaseDesc* inOwner, _Bool inData) { inOwner->mDiscardStaticVsKinematic = inData; }
inline _Bool getPxBroadPhaseDescMDiscardKinematicVsKinematic( const PxBroadPhaseDesc* inOwner ) { return inOwner->mDiscardKinematicVsKinematic; }
inline void setPxBroadPhaseDescMDiscardKinematicVsKinematic( PxBroadPhaseDesc* inOwner, _Bool inData) { inOwner->mDiscardKinematicVsKinematic = inData; }
PX_PHYSX_CORE_API PxBroadPhaseDescGeneratedInfo::PxBroadPhaseDescGeneratedInfo()
	: IsValid( "IsValid", getPxBroadPhaseDesc_IsValid)
	, MType( "MType", setPxBroadPhaseDescMType, getPxBroadPhaseDescMType )
	, MContextID( "MContextID", setPxBroadPhaseDescMContextID, getPxBroadPhaseDescMContextID )
	, MContextManager( "MContextManager", setPxBroadPhaseDescMContextManager, getPxBroadPhaseDescMContextManager )
	, MFoundLostPairsCapacity( "MFoundLostPairsCapacity", setPxBroadPhaseDescMFoundLostPairsCapacity, getPxBroadPhaseDescMFoundLostPairsCapacity )
	, MDiscardStaticVsKinematic( "MDiscardStaticVsKinematic", setPxBroadPhaseDescMDiscardStaticVsKinematic, getPxBroadPhaseDescMDiscardStaticVsKinematic )
	, MDiscardKinematicVsKinematic( "MDiscardKinematicVsKinematic", setPxBroadPhaseDescMDiscardKinematicVsKinematic, getPxBroadPhaseDescMDiscardKinematicVsKinematic )
{}
PX_PHYSX_CORE_API PxBroadPhaseDescGeneratedValues::PxBroadPhaseDescGeneratedValues( const PxBroadPhaseDesc* inSource )
		:IsValid( getPxBroadPhaseDesc_IsValid( inSource ) )
		,MType( inSource->mType )
		,MContextID( inSource->mContextID )
		,MContextManager( inSource->mContextManager )
		,MFoundLostPairsCapacity( inSource->mFoundLostPairsCapacity )
		,MDiscardStaticVsKinematic( inSource->mDiscardStaticVsKinematic )
		,MDiscardKinematicVsKinematic( inSource->mDiscardKinematicVsKinematic )
{
	PX_UNUSED(inSource);
}
inline PxU32 getPxSceneLimitsMaxNbActors( const PxSceneLimits* inOwner ) { return inOwner->maxNbActors; }
inline void setPxSceneLimitsMaxNbActors( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbActors = inData; }
inline PxU32 getPxSceneLimitsMaxNbBodies( const PxSceneLimits* inOwner ) { return inOwner->maxNbBodies; }
inline void setPxSceneLimitsMaxNbBodies( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbBodies = inData; }
inline PxU32 getPxSceneLimitsMaxNbStaticShapes( const PxSceneLimits* inOwner ) { return inOwner->maxNbStaticShapes; }
inline void setPxSceneLimitsMaxNbStaticShapes( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbStaticShapes = inData; }
inline PxU32 getPxSceneLimitsMaxNbDynamicShapes( const PxSceneLimits* inOwner ) { return inOwner->maxNbDynamicShapes; }
inline void setPxSceneLimitsMaxNbDynamicShapes( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbDynamicShapes = inData; }
inline PxU32 getPxSceneLimitsMaxNbAggregates( const PxSceneLimits* inOwner ) { return inOwner->maxNbAggregates; }
inline void setPxSceneLimitsMaxNbAggregates( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbAggregates = inData; }
inline PxU32 getPxSceneLimitsMaxNbConstraints( const PxSceneLimits* inOwner ) { return inOwner->maxNbConstraints; }
inline void setPxSceneLimitsMaxNbConstraints( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbConstraints = inData; }
inline PxU32 getPxSceneLimitsMaxNbRegions( const PxSceneLimits* inOwner ) { return inOwner->maxNbRegions; }
inline void setPxSceneLimitsMaxNbRegions( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbRegions = inData; }
inline PxU32 getPxSceneLimitsMaxNbBroadPhaseOverlaps( const PxSceneLimits* inOwner ) { return inOwner->maxNbBroadPhaseOverlaps; }
inline void setPxSceneLimitsMaxNbBroadPhaseOverlaps( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbBroadPhaseOverlaps = inData; }
PX_PHYSX_CORE_API PxSceneLimitsGeneratedInfo::PxSceneLimitsGeneratedInfo()
	: MaxNbActors( "MaxNbActors", setPxSceneLimitsMaxNbActors, getPxSceneLimitsMaxNbActors )
	, MaxNbBodies( "MaxNbBodies", setPxSceneLimitsMaxNbBodies, getPxSceneLimitsMaxNbBodies )
	, MaxNbStaticShapes( "MaxNbStaticShapes", setPxSceneLimitsMaxNbStaticShapes, getPxSceneLimitsMaxNbStaticShapes )
	, MaxNbDynamicShapes( "MaxNbDynamicShapes", setPxSceneLimitsMaxNbDynamicShapes, getPxSceneLimitsMaxNbDynamicShapes )
	, MaxNbAggregates( "MaxNbAggregates", setPxSceneLimitsMaxNbAggregates, getPxSceneLimitsMaxNbAggregates )
	, MaxNbConstraints( "MaxNbConstraints", setPxSceneLimitsMaxNbConstraints, getPxSceneLimitsMaxNbConstraints )
	, MaxNbRegions( "MaxNbRegions", setPxSceneLimitsMaxNbRegions, getPxSceneLimitsMaxNbRegions )
	, MaxNbBroadPhaseOverlaps( "MaxNbBroadPhaseOverlaps", setPxSceneLimitsMaxNbBroadPhaseOverlaps, getPxSceneLimitsMaxNbBroadPhaseOverlaps )
{}
PX_PHYSX_CORE_API PxSceneLimitsGeneratedValues::PxSceneLimitsGeneratedValues( const PxSceneLimits* inSource )
		:MaxNbActors( inSource->maxNbActors )
		,MaxNbBodies( inSource->maxNbBodies )
		,MaxNbStaticShapes( inSource->maxNbStaticShapes )
		,MaxNbDynamicShapes( inSource->maxNbDynamicShapes )
		,MaxNbAggregates( inSource->maxNbAggregates )
		,MaxNbConstraints( inSource->maxNbConstraints )
		,MaxNbRegions( inSource->maxNbRegions )
		,MaxNbBroadPhaseOverlaps( inSource->maxNbBroadPhaseOverlaps )
{
	PX_UNUSED(inSource);
}
_Bool getPxGpuDynamicsMemoryConfig_IsValid( const PxGpuDynamicsMemoryConfig* inObj ) { return inObj->isValid(); }
inline PxU64 getPxGpuDynamicsMemoryConfigTempBufferCapacity( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->tempBufferCapacity; }
inline void setPxGpuDynamicsMemoryConfigTempBufferCapacity( PxGpuDynamicsMemoryConfig* inOwner, PxU64 inData) { inOwner->tempBufferCapacity = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxRigidContactCount( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxRigidContactCount; }
inline void setPxGpuDynamicsMemoryConfigMaxRigidContactCount( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxRigidContactCount = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxRigidPatchCount( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxRigidPatchCount; }
inline void setPxGpuDynamicsMemoryConfigMaxRigidPatchCount( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxRigidPatchCount = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigHeapCapacity( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->heapCapacity; }
inline void setPxGpuDynamicsMemoryConfigHeapCapacity( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->heapCapacity = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigFoundLostPairsCapacity( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->foundLostPairsCapacity; }
inline void setPxGpuDynamicsMemoryConfigFoundLostPairsCapacity( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->foundLostPairsCapacity = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigFoundLostAggregatePairsCapacity( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->foundLostAggregatePairsCapacity; }
inline void setPxGpuDynamicsMemoryConfigFoundLostAggregatePairsCapacity( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->foundLostAggregatePairsCapacity = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigTotalAggregatePairsCapacity( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->totalAggregatePairsCapacity; }
inline void setPxGpuDynamicsMemoryConfigTotalAggregatePairsCapacity( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->totalAggregatePairsCapacity = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxDeformableSurfaceContacts( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxDeformableSurfaceContacts; }
inline void setPxGpuDynamicsMemoryConfigMaxDeformableSurfaceContacts( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxDeformableSurfaceContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxFemClothContacts( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxFemClothContacts; }
inline void setPxGpuDynamicsMemoryConfigMaxFemClothContacts( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxFemClothContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxDeformableVolumeContacts( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxDeformableVolumeContacts; }
inline void setPxGpuDynamicsMemoryConfigMaxDeformableVolumeContacts( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxDeformableVolumeContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxSoftBodyContacts( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxSoftBodyContacts; }
inline void setPxGpuDynamicsMemoryConfigMaxSoftBodyContacts( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxSoftBodyContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigMaxParticleContacts( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->maxParticleContacts; }
inline void setPxGpuDynamicsMemoryConfigMaxParticleContacts( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->maxParticleContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigCollisionStackSize( const PxGpuDynamicsMemoryConfig* inOwner ) { return inOwner->collisionStackSize; }
inline void setPxGpuDynamicsMemoryConfigCollisionStackSize( PxGpuDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->collisionStackSize = inData; }
PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigGeneratedInfo::PxGpuDynamicsMemoryConfigGeneratedInfo()
	: IsValid( "IsValid", getPxGpuDynamicsMemoryConfig_IsValid)
	, TempBufferCapacity( "TempBufferCapacity", setPxGpuDynamicsMemoryConfigTempBufferCapacity, getPxGpuDynamicsMemoryConfigTempBufferCapacity )
	, MaxRigidContactCount( "MaxRigidContactCount", setPxGpuDynamicsMemoryConfigMaxRigidContactCount, getPxGpuDynamicsMemoryConfigMaxRigidContactCount )
	, MaxRigidPatchCount( "MaxRigidPatchCount", setPxGpuDynamicsMemoryConfigMaxRigidPatchCount, getPxGpuDynamicsMemoryConfigMaxRigidPatchCount )
	, HeapCapacity( "HeapCapacity", setPxGpuDynamicsMemoryConfigHeapCapacity, getPxGpuDynamicsMemoryConfigHeapCapacity )
	, FoundLostPairsCapacity( "FoundLostPairsCapacity", setPxGpuDynamicsMemoryConfigFoundLostPairsCapacity, getPxGpuDynamicsMemoryConfigFoundLostPairsCapacity )
	, FoundLostAggregatePairsCapacity( "FoundLostAggregatePairsCapacity", setPxGpuDynamicsMemoryConfigFoundLostAggregatePairsCapacity, getPxGpuDynamicsMemoryConfigFoundLostAggregatePairsCapacity )
	, TotalAggregatePairsCapacity( "TotalAggregatePairsCapacity", setPxGpuDynamicsMemoryConfigTotalAggregatePairsCapacity, getPxGpuDynamicsMemoryConfigTotalAggregatePairsCapacity )
	, MaxDeformableSurfaceContacts( "MaxDeformableSurfaceContacts", setPxGpuDynamicsMemoryConfigMaxDeformableSurfaceContacts, getPxGpuDynamicsMemoryConfigMaxDeformableSurfaceContacts )
	, MaxFemClothContacts( "MaxFemClothContacts", setPxGpuDynamicsMemoryConfigMaxFemClothContacts, getPxGpuDynamicsMemoryConfigMaxFemClothContacts )
	, MaxDeformableVolumeContacts( "MaxDeformableVolumeContacts", setPxGpuDynamicsMemoryConfigMaxDeformableVolumeContacts, getPxGpuDynamicsMemoryConfigMaxDeformableVolumeContacts )
	, MaxSoftBodyContacts( "MaxSoftBodyContacts", setPxGpuDynamicsMemoryConfigMaxSoftBodyContacts, getPxGpuDynamicsMemoryConfigMaxSoftBodyContacts )
	, MaxParticleContacts( "MaxParticleContacts", setPxGpuDynamicsMemoryConfigMaxParticleContacts, getPxGpuDynamicsMemoryConfigMaxParticleContacts )
	, CollisionStackSize( "CollisionStackSize", setPxGpuDynamicsMemoryConfigCollisionStackSize, getPxGpuDynamicsMemoryConfigCollisionStackSize )
{}
PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigGeneratedValues::PxGpuDynamicsMemoryConfigGeneratedValues( const PxGpuDynamicsMemoryConfig* inSource )
		:IsValid( getPxGpuDynamicsMemoryConfig_IsValid( inSource ) )
		,TempBufferCapacity( inSource->tempBufferCapacity )
		,MaxRigidContactCount( inSource->maxRigidContactCount )
		,MaxRigidPatchCount( inSource->maxRigidPatchCount )
		,HeapCapacity( inSource->heapCapacity )
		,FoundLostPairsCapacity( inSource->foundLostPairsCapacity )
		,FoundLostAggregatePairsCapacity( inSource->foundLostAggregatePairsCapacity )
		,TotalAggregatePairsCapacity( inSource->totalAggregatePairsCapacity )
		,MaxDeformableSurfaceContacts( inSource->maxDeformableSurfaceContacts )
		,MaxFemClothContacts( inSource->maxFemClothContacts )
		,MaxDeformableVolumeContacts( inSource->maxDeformableVolumeContacts )
		,MaxSoftBodyContacts( inSource->maxSoftBodyContacts )
		,MaxParticleContacts( inSource->maxParticleContacts )
		,CollisionStackSize( inSource->collisionStackSize )
{
	PX_UNUSED(inSource);
}
inline PxU64 getPxGpuDynamicsMemoryConfigStatisticsTempBufferCapacity( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->tempBufferCapacity; }
inline void setPxGpuDynamicsMemoryConfigStatisticsTempBufferCapacity( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU64 inData) { inOwner->tempBufferCapacity = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsRigidContactCount( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->rigidContactCount; }
inline void setPxGpuDynamicsMemoryConfigStatisticsRigidContactCount( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->rigidContactCount = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsRigidPatchCount( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->rigidPatchCount; }
inline void setPxGpuDynamicsMemoryConfigStatisticsRigidPatchCount( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->rigidPatchCount = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsFoundLostPairs( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->foundLostPairs; }
inline void setPxGpuDynamicsMemoryConfigStatisticsFoundLostPairs( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->foundLostPairs = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsFoundLostAggregatePairs( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->foundLostAggregatePairs; }
inline void setPxGpuDynamicsMemoryConfigStatisticsFoundLostAggregatePairs( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->foundLostAggregatePairs = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsTotalAggregatePairs( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->totalAggregatePairs; }
inline void setPxGpuDynamicsMemoryConfigStatisticsTotalAggregatePairs( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->totalAggregatePairs = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsDeformableSurfaceContacts( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->deformableSurfaceContacts; }
inline void setPxGpuDynamicsMemoryConfigStatisticsDeformableSurfaceContacts( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->deformableSurfaceContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsDeformableVolumeContacts( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->deformableVolumeContacts; }
inline void setPxGpuDynamicsMemoryConfigStatisticsDeformableVolumeContacts( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->deformableVolumeContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsSoftbodyContacts( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->softbodyContacts; }
inline void setPxGpuDynamicsMemoryConfigStatisticsSoftbodyContacts( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->softbodyContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsParticleContacts( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->particleContacts; }
inline void setPxGpuDynamicsMemoryConfigStatisticsParticleContacts( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->particleContacts = inData; }
inline PxU32 getPxGpuDynamicsMemoryConfigStatisticsCollisionStackSize( const PxGpuDynamicsMemoryConfigStatistics* inOwner ) { return inOwner->collisionStackSize; }
inline void setPxGpuDynamicsMemoryConfigStatisticsCollisionStackSize( PxGpuDynamicsMemoryConfigStatistics* inOwner, PxU32 inData) { inOwner->collisionStackSize = inData; }
PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigStatisticsGeneratedInfo::PxGpuDynamicsMemoryConfigStatisticsGeneratedInfo()
	: TempBufferCapacity( "TempBufferCapacity", setPxGpuDynamicsMemoryConfigStatisticsTempBufferCapacity, getPxGpuDynamicsMemoryConfigStatisticsTempBufferCapacity )
	, RigidContactCount( "RigidContactCount", setPxGpuDynamicsMemoryConfigStatisticsRigidContactCount, getPxGpuDynamicsMemoryConfigStatisticsRigidContactCount )
	, RigidPatchCount( "RigidPatchCount", setPxGpuDynamicsMemoryConfigStatisticsRigidPatchCount, getPxGpuDynamicsMemoryConfigStatisticsRigidPatchCount )
	, FoundLostPairs( "FoundLostPairs", setPxGpuDynamicsMemoryConfigStatisticsFoundLostPairs, getPxGpuDynamicsMemoryConfigStatisticsFoundLostPairs )
	, FoundLostAggregatePairs( "FoundLostAggregatePairs", setPxGpuDynamicsMemoryConfigStatisticsFoundLostAggregatePairs, getPxGpuDynamicsMemoryConfigStatisticsFoundLostAggregatePairs )
	, TotalAggregatePairs( "TotalAggregatePairs", setPxGpuDynamicsMemoryConfigStatisticsTotalAggregatePairs, getPxGpuDynamicsMemoryConfigStatisticsTotalAggregatePairs )
	, DeformableSurfaceContacts( "DeformableSurfaceContacts", setPxGpuDynamicsMemoryConfigStatisticsDeformableSurfaceContacts, getPxGpuDynamicsMemoryConfigStatisticsDeformableSurfaceContacts )
	, DeformableVolumeContacts( "DeformableVolumeContacts", setPxGpuDynamicsMemoryConfigStatisticsDeformableVolumeContacts, getPxGpuDynamicsMemoryConfigStatisticsDeformableVolumeContacts )
	, SoftbodyContacts( "SoftbodyContacts", setPxGpuDynamicsMemoryConfigStatisticsSoftbodyContacts, getPxGpuDynamicsMemoryConfigStatisticsSoftbodyContacts )
	, ParticleContacts( "ParticleContacts", setPxGpuDynamicsMemoryConfigStatisticsParticleContacts, getPxGpuDynamicsMemoryConfigStatisticsParticleContacts )
	, CollisionStackSize( "CollisionStackSize", setPxGpuDynamicsMemoryConfigStatisticsCollisionStackSize, getPxGpuDynamicsMemoryConfigStatisticsCollisionStackSize )
{}
PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigStatisticsGeneratedValues::PxGpuDynamicsMemoryConfigStatisticsGeneratedValues( const PxGpuDynamicsMemoryConfigStatistics* inSource )
		:TempBufferCapacity( inSource->tempBufferCapacity )
		,RigidContactCount( inSource->rigidContactCount )
		,RigidPatchCount( inSource->rigidPatchCount )
		,FoundLostPairs( inSource->foundLostPairs )
		,FoundLostAggregatePairs( inSource->foundLostAggregatePairs )
		,TotalAggregatePairs( inSource->totalAggregatePairs )
		,DeformableSurfaceContacts( inSource->deformableSurfaceContacts )
		,DeformableVolumeContacts( inSource->deformableVolumeContacts )
		,SoftbodyContacts( inSource->softbodyContacts )
		,ParticleContacts( inSource->particleContacts )
		,CollisionStackSize( inSource->collisionStackSize )
{
	PX_UNUSED(inSource);
}
inline PxU32 getPxSimulationStatisticsNbActiveConstraints( const PxSimulationStatistics* inOwner ) { return inOwner->nbActiveConstraints; }
inline void setPxSimulationStatisticsNbActiveConstraints( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbActiveConstraints = inData; }
inline PxU32 getPxSimulationStatisticsNbActiveDynamicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbActiveDynamicBodies; }
inline void setPxSimulationStatisticsNbActiveDynamicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbActiveDynamicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbActiveKinematicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbActiveKinematicBodies; }
inline void setPxSimulationStatisticsNbActiveKinematicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbActiveKinematicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbStaticBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbStaticBodies; }
inline void setPxSimulationStatisticsNbStaticBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbStaticBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbDynamicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbDynamicBodies; }
inline void setPxSimulationStatisticsNbDynamicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDynamicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbKinematicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbKinematicBodies; }
inline void setPxSimulationStatisticsNbKinematicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbKinematicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbAggregates( const PxSimulationStatistics* inOwner ) { return inOwner->nbAggregates; }
inline void setPxSimulationStatisticsNbAggregates( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbAggregates = inData; }
inline PxU32 getPxSimulationStatisticsNbArticulations( const PxSimulationStatistics* inOwner ) { return inOwner->nbArticulations; }
inline void setPxSimulationStatisticsNbArticulations( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbArticulations = inData; }
inline PxU32 getPxSimulationStatisticsNbAxisSolverConstraints( const PxSimulationStatistics* inOwner ) { return inOwner->nbAxisSolverConstraints; }
inline void setPxSimulationStatisticsNbAxisSolverConstraints( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbAxisSolverConstraints = inData; }
inline PxU32 getPxSimulationStatisticsCompressedContactSize( const PxSimulationStatistics* inOwner ) { return inOwner->compressedContactSize; }
inline void setPxSimulationStatisticsCompressedContactSize( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->compressedContactSize = inData; }
inline PxU32 getPxSimulationStatisticsRequiredContactConstraintMemory( const PxSimulationStatistics* inOwner ) { return inOwner->requiredContactConstraintMemory; }
inline void setPxSimulationStatisticsRequiredContactConstraintMemory( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->requiredContactConstraintMemory = inData; }
inline PxU32 getPxSimulationStatisticsPeakConstraintMemory( const PxSimulationStatistics* inOwner ) { return inOwner->peakConstraintMemory; }
inline void setPxSimulationStatisticsPeakConstraintMemory( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->peakConstraintMemory = inData; }
inline PxU32 getPxSimulationStatisticsNbDiscreteContactPairsTotal( const PxSimulationStatistics* inOwner ) { return inOwner->nbDiscreteContactPairsTotal; }
inline void setPxSimulationStatisticsNbDiscreteContactPairsTotal( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDiscreteContactPairsTotal = inData; }
inline PxU32 getPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits( const PxSimulationStatistics* inOwner ) { return inOwner->nbDiscreteContactPairsWithCacheHits; }
inline void setPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDiscreteContactPairsWithCacheHits = inData; }
inline PxU32 getPxSimulationStatisticsNbDiscreteContactPairsWithContacts( const PxSimulationStatistics* inOwner ) { return inOwner->nbDiscreteContactPairsWithContacts; }
inline void setPxSimulationStatisticsNbDiscreteContactPairsWithContacts( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDiscreteContactPairsWithContacts = inData; }
inline PxU32 getPxSimulationStatisticsNbNewPairs( const PxSimulationStatistics* inOwner ) { return inOwner->nbNewPairs; }
inline void setPxSimulationStatisticsNbNewPairs( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbNewPairs = inData; }
inline PxU32 getPxSimulationStatisticsNbLostPairs( const PxSimulationStatistics* inOwner ) { return inOwner->nbLostPairs; }
inline void setPxSimulationStatisticsNbLostPairs( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbLostPairs = inData; }
inline PxU32 getPxSimulationStatisticsNbNewTouches( const PxSimulationStatistics* inOwner ) { return inOwner->nbNewTouches; }
inline void setPxSimulationStatisticsNbNewTouches( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbNewTouches = inData; }
inline PxU32 getPxSimulationStatisticsNbLostTouches( const PxSimulationStatistics* inOwner ) { return inOwner->nbLostTouches; }
inline void setPxSimulationStatisticsNbLostTouches( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbLostTouches = inData; }
inline PxU32 getPxSimulationStatisticsNbPartitions( const PxSimulationStatistics* inOwner ) { return inOwner->nbPartitions; }
inline void setPxSimulationStatisticsNbPartitions( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbPartitions = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemParticles( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemParticles; }
inline void setPxSimulationStatisticsGpuMemParticles( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemParticles = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemDeformableSurfaces( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemDeformableSurfaces; }
inline void setPxSimulationStatisticsGpuMemDeformableSurfaces( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemDeformableSurfaces = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemDeformableVolumes( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemDeformableVolumes; }
inline void setPxSimulationStatisticsGpuMemDeformableVolumes( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemDeformableVolumes = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemSoftBodies( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemSoftBodies; }
inline void setPxSimulationStatisticsGpuMemSoftBodies( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemSoftBodies = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeap( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeap; }
inline void setPxSimulationStatisticsGpuMemHeap( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeap = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapBroadPhase( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapBroadPhase; }
inline void setPxSimulationStatisticsGpuMemHeapBroadPhase( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapBroadPhase = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapNarrowPhase( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapNarrowPhase; }
inline void setPxSimulationStatisticsGpuMemHeapNarrowPhase( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapNarrowPhase = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSolver( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSolver; }
inline void setPxSimulationStatisticsGpuMemHeapSolver( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSolver = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapArticulation( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapArticulation; }
inline void setPxSimulationStatisticsGpuMemHeapArticulation( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapArticulation = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSimulation( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSimulation; }
inline void setPxSimulationStatisticsGpuMemHeapSimulation( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSimulation = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSimulationArticulation( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSimulationArticulation; }
inline void setPxSimulationStatisticsGpuMemHeapSimulationArticulation( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSimulationArticulation = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSimulationParticles( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSimulationParticles; }
inline void setPxSimulationStatisticsGpuMemHeapSimulationParticles( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSimulationParticles = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSimulationDeformableSurface( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSimulationDeformableSurface; }
inline void setPxSimulationStatisticsGpuMemHeapSimulationDeformableSurface( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSimulationDeformableSurface = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSimulationDeformableVolume( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSimulationDeformableVolume; }
inline void setPxSimulationStatisticsGpuMemHeapSimulationDeformableVolume( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSimulationDeformableVolume = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSimulationSoftBody( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSimulationSoftBody; }
inline void setPxSimulationStatisticsGpuMemHeapSimulationSoftBody( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSimulationSoftBody = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapParticles( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapParticles; }
inline void setPxSimulationStatisticsGpuMemHeapParticles( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapParticles = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapDeformableSurfaces( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapDeformableSurfaces; }
inline void setPxSimulationStatisticsGpuMemHeapDeformableSurfaces( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapDeformableSurfaces = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapDeformableVolumes( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapDeformableVolumes; }
inline void setPxSimulationStatisticsGpuMemHeapDeformableVolumes( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapDeformableVolumes = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapSoftBodies( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapSoftBodies; }
inline void setPxSimulationStatisticsGpuMemHeapSoftBodies( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapSoftBodies = inData; }
inline PxU64 getPxSimulationStatisticsGpuMemHeapOther( const PxSimulationStatistics* inOwner ) { return inOwner->gpuMemHeapOther; }
inline void setPxSimulationStatisticsGpuMemHeapOther( PxSimulationStatistics* inOwner, PxU64 inData) { inOwner->gpuMemHeapOther = inData; }
inline PxGpuDynamicsMemoryConfigStatistics getPxSimulationStatisticsGpuDynamicsMemoryConfigStatistics( const PxSimulationStatistics* inOwner ) { return inOwner->gpuDynamicsMemoryConfigStatistics; }
inline void setPxSimulationStatisticsGpuDynamicsMemoryConfigStatistics( PxSimulationStatistics* inOwner, PxGpuDynamicsMemoryConfigStatistics inData) { inOwner->gpuDynamicsMemoryConfigStatistics = inData; }
inline PxU32 getPxSimulationStatisticsNbBroadPhaseAdds( const PxSimulationStatistics* inOwner ) { return inOwner->nbBroadPhaseAdds; }
inline void setPxSimulationStatisticsNbBroadPhaseAdds( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbBroadPhaseAdds = inData; }
inline PxU32 getPxSimulationStatisticsNbBroadPhaseRemoves( const PxSimulationStatistics* inOwner ) { return inOwner->nbBroadPhaseRemoves; }
inline void setPxSimulationStatisticsNbBroadPhaseRemoves( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbBroadPhaseRemoves = inData; }
PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedInfo::PxSimulationStatisticsGeneratedInfo()
	: NbActiveConstraints( "NbActiveConstraints", setPxSimulationStatisticsNbActiveConstraints, getPxSimulationStatisticsNbActiveConstraints )
	, NbActiveDynamicBodies( "NbActiveDynamicBodies", setPxSimulationStatisticsNbActiveDynamicBodies, getPxSimulationStatisticsNbActiveDynamicBodies )
	, NbActiveKinematicBodies( "NbActiveKinematicBodies", setPxSimulationStatisticsNbActiveKinematicBodies, getPxSimulationStatisticsNbActiveKinematicBodies )
	, NbStaticBodies( "NbStaticBodies", setPxSimulationStatisticsNbStaticBodies, getPxSimulationStatisticsNbStaticBodies )
	, NbDynamicBodies( "NbDynamicBodies", setPxSimulationStatisticsNbDynamicBodies, getPxSimulationStatisticsNbDynamicBodies )
	, NbKinematicBodies( "NbKinematicBodies", setPxSimulationStatisticsNbKinematicBodies, getPxSimulationStatisticsNbKinematicBodies )
	, NbAggregates( "NbAggregates", setPxSimulationStatisticsNbAggregates, getPxSimulationStatisticsNbAggregates )
	, NbArticulations( "NbArticulations", setPxSimulationStatisticsNbArticulations, getPxSimulationStatisticsNbArticulations )
	, NbAxisSolverConstraints( "NbAxisSolverConstraints", setPxSimulationStatisticsNbAxisSolverConstraints, getPxSimulationStatisticsNbAxisSolverConstraints )
	, CompressedContactSize( "CompressedContactSize", setPxSimulationStatisticsCompressedContactSize, getPxSimulationStatisticsCompressedContactSize )
	, RequiredContactConstraintMemory( "RequiredContactConstraintMemory", setPxSimulationStatisticsRequiredContactConstraintMemory, getPxSimulationStatisticsRequiredContactConstraintMemory )
	, PeakConstraintMemory( "PeakConstraintMemory", setPxSimulationStatisticsPeakConstraintMemory, getPxSimulationStatisticsPeakConstraintMemory )
	, NbDiscreteContactPairsTotal( "NbDiscreteContactPairsTotal", setPxSimulationStatisticsNbDiscreteContactPairsTotal, getPxSimulationStatisticsNbDiscreteContactPairsTotal )
	, NbDiscreteContactPairsWithCacheHits( "NbDiscreteContactPairsWithCacheHits", setPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits, getPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits )
	, NbDiscreteContactPairsWithContacts( "NbDiscreteContactPairsWithContacts", setPxSimulationStatisticsNbDiscreteContactPairsWithContacts, getPxSimulationStatisticsNbDiscreteContactPairsWithContacts )
	, NbNewPairs( "NbNewPairs", setPxSimulationStatisticsNbNewPairs, getPxSimulationStatisticsNbNewPairs )
	, NbLostPairs( "NbLostPairs", setPxSimulationStatisticsNbLostPairs, getPxSimulationStatisticsNbLostPairs )
	, NbNewTouches( "NbNewTouches", setPxSimulationStatisticsNbNewTouches, getPxSimulationStatisticsNbNewTouches )
	, NbLostTouches( "NbLostTouches", setPxSimulationStatisticsNbLostTouches, getPxSimulationStatisticsNbLostTouches )
	, NbPartitions( "NbPartitions", setPxSimulationStatisticsNbPartitions, getPxSimulationStatisticsNbPartitions )
	, GpuMemParticles( "GpuMemParticles", setPxSimulationStatisticsGpuMemParticles, getPxSimulationStatisticsGpuMemParticles )
	, GpuMemDeformableSurfaces( "GpuMemDeformableSurfaces", setPxSimulationStatisticsGpuMemDeformableSurfaces, getPxSimulationStatisticsGpuMemDeformableSurfaces )
	, GpuMemDeformableVolumes( "GpuMemDeformableVolumes", setPxSimulationStatisticsGpuMemDeformableVolumes, getPxSimulationStatisticsGpuMemDeformableVolumes )
	, GpuMemSoftBodies( "GpuMemSoftBodies", setPxSimulationStatisticsGpuMemSoftBodies, getPxSimulationStatisticsGpuMemSoftBodies )
	, GpuMemHeap( "GpuMemHeap", setPxSimulationStatisticsGpuMemHeap, getPxSimulationStatisticsGpuMemHeap )
	, GpuMemHeapBroadPhase( "GpuMemHeapBroadPhase", setPxSimulationStatisticsGpuMemHeapBroadPhase, getPxSimulationStatisticsGpuMemHeapBroadPhase )
	, GpuMemHeapNarrowPhase( "GpuMemHeapNarrowPhase", setPxSimulationStatisticsGpuMemHeapNarrowPhase, getPxSimulationStatisticsGpuMemHeapNarrowPhase )
	, GpuMemHeapSolver( "GpuMemHeapSolver", setPxSimulationStatisticsGpuMemHeapSolver, getPxSimulationStatisticsGpuMemHeapSolver )
	, GpuMemHeapArticulation( "GpuMemHeapArticulation", setPxSimulationStatisticsGpuMemHeapArticulation, getPxSimulationStatisticsGpuMemHeapArticulation )
	, GpuMemHeapSimulation( "GpuMemHeapSimulation", setPxSimulationStatisticsGpuMemHeapSimulation, getPxSimulationStatisticsGpuMemHeapSimulation )
	, GpuMemHeapSimulationArticulation( "GpuMemHeapSimulationArticulation", setPxSimulationStatisticsGpuMemHeapSimulationArticulation, getPxSimulationStatisticsGpuMemHeapSimulationArticulation )
	, GpuMemHeapSimulationParticles( "GpuMemHeapSimulationParticles", setPxSimulationStatisticsGpuMemHeapSimulationParticles, getPxSimulationStatisticsGpuMemHeapSimulationParticles )
	, GpuMemHeapSimulationDeformableSurface( "GpuMemHeapSimulationDeformableSurface", setPxSimulationStatisticsGpuMemHeapSimulationDeformableSurface, getPxSimulationStatisticsGpuMemHeapSimulationDeformableSurface )
	, GpuMemHeapSimulationDeformableVolume( "GpuMemHeapSimulationDeformableVolume", setPxSimulationStatisticsGpuMemHeapSimulationDeformableVolume, getPxSimulationStatisticsGpuMemHeapSimulationDeformableVolume )
	, GpuMemHeapSimulationSoftBody( "GpuMemHeapSimulationSoftBody", setPxSimulationStatisticsGpuMemHeapSimulationSoftBody, getPxSimulationStatisticsGpuMemHeapSimulationSoftBody )
	, GpuMemHeapParticles( "GpuMemHeapParticles", setPxSimulationStatisticsGpuMemHeapParticles, getPxSimulationStatisticsGpuMemHeapParticles )
	, GpuMemHeapDeformableSurfaces( "GpuMemHeapDeformableSurfaces", setPxSimulationStatisticsGpuMemHeapDeformableSurfaces, getPxSimulationStatisticsGpuMemHeapDeformableSurfaces )
	, GpuMemHeapDeformableVolumes( "GpuMemHeapDeformableVolumes", setPxSimulationStatisticsGpuMemHeapDeformableVolumes, getPxSimulationStatisticsGpuMemHeapDeformableVolumes )
	, GpuMemHeapSoftBodies( "GpuMemHeapSoftBodies", setPxSimulationStatisticsGpuMemHeapSoftBodies, getPxSimulationStatisticsGpuMemHeapSoftBodies )
	, GpuMemHeapOther( "GpuMemHeapOther", setPxSimulationStatisticsGpuMemHeapOther, getPxSimulationStatisticsGpuMemHeapOther )
	, GpuDynamicsMemoryConfigStatistics( "GpuDynamicsMemoryConfigStatistics", setPxSimulationStatisticsGpuDynamicsMemoryConfigStatistics, getPxSimulationStatisticsGpuDynamicsMemoryConfigStatistics )
	, NbBroadPhaseAdds( "NbBroadPhaseAdds", setPxSimulationStatisticsNbBroadPhaseAdds, getPxSimulationStatisticsNbBroadPhaseAdds )
	, NbBroadPhaseRemoves( "NbBroadPhaseRemoves", setPxSimulationStatisticsNbBroadPhaseRemoves, getPxSimulationStatisticsNbBroadPhaseRemoves )
{}
PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedValues::PxSimulationStatisticsGeneratedValues( const PxSimulationStatistics* inSource )
		:NbActiveConstraints( inSource->nbActiveConstraints )
		,NbActiveDynamicBodies( inSource->nbActiveDynamicBodies )
		,NbActiveKinematicBodies( inSource->nbActiveKinematicBodies )
		,NbStaticBodies( inSource->nbStaticBodies )
		,NbDynamicBodies( inSource->nbDynamicBodies )
		,NbKinematicBodies( inSource->nbKinematicBodies )
		,NbAggregates( inSource->nbAggregates )
		,NbArticulations( inSource->nbArticulations )
		,NbAxisSolverConstraints( inSource->nbAxisSolverConstraints )
		,CompressedContactSize( inSource->compressedContactSize )
		,RequiredContactConstraintMemory( inSource->requiredContactConstraintMemory )
		,PeakConstraintMemory( inSource->peakConstraintMemory )
		,NbDiscreteContactPairsTotal( inSource->nbDiscreteContactPairsTotal )
		,NbDiscreteContactPairsWithCacheHits( inSource->nbDiscreteContactPairsWithCacheHits )
		,NbDiscreteContactPairsWithContacts( inSource->nbDiscreteContactPairsWithContacts )
		,NbNewPairs( inSource->nbNewPairs )
		,NbLostPairs( inSource->nbLostPairs )
		,NbNewTouches( inSource->nbNewTouches )
		,NbLostTouches( inSource->nbLostTouches )
		,NbPartitions( inSource->nbPartitions )
		,GpuMemParticles( inSource->gpuMemParticles )
		,GpuMemDeformableSurfaces( inSource->gpuMemDeformableSurfaces )
		,GpuMemDeformableVolumes( inSource->gpuMemDeformableVolumes )
		,GpuMemSoftBodies( inSource->gpuMemSoftBodies )
		,GpuMemHeap( inSource->gpuMemHeap )
		,GpuMemHeapBroadPhase( inSource->gpuMemHeapBroadPhase )
		,GpuMemHeapNarrowPhase( inSource->gpuMemHeapNarrowPhase )
		,GpuMemHeapSolver( inSource->gpuMemHeapSolver )
		,GpuMemHeapArticulation( inSource->gpuMemHeapArticulation )
		,GpuMemHeapSimulation( inSource->gpuMemHeapSimulation )
		,GpuMemHeapSimulationArticulation( inSource->gpuMemHeapSimulationArticulation )
		,GpuMemHeapSimulationParticles( inSource->gpuMemHeapSimulationParticles )
		,GpuMemHeapSimulationDeformableSurface( inSource->gpuMemHeapSimulationDeformableSurface )
		,GpuMemHeapSimulationDeformableVolume( inSource->gpuMemHeapSimulationDeformableVolume )
		,GpuMemHeapSimulationSoftBody( inSource->gpuMemHeapSimulationSoftBody )
		,GpuMemHeapParticles( inSource->gpuMemHeapParticles )
		,GpuMemHeapDeformableSurfaces( inSource->gpuMemHeapDeformableSurfaces )
		,GpuMemHeapDeformableVolumes( inSource->gpuMemHeapDeformableVolumes )
		,GpuMemHeapSoftBodies( inSource->gpuMemHeapSoftBodies )
		,GpuMemHeapOther( inSource->gpuMemHeapOther )
		,GpuDynamicsMemoryConfigStatistics( inSource->gpuDynamicsMemoryConfigStatistics )
		,NbBroadPhaseAdds( inSource->nbBroadPhaseAdds )
		,NbBroadPhaseRemoves( inSource->nbBroadPhaseRemoves )
{
	PX_UNUSED(inSource);
	PxMemCopy( NbDiscreteContactPairs, inSource->nbDiscreteContactPairs, sizeof( NbDiscreteContactPairs ) );
	PxMemCopy( NbModifiedContactPairs, inSource->nbModifiedContactPairs, sizeof( NbModifiedContactPairs ) );
	PxMemCopy( NbCCDPairs, inSource->nbCCDPairs, sizeof( NbCCDPairs ) );
	PxMemCopy( NbTriggerPairs, inSource->nbTriggerPairs, sizeof( NbTriggerPairs ) );
	PxMemCopy( NbShapes, inSource->nbShapes, sizeof( NbShapes ) );
}
