//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#include ".//tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

PhysxSchemaTokensType::PhysxSchemaTokensType() :
    acceleration("acceleration", TfToken::Immortal),
    actor0("actor0", TfToken::Immortal),
    actor1("actor1", TfToken::Immortal),
    alwaysUpdateEnabled("alwaysUpdateEnabled", TfToken::Immortal),
    Asynchronous("Asynchronous", TfToken::Immortal),
    attachmentEnabled("attachmentEnabled", TfToken::Immortal),
    average("average", TfToken::Immortal),
    BitsPerPixel16("BitsPerPixel16", TfToken::Immortal),
    BitsPerPixel32("BitsPerPixel32", TfToken::Immortal),
    BitsPerPixel8("BitsPerPixel8", TfToken::Immortal),
    brakes0("brakes0", TfToken::Immortal),
    brakes1("brakes1", TfToken::Immortal),
    clothConstaint("clothConstaint", TfToken::Immortal),
    collisionFilterIndices0("collisionFilterIndices0", TfToken::Immortal),
    collisionFilterIndices1("collisionFilterIndices1", TfToken::Immortal),
    collisionmeshes("collisionmeshes", TfToken::Immortal),
    constrained("constrained", TfToken::Immortal),
    contactOffset("contactOffset", TfToken::Immortal),
    convexDecomposition("convexDecomposition", TfToken::Immortal),
    convexHull("convexHull", TfToken::Immortal),
    defaultFrictionValue("defaultFrictionValue", TfToken::Immortal),
    Disabled("Disabled", TfToken::Immortal),
    drive("drive", TfToken::Immortal),
    easy("easy", TfToken::Immortal),
    enableCCD("enableCCD", TfToken::Immortal),
    filterType0("filterType0", TfToken::Immortal),
    filterType1("filterType1", TfToken::Immortal),
    flood("flood", TfToken::Immortal),
    fluidRestOffset("fluidRestOffset", TfToken::Immortal),
    force("force", TfToken::Immortal),
    frictionValues("frictionValues", TfToken::Immortal),
    Geometry("Geometry", TfToken::Immortal),
    globalSelfCollisionEnabled("globalSelfCollisionEnabled", TfToken::Immortal),
    GPU("GPU", TfToken::Immortal),
    groundMaterials("groundMaterials", TfToken::Immortal),
    indices("indices", TfToken::Immortal),
    max("max", TfToken::Immortal),
    maxDepenetrationVelocity("maxDepenetrationVelocity", TfToken::Immortal),
    maxNeighborhood("maxNeighborhood", TfToken::Immortal),
    maxVelocity("maxVelocity", TfToken::Immortal),
    MBP("MBP", TfToken::Immortal),
    min("min", TfToken::Immortal),
    multiply("multiply", TfToken::Immortal),
    negX("negX", TfToken::Immortal),
    negY("negY", TfToken::Immortal),
    negZ("negZ", TfToken::Immortal),
    neighborhoodScale("neighborhoodScale", TfToken::Immortal),
    nonParticleCollisionEnabled("nonParticleCollisionEnabled", TfToken::Immortal),
    particleContactOffset("particleContactOffset", TfToken::Immortal),
    particleSystemEnabled("particleSystemEnabled", TfToken::Immortal),
    patch("patch", TfToken::Immortal),
    PCM("PCM", TfToken::Immortal),
    PGS("PGS", TfToken::Immortal),
    physicsBody0Indices("physics:body0Indices", TfToken::Immortal),
    physicsBody0s("physics:body0s", TfToken::Immortal),
    physicsBody1Indices("physics:body1Indices", TfToken::Immortal),
    physicsBody1s("physics:body1s", TfToken::Immortal),
    physicsGearRatio("physics:gearRatio", TfToken::Immortal),
    physicsHinge("physics:hinge", TfToken::Immortal),
    physicsHinge0("physics:hinge0", TfToken::Immortal),
    physicsHinge1("physics:hinge1", TfToken::Immortal),
    physicsLocalPos0s("physics:localPos0s", TfToken::Immortal),
    physicsLocalPos1s("physics:localPos1s", TfToken::Immortal),
    physicsLocalRot0s("physics:localRot0s", TfToken::Immortal),
    physicsLocalRot1s("physics:localRot1s", TfToken::Immortal),
    physicsPrismatic("physics:prismatic", TfToken::Immortal),
    physicsProtoIndices("physics:protoIndices", TfToken::Immortal),
    physicsPrototypes("physics:prototypes", TfToken::Immortal),
    physicsRatio("physics:ratio", TfToken::Immortal),
    physxArticulationArticulationEnabled("physxArticulation:articulationEnabled", TfToken::Immortal),
    physxArticulationEnabledSelfCollisions("physxArticulation:enabledSelfCollisions", TfToken::Immortal),
    physxArticulationSleepThreshold("physxArticulation:sleepThreshold", TfToken::Immortal),
    physxArticulationSolverPositionIterationCount("physxArticulation:solverPositionIterationCount", TfToken::Immortal),
    physxArticulationSolverVelocityIterationCount("physxArticulation:solverVelocityIterationCount", TfToken::Immortal),
    physxArticulationStabilizationThreshold("physxArticulation:stabilizationThreshold", TfToken::Immortal),
    physxAutoAttachmentCollisionFilteringOffset("physxAutoAttachment:collisionFilteringOffset", TfToken::Immortal),
    physxAutoAttachmentDeformableVertexOverlapOffset("physxAutoAttachment:deformableVertexOverlapOffset", TfToken::Immortal),
    physxAutoAttachmentEnableCollisionFiltering("physxAutoAttachment:enableCollisionFiltering", TfToken::Immortal),
    physxAutoAttachmentEnableDeformableFilteringPairs("physxAutoAttachment:enableDeformableFilteringPairs", TfToken::Immortal),
    physxAutoAttachmentEnableDeformableVertexAttachments("physxAutoAttachment:enableDeformableVertexAttachments", TfToken::Immortal),
    physxAutoAttachmentEnableRigidSurfaceAttachments("physxAutoAttachment:enableRigidSurfaceAttachments", TfToken::Immortal),
    physxAutoAttachmentRigidSurfaceSamplingDistance("physxAutoAttachment:rigidSurfaceSamplingDistance", TfToken::Immortal),
    physxAutoParticleClothDisableMeshWelding("physxAutoParticleCloth:disableMeshWelding", TfToken::Immortal),
    physxAutoParticleClothSpringBendStiffness("physxAutoParticleCloth:springBendStiffness", TfToken::Immortal),
    physxAutoParticleClothSpringDamping("physxAutoParticleCloth:springDamping", TfToken::Immortal),
    physxAutoParticleClothSpringShearStiffness("physxAutoParticleCloth:springShearStiffness", TfToken::Immortal),
    physxAutoParticleClothSpringStretchStiffness("physxAutoParticleCloth:springStretchStiffness", TfToken::Immortal),
    physxCameraSubject("physxCamera:subject", TfToken::Immortal),
    physxCharacterControllerClimbingMode("physxCharacterController:climbingMode", TfToken::Immortal),
    physxCharacterControllerContactOffset("physxCharacterController:contactOffset", TfToken::Immortal),
    physxCharacterControllerInvisibleWallHeight("physxCharacterController:invisibleWallHeight", TfToken::Immortal),
    physxCharacterControllerMaxJumpHeight("physxCharacterController:maxJumpHeight", TfToken::Immortal),
    physxCharacterControllerMoveTarget("physxCharacterController:moveTarget", TfToken::Immortal),
    physxCharacterControllerNonWalkableMode("physxCharacterController:nonWalkableMode", TfToken::Immortal),
    physxCharacterControllerScaleCoeff("physxCharacterController:scaleCoeff", TfToken::Immortal),
    physxCharacterControllerSimulationOwner("physxCharacterController:simulationOwner", TfToken::Immortal),
    physxCharacterControllerSlopeLimit("physxCharacterController:slopeLimit", TfToken::Immortal),
    physxCharacterControllerStepOffset("physxCharacterController:stepOffset", TfToken::Immortal),
    physxCharacterControllerUpAxis("physxCharacterController:upAxis", TfToken::Immortal),
    physxCharacterControllerVolumeGrowth("physxCharacterController:volumeGrowth", TfToken::Immortal),
    physxCollisionContactOffset("physxCollision:contactOffset", TfToken::Immortal),
    physxCollisionCustomGeometry("physxCollisionCustomGeometry", TfToken::Immortal),
    physxCollisionMinTorsionalPatchRadius("physxCollision:minTorsionalPatchRadius", TfToken::Immortal),
    physxCollisionRestOffset("physxCollision:restOffset", TfToken::Immortal),
    physxCollisionTorsionalPatchRadius("physxCollision:torsionalPatchRadius", TfToken::Immortal),
    physxContactReportReportPairs("physxContactReport:reportPairs", TfToken::Immortal),
    physxContactReportThreshold("physxContactReport:threshold", TfToken::Immortal),
    physxConvexDecompositionCollisionErrorPercentage("physxConvexDecompositionCollision:errorPercentage", TfToken::Immortal),
    physxConvexDecompositionCollisionHullVertexLimit("physxConvexDecompositionCollision:hullVertexLimit", TfToken::Immortal),
    physxConvexDecompositionCollisionMaxConvexHulls("physxConvexDecompositionCollision:maxConvexHulls", TfToken::Immortal),
    physxConvexDecompositionCollisionMinThickness("physxConvexDecompositionCollision:minThickness", TfToken::Immortal),
    physxConvexDecompositionCollisionShrinkWrap("physxConvexDecompositionCollision:shrinkWrap", TfToken::Immortal),
    physxConvexDecompositionCollisionVoxelResolution("physxConvexDecompositionCollision:voxelResolution", TfToken::Immortal),
    physxConvexHullCollisionHullVertexLimit("physxConvexHullCollision:hullVertexLimit", TfToken::Immortal),
    physxConvexHullCollisionMinThickness("physxConvexHullCollision:minThickness", TfToken::Immortal),
    physxCookedData("physxCookedData", TfToken::Immortal),
    physxCookedData_MultipleApplyTemplate_Buffer("physxCookedData:__INSTANCE_NAME__:buffer", TfToken::Immortal),
    physxDeformableBodyMaterialDampingScale("physxDeformableBodyMaterial:dampingScale", TfToken::Immortal),
    physxDeformableBodyMaterialDensity("physxDeformableBodyMaterial:density", TfToken::Immortal),
    physxDeformableBodyMaterialDynamicFriction("physxDeformableBodyMaterial:dynamicFriction", TfToken::Immortal),
    physxDeformableBodyMaterialElasticityDamping("physxDeformableBodyMaterial:elasticityDamping", TfToken::Immortal),
    physxDeformableBodyMaterialPoissonsRatio("physxDeformableBodyMaterial:poissonsRatio", TfToken::Immortal),
    physxDeformableBodyMaterialYoungsModulus("physxDeformableBodyMaterial:youngsModulus", TfToken::Immortal),
    physxDeformableCollisionIndices("physxDeformable:collisionIndices", TfToken::Immortal),
    physxDeformableCollisionPoints("physxDeformable:collisionPoints", TfToken::Immortal),
    physxDeformableCollisionRestPoints("physxDeformable:collisionRestPoints", TfToken::Immortal),
    physxDeformableDeformableEnabled("physxDeformable:deformableEnabled", TfToken::Immortal),
    physxDeformableDisableGravity("physxDeformable:disableGravity", TfToken::Immortal),
    physxDeformableEnableCCD("physxDeformable:enableCCD", TfToken::Immortal),
    physxDeformableMaxDepenetrationVelocity("physxDeformable:maxDepenetrationVelocity", TfToken::Immortal),
    physxDeformableRestPoints("physxDeformable:restPoints", TfToken::Immortal),
    physxDeformableSelfCollision("physxDeformable:selfCollision", TfToken::Immortal),
    physxDeformableSelfCollisionFilterDistance("physxDeformable:selfCollisionFilterDistance", TfToken::Immortal),
    physxDeformableSettlingThreshold("physxDeformable:settlingThreshold", TfToken::Immortal),
    physxDeformableSimulationIndices("physxDeformable:simulationIndices", TfToken::Immortal),
    physxDeformableSimulationOwner("physxDeformable:simulationOwner", TfToken::Immortal),
    physxDeformableSimulationPoints("physxDeformable:simulationPoints", TfToken::Immortal),
    physxDeformableSimulationRestPoints("physxDeformable:simulationRestPoints", TfToken::Immortal),
    physxDeformableSimulationVelocities("physxDeformable:simulationVelocities", TfToken::Immortal),
    physxDeformableSleepDamping("physxDeformable:sleepDamping", TfToken::Immortal),
    physxDeformableSleepThreshold("physxDeformable:sleepThreshold", TfToken::Immortal),
    physxDeformableSolverPositionIterationCount("physxDeformable:solverPositionIterationCount", TfToken::Immortal),
    physxDeformableSurfaceBendingStiffnessScale("physxDeformableSurface:bendingStiffnessScale", TfToken::Immortal),
    physxDeformableSurfaceCollisionIterationMultiplier("physxDeformableSurface:collisionIterationMultiplier", TfToken::Immortal),
    physxDeformableSurfaceCollisionPairUpdateFrequency("physxDeformableSurface:collisionPairUpdateFrequency", TfToken::Immortal),
    physxDeformableSurfaceFlatteningEnabled("physxDeformableSurface:flatteningEnabled", TfToken::Immortal),
    physxDeformableSurfaceMaterialDensity("physxDeformableSurfaceMaterial:density", TfToken::Immortal),
    physxDeformableSurfaceMaterialDynamicFriction("physxDeformableSurfaceMaterial:dynamicFriction", TfToken::Immortal),
    physxDeformableSurfaceMaterialPoissonsRatio("physxDeformableSurfaceMaterial:poissonsRatio", TfToken::Immortal),
    physxDeformableSurfaceMaterialThickness("physxDeformableSurfaceMaterial:thickness", TfToken::Immortal),
    physxDeformableSurfaceMaterialYoungsModulus("physxDeformableSurfaceMaterial:youngsModulus", TfToken::Immortal),
    physxDeformableSurfaceMaxVelocity("physxDeformableSurface:maxVelocity", TfToken::Immortal),
    physxDeformableVertexVelocityDamping("physxDeformable:vertexVelocityDamping", TfToken::Immortal),
    physxDiffuseParticlesAirDrag("physxDiffuseParticles:airDrag", TfToken::Immortal),
    physxDiffuseParticlesBubbleDrag("physxDiffuseParticles:bubbleDrag", TfToken::Immortal),
    physxDiffuseParticlesBuoyancy("physxDiffuseParticles:buoyancy", TfToken::Immortal),
    physxDiffuseParticlesCollisionDecay("physxDiffuseParticles:collisionDecay", TfToken::Immortal),
    physxDiffuseParticlesDiffuseParticlesEnabled("physxDiffuseParticles:diffuseParticlesEnabled", TfToken::Immortal),
    physxDiffuseParticlesDivergenceWeight("physxDiffuseParticles:divergenceWeight", TfToken::Immortal),
    physxDiffuseParticlesKineticEnergyWeight("physxDiffuseParticles:kineticEnergyWeight", TfToken::Immortal),
    physxDiffuseParticlesLifetime("physxDiffuseParticles:lifetime", TfToken::Immortal),
    physxDiffuseParticlesMaxDiffuseParticleMultiplier("physxDiffuseParticles:maxDiffuseParticleMultiplier", TfToken::Immortal),
    physxDiffuseParticlesPressureWeight("physxDiffuseParticles:pressureWeight", TfToken::Immortal),
    physxDiffuseParticlesThreshold("physxDiffuseParticles:threshold", TfToken::Immortal),
    physxDiffuseParticlesUseAccurateVelocity("physxDiffuseParticles:useAccurateVelocity", TfToken::Immortal),
    physxDroneCameraFeedForwardVelocityGain("physxDroneCamera:feedForwardVelocityGain", TfToken::Immortal),
    physxDroneCameraFollowDistance("physxDroneCamera:followDistance", TfToken::Immortal),
    physxDroneCameraFollowHeight("physxDroneCamera:followHeight", TfToken::Immortal),
    physxDroneCameraHorizontalVelocityGain("physxDroneCamera:horizontalVelocityGain", TfToken::Immortal),
    physxDroneCameraMaxDistance("physxDroneCamera:maxDistance", TfToken::Immortal),
    physxDroneCameraMaxSpeed("physxDroneCamera:maxSpeed", TfToken::Immortal),
    physxDroneCameraPositionOffset("physxDroneCamera:positionOffset", TfToken::Immortal),
    physxDroneCameraRotationFilterTimeConstant("physxDroneCamera:rotationFilterTimeConstant", TfToken::Immortal),
    physxDroneCameraVelocityFilterTimeConstant("physxDroneCamera:velocityFilterTimeConstant", TfToken::Immortal),
    physxDroneCameraVerticalVelocityGain("physxDroneCamera:verticalVelocityGain", TfToken::Immortal),
    physxFollowCameraCameraPositionTimeConstant("physxFollowCamera:cameraPositionTimeConstant", TfToken::Immortal),
    physxFollowCameraFollowMaxDistance("physxFollowCamera:followMaxDistance", TfToken::Immortal),
    physxFollowCameraFollowMaxSpeed("physxFollowCamera:followMaxSpeed", TfToken::Immortal),
    physxFollowCameraFollowMinDistance("physxFollowCamera:followMinDistance", TfToken::Immortal),
    physxFollowCameraFollowMinSpeed("physxFollowCamera:followMinSpeed", TfToken::Immortal),
    physxFollowCameraFollowTurnRateGain("physxFollowCamera:followTurnRateGain", TfToken::Immortal),
    physxFollowCameraLookAheadMaxSpeed("physxFollowCamera:lookAheadMaxSpeed", TfToken::Immortal),
    physxFollowCameraLookAheadMinDistance("physxFollowCamera:lookAheadMinDistance", TfToken::Immortal),
    physxFollowCameraLookAheadMinSpeed("physxFollowCamera:lookAheadMinSpeed", TfToken::Immortal),
    physxFollowCameraLookAheadTurnRateGain("physxFollowCamera:lookAheadTurnRateGain", TfToken::Immortal),
    physxFollowCameraLookPositionHeight("physxFollowCamera:lookPositionHeight", TfToken::Immortal),
    physxFollowCameraLookPositionTimeConstant("physxFollowCamera:lookPositionTimeConstant", TfToken::Immortal),
    physxFollowCameraPitchAngle("physxFollowCamera:pitchAngle", TfToken::Immortal),
    physxFollowCameraPitchAngleTimeConstant("physxFollowCamera:pitchAngleTimeConstant", TfToken::Immortal),
    physxFollowCameraPositionOffset("physxFollowCamera:positionOffset", TfToken::Immortal),
    physxFollowCameraSlowPitchAngleSpeed("physxFollowCamera:slowPitchAngleSpeed", TfToken::Immortal),
    physxFollowCameraSlowSpeedPitchAngleScale("physxFollowCamera:slowSpeedPitchAngleScale", TfToken::Immortal),
    physxFollowCameraVelocityNormalMinSpeed("physxFollowCamera:velocityNormalMinSpeed", TfToken::Immortal),
    physxFollowCameraYawAngle("physxFollowCamera:yawAngle", TfToken::Immortal),
    physxFollowCameraYawRateTimeConstant("physxFollowCamera:yawRateTimeConstant", TfToken::Immortal),
    physxFollowFollowCameraLookAheadMaxDistance("physxFollowFollowCamera:lookAheadMaxDistance", TfToken::Immortal),
    physxFollowLookCameraDownHillGroundAngle("physxFollowLookCamera:downHillGroundAngle", TfToken::Immortal),
    physxFollowLookCameraDownHillGroundPitch("physxFollowLookCamera:downHillGroundPitch", TfToken::Immortal),
    physxFollowLookCameraFollowReverseDistance("physxFollowLookCamera:followReverseDistance", TfToken::Immortal),
    physxFollowLookCameraFollowReverseSpeed("physxFollowLookCamera:followReverseSpeed", TfToken::Immortal),
    physxFollowLookCameraUpHillGroundAngle("physxFollowLookCamera:upHillGroundAngle", TfToken::Immortal),
    physxFollowLookCameraUpHillGroundPitch("physxFollowLookCamera:upHillGroundPitch", TfToken::Immortal),
    physxFollowLookCameraVelocityBlendTimeConstant("physxFollowLookCamera:velocityBlendTimeConstant", TfToken::Immortal),
    physxForceForce("physxForce:force", TfToken::Immortal),
    physxForceForceEnabled("physxForce:forceEnabled", TfToken::Immortal),
    physxForceMode("physxForce:mode", TfToken::Immortal),
    physxForceTorque("physxForce:torque", TfToken::Immortal),
    physxForceWorldFrameEnabled("physxForce:worldFrameEnabled", TfToken::Immortal),
    physxJointArmature("physxJoint:armature", TfToken::Immortal),
    physxJointJointFriction("physxJoint:jointFriction", TfToken::Immortal),
    physxJointMaxJointVelocity("physxJoint:maxJointVelocity", TfToken::Immortal),
    physxLimit("physxLimit", TfToken::Immortal),
    physxLimit_MultipleApplyTemplate_BounceThreshold("physxLimit:__INSTANCE_NAME__:bounceThreshold", TfToken::Immortal),
    physxLimit_MultipleApplyTemplate_Damping("physxLimit:__INSTANCE_NAME__:damping", TfToken::Immortal),
    physxLimit_MultipleApplyTemplate_Restitution("physxLimit:__INSTANCE_NAME__:restitution", TfToken::Immortal),
    physxLimit_MultipleApplyTemplate_Stiffness("physxLimit:__INSTANCE_NAME__:stiffness", TfToken::Immortal),
    physxMaterialCompliantContactAccelerationSpring("physxMaterial:compliantContactAccelerationSpring", TfToken::Immortal),
    physxMaterialCompliantContactDamping("physxMaterial:compliantContactDamping", TfToken::Immortal),
    physxMaterialCompliantContactStiffness("physxMaterial:compliantContactStiffness", TfToken::Immortal),
    physxMaterialDampingCombineMode("physxMaterial:dampingCombineMode", TfToken::Immortal),
    physxMaterialFrictionCombineMode("physxMaterial:frictionCombineMode", TfToken::Immortal),
    physxMaterialRestitutionCombineMode("physxMaterial:restitutionCombineMode", TfToken::Immortal),
    physxMimicJoint("physxMimicJoint", TfToken::Immortal),
    physxMimicJoint_MultipleApplyTemplate_Gearing("physxMimicJoint:__INSTANCE_NAME__:gearing", TfToken::Immortal),
    physxMimicJoint_MultipleApplyTemplate_Offset("physxMimicJoint:__INSTANCE_NAME__:offset", TfToken::Immortal),
    physxMimicJoint_MultipleApplyTemplate_ReferenceJoint("physxMimicJoint:__INSTANCE_NAME__:referenceJoint", TfToken::Immortal),
    physxMimicJoint_MultipleApplyTemplate_ReferenceJointAxis("physxMimicJoint:__INSTANCE_NAME__:referenceJointAxis", TfToken::Immortal),
    physxParticleAnisotropyMax("physxParticleAnisotropy:max", TfToken::Immortal),
    physxParticleAnisotropyMin("physxParticleAnisotropy:min", TfToken::Immortal),
    physxParticleAnisotropyParticleAnisotropyEnabled("physxParticleAnisotropy:particleAnisotropyEnabled", TfToken::Immortal),
    physxParticleAnisotropyScale("physxParticleAnisotropy:scale", TfToken::Immortal),
    physxParticleFluid("physxParticle:fluid", TfToken::Immortal),
    physxParticleIsosurfaceGridFilteringPasses("physxParticleIsosurface:gridFilteringPasses", TfToken::Immortal),
    physxParticleIsosurfaceGridSmoothingRadius("physxParticleIsosurface:gridSmoothingRadius", TfToken::Immortal),
    physxParticleIsosurfaceGridSpacing("physxParticleIsosurface:gridSpacing", TfToken::Immortal),
    physxParticleIsosurfaceIsosurfaceEnabled("physxParticleIsosurface:isosurfaceEnabled", TfToken::Immortal),
    physxParticleIsosurfaceMaxSubgrids("physxParticleIsosurface:maxSubgrids", TfToken::Immortal),
    physxParticleIsosurfaceMaxTriangles("physxParticleIsosurface:maxTriangles", TfToken::Immortal),
    physxParticleIsosurfaceMaxVertices("physxParticleIsosurface:maxVertices", TfToken::Immortal),
    physxParticleIsosurfaceNumMeshNormalSmoothingPasses("physxParticleIsosurface:numMeshNormalSmoothingPasses", TfToken::Immortal),
    physxParticleIsosurfaceNumMeshSmoothingPasses("physxParticleIsosurface:numMeshSmoothingPasses", TfToken::Immortal),
    physxParticleIsosurfaceSurfaceDistance("physxParticleIsosurface:surfaceDistance", TfToken::Immortal),
    physxParticleParticleEnabled("physxParticle:particleEnabled", TfToken::Immortal),
    physxParticleParticleGroup("physxParticle:particleGroup", TfToken::Immortal),
    physxParticleParticleSystem("physxParticle:particleSystem", TfToken::Immortal),
    physxParticlePressure("physxParticle:pressure", TfToken::Immortal),
    physxParticleRestPoints("physxParticle:restPoints", TfToken::Immortal),
    physxParticleSamplingMaxSamples("physxParticleSampling:maxSamples", TfToken::Immortal),
    physxParticleSamplingParticles("physxParticleSampling:particles", TfToken::Immortal),
    physxParticleSamplingSamplingDistance("physxParticleSampling:samplingDistance", TfToken::Immortal),
    physxParticleSamplingVolume("physxParticleSampling:volume", TfToken::Immortal),
    physxParticleSelfCollision("physxParticle:selfCollision", TfToken::Immortal),
    physxParticleSelfCollisionFilter("physxParticle:selfCollisionFilter", TfToken::Immortal),
    physxParticleSimulationPoints("physxParticle:simulationPoints", TfToken::Immortal),
    physxParticleSmoothingParticleSmoothingEnabled("physxParticleSmoothing:particleSmoothingEnabled", TfToken::Immortal),
    physxParticleSmoothingStrength("physxParticleSmoothing:strength", TfToken::Immortal),
    physxParticleSpringDampings("physxParticle:springDampings", TfToken::Immortal),
    physxParticleSpringIndices("physxParticle:springIndices", TfToken::Immortal),
    physxParticleSpringRestLengths("physxParticle:springRestLengths", TfToken::Immortal),
    physxParticleSpringStiffnesses("physxParticle:springStiffnesses", TfToken::Immortal),
    physxPBDMaterialAdhesion("physxPBDMaterial:adhesion", TfToken::Immortal),
    physxPBDMaterialAdhesionOffsetScale("physxPBDMaterial:adhesionOffsetScale", TfToken::Immortal),
    physxPBDMaterialCflCoefficient("physxPBDMaterial:cflCoefficient", TfToken::Immortal),
    physxPBDMaterialCohesion("physxPBDMaterial:cohesion", TfToken::Immortal),
    physxPBDMaterialDamping("physxPBDMaterial:damping", TfToken::Immortal),
    physxPBDMaterialDensity("physxPBDMaterial:density", TfToken::Immortal),
    physxPBDMaterialDrag("physxPBDMaterial:drag", TfToken::Immortal),
    physxPBDMaterialFriction("physxPBDMaterial:friction", TfToken::Immortal),
    physxPBDMaterialGravityScale("physxPBDMaterial:gravityScale", TfToken::Immortal),
    physxPBDMaterialLift("physxPBDMaterial:lift", TfToken::Immortal),
    physxPBDMaterialParticleAdhesionScale("physxPBDMaterial:particleAdhesionScale", TfToken::Immortal),
    physxPBDMaterialParticleFrictionScale("physxPBDMaterial:particleFrictionScale", TfToken::Immortal),
    physxPBDMaterialSurfaceTension("physxPBDMaterial:surfaceTension", TfToken::Immortal),
    physxPBDMaterialViscosity("physxPBDMaterial:viscosity", TfToken::Immortal),
    physxPBDMaterialVorticityConfinement("physxPBDMaterial:vorticityConfinement", TfToken::Immortal),
    physxPhysicsDistanceJointSpringDamping("physxPhysicsDistanceJoint:springDamping", TfToken::Immortal),
    physxPhysicsDistanceJointSpringEnabled("physxPhysicsDistanceJoint:springEnabled", TfToken::Immortal),
    physxPhysicsDistanceJointSpringStiffness("physxPhysicsDistanceJoint:springStiffness", TfToken::Immortal),
    physxResidualReportingMaxResidualPositionIteration("physxResidualReporting:maxResidualPositionIteration", TfToken::Immortal),
    physxResidualReportingMaxResidualVelocityIteration("physxResidualReporting:maxResidualVelocityIteration", TfToken::Immortal),
    physxResidualReportingRmsResidualPositionIteration("physxResidualReporting:rmsResidualPositionIteration", TfToken::Immortal),
    physxResidualReportingRmsResidualVelocityIteration("physxResidualReporting:rmsResidualVelocityIteration", TfToken::Immortal),
    physxRigidBodyAngularDamping("physxRigidBody:angularDamping", TfToken::Immortal),
    physxRigidBodyCfmScale("physxRigidBody:cfmScale", TfToken::Immortal),
    physxRigidBodyContactSlopCoefficient("physxRigidBody:contactSlopCoefficient", TfToken::Immortal),
    physxRigidBodyDisableGravity("physxRigidBody:disableGravity", TfToken::Immortal),
    physxRigidBodyEnableCCD("physxRigidBody:enableCCD", TfToken::Immortal),
    physxRigidBodyEnableGyroscopicForces("physxRigidBody:enableGyroscopicForces", TfToken::Immortal),
    physxRigidBodyEnableSpeculativeCCD("physxRigidBody:enableSpeculativeCCD", TfToken::Immortal),
    physxRigidBodyLinearDamping("physxRigidBody:linearDamping", TfToken::Immortal),
    physxRigidBodyLockedPosAxis("physxRigidBody:lockedPosAxis", TfToken::Immortal),
    physxRigidBodyLockedRotAxis("physxRigidBody:lockedRotAxis", TfToken::Immortal),
    physxRigidBodyMaxAngularVelocity("physxRigidBody:maxAngularVelocity", TfToken::Immortal),
    physxRigidBodyMaxContactImpulse("physxRigidBody:maxContactImpulse", TfToken::Immortal),
    physxRigidBodyMaxDepenetrationVelocity("physxRigidBody:maxDepenetrationVelocity", TfToken::Immortal),
    physxRigidBodyMaxLinearVelocity("physxRigidBody:maxLinearVelocity", TfToken::Immortal),
    physxRigidBodyRetainAccelerations("physxRigidBody:retainAccelerations", TfToken::Immortal),
    physxRigidBodySleepThreshold("physxRigidBody:sleepThreshold", TfToken::Immortal),
    physxRigidBodySolveContact("physxRigidBody:solveContact", TfToken::Immortal),
    physxRigidBodySolverPositionIterationCount("physxRigidBody:solverPositionIterationCount", TfToken::Immortal),
    physxRigidBodySolverVelocityIterationCount("physxRigidBody:solverVelocityIterationCount", TfToken::Immortal),
    physxRigidBodyStabilizationThreshold("physxRigidBody:stabilizationThreshold", TfToken::Immortal),
    physxSceneBounceThreshold("physxScene:bounceThreshold", TfToken::Immortal),
    physxSceneBroadphaseType("physxScene:broadphaseType", TfToken::Immortal),
    physxSceneCollisionSystem("physxScene:collisionSystem", TfToken::Immortal),
    physxSceneEnableCCD("physxScene:enableCCD", TfToken::Immortal),
    physxSceneEnableEnhancedDeterminism("physxScene:enableEnhancedDeterminism", TfToken::Immortal),
    physxSceneEnableExternalForcesEveryIteration("physxScene:enableExternalForcesEveryIteration", TfToken::Immortal),
    physxSceneEnableGPUDynamics("physxScene:enableGPUDynamics", TfToken::Immortal),
    physxSceneEnableResidualReporting("physxScene:enableResidualReporting", TfToken::Immortal),
    physxSceneEnableSceneQuerySupport("physxScene:enableSceneQuerySupport", TfToken::Immortal),
    physxSceneEnableStabilization("physxScene:enableStabilization", TfToken::Immortal),
    physxSceneFrictionCorrelationDistance("physxScene:frictionCorrelationDistance", TfToken::Immortal),
    physxSceneFrictionOffsetThreshold("physxScene:frictionOffsetThreshold", TfToken::Immortal),
    physxSceneFrictionType("physxScene:frictionType", TfToken::Immortal),
    physxSceneGpuCollisionStackSize("physxScene:gpuCollisionStackSize", TfToken::Immortal),
    physxSceneGpuFoundLostAggregatePairsCapacity("physxScene:gpuFoundLostAggregatePairsCapacity", TfToken::Immortal),
    physxSceneGpuFoundLostPairsCapacity("physxScene:gpuFoundLostPairsCapacity", TfToken::Immortal),
    physxSceneGpuHeapCapacity("physxScene:gpuHeapCapacity", TfToken::Immortal),
    physxSceneGpuMaxDeformableSurfaceContacts("physxScene:gpuMaxDeformableSurfaceContacts", TfToken::Immortal),
    physxSceneGpuMaxNumPartitions("physxScene:gpuMaxNumPartitions", TfToken::Immortal),
    physxSceneGpuMaxParticleContacts("physxScene:gpuMaxParticleContacts", TfToken::Immortal),
    physxSceneGpuMaxRigidContactCount("physxScene:gpuMaxRigidContactCount", TfToken::Immortal),
    physxSceneGpuMaxRigidPatchCount("physxScene:gpuMaxRigidPatchCount", TfToken::Immortal),
    physxSceneGpuMaxSoftBodyContacts("physxScene:gpuMaxSoftBodyContacts", TfToken::Immortal),
    physxSceneGpuTempBufferCapacity("physxScene:gpuTempBufferCapacity", TfToken::Immortal),
    physxSceneGpuTotalAggregatePairsCapacity("physxScene:gpuTotalAggregatePairsCapacity", TfToken::Immortal),
    physxSceneInvertCollisionGroupFilter("physxScene:invertCollisionGroupFilter", TfToken::Immortal),
    physxSceneMaxBiasCoefficient("physxScene:maxBiasCoefficient", TfToken::Immortal),
    physxSceneMaxPositionIterationCount("physxScene:maxPositionIterationCount", TfToken::Immortal),
    physxSceneMaxVelocityIterationCount("physxScene:maxVelocityIterationCount", TfToken::Immortal),
    physxSceneMinPositionIterationCount("physxScene:minPositionIterationCount", TfToken::Immortal),
    physxSceneMinVelocityIterationCount("physxScene:minVelocityIterationCount", TfToken::Immortal),
    physxSceneQuasistaticEnableQuasistatic("physxSceneQuasistatic:enableQuasistatic", TfToken::Immortal),
    physxSceneReportKinematicKinematicPairs("physxScene:reportKinematicKinematicPairs", TfToken::Immortal),
    physxSceneReportKinematicStaticPairs("physxScene:reportKinematicStaticPairs", TfToken::Immortal),
    physxSceneSolverType("physxScene:solverType", TfToken::Immortal),
    physxSceneTimeStepsPerSecond("physxScene:timeStepsPerSecond", TfToken::Immortal),
    physxSceneUpdateType("physxScene:updateType", TfToken::Immortal),
    physxSDFMeshCollisionSdfBitsPerSubgridPixel("physxSDFMeshCollision:sdfBitsPerSubgridPixel", TfToken::Immortal),
    physxSDFMeshCollisionSdfEnableRemeshing("physxSDFMeshCollision:sdfEnableRemeshing", TfToken::Immortal),
    physxSDFMeshCollisionSdfMargin("physxSDFMeshCollision:sdfMargin", TfToken::Immortal),
    physxSDFMeshCollisionSdfNarrowBandThickness("physxSDFMeshCollision:sdfNarrowBandThickness", TfToken::Immortal),
    physxSDFMeshCollisionSdfResolution("physxSDFMeshCollision:sdfResolution", TfToken::Immortal),
    physxSDFMeshCollisionSdfSubgridResolution("physxSDFMeshCollision:sdfSubgridResolution", TfToken::Immortal),
    physxSDFMeshCollisionSdfTriangleCountReductionFactor("physxSDFMeshCollision:sdfTriangleCountReductionFactor", TfToken::Immortal),
    physxSphereFillCollisionFillMode("physxSphereFillCollision:fillMode", TfToken::Immortal),
    physxSphereFillCollisionMaxSpheres("physxSphereFillCollision:maxSpheres", TfToken::Immortal),
    physxSphereFillCollisionSeedCount("physxSphereFillCollision:seedCount", TfToken::Immortal),
    physxSphereFillCollisionVoxelResolution("physxSphereFillCollision:voxelResolution", TfToken::Immortal),
    physxSurfaceVelocitySurfaceAngularVelocity("physxSurfaceVelocity:surfaceAngularVelocity", TfToken::Immortal),
    physxSurfaceVelocitySurfaceVelocity("physxSurfaceVelocity:surfaceVelocity", TfToken::Immortal),
    physxSurfaceVelocitySurfaceVelocityEnabled("physxSurfaceVelocity:surfaceVelocityEnabled", TfToken::Immortal),
    physxSurfaceVelocitySurfaceVelocityLocalSpace("physxSurfaceVelocity:surfaceVelocityLocalSpace", TfToken::Immortal),
    physxTendon("physxTendon", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_Damping("physxTendon:__INSTANCE_NAME__:damping", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_ForceCoefficient("physxTendon:__INSTANCE_NAME__:forceCoefficient", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_Gearing("physxTendon:__INSTANCE_NAME__:gearing", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_JointAxis("physxTendon:__INSTANCE_NAME__:jointAxis", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_LimitStiffness("physxTendon:__INSTANCE_NAME__:limitStiffness", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_LocalPos("physxTendon:__INSTANCE_NAME__:localPos", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_LowerLimit("physxTendon:__INSTANCE_NAME__:lowerLimit", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_Offset("physxTendon:__INSTANCE_NAME__:offset", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_ParentAttachment("physxTendon:__INSTANCE_NAME__:parentAttachment", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_ParentLink("physxTendon:__INSTANCE_NAME__:parentLink", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_RestLength("physxTendon:__INSTANCE_NAME__:restLength", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_Stiffness("physxTendon:__INSTANCE_NAME__:stiffness", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_TendonEnabled("physxTendon:__INSTANCE_NAME__:tendonEnabled", TfToken::Immortal),
    physxTendon_MultipleApplyTemplate_UpperLimit("physxTendon:__INSTANCE_NAME__:upperLimit", TfToken::Immortal),
    physxTriangleMeshCollisionWeldTolerance("physxTriangleMeshCollision:weldTolerance", TfToken::Immortal),
    physxTriangleMeshSimplificationCollisionMetric("physxTriangleMeshSimplificationCollision:metric", TfToken::Immortal),
    physxTriangleMeshSimplificationCollisionWeldTolerance("physxTriangleMeshSimplificationCollision:weldTolerance", TfToken::Immortal),
    physxTriggerEnterScriptType("physxTrigger:enterScriptType", TfToken::Immortal),
    physxTriggerLeaveScriptType("physxTrigger:leaveScriptType", TfToken::Immortal),
    physxTriggerOnEnterScript("physxTrigger:onEnterScript", TfToken::Immortal),
    physxTriggerOnLeaveScript("physxTrigger:onLeaveScript", TfToken::Immortal),
    physxTriggerTriggeredCollisions("physxTrigger:triggeredCollisions", TfToken::Immortal),
    physxVehicleAckermannSteeringMaxSteerAngle("physxVehicleAckermannSteering:maxSteerAngle", TfToken::Immortal),
    physxVehicleAckermannSteeringStrength("physxVehicleAckermannSteering:strength", TfToken::Immortal),
    physxVehicleAckermannSteeringTrackWidth("physxVehicleAckermannSteering:trackWidth", TfToken::Immortal),
    physxVehicleAckermannSteeringWheel0("physxVehicleAckermannSteering:wheel0", TfToken::Immortal),
    physxVehicleAckermannSteeringWheel1("physxVehicleAckermannSteering:wheel1", TfToken::Immortal),
    physxVehicleAckermannSteeringWheelBase("physxVehicleAckermannSteering:wheelBase", TfToken::Immortal),
    physxVehicleAutoGearBoxDownRatios("physxVehicleAutoGearBox:downRatios", TfToken::Immortal),
    physxVehicleAutoGearBoxLatency("physxVehicleAutoGearBox:latency", TfToken::Immortal),
    physxVehicleAutoGearBoxUpRatios("physxVehicleAutoGearBox:upRatios", TfToken::Immortal),
    physxVehicleBrakes("physxVehicleBrakes", TfToken::Immortal),
    physxVehicleBrakes_MultipleApplyTemplate_MaxBrakeTorque("physxVehicleBrakes:__INSTANCE_NAME__:maxBrakeTorque", TfToken::Immortal),
    physxVehicleBrakes_MultipleApplyTemplate_TorqueMultipliers("physxVehicleBrakes:__INSTANCE_NAME__:torqueMultipliers", TfToken::Immortal),
    physxVehicleBrakes_MultipleApplyTemplate_Wheels("physxVehicleBrakes:__INSTANCE_NAME__:wheels", TfToken::Immortal),
    physxVehicleClutchStrength("physxVehicleClutch:strength", TfToken::Immortal),
    physxVehicleContextForwardAxis("physxVehicleContext:forwardAxis", TfToken::Immortal),
    physxVehicleContextLongitudinalAxis("physxVehicleContext:longitudinalAxis", TfToken::Immortal),
    physxVehicleContextUpAxis("physxVehicleContext:upAxis", TfToken::Immortal),
    physxVehicleContextUpdateMode("physxVehicleContext:updateMode", TfToken::Immortal),
    physxVehicleContextVerticalAxis("physxVehicleContext:verticalAxis", TfToken::Immortal),
    physxVehicleControllerAccelerator("physxVehicleController:accelerator", TfToken::Immortal),
    physxVehicleControllerBrake("physxVehicleController:brake", TfToken::Immortal),
    physxVehicleControllerBrake0("physxVehicleController:brake0", TfToken::Immortal),
    physxVehicleControllerBrake1("physxVehicleController:brake1", TfToken::Immortal),
    physxVehicleControllerHandbrake("physxVehicleController:handbrake", TfToken::Immortal),
    physxVehicleControllerSteer("physxVehicleController:steer", TfToken::Immortal),
    physxVehicleControllerSteerLeft("physxVehicleController:steerLeft", TfToken::Immortal),
    physxVehicleControllerSteerRight("physxVehicleController:steerRight", TfToken::Immortal),
    physxVehicleControllerTargetGear("physxVehicleController:targetGear", TfToken::Immortal),
    physxVehicleDrive("physxVehicle:drive", TfToken::Immortal),
    physxVehicleDriveBasicPeakTorque("physxVehicleDriveBasic:peakTorque", TfToken::Immortal),
    physxVehicleDriveStandardAutoGearBox("physxVehicleDriveStandard:autoGearBox", TfToken::Immortal),
    physxVehicleDriveStandardClutch("physxVehicleDriveStandard:clutch", TfToken::Immortal),
    physxVehicleDriveStandardEngine("physxVehicleDriveStandard:engine", TfToken::Immortal),
    physxVehicleDriveStandardGears("physxVehicleDriveStandard:gears", TfToken::Immortal),
    physxVehicleEngineDampingRateFullThrottle("physxVehicleEngine:dampingRateFullThrottle", TfToken::Immortal),
    physxVehicleEngineDampingRateZeroThrottleClutchDisengaged("physxVehicleEngine:dampingRateZeroThrottleClutchDisengaged", TfToken::Immortal),
    physxVehicleEngineDampingRateZeroThrottleClutchEngaged("physxVehicleEngine:dampingRateZeroThrottleClutchEngaged", TfToken::Immortal),
    physxVehicleEngineIdleRotationSpeed("physxVehicleEngine:idleRotationSpeed", TfToken::Immortal),
    physxVehicleEngineMaxRotationSpeed("physxVehicleEngine:maxRotationSpeed", TfToken::Immortal),
    physxVehicleEngineMoi("physxVehicleEngine:moi", TfToken::Immortal),
    physxVehicleEnginePeakTorque("physxVehicleEngine:peakTorque", TfToken::Immortal),
    physxVehicleEngineTorqueCurve("physxVehicleEngine:torqueCurve", TfToken::Immortal),
    physxVehicleGearsRatios("physxVehicleGears:ratios", TfToken::Immortal),
    physxVehicleGearsRatioScale("physxVehicleGears:ratioScale", TfToken::Immortal),
    physxVehicleGearsSwitchTime("physxVehicleGears:switchTime", TfToken::Immortal),
    physxVehicleHighForwardSpeedSubStepCount("physxVehicle:highForwardSpeedSubStepCount", TfToken::Immortal),
    physxVehicleLateralStickyTireDamping("physxVehicle:lateralStickyTireDamping", TfToken::Immortal),
    physxVehicleLateralStickyTireThresholdSpeed("physxVehicle:lateralStickyTireThresholdSpeed", TfToken::Immortal),
    physxVehicleLateralStickyTireThresholdTime("physxVehicle:lateralStickyTireThresholdTime", TfToken::Immortal),
    physxVehicleLimitSuspensionExpansionVelocity("physxVehicle:limitSuspensionExpansionVelocity", TfToken::Immortal),
    physxVehicleLongitudinalStickyTireDamping("physxVehicle:longitudinalStickyTireDamping", TfToken::Immortal),
    physxVehicleLongitudinalStickyTireThresholdSpeed("physxVehicle:longitudinalStickyTireThresholdSpeed", TfToken::Immortal),
    physxVehicleLongitudinalStickyTireThresholdTime("physxVehicle:longitudinalStickyTireThresholdTime", TfToken::Immortal),
    physxVehicleLowForwardSpeedSubStepCount("physxVehicle:lowForwardSpeedSubStepCount", TfToken::Immortal),
    physxVehicleMinActiveLongitudinalSlipDenominator("physxVehicle:minActiveLongitudinalSlipDenominator", TfToken::Immortal),
    physxVehicleMinLateralSlipDenominator("physxVehicle:minLateralSlipDenominator", TfToken::Immortal),
    physxVehicleMinLongitudinalSlipDenominator("physxVehicle:minLongitudinalSlipDenominator", TfToken::Immortal),
    physxVehicleMinPassiveLongitudinalSlipDenominator("physxVehicle:minPassiveLongitudinalSlipDenominator", TfToken::Immortal),
    physxVehicleMultiWheelDifferentialAverageWheelSpeedRatios("physxVehicleMultiWheelDifferential:averageWheelSpeedRatios", TfToken::Immortal),
    physxVehicleMultiWheelDifferentialTorqueRatios("physxVehicleMultiWheelDifferential:torqueRatios", TfToken::Immortal),
    physxVehicleMultiWheelDifferentialWheels("physxVehicleMultiWheelDifferential:wheels", TfToken::Immortal),
    physxVehicleNCR("physxVehicleNCR", TfToken::Immortal),
    physxVehicleNCR_MultipleApplyTemplate_CommandValues("physxVehicleNCR:__INSTANCE_NAME__:commandValues", TfToken::Immortal),
    physxVehicleNCR_MultipleApplyTemplate_SpeedResponses("physxVehicleNCR:__INSTANCE_NAME__:speedResponses", TfToken::Immortal),
    physxVehicleNCR_MultipleApplyTemplate_SpeedResponsesPerCommandValue("physxVehicleNCR:__INSTANCE_NAME__:speedResponsesPerCommandValue", TfToken::Immortal),
    physxVehicleSteeringAngleMultipliers("physxVehicleSteering:angleMultipliers", TfToken::Immortal),
    physxVehicleSteeringMaxSteerAngle("physxVehicleSteering:maxSteerAngle", TfToken::Immortal),
    physxVehicleSteeringWheels("physxVehicleSteering:wheels", TfToken::Immortal),
    physxVehicleSubStepThresholdLongitudinalSpeed("physxVehicle:subStepThresholdLongitudinalSpeed", TfToken::Immortal),
    physxVehicleSuspensionCamberAtMaxCompression("physxVehicleSuspension:camberAtMaxCompression", TfToken::Immortal),
    physxVehicleSuspensionCamberAtMaxDroop("physxVehicleSuspension:camberAtMaxDroop", TfToken::Immortal),
    physxVehicleSuspensionCamberAtRest("physxVehicleSuspension:camberAtRest", TfToken::Immortal),
    physxVehicleSuspensionComplianceSuspensionForceAppPoint("physxVehicleSuspensionCompliance:suspensionForceAppPoint", TfToken::Immortal),
    physxVehicleSuspensionComplianceTireForceAppPoint("physxVehicleSuspensionCompliance:tireForceAppPoint", TfToken::Immortal),
    physxVehicleSuspensionComplianceWheelCamberAngle("physxVehicleSuspensionCompliance:wheelCamberAngle", TfToken::Immortal),
    physxVehicleSuspensionComplianceWheelToeAngle("physxVehicleSuspensionCompliance:wheelToeAngle", TfToken::Immortal),
    physxVehicleSuspensionLineQueryType("physxVehicle:suspensionLineQueryType", TfToken::Immortal),
    physxVehicleSuspensionMaxCompression("physxVehicleSuspension:maxCompression", TfToken::Immortal),
    physxVehicleSuspensionMaxDroop("physxVehicleSuspension:maxDroop", TfToken::Immortal),
    physxVehicleSuspensionSpringDamperRate("physxVehicleSuspension:springDamperRate", TfToken::Immortal),
    physxVehicleSuspensionSpringStrength("physxVehicleSuspension:springStrength", TfToken::Immortal),
    physxVehicleSuspensionSprungMass("physxVehicleSuspension:sprungMass", TfToken::Immortal),
    physxVehicleSuspensionTravelDistance("physxVehicleSuspension:travelDistance", TfToken::Immortal),
    physxVehicleTankControllerThrust0("physxVehicleTankController:thrust0", TfToken::Immortal),
    physxVehicleTankControllerThrust1("physxVehicleTankController:thrust1", TfToken::Immortal),
    physxVehicleTankDifferentialNumberOfWheelsPerTrack("physxVehicleTankDifferential:numberOfWheelsPerTrack", TfToken::Immortal),
    physxVehicleTankDifferentialThrustIndexPerTrack("physxVehicleTankDifferential:thrustIndexPerTrack", TfToken::Immortal),
    physxVehicleTankDifferentialTrackToWheelIndices("physxVehicleTankDifferential:trackToWheelIndices", TfToken::Immortal),
    physxVehicleTankDifferentialWheelIndicesInTrackOrder("physxVehicleTankDifferential:wheelIndicesInTrackOrder", TfToken::Immortal),
    physxVehicleTireCamberStiffness("physxVehicleTire:camberStiffness", TfToken::Immortal),
    physxVehicleTireCamberStiffnessPerUnitGravity("physxVehicleTire:camberStiffnessPerUnitGravity", TfToken::Immortal),
    physxVehicleTireFrictionTable("physxVehicleTire:frictionTable", TfToken::Immortal),
    physxVehicleTireFrictionVsSlipGraph("physxVehicleTire:frictionVsSlipGraph", TfToken::Immortal),
    physxVehicleTireLateralStiffnessGraph("physxVehicleTire:lateralStiffnessGraph", TfToken::Immortal),
    physxVehicleTireLatStiffX("physxVehicleTire:latStiffX", TfToken::Immortal),
    physxVehicleTireLatStiffY("physxVehicleTire:latStiffY", TfToken::Immortal),
    physxVehicleTireLongitudinalStiffness("physxVehicleTire:longitudinalStiffness", TfToken::Immortal),
    physxVehicleTireLongitudinalStiffnessPerUnitGravity("physxVehicleTire:longitudinalStiffnessPerUnitGravity", TfToken::Immortal),
    physxVehicleTireRestLoad("physxVehicleTire:restLoad", TfToken::Immortal),
    physxVehicleVehicleEnabled("physxVehicle:vehicleEnabled", TfToken::Immortal),
    physxVehicleWheelAttachmentCollisionGroup("physxVehicleWheelAttachment:collisionGroup", TfToken::Immortal),
    physxVehicleWheelAttachmentDriven("physxVehicleWheelAttachment:driven", TfToken::Immortal),
    physxVehicleWheelAttachmentIndex("physxVehicleWheelAttachment:index", TfToken::Immortal),
    physxVehicleWheelAttachmentSuspension("physxVehicleWheelAttachment:suspension", TfToken::Immortal),
    physxVehicleWheelAttachmentSuspensionForceAppPointOffset("physxVehicleWheelAttachment:suspensionForceAppPointOffset", TfToken::Immortal),
    physxVehicleWheelAttachmentSuspensionFrameOrientation("physxVehicleWheelAttachment:suspensionFrameOrientation", TfToken::Immortal),
    physxVehicleWheelAttachmentSuspensionFramePosition("physxVehicleWheelAttachment:suspensionFramePosition", TfToken::Immortal),
    physxVehicleWheelAttachmentSuspensionTravelDirection("physxVehicleWheelAttachment:suspensionTravelDirection", TfToken::Immortal),
    physxVehicleWheelAttachmentTire("physxVehicleWheelAttachment:tire", TfToken::Immortal),
    physxVehicleWheelAttachmentTireForceAppPointOffset("physxVehicleWheelAttachment:tireForceAppPointOffset", TfToken::Immortal),
    physxVehicleWheelAttachmentWheel("physxVehicleWheelAttachment:wheel", TfToken::Immortal),
    physxVehicleWheelAttachmentWheelCenterOfMassOffset("physxVehicleWheelAttachment:wheelCenterOfMassOffset", TfToken::Immortal),
    physxVehicleWheelAttachmentWheelFrameOrientation("physxVehicleWheelAttachment:wheelFrameOrientation", TfToken::Immortal),
    physxVehicleWheelAttachmentWheelFramePosition("physxVehicleWheelAttachment:wheelFramePosition", TfToken::Immortal),
    physxVehicleWheelControllerBrakeTorque("physxVehicleWheelController:brakeTorque", TfToken::Immortal),
    physxVehicleWheelControllerDriveTorque("physxVehicleWheelController:driveTorque", TfToken::Immortal),
    physxVehicleWheelControllerSteerAngle("physxVehicleWheelController:steerAngle", TfToken::Immortal),
    physxVehicleWheelDampingRate("physxVehicleWheel:dampingRate", TfToken::Immortal),
    physxVehicleWheelMass("physxVehicleWheel:mass", TfToken::Immortal),
    physxVehicleWheelMaxBrakeTorque("physxVehicleWheel:maxBrakeTorque", TfToken::Immortal),
    physxVehicleWheelMaxHandBrakeTorque("physxVehicleWheel:maxHandBrakeTorque", TfToken::Immortal),
    physxVehicleWheelMaxSteerAngle("physxVehicleWheel:maxSteerAngle", TfToken::Immortal),
    physxVehicleWheelMoi("physxVehicleWheel:moi", TfToken::Immortal),
    physxVehicleWheelRadius("physxVehicleWheel:radius", TfToken::Immortal),
    physxVehicleWheelToeAngle("physxVehicleWheel:toeAngle", TfToken::Immortal),
    physxVehicleWheelWidth("physxVehicleWheel:width", TfToken::Immortal),
    points0("points0", TfToken::Immortal),
    points1("points1", TfToken::Immortal),
    posX("posX", TfToken::Immortal),
    posY("posY", TfToken::Immortal),
    posZ("posZ", TfToken::Immortal),
    preventClimbing("preventClimbing", TfToken::Immortal),
    preventClimbingForceSliding("preventClimbingForceSliding", TfToken::Immortal),
    quasistaticactors("quasistaticactors", TfToken::Immortal),
    raycast("raycast", TfToken::Immortal),
    referenceFrameIsCenterOfMass("physxVehicle:referenceFrameIsCenterOfMass", TfToken::Immortal),
    restOffset("restOffset", TfToken::Immortal),
    rotX("rotX", TfToken::Immortal),
    rotY("rotY", TfToken::Immortal),
    rotZ("rotZ", TfToken::Immortal),
    SAP("SAP", TfToken::Immortal),
    SAT("SAT", TfToken::Immortal),
    scriptFile("scriptFile", TfToken::Immortal),
    sdf("sdf", TfToken::Immortal),
    simulationOwner("simulationOwner", TfToken::Immortal),
    solidRestOffset("solidRestOffset", TfToken::Immortal),
    solverPositionIterationCount("solverPositionIterationCount", TfToken::Immortal),
    sphereFill("sphereFill", TfToken::Immortal),
    state("state", TfToken::Immortal),
    state_MultipleApplyTemplate_PhysicsPosition("state:__INSTANCE_NAME__:physics:position", TfToken::Immortal),
    state_MultipleApplyTemplate_PhysicsVelocity("state:__INSTANCE_NAME__:physics:velocity", TfToken::Immortal),
    steer("steer", TfToken::Immortal),
    surface("surface", TfToken::Immortal),
    sweep("sweep", TfToken::Immortal),
    Synchronous("Synchronous", TfToken::Immortal),
    TGS("TGS", TfToken::Immortal),
    transX("transX", TfToken::Immortal),
    transY("transY", TfToken::Immortal),
    transZ("transZ", TfToken::Immortal),
    triangleMesh("triangleMesh", TfToken::Immortal),
    undefined("undefined", TfToken::Immortal),
    velocityChange("velocityChange", TfToken::Immortal),
    Vertices("Vertices", TfToken::Immortal),
    wind("wind", TfToken::Immortal),
    X("X", TfToken::Immortal),
    Y("Y", TfToken::Immortal),
    Z("Z", TfToken::Immortal),
    PhysicsJointStateAPI("PhysicsJointStateAPI", TfToken::Immortal),
    PhysxArticulationAPI("PhysxArticulationAPI", TfToken::Immortal),
    PhysxAutoAttachmentAPI("PhysxAutoAttachmentAPI", TfToken::Immortal),
    PhysxAutoParticleClothAPI("PhysxAutoParticleClothAPI", TfToken::Immortal),
    PhysxCameraAPI("PhysxCameraAPI", TfToken::Immortal),
    PhysxCameraDroneAPI("PhysxCameraDroneAPI", TfToken::Immortal),
    PhysxCameraFollowAPI("PhysxCameraFollowAPI", TfToken::Immortal),
    PhysxCameraFollowLookAPI("PhysxCameraFollowLookAPI", TfToken::Immortal),
    PhysxCameraFollowVelocityAPI("PhysxCameraFollowVelocityAPI", TfToken::Immortal),
    PhysxCharacterControllerAPI("PhysxCharacterControllerAPI", TfToken::Immortal),
    PhysxCollisionAPI("PhysxCollisionAPI", TfToken::Immortal),
    PhysxContactReportAPI("PhysxContactReportAPI", TfToken::Immortal),
    PhysxConvexDecompositionCollisionAPI("PhysxConvexDecompositionCollisionAPI", TfToken::Immortal),
    PhysxConvexHullCollisionAPI("PhysxConvexHullCollisionAPI", TfToken::Immortal),
    PhysxCookedDataAPI("PhysxCookedDataAPI", TfToken::Immortal),
    PhysxDeformableAPI("PhysxDeformableAPI", TfToken::Immortal),
    PhysxDeformableBodyAPI("PhysxDeformableBodyAPI", TfToken::Immortal),
    PhysxDeformableBodyMaterialAPI("PhysxDeformableBodyMaterialAPI", TfToken::Immortal),
    PhysxDeformableSurfaceAPI("PhysxDeformableSurfaceAPI", TfToken::Immortal),
    PhysxDeformableSurfaceMaterialAPI("PhysxDeformableSurfaceMaterialAPI", TfToken::Immortal),
    PhysxDiffuseParticlesAPI("PhysxDiffuseParticlesAPI", TfToken::Immortal),
    PhysxForceAPI("PhysxForceAPI", TfToken::Immortal),
    PhysxJointAPI("PhysxJointAPI", TfToken::Immortal),
    PhysxLimitAPI("PhysxLimitAPI", TfToken::Immortal),
    PhysxMaterialAPI("PhysxMaterialAPI", TfToken::Immortal),
    PhysxMeshMergeCollisionAPI("PhysxMeshMergeCollisionAPI", TfToken::Immortal),
    PhysxMimicJointAPI("PhysxMimicJointAPI", TfToken::Immortal),
    PhysxParticleAnisotropyAPI("PhysxParticleAnisotropyAPI", TfToken::Immortal),
    PhysxParticleAPI("PhysxParticleAPI", TfToken::Immortal),
    PhysxParticleClothAPI("PhysxParticleClothAPI", TfToken::Immortal),
    PhysxParticleIsosurfaceAPI("PhysxParticleIsosurfaceAPI", TfToken::Immortal),
    PhysxParticleSamplingAPI("PhysxParticleSamplingAPI", TfToken::Immortal),
    PhysxParticleSetAPI("PhysxParticleSetAPI", TfToken::Immortal),
    PhysxParticleSmoothingAPI("PhysxParticleSmoothingAPI", TfToken::Immortal),
    PhysxParticleSystem("PhysxParticleSystem", TfToken::Immortal),
    PhysxPBDMaterialAPI("PhysxPBDMaterialAPI", TfToken::Immortal),
    PhysxPhysicsAttachment("PhysxPhysicsAttachment", TfToken::Immortal),
    PhysxPhysicsDistanceJointAPI("PhysxPhysicsDistanceJointAPI", TfToken::Immortal),
    PhysxPhysicsGearJoint("PhysxPhysicsGearJoint", TfToken::Immortal),
    PhysxPhysicsInstancer("PhysxPhysicsInstancer", TfToken::Immortal),
    PhysxPhysicsJointInstancer("PhysxPhysicsJointInstancer", TfToken::Immortal),
    PhysxPhysicsRackAndPinionJoint("PhysxPhysicsRackAndPinionJoint", TfToken::Immortal),
    PhysxResidualReportingAPI("PhysxResidualReportingAPI", TfToken::Immortal),
    PhysxRigidBodyAPI("PhysxRigidBodyAPI", TfToken::Immortal),
    PhysxSceneAPI("PhysxSceneAPI", TfToken::Immortal),
    PhysxSceneQuasistaticAPI("PhysxSceneQuasistaticAPI", TfToken::Immortal),
    PhysxSDFMeshCollisionAPI("PhysxSDFMeshCollisionAPI", TfToken::Immortal),
    PhysxSphereFillCollisionAPI("PhysxSphereFillCollisionAPI", TfToken::Immortal),
    PhysxSurfaceVelocityAPI("PhysxSurfaceVelocityAPI", TfToken::Immortal),
    PhysxTendonAttachmentAPI("PhysxTendonAttachmentAPI", TfToken::Immortal),
    PhysxTendonAttachmentLeafAPI("PhysxTendonAttachmentLeafAPI", TfToken::Immortal),
    PhysxTendonAttachmentRootAPI("PhysxTendonAttachmentRootAPI", TfToken::Immortal),
    PhysxTendonAxisAPI("PhysxTendonAxisAPI", TfToken::Immortal),
    PhysxTendonAxisRootAPI("PhysxTendonAxisRootAPI", TfToken::Immortal),
    PhysxTriangleMeshCollisionAPI("PhysxTriangleMeshCollisionAPI", TfToken::Immortal),
    PhysxTriangleMeshSimplificationCollisionAPI("PhysxTriangleMeshSimplificationCollisionAPI", TfToken::Immortal),
    PhysxTriggerAPI("PhysxTriggerAPI", TfToken::Immortal),
    PhysxTriggerStateAPI("PhysxTriggerStateAPI", TfToken::Immortal),
    PhysxVehicleAckermannSteeringAPI("PhysxVehicleAckermannSteeringAPI", TfToken::Immortal),
    PhysxVehicleAPI("PhysxVehicleAPI", TfToken::Immortal),
    PhysxVehicleAutoGearBoxAPI("PhysxVehicleAutoGearBoxAPI", TfToken::Immortal),
    PhysxVehicleBrakesAPI("PhysxVehicleBrakesAPI", TfToken::Immortal),
    PhysxVehicleClutchAPI("PhysxVehicleClutchAPI", TfToken::Immortal),
    PhysxVehicleContextAPI("PhysxVehicleContextAPI", TfToken::Immortal),
    PhysxVehicleControllerAPI("PhysxVehicleControllerAPI", TfToken::Immortal),
    PhysxVehicleDriveBasicAPI("PhysxVehicleDriveBasicAPI", TfToken::Immortal),
    PhysxVehicleDriveStandardAPI("PhysxVehicleDriveStandardAPI", TfToken::Immortal),
    PhysxVehicleEngineAPI("PhysxVehicleEngineAPI", TfToken::Immortal),
    PhysxVehicleGearsAPI("PhysxVehicleGearsAPI", TfToken::Immortal),
    PhysxVehicleMultiWheelDifferentialAPI("PhysxVehicleMultiWheelDifferentialAPI", TfToken::Immortal),
    PhysxVehicleNonlinearCommandResponseAPI("PhysxVehicleNonlinearCommandResponseAPI", TfToken::Immortal),
    PhysxVehicleSteeringAPI("PhysxVehicleSteeringAPI", TfToken::Immortal),
    PhysxVehicleSuspensionAPI("PhysxVehicleSuspensionAPI", TfToken::Immortal),
    PhysxVehicleSuspensionComplianceAPI("PhysxVehicleSuspensionComplianceAPI", TfToken::Immortal),
    PhysxVehicleTankControllerAPI("PhysxVehicleTankControllerAPI", TfToken::Immortal),
    PhysxVehicleTankDifferentialAPI("PhysxVehicleTankDifferentialAPI", TfToken::Immortal),
    PhysxVehicleTireAPI("PhysxVehicleTireAPI", TfToken::Immortal),
    PhysxVehicleTireFrictionTable("PhysxVehicleTireFrictionTable", TfToken::Immortal),
    PhysxVehicleWheelAPI("PhysxVehicleWheelAPI", TfToken::Immortal),
    PhysxVehicleWheelAttachmentAPI("PhysxVehicleWheelAttachmentAPI", TfToken::Immortal),
    PhysxVehicleWheelControllerAPI("PhysxVehicleWheelControllerAPI", TfToken::Immortal),
    TetrahedralMesh("TetrahedralMesh", TfToken::Immortal),
    allTokens({
        acceleration,
        actor0,
        actor1,
        alwaysUpdateEnabled,
        Asynchronous,
        attachmentEnabled,
        average,
        BitsPerPixel16,
        BitsPerPixel32,
        BitsPerPixel8,
        brakes0,
        brakes1,
        clothConstaint,
        collisionFilterIndices0,
        collisionFilterIndices1,
        collisionmeshes,
        constrained,
        contactOffset,
        convexDecomposition,
        convexHull,
        defaultFrictionValue,
        Disabled,
        drive,
        easy,
        enableCCD,
        filterType0,
        filterType1,
        flood,
        fluidRestOffset,
        force,
        frictionValues,
        Geometry,
        globalSelfCollisionEnabled,
        GPU,
        groundMaterials,
        indices,
        max,
        maxDepenetrationVelocity,
        maxNeighborhood,
        maxVelocity,
        MBP,
        min,
        multiply,
        negX,
        negY,
        negZ,
        neighborhoodScale,
        nonParticleCollisionEnabled,
        particleContactOffset,
        particleSystemEnabled,
        patch,
        PCM,
        PGS,
        physicsBody0Indices,
        physicsBody0s,
        physicsBody1Indices,
        physicsBody1s,
        physicsGearRatio,
        physicsHinge,
        physicsHinge0,
        physicsHinge1,
        physicsLocalPos0s,
        physicsLocalPos1s,
        physicsLocalRot0s,
        physicsLocalRot1s,
        physicsPrismatic,
        physicsProtoIndices,
        physicsPrototypes,
        physicsRatio,
        physxArticulationArticulationEnabled,
        physxArticulationEnabledSelfCollisions,
        physxArticulationSleepThreshold,
        physxArticulationSolverPositionIterationCount,
        physxArticulationSolverVelocityIterationCount,
        physxArticulationStabilizationThreshold,
        physxAutoAttachmentCollisionFilteringOffset,
        physxAutoAttachmentDeformableVertexOverlapOffset,
        physxAutoAttachmentEnableCollisionFiltering,
        physxAutoAttachmentEnableDeformableFilteringPairs,
        physxAutoAttachmentEnableDeformableVertexAttachments,
        physxAutoAttachmentEnableRigidSurfaceAttachments,
        physxAutoAttachmentRigidSurfaceSamplingDistance,
        physxAutoParticleClothDisableMeshWelding,
        physxAutoParticleClothSpringBendStiffness,
        physxAutoParticleClothSpringDamping,
        physxAutoParticleClothSpringShearStiffness,
        physxAutoParticleClothSpringStretchStiffness,
        physxCameraSubject,
        physxCharacterControllerClimbingMode,
        physxCharacterControllerContactOffset,
        physxCharacterControllerInvisibleWallHeight,
        physxCharacterControllerMaxJumpHeight,
        physxCharacterControllerMoveTarget,
        physxCharacterControllerNonWalkableMode,
        physxCharacterControllerScaleCoeff,
        physxCharacterControllerSimulationOwner,
        physxCharacterControllerSlopeLimit,
        physxCharacterControllerStepOffset,
        physxCharacterControllerUpAxis,
        physxCharacterControllerVolumeGrowth,
        physxCollisionContactOffset,
        physxCollisionCustomGeometry,
        physxCollisionMinTorsionalPatchRadius,
        physxCollisionRestOffset,
        physxCollisionTorsionalPatchRadius,
        physxContactReportReportPairs,
        physxContactReportThreshold,
        physxConvexDecompositionCollisionErrorPercentage,
        physxConvexDecompositionCollisionHullVertexLimit,
        physxConvexDecompositionCollisionMaxConvexHulls,
        physxConvexDecompositionCollisionMinThickness,
        physxConvexDecompositionCollisionShrinkWrap,
        physxConvexDecompositionCollisionVoxelResolution,
        physxConvexHullCollisionHullVertexLimit,
        physxConvexHullCollisionMinThickness,
        physxCookedData,
        physxCookedData_MultipleApplyTemplate_Buffer,
        physxDeformableBodyMaterialDampingScale,
        physxDeformableBodyMaterialDensity,
        physxDeformableBodyMaterialDynamicFriction,
        physxDeformableBodyMaterialElasticityDamping,
        physxDeformableBodyMaterialPoissonsRatio,
        physxDeformableBodyMaterialYoungsModulus,
        physxDeformableCollisionIndices,
        physxDeformableCollisionPoints,
        physxDeformableCollisionRestPoints,
        physxDeformableDeformableEnabled,
        physxDeformableDisableGravity,
        physxDeformableEnableCCD,
        physxDeformableMaxDepenetrationVelocity,
        physxDeformableRestPoints,
        physxDeformableSelfCollision,
        physxDeformableSelfCollisionFilterDistance,
        physxDeformableSettlingThreshold,
        physxDeformableSimulationIndices,
        physxDeformableSimulationOwner,
        physxDeformableSimulationPoints,
        physxDeformableSimulationRestPoints,
        physxDeformableSimulationVelocities,
        physxDeformableSleepDamping,
        physxDeformableSleepThreshold,
        physxDeformableSolverPositionIterationCount,
        physxDeformableSurfaceBendingStiffnessScale,
        physxDeformableSurfaceCollisionIterationMultiplier,
        physxDeformableSurfaceCollisionPairUpdateFrequency,
        physxDeformableSurfaceFlatteningEnabled,
        physxDeformableSurfaceMaterialDensity,
        physxDeformableSurfaceMaterialDynamicFriction,
        physxDeformableSurfaceMaterialPoissonsRatio,
        physxDeformableSurfaceMaterialThickness,
        physxDeformableSurfaceMaterialYoungsModulus,
        physxDeformableSurfaceMaxVelocity,
        physxDeformableVertexVelocityDamping,
        physxDiffuseParticlesAirDrag,
        physxDiffuseParticlesBubbleDrag,
        physxDiffuseParticlesBuoyancy,
        physxDiffuseParticlesCollisionDecay,
        physxDiffuseParticlesDiffuseParticlesEnabled,
        physxDiffuseParticlesDivergenceWeight,
        physxDiffuseParticlesKineticEnergyWeight,
        physxDiffuseParticlesLifetime,
        physxDiffuseParticlesMaxDiffuseParticleMultiplier,
        physxDiffuseParticlesPressureWeight,
        physxDiffuseParticlesThreshold,
        physxDiffuseParticlesUseAccurateVelocity,
        physxDroneCameraFeedForwardVelocityGain,
        physxDroneCameraFollowDistance,
        physxDroneCameraFollowHeight,
        physxDroneCameraHorizontalVelocityGain,
        physxDroneCameraMaxDistance,
        physxDroneCameraMaxSpeed,
        physxDroneCameraPositionOffset,
        physxDroneCameraRotationFilterTimeConstant,
        physxDroneCameraVelocityFilterTimeConstant,
        physxDroneCameraVerticalVelocityGain,
        physxFollowCameraCameraPositionTimeConstant,
        physxFollowCameraFollowMaxDistance,
        physxFollowCameraFollowMaxSpeed,
        physxFollowCameraFollowMinDistance,
        physxFollowCameraFollowMinSpeed,
        physxFollowCameraFollowTurnRateGain,
        physxFollowCameraLookAheadMaxSpeed,
        physxFollowCameraLookAheadMinDistance,
        physxFollowCameraLookAheadMinSpeed,
        physxFollowCameraLookAheadTurnRateGain,
        physxFollowCameraLookPositionHeight,
        physxFollowCameraLookPositionTimeConstant,
        physxFollowCameraPitchAngle,
        physxFollowCameraPitchAngleTimeConstant,
        physxFollowCameraPositionOffset,
        physxFollowCameraSlowPitchAngleSpeed,
        physxFollowCameraSlowSpeedPitchAngleScale,
        physxFollowCameraVelocityNormalMinSpeed,
        physxFollowCameraYawAngle,
        physxFollowCameraYawRateTimeConstant,
        physxFollowFollowCameraLookAheadMaxDistance,
        physxFollowLookCameraDownHillGroundAngle,
        physxFollowLookCameraDownHillGroundPitch,
        physxFollowLookCameraFollowReverseDistance,
        physxFollowLookCameraFollowReverseSpeed,
        physxFollowLookCameraUpHillGroundAngle,
        physxFollowLookCameraUpHillGroundPitch,
        physxFollowLookCameraVelocityBlendTimeConstant,
        physxForceForce,
        physxForceForceEnabled,
        physxForceMode,
        physxForceTorque,
        physxForceWorldFrameEnabled,
        physxJointArmature,
        physxJointJointFriction,
        physxJointMaxJointVelocity,
        physxLimit,
        physxLimit_MultipleApplyTemplate_BounceThreshold,
        physxLimit_MultipleApplyTemplate_Damping,
        physxLimit_MultipleApplyTemplate_Restitution,
        physxLimit_MultipleApplyTemplate_Stiffness,
        physxMaterialCompliantContactAccelerationSpring,
        physxMaterialCompliantContactDamping,
        physxMaterialCompliantContactStiffness,
        physxMaterialDampingCombineMode,
        physxMaterialFrictionCombineMode,
        physxMaterialRestitutionCombineMode,
        physxMimicJoint,
        physxMimicJoint_MultipleApplyTemplate_Gearing,
        physxMimicJoint_MultipleApplyTemplate_Offset,
        physxMimicJoint_MultipleApplyTemplate_ReferenceJoint,
        physxMimicJoint_MultipleApplyTemplate_ReferenceJointAxis,
        physxParticleAnisotropyMax,
        physxParticleAnisotropyMin,
        physxParticleAnisotropyParticleAnisotropyEnabled,
        physxParticleAnisotropyScale,
        physxParticleFluid,
        physxParticleIsosurfaceGridFilteringPasses,
        physxParticleIsosurfaceGridSmoothingRadius,
        physxParticleIsosurfaceGridSpacing,
        physxParticleIsosurfaceIsosurfaceEnabled,
        physxParticleIsosurfaceMaxSubgrids,
        physxParticleIsosurfaceMaxTriangles,
        physxParticleIsosurfaceMaxVertices,
        physxParticleIsosurfaceNumMeshNormalSmoothingPasses,
        physxParticleIsosurfaceNumMeshSmoothingPasses,
        physxParticleIsosurfaceSurfaceDistance,
        physxParticleParticleEnabled,
        physxParticleParticleGroup,
        physxParticleParticleSystem,
        physxParticlePressure,
        physxParticleRestPoints,
        physxParticleSamplingMaxSamples,
        physxParticleSamplingParticles,
        physxParticleSamplingSamplingDistance,
        physxParticleSamplingVolume,
        physxParticleSelfCollision,
        physxParticleSelfCollisionFilter,
        physxParticleSimulationPoints,
        physxParticleSmoothingParticleSmoothingEnabled,
        physxParticleSmoothingStrength,
        physxParticleSpringDampings,
        physxParticleSpringIndices,
        physxParticleSpringRestLengths,
        physxParticleSpringStiffnesses,
        physxPBDMaterialAdhesion,
        physxPBDMaterialAdhesionOffsetScale,
        physxPBDMaterialCflCoefficient,
        physxPBDMaterialCohesion,
        physxPBDMaterialDamping,
        physxPBDMaterialDensity,
        physxPBDMaterialDrag,
        physxPBDMaterialFriction,
        physxPBDMaterialGravityScale,
        physxPBDMaterialLift,
        physxPBDMaterialParticleAdhesionScale,
        physxPBDMaterialParticleFrictionScale,
        physxPBDMaterialSurfaceTension,
        physxPBDMaterialViscosity,
        physxPBDMaterialVorticityConfinement,
        physxPhysicsDistanceJointSpringDamping,
        physxPhysicsDistanceJointSpringEnabled,
        physxPhysicsDistanceJointSpringStiffness,
        physxResidualReportingMaxResidualPositionIteration,
        physxResidualReportingMaxResidualVelocityIteration,
        physxResidualReportingRmsResidualPositionIteration,
        physxResidualReportingRmsResidualVelocityIteration,
        physxRigidBodyAngularDamping,
        physxRigidBodyCfmScale,
        physxRigidBodyContactSlopCoefficient,
        physxRigidBodyDisableGravity,
        physxRigidBodyEnableCCD,
        physxRigidBodyEnableGyroscopicForces,
        physxRigidBodyEnableSpeculativeCCD,
        physxRigidBodyLinearDamping,
        physxRigidBodyLockedPosAxis,
        physxRigidBodyLockedRotAxis,
        physxRigidBodyMaxAngularVelocity,
        physxRigidBodyMaxContactImpulse,
        physxRigidBodyMaxDepenetrationVelocity,
        physxRigidBodyMaxLinearVelocity,
        physxRigidBodyRetainAccelerations,
        physxRigidBodySleepThreshold,
        physxRigidBodySolveContact,
        physxRigidBodySolverPositionIterationCount,
        physxRigidBodySolverVelocityIterationCount,
        physxRigidBodyStabilizationThreshold,
        physxSceneBounceThreshold,
        physxSceneBroadphaseType,
        physxSceneCollisionSystem,
        physxSceneEnableCCD,
        physxSceneEnableEnhancedDeterminism,
        physxSceneEnableExternalForcesEveryIteration,
        physxSceneEnableGPUDynamics,
        physxSceneEnableResidualReporting,
        physxSceneEnableSceneQuerySupport,
        physxSceneEnableStabilization,
        physxSceneFrictionCorrelationDistance,
        physxSceneFrictionOffsetThreshold,
        physxSceneFrictionType,
        physxSceneGpuCollisionStackSize,
        physxSceneGpuFoundLostAggregatePairsCapacity,
        physxSceneGpuFoundLostPairsCapacity,
        physxSceneGpuHeapCapacity,
        physxSceneGpuMaxDeformableSurfaceContacts,
        physxSceneGpuMaxNumPartitions,
        physxSceneGpuMaxParticleContacts,
        physxSceneGpuMaxRigidContactCount,
        physxSceneGpuMaxRigidPatchCount,
        physxSceneGpuMaxSoftBodyContacts,
        physxSceneGpuTempBufferCapacity,
        physxSceneGpuTotalAggregatePairsCapacity,
        physxSceneInvertCollisionGroupFilter,
        physxSceneMaxBiasCoefficient,
        physxSceneMaxPositionIterationCount,
        physxSceneMaxVelocityIterationCount,
        physxSceneMinPositionIterationCount,
        physxSceneMinVelocityIterationCount,
        physxSceneQuasistaticEnableQuasistatic,
        physxSceneReportKinematicKinematicPairs,
        physxSceneReportKinematicStaticPairs,
        physxSceneSolverType,
        physxSceneTimeStepsPerSecond,
        physxSceneUpdateType,
        physxSDFMeshCollisionSdfBitsPerSubgridPixel,
        physxSDFMeshCollisionSdfEnableRemeshing,
        physxSDFMeshCollisionSdfMargin,
        physxSDFMeshCollisionSdfNarrowBandThickness,
        physxSDFMeshCollisionSdfResolution,
        physxSDFMeshCollisionSdfSubgridResolution,
        physxSDFMeshCollisionSdfTriangleCountReductionFactor,
        physxSphereFillCollisionFillMode,
        physxSphereFillCollisionMaxSpheres,
        physxSphereFillCollisionSeedCount,
        physxSphereFillCollisionVoxelResolution,
        physxSurfaceVelocitySurfaceAngularVelocity,
        physxSurfaceVelocitySurfaceVelocity,
        physxSurfaceVelocitySurfaceVelocityEnabled,
        physxSurfaceVelocitySurfaceVelocityLocalSpace,
        physxTendon,
        physxTendon_MultipleApplyTemplate_Damping,
        physxTendon_MultipleApplyTemplate_ForceCoefficient,
        physxTendon_MultipleApplyTemplate_Gearing,
        physxTendon_MultipleApplyTemplate_JointAxis,
        physxTendon_MultipleApplyTemplate_LimitStiffness,
        physxTendon_MultipleApplyTemplate_LocalPos,
        physxTendon_MultipleApplyTemplate_LowerLimit,
        physxTendon_MultipleApplyTemplate_Offset,
        physxTendon_MultipleApplyTemplate_ParentAttachment,
        physxTendon_MultipleApplyTemplate_ParentLink,
        physxTendon_MultipleApplyTemplate_RestLength,
        physxTendon_MultipleApplyTemplate_Stiffness,
        physxTendon_MultipleApplyTemplate_TendonEnabled,
        physxTendon_MultipleApplyTemplate_UpperLimit,
        physxTriangleMeshCollisionWeldTolerance,
        physxTriangleMeshSimplificationCollisionMetric,
        physxTriangleMeshSimplificationCollisionWeldTolerance,
        physxTriggerEnterScriptType,
        physxTriggerLeaveScriptType,
        physxTriggerOnEnterScript,
        physxTriggerOnLeaveScript,
        physxTriggerTriggeredCollisions,
        physxVehicleAckermannSteeringMaxSteerAngle,
        physxVehicleAckermannSteeringStrength,
        physxVehicleAckermannSteeringTrackWidth,
        physxVehicleAckermannSteeringWheel0,
        physxVehicleAckermannSteeringWheel1,
        physxVehicleAckermannSteeringWheelBase,
        physxVehicleAutoGearBoxDownRatios,
        physxVehicleAutoGearBoxLatency,
        physxVehicleAutoGearBoxUpRatios,
        physxVehicleBrakes,
        physxVehicleBrakes_MultipleApplyTemplate_MaxBrakeTorque,
        physxVehicleBrakes_MultipleApplyTemplate_TorqueMultipliers,
        physxVehicleBrakes_MultipleApplyTemplate_Wheels,
        physxVehicleClutchStrength,
        physxVehicleContextForwardAxis,
        physxVehicleContextLongitudinalAxis,
        physxVehicleContextUpAxis,
        physxVehicleContextUpdateMode,
        physxVehicleContextVerticalAxis,
        physxVehicleControllerAccelerator,
        physxVehicleControllerBrake,
        physxVehicleControllerBrake0,
        physxVehicleControllerBrake1,
        physxVehicleControllerHandbrake,
        physxVehicleControllerSteer,
        physxVehicleControllerSteerLeft,
        physxVehicleControllerSteerRight,
        physxVehicleControllerTargetGear,
        physxVehicleDrive,
        physxVehicleDriveBasicPeakTorque,
        physxVehicleDriveStandardAutoGearBox,
        physxVehicleDriveStandardClutch,
        physxVehicleDriveStandardEngine,
        physxVehicleDriveStandardGears,
        physxVehicleEngineDampingRateFullThrottle,
        physxVehicleEngineDampingRateZeroThrottleClutchDisengaged,
        physxVehicleEngineDampingRateZeroThrottleClutchEngaged,
        physxVehicleEngineIdleRotationSpeed,
        physxVehicleEngineMaxRotationSpeed,
        physxVehicleEngineMoi,
        physxVehicleEnginePeakTorque,
        physxVehicleEngineTorqueCurve,
        physxVehicleGearsRatios,
        physxVehicleGearsRatioScale,
        physxVehicleGearsSwitchTime,
        physxVehicleHighForwardSpeedSubStepCount,
        physxVehicleLateralStickyTireDamping,
        physxVehicleLateralStickyTireThresholdSpeed,
        physxVehicleLateralStickyTireThresholdTime,
        physxVehicleLimitSuspensionExpansionVelocity,
        physxVehicleLongitudinalStickyTireDamping,
        physxVehicleLongitudinalStickyTireThresholdSpeed,
        physxVehicleLongitudinalStickyTireThresholdTime,
        physxVehicleLowForwardSpeedSubStepCount,
        physxVehicleMinActiveLongitudinalSlipDenominator,
        physxVehicleMinLateralSlipDenominator,
        physxVehicleMinLongitudinalSlipDenominator,
        physxVehicleMinPassiveLongitudinalSlipDenominator,
        physxVehicleMultiWheelDifferentialAverageWheelSpeedRatios,
        physxVehicleMultiWheelDifferentialTorqueRatios,
        physxVehicleMultiWheelDifferentialWheels,
        physxVehicleNCR,
        physxVehicleNCR_MultipleApplyTemplate_CommandValues,
        physxVehicleNCR_MultipleApplyTemplate_SpeedResponses,
        physxVehicleNCR_MultipleApplyTemplate_SpeedResponsesPerCommandValue,
        physxVehicleSteeringAngleMultipliers,
        physxVehicleSteeringMaxSteerAngle,
        physxVehicleSteeringWheels,
        physxVehicleSubStepThresholdLongitudinalSpeed,
        physxVehicleSuspensionCamberAtMaxCompression,
        physxVehicleSuspensionCamberAtMaxDroop,
        physxVehicleSuspensionCamberAtRest,
        physxVehicleSuspensionComplianceSuspensionForceAppPoint,
        physxVehicleSuspensionComplianceTireForceAppPoint,
        physxVehicleSuspensionComplianceWheelCamberAngle,
        physxVehicleSuspensionComplianceWheelToeAngle,
        physxVehicleSuspensionLineQueryType,
        physxVehicleSuspensionMaxCompression,
        physxVehicleSuspensionMaxDroop,
        physxVehicleSuspensionSpringDamperRate,
        physxVehicleSuspensionSpringStrength,
        physxVehicleSuspensionSprungMass,
        physxVehicleSuspensionTravelDistance,
        physxVehicleTankControllerThrust0,
        physxVehicleTankControllerThrust1,
        physxVehicleTankDifferentialNumberOfWheelsPerTrack,
        physxVehicleTankDifferentialThrustIndexPerTrack,
        physxVehicleTankDifferentialTrackToWheelIndices,
        physxVehicleTankDifferentialWheelIndicesInTrackOrder,
        physxVehicleTireCamberStiffness,
        physxVehicleTireCamberStiffnessPerUnitGravity,
        physxVehicleTireFrictionTable,
        physxVehicleTireFrictionVsSlipGraph,
        physxVehicleTireLateralStiffnessGraph,
        physxVehicleTireLatStiffX,
        physxVehicleTireLatStiffY,
        physxVehicleTireLongitudinalStiffness,
        physxVehicleTireLongitudinalStiffnessPerUnitGravity,
        physxVehicleTireRestLoad,
        physxVehicleVehicleEnabled,
        physxVehicleWheelAttachmentCollisionGroup,
        physxVehicleWheelAttachmentDriven,
        physxVehicleWheelAttachmentIndex,
        physxVehicleWheelAttachmentSuspension,
        physxVehicleWheelAttachmentSuspensionForceAppPointOffset,
        physxVehicleWheelAttachmentSuspensionFrameOrientation,
        physxVehicleWheelAttachmentSuspensionFramePosition,
        physxVehicleWheelAttachmentSuspensionTravelDirection,
        physxVehicleWheelAttachmentTire,
        physxVehicleWheelAttachmentTireForceAppPointOffset,
        physxVehicleWheelAttachmentWheel,
        physxVehicleWheelAttachmentWheelCenterOfMassOffset,
        physxVehicleWheelAttachmentWheelFrameOrientation,
        physxVehicleWheelAttachmentWheelFramePosition,
        physxVehicleWheelControllerBrakeTorque,
        physxVehicleWheelControllerDriveTorque,
        physxVehicleWheelControllerSteerAngle,
        physxVehicleWheelDampingRate,
        physxVehicleWheelMass,
        physxVehicleWheelMaxBrakeTorque,
        physxVehicleWheelMaxHandBrakeTorque,
        physxVehicleWheelMaxSteerAngle,
        physxVehicleWheelMoi,
        physxVehicleWheelRadius,
        physxVehicleWheelToeAngle,
        physxVehicleWheelWidth,
        points0,
        points1,
        posX,
        posY,
        posZ,
        preventClimbing,
        preventClimbingForceSliding,
        quasistaticactors,
        raycast,
        referenceFrameIsCenterOfMass,
        restOffset,
        rotX,
        rotY,
        rotZ,
        SAP,
        SAT,
        scriptFile,
        sdf,
        simulationOwner,
        solidRestOffset,
        solverPositionIterationCount,
        sphereFill,
        state,
        state_MultipleApplyTemplate_PhysicsPosition,
        state_MultipleApplyTemplate_PhysicsVelocity,
        steer,
        surface,
        sweep,
        Synchronous,
        TGS,
        transX,
        transY,
        transZ,
        triangleMesh,
        undefined,
        velocityChange,
        Vertices,
        wind,
        X,
        Y,
        Z,
        PhysicsJointStateAPI,
        PhysxArticulationAPI,
        PhysxAutoAttachmentAPI,
        PhysxAutoParticleClothAPI,
        PhysxCameraAPI,
        PhysxCameraDroneAPI,
        PhysxCameraFollowAPI,
        PhysxCameraFollowLookAPI,
        PhysxCameraFollowVelocityAPI,
        PhysxCharacterControllerAPI,
        PhysxCollisionAPI,
        PhysxContactReportAPI,
        PhysxConvexDecompositionCollisionAPI,
        PhysxConvexHullCollisionAPI,
        PhysxCookedDataAPI,
        PhysxDeformableAPI,
        PhysxDeformableBodyAPI,
        PhysxDeformableBodyMaterialAPI,
        PhysxDeformableSurfaceAPI,
        PhysxDeformableSurfaceMaterialAPI,
        PhysxDiffuseParticlesAPI,
        PhysxForceAPI,
        PhysxJointAPI,
        PhysxLimitAPI,
        PhysxMaterialAPI,
        PhysxMeshMergeCollisionAPI,
        PhysxMimicJointAPI,
        PhysxParticleAnisotropyAPI,
        PhysxParticleAPI,
        PhysxParticleClothAPI,
        PhysxParticleIsosurfaceAPI,
        PhysxParticleSamplingAPI,
        PhysxParticleSetAPI,
        PhysxParticleSmoothingAPI,
        PhysxParticleSystem,
        PhysxPBDMaterialAPI,
        PhysxPhysicsAttachment,
        PhysxPhysicsDistanceJointAPI,
        PhysxPhysicsGearJoint,
        PhysxPhysicsInstancer,
        PhysxPhysicsJointInstancer,
        PhysxPhysicsRackAndPinionJoint,
        PhysxResidualReportingAPI,
        PhysxRigidBodyAPI,
        PhysxSceneAPI,
        PhysxSceneQuasistaticAPI,
        PhysxSDFMeshCollisionAPI,
        PhysxSphereFillCollisionAPI,
        PhysxSurfaceVelocityAPI,
        PhysxTendonAttachmentAPI,
        PhysxTendonAttachmentLeafAPI,
        PhysxTendonAttachmentRootAPI,
        PhysxTendonAxisAPI,
        PhysxTendonAxisRootAPI,
        PhysxTriangleMeshCollisionAPI,
        PhysxTriangleMeshSimplificationCollisionAPI,
        PhysxTriggerAPI,
        PhysxTriggerStateAPI,
        PhysxVehicleAckermannSteeringAPI,
        PhysxVehicleAPI,
        PhysxVehicleAutoGearBoxAPI,
        PhysxVehicleBrakesAPI,
        PhysxVehicleClutchAPI,
        PhysxVehicleContextAPI,
        PhysxVehicleControllerAPI,
        PhysxVehicleDriveBasicAPI,
        PhysxVehicleDriveStandardAPI,
        PhysxVehicleEngineAPI,
        PhysxVehicleGearsAPI,
        PhysxVehicleMultiWheelDifferentialAPI,
        PhysxVehicleNonlinearCommandResponseAPI,
        PhysxVehicleSteeringAPI,
        PhysxVehicleSuspensionAPI,
        PhysxVehicleSuspensionComplianceAPI,
        PhysxVehicleTankControllerAPI,
        PhysxVehicleTankDifferentialAPI,
        PhysxVehicleTireAPI,
        PhysxVehicleTireFrictionTable,
        PhysxVehicleWheelAPI,
        PhysxVehicleWheelAttachmentAPI,
        PhysxVehicleWheelControllerAPI,
        TetrahedralMesh
    })
{
}

TfStaticData<PhysxSchemaTokensType> PhysxSchemaTokens;

PXR_NAMESPACE_CLOSE_SCOPE
