//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#include ".//physxMaterialAPI.h"
#include "pxr/usd/usd/schemaRegistry.h"
#include "pxr/usd/usd/typed.h"

#include "pxr/usd/sdf/types.h"
#include "pxr/usd/sdf/assetPath.h"

PXR_NAMESPACE_OPEN_SCOPE

// Register the schema with the TfType system.
TF_REGISTRY_FUNCTION(TfType)
{
    TfType::Define<PhysxSchemaPhysxMaterialAPI,
        TfType::Bases< UsdAPISchemaBase > >();
    
}

/* virtual */
PhysxSchemaPhysxMaterialAPI::~PhysxSchemaPhysxMaterialAPI()
{
}

/* static */
PhysxSchemaPhysxMaterialAPI
PhysxSchemaPhysxMaterialAPI::Get(const UsdStagePtr &stage, const SdfPath &path)
{
    if (!stage) {
        TF_CODING_ERROR("Invalid stage");
        return PhysxSchemaPhysxMaterialAPI();
    }
    return PhysxSchemaPhysxMaterialAPI(stage->GetPrimAtPath(path));
}


/* virtual */
UsdSchemaKind PhysxSchemaPhysxMaterialAPI::_GetSchemaKind() const
{
    return PhysxSchemaPhysxMaterialAPI::schemaKind;
}

/* static */
bool
PhysxSchemaPhysxMaterialAPI::CanApply(
    const UsdPrim &prim, std::string *whyNot)
{
    return prim.CanApplyAPI<PhysxSchemaPhysxMaterialAPI>(whyNot);
}

/* static */
PhysxSchemaPhysxMaterialAPI
PhysxSchemaPhysxMaterialAPI::Apply(const UsdPrim &prim)
{
    if (prim.ApplyAPI<PhysxSchemaPhysxMaterialAPI>()) {
        return PhysxSchemaPhysxMaterialAPI(prim);
    }
    return PhysxSchemaPhysxMaterialAPI();
}

/* static */
const TfType &
PhysxSchemaPhysxMaterialAPI::_GetStaticTfType()
{
    static TfType tfType = TfType::Find<PhysxSchemaPhysxMaterialAPI>();
    return tfType;
}

/* static */
bool 
PhysxSchemaPhysxMaterialAPI::_IsTypedSchema()
{
    static bool isTyped = _GetStaticTfType().IsA<UsdTyped>();
    return isTyped;
}

/* virtual */
const TfType &
PhysxSchemaPhysxMaterialAPI::_GetTfType() const
{
    return _GetStaticTfType();
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::GetFrictionCombineModeAttr() const
{
    return GetPrim().GetAttribute(PhysxSchemaTokens->physxMaterialFrictionCombineMode);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::CreateFrictionCombineModeAttr(VtValue const &defaultValue, bool writeSparsely) const
{
    return UsdSchemaBase::_CreateAttr(PhysxSchemaTokens->physxMaterialFrictionCombineMode,
                       SdfValueTypeNames->Token,
                       /* custom = */ false,
                       SdfVariabilityUniform,
                       defaultValue,
                       writeSparsely);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::GetRestitutionCombineModeAttr() const
{
    return GetPrim().GetAttribute(PhysxSchemaTokens->physxMaterialRestitutionCombineMode);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::CreateRestitutionCombineModeAttr(VtValue const &defaultValue, bool writeSparsely) const
{
    return UsdSchemaBase::_CreateAttr(PhysxSchemaTokens->physxMaterialRestitutionCombineMode,
                       SdfValueTypeNames->Token,
                       /* custom = */ false,
                       SdfVariabilityUniform,
                       defaultValue,
                       writeSparsely);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::GetDampingCombineModeAttr() const
{
    return GetPrim().GetAttribute(PhysxSchemaTokens->physxMaterialDampingCombineMode);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::CreateDampingCombineModeAttr(VtValue const &defaultValue, bool writeSparsely) const
{
    return UsdSchemaBase::_CreateAttr(PhysxSchemaTokens->physxMaterialDampingCombineMode,
                       SdfValueTypeNames->Token,
                       /* custom = */ false,
                       SdfVariabilityUniform,
                       defaultValue,
                       writeSparsely);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::GetCompliantContactAccelerationSpringAttr() const
{
    return GetPrim().GetAttribute(PhysxSchemaTokens->physxMaterialCompliantContactAccelerationSpring);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::CreateCompliantContactAccelerationSpringAttr(VtValue const &defaultValue, bool writeSparsely) const
{
    return UsdSchemaBase::_CreateAttr(PhysxSchemaTokens->physxMaterialCompliantContactAccelerationSpring,
                       SdfValueTypeNames->Bool,
                       /* custom = */ false,
                       SdfVariabilityVarying,
                       defaultValue,
                       writeSparsely);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::GetCompliantContactStiffnessAttr() const
{
    return GetPrim().GetAttribute(PhysxSchemaTokens->physxMaterialCompliantContactStiffness);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::CreateCompliantContactStiffnessAttr(VtValue const &defaultValue, bool writeSparsely) const
{
    return UsdSchemaBase::_CreateAttr(PhysxSchemaTokens->physxMaterialCompliantContactStiffness,
                       SdfValueTypeNames->Float,
                       /* custom = */ false,
                       SdfVariabilityVarying,
                       defaultValue,
                       writeSparsely);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::GetCompliantContactDampingAttr() const
{
    return GetPrim().GetAttribute(PhysxSchemaTokens->physxMaterialCompliantContactDamping);
}

UsdAttribute
PhysxSchemaPhysxMaterialAPI::CreateCompliantContactDampingAttr(VtValue const &defaultValue, bool writeSparsely) const
{
    return UsdSchemaBase::_CreateAttr(PhysxSchemaTokens->physxMaterialCompliantContactDamping,
                       SdfValueTypeNames->Float,
                       /* custom = */ false,
                       SdfVariabilityVarying,
                       defaultValue,
                       writeSparsely);
}

namespace {
static inline TfTokenVector
_ConcatenateAttributeNames(const TfTokenVector& left,const TfTokenVector& right)
{
    TfTokenVector result;
    result.reserve(left.size() + right.size());
    result.insert(result.end(), left.begin(), left.end());
    result.insert(result.end(), right.begin(), right.end());
    return result;
}
}

/*static*/
const TfTokenVector&
PhysxSchemaPhysxMaterialAPI::GetSchemaAttributeNames(bool includeInherited)
{
    static TfTokenVector localNames = {
        PhysxSchemaTokens->physxMaterialFrictionCombineMode,
        PhysxSchemaTokens->physxMaterialRestitutionCombineMode,
        PhysxSchemaTokens->physxMaterialDampingCombineMode,
        PhysxSchemaTokens->physxMaterialCompliantContactAccelerationSpring,
        PhysxSchemaTokens->physxMaterialCompliantContactStiffness,
        PhysxSchemaTokens->physxMaterialCompliantContactDamping,
    };
    static TfTokenVector allNames =
        _ConcatenateAttributeNames(
            UsdAPISchemaBase::GetSchemaAttributeNames(true),
            localNames);

    if (includeInherited)
        return allNames;
    else
        return localNames;
}

PXR_NAMESPACE_CLOSE_SCOPE

// ===================================================================== //
// Feel free to add custom code below this line. It will be preserved by
// the code generator.
//
// Just remember to wrap code in the appropriate delimiters:
// 'PXR_NAMESPACE_OPEN_SCOPE', 'PXR_NAMESPACE_CLOSE_SCOPE'.
// ===================================================================== //
// --(BEGIN CUSTOM CODE)--
