# Contributing to PhysX

## Did you find a bug?

* Check in the GitHub [Issues](https://github.com/NVIDIA-Omniverse/PhysX/issues) if a report for your bug already exists.
* If the bug has not been reported yet, open a new Issue.
* Use a short and descriptive title which contains relevant keywords.
* Write a clear description of the bug.
* Document the environment including your operating system, compiler version, and hardware specifications.
* Add code samples and executable test cases with instructions for reproducing the bug.

## Did you find an issue in the documentation?

* Please create an [Issue](https://github.com/NVIDIA-Omniverse/PhysX/issues/) if you find a documentation issue.

## Did you write a bug fix?

* Open a new [Pull Request](https://github.com/NVIDIA-Omniverse/PhysX/pulls) with your bug fix.
* Write a description of the bug which is fixed by your patch or link to related Issues.
* If your patch fixes for example Issue #33, write `Fixes #33`.
* Explain your solution with a few words.

## Did you write a cosmetic patch?

* Patches that are purely cosmetic will not be considered and associated Pull Requests will be closed.
* Cosmetic are patches which do not improve stability, performance, functionality, etc.
* Examples for cosmetic patches: code formatting, fixing whitespaces.

## Signing your work

* We require that all contributors "sign-off" on their commits. This certifies that the contribution is your original work, or you have rights to submit it under the same license, or a compatible license.

* Any contribution which contains commits that are not Signed-Off will not be accepted.

* To sign off on a commit you simply use the `--signoff` (or `-s`) option when committing your changes:
  ```bash
  $ git commit -s -m "Add cool feature."
  ```
  This will append the following to your commit message:
  ```
  Signed-off-by: Your Name <your@email.com>
  ```

* Full text of the DCO:

  ```
    Developer Certificate of Origin
    Version 1.1
    
    Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
    1 Letterman Drive
    Suite D4700
    San Francisco, CA, 94129
    
    Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.
  ```

  ```
    Developer's Certificate of Origin 1.1
    
    By making a contribution to this project, I certify that:
    
    (a) The contribution was created in whole or in part by me and I have the right to submit it under the open source license indicated in the file; or
    
    (b) The contribution is based upon previous work that, to the best of my knowledge, is covered under an appropriate open source license and I have the right under that license to submit that work with modifications, whether created in whole or in part by me, under the same open source license (unless I am permitted to submit under a different license), as indicated in the file; or
    
    (c) The contribution was provided directly to me by some other person who certified (a), (b) or (c) and I have not modified it.
    
    (d) I understand and agree that this project and the contribution are public and that a record of the contribution (including all personal information I submit with it, including my sign-off) is maintained indefinitely and may be redistributed consistent with this project or the open source license(s) involved.
  ```

## Do you have a question?

* Search the GitHub [Discussions](https://github.com/NVIDIA-Omniverse/PhysX/discussions/) for your question.
* If nobody asked your question before, feel free to open a new discussion.
* Once somebody shares a satisfying answer to your question, click "Mark as answer".
* GitHub Issues should only be used for bug reports. 
* If you open an Issue with a question, we may convert it into a discussion.
* You can also ask in the NVIDIA Omniverse #physics Discord Channel. Get an invite here: [https://discord.com/invite/XWQNJDNuaC](https://discord.com/invite/XWQNJDNuaC).
