# 目标：将纯文本内容转化为结构化的 Markdown 文本

## 输入：
*   待处理内容： [请在此处粘贴或描述你想要转换的纯文本内容。]
*   内容描述（可选但推荐）： [请在此处简要说明文本的主题、类型或大致结构，例如：一篇博客文章草稿、会议记录、学习笔记、代码片段说明等。这有助于更好地推断结构。]

## 核心任务与要求：
请对提供的纯文本内容执行以下操作，最终输出单一、完整的 Markdown (.md) 格式文本。

1.  智能结构识别与推断：
    *   分析文本模式： 基于文本的布局（如空行、缩进、行首特殊字符、文本长度、大写字母使用等）和内容上下文，自动推断文档的逻辑结构。
    *   识别标题： 查找可能的标题行（通常较短、独立成行、或有明显强调），并使用 `#`、`##`、`###` 等标准 Markdown 语法表示各级标题。尝试推断合理的层级关系。
    *   识别列表： 自动检测以数字、字母、星号 (`*`)、破折号 (`-`) 或其他项目符号开头的行，并将它们转换为有序 (`1. Item`) 或无序 (`* Item` 或 `- Item`) 的 Markdown 列表。注意保留嵌套列表的结构（通过缩进判断）。
    *   识别段落： 将连续的文本行视为段落，并使用 Markdown 的段落规则（通常通过一个空行分隔）进行格式化。
    *   识别代码块： 检测通过缩进或特定标记（如 ```）指示的代码段落，并使用 Markdown 代码块语法（```语言类型 ... ``` 或 四个空格缩进）进行格式化。
    *   识别引用块： 检测以 `>` 或类似标记开头的行，并将其转换为 Markdown 引用块 (`> text`)。
    *   识别水平分割线： 检测由 `---`, `*`, `___` 等组成的行，并将其转换为 Markdown 水平分割线 (`---`)。

2.  内容格式化与清理：
    *   保留逻辑空行： 在推断出的段落、列表项、标题之间保留必要的空行，确保 Markdown 渲染后的可读性。
    *   移除冗余空白： 清理文本中不必要的空格（如行首/行尾空格）和过多的连续空行（保留结构所需的空行）。
    *   文本强调（尝试性）： 如果文本中有明显用于强调的标记（如 `*单词*` 或 `_单词_`），尝试将其转换为 Markdown 的斜体 (`*单词*` 或 `_单词_`) 或粗体 (`单词` 或 `__单词__`)。此项需谨慎，避免过度转换。
    *   统一符号： 将所有符号统一为中文标准符号。
    

3.  保持内容完整性：
    *   确保原始文本中的所有重要内容都被转换并包含在最终的 Markdown 输出中。
    *   对于无法明确判断格式的文本块，优先保留其原始文本内容，并尽可能按段落处理。

4.  处理不确定性：
    *   如果文本结构非常模糊或存在多种可能的解释，请采用最常见或看似最合理的 Markdown 结构。
    *   如果某部分内容无法可靠地转换为特定 Markdown 结构（如复杂的 ASCII 图表），可以将其放入代码块中以保留原始格式，或者在旁边添加注释说明。

5.  文本预处理与修正：
    *   错别字修正： 在进行结构分析之前，首先对文本内容进行识别并自动修正常见的中文错别字。修正时应考虑上下文，确保语义的准确性。

## 输出格式：
*   单一 Markdown 文本： 将处理完成的所有内容，严格按照 Markdown 语法，整合到一个 `.md` 格式的文本框中输出。确保格式干净、结构清晰、内容完整。

---

请确认收到纯文本内容和可选的描述后，开始处理。
